{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The @PangoGlyphGeometry@ structure contains width and positioning
-- information for a single glyph.
-- 
-- Note that /@width@/ is not guaranteed to be the same as the glyph
-- extents. Kerning and other positioning applied during shaping will
-- affect both the /@width@/ and the /@xOffset@/ for the glyphs in the
-- glyph string that results from shaping.
-- 
-- The information in this struct is intended for rendering the glyphs,
-- as follows:
-- 
-- 1. Assume the current point is (x, y)
-- 
-- 2. Render the current glyph at (x + x_offset, y + y_offset),
-- 
-- 3. Advance the current point to (x + width, y)
-- 
-- 4. Render the next glyph
-- 
-- 

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Pango.Structs.GlyphGeometry
    ( 

-- * Exported types
    GlyphGeometry(..)                       ,
    newZeroGlyphGeometry                    ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveGlyphGeometryMethod              ,
#endif



 -- * Properties


-- ** width #attr:width#
-- | the logical width to use for the the character.

    getGlyphGeometryWidth                   ,
#if defined(ENABLE_OVERLOADING)
    glyphGeometry_width                     ,
#endif
    setGlyphGeometryWidth                   ,


-- ** xOffset #attr:xOffset#
-- | horizontal offset from nominal character position.

    getGlyphGeometryXOffset                 ,
#if defined(ENABLE_OVERLOADING)
    glyphGeometry_xOffset                   ,
#endif
    setGlyphGeometryXOffset                 ,


-- ** yOffset #attr:yOffset#
-- | vertical offset from nominal character position.

    getGlyphGeometryYOffset                 ,
#if defined(ENABLE_OVERLOADING)
    glyphGeometry_yOffset                   ,
#endif
    setGlyphGeometryYOffset                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype GlyphGeometry = GlyphGeometry (SP.ManagedPtr GlyphGeometry)
    deriving (Eq)

instance SP.ManagedPtrNewtype GlyphGeometry where
    toManagedPtr (GlyphGeometry p) = p

instance BoxedPtr GlyphGeometry where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 12 >=> B.ManagedPtr.wrapPtr GlyphGeometry)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr GlyphGeometry where
    boxedPtrCalloc = callocBytes 12


-- | Construct a t'GlyphGeometry' struct initialized to zero.
newZeroGlyphGeometry :: MonadIO m => m GlyphGeometry
newZeroGlyphGeometry = liftIO $ boxedPtrCalloc >>= wrapPtr GlyphGeometry

instance tag ~ 'AttrSet => Constructible GlyphGeometry tag where
    new _ attrs = do
        o <- newZeroGlyphGeometry
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphGeometry #width
-- @
getGlyphGeometryWidth :: MonadIO m => GlyphGeometry -> m Int32
getGlyphGeometryWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphGeometry [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphGeometryWidth :: MonadIO m => GlyphGeometry -> Int32 -> m ()
setGlyphGeometryWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphGeometryWidthFieldInfo
instance AttrInfo GlyphGeometryWidthFieldInfo where
    type AttrBaseTypeConstraint GlyphGeometryWidthFieldInfo = (~) GlyphGeometry
    type AttrAllowedOps GlyphGeometryWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphGeometryWidthFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphGeometryWidthFieldInfo = (~)Int32
    type AttrTransferType GlyphGeometryWidthFieldInfo = Int32
    type AttrGetType GlyphGeometryWidthFieldInfo = Int32
    type AttrLabel GlyphGeometryWidthFieldInfo = "width"
    type AttrOrigin GlyphGeometryWidthFieldInfo = GlyphGeometry
    attrGet = getGlyphGeometryWidth
    attrSet = setGlyphGeometryWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphGeometry.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphGeometry.html#g:attr:width"
        })

glyphGeometry_width :: AttrLabelProxy "width"
glyphGeometry_width = AttrLabelProxy

#endif


-- | Get the value of the “@x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphGeometry #xOffset
-- @
getGlyphGeometryXOffset :: MonadIO m => GlyphGeometry -> m Int32
getGlyphGeometryXOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@x_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphGeometry [ #xOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphGeometryXOffset :: MonadIO m => GlyphGeometry -> Int32 -> m ()
setGlyphGeometryXOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphGeometryXOffsetFieldInfo
instance AttrInfo GlyphGeometryXOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphGeometryXOffsetFieldInfo = (~) GlyphGeometry
    type AttrAllowedOps GlyphGeometryXOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphGeometryXOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphGeometryXOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphGeometryXOffsetFieldInfo = Int32
    type AttrGetType GlyphGeometryXOffsetFieldInfo = Int32
    type AttrLabel GlyphGeometryXOffsetFieldInfo = "x_offset"
    type AttrOrigin GlyphGeometryXOffsetFieldInfo = GlyphGeometry
    attrGet = getGlyphGeometryXOffset
    attrSet = setGlyphGeometryXOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphGeometry.xOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphGeometry.html#g:attr:xOffset"
        })

glyphGeometry_xOffset :: AttrLabelProxy "xOffset"
glyphGeometry_xOffset = AttrLabelProxy

#endif


-- | Get the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' glyphGeometry #yOffset
-- @
getGlyphGeometryYOffset :: MonadIO m => GlyphGeometry -> m Int32
getGlyphGeometryYOffset s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Int32
    return val

-- | Set the value of the “@y_offset@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' glyphGeometry [ #yOffset 'Data.GI.Base.Attributes.:=' value ]
-- @
setGlyphGeometryYOffset :: MonadIO m => GlyphGeometry -> Int32 -> m ()
setGlyphGeometryYOffset s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data GlyphGeometryYOffsetFieldInfo
instance AttrInfo GlyphGeometryYOffsetFieldInfo where
    type AttrBaseTypeConstraint GlyphGeometryYOffsetFieldInfo = (~) GlyphGeometry
    type AttrAllowedOps GlyphGeometryYOffsetFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint GlyphGeometryYOffsetFieldInfo = (~) Int32
    type AttrTransferTypeConstraint GlyphGeometryYOffsetFieldInfo = (~)Int32
    type AttrTransferType GlyphGeometryYOffsetFieldInfo = Int32
    type AttrGetType GlyphGeometryYOffsetFieldInfo = Int32
    type AttrLabel GlyphGeometryYOffsetFieldInfo = "y_offset"
    type AttrOrigin GlyphGeometryYOffsetFieldInfo = GlyphGeometry
    attrGet = getGlyphGeometryYOffset
    attrSet = setGlyphGeometryYOffset
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Pango.Structs.GlyphGeometry.yOffset"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-pango-1.0.30/docs/GI-Pango-Structs-GlyphGeometry.html#g:attr:yOffset"
        })

glyphGeometry_yOffset :: AttrLabelProxy "yOffset"
glyphGeometry_yOffset = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GlyphGeometry
type instance O.AttributeList GlyphGeometry = GlyphGeometryAttributeList
type GlyphGeometryAttributeList = ('[ '("width", GlyphGeometryWidthFieldInfo), '("xOffset", GlyphGeometryXOffsetFieldInfo), '("yOffset", GlyphGeometryYOffsetFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveGlyphGeometryMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGlyphGeometryMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGlyphGeometryMethod t GlyphGeometry, O.OverloadedMethod info GlyphGeometry p) => OL.IsLabel t (GlyphGeometry -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGlyphGeometryMethod t GlyphGeometry, O.OverloadedMethod info GlyphGeometry p, R.HasField t GlyphGeometry p) => R.HasField t GlyphGeometry p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGlyphGeometryMethod t GlyphGeometry, O.OverloadedMethodInfo info GlyphGeometry) => OL.IsLabel t (O.MethodProxy info GlyphGeometry) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


