//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/extensions/http/cache_v2/file_system_http_cache/v3/file_system_http_cache.proto

package file_system_http_cachev3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on FileSystemHttpCacheV2Config with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *FileSystemHttpCacheV2Config) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on FileSystemHttpCacheV2Config with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// FileSystemHttpCacheV2ConfigMultiError, or nil if none found.
func (m *FileSystemHttpCacheV2Config) ValidateAll() error {
	return m.validate(true)
}

func (m *FileSystemHttpCacheV2Config) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetManagerConfig() == nil {
		err := FileSystemHttpCacheV2ConfigValidationError{
			field:  "ManagerConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetManagerConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "ManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "ManagerConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetManagerConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "ManagerConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetCachePath()) < 1 {
		err := FileSystemHttpCacheV2ConfigValidationError{
			field:  "CachePath",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetMaxCacheSizeBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxCacheSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxCacheSizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxCacheSizeBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "MaxCacheSizeBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxIndividualCacheEntrySizeBytes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxIndividualCacheEntrySizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxIndividualCacheEntrySizeBytes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxIndividualCacheEntrySizeBytes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "MaxIndividualCacheEntrySizeBytes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMaxCacheEntryCount()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxCacheEntryCount",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxCacheEntryCount",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxCacheEntryCount()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "MaxCacheEntryCount",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CacheSubdivisions

	// no validation rules for EvictFraction

	if all {
		switch v := interface{}(m.GetMaxEvictionPeriod()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MaxEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMaxEvictionPeriod()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "MaxEvictionPeriod",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetMinEvictionPeriod()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MinEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, FileSystemHttpCacheV2ConfigValidationError{
					field:  "MinEvictionPeriod",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetMinEvictionPeriod()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return FileSystemHttpCacheV2ConfigValidationError{
				field:  "MinEvictionPeriod",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for CreateCachePath

	if len(errors) > 0 {
		return FileSystemHttpCacheV2ConfigMultiError(errors)
	}

	return nil
}

// FileSystemHttpCacheV2ConfigMultiError is an error wrapping multiple
// validation errors returned by FileSystemHttpCacheV2Config.ValidateAll() if
// the designated constraints aren't met.
type FileSystemHttpCacheV2ConfigMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m FileSystemHttpCacheV2ConfigMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m FileSystemHttpCacheV2ConfigMultiError) AllErrors() []error { return m }

// FileSystemHttpCacheV2ConfigValidationError is the validation error returned
// by FileSystemHttpCacheV2Config.Validate if the designated constraints
// aren't met.
type FileSystemHttpCacheV2ConfigValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e FileSystemHttpCacheV2ConfigValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e FileSystemHttpCacheV2ConfigValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e FileSystemHttpCacheV2ConfigValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e FileSystemHttpCacheV2ConfigValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e FileSystemHttpCacheV2ConfigValidationError) ErrorName() string {
	return "FileSystemHttpCacheV2ConfigValidationError"
}

// Error satisfies the builtin error interface
func (e FileSystemHttpCacheV2ConfigValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sFileSystemHttpCacheV2Config.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = FileSystemHttpCacheV2ConfigValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = FileSystemHttpCacheV2ConfigValidationError{}
