
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdualaction_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"

// Argument includes
#include <QString>
#include <kguiitem.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDualAction_Type = nullptr;
static PyTypeObject *Sbk_KDualAction_TypeF(void)
{
    return _Sbk_KDualAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDualActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDualActionWrapper::KDualActionWrapper(::QObject * parent) : KDualAction(parent)
{
}

KDualActionWrapper::KDualActionWrapper(const ::QString & inactiveText, const ::QString & activeText, ::QObject * parent) : KDualAction(inactiveText, activeText, parent)
{
}

void KDualActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDualAction", funcName, gil, pyOverride, event);
}

void KDualActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDualAction", funcName, gil, pyOverride, signal);
}

void KDualActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDualAction", funcName, gil, pyOverride, event);
}

void KDualActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDualAction", funcName, gil, pyOverride, signal);
}

bool KDualActionWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAction::event(arg__1);
    }
    return KXYSelectorWrapper::sbk_o_event("KDualAction", funcName, gil, pyOverride, arg__1);
}

bool KDualActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDualAction", funcName, gil, pyOverride, watched, event);
}

void KDualActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDualAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDualAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KDualActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDualAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDualActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDualAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDualActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDualActionWrapper *>(this));
    }
    return KDualAction::qt_metacast(_clname);
}

KDualActionWrapper::~KDualActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDualAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDualAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDualAction >()))
        return -1;

    KDualActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    if (numArgs == 2)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    if (PyArg_UnpackTuple(args, "KDualAction", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDualAction::KDualAction(QObject*)
    // 1: KDualAction::KDualAction(QString,QString,QObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDualAction(QObject*)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KDualAction(QString,QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KDualAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KDualAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KDualActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KDualActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KDualAction(const QString &inactiveText, const QString &activeText, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KDualAction(QString,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KDualActionWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KDualActionWrapper(cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDualAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDualActionFunc_activeGuiItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeGuiItem()const
        KGuiItem* cppResult = new KGuiItem(const_cast<const ::KDualAction *>(cppSelf)->activeGuiItem());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_activeIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeIcon()const
        QIcon cppResult = const_cast<const ::KDualAction *>(cppSelf)->activeIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_activeText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeText()const
        QString cppResult = const_cast<const ::KDualAction *>(cppSelf)->activeText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_activeToolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // activeToolTip()const
        QString cppResult = const_cast<const ::KDualAction *>(cppSelf)->activeToolTip();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_autoToggle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // autoToggle()const
        bool cppResult = const_cast<const ::KDualAction *>(cppSelf)->autoToggle();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_inactiveGuiItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // inactiveGuiItem()const
        KGuiItem* cppResult = new KGuiItem(const_cast<const ::KDualAction *>(cppSelf)->inactiveGuiItem());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_inactiveIcon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // inactiveIcon()const
        QIcon cppResult = const_cast<const ::KDualAction *>(cppSelf)->inactiveIcon();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_inactiveText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // inactiveText()const
        QString cppResult = const_cast<const ::KDualAction *>(cppSelf)->inactiveText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_inactiveToolTip(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // inactiveToolTip()const
        QString cppResult = const_cast<const ::KDualAction *>(cppSelf)->inactiveToolTip();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isActive()const
        bool cppResult = const_cast<const ::KDualAction *>(cppSelf)->isActive();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDualActionFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActive", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActive(bool)
            cppSelf->setActive(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setActiveGuiItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setActiveGuiItem(KGuiItem)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveGuiItem(KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActiveGuiItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KGuiItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActiveGuiItem(KGuiItem)
            cppSelf->setActiveGuiItem(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setActiveIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setActiveIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setActiveIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActiveIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setActiveIcon(QIcon)
            cppSelf->setActiveIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setActiveText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setActiveText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setActiveText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActiveText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActiveText(QString)
            cppSelf->setActiveText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setActiveToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setActiveToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setActiveToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActiveToolTip", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActiveToolTip(QString)
            cppSelf->setActiveToolTip(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setAutoToggle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setAutoToggle(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoToggle(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setAutoToggle", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAutoToggle(bool)
            cppSelf->setAutoToggle(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setIconForStates(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setIconForStates(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setIconForStates(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIconForStates", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setIconForStates(QIcon)
            cppSelf->setIconForStates(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setInactiveGuiItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setInactiveGuiItem(KGuiItem)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KGuiItem_IDX]), (pyArg)))) {
        overloadId = 0; // setInactiveGuiItem(KGuiItem)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInactiveGuiItem", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KGuiItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setInactiveGuiItem(KGuiItem)
            cppSelf->setInactiveGuiItem(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setInactiveIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setInactiveIcon(QIcon)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArg)))) {
        overloadId = 0; // setInactiveIcon(QIcon)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInactiveIcon", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QIcon cppArg0_local;
        ::QIcon *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setInactiveIcon(QIcon)
            cppSelf->setInactiveIcon(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setInactiveText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setInactiveText(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setInactiveText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInactiveText", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setInactiveText(QString)
            cppSelf->setInactiveText(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDualActionFunc_setInactiveToolTip(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDualAction::setInactiveToolTip(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setInactiveToolTip(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setInactiveToolTip", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setInactiveToolTip(QString)
            cppSelf->setInactiveToolTip(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDualAction_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDualAction_methods[] = {
    {"activeGuiItem", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_activeGuiItem), METH_NOARGS, nullptr},
    {"activeIcon", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_activeIcon), METH_NOARGS, nullptr},
    {"activeText", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_activeText), METH_NOARGS, nullptr},
    {"activeToolTip", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_activeToolTip), METH_NOARGS, nullptr},
    {"autoToggle", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_autoToggle), METH_NOARGS, nullptr},
    {"inactiveGuiItem", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_inactiveGuiItem), METH_NOARGS, nullptr},
    {"inactiveIcon", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_inactiveIcon), METH_NOARGS, nullptr},
    {"inactiveText", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_inactiveText), METH_NOARGS, nullptr},
    {"inactiveToolTip", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_inactiveToolTip), METH_NOARGS, nullptr},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_isActive), METH_NOARGS, nullptr},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setActive), METH_O, nullptr},
    {"setActiveGuiItem", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setActiveGuiItem), METH_O, nullptr},
    {"setActiveIcon", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setActiveIcon), METH_O, nullptr},
    {"setActiveText", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setActiveText), METH_O, nullptr},
    {"setActiveToolTip", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setActiveToolTip), METH_O, nullptr},
    {"setAutoToggle", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setAutoToggle), METH_O, nullptr},
    {"setIconForStates", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setIconForStates), METH_O, nullptr},
    {"setInactiveGuiItem", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setInactiveGuiItem), METH_O, nullptr},
    {"setInactiveIcon", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setInactiveIcon), METH_O, nullptr},
    {"setInactiveText", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setInactiveText), METH_O, nullptr},
    {"setInactiveToolTip", reinterpret_cast<PyCFunction>(Sbk_KDualActionFunc_setInactiveToolTip), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDualAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDualAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDualActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDualAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDualAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDualAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDualAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDualAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDualAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDualAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDualAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDualAction_spec = {
    "1:KWidgetsAddons.KDualAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDualAction_slots
};

} //extern "C"

static void *Sbk_KDualAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDualAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDualAction_PythonToCpp_KDualAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDualAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDualAction_PythonToCpp_KDualAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDualAction_TypeF()))
        return KDualAction_PythonToCpp_KDualAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDualAction_PTR_CppToPython_KDualAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDualAction *>(const_cast<void *>(cppIn)), Sbk_KDualAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDualAction_SignatureStrings[] = {
    "1:KWidgetsAddons.KDualAction(self,parent:PySide6.QtCore.QObject)",
    "0:KWidgetsAddons.KDualAction(self,inactiveText:QString,activeText:QString,parent:PySide6.QtCore.QObject)",
    "KWidgetsAddons.KDualAction.activeGuiItem(self)->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KDualAction.activeIcon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KDualAction.activeText(self)->QString",
    "KWidgetsAddons.KDualAction.activeToolTip(self)->QString",
    "KWidgetsAddons.KDualAction.autoToggle(self)->bool",
    "KWidgetsAddons.KDualAction.inactiveGuiItem(self)->KWidgetsAddons.KGuiItem",
    "KWidgetsAddons.KDualAction.inactiveIcon(self)->PySide6.QtGui.QIcon",
    "KWidgetsAddons.KDualAction.inactiveText(self)->QString",
    "KWidgetsAddons.KDualAction.inactiveToolTip(self)->QString",
    "KWidgetsAddons.KDualAction.isActive(self)->bool",
    "KWidgetsAddons.KDualAction.setActive(self,state:bool)",
    "KWidgetsAddons.KDualAction.setActiveGuiItem(self,arg__1:KWidgetsAddons.KGuiItem)",
    "KWidgetsAddons.KDualAction.setActiveIcon(self,arg__1:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KDualAction.setActiveText(self,arg__1:QString)",
    "KWidgetsAddons.KDualAction.setActiveToolTip(self,arg__1:QString)",
    "KWidgetsAddons.KDualAction.setAutoToggle(self,arg__1:bool)",
    "KWidgetsAddons.KDualAction.setIconForStates(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KDualAction.setInactiveGuiItem(self,arg__1:KWidgetsAddons.KGuiItem)",
    "KWidgetsAddons.KDualAction.setInactiveIcon(self,arg__1:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap])",
    "KWidgetsAddons.KDualAction.setInactiveText(self,arg__1:QString)",
    "KWidgetsAddons.KDualAction.setInactiveToolTip(self,arg__1:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDualAction_SignatureByteSize = 317;
static constexpr uint8_t KDualAction_SignatureBytes[317] = {
    0x78, 0xda, 0xb5, 0x94, 0xc1, 0x4f, 0x83, 0x30, 0x14, 0xc6, 0xef, 0xfe, 0x15, 0x1e, 0x25, 0xc1,
    0xc6, 0x5d, 0x3c, 0x70, 0x30, 0x21, 0x1a, 0x4d, 0xb3, 0x83, 0x23, 0x60, 0x3c, 0x18, 0xb3, 0x74,
    0xf0, 0x24, 0x35, 0xac, 0x25, 0xf4, 0x61, 0xb6, 0xff, 0xde, 0x32, 0x29, 0x22, 0xb2, 0xd1, 0x86,
    0xec, 0x48, 0xdb, 0xdf, 0xf7, 0xfa, 0xbe, 0xaf, 0x8f, 0x45, 0xb0, 0x7c, 0xe5, 0x59, 0x0e, 0xa8,
    0xc2, 0x2c, 0x93, 0x42, 0x91, 0xe5, 0x43, 0xcd, 0x8a, 0x30, 0x45, 0x2e, 0xc5, 0x95, 0x82, 0xe2,
    0xc3, 0x2f, 0x59, 0x05, 0x02, 0x83, 0xd5, 0x3e, 0xe6, 0x19, 0xdc, 0x92, 0x08, 0xef, 0x65, 0x05,
    0x24, 0x7a, 0xde, 0x7c, 0x42, 0x8a, 0xde, 0xc5, 0xcd, 0xa4, 0x00, 0x17, 0x4c, 0x7f, 0x7d, 0x41,
    0x02, 0x3b, 0x0c, 0xa2, 0x18, 0x2b, 0x2e, 0x72, 0x7f, 0x64, 0x69, 0xa2, 0xd0, 0xf1, 0x32, 0xe4,
    0x47, 0xec, 0xa9, 0xe6, 0x14, 0x61, 0x7b, 0x28, 0xea, 0x5d, 0xdf, 0x0d, 0xcf, 0xb7, 0xdb, 0xd3,
    0x3a, 0x34, 0x6d, 0x6f, 0xae, 0x45, 0x7e, 0x2f, 0xa3, 0x71, 0x12, 0x35, 0x5b, 0xd3, 0x02, 0x4d,
    0x57, 0x46, 0xa0, 0x6d, 0xce, 0x02, 0x92, 0xb2, 0x48, 0x78, 0xe9, 0xc2, 0xd5, 0x28, 0x13, 0x99,
    0xe7, 0x05, 0x18, 0x68, 0xa3, 0x35, 0x4e, 0x11, 0x26, 0x89, 0xf9, 0x4e, 0x19, 0xa5, 0x19, 0x5e,
    0xf5, 0x9f, 0x85, 0x43, 0xd7, 0x1d, 0xe6, 0xec, 0x17, 0x57, 0xe1, 0x81, 0xb4, 0x75, 0x4b, 0x01,
    0xf6, 0x00, 0x5f, 0x21, 0x43, 0x08, 0x1a, 0xc8, 0xb3, 0xa2, 0xfa, 0x26, 0xfb, 0xac, 0xca, 0xd7,
    0xeb, 0x45, 0x70, 0xc4, 0x69, 0x3b, 0xc1, 0xce, 0x6b, 0xa3, 0x86, 0xfb, 0x52, 0xb7, 0x4c, 0x5e,
    0x84, 0x3e, 0xf6, 0x36, 0xe2, 0xbe, 0x7f, 0x39, 0x58, 0x5c, 0xf1, 0xdd, 0x96, 0x95, 0xef, 0x76,
    0xe5, 0xba, 0x5c, 0x4c, 0xb9, 0xd6, 0x62, 0x4b, 0xba, 0x17, 0x8f, 0xab, 0xc0, 0xdf, 0x77, 0x6d,
    0x68, 0x1b, 0xe7, 0x9b, 0xae, 0x1f, 0x65, 0x15, 0x37, 0x51, 0xa9, 0xf6, 0xef, 0xa3, 0x97, 0xce,
    0xe6, 0x14, 0x1d, 0x19, 0xa8, 0x99, 0x59, 0xd3, 0xe1, 0x64, 0x9d, 0x3b, 0x6d, 0x3a, 0x9c, 0x43,
    0xc7, 0xb8, 0xe8, 0xc8, 0x40, 0xfe, 0x93, 0xf8, 0x06, 0xf9, 0xa5, 0x54, 0x83
};
#endif

PyTypeObject *init_KDualAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KDualAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]))));

    _Sbk_KDualAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDualAction",
        "KDualAction*",
        &Sbk_KDualAction_spec,
        &Shiboken::callCppDestructor< KDualAction >,
        Sbk_KDualAction_Type_bases.object(),
        0);
    auto *pyType = Sbk_KDualAction_TypeF(); // references _Sbk_KDualAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDualAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDualAction_SignatureBytes, KDualAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDualAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDualAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDualAction_PythonToCpp_KDualAction_PTR,
        is_KDualAction_PythonToCpp_KDualAction_PTR_Convertible,
        KDualAction_PTR_CppToPython_KDualAction);

    Shiboken::Conversions::registerConverterName(converter, "KDualAction");
    Shiboken::Conversions::registerConverterName(converter, "KDualAction*");
    Shiboken::Conversions::registerConverterName(converter, "KDualAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDualAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDualActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDualAction_TypeF(), &Sbk_KDualAction_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KDualAction::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDualAction::staticMetaObject, sizeof(KDualActionWrapper));

    return pyType;
}
