/** \file server/drivers/sed1520fm.h
 * Font definitions for big numbers to be used with SED1520 display.
 *
 * The code in this file was created with Cosmicvoid's Font Editor (CFE) based
 * on the original font by Robin Adams and manually optimized.
 */

/*-
 * Copyright (c) 2001 Robin Adams <robin@adams-online.de>
 *               2011 Markus Dolze <bsdfan@nurfuerspam.de>
 *
 * This file is released under the GNU General Public License. Refer to the
 * COPYING file distributed with this package.
 */

#ifndef SED1520FM_H
#define SED1520FM_H

/* Properties of this font (currently unused) */
#define nr_chrs_NUM 11
#define chr_hgt_NUM 24
#define data_size_NUM 8
#define firstchr_NUM 48

const unsigned char widtbl_NUM[11] =
{
        16, 15, 16, 16, 16, 16, 16, 16, 16, 16, 5
};

/* Column format, LSB top */

const unsigned char chr_NUM_30[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xE0, 0xFF, 0x0F,
        0xF0, 0xFF, 0x1F, 0xF0, 0xFF, 0x1F, 0x78, 0x00, 0x3C,
        0x38, 0x00, 0x38, 0x38, 0x00, 0x38, 0x78, 0x00, 0x3C,
        0xF0, 0xFF, 0x1F, 0xF0, 0xFF, 0x1F, 0xE0, 0xFF, 0x0F,
        0x00, 0xFF, 0x01
};
const unsigned char chr_NUM_31[45] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x1E, 0x00, 0x00, 0x0F, 0x00, 0x80, 0x0F, 0x00,
        0xC0, 0x07, 0x00, 0xE0, 0x03, 0x00, 0xF0, 0xFF, 0x3F,
        0xF8, 0xFF, 0x3F, 0xF8, 0xFF, 0x3F, 0xF8, 0xFF, 0x3F
};
const unsigned char chr_NUM_32[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x00, 0x3C,
        0xF0, 0x01, 0x3F, 0xF0, 0x81, 0x3F, 0x78, 0xC0, 0x3F,
        0x38, 0xE0, 0x3F, 0x38, 0xF0, 0x3C, 0x38, 0x78, 0x3C,
        0xF8, 0x7F, 0x3C, 0xF0, 0x3F, 0x3C, 0xF0, 0x0F, 0x3C,
        0xC0, 0x07, 0x3C
};
const unsigned char chr_NUM_33[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0xC0, 0x00, 0x03, 0xF0, 0x00, 0x0F,
        0xF0, 0x00, 0x1F, 0xF8, 0x00, 0x3F, 0x38, 0x00, 0x3C,
        0x38, 0x1C, 0x38, 0x38, 0x1E, 0x38, 0xF8, 0x3F, 0x3C,
        0xF0, 0xF7, 0x1F, 0xF0, 0xF7, 0x1F, 0xC0, 0xE1, 0x0F,
        0x00, 0xC0, 0x03
};
const unsigned char chr_NUM_34[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0xC0, 0x03, 0x00, 0xE0, 0x03, 0x00, 0xF8, 0x03,
        0x00, 0xBE, 0x03, 0x00, 0x9F, 0x03, 0xC0, 0x87, 0x03,
        0xE0, 0x83, 0x03, 0xF8, 0xFF, 0x3F, 0xF8, 0xFF, 0x3F,
        0xF8, 0xFF, 0x3F, 0xF8, 0xFF, 0x3F, 0x00, 0x80, 0x03,
        0x00, 0x80, 0x03
};
const unsigned char chr_NUM_35[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0x1C, 0x03, 0xE0, 0x1F, 0x0F,
        0xF8, 0x1F, 0x1F, 0xF8, 0x1F, 0x3F, 0xF8, 0x0C, 0x3C,
        0x38, 0x0E, 0x38, 0x38, 0x0E, 0x38, 0x38, 0x1E, 0x3C,
        0x38, 0xFE, 0x1F, 0x38, 0xFC, 0x1F, 0x38, 0xF8, 0x0F,
        0x00, 0xF0, 0x03
};
const unsigned char chr_NUM_36[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x00, 0xFF, 0x01, 0xC0, 0xFF, 0x07,
        0xE0, 0xFF, 0x1F, 0xF0, 0xFF, 0x1F, 0x78, 0x38, 0x3C,
        0x38, 0x1C, 0x38, 0x38, 0x1C, 0x38, 0x78, 0x3C, 0x3C,
        0xF8, 0xFC, 0x3F, 0xF0, 0xF8, 0x1F, 0xF0, 0xF0, 0x0F,
        0xC0, 0xE0, 0x07
};
const unsigned char chr_NUM_37[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x38, 0x00, 0x00,
        0x38, 0x00, 0x3C, 0x38, 0xC0, 0x3F, 0x38, 0xF0, 0x3F,
        0x38, 0xFC, 0x3F, 0x38, 0xFF, 0x01, 0xB8, 0x3F, 0x00,
        0xF8, 0x07, 0x00, 0xF8, 0x03, 0x00, 0xF8, 0x00, 0x00,
        0x78, 0x00, 0x00
};
const unsigned char chr_NUM_38[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0xC0, 0xC3, 0x07, 0xF0, 0xE7, 0x1F,
        0xF0, 0xFF, 0x1F, 0xF8, 0xFF, 0x3F, 0x38, 0x3C, 0x38,
        0x18, 0x18, 0x30, 0x18, 0x18, 0x30, 0x38, 0x3C, 0x38,
        0xF8, 0xFF, 0x3F, 0xF0, 0xFF, 0x1F, 0xF0, 0xE7, 0x1F,
        0xC0, 0xC3, 0x07
};
const unsigned char chr_NUM_39[48] =
{
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
        0x00, 0x00, 0x00, 0xC0, 0x0F, 0x06, 0xE0, 0x1F, 0x1E,
        0xF0, 0x3F, 0x1E, 0xF8, 0x7F, 0x3E, 0x78, 0x78, 0x3C,
        0x38, 0x70, 0x38, 0x38, 0x70, 0x38, 0x78, 0x38, 0x3C,
        0xF0, 0xFF, 0x1F, 0xF0, 0xFF, 0x0F, 0xC0, 0xFF, 0x07,
        0x00, 0xFF, 0x01
};
const unsigned char chr_NUM_3A[15] =
{
        0x00, 0x00, 0x00, 0xE0, 0x81, 0x07, 0xE0, 0x81, 0x07,
        0xE0, 0x81, 0x07, 0xE0, 0x81, 0x07
};

const unsigned char * chrtbl_NUM[11] =
{
        chr_NUM_30, chr_NUM_31, chr_NUM_32, chr_NUM_33, chr_NUM_34, chr_NUM_35,
        chr_NUM_36, chr_NUM_37, chr_NUM_38, chr_NUM_39, chr_NUM_3A
};

#endif
