
#include "ooxml/resourceids.hxx"
#include "OOXMLFactory_w14.hxx"
#include "ooxml/OOXMLFastHelper.hxx"
#include "oox/token/tokens.hxx"

#ifdef _MSC_VER
#pragma warning(disable:4060) // switch statement contains no 'case' or 'default' labels
#pragma warning(disable:4065) // switch statement contains 'default' but no 'case' labels
#pragma warning(disable:4702) // unreachable code
#endif

namespace writerfilter {
namespace ooxml {

using namespace com::sun::star;

/// @cond GENERATED

OOXMLFactory_w14::OOXMLFactory_w14()
{
}

OOXMLFactory_w14::~OOXMLFactory_w14()
{
}

OOXMLFactory_ns::Pointer_t OOXMLFactory_w14::m_pInstance;

OOXMLFactory_ns::Pointer_t OOXMLFactory_w14::getInstance()
{
    if (!m_pInstance)
        m_pInstance = new OOXMLFactory_w14();

    return m_pInstance;
}

const AttributeInfo* OOXMLFactory_w14::getAttributeInfoArray(Id nId)
{
    switch (nId)
    {
    case NN_w14|DEFINE_CT_SRgbColor:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::Hex, NN_w14|DEFINE_ST_HexColorRGB },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_SchemeColor:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_SchemeColorVal },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_PositiveFixedPercentage:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_PositivePercentage:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::Integer, NN_w14|DEFINE_ST_PositivePercentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Percentage:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_LinearShadeProperties:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_ang, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_scaled, ResourceType::List, NN_w14|DEFINE_ST_OnOff },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_PathShadeProperties:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_path, ResourceType::List, NN_w14|DEFINE_ST_PathShadeType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_GradientStop:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_pos, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_RelativeRect:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_l, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_t, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_r, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_b, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_PresetLineDashProperties:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_PresetLineDashVal },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_LineJoinMiterProperties:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_lim, ResourceType::Integer, NN_w14|DEFINE_ST_PositivePercentage },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Camera:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_prst, ResourceType::List, NN_w14|DEFINE_ST_PresetCameraType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_LightRig:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_rig, ResourceType::List, NN_w14|DEFINE_ST_LightRigType },
                { oox::NMSP_w14|oox::XML_dir, ResourceType::List, NN_w14|DEFINE_ST_LightRigDirection },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_SphereCoords:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_lat, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_lon, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_rev, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Bevel:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_w, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_h, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_prst, ResourceType::List, NN_w14|DEFINE_ST_BevelPresetType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_StyleSet:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_id, ResourceType::Integer, NN_w14|DEFINE_ST_UnsignedDecimalNumber },
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_OnOff },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_OnOff:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_OnOff },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Glow:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_rad, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Shadow:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_blurRad, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_dist, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_dir, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_sx, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_sy, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_kx, ResourceType::Integer, NN_w14|DEFINE_ST_FixedAngle },
                { oox::NMSP_w14|oox::XML_ky, ResourceType::Integer, NN_w14|DEFINE_ST_FixedAngle },
                { oox::NMSP_w14|oox::XML_algn, ResourceType::List, NN_w14|DEFINE_ST_RectAlignment },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Reflection:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_blurRad, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_stA, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { oox::NMSP_w14|oox::XML_stPos, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { oox::NMSP_w14|oox::XML_endA, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { oox::NMSP_w14|oox::XML_endPos, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedPercentage },
                { oox::NMSP_w14|oox::XML_dist, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_dir, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_fadeDir, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveFixedAngle },
                { oox::NMSP_w14|oox::XML_sx, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_sy, ResourceType::Integer, NN_w14|DEFINE_ST_Percentage },
                { oox::NMSP_w14|oox::XML_kx, ResourceType::Integer, NN_w14|DEFINE_ST_FixedAngle },
                { oox::NMSP_w14|oox::XML_ky, ResourceType::Integer, NN_w14|DEFINE_ST_FixedAngle },
                { oox::NMSP_w14|oox::XML_algn, ResourceType::List, NN_w14|DEFINE_ST_RectAlignment },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_TextOutlineEffect:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_w, ResourceType::Integer, NN_w14|DEFINE_ST_LineWidth },
                { oox::NMSP_w14|oox::XML_cap, ResourceType::List, NN_w14|DEFINE_ST_LineCap },
                { oox::NMSP_w14|oox::XML_cmpd, ResourceType::List, NN_w14|DEFINE_ST_CompoundLine },
                { oox::NMSP_w14|oox::XML_algn, ResourceType::List, NN_w14|DEFINE_ST_PenAlignment },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Props3D:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_extrusionH, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_contourW, ResourceType::Integer, NN_w14|DEFINE_ST_PositiveCoordinate },
                { oox::NMSP_w14|oox::XML_prstMaterial, ResourceType::List, NN_w14|DEFINE_ST_PresetMaterialType },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_Ligatures:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_Ligatures },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_NumForm:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_NumForm },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_NumSpacing:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::List, NN_w14|DEFINE_ST_NumSpacing },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    case NN_w14|DEFINE_CT_String:
        {
            const static AttributeInfo info[] = {
                { oox::NMSP_w14|oox::XML_val, ResourceType::String, NN_w14|DEFINE_ST_String },
                { -1, ResourceType::NoResource, 0 }
            };
            return info;
        }
        break;
    default:
        break;
    }

    return NULL;
}

bool OOXMLFactory_w14::getListValue(Id nId, std::string_view aValue, sal_uInt32& rOutValue)
{
    (void) aValue;
    (void) rOutValue;

    switch (nId)
    {
    case NN_w14|DEFINE_ST_SchemeColorVal:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "accent1") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent1; }
            else if (aValue == "accent2") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent2; }
            else if (aValue == "accent3") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent3; }
            else if (aValue == "accent4") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent4; }
            else if (aValue == "accent5") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent5; }
            else if (aValue == "accent6") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_accent6; }
            else { return false; }
            return true;
        case 'b':
            if (aValue == "bg1") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_bg1; }
            else if (aValue == "bg2") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_bg2; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "dk1") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_dk1; }
            else if (aValue == "dk2") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_dk2; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "folHlink") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_folHlink; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "hlink") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_hlink; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lt1") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_lt1; }
            else if (aValue == "lt2") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_lt2; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "phClr") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_phClr; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tx1") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_tx1; }
            else if (aValue == "tx2") { rOutValue = NS_ooxml::LN_ST_SchemeColorVal_tx2; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_RectAlignment:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bl") { rOutValue = NS_ooxml::LN_ST_RectAlignment_bl; }
            else if (aValue == "b") { rOutValue = NS_ooxml::LN_ST_RectAlignment_b; }
            else if (aValue == "br") { rOutValue = NS_ooxml::LN_ST_RectAlignment_br; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "ctr") { rOutValue = NS_ooxml::LN_ST_RectAlignment_ctr; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "l") { rOutValue = NS_ooxml::LN_ST_RectAlignment_l; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_ST_RectAlignment_none; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "r") { rOutValue = NS_ooxml::LN_ST_RectAlignment_r; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tl") { rOutValue = NS_ooxml::LN_ST_RectAlignment_tl; }
            else if (aValue == "t") { rOutValue = NS_ooxml::LN_ST_RectAlignment_t; }
            else if (aValue == "tr") { rOutValue = NS_ooxml::LN_ST_RectAlignment_tr; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_LineCap:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'f':
            if (aValue == "flat") { rOutValue = NS_ooxml::LN_ST_LineCap_flat; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "rnd") { rOutValue = NS_ooxml::LN_ST_LineCap_rnd; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "sq") { rOutValue = NS_ooxml::LN_ST_LineCap_sq; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_CompoundLine:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "dbl") { rOutValue = NS_ooxml::LN_ST_CompoundLine_dbl; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "sng") { rOutValue = NS_ooxml::LN_ST_CompoundLine_sng; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "thickThin") { rOutValue = NS_ooxml::LN_ST_CompoundLine_thickThin; }
            else if (aValue == "thinThick") { rOutValue = NS_ooxml::LN_ST_CompoundLine_thinThick; }
            else if (aValue == "tri") { rOutValue = NS_ooxml::LN_ST_CompoundLine_tri; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_PenAlignment:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'c':
            if (aValue == "ctr") { rOutValue = NS_ooxml::LN_ST_PenAlignment_ctr; }
            else { return false; }
            return true;
        case 'i':
            if (aValue == "in") { rOutValue = NS_ooxml::LN_ST_PenAlignment_in; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_OnOff:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case '0':
            if (aValue == "0") { rOutValue = NS_ooxml::LN_ST_OnOff_0; }
            else { return false; }
            return true;
        case '1':
            if (aValue == "1") { rOutValue = NS_ooxml::LN_ST_OnOff_1; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "false") { rOutValue = NS_ooxml::LN_ST_OnOff_false; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "true") { rOutValue = NS_ooxml::LN_ST_OnOff_true; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_PathShadeType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'c':
            if (aValue == "circle") { rOutValue = NS_ooxml::LN_ST_PathShadeType_circle; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "rect") { rOutValue = NS_ooxml::LN_ST_PathShadeType_rect; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "shape") { rOutValue = NS_ooxml::LN_ST_PathShadeType_shape; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_PresetLineDashVal:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "dot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_dot; }
            else if (aValue == "dash") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_dash; }
            else if (aValue == "dashDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_dashDot; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lgDash") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_lgDash; }
            else if (aValue == "lgDashDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_lgDashDot; }
            else if (aValue == "lgDashDotDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_lgDashDotDot; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "solid") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_solid; }
            else if (aValue == "sysDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_sysDot; }
            else if (aValue == "sysDash") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_sysDash; }
            else if (aValue == "sysDashDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_sysDashDot; }
            else if (aValue == "sysDashDotDot") { rOutValue = NS_ooxml::LN_ST_PresetLineDashVal_sysDashDotDot; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_PresetCameraType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'i':
            if (aValue == "isometricTopUp") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricTopUp; }
            else if (aValue == "isometricTopDown") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricTopDown; }
            else if (aValue == "isometricBottomUp") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricBottomUp; }
            else if (aValue == "isometricBottomDown") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricBottomDown; }
            else if (aValue == "isometricLeftUp") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricLeftUp; }
            else if (aValue == "isometricLeftDown") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricLeftDown; }
            else if (aValue == "isometricRightUp") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricRightUp; }
            else if (aValue == "isometricRightDown") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricRightDown; }
            else if (aValue == "isometricOffAxis1Left") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Left; }
            else if (aValue == "isometricOffAxis1Right") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Right; }
            else if (aValue == "isometricOffAxis1Top") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis1Top; }
            else if (aValue == "isometricOffAxis2Left") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Left; }
            else if (aValue == "isometricOffAxis2Right") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Right; }
            else if (aValue == "isometricOffAxis2Top") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis2Top; }
            else if (aValue == "isometricOffAxis3Left") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Left; }
            else if (aValue == "isometricOffAxis3Right") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Right; }
            else if (aValue == "isometricOffAxis3Bottom") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis3Bottom; }
            else if (aValue == "isometricOffAxis4Left") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Left; }
            else if (aValue == "isometricOffAxis4Right") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Right; }
            else if (aValue == "isometricOffAxis4Bottom") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_isometricOffAxis4Bottom; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "legacyObliqueTopLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTopLeft; }
            else if (aValue == "legacyObliqueTop") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTop; }
            else if (aValue == "legacyObliqueTopRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueTopRight; }
            else if (aValue == "legacyObliqueLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueLeft; }
            else if (aValue == "legacyObliqueFront") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueFront; }
            else if (aValue == "legacyObliqueRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueRight; }
            else if (aValue == "legacyObliqueBottomLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottomLeft; }
            else if (aValue == "legacyObliqueBottom") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottom; }
            else if (aValue == "legacyObliqueBottomRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyObliqueBottomRight; }
            else if (aValue == "legacyPerspectiveTopLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTopLeft; }
            else if (aValue == "legacyPerspectiveTop") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTop; }
            else if (aValue == "legacyPerspectiveTopRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveTopRight; }
            else if (aValue == "legacyPerspectiveLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveLeft; }
            else if (aValue == "legacyPerspectiveFront") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveFront; }
            else if (aValue == "legacyPerspectiveRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveRight; }
            else if (aValue == "legacyPerspectiveBottomLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottomLeft; }
            else if (aValue == "legacyPerspectiveBottom") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottom; }
            else if (aValue == "legacyPerspectiveBottomRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_legacyPerspectiveBottomRight; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "orthographicFront") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_orthographicFront; }
            else if (aValue == "obliqueTopLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueTopLeft; }
            else if (aValue == "obliqueTop") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueTop; }
            else if (aValue == "obliqueTopRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueTopRight; }
            else if (aValue == "obliqueLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueLeft; }
            else if (aValue == "obliqueRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueRight; }
            else if (aValue == "obliqueBottomLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueBottomLeft; }
            else if (aValue == "obliqueBottom") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueBottom; }
            else if (aValue == "obliqueBottomRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_obliqueBottomRight; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "perspectiveFront") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveFront; }
            else if (aValue == "perspectiveLeft") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveLeft; }
            else if (aValue == "perspectiveRight") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveRight; }
            else if (aValue == "perspectiveAbove") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveAbove; }
            else if (aValue == "perspectiveBelow") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveBelow; }
            else if (aValue == "perspectiveAboveLeftFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveAboveLeftFacing; }
            else if (aValue == "perspectiveAboveRightFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveAboveRightFacing; }
            else if (aValue == "perspectiveContrastingLeftFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveContrastingLeftFacing; }
            else if (aValue == "perspectiveContrastingRightFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveContrastingRightFacing; }
            else if (aValue == "perspectiveHeroicLeftFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicLeftFacing; }
            else if (aValue == "perspectiveHeroicRightFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicRightFacing; }
            else if (aValue == "perspectiveHeroicExtremeLeftFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicExtremeLeftFacing; }
            else if (aValue == "perspectiveHeroicExtremeRightFacing") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveHeroicExtremeRightFacing; }
            else if (aValue == "perspectiveRelaxed") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveRelaxed; }
            else if (aValue == "perspectiveRelaxedModerately") { rOutValue = NS_ooxml::LN_ST_PresetCameraType_perspectiveRelaxedModerately; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_LightRigType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "balanced") { rOutValue = NS_ooxml::LN_ST_LightRigType_balanced; }
            else if (aValue == "brightRoom") { rOutValue = NS_ooxml::LN_ST_LightRigType_brightRoom; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "contrasting") { rOutValue = NS_ooxml::LN_ST_LightRigType_contrasting; }
            else if (aValue == "chilly") { rOutValue = NS_ooxml::LN_ST_LightRigType_chilly; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "flood") { rOutValue = NS_ooxml::LN_ST_LightRigType_flood; }
            else if (aValue == "freezing") { rOutValue = NS_ooxml::LN_ST_LightRigType_freezing; }
            else if (aValue == "flat") { rOutValue = NS_ooxml::LN_ST_LightRigType_flat; }
            else { return false; }
            return true;
        case 'g':
            if (aValue == "glow") { rOutValue = NS_ooxml::LN_ST_LightRigType_glow; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "harsh") { rOutValue = NS_ooxml::LN_ST_LightRigType_harsh; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "legacyFlat1") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyFlat1; }
            else if (aValue == "legacyFlat2") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyFlat2; }
            else if (aValue == "legacyFlat3") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyFlat3; }
            else if (aValue == "legacyFlat4") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyFlat4; }
            else if (aValue == "legacyNormal1") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyNormal1; }
            else if (aValue == "legacyNormal2") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyNormal2; }
            else if (aValue == "legacyNormal3") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyNormal3; }
            else if (aValue == "legacyNormal4") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyNormal4; }
            else if (aValue == "legacyHarsh1") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyHarsh1; }
            else if (aValue == "legacyHarsh2") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyHarsh2; }
            else if (aValue == "legacyHarsh3") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyHarsh3; }
            else if (aValue == "legacyHarsh4") { rOutValue = NS_ooxml::LN_ST_LightRigType_legacyHarsh4; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "morning") { rOutValue = NS_ooxml::LN_ST_LightRigType_morning; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "soft") { rOutValue = NS_ooxml::LN_ST_LightRigType_soft; }
            else if (aValue == "sunrise") { rOutValue = NS_ooxml::LN_ST_LightRigType_sunrise; }
            else if (aValue == "sunset") { rOutValue = NS_ooxml::LN_ST_LightRigType_sunset; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "threePt") { rOutValue = NS_ooxml::LN_ST_LightRigType_threePt; }
            else if (aValue == "twoPt") { rOutValue = NS_ooxml::LN_ST_LightRigType_twoPt; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_LightRigDirection:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'b':
            if (aValue == "bl") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_bl; }
            else if (aValue == "b") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_b; }
            else if (aValue == "br") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_br; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "l") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_l; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "r") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_r; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tl") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_tl; }
            else if (aValue == "t") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_t; }
            else if (aValue == "tr") { rOutValue = NS_ooxml::LN_ST_LightRigDirection_tr; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_BevelPresetType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "angle") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_angle; }
            else if (aValue == "artDeco") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_artDeco; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "circle") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_circle; }
            else if (aValue == "cross") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_cross; }
            else if (aValue == "convex") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_convex; }
            else if (aValue == "coolSlant") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_coolSlant; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "divot") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_divot; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "hardEdge") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_hardEdge; }
            else { return false; }
            return true;
        case 'r':
            if (aValue == "relaxedInset") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_relaxedInset; }
            else if (aValue == "riblet") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_riblet; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "slope") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_slope; }
            else if (aValue == "softRound") { rOutValue = NS_ooxml::LN_ST_BevelPresetType_softRound; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_PresetMaterialType:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'c':
            if (aValue == "clear") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_clear; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "dkEdge") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_dkEdge; }
            else { return false; }
            return true;
        case 'f':
            if (aValue == "flat") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_flat; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "legacyMatte") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_legacyMatte; }
            else if (aValue == "legacyPlastic") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_legacyPlastic; }
            else if (aValue == "legacyMetal") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_legacyMetal; }
            else if (aValue == "legacyWireframe") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_legacyWireframe; }
            else { return false; }
            return true;
        case 'm':
            if (aValue == "matte") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_matte; }
            else if (aValue == "metal") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_metal; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_none; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "plastic") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_plastic; }
            else if (aValue == "powder") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_powder; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "softEdge") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_softEdge; }
            else if (aValue == "softmetal") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_softmetal; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "translucentPowder") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_translucentPowder; }
            else { return false; }
            return true;
        case 'w':
            if (aValue == "warmMatte") { rOutValue = NS_ooxml::LN_ST_PresetMaterialType_warmMatte; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_Ligatures:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'a':
            if (aValue == "all") { rOutValue = NS_ooxml::LN_ST_Ligatures_all; }
            else { return false; }
            return true;
        case 'c':
            if (aValue == "contextual") { rOutValue = NS_ooxml::LN_ST_Ligatures_contextual; }
            else if (aValue == "contextualHistorical") { rOutValue = NS_ooxml::LN_ST_Ligatures_contextualHistorical; }
            else if (aValue == "contextualDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_contextualDiscretional; }
            else if (aValue == "contextualHistoricalDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_contextualHistoricalDiscretional; }
            else { return false; }
            return true;
        case 'd':
            if (aValue == "discretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_discretional; }
            else { return false; }
            return true;
        case 'h':
            if (aValue == "historical") { rOutValue = NS_ooxml::LN_ST_Ligatures_historical; }
            else if (aValue == "historicalDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_historicalDiscretional; }
            else { return false; }
            return true;
        case 'n':
            if (aValue == "none") { rOutValue = NS_ooxml::LN_ST_Ligatures_none; }
            else { return false; }
            return true;
        case 's':
            if (aValue == "standard") { rOutValue = NS_ooxml::LN_ST_Ligatures_standard; }
            else if (aValue == "standardContextual") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardContextual; }
            else if (aValue == "standardHistorical") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardHistorical; }
            else if (aValue == "standardDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardDiscretional; }
            else if (aValue == "standardContextualHistorical") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardContextualHistorical; }
            else if (aValue == "standardContextualDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardContextualDiscretional; }
            else if (aValue == "standardHistoricalDiscretional") { rOutValue = NS_ooxml::LN_ST_Ligatures_standardHistoricalDiscretional; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_NumForm:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "default") { rOutValue = NS_ooxml::LN_ST_NumForm_default; }
            else { return false; }
            return true;
        case 'l':
            if (aValue == "lining") { rOutValue = NS_ooxml::LN_ST_NumForm_lining; }
            else { return false; }
            return true;
        case 'o':
            if (aValue == "oldStyle") { rOutValue = NS_ooxml::LN_ST_NumForm_oldStyle; }
            else { return false; }
            return true;
        }
        return false;
    case NN_w14|DEFINE_ST_NumSpacing:
        if (aValue.empty())
            return false;
        switch (aValue[0])
        {
        case 'd':
            if (aValue == "default") { rOutValue = NS_ooxml::LN_ST_NumSpacing_default; }
            else { return false; }
            return true;
        case 'p':
            if (aValue == "proportional") { rOutValue = NS_ooxml::LN_ST_NumSpacing_proportional; }
            else { return false; }
            return true;
        case 't':
            if (aValue == "tabular") { rOutValue = NS_ooxml::LN_ST_NumSpacing_tabular; }
            else { return false; }
            return true;
        }
        return false;
    default:
        break;
    }

    return false;
}

bool OOXMLFactory_w14::getElementId(Id nDefine, Id nId, ResourceType& rOutResource, Id& rOutElement)
{
    (void) rOutResource;
    (void) rOutElement;

    switch (nDefine)
    {
    case NN_w14|DEFINE_EG_ColorChoice:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_EG_ColorTransform:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_alpha: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_hueMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_w14|oox::XML_lum: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_sat: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_shade: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_tint: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_EG_FillProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_w14|oox::XML_noFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SolidColorFillProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_EG_ShadeProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_lin: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_LinearShadeProperties; break;
        case oox::NMSP_w14|oox::XML_path: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PathShadeProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_EG_LineDashProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_prstDash: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PresetLineDashProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_EG_LineJoinProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_bevel: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_miter: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_LineJoinMiterProperties; break;
        case oox::NMSP_w14|oox::XML_round: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_SRgbColor:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_alpha: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_hueMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_w14|oox::XML_lum: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_sat: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_shade: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_tint: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_SchemeColor:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_alpha: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_hueMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositivePercentage; break;
        case oox::NMSP_w14|oox::XML_lum: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_lumOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_sat: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satMod: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_satOff: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Percentage; break;
        case oox::NMSP_w14|oox::XML_shade: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        case oox::NMSP_w14|oox::XML_tint: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PositiveFixedPercentage; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_SolidColorFillProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_GradientFillProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_gsLst: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientStopList; break;
        case oox::NMSP_w14|oox::XML_lin: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_LinearShadeProperties; break;
        case oox::NMSP_w14|oox::XML_path: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PathShadeProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_PathShadeProperties:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_fillToRect: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_RelativeRect; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_GradientStopList:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_gs: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientStop; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_GradientStop:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_LightRig:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_rot: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SphereCoords; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_Color:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_Glow:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_Shadow:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SchemeColor; break;
        case oox::NMSP_w14|oox::XML_srgbClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SRgbColor; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_TextOutlineEffect:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_bevel: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_w14|oox::XML_miter: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_LineJoinMiterProperties; break;
        case oox::NMSP_w14|oox::XML_noFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_prstDash: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_PresetLineDashProperties; break;
        case oox::NMSP_w14|oox::XML_round: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SolidColorFillProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_FillTextEffect:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_gradFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_GradientFillProperties; break;
        case oox::NMSP_w14|oox::XML_noFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Empty; break;
        case oox::NMSP_w14|oox::XML_solidFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_SolidColorFillProperties; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_Scene3D:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_camera: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Camera; break;
        case oox::NMSP_w14|oox::XML_lightRig: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_LightRig; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_Props3D:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_bevelB: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Bevel; break;
        case oox::NMSP_w14|oox::XML_bevelT: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Bevel; break;
        case oox::NMSP_w14|oox::XML_contourClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Color; break;
        case oox::NMSP_w14|oox::XML_extrusionClr: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Color; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_StylisticSets:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_styleSet: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_StyleSet; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_glow:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_glow: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Glow; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_shadow:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_shadow: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Shadow; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_reflection:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_reflection: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Reflection; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_textOutline:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_textOutline: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_TextOutlineEffect; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_textFill:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_textFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_FillTextEffect; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_scene3d:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_scene3d: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Scene3D; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_props3d:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_props3d: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Props3D; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_ligatures:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_ligatures: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Ligatures; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_numForm:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_numForm: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_NumForm; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_numSpacing:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_numSpacing: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_NumSpacing; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_stylisticSets:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_stylisticSets: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_StylisticSets; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_cntxtAlts:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_cntxtAlts: rOutResource = ResourceType::Value; rOutElement = NN_w14|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    case NN_w14|DEFINE_CT_SdtCheckbox:
        switch (nId)
        {
        case oox::NMSP_w14|oox::XML_checked: rOutResource = ResourceType::Value; rOutElement = NN_w14|DEFINE_CT_OnOff; break;
        case oox::NMSP_w14|oox::XML_checkedState: rOutResource = ResourceType::Value; rOutElement = NN_w14|DEFINE_CT_String; break;
        case oox::NMSP_w14|oox::XML_uncheckedState: rOutResource = ResourceType::Value; rOutElement = NN_w14|DEFINE_CT_String; break;
        default: return false;
        }
        return true;
    default:
        switch (nId)
        {
        /* start: glow*/
        case oox::NMSP_w14|oox::XML_glow: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Glow; break;
        /* start: shadow*/
        case oox::NMSP_w14|oox::XML_shadow: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Shadow; break;
        /* start: reflection*/
        case oox::NMSP_w14|oox::XML_reflection: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Reflection; break;
        /* start: textOutline*/
        case oox::NMSP_w14|oox::XML_textOutline: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_TextOutlineEffect; break;
        /* start: textFill*/
        case oox::NMSP_w14|oox::XML_textFill: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_FillTextEffect; break;
        /* start: scene3d*/
        case oox::NMSP_w14|oox::XML_scene3d: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Scene3D; break;
        /* start: props3d*/
        case oox::NMSP_w14|oox::XML_props3d: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Props3D; break;
        /* start: ligatures*/
        case oox::NMSP_w14|oox::XML_ligatures: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_Ligatures; break;
        /* start: numForm*/
        case oox::NMSP_w14|oox::XML_numForm: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_NumForm; break;
        /* start: numSpacing*/
        case oox::NMSP_w14|oox::XML_numSpacing: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_NumSpacing; break;
        /* start: stylisticSets*/
        case oox::NMSP_w14|oox::XML_stylisticSets: rOutResource = ResourceType::Properties; rOutElement = NN_w14|DEFINE_CT_StylisticSets; break;
        /* start: cntxtAlts*/
        case oox::NMSP_w14|oox::XML_cntxtAlts: rOutResource = ResourceType::Value; rOutElement = NN_w14|DEFINE_CT_OnOff; break;
        default: return false;
        }
        return true;
    }
}

void OOXMLFactory_w14::startAction(OOXMLFastContextHandler* pHandler)
{
    sal_uInt32 nDefine = pHandler->getDefine();
    switch (nDefine)
    {
    case NN_w14|DEFINE_CT_String:
        pHandler->setDefaultStringValue();
        break;
    
    case NN_w14|DEFINE_CT_OnOff:
        pHandler->setDefaultBooleanValue();
        break;

    default:
        break;
    }
}

void OOXMLFactory_w14::charactersAction(OOXMLFastContextHandler*, const OUString&)
{
}

Id OOXMLFactory_w14::getResourceId(Id nDefine, sal_Int32 nToken)
{
    (void) nDefine;
    (void) nToken;

    switch (nDefine)
    {
    case NN_w14|DEFINE_EG_ColorChoice:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        }
        break;
    case NN_w14|DEFINE_EG_ColorTransform:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        }
        break;
    case NN_w14|DEFINE_EG_FillProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gradFill: return NS_ooxml::LN_EG_FillProperties_gradFill;
        case oox::NMSP_w14|oox::XML_noFill: return NS_ooxml::LN_EG_FillProperties_noFill;
        case oox::NMSP_w14|oox::XML_solidFill: return NS_ooxml::LN_EG_FillProperties_solidFill;
        }
        break;
    case NN_w14|DEFINE_EG_ShadeProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_lin: return NS_ooxml::LN_EG_ShadeProperties_lin;
        case oox::NMSP_w14|oox::XML_path: return NS_ooxml::LN_EG_ShadeProperties_path;
        }
        break;
    case NN_w14|DEFINE_EG_LineDashProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_prstDash: return NS_ooxml::LN_EG_LineDashProperties_prstDash;
        }
        break;
    case NN_w14|DEFINE_EG_LineJoinProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_bevel: return NS_ooxml::LN_EG_LineJoinProperties_bevel;
        case oox::NMSP_w14|oox::XML_miter: return NS_ooxml::LN_EG_LineJoinProperties_miter;
        case oox::NMSP_w14|oox::XML_round: return NS_ooxml::LN_EG_LineJoinProperties_round;
        }
        break;
    case NN_w14|DEFINE_CT_SRgbColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_SRgbColor_val;
        }
        break;
    case NN_w14|DEFINE_CT_SchemeColor:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_alpha: return NS_ooxml::LN_EG_ColorTransform_alpha;
        case oox::NMSP_w14|oox::XML_hueMod: return NS_ooxml::LN_EG_ColorTransform_hueMod;
        case oox::NMSP_w14|oox::XML_lum: return NS_ooxml::LN_EG_ColorTransform_lum;
        case oox::NMSP_w14|oox::XML_lumMod: return NS_ooxml::LN_EG_ColorTransform_lumMod;
        case oox::NMSP_w14|oox::XML_lumOff: return NS_ooxml::LN_EG_ColorTransform_lumOff;
        case oox::NMSP_w14|oox::XML_sat: return NS_ooxml::LN_EG_ColorTransform_sat;
        case oox::NMSP_w14|oox::XML_satMod: return NS_ooxml::LN_EG_ColorTransform_satMod;
        case oox::NMSP_w14|oox::XML_satOff: return NS_ooxml::LN_EG_ColorTransform_satOff;
        case oox::NMSP_w14|oox::XML_shade: return NS_ooxml::LN_EG_ColorTransform_shade;
        case oox::NMSP_w14|oox::XML_tint: return NS_ooxml::LN_EG_ColorTransform_tint;
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_SchemeColor_val;
        }
        break;
    case NN_w14|DEFINE_CT_PositiveFixedPercentage:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_PositiveFixedPercentage_val;
        }
        break;
    case NN_w14|DEFINE_CT_PositivePercentage:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_PositivePercentage_val;
        }
        break;
    case NN_w14|DEFINE_CT_Percentage:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_Percentage_val;
        }
        break;
    case NN_w14|DEFINE_CT_SolidColorFillProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        }
        break;
    case NN_w14|DEFINE_CT_GradientFillProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gsLst: return NS_ooxml::LN_CT_GradientFillProperties_gsLst;
        case oox::NMSP_w14|oox::XML_lin: return NS_ooxml::LN_EG_ShadeProperties_lin;
        case oox::NMSP_w14|oox::XML_path: return NS_ooxml::LN_EG_ShadeProperties_path;
        }
        break;
    case NN_w14|DEFINE_CT_LinearShadeProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_ang: return NS_ooxml::LN_CT_LinearShadeProperties_ang;
        case oox::NMSP_w14|oox::XML_scaled: return NS_ooxml::LN_CT_LinearShadeProperties_scaled;
        }
        break;
    case NN_w14|DEFINE_CT_PathShadeProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_fillToRect: return NS_ooxml::LN_CT_PathShadeProperties_fillToRect;
        case oox::NMSP_w14|oox::XML_path: return NS_ooxml::LN_CT_PathShadeProperties_path;
        }
        break;
    case NN_w14|DEFINE_CT_GradientStopList:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gs: return NS_ooxml::LN_CT_GradientStopList_gs;
        }
        break;
    case NN_w14|DEFINE_CT_GradientStop:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_pos: return NS_ooxml::LN_CT_GradientStop_pos;
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        }
        break;
    case NN_w14|DEFINE_CT_RelativeRect:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_b: return NS_ooxml::LN_CT_RelativeRect_b;
        case oox::NMSP_w14|oox::XML_l: return NS_ooxml::LN_CT_RelativeRect_l;
        case oox::NMSP_w14|oox::XML_r: return NS_ooxml::LN_CT_RelativeRect_r;
        case oox::NMSP_w14|oox::XML_t: return NS_ooxml::LN_CT_RelativeRect_t;
        }
        break;
    case NN_w14|DEFINE_CT_PresetLineDashProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_PresetLineDashProperties_val;
        }
        break;
    case NN_w14|DEFINE_CT_LineJoinMiterProperties:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_lim: return NS_ooxml::LN_CT_LineJoinMiterProperties_lim;
        }
        break;
    case NN_w14|DEFINE_CT_Camera:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_prst: return NS_ooxml::LN_CT_Camera_prst;
        }
        break;
    case NN_w14|DEFINE_CT_LightRig:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_dir: return NS_ooxml::LN_CT_LightRig_dir;
        case oox::NMSP_w14|oox::XML_rig: return NS_ooxml::LN_CT_LightRig_rig;
        case oox::NMSP_w14|oox::XML_rot: return NS_ooxml::LN_CT_LightRig_rot;
        }
        break;
    case NN_w14|DEFINE_CT_SphereCoords:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_lat: return NS_ooxml::LN_CT_SphereCoords_lat;
        case oox::NMSP_w14|oox::XML_lon: return NS_ooxml::LN_CT_SphereCoords_lon;
        case oox::NMSP_w14|oox::XML_rev: return NS_ooxml::LN_CT_SphereCoords_rev;
        }
        break;
    case NN_w14|DEFINE_CT_Bevel:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_h: return NS_ooxml::LN_CT_Bevel_h;
        case oox::NMSP_w14|oox::XML_prst: return NS_ooxml::LN_CT_Bevel_prst;
        case oox::NMSP_w14|oox::XML_w: return NS_ooxml::LN_CT_Bevel_w;
        }
        break;
    case NN_w14|DEFINE_CT_Color:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        }
        break;
    case NN_w14|DEFINE_CT_StyleSet:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_id: return NS_ooxml::LN_CT_StyleSet_id;
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_StyleSet_val;
        }
        break;
    case NN_w14|DEFINE_CT_OnOff:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_OnOff_val;
        }
        break;
    case NN_w14|DEFINE_CT_Glow:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_rad: return NS_ooxml::LN_CT_Glow_rad;
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        }
        break;
    case NN_w14|DEFINE_CT_Shadow:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_algn: return NS_ooxml::LN_CT_Shadow_algn;
        case oox::NMSP_w14|oox::XML_blurRad: return NS_ooxml::LN_CT_Shadow_blurRad;
        case oox::NMSP_w14|oox::XML_dir: return NS_ooxml::LN_CT_Shadow_dir;
        case oox::NMSP_w14|oox::XML_dist: return NS_ooxml::LN_CT_Shadow_dist;
        case oox::NMSP_w14|oox::XML_kx: return NS_ooxml::LN_CT_Shadow_kx;
        case oox::NMSP_w14|oox::XML_ky: return NS_ooxml::LN_CT_Shadow_ky;
        case oox::NMSP_w14|oox::XML_schemeClr: return NS_ooxml::LN_EG_ColorChoice_schemeClr;
        case oox::NMSP_w14|oox::XML_srgbClr: return NS_ooxml::LN_EG_ColorChoice_srgbClr;
        case oox::NMSP_w14|oox::XML_sx: return NS_ooxml::LN_CT_Shadow_sx;
        case oox::NMSP_w14|oox::XML_sy: return NS_ooxml::LN_CT_Shadow_sy;
        }
        break;
    case NN_w14|DEFINE_CT_Reflection:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_algn: return NS_ooxml::LN_CT_Reflection_algn;
        case oox::NMSP_w14|oox::XML_blurRad: return NS_ooxml::LN_CT_Reflection_blurRad;
        case oox::NMSP_w14|oox::XML_dir: return NS_ooxml::LN_CT_Reflection_dir;
        case oox::NMSP_w14|oox::XML_dist: return NS_ooxml::LN_CT_Reflection_dist;
        case oox::NMSP_w14|oox::XML_endA: return NS_ooxml::LN_CT_Reflection_endA;
        case oox::NMSP_w14|oox::XML_endPos: return NS_ooxml::LN_CT_Reflection_endPos;
        case oox::NMSP_w14|oox::XML_fadeDir: return NS_ooxml::LN_CT_Reflection_fadeDir;
        case oox::NMSP_w14|oox::XML_kx: return NS_ooxml::LN_CT_Reflection_kx;
        case oox::NMSP_w14|oox::XML_ky: return NS_ooxml::LN_CT_Reflection_ky;
        case oox::NMSP_w14|oox::XML_stA: return NS_ooxml::LN_CT_Reflection_stA;
        case oox::NMSP_w14|oox::XML_stPos: return NS_ooxml::LN_CT_Reflection_stPos;
        case oox::NMSP_w14|oox::XML_sx: return NS_ooxml::LN_CT_Reflection_sx;
        case oox::NMSP_w14|oox::XML_sy: return NS_ooxml::LN_CT_Reflection_sy;
        }
        break;
    case NN_w14|DEFINE_CT_TextOutlineEffect:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_algn: return NS_ooxml::LN_CT_TextOutlineEffect_algn;
        case oox::NMSP_w14|oox::XML_bevel: return NS_ooxml::LN_EG_LineJoinProperties_bevel;
        case oox::NMSP_w14|oox::XML_cap: return NS_ooxml::LN_CT_TextOutlineEffect_cap;
        case oox::NMSP_w14|oox::XML_cmpd: return NS_ooxml::LN_CT_TextOutlineEffect_cmpd;
        case oox::NMSP_w14|oox::XML_gradFill: return NS_ooxml::LN_EG_FillProperties_gradFill;
        case oox::NMSP_w14|oox::XML_miter: return NS_ooxml::LN_EG_LineJoinProperties_miter;
        case oox::NMSP_w14|oox::XML_noFill: return NS_ooxml::LN_EG_FillProperties_noFill;
        case oox::NMSP_w14|oox::XML_prstDash: return NS_ooxml::LN_EG_LineDashProperties_prstDash;
        case oox::NMSP_w14|oox::XML_round: return NS_ooxml::LN_EG_LineJoinProperties_round;
        case oox::NMSP_w14|oox::XML_solidFill: return NS_ooxml::LN_EG_FillProperties_solidFill;
        case oox::NMSP_w14|oox::XML_w: return NS_ooxml::LN_CT_TextOutlineEffect_w;
        }
        break;
    case NN_w14|DEFINE_CT_FillTextEffect:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_gradFill: return NS_ooxml::LN_EG_FillProperties_gradFill;
        case oox::NMSP_w14|oox::XML_noFill: return NS_ooxml::LN_EG_FillProperties_noFill;
        case oox::NMSP_w14|oox::XML_solidFill: return NS_ooxml::LN_EG_FillProperties_solidFill;
        }
        break;
    case NN_w14|DEFINE_CT_Scene3D:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_camera: return NS_ooxml::LN_CT_Scene3D_camera;
        case oox::NMSP_w14|oox::XML_lightRig: return NS_ooxml::LN_CT_Scene3D_lightRig;
        }
        break;
    case NN_w14|DEFINE_CT_Props3D:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_bevelB: return NS_ooxml::LN_CT_Props3D_bevelB;
        case oox::NMSP_w14|oox::XML_bevelT: return NS_ooxml::LN_CT_Props3D_bevelT;
        case oox::NMSP_w14|oox::XML_contourClr: return NS_ooxml::LN_CT_Props3D_contourClr;
        case oox::NMSP_w14|oox::XML_contourW: return NS_ooxml::LN_CT_Props3D_contourW;
        case oox::NMSP_w14|oox::XML_extrusionClr: return NS_ooxml::LN_CT_Props3D_extrusionClr;
        case oox::NMSP_w14|oox::XML_extrusionH: return NS_ooxml::LN_CT_Props3D_extrusionH;
        case oox::NMSP_w14|oox::XML_prstMaterial: return NS_ooxml::LN_CT_Props3D_prstMaterial;
        }
        break;
    case NN_w14|DEFINE_CT_Ligatures:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_Ligatures_val;
        }
        break;
    case NN_w14|DEFINE_CT_NumForm:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_NumForm_val;
        }
        break;
    case NN_w14|DEFINE_CT_NumSpacing:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_NumSpacing_val;
        }
        break;
    case NN_w14|DEFINE_CT_StylisticSets:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_styleSet: return NS_ooxml::LN_CT_StylisticSets_styleSet;
        }
        break;
    case NN_w14|DEFINE_glow:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_glow: return NS_ooxml::LN_glow_glow;
        }
        break;
    case NN_w14|DEFINE_shadow:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_shadow: return NS_ooxml::LN_shadow_shadow;
        }
        break;
    case NN_w14|DEFINE_reflection:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_reflection: return NS_ooxml::LN_reflection_reflection;
        }
        break;
    case NN_w14|DEFINE_textOutline:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_textOutline: return NS_ooxml::LN_textOutline_textOutline;
        }
        break;
    case NN_w14|DEFINE_textFill:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_textFill: return NS_ooxml::LN_textFill_textFill;
        }
        break;
    case NN_w14|DEFINE_scene3d:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_scene3d: return NS_ooxml::LN_scene3d_scene3d;
        }
        break;
    case NN_w14|DEFINE_props3d:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_props3d: return NS_ooxml::LN_props3d_props3d;
        }
        break;
    case NN_w14|DEFINE_ligatures:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_ligatures: return NS_ooxml::LN_ligatures_ligatures;
        }
        break;
    case NN_w14|DEFINE_numForm:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_numForm: return NS_ooxml::LN_numForm_numForm;
        }
        break;
    case NN_w14|DEFINE_numSpacing:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_numSpacing: return NS_ooxml::LN_numSpacing_numSpacing;
        }
        break;
    case NN_w14|DEFINE_stylisticSets:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_stylisticSets: return NS_ooxml::LN_stylisticSets_stylisticSets;
        }
        break;
    case NN_w14|DEFINE_cntxtAlts:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_cntxtAlts: return NS_ooxml::LN_cntxtAlts_cntxtAlts;
        }
        break;
    case NN_w14|DEFINE_CT_String:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_val: return NS_ooxml::LN_CT_String_val;
        }
        break;
    case NN_w14|DEFINE_CT_SdtCheckbox:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_checked: return NS_ooxml::LN_CT_SdtCheckbox_checked;
        case oox::NMSP_w14|oox::XML_checkedState: return NS_ooxml::LN_CT_SdtCheckbox_checkedState;
        case oox::NMSP_w14|oox::XML_uncheckedState: return NS_ooxml::LN_CT_SdtCheckbox_uncheckedState;
        }
        break;
    default:
        switch (nToken)
        {
        case oox::NMSP_w14|oox::XML_glow: return NS_ooxml::LN_glow_glow;
        case oox::NMSP_w14|oox::XML_shadow: return NS_ooxml::LN_shadow_shadow;
        case oox::NMSP_w14|oox::XML_reflection: return NS_ooxml::LN_reflection_reflection;
        case oox::NMSP_w14|oox::XML_textOutline: return NS_ooxml::LN_textOutline_textOutline;
        case oox::NMSP_w14|oox::XML_textFill: return NS_ooxml::LN_textFill_textFill;
        case oox::NMSP_w14|oox::XML_scene3d: return NS_ooxml::LN_scene3d_scene3d;
        case oox::NMSP_w14|oox::XML_props3d: return NS_ooxml::LN_props3d_props3d;
        case oox::NMSP_w14|oox::XML_ligatures: return NS_ooxml::LN_ligatures_ligatures;
        case oox::NMSP_w14|oox::XML_numForm: return NS_ooxml::LN_numForm_numForm;
        case oox::NMSP_w14|oox::XML_numSpacing: return NS_ooxml::LN_numSpacing_numSpacing;
        case oox::NMSP_w14|oox::XML_stylisticSets: return NS_ooxml::LN_stylisticSets_stylisticSets;
        case oox::NMSP_w14|oox::XML_cntxtAlts: return NS_ooxml::LN_cntxtAlts_cntxtAlts;
        }
        break;
    }
    return 0;
}

void OOXMLFactory_w14::attributeAction(OOXMLFastContextHandler* _pHandler, Token_t nToken, const OOXMLValue& pValue)
{
    switch (_pHandler->getDefine())
    {
    case NN_w14|DEFINE_CT_OnOff:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_w14|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    case NN_w14|DEFINE_CT_String:
        if (OOXMLFastContextHandlerValue* pHandler = dynamic_cast<OOXMLFastContextHandlerValue*>(_pHandler))
        {
            if (nToken == static_cast<Token_t>(oox::NMSP_w14|oox::XML_val))
                pHandler->setValue(pValue);
        }
        break;
    default:
        break;
    }
}

/// @endcond
}}
