/* skk.c generated by valac 0.56.17, the Vala compiler
 * generated from skk.vala, do not modify */

/*
 * Copyright (C) 2011-2018 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2018 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <config.h>
#include <stdio.h>
#include <libskk/libskk.h>
#include <gee.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_REPL (repl_get_type ())
#define REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPL, Repl))
#define REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REPL, ReplClass))
#define IS_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPL))
#define IS_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REPL))
#define REPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REPL, ReplClass))

typedef struct _Repl Repl;
typedef struct _ReplClass ReplClass;
typedef struct _ReplPrivate ReplPrivate;
enum  {
	REPL_0_PROPERTY,
	REPL_NUM_PROPERTIES
};
static GParamSpec* repl_properties[REPL_NUM_PROPERTIES];
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Repl {
	GObject parent_instance;
	ReplPrivate * priv;
};

struct _ReplClass {
	GObjectClass parent_class;
};

struct _ReplPrivate {
	SkkContext* context;
};

VALA_EXTERN gchar* opt_file_dict;
gchar* opt_file_dict = NULL;
VALA_EXTERN gchar* opt_user_dict;
gchar* opt_user_dict = NULL;
VALA_EXTERN gchar* opt_skkserv;
gchar* opt_skkserv = NULL;
VALA_EXTERN gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
VALA_EXTERN gboolean opt_list_typing_rules;
gboolean opt_list_typing_rules = FALSE;
static gint Repl_private_offset;
static gpointer repl_parent_class = NULL;

static gint _vala_main (gchar** args,
                 gint args_length1);
static void _vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                       gssize array_length);
VALA_EXTERN GType repl_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Repl, g_object_unref)
VALA_EXTERN Repl* repl_new (SkkContext* context);
VALA_EXTERN Repl* repl_construct (GType object_type,
                      SkkContext* context);
VALA_EXTERN gboolean repl_run (Repl* self);
static void repl_finalize (GObject * obj);
static GType repl_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

const GOptionEntry options[6] = {{"file-dict", 'f', (gint) 0, G_OPTION_ARG_STRING, &opt_file_dict, N_ ("Path to a file dictionary"), NULL}, {"user-dict", 'u', (gint) 0, G_OPTION_ARG_STRING, &opt_user_dict, N_ ("Path to a user dictionary"), NULL}, {"skkserv", 's', (gint) 0, G_OPTION_ARG_STRING, &opt_skkserv, N_ ("Host and port running skkserv (HOST:PORT)"), NULL}, {"rule", 'r', (gint) 0, G_OPTION_ARG_STRING, &opt_typing_rule, N_ ("Typing rule (default: \"default\")"), NULL}, {"list-rules", 'l', (gint) 0, G_OPTION_ARG_NONE, &opt_list_typing_rules, N_ ("List typing rules"), NULL}, {NULL}};

static void
_vala_SkkRuleMetadata_array_free (SkkRuleMetadata * array,
                                  gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			skk_rule_metadata_destroy (&array[i]);
		}
	}
	g_free (array);
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gint
_vala_main (gchar** args,
            gint args_length1)
{
	GOptionContext* option_context = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GeeArrayList* dictionaries = NULL;
	GeeArrayList* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp31_;
	const gchar* _tmp33_;
	const gchar* _tmp52_;
	SkkContext* context = NULL;
	GeeArrayList* _tmp73_;
	gint _tmp74_ = 0;
	gpointer* _tmp75_;
	SkkDict** _tmp76_;
	gint _tmp76__length1;
	SkkContext* _tmp77_;
	SkkContext* _tmp78_;
	const gchar* _tmp79_;
	Repl* repl = NULL;
	SkkContext* _tmp90_;
	Repl* _tmp91_;
	Repl* _tmp92_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (_ ("- emulate SKK input method on the command line"));
	option_context = _tmp0_;
	_tmp1_ = option_context;
	g_option_context_add_main_entries (_tmp1_, options, "libskk");
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option_context;
		g_option_context_parse (_tmp2_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = 1;
		_g_error_free0 (e);
		_g_option_context_free0 (option_context);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option_context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	skk_init ();
	if (opt_list_typing_rules) {
		SkkRuleMetadata* rules = NULL;
		gint _tmp8_ = 0;
		SkkRuleMetadata* _tmp9_;
		gint rules_length1;
		gint _rules_size_;
		SkkRuleMetadata* _tmp10_;
		gint _tmp10__length1;
		_tmp9_ = skk_rule_list (&_tmp8_);
		rules = _tmp9_;
		rules_length1 = _tmp8_;
		_rules_size_ = rules_length1;
		_tmp10_ = rules;
		_tmp10__length1 = rules_length1;
		{
			SkkRuleMetadata* rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp10_;
			rule_collection_length1 = _tmp10__length1;
			for (rule_it = 0; rule_it < rule_collection_length1; rule_it = rule_it + 1) {
				SkkRuleMetadata _tmp11_;
				SkkRuleMetadata _tmp12_ = {0};
				SkkRuleMetadata rule = {0};
				_tmp11_ = rule_collection[rule_it];
				skk_rule_metadata_copy (&_tmp11_, &_tmp12_);
				rule = _tmp12_;
				{
					FILE* _tmp13_;
					SkkRuleMetadata _tmp14_;
					const gchar* _tmp15_;
					SkkRuleMetadata _tmp16_;
					const gchar* _tmp17_;
					SkkRuleMetadata _tmp18_;
					const gchar* _tmp19_;
					_tmp13_ = stdout;
					_tmp14_ = rule;
					_tmp15_ = _tmp14_.name;
					_tmp16_ = rule;
					_tmp17_ = _tmp16_.label;
					_tmp18_ = rule;
					_tmp19_ = _tmp18_.description;
					fprintf (_tmp13_, "%s - %s: %s\n", _tmp15_, _tmp17_, _tmp19_);
					skk_rule_metadata_destroy (&rule);
				}
			}
		}
		result = 0;
		rules = (_vala_SkkRuleMetadata_array_free (rules, rules_length1), NULL);
		_g_option_context_free0 (option_context);
		return result;
	}
	_tmp20_ = gee_array_list_new (SKK_TYPE_DICT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	dictionaries = _tmp20_;
	_tmp21_ = opt_user_dict;
	if (_tmp21_ != NULL) {
		{
			SkkUserDict* _tmp22_ = NULL;
			const gchar* _tmp23_;
			SkkUserDict* _tmp24_;
			GeeArrayList* _tmp25_;
			_tmp23_ = opt_user_dict;
			_tmp24_ = skk_user_dict_new (_tmp23_, "UTF-8", &_inner_error0_);
			_tmp22_ = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp25_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (SkkDict*) _tmp22_);
			_g_object_unref0 (_tmp22_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			const gchar* _tmp27_;
			GError* _tmp28_;
			const gchar* _tmp29_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = opt_user_dict;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			fprintf (_tmp26_, "can't open user dict %s: %s", _tmp27_, _tmp29_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp30_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp30_;
		}
	}
	_tmp31_ = opt_file_dict;
	if (_tmp31_ == NULL) {
		gchar* _tmp32_;
		_tmp32_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_file_dict);
		opt_file_dict = _tmp32_;
	}
	_tmp33_ = opt_file_dict;
	if (g_str_has_suffix (_tmp33_, ".cdb")) {
		{
			SkkCdbDict* _tmp34_ = NULL;
			const gchar* _tmp35_;
			SkkCdbDict* _tmp36_;
			GeeArrayList* _tmp37_;
			_tmp35_ = opt_file_dict;
			_tmp36_ = skk_cdb_dict_new (_tmp35_, "EUC-JP", &_inner_error0_);
			_tmp34_ = _tmp36_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
			_tmp37_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, (SkkDict*) _tmp34_);
			_g_object_unref0 (_tmp34_);
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			FILE* _tmp38_;
			const gchar* _tmp39_;
			GError* _tmp40_;
			const gchar* _tmp41_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp38_ = stderr;
			_tmp39_ = opt_file_dict;
			_tmp40_ = e;
			_tmp41_ = _tmp40_->message;
			fprintf (_tmp38_, "can't open CDB dict %s: %s", _tmp39_, _tmp41_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally2:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp42_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp42_;
		}
	} else {
		{
			SkkFileDict* _tmp43_ = NULL;
			const gchar* _tmp44_;
			SkkFileDict* _tmp45_;
			GeeArrayList* _tmp46_;
			_tmp44_ = opt_file_dict;
			_tmp45_ = skk_file_dict_new (_tmp44_, "EUC-JP", &_inner_error0_);
			_tmp43_ = _tmp45_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch3_g_error;
			}
			_tmp46_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp46_, (SkkDict*) _tmp43_);
			_g_object_unref0 (_tmp43_);
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			FILE* _tmp47_;
			const gchar* _tmp48_;
			GError* _tmp49_;
			const gchar* _tmp50_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp47_ = stderr;
			_tmp48_ = opt_file_dict;
			_tmp49_ = e;
			_tmp50_ = _tmp49_->message;
			fprintf (_tmp47_, "can't open file dict %s: %s", _tmp48_, _tmp50_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally3:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp51_ = -1;
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp51_;
		}
	}
	_tmp52_ = opt_skkserv;
	if (_tmp52_ != NULL) {
		gint index = 0;
		const gchar* _tmp53_;
		gchar* host = NULL;
		guint16 port = 0U;
		_tmp53_ = opt_skkserv;
		index = string_last_index_of (_tmp53_, ":", 0);
		if (index < 0) {
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp54_ = opt_skkserv;
			_tmp55_ = g_strdup (_tmp54_);
			_g_free0 (host);
			host = _tmp55_;
			port = (guint16) 1178;
		} else {
			const gchar* _tmp56_;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			_tmp56_ = opt_skkserv;
			_tmp57_ = string_slice (_tmp56_, (glong) 0, (glong) index);
			_g_free0 (host);
			host = _tmp57_;
			_tmp58_ = opt_skkserv;
			_tmp59_ = opt_skkserv;
			_tmp60_ = strlen (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = string_slice (_tmp58_, (glong) (index + 1), (glong) _tmp61_);
			_tmp63_ = _tmp62_;
			port = (guint16) atoi (_tmp63_);
			_g_free0 (_tmp63_);
		}
		{
			SkkSkkServ* _tmp64_ = NULL;
			const gchar* _tmp65_;
			SkkSkkServ* _tmp66_;
			GeeArrayList* _tmp67_;
			_tmp65_ = host;
			_tmp66_ = skk_skk_serv_new (_tmp65_, port, "EUC-JP", &_inner_error0_);
			_tmp64_ = _tmp66_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch4_g_error;
			}
			_tmp67_ = dictionaries;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, (SkkDict*) _tmp64_);
			_g_object_unref0 (_tmp64_);
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			FILE* _tmp68_;
			const gchar* _tmp69_;
			GError* _tmp70_;
			const gchar* _tmp71_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp68_ = stderr;
			_tmp69_ = host;
			_tmp70_ = e;
			_tmp71_ = _tmp70_->message;
			fprintf (_tmp68_, "can't connect to skkserv at %s:%d: %s", _tmp69_, (gint) port, _tmp71_);
			result = 1;
			_g_error_free0 (e);
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally4:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp72_ = -1;
			_g_free0 (host);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp72_;
		}
		_g_free0 (host);
	}
	_tmp73_ = dictionaries;
	_tmp75_ = gee_collection_to_array ((GeeCollection*) _tmp73_, &_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp76__length1 = _tmp74_;
	_tmp77_ = skk_context_new (_tmp76_, _tmp74_);
	_tmp78_ = _tmp77_;
	_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_object_unref), NULL);
	context = _tmp78_;
	_tmp79_ = opt_typing_rule;
	if (_tmp79_ != NULL) {
		{
			SkkRule* _tmp80_ = NULL;
			const gchar* _tmp81_;
			SkkRule* _tmp82_;
			SkkContext* _tmp84_;
			_tmp81_ = opt_typing_rule;
			_tmp82_ = skk_rule_new (_tmp81_, &_inner_error0_);
			_tmp80_ = _tmp82_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gint _tmp83_ = -1;
				if (_inner_error0_->domain == SKK_RULE_PARSE_ERROR) {
					goto __catch5_skk_rule_parse_error;
				}
				_g_object_unref0 (context);
				_g_object_unref0 (dictionaries);
				_g_option_context_free0 (option_context);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp83_;
			}
			_tmp84_ = context;
			skk_context_set_typing_rule (_tmp84_, _tmp80_);
			_g_object_unref0 (_tmp80_);
		}
		goto __finally5;
		__catch5_skk_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp85_;
			const gchar* _tmp86_;
			GError* _tmp87_;
			const gchar* _tmp88_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp85_ = stderr;
			_tmp86_ = opt_typing_rule;
			_tmp87_ = e;
			_tmp88_ = _tmp87_->message;
			fprintf (_tmp85_, "can't load rule \"%s\": %s\n", _tmp86_, _tmp88_);
			result = 1;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp89_ = -1;
			_g_object_unref0 (context);
			_g_object_unref0 (dictionaries);
			_g_option_context_free0 (option_context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp89_;
		}
	}
	_tmp90_ = context;
	_tmp91_ = repl_new (_tmp90_);
	repl = _tmp91_;
	_tmp92_ = repl;
	if (!repl_run (_tmp92_)) {
		result = 1;
		_g_object_unref0 (repl);
		_g_object_unref0 (context);
		_g_object_unref0 (dictionaries);
		_g_option_context_free0 (option_context);
		return result;
	}
	result = 0;
	_g_object_unref0 (repl);
	_g_object_unref0 (context);
	_g_object_unref0 (dictionaries);
	_g_option_context_free0 (option_context);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static inline gpointer
repl_get_instance_private (Repl* self)
{
	return G_STRUCT_MEMBER_P (self, Repl_private_offset);
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		GString* _tmp0_;
		GString* _tmp2_;
		c = fgetc (self);
		if (!(c != EOF)) {
			break;
		}
		_tmp0_ = ret;
		if (_tmp0_ == NULL) {
			GString* _tmp1_;
			_tmp1_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp1_;
		}
		if (c == ((gint) '\n')) {
			break;
		}
		_tmp2_ = ret;
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
	}
	_tmp3_ = ret;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = ret;
		_tmp5_ = ((GString*) _tmp4_)->str;
		((GString*) _tmp4_)->str = NULL;
		result = _tmp5_;
		_g_string_free0 (ret);
		return result;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

gboolean
repl_run (Repl* self)
{
	gchar* line = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	while (TRUE) {
		FILE* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		SkkContext* _tmp3_;
		const gchar* _tmp4_;
		gchar* output = NULL;
		SkkContext* _tmp5_;
		gchar* _tmp6_;
		gchar* preedit = NULL;
		SkkContext* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		FILE* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		SkkContext* _tmp21_;
		SkkContext* _tmp22_;
		_tmp0_ = stdin;
		_tmp1_ = g_file_stream_read_line (_tmp0_);
		_g_free0 (line);
		line = _tmp1_;
		_tmp2_ = line;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp3_ = self->priv->context;
		_tmp4_ = line;
		skk_context_process_key_events (_tmp3_, _tmp4_);
		_tmp5_ = self->priv->context;
		_tmp6_ = skk_context_poll_output (_tmp5_);
		output = _tmp6_;
		_tmp7_ = self->priv->context;
		_tmp8_ = skk_context_get_preedit (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		preedit = _tmp10_;
		_tmp11_ = stdout;
		_tmp12_ = line;
		_tmp13_ = string_replace (_tmp12_, "\"", "\\\"");
		_tmp14_ = _tmp13_;
		_tmp15_ = output;
		_tmp16_ = string_replace (_tmp15_, "\"", "\\\"");
		_tmp17_ = _tmp16_;
		_tmp18_ = preedit;
		_tmp19_ = string_replace (_tmp18_, "\"", "\\\"");
		_tmp20_ = _tmp19_;
		fprintf (_tmp11_, "{ \"input\": \"%s\", " "\"output\": \"%s\", " "\"preedit\": \"%s\" }\n", _tmp14_, _tmp17_, _tmp20_);
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp14_);
		_tmp21_ = self->priv->context;
		skk_context_reset (_tmp21_);
		_tmp22_ = self->priv->context;
		skk_context_clear_output (_tmp22_);
		_g_free0 (preedit);
		_g_free0 (output);
	}
	result = TRUE;
	_g_free0 (line);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Repl*
repl_construct (GType object_type,
                SkkContext* context)
{
	Repl * self = NULL;
	SkkContext* _tmp0_;
	g_return_val_if_fail (context != NULL, NULL);
	self = (Repl*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (context);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	return self;
}

Repl*
repl_new (SkkContext* context)
{
	return repl_construct (TYPE_REPL, context);
}

static void
repl_class_init (ReplClass * klass,
                 gpointer klass_data)
{
	repl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Repl_private_offset);
	G_OBJECT_CLASS (klass)->finalize = repl_finalize;
}

static void
repl_instance_init (Repl * self,
                    gpointer klass)
{
	self->priv = repl_get_instance_private (self);
}

static void
repl_finalize (GObject * obj)
{
	Repl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_REPL, Repl);
	_g_object_unref0 (self->priv->context);
	G_OBJECT_CLASS (repl_parent_class)->finalize (obj);
}

static GType
repl_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ReplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) repl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Repl), 0, (GInstanceInitFunc) repl_instance_init, NULL };
	GType repl_type_id;
	repl_type_id = g_type_register_static (G_TYPE_OBJECT, "Repl", &g_define_type_info, 0);
	Repl_private_offset = g_type_add_instance_private (repl_type_id, sizeof (ReplPrivate));
	return repl_type_id;
}

GType
repl_get_type (void)
{
	static volatile gsize repl_type_id__once = 0;
	if (g_once_init_enter (&repl_type_id__once)) {
		GType repl_type_id;
		repl_type_id = repl_get_type_once ();
		g_once_init_leave (&repl_type_id__once, repl_type_id);
	}
	return repl_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

