#ifndef LS_IDGENERATOR_H
#define LS_IDGENERATOR_H

#include <set>

namespace LinuxSampler {

/**
 * Generates unique numerical IDs starting from zero.
 *
 * @e Note: this class is not exported to the C++ API of the sampler!
 */
class IDGenerator {
public:
    /**
     * Constructor.
     *
     * @param simpleAlgorithm - if false, all created IDs which are still in
     *                          use will be remembered, if true then IDs are
     *                          simply generated by incrementing an int variable
     *                          by 1 until the whole int value range was used
     */
    IDGenerator(bool simpleAlgorithm = false);

    /**
     * Returns new unique positive ID of at least zero, a negative number if
     * no free ID could be generated.
     */
    int create();

    /**
     * Free the given ID, for being re-used in future.
     */
    void destroy(int id);

private:
    std::set<int> ids;
    int previousId;
    bool simple;
};

} // namespace LinuxSampler

#endif // LS_IDGENERATOR_H
