#pragma once

#include "data/Locale.h"
#include "scrapers/ScraperConfiguration.h"
#include "settings/Settings.h"
#include "utils/Meta.h"

namespace mediaelch {
namespace scraper {

class TmdbMovieConfiguration : public QObject, public ScraperConfiguration
{
    Q_OBJECT
public:
    explicit TmdbMovieConfiguration(Settings& settings, QObject* parent = nullptr);
    virtual ~TmdbMovieConfiguration() = default;

    void init() override;

    ELCH_NODISCARD static mediaelch::Locale defaultLocale();
    ELCH_NODISCARD static QVector<Locale> supportedLanguages();

signals:
    void languageChanged(mediaelch::Locale language);

public:
    ELCH_NODISCARD Locale language() override;
    void setLanguage(const Locale& value) override;
};

} // namespace scraper
} // namespace mediaelch
