/* Callout.c generated by valac 0.56.18, the Vala compiler
 * generated from Callout.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <libxml/tree.h>
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <granite.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CALLOUT_MODE_NONE = 0,
	CALLOUT_MODE_SELECTED,
	CALLOUT_MODE_EDITABLE,
	CALLOUT_MODE_HIDING,
	CALLOUT_MODE_HIDDEN
} CalloutMode;

#define TYPE_CALLOUT_MODE (callout_mode_get_type ())

#define TYPE_CALLOUT (callout_get_type ())
#define CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CALLOUT, Callout))
#define CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CALLOUT, CalloutClass))
#define IS_CALLOUT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CALLOUT))
#define IS_CALLOUT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CALLOUT))
#define CALLOUT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CALLOUT, CalloutClass))

typedef struct _Callout Callout;
typedef struct _CalloutClass CalloutClass;
typedef struct _CalloutPrivate CalloutPrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_STYLE (style_get_type ())
#define STYLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLE, Style))
#define STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLE, StyleClass))
#define IS_STYLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLE))
#define IS_STYLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLE))
#define STYLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLE, StyleClass))

typedef struct _Style Style;
typedef struct _StyleClass StyleClass;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;
enum  {
	CALLOUT_0_PROPERTY,
	CALLOUT_NODE_PROPERTY,
	CALLOUT_TEXT_PROPERTY,
	CALLOUT_TOTAL_WIDTH_PROPERTY,
	CALLOUT_TOTAL_HEIGHT_PROPERTY,
	CALLOUT_MODE_PROPERTY,
	CALLOUT_STYLE_PROPERTY,
	CALLOUT_ALPHA_PROPERTY,
	CALLOUT_NUM_PROPERTIES
};
static GParamSpec* callout_properties[CALLOUT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _style_unref0(var) ((var == NULL) ? NULL : (var = (style_unref (var), NULL)))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_TEXT_PARSER (text_parser_get_type ())
#define TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_PARSER, TextParser))
#define TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_PARSER, TextParserClass))
#define IS_TEXT_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_PARSER))
#define IS_TEXT_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_PARSER))
#define TEXT_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_PARSER, TextParserClass))

typedef struct _TextParser TextParser;
typedef struct _TextParserClass TextParserClass;

#define TYPE_MARKDOWN_PARSER (markdown_parser_get_type ())
#define MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKDOWN_PARSER, MarkdownParser))
#define MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKDOWN_PARSER, MarkdownParserClass))
#define IS_MARKDOWN_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKDOWN_PARSER))
#define IS_MARKDOWN_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKDOWN_PARSER))
#define MARKDOWN_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKDOWN_PARSER, MarkdownParserClass))

typedef struct _MarkdownParser MarkdownParser;
typedef struct _MarkdownParserClass MarkdownParserClass;

#define TYPE_URL_PARSER (url_parser_get_type ())
#define URL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_URL_PARSER, UrlParser))
#define URL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_URL_PARSER, UrlParserClass))
#define IS_URL_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_URL_PARSER))
#define IS_URL_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_URL_PARSER))
#define URL_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_URL_PARSER, UrlParserClass))

typedef struct _UrlParser UrlParser;
typedef struct _UrlParserClass UrlParserClass;

#define TYPE_UNICODE_PARSER (unicode_parser_get_type ())
#define UNICODE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_PARSER, UnicodeParser))
#define UNICODE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_PARSER, UnicodeParserClass))
#define IS_UNICODE_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_PARSER))
#define IS_UNICODE_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_PARSER))
#define UNICODE_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_PARSER, UnicodeParserClass))

typedef struct _UnicodeParser UnicodeParser;
typedef struct _UnicodeParserClass UnicodeParserClass;
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_STYLES (styles_get_type ())
#define STYLES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STYLES, Styles))
#define STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STYLES, StylesClass))
#define IS_STYLES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STYLES))
#define IS_STYLES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STYLES))
#define STYLES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STYLES, StylesClass))

typedef struct _Styles Styles;
typedef struct _StylesClass StylesClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
enum  {
	CALLOUT_RESIZED_SIGNAL,
	CALLOUT_NUM_SIGNALS
};
static guint callout_signals[CALLOUT_NUM_SIGNALS] = {0};

struct _Callout {
	GObject parent_instance;
	CalloutPrivate * priv;
};

struct _CalloutClass {
	GObjectClass parent_class;
};

struct _CalloutPrivate {
	Node* _node;
	Style* _style;
	CanvasText* _text;
	CalloutMode _mode;
	gdouble _alpha;
};

static gint Callout_private_offset;
static gpointer callout_parent_class = NULL;
VALA_EXTERN Styles* style_inspector_styles;

VALA_EXTERN GType callout_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean callout_mode_is_selected (CalloutMode self);
VALA_EXTERN gboolean callout_mode_is_disconnected (CalloutMode self);
VALA_EXTERN GType callout_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Callout, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN gpointer style_ref (gpointer instance);
VALA_EXTERN void style_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_style (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_style (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_style (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_style (const GValue* value);
VALA_EXTERN GType style_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Style, style_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN Callout* callout_new (Node* node);
VALA_EXTERN Callout* callout_construct (GType object_type,
                            Node* node);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* node_get_da (Node* self);
VALA_EXTERN CanvasText* canvas_text_new_with_text (DrawArea* da,
                                       const gchar* txt);
VALA_EXTERN CanvasText* canvas_text_construct_with_text (GType object_type,
                                             DrawArea* da,
                                             const gchar* txt);
static void callout_position_text_from_ct (Callout* self);
static void _callout_position_text_from_ct_canvas_text_resized (CanvasText* _sender,
                                                         gpointer self);
VALA_EXTERN Style* style_new (void);
VALA_EXTERN Style* style_construct (GType object_type);
VALA_EXTERN void callout_set_parsers (Callout* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN gpointer text_parser_ref (gpointer instance);
VALA_EXTERN void text_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_text_parser (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_text_parser (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_text_parser (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_text_parser (const GValue* value);
VALA_EXTERN GType text_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TextParser, text_parser_unref)
VALA_EXTERN void formatted_text_add_parser (FormattedText* self,
                                TextParser* parser);
VALA_EXTERN GType markdown_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MarkdownParser, text_parser_unref)
VALA_EXTERN MarkdownParser* draw_area_get_markdown_parser (DrawArea* self);
VALA_EXTERN GType url_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UrlParser, text_parser_unref)
VALA_EXTERN UrlParser* draw_area_get_url_parser (DrawArea* self);
VALA_EXTERN GType unicode_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeParser, text_parser_unref)
VALA_EXTERN UnicodeParser* draw_area_get_unicode_parser (DrawArea* self);
static gboolean callout_is_below_node (Callout* self);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN gboolean node_side_horizontal (NodeSide self);
VALA_EXTERN void callout_position_text (Callout* self,
                            gboolean call_resized);
VALA_EXTERN Style* node_get_style (Node* self);
VALA_EXTERN gint* style_get_node_margin (Style* self);
static gint* _int_dup (gint* self);
VALA_EXTERN Style* callout_get_style (Callout* self);
VALA_EXTERN gint* style_get_callout_padding (Style* self);
VALA_EXTERN gint* style_get_callout_ptr_length (Style* self);
VALA_EXTERN void node_node_bbox (Node* self,
                     gdouble* x,
                     gdouble* y,
                     gdouble* w,
                     gdouble* h);
VALA_EXTERN void canvas_text_set_posx (CanvasText* self,
                           gdouble value);
VALA_EXTERN void canvas_text_set_posy (CanvasText* self,
                           gdouble value);
VALA_EXTERN void callout_bbox (Callout* self,
                   gdouble* x,
                   gdouble* y,
                   gdouble* w,
                   gdouble* h);
VALA_EXTERN gdouble canvas_text_get_posx (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_posy (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_width (CanvasText* self);
VALA_EXTERN gdouble canvas_text_get_height (CanvasText* self);
static void callout_resizer_bbox (Callout* self,
                           gdouble* x,
                           gdouble* y,
                           gdouble* w,
                           gdouble* h);
VALA_EXTERN gboolean node_resizer_on_left (Node* self);
VALA_EXTERN gboolean callout_contains (Callout* self,
                           gdouble x,
                           gdouble y);
VALA_EXTERN gboolean utils_is_within_bounds (gdouble x,
                                 gdouble y,
                                 gdouble bx,
                                 gdouble by,
                                 gdouble bw,
                                 gdouble bh);
VALA_EXTERN gboolean callout_is_within_resizer (Callout* self,
                                    gdouble x,
                                    gdouble y);
VALA_EXTERN CalloutMode callout_get_mode (Callout* self);
VALA_EXTERN void callout_resize (Callout* self,
                     gdouble diff);
VALA_EXTERN void canvas_text_resize (CanvasText* self,
                         gdouble diff);
VALA_EXTERN xmlNode* callout_save (Callout* self);
VALA_EXTERN xmlNode* canvas_text_save (CanvasText* self,
                           const gchar* title);
VALA_EXTERN void style_save_callout (Style* self,
                         xmlNode* parent);
static void callout_load_style (Callout* self,
                         xmlNode* n);
VALA_EXTERN void style_load_node (Style* self,
                      xmlNode* node);
VALA_EXTERN void canvas_text_set_font (CanvasText* self,
                           const gchar* family,
                           gint* size,
                           gdouble zoom_factor);
VALA_EXTERN PangoFontDescription* style_get_callout_font (Style* self);
VALA_EXTERN void callout_load (Callout* self,
                   xmlNode* node);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN gboolean style_copy (Style* self,
                     Style* s);
VALA_EXTERN gpointer styles_ref (gpointer instance);
VALA_EXTERN void styles_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_styles (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_styles (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_styles (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_styles (const GValue* value);
VALA_EXTERN GType styles_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Styles, styles_unref)
VALA_EXTERN Style* styles_get_style_for_level (Styles* self,
                                   guint level,
                                   Style* alternative);
VALA_EXTERN void canvas_text_load (CanvasText* self,
                       xmlNode* n);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void callout_draw (Callout* self,
                   cairo_t* ctx,
                   Theme* theme,
                   gboolean exporting);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
VALA_EXTERN gint* style_get_callout_ptr_width (Style* self);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN gdouble callout_get_alpha (Callout* self);
VALA_EXTERN void utils_set_context_color (cairo_t* ctx,
                              GdkRGBA* color);
VALA_EXTERN void canvas_text_draw (CanvasText* self,
                       cairo_t* ctx,
                       Theme* theme,
                       GdkRGBA* fg,
                       gdouble alpha,
                       gboolean copy_layout);
VALA_EXTERN Node* callout_get_node (Callout* self);
VALA_EXTERN CanvasText* callout_get_text (Callout* self);
VALA_EXTERN gdouble callout_get_total_width (Callout* self);
VALA_EXTERN gdouble callout_get_total_height (Callout* self);
VALA_EXTERN void callout_set_mode (Callout* self,
                       CalloutMode value);
VALA_EXTERN void canvas_text_set_edit (CanvasText* self,
                           gboolean value);
VALA_EXTERN void canvas_text_set_cursor_all (CanvasText* self,
                                 gboolean motion);
VALA_EXTERN void canvas_text_clear_selection (CanvasText* self,
                                  const gchar* msg);
VALA_EXTERN void callout_set_style (Callout* self,
                        Style* value);
VALA_EXTERN gint* style_get_node_width (Style* self);
VALA_EXTERN void canvas_text_set_max_width (CanvasText* self,
                                gdouble value);
VALA_EXTERN void callout_set_alpha (Callout* self,
                        gdouble value);
static void callout_finalize (GObject * obj);
static GType callout_get_type_once (void);
static void _vala_callout_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec);
static void _vala_callout_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec);

gboolean
callout_mode_is_selected (CalloutMode self)
{
	gboolean result;
	result = self == CALLOUT_MODE_SELECTED;
	return result;
}

gboolean
callout_mode_is_disconnected (CalloutMode self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if (self == CALLOUT_MODE_HIDING) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self == CALLOUT_MODE_HIDDEN;
	}
	result = _tmp0_;
	return result;
}

static GType
callout_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{CALLOUT_MODE_NONE, "CALLOUT_MODE_NONE", "none"}, {CALLOUT_MODE_SELECTED, "CALLOUT_MODE_SELECTED", "selected"}, {CALLOUT_MODE_EDITABLE, "CALLOUT_MODE_EDITABLE", "editable"}, {CALLOUT_MODE_HIDING, "CALLOUT_MODE_HIDING", "hiding"}, {CALLOUT_MODE_HIDDEN, "CALLOUT_MODE_HIDDEN", "hidden"}, {0, NULL, NULL}};
	GType callout_mode_type_id;
	callout_mode_type_id = g_enum_register_static ("CalloutMode", values);
	return callout_mode_type_id;
}

GType
callout_mode_get_type (void)
{
	static volatile gsize callout_mode_type_id__once = 0;
	if (g_once_init_enter (&callout_mode_type_id__once)) {
		GType callout_mode_type_id;
		callout_mode_type_id = callout_mode_get_type_once ();
		g_once_init_leave (&callout_mode_type_id__once, callout_mode_type_id);
	}
	return callout_mode_type_id__once;
}

static inline gpointer
callout_get_instance_private (Callout* self)
{
	return G_STRUCT_MEMBER_P (self, Callout_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_callout_position_text_from_ct_canvas_text_resized (CanvasText* _sender,
                                                    gpointer self)
{
	callout_position_text_from_ct ((Callout*) self);
}

Callout*
callout_construct (GType object_type,
                   Node* node)
{
	Callout * self = NULL;
	Node* _tmp0_;
	DrawArea* _tmp1_;
	DrawArea* _tmp2_;
	CanvasText* _tmp3_;
	CanvasText* _tmp4_;
	Style* _tmp5_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (Callout*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (node);
	_g_object_unref0 (self->priv->_node);
	self->priv->_node = _tmp0_;
	_tmp1_ = node_get_da (node);
	_tmp2_ = _tmp1_;
	_tmp3_ = canvas_text_new_with_text (_tmp2_, _ ("Callout"));
	_g_object_unref0 (self->priv->_text);
	self->priv->_text = _tmp3_;
	_tmp4_ = self->priv->_text;
	g_signal_connect_object (_tmp4_, "resized", (GCallback) _callout_position_text_from_ct_canvas_text_resized, self, 0);
	_tmp5_ = style_new ();
	_style_unref0 (self->priv->_style);
	self->priv->_style = _tmp5_;
	callout_set_parsers (self);
	return self;
}

Callout*
callout_new (Node* node)
{
	return callout_construct (TYPE_CALLOUT, node);
}

void
callout_set_parsers (Callout* self)
{
	CanvasText* _tmp0_;
	FormattedText* _tmp1_;
	FormattedText* _tmp2_;
	Node* _tmp3_;
	DrawArea* _tmp4_;
	DrawArea* _tmp5_;
	MarkdownParser* _tmp6_;
	MarkdownParser* _tmp7_;
	CanvasText* _tmp8_;
	FormattedText* _tmp9_;
	FormattedText* _tmp10_;
	Node* _tmp11_;
	DrawArea* _tmp12_;
	DrawArea* _tmp13_;
	UrlParser* _tmp14_;
	UrlParser* _tmp15_;
	CanvasText* _tmp16_;
	FormattedText* _tmp17_;
	FormattedText* _tmp18_;
	Node* _tmp19_;
	DrawArea* _tmp20_;
	DrawArea* _tmp21_;
	UnicodeParser* _tmp22_;
	UnicodeParser* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_text;
	_tmp1_ = canvas_text_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_node;
	_tmp4_ = node_get_da (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = draw_area_get_markdown_parser (_tmp5_);
	_tmp7_ = _tmp6_;
	formatted_text_add_parser (_tmp2_, (TextParser*) _tmp7_);
	_tmp8_ = self->priv->_text;
	_tmp9_ = canvas_text_get_text (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_node;
	_tmp12_ = node_get_da (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = draw_area_get_url_parser (_tmp13_);
	_tmp15_ = _tmp14_;
	formatted_text_add_parser (_tmp10_, (TextParser*) _tmp15_);
	_tmp16_ = self->priv->_text;
	_tmp17_ = canvas_text_get_text (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_node;
	_tmp20_ = node_get_da (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = draw_area_get_unicode_parser (_tmp21_);
	_tmp23_ = _tmp22_;
	formatted_text_add_parser (_tmp18_, (TextParser*) _tmp23_);
}

static gboolean
callout_is_below_node (Callout* self)
{
	Node* _tmp0_;
	NodeSide _tmp1_;
	NodeSide _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_node;
	_tmp1_ = node_get_side (_tmp0_);
	_tmp2_ = _tmp1_;
	result = node_side_horizontal (_tmp2_);
	return result;
}

static void
callout_position_text_from_ct (Callout* self)
{
	g_return_if_fail (self != NULL);
	callout_position_text (self, TRUE);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

void
callout_position_text (Callout* self,
                       gboolean call_resized)
{
	gint* _tmp0_ = NULL;
	Node* _tmp1_;
	Style* _tmp2_;
	Style* _tmp3_;
	gint* _tmp4_;
	gint* _tmp5_;
	gint* _tmp6_;
	gint* margin = NULL;
	gint* _tmp9_;
	gint* _tmp10_ = NULL;
	Style* _tmp11_;
	Style* _tmp12_;
	gint* _tmp13_;
	gint* _tmp14_;
	gint* _tmp15_;
	gint* padding = NULL;
	gint* _tmp18_;
	gint* _tmp19_ = NULL;
	Style* _tmp20_;
	Style* _tmp21_;
	gint* _tmp22_;
	gint* _tmp23_;
	gint* _tmp24_;
	gint* plength = NULL;
	gint* _tmp27_;
	gdouble nx = 0.0;
	gdouble ny = 0.0;
	gdouble nw = 0.0;
	gdouble nh = 0.0;
	Node* _tmp28_;
	gdouble _tmp29_ = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_node;
	_tmp2_ = node_get_style (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = style_get_node_margin (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = __int_dup0 (_tmp5_);
	_tmp0_ = _tmp6_;
	if (_tmp0_ == NULL) {
		gint _tmp7_;
		gint* _tmp8_;
		_tmp7_ = 0;
		_tmp8_ = __int_dup0 (&_tmp7_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _tmp0_;
	_tmp0_ = NULL;
	margin = _tmp9_;
	_tmp11_ = callout_get_style (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = style_get_callout_padding (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = __int_dup0 (_tmp14_);
	_tmp10_ = _tmp15_;
	if (_tmp10_ == NULL) {
		gint _tmp16_;
		gint* _tmp17_;
		_tmp16_ = 0;
		_tmp17_ = __int_dup0 (&_tmp16_);
		_g_free0 (_tmp10_);
		_tmp10_ = _tmp17_;
	}
	_tmp18_ = _tmp10_;
	_tmp10_ = NULL;
	padding = _tmp18_;
	_tmp20_ = callout_get_style (self);
	_tmp21_ = _tmp20_;
	_tmp22_ = style_get_callout_ptr_length (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = __int_dup0 (_tmp23_);
	_tmp19_ = _tmp24_;
	if (_tmp19_ == NULL) {
		gint _tmp25_;
		gint* _tmp26_;
		_tmp25_ = 0;
		_tmp26_ = __int_dup0 (&_tmp25_);
		_g_free0 (_tmp19_);
		_tmp19_ = _tmp26_;
	}
	_tmp27_ = _tmp19_;
	_tmp19_ = NULL;
	plength = _tmp27_;
	_tmp28_ = self->priv->_node;
	node_node_bbox (_tmp28_, &_tmp29_, &_tmp30_, &_tmp31_, &_tmp32_);
	nx = _tmp29_;
	ny = _tmp30_;
	nw = _tmp31_;
	nh = _tmp32_;
	if (callout_is_below_node (self)) {
		CanvasText* _tmp33_;
		gint* _tmp34_;
		gint* _tmp35_;
		CanvasText* _tmp36_;
		gint* _tmp37_;
		gint* _tmp38_;
		gint* _tmp39_;
		_tmp33_ = self->priv->_text;
		_tmp34_ = margin;
		_tmp35_ = padding;
		canvas_text_set_posx (_tmp33_, (nx + (*_tmp34_)) + (*_tmp35_));
		_tmp36_ = self->priv->_text;
		_tmp37_ = margin;
		_tmp38_ = plength;
		_tmp39_ = padding;
		canvas_text_set_posy (_tmp36_, ((ny + nh) - (*_tmp37_)) + ((*_tmp38_) + (*_tmp39_)));
	} else {
		CanvasText* _tmp40_;
		gint* _tmp41_;
		gint* _tmp42_;
		gint* _tmp43_;
		CanvasText* _tmp44_;
		gint* _tmp45_;
		gint* _tmp46_;
		_tmp40_ = self->priv->_text;
		_tmp41_ = margin;
		_tmp42_ = plength;
		_tmp43_ = padding;
		canvas_text_set_posx (_tmp40_, ((nx + nw) - (*_tmp41_)) + ((*_tmp42_) + (*_tmp43_)));
		_tmp44_ = self->priv->_text;
		_tmp45_ = margin;
		_tmp46_ = padding;
		canvas_text_set_posy (_tmp44_, (ny + (*_tmp45_)) + (*_tmp46_));
	}
	if (call_resized) {
		g_signal_emit (self, callout_signals[CALLOUT_RESIZED_SIGNAL], 0);
	}
	_g_free0 (plength);
	_g_free0 (_tmp19_);
	_g_free0 (padding);
	_g_free0 (_tmp10_);
	_g_free0 (margin);
	_g_free0 (_tmp0_);
}

void
callout_bbox (Callout* self,
              gdouble* x,
              gdouble* y,
              gdouble* w,
              gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gint* _tmp0_ = NULL;
	Style* _tmp1_;
	Style* _tmp2_;
	gint* _tmp3_;
	gint* _tmp4_;
	gint* _tmp5_;
	gint* padding = NULL;
	gint* _tmp8_;
	CanvasText* _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	CanvasText* _tmp12_;
	gdouble _tmp13_;
	gdouble _tmp14_;
	CanvasText* _tmp15_;
	gdouble _tmp16_;
	gdouble _tmp17_;
	CanvasText* _tmp18_;
	gdouble _tmp19_;
	gdouble _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp1_ = callout_get_style (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = style_get_callout_padding (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = __int_dup0 (_tmp4_);
	_tmp0_ = _tmp5_;
	if (_tmp0_ == NULL) {
		gint _tmp6_;
		gint* _tmp7_;
		_tmp6_ = 0;
		_tmp7_ = __int_dup0 (&_tmp6_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	_tmp0_ = NULL;
	padding = _tmp8_;
	_tmp9_ = self->priv->_text;
	_tmp10_ = canvas_text_get_posx (_tmp9_);
	_tmp11_ = _tmp10_;
	_vala_x = _tmp11_ - (*padding);
	_tmp12_ = self->priv->_text;
	_tmp13_ = canvas_text_get_posy (_tmp12_);
	_tmp14_ = _tmp13_;
	_vala_y = _tmp14_ - (*padding);
	_tmp15_ = self->priv->_text;
	_tmp16_ = canvas_text_get_width (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_w = _tmp17_ + ((*padding) * 2);
	_tmp18_ = self->priv->_text;
	_tmp19_ = canvas_text_get_height (_tmp18_);
	_tmp20_ = _tmp19_;
	_vala_h = _tmp20_ + ((*padding) * 2);
	_g_free0 (padding);
	_g_free0 (_tmp0_);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

static void
callout_resizer_bbox (Callout* self,
                      gdouble* x,
                      gdouble* y,
                      gdouble* w,
                      gdouble* h)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_w = 0.0;
	gdouble _vala_h = 0.0;
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble cw = 0.0;
	gdouble ch = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	Node* _tmp5_;
	g_return_if_fail (self != NULL);
	callout_bbox (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	cx = _tmp0_;
	cy = _tmp1_;
	cw = _tmp2_;
	ch = _tmp3_;
	_tmp5_ = self->priv->_node;
	if (node_resizer_on_left (_tmp5_)) {
		_tmp4_ = cx;
	} else {
		_tmp4_ = (cx + cw) - 8;
	}
	_vala_x = _tmp4_;
	_vala_y = cy;
	_vala_w = (gdouble) 8;
	_vala_h = (gdouble) 8;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (w) {
		*w = _vala_w;
	}
	if (h) {
		*h = _vala_h;
	}
}

gboolean
callout_contains (Callout* self,
                  gdouble x,
                  gdouble y)
{
	gdouble cx = 0.0;
	gdouble cy = 0.0;
	gdouble cw = 0.0;
	gdouble ch = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	callout_bbox (self, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_);
	cx = _tmp0_;
	cy = _tmp1_;
	cw = _tmp2_;
	ch = _tmp3_;
	result = utils_is_within_bounds (x, y, cx, cy, cw, ch);
	return result;
}

gboolean
callout_is_within_resizer (Callout* self,
                           gdouble x,
                           gdouble y)
{
	CalloutMode _tmp0_;
	CalloutMode _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = callout_get_mode (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == CALLOUT_MODE_SELECTED) {
		gdouble rx = 0.0;
		gdouble ry = 0.0;
		gdouble rw = 0.0;
		gdouble rh = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		callout_resizer_bbox (self, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_);
		rx = _tmp2_;
		ry = _tmp3_;
		rw = _tmp4_;
		rh = _tmp5_;
		result = utils_is_within_bounds (x, y, rx, ry, rw, rh);
		return result;
	}
	result = FALSE;
	return result;
}

void
callout_resize (Callout* self,
                gdouble diff)
{
	gdouble _tmp0_ = 0.0;
	Node* _tmp1_;
	CanvasText* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_node;
	if (node_resizer_on_left (_tmp1_)) {
		_tmp0_ = 0 - diff;
	} else {
		_tmp0_ = diff;
	}
	diff = _tmp0_;
	_tmp2_ = self->priv->_text;
	canvas_text_resize (_tmp2_, diff);
}

xmlNode*
callout_save (Callout* self)
{
	xmlNode* node = NULL;
	xmlNode* _tmp0_;
	CanvasText* _tmp1_;
	xmlNode* _tmp2_;
	Style* _tmp3_;
	Style* _tmp4_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "callout");
	node = _tmp0_;
	_tmp1_ = self->priv->_text;
	_tmp2_ = canvas_text_save (_tmp1_, "text");
	xmlAddChild (node, _tmp2_);
	_tmp3_ = callout_get_style (self);
	_tmp4_ = _tmp3_;
	style_save_callout (_tmp4_, node);
	result = node;
	return result;
}

static void
callout_load_style (Callout* self,
                    xmlNode* n)
{
	Style* _tmp0_;
	CanvasText* _tmp1_;
	Style* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	const gchar* _tmp5_;
	Style* _tmp6_;
	PangoFontDescription* _tmp7_;
	PangoFontDescription* _tmp8_;
	gint _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_style;
	style_load_node (_tmp0_, n);
	_tmp1_ = self->priv->_text;
	_tmp2_ = self->priv->_style;
	_tmp3_ = style_get_callout_font (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = pango_font_description_get_family (_tmp4_);
	_tmp6_ = self->priv->_style;
	_tmp7_ = style_get_callout_font (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = pango_font_description_get_size (_tmp8_) / PANGO_SCALE;
	canvas_text_set_font (_tmp1_, _tmp5_, &_tmp9_, 1.0);
}

void
callout_load (Callout* self,
              xmlNode* node)
{
	gint _tmp0_ = 0;
	Node* _tmp1_;
	Style* _tmp2_;
	Styles* _tmp3_;
	Style* _tmp4_;
	Style* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_node;
	if (node_is_root (_tmp1_)) {
		_tmp0_ = 0;
	} else {
		_tmp0_ = 1;
	}
	_tmp2_ = self->priv->_style;
	_tmp3_ = style_inspector_styles;
	_tmp4_ = styles_get_style_for_level (_tmp3_, (guint) _tmp0_, NULL);
	_tmp5_ = _tmp4_;
	style_copy (_tmp2_, _tmp5_);
	_style_unref0 (_tmp5_);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp6_;
		_tmp6_ = node->children;
		it = _tmp6_;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp10_;
				xmlNode* _tmp11_;
				if (!_tmp7_) {
					xmlNode* _tmp8_;
					xmlNode* _tmp9_;
					_tmp8_ = it;
					_tmp9_ = _tmp8_->next;
					it = _tmp9_;
				}
				_tmp7_ = FALSE;
				_tmp10_ = it;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = it;
				if (_tmp11_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					GQuark _tmp16_ = 0U;
					static GQuark _tmp15_label0 = 0;
					static GQuark _tmp15_label1 = 0;
					_tmp12_ = it;
					_tmp13_ = _tmp12_->name;
					_tmp14_ = _tmp13_;
					_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
					if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("text")))) {
						switch (0) {
							default:
							{
								CanvasText* _tmp17_;
								xmlNode* _tmp18_;
								_tmp17_ = self->priv->_text;
								_tmp18_ = it;
								canvas_text_load (_tmp17_, _tmp18_);
								break;
							}
						}
					} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("style")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp19_;
								_tmp19_ = it;
								callout_load_style (self, _tmp19_);
								break;
							}
						}
					}
				}
			}
		}
	}
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
callout_draw (Callout* self,
              cairo_t* ctx,
              Theme* theme,
              gboolean exporting)
{
	GdkRGBA* background = NULL;
	GdkRGBA* _tmp0_;
	GdkRGBA foreground = {0};
	GdkRGBA* _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_ = {0};
	gint* _tmp4_ = NULL;
	Style* _tmp5_;
	Style* _tmp6_;
	gint* _tmp7_;
	gint* _tmp8_;
	gint* _tmp9_;
	gint* pwidth = NULL;
	gint* _tmp12_;
	gint* _tmp13_ = NULL;
	Style* _tmp14_;
	Style* _tmp15_;
	gint* _tmp16_;
	gint* _tmp17_;
	gint* _tmp18_;
	gint* plength = NULL;
	gint* _tmp21_;
	gint* _tmp22_ = NULL;
	Style* _tmp23_;
	Style* _tmp24_;
	gint* _tmp25_;
	gint* _tmp26_;
	gint* _tmp27_;
	gint* padding = NULL;
	gint* _tmp30_;
	gboolean _tmp31_ = FALSE;
	CalloutMode _tmp32_;
	CalloutMode _tmp33_;
	GdkRGBA* _tmp37_;
	gdouble _tmp38_;
	GdkRGBA _tmp39_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble w = 0.0;
	gdouble h = 0.0;
	gdouble _tmp40_ = 0.0;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gint* _tmp44_;
	gboolean _tmp57_ = FALSE;
	CalloutMode _tmp58_;
	CalloutMode _tmp59_;
	CanvasText* _tmp71_;
	GdkRGBA _tmp72_;
	gdouble _tmp73_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	if (self->priv->_mode == CALLOUT_MODE_HIDDEN) {
		return;
	}
	_tmp0_ = theme_get_color (theme, "callout_background");
	background = _tmp0_;
	_tmp1_ = background;
	_tmp2_ = *_tmp1_;
	granite_contrasting_foreground_color (&_tmp2_, &_tmp3_);
	foreground = _tmp3_;
	_tmp5_ = callout_get_style (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = style_get_callout_ptr_width (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = __int_dup0 (_tmp8_);
	_tmp4_ = _tmp9_;
	if (_tmp4_ == NULL) {
		gint _tmp10_;
		gint* _tmp11_;
		_tmp10_ = 0;
		_tmp11_ = __int_dup0 (&_tmp10_);
		_g_free0 (_tmp4_);
		_tmp4_ = _tmp11_;
	}
	_tmp12_ = _tmp4_;
	_tmp4_ = NULL;
	pwidth = _tmp12_;
	_tmp14_ = callout_get_style (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = style_get_callout_ptr_length (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = __int_dup0 (_tmp17_);
	_tmp13_ = _tmp18_;
	if (_tmp13_ == NULL) {
		gint _tmp19_;
		gint* _tmp20_;
		_tmp19_ = 0;
		_tmp20_ = __int_dup0 (&_tmp19_);
		_g_free0 (_tmp13_);
		_tmp13_ = _tmp20_;
	}
	_tmp21_ = _tmp13_;
	_tmp13_ = NULL;
	plength = _tmp21_;
	_tmp23_ = callout_get_style (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = style_get_callout_padding (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = __int_dup0 (_tmp26_);
	_tmp22_ = _tmp27_;
	if (_tmp22_ == NULL) {
		gint _tmp28_;
		gint* _tmp29_;
		_tmp28_ = 0;
		_tmp29_ = __int_dup0 (&_tmp28_);
		_g_free0 (_tmp22_);
		_tmp22_ = _tmp29_;
	}
	_tmp30_ = _tmp22_;
	_tmp22_ = NULL;
	padding = _tmp30_;
	_tmp32_ = callout_get_mode (self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == CALLOUT_MODE_SELECTED) {
		_tmp31_ = !exporting;
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		GdkRGBA* _tmp34_;
		GdkRGBA* _tmp35_;
		GdkRGBA* _tmp36_;
		_tmp34_ = theme_get_color (theme, "nodesel_background");
		__vala_GdkRGBA_free0 (background);
		background = _tmp34_;
		_tmp35_ = theme_get_color (theme, "nodesel_foreground");
		_tmp36_ = _tmp35_;
		foreground = *_tmp36_;
		__vala_GdkRGBA_free0 (_tmp36_);
	}
	_tmp37_ = background;
	_tmp38_ = self->priv->_alpha;
	_tmp39_ = *_tmp37_;
	utils_set_context_color_with_alpha (ctx, &_tmp39_, _tmp38_);
	cairo_set_line_width (ctx, (gdouble) 1);
	callout_bbox (self, &_tmp40_, &_tmp41_, &_tmp42_, &_tmp43_);
	x = _tmp40_;
	y = _tmp41_;
	w = _tmp42_;
	h = _tmp43_;
	_tmp44_ = padding;
	granite_drawing_utilities_cairo_rounded_rectangle (ctx, x, y, w, h, *_tmp44_);
	cairo_fill (ctx);
	if (callout_is_below_node (self)) {
		gdouble _tmp45_;
		gint* _tmp46_;
		gint* _tmp47_;
		gint* _tmp48_;
		gint* _tmp49_;
		gint* _tmp50_;
		_tmp45_ = y;
		y = _tmp45_ + 1;
		_tmp46_ = padding;
		cairo_move_to (ctx, x + (*_tmp46_), y);
		_tmp47_ = padding;
		_tmp48_ = plength;
		cairo_line_to (ctx, x + (*_tmp47_), y - (*_tmp48_));
		_tmp49_ = padding;
		_tmp50_ = pwidth;
		cairo_line_to (ctx, (x + (*_tmp49_)) + (*_tmp50_), y);
	} else {
		gdouble _tmp51_;
		gint* _tmp52_;
		gint* _tmp53_;
		gint* _tmp54_;
		gint* _tmp55_;
		gint* _tmp56_;
		_tmp51_ = x;
		x = _tmp51_ + 1;
		_tmp52_ = padding;
		cairo_move_to (ctx, x, y + (*_tmp52_));
		_tmp53_ = plength;
		_tmp54_ = padding;
		cairo_line_to (ctx, x - (*_tmp53_), y + (*_tmp54_));
		_tmp55_ = padding;
		_tmp56_ = pwidth;
		cairo_line_to (ctx, x, (y + (*_tmp55_)) + (*_tmp56_));
	}
	cairo_close_path (ctx);
	cairo_fill (ctx);
	_tmp58_ = callout_get_mode (self);
	_tmp59_ = _tmp58_;
	if (_tmp59_ == CALLOUT_MODE_SELECTED) {
		_tmp57_ = !exporting;
	} else {
		_tmp57_ = FALSE;
	}
	if (_tmp57_) {
		gdouble _tmp60_ = 0.0;
		gdouble _tmp61_ = 0.0;
		gdouble _tmp62_ = 0.0;
		gdouble _tmp63_ = 0.0;
		GdkRGBA* _tmp64_;
		GdkRGBA* _tmp65_;
		GdkRGBA _tmp66_;
		GdkRGBA* _tmp67_;
		GdkRGBA* _tmp68_;
		gdouble _tmp69_;
		GdkRGBA _tmp70_;
		callout_resizer_bbox (self, &_tmp60_, &_tmp61_, &_tmp62_, &_tmp63_);
		x = _tmp60_;
		y = _tmp61_;
		w = _tmp62_;
		h = _tmp63_;
		_tmp64_ = theme_get_color (theme, "background");
		_tmp65_ = _tmp64_;
		_tmp66_ = *_tmp65_;
		utils_set_context_color (ctx, &_tmp66_);
		__vala_GdkRGBA_free0 (_tmp65_);
		cairo_set_line_width (ctx, (gdouble) 1);
		cairo_rectangle (ctx, x, y, w, h);
		cairo_fill_preserve (ctx);
		_tmp67_ = theme_get_color (theme, "foreground");
		_tmp68_ = _tmp67_;
		_tmp69_ = self->priv->_alpha;
		_tmp70_ = *_tmp68_;
		utils_set_context_color_with_alpha (ctx, &_tmp70_, _tmp69_);
		__vala_GdkRGBA_free0 (_tmp68_);
		cairo_stroke (ctx);
	}
	_tmp71_ = self->priv->_text;
	_tmp72_ = foreground;
	_tmp73_ = self->priv->_alpha;
	canvas_text_draw (_tmp71_, ctx, theme, &_tmp72_, _tmp73_, exporting);
	_g_free0 (padding);
	_g_free0 (_tmp22_);
	_g_free0 (plength);
	_g_free0 (_tmp13_);
	_g_free0 (pwidth);
	_g_free0 (_tmp4_);
	__vala_GdkRGBA_free0 (background);
}

Node*
callout_get_node (Callout* self)
{
	Node* result;
	Node* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_node;
	result = _tmp0_;
	return result;
}

CanvasText*
callout_get_text (Callout* self)
{
	CanvasText* result;
	CanvasText* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text;
	result = _tmp0_;
	return result;
}

gdouble
callout_get_total_width (Callout* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (callout_mode_is_disconnected (self->priv->_mode)) {
		result = (gdouble) 0;
		return result;
	} else {
		gint* _tmp0_ = NULL;
		Style* _tmp1_;
		gint* _tmp2_;
		gint* _tmp3_;
		gint* _tmp4_;
		gint* padding = NULL;
		gint* _tmp7_;
		gint* _tmp8_ = NULL;
		Style* _tmp9_;
		gint* _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		gint* plength = NULL;
		gint* _tmp15_;
		_tmp1_ = self->priv->_style;
		_tmp2_ = style_get_callout_padding (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __int_dup0 (_tmp3_);
		_tmp0_ = _tmp4_;
		if (_tmp0_ == NULL) {
			gint _tmp5_;
			gint* _tmp6_;
			_tmp5_ = 0;
			_tmp6_ = __int_dup0 (&_tmp5_);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp6_;
		}
		_tmp7_ = _tmp0_;
		_tmp0_ = NULL;
		padding = _tmp7_;
		_tmp9_ = self->priv->_style;
		_tmp10_ = style_get_callout_ptr_length (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = __int_dup0 (_tmp11_);
		_tmp8_ = _tmp12_;
		if (_tmp8_ == NULL) {
			gint _tmp13_;
			gint* _tmp14_;
			_tmp13_ = 0;
			_tmp14_ = __int_dup0 (&_tmp13_);
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		_tmp8_ = NULL;
		plength = _tmp15_;
		if (callout_is_below_node (self)) {
			CanvasText* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			gint* _tmp19_;
			_tmp16_ = self->priv->_text;
			_tmp17_ = canvas_text_get_width (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = padding;
			result = _tmp18_ + ((*_tmp19_) * 2);
			_g_free0 (plength);
			_g_free0 (_tmp8_);
			_g_free0 (padding);
			_g_free0 (_tmp0_);
			return result;
		} else {
			CanvasText* _tmp20_;
			gdouble _tmp21_;
			gdouble _tmp22_;
			gint* _tmp23_;
			gint* _tmp24_;
			_tmp20_ = self->priv->_text;
			_tmp21_ = canvas_text_get_width (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = padding;
			_tmp24_ = plength;
			result = (_tmp22_ + ((*_tmp23_) * 2)) + (*_tmp24_);
			_g_free0 (plength);
			_g_free0 (_tmp8_);
			_g_free0 (padding);
			_g_free0 (_tmp0_);
			return result;
		}
		_g_free0 (plength);
		_g_free0 (_tmp8_);
		_g_free0 (padding);
		_g_free0 (_tmp0_);
	}
}

gdouble
callout_get_total_height (Callout* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	if (callout_mode_is_disconnected (self->priv->_mode)) {
		result = (gdouble) 0;
		return result;
	} else {
		gint* _tmp0_ = NULL;
		Style* _tmp1_;
		gint* _tmp2_;
		gint* _tmp3_;
		gint* _tmp4_;
		gint* padding = NULL;
		gint* _tmp7_;
		gint* _tmp8_ = NULL;
		Style* _tmp9_;
		gint* _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
		gint* plength = NULL;
		gint* _tmp15_;
		_tmp1_ = self->priv->_style;
		_tmp2_ = style_get_callout_padding (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __int_dup0 (_tmp3_);
		_tmp0_ = _tmp4_;
		if (_tmp0_ == NULL) {
			gint _tmp5_;
			gint* _tmp6_;
			_tmp5_ = 0;
			_tmp6_ = __int_dup0 (&_tmp5_);
			_g_free0 (_tmp0_);
			_tmp0_ = _tmp6_;
		}
		_tmp7_ = _tmp0_;
		_tmp0_ = NULL;
		padding = _tmp7_;
		_tmp9_ = self->priv->_style;
		_tmp10_ = style_get_callout_ptr_length (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = __int_dup0 (_tmp11_);
		_tmp8_ = _tmp12_;
		if (_tmp8_ == NULL) {
			gint _tmp13_;
			gint* _tmp14_;
			_tmp13_ = 0;
			_tmp14_ = __int_dup0 (&_tmp13_);
			_g_free0 (_tmp8_);
			_tmp8_ = _tmp14_;
		}
		_tmp15_ = _tmp8_;
		_tmp8_ = NULL;
		plength = _tmp15_;
		if (callout_is_below_node (self)) {
			CanvasText* _tmp16_;
			gdouble _tmp17_;
			gdouble _tmp18_;
			gint* _tmp19_;
			gint* _tmp20_;
			_tmp16_ = self->priv->_text;
			_tmp17_ = canvas_text_get_height (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = padding;
			_tmp20_ = plength;
			result = (_tmp18_ + ((*_tmp19_) * 2)) + (*_tmp20_);
			_g_free0 (plength);
			_g_free0 (_tmp8_);
			_g_free0 (padding);
			_g_free0 (_tmp0_);
			return result;
		} else {
			CanvasText* _tmp21_;
			gdouble _tmp22_;
			gdouble _tmp23_;
			gint* _tmp24_;
			_tmp21_ = self->priv->_text;
			_tmp22_ = canvas_text_get_height (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = padding;
			result = _tmp23_ + ((*_tmp24_) * 2);
			_g_free0 (plength);
			_g_free0 (_tmp8_);
			_g_free0 (padding);
			_g_free0 (_tmp0_);
			return result;
		}
		_g_free0 (plength);
		_g_free0 (_tmp8_);
		_g_free0 (padding);
		_g_free0 (_tmp0_);
	}
}

CalloutMode
callout_get_mode (Callout* self)
{
	CalloutMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
callout_set_mode (Callout* self,
                  CalloutMode value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_mode != value) {
		CalloutMode orig_mode = 0;
		gboolean _tmp4_ = FALSE;
		orig_mode = self->priv->_mode;
		self->priv->_mode = value;
		if (self->priv->_mode == CALLOUT_MODE_EDITABLE) {
			CanvasText* _tmp0_;
			CanvasText* _tmp1_;
			_tmp0_ = self->priv->_text;
			canvas_text_set_edit (_tmp0_, TRUE);
			_tmp1_ = self->priv->_text;
			canvas_text_set_cursor_all (_tmp1_, FALSE);
		} else {
			CanvasText* _tmp2_;
			CanvasText* _tmp3_;
			_tmp2_ = self->priv->_text;
			canvas_text_set_edit (_tmp2_, FALSE);
			_tmp3_ = self->priv->_text;
			canvas_text_clear_selection (_tmp3_, NULL);
		}
		if (callout_mode_is_disconnected (orig_mode)) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = callout_mode_is_disconnected (value);
		}
		if (_tmp4_) {
			g_signal_emit (self, callout_signals[CALLOUT_RESIZED_SIGNAL], 0);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, callout_properties[CALLOUT_MODE_PROPERTY]);
}

Style*
callout_get_style (Callout* self)
{
	Style* result;
	Style* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_style;
	result = _tmp0_;
	return result;
}

void
callout_set_style (Callout* self,
                   Style* value)
{
	Style* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_style;
	if (style_copy (_tmp0_, value)) {
		CanvasText* _tmp1_;
		Style* _tmp2_;
		PangoFontDescription* _tmp3_;
		PangoFontDescription* _tmp4_;
		const gchar* _tmp5_;
		Style* _tmp6_;
		PangoFontDescription* _tmp7_;
		PangoFontDescription* _tmp8_;
		gint _tmp9_;
		CanvasText* _tmp10_;
		Style* _tmp11_;
		Style* _tmp12_;
		gint* _tmp13_;
		gint* _tmp14_;
		_tmp1_ = self->priv->_text;
		_tmp2_ = self->priv->_style;
		_tmp3_ = style_get_callout_font (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = pango_font_description_get_family (_tmp4_);
		_tmp6_ = self->priv->_style;
		_tmp7_ = style_get_callout_font (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = pango_font_description_get_size (_tmp8_) / PANGO_SCALE;
		canvas_text_set_font (_tmp1_, _tmp5_, &_tmp9_, 1.0);
		_tmp10_ = self->priv->_text;
		_tmp11_ = callout_get_style (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = style_get_node_width (_tmp12_);
		_tmp14_ = _tmp13_;
		canvas_text_set_max_width (_tmp10_, *_tmp14_);
		callout_position_text (self, TRUE);
		g_signal_emit (self, callout_signals[CALLOUT_RESIZED_SIGNAL], 0);
	}
	g_object_notify_by_pspec ((GObject *) self, callout_properties[CALLOUT_STYLE_PROPERTY]);
}

gdouble
callout_get_alpha (Callout* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_alpha;
	return result;
}

void
callout_set_alpha (Callout* self,
                   gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = callout_get_alpha (self);
	if (old_value != value) {
		self->priv->_alpha = value;
		g_object_notify_by_pspec ((GObject *) self, callout_properties[CALLOUT_ALPHA_PROPERTY]);
	}
}

static void
callout_class_init (CalloutClass * klass,
                    gpointer klass_data)
{
	callout_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Callout_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_callout_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_callout_set_property;
	G_OBJECT_CLASS (klass)->finalize = callout_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_NODE_PROPERTY, callout_properties[CALLOUT_NODE_PROPERTY] = g_param_spec_object ("node", "node", "node", TYPE_NODE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_TEXT_PROPERTY, callout_properties[CALLOUT_TEXT_PROPERTY] = g_param_spec_object ("text", "text", "text", TYPE_CANVAS_TEXT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_TOTAL_WIDTH_PROPERTY, callout_properties[CALLOUT_TOTAL_WIDTH_PROPERTY] = g_param_spec_double ("total-width", "total-width", "total-width", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_TOTAL_HEIGHT_PROPERTY, callout_properties[CALLOUT_TOTAL_HEIGHT_PROPERTY] = g_param_spec_double ("total-height", "total-height", "total-height", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_MODE_PROPERTY, callout_properties[CALLOUT_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_CALLOUT_MODE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_STYLE_PROPERTY, callout_properties[CALLOUT_STYLE_PROPERTY] = param_spec_style ("style", "style", "style", TYPE_STYLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CALLOUT_ALPHA_PROPERTY, callout_properties[CALLOUT_ALPHA_PROPERTY] = g_param_spec_double ("alpha", "alpha", "alpha", -G_MAXDOUBLE, G_MAXDOUBLE, 1.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	callout_signals[CALLOUT_RESIZED_SIGNAL] = g_signal_new ("resized", TYPE_CALLOUT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
callout_instance_init (Callout * self,
                       gpointer klass)
{
	self->priv = callout_get_instance_private (self);
	self->priv->_mode = CALLOUT_MODE_NONE;
	self->priv->_alpha = 1.0;
}

static void
callout_finalize (GObject * obj)
{
	Callout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CALLOUT, Callout);
	_g_object_unref0 (self->priv->_node);
	_style_unref0 (self->priv->_style);
	_g_object_unref0 (self->priv->_text);
	G_OBJECT_CLASS (callout_parent_class)->finalize (obj);
}

static GType
callout_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CalloutClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) callout_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Callout), 0, (GInstanceInitFunc) callout_instance_init, NULL };
	GType callout_type_id;
	callout_type_id = g_type_register_static (G_TYPE_OBJECT, "Callout", &g_define_type_info, 0);
	Callout_private_offset = g_type_add_instance_private (callout_type_id, sizeof (CalloutPrivate));
	return callout_type_id;
}

GType
callout_get_type (void)
{
	static volatile gsize callout_type_id__once = 0;
	if (g_once_init_enter (&callout_type_id__once)) {
		GType callout_type_id;
		callout_type_id = callout_get_type_once ();
		g_once_init_leave (&callout_type_id__once, callout_type_id);
	}
	return callout_type_id__once;
}

static void
_vala_callout_get_property (GObject * object,
                            guint property_id,
                            GValue * value,
                            GParamSpec * pspec)
{
	Callout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CALLOUT, Callout);
	switch (property_id) {
		case CALLOUT_NODE_PROPERTY:
		g_value_set_object (value, callout_get_node (self));
		break;
		case CALLOUT_TEXT_PROPERTY:
		g_value_set_object (value, callout_get_text (self));
		break;
		case CALLOUT_TOTAL_WIDTH_PROPERTY:
		g_value_set_double (value, callout_get_total_width (self));
		break;
		case CALLOUT_TOTAL_HEIGHT_PROPERTY:
		g_value_set_double (value, callout_get_total_height (self));
		break;
		case CALLOUT_MODE_PROPERTY:
		g_value_set_enum (value, callout_get_mode (self));
		break;
		case CALLOUT_STYLE_PROPERTY:
		value_set_style (value, callout_get_style (self));
		break;
		case CALLOUT_ALPHA_PROPERTY:
		g_value_set_double (value, callout_get_alpha (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_callout_set_property (GObject * object,
                            guint property_id,
                            const GValue * value,
                            GParamSpec * pspec)
{
	Callout * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CALLOUT, Callout);
	switch (property_id) {
		case CALLOUT_MODE_PROPERTY:
		callout_set_mode (self, g_value_get_enum (value));
		break;
		case CALLOUT_STYLE_PROPERTY:
		callout_set_style (self, value_get_style (value));
		break;
		case CALLOUT_ALPHA_PROPERTY:
		callout_set_alpha (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

