// python wrapper for vtkAxisAlignedCutter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAxisAlignedCutter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAxisAlignedCutter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAxisAlignedCutter_ClassNew(); }


static PyObject *
PyvtkAxisAlignedCutter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAxisAlignedCutter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAxisAlignedCutter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAxisAlignedCutter *tempr = vtkAxisAlignedCutter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAxisAlignedCutter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAxisAlignedCutter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAxisAlignedCutter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAxisAlignedCutter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SetCutFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCutFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  vtkImplicitFunction *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkImplicitFunction"))
  {
    if (ap.IsBound())
    {
      op->SetCutFunction(temp0);
    }
    else
    {
      op->vtkAxisAlignedCutter::SetCutFunction(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetCutFunction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetCutFunction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkImplicitFunction *tempr = (ap.IsBound() ?
      op->GetCutFunction() :
      op->vtkAxisAlignedCutter::GetCutFunction());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetMTime(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMTime");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    unsigned long tempr = (ap.IsBound() ?
      op->GetMTime() :
      op->vtkAxisAlignedCutter::GetMTime());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SetOffsetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetOffsetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetOffsetValue(temp0, temp1);
    }
    else
    {
      op->vtkAxisAlignedCutter::SetOffsetValue(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetOffsetValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOffsetValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetOffsetValue(temp0) :
      op->vtkAxisAlignedCutter::GetOffsetValue(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SetNumberOfOffsetValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfOffsetValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfOffsetValues(temp0);
    }
    else
    {
      op->vtkAxisAlignedCutter::SetNumberOfOffsetValues(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetNumberOfOffsetValues(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfOffsetValues");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfOffsetValues() :
      op->vtkAxisAlignedCutter::GetNumberOfOffsetValues());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SetLevelOfResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLevelOfResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLevelOfResolution(temp0);
    }
    else
    {
      op->vtkAxisAlignedCutter::SetLevelOfResolution(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetLevelOfResolution(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLevelOfResolution");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetLevelOfResolution() :
      op->vtkAxisAlignedCutter::GetLevelOfResolution());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkAxisAlignedCutter::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAxisAlignedCutter_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAxisAlignedCutter *op = static_cast<vtkAxisAlignedCutter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkAxisAlignedCutter::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkAxisAlignedCutter_Methods[] = {
  {"IsTypeOf", PyvtkAxisAlignedCutter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAxisAlignedCutter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAxisAlignedCutter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAxisAlignedCutter\nC++: static vtkAxisAlignedCutter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAxisAlignedCutter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAxisAlignedCutter\nC++: vtkAxisAlignedCutter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAxisAlignedCutter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAxisAlignedCutter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetCutFunction", PyvtkAxisAlignedCutter_SetCutFunction, METH_VARARGS,
   "SetCutFunction(self, function:vtkImplicitFunction) -> None\nC++: void SetCutFunction(vtkImplicitFunction *function)\n\nSpecify the implicit function to perform the cutting. For now,\nonly `Axis-Aligned` planes are supported.\n"},
  {"GetCutFunction", PyvtkAxisAlignedCutter_GetCutFunction, METH_VARARGS,
   "GetCutFunction(self) -> vtkImplicitFunction\nC++: vtkImplicitFunction *GetCutFunction()\n\n"},
  {"GetMTime", PyvtkAxisAlignedCutter_GetMTime, METH_VARARGS,
   "GetMTime(self) -> int\nC++: vtkMTimeType GetMTime() override;\n\nGet the last modified time of this filter. This time also depends\non the the modified time of the internal CutFunction instance.\n"},
  {"SetOffsetValue", PyvtkAxisAlignedCutter_SetOffsetValue, METH_VARARGS,
   "SetOffsetValue(self, i:int, value:float) -> None\nC++: void SetOffsetValue(int i, double value)\n\nSet/get a slice offset value at specified index i. Negative\nindices are clamped to 0. New space is allocated if necessary.\n"},
  {"GetOffsetValue", PyvtkAxisAlignedCutter_GetOffsetValue, METH_VARARGS,
   "GetOffsetValue(self, i:int) -> float\nC++: double GetOffsetValue(int i)\n\n"},
  {"SetNumberOfOffsetValues", PyvtkAxisAlignedCutter_SetNumberOfOffsetValues, METH_VARARGS,
   "SetNumberOfOffsetValues(self, number:int) -> None\nC++: void SetNumberOfOffsetValues(int number)\n\nSet/get the number of slice offset values. Allocate new space to\nstore them if needed.\n"},
  {"GetNumberOfOffsetValues", PyvtkAxisAlignedCutter_GetNumberOfOffsetValues, METH_VARARGS,
   "GetNumberOfOffsetValues(self) -> int\nC++: int GetNumberOfOffsetValues()\n\n"},
  {"SetLevelOfResolution", PyvtkAxisAlignedCutter_SetLevelOfResolution, METH_VARARGS,
   "SetLevelOfResolution(self, _arg:int) -> None\nC++: virtual void SetLevelOfResolution(int _arg)\n\nSets the level of resolution. Default is 0.\n\nNote: Only used for cutting overlapping AMR.\n"},
  {"GetLevelOfResolution", PyvtkAxisAlignedCutter_GetLevelOfResolution, METH_VARARGS,
   "GetLevelOfResolution(self) -> int\nC++: virtual int GetLevelOfResolution()\n\n"},
  {"SetController", PyvtkAxisAlignedCutter_SetController, METH_VARARGS,
   "SetController(self, controller:vtkMultiProcessController) -> None\nC++: void SetController(vtkMultiProcessController *controller)\n\nGet/Set the controller in an MPI environment. If one sets the\ncontroller to `nullptr`, an instance of `vtkDummyController` is\nstored instead. `GetController` never returns `nullptr`.\n"},
  {"GetController", PyvtkAxisAlignedCutter_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: vtkMultiProcessController *GetController()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAxisAlignedCutter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("cut_function"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAxisAlignedCutter_GetCutFunction(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAxisAlignedCutter_SetCutFunction(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAxisAlignedCutter_SetCutFunction(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetCutFunction/SetCutFunction\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("level_of_resolution"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAxisAlignedCutter_GetLevelOfResolution(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAxisAlignedCutter_SetLevelOfResolution(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAxisAlignedCutter_SetLevelOfResolution(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLevelOfResolution/SetLevelOfResolution\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAxisAlignedCutter_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAxisAlignedCutter_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAxisAlignedCutter_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("m_time"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAxisAlignedCutter_GetMTime(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMTime\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAxisAlignedCutter_Doc =
  "vtkAxisAlignedCutter - Cut data with an Axis-Aligned cut function\n\n"
  "Superclass: vtkDataObjectAlgorithm\n\n"
  "`vtkAxisAlignedCutter` is a filter producing Axis-Aligned \"slices\" of\n"
  "the input data. Among slicing filters, this one allows to preserve\n"
  "the input type. In other words, this filter reduces the dimention of\n"
  "the input by 1, following an implicit cutting function. For example,\n"
  "slicing a 3D `vtkHyperTreeGrid` will produce one (or several) 2D\n"
  "`vtkHyperTreeGrid`. For that matter, this filter is limited to\n"
  "Axis-Aligned functions.\n\n"
  "Except for `vtkOverlapingAMR`, this filter can produce multiple\n"
  "slices at once. In such cases, the output slices are stored in a\n"
  "`vtkPartitionedDataSetCollection`.\n\n"
  "In the case of a composite input, this filter will produce a\n"
  "composite output with the same structure, except that each leaf\n"
  "(HyperTreeGrid or PartitionedDataSet containting HTG(s)) will be\n"
  "replaced by a new level of nodes containing slices (one node for each\n"
  "slice). Output will always be a PartitionedDataSetCollection, even if\n"
  "the input is a MultiBlock.\n\n"
  "Please note that a composite input is considered valid only if it\n"
  "only contains HTGs or Partitioned DataSets of HTGs. This do not\n"
  "concern Overlaping AMR since they can't be stored in composite\n"
  "datasets.\n\n"
  "To recap, currently supported input types are:\n"
  "- `vtkHyperTreeGrid`, output is a `vtkPartitionedDataSetCollection`\n"
  "  (of `vtkHyperTreeGrid`)\n"
  "- `vtkCompositeDataSet` of `vtkHyperTreeGrid`, output is a\n"
  "  `vtkPartitionedDataSetCollection` of `vtkHyperTreeGrid` (with one\n"
  "  additional layer)\n"
  "- `vtkOverlappingAMR`, output is a `vtkOverlappingAMR`\n\n"
  "Currently supported cutting function is Axis-Aligned `vtkPVPlane`.\n\n"
  "@sa\n"
  "vtkCutter vtkPVCutter vtkPlaneCutter vtkPVPlaneCutter\n"
  "vtkPVMetaSliceDataSet vtkHyperTreeGridAxisCut vtkAMRSliceFilter\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAxisAlignedCutter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkAxisAlignedCutter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAxisAlignedCutter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAxisAlignedCutter_StaticNew()
{
  return vtkAxisAlignedCutter::New();
}

PyObject *PyvtkAxisAlignedCutter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAxisAlignedCutter_Type, PyvtkAxisAlignedCutter_Methods,
    "vtkAxisAlignedCutter",
 &PyvtkAxisAlignedCutter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkDataObjectAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAxisAlignedCutter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAxisAlignedCutter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAxisAlignedCutter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAxisAlignedCutter", o) != 0)
  {
    Py_DECREF(o);
  }

}

