// python wrapper for vtkPVPythonAlgorithmPlugin
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkPVPythonAlgorithmPlugin.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkPVPythonAlgorithmPlugin(PyObject *dict); }

static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetPluginName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginName");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetPluginName();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetPluginVersionString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPluginVersionString");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetPluginVersionString();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetRequiredOnServer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredOnServer");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetRequiredOnServer();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetRequiredOnClient(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredOnClient");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = op->GetRequiredOnClient();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetRequiredPlugins(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetRequiredPlugins");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetRequiredPlugins();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetDescription(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetDescription");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetDescription();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetEULA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEULA");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    const char *tempr = op->GetEULA();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_GetXMLs(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetXMLs");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkPVPythonAlgorithmPlugin *op = static_cast<vtkPVPythonAlgorithmPlugin *>(vp);

  std::vector<std::string> temp0(ap.GetArgSize(0));
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0.data(), temp0.size()))
  {
    op->GetXMLs(temp0);

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp0.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp0.data(), temp0.size()));
      ap.SetContents(0, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkPVPythonAlgorithmPlugin_InitializeFromStringAndGetXMLs(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "InitializeFromStringAndGetXMLs");

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  std::vector<std::string> temp2(ap.GetArgSize(2));
  PyObject *result = nullptr;

  if (ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetArray(temp2.data(), temp2.size()))
  {
    bool tempr = vtkPVPythonAlgorithmPlugin::InitializeFromStringAndGetXMLs(temp0, temp1, temp2);

    if (!ap.ErrorOccurred())
    {
      PyObject *vec = (temp2.empty() ?
        PyTuple_New(0) :
        vtkPythonArgs::BuildTuple(temp2.data(), temp2.size()));
      ap.SetContents(2, vec);
      Py_DECREF(vec);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkPVPythonAlgorithmPlugin_Methods[] = {
  {"GetPluginName", PyvtkPVPythonAlgorithmPlugin_GetPluginName, METH_VARARGS,
   "GetPluginName(self) -> str\nC++: const char *GetPluginName() override;\n\nImplementation of the vtkPVPlugin interface.\n"},
  {"GetPluginVersionString", PyvtkPVPythonAlgorithmPlugin_GetPluginVersionString, METH_VARARGS,
   "GetPluginVersionString(self) -> str\nC++: const char *GetPluginVersionString() override;\n\nReturns the version for this plugin.\n"},
  {"GetRequiredOnServer", PyvtkPVPythonAlgorithmPlugin_GetRequiredOnServer, METH_VARARGS,
   "GetRequiredOnServer(self) -> bool\nC++: bool GetRequiredOnServer() override;\n\nReturns true if this plugin is required on the server.\n"},
  {"GetRequiredOnClient", PyvtkPVPythonAlgorithmPlugin_GetRequiredOnClient, METH_VARARGS,
   "GetRequiredOnClient(self) -> bool\nC++: bool GetRequiredOnClient() override;\n\nReturns true if this plugin is required on the client.\n"},
  {"GetRequiredPlugins", PyvtkPVPythonAlgorithmPlugin_GetRequiredPlugins, METH_VARARGS,
   "GetRequiredPlugins(self) -> str\nC++: const char *GetRequiredPlugins() override;\n\nReturns a ';' separated list of plugin names required by this\nplugin.\n"},
  {"GetDescription", PyvtkPVPythonAlgorithmPlugin_GetDescription, METH_VARARGS,
   "GetDescription(self) -> str\nC++: const char *GetDescription() override;\n\nReturns a description of this plugin.\n"},
  {"GetEULA", PyvtkPVPythonAlgorithmPlugin_GetEULA, METH_VARARGS,
   "GetEULA(self) -> str\nC++: const char *GetEULA() override;\n\nReturns EULA for the plugin, if any. If none, this will return\nnullptr.\n"},
  {"GetXMLs", PyvtkPVPythonAlgorithmPlugin_GetXMLs, METH_VARARGS,
   "GetXMLs(self, xmls:[str, ...]) -> None\nC++: void GetXMLs(std::vector<std::string> &xmls) override;\n\nImplementation of the vtkPVServerManagerPluginInterface.\n"},
  {"InitializeFromStringAndGetXMLs", PyvtkPVPythonAlgorithmPlugin_InitializeFromStringAndGetXMLs, METH_VARARGS,
   "InitializeFromStringAndGetXMLs(moduleName:str,\n    pythonSourceCode:str, xmls:[str, ...]) -> bool\nC++: static bool InitializeFromStringAndGetXMLs(\n    const char *moduleName, const char *pythonSourceCode,\n    std::vector<std::string> &xmls)\n\nCreates the object from Python source code and gets the\nservermanager XMLs from all the Python filters included in the\n'moduleName'.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPythonAlgorithmPlugin_GetSets[] = {
  {
    /*name=*/pystr("plugin_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetPluginName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("plugin_version_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetPluginVersionString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPluginVersionString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_on_server"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetRequiredOnServer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredOnServer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_on_client"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetRequiredOnClient(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredOnClient\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("required_plugins"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetRequiredPlugins(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetRequiredPlugins\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("description"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetDescription(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetDescription\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("eula"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkPVPythonAlgorithmPlugin_GetEULA(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetEULA\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPythonAlgorithmPlugin");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkPVPythonAlgorithmPlugin *op = new vtkPVPythonAlgorithmPlugin(temp0);

    result = PyVTKSpecialObject_New("vtkPVPythonAlgorithmPlugin", op);
  }

  return result;
}

static PyObject *
PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPythonAlgorithmPlugin");

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkPVPythonAlgorithmPlugin *op = new vtkPVPythonAlgorithmPlugin(temp0, temp1);

    result = PyVTKSpecialObject_New("vtkPVPythonAlgorithmPlugin", op);
  }

  return result;
}

static PyMethodDef PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_Methods[] = {
  {"vtkPVPythonAlgorithmPlugin", PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_s1, METH_VARARGS,
   "@z"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 1:
      return PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_s1(self, args);
    case 2:
      return PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPVPythonAlgorithmPlugin");
  return nullptr;
}


static const char *PyvtkPVPythonAlgorithmPlugin_Doc =

  "vtkPVPythonAlgorithmPlugin(filePath:str) -> vtkPVPythonAlgorithmPlugin\nC++: vtkPVPythonAlgorithmPlugin(const char *filePath)\nvtkPVPythonAlgorithmPlugin(moduleName:str, pythonSourceCode:str)\n    -> vtkPVPythonAlgorithmPlugin\nC++: vtkPVPythonAlgorithmPlugin(const char *moduleName,\n    const char *pythonSourceCode)\n""\n"
  "vtkPVPythonAlgorithmPlugin - packages a Python module into a ParaView\nplugin.\n\n"
  "Superclass: vtkPVPlugin\n\n"
  "vtkPVPythonAlgorithmPlugin helps us support loading a Python module\n"
  "as a ParaView `plugin`. The only supported type of plugin is a\n"
  "server-manager plugin that adds support for algorithm proxies i.e.\n"
  "readers, filters, and writers.\n\n";

static PyObject *
PyvtkPVPythonAlgorithmPlugin_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin(nullptr, args);
}

static void PyvtkPVPythonAlgorithmPlugin_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVPythonAlgorithmPlugin *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVPythonAlgorithmPlugin_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPythonAlgorithmPlugin_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManagerPython.vtkPVPythonAlgorithmPlugin", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVPythonAlgorithmPlugin_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVPythonAlgorithmPlugin_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVPythonAlgorithmPlugin_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVPythonAlgorithmPlugin_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

#ifndef DECLARED_PyvtkPVPythonAlgorithmPlugin_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPythonAlgorithmPlugin_TypeNew(); }
#define DECLARED_PyvtkPVPythonAlgorithmPlugin_TypeNew
#endif

PyObject *PyvtkPVPythonAlgorithmPlugin_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVPythonAlgorithmPlugin_Type,
    PyvtkPVPythonAlgorithmPlugin_Methods,
    PyvtkPVPythonAlgorithmPlugin_GetSets,
    PyvtkPVPythonAlgorithmPlugin_vtkPVPythonAlgorithmPlugin_Methods,
    nullptr);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindSpecialTypeObject("vtkPVPlugin");

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

static PyMethodDef PyvtkPVPythonAlgorithmPluginLoaderInitializer_Methods[] = {
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkPVPythonAlgorithmPluginLoaderInitializer_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPythonAlgorithmPluginLoaderInitializer");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkPVPythonAlgorithmPluginLoaderInitializer *op = new vtkPVPythonAlgorithmPluginLoaderInitializer();

    result = PyVTKSpecialObject_New("vtkPVPythonAlgorithmPluginLoaderInitializer", op);
  }

  return result;
}

static PyObject *
PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkPVPythonAlgorithmPluginLoaderInitializer");

  vtkPVPythonAlgorithmPluginLoaderInitializer *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkPVPythonAlgorithmPluginLoaderInitializer"))
  {
    vtkPVPythonAlgorithmPluginLoaderInitializer *op = new vtkPVPythonAlgorithmPluginLoaderInitializer(*temp0);

    result = PyVTKSpecialObject_New("vtkPVPythonAlgorithmPluginLoaderInitializer", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_Methods[] = {
  {"vtkPVPythonAlgorithmPluginLoaderInitializer", PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_s2, METH_VARARGS,
   "@W vtkPVPythonAlgorithmPluginLoaderInitializer"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_s1(self, args);
    case 1:
      return PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkPVPythonAlgorithmPluginLoaderInitializer");
  return nullptr;
}


static const char *PyvtkPVPythonAlgorithmPluginLoaderInitializer_Doc =

  "vtkPVPythonAlgorithmPluginLoaderInitializer()\n    -> vtkPVPythonAlgorithmPluginLoaderInitializer\nC++: vtkPVPythonAlgorithmPluginLoaderInitializer()\nvtkPVPythonAlgorithmPluginLoaderInitializer(\n    __a:vtkPVPythonAlgorithmPluginLoaderInitializer)\n    -> vtkPVPythonAlgorithmPluginLoaderInitializer\nC++: vtkPVPythonAlgorithmPluginLoaderInitializer(\n    const &vtkPVPythonAlgorithmPluginLoaderInitializer)\n""\n"
  "vtkPVPythonAlgorithmPluginLoaderInitializer - no description provided.\n\n"
;

static PyObject *
PyvtkPVPythonAlgorithmPluginLoaderInitializer_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer(nullptr, args);
}

static void PyvtkPVPythonAlgorithmPluginLoaderInitializer_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkPVPythonAlgorithmPluginLoaderInitializer *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkPVPythonAlgorithmPluginLoaderInitializer_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkPVPythonAlgorithmPluginLoaderInitializer_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingServerManagerPython.vtkPVPythonAlgorithmPluginLoaderInitializer", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkPVPythonAlgorithmPluginLoaderInitializer_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkPVPythonAlgorithmPluginLoaderInitializer_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkPVPythonAlgorithmPluginLoaderInitializer_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkPVPythonAlgorithmPluginLoaderInitializer_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkPVPythonAlgorithmPluginLoaderInitializer_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkPVPythonAlgorithmPluginLoaderInitializer(*static_cast<const vtkPVPythonAlgorithmPluginLoaderInitializer*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkPVPythonAlgorithmPluginLoaderInitializer_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkPVPythonAlgorithmPluginLoaderInitializer_TypeNew(); }
#define DECLARED_PyvtkPVPythonAlgorithmPluginLoaderInitializer_TypeNew
#endif

PyObject *PyvtkPVPythonAlgorithmPluginLoaderInitializer_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkPVPythonAlgorithmPluginLoaderInitializer_Type,
    PyvtkPVPythonAlgorithmPluginLoaderInitializer_Methods,
    PyvtkPVPythonAlgorithmPluginLoaderInitializer_GetSets,
    PyvtkPVPythonAlgorithmPluginLoaderInitializer_vtkPVPythonAlgorithmPluginLoaderInitializer_Methods,
    &PyvtkPVPythonAlgorithmPluginLoaderInitializer_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkPVPythonAlgorithmPlugin(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkPVPythonAlgorithmPlugin_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPythonAlgorithmPlugin", o) != 0)
  {
    Py_DECREF(o);
  }

  o = PyvtkPVPythonAlgorithmPluginLoaderInitializer_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkPVPythonAlgorithmPluginLoaderInitializer", o) != 0)
  {
    Py_DECREF(o);
  }

}

