// python wrapper for vtkSMSaveScreenshotProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSmartPointer.h"
#include "vtkVector.h"
#include "vtkSMSaveScreenshotProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMSaveScreenshotProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMSaveScreenshotProxy_ClassNew(); }


static PyObject *
PyvtkSMSaveScreenshotProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMSaveScreenshotProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMSaveScreenshotProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMSaveScreenshotProxy *tempr = vtkSMSaveScreenshotProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMSaveScreenshotProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMSaveScreenshotProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMSaveScreenshotProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMSaveScreenshotProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_WriteImage(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteImage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  const char *temp0 = nullptr;
  unsigned int temp1 = vtkPVSession::CLIENT;
  vtkPVXMLElement *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetValue(temp0) &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetVTKObject(temp2, "vtkPVXMLElement")))
  {
    bool tempr = (ap.IsBound() ?
      op->WriteImage(temp0, temp1, temp2) :
      op->vtkSMSaveScreenshotProxy::WriteImage(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_CaptureImage_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CaptureImage");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSmartPointer<vtkImageData> tempr = (ap.IsBound() ?
      op->CaptureImage() :
      op->vtkSMSaveScreenshotProxy::CaptureImage());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMSaveScreenshotProxy_CaptureImage_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CaptureImage");

  vtkSMViewProxy *temp0 = nullptr;
  vtkVector2i *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy") &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVector2i"))
  {
    vtkSmartPointer<vtkImageData> tempr = vtkSMSaveScreenshotProxy::CaptureImage(temp0, *temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  Py_XDECREF(pobj1);

  return result;
}

static PyObject *
PyvtkSMSaveScreenshotProxy_CaptureImage_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "CaptureImage");

  vtkSMViewLayoutProxy *temp0 = nullptr;
  vtkVector2i *temp1 = nullptr;
  PyObject *pobj1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMViewLayoutProxy") &&
      ap.GetSpecialObject(temp1, pobj1, "vtkVector2i"))
  {
    vtkSmartPointer<vtkImageData> tempr = vtkSMSaveScreenshotProxy::CaptureImage(temp0, *temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  Py_XDECREF(pobj1);

  return result;
}

static PyMethodDef PyvtkSMSaveScreenshotProxy_CaptureImage_Methods[] = {
  {"CaptureImage", PyvtkSMSaveScreenshotProxy_CaptureImage_s2, METH_VARARGS | METH_STATIC,
   "VW *vtkSMViewProxy vtkVector2i"},
  {"CaptureImage", PyvtkSMSaveScreenshotProxy_CaptureImage_s3, METH_VARARGS | METH_STATIC,
   "VW *vtkSMViewLayoutProxy vtkVector2i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMSaveScreenshotProxy_CaptureImage(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMSaveScreenshotProxy_CaptureImage_Methods;
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMSaveScreenshotProxy_CaptureImage_s1(self, args);
    case 2:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CaptureImage");
  return nullptr;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_UpdateDefaultsAndVisibilities(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateDefaultsAndVisibilities");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->UpdateDefaultsAndVisibilities(temp0);
    }
    else
    {
      op->vtkSMSaveScreenshotProxy::UpdateDefaultsAndVisibilities(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_GetScaleFactorsAndSize(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetScaleFactorsAndSize");

  vtkVector2i *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkVector2i *temp1 = nullptr;
  size_t size2 = ap.GetArgSize(2);
  vtkPythonArgs::Array<bool> store2(2*size2);
  bool *temp2 = store2.Data();
  bool *save2 = (size2 == 0 ? nullptr : temp2 + size2);
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2, 3) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVector2i") &&
      ap.GetSpecialObject(temp1, "vtkVector2i") &&
      (ap.NoArgsLeft() || ap.GetArray(temp2, size2)))
  {
    vtkPythonArgs::Save(temp2, save2, size2);

    vtkVector2i tempr = vtkSMSaveScreenshotProxy::GetScaleFactorsAndSize(*temp0, *temp1, temp2);

    if (vtkPythonArgs::HasChanged(temp2, save2, size2) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(2, temp2, size2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVector2i");
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_ComputeMagnification(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "ComputeMagnification");

  vtkVector2i *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  vtkVector2i *temp1 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkVector2i") &&
      ap.GetSpecialObject(temp1, "vtkVector2i"))
  {
    int tempr = vtkSMSaveScreenshotProxy::ComputeMagnification(*temp0, *temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  Py_XDECREF(pobj0);

  return result;
}


static PyObject *
PyvtkSMSaveScreenshotProxy_GetFileFormatFilters(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileFormatFilters");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMSaveScreenshotProxy *op = static_cast<vtkSMSaveScreenshotProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetFileFormatFilters() :
      op->vtkSMSaveScreenshotProxy::GetFileFormatFilters());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMSaveScreenshotProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMSaveScreenshotProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMSaveScreenshotProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMSaveScreenshotProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMSaveScreenshotProxy\nC++: static vtkSMSaveScreenshotProxy *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMSaveScreenshotProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMSaveScreenshotProxy\nC++: vtkSMSaveScreenshotProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMSaveScreenshotProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMSaveScreenshotProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"WriteImage", PyvtkSMSaveScreenshotProxy_WriteImage, METH_VARARGS,
   "WriteImage(self, filename:str, location:int=...,\n    stateXMLRoot:vtkPVXMLElement=...) -> bool\nC++: bool WriteImage(const char *filename,\n    vtkTypeUInt32 location=vtkPVSession::CLIENT,\n    vtkPVXMLElement *stateXMLRoot=nullptr)\n\nCapture image. You can specify the location at which to write the\nimage. Currently supported values are vtkPVSession::CLIENT,\nvtkPVSession::DATA_SERVER or vtkPVSession::DATA_SERVER_ROOT.\nSelecting vtkPVSession::DATA_SERVER is same as\nvtkPVSession::DATA_SERVER_ROOT since the images are only written\non root node. You can also specify the xml root of a state file\nto embed in the image.\n\nNote: embedding state as metadata is supported only for PNG\nfiles.\n"},
  {"CaptureImage", PyvtkSMSaveScreenshotProxy_CaptureImage, METH_VARARGS,
   "CaptureImage(self) -> vtkImageData\nC++: vtkSmartPointer<vtkImageData> CaptureImage()\nCaptureImage(view:vtkSMViewProxy, size:vtkVector2i)\n    -> vtkImageData\nC++: static vtkSmartPointer<vtkImageData> CaptureImage(\n    vtkSMViewProxy *view, const vtkVector2i &size)\nCaptureImage(view:vtkSMViewLayoutProxy, size:vtkVector2i)\n    -> vtkImageData\nC++: static vtkSmartPointer<vtkImageData> CaptureImage(\n    vtkSMViewLayoutProxy *view, const vtkVector2i &size)\n\nCapture the rendered image but doesn't save it out to any file.\n"},
  {"UpdateDefaultsAndVisibilities", PyvtkSMSaveScreenshotProxy_UpdateDefaultsAndVisibilities, METH_VARARGS,
   "UpdateDefaultsAndVisibilities(self, filename:str) -> None\nC++: virtual void UpdateDefaultsAndVisibilities(\n    const char *filename)\n\nUpdates default property values for saving the given file.\n"},
  {"GetScaleFactorsAndSize", PyvtkSMSaveScreenshotProxy_GetScaleFactorsAndSize, METH_VARARGS,
   "GetScaleFactorsAndSize(targetSize:vtkVector2i, size:vtkVector2i,\n    approximate:[bool, ...]=...) -> vtkVector2i\nC++: static vtkVector2i GetScaleFactorsAndSize(\n    const vtkVector2i &targetSize, vtkVector2i &size,\n    bool *approximate=nullptr)\n\nCompute scale factors and new size for target resolution. This\ndetermines integral scale factors (in X and Y) to get a box of\nsize of targetSize from a box of maximum size specified by size.\nIf approximate is non-null, then it is set to true when there no\nway to do that (e.g. one of the components of the targetSize is\nprime and doesn't match size).\n\nOn success, returns the scale factors and modifies size such that\nsize * scaleFactors == targetSize is possible. If not, size *\nscaleFactors < targetSize and approximate if non-null, is set to\ntrue.\n"},
  {"ComputeMagnification", PyvtkSMSaveScreenshotProxy_ComputeMagnification, METH_VARARGS,
   "ComputeMagnification(targetSize:vtkVector2i, size:vtkVector2i)\n    -> int\nC++: static int ComputeMagnification(\n    const vtkVector2i &targetSize, vtkVector2i &size)\n\nCompute a single magnification factor to reach targetSize using a\nbox that fits within size. This implementation is inaccurate and\nmay not give target resolution correctly. Hence\n`GetScaleFactorsAndSize` should be preferred. This method is\nuseful when the interest is in preserving the target aspect ratio\nas closely as possible than reaching the target size.\n"},
  {"GetFileFormatFilters", PyvtkSMSaveScreenshotProxy_GetFileFormatFilters, METH_VARARGS,
   "GetFileFormatFilters(self) -> str\nC++: std::string GetFileFormatFilters()\n\nConvenience method to derive a QFileDialog friendly format string\nfor extensions supported by this proxy.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMSaveScreenshotProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_format_filters"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMSaveScreenshotProxy_GetFileFormatFilters(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetFileFormatFilters\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMSaveScreenshotProxy_Doc =
  "vtkSMSaveScreenshotProxy - proxy to help with saving screenshots for\nviews\n\n"
  "Superclass: vtkSMProxy\n\n"
  "vtkSMSaveScreenshotProxy is used to capture images from views or\n"
  "layouts. It encapsulates the logic to generate screen shot of any\n"
  "arbitrary size independent of the application window size.\n\n"
  "The properties on this proxy provide various options that user can\n"
  "configure when saving images/screenshots. Once those properties are\n"
  "setup, one calls `vtkSMSaveScreenshotProxy::WriteImage` or\n"
  "`vtkSMSaveScreenshotProxy::CaptureImage`.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMSaveScreenshotProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMSaveScreenshotProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMSaveScreenshotProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMSaveScreenshotProxy_StaticNew()
{
  return vtkSMSaveScreenshotProxy::New();
}

PyObject *PyvtkSMSaveScreenshotProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMSaveScreenshotProxy_Type, PyvtkSMSaveScreenshotProxy_Methods,
    "vtkSMSaveScreenshotProxy",
 &PyvtkSMSaveScreenshotProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxy");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMSaveScreenshotProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMSaveScreenshotProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMSaveScreenshotProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMSaveScreenshotProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

