/*
 * Performance Metrics Name Space Map
 * Built by pmgenmap.sh from the file
 * systmetrics.map
 * on Wed Jan 28 17:10:49 UTC 2026
 *
 * Do not edit this file!
 */

/*
 *
 * metric names and access macros for photosyst.[ch]
 *
 */

const char *systmetrics[] = {
/* /proc/loadavg */
#define CPU_LOAD	0
	"kernel.all.load",

/* /proc/stat */
#define CPU_CSW	1
	"kernel.all.pswitch",
#define CPU_DEVINT	2
	"kernel.all.intr",
#define CPU_NPROCS	3
	"kernel.all.sysfork",
#define CPU_UTIME	4
	"kernel.all.cpu.user",
#define CPU_NTIME	5
	"kernel.all.cpu.nice",
#define CPU_STIME	6
	"kernel.all.cpu.sys",
#define CPU_ITIME	7
	"kernel.all.cpu.idle",
#define CPU_WTIME	8
	"kernel.all.cpu.wait.total",
#define CPU_HARDIRQ	9
	"kernel.all.cpu.irq.hard",
#define CPU_SOFTIRQ	10
	"kernel.all.cpu.irq.soft",
#define CPU_STEAL	11
	"kernel.all.cpu.steal",
#define CPU_GUEST	12
	"kernel.all.cpu.guest",
#define PERCPU_STIME	13
	"kernel.percpu.cpu.sys",
#define PERCPU_UTIME	14
	"kernel.percpu.cpu.user",
#define PERCPU_NTIME	15
	"kernel.percpu.cpu.nice",
#define PERCPU_ITIME	16
	"kernel.percpu.cpu.idle",
#define PERCPU_WTIME	17
	"kernel.percpu.cpu.wait.total",
#define PERCPU_HARDIRQ	18
	"kernel.percpu.cpu.irq.hard",
#define PERCPU_SOFTIRQ	19
	"kernel.percpu.cpu.irq.soft",
#define PERCPU_STEAL	20
	"kernel.percpu.cpu.steal",
#define PERCPU_GUEST	21
	"kernel.percpu.cpu.guest",

#define PERCPU_FREQ_CLK	22
	"hinv.cpu.clock",
#define PERCPU_FREQ_CNT	23
	"hinv.cpu.frequency_scaling.count",
#define PERCPU_FREQ_HIT	24
	"hinv.cpu.frequency_scaling.time",
#define PERCPU_FREQ_MAX	25
	"hinv.cpu.frequency_scaling.max",

/* /proc/vmstat */
#define MEM_SWINS	26
	"swap.pagesin",
#define MEM_SWOUTS	27
	"swap.pagesout",
#define MEM_PGPGIN	28
	"mem.vmstat.pgpgin",
#define MEM_PGPGOUT	29
	"mem.vmstat.pgpgout",
#define MEM_PAGETABLES	30
	"mem.vmstat.nr_page_table_pages",
#define MEM_NUMAMIGRATE	31
	"mem.vmstat.numa_pages_migrated",
#define MEM_PGMIGRATE	32
	"mem.vmstat.pgmigrate_success",
#define MEM_SCAN_DDMA	33
	"mem.vmstat.pgscan_direct_dma",
#define MEM_SCAN_DDMA32	34
	"mem.vmstat.pgscan_direct_dma32",
#define MEM_SCAN_DHIGH	35
	"mem.vmstat.pgscan_direct_high",
#define MEM_SCAN_DMOVABLE	36
	"mem.vmstat.pgscan_direct_movable",
#define MEM_SCAN_DNORMAL	37
	"mem.vmstat.pgscan_direct_normal",
#define MEM_SCAN_KDMA	38
	"mem.vmstat.pgscan_kswapd_dma",
#define MEM_SCAN_KDMA32	39
	"mem.vmstat.pgscan_kswapd_dma32",
#define MEM_SCAN_KHIGH	40
	"mem.vmstat.pgscan_kswapd_high",
#define MEM_SCAN_KMOVABLE	41
	"mem.vmstat.pgscan_kswapd_movable",
#define MEM_SCAN_KNORMAL	42
	"mem.vmstat.pgscan_kswapd_normal",
#define MEM_STEAL_DMA	43
	"mem.vmstat.pgsteal_dma",
#define MEM_STEAL_DMA32	44
	"mem.vmstat.pgsteal_dma32",
#define MEM_STEAL_HIGH	45
	"mem.vmstat.pgsteal_high",
#define MEM_STEAL_MOVABLE	46
	"mem.vmstat.pgsteal_movable",
#define MEM_STEAL_NORMAL	47
	"mem.vmstat.pgsteal_normal",
#define MEM_ALLOCSTALL	48
	"mem.vmstat.allocstall",
#define MEM_COMPACTSTALL	49
	"mem.vmstat.compact_stall",
#define MEM_OOM_KILL	50
	"mem.vmstat.oom_kill",
#define MEM_ZSWPIN	51
	"mem.vmstat.zswpin",
#define MEM_ZSWPOUT	52
	"mem.vmstat.zswpout",

/* /proc/meminfo */
#define MEM_SWAPCACHED	53
	"mem.util.swapCached",
#define MEM_CACHEMEM	54
	"mem.util.cached",
#define MEM_CACHEDRT	55
	"mem.util.dirty",
#define MEM_PHYSMEM	56
	"mem.physmem",
#define MEM_FREEMEM	57
	"mem.freemem",
#define MEM_BUFFERMEM	58
	"mem.util.bufmem",
#define MEM_SHMEM	59
	"mem.util.shmem",
#define MEM_TOTSWAP	60
	"swap.length",
#define MEM_FREESWAP	61
	"swap.free",
#define MEM_SLABMEM	62
	"mem.util.slab",
#define MEM_SLABRECLAIM	63
	"mem.util.slabReclaimable",
#define MEM_COMMITTED	64
	"mem.util.committed_AS",
#define MEM_COMMITLIM	65
	"mem.util.commitLimit",
#define MEM_TOTHUGEPAGE	66
	"mem.util.hugepagesTotal",
#define MEM_FREEHUGEPAGE	67
	"mem.util.hugepagesFree",
#define MEM_ZSWAPPED	68
	"mem.util.zswapped",
#define MEM_ZSWAP	69
	"mem.util.zswap",
#define MEM_AVAILABLE	70
	"mem.util.available",
#define MEM_ANONHUGEPAGE	71
	"mem.util.anonhugepages",

#define HUGEPAGESZ	72
	"hinv.hugepagesize",
#define MAP_CPU_NODE	73
	"hinv.map.cpu_node",

/* NUMA memory metrics */
#define PERNODE_MEM_TOTAL	74
	"mem.numa.util.total",
#define PERNODE_MEM_FREE	75
	"mem.numa.util.free",
#define PERNODE_MEM_FILE	76
	"mem.numa.util.filePages",
#define PERNODE_MEM_DIRTY	77
	"mem.numa.util.dirty",
#define PERNODE_MEM_SLAB	78
	"mem.numa.util.slab",
#define PERNODE_MEM_SRECLAIM	79
	"mem.numa.util.slabReclaimable",
#define PERNODE_MEM_ACTIVE	80
	"mem.numa.util.active",
#define PERNODE_MEM_INACTIVE	81
	"mem.numa.util.inactive",
#define PERNODE_MEM_SHMEM	82
	"mem.numa.util.shmem",
#define PERNODE_MEM_HUGEPAGES	83
	"mem.numa.util.hugepagesTotalBytes",
#define PERNODE_MEM_HUGEPAGESFREE	84
	"mem.numa.util.hugepagesFree",

/* /sys/kernel/debug/ksm */
#define PERNODE_MEM_EXTFRAG	85
	"sysfs.kernel.debug.extfrag_unusable",

/* NUMA CPU metrics */
#define PERNODE_CPU_SYS	86
	"kernel.pernode.cpu.sys",
#define PERNODE_CPU_USER	87
	"kernel.pernode.cpu.user",
#define PERNODE_CPU_NICE	88
	"kernel.pernode.cpu.nice",
#define PERNODE_CPU_IDLE	89
	"kernel.pernode.cpu.idle",
#define PERNODE_CPU_IOWAIT	90
	"kernel.pernode.cpu.wait.total",
#define PERNODE_CPU_IRQ_HARD	91
	"kernel.pernode.cpu.irq.hard",
#define PERNODE_CPU_IRQ_SOFT	92
	"kernel.pernode.cpu.irq.soft",
#define PERNODE_CPU_STEAL	93
	"kernel.pernode.cpu.steal",
#define PERNODE_CPU_GUEST	94
	"kernel.pernode.cpu.guest",

/* /sys/kernel/mm/ksm */
#define MEM_KSMSHARED	95
	"mem.ksm.pages_shared",
#define MEM_KSMSHARING	96
	"mem.ksm.pages_sharing",

/* shmctl(2) */
#define MEM_SHMRSS	97
	"ipc.shm.rss",
#define MEM_SHMSWP	98
	"ipc.shm.swp",

/* /proc/net/dev */
#define PERINTF_RBYTE	99
	"network.interface.in.bytes",
#define PERINTF_RPACK	100
	"network.interface.in.packets",
#define PERINTF_RERRS	101
	"network.interface.in.errors",
#define PERINTF_RDROP	102
	"network.interface.in.drops",
#define PERINTF_RFIFO	103
	"network.interface.in.fifo",
#define PERINTF_RFRAME	104
	"network.interface.in.frame",
#define PERINTF_RCOMPR	105
	"network.interface.in.compressed",
#define PERINTF_RMULTIC	106
	"network.interface.in.mcasts",
#define PERINTF_SBYTE	107
	"network.interface.out.bytes",
#define PERINTF_SPACK	108
	"network.interface.out.packets",
#define PERINTF_SERRS	109
	"network.interface.out.errors",
#define PERINTF_SDROP	110
	"network.interface.out.drops",
#define PERINTF_SFIFO	111
	"network.interface.out.fifo",
#define PERINTF_SCOLLIS	112
	"network.interface.collisions",
#define PERINTF_SCARRIER	113
	"network.interface.out.carrier",
#define PERINTF_SCOMPR	114
	"network.interface.out.compressed",

/* /proc/net/snmp */
#define IPV4_Forwarding	115
	"network.ip.forwarding",
#define IPV4_DefaultTTL	116
	"network.ip.defaultttl",
#define IPV4_InReceives	117
	"network.ip.inreceives",
#define IPV4_InHdrErrors	118
	"network.ip.inhdrerrors",
#define IPV4_InAddrErrors	119
	"network.ip.inaddrerrors",
#define IPV4_ForwDatagrams	120
	"network.ip.forwdatagrams",
#define IPV4_InUnknownProtos	121
	"network.ip.inunknownprotos",
#define IPV4_InDiscards	122
	"network.ip.indiscards",
#define IPV4_InDelivers	123
	"network.ip.indelivers",
#define IPV4_OutRequests	124
	"network.ip.outrequests",
#define IPV4_OutDiscards	125
	"network.ip.outdiscards",
#define IPV4_OutNoRoutes	126
	"network.ip.outnoroutes",
#define IPV4_ReasmTimeout	127
	"network.ip.reasmtimeout",
#define IPV4_ReasmReqds	128
	"network.ip.reasmreqds",
#define IPV4_ReasmOKs	129
	"network.ip.reasmoks",
#define IPV4_ReasmFails	130
	"network.ip.reasmfails",
#define IPV4_FragOKs	131
	"network.ip.fragoks",
#define IPV4_FragFails	132
	"network.ip.fragfails",
#define IPV4_FragCreates	133
	"network.ip.fragcreates",
#define ICMP4_InMsgs	134
	"network.icmp.inmsgs",
#define ICMP4_InErrors	135
	"network.icmp.inerrors",
#define ICMP4_InDestUnreachs	136
	"network.icmp.indestunreachs",
#define ICMP4_InTimeExcds	137
	"network.icmp.intimeexcds",
#define ICMP4_InParmProbs	138
	"network.icmp.inparmprobs",
#define ICMP4_InSrcQuenchs	139
	"network.icmp.insrcquenchs",
#define ICMP4_InRedirects	140
	"network.icmp.inredirects",
#define ICMP4_InEchos	141
	"network.icmp.inechos",
#define ICMP4_InEchoReps	142
	"network.icmp.inechoreps",
#define ICMP4_InTimestamps	143
	"network.icmp.intimestamps",
#define ICMP4_InTimestampReps	144
	"network.icmp.intimestampreps",
#define ICMP4_InAddrMasks	145
	"network.icmp.inaddrmasks",
#define ICMP4_InAddrMaskReps	146
	"network.icmp.inaddrmaskreps",
#define ICMP4_OutMsgs	147
	"network.icmp.outmsgs",
#define ICMP4_OutErrors	148
	"network.icmp.outerrors",
#define ICMP4_OutDestUnreachs	149
	"network.icmp.outdestunreachs",
#define ICMP4_OutTimeExcds	150
	"network.icmp.outtimeexcds",
#define ICMP4_OutParmProbs	151
	"network.icmp.outparmprobs",
#define ICMP4_OutSrcQuenchs	152
	"network.icmp.outsrcquenchs",
#define ICMP4_OutRedirects	153
	"network.icmp.outredirects",
#define ICMP4_OutEchos	154
	"network.icmp.outechos",
#define ICMP4_OutEchoReps	155
	"network.icmp.outechoreps",
#define ICMP4_OutTimestamps	156
	"network.icmp.outtimestamps",
#define ICMP4_OutTimestampReps	157
	"network.icmp.outtimestampreps",
#define ICMP4_OutAddrMasks	158
	"network.icmp.outaddrmasks",
#define ICMP4_OutAddrMaskReps	159
	"network.icmp.outaddrmaskreps",
#define TCP_RtoAlgorithm	160
	"network.tcp.rtoalgorithm",
#define TCP_RtoMin	161
	"network.tcp.rtomin",
#define TCP_RtoMax	162
	"network.tcp.rtomax",
#define TCP_MaxConn	163
	"network.tcp.maxconn",
#define TCP_ActiveOpens	164
	"network.tcp.activeopens",
#define TCP_PassiveOpens	165
	"network.tcp.passiveopens",
#define TCP_AttemptFails	166
	"network.tcp.attemptfails",
#define TCP_EstabResets	167
	"network.tcp.estabresets",
#define TCP_CurrEstab	168
	"network.tcp.currestab",
#define TCP_InSegs	169
	"network.tcp.insegs",
#define TCP_OutSegs	170
	"network.tcp.outsegs",
#define TCP_RetransSegs	171
	"network.tcp.retranssegs",
#define TCP_InErrs	172
	"network.tcp.inerrs",
#define TCP_OutRsts	173
	"network.tcp.outrsts",
#define UDPV4_InDatagrams	174
	"network.udp.indatagrams",
#define UDPV4_NoPorts	175
	"network.udp.noports",
#define UDPV4_InErrors	176
	"network.udp.inerrors",
#define UDPV4_OutDatagrams	177
	"network.udp.outdatagrams",

/* /proc/net/snmp6 */
#define IPV6_InReceives	178
	"network.ip6.inreceives",
#define IPV6_InHdrErrors	179
	"network.ip6.inhdrerrors",
#define IPV6_InTooBigErrors	180
	"network.ip6.intoobigerrors",
#define IPV6_InNoRoutes	181
	"network.ip6.innoroutes",
#define IPV6_InAddrErrors	182
	"network.ip6.inaddrerrors",
#define IPV6_InUnknownProtos	183
	"network.ip6.inunknownprotos",
#define IPV6_InTruncatedPkts	184
	"network.ip6.intruncatedpkts",
#define IPV6_InDiscards	185
	"network.ip6.indiscards",
#define IPV6_InDelivers	186
	"network.ip6.indelivers",
#define IPV6_OutForwDatagrams	187
	"network.ip6.outforwdatagrams",
#define IPV6_OutRequests	188
	"network.ip6.outrequests",
#define IPV6_OutDiscards	189
	"network.ip6.outdiscards",
#define IPV6_OutNoRoutes	190
	"network.ip6.outnoroutes",
#define IPV6_ReasmTimeout	191
	"network.ip6.reasmtimeout",
#define IPV6_ReasmReqds	192
	"network.ip6.reasmreqds",
#define IPV6_ReasmOKs	193
	"network.ip6.reasmoks",
#define IPV6_ReasmFails	194
	"network.ip6.reasmfails",
#define IPV6_FragOKs	195
	"network.ip6.fragoks",
#define IPV6_FragFails	196
	"network.ip6.fragfails",
#define IPV6_FragCreates	197
	"network.ip6.fragcreates",
#define IPV6_InMcastPkts	198
	"network.ip6.inmcastpkts",
#define IPV6_OutMcastPkts	199
	"network.ip6.outmcastpkts",
#define ICMPV6_InMsgs	200
	"network.icmp6.inmsgs",
#define ICMPV6_InErrors	201
	"network.icmp6.inerrors",
#define ICMPV6_InDestUnreachs	202
	"network.icmp6.indestunreachs",
#define ICMPV6_InPktTooBigs	203
	"network.icmp6.inpkttoobigs",
#define ICMPV6_InTimeExcds	204
	"network.icmp6.intimeexcds",
#define ICMPV6_InParmProblems	205
	"network.icmp6.inparmproblems",
#define ICMPV6_InEchos	206
	"network.icmp6.inechos",
#define ICMPV6_InEchoReplies	207
	"network.icmp6.inechoreplies",
#define ICMPV6_InGroupMembQueries	208
	"network.icmp6.ingroupmembqueries",
#define ICMPV6_InGroupMembResponses	209
	"network.icmp6.ingroupmembresponses",
#define ICMPV6_InGroupMembReductions	210
	"network.icmp6.ingroupmembreductions",
#define ICMPV6_InRouterSolicits	211
	"network.icmp6.inroutersolicits",
#define ICMPV6_InRouterAdvertisements	212
	"network.icmp6.inrouteradvertisements",
#define ICMPV6_InNeighborSolicits	213
	"network.icmp6.inneighborsolicits",
#define ICMPV6_InNeighborAdvertisements	214
	"network.icmp6.inneighboradvertisements",
#define ICMPV6_InRedirects	215
	"network.icmp6.inredirects",
#define ICMPV6_OutMsgs	216
	"network.icmp6.outmsgs",
#define ICMPV6_OutDestUnreachs	217
	"network.icmp6.outdestunreachs",
#define ICMPV6_OutPktTooBigs	218
	"network.icmp6.outpkttoobigs",
#define ICMPV6_OutTimeExcds	219
	"network.icmp6.outtimeexcds",
#define ICMPV6_OutParmProblems	220
	"network.icmp6.outparmproblems",
#define ICMPV6_OutEchoReplies	221
	"network.icmp6.outechoreplies",
#define ICMPV6_OutRouterSolicits	222
	"network.icmp6.outroutersolicits",
#define ICMPV6_OutNeighborSolicits	223
	"network.icmp6.outneighborsolicits",
#define ICMPV6_OutNeighborAdvertisements	224
	"network.icmp6.outneighboradvertisements",
#define ICMPV6_OutRedirects	225
	"network.icmp6.outredirects",
#define ICMPV6_OutGroupMembResponses	226
	"network.icmp6.outgroupmembresponses",
#define ICMPV6_OutGroupMembReductions	227
	"network.icmp6.outgroupmembreductions",
#define UDPV6_InDatagrams	228
	"network.udp6.indatagrams",
#define UDPV6_NoPorts	229
	"network.udp6.noports",
#define UDPV6_InErrors	230
	"network.udp6.inerrors",
#define UDPV6_OutDatagrams	231
	"network.udp6.outdatagrams",

/* /proc/net/sockstat */
#define NET_SOCKSTAT_TCPMEM	232
	"network.sockstat.tcp.mem",
#define NET_SOCKSTAT_UDPMEM	233
	"network.sockstat.udp.mem",

/* /proc/diskstats or /proc/partitions */
#define PERDISK_NREAD	234
	"disk.dev.read",
#define PERDISK_NRSECT	235
	"disk.dev.blkread",
#define PERDISK_NWRITE	236
	"disk.dev.write",
#define PERDISK_NWSECT	237
	"disk.dev.blkwrite",
#define PERDISK_IO_MS	238
	"disk.dev.avactive",
#define PERDISK_AVEQ	239
	"disk.dev.aveq",
#define PERDISK_NDISC	240
	"disk.dev.discard",
#define PERDISK_NDSECT	241
	"disk.dev.blkdiscard",
#define PERDISK_INFLIGHT	242
	"disk.dev.inflight",
#define PERDM_NREAD	243
	"disk.dm.read",
#define PERDM_NRSECT	244
	"disk.dm.blkread",
#define PERDM_NWRITE	245
	"disk.dm.write",
#define PERDM_NWSECT	246
	"disk.dm.blkwrite",
#define PERDM_NDISC	247
	"disk.dm.discard",
#define PERDM_NDSECT	248
	"disk.dm.blkdiscard",
#define PERDM_INFLIGHT	249
	"disk.dm.inflight",
#define PERMD_NREAD	250
	"disk.md.read",
#define PERMD_NRSECT	251
	"disk.md.blkread",
#define PERMD_NWRITE	252
	"disk.md.write",
#define PERMD_NWSECT	253
	"disk.md.blkwrite",
#define PERMD_NDISC	254
	"disk.md.discard",
#define PERMD_NDSECT	255
	"disk.md.blkdiscard",
#define PERMD_INFLIGHT	256
	"disk.md.inflight",

/* /proc/net/rpc/nfsd */
#define NFS_RCHITS	257
	"rpc.server.rchits",
#define NFS_RCMISS	258
	"rpc.server.rcmisses",
#define NFS_RCNOCACHE	259
	"rpc.server.rcnocache",
#define NFS_IORD	260
	"rpc.server.io_read",
#define NFS_IOWR	261
	"rpc.server.io_write",
#define NFS_NETCNT	262
	"rpc.server.netcnt",
#define NFS_UDP	263
	"rpc.server.netudpcnt",
#define NFS_TCP	264
	"rpc.server.nettcpcnt",
#define NFS_TCPCONN	265
	"rpc.server.nettcpconn",
#define NFS_RPCCNT	266
	"rpc.server.rpccnt",
#define NFS_RPCBADFMT	267
	"rpc.server.rpcbadfmt",
#define NFS_RPCBADAUTH	268
	"rpc.server.rpcbadauth",
#define NFS_RPCBADCLNT	269
	"rpc.server.rpcbadclnt",
#define NFS_REQS	270
	"nfs.server.reqs",
#define NFS3_REQS	271
	"nfs3.server.reqs",
#define NFS4_REQS	272
	"nfs4.server.reqs",

/* /proc/net/rpc/nfs */
#define NFC_RPCCNT	273
	"rpc.client.rpccnt",
#define NFC_RETRANS	274
	"rpc.client.rpcretrans",
#define NFC_AUTHREFRESH	275
	"rpc.client.rpcauthrefresh",
#define NFC_REQS	276
	"nfs.client.reqs",
#define NFC3_REQS	277
	"nfs3.client.reqs",
#define NFC4_REQS	278
	"nfs4.client.reqs",

/* /proc/self/mountstats */
#define PERNFS_EXPORT	279
	"nfsclient.export",
#define PERNFS_AGE	280
	"nfsclient.age",
#define PERNFS_RDBYTES	281
	"nfsclient.bytes.read.normal",
#define PERNFS_WRBYTES	282
	"nfsclient.bytes.write.normal",
#define PERNFS_DRDBYTES	283
	"nfsclient.bytes.read.direct",
#define PERNFS_DWRBYTES	284
	"nfsclient.bytes.write.direct",
#define PERNFS_TOTRDBYTES	285
	"nfsclient.bytes.read.server",
#define PERNFS_TOTWRBYTES	286
	"nfsclient.bytes.write.server",
#define PERNFS_RDPAGES	287
	"nfsclient.pages.read",
#define PERNFS_WRPAGES	288
	"nfsclient.pages.write",

/* /proc/pressure/{cpu,memory,io} */
#define PSI_CPUSOME_AVG	289
	"kernel.all.pressure.cpu.some.avg",
#define PSI_CPUSOME_TOTAL	290
	"kernel.all.pressure.cpu.some.total",
#define PSI_MEMSOME_AVG	291
	"kernel.all.pressure.memory.some.avg",
#define PSI_MEMSOME_TOTAL	292
	"kernel.all.pressure.memory.some.total",
#define PSI_MEMFULL_AVG	293
	"kernel.all.pressure.memory.full.avg",
#define PSI_MEMFULL_TOTAL	294
	"kernel.all.pressure.memory.full.total",
#define PSI_IOSOME_AVG	295
	"kernel.all.pressure.io.some.avg",
#define PSI_IOSOME_TOTAL	296
	"kernel.all.pressure.io.some.total",
#define PSI_IOFULL_AVG	297
	"kernel.all.pressure.io.full.avg",
#define PSI_IOFULL_TOTAL	298
	"kernel.all.pressure.io.full.total",

/* /proc/spl/kstat/zfs/arcstats */
#define ZFS_ARCSIZE	299
	"zfs.arc.size",

/* /sys/kernel/debug/zswap */
#define ZSWAP_TOTALSIZE	300
	"zswap.pool_total_size",
#define ZSWAP_STOREDMEM	301
	"zswap.stored_pages",

/* /sys/module/zswap/parameters/enabled */
#define ZSWAP_STATE	302
	"sysfs.module.zswap.enabled",

/* hardware events */
#define PERCPU_PERF_INST1	303
	"perfevent.hwcounters.INSTRUCTION_RETIRED.value",
#define PERCPU_PERF_INSTR	304
	"perfevent.hwcounters.INSTRUCTIONS_RETIRED.value",
#define PERCPU_PERF_CYCLE	305
	"perfevent.hwcounters.UNHALTED_REFERENCE_CYCLES.value",

/* Infiniband */
#define PERIFB_PORT_LID	306
	"infiniband.port.lid",
#define PERIFB_PORT_RATE	307
	"infiniband.port.rate",
#define PERIFB_PORT_WIDTH	308
	"infiniband.port.linkwidth",
#define PERIFB_PORT_INB	309
	"infiniband.port.in.bytes",
#define PERIFB_PORT_OUTB	310
	"infiniband.port.out.bytes",
#define PERIFB_PORT_INPKT	311
	"infiniband.port.in.packets",
#define PERIFB_PORT_OUTPKT	312
	"infiniband.port.out.packets",

/* http status */
#define WWW_ACCESSES	313
	"apache.total_accesses",
#define WWW_TOTKBYTES	314
	"apache.total_kbytes",
#define WWW_UPTIME	315
	"apache.uptime",
#define WWW_BWORKERS	316
	"apache.busy_servers",
#define WWW_IWORKERS	317
	"apache.idle_servers",

/* Nvidia GPUs */
#define GPU_CARDNAME	318
	"nvidia.cardname",
#define GPU_BUSID	319
	"nvidia.busid",
#define GPU_GPUBUSY	320
	"nvidia.gpuactive",
#define GPU_MEMBUSY	321
	"nvidia.memactive",
#define GPU_MEMUSED	322
	"nvidia.memused",
#define GPU_MEMTOTAL	323
	"nvidia.memtotal",
#define GPU_NGPUPROCS	324
	"nvidia.nprocs",
#define GPU_SAMPLES	325
	"nvidia.samples",
#define GPU_GPUBUSY_ACCUM	326
	"nvidia.gpuutilaccum",
#define GPU_MEMBUSY_ACCUM	327
	"nvidia.memutilaccum",
#define GPU_MEMUSED_ACCUM	328
	"nvidia.memusedaccum",

/* LLC Last-Level Cache of CPU info. */
#define LLC_OCCUPANCY	329
	"resctrl.llc.occupancy",
#define LLC_MBM_LOCAL	330
	"resctrl.llc.mbm_local",
#define LLC_MBM_TOTAL	331
	"resctrl.llc.mbm_total",

/* end marker - provides count */
#define SYST_NMETRICS	332
	".",

};

