/* s3 compat server functions auto-generated by pidl */
#include "bin/default/librpc/gen_ndr/ndr_netlogon.h"
#include "bin/default/librpc/gen_ndr/ndr_netlogon_scompat.h"
#include <librpc/rpc/dcesrv_core.h>
#include <rpc_server/rpc_config.h>
#include <rpc_server/rpc_server.h>
#include <util/debug.h>

enum s3compat_rpc_dispatch {
	S3COMPAT_RPC_DISPATCH_EXTERNAL = 0x00000001,
	S3COMPAT_RPC_DISPATCH_INTERNAL = 0x00000002,
};

/* netlogon - dcerpc server boilerplate generated by pidl */
static NTSTATUS netlogon__op_bind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETLOGON_BIND
	return DCESRV_INTERFACE_NETLOGON_BIND(context,iface);
#else
	return NT_STATUS_OK;
#endif
}

static void netlogon__op_unbind(struct dcesrv_connection_context *context, const struct dcesrv_interface *iface)
{
#ifdef DCESRV_INTERFACE_NETLOGON_UNBIND
	DCESRV_INTERFACE_NETLOGON_UNBIND(context, iface);
#else
	return;
#endif
}

NTSTATUS netlogon__op_ndr_pull(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_pull *pull, void **r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	dce_call->fault_code = 0;

	if (opnum >= ndr_table_netlogon.num_calls) {
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	*r = talloc_named(mem_ctx, ndr_table_netlogon.calls[opnum].struct_size, "struct %s", ndr_table_netlogon.calls[opnum].name);
	NT_STATUS_HAVE_NO_MEMORY(*r);

	/* unravel the NDR for the packet */
	ndr_err = ndr_table_netlogon.calls[opnum].ndr_pull(pull, NDR_IN, *r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

static NTSTATUS netlogon__op_dispatch_internal(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r, enum s3compat_rpc_dispatch dispatch)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;
	struct pipes_struct *p = NULL;
	NTSTATUS status = NT_STATUS_OK;
	bool impersonated = false;

	/* Retrieve pipes struct */
	p = dcesrv_get_pipes_struct(dce_call->conn);
	p->dce_call = dce_call;
	p->mem_ctx = mem_ctx;
	/* Reset pipes struct fault state */
	p->fault_state = 0;

	/* Impersonate */
	if (dispatch == S3COMPAT_RPC_DISPATCH_EXTERNAL) {
		impersonated = become_authenticated_pipe_user(dce_call->auth_state->session_info);
		if (!impersonated) {
			dce_call->fault_code = DCERPC_FAULT_ACCESS_DENIED;
			status = NT_STATUS_NET_WRITE_FAULT;
			goto fail;
		}
	}

	switch (opnum) {
	case 0: { /* netr_LogonUasLogon */
		struct netr_LogonUasLogon *r2 = (struct netr_LogonUasLogon *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogon, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct netr_UasInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonUasLogon(p, r2);
		break;
	}
	case 1: { /* netr_LogonUasLogoff */
		struct netr_LogonUasLogoff *r2 = (struct netr_LogonUasLogoff *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogoff, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct netr_UasLogoffInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonUasLogoff(p, r2);
		break;
	}
	case 2: { /* netr_LogonSamLogon */
		struct netr_LogonSamLogon *r2 = (struct netr_LogonSamLogon *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogon, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.validation = talloc_zero(r2, union netr_Validation);
		if (r2->out.validation == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.authoritative = talloc_zero(r2, uint8_t);
		if (r2->out.authoritative == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonSamLogon(p, r2);
		break;
	}
	case 3: { /* netr_LogonSamLogoff */
		struct netr_LogonSamLogoff *r2 = (struct netr_LogonSamLogoff *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogoff, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.result = _netr_LogonSamLogoff(p, r2);
		break;
	}
	case 4: { /* netr_ServerReqChallenge */
		struct netr_ServerReqChallenge *r2 = (struct netr_ServerReqChallenge *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerReqChallenge, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_credentials = talloc_zero(r2, struct netr_Credential);
		if (r2->out.return_credentials == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerReqChallenge(p, r2);
		break;
	}
	case 5: { /* netr_ServerAuthenticate */
		struct netr_ServerAuthenticate *r2 = (struct netr_ServerAuthenticate *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_credentials = talloc_zero(r2, struct netr_Credential);
		if (r2->out.return_credentials == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerAuthenticate(p, r2);
		break;
	}
	case 6: { /* netr_ServerPasswordSet */
		struct netr_ServerPasswordSet *r2 = (struct netr_ServerPasswordSet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerPasswordSet(p, r2);
		break;
	}
	case 7: { /* netr_DatabaseDeltas */
		struct netr_DatabaseDeltas *r2 = (struct netr_DatabaseDeltas *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseDeltas, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.sequence_num = r2->in.sequence_num;
		r2->out.delta_enum_array = talloc_zero(r2, struct netr_DELTA_ENUM_ARRAY *);
		if (r2->out.delta_enum_array == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DatabaseDeltas(p, r2);
		break;
	}
	case 8: { /* netr_DatabaseSync */
		struct netr_DatabaseSync *r2 = (struct netr_DatabaseSync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.sync_context = r2->in.sync_context;
		r2->out.delta_enum_array = talloc_zero(r2, struct netr_DELTA_ENUM_ARRAY *);
		if (r2->out.delta_enum_array == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DatabaseSync(p, r2);
		break;
	}
	case 9: { /* netr_AccountDeltas */
		struct netr_AccountDeltas *r2 = (struct netr_AccountDeltas *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountDeltas, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.buffer = talloc_zero(r2, struct netr_AccountBuffer);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.count_returned = talloc_zero(r2, uint32_t);
		if (r2->out.count_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.total_entries = talloc_zero(r2, uint32_t);
		if (r2->out.total_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.recordid = talloc_zero(r2, struct netr_UAS_INFO_0);
		if (r2->out.recordid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_AccountDeltas(p, r2);
		break;
	}
	case 10: { /* netr_AccountSync */
		struct netr_AccountSync *r2 = (struct netr_AccountSync *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountSync, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.recordid = r2->in.recordid;
		r2->out.buffer = talloc_zero(r2, struct netr_AccountBuffer);
		if (r2->out.buffer == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.count_returned = talloc_zero(r2, uint32_t);
		if (r2->out.count_returned == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.total_entries = talloc_zero(r2, uint32_t);
		if (r2->out.total_entries == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.next_reference = talloc_zero(r2, uint32_t);
		if (r2->out.next_reference == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_AccountSync(p, r2);
		break;
	}
	case 11: { /* netr_GetDcName */
		struct netr_GetDcName *r2 = (struct netr_GetDcName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetDcName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dcname = talloc_zero(r2, const char *);
		if (r2->out.dcname == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_GetDcName(p, r2);
		break;
	}
	case 12: { /* netr_LogonControl */
		struct netr_LogonControl *r2 = (struct netr_LogonControl *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero(r2, union netr_CONTROL_QUERY_INFORMATION);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonControl(p, r2);
		break;
	}
	case 13: { /* netr_GetAnyDCName */
		struct netr_GetAnyDCName *r2 = (struct netr_GetAnyDCName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetAnyDCName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dcname = talloc_zero(r2, const char *);
		if (r2->out.dcname == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_GetAnyDCName(p, r2);
		break;
	}
	case 14: { /* netr_LogonControl2 */
		struct netr_LogonControl2 *r2 = (struct netr_LogonControl2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero(r2, union netr_CONTROL_QUERY_INFORMATION);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonControl2(p, r2);
		break;
	}
	case 15: { /* netr_ServerAuthenticate2 */
		struct netr_ServerAuthenticate2 *r2 = (struct netr_ServerAuthenticate2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.negotiate_flags = r2->in.negotiate_flags;
		r2->out.return_credentials = talloc_zero(r2, struct netr_Credential);
		if (r2->out.return_credentials == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerAuthenticate2(p, r2);
		break;
	}
	case 16: { /* netr_DatabaseSync2 */
		struct netr_DatabaseSync2 *r2 = (struct netr_DatabaseSync2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.sync_context = r2->in.sync_context;
		r2->out.delta_enum_array = talloc_zero(r2, struct netr_DELTA_ENUM_ARRAY *);
		if (r2->out.delta_enum_array == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DatabaseSync2(p, r2);
		break;
	}
	case 17: { /* netr_DatabaseRedo */
		struct netr_DatabaseRedo *r2 = (struct netr_DatabaseRedo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseRedo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.delta_enum_array = talloc_zero(r2, struct netr_DELTA_ENUM_ARRAY *);
		if (r2->out.delta_enum_array == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DatabaseRedo(p, r2);
		break;
	}
	case 18: { /* netr_LogonControl2Ex */
		struct netr_LogonControl2Ex *r2 = (struct netr_LogonControl2Ex *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2Ex, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.query = talloc_zero(r2, union netr_CONTROL_QUERY_INFORMATION);
		if (r2->out.query == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonControl2Ex(p, r2);
		break;
	}
	case 19: { /* netr_NetrEnumerateTrustedDomains */
		struct netr_NetrEnumerateTrustedDomains *r2 = (struct netr_NetrEnumerateTrustedDomains *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrEnumerateTrustedDomains, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.trusted_domains_blob = talloc_zero(r2, struct netr_Blob);
		if (r2->out.trusted_domains_blob == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_NetrEnumerateTrustedDomains(p, r2);
		break;
	}
	case 20: { /* netr_DsRGetDCName */
		struct netr_DsRGetDCName *r2 = (struct netr_DsRGetDCName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct netr_DsRGetDCNameInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRGetDCName(p, r2);
		break;
	}
	case 21: { /* netr_LogonGetCapabilities */
		struct netr_LogonGetCapabilities *r2 = (struct netr_LogonGetCapabilities *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetCapabilities, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.capabilities = talloc_zero(r2, union netr_Capabilities);
		if (r2->out.capabilities == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonGetCapabilities(p, r2);
		break;
	}
	case 22: { /* netr_NETRLOGONSETSERVICEBITS */
		struct netr_NETRLOGONSETSERVICEBITS *r2 = (struct netr_NETRLOGONSETSERVICEBITS *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSETSERVICEBITS, NDR_IN, r2);
		}
		r2->out.result = _netr_NETRLOGONSETSERVICEBITS(p, r2);
		break;
	}
	case 23: { /* netr_LogonGetTrustRid */
		struct netr_LogonGetTrustRid *r2 = (struct netr_LogonGetTrustRid *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetTrustRid, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonGetTrustRid(p, r2);
		break;
	}
	case 24: { /* netr_NETRLOGONCOMPUTESERVERDIGEST */
		struct netr_NETRLOGONCOMPUTESERVERDIGEST *r2 = (struct netr_NETRLOGONCOMPUTESERVERDIGEST *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, NDR_IN, r2);
		}
		r2->out.result = _netr_NETRLOGONCOMPUTESERVERDIGEST(p, r2);
		break;
	}
	case 25: { /* netr_NETRLOGONCOMPUTECLIENTDIGEST */
		struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r2 = (struct netr_NETRLOGONCOMPUTECLIENTDIGEST *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, NDR_IN, r2);
		}
		r2->out.result = _netr_NETRLOGONCOMPUTECLIENTDIGEST(p, r2);
		break;
	}
	case 26: { /* netr_ServerAuthenticate3 */
		struct netr_ServerAuthenticate3 *r2 = (struct netr_ServerAuthenticate3 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate3, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.negotiate_flags = r2->in.negotiate_flags;
		r2->out.return_credentials = talloc_zero(r2, struct netr_Credential);
		if (r2->out.return_credentials == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerAuthenticate3(p, r2);
		break;
	}
	case 27: { /* netr_DsRGetDCNameEx */
		struct netr_DsRGetDCNameEx *r2 = (struct netr_DsRGetDCNameEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct netr_DsRGetDCNameInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRGetDCNameEx(p, r2);
		break;
	}
	case 28: { /* netr_DsRGetSiteName */
		struct netr_DsRGetSiteName *r2 = (struct netr_DsRGetSiteName *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetSiteName, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.site = talloc_zero(r2, const char *);
		if (r2->out.site == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRGetSiteName(p, r2);
		break;
	}
	case 29: { /* netr_LogonGetDomainInfo */
		struct netr_LogonGetDomainInfo *r2 = (struct netr_LogonGetDomainInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetDomainInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.info = talloc_zero(r2, union netr_DomainInfo);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonGetDomainInfo(p, r2);
		break;
	}
	case 30: { /* netr_ServerPasswordSet2 */
		struct netr_ServerPasswordSet2 *r2 = (struct netr_ServerPasswordSet2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerPasswordSet2(p, r2);
		break;
	}
	case 31: { /* netr_ServerPasswordGet */
		struct netr_ServerPasswordGet *r2 = (struct netr_ServerPasswordGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordGet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.password = talloc_zero(r2, struct samr_Password);
		if (r2->out.password == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerPasswordGet(p, r2);
		break;
	}
	case 32: { /* netr_NetrLogonSendToSam */
		struct netr_NetrLogonSendToSam *r2 = (struct netr_NetrLogonSendToSam *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrLogonSendToSam, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_NetrLogonSendToSam(p, r2);
		break;
	}
	case 33: { /* netr_DsRAddressToSitenamesW */
		struct netr_DsRAddressToSitenamesW *r2 = (struct netr_DsRAddressToSitenamesW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRAddressToSitenamesW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ctr = talloc_zero(r2, struct netr_DsRAddressToSitenamesWCtr *);
		if (r2->out.ctr == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRAddressToSitenamesW(p, r2);
		break;
	}
	case 34: { /* netr_DsRGetDCNameEx2 */
		struct netr_DsRGetDCNameEx2 *r2 = (struct netr_DsRGetDCNameEx2 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx2, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.info = talloc_zero(r2, struct netr_DsRGetDCNameInfo *);
		if (r2->out.info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRGetDCNameEx2(p, r2);
		break;
	}
	case 35: { /* netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN */
		struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r2 = (struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, NDR_IN, r2);
		}
		r2->out.result = _netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(p, r2);
		break;
	}
	case 36: { /* netr_NetrEnumerateTrustedDomainsEx */
		struct netr_NetrEnumerateTrustedDomainsEx *r2 = (struct netr_NetrEnumerateTrustedDomainsEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrEnumerateTrustedDomainsEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dom_trust_list = talloc_zero(r2, struct netr_DomainTrustList);
		if (r2->out.dom_trust_list == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_NetrEnumerateTrustedDomainsEx(p, r2);
		break;
	}
	case 37: { /* netr_DsRAddressToSitenamesExW */
		struct netr_DsRAddressToSitenamesExW *r2 = (struct netr_DsRAddressToSitenamesExW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRAddressToSitenamesExW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ctr = talloc_zero(r2, struct netr_DsRAddressToSitenamesExWCtr *);
		if (r2->out.ctr == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRAddressToSitenamesExW(p, r2);
		break;
	}
	case 38: { /* netr_DsrGetDcSiteCoverageW */
		struct netr_DsrGetDcSiteCoverageW *r2 = (struct netr_DsrGetDcSiteCoverageW *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrGetDcSiteCoverageW, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.ctr = talloc_zero(r2, struct DcSitesCtr *);
		if (r2->out.ctr == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsrGetDcSiteCoverageW(p, r2);
		break;
	}
	case 39: { /* netr_LogonSamLogonEx */
		struct netr_LogonSamLogonEx *r2 = (struct netr_LogonSamLogonEx *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonEx, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.flags = r2->in.flags;
		r2->out.validation = talloc_zero(r2, union netr_Validation);
		if (r2->out.validation == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.authoritative = talloc_zero(r2, uint8_t);
		if (r2->out.authoritative == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonSamLogonEx(p, r2);
		break;
	}
	case 40: { /* netr_DsrEnumerateDomainTrusts */
		struct netr_DsrEnumerateDomainTrusts *r2 = (struct netr_DsrEnumerateDomainTrusts *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrEnumerateDomainTrusts, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.trusts = talloc_zero(r2, struct netr_DomainTrustList);
		if (r2->out.trusts == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsrEnumerateDomainTrusts(p, r2);
		break;
	}
	case 41: { /* netr_DsrDeregisterDNSHostRecords */
		struct netr_DsrDeregisterDNSHostRecords *r2 = (struct netr_DsrDeregisterDNSHostRecords *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrDeregisterDNSHostRecords, NDR_IN, r2);
		}
		r2->out.result = _netr_DsrDeregisterDNSHostRecords(p, r2);
		break;
	}
	case 42: { /* netr_ServerTrustPasswordsGet */
		struct netr_ServerTrustPasswordsGet *r2 = (struct netr_ServerTrustPasswordsGet *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerTrustPasswordsGet, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.new_owf_password = talloc_zero(r2, struct samr_Password);
		if (r2->out.new_owf_password == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.old_owf_password = talloc_zero(r2, struct samr_Password);
		if (r2->out.old_owf_password == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerTrustPasswordsGet(p, r2);
		break;
	}
	case 43: { /* netr_DsRGetForestTrustInformation */
		struct netr_DsRGetForestTrustInformation *r2 = (struct netr_DsRGetForestTrustInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetForestTrustInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.forest_trust_info = talloc_zero(r2, struct lsa_ForestTrustInformation *);
		if (r2->out.forest_trust_info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsRGetForestTrustInformation(p, r2);
		break;
	}
	case 44: { /* netr_GetForestTrustInformation */
		struct netr_GetForestTrustInformation *r2 = (struct netr_GetForestTrustInformation *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetForestTrustInformation, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.forest_trust_info = talloc_zero(r2, struct lsa_ForestTrustInformation *);
		if (r2->out.forest_trust_info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_GetForestTrustInformation(p, r2);
		break;
	}
	case 45: { /* netr_LogonSamLogonWithFlags */
		struct netr_LogonSamLogonWithFlags *r2 = (struct netr_LogonSamLogonWithFlags *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonWithFlags, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = r2->in.return_authenticator;
		r2->out.flags = r2->in.flags;
		r2->out.validation = talloc_zero(r2, union netr_Validation);
		if (r2->out.validation == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.authoritative = talloc_zero(r2, uint8_t);
		if (r2->out.authoritative == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_LogonSamLogonWithFlags(p, r2);
		break;
	}
	case 46: { /* netr_ServerGetTrustInfo */
		struct netr_ServerGetTrustInfo *r2 = (struct netr_ServerGetTrustInfo *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerGetTrustInfo, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.new_owf_password = talloc_zero(r2, struct samr_Password);
		if (r2->out.new_owf_password == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.old_owf_password = talloc_zero(r2, struct samr_Password);
		if (r2->out.old_owf_password == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.trust_info = talloc_zero(r2, struct netr_TrustInfo *);
		if (r2->out.trust_info == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerGetTrustInfo(p, r2);
		break;
	}
	case 47: { /* netr_Unused47 */
		struct netr_Unused47 *r2 = (struct netr_Unused47 *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Unused47, NDR_IN, r2);
		}
		r2->out.result = _netr_Unused47(p, r2);
		break;
	}
	case 48: { /* netr_DsrUpdateReadOnlyServerDnsRecords */
		struct netr_DsrUpdateReadOnlyServerDnsRecords *r2 = (struct netr_DsrUpdateReadOnlyServerDnsRecords *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrUpdateReadOnlyServerDnsRecords, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.dns_names = r2->in.dns_names;
		r2->out.return_authenticator = talloc_zero(r2, struct netr_Authenticator);
		if (r2->out.return_authenticator == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_DsrUpdateReadOnlyServerDnsRecords(p, r2);
		break;
	}
	case 49: { /* netr_Opnum49NotUsedOnWire */
		struct netr_Opnum49NotUsedOnWire *r2 = (struct netr_Opnum49NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum49NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum49NotUsedOnWire(p, r2);
		break;
	}
	case 50: { /* netr_Opnum50NotUsedOnWire */
		struct netr_Opnum50NotUsedOnWire *r2 = (struct netr_Opnum50NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum50NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum50NotUsedOnWire(p, r2);
		break;
	}
	case 51: { /* netr_Opnum51NotUsedOnWire */
		struct netr_Opnum51NotUsedOnWire *r2 = (struct netr_Opnum51NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum51NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum51NotUsedOnWire(p, r2);
		break;
	}
	case 52: { /* netr_Opnum52NotUsedOnWire */
		struct netr_Opnum52NotUsedOnWire *r2 = (struct netr_Opnum52NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum52NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum52NotUsedOnWire(p, r2);
		break;
	}
	case 53: { /* netr_Opnum53NotUsedOnWire */
		struct netr_Opnum53NotUsedOnWire *r2 = (struct netr_Opnum53NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum53NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum53NotUsedOnWire(p, r2);
		break;
	}
	case 54: { /* netr_ChainSetClientAttributes */
		struct netr_ChainSetClientAttributes *r2 = (struct netr_ChainSetClientAttributes *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ChainSetClientAttributes, NDR_IN, r2);
		}
		r2->out.result = _netr_ChainSetClientAttributes(p, r2);
		break;
	}
	case 55: { /* netr_Opnum55NotUsedOnWire */
		struct netr_Opnum55NotUsedOnWire *r2 = (struct netr_Opnum55NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum55NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum55NotUsedOnWire(p, r2);
		break;
	}
	case 56: { /* netr_Opnum56NotUsedOnWire */
		struct netr_Opnum56NotUsedOnWire *r2 = (struct netr_Opnum56NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum56NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum56NotUsedOnWire(p, r2);
		break;
	}
	case 57: { /* netr_Opnum57NotUsedOnWire */
		struct netr_Opnum57NotUsedOnWire *r2 = (struct netr_Opnum57NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum57NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum57NotUsedOnWire(p, r2);
		break;
	}
	case 58: { /* netr_Opnum58NotUsedOnWire */
		struct netr_Opnum58NotUsedOnWire *r2 = (struct netr_Opnum58NotUsedOnWire *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum58NotUsedOnWire, NDR_IN, r2);
		}
		_netr_Opnum58NotUsedOnWire(p, r2);
		break;
	}
	case 59: { /* netr_ServerAuthenticateKerberos */
		struct netr_ServerAuthenticateKerberos *r2 = (struct netr_ServerAuthenticateKerberos *)r;
		if (DEBUGLEVEL >= 10) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticateKerberos, NDR_IN, r2);
		}
		NDR_ZERO_STRUCT(r2->out);
		r2->out.negotiate_flags = r2->in.negotiate_flags;
		r2->out.rid = talloc_zero(r2, uint32_t);
		if (r2->out.rid == NULL) {
			status = NT_STATUS_NO_MEMORY;
			p->fault_state = DCERPC_FAULT_CANT_PERFORM;
			goto fail;
		}

		r2->out.result = _netr_ServerAuthenticateKerberos(p, r2);
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

fail:
	/* Unimpersonate */
	if (impersonated) {
		unbecome_authenticated_pipe_user();
	}

	p->dce_call = NULL;
	p->mem_ctx = NULL;
	/* Check pipes struct fault state */
	if (p->fault_state != 0) {
		dce_call->fault_code = p->fault_state;
	}
	if (dce_call->fault_code != 0) {
		status = NT_STATUS_NET_WRITE_FAULT;
	}

	return status;
}

NTSTATUS netlogon__op_dispatch(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return netlogon__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_EXTERNAL);
}

NTSTATUS netlogon__op_reply(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	switch (opnum) {
	case 0: { /* netr_LogonUasLogon */
		struct netr_LogonUasLogon *r2 = (struct netr_LogonUasLogon *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogon replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogon, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonUasLogon\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 1: { /* netr_LogonUasLogoff */
		struct netr_LogonUasLogoff *r2 = (struct netr_LogonUasLogoff *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonUasLogoff replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonUasLogoff, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonUasLogoff\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 2: { /* netr_LogonSamLogon */
		struct netr_LogonSamLogon *r2 = (struct netr_LogonSamLogon *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogon replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogon, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonSamLogon\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 3: { /* netr_LogonSamLogoff */
		struct netr_LogonSamLogoff *r2 = (struct netr_LogonSamLogoff *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogoff replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogoff, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonSamLogoff\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 4: { /* netr_ServerReqChallenge */
		struct netr_ServerReqChallenge *r2 = (struct netr_ServerReqChallenge *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerReqChallenge replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerReqChallenge, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerReqChallenge\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 5: { /* netr_ServerAuthenticate */
		struct netr_ServerAuthenticate *r2 = (struct netr_ServerAuthenticate *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerAuthenticate\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 6: { /* netr_ServerPasswordSet */
		struct netr_ServerPasswordSet *r2 = (struct netr_ServerPasswordSet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerPasswordSet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 7: { /* netr_DatabaseDeltas */
		struct netr_DatabaseDeltas *r2 = (struct netr_DatabaseDeltas *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseDeltas replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseDeltas, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DatabaseDeltas\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 8: { /* netr_DatabaseSync */
		struct netr_DatabaseSync *r2 = (struct netr_DatabaseSync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DatabaseSync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 9: { /* netr_AccountDeltas */
		struct netr_AccountDeltas *r2 = (struct netr_AccountDeltas *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountDeltas replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountDeltas, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_AccountDeltas\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 10: { /* netr_AccountSync */
		struct netr_AccountSync *r2 = (struct netr_AccountSync *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_AccountSync replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_AccountSync, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_AccountSync\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 11: { /* netr_GetDcName */
		struct netr_GetDcName *r2 = (struct netr_GetDcName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetDcName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetDcName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_GetDcName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 12: { /* netr_LogonControl */
		struct netr_LogonControl *r2 = (struct netr_LogonControl *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonControl\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 13: { /* netr_GetAnyDCName */
		struct netr_GetAnyDCName *r2 = (struct netr_GetAnyDCName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetAnyDCName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetAnyDCName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_GetAnyDCName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 14: { /* netr_LogonControl2 */
		struct netr_LogonControl2 *r2 = (struct netr_LogonControl2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonControl2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 15: { /* netr_ServerAuthenticate2 */
		struct netr_ServerAuthenticate2 *r2 = (struct netr_ServerAuthenticate2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerAuthenticate2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 16: { /* netr_DatabaseSync2 */
		struct netr_DatabaseSync2 *r2 = (struct netr_DatabaseSync2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseSync2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseSync2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DatabaseSync2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 17: { /* netr_DatabaseRedo */
		struct netr_DatabaseRedo *r2 = (struct netr_DatabaseRedo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DatabaseRedo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DatabaseRedo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DatabaseRedo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 18: { /* netr_LogonControl2Ex */
		struct netr_LogonControl2Ex *r2 = (struct netr_LogonControl2Ex *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonControl2Ex replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonControl2Ex, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonControl2Ex\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 19: { /* netr_NetrEnumerateTrustedDomains */
		struct netr_NetrEnumerateTrustedDomains *r2 = (struct netr_NetrEnumerateTrustedDomains *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NetrEnumerateTrustedDomains replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrEnumerateTrustedDomains, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NetrEnumerateTrustedDomains\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 20: { /* netr_DsRGetDCName */
		struct netr_DsRGetDCName *r2 = (struct netr_DsRGetDCName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRGetDCName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 21: { /* netr_LogonGetCapabilities */
		struct netr_LogonGetCapabilities *r2 = (struct netr_LogonGetCapabilities *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonGetCapabilities replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetCapabilities, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonGetCapabilities\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 22: { /* netr_NETRLOGONSETSERVICEBITS */
		struct netr_NETRLOGONSETSERVICEBITS *r2 = (struct netr_NETRLOGONSETSERVICEBITS *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONSETSERVICEBITS replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONSETSERVICEBITS, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NETRLOGONSETSERVICEBITS\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 23: { /* netr_LogonGetTrustRid */
		struct netr_LogonGetTrustRid *r2 = (struct netr_LogonGetTrustRid *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonGetTrustRid replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetTrustRid, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonGetTrustRid\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 24: { /* netr_NETRLOGONCOMPUTESERVERDIGEST */
		struct netr_NETRLOGONCOMPUTESERVERDIGEST *r2 = (struct netr_NETRLOGONCOMPUTESERVERDIGEST *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTESERVERDIGEST replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTESERVERDIGEST, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NETRLOGONCOMPUTESERVERDIGEST\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 25: { /* netr_NETRLOGONCOMPUTECLIENTDIGEST */
		struct netr_NETRLOGONCOMPUTECLIENTDIGEST *r2 = (struct netr_NETRLOGONCOMPUTECLIENTDIGEST *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONCOMPUTECLIENTDIGEST replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONCOMPUTECLIENTDIGEST, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NETRLOGONCOMPUTECLIENTDIGEST\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 26: { /* netr_ServerAuthenticate3 */
		struct netr_ServerAuthenticate3 *r2 = (struct netr_ServerAuthenticate3 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticate3 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticate3, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerAuthenticate3\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 27: { /* netr_DsRGetDCNameEx */
		struct netr_DsRGetDCNameEx *r2 = (struct netr_DsRGetDCNameEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRGetDCNameEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 28: { /* netr_DsRGetSiteName */
		struct netr_DsRGetSiteName *r2 = (struct netr_DsRGetSiteName *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetSiteName replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetSiteName, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRGetSiteName\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 29: { /* netr_LogonGetDomainInfo */
		struct netr_LogonGetDomainInfo *r2 = (struct netr_LogonGetDomainInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonGetDomainInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonGetDomainInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonGetDomainInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 30: { /* netr_ServerPasswordSet2 */
		struct netr_ServerPasswordSet2 *r2 = (struct netr_ServerPasswordSet2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordSet2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordSet2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerPasswordSet2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 31: { /* netr_ServerPasswordGet */
		struct netr_ServerPasswordGet *r2 = (struct netr_ServerPasswordGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerPasswordGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerPasswordGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerPasswordGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 32: { /* netr_NetrLogonSendToSam */
		struct netr_NetrLogonSendToSam *r2 = (struct netr_NetrLogonSendToSam *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NetrLogonSendToSam replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrLogonSendToSam, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NetrLogonSendToSam\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 33: { /* netr_DsRAddressToSitenamesW */
		struct netr_DsRAddressToSitenamesW *r2 = (struct netr_DsRAddressToSitenamesW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRAddressToSitenamesW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRAddressToSitenamesW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRAddressToSitenamesW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 34: { /* netr_DsRGetDCNameEx2 */
		struct netr_DsRGetDCNameEx2 *r2 = (struct netr_DsRGetDCNameEx2 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetDCNameEx2 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetDCNameEx2, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRGetDCNameEx2\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 35: { /* netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN */
		struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *r2 = (struct netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 36: { /* netr_NetrEnumerateTrustedDomainsEx */
		struct netr_NetrEnumerateTrustedDomainsEx *r2 = (struct netr_NetrEnumerateTrustedDomainsEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_NetrEnumerateTrustedDomainsEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_NetrEnumerateTrustedDomainsEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_NetrEnumerateTrustedDomainsEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 37: { /* netr_DsRAddressToSitenamesExW */
		struct netr_DsRAddressToSitenamesExW *r2 = (struct netr_DsRAddressToSitenamesExW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRAddressToSitenamesExW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRAddressToSitenamesExW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRAddressToSitenamesExW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 38: { /* netr_DsrGetDcSiteCoverageW */
		struct netr_DsrGetDcSiteCoverageW *r2 = (struct netr_DsrGetDcSiteCoverageW *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrGetDcSiteCoverageW replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrGetDcSiteCoverageW, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsrGetDcSiteCoverageW\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 39: { /* netr_LogonSamLogonEx */
		struct netr_LogonSamLogonEx *r2 = (struct netr_LogonSamLogonEx *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonEx replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonEx, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonSamLogonEx\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 40: { /* netr_DsrEnumerateDomainTrusts */
		struct netr_DsrEnumerateDomainTrusts *r2 = (struct netr_DsrEnumerateDomainTrusts *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrEnumerateDomainTrusts replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrEnumerateDomainTrusts, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsrEnumerateDomainTrusts\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 41: { /* netr_DsrDeregisterDNSHostRecords */
		struct netr_DsrDeregisterDNSHostRecords *r2 = (struct netr_DsrDeregisterDNSHostRecords *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrDeregisterDNSHostRecords replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrDeregisterDNSHostRecords, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsrDeregisterDNSHostRecords\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 42: { /* netr_ServerTrustPasswordsGet */
		struct netr_ServerTrustPasswordsGet *r2 = (struct netr_ServerTrustPasswordsGet *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerTrustPasswordsGet replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerTrustPasswordsGet, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerTrustPasswordsGet\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 43: { /* netr_DsRGetForestTrustInformation */
		struct netr_DsRGetForestTrustInformation *r2 = (struct netr_DsRGetForestTrustInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsRGetForestTrustInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsRGetForestTrustInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsRGetForestTrustInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 44: { /* netr_GetForestTrustInformation */
		struct netr_GetForestTrustInformation *r2 = (struct netr_GetForestTrustInformation *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_GetForestTrustInformation replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_GetForestTrustInformation, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_GetForestTrustInformation\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 45: { /* netr_LogonSamLogonWithFlags */
		struct netr_LogonSamLogonWithFlags *r2 = (struct netr_LogonSamLogonWithFlags *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_LogonSamLogonWithFlags replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_LogonSamLogonWithFlags, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_LogonSamLogonWithFlags\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 46: { /* netr_ServerGetTrustInfo */
		struct netr_ServerGetTrustInfo *r2 = (struct netr_ServerGetTrustInfo *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerGetTrustInfo replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerGetTrustInfo, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerGetTrustInfo\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 47: { /* netr_Unused47 */
		struct netr_Unused47 *r2 = (struct netr_Unused47 *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Unused47 replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Unused47, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Unused47\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 48: { /* netr_DsrUpdateReadOnlyServerDnsRecords */
		struct netr_DsrUpdateReadOnlyServerDnsRecords *r2 = (struct netr_DsrUpdateReadOnlyServerDnsRecords *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_DsrUpdateReadOnlyServerDnsRecords replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_DsrUpdateReadOnlyServerDnsRecords, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_DsrUpdateReadOnlyServerDnsRecords\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 49: { /* netr_Opnum49NotUsedOnWire */
		struct netr_Opnum49NotUsedOnWire *r2 = (struct netr_Opnum49NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum49NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum49NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum49NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 50: { /* netr_Opnum50NotUsedOnWire */
		struct netr_Opnum50NotUsedOnWire *r2 = (struct netr_Opnum50NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum50NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum50NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum50NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 51: { /* netr_Opnum51NotUsedOnWire */
		struct netr_Opnum51NotUsedOnWire *r2 = (struct netr_Opnum51NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum51NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum51NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum51NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 52: { /* netr_Opnum52NotUsedOnWire */
		struct netr_Opnum52NotUsedOnWire *r2 = (struct netr_Opnum52NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum52NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum52NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum52NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 53: { /* netr_Opnum53NotUsedOnWire */
		struct netr_Opnum53NotUsedOnWire *r2 = (struct netr_Opnum53NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum53NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum53NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum53NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 54: { /* netr_ChainSetClientAttributes */
		struct netr_ChainSetClientAttributes *r2 = (struct netr_ChainSetClientAttributes *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ChainSetClientAttributes replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ChainSetClientAttributes, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ChainSetClientAttributes\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 55: { /* netr_Opnum55NotUsedOnWire */
		struct netr_Opnum55NotUsedOnWire *r2 = (struct netr_Opnum55NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum55NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum55NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum55NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 56: { /* netr_Opnum56NotUsedOnWire */
		struct netr_Opnum56NotUsedOnWire *r2 = (struct netr_Opnum56NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum56NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum56NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum56NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 57: { /* netr_Opnum57NotUsedOnWire */
		struct netr_Opnum57NotUsedOnWire *r2 = (struct netr_Opnum57NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum57NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum57NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum57NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 58: { /* netr_Opnum58NotUsedOnWire */
		struct netr_Opnum58NotUsedOnWire *r2 = (struct netr_Opnum58NotUsedOnWire *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_Opnum58NotUsedOnWire replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_Opnum58NotUsedOnWire, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_Opnum58NotUsedOnWire\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	case 59: { /* netr_ServerAuthenticateKerberos */
		struct netr_ServerAuthenticateKerberos *r2 = (struct netr_ServerAuthenticateKerberos *)r;
		if (dce_call->state_flags & DCESRV_CALL_STATE_FLAG_ASYNC) {
			DEBUG(5,("function netr_ServerAuthenticateKerberos replied async\n"));
		}
		if (DEBUGLEVEL >= 10 && dce_call->fault_code == 0) {
			NDR_PRINT_FUNCTION_DEBUG(netr_ServerAuthenticateKerberos, NDR_OUT | NDR_SET_VALUES, r2);
		}
		if (dce_call->fault_code != 0) {
			DBG_WARNING("dcerpc_fault %s in netr_ServerAuthenticateKerberos\n", dcerpc_errstr(mem_ctx, dce_call->fault_code));
		}
		break;
	}
	default:
		dce_call->fault_code = DCERPC_FAULT_OP_RNG_ERROR;
		break;
	}

	if (dce_call->fault_code != 0) {
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS netlogon__op_ndr_push(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, struct ndr_push *push, const void *r)
{
	enum ndr_err_code ndr_err;
	uint16_t opnum = dce_call->pkt.u.request.opnum;

	ndr_err = ndr_table_netlogon.calls[opnum].ndr_push(push, NDR_OUT, r);
	if (!NDR_ERR_CODE_IS_SUCCESS(ndr_err)) {
		dce_call->fault_code = DCERPC_FAULT_NDR;
		return NT_STATUS_NET_WRITE_FAULT;
	}

	return NT_STATUS_OK;
}

NTSTATUS netlogon__op_local(struct dcesrv_call_state *dce_call, TALLOC_CTX *mem_ctx, void *r)
{
	return netlogon__op_dispatch_internal(dce_call, mem_ctx, r, S3COMPAT_RPC_DISPATCH_INTERNAL);
}

static const struct dcesrv_interface dcesrv_netlogon_interface = {
	.name      = "netlogon",
	.syntax_id = {{0x12345678,0x1234,0xabcd,{0xef,0x00},{0x01,0x23,0x45,0x67,0xcf,0xfb}},1.0},
	.bind      = netlogon__op_bind,
	.unbind    = netlogon__op_unbind,
	.ndr_pull  = netlogon__op_ndr_pull,
	.dispatch  = netlogon__op_dispatch,
	.reply     = netlogon__op_reply,
	.ndr_push  = netlogon__op_ndr_push,
	.local     = netlogon__op_local,
#ifdef DCESRV_INTERFACE_NETLOGON_FLAGS
	.flags     = DCESRV_INTERFACE_NETLOGON_FLAGS
#else
	.flags     = 0
#endif
};

static NTSTATUS netlogon__op_init_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	uint32_t i;
	NTSTATUS ret;

#ifdef DCESRV_INTERFACE_NETLOGON_NCACN_NP_SECONDARY_ENDPOINT
	const char *ncacn_np_secondary_endpoint = DCESRV_INTERFACE_NETLOGON_NCACN_NP_SECONDARY_ENDPOINT;
#else
	const char *ncacn_np_secondary_endpoint = NULL;
#endif

	for (i=0;i<ndr_table_netlogon.endpoints->count;i++) {
		const char *name = ndr_table_netlogon.endpoints->names[i];

		ret = dcesrv_interface_register(dce_ctx, name, ncacn_np_secondary_endpoint, &dcesrv_netlogon_interface, NULL);
		if (!NT_STATUS_IS_OK(ret)) {
			DBG_ERR("Failed to register endpoint '%s'\n",name);
			return ret;
		}
	}

	return NT_STATUS_OK;
}

static NTSTATUS netlogon__op_shutdown_server(struct dcesrv_context *dce_ctx, const struct dcesrv_endpoint_server *ep_server)
{
	return NT_STATUS_OK;
}

static bool netlogon__op_interface_by_uuid(struct dcesrv_interface *iface, const struct GUID *uuid, uint32_t if_version)
{
	if (dcesrv_netlogon_interface.syntax_id.if_version == if_version && GUID_equal(&dcesrv_netlogon_interface.syntax_id.uuid, uuid)) {
		memcpy(iface,&dcesrv_netlogon_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static bool netlogon__op_interface_by_name(struct dcesrv_interface *iface, const char *name)
{
	if (strcmp(dcesrv_netlogon_interface.name, name)==0) {
		memcpy(iface, &dcesrv_netlogon_interface, sizeof(*iface));
		return true;
	}

	return false;
}

static const struct dcesrv_endpoint_server netlogon_ep_server = {
	/* fill in our name */
	.name = "netlogon",

	/* Initialization flag */
	.initialized = false,

	/* fill in all the operations */
#ifdef DCESRV_INTERFACE_NETLOGON_INIT_SERVER
	.init_server = DCESRV_INTERFACE_NETLOGON_INIT_SERVER,
#else
	.init_server = netlogon__op_init_server,
#endif
#ifdef DCESRV_INTERFACE_NETLOGON_SHUTDOWN_SERVER
	.shutdown_server = DCESRV_INTERFACE_NETLOGON_SHUTDOWN_SERVER,
#else
	.shutdown_server = netlogon__op_shutdown_server,
#endif
	.interface_by_uuid = netlogon__op_interface_by_uuid,
	.interface_by_name = netlogon__op_interface_by_name
};

const struct dcesrv_endpoint_server *netlogon_get_ep_server(void)
{
	return &netlogon_ep_server;
}
