// Code generated by go-swagger; DO NOT EDIT.

package iam_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// IamServiceBatchGetPrincipalsReader is a Reader for the IamServiceBatchGetPrincipals structure.
type IamServiceBatchGetPrincipalsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *IamServiceBatchGetPrincipalsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewIamServiceBatchGetPrincipalsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewIamServiceBatchGetPrincipalsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewIamServiceBatchGetPrincipalsOK creates a IamServiceBatchGetPrincipalsOK with default headers values
func NewIamServiceBatchGetPrincipalsOK() *IamServiceBatchGetPrincipalsOK {
	return &IamServiceBatchGetPrincipalsOK{}
}

/*
IamServiceBatchGetPrincipalsOK describes a response with status code 200, with default header values.

A successful response.
*/
type IamServiceBatchGetPrincipalsOK struct {
	Payload *models.HashicorpCloudIamBatchGetPrincipalsResponse
}

// IsSuccess returns true when this iam service batch get principals o k response has a 2xx status code
func (o *IamServiceBatchGetPrincipalsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this iam service batch get principals o k response has a 3xx status code
func (o *IamServiceBatchGetPrincipalsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this iam service batch get principals o k response has a 4xx status code
func (o *IamServiceBatchGetPrincipalsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this iam service batch get principals o k response has a 5xx status code
func (o *IamServiceBatchGetPrincipalsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this iam service batch get principals o k response a status code equal to that given
func (o *IamServiceBatchGetPrincipalsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the iam service batch get principals o k response
func (o *IamServiceBatchGetPrincipalsOK) Code() int {
	return 200
}

func (o *IamServiceBatchGetPrincipalsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/principals][%d] iamServiceBatchGetPrincipalsOK %s", 200, payload)
}

func (o *IamServiceBatchGetPrincipalsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/principals][%d] iamServiceBatchGetPrincipalsOK %s", 200, payload)
}

func (o *IamServiceBatchGetPrincipalsOK) GetPayload() *models.HashicorpCloudIamBatchGetPrincipalsResponse {
	return o.Payload
}

func (o *IamServiceBatchGetPrincipalsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamBatchGetPrincipalsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewIamServiceBatchGetPrincipalsDefault creates a IamServiceBatchGetPrincipalsDefault with default headers values
func NewIamServiceBatchGetPrincipalsDefault(code int) *IamServiceBatchGetPrincipalsDefault {
	return &IamServiceBatchGetPrincipalsDefault{
		_statusCode: code,
	}
}

/*
IamServiceBatchGetPrincipalsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type IamServiceBatchGetPrincipalsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this iam service batch get principals default response has a 2xx status code
func (o *IamServiceBatchGetPrincipalsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this iam service batch get principals default response has a 3xx status code
func (o *IamServiceBatchGetPrincipalsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this iam service batch get principals default response has a 4xx status code
func (o *IamServiceBatchGetPrincipalsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this iam service batch get principals default response has a 5xx status code
func (o *IamServiceBatchGetPrincipalsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this iam service batch get principals default response a status code equal to that given
func (o *IamServiceBatchGetPrincipalsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the iam service batch get principals default response
func (o *IamServiceBatchGetPrincipalsDefault) Code() int {
	return o._statusCode
}

func (o *IamServiceBatchGetPrincipalsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/principals][%d] IamService_BatchGetPrincipals default %s", o._statusCode, payload)
}

func (o *IamServiceBatchGetPrincipalsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /iam/2019-12-10/organizations/{organization_id}/principals][%d] IamService_BatchGetPrincipals default %s", o._statusCode, payload)
}

func (o *IamServiceBatchGetPrincipalsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *IamServiceBatchGetPrincipalsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
