/*
  File autogenerated by gengetopt version 2.23
  generated with the following command:
  gengetopt -C --no-help --no-version --unamed-opts=SUBNETS -i /build/zmap/src/zmap-4.3.4/build/src/zopt.ggo -F /build/zmap/src/zmap-4.3.4/build/src/zopt 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef FIX_UNUSED
#define FIX_UNUSED(X) (void) (X) /* avoid warnings for unused params */
#endif

#include <getopt.h>

#include "/build/zmap/src/zmap-4.3.4/build/src/zopt.h"

const char *gengetopt_args_info_purpose = "A fast Internet-wide scanner.";

const char *gengetopt_args_info_usage = "Usage: zmap [OPTION]... [SUBNETS]...";

const char *gengetopt_args_info_versiontext = "";

const char *gengetopt_args_info_description = "";

const char *gengetopt_args_info_help[] = {
  "Basic Arguments:",
  "  -p, --target-ports=ports      comma-delimited list of ports and port ranges\n                                  to scan (for TCP and UDP scans)",
  "  -o, --output-file=name        Output file",
  "  -b, --blocklist-file=path     File of subnets to exclude, in CIDR notation,\n                                  e.g. 192.168.0.0/16",
  "  -w, --allowlist-file=path     File of subnets to constrain scan to, in CIDR\n                                  notation, e.g. 192.168.0.0/16",
  "  -I, --list-of-ips-file=path   List of individual addresses to scan in random\n                                  order. Use --allowlist-file unless >1 million\n                                  IPs",
  "\nScan Options:",
  "  -r, --rate=pps                Set send rate in packets/sec",
  "  -B, --bandwidth=bps           Set send rate in bits/second (supports suffixes\n                                  G, M and K)",
  "      --batch=pps               Set batch size for how many packets to send in\n                                  a single syscall. Advantageous on Linux or\n                                  with netmap (default=64)",
  "  -n, --max-targets=n           Cap number of targets to probe (as a number '-n\n                                  1000' or a percentage '-n 1%' of the target\n                                  search space). A target is an IP/port pair,\n                                  if scanning multiple ports, and an IP\n                                  otherwise.",
  "  -t, --max-runtime=secs        Cap length of time for sending packets",
  "  -N, --max-results=n           Cap number of results to return",
  "  -P, --probes=n                Number of probes to send to each IP/Port pair\n                                  (default=`1')",
  "  -c, --cooldown-time=secs      How long to continue receiving after sending\n                                  last probe  (default=`8')",
  "  -e, --seed=n                  Seed used to select address permutation",
  "      --retries=n               Max number of times to try to send packet if\n                                  send fails  (default=`10')",
  "  -d, --dryrun                  Don't actually send packets",
  "      --fast-dryrun             Don't actually send packets, print out a binary\n                                  representation probe dst IP and dst Port.\n                                  Used for faster integration tests, not for\n                                  general use.",
  "\nScan Sharding:",
  "      --shards=N                Set the total number of shards  (default=`1')",
  "      --shard=n                 Set which shard this scan is (0 indexed)\n                                  (default=`0')",
  "\nNetwork Options:",
  "  -s, --source-port=port|range  Source port(s) for scan packets",
  "      --validate-source-port=enable|disable\n                                Override to validate if probe responses have a\n                                  valid src port corresponding to sent probe's\n                                  dst port. \"enable\" or \"disable\"",
  "  -S, --source-ip=ip|range      Source address(es) for scan packets",
  "  -G, --gateway-mac=addr        Specify gateway MAC address",
  "      --source-mac=addr         Source MAC address",
  "  -i, --interface=name          Specify network interface to use",
  "  -X, --iplayer                 Sends IP packets instead of Ethernet (for VPNs)",
  "      --netmap-wait-ping=ip     Wait for IP to respond to ping before\n                                  commencing scan (netmap only)",
  "\nProbe Modules:",
  "  -M, --probe-module=name       Select probe module  (default=`tcp_synscan')",
  "      --probe-args=args         Arguments to pass to probe module",
  "      --probe-ttl=n             Set TTL value for probe IP packets\n                                  (default=`64')",
  "      --list-probe-modules      List available probe modules",
  "\nResults Output:",
  "  -f, --output-fields=fields    Fields that should be output in result set",
  "  -O, --output-module=name      Select output module",
  "      --output-args=args        Arguments to pass to output module",
  "      --output-filter=filter    Specify a filter over the response fields to\n                                  limit what responses get sent to the output\n                                  module",
  "      --list-output-modules     List available output modules",
  "      --list-output-fields      List all fields that can be output by selected\n                                  probe module",
  "      --no-header-row           Precludes outputting any header rows in data\n                                  (e.g., CSV headers)",
  "\nResponse Deduplication:",
  "      --dedup-method=method     Specifies how response deduplication should be\n                                  performed. Options: default, none, full,\n                                  window",
  "      --dedup-window-size=targets\n                                Specifies window size for how many recent\n                                  responses to keep in memory for deduplication\n                                  (default=`1000000')",
  "\nLogging and Metadata:",
  "  -v, --verbosity=n             Level of log detail (0-5)  (default=`3')",
  "  -l, --log-file=name           Write log entries to file",
  "  -L, --log-directory=directory Write log entries to a timestamped file in this\n                                  directory",
  "  -m, --metadata-file=name      Output file for scan metadata (JSON)",
  "  -u, --status-updates-file=name\n                                Write scan progress updates to CSV file",
  "  -q, --quiet                   Do not print status updates",
  "      --disable-syslog          Disables logging messages to syslog",
  "      --notes=notes             Inject user-specified notes into scan metadata",
  "      --user-metadata=json      Inject user-specified JSON metadata into scan\n                                  metadata",
  "\nAdditional Options:",
  "  -C, --config=filename         Read a configuration file, which can specify\n                                  any of these options\n                                  (default=`/etc/zmap/zmap.conf')",
  "      --max-sendto-failures=n   Maximum NIC sendto failures before scan is\n                                  aborted  (default=`-1')",
  "      --min-hitrate=n           Minimum hitrate that scan can hit before scan\n                                  is aborted  (default=`0.0')",
  "  -T, --sender-threads=n        Threads used to send packets  (default=`4')",
  "      --cores=STRING            Comma-separated list of cores to pin to",
  "      --ignore-blocklist-errors Ignore invalid entries in allowlist/blocklist\n                                  file.",
  "  -h, --help                    Print help and exit",
  "  -V, --version                 Print version and exit",
  "\nExamples:\n    zmap -p 80 (scan full IPv4 address space for hosts on TCP/80)\n    zmap -N 5 -B 10M -p 80 (find 5 HTTP servers, scanning at 10 Mb/s)\n    zmap -p 80 10.0.0.0/8 192.168.0.0/16 (scan both subnets on TCP/80)\n    zmap -p 80 1.2.3.4 10.0.0.3 (scan 1.2.3.4, 10.0.0.3 on TCP/80)\n    zmap -p 80,100-102 (scan full IPv4 on ports 80, 100, 101, 102)",
    0
};

typedef enum {ARG_NO
  , ARG_STRING
  , ARG_INT
  , ARG_FLOAT
  , ARG_LONGLONG
} cmdline_parser_arg_type;

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error);

struct line_list
{
  char * string_arg;
  struct line_list * next;
};

static struct line_list *cmd_line_list = 0;
static struct line_list *cmd_line_list_tmp = 0;

static void
free_cmd_list(void)
{
  /* free the list of a previous call */
  if (cmd_line_list)
    {
      while (cmd_line_list) {
        cmd_line_list_tmp = cmd_line_list;
        cmd_line_list = cmd_line_list->next;
        free (cmd_line_list_tmp->string_arg);
        free (cmd_line_list_tmp);
      }
    }
}


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->target_ports_given = 0 ;
  args_info->output_file_given = 0 ;
  args_info->blocklist_file_given = 0 ;
  args_info->allowlist_file_given = 0 ;
  args_info->list_of_ips_file_given = 0 ;
  args_info->rate_given = 0 ;
  args_info->bandwidth_given = 0 ;
  args_info->batch_given = 0 ;
  args_info->max_targets_given = 0 ;
  args_info->max_runtime_given = 0 ;
  args_info->max_results_given = 0 ;
  args_info->probes_given = 0 ;
  args_info->cooldown_time_given = 0 ;
  args_info->seed_given = 0 ;
  args_info->retries_given = 0 ;
  args_info->dryrun_given = 0 ;
  args_info->fast_dryrun_given = 0 ;
  args_info->shards_given = 0 ;
  args_info->shard_given = 0 ;
  args_info->source_port_given = 0 ;
  args_info->validate_source_port_given = 0 ;
  args_info->source_ip_given = 0 ;
  args_info->gateway_mac_given = 0 ;
  args_info->source_mac_given = 0 ;
  args_info->interface_given = 0 ;
  args_info->iplayer_given = 0 ;
  args_info->netmap_wait_ping_given = 0 ;
  args_info->probe_module_given = 0 ;
  args_info->probe_args_given = 0 ;
  args_info->probe_ttl_given = 0 ;
  args_info->list_probe_modules_given = 0 ;
  args_info->output_fields_given = 0 ;
  args_info->output_module_given = 0 ;
  args_info->output_args_given = 0 ;
  args_info->output_filter_given = 0 ;
  args_info->list_output_modules_given = 0 ;
  args_info->list_output_fields_given = 0 ;
  args_info->no_header_row_given = 0 ;
  args_info->dedup_method_given = 0 ;
  args_info->dedup_window_size_given = 0 ;
  args_info->verbosity_given = 0 ;
  args_info->log_file_given = 0 ;
  args_info->log_directory_given = 0 ;
  args_info->metadata_file_given = 0 ;
  args_info->status_updates_file_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->disable_syslog_given = 0 ;
  args_info->notes_given = 0 ;
  args_info->user_metadata_given = 0 ;
  args_info->config_given = 0 ;
  args_info->max_sendto_failures_given = 0 ;
  args_info->min_hitrate_given = 0 ;
  args_info->sender_threads_given = 0 ;
  args_info->cores_given = 0 ;
  args_info->ignore_blocklist_errors_given = 0 ;
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  FIX_UNUSED (args_info);
  args_info->target_ports_arg = NULL;
  args_info->target_ports_orig = NULL;
  args_info->output_file_arg = NULL;
  args_info->output_file_orig = NULL;
  args_info->blocklist_file_arg = NULL;
  args_info->blocklist_file_orig = NULL;
  args_info->allowlist_file_arg = NULL;
  args_info->allowlist_file_orig = NULL;
  args_info->list_of_ips_file_arg = NULL;
  args_info->list_of_ips_file_orig = NULL;
  args_info->rate_orig = NULL;
  args_info->bandwidth_arg = NULL;
  args_info->bandwidth_orig = NULL;
  args_info->batch_orig = NULL;
  args_info->max_targets_arg = NULL;
  args_info->max_targets_orig = NULL;
  args_info->max_runtime_orig = NULL;
  args_info->max_results_orig = NULL;
  args_info->probes_arg = 1;
  args_info->probes_orig = NULL;
  args_info->cooldown_time_arg = 8;
  args_info->cooldown_time_orig = NULL;
  args_info->seed_orig = NULL;
  args_info->retries_arg = 10;
  args_info->retries_orig = NULL;
  args_info->shards_arg = 1;
  args_info->shards_orig = NULL;
  args_info->shard_arg = 0;
  args_info->shard_orig = NULL;
  args_info->source_port_arg = NULL;
  args_info->source_port_orig = NULL;
  args_info->validate_source_port_arg = NULL;
  args_info->validate_source_port_orig = NULL;
  args_info->source_ip_arg = NULL;
  args_info->source_ip_orig = NULL;
  args_info->gateway_mac_arg = NULL;
  args_info->gateway_mac_orig = NULL;
  args_info->source_mac_arg = NULL;
  args_info->source_mac_orig = NULL;
  args_info->interface_arg = NULL;
  args_info->interface_orig = NULL;
  args_info->netmap_wait_ping_arg = NULL;
  args_info->netmap_wait_ping_orig = NULL;
  args_info->probe_module_arg = gengetopt_strdup ("tcp_synscan");
  args_info->probe_module_orig = NULL;
  args_info->probe_args_arg = NULL;
  args_info->probe_args_orig = NULL;
  args_info->probe_ttl_arg = 64;
  args_info->probe_ttl_orig = NULL;
  args_info->output_fields_arg = NULL;
  args_info->output_fields_orig = NULL;
  args_info->output_module_arg = NULL;
  args_info->output_module_orig = NULL;
  args_info->output_args_arg = NULL;
  args_info->output_args_orig = NULL;
  args_info->output_filter_arg = NULL;
  args_info->output_filter_orig = NULL;
  args_info->dedup_method_arg = NULL;
  args_info->dedup_method_orig = NULL;
  args_info->dedup_window_size_arg = 1000000;
  args_info->dedup_window_size_orig = NULL;
  args_info->verbosity_arg = 3;
  args_info->verbosity_orig = NULL;
  args_info->log_file_arg = NULL;
  args_info->log_file_orig = NULL;
  args_info->log_directory_arg = NULL;
  args_info->log_directory_orig = NULL;
  args_info->metadata_file_arg = NULL;
  args_info->metadata_file_orig = NULL;
  args_info->status_updates_file_arg = NULL;
  args_info->status_updates_file_orig = NULL;
  args_info->notes_arg = NULL;
  args_info->notes_orig = NULL;
  args_info->user_metadata_arg = NULL;
  args_info->user_metadata_orig = NULL;
  args_info->config_arg = gengetopt_strdup ("/etc/zmap/zmap.conf");
  args_info->config_orig = NULL;
  args_info->max_sendto_failures_arg = -1;
  args_info->max_sendto_failures_orig = NULL;
  args_info->min_hitrate_arg = 0.0;
  args_info->min_hitrate_orig = NULL;
  args_info->sender_threads_arg = 4;
  args_info->sender_threads_orig = NULL;
  args_info->cores_arg = NULL;
  args_info->cores_orig = NULL;
  
}

static
void init_args_info(struct gengetopt_args_info *args_info)
{


  args_info->target_ports_help = gengetopt_args_info_help[1] ;
  args_info->output_file_help = gengetopt_args_info_help[2] ;
  args_info->blocklist_file_help = gengetopt_args_info_help[3] ;
  args_info->allowlist_file_help = gengetopt_args_info_help[4] ;
  args_info->list_of_ips_file_help = gengetopt_args_info_help[5] ;
  args_info->rate_help = gengetopt_args_info_help[7] ;
  args_info->bandwidth_help = gengetopt_args_info_help[8] ;
  args_info->batch_help = gengetopt_args_info_help[9] ;
  args_info->max_targets_help = gengetopt_args_info_help[10] ;
  args_info->max_runtime_help = gengetopt_args_info_help[11] ;
  args_info->max_results_help = gengetopt_args_info_help[12] ;
  args_info->probes_help = gengetopt_args_info_help[13] ;
  args_info->cooldown_time_help = gengetopt_args_info_help[14] ;
  args_info->seed_help = gengetopt_args_info_help[15] ;
  args_info->retries_help = gengetopt_args_info_help[16] ;
  args_info->dryrun_help = gengetopt_args_info_help[17] ;
  args_info->fast_dryrun_help = gengetopt_args_info_help[18] ;
  args_info->shards_help = gengetopt_args_info_help[20] ;
  args_info->shard_help = gengetopt_args_info_help[21] ;
  args_info->source_port_help = gengetopt_args_info_help[23] ;
  args_info->validate_source_port_help = gengetopt_args_info_help[24] ;
  args_info->source_ip_help = gengetopt_args_info_help[25] ;
  args_info->gateway_mac_help = gengetopt_args_info_help[26] ;
  args_info->source_mac_help = gengetopt_args_info_help[27] ;
  args_info->interface_help = gengetopt_args_info_help[28] ;
  args_info->iplayer_help = gengetopt_args_info_help[29] ;
  args_info->netmap_wait_ping_help = gengetopt_args_info_help[30] ;
  args_info->probe_module_help = gengetopt_args_info_help[32] ;
  args_info->probe_args_help = gengetopt_args_info_help[33] ;
  args_info->probe_ttl_help = gengetopt_args_info_help[34] ;
  args_info->list_probe_modules_help = gengetopt_args_info_help[35] ;
  args_info->output_fields_help = gengetopt_args_info_help[37] ;
  args_info->output_module_help = gengetopt_args_info_help[38] ;
  args_info->output_args_help = gengetopt_args_info_help[39] ;
  args_info->output_filter_help = gengetopt_args_info_help[40] ;
  args_info->list_output_modules_help = gengetopt_args_info_help[41] ;
  args_info->list_output_fields_help = gengetopt_args_info_help[42] ;
  args_info->no_header_row_help = gengetopt_args_info_help[43] ;
  args_info->dedup_method_help = gengetopt_args_info_help[45] ;
  args_info->dedup_window_size_help = gengetopt_args_info_help[46] ;
  args_info->verbosity_help = gengetopt_args_info_help[48] ;
  args_info->log_file_help = gengetopt_args_info_help[49] ;
  args_info->log_directory_help = gengetopt_args_info_help[50] ;
  args_info->metadata_file_help = gengetopt_args_info_help[51] ;
  args_info->status_updates_file_help = gengetopt_args_info_help[52] ;
  args_info->quiet_help = gengetopt_args_info_help[53] ;
  args_info->disable_syslog_help = gengetopt_args_info_help[54] ;
  args_info->notes_help = gengetopt_args_info_help[55] ;
  args_info->user_metadata_help = gengetopt_args_info_help[56] ;
  args_info->config_help = gengetopt_args_info_help[58] ;
  args_info->max_sendto_failures_help = gengetopt_args_info_help[59] ;
  args_info->min_hitrate_help = gengetopt_args_info_help[60] ;
  args_info->sender_threads_help = gengetopt_args_info_help[61] ;
  args_info->cores_help = gengetopt_args_info_help[62] ;
  args_info->ignore_blocklist_errors_help = gengetopt_args_info_help[63] ;
  args_info->help_help = gengetopt_args_info_help[64] ;
  args_info->version_help = gengetopt_args_info_help[65] ;
  
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n",
     (strlen(CMDLINE_PARSER_PACKAGE_NAME) ? CMDLINE_PARSER_PACKAGE_NAME : CMDLINE_PARSER_PACKAGE),
     CMDLINE_PARSER_VERSION);

  if (strlen(gengetopt_args_info_versiontext) > 0)
    printf("\n%s\n", gengetopt_args_info_versiontext);
}

static void print_help_common(void)
{
	size_t len_purpose = strlen(gengetopt_args_info_purpose);
	size_t len_usage = strlen(gengetopt_args_info_usage);

	if (len_usage > 0) {
		printf("%s\n", gengetopt_args_info_usage);
	}
	if (len_purpose > 0) {
		printf("%s\n", gengetopt_args_info_purpose);
	}

	if (len_usage || len_purpose) {
		printf("\n");
	}

	if (strlen(gengetopt_args_info_description) > 0) {
		printf("%s\n\n", gengetopt_args_info_description);
	}
}

void
cmdline_parser_print_help (void)
{
  int i = 0;
  print_help_common();
  while (gengetopt_args_info_help[i])
    printf("%s\n", gengetopt_args_info_help[i++]);
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);
  init_args_info (args_info);

  args_info->inputs = 0;
  args_info->inputs_num = 0;
}

void
cmdline_parser_params_init(struct cmdline_parser_params *params)
{
  if (params)
    { 
      params->override = 0;
      params->initialize = 1;
      params->check_required = 1;
      params->check_ambiguity = 0;
      params->print_errors = 1;
    }
}

struct cmdline_parser_params *
cmdline_parser_params_create(void)
{
  struct cmdline_parser_params *params = 
    (struct cmdline_parser_params *)malloc(sizeof(struct cmdline_parser_params));
  cmdline_parser_params_init(params);  
  return params;
}

static void
free_string_field (char **s)
{
  if (*s)
    {
      free (*s);
      *s = 0;
    }
}


static void
cmdline_parser_release (struct gengetopt_args_info *args_info)
{
  unsigned int i;
  free_string_field (&(args_info->target_ports_arg));
  free_string_field (&(args_info->target_ports_orig));
  free_string_field (&(args_info->output_file_arg));
  free_string_field (&(args_info->output_file_orig));
  free_string_field (&(args_info->blocklist_file_arg));
  free_string_field (&(args_info->blocklist_file_orig));
  free_string_field (&(args_info->allowlist_file_arg));
  free_string_field (&(args_info->allowlist_file_orig));
  free_string_field (&(args_info->list_of_ips_file_arg));
  free_string_field (&(args_info->list_of_ips_file_orig));
  free_string_field (&(args_info->rate_orig));
  free_string_field (&(args_info->bandwidth_arg));
  free_string_field (&(args_info->bandwidth_orig));
  free_string_field (&(args_info->batch_orig));
  free_string_field (&(args_info->max_targets_arg));
  free_string_field (&(args_info->max_targets_orig));
  free_string_field (&(args_info->max_runtime_orig));
  free_string_field (&(args_info->max_results_orig));
  free_string_field (&(args_info->probes_orig));
  free_string_field (&(args_info->cooldown_time_orig));
  free_string_field (&(args_info->seed_orig));
  free_string_field (&(args_info->retries_orig));
  free_string_field (&(args_info->shards_orig));
  free_string_field (&(args_info->shard_orig));
  free_string_field (&(args_info->source_port_arg));
  free_string_field (&(args_info->source_port_orig));
  free_string_field (&(args_info->validate_source_port_arg));
  free_string_field (&(args_info->validate_source_port_orig));
  free_string_field (&(args_info->source_ip_arg));
  free_string_field (&(args_info->source_ip_orig));
  free_string_field (&(args_info->gateway_mac_arg));
  free_string_field (&(args_info->gateway_mac_orig));
  free_string_field (&(args_info->source_mac_arg));
  free_string_field (&(args_info->source_mac_orig));
  free_string_field (&(args_info->interface_arg));
  free_string_field (&(args_info->interface_orig));
  free_string_field (&(args_info->netmap_wait_ping_arg));
  free_string_field (&(args_info->netmap_wait_ping_orig));
  free_string_field (&(args_info->probe_module_arg));
  free_string_field (&(args_info->probe_module_orig));
  free_string_field (&(args_info->probe_args_arg));
  free_string_field (&(args_info->probe_args_orig));
  free_string_field (&(args_info->probe_ttl_orig));
  free_string_field (&(args_info->output_fields_arg));
  free_string_field (&(args_info->output_fields_orig));
  free_string_field (&(args_info->output_module_arg));
  free_string_field (&(args_info->output_module_orig));
  free_string_field (&(args_info->output_args_arg));
  free_string_field (&(args_info->output_args_orig));
  free_string_field (&(args_info->output_filter_arg));
  free_string_field (&(args_info->output_filter_orig));
  free_string_field (&(args_info->dedup_method_arg));
  free_string_field (&(args_info->dedup_method_orig));
  free_string_field (&(args_info->dedup_window_size_orig));
  free_string_field (&(args_info->verbosity_orig));
  free_string_field (&(args_info->log_file_arg));
  free_string_field (&(args_info->log_file_orig));
  free_string_field (&(args_info->log_directory_arg));
  free_string_field (&(args_info->log_directory_orig));
  free_string_field (&(args_info->metadata_file_arg));
  free_string_field (&(args_info->metadata_file_orig));
  free_string_field (&(args_info->status_updates_file_arg));
  free_string_field (&(args_info->status_updates_file_orig));
  free_string_field (&(args_info->notes_arg));
  free_string_field (&(args_info->notes_orig));
  free_string_field (&(args_info->user_metadata_arg));
  free_string_field (&(args_info->user_metadata_orig));
  free_string_field (&(args_info->config_arg));
  free_string_field (&(args_info->config_orig));
  free_string_field (&(args_info->max_sendto_failures_orig));
  free_string_field (&(args_info->min_hitrate_orig));
  free_string_field (&(args_info->sender_threads_orig));
  free_string_field (&(args_info->cores_arg));
  free_string_field (&(args_info->cores_orig));
  
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);

  if (args_info->inputs_num)
    free (args_info->inputs);

  clear_given (args_info);
}


static void
write_into_file(FILE *outfile, const char *opt, const char *arg, const char *values[])
{
  FIX_UNUSED (values);
  if (arg) {
    fprintf(outfile, "%s=\"%s\"\n", opt, arg);
  } else {
    fprintf(outfile, "%s\n", opt);
  }
}


int
cmdline_parser_dump(FILE *outfile, struct gengetopt_args_info *args_info)
{
  int i = 0;

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot dump options to stream\n", CMDLINE_PARSER_PACKAGE);
      return EXIT_FAILURE;
    }

  if (args_info->target_ports_given)
    write_into_file(outfile, "target-ports", args_info->target_ports_orig, 0);
  if (args_info->output_file_given)
    write_into_file(outfile, "output-file", args_info->output_file_orig, 0);
  if (args_info->blocklist_file_given)
    write_into_file(outfile, "blocklist-file", args_info->blocklist_file_orig, 0);
  if (args_info->allowlist_file_given)
    write_into_file(outfile, "allowlist-file", args_info->allowlist_file_orig, 0);
  if (args_info->list_of_ips_file_given)
    write_into_file(outfile, "list-of-ips-file", args_info->list_of_ips_file_orig, 0);
  if (args_info->rate_given)
    write_into_file(outfile, "rate", args_info->rate_orig, 0);
  if (args_info->bandwidth_given)
    write_into_file(outfile, "bandwidth", args_info->bandwidth_orig, 0);
  if (args_info->batch_given)
    write_into_file(outfile, "batch", args_info->batch_orig, 0);
  if (args_info->max_targets_given)
    write_into_file(outfile, "max-targets", args_info->max_targets_orig, 0);
  if (args_info->max_runtime_given)
    write_into_file(outfile, "max-runtime", args_info->max_runtime_orig, 0);
  if (args_info->max_results_given)
    write_into_file(outfile, "max-results", args_info->max_results_orig, 0);
  if (args_info->probes_given)
    write_into_file(outfile, "probes", args_info->probes_orig, 0);
  if (args_info->cooldown_time_given)
    write_into_file(outfile, "cooldown-time", args_info->cooldown_time_orig, 0);
  if (args_info->seed_given)
    write_into_file(outfile, "seed", args_info->seed_orig, 0);
  if (args_info->retries_given)
    write_into_file(outfile, "retries", args_info->retries_orig, 0);
  if (args_info->dryrun_given)
    write_into_file(outfile, "dryrun", 0, 0 );
  if (args_info->fast_dryrun_given)
    write_into_file(outfile, "fast-dryrun", 0, 0 );
  if (args_info->shards_given)
    write_into_file(outfile, "shards", args_info->shards_orig, 0);
  if (args_info->shard_given)
    write_into_file(outfile, "shard", args_info->shard_orig, 0);
  if (args_info->source_port_given)
    write_into_file(outfile, "source-port", args_info->source_port_orig, 0);
  if (args_info->validate_source_port_given)
    write_into_file(outfile, "validate-source-port", args_info->validate_source_port_orig, 0);
  if (args_info->source_ip_given)
    write_into_file(outfile, "source-ip", args_info->source_ip_orig, 0);
  if (args_info->gateway_mac_given)
    write_into_file(outfile, "gateway-mac", args_info->gateway_mac_orig, 0);
  if (args_info->source_mac_given)
    write_into_file(outfile, "source-mac", args_info->source_mac_orig, 0);
  if (args_info->interface_given)
    write_into_file(outfile, "interface", args_info->interface_orig, 0);
  if (args_info->iplayer_given)
    write_into_file(outfile, "iplayer", 0, 0 );
  if (args_info->netmap_wait_ping_given)
    write_into_file(outfile, "netmap-wait-ping", args_info->netmap_wait_ping_orig, 0);
  if (args_info->probe_module_given)
    write_into_file(outfile, "probe-module", args_info->probe_module_orig, 0);
  if (args_info->probe_args_given)
    write_into_file(outfile, "probe-args", args_info->probe_args_orig, 0);
  if (args_info->probe_ttl_given)
    write_into_file(outfile, "probe-ttl", args_info->probe_ttl_orig, 0);
  if (args_info->list_probe_modules_given)
    write_into_file(outfile, "list-probe-modules", 0, 0 );
  if (args_info->output_fields_given)
    write_into_file(outfile, "output-fields", args_info->output_fields_orig, 0);
  if (args_info->output_module_given)
    write_into_file(outfile, "output-module", args_info->output_module_orig, 0);
  if (args_info->output_args_given)
    write_into_file(outfile, "output-args", args_info->output_args_orig, 0);
  if (args_info->output_filter_given)
    write_into_file(outfile, "output-filter", args_info->output_filter_orig, 0);
  if (args_info->list_output_modules_given)
    write_into_file(outfile, "list-output-modules", 0, 0 );
  if (args_info->list_output_fields_given)
    write_into_file(outfile, "list-output-fields", 0, 0 );
  if (args_info->no_header_row_given)
    write_into_file(outfile, "no-header-row", 0, 0 );
  if (args_info->dedup_method_given)
    write_into_file(outfile, "dedup-method", args_info->dedup_method_orig, 0);
  if (args_info->dedup_window_size_given)
    write_into_file(outfile, "dedup-window-size", args_info->dedup_window_size_orig, 0);
  if (args_info->verbosity_given)
    write_into_file(outfile, "verbosity", args_info->verbosity_orig, 0);
  if (args_info->log_file_given)
    write_into_file(outfile, "log-file", args_info->log_file_orig, 0);
  if (args_info->log_directory_given)
    write_into_file(outfile, "log-directory", args_info->log_directory_orig, 0);
  if (args_info->metadata_file_given)
    write_into_file(outfile, "metadata-file", args_info->metadata_file_orig, 0);
  if (args_info->status_updates_file_given)
    write_into_file(outfile, "status-updates-file", args_info->status_updates_file_orig, 0);
  if (args_info->quiet_given)
    write_into_file(outfile, "quiet", 0, 0 );
  if (args_info->disable_syslog_given)
    write_into_file(outfile, "disable-syslog", 0, 0 );
  if (args_info->notes_given)
    write_into_file(outfile, "notes", args_info->notes_orig, 0);
  if (args_info->user_metadata_given)
    write_into_file(outfile, "user-metadata", args_info->user_metadata_orig, 0);
  if (args_info->config_given)
    write_into_file(outfile, "config", args_info->config_orig, 0);
  if (args_info->max_sendto_failures_given)
    write_into_file(outfile, "max-sendto-failures", args_info->max_sendto_failures_orig, 0);
  if (args_info->min_hitrate_given)
    write_into_file(outfile, "min-hitrate", args_info->min_hitrate_orig, 0);
  if (args_info->sender_threads_given)
    write_into_file(outfile, "sender-threads", args_info->sender_threads_orig, 0);
  if (args_info->cores_given)
    write_into_file(outfile, "cores", args_info->cores_orig, 0);
  if (args_info->ignore_blocklist_errors_given)
    write_into_file(outfile, "ignore-blocklist-errors", 0, 0 );
  if (args_info->help_given)
    write_into_file(outfile, "help", 0, 0 );
  if (args_info->version_given)
    write_into_file(outfile, "version", 0, 0 );
  

  i = EXIT_SUCCESS;
  return i;
}

int
cmdline_parser_file_save(const char *filename, struct gengetopt_args_info *args_info)
{
  FILE *outfile;
  int i = 0;

  outfile = fopen(filename, "w");

  if (!outfile)
    {
      fprintf (stderr, "%s: cannot open file for writing: %s\n", CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  i = cmdline_parser_dump(outfile, args_info);
  fclose (outfile);

  return i;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  cmdline_parser_release (args_info);
}

/** @brief replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = 0;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char **argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser_ext (int argc, char **argv, struct gengetopt_args_info *args_info,
                   struct cmdline_parser_params *params)
{
  int result;
  result = cmdline_parser_internal (argc, argv, args_info, params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser2 (int argc, char **argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;
  struct cmdline_parser_params params;
  
  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;

  result = cmdline_parser_internal (argc, argv, args_info, &params, 0);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  FIX_UNUSED (args_info);
  FIX_UNUSED (prog_name);
  return EXIT_SUCCESS;
}


static char *package_name = 0;

/**
 * @brief updates an option
 * @param field the generic pointer to the field to update
 * @param orig_field the pointer to the orig field
 * @param field_given the pointer to the number of occurrence of this option
 * @param prev_given the pointer to the number of occurrence already seen
 * @param value the argument for this option (if null no arg was specified)
 * @param possible_values the possible values for this option (if specified)
 * @param default_value the default value (in case the option only accepts fixed values)
 * @param arg_type the type of this option
 * @param check_ambiguity @see cmdline_parser_params.check_ambiguity
 * @param override @see cmdline_parser_params.override
 * @param no_free whether to free a possible previous value
 * @param multiple_option whether this is a multiple option
 * @param long_opt the corresponding long option
 * @param short_opt the corresponding short option (or '-' if none)
 * @param additional_error possible further error specification
 */
static
int update_arg(void *field, char **orig_field,
               unsigned int *field_given, unsigned int *prev_given, 
               char *value, const char *possible_values[],
               const char *default_value,
               cmdline_parser_arg_type arg_type,
               int check_ambiguity, int override,
               int no_free, int multiple_option,
               const char *long_opt, char short_opt,
               const char *additional_error)
{
  char *stop_char = 0;
  const char *val = value;
  int found;
  char **string_field;
  FIX_UNUSED (field);

  stop_char = 0;
  found = 0;

  if (!multiple_option && prev_given && (*prev_given || (check_ambiguity && *field_given)))
    {
      if (short_opt != '-')
        fprintf (stderr, "%s: `--%s' (`-%c') option given more than once%s\n", 
               package_name, long_opt, short_opt,
               (additional_error ? additional_error : ""));
      else
        fprintf (stderr, "%s: `--%s' option given more than once%s\n", 
               package_name, long_opt,
               (additional_error ? additional_error : ""));
      return 1; /* failure */
    }

  FIX_UNUSED (default_value);
    
  if (field_given && *field_given && ! override)
    return 0;
  if (prev_given)
    (*prev_given)++;
  if (field_given)
    (*field_given)++;
  if (possible_values)
    val = possible_values[found];

  switch(arg_type) {
  case ARG_INT:
    if (val) *((int *)field) = strtol (val, &stop_char, 0);
    break;
  case ARG_FLOAT:
    if (val) *((float *)field) = (float)strtod (val, &stop_char);
    break;
  case ARG_LONGLONG:
#if defined(HAVE_LONG_LONG) || defined(HAVE_LONG_LONG_INT)
    if (val) *((long long int*)field) = (long long int) strtoll (val, &stop_char, 0);
#else
    if (val) *((long *)field) = (long)strtol (val, &stop_char, 0);
#endif
    break;
  case ARG_STRING:
    if (val) {
      string_field = (char **)field;
      if (!no_free && *string_field)
        free (*string_field); /* free previous string */
      *string_field = gengetopt_strdup (val);
    }
    break;
  default:
    break;
  };

  /* check numeric conversion */
  switch(arg_type) {
  case ARG_INT:
  case ARG_FLOAT:
  case ARG_LONGLONG:
    if (val && !(stop_char && *stop_char == '\0')) {
      fprintf(stderr, "%s: invalid numeric value: %s\n", package_name, val);
      return 1; /* failure */
    }
    break;
  default:
    ;
  };

  /* store the original value */
  switch(arg_type) {
  case ARG_NO:
    break;
  default:
    if (value && orig_field) {
      if (no_free) {
        *orig_field = value;
      } else {
        if (*orig_field)
          free (*orig_field); /* free previous string */
        *orig_field = gengetopt_strdup (value);
      }
    }
  };

  return 0; /* OK */
}


int
cmdline_parser_internal (
  int argc, char **argv, struct gengetopt_args_info *args_info,
                        struct cmdline_parser_params *params, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error_occurred = 0;
  struct gengetopt_args_info local_args_info;
  
  int override;
  int initialize;
  int check_required;
  int check_ambiguity;
  
  package_name = argv[0];
  
  /* TODO: Why is this here? It is not used anywhere. */
  override = params->override;
  FIX_UNUSED(override);

  initialize = params->initialize;
  check_required = params->check_required;

  /* TODO: Why is this here? It is not used anywhere. */
  check_ambiguity = params->check_ambiguity;
  FIX_UNUSED(check_ambiguity);

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 0;
  opterr = params->print_errors;
  optopt = '?';

  while (1)
    {
      int option_index = 0;

      static struct option long_options[] = {
        { "target-ports",	1, NULL, 'p' },
        { "output-file",	1, NULL, 'o' },
        { "blocklist-file",	1, NULL, 'b' },
        { "allowlist-file",	1, NULL, 'w' },
        { "list-of-ips-file",	1, NULL, 'I' },
        { "rate",	1, NULL, 'r' },
        { "bandwidth",	1, NULL, 'B' },
        { "batch",	1, NULL, 0 },
        { "max-targets",	1, NULL, 'n' },
        { "max-runtime",	1, NULL, 't' },
        { "max-results",	1, NULL, 'N' },
        { "probes",	1, NULL, 'P' },
        { "cooldown-time",	1, NULL, 'c' },
        { "seed",	1, NULL, 'e' },
        { "retries",	1, NULL, 0 },
        { "dryrun",	0, NULL, 'd' },
        { "fast-dryrun",	0, NULL, 0 },
        { "shards",	1, NULL, 0 },
        { "shard",	1, NULL, 0 },
        { "source-port",	1, NULL, 's' },
        { "validate-source-port",	1, NULL, 0 },
        { "source-ip",	1, NULL, 'S' },
        { "gateway-mac",	1, NULL, 'G' },
        { "source-mac",	1, NULL, 0 },
        { "interface",	1, NULL, 'i' },
        { "iplayer",	0, NULL, 'X' },
        { "netmap-wait-ping",	1, NULL, 0 },
        { "probe-module",	1, NULL, 'M' },
        { "probe-args",	1, NULL, 0 },
        { "probe-ttl",	1, NULL, 0 },
        { "list-probe-modules",	0, NULL, 0 },
        { "output-fields",	1, NULL, 'f' },
        { "output-module",	1, NULL, 'O' },
        { "output-args",	1, NULL, 0 },
        { "output-filter",	1, NULL, 0 },
        { "list-output-modules",	0, NULL, 0 },
        { "list-output-fields",	0, NULL, 0 },
        { "no-header-row",	0, NULL, 0 },
        { "dedup-method",	1, NULL, 0 },
        { "dedup-window-size",	1, NULL, 0 },
        { "verbosity",	1, NULL, 'v' },
        { "log-file",	1, NULL, 'l' },
        { "log-directory",	1, NULL, 'L' },
        { "metadata-file",	1, NULL, 'm' },
        { "status-updates-file",	1, NULL, 'u' },
        { "quiet",	0, NULL, 'q' },
        { "disable-syslog",	0, NULL, 0 },
        { "notes",	1, NULL, 0 },
        { "user-metadata",	1, NULL, 0 },
        { "config",	1, NULL, 'C' },
        { "max-sendto-failures",	1, NULL, 0 },
        { "min-hitrate",	1, NULL, 0 },
        { "sender-threads",	1, NULL, 'T' },
        { "cores",	1, NULL, 0 },
        { "ignore-blocklist-errors",	0, NULL, 0 },
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { 0,  0, 0, 0 }
      };

      c = getopt_long (argc, argv, "p:o:b:w:I:r:B:n:t:N:P:c:e:ds:S:G:i:XM:f:O:v:l:L:m:u:qC:T:hV", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'p':	/* comma-delimited list of ports and port ranges to scan (for TCP and UDP scans).  */
        
        
          if (update_arg( (void *)&(args_info->target_ports_arg), 
               &(args_info->target_ports_orig), &(args_info->target_ports_given),
              &(local_args_info.target_ports_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "target-ports", 'p',
              additional_error))
            goto failure;
        
          break;
        case 'o':	/* Output file.  */
        
        
          if (update_arg( (void *)&(args_info->output_file_arg), 
               &(args_info->output_file_orig), &(args_info->output_file_given),
              &(local_args_info.output_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-file", 'o',
              additional_error))
            goto failure;
        
          break;
        case 'b':	/* File of subnets to exclude, in CIDR notation, e.g. 192.168.0.0/16.  */
        
        
          if (update_arg( (void *)&(args_info->blocklist_file_arg), 
               &(args_info->blocklist_file_orig), &(args_info->blocklist_file_given),
              &(local_args_info.blocklist_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "blocklist-file", 'b',
              additional_error))
            goto failure;
        
          break;
        case 'w':	/* File of subnets to constrain scan to, in CIDR notation, e.g. 192.168.0.0/16.  */
        
        
          if (update_arg( (void *)&(args_info->allowlist_file_arg), 
               &(args_info->allowlist_file_orig), &(args_info->allowlist_file_given),
              &(local_args_info.allowlist_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "allowlist-file", 'w',
              additional_error))
            goto failure;
        
          break;
        case 'I':	/* List of individual addresses to scan in random order. Use --allowlist-file unless >1 million IPs.  */
        
        
          if (update_arg( (void *)&(args_info->list_of_ips_file_arg), 
               &(args_info->list_of_ips_file_orig), &(args_info->list_of_ips_file_given),
              &(local_args_info.list_of_ips_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "list-of-ips-file", 'I',
              additional_error))
            goto failure;
        
          break;
        case 'r':	/* Set send rate in packets/sec.  */
        
        
          if (update_arg( (void *)&(args_info->rate_arg), 
               &(args_info->rate_orig), &(args_info->rate_given),
              &(local_args_info.rate_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "rate", 'r',
              additional_error))
            goto failure;
        
          break;
        case 'B':	/* Set send rate in bits/second (supports suffixes G, M and K).  */
        
        
          if (update_arg( (void *)&(args_info->bandwidth_arg), 
               &(args_info->bandwidth_orig), &(args_info->bandwidth_given),
              &(local_args_info.bandwidth_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "bandwidth", 'B',
              additional_error))
            goto failure;
        
          break;
        case 'n':	/* Cap number of targets to probe (as a number '-n 1000' or a percentage '-n 1%' of the target search space). A target is an IP/port pair, if scanning multiple ports, and an IP otherwise..  */
        
        
          if (update_arg( (void *)&(args_info->max_targets_arg), 
               &(args_info->max_targets_orig), &(args_info->max_targets_given),
              &(local_args_info.max_targets_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "max-targets", 'n',
              additional_error))
            goto failure;
        
          break;
        case 't':	/* Cap length of time for sending packets.  */
        
        
          if (update_arg( (void *)&(args_info->max_runtime_arg), 
               &(args_info->max_runtime_orig), &(args_info->max_runtime_given),
              &(local_args_info.max_runtime_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "max-runtime", 't',
              additional_error))
            goto failure;
        
          break;
        case 'N':	/* Cap number of results to return.  */
        
        
          if (update_arg( (void *)&(args_info->max_results_arg), 
               &(args_info->max_results_orig), &(args_info->max_results_given),
              &(local_args_info.max_results_given), optarg, 0, 0, ARG_INT,
              check_ambiguity, override, 0, 0,
              "max-results", 'N',
              additional_error))
            goto failure;
        
          break;
        case 'P':	/* Number of probes to send to each IP/Port pair.  */
        
        
          if (update_arg( (void *)&(args_info->probes_arg), 
               &(args_info->probes_orig), &(args_info->probes_given),
              &(local_args_info.probes_given), optarg, 0, "1", ARG_INT,
              check_ambiguity, override, 0, 0,
              "probes", 'P',
              additional_error))
            goto failure;
        
          break;
        case 'c':	/* How long to continue receiving after sending last probe.  */
        
        
          if (update_arg( (void *)&(args_info->cooldown_time_arg), 
               &(args_info->cooldown_time_orig), &(args_info->cooldown_time_given),
              &(local_args_info.cooldown_time_given), optarg, 0, "8", ARG_INT,
              check_ambiguity, override, 0, 0,
              "cooldown-time", 'c',
              additional_error))
            goto failure;
        
          break;
        case 'e':	/* Seed used to select address permutation.  */
        
        
          if (update_arg( (void *)&(args_info->seed_arg), 
               &(args_info->seed_orig), &(args_info->seed_given),
              &(local_args_info.seed_given), optarg, 0, 0, ARG_LONGLONG,
              check_ambiguity, override, 0, 0,
              "seed", 'e',
              additional_error))
            goto failure;
        
          break;
        case 'd':	/* Don't actually send packets.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->dryrun_given),
              &(local_args_info.dryrun_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "dryrun", 'd',
              additional_error))
            goto failure;
        
          break;
        case 's':	/* Source port(s) for scan packets.  */
        
        
          if (update_arg( (void *)&(args_info->source_port_arg), 
               &(args_info->source_port_orig), &(args_info->source_port_given),
              &(local_args_info.source_port_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "source-port", 's',
              additional_error))
            goto failure;
        
          break;
        case 'S':	/* Source address(es) for scan packets.  */
        
        
          if (update_arg( (void *)&(args_info->source_ip_arg), 
               &(args_info->source_ip_orig), &(args_info->source_ip_given),
              &(local_args_info.source_ip_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "source-ip", 'S',
              additional_error))
            goto failure;
        
          break;
        case 'G':	/* Specify gateway MAC address.  */
        
        
          if (update_arg( (void *)&(args_info->gateway_mac_arg), 
               &(args_info->gateway_mac_orig), &(args_info->gateway_mac_given),
              &(local_args_info.gateway_mac_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "gateway-mac", 'G',
              additional_error))
            goto failure;
        
          break;
        case 'i':	/* Specify network interface to use.  */
        
        
          if (update_arg( (void *)&(args_info->interface_arg), 
               &(args_info->interface_orig), &(args_info->interface_given),
              &(local_args_info.interface_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "interface", 'i',
              additional_error))
            goto failure;
        
          break;
        case 'X':	/* Sends IP packets instead of Ethernet (for VPNs).  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->iplayer_given),
              &(local_args_info.iplayer_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "iplayer", 'X',
              additional_error))
            goto failure;
        
          break;
        case 'M':	/* Select probe module.  */
        
        
          if (update_arg( (void *)&(args_info->probe_module_arg), 
               &(args_info->probe_module_orig), &(args_info->probe_module_given),
              &(local_args_info.probe_module_given), optarg, 0, "tcp_synscan", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "probe-module", 'M',
              additional_error))
            goto failure;
        
          break;
        case 'f':	/* Fields that should be output in result set.  */
        
        
          if (update_arg( (void *)&(args_info->output_fields_arg), 
               &(args_info->output_fields_orig), &(args_info->output_fields_given),
              &(local_args_info.output_fields_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-fields", 'f',
              additional_error))
            goto failure;
        
          break;
        case 'O':	/* Select output module.  */
        
        
          if (update_arg( (void *)&(args_info->output_module_arg), 
               &(args_info->output_module_orig), &(args_info->output_module_given),
              &(local_args_info.output_module_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "output-module", 'O',
              additional_error))
            goto failure;
        
          break;
        case 'v':	/* Level of log detail (0-5).  */
        
        
          if (update_arg( (void *)&(args_info->verbosity_arg), 
               &(args_info->verbosity_orig), &(args_info->verbosity_given),
              &(local_args_info.verbosity_given), optarg, 0, "3", ARG_INT,
              check_ambiguity, override, 0, 0,
              "verbosity", 'v',
              additional_error))
            goto failure;
        
          break;
        case 'l':	/* Write log entries to file.  */
        
        
          if (update_arg( (void *)&(args_info->log_file_arg), 
               &(args_info->log_file_orig), &(args_info->log_file_given),
              &(local_args_info.log_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "log-file", 'l',
              additional_error))
            goto failure;
        
          break;
        case 'L':	/* Write log entries to a timestamped file in this directory.  */
        
        
          if (update_arg( (void *)&(args_info->log_directory_arg), 
               &(args_info->log_directory_orig), &(args_info->log_directory_given),
              &(local_args_info.log_directory_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "log-directory", 'L',
              additional_error))
            goto failure;
        
          break;
        case 'm':	/* Output file for scan metadata (JSON).  */
        
        
          if (update_arg( (void *)&(args_info->metadata_file_arg), 
               &(args_info->metadata_file_orig), &(args_info->metadata_file_given),
              &(local_args_info.metadata_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "metadata-file", 'm',
              additional_error))
            goto failure;
        
          break;
        case 'u':	/* Write scan progress updates to CSV file.  */
        
        
          if (update_arg( (void *)&(args_info->status_updates_file_arg), 
               &(args_info->status_updates_file_orig), &(args_info->status_updates_file_given),
              &(local_args_info.status_updates_file_given), optarg, 0, 0, ARG_STRING,
              check_ambiguity, override, 0, 0,
              "status-updates-file", 'u',
              additional_error))
            goto failure;
        
          break;
        case 'q':	/* Do not print status updates.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->quiet_given),
              &(local_args_info.quiet_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "quiet", 'q',
              additional_error))
            goto failure;
        
          break;
        case 'C':	/* Read a configuration file, which can specify any of these options.  */
        
        
          if (update_arg( (void *)&(args_info->config_arg), 
               &(args_info->config_orig), &(args_info->config_given),
              &(local_args_info.config_given), optarg, 0, "/etc/zmap/zmap.conf", ARG_STRING,
              check_ambiguity, override, 0, 0,
              "config", 'C',
              additional_error))
            goto failure;
        
          break;
        case 'T':	/* Threads used to send packets.  */
        
        
          if (update_arg( (void *)&(args_info->sender_threads_arg), 
               &(args_info->sender_threads_orig), &(args_info->sender_threads_given),
              &(local_args_info.sender_threads_given), optarg, 0, "4", ARG_INT,
              check_ambiguity, override, 0, 0,
              "sender-threads", 'T',
              additional_error))
            goto failure;
        
          break;
        case 'h':	/* Print help and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->help_given),
              &(local_args_info.help_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "help", 'h',
              additional_error))
            goto failure;
        
          break;
        case 'V':	/* Print version and exit.  */
        
        
          if (update_arg( 0 , 
               0 , &(args_info->version_given),
              &(local_args_info.version_given), optarg, 0, 0, ARG_NO,
              check_ambiguity, override, 0, 0,
              "version", 'V',
              additional_error))
            goto failure;
        
          break;

        case 0:	/* Long option with no short option */
          /* Set batch size for how many packets to send in a single syscall. Advantageous on Linux or with netmap (default=64).  */
          if (strcmp (long_options[option_index].name, "batch") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->batch_arg), 
                 &(args_info->batch_orig), &(args_info->batch_given),
                &(local_args_info.batch_given), optarg, 0, 0, ARG_INT,
                check_ambiguity, override, 0, 0,
                "batch", '-',
                additional_error))
              goto failure;
          
          }
          /* Max number of times to try to send packet if send fails.  */
          else if (strcmp (long_options[option_index].name, "retries") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->retries_arg), 
                 &(args_info->retries_orig), &(args_info->retries_given),
                &(local_args_info.retries_given), optarg, 0, "10", ARG_INT,
                check_ambiguity, override, 0, 0,
                "retries", '-',
                additional_error))
              goto failure;
          
          }
          /* Don't actually send packets, print out a binary representation probe dst IP and dst Port. Used for faster integration tests, not for general use..  */
          else if (strcmp (long_options[option_index].name, "fast-dryrun") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->fast_dryrun_given),
                &(local_args_info.fast_dryrun_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "fast-dryrun", '-',
                additional_error))
              goto failure;
          
          }
          /* Set the total number of shards.  */
          else if (strcmp (long_options[option_index].name, "shards") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shards_arg), 
                 &(args_info->shards_orig), &(args_info->shards_given),
                &(local_args_info.shards_given), optarg, 0, "1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "shards", '-',
                additional_error))
              goto failure;
          
          }
          /* Set which shard this scan is (0 indexed).  */
          else if (strcmp (long_options[option_index].name, "shard") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->shard_arg), 
                 &(args_info->shard_orig), &(args_info->shard_given),
                &(local_args_info.shard_given), optarg, 0, "0", ARG_INT,
                check_ambiguity, override, 0, 0,
                "shard", '-',
                additional_error))
              goto failure;
          
          }
          /* Override to validate if probe responses have a valid src port corresponding to sent probe's dst port. \"enable\" or \"disable\".  */
          else if (strcmp (long_options[option_index].name, "validate-source-port") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->validate_source_port_arg), 
                 &(args_info->validate_source_port_orig), &(args_info->validate_source_port_given),
                &(local_args_info.validate_source_port_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "validate-source-port", '-',
                additional_error))
              goto failure;
          
          }
          /* Source MAC address.  */
          else if (strcmp (long_options[option_index].name, "source-mac") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->source_mac_arg), 
                 &(args_info->source_mac_orig), &(args_info->source_mac_given),
                &(local_args_info.source_mac_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "source-mac", '-',
                additional_error))
              goto failure;
          
          }
          /* Wait for IP to respond to ping before commencing scan (netmap only).  */
          else if (strcmp (long_options[option_index].name, "netmap-wait-ping") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->netmap_wait_ping_arg), 
                 &(args_info->netmap_wait_ping_orig), &(args_info->netmap_wait_ping_given),
                &(local_args_info.netmap_wait_ping_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "netmap-wait-ping", '-',
                additional_error))
              goto failure;
          
          }
          /* Arguments to pass to probe module.  */
          else if (strcmp (long_options[option_index].name, "probe-args") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->probe_args_arg), 
                 &(args_info->probe_args_orig), &(args_info->probe_args_given),
                &(local_args_info.probe_args_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "probe-args", '-',
                additional_error))
              goto failure;
          
          }
          /* Set TTL value for probe IP packets.  */
          else if (strcmp (long_options[option_index].name, "probe-ttl") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->probe_ttl_arg), 
                 &(args_info->probe_ttl_orig), &(args_info->probe_ttl_given),
                &(local_args_info.probe_ttl_given), optarg, 0, "64", ARG_INT,
                check_ambiguity, override, 0, 0,
                "probe-ttl", '-',
                additional_error))
              goto failure;
          
          }
          /* List available probe modules.  */
          else if (strcmp (long_options[option_index].name, "list-probe-modules") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->list_probe_modules_given),
                &(local_args_info.list_probe_modules_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "list-probe-modules", '-',
                additional_error))
              goto failure;
          
          }
          /* Arguments to pass to output module.  */
          else if (strcmp (long_options[option_index].name, "output-args") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_args_arg), 
                 &(args_info->output_args_orig), &(args_info->output_args_given),
                &(local_args_info.output_args_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-args", '-',
                additional_error))
              goto failure;
          
          }
          /* Specify a filter over the response fields to limit what responses get sent to the output module.  */
          else if (strcmp (long_options[option_index].name, "output-filter") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->output_filter_arg), 
                 &(args_info->output_filter_orig), &(args_info->output_filter_given),
                &(local_args_info.output_filter_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "output-filter", '-',
                additional_error))
              goto failure;
          
          }
          /* List available output modules.  */
          else if (strcmp (long_options[option_index].name, "list-output-modules") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->list_output_modules_given),
                &(local_args_info.list_output_modules_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "list-output-modules", '-',
                additional_error))
              goto failure;
          
          }
          /* List all fields that can be output by selected probe module.  */
          else if (strcmp (long_options[option_index].name, "list-output-fields") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->list_output_fields_given),
                &(local_args_info.list_output_fields_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "list-output-fields", '-',
                additional_error))
              goto failure;
          
          }
          /* Precludes outputting any header rows in data (e.g., CSV headers).  */
          else if (strcmp (long_options[option_index].name, "no-header-row") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->no_header_row_given),
                &(local_args_info.no_header_row_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "no-header-row", '-',
                additional_error))
              goto failure;
          
          }
          /* Specifies how response deduplication should be performed. Options: default, none, full, window.  */
          else if (strcmp (long_options[option_index].name, "dedup-method") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dedup_method_arg), 
                 &(args_info->dedup_method_orig), &(args_info->dedup_method_given),
                &(local_args_info.dedup_method_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "dedup-method", '-',
                additional_error))
              goto failure;
          
          }
          /* Specifies window size for how many recent responses to keep in memory for deduplication.  */
          else if (strcmp (long_options[option_index].name, "dedup-window-size") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->dedup_window_size_arg), 
                 &(args_info->dedup_window_size_orig), &(args_info->dedup_window_size_given),
                &(local_args_info.dedup_window_size_given), optarg, 0, "1000000", ARG_INT,
                check_ambiguity, override, 0, 0,
                "dedup-window-size", '-',
                additional_error))
              goto failure;
          
          }
          /* Disables logging messages to syslog.  */
          else if (strcmp (long_options[option_index].name, "disable-syslog") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->disable_syslog_given),
                &(local_args_info.disable_syslog_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "disable-syslog", '-',
                additional_error))
              goto failure;
          
          }
          /* Inject user-specified notes into scan metadata.  */
          else if (strcmp (long_options[option_index].name, "notes") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->notes_arg), 
                 &(args_info->notes_orig), &(args_info->notes_given),
                &(local_args_info.notes_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "notes", '-',
                additional_error))
              goto failure;
          
          }
          /* Inject user-specified JSON metadata into scan metadata.  */
          else if (strcmp (long_options[option_index].name, "user-metadata") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->user_metadata_arg), 
                 &(args_info->user_metadata_orig), &(args_info->user_metadata_given),
                &(local_args_info.user_metadata_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "user-metadata", '-',
                additional_error))
              goto failure;
          
          }
          /* Maximum NIC sendto failures before scan is aborted.  */
          else if (strcmp (long_options[option_index].name, "max-sendto-failures") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->max_sendto_failures_arg), 
                 &(args_info->max_sendto_failures_orig), &(args_info->max_sendto_failures_given),
                &(local_args_info.max_sendto_failures_given), optarg, 0, "-1", ARG_INT,
                check_ambiguity, override, 0, 0,
                "max-sendto-failures", '-',
                additional_error))
              goto failure;
          
          }
          /* Minimum hitrate that scan can hit before scan is aborted.  */
          else if (strcmp (long_options[option_index].name, "min-hitrate") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->min_hitrate_arg), 
                 &(args_info->min_hitrate_orig), &(args_info->min_hitrate_given),
                &(local_args_info.min_hitrate_given), optarg, 0, "0.0", ARG_FLOAT,
                check_ambiguity, override, 0, 0,
                "min-hitrate", '-',
                additional_error))
              goto failure;
          
          }
          /* Comma-separated list of cores to pin to.  */
          else if (strcmp (long_options[option_index].name, "cores") == 0)
          {
          
          
            if (update_arg( (void *)&(args_info->cores_arg), 
                 &(args_info->cores_orig), &(args_info->cores_given),
                &(local_args_info.cores_given), optarg, 0, 0, ARG_STRING,
                check_ambiguity, override, 0, 0,
                "cores", '-',
                additional_error))
              goto failure;
          
          }
          /* Ignore invalid entries in allowlist/blocklist file..  */
          else if (strcmp (long_options[option_index].name, "ignore-blocklist-errors") == 0)
          {
          
          
            if (update_arg( 0 , 
                 0 , &(args_info->ignore_blocklist_errors_given),
                &(local_args_info.ignore_blocklist_errors_given), optarg, 0, 0, ARG_NO,
                check_ambiguity, override, 0, 0,
                "ignore-blocklist-errors", '-',
                additional_error))
              goto failure;
          
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */



	FIX_UNUSED(check_required);

  cmdline_parser_release (&local_args_info);

  if ( error_occurred )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;
      int found_prog_name = 0;
      /* whether program name, i.e., argv[0], is in the remaining args
         (this may happen with some implementations of getopt,
          but surely not with the one included by gengetopt) */

      i = optind;
      while (i < argc)
        if (argv[i++] == argv[0]) {
          found_prog_name = 1;
          break;
        }
      i = 0;

      args_info->inputs_num = argc - optind - found_prog_name;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        if (argv[optind++] != argv[0])
          args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind-1]) ;
    }

  return 0;

failure:
  
  cmdline_parser_release (&local_args_info);
  return (EXIT_FAILURE);
}

#ifndef CONFIG_FILE_LINE_SIZE
#define CONFIG_FILE_LINE_SIZE 2048
#endif
#define ADDITIONAL_ERROR " in configuration file "

#define CONFIG_FILE_LINE_BUFFER_SIZE (CONFIG_FILE_LINE_SIZE+3)
/* 3 is for "--" and "=" */

static int
_cmdline_parser_configfile (const char *filename, int *my_argc)
{
  FILE* file;
  char my_argv[CONFIG_FILE_LINE_BUFFER_SIZE+1];
  char linebuf[CONFIG_FILE_LINE_SIZE];
  int line_num = 0;
  int result = 0, equal;
  char *fopt, *farg;
  char *str_index;
  size_t len, next_token;
  char delimiter;

  if ((file = fopen(filename, "r")) == 0)
    {
      fprintf (stderr, "%s: Error opening configuration file '%s'\n",
               CMDLINE_PARSER_PACKAGE, filename);
      return EXIT_FAILURE;
    }

  while ((fgets(linebuf, CONFIG_FILE_LINE_SIZE, file)) != 0)
    {
      ++line_num;
      my_argv[0] = '\0';
      len = strlen(linebuf);
      if (len > (CONFIG_FILE_LINE_BUFFER_SIZE-1))
        {
          fprintf (stderr, "%s:%s:%d: Line too long in configuration file\n",
                   CMDLINE_PARSER_PACKAGE, filename, line_num);
          result = EXIT_FAILURE;
          break;
        }

      /* find first non-whitespace character in the line */
      next_token = strspn (linebuf, " \t\r\n");
      str_index  = linebuf + next_token;

      if ( str_index[0] == '\0' || str_index[0] == '#')
        continue; /* empty line or comment line is skipped */

      fopt = str_index;

      /* truncate fopt at the end of the first non-valid character */
      next_token = strcspn (fopt, " \t\r\n=");

      if (fopt[next_token] == '\0') /* the line is over */
        {
          farg  = 0;
          equal = 0;
          goto noarg;
        }

      /* remember if equal sign is present */
      equal = (fopt[next_token] == '=');
      fopt[next_token++] = '\0';

      /* advance pointers to the next token after the end of fopt */
      next_token += strspn (fopt + next_token, " \t\r\n");

      /* check for the presence of equal sign, and if so, skip it */
      if ( !equal )
        if ((equal = (fopt[next_token] == '=')))
          {
            next_token++;
            next_token += strspn (fopt + next_token, " \t\r\n");
          }
      str_index  += next_token;

      /* find argument */
      farg = str_index;
      if ( farg[0] == '\"' || farg[0] == '\'' )
        { /* quoted argument */
          str_index = strchr (++farg, str_index[0] ); /* skip opening quote */
          if (! str_index)
            {
              fprintf
                (stderr,
                 "%s:%s:%d: unterminated string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }
      else
        { /* read up the remaining part up to a delimiter */
          next_token = strcspn (farg, " \t\r\n#\'\"");
          str_index += next_token;
        }

      /* truncate farg at the delimiter and store it for further check */
      delimiter = *str_index, *str_index++ = '\0';

      /* everything but comment is illegal at the end of line */
      if (delimiter != '\0' && delimiter != '#')
        {
          str_index += strspn(str_index, " \t\r\n");
          if (*str_index != '\0' && *str_index != '#')
            {
              fprintf
                (stderr,
                 "%s:%s:%d: malformed string in configuration file\n",
                 CMDLINE_PARSER_PACKAGE, filename, line_num);
              result = EXIT_FAILURE;
              break;
            }
        }

    noarg:
      if (!strcmp(fopt,"include")) {
        if (farg && *farg) {
          result = _cmdline_parser_configfile(farg, my_argc);
        } else {
          fprintf(stderr, "%s:%s:%d: include requires a filename argument.\n",
                  CMDLINE_PARSER_PACKAGE, filename, line_num);
        }
        continue;
      }
      len = strlen(fopt);
      strcat (my_argv, len > 1 ? "--" : "-");
      strcat (my_argv, fopt);
      if (len > 1 && ((farg && *farg) || equal))
        strcat (my_argv, "=");
      if (farg && *farg)
        strcat (my_argv, farg);
      ++(*my_argc);

      cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
      cmd_line_list_tmp->next = cmd_line_list;
      cmd_line_list = cmd_line_list_tmp;
      cmd_line_list->string_arg = gengetopt_strdup(my_argv);
    } /* while */

  if (file)
    fclose(file);
  return result;
}

int
cmdline_parser_configfile (
  const char *filename,
                           struct gengetopt_args_info *args_info,
                           int override, int initialize, int check_required)
{
  struct cmdline_parser_params params;

  params.override = override;
  params.initialize = initialize;
  params.check_required = check_required;
  params.check_ambiguity = 0;
  params.print_errors = 1;
  
  return cmdline_parser_config_file (filename, args_info, &params);
}

int
cmdline_parser_config_file (const char *filename,
                           struct gengetopt_args_info *args_info,
                           struct cmdline_parser_params *params)
{
  int i, result;
  int my_argc = 1;
  char **my_argv_arg;
  char *additional_error;

  /* store the program name */
  cmd_line_list_tmp = (struct line_list *) malloc (sizeof (struct line_list));
  cmd_line_list_tmp->next = cmd_line_list;
  cmd_line_list = cmd_line_list_tmp;
  cmd_line_list->string_arg = gengetopt_strdup (CMDLINE_PARSER_PACKAGE);

  result = _cmdline_parser_configfile(filename, &my_argc);

  if (result != EXIT_FAILURE) {
    my_argv_arg = (char **) malloc((my_argc+1) * sizeof(char *));
    cmd_line_list_tmp = cmd_line_list;

    for (i = my_argc - 1; i >= 0; --i) {
      my_argv_arg[i] = cmd_line_list_tmp->string_arg;
      cmd_line_list_tmp = cmd_line_list_tmp->next;
    }

    my_argv_arg[my_argc] = 0;

    additional_error = (char *)malloc(strlen(filename) + strlen(ADDITIONAL_ERROR) + 1);
    strcpy (additional_error, ADDITIONAL_ERROR);
    strcat (additional_error, filename);
    result =
      cmdline_parser_internal (my_argc, my_argv_arg, args_info,
                              params,
                              additional_error);

    free (additional_error);
    free (my_argv_arg);
  }

  free_cmd_list();
  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}
/* vim: set ft=c noet ts=8 sts=8 sw=8 tw=80 nojs spell : */
