/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the X86 target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 157;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(X86InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(X86InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static X86InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static X86InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(1),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s80,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v32s1,
  GILLT_v32s8,
  GILLT_v32s16,
  GILLT_v64s1,
  GILLT_v64s8,
};
const static size_t NumTypeObjects = 25;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(80),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(32), 1),
  LLT::vector(ElementCount::getFixed(32), 8),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(64), 1),
  LLT::vector(ElementCount::getFixed(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_TruePredicateBit = 63,
  Feature_HasEGPRBit = 5,
  Feature_NoEGPRBit = 4,
  Feature_HasNDDBit = 6,
  Feature_NoNDDBit = 27,
  Feature_HasZUBit = 153,
  Feature_HasCFBit = 30,
  Feature_HasCMOVBit = 29,
  Feature_NoCMOVBit = 136,
  Feature_HasMMXBit = 108,
  Feature_HasSSE1Bit = 49,
  Feature_UseSSE1Bit = 56,
  Feature_HasSSE2Bit = 48,
  Feature_UseSSE2Bit = 57,
  Feature_HasSSE3Bit = 40,
  Feature_UseSSE3Bit = 66,
  Feature_HasSSSE3Bit = 109,
  Feature_UseSSSE3Bit = 67,
  Feature_UseSSE41Bit = 64,
  Feature_UseSSE42Bit = 71,
  Feature_HasSSE4ABit = 81,
  Feature_NoAVXBit = 77,
  Feature_HasAVXBit = 58,
  Feature_HasAVX2Bit = 52,
  Feature_HasAVX1OnlyBit = 50,
  Feature_HasAVX10_2Bit = 107,
  Feature_NoAVX10_2Bit = 70,
  Feature_HasAVX512Bit = 94,
  Feature_UseAVXBit = 54,
  Feature_NoAVX512Bit = 45,
  Feature_HasCDIBit = 98,
  Feature_HasVPOPCNTDQBit = 102,
  Feature_HasDQIBit = 96,
  Feature_NoDQIBit = 68,
  Feature_HasBWIBit = 97,
  Feature_NoBWIBit = 65,
  Feature_HasVLXBit = 95,
  Feature_NoVLXBit = 44,
  Feature_NoVLX_Or_NoBWIBit = 62,
  Feature_HasVNNIBit = 104,
  Feature_HasVP2INTERSECTBit = 106,
  Feature_HasFP16Bit = 100,
  Feature_HasAVXVNNIINT16Bit = 93,
  Feature_HasAVXVNNIINT8Bit = 88,
  Feature_HasAVXVNNIBit = 82,
  Feature_NoVLX_Or_NoVNNIBit = 83,
  Feature_HasBITALGBit = 105,
  Feature_HasPOPCNTBit = 69,
  Feature_HasAESBit = 74,
  Feature_HasVAESBit = 76,
  Feature_NoVLX_Or_NoVAESBit = 75,
  Feature_HasFXSRBit = 41,
  Feature_HasX87Bit = 39,
  Feature_HasXSAVEBit = 125,
  Feature_HasXSAVEOPTBit = 126,
  Feature_HasXSAVECBit = 127,
  Feature_HasXSAVESBit = 128,
  Feature_HasPCLMULBit = 78,
  Feature_NoVLX_Or_NoVPCLMULQDQBit = 79,
  Feature_HasVPCLMULQDQBit = 80,
  Feature_HasGFNIBit = 85,
  Feature_HasFMABit = 42,
  Feature_HasFMA4Bit = 46,
  Feature_NoFMA4Bit = 43,
  Feature_HasXOPBit = 47,
  Feature_HasTBMBit = 26,
  Feature_NoTBMBit = 141,
  Feature_HasLWPBit = 12,
  Feature_HasMOVBEBit = 3,
  Feature_NoNDD_Or_NoMOVBEBit = 2,
  Feature_HasRDRANDBit = 7,
  Feature_HasF16CBit = 84,
  Feature_HasFSGSBaseBit = 129,
  Feature_HasLZCNTBit = 9,
  Feature_HasBMIBit = 10,
  Feature_HasBMI2Bit = 11,
  Feature_NoBMI2Bit = 140,
  Feature_HasVBMIBit = 99,
  Feature_HasVBMI2Bit = 103,
  Feature_HasIFMABit = 101,
  Feature_HasAVXIFMABit = 86,
  Feature_NoVLX_Or_NoIFMABit = 87,
  Feature_HasRTMBit = 111,
  Feature_HasSHABit = 73,
  Feature_HasSHA512Bit = 90,
  Feature_HasSM3Bit = 91,
  Feature_HasRDSEEDBit = 8,
  Feature_HasSSEPrefetchBit = 59,
  Feature_HasPREFETCHIBit = 20,
  Feature_HasPrefetchWBit = 110,
  Feature_HasMWAITXBit = 139,
  Feature_HasCLDEMOTEBit = 24,
  Feature_HasMOVDIRIBit = 14,
  Feature_HasMOVDIR64BBit = 15,
  Feature_HasMOVRSBit = 25,
  Feature_HasPTWRITEBit = 132,
  Feature_FPStackf32Bit = 37,
  Feature_FPStackf64Bit = 38,
  Feature_HasSM4Bit = 92,
  Feature_HasCLFLUSHBit = 60,
  Feature_HasCLFLUSHOPTBit = 22,
  Feature_HasCLWBBit = 23,
  Feature_HasWBNOINVDBit = 124,
  Feature_HasRDPIDBit = 131,
  Feature_HasWAITPKGBit = 13,
  Feature_HasINVPCIDBit = 130,
  Feature_HasCX8Bit = 137,
  Feature_HasCX16Bit = 138,
  Feature_HasENQCMDBit = 16,
  Feature_HasAMXFP16Bit = 116,
  Feature_HasCMPCCXADDBit = 21,
  Feature_HasAVXNECONVERTBit = 89,
  Feature_HasKLBit = 112,
  Feature_HasRAOINTBit = 122,
  Feature_HasSERIALIZEBit = 17,
  Feature_HasTSXLDTRKBit = 18,
  Feature_HasAMXTILEBit = 113,
  Feature_HasAMXBF16Bit = 115,
  Feature_HasAMXINT8Bit = 114,
  Feature_HasAMXCOMPLEXBit = 117,
  Feature_HasAMXFP8Bit = 118,
  Feature_HasAMXTRANSPOSEBit = 119,
  Feature_HasAMXAVX512Bit = 120,
  Feature_HasAMXTF32Bit = 121,
  Feature_HasUINTRBit = 19,
  Feature_HasUSERMSRBit = 123,
  Feature_HasCRC32Bit = 72,
  Feature_Not64BitModeBit = 0,
  Feature_In64BitModeBit = 1,
  Feature_IsLP64Bit = 134,
  Feature_NotLP64Bit = 133,
  Feature_NotWin64WithoutFPBit = 135,
  Feature_IsPSBit = 144,
  Feature_NotPSBit = 143,
  Feature_KernelCodeBit = 145,
  Feature_NearDataBit = 147,
  Feature_IsNotPICBit = 146,
  Feature_OptForSizeBit = 53,
  Feature_OptForMinSizeBit = 51,
  Feature_OptForSpeedBit = 142,
  Feature_UseIncDecBit = 28,
  Feature_NoSSE41_Or_OptForSizeBit = 55,
  Feature_ImportCallOptimizationEnabledBit = 35,
  Feature_ImportCallOptimizationDisabledBit = 33,
  Feature_IsWin64CCFuncBit = 151,
  Feature_IsNotWin64CCFuncBit = 150,
  Feature_IsHiPECCFuncBit = 149,
  Feature_IsNotHiPECCFuncBit = 148,
  Feature_CallImmAddrBit = 152,
  Feature_FavorMemIndirectCallBit = 31,
  Feature_HasFastSHLDRotateBit = 36,
  Feature_HasMFenceBit = 61,
  Feature_UseIndirectThunkCallsBit = 34,
  Feature_NotUseIndirectThunkCallsBit = 32,
  Feature_HwMode2Bit = 156,
  Feature_HwMode1Bit = 155,
  Feature_HwMode0Bit = 154,
};

PredicateBitset X86InstructionSelector::
computeAvailableModuleFeatures(const X86Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (true)
    Features.set(Feature_TruePredicateBit);
  if (Subtarget->hasEGPR())
    Features.set(Feature_HasEGPRBit);
  if (!Subtarget->hasEGPR())
    Features.set(Feature_NoEGPRBit);
  if (Subtarget->hasNDD())
    Features.set(Feature_HasNDDBit);
  if (!Subtarget->hasNDD())
    Features.set(Feature_NoNDDBit);
  if (Subtarget->hasZU())
    Features.set(Feature_HasZUBit);
  if (Subtarget->hasCF())
    Features.set(Feature_HasCFBit);
  if (Subtarget->canUseCMOV())
    Features.set(Feature_HasCMOVBit);
  if (!Subtarget->canUseCMOV())
    Features.set(Feature_NoCMOVBit);
  if (Subtarget->hasMMX())
    Features.set(Feature_HasMMXBit);
  if (Subtarget->hasSSE1())
    Features.set(Feature_HasSSE1Bit);
  if (Subtarget->hasSSE1() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE1Bit);
  if (Subtarget->hasSSE2())
    Features.set(Feature_HasSSE2Bit);
  if (Subtarget->hasSSE2() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE2Bit);
  if (Subtarget->hasSSE3())
    Features.set(Feature_HasSSE3Bit);
  if (Subtarget->hasSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE3Bit);
  if (Subtarget->hasSSSE3())
    Features.set(Feature_HasSSSE3Bit);
  if (Subtarget->hasSSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSSE3Bit);
  if (Subtarget->hasSSE41() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE41Bit);
  if (Subtarget->hasSSE42() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE42Bit);
  if (Subtarget->hasSSE4A())
    Features.set(Feature_HasSSE4ABit);
  if (!Subtarget->hasAVX())
    Features.set(Feature_NoAVXBit);
  if (Subtarget->hasAVX())
    Features.set(Feature_HasAVXBit);
  if (Subtarget->hasAVX2())
    Features.set(Feature_HasAVX2Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX2())
    Features.set(Feature_HasAVX1OnlyBit);
  if (Subtarget->hasAVX10_2())
    Features.set(Feature_HasAVX10_2Bit);
  if (!Subtarget->hasAVX10_2())
    Features.set(Feature_NoAVX10_2Bit);
  if (Subtarget->hasAVX512())
    Features.set(Feature_HasAVX512Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX512())
    Features.set(Feature_UseAVXBit);
  if (!Subtarget->hasAVX512())
    Features.set(Feature_NoAVX512Bit);
  if (Subtarget->hasCDI())
    Features.set(Feature_HasCDIBit);
  if (Subtarget->hasVPOPCNTDQ())
    Features.set(Feature_HasVPOPCNTDQBit);
  if (Subtarget->hasDQI())
    Features.set(Feature_HasDQIBit);
  if (!Subtarget->hasDQI())
    Features.set(Feature_NoDQIBit);
  if (Subtarget->hasBWI())
    Features.set(Feature_HasBWIBit);
  if (!Subtarget->hasBWI())
    Features.set(Feature_NoBWIBit);
  if (Subtarget->hasVLX())
    Features.set(Feature_HasVLXBit);
  if (!Subtarget->hasVLX())
    Features.set(Feature_NoVLXBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasBWI())
    Features.set(Feature_NoVLX_Or_NoBWIBit);
  if (Subtarget->hasVNNI())
    Features.set(Feature_HasVNNIBit);
  if (Subtarget->hasVP2INTERSECT())
    Features.set(Feature_HasVP2INTERSECTBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasAVXVNNIINT16())
    Features.set(Feature_HasAVXVNNIINT16Bit);
  if (Subtarget->hasAVXVNNIINT8())
    Features.set(Feature_HasAVXVNNIINT8Bit);
  if (Subtarget->hasAVXVNNI())
    Features.set(Feature_HasAVXVNNIBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVNNI())
    Features.set(Feature_NoVLX_Or_NoVNNIBit);
  if (Subtarget->hasBITALG())
    Features.set(Feature_HasBITALGBit);
  if (Subtarget->hasPOPCNT())
    Features.set(Feature_HasPOPCNTBit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasVAES())
    Features.set(Feature_HasVAESBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVAES())
    Features.set(Feature_NoVLX_Or_NoVAESBit);
  if (Subtarget->hasFXSR())
    Features.set(Feature_HasFXSRBit);
  if (Subtarget->hasX87())
    Features.set(Feature_HasX87Bit);
  if (Subtarget->hasXSAVE())
    Features.set(Feature_HasXSAVEBit);
  if (Subtarget->hasXSAVEOPT())
    Features.set(Feature_HasXSAVEOPTBit);
  if (Subtarget->hasXSAVEC())
    Features.set(Feature_HasXSAVECBit);
  if (Subtarget->hasXSAVES())
    Features.set(Feature_HasXSAVESBit);
  if (Subtarget->hasPCLMUL())
    Features.set(Feature_HasPCLMULBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_NoVLX_Or_NoVPCLMULQDQBit);
  if (Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_HasVPCLMULQDQBit);
  if (Subtarget->hasGFNI())
    Features.set(Feature_HasGFNIBit);
  if (Subtarget->hasFMA())
    Features.set(Feature_HasFMABit);
  if (Subtarget->hasFMA4())
    Features.set(Feature_HasFMA4Bit);
  if (!Subtarget->hasFMA4())
    Features.set(Feature_NoFMA4Bit);
  if (Subtarget->hasXOP())
    Features.set(Feature_HasXOPBit);
  if (Subtarget->hasTBM())
    Features.set(Feature_HasTBMBit);
  if (!Subtarget->hasTBM())
    Features.set(Feature_NoTBMBit);
  if (Subtarget->hasLWP())
    Features.set(Feature_HasLWPBit);
  if (Subtarget->hasMOVBE())
    Features.set(Feature_HasMOVBEBit);
  if (!Subtarget->hasNDD() || !Subtarget->hasMOVBE())
    Features.set(Feature_NoNDD_Or_NoMOVBEBit);
  if (Subtarget->hasRDRAND())
    Features.set(Feature_HasRDRANDBit);
  if (Subtarget->hasF16C())
    Features.set(Feature_HasF16CBit);
  if (Subtarget->hasFSGSBase())
    Features.set(Feature_HasFSGSBaseBit);
  if (Subtarget->hasLZCNT())
    Features.set(Feature_HasLZCNTBit);
  if (Subtarget->hasBMI())
    Features.set(Feature_HasBMIBit);
  if (Subtarget->hasBMI2())
    Features.set(Feature_HasBMI2Bit);
  if (!Subtarget->hasBMI2())
    Features.set(Feature_NoBMI2Bit);
  if (Subtarget->hasVBMI())
    Features.set(Feature_HasVBMIBit);
  if (Subtarget->hasVBMI2())
    Features.set(Feature_HasVBMI2Bit);
  if (Subtarget->hasIFMA())
    Features.set(Feature_HasIFMABit);
  if (Subtarget->hasAVXIFMA())
    Features.set(Feature_HasAVXIFMABit);
  if (!Subtarget->hasVLX() || !Subtarget->hasIFMA())
    Features.set(Feature_NoVLX_Or_NoIFMABit);
  if (Subtarget->hasRTM())
    Features.set(Feature_HasRTMBit);
  if (Subtarget->hasSHA())
    Features.set(Feature_HasSHABit);
  if (Subtarget->hasSHA512())
    Features.set(Feature_HasSHA512Bit);
  if (Subtarget->hasSM3())
    Features.set(Feature_HasSM3Bit);
  if (Subtarget->hasRDSEED())
    Features.set(Feature_HasRDSEEDBit);
  if (Subtarget->hasSSEPrefetch())
    Features.set(Feature_HasSSEPrefetchBit);
  if (Subtarget->hasPREFETCHI())
    Features.set(Feature_HasPREFETCHIBit);
  if (Subtarget->hasPrefetchW())
    Features.set(Feature_HasPrefetchWBit);
  if (Subtarget->hasMWAITX())
    Features.set(Feature_HasMWAITXBit);
  if (Subtarget->hasCLDEMOTE())
    Features.set(Feature_HasCLDEMOTEBit);
  if (Subtarget->hasMOVDIRI())
    Features.set(Feature_HasMOVDIRIBit);
  if (Subtarget->hasMOVDIR64B())
    Features.set(Feature_HasMOVDIR64BBit);
  if (Subtarget->hasMOVRS())
    Features.set(Feature_HasMOVRSBit);
  if (Subtarget->hasPTWRITE())
    Features.set(Feature_HasPTWRITEBit);
  if (!Subtarget->hasSSE1())
    Features.set(Feature_FPStackf32Bit);
  if (!Subtarget->hasSSE2())
    Features.set(Feature_FPStackf64Bit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasCLFLUSH())
    Features.set(Feature_HasCLFLUSHBit);
  if (Subtarget->hasCLFLUSHOPT())
    Features.set(Feature_HasCLFLUSHOPTBit);
  if (Subtarget->hasCLWB())
    Features.set(Feature_HasCLWBBit);
  if (Subtarget->hasWBNOINVD())
    Features.set(Feature_HasWBNOINVDBit);
  if (Subtarget->hasRDPID())
    Features.set(Feature_HasRDPIDBit);
  if (Subtarget->hasWAITPKG())
    Features.set(Feature_HasWAITPKGBit);
  if (Subtarget->hasINVPCID())
    Features.set(Feature_HasINVPCIDBit);
  if (Subtarget->hasCX8())
    Features.set(Feature_HasCX8Bit);
  if (Subtarget->hasCX16())
    Features.set(Feature_HasCX16Bit);
  if (Subtarget->hasENQCMD())
    Features.set(Feature_HasENQCMDBit);
  if (Subtarget->hasAMXFP16())
    Features.set(Feature_HasAMXFP16Bit);
  if (Subtarget->hasCMPCCXADD())
    Features.set(Feature_HasCMPCCXADDBit);
  if (Subtarget->hasAVXNECONVERT())
    Features.set(Feature_HasAVXNECONVERTBit);
  if (Subtarget->hasKL())
    Features.set(Feature_HasKLBit);
  if (Subtarget->hasRAOINT())
    Features.set(Feature_HasRAOINTBit);
  if (Subtarget->hasSERIALIZE())
    Features.set(Feature_HasSERIALIZEBit);
  if (Subtarget->hasTSXLDTRK())
    Features.set(Feature_HasTSXLDTRKBit);
  if (Subtarget->hasAMXTILE())
    Features.set(Feature_HasAMXTILEBit);
  if (Subtarget->hasAMXBF16())
    Features.set(Feature_HasAMXBF16Bit);
  if (Subtarget->hasAMXINT8())
    Features.set(Feature_HasAMXINT8Bit);
  if (Subtarget->hasAMXCOMPLEX())
    Features.set(Feature_HasAMXCOMPLEXBit);
  if (Subtarget->hasAMXFP8())
    Features.set(Feature_HasAMXFP8Bit);
  if (Subtarget->hasAMXTRANSPOSE())
    Features.set(Feature_HasAMXTRANSPOSEBit);
  if (Subtarget->hasAMXAVX512())
    Features.set(Feature_HasAMXAVX512Bit);
  if (Subtarget->hasAMXTF32())
    Features.set(Feature_HasAMXTF32Bit);
  if (Subtarget->hasUINTR())
    Features.set(Feature_HasUINTRBit);
  if (Subtarget->hasUSERMSR())
    Features.set(Feature_HasUSERMSRBit);
  if (Subtarget->hasCRC32())
    Features.set(Feature_HasCRC32Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_Not64BitModeBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->isTarget64BitLP64())
    Features.set(Feature_IsLP64Bit);
  if (!Subtarget->isTarget64BitLP64())
    Features.set(Feature_NotLP64Bit);
  if (Subtarget->isTargetPS())
    Features.set(Feature_IsPSBit);
  if (!Subtarget->isTargetPS())
    Features.set(Feature_NotPSBit);
  if (TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_KernelCodeBit);
  if (TM.getCodeModel() == CodeModel::Small ||TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_NearDataBit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_IsNotPICBit);
  if (Subtarget->isLegalToCallImmediateAddr())
    Features.set(Feature_CallImmAddrBit);
  if (!Subtarget->slowTwoMemOps())
    Features.set(Feature_FavorMemIndirectCallBit);
  if (Subtarget->hasFastSHLDRotate())
    Features.set(Feature_HasFastSHLDRotateBit);
  if (Subtarget->hasMFence())
    Features.set(Feature_HasMFenceBit);
  if (Subtarget->useIndirectThunkCalls())
    Features.set(Feature_UseIndirectThunkCallsBit);
  if (!Subtarget->useIndirectThunkCalls())
    Features.set(Feature_NotUseIndirectThunkCallsBit);
  if (!((Subtarget->is64Bit()) && (!Subtarget->getTargetTriple().isX32())) && !((Subtarget->getTargetTriple().isX32())))
    Features.set(Feature_HwMode2Bit);
  if ((Subtarget->getTargetTriple().isX32()))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()) && (!Subtarget->getTargetTriple().isX32()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void X86InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const X86Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset X86InstructionSelector::
computeAvailableFunctionFeatures(const X86Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!Subtarget->isTargetWin64() ||Subtarget->getFrameLowering()->hasFP(*MF))
    Features.set(Feature_NotWin64WithoutFPBit);
  if (shouldOptForSize(MF))
    Features.set(Feature_OptForSizeBit);
  if (MF->getFunction().hasMinSize())
    Features.set(Feature_OptForMinSizeBit);
  if (!shouldOptForSize(MF))
    Features.set(Feature_OptForSpeedBit);
  if (!Subtarget->slowIncDec() || shouldOptForSize(MF))
    Features.set(Feature_UseIncDecBit);
  if (shouldOptForSize(MF) || !Subtarget->hasSSE41())
    Features.set(Feature_NoSSE41_Or_OptForSizeBit);
  if (MF->getFunction().getParent()->getModuleFlag("import-call-optimization"))
    Features.set(Feature_ImportCallOptimizationEnabledBit);
  if (!MF->getFunction().getParent()->getModuleFlag("import-call-optimization"))
    Features.set(Feature_ImportCallOptimizationDisabledBit);
  if (Subtarget->isCallingConvWin64(MF->getFunction().getCallingConv()))
    Features.set(Feature_IsWin64CCFuncBit);
  if (!Subtarget->isCallingConvWin64(MF->getFunction().getCallingConv()))
    Features.set(Feature_IsNotWin64CCFuncBit);
  if (MF->getFunction().getCallingConv() == CallingConv::HiPE)
    Features.set(Feature_IsHiPECCFuncBit);
  if (MF->getFunction().getCallingConv() != CallingConv::HiPE)
    Features.set(Feature_IsNotHiPECCFuncBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_FPStackf32,
  GIFBS_FPStackf64,
  GIFBS_HasAVX,
  GIFBS_HasAVX1Only,
  GIFBS_HasAVX2,
  GIFBS_HasAVX512,
  GIFBS_HasAVXNECONVERT,
  GIFBS_HasBITALG,
  GIFBS_HasBMI,
  GIFBS_HasBWI,
  GIFBS_HasCDI,
  GIFBS_HasCLDEMOTE,
  GIFBS_HasCLFLUSH,
  GIFBS_HasCLFLUSHOPT,
  GIFBS_HasCLWB,
  GIFBS_HasDQI,
  GIFBS_HasFP16,
  GIFBS_HasFXSR,
  GIFBS_HasFastSHLDRotate,
  GIFBS_HasKL,
  GIFBS_HasLWP,
  GIFBS_HasLZCNT,
  GIFBS_HasMFence,
  GIFBS_HasMMX,
  GIFBS_HasMOVBE,
  GIFBS_HasMOVRS,
  GIFBS_HasMWAITX,
  GIFBS_HasNDD,
  GIFBS_HasPOPCNT,
  GIFBS_HasPTWRITE,
  GIFBS_HasPrefetchW,
  GIFBS_HasRTM,
  GIFBS_HasSERIALIZE,
  GIFBS_HasSHA,
  GIFBS_HasSHA512,
  GIFBS_HasSM3,
  GIFBS_HasSM4,
  GIFBS_HasSSE1,
  GIFBS_HasSSE2,
  GIFBS_HasSSE3,
  GIFBS_HasSSE4A,
  GIFBS_HasSSEPrefetch,
  GIFBS_HasTBM,
  GIFBS_HasTSXLDTRK,
  GIFBS_HasVBMI2,
  GIFBS_HasVLX,
  GIFBS_HasVPOPCNTDQ,
  GIFBS_HasWAITPKG,
  GIFBS_HasWBNOINVD,
  GIFBS_HasX87,
  GIFBS_HasXOP,
  GIFBS_HasXSAVE,
  GIFBS_HasXSAVEC,
  GIFBS_HasXSAVEOPT,
  GIFBS_HasXSAVES,
  GIFBS_HasZU,
  GIFBS_In64BitMode,
  GIFBS_IsPS,
  GIFBS_NoAVX,
  GIFBS_NoDQI,
  GIFBS_NoEGPR,
  GIFBS_NoNDD,
  GIFBS_NoNDD_Or_NoMOVBE,
  GIFBS_NoVLX,
  GIFBS_Not64BitMode,
  GIFBS_NotPS,
  GIFBS_UseAVX,
  GIFBS_UseIncDec,
  GIFBS_UseSSE1,
  GIFBS_UseSSE2,
  GIFBS_UseSSE3,
  GIFBS_UseSSE41,
  GIFBS_UseSSSE3,
  GIFBS_HasAES_HasAVX,
  GIFBS_HasAES_NoAVX,
  GIFBS_HasAMXBF16_In64BitMode,
  GIFBS_HasAMXCOMPLEX_In64BitMode,
  GIFBS_HasAMXFP16_In64BitMode,
  GIFBS_HasAMXFP8_In64BitMode,
  GIFBS_HasAMXINT8_In64BitMode,
  GIFBS_HasAMXTF32_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode,
  GIFBS_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAVX_In64BitMode,
  GIFBS_HasAVX_NoBWI,
  GIFBS_HasAVX_NoVLX,
  GIFBS_HasAVX_NoVLX_Or_NoBWI,
  GIFBS_HasAVX10_2_HasSM4,
  GIFBS_HasAVX2_NoVLX,
  GIFBS_HasAVX2_NoVLX_Or_NoBWI,
  GIFBS_HasAVX512_HasVAES,
  GIFBS_HasAVX512_HasVLX,
  GIFBS_HasAVX512_HasVPCLMULQDQ,
  GIFBS_HasAVX512_NoBWI,
  GIFBS_HasAVX512_NoDQI,
  GIFBS_HasAVX512_NoEGPR,
  GIFBS_HasAVX512_NoVLX,
  GIFBS_HasAVX512_OptForSize,
  GIFBS_HasBITALG_HasVLX,
  GIFBS_HasBITALG_NoVLX,
  GIFBS_HasBMI_HasEGPR,
  GIFBS_HasBMI_NoEGPR,
  GIFBS_HasBMI2_HasEGPR,
  GIFBS_HasBMI2_NoEGPR,
  GIFBS_HasBWI_HasVLX,
  GIFBS_HasBWI_NoEGPR,
  GIFBS_HasBWI_NoVLX,
  GIFBS_HasCDI_HasVLX,
  GIFBS_HasCDI_NoVLX,
  GIFBS_HasCRC32_NoEGPR,
  GIFBS_HasDQI_HasVLX,
  GIFBS_HasDQI_NoBWI,
  GIFBS_HasDQI_NoEGPR,
  GIFBS_HasDQI_NoVLX,
  GIFBS_HasEGPR_HasINVPCID,
  GIFBS_HasEGPR_In64BitMode,
  GIFBS_HasFMA4_NoAVX512,
  GIFBS_HasFMA4_NoVLX,
  GIFBS_HasFP16_HasVLX,
  GIFBS_HasFP16_In64BitMode,
  GIFBS_HasFP16_OptForSize,
  GIFBS_HasFSGSBase_In64BitMode,
  GIFBS_HasFXSR_In64BitMode,
  GIFBS_HasINVPCID_NoEGPR,
  GIFBS_HasINVPCID_Not64BitMode,
  GIFBS_HasMOVBE_NoEGPR,
  GIFBS_HasMOVDIR64B_NoEGPR,
  GIFBS_HasMOVDIRI_NoEGPR,
  GIFBS_HasNDD_In64BitMode,
  GIFBS_HasNDD_UseIncDec,
  GIFBS_HasPCLMUL_NoAVX,
  GIFBS_HasPREFETCHI_In64BitMode,
  GIFBS_HasPTWRITE_In64BitMode,
  GIFBS_HasRDPID_In64BitMode,
  GIFBS_HasRDPID_Not64BitMode,
  GIFBS_HasUINTR_In64BitMode,
  GIFBS_HasUSERMSR_NoEGPR,
  GIFBS_HasVAES_HasVLX,
  GIFBS_HasVAES_NoVLX,
  GIFBS_HasVBMI2_HasVLX,
  GIFBS_HasVLX_HasVPCLMULQDQ,
  GIFBS_HasVLX_HasVPOPCNTDQ,
  GIFBS_HasVPCLMULQDQ_NoVLX,
  GIFBS_HasVPOPCNTDQ_NoVLX,
  GIFBS_HasWAITPKG_In64BitMode,
  GIFBS_HasWAITPKG_Not64BitMode,
  GIFBS_HasXSAVE_In64BitMode,
  GIFBS_HasXSAVEC_In64BitMode,
  GIFBS_HasXSAVEOPT_In64BitMode,
  GIFBS_HasXSAVES_In64BitMode,
  GIFBS_In64BitMode_UseIncDec,
  GIFBS_In64BitMode_UseSSE2,
  GIFBS_NoNDD_UseIncDec,
  GIFBS_Not64BitMode_OptForSize,
  GIFBS_NotWin64WithoutFP_OptForMinSize,
  GIFBS_OptForSize_UseAVX,
  GIFBS_OptForSize_UseSSE1,
  GIFBS_OptForSize_UseSSE2,
  GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES,
  GIFBS_HasAMXAVX512_HasAVX10_2_In64BitMode,
  GIFBS_HasAMXBF16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXFP16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXTF32_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXTILE_HasEGPR_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode_NoEGPR,
  GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ,
  GIFBS_HasAVX10_2_HasMOVRS_In64BitMode,
  GIFBS_HasAVX512_HasEGPR_In64BitMode,
  GIFBS_HasBWI_HasEGPR_In64BitMode,
  GIFBS_HasCRC32_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasVLX_NoBWI,
  GIFBS_HasEGPR_HasMOVBE_In64BitMode,
  GIFBS_HasEGPR_HasMOVDIR64B_In64BitMode,
  GIFBS_HasEGPR_HasMOVDIRI_In64BitMode,
  GIFBS_HasEGPR_HasMOVRS_In64BitMode,
  GIFBS_HasEGPR_HasUSERMSR_In64BitMode,
  GIFBS_HasFMA_NoAVX512_NoFMA4,
  GIFBS_HasFMA_NoFMA4_NoVLX,
  GIFBS_HasMOVBE_HasNDD_In64BitMode,
  GIFBS_HasMOVDIR64B_In64BitMode_NoEGPR,
  GIFBS_HasMOVDIRI_In64BitMode_NoEGPR,
  GIFBS_HasMOVRS_In64BitMode_NoEGPR,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_FPStackf32Bit, },
  {Feature_FPStackf64Bit, },
  {Feature_HasAVXBit, },
  {Feature_HasAVX1OnlyBit, },
  {Feature_HasAVX2Bit, },
  {Feature_HasAVX512Bit, },
  {Feature_HasAVXNECONVERTBit, },
  {Feature_HasBITALGBit, },
  {Feature_HasBMIBit, },
  {Feature_HasBWIBit, },
  {Feature_HasCDIBit, },
  {Feature_HasCLDEMOTEBit, },
  {Feature_HasCLFLUSHBit, },
  {Feature_HasCLFLUSHOPTBit, },
  {Feature_HasCLWBBit, },
  {Feature_HasDQIBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFXSRBit, },
  {Feature_HasFastSHLDRotateBit, },
  {Feature_HasKLBit, },
  {Feature_HasLWPBit, },
  {Feature_HasLZCNTBit, },
  {Feature_HasMFenceBit, },
  {Feature_HasMMXBit, },
  {Feature_HasMOVBEBit, },
  {Feature_HasMOVRSBit, },
  {Feature_HasMWAITXBit, },
  {Feature_HasNDDBit, },
  {Feature_HasPOPCNTBit, },
  {Feature_HasPTWRITEBit, },
  {Feature_HasPrefetchWBit, },
  {Feature_HasRTMBit, },
  {Feature_HasSERIALIZEBit, },
  {Feature_HasSHABit, },
  {Feature_HasSHA512Bit, },
  {Feature_HasSM3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSSE1Bit, },
  {Feature_HasSSE2Bit, },
  {Feature_HasSSE3Bit, },
  {Feature_HasSSE4ABit, },
  {Feature_HasSSEPrefetchBit, },
  {Feature_HasTBMBit, },
  {Feature_HasTSXLDTRKBit, },
  {Feature_HasVBMI2Bit, },
  {Feature_HasVLXBit, },
  {Feature_HasVPOPCNTDQBit, },
  {Feature_HasWAITPKGBit, },
  {Feature_HasWBNOINVDBit, },
  {Feature_HasX87Bit, },
  {Feature_HasXOPBit, },
  {Feature_HasXSAVEBit, },
  {Feature_HasXSAVECBit, },
  {Feature_HasXSAVEOPTBit, },
  {Feature_HasXSAVESBit, },
  {Feature_HasZUBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsPSBit, },
  {Feature_NoAVXBit, },
  {Feature_NoDQIBit, },
  {Feature_NoEGPRBit, },
  {Feature_NoNDDBit, },
  {Feature_NoNDD_Or_NoMOVBEBit, },
  {Feature_NoVLXBit, },
  {Feature_Not64BitModeBit, },
  {Feature_NotPSBit, },
  {Feature_UseAVXBit, },
  {Feature_UseIncDecBit, },
  {Feature_UseSSE1Bit, },
  {Feature_UseSSE2Bit, },
  {Feature_UseSSE3Bit, },
  {Feature_UseSSE41Bit, },
  {Feature_UseSSSE3Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, },
  {Feature_HasAESBit, Feature_NoAVXBit, },
  {Feature_HasAMXBF16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXINT8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_NoBWIBit, },
  {Feature_HasAVXBit, Feature_NoVLXBit, },
  {Feature_HasAVXBit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX10_2Bit, Feature_HasSM4Bit, },
  {Feature_HasAVX2Bit, Feature_NoVLXBit, },
  {Feature_HasAVX2Bit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_HasVAESBit, },
  {Feature_HasAVX512Bit, Feature_HasVLXBit, },
  {Feature_HasAVX512Bit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_NoDQIBit, },
  {Feature_HasAVX512Bit, Feature_NoEGPRBit, },
  {Feature_HasAVX512Bit, Feature_NoVLXBit, },
  {Feature_HasAVX512Bit, Feature_OptForSizeBit, },
  {Feature_HasBITALGBit, Feature_HasVLXBit, },
  {Feature_HasBITALGBit, Feature_NoVLXBit, },
  {Feature_HasBMIBit, Feature_HasEGPRBit, },
  {Feature_HasBMIBit, Feature_NoEGPRBit, },
  {Feature_HasBMI2Bit, Feature_HasEGPRBit, },
  {Feature_HasBMI2Bit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_HasVLXBit, },
  {Feature_HasBWIBit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_NoVLXBit, },
  {Feature_HasCDIBit, Feature_HasVLXBit, },
  {Feature_HasCDIBit, Feature_NoVLXBit, },
  {Feature_HasCRC32Bit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, },
  {Feature_HasDQIBit, Feature_NoBWIBit, },
  {Feature_HasDQIBit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_NoVLXBit, },
  {Feature_HasEGPRBit, Feature_HasINVPCIDBit, },
  {Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasFMA4Bit, Feature_NoAVX512Bit, },
  {Feature_HasFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasFP16Bit, Feature_HasVLXBit, },
  {Feature_HasFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasFP16Bit, Feature_OptForSizeBit, },
  {Feature_HasFSGSBaseBit, Feature_In64BitModeBit, },
  {Feature_HasFXSRBit, Feature_In64BitModeBit, },
  {Feature_HasINVPCIDBit, Feature_NoEGPRBit, },
  {Feature_HasINVPCIDBit, Feature_Not64BitModeBit, },
  {Feature_HasMOVBEBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIR64BBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIRIBit, Feature_NoEGPRBit, },
  {Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_UseIncDecBit, },
  {Feature_HasPCLMULBit, Feature_NoAVXBit, },
  {Feature_HasPREFETCHIBit, Feature_In64BitModeBit, },
  {Feature_HasPTWRITEBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_Not64BitModeBit, },
  {Feature_HasUINTRBit, Feature_In64BitModeBit, },
  {Feature_HasUSERMSRBit, Feature_NoEGPRBit, },
  {Feature_HasVAESBit, Feature_HasVLXBit, },
  {Feature_HasVAESBit, Feature_NoVLXBit, },
  {Feature_HasVBMI2Bit, Feature_HasVLXBit, },
  {Feature_HasVLXBit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasVLXBit, Feature_HasVPOPCNTDQBit, },
  {Feature_HasVPCLMULQDQBit, Feature_NoVLXBit, },
  {Feature_HasVPOPCNTDQBit, Feature_NoVLXBit, },
  {Feature_HasWAITPKGBit, Feature_In64BitModeBit, },
  {Feature_HasWAITPKGBit, Feature_Not64BitModeBit, },
  {Feature_HasXSAVEBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVECBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVEOPTBit, Feature_In64BitModeBit, },
  {Feature_HasXSAVESBit, Feature_In64BitModeBit, },
  {Feature_In64BitModeBit, Feature_UseIncDecBit, },
  {Feature_In64BitModeBit, Feature_UseSSE2Bit, },
  {Feature_NoNDDBit, Feature_UseIncDecBit, },
  {Feature_Not64BitModeBit, Feature_OptForSizeBit, },
  {Feature_NotWin64WithoutFPBit, Feature_OptForMinSizeBit, },
  {Feature_OptForSizeBit, Feature_UseAVXBit, },
  {Feature_OptForSizeBit, Feature_UseSSE1Bit, },
  {Feature_OptForSizeBit, Feature_UseSSE2Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, Feature_NoVLX_Or_NoVAESBit, },
  {Feature_HasAMXAVX512Bit, Feature_HasAVX10_2Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXBF16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasAVXBit, Feature_HasPCLMULBit, Feature_NoVLX_Or_NoVPCLMULQDQBit, },
  {Feature_HasAVX10_2Bit, Feature_HasMOVRSBit, Feature_In64BitModeBit, },
  {Feature_HasAVX512Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasBWIBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasCRC32Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, Feature_NoBWIBit, },
  {Feature_HasEGPRBit, Feature_HasMOVBEBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVDIR64BBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVDIRIBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasMOVRSBit, Feature_In64BitModeBit, },
  {Feature_HasEGPRBit, Feature_HasUSERMSRBit, Feature_In64BitModeBit, },
  {Feature_HasFMABit, Feature_NoAVX512Bit, Feature_NoFMA4Bit, },
  {Feature_HasFMABit, Feature_NoFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasMOVBEBit, Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasMOVDIR64BBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasMOVDIRIBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
  {Feature_HasMOVRSBit, Feature_In64BitModeBit, Feature_NoEGPRBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_addr,
};
// See constructor for table contents

X86InstructionSelector::ComplexMatcherMemFn
X86InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &X86InstructionSelector::selectAddr, // gi_addr
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_alignedload = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_alignedstore,
  GICXXPred_MI_Predicate_imm_su,
  GICXXPred_MI_Predicate_loadi8,
  GICXXPred_MI_Predicate_loadi16,
  GICXXPred_MI_Predicate_loadi32,
  GICXXPred_MI_Predicate_or_disjoint,
};
bool X86InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_alignedload: {
    
        auto &LdSt = cast<GLoadStore>(MI);
        return LdSt.getAlign() >= LdSt.getMemSize().getValue();
      
    llvm_unreachable("alignedload should have returned");
  }
  case GICXXPred_MI_Predicate_alignedstore: {
    
        auto &LdSt = cast<GLoadStore>(MI);
        return LdSt.getAlign() >= LdSt.getMemSize().getValue();
      
    llvm_unreachable("alignedstore should have returned");
  }
  case GICXXPred_MI_Predicate_imm_su: {
     return true; 
  }
  case GICXXPred_MI_Predicate_loadi8: {
     return isa<GLoad>(MI); 
  }
  case GICXXPred_MI_Predicate_loadi16: {
    
        auto &Load = cast<GLoad>(MI);
        LLT Ty = MRI.getType(Load.getDstReg());
        // Non extending load has MMO and destination types of the same size
        if (Load.getMemSizeInBits() == Ty.getSizeInBits())
           return true;
        return Load.getAlign() >= 2 && Load.isSimple();
      
    llvm_unreachable("loadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_loadi32: {
    
        auto &Load = cast<GLoad>(MI);
        LLT Ty = MRI.getType(Load.getDstReg());
        // Non extending load has MMO and destination types of the same size
        if (Load.getMemSizeInBits() == Ty.getSizeInBits())
           return true;
        return Load.getAlign() >= 4 && Load.isSimple();
      
    llvm_unreachable("loadi32 should have returned");
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AndMask64 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BTCBTSMask64,
  GICXXPred_I64_Predicate_BTRMask64,
  GICXXPred_I64_Predicate_i16immSExt8,
  GICXXPred_I64_Predicate_i32immSExt8,
  GICXXPred_I64_Predicate_i64immSExt8,
  GICXXPred_I64_Predicate_i64immSExt32,
  GICXXPred_I64_Predicate_i64immZExt32,
  GICXXPred_I64_Predicate_i64immZExt32SExt8,
  GICXXPred_I64_Predicate_i64timmSExt32,
  GICXXPred_I64_Predicate_immff00_ffff,
};
bool X86InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AndMask64: {
    
      return isMask_64(Imm) && !isUInt<32>(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTCBTSMask64: {
    
      return !isInt<32>(Imm) && isPowerOf2_64(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTRMask64: {
    
      return !isUInt<32>(Imm) && !isInt<32>(Imm) && isPowerOf2_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_i16immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32: {
     return isUInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32SExt8: {
    
      return isUInt<32>(Imm) && isInt<8>(static_cast<int32_t>(Imm));
    
  }
  case GICXXPred_I64_Predicate_i64timmSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_immff00_ffff: {
    
      return Imm >= 0xff00 && Imm <= 0xffff;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm1,
  GICXXPred_APFloat_Predicate_fpimmneg0,
  GICXXPred_APFloat_Predicate_fpimmneg1,
};
bool X86InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm1: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg1: {
    
      return Imm.isExactlyValue(-1.0);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool X86InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("X86InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
X86InstructionSelector::CustomRendererFn
X86InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool X86InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool X86InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("X86InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *X86InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(349), /*)*//*default:*//*Label 81*/ GIMT_Encode4(238952),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1194),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(7427),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(10963), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(14746),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(25338),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(33742), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    114 */ /*TargetOpcode::G_CONCAT_VECTORS*//*Label 6*/ GIMT_Encode4(46443), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 7*/ GIMT_Encode4(46610), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    150 */ /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 8*/ GIMT_Encode4(48900),
     /*    154 */ /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 9*/ GIMT_Encode4(52078), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 10*/ GIMT_Encode4(53298),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 11*/ GIMT_Encode4(59523),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 12*/ GIMT_Encode4(59856), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 13*/ GIMT_Encode4(60511), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 14*/ GIMT_Encode4(85974),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 15*/ GIMT_Encode4(86210), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 16*/ GIMT_Encode4(86458), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 17*/ GIMT_Encode4(86777),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 18*/ GIMT_Encode4(100603), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 19*/ GIMT_Encode4(109678),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 20*/ GIMT_Encode4(110113), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 21*/ GIMT_Encode4(111202),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 22*/ GIMT_Encode4(111808), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 23*/ GIMT_Encode4(112261),
     /*    370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 24*/ GIMT_Encode4(113933),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 25*/ GIMT_Encode4(114175),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 26*/ GIMT_Encode4(116159),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 27*/ GIMT_Encode4(118443),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 28*/ GIMT_Encode4(120487),
     /*    390 */ /*TargetOpcode::G_FSHL*//*Label 29*/ GIMT_Encode4(122531),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 30*/ GIMT_Encode4(124258),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 31*/ GIMT_Encode4(125999),
     /*    402 */ /*TargetOpcode::G_ROTL*//*Label 32*/ GIMT_Encode4(129497),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 33*/ GIMT_Encode4(133217), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 34*/ GIMT_Encode4(134874), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 35*/ GIMT_Encode4(142540),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 36*/ GIMT_Encode4(143405),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 37*/ GIMT_Encode4(144270),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 38*/ GIMT_Encode4(145956),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 39*/ GIMT_Encode4(147642),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 40*/ GIMT_Encode4(148708), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 41*/ GIMT_Encode4(149774),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 42*/ GIMT_Encode4(155688),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 43*/ GIMT_Encode4(159870),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 44*/ GIMT_Encode4(165784), GIMT_Encode4(0),
     /*    550 */ /*TargetOpcode::G_FDIV*//*Label 45*/ GIMT_Encode4(171772), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    602 */ /*TargetOpcode::G_FNEG*//*Label 46*/ GIMT_Encode4(175954),
     /*    606 */ /*TargetOpcode::G_FPEXT*//*Label 47*/ GIMT_Encode4(176077),
     /*    610 */ /*TargetOpcode::G_FPTRUNC*//*Label 48*/ GIMT_Encode4(177009),
     /*    614 */ /*TargetOpcode::G_FPTOSI*//*Label 49*/ GIMT_Encode4(177395),
     /*    618 */ /*TargetOpcode::G_FPTOUI*//*Label 50*/ GIMT_Encode4(178776),
     /*    622 */ /*TargetOpcode::G_SITOFP*//*Label 51*/ GIMT_Encode4(179332),
     /*    626 */ /*TargetOpcode::G_UITOFP*//*Label 52*/ GIMT_Encode4(182708), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    638 */ /*TargetOpcode::G_FABS*//*Label 53*/ GIMT_Encode4(184955), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    726 */ /*TargetOpcode::G_SMIN*//*Label 54*/ GIMT_Encode4(185078),
     /*    730 */ /*TargetOpcode::G_SMAX*//*Label 55*/ GIMT_Encode4(188399),
     /*    734 */ /*TargetOpcode::G_UMIN*//*Label 56*/ GIMT_Encode4(191720),
     /*    738 */ /*TargetOpcode::G_UMAX*//*Label 57*/ GIMT_Encode4(195041),
     /*    742 */ /*TargetOpcode::G_ABS*//*Label 58*/ GIMT_Encode4(198362), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    754 */ /*TargetOpcode::G_BR*//*Label 59*/ GIMT_Encode4(200243), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    770 */ /*TargetOpcode::G_EXTRACT_SUBVECTOR*//*Label 60*/ GIMT_Encode4(200259), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    794 */ /*TargetOpcode::G_VECTOR_COMPRESS*//*Label 61*/ GIMT_Encode4(203188),
     /*    798 */ /*TargetOpcode::G_CTTZ*//*Label 62*/ GIMT_Encode4(205170),
     /*    802 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 63*/ GIMT_Encode4(205476),
     /*    806 */ /*TargetOpcode::G_CTLZ*//*Label 64*/ GIMT_Encode4(205863), GIMT_Encode4(0),
     /*    814 */ /*TargetOpcode::G_CTPOP*//*Label 65*/ GIMT_Encode4(207167),
     /*    818 */ /*TargetOpcode::G_BSWAP*//*Label 66*/ GIMT_Encode4(209429), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    874 */ /*TargetOpcode::G_FSQRT*//*Label 67*/ GIMT_Encode4(209929), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    914 */ /*TargetOpcode::G_STRICT_FADD*//*Label 68*/ GIMT_Encode4(212098),
     /*    918 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 69*/ GIMT_Encode4(217028),
     /*    922 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 70*/ GIMT_Encode4(220718),
     /*    926 */ /*TargetOpcode::G_STRICT_FDIV*//*Label 71*/ GIMT_Encode4(225648), GIMT_Encode4(0),
     /*    934 */ /*TargetOpcode::G_STRICT_FMA*//*Label 72*/ GIMT_Encode4(229338),
     /*    938 */ /*TargetOpcode::G_STRICT_FSQRT*//*Label 73*/ GIMT_Encode4(235326), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    974 */ /*TargetOpcode::G_TRAP*//*Label 74*/ GIMT_Encode4(237495),
     /*    978 */ /*TargetOpcode::G_DEBUGTRAP*//*Label 75*/ GIMT_Encode4(237508),
     /*    982 */ /*TargetOpcode::G_UBSANTRAP*//*Label 76*/ GIMT_Encode4(237544), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1178 */ /*X86::G_FILD*//*Label 77*/ GIMT_Encode4(237560),
     /*   1182 */ /*X86::G_FIST*//*Label 78*/ GIMT_Encode4(238019),
     /*   1186 */ /*X86::G_FLDCW16*//*Label 79*/ GIMT_Encode4(238883),
     /*   1190 */ /*X86::G_FNSTCW16*//*Label 80*/ GIMT_Encode4(238919),
     /*   1194 */ // Label 0: @1194
     /*   1194 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 98*/ GIMT_Encode4(7426),
     /*   1205 */ /*GILLT_s8*//*Label 82*/ GIMT_Encode4(1301),
     /*   1209 */ /*GILLT_s16*//*Label 83*/ GIMT_Encode4(1806),
     /*   1213 */ /*GILLT_s32*//*Label 84*/ GIMT_Encode4(2456),
     /*   1217 */ /*GILLT_s64*//*Label 85*/ GIMT_Encode4(3106), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   1233 */ /*GILLT_v2s64*//*Label 86*/ GIMT_Encode4(3930), GIMT_Encode4(0),
     /*   1241 */ /*GILLT_v4s32*//*Label 87*/ GIMT_Encode4(4272),
     /*   1245 */ /*GILLT_v4s64*//*Label 88*/ GIMT_Encode4(4736), GIMT_Encode4(0),
     /*   1253 */ /*GILLT_v8s16*//*Label 89*/ GIMT_Encode4(5051),
     /*   1257 */ /*GILLT_v8s32*//*Label 90*/ GIMT_Encode4(5515),
     /*   1261 */ /*GILLT_v8s64*//*Label 91*/ GIMT_Encode4(5830), GIMT_Encode4(0),
     /*   1269 */ /*GILLT_v16s8*//*Label 92*/ GIMT_Encode4(5986),
     /*   1273 */ /*GILLT_v16s16*//*Label 93*/ GIMT_Encode4(6328),
     /*   1277 */ /*GILLT_v16s32*//*Label 94*/ GIMT_Encode4(6643), GIMT_Encode4(0),
     /*   1285 */ /*GILLT_v32s8*//*Label 95*/ GIMT_Encode4(6799),
     /*   1289 */ /*GILLT_v32s16*//*Label 96*/ GIMT_Encode4(7114), GIMT_Encode4(0),
     /*   1297 */ /*GILLT_v64s8*//*Label 97*/ GIMT_Encode4(7270),
     /*   1301 */ // Label 82: @1301
     /*   1301 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1805),
     /*   1306 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*   1309 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*   1312 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1316 */   GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1377), // Rule ID 26060 //
     /*   1321 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1324 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1328 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1332 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1335 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1339 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1343 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1347 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1349 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1356 */     // (add:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (ADD8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1356 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm),
     /*   1359 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1361 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1363 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1367 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1370 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1375 */     GIR_RootConstrainSelectedInstOperands,
     /*   1376 */     // GIR_Coverage, 26060,
     /*   1376 */     GIR_EraseRootFromParent_Done,
     /*   1377 */   // Label 100: @1377
     /*   1377 */   GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1438), // Rule ID 26079 //
     /*   1382 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1385 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1389 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1393 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1396 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1400 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1404 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1408 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1410 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1417 */     // (add:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (ADD8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1417 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm_ND),
     /*   1420 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1422 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1424 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1428 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1431 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1436 */     GIR_RootConstrainSelectedInstOperands,
     /*   1437 */     // GIR_Coverage, 26079,
     /*   1437 */     GIR_EraseRootFromParent_Done,
     /*   1438 */   // Label 101: @1438
     /*   1438 */   GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1499), // Rule ID 22802 //
     /*   1443 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1446 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1450 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1454 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1458 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1461 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1465 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1469 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1471 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1478 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (ADD8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1478 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm),
     /*   1481 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1483 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1485 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1489 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1492 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1497 */     GIR_RootConstrainSelectedInstOperands,
     /*   1498 */     // GIR_Coverage, 22802,
     /*   1498 */     GIR_EraseRootFromParent_Done,
     /*   1499 */   // Label 102: @1499
     /*   1499 */   GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1560), // Rule ID 22892 //
     /*   1504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1507 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1511 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1515 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1519 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1522 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1526 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   1530 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1532 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1539 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (ADD8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1539 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8rm_ND),
     /*   1542 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1544 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1546 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1550 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1553 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1558 */     GIR_RootConstrainSelectedInstOperands,
     /*   1559 */     // GIR_Coverage, 22892,
     /*   1559 */     GIR_EraseRootFromParent_Done,
     /*   1560 */   // Label 103: @1560
     /*   1560 */   GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1588), // Rule ID 22868 //
     /*   1565 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   1568 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1572 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   1576 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1576 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r),
     /*   1579 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1581 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1583 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1586 */     GIR_RootConstrainSelectedInstOperands,
     /*   1587 */     // GIR_Coverage, 22868,
     /*   1587 */     GIR_EraseRootFromParent_Done,
     /*   1588 */   // Label 104: @1588
     /*   1588 */   GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1616), // Rule ID 22872 //
     /*   1593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   1596 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1600 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   1604 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1604 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r),
     /*   1607 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1609 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1611 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1614 */     GIR_RootConstrainSelectedInstOperands,
     /*   1615 */     // GIR_Coverage, 22872,
     /*   1615 */     GIR_EraseRootFromParent_Done,
     /*   1616 */   // Label 105: @1616
     /*   1616 */   GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1644), // Rule ID 22958 //
     /*   1621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   1624 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1628 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   1632 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r_ND),
     /*   1635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1637 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1639 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1642 */     GIR_RootConstrainSelectedInstOperands,
     /*   1643 */     // GIR_Coverage, 22958,
     /*   1643 */     GIR_EraseRootFromParent_Done,
     /*   1644 */   // Label 106: @1644
     /*   1644 */   GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1672), // Rule ID 22962 //
     /*   1649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   1652 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1656 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   1660 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
     /*   1660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r_ND),
     /*   1663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1665 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   1667 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1670 */     GIR_RootConstrainSelectedInstOperands,
     /*   1671 */     // GIR_Coverage, 22962,
     /*   1671 */     GIR_EraseRootFromParent_Done,
     /*   1672 */   // Label 107: @1672
     /*   1672 */   GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1709), // Rule ID 22806 //
     /*   1677 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1680 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1684 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1688 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1692 */     // MIs[1] Operand 1
     /*   1692 */     // No operand predicates
     /*   1692 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1694 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   1694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
     /*   1697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1699 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1701 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   1704 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1707 */     GIR_RootConstrainSelectedInstOperands,
     /*   1708 */     // GIR_Coverage, 22806,
     /*   1708 */     GIR_EraseRootFromParent_Done,
     /*   1709 */   // Label 108: @1709
     /*   1709 */   GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1746), // Rule ID 22896 //
     /*   1714 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1717 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1721 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1725 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1729 */     // MIs[1] Operand 1
     /*   1729 */     // No operand predicates
     /*   1729 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1731 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   1731 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri_ND),
     /*   1734 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1736 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   1738 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   1741 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1744 */     GIR_RootConstrainSelectedInstOperands,
     /*   1745 */     // GIR_Coverage, 22896,
     /*   1745 */     GIR_EraseRootFromParent_Done,
     /*   1746 */   // Label 109: @1746
     /*   1746 */   GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1775), // Rule ID 22798 //
     /*   1751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1754 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1758 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1762 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   1762 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr),
     /*   1767 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   1773 */     GIR_RootConstrainSelectedInstOperands,
     /*   1774 */     // GIR_Coverage, 22798,
     /*   1774 */     GIR_Done,
     /*   1775 */   // Label 110: @1775
     /*   1775 */   GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1804), // Rule ID 22888 //
     /*   1780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1783 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1787 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   1791 */     // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   1791 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr_ND),
     /*   1796 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   1802 */     GIR_RootConstrainSelectedInstOperands,
     /*   1803 */     // GIR_Coverage, 22888,
     /*   1803 */     GIR_Done,
     /*   1804 */   // Label 111: @1804
     /*   1804 */   GIM_Reject,
     /*   1805 */ // Label 99: @1805
     /*   1805 */ GIM_Reject,
     /*   1806 */ // Label 83: @1806
     /*   1806 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(2455),
     /*   1811 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*   1814 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*   1817 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1821 */   GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1890), // Rule ID 22623 //
     /*   1826 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1829 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1833 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1837 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1840 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1844 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1848 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   1859 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1861 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1868 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, 128:{ *:[i16] })  =>  (SUB16mi_ND:{ *:[i16] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i16] })
     /*   1868 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16mi_ND),
     /*   1871 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1873 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   1877 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   1880 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1883 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1888 */     GIR_RootConstrainSelectedInstOperands,
     /*   1889 */     // GIR_Coverage, 22623,
     /*   1889 */     GIR_EraseRootFromParent_Done,
     /*   1890 */   // Label 113: @1890
     /*   1890 */   GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1951), // Rule ID 26061 //
     /*   1895 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   1898 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1902 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1906 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1909 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1913 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1917 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1921 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1923 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1930 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (ADD16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1930 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm),
     /*   1933 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1935 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1937 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   1941 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   1944 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   1949 */     GIR_RootConstrainSelectedInstOperands,
     /*   1950 */     // GIR_Coverage, 26061,
     /*   1950 */     GIR_EraseRootFromParent_Done,
     /*   1951 */   // Label 114: @1951
     /*   1951 */   GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(2012), // Rule ID 26080 //
     /*   1956 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   1959 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1963 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   1967 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   1970 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   1974 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   1978 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   1982 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1984 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   1991 */     // (add:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (ADD16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   1991 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm_ND),
     /*   1994 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   1996 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   1998 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2002 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2005 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2010 */     GIR_RootConstrainSelectedInstOperands,
     /*   2011 */     // GIR_Coverage, 26080,
     /*   2011 */     GIR_EraseRootFromParent_Done,
     /*   2012 */   // Label 115: @2012
     /*   2012 */   GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(2073), // Rule ID 22803 //
     /*   2017 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2020 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2024 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2028 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2032 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2035 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2039 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   2043 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2045 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2052 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (ADD16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2052 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm),
     /*   2055 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2057 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2059 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2063 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2066 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2071 */     GIR_RootConstrainSelectedInstOperands,
     /*   2072 */     // GIR_Coverage, 22803,
     /*   2072 */     GIR_EraseRootFromParent_Done,
     /*   2073 */   // Label 116: @2073
     /*   2073 */   GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(2134), // Rule ID 22893 //
     /*   2078 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2081 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2085 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2089 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2093 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2096 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2100 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   2104 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2106 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2113 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (ADD16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2113 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16rm_ND),
     /*   2116 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2118 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2120 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2124 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2127 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2132 */     GIR_RootConstrainSelectedInstOperands,
     /*   2133 */     // GIR_Coverage, 22893,
     /*   2133 */     GIR_EraseRootFromParent_Done,
     /*   2134 */   // Label 117: @2134
     /*   2134 */   GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(2172), // Rule ID 22608 //
     /*   2139 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2142 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2146 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2157 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
     /*   2157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
     /*   2160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2162 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2164 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   2167 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2170 */     GIR_RootConstrainSelectedInstOperands,
     /*   2171 */     // GIR_Coverage, 22608,
     /*   2171 */     GIR_EraseRootFromParent_Done,
     /*   2172 */   // Label 118: @2172
     /*   2172 */   GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2210), // Rule ID 22614 //
     /*   2177 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2180 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2184 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2195 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
     /*   2195 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
     /*   2198 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2200 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2202 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   2205 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2208 */     GIR_RootConstrainSelectedInstOperands,
     /*   2209 */     // GIR_Coverage, 22614,
     /*   2209 */     GIR_EraseRootFromParent_Done,
     /*   2210 */   // Label 119: @2210
     /*   2210 */   GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(2238), // Rule ID 22869 //
     /*   2215 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2218 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2222 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2226 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2226 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r),
     /*   2229 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2231 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2233 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2236 */     GIR_RootConstrainSelectedInstOperands,
     /*   2237 */     // GIR_Coverage, 22869,
     /*   2237 */     GIR_EraseRootFromParent_Done,
     /*   2238 */   // Label 120: @2238
     /*   2238 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(2266), // Rule ID 22873 //
     /*   2243 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2246 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2250 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   2254 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2254 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r),
     /*   2257 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2259 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2261 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2264 */     GIR_RootConstrainSelectedInstOperands,
     /*   2265 */     // GIR_Coverage, 22873,
     /*   2265 */     GIR_EraseRootFromParent_Done,
     /*   2266 */   // Label 121: @2266
     /*   2266 */   GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2294), // Rule ID 22959 //
     /*   2271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2274 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2278 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2282 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2282 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r_ND),
     /*   2285 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2287 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2289 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2292 */     GIR_RootConstrainSelectedInstOperands,
     /*   2293 */     // GIR_Coverage, 22959,
     /*   2293 */     GIR_EraseRootFromParent_Done,
     /*   2294 */   // Label 122: @2294
     /*   2294 */   GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2322), // Rule ID 22963 //
     /*   2299 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2302 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2306 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   2310 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
     /*   2310 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r_ND),
     /*   2313 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2315 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2317 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2320 */     GIR_RootConstrainSelectedInstOperands,
     /*   2321 */     // GIR_Coverage, 22963,
     /*   2321 */     GIR_EraseRootFromParent_Done,
     /*   2322 */   // Label 123: @2322
     /*   2322 */   GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2359), // Rule ID 22807 //
     /*   2327 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2330 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2334 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2338 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2342 */     // MIs[1] Operand 1
     /*   2342 */     // No operand predicates
     /*   2342 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2344 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   2344 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
     /*   2347 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2349 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2351 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   2354 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2357 */     GIR_RootConstrainSelectedInstOperands,
     /*   2358 */     // GIR_Coverage, 22807,
     /*   2358 */     GIR_EraseRootFromParent_Done,
     /*   2359 */   // Label 124: @2359
     /*   2359 */   GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2396), // Rule ID 22897 //
     /*   2364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2367 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2371 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2375 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2379 */     // MIs[1] Operand 1
     /*   2379 */     // No operand predicates
     /*   2379 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2381 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   2381 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri_ND),
     /*   2384 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2386 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2388 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   2391 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2394 */     GIR_RootConstrainSelectedInstOperands,
     /*   2395 */     // GIR_Coverage, 22897,
     /*   2395 */     GIR_EraseRootFromParent_Done,
     /*   2396 */   // Label 125: @2396
     /*   2396 */   GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2425), // Rule ID 22799 //
     /*   2401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2404 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2408 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2412 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   2412 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr),
     /*   2417 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   2423 */     GIR_RootConstrainSelectedInstOperands,
     /*   2424 */     // GIR_Coverage, 22799,
     /*   2424 */     GIR_Done,
     /*   2425 */   // Label 126: @2425
     /*   2425 */   GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2454), // Rule ID 22889 //
     /*   2430 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2433 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2437 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   2441 */     // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   2441 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr_ND),
     /*   2446 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   2452 */     GIR_RootConstrainSelectedInstOperands,
     /*   2453 */     // GIR_Coverage, 22889,
     /*   2453 */     GIR_Done,
     /*   2454 */   // Label 127: @2454
     /*   2454 */   GIM_Reject,
     /*   2455 */ // Label 112: @2455
     /*   2455 */ GIM_Reject,
     /*   2456 */ // Label 84: @2456
     /*   2456 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(3105),
     /*   2461 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2464 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2467 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2471 */   GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2540), // Rule ID 22624 //
     /*   2476 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2479 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2483 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2487 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2490 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2494 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2498 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2509 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2511 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2518 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, 128:{ *:[i32] })  =>  (SUB32mi_ND:{ *:[i32] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i32] })
     /*   2518 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32mi_ND),
     /*   2521 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2523 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   2527 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   2530 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2533 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2538 */     GIR_RootConstrainSelectedInstOperands,
     /*   2539 */     // GIR_Coverage, 22624,
     /*   2539 */     GIR_EraseRootFromParent_Done,
     /*   2540 */   // Label 129: @2540
     /*   2540 */   GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2601), // Rule ID 26062 //
     /*   2545 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2548 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2552 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2556 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2559 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2563 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2567 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2571 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2573 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2580 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (ADD32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2580 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm),
     /*   2583 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2585 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   2587 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2591 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2594 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2599 */     GIR_RootConstrainSelectedInstOperands,
     /*   2600 */     // GIR_Coverage, 26062,
     /*   2600 */     GIR_EraseRootFromParent_Done,
     /*   2601 */   // Label 130: @2601
     /*   2601 */   GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2662), // Rule ID 26081 //
     /*   2606 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2609 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2613 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2617 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2620 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2624 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2628 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2632 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2634 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2641 */     // (add:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (ADD32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2641 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm_ND),
     /*   2644 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2646 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   2648 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2652 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2655 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2660 */     GIR_RootConstrainSelectedInstOperands,
     /*   2661 */     // GIR_Coverage, 26081,
     /*   2661 */     GIR_EraseRootFromParent_Done,
     /*   2662 */   // Label 131: @2662
     /*   2662 */   GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2723), // Rule ID 22804 //
     /*   2667 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2670 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2682 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2685 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2689 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2695 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2702 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ADD32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2702 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm),
     /*   2705 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2707 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2709 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2713 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2716 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2721 */     GIR_RootConstrainSelectedInstOperands,
     /*   2722 */     // GIR_Coverage, 22804,
     /*   2722 */     GIR_EraseRootFromParent_Done,
     /*   2723 */   // Label 132: @2723
     /*   2723 */   GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2784), // Rule ID 22894 //
     /*   2728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2731 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2735 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2739 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   2743 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   2746 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   2750 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   2754 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2756 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   2763 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ADD32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   2763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32rm_ND),
     /*   2766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2768 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2770 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   2774 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2777 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   2782 */     GIR_RootConstrainSelectedInstOperands,
     /*   2783 */     // GIR_Coverage, 22894,
     /*   2783 */     GIR_EraseRootFromParent_Done,
     /*   2784 */   // Label 133: @2784
     /*   2784 */   GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2822), // Rule ID 22609 //
     /*   2789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2792 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2796 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2807 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
     /*   2807 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
     /*   2810 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2812 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2814 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   2817 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2820 */     GIR_RootConstrainSelectedInstOperands,
     /*   2821 */     // GIR_Coverage, 22609,
     /*   2821 */     GIR_EraseRootFromParent_Done,
     /*   2822 */   // Label 134: @2822
     /*   2822 */   GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2860), // Rule ID 22615 //
     /*   2827 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   2830 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2834 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   2845 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
     /*   2845 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
     /*   2848 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2850 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   2852 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   2855 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2858 */     GIR_RootConstrainSelectedInstOperands,
     /*   2859 */     // GIR_Coverage, 22615,
     /*   2859 */     GIR_EraseRootFromParent_Done,
     /*   2860 */   // Label 135: @2860
     /*   2860 */   GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2888), // Rule ID 22870 //
     /*   2865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2868 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2872 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2876 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2876 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r),
     /*   2879 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2881 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2883 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2886 */     GIR_RootConstrainSelectedInstOperands,
     /*   2887 */     // GIR_Coverage, 22870,
     /*   2887 */     GIR_EraseRootFromParent_Done,
     /*   2888 */   // Label 136: @2888
     /*   2888 */   GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2916), // Rule ID 22874 //
     /*   2893 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   2896 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2900 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   2904 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2904 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r),
     /*   2907 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2909 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2911 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2914 */     GIR_RootConstrainSelectedInstOperands,
     /*   2915 */     // GIR_Coverage, 22874,
     /*   2915 */     GIR_EraseRootFromParent_Done,
     /*   2916 */   // Label 137: @2916
     /*   2916 */   GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2944), // Rule ID 22960 //
     /*   2921 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2924 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2928 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   2932 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2932 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r_ND),
     /*   2935 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2937 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2939 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2942 */     GIR_RootConstrainSelectedInstOperands,
     /*   2943 */     // GIR_Coverage, 22960,
     /*   2943 */     GIR_EraseRootFromParent_Done,
     /*   2944 */   // Label 138: @2944
     /*   2944 */   GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2972), // Rule ID 22964 //
     /*   2949 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   2952 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2956 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   2960 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*   2960 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r_ND),
     /*   2963 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2965 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   2967 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   2970 */     GIR_RootConstrainSelectedInstOperands,
     /*   2971 */     // GIR_Coverage, 22964,
     /*   2971 */     GIR_EraseRootFromParent_Done,
     /*   2972 */   // Label 139: @2972
     /*   2972 */   GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(3009), // Rule ID 22808 //
     /*   2977 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   2980 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   2984 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2988 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   2992 */     // MIs[1] Operand 1
     /*   2992 */     // No operand predicates
     /*   2992 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2994 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   2994 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
     /*   2997 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   2999 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3001 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3004 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3007 */     GIR_RootConstrainSelectedInstOperands,
     /*   3008 */     // GIR_Coverage, 22808,
     /*   3008 */     GIR_EraseRootFromParent_Done,
     /*   3009 */   // Label 140: @3009
     /*   3009 */   GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(3046), // Rule ID 22898 //
     /*   3014 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3017 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3021 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3025 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3029 */     // MIs[1] Operand 1
     /*   3029 */     // No operand predicates
     /*   3029 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3031 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   3031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri_ND),
     /*   3034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3036 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3038 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3041 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3044 */     GIR_RootConstrainSelectedInstOperands,
     /*   3045 */     // GIR_Coverage, 22898,
     /*   3045 */     GIR_EraseRootFromParent_Done,
     /*   3046 */   // Label 141: @3046
     /*   3046 */   GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(3075), // Rule ID 22800 //
     /*   3051 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3054 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3058 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3062 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   3062 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr),
     /*   3067 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3073 */     GIR_RootConstrainSelectedInstOperands,
     /*   3074 */     // GIR_Coverage, 22800,
     /*   3074 */     GIR_Done,
     /*   3075 */   // Label 142: @3075
     /*   3075 */   GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(3104), // Rule ID 22890 //
     /*   3080 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3083 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3087 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   3091 */     // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   3091 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr_ND),
     /*   3096 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3102 */     GIR_RootConstrainSelectedInstOperands,
     /*   3103 */     // GIR_Coverage, 22890,
     /*   3103 */     GIR_Done,
     /*   3104 */   // Label 143: @3104
     /*   3104 */   GIM_Reject,
     /*   3105 */ // Label 128: @3105
     /*   3105 */ GIM_Reject,
     /*   3106 */ // Label 85: @3106
     /*   3106 */ GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(3929),
     /*   3111 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   3114 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   3117 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3121 */   GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(3190), // Rule ID 22625 //
     /*   3126 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3129 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3133 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3137 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3140 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3144 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3148 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3159 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3161 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3168 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_load>>, 128:{ *:[i64] })  =>  (SUB64mi32_ND:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -128:{ *:[i64] })
     /*   3168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64mi32_ND),
     /*   3171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3173 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   3177 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   3180 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3183 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3188 */     GIR_RootConstrainSelectedInstOperands,
     /*   3189 */     // GIR_Coverage, 22625,
     /*   3189 */     GIR_EraseRootFromParent_Done,
     /*   3190 */   // Label 145: @3190
     /*   3190 */   GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(3266), // Rule ID 22631 //
     /*   3195 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3198 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3206 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3209 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3213 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3217 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3228 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3230 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3237 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src)<<P:Predicate_unindexedload>><<P:Predicate_load>>, 2147483648:{ *:[i64] })  =>  (SUB64mi32_ND:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src, -2147483648:{ *:[i64] })
     /*   3237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64mi32_ND),
     /*   3240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3242 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src
     /*   3246 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(18446744071562067968u),
     /*   3256 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3259 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3264 */     GIR_RootConstrainSelectedInstOperands,
     /*   3265 */     // GIR_Coverage, 22631,
     /*   3265 */     GIR_EraseRootFromParent_Done,
     /*   3266 */   // Label 146: @3266
     /*   3266 */   GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(3327), // Rule ID 26063 //
     /*   3271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3274 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3278 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3282 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3285 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3289 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3293 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3297 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3299 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3306 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (ADD64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3306 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm),
     /*   3309 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3311 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3313 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3317 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3320 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3325 */     GIR_RootConstrainSelectedInstOperands,
     /*   3326 */     // GIR_Coverage, 26063,
     /*   3326 */     GIR_EraseRootFromParent_Done,
     /*   3327 */   // Label 147: @3327
     /*   3327 */   GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(3388), // Rule ID 26082 //
     /*   3332 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3335 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3339 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3343 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3346 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3350 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3354 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3358 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3360 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3367 */     // (add:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (ADD64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3367 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm_ND),
     /*   3370 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3372 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3374 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3378 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3381 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3386 */     GIR_RootConstrainSelectedInstOperands,
     /*   3387 */     // GIR_Coverage, 26082,
     /*   3387 */     GIR_EraseRootFromParent_Done,
     /*   3388 */   // Label 148: @3388
     /*   3388 */   GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(3449), // Rule ID 22805 //
     /*   3393 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3396 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3408 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3411 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3415 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3419 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3421 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3428 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ADD64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3428 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm),
     /*   3431 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3433 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3435 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3439 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3442 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3447 */     GIR_RootConstrainSelectedInstOperands,
     /*   3448 */     // GIR_Coverage, 22805,
     /*   3448 */     GIR_EraseRootFromParent_Done,
     /*   3449 */   // Label 149: @3449
     /*   3449 */   GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(3510), // Rule ID 22895 //
     /*   3454 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3457 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3461 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3465 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3469 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3472 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3476 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3480 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3482 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3489 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ADD64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3489 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64rm_ND),
     /*   3492 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3494 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3496 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3500 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3503 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   3508 */     GIR_RootConstrainSelectedInstOperands,
     /*   3509 */     // GIR_Coverage, 22895,
     /*   3509 */     GIR_EraseRootFromParent_Done,
     /*   3510 */   // Label 150: @3510
     /*   3510 */   GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3548), // Rule ID 22610 //
     /*   3515 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3518 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3522 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3533 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
     /*   3533 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   3536 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3538 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3540 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   3543 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3546 */     GIR_RootConstrainSelectedInstOperands,
     /*   3547 */     // GIR_Coverage, 22610,
     /*   3547 */     GIR_EraseRootFromParent_Done,
     /*   3548 */   // Label 151: @3548
     /*   3548 */   GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(3586), // Rule ID 22616 //
     /*   3553 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3556 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3560 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
     /*   3571 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
     /*   3571 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   3574 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3576 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3578 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/128,
     /*   3581 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3584 */     GIR_RootConstrainSelectedInstOperands,
     /*   3585 */     // GIR_Coverage, 22616,
     /*   3585 */     GIR_EraseRootFromParent_Done,
     /*   3586 */   // Label 152: @3586
     /*   3586 */   GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(3631), // Rule ID 22626 //
     /*   3591 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3594 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3598 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3609 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
     /*   3609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   3612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3614 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3616 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(18446744071562067968u),
     /*   3626 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3629 */     GIR_RootConstrainSelectedInstOperands,
     /*   3630 */     // GIR_Coverage, 22626,
     /*   3630 */     GIR_EraseRootFromParent_Done,
     /*   3631 */   // Label 153: @3631
     /*   3631 */   GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(3676), // Rule ID 22628 //
     /*   3636 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3639 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3643 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
     /*   3654 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
     /*   3654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   3657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3659 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3661 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(18446744071562067968u),
     /*   3671 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3674 */     GIR_RootConstrainSelectedInstOperands,
     /*   3675 */     // GIR_Coverage, 22628,
     /*   3675 */     GIR_EraseRootFromParent_Done,
     /*   3676 */   // Label 154: @3676
     /*   3676 */   GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3704), // Rule ID 22871 //
     /*   3681 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   3684 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3688 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   3692 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3692 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r),
     /*   3695 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3697 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3699 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3702 */     GIR_RootConstrainSelectedInstOperands,
     /*   3703 */     // GIR_Coverage, 22871,
     /*   3703 */     GIR_EraseRootFromParent_Done,
     /*   3704 */   // Label 155: @3704
     /*   3704 */   GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3732), // Rule ID 22875 //
     /*   3709 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
     /*   3712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3716 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   3720 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3720 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r),
     /*   3723 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3725 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3727 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3730 */     GIR_RootConstrainSelectedInstOperands,
     /*   3731 */     // GIR_Coverage, 22875,
     /*   3731 */     GIR_EraseRootFromParent_Done,
     /*   3732 */   // Label 156: @3732
     /*   3732 */   GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3760), // Rule ID 22961 //
     /*   3737 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   3740 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3744 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*   3748 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3748 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r_ND),
     /*   3751 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3753 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3755 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3758 */     GIR_RootConstrainSelectedInstOperands,
     /*   3759 */     // GIR_Coverage, 22961,
     /*   3759 */     GIR_EraseRootFromParent_Done,
     /*   3760 */   // Label 157: @3760
     /*   3760 */   GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3788), // Rule ID 22965 //
     /*   3765 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
     /*   3768 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3772 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*   3776 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*   3776 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r_ND),
     /*   3779 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3781 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*   3783 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3786 */     GIR_RootConstrainSelectedInstOperands,
     /*   3787 */     // GIR_Coverage, 22965,
     /*   3787 */     GIR_EraseRootFromParent_Done,
     /*   3788 */   // Label 158: @3788
     /*   3788 */   GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3829), // Rule ID 22809 //
     /*   3793 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3796 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3808 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   3812 */     // MIs[1] Operand 1
     /*   3812 */     // No operand predicates
     /*   3812 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3814 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   3814 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32),
     /*   3817 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3819 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3821 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3824 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3827 */     GIR_RootConstrainSelectedInstOperands,
     /*   3828 */     // GIR_Coverage, 22809,
     /*   3828 */     GIR_EraseRootFromParent_Done,
     /*   3829 */   // Label 159: @3829
     /*   3829 */   GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3870), // Rule ID 22899 //
     /*   3834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3837 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3841 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3845 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   3849 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   3853 */     // MIs[1] Operand 1
     /*   3853 */     // No operand predicates
     /*   3853 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3855 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   3855 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32_ND),
     /*   3858 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3860 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   3862 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   3865 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   3868 */     GIR_RootConstrainSelectedInstOperands,
     /*   3869 */     // GIR_Coverage, 22899,
     /*   3869 */     GIR_EraseRootFromParent_Done,
     /*   3870 */   // Label 160: @3870
     /*   3870 */   GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3899), // Rule ID 22801 //
     /*   3875 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   3878 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3882 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3886 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   3886 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr),
     /*   3891 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3897 */     GIR_RootConstrainSelectedInstOperands,
     /*   3898 */     // GIR_Coverage, 22801,
     /*   3898 */     GIR_Done,
     /*   3899 */   // Label 161: @3899
     /*   3899 */   GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3928), // Rule ID 22891 //
     /*   3904 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   3907 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3911 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   3915 */     // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   3915 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr_ND),
     /*   3920 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   3926 */     GIR_RootConstrainSelectedInstOperands,
     /*   3927 */     // GIR_Coverage, 22891,
     /*   3927 */     GIR_Done,
     /*   3928 */   // Label 162: @3928
     /*   3928 */   GIM_Reject,
     /*   3929 */ // Label 144: @3929
     /*   3929 */ GIM_Reject,
     /*   3930 */ // Label 86: @3930
     /*   3930 */ GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(4271),
     /*   3935 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   3938 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   3941 */   GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(4003), // Rule ID 23444 //
     /*   3946 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   3949 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   3953 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3957 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   3961 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   3964 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   3968 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   3972 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   3976 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3978 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   3985 */     // (add:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPADDQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   3985 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQrm),
     /*   3988 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   3990 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   3992 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   3996 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4001 */     GIR_RootConstrainSelectedInstOperands,
     /*   4002 */     // GIR_Coverage, 23444,
     /*   4002 */     GIR_EraseRootFromParent_Done,
     /*   4003 */   // Label 164: @4003
     /*   4003 */   GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(4065), // Rule ID 23714 //
     /*   4008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4015 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4019 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4023 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4026 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4030 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4034 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4038 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4040 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4047 */     // (add:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPADDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4047 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rm),
     /*   4050 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4052 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4054 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4058 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4063 */     GIR_RootConstrainSelectedInstOperands,
     /*   4064 */     // GIR_Coverage, 23714,
     /*   4064 */     GIR_EraseRootFromParent_Done,
     /*   4065 */   // Label 165: @4065
     /*   4065 */   GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(4127), // Rule ID 2539 //
     /*   4070 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4073 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4077 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4081 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4085 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4089 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4092 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4096 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4100 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4102 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4109 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4109 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQrm),
     /*   4112 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4114 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4116 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4120 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4125 */     GIR_RootConstrainSelectedInstOperands,
     /*   4126 */     // GIR_Coverage, 2539,
     /*   4126 */     GIR_EraseRootFromParent_Done,
     /*   4127 */   // Label 166: @4127
     /*   4127 */   GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(4189), // Rule ID 4652 //
     /*   4132 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4135 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4139 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4143 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4147 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4151 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4154 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4158 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4162 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4164 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4171 */     // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4171 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rm),
     /*   4174 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4176 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4178 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4182 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4187 */     GIR_RootConstrainSelectedInstOperands,
     /*   4188 */     // GIR_Coverage, 4652,
     /*   4188 */     GIR_EraseRootFromParent_Done,
     /*   4189 */   // Label 167: @4189
     /*   4189 */   GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(4216), // Rule ID 2538 //
     /*   4194 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4197 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4201 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4205 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4209 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   4209 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQrr),
     /*   4214 */     GIR_RootConstrainSelectedInstOperands,
     /*   4215 */     // GIR_Coverage, 2538,
     /*   4215 */     GIR_Done,
     /*   4216 */   // Label 168: @4216
     /*   4216 */   GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(4243), // Rule ID 2540 //
     /*   4221 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   4224 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4228 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4232 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4236 */     // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   4236 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDQrr),
     /*   4241 */     GIR_RootConstrainSelectedInstOperands,
     /*   4242 */     // GIR_Coverage, 2540,
     /*   4242 */     GIR_Done,
     /*   4243 */   // Label 169: @4243
     /*   4243 */   GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(4270), // Rule ID 4649 //
     /*   4248 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4251 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4255 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4259 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4263 */     // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPADDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*   4263 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rr),
     /*   4268 */     GIR_RootConstrainSelectedInstOperands,
     /*   4269 */     // GIR_Coverage, 4649,
     /*   4269 */     GIR_Done,
     /*   4270 */   // Label 170: @4270
     /*   4270 */   GIM_Reject,
     /*   4271 */ // Label 163: @4271
     /*   4271 */ GIM_Reject,
     /*   4272 */ // Label 87: @4272
     /*   4272 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(4735),
     /*   4277 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4280 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4283 */   GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(4345), // Rule ID 23441 //
     /*   4288 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4291 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4303 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4306 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4310 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4314 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4318 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4320 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4327 */     // (add:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPADDDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4327 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDrm),
     /*   4330 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4332 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4334 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4338 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4343 */     GIR_RootConstrainSelectedInstOperands,
     /*   4344 */     // GIR_Coverage, 23441,
     /*   4344 */     GIR_EraseRootFromParent_Done,
     /*   4345 */   // Label 172: @4345
     /*   4345 */   GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(4407), // Rule ID 23732 //
     /*   4350 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4353 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4357 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4361 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4365 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4368 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4372 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4376 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4380 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4382 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4389 */     // (add:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPADDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4389 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rm),
     /*   4392 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4394 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4396 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4400 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4405 */     GIR_RootConstrainSelectedInstOperands,
     /*   4406 */     // GIR_Coverage, 23732,
     /*   4406 */     GIR_EraseRootFromParent_Done,
     /*   4407 */   // Label 173: @4407
     /*   4407 */   GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(4469), // Rule ID 2533 //
     /*   4412 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4415 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4419 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4423 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4427 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4431 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4434 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4438 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4442 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4444 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4451 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4451 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDrm),
     /*   4454 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4456 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4458 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4462 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4467 */     GIR_RootConstrainSelectedInstOperands,
     /*   4468 */     // GIR_Coverage, 2533,
     /*   4468 */     GIR_EraseRootFromParent_Done,
     /*   4469 */   // Label 174: @4469
     /*   4469 */   GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(4531), // Rule ID 4679 //
     /*   4474 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4477 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4481 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4485 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4489 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4493 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4496 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4500 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4504 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4506 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4513 */     // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4513 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rm),
     /*   4516 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4518 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4520 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4524 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4529 */     GIR_RootConstrainSelectedInstOperands,
     /*   4530 */     // GIR_Coverage, 4679,
     /*   4530 */     GIR_EraseRootFromParent_Done,
     /*   4531 */   // Label 175: @4531
     /*   4531 */   GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(4592), // Rule ID 17867 //
     /*   4536 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   4539 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4543 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4547 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4551 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4555 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4559 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4564 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4569 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4573 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4575 */     // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2), VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
     /*   4575 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
     /*   4578 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4580 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   4584 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   4588 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   4590 */     GIR_RootConstrainSelectedInstOperands,
     /*   4591 */     // GIR_Coverage, 17867,
     /*   4591 */     GIR_EraseRootFromParent_Done,
     /*   4592 */   // Label 176: @4592
     /*   4592 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(4653), // Rule ID 25196 //
     /*   4597 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   4600 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4604 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4608 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4612 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   4616 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4620 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4624 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4629 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4634 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4636 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src3, (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2))  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
     /*   4636 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
     /*   4639 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4641 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   4645 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   4649 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   4651 */     GIR_RootConstrainSelectedInstOperands,
     /*   4652 */     // GIR_Coverage, 25196,
     /*   4652 */     GIR_EraseRootFromParent_Done,
     /*   4653 */   // Label 177: @4653
     /*   4653 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(4680), // Rule ID 2532 //
     /*   4658 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   4661 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4665 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4669 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4673 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   4673 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDrr),
     /*   4678 */     GIR_RootConstrainSelectedInstOperands,
     /*   4679 */     // GIR_Coverage, 2532,
     /*   4679 */     GIR_Done,
     /*   4680 */   // Label 178: @4680
     /*   4680 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(4707), // Rule ID 2534 //
     /*   4685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   4688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4692 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4696 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   4700 */     // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   4700 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDDrr),
     /*   4705 */     GIR_RootConstrainSelectedInstOperands,
     /*   4706 */     // GIR_Coverage, 2534,
     /*   4706 */     GIR_Done,
     /*   4707 */   // Label 179: @4707
     /*   4707 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(4734), // Rule ID 4676 //
     /*   4712 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4715 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4719 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4723 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   4727 */     // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPADDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*   4727 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rr),
     /*   4732 */     GIR_RootConstrainSelectedInstOperands,
     /*   4733 */     // GIR_Coverage, 4676,
     /*   4733 */     GIR_Done,
     /*   4734 */   // Label 180: @4734
     /*   4734 */   GIM_Reject,
     /*   4735 */ // Label 171: @4735
     /*   4735 */ GIM_Reject,
     /*   4736 */ // Label 88: @4736
     /*   4736 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(5050),
     /*   4741 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*   4744 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*   4747 */   GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(4809), // Rule ID 23446 //
     /*   4752 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   4755 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4759 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4763 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4767 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4770 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4774 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4778 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4782 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4784 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4791 */     // (add:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPADDQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQYrm),
     /*   4794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4796 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4798 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4802 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4807 */     GIR_RootConstrainSelectedInstOperands,
     /*   4808 */     // GIR_Coverage, 23446,
     /*   4808 */     GIR_EraseRootFromParent_Done,
     /*   4809 */   // Label 182: @4809
     /*   4809 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(4871), // Rule ID 23708 //
     /*   4814 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4817 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4821 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4825 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4829 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4832 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4836 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4840 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4844 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4846 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4853 */     // (add:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPADDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4853 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rm),
     /*   4856 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4858 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   4860 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4864 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4869 */     GIR_RootConstrainSelectedInstOperands,
     /*   4870 */     // GIR_Coverage, 23708,
     /*   4870 */     GIR_EraseRootFromParent_Done,
     /*   4871 */   // Label 183: @4871
     /*   4871 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(4933), // Rule ID 2543 //
     /*   4876 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   4879 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4883 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   4887 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4891 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4895 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4898 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4902 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4906 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4908 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4915 */     // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4915 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQYrm),
     /*   4918 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4920 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4922 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4926 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4931 */     GIR_RootConstrainSelectedInstOperands,
     /*   4932 */     // GIR_Coverage, 2543,
     /*   4932 */     GIR_EraseRootFromParent_Done,
     /*   4933 */   // Label 184: @4933
     /*   4933 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(4995), // Rule ID 4643 //
     /*   4938 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   4941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4945 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   4949 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4953 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   4957 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   4960 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   4964 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   4968 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4970 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   4977 */     // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   4977 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rm),
     /*   4980 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   4982 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   4984 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   4988 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   4993 */     GIR_RootConstrainSelectedInstOperands,
     /*   4994 */     // GIR_Coverage, 4643,
     /*   4994 */     GIR_EraseRootFromParent_Done,
     /*   4995 */   // Label 185: @4995
     /*   4995 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(5022), // Rule ID 2542 //
     /*   5000 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5003 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5007 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5011 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5015 */     // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPADDQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*   5015 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQYrr),
     /*   5020 */     GIR_RootConstrainSelectedInstOperands,
     /*   5021 */     // GIR_Coverage, 2542,
     /*   5021 */     GIR_Done,
     /*   5022 */   // Label 186: @5022
     /*   5022 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(5049), // Rule ID 4640 //
     /*   5027 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5030 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5034 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5038 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5042 */     // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPADDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*   5042 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rr),
     /*   5047 */     GIR_RootConstrainSelectedInstOperands,
     /*   5048 */     // GIR_Coverage, 4640,
     /*   5048 */     GIR_Done,
     /*   5049 */   // Label 187: @5049
     /*   5049 */   GIM_Reject,
     /*   5050 */ // Label 181: @5050
     /*   5050 */ GIM_Reject,
     /*   5051 */ // Label 89: @5051
     /*   5051 */ GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(5514),
     /*   5056 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5059 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5062 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(5124), // Rule ID 23438 //
     /*   5067 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5070 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5074 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5078 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5082 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5085 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5089 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5093 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5097 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5099 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5106 */     // (add:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPADDWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWrm),
     /*   5109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5111 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5113 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5117 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5122 */     GIR_RootConstrainSelectedInstOperands,
     /*   5123 */     // GIR_Coverage, 23438,
     /*   5123 */     GIR_EraseRootFromParent_Done,
     /*   5124 */   // Label 189: @5124
     /*   5124 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(5186), // Rule ID 23744 //
     /*   5129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5132 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5136 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5140 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5144 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5147 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5151 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5155 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5159 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5161 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5168 */     // (add:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPADDWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5168 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rm),
     /*   5171 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5173 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5175 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5179 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5184 */     GIR_RootConstrainSelectedInstOperands,
     /*   5185 */     // GIR_Coverage, 23744,
     /*   5185 */     GIR_EraseRootFromParent_Done,
     /*   5186 */   // Label 190: @5186
     /*   5186 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(5248), // Rule ID 2527 //
     /*   5191 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5198 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5210 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5213 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5217 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5221 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5223 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5230 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWrm),
     /*   5233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5235 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5237 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5241 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5246 */     GIR_RootConstrainSelectedInstOperands,
     /*   5247 */     // GIR_Coverage, 2527,
     /*   5247 */     GIR_EraseRootFromParent_Done,
     /*   5248 */   // Label 191: @5248
     /*   5248 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(5310), // Rule ID 4700 //
     /*   5253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5260 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5264 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5268 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5272 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5275 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5279 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5283 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5285 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5292 */     // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5292 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rm),
     /*   5295 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5297 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5299 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5303 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5308 */     GIR_RootConstrainSelectedInstOperands,
     /*   5309 */     // GIR_Coverage, 4700,
     /*   5309 */     GIR_EraseRootFromParent_Done,
     /*   5310 */   // Label 192: @5310
     /*   5310 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(5371), // Rule ID 17866 //
     /*   5315 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   5318 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5322 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5326 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5330 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5334 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5338 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5343 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5348 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5352 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5354 */     // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2), VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
     /*   5354 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
     /*   5357 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5359 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   5363 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   5367 */     GIR_RootToRootCopy, /*OpIdx*/2, // src3
     /*   5369 */     GIR_RootConstrainSelectedInstOperands,
     /*   5370 */     // GIR_Coverage, 17866,
     /*   5370 */     GIR_EraseRootFromParent_Done,
     /*   5371 */   // Label 193: @5371
     /*   5371 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(5432), // Rule ID 25195 //
     /*   5376 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
     /*   5379 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5383 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5387 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5391 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   5395 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   5399 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   5403 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5408 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5415 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src3, (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2))  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
     /*   5415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
     /*   5418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*   5424 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*   5428 */     GIR_RootToRootCopy, /*OpIdx*/1, // src3
     /*   5430 */     GIR_RootConstrainSelectedInstOperands,
     /*   5431 */     // GIR_Coverage, 25195,
     /*   5431 */     GIR_EraseRootFromParent_Done,
     /*   5432 */   // Label 194: @5432
     /*   5432 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(5459), // Rule ID 2526 //
     /*   5437 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   5440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5444 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5448 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5452 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   5452 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWrr),
     /*   5457 */     GIR_RootConstrainSelectedInstOperands,
     /*   5458 */     // GIR_Coverage, 2526,
     /*   5458 */     GIR_Done,
     /*   5459 */   // Label 195: @5459
     /*   5459 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(5486), // Rule ID 2528 //
     /*   5464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   5467 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5471 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5475 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   5479 */     // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   5479 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDWrr),
     /*   5484 */     GIR_RootConstrainSelectedInstOperands,
     /*   5485 */     // GIR_Coverage, 2528,
     /*   5485 */     GIR_Done,
     /*   5486 */   // Label 196: @5486
     /*   5486 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(5513), // Rule ID 4697 //
     /*   5491 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   5494 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5498 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5502 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   5506 */     // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPADDWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*   5506 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rr),
     /*   5511 */     GIR_RootConstrainSelectedInstOperands,
     /*   5512 */     // GIR_Coverage, 4697,
     /*   5512 */     GIR_Done,
     /*   5513 */   // Label 197: @5513
     /*   5513 */   GIM_Reject,
     /*   5514 */ // Label 188: @5514
     /*   5514 */ GIM_Reject,
     /*   5515 */ // Label 90: @5515
     /*   5515 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(5829),
     /*   5520 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*   5523 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*   5526 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(5588), // Rule ID 23443 //
     /*   5531 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5534 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5538 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5542 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5546 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5549 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5553 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5557 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5561 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5563 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5570 */     // (add:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPADDDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5570 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDYrm),
     /*   5573 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5575 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5577 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5581 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5586 */     GIR_RootConstrainSelectedInstOperands,
     /*   5587 */     // GIR_Coverage, 23443,
     /*   5587 */     GIR_EraseRootFromParent_Done,
     /*   5588 */   // Label 199: @5588
     /*   5588 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(5650), // Rule ID 23726 //
     /*   5593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5600 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5604 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5608 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5611 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5615 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5619 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5623 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5625 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5632 */     // (add:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPADDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rm),
     /*   5635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5637 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5639 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5643 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5648 */     GIR_RootConstrainSelectedInstOperands,
     /*   5649 */     // GIR_Coverage, 23726,
     /*   5649 */     GIR_EraseRootFromParent_Done,
     /*   5650 */   // Label 200: @5650
     /*   5650 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(5712), // Rule ID 2537 //
     /*   5655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5658 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5662 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5666 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5670 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5674 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5677 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5681 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5685 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5687 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5694 */     // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDYrm),
     /*   5697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5699 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5701 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5705 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5710 */     GIR_RootConstrainSelectedInstOperands,
     /*   5711 */     // GIR_Coverage, 2537,
     /*   5711 */     GIR_EraseRootFromParent_Done,
     /*   5712 */   // Label 201: @5712
     /*   5712 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(5774), // Rule ID 4670 //
     /*   5717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5736 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5739 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5743 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5747 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5749 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5756 */     // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5756 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rm),
     /*   5759 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5761 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5763 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5767 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5772 */     GIR_RootConstrainSelectedInstOperands,
     /*   5773 */     // GIR_Coverage, 4670,
     /*   5773 */     GIR_EraseRootFromParent_Done,
     /*   5774 */   // Label 202: @5774
     /*   5774 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(5801), // Rule ID 2536 //
     /*   5779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   5782 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5786 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5790 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   5794 */     // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPADDDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*   5794 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDYrr),
     /*   5799 */     GIR_RootConstrainSelectedInstOperands,
     /*   5800 */     // GIR_Coverage, 2536,
     /*   5800 */     GIR_Done,
     /*   5801 */   // Label 203: @5801
     /*   5801 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(5828), // Rule ID 4667 //
     /*   5806 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   5809 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5813 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5817 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   5821 */     // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPADDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*   5821 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rr),
     /*   5826 */     GIR_RootConstrainSelectedInstOperands,
     /*   5827 */     // GIR_Coverage, 4667,
     /*   5827 */     GIR_Done,
     /*   5828 */   // Label 204: @5828
     /*   5828 */   GIM_Reject,
     /*   5829 */ // Label 198: @5829
     /*   5829 */ GIM_Reject,
     /*   5830 */ // Label 91: @5830
     /*   5830 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(5985),
     /*   5835 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*   5838 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*   5841 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5845 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(5903), // Rule ID 23702 //
     /*   5850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5853 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5857 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5861 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5864 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5868 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5872 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5876 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5878 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5885 */     // (add:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPADDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5885 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZrm),
     /*   5888 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5890 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   5892 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5896 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5901 */     GIR_RootConstrainSelectedInstOperands,
     /*   5902 */     // GIR_Coverage, 23702,
     /*   5902 */     GIR_EraseRootFromParent_Done,
     /*   5903 */   // Label 206: @5903
     /*   5903 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(5961), // Rule ID 4634 //
     /*   5908 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5911 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5915 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5919 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   5923 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   5926 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   5930 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   5934 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5936 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   5943 */     // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   5943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDQZrm),
     /*   5946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   5948 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   5950 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   5954 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   5959 */     GIR_RootConstrainSelectedInstOperands,
     /*   5960 */     // GIR_Coverage, 4634,
     /*   5960 */     GIR_EraseRootFromParent_Done,
     /*   5961 */   // Label 207: @5961
     /*   5961 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(5984), // Rule ID 4631 //
     /*   5966 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   5969 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5973 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   5977 */     // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPADDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*   5977 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZrr),
     /*   5982 */     GIR_RootConstrainSelectedInstOperands,
     /*   5983 */     // GIR_Coverage, 4631,
     /*   5983 */     GIR_Done,
     /*   5984 */   // Label 208: @5984
     /*   5984 */   GIM_Reject,
     /*   5985 */ // Label 205: @5985
     /*   5985 */ GIM_Reject,
     /*   5986 */ // Label 92: @5986
     /*   5986 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(6327),
     /*   5991 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   5994 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   5997 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(6059), // Rule ID 23435 //
     /*   6002 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   6005 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6009 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6013 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6017 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6020 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6024 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6028 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6032 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6034 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6041 */     // (add:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPADDBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6041 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBrm),
     /*   6044 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6046 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6048 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6052 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6057 */     GIR_RootConstrainSelectedInstOperands,
     /*   6058 */     // GIR_Coverage, 23435,
     /*   6058 */     GIR_EraseRootFromParent_Done,
     /*   6059 */   // Label 210: @6059
     /*   6059 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(6121), // Rule ID 23753 //
     /*   6064 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6067 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6071 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6075 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6079 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6082 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6086 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6090 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6094 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6096 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6103 */     // (add:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPADDBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rm),
     /*   6106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6108 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6110 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6114 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6119 */     GIR_RootConstrainSelectedInstOperands,
     /*   6120 */     // GIR_Coverage, 23753,
     /*   6120 */     GIR_EraseRootFromParent_Done,
     /*   6121 */   // Label 211: @6121
     /*   6121 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(6183), // Rule ID 2521 //
     /*   6126 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   6129 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6133 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6145 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6148 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6152 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6156 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6158 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6165 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBrm),
     /*   6168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6170 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6172 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6176 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6181 */     GIR_RootConstrainSelectedInstOperands,
     /*   6182 */     // GIR_Coverage, 2521,
     /*   6182 */     GIR_EraseRootFromParent_Done,
     /*   6183 */   // Label 212: @6183
     /*   6183 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(6245), // Rule ID 4718 //
     /*   6188 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6191 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6195 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6199 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6203 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6207 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6210 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6214 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6218 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6220 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6227 */     // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6227 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rm),
     /*   6230 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6232 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6234 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6238 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6243 */     GIR_RootConstrainSelectedInstOperands,
     /*   6244 */     // GIR_Coverage, 4718,
     /*   6244 */     GIR_EraseRootFromParent_Done,
     /*   6245 */   // Label 213: @6245
     /*   6245 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(6272), // Rule ID 2520 //
     /*   6250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   6253 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6257 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6261 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6265 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*   6265 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBrr),
     /*   6270 */     GIR_RootConstrainSelectedInstOperands,
     /*   6271 */     // GIR_Coverage, 2520,
     /*   6271 */     GIR_Done,
     /*   6272 */   // Label 214: @6272
     /*   6272 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(6299), // Rule ID 2522 //
     /*   6277 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   6280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6284 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6288 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   6292 */     // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*   6292 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDBrr),
     /*   6297 */     GIR_RootConstrainSelectedInstOperands,
     /*   6298 */     // GIR_Coverage, 2522,
     /*   6298 */     GIR_Done,
     /*   6299 */   // Label 215: @6299
     /*   6299 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(6326), // Rule ID 4715 //
     /*   6304 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6307 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6311 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6315 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   6319 */     // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPADDBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*   6319 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rr),
     /*   6324 */     GIR_RootConstrainSelectedInstOperands,
     /*   6325 */     // GIR_Coverage, 4715,
     /*   6325 */     GIR_Done,
     /*   6326 */   // Label 216: @6326
     /*   6326 */   GIM_Reject,
     /*   6327 */ // Label 209: @6327
     /*   6327 */ GIM_Reject,
     /*   6328 */ // Label 93: @6328
     /*   6328 */ GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(6642),
     /*   6333 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*   6336 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*   6339 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(6401), // Rule ID 23440 //
     /*   6344 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6347 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6351 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6355 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6359 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6362 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6366 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6370 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6376 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6383 */     // (add:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPADDWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWYrm),
     /*   6386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6388 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6390 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6394 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6399 */     GIR_RootConstrainSelectedInstOperands,
     /*   6400 */     // GIR_Coverage, 23440,
     /*   6400 */     GIR_EraseRootFromParent_Done,
     /*   6401 */   // Label 218: @6401
     /*   6401 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(6463), // Rule ID 23741 //
     /*   6406 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6409 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6413 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6417 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6421 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6424 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6428 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6432 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6436 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6438 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6445 */     // (add:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPADDWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6445 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rm),
     /*   6448 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6450 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6452 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6456 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6461 */     GIR_RootConstrainSelectedInstOperands,
     /*   6462 */     // GIR_Coverage, 23741,
     /*   6462 */     GIR_EraseRootFromParent_Done,
     /*   6463 */   // Label 219: @6463
     /*   6463 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(6525), // Rule ID 2531 //
     /*   6468 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6471 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6475 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6479 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6483 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6487 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6490 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6494 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6498 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6500 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6507 */     // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6507 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWYrm),
     /*   6510 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6512 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6514 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6518 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6523 */     GIR_RootConstrainSelectedInstOperands,
     /*   6524 */     // GIR_Coverage, 2531,
     /*   6524 */     GIR_EraseRootFromParent_Done,
     /*   6525 */   // Label 220: @6525
     /*   6525 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(6587), // Rule ID 4694 //
     /*   6530 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6533 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6537 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6541 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6545 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6549 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6552 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6556 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6560 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6562 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6569 */     // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6569 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rm),
     /*   6572 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6574 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6576 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6580 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6585 */     GIR_RootConstrainSelectedInstOperands,
     /*   6586 */     // GIR_Coverage, 4694,
     /*   6586 */     GIR_EraseRootFromParent_Done,
     /*   6587 */   // Label 221: @6587
     /*   6587 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(6614), // Rule ID 2530 //
     /*   6592 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6595 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6599 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6603 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6607 */     // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPADDWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*   6607 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWYrr),
     /*   6612 */     GIR_RootConstrainSelectedInstOperands,
     /*   6613 */     // GIR_Coverage, 2530,
     /*   6613 */     GIR_Done,
     /*   6614 */   // Label 222: @6614
     /*   6614 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(6641), // Rule ID 4691 //
     /*   6619 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6622 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6626 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6630 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6634 */     // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPADDWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*   6634 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rr),
     /*   6639 */     GIR_RootConstrainSelectedInstOperands,
     /*   6640 */     // GIR_Coverage, 4691,
     /*   6640 */     GIR_Done,
     /*   6641 */   // Label 223: @6641
     /*   6641 */   GIM_Reject,
     /*   6642 */ // Label 217: @6642
     /*   6642 */ GIM_Reject,
     /*   6643 */ // Label 94: @6643
     /*   6643 */ GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(6798),
     /*   6648 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*   6651 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*   6654 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6658 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(6716), // Rule ID 23720 //
     /*   6663 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6666 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6670 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6674 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6677 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6681 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6685 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6689 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6691 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6698 */     // (add:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPADDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6698 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZrm),
     /*   6701 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6703 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6705 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6709 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6714 */     GIR_RootConstrainSelectedInstOperands,
     /*   6715 */     // GIR_Coverage, 23720,
     /*   6715 */     GIR_EraseRootFromParent_Done,
     /*   6716 */   // Label 225: @6716
     /*   6716 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(6774), // Rule ID 4661 //
     /*   6721 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6736 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6739 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6743 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6747 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6749 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6756 */     // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6756 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDDZrm),
     /*   6759 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6761 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6763 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6767 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6772 */     GIR_RootConstrainSelectedInstOperands,
     /*   6773 */     // GIR_Coverage, 4661,
     /*   6773 */     GIR_EraseRootFromParent_Done,
     /*   6774 */   // Label 226: @6774
     /*   6774 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(6797), // Rule ID 4658 //
     /*   6779 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*   6782 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6786 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   6790 */     // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPADDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*   6790 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZrr),
     /*   6795 */     GIR_RootConstrainSelectedInstOperands,
     /*   6796 */     // GIR_Coverage, 4658,
     /*   6796 */     GIR_Done,
     /*   6797 */   // Label 227: @6797
     /*   6797 */   GIM_Reject,
     /*   6798 */ // Label 224: @6798
     /*   6798 */ GIM_Reject,
     /*   6799 */ // Label 95: @6799
     /*   6799 */ GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(7113),
     /*   6804 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*   6807 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*   6810 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(6872), // Rule ID 23437 //
     /*   6815 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6818 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6822 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6830 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6833 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6837 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6841 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6845 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6847 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6854 */     // (add:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VPADDBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6854 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBYrm),
     /*   6857 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6859 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6861 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6865 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6870 */     GIR_RootConstrainSelectedInstOperands,
     /*   6871 */     // GIR_Coverage, 23437,
     /*   6871 */     GIR_EraseRootFromParent_Done,
     /*   6872 */   // Label 229: @6872
     /*   6872 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(6934), // Rule ID 23750 //
     /*   6877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   6880 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6884 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6888 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6892 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6895 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6899 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6903 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   6907 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6909 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6916 */     // (add:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v32i8] }:$src1)  =>  (VPADDBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6916 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rm),
     /*   6919 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6921 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   6923 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6927 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6932 */     GIR_RootConstrainSelectedInstOperands,
     /*   6933 */     // GIR_Coverage, 23750,
     /*   6933 */     GIR_EraseRootFromParent_Done,
     /*   6934 */   // Label 230: @6934
     /*   6934 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(6996), // Rule ID 2525 //
     /*   6939 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   6942 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6946 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   6950 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   6954 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   6958 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   6961 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   6965 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   6969 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   6971 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   6978 */     // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   6978 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBYrm),
     /*   6981 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   6983 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   6985 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   6989 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   6994 */     GIR_RootConstrainSelectedInstOperands,
     /*   6995 */     // GIR_Coverage, 2525,
     /*   6995 */     GIR_EraseRootFromParent_Done,
     /*   6996 */   // Label 231: @6996
     /*   6996 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(7058), // Rule ID 4712 //
     /*   7001 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   7004 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7008 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7012 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7016 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7020 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7023 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7027 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7031 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7033 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7040 */     // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7040 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rm),
     /*   7043 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7045 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7047 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7051 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7056 */     GIR_RootConstrainSelectedInstOperands,
     /*   7057 */     // GIR_Coverage, 4712,
     /*   7057 */     GIR_EraseRootFromParent_Done,
     /*   7058 */   // Label 232: @7058
     /*   7058 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(7085), // Rule ID 2524 //
     /*   7063 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*   7066 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7070 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7074 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   7078 */     // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPADDBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*   7078 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBYrr),
     /*   7083 */     GIR_RootConstrainSelectedInstOperands,
     /*   7084 */     // GIR_Coverage, 2524,
     /*   7084 */     GIR_Done,
     /*   7085 */   // Label 233: @7085
     /*   7085 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(7112), // Rule ID 4709 //
     /*   7090 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   7093 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7097 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7101 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   7105 */     // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPADDBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*   7105 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rr),
     /*   7110 */     GIR_RootConstrainSelectedInstOperands,
     /*   7111 */     // GIR_Coverage, 4709,
     /*   7111 */     GIR_Done,
     /*   7112 */   // Label 234: @7112
     /*   7112 */   GIM_Reject,
     /*   7113 */ // Label 228: @7113
     /*   7113 */ GIM_Reject,
     /*   7114 */ // Label 96: @7114
     /*   7114 */ GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(7269),
     /*   7119 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*   7122 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*   7125 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7129 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(7187), // Rule ID 23738 //
     /*   7134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7145 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7148 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7152 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7156 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7160 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7162 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7169 */     // (add:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPADDWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZrm),
     /*   7172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7174 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7176 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7180 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7185 */     GIR_RootConstrainSelectedInstOperands,
     /*   7186 */     // GIR_Coverage, 23738,
     /*   7186 */     GIR_EraseRootFromParent_Done,
     /*   7187 */   // Label 236: @7187
     /*   7187 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(7245), // Rule ID 4688 //
     /*   7192 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7195 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7199 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7203 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7207 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7210 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7214 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7218 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7220 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7227 */     // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7227 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDWZrm),
     /*   7230 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7232 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7234 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7238 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7243 */     GIR_RootConstrainSelectedInstOperands,
     /*   7244 */     // GIR_Coverage, 4688,
     /*   7244 */     GIR_EraseRootFromParent_Done,
     /*   7245 */   // Label 237: @7245
     /*   7245 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(7268), // Rule ID 4685 //
     /*   7250 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7253 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7257 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7261 */     // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPADDWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*   7261 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZrr),
     /*   7266 */     GIR_RootConstrainSelectedInstOperands,
     /*   7267 */     // GIR_Coverage, 4685,
     /*   7267 */     GIR_Done,
     /*   7268 */   // Label 238: @7268
     /*   7268 */   GIM_Reject,
     /*   7269 */ // Label 235: @7269
     /*   7269 */ GIM_Reject,
     /*   7270 */ // Label 97: @7270
     /*   7270 */ GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(7425),
     /*   7275 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*   7278 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*   7281 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7285 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(7343), // Rule ID 23747 //
     /*   7290 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7293 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7297 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7301 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7304 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7308 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7312 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7316 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7318 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7325 */     // (add:{ *:[v64i8] } (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v64i8] }:$src1)  =>  (VPADDBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7325 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZrm),
     /*   7328 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7330 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7332 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7336 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7341 */     GIR_RootConstrainSelectedInstOperands,
     /*   7342 */     // GIR_Coverage, 23747,
     /*   7342 */     GIR_EraseRootFromParent_Done,
     /*   7343 */   // Label 240: @7343
     /*   7343 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(7401), // Rule ID 4706 //
     /*   7348 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7351 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7355 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7359 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7363 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7366 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   7370 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7376 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7383 */     // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPADDBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPADDBZrm),
     /*   7386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7388 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7390 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7394 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7399 */     GIR_RootConstrainSelectedInstOperands,
     /*   7400 */     // GIR_Coverage, 4706,
     /*   7400 */     GIR_EraseRootFromParent_Done,
     /*   7401 */   // Label 241: @7401
     /*   7401 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(7424), // Rule ID 4703 //
     /*   7406 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*   7409 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7413 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*   7417 */     // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPADDBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*   7417 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZrr),
     /*   7422 */     GIR_RootConstrainSelectedInstOperands,
     /*   7423 */     // GIR_Coverage, 4703,
     /*   7423 */     GIR_Done,
     /*   7424 */   // Label 242: @7424
     /*   7424 */   GIM_Reject,
     /*   7425 */ // Label 239: @7425
     /*   7425 */ GIM_Reject,
     /*   7426 */ // Label 98: @7426
     /*   7426 */ GIM_Reject,
     /*   7427 */ // Label 1: @7427
     /*   7427 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 259*/ GIMT_Encode4(10962),
     /*   7438 */ /*GILLT_s8*//*Label 243*/ GIMT_Encode4(7534),
     /*   7442 */ /*GILLT_s16*//*Label 244*/ GIMT_Encode4(7886),
     /*   7446 */ /*GILLT_s32*//*Label 245*/ GIMT_Encode4(8238),
     /*   7450 */ /*GILLT_s64*//*Label 246*/ GIMT_Encode4(8590), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   7466 */ /*GILLT_v2s64*//*Label 247*/ GIMT_Encode4(8950), GIMT_Encode4(0),
     /*   7474 */ /*GILLT_v4s32*//*Label 248*/ GIMT_Encode4(9168),
     /*   7478 */ /*GILLT_v4s64*//*Label 249*/ GIMT_Encode4(9386), GIMT_Encode4(0),
     /*   7486 */ /*GILLT_v8s16*//*Label 250*/ GIMT_Encode4(9577),
     /*   7490 */ /*GILLT_v8s32*//*Label 251*/ GIMT_Encode4(9795),
     /*   7494 */ /*GILLT_v8s64*//*Label 252*/ GIMT_Encode4(9986), GIMT_Encode4(0),
     /*   7502 */ /*GILLT_v16s8*//*Label 253*/ GIMT_Encode4(10080),
     /*   7506 */ /*GILLT_v16s16*//*Label 254*/ GIMT_Encode4(10298),
     /*   7510 */ /*GILLT_v16s32*//*Label 255*/ GIMT_Encode4(10489), GIMT_Encode4(0),
     /*   7518 */ /*GILLT_v32s8*//*Label 256*/ GIMT_Encode4(10583),
     /*   7522 */ /*GILLT_v32s16*//*Label 257*/ GIMT_Encode4(10774), GIMT_Encode4(0),
     /*   7530 */ /*GILLT_v64s8*//*Label 258*/ GIMT_Encode4(10868),
     /*   7534 */ // Label 243: @7534
     /*   7534 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(7885),
     /*   7539 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*   7542 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*   7545 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7549 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(7610), // Rule ID 22814 //
     /*   7554 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7557 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7561 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7565 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7569 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7572 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7576 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   7580 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7582 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7589 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (SUB8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7589 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8rm),
     /*   7592 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7594 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7596 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7600 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7603 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7608 */     GIR_RootConstrainSelectedInstOperands,
     /*   7609 */     // GIR_Coverage, 22814,
     /*   7609 */     GIR_EraseRootFromParent_Done,
     /*   7610 */   // Label 261: @7610
     /*   7610 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(7671), // Rule ID 22904 //
     /*   7615 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7618 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7622 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7626 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7630 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7633 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7637 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*   7641 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7643 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7650 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (SUB8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7650 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8rm_ND),
     /*   7653 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7655 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7657 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7661 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7664 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7669 */     GIR_RootConstrainSelectedInstOperands,
     /*   7670 */     // GIR_Coverage, 22904,
     /*   7670 */     GIR_EraseRootFromParent_Done,
     /*   7671 */   // Label 262: @7671
     /*   7671 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(7699), // Rule ID 239 //
     /*   7676 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7679 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7683 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7687 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
     /*   7687 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r),
     /*   7690 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7692 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7694 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7697 */     GIR_RootConstrainSelectedInstOperands,
     /*   7698 */     // GIR_Coverage, 239,
     /*   7698 */     GIR_EraseRootFromParent_Done,
     /*   7699 */   // Label 263: @7699
     /*   7699 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(7727), // Rule ID 247 //
     /*   7704 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   7707 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7711 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7715 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
     /*   7715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_ND),
     /*   7718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7720 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7722 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7725 */     GIR_RootConstrainSelectedInstOperands,
     /*   7726 */     // GIR_Coverage, 247,
     /*   7726 */     GIR_EraseRootFromParent_Done,
     /*   7727 */   // Label 264: @7727
     /*   7727 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(7752), // Rule ID 255 //
     /*   7732 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   7735 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   7739 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7743 */     // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_NF_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
     /*   7743 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_NF_ND),
     /*   7746 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7748 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   7750 */     GIR_RootConstrainSelectedInstOperands,
     /*   7751 */     // GIR_Coverage, 255,
     /*   7751 */     GIR_EraseRootFromParent_Done,
     /*   7752 */   // Label 265: @7752
     /*   7752 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(7789), // Rule ID 22818 //
     /*   7757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7760 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7764 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7768 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7772 */     // MIs[1] Operand 1
     /*   7772 */     // No operand predicates
     /*   7772 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7774 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   7774 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri),
     /*   7777 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7779 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7781 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   7784 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7787 */     GIR_RootConstrainSelectedInstOperands,
     /*   7788 */     // GIR_Coverage, 22818,
     /*   7788 */     GIR_EraseRootFromParent_Done,
     /*   7789 */   // Label 266: @7789
     /*   7789 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(7826), // Rule ID 22908 //
     /*   7794 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7797 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7801 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7805 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   7809 */     // MIs[1] Operand 1
     /*   7809 */     // No operand predicates
     /*   7809 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7811 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*   7811 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri_ND),
     /*   7814 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7816 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7818 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   7821 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7824 */     GIR_RootConstrainSelectedInstOperands,
     /*   7825 */     // GIR_Coverage, 22908,
     /*   7825 */     GIR_EraseRootFromParent_Done,
     /*   7826 */   // Label 267: @7826
     /*   7826 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(7855), // Rule ID 22810 //
     /*   7831 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7834 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7838 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7842 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   7842 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr),
     /*   7847 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   7853 */     GIR_RootConstrainSelectedInstOperands,
     /*   7854 */     // GIR_Coverage, 22810,
     /*   7854 */     GIR_Done,
     /*   7855 */   // Label 268: @7855
     /*   7855 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(7884), // Rule ID 22900 //
     /*   7860 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7863 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7867 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*   7871 */     // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*   7871 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr_ND),
     /*   7876 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   7882 */     GIR_RootConstrainSelectedInstOperands,
     /*   7883 */     // GIR_Coverage, 22900,
     /*   7883 */     GIR_Done,
     /*   7884 */   // Label 269: @7884
     /*   7884 */   GIM_Reject,
     /*   7885 */ // Label 260: @7885
     /*   7885 */ GIM_Reject,
     /*   7886 */ // Label 244: @7886
     /*   7886 */ GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(8237),
     /*   7891 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*   7894 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*   7897 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7901 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(7962), // Rule ID 22815 //
     /*   7906 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   7909 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7913 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7917 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7921 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7924 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7928 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   7932 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7934 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   7941 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (SUB16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   7941 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16rm),
     /*   7944 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   7946 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   7948 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   7952 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   7955 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   7960 */     GIR_RootConstrainSelectedInstOperands,
     /*   7961 */     // GIR_Coverage, 22815,
     /*   7961 */     GIR_EraseRootFromParent_Done,
     /*   7962 */   // Label 271: @7962
     /*   7962 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(8023), // Rule ID 22905 //
     /*   7967 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   7970 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   7974 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   7978 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   7982 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   7985 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   7989 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*   7993 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   7995 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8002 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (SUB16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8002 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16rm_ND),
     /*   8005 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8007 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8009 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8013 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8016 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8021 */     GIR_RootConstrainSelectedInstOperands,
     /*   8022 */     // GIR_Coverage, 22905,
     /*   8022 */     GIR_EraseRootFromParent_Done,
     /*   8023 */   // Label 272: @8023
     /*   8023 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(8051), // Rule ID 240 //
     /*   8028 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8031 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8035 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8039 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
     /*   8039 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r),
     /*   8042 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8044 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8046 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8049 */     GIR_RootConstrainSelectedInstOperands,
     /*   8050 */     // GIR_Coverage, 240,
     /*   8050 */     GIR_EraseRootFromParent_Done,
     /*   8051 */   // Label 273: @8051
     /*   8051 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(8079), // Rule ID 248 //
     /*   8056 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8059 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8063 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8067 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
     /*   8067 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_ND),
     /*   8070 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8072 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8074 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8077 */     GIR_RootConstrainSelectedInstOperands,
     /*   8078 */     // GIR_Coverage, 248,
     /*   8078 */     GIR_EraseRootFromParent_Done,
     /*   8079 */   // Label 274: @8079
     /*   8079 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(8104), // Rule ID 256 //
     /*   8084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8087 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8091 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8095 */     // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_NF_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
     /*   8095 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_NF_ND),
     /*   8098 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8100 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8102 */     GIR_RootConstrainSelectedInstOperands,
     /*   8103 */     // GIR_Coverage, 256,
     /*   8103 */     GIR_EraseRootFromParent_Done,
     /*   8104 */   // Label 275: @8104
     /*   8104 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(8141), // Rule ID 22819 //
     /*   8109 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8112 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8116 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8120 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8124 */     // MIs[1] Operand 1
     /*   8124 */     // No operand predicates
     /*   8124 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8126 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   8126 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
     /*   8129 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8131 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8133 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8136 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8139 */     GIR_RootConstrainSelectedInstOperands,
     /*   8140 */     // GIR_Coverage, 22819,
     /*   8140 */     GIR_EraseRootFromParent_Done,
     /*   8141 */   // Label 276: @8141
     /*   8141 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(8178), // Rule ID 22909 //
     /*   8146 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8149 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8153 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8157 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8161 */     // MIs[1] Operand 1
     /*   8161 */     // No operand predicates
     /*   8161 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8163 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*   8163 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
     /*   8166 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8168 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8170 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8173 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8176 */     GIR_RootConstrainSelectedInstOperands,
     /*   8177 */     // GIR_Coverage, 22909,
     /*   8177 */     GIR_EraseRootFromParent_Done,
     /*   8178 */   // Label 277: @8178
     /*   8178 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(8207), // Rule ID 22811 //
     /*   8183 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8186 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8190 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8194 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   8194 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr),
     /*   8199 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8205 */     GIR_RootConstrainSelectedInstOperands,
     /*   8206 */     // GIR_Coverage, 22811,
     /*   8206 */     GIR_Done,
     /*   8207 */   // Label 278: @8207
     /*   8207 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(8236), // Rule ID 22901 //
     /*   8212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8215 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8219 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*   8223 */     // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*   8223 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr_ND),
     /*   8228 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8234 */     GIR_RootConstrainSelectedInstOperands,
     /*   8235 */     // GIR_Coverage, 22901,
     /*   8235 */     GIR_Done,
     /*   8236 */   // Label 279: @8236
     /*   8236 */   GIM_Reject,
     /*   8237 */ // Label 270: @8237
     /*   8237 */ GIM_Reject,
     /*   8238 */ // Label 245: @8238
     /*   8238 */ GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(8589),
     /*   8243 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   8246 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   8249 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8253 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(8314), // Rule ID 22816 //
     /*   8258 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8261 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8265 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8269 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8273 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8276 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8280 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   8284 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8286 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8293 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (SUB32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8293 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32rm),
     /*   8296 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8298 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8300 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8304 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8307 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8312 */     GIR_RootConstrainSelectedInstOperands,
     /*   8313 */     // GIR_Coverage, 22816,
     /*   8313 */     GIR_EraseRootFromParent_Done,
     /*   8314 */   // Label 281: @8314
     /*   8314 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(8375), // Rule ID 22906 //
     /*   8319 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8322 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8326 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8330 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8334 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8337 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8341 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*   8345 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8347 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8354 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (SUB32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8354 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32rm_ND),
     /*   8357 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8359 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8361 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8365 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8368 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8373 */     GIR_RootConstrainSelectedInstOperands,
     /*   8374 */     // GIR_Coverage, 22906,
     /*   8374 */     GIR_EraseRootFromParent_Done,
     /*   8375 */   // Label 282: @8375
     /*   8375 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(8403), // Rule ID 241 //
     /*   8380 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8383 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8387 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8391 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8391 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r),
     /*   8394 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8396 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8398 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8401 */     GIR_RootConstrainSelectedInstOperands,
     /*   8402 */     // GIR_Coverage, 241,
     /*   8402 */     GIR_EraseRootFromParent_Done,
     /*   8403 */   // Label 283: @8403
     /*   8403 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(8431), // Rule ID 249 //
     /*   8408 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8411 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8415 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8419 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8419 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_ND),
     /*   8422 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8424 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8426 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8429 */     GIR_RootConstrainSelectedInstOperands,
     /*   8430 */     // GIR_Coverage, 249,
     /*   8430 */     GIR_EraseRootFromParent_Done,
     /*   8431 */   // Label 284: @8431
     /*   8431 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(8456), // Rule ID 257 //
     /*   8436 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8439 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8443 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8447 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_NF_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
     /*   8447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_NF_ND),
     /*   8450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8452 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8454 */     GIR_RootConstrainSelectedInstOperands,
     /*   8455 */     // GIR_Coverage, 257,
     /*   8455 */     GIR_EraseRootFromParent_Done,
     /*   8456 */   // Label 285: @8456
     /*   8456 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(8493), // Rule ID 22820 //
     /*   8461 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8464 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8468 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8472 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8476 */     // MIs[1] Operand 1
     /*   8476 */     // No operand predicates
     /*   8476 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8478 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   8478 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
     /*   8481 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8483 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8485 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8488 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8491 */     GIR_RootConstrainSelectedInstOperands,
     /*   8492 */     // GIR_Coverage, 22820,
     /*   8492 */     GIR_EraseRootFromParent_Done,
     /*   8493 */   // Label 286: @8493
     /*   8493 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(8530), // Rule ID 22910 //
     /*   8498 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8501 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8505 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8509 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8513 */     // MIs[1] Operand 1
     /*   8513 */     // No operand predicates
     /*   8513 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8515 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*   8515 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
     /*   8518 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8520 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8522 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8525 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8528 */     GIR_RootConstrainSelectedInstOperands,
     /*   8529 */     // GIR_Coverage, 22910,
     /*   8529 */     GIR_EraseRootFromParent_Done,
     /*   8530 */   // Label 287: @8530
     /*   8530 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(8559), // Rule ID 22812 //
     /*   8535 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8538 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8542 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8546 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   8546 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr),
     /*   8551 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8557 */     GIR_RootConstrainSelectedInstOperands,
     /*   8558 */     // GIR_Coverage, 22812,
     /*   8558 */     GIR_Done,
     /*   8559 */   // Label 288: @8559
     /*   8559 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(8588), // Rule ID 22902 //
     /*   8564 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8567 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8571 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*   8575 */     // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*   8575 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr_ND),
     /*   8580 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8586 */     GIR_RootConstrainSelectedInstOperands,
     /*   8587 */     // GIR_Coverage, 22902,
     /*   8587 */     GIR_Done,
     /*   8588 */   // Label 289: @8588
     /*   8588 */   GIM_Reject,
     /*   8589 */ // Label 280: @8589
     /*   8589 */ GIM_Reject,
     /*   8590 */ // Label 246: @8590
     /*   8590 */ GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(8949),
     /*   8595 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   8598 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   8601 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8605 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(8666), // Rule ID 22817 //
     /*   8610 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8613 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8617 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8621 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8625 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8628 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8632 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8636 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8638 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8645 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (SUB64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8645 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64rm),
     /*   8648 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8650 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8652 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8656 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8659 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8664 */     GIR_RootConstrainSelectedInstOperands,
     /*   8665 */     // GIR_Coverage, 22817,
     /*   8665 */     GIR_EraseRootFromParent_Done,
     /*   8666 */   // Label 291: @8666
     /*   8666 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(8727), // Rule ID 22907 //
     /*   8671 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8674 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8678 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8682 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8686 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8689 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8693 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8697 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8699 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   8706 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (SUB64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   8706 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64rm_ND),
     /*   8709 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8711 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8713 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   8717 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8720 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   8725 */     GIR_RootConstrainSelectedInstOperands,
     /*   8726 */     // GIR_Coverage, 22907,
     /*   8726 */     GIR_EraseRootFromParent_Done,
     /*   8727 */   // Label 292: @8727
     /*   8727 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(8755), // Rule ID 242 //
     /*   8732 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8735 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8739 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8743 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
     /*   8743 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r),
     /*   8746 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8748 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8750 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8753 */     GIR_RootConstrainSelectedInstOperands,
     /*   8754 */     // GIR_Coverage, 242,
     /*   8754 */     GIR_EraseRootFromParent_Done,
     /*   8755 */   // Label 293: @8755
     /*   8755 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(8783), // Rule ID 250 //
     /*   8760 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8763 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8767 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8771 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
     /*   8771 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_ND),
     /*   8774 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8776 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8778 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8781 */     GIR_RootConstrainSelectedInstOperands,
     /*   8782 */     // GIR_Coverage, 250,
     /*   8782 */     GIR_EraseRootFromParent_Done,
     /*   8783 */   // Label 294: @8783
     /*   8783 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(8808), // Rule ID 258 //
     /*   8788 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
     /*   8791 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   8795 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8799 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_NF_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
     /*   8799 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_NF_ND),
     /*   8802 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8804 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*   8806 */     GIR_RootConstrainSelectedInstOperands,
     /*   8807 */     // GIR_Coverage, 258,
     /*   8807 */     GIR_EraseRootFromParent_Done,
     /*   8808 */   // Label 295: @8808
     /*   8808 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(8849), // Rule ID 22821 //
     /*   8813 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8816 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8820 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8824 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8828 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   8832 */     // MIs[1] Operand 1
     /*   8832 */     // No operand predicates
     /*   8832 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8834 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   8834 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
     /*   8837 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8839 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8841 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8844 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8847 */     GIR_RootConstrainSelectedInstOperands,
     /*   8848 */     // GIR_Coverage, 22821,
     /*   8848 */     GIR_EraseRootFromParent_Done,
     /*   8849 */   // Label 296: @8849
     /*   8849 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(8890), // Rule ID 22911 //
     /*   8854 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8857 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8861 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8865 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   8869 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*   8873 */     // MIs[1] Operand 1
     /*   8873 */     // No operand predicates
     /*   8873 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8875 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*   8875 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
     /*   8878 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   8880 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   8882 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*   8885 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*   8888 */     GIR_RootConstrainSelectedInstOperands,
     /*   8889 */     // GIR_Coverage, 22911,
     /*   8889 */     GIR_EraseRootFromParent_Done,
     /*   8890 */   // Label 297: @8890
     /*   8890 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(8919), // Rule ID 22813 //
     /*   8895 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*   8898 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8902 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8906 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   8906 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr),
     /*   8911 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8917 */     GIR_RootConstrainSelectedInstOperands,
     /*   8918 */     // GIR_Coverage, 22813,
     /*   8918 */     GIR_Done,
     /*   8919 */   // Label 298: @8919
     /*   8919 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(8948), // Rule ID 22903 //
     /*   8924 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*   8927 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8931 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*   8935 */     // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*   8935 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr_ND),
     /*   8940 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*   8946 */     GIR_RootConstrainSelectedInstOperands,
     /*   8947 */     // GIR_Coverage, 22903,
     /*   8947 */     GIR_Done,
     /*   8948 */   // Label 299: @8948
     /*   8948 */   GIM_Reject,
     /*   8949 */ // Label 290: @8949
     /*   8949 */ GIM_Reject,
     /*   8950 */ // Label 247: @8950
     /*   8950 */ GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(9167),
     /*   8955 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   8958 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   8961 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(9023), // Rule ID 2605 //
     /*   8966 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   8969 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   8973 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   8977 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   8981 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   8985 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   8988 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   8992 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   8996 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   8998 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9005 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9005 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQrm),
     /*   9008 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9010 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9012 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9016 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9021 */     GIR_RootConstrainSelectedInstOperands,
     /*   9022 */     // GIR_Coverage, 2605,
     /*   9022 */     GIR_EraseRootFromParent_Done,
     /*   9023 */   // Label 301: @9023
     /*   9023 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(9085), // Rule ID 4742 //
     /*   9028 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9031 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9035 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9039 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9043 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9047 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9050 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9054 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9058 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9060 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9067 */     // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9067 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rm),
     /*   9070 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9072 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9074 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9078 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9083 */     GIR_RootConstrainSelectedInstOperands,
     /*   9084 */     // GIR_Coverage, 4742,
     /*   9084 */     GIR_EraseRootFromParent_Done,
     /*   9085 */   // Label 302: @9085
     /*   9085 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(9112), // Rule ID 2604 //
     /*   9090 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9093 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9097 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9101 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9105 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   9105 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQrr),
     /*   9110 */     GIR_RootConstrainSelectedInstOperands,
     /*   9111 */     // GIR_Coverage, 2604,
     /*   9111 */     GIR_Done,
     /*   9112 */   // Label 303: @9112
     /*   9112 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(9139), // Rule ID 2606 //
     /*   9117 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9124 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9128 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9132 */     // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*   9132 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBQrr),
     /*   9137 */     GIR_RootConstrainSelectedInstOperands,
     /*   9138 */     // GIR_Coverage, 2606,
     /*   9138 */     GIR_Done,
     /*   9139 */   // Label 304: @9139
     /*   9139 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(9166), // Rule ID 4739 //
     /*   9144 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9147 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9151 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9155 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9159 */     // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPSUBQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*   9159 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rr),
     /*   9164 */     GIR_RootConstrainSelectedInstOperands,
     /*   9165 */     // GIR_Coverage, 4739,
     /*   9165 */     GIR_Done,
     /*   9166 */   // Label 305: @9166
     /*   9166 */   GIM_Reject,
     /*   9167 */ // Label 300: @9167
     /*   9167 */ GIM_Reject,
     /*   9168 */ // Label 248: @9168
     /*   9168 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(9385),
     /*   9173 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9176 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9179 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(9241), // Rule ID 2599 //
     /*   9184 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9187 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9191 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9195 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9199 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9203 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9206 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9210 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9214 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9216 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9223 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9223 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDrm),
     /*   9226 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9228 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9230 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9234 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9239 */     GIR_RootConstrainSelectedInstOperands,
     /*   9240 */     // GIR_Coverage, 2599,
     /*   9240 */     GIR_EraseRootFromParent_Done,
     /*   9241 */   // Label 307: @9241
     /*   9241 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(9303), // Rule ID 4769 //
     /*   9246 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9249 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9253 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9257 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9261 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9265 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9268 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9272 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9276 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9278 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9285 */     // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9285 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rm),
     /*   9288 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9290 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9292 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9296 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9301 */     GIR_RootConstrainSelectedInstOperands,
     /*   9302 */     // GIR_Coverage, 4769,
     /*   9302 */     GIR_EraseRootFromParent_Done,
     /*   9303 */   // Label 308: @9303
     /*   9303 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(9330), // Rule ID 2598 //
     /*   9308 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*   9311 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9315 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9319 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9323 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   9323 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDrr),
     /*   9328 */     GIR_RootConstrainSelectedInstOperands,
     /*   9329 */     // GIR_Coverage, 2598,
     /*   9329 */     GIR_Done,
     /*   9330 */   // Label 309: @9330
     /*   9330 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(9357), // Rule ID 2600 //
     /*   9335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9338 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9342 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9346 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9350 */     // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*   9350 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBDrr),
     /*   9355 */     GIR_RootConstrainSelectedInstOperands,
     /*   9356 */     // GIR_Coverage, 2600,
     /*   9356 */     GIR_Done,
     /*   9357 */   // Label 310: @9357
     /*   9357 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(9384), // Rule ID 4766 //
     /*   9362 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9365 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9369 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9373 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9377 */     // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPSUBDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*   9377 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rr),
     /*   9382 */     GIR_RootConstrainSelectedInstOperands,
     /*   9383 */     // GIR_Coverage, 4766,
     /*   9383 */     GIR_Done,
     /*   9384 */   // Label 311: @9384
     /*   9384 */   GIM_Reject,
     /*   9385 */ // Label 306: @9385
     /*   9385 */ GIM_Reject,
     /*   9386 */ // Label 249: @9386
     /*   9386 */ GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(9576),
     /*   9391 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*   9394 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*   9397 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(9459), // Rule ID 2609 //
     /*   9402 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9405 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9409 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9413 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9417 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9421 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9424 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9428 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9432 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9434 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9441 */     // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9441 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrm),
     /*   9444 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9446 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9448 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9452 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9457 */     GIR_RootConstrainSelectedInstOperands,
     /*   9458 */     // GIR_Coverage, 2609,
     /*   9458 */     GIR_EraseRootFromParent_Done,
     /*   9459 */   // Label 313: @9459
     /*   9459 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(9521), // Rule ID 4733 //
     /*   9464 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9467 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9471 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9475 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9479 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9483 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9486 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9490 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9494 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9496 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9503 */     // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9503 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rm),
     /*   9506 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9508 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9510 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9514 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9519 */     GIR_RootConstrainSelectedInstOperands,
     /*   9520 */     // GIR_Coverage, 4733,
     /*   9520 */     GIR_EraseRootFromParent_Done,
     /*   9521 */   // Label 314: @9521
     /*   9521 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(9548), // Rule ID 2608 //
     /*   9526 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9529 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9533 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9537 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9541 */     // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPSUBQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*   9541 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrr),
     /*   9546 */     GIR_RootConstrainSelectedInstOperands,
     /*   9547 */     // GIR_Coverage, 2608,
     /*   9547 */     GIR_Done,
     /*   9548 */   // Label 315: @9548
     /*   9548 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(9575), // Rule ID 4730 //
     /*   9553 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9556 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9560 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9564 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9568 */     // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPSUBQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*   9568 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rr),
     /*   9573 */     GIR_RootConstrainSelectedInstOperands,
     /*   9574 */     // GIR_Coverage, 4730,
     /*   9574 */     GIR_Done,
     /*   9575 */   // Label 316: @9575
     /*   9575 */   GIM_Reject,
     /*   9576 */ // Label 312: @9576
     /*   9576 */ GIM_Reject,
     /*   9577 */ // Label 250: @9577
     /*   9577 */ GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(9794),
     /*   9582 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   9585 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   9588 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(9650), // Rule ID 2593 //
     /*   9593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   9596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9600 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9604 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9608 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9612 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9615 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9619 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9623 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9625 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9632 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9632 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWrm),
     /*   9635 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9637 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9639 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9643 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9648 */     GIR_RootConstrainSelectedInstOperands,
     /*   9649 */     // GIR_Coverage, 2593,
     /*   9649 */     GIR_EraseRootFromParent_Done,
     /*   9650 */   // Label 318: @9650
     /*   9650 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(9712), // Rule ID 4790 //
     /*   9655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   9658 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9662 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9666 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9670 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9674 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9677 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9681 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9685 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9687 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9694 */     // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rm),
     /*   9697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9699 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9701 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9705 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9710 */     GIR_RootConstrainSelectedInstOperands,
     /*   9711 */     // GIR_Coverage, 4790,
     /*   9711 */     GIR_EraseRootFromParent_Done,
     /*   9712 */   // Label 319: @9712
     /*   9712 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(9739), // Rule ID 2592 //
     /*   9717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*   9720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9728 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9732 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   9732 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWrr),
     /*   9737 */     GIR_RootConstrainSelectedInstOperands,
     /*   9738 */     // GIR_Coverage, 2592,
     /*   9738 */     GIR_Done,
     /*   9739 */   // Label 320: @9739
     /*   9739 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(9766), // Rule ID 2594 //
     /*   9744 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*   9747 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9751 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9755 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*   9759 */     // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*   9759 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBWrr),
     /*   9764 */     GIR_RootConstrainSelectedInstOperands,
     /*   9765 */     // GIR_Coverage, 2594,
     /*   9765 */     GIR_Done,
     /*   9766 */   // Label 321: @9766
     /*   9766 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(9793), // Rule ID 4787 //
     /*   9771 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*   9774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9778 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9782 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*   9786 */     // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPSUBWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*   9786 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rr),
     /*   9791 */     GIR_RootConstrainSelectedInstOperands,
     /*   9792 */     // GIR_Coverage, 4787,
     /*   9792 */     GIR_Done,
     /*   9793 */   // Label 322: @9793
     /*   9793 */   GIM_Reject,
     /*   9794 */ // Label 317: @9794
     /*   9794 */ GIM_Reject,
     /*   9795 */ // Label 251: @9795
     /*   9795 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(9985),
     /*   9800 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*   9803 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*   9806 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(9868), // Rule ID 2603 //
     /*   9811 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9814 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9818 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9822 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9830 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9833 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9837 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9841 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9843 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9850 */     // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9850 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrm),
     /*   9853 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9855 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9857 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9861 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9866 */     GIR_RootConstrainSelectedInstOperands,
     /*   9867 */     // GIR_Coverage, 2603,
     /*   9867 */     GIR_EraseRootFromParent_Done,
     /*   9868 */   // Label 324: @9868
     /*   9868 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(9930), // Rule ID 4760 //
     /*   9873 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9876 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9880 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9884 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   9888 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*   9892 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*   9895 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*   9899 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*   9903 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   9905 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*   9912 */     // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*   9912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rm),
     /*   9915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   9917 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*   9919 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*   9923 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*   9928 */     GIR_RootConstrainSelectedInstOperands,
     /*   9929 */     // GIR_Coverage, 4760,
     /*   9929 */     GIR_EraseRootFromParent_Done,
     /*   9930 */   // Label 325: @9930
     /*   9930 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(9957), // Rule ID 2602 //
     /*   9935 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*   9938 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9942 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9946 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*   9950 */     // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSUBDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*   9950 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrr),
     /*   9955 */     GIR_RootConstrainSelectedInstOperands,
     /*   9956 */     // GIR_Coverage, 2602,
     /*   9956 */     GIR_Done,
     /*   9957 */   // Label 326: @9957
     /*   9957 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(9984), // Rule ID 4757 //
     /*   9962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*   9965 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9969 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9973 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*   9977 */     // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPSUBDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*   9977 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rr),
     /*   9982 */     GIR_RootConstrainSelectedInstOperands,
     /*   9983 */     // GIR_Coverage, 4757,
     /*   9983 */     GIR_Done,
     /*   9984 */   // Label 327: @9984
     /*   9984 */   GIM_Reject,
     /*   9985 */ // Label 323: @9985
     /*   9985 */ GIM_Reject,
     /*   9986 */ // Label 252: @9986
     /*   9986 */ GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(10079),
     /*   9991 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*   9994 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*   9997 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10001 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10005 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(10059), // Rule ID 4724 //
     /*  10010 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10013 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10017 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10021 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10024 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10028 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10032 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10034 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10041 */     // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10041 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrm),
     /*  10044 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10046 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10048 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10052 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10057 */     GIR_RootConstrainSelectedInstOperands,
     /*  10058 */     // GIR_Coverage, 4724,
     /*  10058 */     GIR_EraseRootFromParent_Done,
     /*  10059 */   // Label 329: @10059
     /*  10059 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(10078), // Rule ID 4721 //
     /*  10064 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10067 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10071 */     // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPSUBQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  10071 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrr),
     /*  10076 */     GIR_RootConstrainSelectedInstOperands,
     /*  10077 */     // GIR_Coverage, 4721,
     /*  10077 */     GIR_Done,
     /*  10078 */   // Label 330: @10078
     /*  10078 */   GIM_Reject,
     /*  10079 */ // Label 328: @10079
     /*  10079 */ GIM_Reject,
     /*  10080 */ // Label 253: @10080
     /*  10080 */ GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(10297),
     /*  10085 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  10088 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  10091 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(10153), // Rule ID 2587 //
     /*  10096 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  10099 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10103 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10107 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10111 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10115 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10118 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10122 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10126 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10128 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10135 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10135 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBrm),
     /*  10138 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10140 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10142 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10146 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10151 */     GIR_RootConstrainSelectedInstOperands,
     /*  10152 */     // GIR_Coverage, 2587,
     /*  10152 */     GIR_EraseRootFromParent_Done,
     /*  10153 */   // Label 332: @10153
     /*  10153 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(10215), // Rule ID 4808 //
     /*  10158 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10161 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10165 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10169 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10173 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10177 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10180 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10184 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10188 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10190 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10197 */     // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10197 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rm),
     /*  10200 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10202 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10204 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10208 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10213 */     GIR_RootConstrainSelectedInstOperands,
     /*  10214 */     // GIR_Coverage, 4808,
     /*  10214 */     GIR_EraseRootFromParent_Done,
     /*  10215 */   // Label 333: @10215
     /*  10215 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(10242), // Rule ID 2586 //
     /*  10220 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  10223 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10227 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10231 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10235 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  10235 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBrr),
     /*  10240 */     GIR_RootConstrainSelectedInstOperands,
     /*  10241 */     // GIR_Coverage, 2586,
     /*  10241 */     GIR_Done,
     /*  10242 */   // Label 334: @10242
     /*  10242 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(10269), // Rule ID 2588 //
     /*  10247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  10250 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10254 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10258 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  10262 */     // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  10262 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBBrr),
     /*  10267 */     GIR_RootConstrainSelectedInstOperands,
     /*  10268 */     // GIR_Coverage, 2588,
     /*  10268 */     GIR_Done,
     /*  10269 */   // Label 335: @10269
     /*  10269 */   GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(10296), // Rule ID 4805 //
     /*  10274 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10277 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10281 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10285 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  10289 */     // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPSUBBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  10289 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rr),
     /*  10294 */     GIR_RootConstrainSelectedInstOperands,
     /*  10295 */     // GIR_Coverage, 4805,
     /*  10295 */     GIR_Done,
     /*  10296 */   // Label 336: @10296
     /*  10296 */   GIM_Reject,
     /*  10297 */ // Label 331: @10297
     /*  10297 */ GIM_Reject,
     /*  10298 */ // Label 254: @10298
     /*  10298 */ GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(10488),
     /*  10303 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  10306 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  10309 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(10371), // Rule ID 2597 //
     /*  10314 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10317 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10321 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10325 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10329 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10333 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10336 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10340 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10344 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10346 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10353 */     // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10353 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrm),
     /*  10356 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10358 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10360 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10364 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10369 */     GIR_RootConstrainSelectedInstOperands,
     /*  10370 */     // GIR_Coverage, 2597,
     /*  10370 */     GIR_EraseRootFromParent_Done,
     /*  10371 */   // Label 338: @10371
     /*  10371 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(10433), // Rule ID 4784 //
     /*  10376 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10379 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10383 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10387 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10391 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10395 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10398 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10402 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10406 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10408 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10415 */     // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rm),
     /*  10418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10420 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10422 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10426 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10431 */     GIR_RootConstrainSelectedInstOperands,
     /*  10432 */     // GIR_Coverage, 4784,
     /*  10432 */     GIR_EraseRootFromParent_Done,
     /*  10433 */   // Label 339: @10433
     /*  10433 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(10460), // Rule ID 2596 //
     /*  10438 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10441 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10445 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10449 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10453 */     // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSUBWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  10453 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrr),
     /*  10458 */     GIR_RootConstrainSelectedInstOperands,
     /*  10459 */     // GIR_Coverage, 2596,
     /*  10459 */     GIR_Done,
     /*  10460 */   // Label 340: @10460
     /*  10460 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(10487), // Rule ID 4781 //
     /*  10465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10468 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10472 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10476 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10480 */     // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPSUBWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  10480 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rr),
     /*  10485 */     GIR_RootConstrainSelectedInstOperands,
     /*  10486 */     // GIR_Coverage, 4781,
     /*  10486 */     GIR_Done,
     /*  10487 */   // Label 341: @10487
     /*  10487 */   GIM_Reject,
     /*  10488 */ // Label 337: @10488
     /*  10488 */ GIM_Reject,
     /*  10489 */ // Label 255: @10489
     /*  10489 */ GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(10582),
     /*  10494 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  10497 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  10500 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10504 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10508 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(10562), // Rule ID 4751 //
     /*  10513 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10524 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10527 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10531 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10535 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10537 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10544 */     // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrm),
     /*  10547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10549 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10551 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10555 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10560 */     GIR_RootConstrainSelectedInstOperands,
     /*  10561 */     // GIR_Coverage, 4751,
     /*  10561 */     GIR_EraseRootFromParent_Done,
     /*  10562 */   // Label 343: @10562
     /*  10562 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(10581), // Rule ID 4748 //
     /*  10567 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  10570 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10574 */     // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPSUBDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  10574 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrr),
     /*  10579 */     GIR_RootConstrainSelectedInstOperands,
     /*  10580 */     // GIR_Coverage, 4748,
     /*  10580 */     GIR_Done,
     /*  10581 */   // Label 344: @10581
     /*  10581 */   GIM_Reject,
     /*  10582 */ // Label 342: @10582
     /*  10582 */ GIM_Reject,
     /*  10583 */ // Label 256: @10583
     /*  10583 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(10773),
     /*  10588 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*  10591 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*  10594 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(10656), // Rule ID 2591 //
     /*  10599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10602 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10606 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10610 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10614 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10618 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10621 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10625 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10629 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10631 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10638 */     // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrm),
     /*  10641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10643 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10645 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10649 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10654 */     GIR_RootConstrainSelectedInstOperands,
     /*  10655 */     // GIR_Coverage, 2591,
     /*  10655 */     GIR_EraseRootFromParent_Done,
     /*  10656 */   // Label 346: @10656
     /*  10656 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(10718), // Rule ID 4802 //
     /*  10661 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10664 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10668 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10672 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10676 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10680 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10683 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10687 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10691 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10693 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10700 */     // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10700 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rm),
     /*  10703 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10705 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10707 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10711 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10716 */     GIR_RootConstrainSelectedInstOperands,
     /*  10717 */     // GIR_Coverage, 4802,
     /*  10717 */     GIR_EraseRootFromParent_Done,
     /*  10718 */   // Label 347: @10718
     /*  10718 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(10745), // Rule ID 2590 //
     /*  10723 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  10726 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10730 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10734 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  10738 */     // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSUBBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  10738 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrr),
     /*  10743 */     GIR_RootConstrainSelectedInstOperands,
     /*  10744 */     // GIR_Coverage, 2590,
     /*  10744 */     GIR_Done,
     /*  10745 */   // Label 348: @10745
     /*  10745 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(10772), // Rule ID 4799 //
     /*  10750 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  10753 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10757 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10761 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  10765 */     // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPSUBBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*  10765 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rr),
     /*  10770 */     GIR_RootConstrainSelectedInstOperands,
     /*  10771 */     // GIR_Coverage, 4799,
     /*  10771 */     GIR_Done,
     /*  10772 */   // Label 349: @10772
     /*  10772 */   GIM_Reject,
     /*  10773 */ // Label 345: @10773
     /*  10773 */ GIM_Reject,
     /*  10774 */ // Label 257: @10774
     /*  10774 */ GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(10867),
     /*  10779 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  10782 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  10785 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10789 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10793 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(10847), // Rule ID 4778 //
     /*  10798 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10801 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10805 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10809 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10812 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10816 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10820 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10822 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10829 */     // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10829 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrm),
     /*  10832 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10834 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10836 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10840 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10845 */     GIR_RootConstrainSelectedInstOperands,
     /*  10846 */     // GIR_Coverage, 4778,
     /*  10846 */     GIR_EraseRootFromParent_Done,
     /*  10847 */   // Label 351: @10847
     /*  10847 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(10866), // Rule ID 4775 //
     /*  10852 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10855 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10859 */     // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPSUBWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  10859 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrr),
     /*  10864 */     GIR_RootConstrainSelectedInstOperands,
     /*  10865 */     // GIR_Coverage, 4775,
     /*  10865 */     GIR_Done,
     /*  10866 */   // Label 352: @10866
     /*  10866 */   GIM_Reject,
     /*  10867 */ // Label 350: @10867
     /*  10867 */ GIM_Reject,
     /*  10868 */ // Label 258: @10868
     /*  10868 */ GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(10961),
     /*  10873 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*  10876 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*  10879 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10883 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10887 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(10941), // Rule ID 4796 //
     /*  10892 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10895 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  10899 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  10903 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  10906 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  10910 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  10914 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  10916 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  10923 */     // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPSUBBZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  10923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrm),
     /*  10926 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  10928 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  10930 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  10934 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  10939 */     GIR_RootConstrainSelectedInstOperands,
     /*  10940 */     // GIR_Coverage, 4796,
     /*  10940 */     GIR_EraseRootFromParent_Done,
     /*  10941 */   // Label 354: @10941
     /*  10941 */   GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(10960), // Rule ID 4793 //
     /*  10946 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  10949 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  10953 */     // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPSUBBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*  10953 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrr),
     /*  10958 */     GIR_RootConstrainSelectedInstOperands,
     /*  10959 */     // GIR_Coverage, 4793,
     /*  10959 */     GIR_Done,
     /*  10960 */   // Label 355: @10960
     /*  10960 */   GIM_Reject,
     /*  10961 */ // Label 353: @10961
     /*  10961 */ GIM_Reject,
     /*  10962 */ // Label 259: @10962
     /*  10962 */ GIM_Reject,
     /*  10963 */ // Label 2: @10963
     /*  10963 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(23), /*)*//*default:*//*Label 368*/ GIMT_Encode4(14745),
     /*  10974 */ /*GILLT_s16*//*Label 356*/ GIMT_Encode4(11058),
     /*  10978 */ /*GILLT_s32*//*Label 357*/ GIMT_Encode4(11475),
     /*  10982 */ /*GILLT_s64*//*Label 358*/ GIMT_Encode4(11892), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  10998 */ /*GILLT_v2s64*//*Label 359*/ GIMT_Encode4(12317), GIMT_Encode4(0),
     /*  11006 */ /*GILLT_v4s32*//*Label 360*/ GIMT_Encode4(12646),
     /*  11010 */ /*GILLT_v4s64*//*Label 361*/ GIMT_Encode4(12988), GIMT_Encode4(0),
     /*  11018 */ /*GILLT_v8s16*//*Label 362*/ GIMT_Encode4(13305),
     /*  11022 */ /*GILLT_v8s32*//*Label 363*/ GIMT_Encode4(13647),
     /*  11026 */ /*GILLT_v8s64*//*Label 364*/ GIMT_Encode4(13962), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  11038 */ /*GILLT_v16s16*//*Label 365*/ GIMT_Encode4(14118),
     /*  11042 */ /*GILLT_v16s32*//*Label 366*/ GIMT_Encode4(14433), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  11054 */ /*GILLT_v32s16*//*Label 367*/ GIMT_Encode4(14589),
     /*  11058 */ // Label 356: @11058
     /*  11058 */ GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(11474),
     /*  11063 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  11066 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  11069 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11073 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(11137), // Rule ID 22985 //
     /*  11078 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11082 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11086 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11089 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11093 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11097 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11101 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11105 */     // MIs[2] Operand 1
     /*  11105 */     // No operand predicates
     /*  11105 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11107 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11114 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rmi:{ *:[i16] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  11114 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rmi),
     /*  11117 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11119 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11123 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11126 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11129 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11135 */     GIR_RootConstrainSelectedInstOperands,
     /*  11136 */     // GIR_Coverage, 22985,
     /*  11136 */     GIR_EraseRootFromParent_Done,
     /*  11137 */   // Label 370: @11137
     /*  11137 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(11198), // Rule ID 26064 //
     /*  11142 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11145 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11149 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11153 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11156 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11160 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11164 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11168 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11170 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11177 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (IMUL16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11177 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm),
     /*  11180 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11182 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11184 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11188 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11191 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11196 */     GIR_RootConstrainSelectedInstOperands,
     /*  11197 */     // GIR_Coverage, 26064,
     /*  11197 */     GIR_EraseRootFromParent_Done,
     /*  11198 */   // Label 371: @11198
     /*  11198 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(11259), // Rule ID 26083 //
     /*  11203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11214 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11217 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11221 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11225 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11229 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11231 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11238 */     // (mul:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (IMUL16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11238 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm_ND),
     /*  11241 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11243 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11245 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11249 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11252 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11257 */     GIR_RootConstrainSelectedInstOperands,
     /*  11258 */     // GIR_Coverage, 26083,
     /*  11258 */     GIR_EraseRootFromParent_Done,
     /*  11259 */   // Label 372: @11259
     /*  11259 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(11320), // Rule ID 22829 //
     /*  11264 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11267 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11271 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11275 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11279 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11282 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11286 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11290 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11292 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11299 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (IMUL16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11299 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm),
     /*  11302 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11304 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11306 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11310 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11313 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11318 */     GIR_RootConstrainSelectedInstOperands,
     /*  11319 */     // GIR_Coverage, 22829,
     /*  11319 */     GIR_EraseRootFromParent_Done,
     /*  11320 */   // Label 373: @11320
     /*  11320 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(11381), // Rule ID 22919 //
     /*  11325 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11328 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11332 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11336 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11340 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11343 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11347 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  11351 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11353 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11360 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (IMUL16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11360 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rm_ND),
     /*  11363 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11365 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11367 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11371 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11374 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11379 */     GIR_RootConstrainSelectedInstOperands,
     /*  11380 */     // GIR_Coverage, 22919,
     /*  11380 */     GIR_EraseRootFromParent_Done,
     /*  11381 */   // Label 374: @11381
     /*  11381 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(11415), // Rule ID 22982 //
     /*  11386 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11390 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11394 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11398 */     // MIs[1] Operand 1
     /*  11398 */     // No operand predicates
     /*  11398 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11400 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  11400 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rri),
     /*  11403 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11405 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11407 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  11410 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11413 */     GIR_RootConstrainSelectedInstOperands,
     /*  11414 */     // GIR_Coverage, 22982,
     /*  11414 */     GIR_EraseRootFromParent_Done,
     /*  11415 */   // Label 375: @11415
     /*  11415 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(11444), // Rule ID 22826 //
     /*  11420 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11423 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11427 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11431 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  11431 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr),
     /*  11436 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11442 */     GIR_RootConstrainSelectedInstOperands,
     /*  11443 */     // GIR_Coverage, 22826,
     /*  11443 */     GIR_Done,
     /*  11444 */   // Label 376: @11444
     /*  11444 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(11473), // Rule ID 22916 //
     /*  11449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11452 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11456 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  11460 */     // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  11460 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr_ND),
     /*  11465 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11471 */     GIR_RootConstrainSelectedInstOperands,
     /*  11472 */     // GIR_Coverage, 22916,
     /*  11472 */     GIR_Done,
     /*  11473 */   // Label 377: @11473
     /*  11473 */   GIM_Reject,
     /*  11474 */ // Label 369: @11474
     /*  11474 */ GIM_Reject,
     /*  11475 */ // Label 357: @11475
     /*  11475 */ GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(11891),
     /*  11480 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  11483 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  11486 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11490 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(11554), // Rule ID 22986 //
     /*  11495 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11499 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11503 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11506 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11510 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11514 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11518 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11522 */     // MIs[2] Operand 1
     /*  11522 */     // No operand predicates
     /*  11522 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11524 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11531 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rmi:{ *:[i32] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  11531 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rmi),
     /*  11534 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11536 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11540 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11543 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11546 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11552 */     GIR_RootConstrainSelectedInstOperands,
     /*  11553 */     // GIR_Coverage, 22986,
     /*  11553 */     GIR_EraseRootFromParent_Done,
     /*  11554 */   // Label 379: @11554
     /*  11554 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(11615), // Rule ID 26065 //
     /*  11559 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11562 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11566 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11570 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11573 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11577 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11581 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11585 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11587 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11594 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (IMUL32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11594 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm),
     /*  11597 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11599 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11601 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11605 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11608 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11613 */     GIR_RootConstrainSelectedInstOperands,
     /*  11614 */     // GIR_Coverage, 26065,
     /*  11614 */     GIR_EraseRootFromParent_Done,
     /*  11615 */   // Label 380: @11615
     /*  11615 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(11676), // Rule ID 26084 //
     /*  11620 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11623 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11627 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11631 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11634 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11638 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11642 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11646 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11648 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11655 */     // (mul:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (IMUL32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm_ND),
     /*  11658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11660 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  11662 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11666 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11669 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11674 */     GIR_RootConstrainSelectedInstOperands,
     /*  11675 */     // GIR_Coverage, 26084,
     /*  11675 */     GIR_EraseRootFromParent_Done,
     /*  11676 */   // Label 381: @11676
     /*  11676 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(11737), // Rule ID 22830 //
     /*  11681 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11684 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11688 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11692 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11696 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11699 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11703 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11707 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11709 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11716 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (IMUL32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11716 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm),
     /*  11719 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11721 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11723 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11727 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11730 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11735 */     GIR_RootConstrainSelectedInstOperands,
     /*  11736 */     // GIR_Coverage, 22830,
     /*  11736 */     GIR_EraseRootFromParent_Done,
     /*  11737 */   // Label 382: @11737
     /*  11737 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(11798), // Rule ID 22920 //
     /*  11742 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11745 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11749 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11753 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11757 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11760 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11764 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  11768 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11770 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11777 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (IMUL32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  11777 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rm_ND),
     /*  11780 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11782 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11784 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  11788 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11791 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  11796 */     GIR_RootConstrainSelectedInstOperands,
     /*  11797 */     // GIR_Coverage, 22920,
     /*  11797 */     GIR_EraseRootFromParent_Done,
     /*  11798 */   // Label 383: @11798
     /*  11798 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(11832), // Rule ID 22983 //
     /*  11803 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11807 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  11811 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11815 */     // MIs[1] Operand 1
     /*  11815 */     // No operand predicates
     /*  11815 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  11817 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  11817 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rri),
     /*  11820 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11822 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  11824 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  11827 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11830 */     GIR_RootConstrainSelectedInstOperands,
     /*  11831 */     // GIR_Coverage, 22983,
     /*  11831 */     GIR_EraseRootFromParent_Done,
     /*  11832 */   // Label 384: @11832
     /*  11832 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(11861), // Rule ID 22827 //
     /*  11837 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11840 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11844 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11848 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  11848 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr),
     /*  11853 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11859 */     GIR_RootConstrainSelectedInstOperands,
     /*  11860 */     // GIR_Coverage, 22827,
     /*  11860 */     GIR_Done,
     /*  11861 */   // Label 385: @11861
     /*  11861 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(11890), // Rule ID 22917 //
     /*  11866 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  11869 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11873 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  11877 */     // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  11877 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr_ND),
     /*  11882 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  11888 */     GIR_RootConstrainSelectedInstOperands,
     /*  11889 */     // GIR_Coverage, 22917,
     /*  11889 */     GIR_Done,
     /*  11890 */   // Label 386: @11890
     /*  11890 */   GIM_Reject,
     /*  11891 */ // Label 378: @11891
     /*  11891 */ GIM_Reject,
     /*  11892 */ // Label 358: @11892
     /*  11892 */ GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(12316),
     /*  11897 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  11900 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  11903 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  11907 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(11975), // Rule ID 22987 //
     /*  11912 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11916 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11920 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11923 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  11927 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  11931 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  11935 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  11939 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  11943 */     // MIs[2] Operand 1
     /*  11943 */     // No operand predicates
     /*  11943 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  11945 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  11952 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src1)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rmi32:{ *:[i64] }:{ *:[i32] } addr:{ *:[iPTR] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  11952 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rmi32),
     /*  11955 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  11957 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src1
     /*  11961 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // src2
     /*  11964 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  11967 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  11973 */     GIR_RootConstrainSelectedInstOperands,
     /*  11974 */     // GIR_Coverage, 22987,
     /*  11974 */     GIR_EraseRootFromParent_Done,
     /*  11975 */   // Label 388: @11975
     /*  11975 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(12036), // Rule ID 26066 //
     /*  11980 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  11983 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11987 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  11991 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  11994 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  11998 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12002 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12006 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12008 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12015 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (IMUL64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12015 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm),
     /*  12018 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12020 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12022 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12026 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12029 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12034 */     GIR_RootConstrainSelectedInstOperands,
     /*  12035 */     // GIR_Coverage, 26066,
     /*  12035 */     GIR_EraseRootFromParent_Done,
     /*  12036 */   // Label 389: @12036
     /*  12036 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(12097), // Rule ID 26085 //
     /*  12041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12052 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12055 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12059 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12063 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12067 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12069 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12076 */     // (mul:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (IMUL64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12076 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm_ND),
     /*  12079 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12081 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12083 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12087 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12090 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12095 */     GIR_RootConstrainSelectedInstOperands,
     /*  12096 */     // GIR_Coverage, 26085,
     /*  12096 */     GIR_EraseRootFromParent_Done,
     /*  12097 */   // Label 390: @12097
     /*  12097 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(12158), // Rule ID 22831 //
     /*  12102 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  12105 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12109 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12113 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12117 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12120 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12124 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12128 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12130 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12137 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (IMUL64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12137 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm),
     /*  12140 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12142 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12144 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12148 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12151 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12156 */     GIR_RootConstrainSelectedInstOperands,
     /*  12157 */     // GIR_Coverage, 22831,
     /*  12157 */     GIR_EraseRootFromParent_Done,
     /*  12158 */   // Label 391: @12158
     /*  12158 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(12219), // Rule ID 22921 //
     /*  12163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12166 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12170 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12174 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12178 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12181 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12185 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12189 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12191 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12198 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (IMUL64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12198 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rm_ND),
     /*  12201 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12203 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12205 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12209 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12212 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12217 */     GIR_RootConstrainSelectedInstOperands,
     /*  12218 */     // GIR_Coverage, 22921,
     /*  12218 */     GIR_EraseRootFromParent_Done,
     /*  12219 */   // Label 392: @12219
     /*  12219 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(12257), // Rule ID 22984 //
     /*  12224 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12228 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12232 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  12236 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  12240 */     // MIs[1] Operand 1
     /*  12240 */     // No operand predicates
     /*  12240 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12242 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  12242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rri32),
     /*  12245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12247 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12249 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  12252 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  12255 */     GIR_RootConstrainSelectedInstOperands,
     /*  12256 */     // GIR_Coverage, 22984,
     /*  12256 */     GIR_EraseRootFromParent_Done,
     /*  12257 */   // Label 393: @12257
     /*  12257 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(12286), // Rule ID 22828 //
     /*  12262 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  12265 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12269 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12273 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  12273 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr),
     /*  12278 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  12284 */     GIR_RootConstrainSelectedInstOperands,
     /*  12285 */     // GIR_Coverage, 22828,
     /*  12285 */     GIR_Done,
     /*  12286 */   // Label 394: @12286
     /*  12286 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(12315), // Rule ID 22918 //
     /*  12291 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  12294 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12298 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  12302 */     // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  12302 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr_ND),
     /*  12307 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  12313 */     GIR_RootConstrainSelectedInstOperands,
     /*  12314 */     // GIR_Coverage, 22918,
     /*  12314 */     GIR_Done,
     /*  12315 */   // Label 395: @12315
     /*  12315 */   GIM_Reject,
     /*  12316 */ // Label 387: @12316
     /*  12316 */ GIM_Reject,
     /*  12317 */ // Label 359: @12317
     /*  12317 */ GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(12645),
     /*  12322 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  12325 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  12328 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(12390), // Rule ID 23831 //
     /*  12333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12348 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12351 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12355 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12359 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12363 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12365 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12372 */     // (mul:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPMULLQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rm),
     /*  12375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12377 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12379 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12383 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12388 */     GIR_RootConstrainSelectedInstOperands,
     /*  12389 */     // GIR_Coverage, 23831,
     /*  12389 */     GIR_EraseRootFromParent_Done,
     /*  12390 */   // Label 397: @12390
     /*  12390 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(12452), // Rule ID 5021 //
     /*  12395 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12398 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12402 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12406 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12410 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12414 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12417 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12421 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12425 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12427 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12434 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12434 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rm),
     /*  12437 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12439 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12441 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12445 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12450 */     GIR_RootConstrainSelectedInstOperands,
     /*  12451 */     // GIR_Coverage, 5021,
     /*  12451 */     GIR_EraseRootFromParent_Done,
     /*  12452 */   // Label 398: @12452
     /*  12452 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(12479), // Rule ID 5018 //
     /*  12457 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  12460 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12464 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12468 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12472 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPMULLQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  12472 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rr),
     /*  12477 */     GIR_RootConstrainSelectedInstOperands,
     /*  12478 */     // GIR_Coverage, 5018,
     /*  12478 */     GIR_Done,
     /*  12479 */   // Label 399: @12479
     /*  12479 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(12644), // Rule ID 19998 //
     /*  12484 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_NoVLX),
     /*  12487 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
     /*  12491 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12495 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12499 */     // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src1, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src2, sub_xmm:{ *:[i32] })), sub_xmm:{ *:[i32] })
     /*  12499 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
     /*  12502 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  12506 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12511 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
     /*  12513 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
     /*  12516 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  12520 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12525 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  12528 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  12532 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
     /*  12535 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  12540 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12545 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
     /*  12550 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
     /*  12553 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  12557 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12562 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  12564 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
     /*  12567 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  12571 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12576 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  12579 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  12583 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
     /*  12586 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  12591 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12596 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
     /*  12601 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
     /*  12604 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  12608 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  12613 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  12616 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
     /*  12619 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  12621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  12624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12626 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
     /*  12633 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
     /*  12638 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  12643 */     // GIR_Coverage, 19998,
     /*  12643 */     GIR_EraseRootFromParent_Done,
     /*  12644 */   // Label 400: @12644
     /*  12644 */   GIM_Reject,
     /*  12645 */ // Label 396: @12645
     /*  12645 */ GIM_Reject,
     /*  12646 */ // Label 360: @12646
     /*  12646 */ GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(12987),
     /*  12651 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12654 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12657 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(12719), // Rule ID 23534 //
     /*  12662 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12665 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12669 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12673 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12677 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12680 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12684 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12688 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12692 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12694 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12701 */     // (mul:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPMULLDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12701 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDrm),
     /*  12704 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12706 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12708 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12712 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12717 */     GIR_RootConstrainSelectedInstOperands,
     /*  12718 */     // GIR_Coverage, 23534,
     /*  12718 */     GIR_EraseRootFromParent_Done,
     /*  12719 */   // Label 402: @12719
     /*  12719 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(12781), // Rule ID 23804 //
     /*  12724 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12727 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12731 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12735 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12739 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12742 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12746 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12750 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12754 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12756 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12763 */     // (mul:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPMULLDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rm),
     /*  12766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12768 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  12770 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12774 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12779 */     GIR_RootConstrainSelectedInstOperands,
     /*  12780 */     // GIR_Coverage, 23804,
     /*  12780 */     GIR_EraseRootFromParent_Done,
     /*  12781 */   // Label 403: @12781
     /*  12781 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(12843), // Rule ID 3238 //
     /*  12786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12789 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12793 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12797 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12801 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12805 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12808 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12812 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12816 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12818 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12825 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12825 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDrm),
     /*  12828 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12830 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12832 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12836 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12841 */     GIR_RootConstrainSelectedInstOperands,
     /*  12842 */     // GIR_Coverage, 3238,
     /*  12842 */     GIR_EraseRootFromParent_Done,
     /*  12843 */   // Label 404: @12843
     /*  12843 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(12905), // Rule ID 4976 //
     /*  12848 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12851 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12855 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12859 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  12863 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  12867 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  12870 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  12874 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  12878 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  12880 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  12887 */     // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  12887 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rm),
     /*  12890 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  12892 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  12894 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  12898 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  12903 */     GIR_RootConstrainSelectedInstOperands,
     /*  12904 */     // GIR_Coverage, 4976,
     /*  12904 */     GIR_EraseRootFromParent_Done,
     /*  12905 */   // Label 405: @12905
     /*  12905 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(12932), // Rule ID 3237 //
     /*  12910 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  12913 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12917 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12921 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12925 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  12925 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDrr),
     /*  12930 */     GIR_RootConstrainSelectedInstOperands,
     /*  12931 */     // GIR_Coverage, 3237,
     /*  12931 */     GIR_Done,
     /*  12932 */   // Label 406: @12932
     /*  12932 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(12959), // Rule ID 3245 //
     /*  12937 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
     /*  12940 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12944 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12948 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  12952 */     // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  12952 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLDrr),
     /*  12957 */     GIR_RootConstrainSelectedInstOperands,
     /*  12958 */     // GIR_Coverage, 3245,
     /*  12958 */     GIR_Done,
     /*  12959 */   // Label 407: @12959
     /*  12959 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(12986), // Rule ID 4973 //
     /*  12964 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  12967 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12971 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  12979 */     // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPMULLDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  12979 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rr),
     /*  12984 */     GIR_RootConstrainSelectedInstOperands,
     /*  12985 */     // GIR_Coverage, 4973,
     /*  12985 */     GIR_Done,
     /*  12986 */   // Label 408: @12986
     /*  12986 */   GIM_Reject,
     /*  12987 */ // Label 401: @12987
     /*  12987 */ GIM_Reject,
     /*  12988 */ // Label 361: @12988
     /*  12988 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(13304),
     /*  12993 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  12996 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  12999 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13003 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(13061), // Rule ID 23825 //
     /*  13008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  13011 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13015 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13019 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13022 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13026 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13030 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13034 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13036 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13043 */     // (mul:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPMULLQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13043 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rm),
     /*  13046 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13048 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13050 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13054 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13059 */     GIR_RootConstrainSelectedInstOperands,
     /*  13060 */     // GIR_Coverage, 23825,
     /*  13060 */     GIR_EraseRootFromParent_Done,
     /*  13061 */   // Label 410: @13061
     /*  13061 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(13119), // Rule ID 5012 //
     /*  13066 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  13069 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13073 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13077 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13081 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13084 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13088 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13092 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13094 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13101 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13101 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rm),
     /*  13104 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13106 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13108 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13112 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13117 */     GIR_RootConstrainSelectedInstOperands,
     /*  13118 */     // GIR_Coverage, 5012,
     /*  13118 */     GIR_EraseRootFromParent_Done,
     /*  13119 */   // Label 411: @13119
     /*  13119 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(13142), // Rule ID 5009 //
     /*  13124 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
     /*  13127 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13131 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13135 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPMULLQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  13135 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rr),
     /*  13140 */     GIR_RootConstrainSelectedInstOperands,
     /*  13141 */     // GIR_Coverage, 5009,
     /*  13141 */     GIR_Done,
     /*  13142 */   // Label 412: @13142
     /*  13142 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(13303), // Rule ID 19996 //
     /*  13147 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_NoVLX),
     /*  13150 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13154 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13158 */     // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src1, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src2, sub_ymm:{ *:[i32] })), sub_ymm:{ *:[i32] })
     /*  13158 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
     /*  13161 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13165 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13170 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
     /*  13172 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
     /*  13175 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13179 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13184 */     GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
     /*  13187 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  13191 */     GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
     /*  13194 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  13199 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13204 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13209 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
     /*  13212 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  13216 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13221 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  13223 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
     /*  13226 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  13230 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13235 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
     /*  13238 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  13242 */     GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
     /*  13245 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
     /*  13250 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13255 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13260 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
     /*  13263 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  13267 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  13272 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  13275 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
     /*  13278 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  13280 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  13283 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13285 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
     /*  13292 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
     /*  13297 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
     /*  13302 */     // GIR_Coverage, 19996,
     /*  13302 */     GIR_EraseRootFromParent_Done,
     /*  13303 */   // Label 413: @13303
     /*  13303 */   GIM_Reject,
     /*  13304 */ // Label 409: @13304
     /*  13304 */ GIM_Reject,
     /*  13305 */ // Label 362: @13305
     /*  13305 */ GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(13646),
     /*  13310 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  13313 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  13316 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(13378), // Rule ID 23459 //
     /*  13321 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13324 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13328 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13332 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13336 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13339 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13343 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13347 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13351 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13353 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13360 */     // (mul:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPMULLWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13360 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWrm),
     /*  13363 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13365 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13367 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13371 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13376 */     GIR_RootConstrainSelectedInstOperands,
     /*  13377 */     // GIR_Coverage, 23459,
     /*  13377 */     GIR_EraseRootFromParent_Done,
     /*  13378 */   // Label 415: @13378
     /*  13378 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(13440), // Rule ID 23816 //
     /*  13383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13390 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13394 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13398 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13401 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13405 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13409 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13415 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13422 */     // (mul:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPMULLWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13422 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rm),
     /*  13425 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13427 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13429 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13433 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13438 */     GIR_RootConstrainSelectedInstOperands,
     /*  13439 */     // GIR_Coverage, 23816,
     /*  13439 */     GIR_EraseRootFromParent_Done,
     /*  13440 */   // Label 416: @13440
     /*  13440 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(13502), // Rule ID 2569 //
     /*  13445 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13448 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13452 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13464 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13467 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13471 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13475 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13477 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13484 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13484 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWrm),
     /*  13487 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13489 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13491 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13495 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13500 */     GIR_RootConstrainSelectedInstOperands,
     /*  13501 */     // GIR_Coverage, 2569,
     /*  13501 */     GIR_EraseRootFromParent_Done,
     /*  13502 */   // Label 417: @13502
     /*  13502 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(13564), // Rule ID 4997 //
     /*  13507 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13510 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13514 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13518 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13522 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13526 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13529 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13533 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13537 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13539 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13546 */     // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13546 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rm),
     /*  13549 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13551 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13553 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13557 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13562 */     GIR_RootConstrainSelectedInstOperands,
     /*  13563 */     // GIR_Coverage, 4997,
     /*  13563 */     GIR_EraseRootFromParent_Done,
     /*  13564 */   // Label 418: @13564
     /*  13564 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(13591), // Rule ID 2568 //
     /*  13569 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
     /*  13572 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13576 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13580 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13584 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  13584 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWrr),
     /*  13589 */     GIR_RootConstrainSelectedInstOperands,
     /*  13590 */     // GIR_Coverage, 2568,
     /*  13590 */     GIR_Done,
     /*  13591 */   // Label 419: @13591
     /*  13591 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(13618), // Rule ID 2570 //
     /*  13596 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  13599 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13603 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13607 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  13611 */     // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  13611 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLWrr),
     /*  13616 */     GIR_RootConstrainSelectedInstOperands,
     /*  13617 */     // GIR_Coverage, 2570,
     /*  13617 */     GIR_Done,
     /*  13618 */   // Label 420: @13618
     /*  13618 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(13645), // Rule ID 4994 //
     /*  13623 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  13626 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13630 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13634 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  13638 */     // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPMULLWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  13638 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rr),
     /*  13643 */     GIR_RootConstrainSelectedInstOperands,
     /*  13644 */     // GIR_Coverage, 4994,
     /*  13644 */     GIR_Done,
     /*  13645 */   // Label 421: @13645
     /*  13645 */   GIM_Reject,
     /*  13646 */ // Label 414: @13646
     /*  13646 */ GIM_Reject,
     /*  13647 */ // Label 363: @13647
     /*  13647 */ GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(13961),
     /*  13652 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  13655 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  13658 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(13720), // Rule ID 23536 //
     /*  13663 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13666 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13670 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13674 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13678 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13681 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13685 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13689 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13695 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13702 */     // (mul:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPMULLDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13702 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrm),
     /*  13705 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13707 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13709 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13713 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13718 */     GIR_RootConstrainSelectedInstOperands,
     /*  13719 */     // GIR_Coverage, 23536,
     /*  13719 */     GIR_EraseRootFromParent_Done,
     /*  13720 */   // Label 423: @13720
     /*  13720 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(13782), // Rule ID 23798 //
     /*  13725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13728 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13732 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13736 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13740 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13743 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13747 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13751 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13755 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13757 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13764 */     // (mul:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPMULLDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rm),
     /*  13767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13769 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  13771 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13775 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13780 */     GIR_RootConstrainSelectedInstOperands,
     /*  13781 */     // GIR_Coverage, 23798,
     /*  13781 */     GIR_EraseRootFromParent_Done,
     /*  13782 */   // Label 424: @13782
     /*  13782 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(13844), // Rule ID 3242 //
     /*  13787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13794 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13798 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13802 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13806 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13809 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13813 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13817 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13819 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13826 */     // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13826 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrm),
     /*  13829 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13831 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13833 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13837 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13842 */     GIR_RootConstrainSelectedInstOperands,
     /*  13843 */     // GIR_Coverage, 3242,
     /*  13843 */     GIR_EraseRootFromParent_Done,
     /*  13844 */   // Label 425: @13844
     /*  13844 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(13906), // Rule ID 4967 //
     /*  13849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13852 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13856 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13860 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  13864 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13868 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13871 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  13875 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  13879 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  13881 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  13888 */     // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  13888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rm),
     /*  13891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  13893 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  13895 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  13899 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  13904 */     GIR_RootConstrainSelectedInstOperands,
     /*  13905 */     // GIR_Coverage, 4967,
     /*  13905 */     GIR_EraseRootFromParent_Done,
     /*  13906 */   // Label 426: @13906
     /*  13906 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(13933), // Rule ID 3241 //
     /*  13911 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  13914 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13918 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13922 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  13926 */     // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPMULLDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  13926 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrr),
     /*  13931 */     GIR_RootConstrainSelectedInstOperands,
     /*  13932 */     // GIR_Coverage, 3241,
     /*  13932 */     GIR_Done,
     /*  13933 */   // Label 427: @13933
     /*  13933 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(13960), // Rule ID 4964 //
     /*  13938 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  13941 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13945 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13949 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  13953 */     // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPMULLDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  13953 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rr),
     /*  13958 */     GIR_RootConstrainSelectedInstOperands,
     /*  13959 */     // GIR_Coverage, 4964,
     /*  13959 */     GIR_Done,
     /*  13960 */   // Label 428: @13960
     /*  13960 */   GIM_Reject,
     /*  13961 */ // Label 422: @13961
     /*  13961 */ GIM_Reject,
     /*  13962 */ // Label 364: @13962
     /*  13962 */ GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(14117),
     /*  13967 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  13970 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  13973 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  13977 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(14035), // Rule ID 23819 //
     /*  13982 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  13985 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13989 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  13993 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  13996 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14000 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14004 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14008 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14010 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14017 */     // (mul:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPMULLQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14017 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrm),
     /*  14020 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14022 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14024 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14028 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14033 */     GIR_RootConstrainSelectedInstOperands,
     /*  14034 */     // GIR_Coverage, 23819,
     /*  14034 */     GIR_EraseRootFromParent_Done,
     /*  14035 */   // Label 430: @14035
     /*  14035 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(14093), // Rule ID 5003 //
     /*  14040 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  14043 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14047 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14051 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14055 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14058 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14062 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14066 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14068 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14075 */     // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14075 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrm),
     /*  14078 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14080 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14082 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14086 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14091 */     GIR_RootConstrainSelectedInstOperands,
     /*  14092 */     // GIR_Coverage, 5003,
     /*  14092 */     GIR_EraseRootFromParent_Done,
     /*  14093 */   // Label 431: @14093
     /*  14093 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(14116), // Rule ID 5000 //
     /*  14098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  14101 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14105 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14109 */     // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPMULLQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  14109 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
     /*  14114 */     GIR_RootConstrainSelectedInstOperands,
     /*  14115 */     // GIR_Coverage, 5000,
     /*  14115 */     GIR_Done,
     /*  14116 */   // Label 432: @14116
     /*  14116 */   GIM_Reject,
     /*  14117 */ // Label 429: @14117
     /*  14117 */ GIM_Reject,
     /*  14118 */ // Label 365: @14118
     /*  14118 */ GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(14432),
     /*  14123 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  14126 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  14129 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(14191), // Rule ID 23461 //
     /*  14134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14137 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14141 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14145 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14149 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14152 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14156 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14160 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14164 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14166 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14173 */     // (mul:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPMULLWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrm),
     /*  14176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14178 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14180 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14184 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14189 */     GIR_RootConstrainSelectedInstOperands,
     /*  14190 */     // GIR_Coverage, 23461,
     /*  14190 */     GIR_EraseRootFromParent_Done,
     /*  14191 */   // Label 434: @14191
     /*  14191 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(14253), // Rule ID 23813 //
     /*  14196 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14199 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14203 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14207 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14211 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14214 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14218 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14222 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14226 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14228 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14235 */     // (mul:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPMULLWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14235 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rm),
     /*  14238 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14240 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14242 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14246 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14251 */     GIR_RootConstrainSelectedInstOperands,
     /*  14252 */     // GIR_Coverage, 23813,
     /*  14252 */     GIR_EraseRootFromParent_Done,
     /*  14253 */   // Label 435: @14253
     /*  14253 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(14315), // Rule ID 2573 //
     /*  14258 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14261 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14265 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14269 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14273 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14277 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14280 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14284 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14288 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14290 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14297 */     // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14297 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrm),
     /*  14300 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14302 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14304 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14308 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14313 */     GIR_RootConstrainSelectedInstOperands,
     /*  14314 */     // GIR_Coverage, 2573,
     /*  14314 */     GIR_EraseRootFromParent_Done,
     /*  14315 */   // Label 436: @14315
     /*  14315 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(14377), // Rule ID 4991 //
     /*  14320 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14323 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14327 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14331 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14335 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14339 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14342 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14346 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14350 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14352 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14359 */     // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14359 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rm),
     /*  14362 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14364 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14366 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14370 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14375 */     GIR_RootConstrainSelectedInstOperands,
     /*  14376 */     // GIR_Coverage, 4991,
     /*  14376 */     GIR_EraseRootFromParent_Done,
     /*  14377 */   // Label 437: @14377
     /*  14377 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(14404), // Rule ID 2572 //
     /*  14382 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
     /*  14385 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14389 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14393 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  14397 */     // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPMULLWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  14397 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrr),
     /*  14402 */     GIR_RootConstrainSelectedInstOperands,
     /*  14403 */     // GIR_Coverage, 2572,
     /*  14403 */     GIR_Done,
     /*  14404 */   // Label 438: @14404
     /*  14404 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(14431), // Rule ID 4988 //
     /*  14409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
     /*  14412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14416 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14420 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  14424 */     // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPMULLWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  14424 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rr),
     /*  14429 */     GIR_RootConstrainSelectedInstOperands,
     /*  14430 */     // GIR_Coverage, 4988,
     /*  14430 */     GIR_Done,
     /*  14431 */   // Label 439: @14431
     /*  14431 */   GIM_Reject,
     /*  14432 */ // Label 433: @14432
     /*  14432 */ GIM_Reject,
     /*  14433 */ // Label 366: @14433
     /*  14433 */ GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(14588),
     /*  14438 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  14441 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  14444 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14448 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(14506), // Rule ID 23792 //
     /*  14453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14464 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14467 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14471 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14475 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14479 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14481 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14488 */     // (mul:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPMULLDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14488 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrm),
     /*  14491 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14493 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14495 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14499 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14504 */     GIR_RootConstrainSelectedInstOperands,
     /*  14505 */     // GIR_Coverage, 23792,
     /*  14505 */     GIR_EraseRootFromParent_Done,
     /*  14506 */   // Label 441: @14506
     /*  14506 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(14564), // Rule ID 4958 //
     /*  14511 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14514 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14518 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14522 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14526 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14529 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14533 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14537 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14539 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14546 */     // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14546 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrm),
     /*  14549 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14551 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14553 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14557 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14562 */     GIR_RootConstrainSelectedInstOperands,
     /*  14563 */     // GIR_Coverage, 4958,
     /*  14563 */     GIR_EraseRootFromParent_Done,
     /*  14564 */   // Label 442: @14564
     /*  14564 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(14587), // Rule ID 4955 //
     /*  14569 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  14572 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14576 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14580 */     // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPMULLDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  14580 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrr),
     /*  14585 */     GIR_RootConstrainSelectedInstOperands,
     /*  14586 */     // GIR_Coverage, 4955,
     /*  14586 */     GIR_Done,
     /*  14587 */   // Label 443: @14587
     /*  14587 */   GIM_Reject,
     /*  14588 */ // Label 440: @14588
     /*  14588 */ GIM_Reject,
     /*  14589 */ // Label 367: @14589
     /*  14589 */ GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(14744),
     /*  14594 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  14597 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  14600 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14604 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(14662), // Rule ID 23810 //
     /*  14609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14612 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14616 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14620 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14623 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14627 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14631 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14635 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14637 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14644 */     // (mul:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPMULLWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14644 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrm),
     /*  14647 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14649 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  14651 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14655 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14660 */     GIR_RootConstrainSelectedInstOperands,
     /*  14661 */     // GIR_Coverage, 23810,
     /*  14661 */     GIR_EraseRootFromParent_Done,
     /*  14662 */   // Label 445: @14662
     /*  14662 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(14720), // Rule ID 4985 //
     /*  14667 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14670 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  14678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  14682 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  14685 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  14689 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  14693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  14695 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  14702 */     // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPMULLWZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  14702 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrm),
     /*  14705 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14707 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  14709 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  14713 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  14718 */     GIR_RootConstrainSelectedInstOperands,
     /*  14719 */     // GIR_Coverage, 4985,
     /*  14719 */     GIR_EraseRootFromParent_Done,
     /*  14720 */   // Label 446: @14720
     /*  14720 */   GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(14743), // Rule ID 4982 //
     /*  14725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  14728 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14732 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  14736 */     // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPMULLWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  14736 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrr),
     /*  14741 */     GIR_RootConstrainSelectedInstOperands,
     /*  14742 */     // GIR_Coverage, 4982,
     /*  14742 */     GIR_Done,
     /*  14743 */   // Label 447: @14743
     /*  14743 */   GIM_Reject,
     /*  14744 */ // Label 444: @14744
     /*  14744 */ GIM_Reject,
     /*  14745 */ // Label 368: @14745
     /*  14745 */ GIM_Reject,
     /*  14746 */ // Label 3: @14746
     /*  14746 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 471*/ GIMT_Encode4(25337),
     /*  14757 */ /*GILLT_s1*//*Label 448*/ GIMT_Encode4(14857),
     /*  14761 */ /*GILLT_s8*//*Label 449*/ GIMT_Encode4(15203),
     /*  14765 */ /*GILLT_s16*//*Label 450*/ GIMT_Encode4(15596),
     /*  14769 */ /*GILLT_s32*//*Label 451*/ GIMT_Encode4(16281),
     /*  14773 */ /*GILLT_s64*//*Label 452*/ GIMT_Encode4(18107), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14785 */ /*GILLT_v2s1*//*Label 453*/ GIMT_Encode4(19811),
     /*  14789 */ /*GILLT_v2s64*//*Label 454*/ GIMT_Encode4(20157),
     /*  14793 */ /*GILLT_v4s1*//*Label 455*/ GIMT_Encode4(20499),
     /*  14797 */ /*GILLT_v4s32*//*Label 456*/ GIMT_Encode4(20845),
     /*  14801 */ /*GILLT_v4s64*//*Label 457*/ GIMT_Encode4(21187),
     /*  14805 */ /*GILLT_v8s1*//*Label 458*/ GIMT_Encode4(21653),
     /*  14809 */ /*GILLT_v8s16*//*Label 459*/ GIMT_Encode4(22151),
     /*  14813 */ /*GILLT_v8s32*//*Label 460*/ GIMT_Encode4(22493),
     /*  14817 */ /*GILLT_v8s64*//*Label 461*/ GIMT_Encode4(22959),
     /*  14821 */ /*GILLT_v16s1*//*Label 462*/ GIMT_Encode4(23115),
     /*  14825 */ /*GILLT_v16s8*//*Label 463*/ GIMT_Encode4(23275),
     /*  14829 */ /*GILLT_v16s16*//*Label 464*/ GIMT_Encode4(23617),
     /*  14833 */ /*GILLT_v16s32*//*Label 465*/ GIMT_Encode4(24083),
     /*  14837 */ /*GILLT_v32s1*//*Label 466*/ GIMT_Encode4(24239),
     /*  14841 */ /*GILLT_v32s8*//*Label 467*/ GIMT_Encode4(24399),
     /*  14845 */ /*GILLT_v32s16*//*Label 468*/ GIMT_Encode4(24865),
     /*  14849 */ /*GILLT_v64s1*//*Label 469*/ GIMT_Encode4(25021),
     /*  14853 */ /*GILLT_v64s8*//*Label 470*/ GIMT_Encode4(25181),
     /*  14857 */ // Label 448: @14857
     /*  14857 */ GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(15202),
     /*  14862 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  14865 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  14868 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14872 */   GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(14992), // Rule ID 19488 //
     /*  14877 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14881 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14885 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  14889 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*  14893 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14898 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  14902 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14908 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  14910 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  14914 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  14916 */     // (and:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  14916 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  14919 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14923 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14928 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  14932 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  14937 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  14940 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14944 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14949 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  14953 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  14958 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  14961 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  14965 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  14970 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  14973 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  14976 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  14978 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  14981 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  14983 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  14986 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  14991 */     // GIR_Coverage, 19488,
     /*  14991 */     GIR_EraseRootFromParent_Done,
     /*  14992 */   // Label 473: @14992
     /*  14992 */   GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(15112), // Rule ID 25373 //
     /*  14997 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15001 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15005 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15009 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  15013 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*  15017 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15022 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15026 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15032 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  15034 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15036 */     // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  15036 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  15039 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15043 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15048 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  15052 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15057 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  15060 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15064 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15069 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  15073 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15078 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  15081 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  15085 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15090 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15093 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  15096 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  15098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15103 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15106 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  15111 */     // GIR_Coverage, 25373,
     /*  15111 */     GIR_EraseRootFromParent_Done,
     /*  15112 */   // Label 474: @15112
     /*  15112 */   GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(15201), // Rule ID 19484 //
     /*  15117 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15121 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  15125 */     // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  15125 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  15128 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15132 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15137 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  15141 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15146 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  15149 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15153 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15158 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  15162 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  15167 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  15170 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  15174 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15179 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15182 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  15185 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  15187 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  15190 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15192 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15195 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  15200 */     // GIR_Coverage, 19484,
     /*  15200 */     GIR_EraseRootFromParent_Done,
     /*  15201 */   // Label 475: @15201
     /*  15201 */   GIM_Reject,
     /*  15202 */ // Label 472: @15202
     /*  15202 */ GIM_Reject,
     /*  15203 */ // Label 449: @15203
     /*  15203 */ GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(15595),
     /*  15208 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*  15211 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*  15214 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15218 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(15279), // Rule ID 26075 //
     /*  15223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15234 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15237 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15241 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15245 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15249 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15251 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15258 */     // (and:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (AND8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15258 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm),
     /*  15261 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15263 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15265 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15269 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15272 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15277 */     GIR_RootConstrainSelectedInstOperands,
     /*  15278 */     // GIR_Coverage, 26075,
     /*  15278 */     GIR_EraseRootFromParent_Done,
     /*  15279 */   // Label 477: @15279
     /*  15279 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(15340), // Rule ID 26094 //
     /*  15284 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15287 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15291 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15295 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15298 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15302 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15306 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15310 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15312 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15319 */     // (and:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (AND8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15319 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm_ND),
     /*  15322 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15324 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15326 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15330 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15333 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15338 */     GIR_RootConstrainSelectedInstOperands,
     /*  15339 */     // GIR_Coverage, 26094,
     /*  15339 */     GIR_EraseRootFromParent_Done,
     /*  15340 */   // Label 478: @15340
     /*  15340 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(15401), // Rule ID 22860 //
     /*  15345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15348 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15360 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15363 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15367 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15371 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15373 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15380 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (AND8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15380 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm),
     /*  15383 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15385 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15387 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15391 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15394 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15399 */     GIR_RootConstrainSelectedInstOperands,
     /*  15400 */     // GIR_Coverage, 22860,
     /*  15400 */     GIR_EraseRootFromParent_Done,
     /*  15401 */   // Label 479: @15401
     /*  15401 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(15462), // Rule ID 22950 //
     /*  15406 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15409 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15413 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15417 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15421 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15424 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15428 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  15432 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15434 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15441 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (AND8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15441 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8rm_ND),
     /*  15444 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15446 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15448 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15452 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15455 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15460 */     GIR_RootConstrainSelectedInstOperands,
     /*  15461 */     // GIR_Coverage, 22950,
     /*  15461 */     GIR_EraseRootFromParent_Done,
     /*  15462 */   // Label 480: @15462
     /*  15462 */   GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(15499), // Rule ID 22864 //
     /*  15467 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15470 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15474 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15478 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15482 */     // MIs[1] Operand 1
     /*  15482 */     // No operand predicates
     /*  15482 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15484 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  15484 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri),
     /*  15487 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15489 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15491 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  15494 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15497 */     GIR_RootConstrainSelectedInstOperands,
     /*  15498 */     // GIR_Coverage, 22864,
     /*  15498 */     GIR_EraseRootFromParent_Done,
     /*  15499 */   // Label 481: @15499
     /*  15499 */   GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(15536), // Rule ID 22954 //
     /*  15504 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15507 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15511 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15515 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15519 */     // MIs[1] Operand 1
     /*  15519 */     // No operand predicates
     /*  15519 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15521 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  15521 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri_ND),
     /*  15524 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15526 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15528 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  15531 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15534 */     GIR_RootConstrainSelectedInstOperands,
     /*  15535 */     // GIR_Coverage, 22954,
     /*  15535 */     GIR_EraseRootFromParent_Done,
     /*  15536 */   // Label 482: @15536
     /*  15536 */   GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(15565), // Rule ID 22856 //
     /*  15541 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15544 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15548 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15552 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  15552 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr),
     /*  15557 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  15563 */     GIR_RootConstrainSelectedInstOperands,
     /*  15564 */     // GIR_Coverage, 22856,
     /*  15564 */     GIR_Done,
     /*  15565 */   // Label 483: @15565
     /*  15565 */   GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(15594), // Rule ID 22946 //
     /*  15570 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15573 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15577 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15581 */     // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  15581 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr_ND),
     /*  15586 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  15592 */     GIR_RootConstrainSelectedInstOperands,
     /*  15593 */     // GIR_Coverage, 22946,
     /*  15593 */     GIR_Done,
     /*  15594 */   // Label 484: @15594
     /*  15594 */   GIM_Reject,
     /*  15595 */ // Label 476: @15595
     /*  15595 */ GIM_Reject,
     /*  15596 */ // Label 450: @15596
     /*  15596 */ GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(16280),
     /*  15601 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  15604 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  15607 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15611 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(15672), // Rule ID 26076 //
     /*  15616 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15619 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15623 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15627 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15630 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15634 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15638 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15642 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15644 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15651 */     // (and:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (AND16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15651 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm),
     /*  15654 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15656 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15658 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15662 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15665 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15670 */     GIR_RootConstrainSelectedInstOperands,
     /*  15671 */     // GIR_Coverage, 26076,
     /*  15671 */     GIR_EraseRootFromParent_Done,
     /*  15672 */   // Label 486: @15672
     /*  15672 */   GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(15733), // Rule ID 26095 //
     /*  15677 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15680 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15684 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15688 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15691 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15695 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15699 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15703 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15705 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15712 */     // (and:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (AND16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15712 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm_ND),
     /*  15715 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15717 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15719 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15723 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15726 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15731 */     GIR_RootConstrainSelectedInstOperands,
     /*  15732 */     // GIR_Coverage, 26095,
     /*  15732 */     GIR_EraseRootFromParent_Done,
     /*  15733 */   // Label 487: @15733
     /*  15733 */   GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(15794), // Rule ID 22861 //
     /*  15738 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  15741 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15745 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15749 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15753 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15756 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15760 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15764 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15766 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15773 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (AND16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15773 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm),
     /*  15776 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15778 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15780 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15784 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15787 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15792 */     GIR_RootConstrainSelectedInstOperands,
     /*  15793 */     // GIR_Coverage, 22861,
     /*  15793 */     GIR_EraseRootFromParent_Done,
     /*  15794 */   // Label 488: @15794
     /*  15794 */   GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(15855), // Rule ID 22951 //
     /*  15799 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  15802 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15806 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15810 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  15814 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  15817 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  15821 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  15825 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15827 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  15834 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (AND16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  15834 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16rm_ND),
     /*  15837 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15839 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  15841 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  15845 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15848 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  15853 */     GIR_RootConstrainSelectedInstOperands,
     /*  15854 */     // GIR_Coverage, 22951,
     /*  15854 */     GIR_EraseRootFromParent_Done,
     /*  15855 */   // Label 489: @15855
     /*  15855 */   GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(15957), // Rule ID 26042 //
     /*  15860 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15864 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  15868 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15872 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  15876 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  15880 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15885 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15889 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15891 */     // (and:{ *:[i16] } (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  15891 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  15894 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  15898 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15903 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  15905 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  15908 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  15912 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  15917 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  15920 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  15924 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  15927 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  15932 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  15937 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  15942 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
     /*  15945 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  15947 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  15949 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  15952 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  15955 */     GIR_RootConstrainSelectedInstOperands,
     /*  15956 */     // GIR_Coverage, 26042,
     /*  15956 */     GIR_EraseRootFromParent_Done,
     /*  15957 */   // Label 490: @15957
     /*  15957 */   GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(16059), // Rule ID 22780 //
     /*  15962 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  15966 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15970 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  15974 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15978 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  15982 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  15986 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  15991 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15993 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  15993 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  15996 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  16000 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16005 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  16007 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  16010 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  16014 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16019 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  16022 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  16026 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  16029 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  16034 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  16039 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  16044 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
     /*  16047 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16049 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16051 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  16054 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16057 */     GIR_RootConstrainSelectedInstOperands,
     /*  16058 */     // GIR_Coverage, 22780,
     /*  16058 */     GIR_EraseRootFromParent_Done,
     /*  16059 */   // Label 491: @16059
     /*  16059 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(16147), // Rule ID 22640 //
     /*  16064 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16068 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  16079 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, 255:{ *:[i16] })  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src1, sub_8bit:{ *:[i32] })), sub_16bit:{ *:[i32] })
     /*  16079 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s8,
     /*  16082 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  16086 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16091 */     GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
     /*  16097 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
     /*  16102 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  16107 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  16110 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
     /*  16114 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  16119 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  16122 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  16124 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  16127 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16129 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
     /*  16136 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  16141 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  16146 */     // GIR_Coverage, 22640,
     /*  16146 */     GIR_EraseRootFromParent_Done,
     /*  16147 */   // Label 492: @16147
     /*  16147 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(16184), // Rule ID 22865 //
     /*  16152 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16155 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16159 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16163 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16167 */     // MIs[1] Operand 1
     /*  16167 */     // No operand predicates
     /*  16167 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16169 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  16169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri),
     /*  16172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16174 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16176 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  16179 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16182 */     GIR_RootConstrainSelectedInstOperands,
     /*  16183 */     // GIR_Coverage, 22865,
     /*  16183 */     GIR_EraseRootFromParent_Done,
     /*  16184 */   // Label 493: @16184
     /*  16184 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(16221), // Rule ID 22955 //
     /*  16189 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16192 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16196 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16200 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  16204 */     // MIs[1] Operand 1
     /*  16204 */     // No operand predicates
     /*  16204 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16206 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  16206 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri_ND),
     /*  16209 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16211 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16213 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  16216 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16219 */     GIR_RootConstrainSelectedInstOperands,
     /*  16220 */     // GIR_Coverage, 22955,
     /*  16220 */     GIR_EraseRootFromParent_Done,
     /*  16221 */   // Label 494: @16221
     /*  16221 */   GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(16250), // Rule ID 22857 //
     /*  16226 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16229 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16233 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16237 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  16237 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr),
     /*  16242 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  16248 */     GIR_RootConstrainSelectedInstOperands,
     /*  16249 */     // GIR_Coverage, 22857,
     /*  16249 */     GIR_Done,
     /*  16250 */   // Label 495: @16250
     /*  16250 */   GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(16279), // Rule ID 22947 //
     /*  16255 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16258 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16262 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  16266 */     // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  16266 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr_ND),
     /*  16271 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  16277 */     GIR_RootConstrainSelectedInstOperands,
     /*  16278 */     // GIR_Coverage, 22947,
     /*  16278 */     GIR_Done,
     /*  16279 */   // Label 496: @16279
     /*  16279 */   GIM_Reject,
     /*  16280 */ // Label 485: @16280
     /*  16280 */ GIM_Reject,
     /*  16281 */ // Label 451: @16281
     /*  16281 */ GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(18106),
     /*  16286 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  16289 */   GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(16381), // Rule ID 17546 //
     /*  16294 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  16297 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16304 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16308 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16312 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16316 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16320 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16325 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  16329 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16333 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16337 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16340 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  16344 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16348 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16350 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16357 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ANDN32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16357 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm),
     /*  16360 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16362 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  16366 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16370 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16373 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16379 */     GIR_RootConstrainSelectedInstOperands,
     /*  16380 */     // GIR_Coverage, 17546,
     /*  16380 */     GIR_EraseRootFromParent_Done,
     /*  16381 */   // Label 498: @16381
     /*  16381 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(16473), // Rule ID 17550 //
     /*  16386 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  16389 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16392 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16396 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16400 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16404 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16408 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16412 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16417 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  16421 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16425 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16429 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16432 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  16436 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16440 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16442 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16449 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (ANDN32rm_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16449 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm_EVEX),
     /*  16452 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  16458 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16462 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16465 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16471 */     GIR_RootConstrainSelectedInstOperands,
     /*  16472 */     // GIR_Coverage, 17550,
     /*  16472 */     GIR_EraseRootFromParent_Done,
     /*  16473 */   // Label 499: @16473
     /*  16473 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(16565), // Rule ID 25109 //
     /*  16478 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  16481 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16484 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16496 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16499 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16503 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16507 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16511 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16515 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16519 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16523 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16528 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  16532 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16534 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16541 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16541 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm),
     /*  16544 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16546 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  16550 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16554 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16557 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16563 */     GIR_RootConstrainSelectedInstOperands,
     /*  16564 */     // GIR_Coverage, 25109,
     /*  16564 */     GIR_EraseRootFromParent_Done,
     /*  16565 */   // Label 500: @16565
     /*  16565 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(16657), // Rule ID 25113 //
     /*  16570 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  16573 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16576 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16580 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16584 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16588 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16591 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16595 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16599 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16603 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16607 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16611 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16615 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16620 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  16624 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16626 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16633 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rm_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16633 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rm_EVEX),
     /*  16636 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16638 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  16642 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16646 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16649 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  16655 */     GIR_RootConstrainSelectedInstOperands,
     /*  16656 */     // GIR_Coverage, 25113,
     /*  16656 */     GIR_EraseRootFromParent_Done,
     /*  16657 */   // Label 501: @16657
     /*  16657 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(16725), // Rule ID 26077 //
     /*  16662 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16665 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16668 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16672 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16676 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16680 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16683 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16687 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16691 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16695 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16697 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16704 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (AND32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm),
     /*  16707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16709 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  16711 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16715 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16718 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16723 */     GIR_RootConstrainSelectedInstOperands,
     /*  16724 */     // GIR_Coverage, 26077,
     /*  16724 */     GIR_EraseRootFromParent_Done,
     /*  16725 */   // Label 502: @16725
     /*  16725 */   GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(16793), // Rule ID 26096 //
     /*  16730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16733 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16736 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16740 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16744 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16748 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16751 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16755 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16759 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16763 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16765 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16772 */     // (and:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (AND32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16772 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm_ND),
     /*  16775 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16777 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  16779 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16783 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16786 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16791 */     GIR_RootConstrainSelectedInstOperands,
     /*  16792 */     // GIR_Coverage, 26096,
     /*  16792 */     GIR_EraseRootFromParent_Done,
     /*  16793 */   // Label 503: @16793
     /*  16793 */   GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(16861), // Rule ID 22862 //
     /*  16798 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  16801 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16804 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16808 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16812 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16816 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16820 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16823 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16827 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16831 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16833 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16840 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (AND32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16840 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm),
     /*  16843 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16845 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16847 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16851 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16854 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16859 */     GIR_RootConstrainSelectedInstOperands,
     /*  16860 */     // GIR_Coverage, 22862,
     /*  16860 */     GIR_EraseRootFromParent_Done,
     /*  16861 */   // Label 504: @16861
     /*  16861 */   GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(16929), // Rule ID 22952 //
     /*  16866 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  16869 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16872 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16876 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16880 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16884 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  16888 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  16891 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  16895 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  16899 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16901 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  16908 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (AND32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  16908 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32rm_ND),
     /*  16911 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16913 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  16915 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  16919 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  16922 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  16927 */     GIR_RootConstrainSelectedInstOperands,
     /*  16928 */     // GIR_Coverage, 22952,
     /*  16928 */     GIR_EraseRootFromParent_Done,
     /*  16929 */   // Label 505: @16929
     /*  16929 */   GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(17006), // Rule ID 25001 //
     /*  16934 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  16937 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16940 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16944 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16948 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16952 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  16956 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16960 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  16965 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  16969 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  16973 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16977 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16981 */     // MIs[2] src
     /*  16981 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16986 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  16990 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  16992 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  16992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
     /*  16995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  16997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17001 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17004 */     GIR_RootConstrainSelectedInstOperands,
     /*  17005 */     // GIR_Coverage, 25001,
     /*  17005 */     GIR_EraseRootFromParent_Done,
     /*  17006 */   // Label 506: @17006
     /*  17006 */   GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(17083), // Rule ID 25013 //
     /*  17011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17014 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17017 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17021 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17025 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17029 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17033 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17037 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17042 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17046 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17050 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17054 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17058 */     // MIs[2] src
     /*  17058 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17063 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  17067 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17069 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17069 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
     /*  17072 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17078 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17081 */     GIR_RootConstrainSelectedInstOperands,
     /*  17082 */     // GIR_Coverage, 25013,
     /*  17082 */     GIR_EraseRootFromParent_Done,
     /*  17083 */   // Label 507: @17083
     /*  17083 */   GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(17160), // Rule ID 17354 //
     /*  17088 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17091 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17094 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17098 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17102 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17106 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17110 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17114 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17119 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17123 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17127 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17131 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17135 */     // MIs[2] src
     /*  17135 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17140 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  17144 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17146 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17146 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
     /*  17149 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17151 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17155 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17158 */     GIR_RootConstrainSelectedInstOperands,
     /*  17159 */     // GIR_Coverage, 17354,
     /*  17159 */     GIR_EraseRootFromParent_Done,
     /*  17160 */   // Label 508: @17160
     /*  17160 */   GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(17237), // Rule ID 17366 //
     /*  17165 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17168 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17171 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17175 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17179 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17183 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17187 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17191 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17196 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17200 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  17204 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17208 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17212 */     // MIs[2] src
     /*  17212 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17217 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  17221 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  17223 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17223 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
     /*  17226 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17228 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17232 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17235 */     GIR_RootConstrainSelectedInstOperands,
     /*  17236 */     // GIR_Coverage, 17366,
     /*  17236 */     GIR_EraseRootFromParent_Done,
     /*  17237 */   // Label 509: @17237
     /*  17237 */   GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(17295), // Rule ID 24995 //
     /*  17242 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17245 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17249 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17253 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17257 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17261 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17265 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17270 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  17274 */     // MIs[0] src
     /*  17274 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17279 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17281 */     // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17281 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
     /*  17284 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17286 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  17290 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17293 */     GIR_RootConstrainSelectedInstOperands,
     /*  17294 */     // GIR_Coverage, 24995,
     /*  17294 */     GIR_EraseRootFromParent_Done,
     /*  17295 */   // Label 510: @17295
     /*  17295 */   GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(17404), // Rule ID 26048 //
     /*  17300 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17303 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17307 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17311 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  17315 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17319 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  17323 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  17327 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  17332 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17336 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17338 */     // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  17338 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17341 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  17345 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17350 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  17352 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17355 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  17359 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17364 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17367 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  17371 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  17374 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17379 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17384 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  17389 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
     /*  17392 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17394 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  17396 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17399 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17402 */     GIR_RootConstrainSelectedInstOperands,
     /*  17403 */     // GIR_Coverage, 26048,
     /*  17403 */     GIR_EraseRootFromParent_Done,
     /*  17404 */   // Label 511: @17404
     /*  17404 */   GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(17458), // Rule ID 17348 //
     /*  17409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  17412 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17415 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17419 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17423 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17427 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17431 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17435 */     // MIs[1] src
     /*  17435 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  17440 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  17444 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17446 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  17446 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
     /*  17449 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17451 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  17453 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17456 */     GIR_RootConstrainSelectedInstOperands,
     /*  17457 */     // GIR_Coverage, 17348,
     /*  17457 */     GIR_EraseRootFromParent_Done,
     /*  17458 */   // Label 512: @17458
     /*  17458 */   GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(17567), // Rule ID 22786 //
     /*  17463 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17466 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17470 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17474 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17478 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  17482 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17486 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  17490 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  17494 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  17499 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17501 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  17501 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  17504 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  17508 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17513 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  17515 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  17518 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  17522 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17527 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  17530 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  17534 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  17537 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17542 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  17547 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  17552 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
     /*  17555 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17557 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17559 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17562 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17565 */     GIR_RootConstrainSelectedInstOperands,
     /*  17566 */     // GIR_Coverage, 22786,
     /*  17566 */     GIR_EraseRootFromParent_Done,
     /*  17567 */   // Label 513: @17567
     /*  17567 */   GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(17632), // Rule ID 22638 //
     /*  17572 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17575 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17579 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17583 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
     /*  17594 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 65535:{ *:[i32] })  =>  (MOVZX32rr16:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src1, sub_16bit:{ *:[i32] }))
     /*  17594 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  17597 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17601 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17606 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src1
     /*  17612 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  17617 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  17622 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
     /*  17625 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17627 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17630 */     GIR_RootConstrainSelectedInstOperands,
     /*  17631 */     // GIR_Coverage, 22638,
     /*  17631 */     GIR_EraseRootFromParent_Done,
     /*  17632 */   // Label 514: @17632
     /*  17632 */   GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(17697), // Rule ID 22639 //
     /*  17637 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17640 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17644 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17648 */     GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
     /*  17659 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 255:{ *:[i32] })  =>  (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src1, sub_8bit:{ *:[i32] }))
     /*  17659 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s8,
     /*  17662 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  17666 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  17671 */     GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
     /*  17677 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
     /*  17682 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
     /*  17687 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
     /*  17690 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17692 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  17695 */     GIR_RootConstrainSelectedInstOperands,
     /*  17696 */     // GIR_Coverage, 22639,
     /*  17696 */     GIR_EraseRootFromParent_Done,
     /*  17697 */   // Label 515: @17697
     /*  17697 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(17741), // Rule ID 22866 //
     /*  17702 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  17705 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17708 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17712 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17716 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17720 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17724 */     // MIs[1] Operand 1
     /*  17724 */     // No operand predicates
     /*  17724 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17726 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  17726 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri),
     /*  17729 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17731 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17733 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  17736 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17739 */     GIR_RootConstrainSelectedInstOperands,
     /*  17740 */     // GIR_Coverage, 22866,
     /*  17740 */     GIR_EraseRootFromParent_Done,
     /*  17741 */   // Label 516: @17741
     /*  17741 */   GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(17785), // Rule ID 22956 //
     /*  17746 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  17749 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17752 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17756 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  17768 */     // MIs[1] Operand 1
     /*  17768 */     // No operand predicates
     /*  17768 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17770 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  17770 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri_ND),
     /*  17773 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17775 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  17777 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  17780 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17783 */     GIR_RootConstrainSelectedInstOperands,
     /*  17784 */     // GIR_Coverage, 22956,
     /*  17784 */     GIR_EraseRootFromParent_Done,
     /*  17785 */   // Label 517: @17785
     /*  17785 */   GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(17847), // Rule ID 17544 //
     /*  17790 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  17793 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17812 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17816 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17821 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17825 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17829 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17831 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
     /*  17834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17840 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  17842 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17845 */     GIR_RootConstrainSelectedInstOperands,
     /*  17846 */     // GIR_Coverage, 17544,
     /*  17846 */     GIR_EraseRootFromParent_Done,
     /*  17847 */   // Label 518: @17847
     /*  17847 */   GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(17909), // Rule ID 17548 //
     /*  17852 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  17855 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17858 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17862 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17866 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17870 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17874 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17878 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17883 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17887 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17891 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17893 */     // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17893 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
     /*  17896 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17902 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  17904 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17907 */     GIR_RootConstrainSelectedInstOperands,
     /*  17908 */     // GIR_Coverage, 17548,
     /*  17908 */     GIR_EraseRootFromParent_Done,
     /*  17909 */   // Label 519: @17909
     /*  17909 */   GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(17971), // Rule ID 25107 //
     /*  17914 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  17917 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17920 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17924 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17928 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17932 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17936 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  17940 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17944 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17949 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  17953 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  17955 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  17955 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
     /*  17958 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  17960 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  17964 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  17966 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  17969 */     GIR_RootConstrainSelectedInstOperands,
     /*  17970 */     // GIR_Coverage, 25107,
     /*  17970 */     GIR_EraseRootFromParent_Done,
     /*  17971 */   // Label 520: @17971
     /*  17971 */   GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(18033), // Rule ID 25111 //
     /*  17976 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  17979 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  17982 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17986 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  17990 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  17994 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17998 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  18002 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18006 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18011 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  18015 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18017 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18017 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
     /*  18020 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18022 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18026 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  18028 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18031 */     GIR_RootConstrainSelectedInstOperands,
     /*  18032 */     // GIR_Coverage, 25111,
     /*  18032 */     GIR_EraseRootFromParent_Done,
     /*  18033 */   // Label 521: @18033
     /*  18033 */   GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(18069), // Rule ID 22858 //
     /*  18038 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18041 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  18044 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18048 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18052 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18056 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18056 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr),
     /*  18061 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  18067 */     GIR_RootConstrainSelectedInstOperands,
     /*  18068 */     // GIR_Coverage, 22858,
     /*  18068 */     GIR_Done,
     /*  18069 */   // Label 522: @18069
     /*  18069 */   GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(18105), // Rule ID 22948 //
     /*  18074 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18077 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  18080 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18084 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18088 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  18092 */     // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  18092 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr_ND),
     /*  18097 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  18103 */     GIR_RootConstrainSelectedInstOperands,
     /*  18104 */     // GIR_Coverage, 22948,
     /*  18104 */     GIR_Done,
     /*  18105 */   // Label 523: @18105
     /*  18105 */   GIM_Reject,
     /*  18106 */ // Label 497: @18106
     /*  18106 */ GIM_Reject,
     /*  18107 */ // Label 452: @18107
     /*  18107 */ GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(19810),
     /*  18112 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  18115 */   GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(18207), // Rule ID 17547 //
     /*  18120 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  18123 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18126 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18130 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18134 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18138 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18142 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18146 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18151 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  18155 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18159 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18163 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18166 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/2, /*MMO*/0, /*OpIdx*/0,
     /*  18170 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  18174 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18176 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18183 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ANDN64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18183 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm),
     /*  18186 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18188 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18192 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18196 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18199 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18205 */     GIR_RootConstrainSelectedInstOperands,
     /*  18206 */     // GIR_Coverage, 17547,
     /*  18206 */     GIR_EraseRootFromParent_Done,
     /*  18207 */   // Label 525: @18207
     /*  18207 */   GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(18299), // Rule ID 17551 //
     /*  18212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  18215 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18218 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18222 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18226 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18230 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18234 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18238 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18243 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  18247 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18251 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18255 */     GIM_CheckAtomicOrdering, /*MI*/2, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18258 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/2, /*MMO*/0, /*OpIdx*/0,
     /*  18262 */     GIM_CheckPointerToAny, /*MI*/2, /*Op*/1, /*SizeInBits*/0,
     /*  18266 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18268 */     GIM_CheckComplexPattern, /*MI*/2, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18275 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (ANDN64rm_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18275 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm_EVEX),
     /*  18278 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  18284 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18288 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18291 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18297 */     GIR_RootConstrainSelectedInstOperands,
     /*  18298 */     // GIR_Coverage, 17551,
     /*  18298 */     GIR_EraseRootFromParent_Done,
     /*  18299 */   // Label 526: @18299
     /*  18299 */   GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(18391), // Rule ID 25110 //
     /*  18304 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  18307 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18310 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18314 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18318 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18322 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18325 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18329 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18333 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18337 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18341 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  18345 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18349 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18354 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  18358 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18360 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18367 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18367 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm),
     /*  18370 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18372 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  18376 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18380 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18383 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18389 */     GIR_RootConstrainSelectedInstOperands,
     /*  18390 */     // GIR_Coverage, 25110,
     /*  18390 */     GIR_EraseRootFromParent_Done,
     /*  18391 */   // Label 527: @18391
     /*  18391 */   GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(18483), // Rule ID 25114 //
     /*  18396 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  18399 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18402 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18406 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18410 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18414 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18417 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18421 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18425 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18429 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18433 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  18437 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18441 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18446 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  18450 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18452 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18459 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rm_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18459 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rm_EVEX),
     /*  18462 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18464 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  18468 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18472 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18475 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/3, /*MergeInsnID's*/0, 1, 2,
     /*  18481 */     GIR_RootConstrainSelectedInstOperands,
     /*  18482 */     // GIR_Coverage, 25114,
     /*  18482 */     GIR_EraseRootFromParent_Done,
     /*  18483 */   // Label 528: @18483
     /*  18483 */   GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(18551), // Rule ID 26078 //
     /*  18488 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18491 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18494 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18498 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18502 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18506 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18509 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18513 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18517 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18521 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18523 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18530 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (AND64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18530 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm),
     /*  18533 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18535 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  18537 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18541 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18544 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18549 */     GIR_RootConstrainSelectedInstOperands,
     /*  18550 */     // GIR_Coverage, 26078,
     /*  18550 */     GIR_EraseRootFromParent_Done,
     /*  18551 */   // Label 529: @18551
     /*  18551 */   GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(18619), // Rule ID 26097 //
     /*  18556 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18559 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18562 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18566 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18570 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18574 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18577 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18581 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18585 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18589 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18591 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18598 */     // (and:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (AND64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18598 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm_ND),
     /*  18601 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18603 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  18605 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18609 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18612 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18617 */     GIR_RootConstrainSelectedInstOperands,
     /*  18618 */     // GIR_Coverage, 26097,
     /*  18618 */     GIR_EraseRootFromParent_Done,
     /*  18619 */   // Label 530: @18619
     /*  18619 */   GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(18687), // Rule ID 22863 //
     /*  18624 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  18627 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18630 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18634 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18638 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18642 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18646 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18649 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18653 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18657 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18659 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18666 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (AND64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18666 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm),
     /*  18669 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18671 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  18673 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18677 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18680 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18685 */     GIR_RootConstrainSelectedInstOperands,
     /*  18686 */     // GIR_Coverage, 22863,
     /*  18686 */     GIR_EraseRootFromParent_Done,
     /*  18687 */   // Label 531: @18687
     /*  18687 */   GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(18755), // Rule ID 22953 //
     /*  18692 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  18695 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18702 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18706 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  18710 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  18714 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  18717 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  18721 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  18725 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  18727 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  18734 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (AND64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  18734 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64rm_ND),
     /*  18737 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18739 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  18741 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  18745 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18748 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  18753 */     GIR_RootConstrainSelectedInstOperands,
     /*  18754 */     // GIR_Coverage, 22953,
     /*  18754 */     GIR_EraseRootFromParent_Done,
     /*  18755 */   // Label 532: @18755
     /*  18755 */   GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(18832), // Rule ID 25002 //
     /*  18760 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18763 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18766 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18770 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18774 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18778 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18782 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18786 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18791 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  18795 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18799 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18803 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18807 */     // MIs[2] src
     /*  18807 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18812 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  18816 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18818 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
     /*  18821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18823 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18827 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18830 */     GIR_RootConstrainSelectedInstOperands,
     /*  18831 */     // GIR_Coverage, 25002,
     /*  18831 */     GIR_EraseRootFromParent_Done,
     /*  18832 */   // Label 533: @18832
     /*  18832 */   GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(18909), // Rule ID 25014 //
     /*  18837 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18840 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18843 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18847 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18851 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18855 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18859 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18863 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18868 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  18872 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18876 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18880 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18884 */     // MIs[2] src
     /*  18884 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18889 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  18893 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18895 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18895 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
     /*  18898 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18904 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18907 */     GIR_RootConstrainSelectedInstOperands,
     /*  18908 */     // GIR_Coverage, 25014,
     /*  18908 */     GIR_EraseRootFromParent_Done,
     /*  18909 */   // Label 534: @18909
     /*  18909 */   GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(18986), // Rule ID 17355 //
     /*  18914 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18917 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18920 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18924 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18928 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18932 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  18936 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  18940 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  18945 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  18949 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  18953 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18957 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  18961 */     // MIs[2] src
     /*  18961 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18966 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  18970 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  18972 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  18972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
     /*  18975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  18977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  18981 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  18984 */     GIR_RootConstrainSelectedInstOperands,
     /*  18985 */     // GIR_Coverage, 17355,
     /*  18985 */     GIR_EraseRootFromParent_Done,
     /*  18986 */   // Label 535: @18986
     /*  18986 */   GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(19063), // Rule ID 17367 //
     /*  18991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  18994 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  18997 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19001 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19005 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19009 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19013 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19017 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19022 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  19026 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  19030 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19034 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  19038 */     // MIs[2] src
     /*  19038 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19043 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  19047 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19049 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19049 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
     /*  19052 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19054 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  19058 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19061 */     GIR_RootConstrainSelectedInstOperands,
     /*  19062 */     // GIR_Coverage, 17367,
     /*  19062 */     GIR_EraseRootFromParent_Done,
     /*  19063 */   // Label 536: @19063
     /*  19063 */   GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(19121), // Rule ID 24996 //
     /*  19068 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  19071 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19075 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19079 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19083 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19087 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19091 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19096 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  19100 */     // MIs[0] src
     /*  19100 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19105 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19107 */     // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19107 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
     /*  19110 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19112 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  19116 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19119 */     GIR_RootConstrainSelectedInstOperands,
     /*  19120 */     // GIR_Coverage, 24996,
     /*  19120 */     GIR_EraseRootFromParent_Done,
     /*  19121 */   // Label 537: @19121
     /*  19121 */   GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(19230), // Rule ID 26054 //
     /*  19126 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19129 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19133 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19137 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  19141 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19145 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  19149 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  19153 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  19158 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19162 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19164 */     // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  19164 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  19167 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  19171 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19176 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  19178 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  19181 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  19185 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19190 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19193 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  19197 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  19200 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19205 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19210 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  19215 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
     /*  19218 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19220 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  19222 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19225 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19228 */     GIR_RootConstrainSelectedInstOperands,
     /*  19229 */     // GIR_Coverage, 26054,
     /*  19229 */     GIR_EraseRootFromParent_Done,
     /*  19230 */   // Label 538: @19230
     /*  19230 */   GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(19284), // Rule ID 17349 //
     /*  19235 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  19238 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19241 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19245 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19249 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19253 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19257 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19261 */     // MIs[1] src
     /*  19261 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  19266 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  19270 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19272 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  19272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
     /*  19275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19277 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  19279 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19282 */     GIR_RootConstrainSelectedInstOperands,
     /*  19283 */     // GIR_Coverage, 17349,
     /*  19283 */     GIR_EraseRootFromParent_Done,
     /*  19284 */   // Label 539: @19284
     /*  19284 */   GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(19393), // Rule ID 22792 //
     /*  19289 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19292 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19296 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19300 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19304 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
     /*  19308 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19312 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  19316 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  19320 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  19325 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19327 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  19327 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  19330 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  19334 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19339 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  19341 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  19344 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  19348 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19353 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19356 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  19360 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  19363 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19368 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  19373 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  19378 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
     /*  19381 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19383 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19385 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19388 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19391 */     GIR_RootConstrainSelectedInstOperands,
     /*  19392 */     // GIR_Coverage, 22792,
     /*  19392 */     GIR_EraseRootFromParent_Done,
     /*  19393 */   // Label 540: @19393
     /*  19393 */   GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(19441), // Rule ID 22867 //
     /*  19398 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  19401 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19408 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19412 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19416 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19420 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  19424 */     // MIs[1] Operand 1
     /*  19424 */     // No operand predicates
     /*  19424 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19426 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  19426 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32),
     /*  19429 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19431 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19433 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  19436 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19439 */     GIR_RootConstrainSelectedInstOperands,
     /*  19440 */     // GIR_Coverage, 22867,
     /*  19440 */     GIR_EraseRootFromParent_Done,
     /*  19441 */   // Label 541: @19441
     /*  19441 */   GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(19489), // Rule ID 22957 //
     /*  19446 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  19449 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19452 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19456 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19460 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19464 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  19468 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  19472 */     // MIs[1] Operand 1
     /*  19472 */     // No operand predicates
     /*  19472 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19474 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  19474 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32_ND),
     /*  19477 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19479 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  19481 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  19484 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19487 */     GIR_RootConstrainSelectedInstOperands,
     /*  19488 */     // GIR_Coverage, 22957,
     /*  19488 */     GIR_EraseRootFromParent_Done,
     /*  19489 */   // Label 542: @19489
     /*  19489 */   GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(19551), // Rule ID 17545 //
     /*  19494 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  19497 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19500 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19504 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19508 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19512 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19516 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19520 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19525 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  19529 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19533 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19535 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19535 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
     /*  19538 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19540 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19544 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  19546 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19549 */     GIR_RootConstrainSelectedInstOperands,
     /*  19550 */     // GIR_Coverage, 17545,
     /*  19550 */     GIR_EraseRootFromParent_Done,
     /*  19551 */   // Label 543: @19551
     /*  19551 */   GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(19613), // Rule ID 17549 //
     /*  19556 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  19559 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19562 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19566 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19570 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19574 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19578 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19582 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19587 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  19591 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19595 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19597 */     // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19597 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
     /*  19600 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19602 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19606 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  19608 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19611 */     GIR_RootConstrainSelectedInstOperands,
     /*  19612 */     // GIR_Coverage, 17549,
     /*  19612 */     GIR_EraseRootFromParent_Done,
     /*  19613 */   // Label 544: @19613
     /*  19613 */   GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(19675), // Rule ID 25108 //
     /*  19618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
     /*  19621 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19628 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19632 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19636 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19640 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19644 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19648 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19653 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  19657 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19659 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
     /*  19662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19668 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  19670 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19673 */     GIR_RootConstrainSelectedInstOperands,
     /*  19674 */     // GIR_Coverage, 25108,
     /*  19674 */     GIR_EraseRootFromParent_Done,
     /*  19675 */   // Label 545: @19675
     /*  19675 */   GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(19737), // Rule ID 25112 //
     /*  19680 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
     /*  19683 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19690 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19702 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  19706 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  19710 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19715 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  19719 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  19721 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19721 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
     /*  19724 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19730 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  19732 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  19735 */     GIR_RootConstrainSelectedInstOperands,
     /*  19736 */     // GIR_Coverage, 25112,
     /*  19736 */     GIR_EraseRootFromParent_Done,
     /*  19737 */   // Label 546: @19737
     /*  19737 */   GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(19773), // Rule ID 22859 //
     /*  19742 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  19745 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19748 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19752 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19756 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19760 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19760 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr),
     /*  19765 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  19771 */     GIR_RootConstrainSelectedInstOperands,
     /*  19772 */     // GIR_Coverage, 22859,
     /*  19772 */     GIR_Done,
     /*  19773 */   // Label 547: @19773
     /*  19773 */   GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(19809), // Rule ID 22949 //
     /*  19778 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  19781 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  19784 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19788 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19792 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  19796 */     // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  19796 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr_ND),
     /*  19801 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  19807 */     GIR_RootConstrainSelectedInstOperands,
     /*  19808 */     // GIR_Coverage, 22949,
     /*  19808 */     GIR_Done,
     /*  19809 */   // Label 548: @19809
     /*  19809 */   GIM_Reject,
     /*  19810 */ // Label 524: @19810
     /*  19810 */ GIM_Reject,
     /*  19811 */ // Label 453: @19811
     /*  19811 */ GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(20156),
     /*  19816 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19819 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19822 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19826 */   GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(19946), // Rule ID 19489 //
     /*  19831 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19835 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19839 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19843 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19847 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19852 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19856 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19862 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  19864 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19868 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19870 */     // (and:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  19870 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  19873 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19877 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19882 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  19886 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  19891 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  19894 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19898 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19903 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  19907 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  19912 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  19915 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  19919 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  19924 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  19927 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  19930 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  19932 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19935 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  19937 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  19940 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  19945 */     // GIR_Coverage, 19489,
     /*  19945 */     GIR_EraseRootFromParent_Done,
     /*  19946 */   // Label 550: @19946
     /*  19946 */   GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(20066), // Rule ID 25374 //
     /*  19951 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19955 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  19959 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19963 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  19967 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  19971 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  19976 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19980 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19986 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  19988 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  19990 */     // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  19990 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  19993 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  19997 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20002 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  20006 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20011 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20014 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20018 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20023 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20027 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20032 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20035 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20039 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20044 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20047 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20050 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20052 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20055 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20057 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20060 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  20065 */     // GIR_Coverage, 25374,
     /*  20065 */     GIR_EraseRootFromParent_Done,
     /*  20066 */   // Label 551: @20066
     /*  20066 */   GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(20155), // Rule ID 19485 //
     /*  20071 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  20075 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  20079 */     // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  20079 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20082 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20086 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20091 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20095 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20100 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20103 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20107 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20112 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  20116 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20121 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20124 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  20128 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20133 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20136 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20139 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20141 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20144 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20146 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20149 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  20154 */     // GIR_Coverage, 19485,
     /*  20154 */     GIR_EraseRootFromParent_Done,
     /*  20155 */   // Label 552: @20155
     /*  20155 */   GIM_Reject,
     /*  20156 */ // Label 549: @20156
     /*  20156 */ GIM_Reject,
     /*  20157 */ // Label 454: @20157
     /*  20157 */ GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(20498),
     /*  20162 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  20165 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  20168 */   GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(20230), // Rule ID 23366 //
     /*  20173 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20176 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20180 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20184 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20188 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20191 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20195 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20199 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20203 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20205 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20212 */     // (and:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPANDrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20212 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20215 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20217 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20219 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20223 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20228 */     GIR_RootConstrainSelectedInstOperands,
     /*  20229 */     // GIR_Coverage, 23366,
     /*  20229 */     GIR_EraseRootFromParent_Done,
     /*  20230 */   // Label 554: @20230
     /*  20230 */   GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(20292), // Rule ID 24155 //
     /*  20235 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20242 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20246 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20250 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20253 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20257 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20261 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20265 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20267 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20274 */     // (and:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPANDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20274 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  20277 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20279 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20281 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20285 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20290 */     GIR_RootConstrainSelectedInstOperands,
     /*  20291 */     // GIR_Coverage, 24155,
     /*  20291 */     GIR_EraseRootFromParent_Done,
     /*  20292 */   // Label 555: @20292
     /*  20292 */   GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(20354), // Rule ID 2109 //
     /*  20297 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20304 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20308 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20312 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20316 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20319 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20323 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20327 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20329 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20336 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20336 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20339 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20341 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  20343 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20347 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20352 */     GIR_RootConstrainSelectedInstOperands,
     /*  20353 */     // GIR_Coverage, 2109,
     /*  20353 */     GIR_EraseRootFromParent_Done,
     /*  20354 */   // Label 556: @20354
     /*  20354 */   GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(20416), // Rule ID 5705 //
     /*  20359 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20362 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20366 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20370 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20374 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20378 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20381 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20385 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20389 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20391 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20398 */     // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20398 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  20401 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20403 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  20405 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20409 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20414 */     GIR_RootConstrainSelectedInstOperands,
     /*  20415 */     // GIR_Coverage, 5705,
     /*  20415 */     GIR_EraseRootFromParent_Done,
     /*  20416 */   // Label 557: @20416
     /*  20416 */   GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(20443), // Rule ID 2108 //
     /*  20421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20424 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20428 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20432 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20436 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  20436 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  20441 */     GIR_RootConstrainSelectedInstOperands,
     /*  20442 */     // GIR_Coverage, 2108,
     /*  20442 */     GIR_Done,
     /*  20443 */   // Label 558: @20443
     /*  20443 */   GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(20470), // Rule ID 2110 //
     /*  20448 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  20451 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20455 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20459 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20463 */     // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  20463 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  20468 */     GIR_RootConstrainSelectedInstOperands,
     /*  20469 */     // GIR_Coverage, 2110,
     /*  20469 */     GIR_Done,
     /*  20470 */   // Label 559: @20470
     /*  20470 */   GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(20497), // Rule ID 5702 //
     /*  20475 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20478 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20482 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20486 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20490 */     // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPANDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  20490 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  20495 */     GIR_RootConstrainSelectedInstOperands,
     /*  20496 */     // GIR_Coverage, 5702,
     /*  20496 */     GIR_Done,
     /*  20497 */   // Label 560: @20497
     /*  20497 */   GIM_Reject,
     /*  20498 */ // Label 553: @20498
     /*  20498 */ GIM_Reject,
     /*  20499 */ // Label 455: @20499
     /*  20499 */ GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(20844),
     /*  20504 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20507 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20510 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20514 */   GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(20634), // Rule ID 19490 //
     /*  20519 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20523 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20527 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20531 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20535 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20540 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20544 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20550 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  20552 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20556 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20558 */     // (and:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20558 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20561 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20565 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20570 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20574 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20579 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20582 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20586 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20591 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20595 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20600 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20603 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20607 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20612 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20615 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20618 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20625 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20628 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20633 */     // GIR_Coverage, 19490,
     /*  20633 */     GIR_EraseRootFromParent_Done,
     /*  20634 */   // Label 562: @20634
     /*  20634 */   GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(20754), // Rule ID 25375 //
     /*  20639 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20643 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  20647 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20651 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  20655 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  20659 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20664 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20668 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20674 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  20676 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  20678 */     // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20678 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20681 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20685 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20690 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  20694 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20699 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20702 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20706 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20711 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  20715 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20720 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20723 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  20727 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20732 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20735 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20738 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20740 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20743 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20745 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20748 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20753 */     // GIR_Coverage, 25375,
     /*  20753 */     GIR_EraseRootFromParent_Done,
     /*  20754 */   // Label 563: @20754
     /*  20754 */   GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(20843), // Rule ID 19486 //
     /*  20759 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20763 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  20767 */     // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  20767 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  20770 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20774 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20779 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  20783 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20788 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  20791 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20795 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20800 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  20804 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  20809 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  20812 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  20816 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  20821 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  20824 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  20827 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  20829 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  20832 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20834 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  20837 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  20842 */     // GIR_Coverage, 19486,
     /*  20842 */     GIR_EraseRootFromParent_Done,
     /*  20843 */   // Label 564: @20843
     /*  20843 */   GIM_Reject,
     /*  20844 */ // Label 561: @20844
     /*  20844 */ GIM_Reject,
     /*  20845 */ // Label 456: @20845
     /*  20845 */ GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(21186),
     /*  20850 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20853 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20856 */   GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(20918), // Rule ID 24173 //
     /*  20861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20864 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20868 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20872 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20876 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20879 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20883 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20887 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20891 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20893 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20900 */     // (and:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPANDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rm),
     /*  20903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20905 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20907 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20911 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20916 */     GIR_RootConstrainSelectedInstOperands,
     /*  20917 */     // GIR_Coverage, 24173,
     /*  20917 */     GIR_EraseRootFromParent_Done,
     /*  20918 */   // Label 566: @20918
     /*  20918 */   GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(20980), // Rule ID 25259 //
     /*  20923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  20926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20930 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20934 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  20938 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  20941 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  20945 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  20949 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  20953 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  20955 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  20962 */     // (and:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPANDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  20962 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  20965 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  20967 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  20969 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  20973 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  20978 */     GIR_RootConstrainSelectedInstOperands,
     /*  20979 */     // GIR_Coverage, 25259,
     /*  20979 */     GIR_EraseRootFromParent_Done,
     /*  20980 */   // Label 567: @20980
     /*  20980 */   GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(21042), // Rule ID 5732 //
     /*  20985 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  20988 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20992 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  20996 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21000 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21004 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21007 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21011 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21015 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21017 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21024 */     // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21024 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rm),
     /*  21027 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21029 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21031 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21035 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21040 */     GIR_RootConstrainSelectedInstOperands,
     /*  21041 */     // GIR_Coverage, 5732,
     /*  21041 */     GIR_EraseRootFromParent_Done,
     /*  21042 */   // Label 568: @21042
     /*  21042 */   GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(21104), // Rule ID 18160 //
     /*  21047 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  21050 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21054 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21058 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21062 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21066 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21069 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21073 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21077 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21079 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21086 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  21089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21091 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21093 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21097 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21102 */     GIR_RootConstrainSelectedInstOperands,
     /*  21103 */     // GIR_Coverage, 18160,
     /*  21103 */     GIR_EraseRootFromParent_Done,
     /*  21104 */   // Label 569: @21104
     /*  21104 */   GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(21131), // Rule ID 5729 //
     /*  21109 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21112 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21116 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21120 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  21124 */     // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPANDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  21124 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rr),
     /*  21129 */     GIR_RootConstrainSelectedInstOperands,
     /*  21130 */     // GIR_Coverage, 5729,
     /*  21130 */     GIR_Done,
     /*  21131 */   // Label 570: @21131
     /*  21131 */   GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(21158), // Rule ID 18148 //
     /*  21136 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  21139 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21143 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21147 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21151 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  21151 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  21156 */     GIR_RootConstrainSelectedInstOperands,
     /*  21157 */     // GIR_Coverage, 18148,
     /*  21157 */     GIR_Done,
     /*  21158 */   // Label 571: @21158
     /*  21158 */   GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(21185), // Rule ID 18172 //
     /*  21163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  21166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21170 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21174 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  21178 */     // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  21178 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  21183 */     GIR_RootConstrainSelectedInstOperands,
     /*  21184 */     // GIR_Coverage, 18172,
     /*  21184 */     GIR_Done,
     /*  21185 */   // Label 572: @21185
     /*  21185 */   GIM_Reject,
     /*  21186 */ // Label 565: @21186
     /*  21186 */ GIM_Reject,
     /*  21187 */ // Label 457: @21187
     /*  21187 */ GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(21652),
     /*  21192 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  21195 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  21198 */   GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(21260), // Rule ID 23368 //
     /*  21203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21210 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21214 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21218 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21221 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21225 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21229 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21233 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21235 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21242 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPANDYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  21245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21247 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21249 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21253 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21258 */     GIR_RootConstrainSelectedInstOperands,
     /*  21259 */     // GIR_Coverage, 23368,
     /*  21259 */     GIR_EraseRootFromParent_Done,
     /*  21260 */   // Label 574: @21260
     /*  21260 */   GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(21322), // Rule ID 24149 //
     /*  21265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21272 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21276 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21280 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21283 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21287 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21291 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21295 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21297 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21304 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPANDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21304 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  21307 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21309 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21311 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21315 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21320 */     GIR_RootConstrainSelectedInstOperands,
     /*  21321 */     // GIR_Coverage, 24149,
     /*  21321 */     GIR_EraseRootFromParent_Done,
     /*  21322 */   // Label 575: @21322
     /*  21322 */   GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(21384), // Rule ID 25248 //
     /*  21327 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21330 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21334 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21338 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21342 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21345 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21349 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21353 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21357 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21359 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21366 */     // (and:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VANDPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21366 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  21369 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21371 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  21373 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21377 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21382 */     GIR_RootConstrainSelectedInstOperands,
     /*  21383 */     // GIR_Coverage, 25248,
     /*  21383 */     GIR_EraseRootFromParent_Done,
     /*  21384 */   // Label 576: @21384
     /*  21384 */   GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(21446), // Rule ID 2113 //
     /*  21389 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21392 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21396 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21408 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21411 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21415 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21419 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21421 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21428 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21428 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  21431 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21433 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21435 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21439 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21444 */     GIR_RootConstrainSelectedInstOperands,
     /*  21445 */     // GIR_Coverage, 2113,
     /*  21445 */     GIR_EraseRootFromParent_Done,
     /*  21446 */   // Label 577: @21446
     /*  21446 */   GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(21508), // Rule ID 5696 //
     /*  21451 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21458 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21462 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21466 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21470 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21473 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21477 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21481 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21483 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21490 */     // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21490 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  21493 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21495 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21497 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21501 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21506 */     GIR_RootConstrainSelectedInstOperands,
     /*  21507 */     // GIR_Coverage, 5696,
     /*  21507 */     GIR_EraseRootFromParent_Done,
     /*  21508 */   // Label 578: @21508
     /*  21508 */   GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(21570), // Rule ID 18133 //
     /*  21513 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21520 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21524 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21528 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  21532 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  21535 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  21539 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  21543 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  21545 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  21552 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  21552 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  21555 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21557 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  21559 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  21563 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  21568 */     GIR_RootConstrainSelectedInstOperands,
     /*  21569 */     // GIR_Coverage, 18133,
     /*  21569 */     GIR_EraseRootFromParent_Done,
     /*  21570 */   // Label 579: @21570
     /*  21570 */   GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(21597), // Rule ID 2112 //
     /*  21575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  21578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21582 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21586 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21590 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPANDYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  21590 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  21595 */     GIR_RootConstrainSelectedInstOperands,
     /*  21596 */     // GIR_Coverage, 2112,
     /*  21596 */     GIR_Done,
     /*  21597 */   // Label 580: @21597
     /*  21597 */   GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(21624), // Rule ID 5693 //
     /*  21602 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  21605 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21609 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21613 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  21617 */     // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPANDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  21617 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  21622 */     GIR_RootConstrainSelectedInstOperands,
     /*  21623 */     // GIR_Coverage, 5693,
     /*  21623 */     GIR_Done,
     /*  21624 */   // Label 581: @21624
     /*  21624 */   GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(21651), // Rule ID 18117 //
     /*  21629 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  21632 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21636 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21640 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  21644 */     // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VANDPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  21644 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  21649 */     GIR_RootConstrainSelectedInstOperands,
     /*  21650 */     // GIR_Coverage, 18117,
     /*  21650 */     GIR_Done,
     /*  21651 */   // Label 582: @21651
     /*  21651 */   GIM_Reject,
     /*  21652 */ // Label 573: @21652
     /*  21652 */ GIM_Reject,
     /*  21653 */ // Label 458: @21653
     /*  21653 */ GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(22150),
     /*  21658 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21661 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21664 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21668 */   GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(21728), // Rule ID 4429 //
     /*  21673 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  21676 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21680 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21684 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21688 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21692 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21697 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21701 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21707 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21709 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21713 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21715 */     // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  21715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
     /*  21718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21720 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21724 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  21726 */     GIR_RootConstrainSelectedInstOperands,
     /*  21727 */     // GIR_Coverage, 4429,
     /*  21727 */     GIR_EraseRootFromParent_Done,
     /*  21728 */   // Label 584: @21728
     /*  21728 */   GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(21851), // Rule ID 19487 //
     /*  21733 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  21736 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21740 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21744 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21748 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21752 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21757 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21761 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21767 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21769 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21773 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21775 */     // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  21775 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  21778 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21782 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21787 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  21791 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21796 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  21799 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21803 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21808 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21812 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21817 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  21820 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  21824 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21829 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  21832 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  21835 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  21837 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21840 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21842 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  21845 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  21850 */     // GIR_Coverage, 19487,
     /*  21850 */     GIR_EraseRootFromParent_Done,
     /*  21851 */   // Label 585: @21851
     /*  21851 */   GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(21911), // Rule ID 23698 //
     /*  21856 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  21859 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21863 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21867 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21871 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21875 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21879 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21884 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21888 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21894 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21896 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21898 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  21898 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
     /*  21901 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  21903 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21907 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  21909 */     GIR_RootConstrainSelectedInstOperands,
     /*  21910 */     // GIR_Coverage, 23698,
     /*  21910 */     GIR_EraseRootFromParent_Done,
     /*  21911 */   // Label 586: @21911
     /*  21911 */   GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(22034), // Rule ID 25372 //
     /*  21916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  21919 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21923 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  21927 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21931 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  21935 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  21939 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  21944 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21948 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21954 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  21956 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  21958 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  21958 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  21961 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21965 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21970 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  21974 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  21979 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  21982 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  21986 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  21991 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  21995 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  22000 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  22003 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  22007 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22012 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  22015 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  22018 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22020 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22023 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22025 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  22028 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  22033 */     // GIR_Coverage, 25372,
     /*  22033 */     GIR_EraseRootFromParent_Done,
     /*  22034 */   // Label 587: @22034
     /*  22034 */   GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(22057), // Rule ID 4413 //
     /*  22039 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  22042 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22046 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22050 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KANDBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  22050 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDBkk),
     /*  22055 */     GIR_RootConstrainSelectedInstOperands,
     /*  22056 */     // GIR_Coverage, 4413,
     /*  22056 */     GIR_Done,
     /*  22057 */   // Label 588: @22057
     /*  22057 */   GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(22149), // Rule ID 19483 //
     /*  22062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  22065 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22069 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  22073 */     // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  22073 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  22076 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22080 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22085 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  22089 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  22094 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  22097 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22101 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22106 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  22110 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  22115 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  22118 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  22122 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  22127 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  22130 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  22133 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  22135 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  22138 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22140 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  22143 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  22148 */     // GIR_Coverage, 19483,
     /*  22148 */     GIR_EraseRootFromParent_Done,
     /*  22149 */   // Label 589: @22149
     /*  22149 */   GIM_Reject,
     /*  22150 */ // Label 583: @22150
     /*  22150 */ GIM_Reject,
     /*  22151 */ // Label 459: @22151
     /*  22151 */ GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(22492),
     /*  22156 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  22159 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  22162 */   GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(22224), // Rule ID 25258 //
     /*  22167 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22170 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22174 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22178 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22182 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22185 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22189 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22193 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22197 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22199 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22206 */     // (and:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPANDrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22206 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  22209 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22211 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22213 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22217 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22222 */     GIR_RootConstrainSelectedInstOperands,
     /*  22223 */     // GIR_Coverage, 25258,
     /*  22223 */     GIR_EraseRootFromParent_Done,
     /*  22224 */   // Label 591: @22224
     /*  22224 */   GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(22286), // Rule ID 25439 //
     /*  22229 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22232 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22236 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22240 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22244 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22247 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22251 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22255 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22259 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22261 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22268 */     // (and:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPANDQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22268 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  22271 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22273 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22275 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22279 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22284 */     GIR_RootConstrainSelectedInstOperands,
     /*  22285 */     // GIR_Coverage, 25439,
     /*  22285 */     GIR_EraseRootFromParent_Done,
     /*  22286 */   // Label 592: @22286
     /*  22286 */   GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(22348), // Rule ID 18159 //
     /*  22291 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22294 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22298 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22302 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22306 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22310 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22313 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22317 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22321 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22323 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22330 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22330 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  22333 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22335 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22337 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22341 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22346 */     GIR_RootConstrainSelectedInstOperands,
     /*  22347 */     // GIR_Coverage, 18159,
     /*  22347 */     GIR_EraseRootFromParent_Done,
     /*  22348 */   // Label 593: @22348
     /*  22348 */   GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(22410), // Rule ID 20025 //
     /*  22353 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22360 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22364 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22368 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22372 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22375 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22379 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22383 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22385 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22392 */     // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22392 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  22395 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22397 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22399 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22403 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22408 */     GIR_RootConstrainSelectedInstOperands,
     /*  22409 */     // GIR_Coverage, 20025,
     /*  22409 */     GIR_EraseRootFromParent_Done,
     /*  22410 */   // Label 594: @22410
     /*  22410 */   GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(22437), // Rule ID 18147 //
     /*  22415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  22418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22422 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22426 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22430 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  22430 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  22435 */     GIR_RootConstrainSelectedInstOperands,
     /*  22436 */     // GIR_Coverage, 18147,
     /*  22436 */     GIR_Done,
     /*  22437 */   // Label 595: @22437
     /*  22437 */   GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(22464), // Rule ID 18171 //
     /*  22442 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  22445 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22449 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22453 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  22457 */     // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  22457 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  22462 */     GIR_RootConstrainSelectedInstOperands,
     /*  22463 */     // GIR_Coverage, 18171,
     /*  22463 */     GIR_Done,
     /*  22464 */   // Label 596: @22464
     /*  22464 */   GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(22491), // Rule ID 20017 //
     /*  22469 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  22472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22476 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22480 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  22484 */     // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPANDQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  22484 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  22489 */     GIR_RootConstrainSelectedInstOperands,
     /*  22490 */     // GIR_Coverage, 20017,
     /*  22490 */     GIR_Done,
     /*  22491 */   // Label 597: @22491
     /*  22491 */   GIM_Reject,
     /*  22492 */ // Label 590: @22492
     /*  22492 */ GIM_Reject,
     /*  22493 */ // Label 460: @22493
     /*  22493 */ GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(22958),
     /*  22498 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  22501 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  22504 */   GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(22566), // Rule ID 24167 //
     /*  22509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22512 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22524 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22527 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22531 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22535 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22539 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22541 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22548 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPANDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rm),
     /*  22551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22553 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22555 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22559 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22564 */     GIR_RootConstrainSelectedInstOperands,
     /*  22565 */     // GIR_Coverage, 24167,
     /*  22565 */     GIR_EraseRootFromParent_Done,
     /*  22566 */   // Label 599: @22566
     /*  22566 */   GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(22628), // Rule ID 25238 //
     /*  22571 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22574 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22578 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22582 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22586 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22589 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22593 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22597 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22601 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22603 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22610 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPANDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22610 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  22613 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22615 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22617 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22621 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22626 */     GIR_RootConstrainSelectedInstOperands,
     /*  22627 */     // GIR_Coverage, 25238,
     /*  22627 */     GIR_EraseRootFromParent_Done,
     /*  22628 */   // Label 600: @22628
     /*  22628 */   GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(22690), // Rule ID 25247 //
     /*  22633 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22636 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22640 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22644 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22648 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22651 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22655 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22659 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22663 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22665 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22672 */     // (and:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VANDPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22672 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  22675 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22677 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  22679 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22683 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22688 */     GIR_RootConstrainSelectedInstOperands,
     /*  22689 */     // GIR_Coverage, 25247,
     /*  22689 */     GIR_EraseRootFromParent_Done,
     /*  22690 */   // Label 601: @22690
     /*  22690 */   GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(22752), // Rule ID 5723 //
     /*  22695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22702 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22706 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22710 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22714 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22717 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22721 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22725 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22727 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22734 */     // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22734 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rm),
     /*  22737 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22739 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22741 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22745 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22750 */     GIR_RootConstrainSelectedInstOperands,
     /*  22751 */     // GIR_Coverage, 5723,
     /*  22751 */     GIR_EraseRootFromParent_Done,
     /*  22752 */   // Label 602: @22752
     /*  22752 */   GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(22814), // Rule ID 18104 //
     /*  22757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22764 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22768 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22772 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22776 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22779 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22783 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22787 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22789 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22796 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22796 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  22799 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22801 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22803 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22807 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22812 */     GIR_RootConstrainSelectedInstOperands,
     /*  22813 */     // GIR_Coverage, 18104,
     /*  22813 */     GIR_EraseRootFromParent_Done,
     /*  22814 */   // Label 603: @22814
     /*  22814 */   GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(22876), // Rule ID 18132 //
     /*  22819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22822 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22826 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22830 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  22834 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22838 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22841 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22845 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  22849 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  22851 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  22858 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  22858 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  22861 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  22863 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  22865 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  22869 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  22874 */     GIR_RootConstrainSelectedInstOperands,
     /*  22875 */     // GIR_Coverage, 18132,
     /*  22875 */     GIR_EraseRootFromParent_Done,
     /*  22876 */   // Label 604: @22876
     /*  22876 */   GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(22903), // Rule ID 5720 //
     /*  22881 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  22884 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22888 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22892 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  22896 */     // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPANDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  22896 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rr),
     /*  22901 */     GIR_RootConstrainSelectedInstOperands,
     /*  22902 */     // GIR_Coverage, 5720,
     /*  22902 */     GIR_Done,
     /*  22903 */   // Label 605: @22903
     /*  22903 */   GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(22930), // Rule ID 18092 //
     /*  22908 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  22911 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22915 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22919 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22923 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPANDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  22923 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  22928 */     GIR_RootConstrainSelectedInstOperands,
     /*  22929 */     // GIR_Coverage, 18092,
     /*  22929 */     GIR_Done,
     /*  22930 */   // Label 606: @22930
     /*  22930 */   GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(22957), // Rule ID 18116 //
     /*  22935 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  22938 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22942 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22946 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  22950 */     // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VANDPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  22950 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  22955 */     GIR_RootConstrainSelectedInstOperands,
     /*  22956 */     // GIR_Coverage, 18116,
     /*  22956 */     GIR_Done,
     /*  22957 */   // Label 607: @22957
     /*  22957 */   GIM_Reject,
     /*  22958 */ // Label 598: @22958
     /*  22958 */ GIM_Reject,
     /*  22959 */ // Label 461: @22959
     /*  22959 */ GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(23114),
     /*  22964 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  22967 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  22970 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  22974 */   GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(23032), // Rule ID 24143 //
     /*  22979 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  22982 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22986 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  22990 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  22993 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  22997 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23001 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23005 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23007 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23014 */     // (and:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPANDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23014 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  23017 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23019 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23021 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23025 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23030 */     GIR_RootConstrainSelectedInstOperands,
     /*  23031 */     // GIR_Coverage, 24143,
     /*  23031 */     GIR_EraseRootFromParent_Done,
     /*  23032 */   // Label 609: @23032
     /*  23032 */   GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(23090), // Rule ID 5687 //
     /*  23037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23040 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23052 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23055 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23059 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23063 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23065 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23072 */     // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23072 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  23075 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23077 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23079 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23083 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23088 */     GIR_RootConstrainSelectedInstOperands,
     /*  23089 */     // GIR_Coverage, 5687,
     /*  23089 */     GIR_EraseRootFromParent_Done,
     /*  23090 */   // Label 610: @23090
     /*  23090 */   GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(23113), // Rule ID 5684 //
     /*  23095 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23098 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23102 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  23106 */     // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPANDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  23106 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  23111 */     GIR_RootConstrainSelectedInstOperands,
     /*  23112 */     // GIR_Coverage, 5684,
     /*  23112 */     GIR_Done,
     /*  23113 */   // Label 611: @23113
     /*  23113 */   GIM_Reject,
     /*  23114 */ // Label 608: @23114
     /*  23114 */ GIM_Reject,
     /*  23115 */ // Label 462: @23115
     /*  23115 */ GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(23274),
     /*  23120 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23123 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23126 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23130 */   GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(23190), // Rule ID 4430 //
     /*  23135 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23138 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23142 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23146 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23150 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23154 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23159 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23163 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23169 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  23171 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23175 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23177 */     // (and:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23177 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  23180 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23182 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  23186 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  23188 */     GIR_RootConstrainSelectedInstOperands,
     /*  23189 */     // GIR_Coverage, 4430,
     /*  23189 */     GIR_EraseRootFromParent_Done,
     /*  23190 */   // Label 613: @23190
     /*  23190 */   GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(23250), // Rule ID 23699 //
     /*  23195 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23198 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23210 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  23214 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  23218 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23223 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23227 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23233 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  23235 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  23237 */     // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
     /*  23240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  23246 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  23248 */     GIR_RootConstrainSelectedInstOperands,
     /*  23249 */     // GIR_Coverage, 23699,
     /*  23249 */     GIR_EraseRootFromParent_Done,
     /*  23250 */   // Label 614: @23250
     /*  23250 */   GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(23273), // Rule ID 4414 //
     /*  23255 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  23258 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23262 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  23266 */     // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KANDWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  23266 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
     /*  23271 */     GIR_RootConstrainSelectedInstOperands,
     /*  23272 */     // GIR_Coverage, 4414,
     /*  23272 */     GIR_Done,
     /*  23273 */   // Label 615: @23273
     /*  23273 */   GIM_Reject,
     /*  23274 */ // Label 612: @23274
     /*  23274 */ GIM_Reject,
     /*  23275 */ // Label 463: @23275
     /*  23275 */ GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(23616),
     /*  23280 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  23283 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  23286 */   GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(23348), // Rule ID 25257 //
     /*  23291 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23294 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23298 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23302 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23306 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23309 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23313 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23317 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23321 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23323 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23330 */     // (and:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPANDrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23330 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  23333 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23335 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23337 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23341 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23346 */     GIR_RootConstrainSelectedInstOperands,
     /*  23347 */     // GIR_Coverage, 25257,
     /*  23347 */     GIR_EraseRootFromParent_Done,
     /*  23348 */   // Label 617: @23348
     /*  23348 */   GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(23410), // Rule ID 25438 //
     /*  23353 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23360 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23364 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23368 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23371 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23375 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23379 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23383 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23385 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23392 */     // (and:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPANDQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23392 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  23395 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23397 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23399 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23403 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23408 */     GIR_RootConstrainSelectedInstOperands,
     /*  23409 */     // GIR_Coverage, 25438,
     /*  23409 */     GIR_EraseRootFromParent_Done,
     /*  23410 */   // Label 618: @23410
     /*  23410 */   GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(23472), // Rule ID 18158 //
     /*  23415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23422 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23426 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23430 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23434 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23437 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23441 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23445 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23447 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23454 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23454 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDrm),
     /*  23457 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23459 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23461 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23465 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23470 */     GIR_RootConstrainSelectedInstOperands,
     /*  23471 */     // GIR_Coverage, 18158,
     /*  23471 */     GIR_EraseRootFromParent_Done,
     /*  23472 */   // Label 619: @23472
     /*  23472 */   GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(23534), // Rule ID 20024 //
     /*  23477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23484 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23496 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23499 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23503 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23507 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23509 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23516 */     // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23516 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rm),
     /*  23519 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23521 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23523 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23527 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23532 */     GIR_RootConstrainSelectedInstOperands,
     /*  23533 */     // GIR_Coverage, 20024,
     /*  23533 */     GIR_EraseRootFromParent_Done,
     /*  23534 */   // Label 620: @23534
     /*  23534 */   GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(23561), // Rule ID 18146 //
     /*  23539 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  23542 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23546 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23550 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23554 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  23554 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
     /*  23559 */     GIR_RootConstrainSelectedInstOperands,
     /*  23560 */     // GIR_Coverage, 18146,
     /*  23560 */     GIR_Done,
     /*  23561 */   // Label 621: @23561
     /*  23561 */   GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(23588), // Rule ID 18170 //
     /*  23566 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  23569 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23573 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23577 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  23581 */     // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  23581 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
     /*  23586 */     GIR_RootConstrainSelectedInstOperands,
     /*  23587 */     // GIR_Coverage, 18170,
     /*  23587 */     GIR_Done,
     /*  23588 */   // Label 622: @23588
     /*  23588 */   GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(23615), // Rule ID 20016 //
     /*  23593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23600 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23604 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  23608 */     // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPANDQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  23608 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
     /*  23613 */     GIR_RootConstrainSelectedInstOperands,
     /*  23614 */     // GIR_Coverage, 20016,
     /*  23614 */     GIR_Done,
     /*  23615 */   // Label 623: @23615
     /*  23615 */   GIM_Reject,
     /*  23616 */ // Label 616: @23616
     /*  23616 */ GIM_Reject,
     /*  23617 */ // Label 464: @23617
     /*  23617 */ GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(24082),
     /*  23622 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  23625 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  23628 */   GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(23690), // Rule ID 25237 //
     /*  23633 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  23636 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23640 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23644 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23648 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23651 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23655 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23659 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23663 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23665 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23672 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPANDYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23672 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  23675 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23677 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23679 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23683 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23688 */     GIR_RootConstrainSelectedInstOperands,
     /*  23689 */     // GIR_Coverage, 25237,
     /*  23689 */     GIR_EraseRootFromParent_Done,
     /*  23690 */   // Label 625: @23690
     /*  23690 */   GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(23752), // Rule ID 25246 //
     /*  23695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  23698 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23710 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23713 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23717 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23721 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23725 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23727 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23734 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VANDPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23734 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  23737 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23739 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23741 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23745 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23750 */     GIR_RootConstrainSelectedInstOperands,
     /*  23751 */     // GIR_Coverage, 25246,
     /*  23751 */     GIR_EraseRootFromParent_Done,
     /*  23752 */   // Label 626: @23752
     /*  23752 */   GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(23814), // Rule ID 25445 //
     /*  23757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23764 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23768 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23772 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23775 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23779 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23783 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23787 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23789 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23796 */     // (and:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPANDQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23796 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  23799 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23801 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  23803 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23807 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23812 */     GIR_RootConstrainSelectedInstOperands,
     /*  23813 */     // GIR_Coverage, 25445,
     /*  23813 */     GIR_EraseRootFromParent_Done,
     /*  23814 */   // Label 627: @23814
     /*  23814 */   GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(23876), // Rule ID 18103 //
     /*  23819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  23822 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23826 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23830 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23834 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23838 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23841 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23845 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23849 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23851 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23858 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23858 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  23861 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23863 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23865 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23869 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23874 */     GIR_RootConstrainSelectedInstOperands,
     /*  23875 */     // GIR_Coverage, 18103,
     /*  23875 */     GIR_EraseRootFromParent_Done,
     /*  23876 */   // Label 628: @23876
     /*  23876 */   GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(23938), // Rule ID 18131 //
     /*  23881 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  23884 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23888 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  23892 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23896 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23900 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23903 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23907 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23911 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23913 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23920 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  23923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23925 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23927 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23931 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23936 */     GIR_RootConstrainSelectedInstOperands,
     /*  23937 */     // GIR_Coverage, 18131,
     /*  23937 */     GIR_EraseRootFromParent_Done,
     /*  23938 */   // Label 629: @23938
     /*  23938 */   GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(24000), // Rule ID 20041 //
     /*  23943 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  23946 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23950 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  23954 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  23958 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  23962 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  23965 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  23969 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  23973 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  23975 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  23982 */     // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  23982 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  23985 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  23987 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  23989 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  23993 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  23998 */     GIR_RootConstrainSelectedInstOperands,
     /*  23999 */     // GIR_Coverage, 20041,
     /*  23999 */     GIR_EraseRootFromParent_Done,
     /*  24000 */   // Label 630: @24000
     /*  24000 */   GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(24027), // Rule ID 18091 //
     /*  24005 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24008 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24012 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24016 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24020 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPANDYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  24020 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  24025 */     GIR_RootConstrainSelectedInstOperands,
     /*  24026 */     // GIR_Coverage, 18091,
     /*  24026 */     GIR_Done,
     /*  24027 */   // Label 631: @24027
     /*  24027 */   GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(24054), // Rule ID 18115 //
     /*  24032 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24035 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24039 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24043 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24047 */     // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VANDPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  24047 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  24052 */     GIR_RootConstrainSelectedInstOperands,
     /*  24053 */     // GIR_Coverage, 18115,
     /*  24053 */     GIR_Done,
     /*  24054 */   // Label 632: @24054
     /*  24054 */   GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(24081), // Rule ID 20033 //
     /*  24059 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24062 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24066 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24070 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24074 */     // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPANDQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  24074 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  24079 */     GIR_RootConstrainSelectedInstOperands,
     /*  24080 */     // GIR_Coverage, 20033,
     /*  24080 */     GIR_Done,
     /*  24081 */   // Label 633: @24081
     /*  24081 */   GIM_Reject,
     /*  24082 */ // Label 624: @24082
     /*  24082 */ GIM_Reject,
     /*  24083 */ // Label 465: @24083
     /*  24083 */ GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(24238),
     /*  24088 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  24091 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  24094 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24098 */   GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(24156), // Rule ID 24161 //
     /*  24103 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24106 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24110 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24114 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24117 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24121 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24125 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24129 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24131 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24138 */     // (and:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPANDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24138 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZrm),
     /*  24141 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24143 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24145 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24149 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24154 */     GIR_RootConstrainSelectedInstOperands,
     /*  24155 */     // GIR_Coverage, 24161,
     /*  24155 */     GIR_EraseRootFromParent_Done,
     /*  24156 */   // Label 635: @24156
     /*  24156 */   GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(24214), // Rule ID 5714 //
     /*  24161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24164 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24176 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24179 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24183 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24187 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24189 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24196 */     // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24196 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDDZrm),
     /*  24199 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24201 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24203 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24207 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24212 */     GIR_RootConstrainSelectedInstOperands,
     /*  24213 */     // GIR_Coverage, 5714,
     /*  24213 */     GIR_EraseRootFromParent_Done,
     /*  24214 */   // Label 636: @24214
     /*  24214 */   GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(24237), // Rule ID 5711 //
     /*  24219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24222 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24226 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24230 */     // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPANDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
     /*  24230 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZrr),
     /*  24235 */     GIR_RootConstrainSelectedInstOperands,
     /*  24236 */     // GIR_Coverage, 5711,
     /*  24236 */     GIR_Done,
     /*  24237 */   // Label 637: @24237
     /*  24237 */   GIM_Reject,
     /*  24238 */ // Label 634: @24238
     /*  24238 */ GIM_Reject,
     /*  24239 */ // Label 466: @24239
     /*  24239 */ GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(24398),
     /*  24244 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24247 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24250 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24254 */   GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(24314), // Rule ID 4431 //
     /*  24259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24262 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24266 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24270 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24274 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24278 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24283 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24287 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24293 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  24295 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24299 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24301 */     // (and:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
     /*  24304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24306 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  24310 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  24312 */     GIR_RootConstrainSelectedInstOperands,
     /*  24313 */     // GIR_Coverage, 4431,
     /*  24313 */     GIR_EraseRootFromParent_Done,
     /*  24314 */   // Label 639: @24314
     /*  24314 */   GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(24374), // Rule ID 23700 //
     /*  24319 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24322 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24326 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24330 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24334 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
     /*  24338 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
     /*  24342 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24347 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24351 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24357 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  24359 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  24361 */     // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24361 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
     /*  24364 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24366 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  24370 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  24372 */     GIR_RootConstrainSelectedInstOperands,
     /*  24373 */     // GIR_Coverage, 23700,
     /*  24373 */     GIR_EraseRootFromParent_Done,
     /*  24374 */   // Label 640: @24374
     /*  24374 */   GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(24397), // Rule ID 4415 //
     /*  24379 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  24382 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24386 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
     /*  24390 */     // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KANDDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
     /*  24390 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDDkk),
     /*  24395 */     GIR_RootConstrainSelectedInstOperands,
     /*  24396 */     // GIR_Coverage, 4415,
     /*  24396 */     GIR_Done,
     /*  24397 */   // Label 641: @24397
     /*  24397 */   GIM_Reject,
     /*  24398 */ // Label 638: @24398
     /*  24398 */ GIM_Reject,
     /*  24399 */ // Label 467: @24399
     /*  24399 */ GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(24864),
     /*  24404 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
     /*  24407 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
     /*  24410 */   GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(24472), // Rule ID 25236 //
     /*  24415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24422 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24426 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24430 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24433 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24437 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24441 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24445 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24447 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24454 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VPANDYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24454 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  24457 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24459 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24461 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24465 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24470 */     GIR_RootConstrainSelectedInstOperands,
     /*  24471 */     // GIR_Coverage, 25236,
     /*  24471 */     GIR_EraseRootFromParent_Done,
     /*  24472 */   // Label 643: @24472
     /*  24472 */   GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(24534), // Rule ID 25245 //
     /*  24477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24484 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24488 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24492 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24495 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24499 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24503 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24507 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24509 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24516 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v32i8] }:$src1)  =>  (VANDPSYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24516 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  24519 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24521 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24523 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24527 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24532 */     GIR_RootConstrainSelectedInstOperands,
     /*  24533 */     // GIR_Coverage, 25245,
     /*  24533 */     GIR_EraseRootFromParent_Done,
     /*  24534 */   // Label 644: @24534
     /*  24534 */   GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(24596), // Rule ID 25444 //
     /*  24539 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24542 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24546 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24550 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24554 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24557 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24561 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24565 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24569 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24571 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24578 */     // (and:{ *:[v32i8] } (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v32i8] }:$src1)  =>  (VPANDQZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24578 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  24581 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24583 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24585 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24589 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24594 */     GIR_RootConstrainSelectedInstOperands,
     /*  24595 */     // GIR_Coverage, 25444,
     /*  24595 */     GIR_EraseRootFromParent_Done,
     /*  24596 */   // Label 645: @24596
     /*  24596 */   GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(24658), // Rule ID 18102 //
     /*  24601 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24604 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24608 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24612 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24616 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24620 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24623 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24627 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24631 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24633 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24640 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24640 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDYrm),
     /*  24643 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24645 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24647 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24651 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24656 */     GIR_RootConstrainSelectedInstOperands,
     /*  24657 */     // GIR_Coverage, 18102,
     /*  24657 */     GIR_EraseRootFromParent_Done,
     /*  24658 */   // Label 646: @24658
     /*  24658 */   GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(24720), // Rule ID 18130 //
     /*  24663 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24666 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24670 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24682 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24685 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24689 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24693 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24695 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24702 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VANDPSYrm:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24702 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VANDPSYrm),
     /*  24705 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24707 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24709 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24713 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24718 */     GIR_RootConstrainSelectedInstOperands,
     /*  24719 */     // GIR_Coverage, 18130,
     /*  24719 */     GIR_EraseRootFromParent_Done,
     /*  24720 */   // Label 647: @24720
     /*  24720 */   GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(24782), // Rule ID 20040 //
     /*  24725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24728 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24732 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24736 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24740 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24744 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24747 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24751 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24755 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24757 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24764 */     // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, (ld:{ *:[v32i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZ256rm:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rm),
     /*  24767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24769 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24771 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24775 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24780 */     GIR_RootConstrainSelectedInstOperands,
     /*  24781 */     // GIR_Coverage, 20040,
     /*  24781 */     GIR_EraseRootFromParent_Done,
     /*  24782 */   // Label 648: @24782
     /*  24782 */   GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(24809), // Rule ID 18090 //
     /*  24787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  24790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24794 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24798 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24802 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPANDYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  24802 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
     /*  24807 */     GIR_RootConstrainSelectedInstOperands,
     /*  24808 */     // GIR_Coverage, 18090,
     /*  24808 */     GIR_Done,
     /*  24809 */   // Label 649: @24809
     /*  24809 */   GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(24836), // Rule ID 18114 //
     /*  24814 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  24817 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24821 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24825 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  24829 */     // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VANDPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
     /*  24829 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
     /*  24834 */     GIR_RootConstrainSelectedInstOperands,
     /*  24835 */     // GIR_Coverage, 18114,
     /*  24835 */     GIR_Done,
     /*  24836 */   // Label 650: @24836
     /*  24836 */   GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(24863), // Rule ID 20032 //
     /*  24841 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  24844 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24848 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  24856 */     // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPANDQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
     /*  24856 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
     /*  24861 */     GIR_RootConstrainSelectedInstOperands,
     /*  24862 */     // GIR_Coverage, 20032,
     /*  24862 */     GIR_Done,
     /*  24863 */   // Label 651: @24863
     /*  24863 */   GIM_Reject,
     /*  24864 */ // Label 642: @24864
     /*  24864 */ GIM_Reject,
     /*  24865 */ // Label 468: @24865
     /*  24865 */ GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(25020),
     /*  24870 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
     /*  24873 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
     /*  24876 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24880 */   GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(24938), // Rule ID 25451 //
     /*  24885 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24888 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24892 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24896 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24899 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24903 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24907 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24911 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24913 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24920 */     // (and:{ *:[v32i16] } (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v32i16] }:$src1)  =>  (VPANDQZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  24923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24925 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  24927 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24931 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24936 */     GIR_RootConstrainSelectedInstOperands,
     /*  24937 */     // GIR_Coverage, 25451,
     /*  24937 */     GIR_EraseRootFromParent_Done,
     /*  24938 */   // Label 653: @24938
     /*  24938 */   GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(24996), // Rule ID 20057 //
     /*  24943 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  24946 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  24950 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  24954 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  24958 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  24961 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  24965 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  24969 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  24971 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  24978 */     // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, (ld:{ *:[v32i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  24978 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  24981 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  24983 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  24985 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  24989 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  24994 */     GIR_RootConstrainSelectedInstOperands,
     /*  24995 */     // GIR_Coverage, 20057,
     /*  24995 */     GIR_EraseRootFromParent_Done,
     /*  24996 */   // Label 654: @24996
     /*  24996 */   GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(25019), // Rule ID 20049 //
     /*  25001 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25004 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25008 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25012 */     // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPANDQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
     /*  25012 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  25017 */     GIR_RootConstrainSelectedInstOperands,
     /*  25018 */     // GIR_Coverage, 20049,
     /*  25018 */     GIR_Done,
     /*  25019 */   // Label 655: @25019
     /*  25019 */   GIM_Reject,
     /*  25020 */ // Label 652: @25020
     /*  25020 */ GIM_Reject,
     /*  25021 */ // Label 469: @25021
     /*  25021 */ GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(25180),
     /*  25026 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25029 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25032 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25036 */   GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(25096), // Rule ID 4432 //
     /*  25041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25052 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25056 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25060 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25065 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25069 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25075 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  25077 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25081 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  25083 */     // (and:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25083 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
     /*  25086 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25088 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  25092 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  25094 */     GIR_RootConstrainSelectedInstOperands,
     /*  25095 */     // GIR_Coverage, 4432,
     /*  25095 */     GIR_EraseRootFromParent_Done,
     /*  25096 */   // Label 657: @25096
     /*  25096 */   GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(25156), // Rule ID 23701 //
     /*  25101 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25104 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25108 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25112 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25116 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
     /*  25120 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
     /*  25124 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25129 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25133 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25139 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  25141 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  25143 */     // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25143 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
     /*  25146 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  25152 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  25154 */     GIR_RootConstrainSelectedInstOperands,
     /*  25155 */     // GIR_Coverage, 23701,
     /*  25155 */     GIR_EraseRootFromParent_Done,
     /*  25156 */   // Label 658: @25156
     /*  25156 */   GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(25179), // Rule ID 4416 //
     /*  25161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
     /*  25164 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25168 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
     /*  25172 */     // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KANDQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
     /*  25172 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDQkk),
     /*  25177 */     GIR_RootConstrainSelectedInstOperands,
     /*  25178 */     // GIR_Coverage, 4416,
     /*  25178 */     GIR_Done,
     /*  25179 */   // Label 659: @25179
     /*  25179 */   GIM_Reject,
     /*  25180 */ // Label 656: @25180
     /*  25180 */ GIM_Reject,
     /*  25181 */ // Label 470: @25181
     /*  25181 */ GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(25336),
     /*  25186 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
     /*  25189 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
     /*  25192 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25196 */   GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(25254), // Rule ID 25450 //
     /*  25201 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25204 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25208 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25212 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25215 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  25219 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25223 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25227 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25229 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25236 */     // (and:{ *:[v64i8] } (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v64i8] }:$src1)  =>  (VPANDQZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25236 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  25239 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25241 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25243 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25247 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25252 */     GIR_RootConstrainSelectedInstOperands,
     /*  25253 */     // GIR_Coverage, 25450,
     /*  25253 */     GIR_EraseRootFromParent_Done,
     /*  25254 */   // Label 661: @25254
     /*  25254 */   GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(25312), // Rule ID 20056 //
     /*  25259 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25262 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25266 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25270 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25274 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25277 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  25281 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25285 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25287 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25294 */     // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, (ld:{ *:[v64i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPANDQZrm:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25294 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPANDQZrm),
     /*  25297 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25299 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25301 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25305 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25310 */     GIR_RootConstrainSelectedInstOperands,
     /*  25311 */     // GIR_Coverage, 20056,
     /*  25311 */     GIR_EraseRootFromParent_Done,
     /*  25312 */   // Label 662: @25312
     /*  25312 */   GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(25335), // Rule ID 20048 //
     /*  25317 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  25320 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25324 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  25328 */     // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPANDQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
     /*  25328 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
     /*  25333 */     GIR_RootConstrainSelectedInstOperands,
     /*  25334 */     // GIR_Coverage, 20048,
     /*  25334 */     GIR_Done,
     /*  25335 */   // Label 663: @25335
     /*  25335 */   GIM_Reject,
     /*  25336 */ // Label 660: @25336
     /*  25336 */ GIM_Reject,
     /*  25337 */ // Label 471: @25337
     /*  25337 */ GIM_Reject,
     /*  25338 */ // Label 4: @25338
     /*  25338 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 687*/ GIMT_Encode4(33741),
     /*  25349 */ /*GILLT_s1*//*Label 664*/ GIMT_Encode4(25449),
     /*  25353 */ /*GILLT_s8*//*Label 665*/ GIMT_Encode4(25549),
     /*  25357 */ /*GILLT_s16*//*Label 666*/ GIMT_Encode4(25942),
     /*  25361 */ /*GILLT_s32*//*Label 667*/ GIMT_Encode4(26539),
     /*  25365 */ /*GILLT_s64*//*Label 668*/ GIMT_Encode4(27995), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  25377 */ /*GILLT_v2s1*//*Label 669*/ GIMT_Encode4(29459),
     /*  25381 */ /*GILLT_v2s64*//*Label 670*/ GIMT_Encode4(29559),
     /*  25385 */ /*GILLT_v4s1*//*Label 671*/ GIMT_Encode4(29901),
     /*  25389 */ /*GILLT_v4s32*//*Label 672*/ GIMT_Encode4(30001),
     /*  25393 */ /*GILLT_v4s64*//*Label 673*/ GIMT_Encode4(30343),
     /*  25397 */ /*GILLT_v8s1*//*Label 674*/ GIMT_Encode4(30809),
     /*  25401 */ /*GILLT_v8s16*//*Label 675*/ GIMT_Encode4(30933),
     /*  25405 */ /*GILLT_v8s32*//*Label 676*/ GIMT_Encode4(31275),
     /*  25409 */ /*GILLT_v8s64*//*Label 677*/ GIMT_Encode4(31741),
     /*  25413 */ /*GILLT_v16s1*//*Label 678*/ GIMT_Encode4(31897),
     /*  25417 */ /*GILLT_v16s8*//*Label 679*/ GIMT_Encode4(31931),
     /*  25421 */ /*GILLT_v16s16*//*Label 680*/ GIMT_Encode4(32273),
     /*  25425 */ /*GILLT_v16s32*//*Label 681*/ GIMT_Encode4(32739),
     /*  25429 */ /*GILLT_v32s1*//*Label 682*/ GIMT_Encode4(32895),
     /*  25433 */ /*GILLT_v32s8*//*Label 683*/ GIMT_Encode4(32929),
     /*  25437 */ /*GILLT_v32s16*//*Label 684*/ GIMT_Encode4(33395),
     /*  25441 */ /*GILLT_v64s1*//*Label 685*/ GIMT_Encode4(33551),
     /*  25445 */ /*GILLT_v64s8*//*Label 686*/ GIMT_Encode4(33585),
     /*  25449 */ // Label 664: @25449
     /*  25449 */ GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(25548), // Rule ID 19492 //
     /*  25454 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  25457 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  25460 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25464 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25468 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
     /*  25472 */   // (or:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
     /*  25472 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  25475 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25479 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25484 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  25488 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  25493 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  25496 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25500 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25505 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  25509 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  25514 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  25517 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  25521 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  25526 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  25529 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  25532 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  25534 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  25537 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25539 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  25542 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
     /*  25547 */   // GIR_Coverage, 19492,
     /*  25547 */   GIR_EraseRootFromParent_Done,
     /*  25548 */ // Label 688: @25548
     /*  25548 */ GIM_Reject,
     /*  25549 */ // Label 665: @25549
     /*  25549 */ GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(25941),
     /*  25554 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
     /*  25557 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
     /*  25560 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25564 */   GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(25625), // Rule ID 26067 //
     /*  25569 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25572 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25576 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25580 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25583 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25587 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25591 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25595 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25597 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25604 */     // (or:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (OR8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25604 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm),
     /*  25607 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25609 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25611 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25615 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25618 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25623 */     GIR_RootConstrainSelectedInstOperands,
     /*  25624 */     // GIR_Coverage, 26067,
     /*  25624 */     GIR_EraseRootFromParent_Done,
     /*  25625 */   // Label 690: @25625
     /*  25625 */   GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(25686), // Rule ID 26086 //
     /*  25630 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25633 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25637 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25641 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25644 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25648 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25652 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25656 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25658 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25665 */     // (or:{ *:[i8] } (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>, GR8:{ *:[i8] }:$src1)  =>  (OR8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25665 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm_ND),
     /*  25668 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25670 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  25672 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25676 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25679 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25684 */     GIR_RootConstrainSelectedInstOperands,
     /*  25685 */     // GIR_Coverage, 26086,
     /*  25685 */     GIR_EraseRootFromParent_Done,
     /*  25686 */   // Label 691: @25686
     /*  25686 */   GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(25747), // Rule ID 22836 //
     /*  25691 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25694 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25698 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25702 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25706 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25709 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25713 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25717 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25719 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25726 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (OR8rm:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25726 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm),
     /*  25729 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25731 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25733 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25737 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25740 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25745 */     GIR_RootConstrainSelectedInstOperands,
     /*  25746 */     // GIR_Coverage, 22836,
     /*  25746 */     GIR_EraseRootFromParent_Done,
     /*  25747 */   // Label 692: @25747
     /*  25747 */   GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(25808), // Rule ID 22926 //
     /*  25752 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25755 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25759 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25763 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25767 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25770 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25774 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi8),
     /*  25778 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25780 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25787 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (ld:{ *:[i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi8>>)  =>  (OR8rm_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25787 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8rm_ND),
     /*  25790 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25792 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25794 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  25798 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25801 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  25806 */     GIR_RootConstrainSelectedInstOperands,
     /*  25807 */     // GIR_Coverage, 22926,
     /*  25807 */     GIR_EraseRootFromParent_Done,
     /*  25808 */   // Label 693: @25808
     /*  25808 */   GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(25845), // Rule ID 22840 //
     /*  25813 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25816 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25820 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25824 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25828 */     // MIs[1] Operand 1
     /*  25828 */     // No operand predicates
     /*  25828 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25830 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  25830 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri),
     /*  25833 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25835 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25837 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  25840 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25843 */     GIR_RootConstrainSelectedInstOperands,
     /*  25844 */     // GIR_Coverage, 22840,
     /*  25844 */     GIR_EraseRootFromParent_Done,
     /*  25845 */   // Label 694: @25845
     /*  25845 */   GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(25882), // Rule ID 22930 //
     /*  25850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25853 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25857 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  25861 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  25865 */     // MIs[1] Operand 1
     /*  25865 */     // No operand predicates
     /*  25865 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25867 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
     /*  25867 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri_ND),
     /*  25870 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  25872 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  25874 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  25877 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  25880 */     GIR_RootConstrainSelectedInstOperands,
     /*  25881 */     // GIR_Coverage, 22930,
     /*  25881 */     GIR_EraseRootFromParent_Done,
     /*  25882 */   // Label 695: @25882
     /*  25882 */   GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(25911), // Rule ID 22832 //
     /*  25887 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25890 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25894 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25898 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  25898 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr),
     /*  25903 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  25909 */     GIR_RootConstrainSelectedInstOperands,
     /*  25910 */     // GIR_Coverage, 22832,
     /*  25910 */     GIR_Done,
     /*  25911 */   // Label 696: @25911
     /*  25911 */   GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(25940), // Rule ID 22922 //
     /*  25916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  25919 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25923 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  25927 */     // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
     /*  25927 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr_ND),
     /*  25932 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  25938 */     GIR_RootConstrainSelectedInstOperands,
     /*  25939 */     // GIR_Coverage, 22922,
     /*  25939 */     GIR_Done,
     /*  25940 */   // Label 697: @25940
     /*  25940 */   GIM_Reject,
     /*  25941 */ // Label 689: @25941
     /*  25941 */ GIM_Reject,
     /*  25942 */ // Label 666: @25942
     /*  25942 */ GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(26538),
     /*  25947 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  25950 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  25953 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  25957 */   GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(26018), // Rule ID 26068 //
     /*  25962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  25965 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25969 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  25973 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  25976 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  25980 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  25984 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  25988 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  25990 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  25997 */     // (or:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (OR16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  25997 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm),
     /*  26000 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26002 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26004 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26008 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26011 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26016 */     GIR_RootConstrainSelectedInstOperands,
     /*  26017 */     // GIR_Coverage, 26068,
     /*  26017 */     GIR_EraseRootFromParent_Done,
     /*  26018 */   // Label 699: @26018
     /*  26018 */   GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(26079), // Rule ID 26087 //
     /*  26023 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26026 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26030 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26034 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26037 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26041 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26045 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26049 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26051 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26058 */     // (or:{ *:[i16] } (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>, GR16:{ *:[i16] }:$src1)  =>  (OR16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26058 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm_ND),
     /*  26061 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26063 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26065 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26069 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26072 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26077 */     GIR_RootConstrainSelectedInstOperands,
     /*  26078 */     // GIR_Coverage, 26087,
     /*  26078 */     GIR_EraseRootFromParent_Done,
     /*  26079 */   // Label 700: @26079
     /*  26079 */   GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(26140), // Rule ID 22837 //
     /*  26084 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26087 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26091 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26095 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26099 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26102 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26106 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26110 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26112 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26119 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (OR16rm:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26119 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm),
     /*  26122 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26124 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26126 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26130 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26133 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26138 */     GIR_RootConstrainSelectedInstOperands,
     /*  26139 */     // GIR_Coverage, 22837,
     /*  26139 */     GIR_EraseRootFromParent_Done,
     /*  26140 */   // Label 701: @26140
     /*  26140 */   GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(26201), // Rule ID 22927 //
     /*  26145 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26148 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26152 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26156 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26160 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26163 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26167 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi16),
     /*  26171 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26173 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26180 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (ld:{ *:[i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi16>>)  =>  (OR16rm_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26180 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16rm_ND),
     /*  26183 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26185 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26187 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26191 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26194 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26199 */     GIR_RootConstrainSelectedInstOperands,
     /*  26200 */     // GIR_Coverage, 22927,
     /*  26200 */     GIR_EraseRootFromParent_Done,
     /*  26201 */   // Label 702: @26201
     /*  26201 */   GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(26303), // Rule ID 26043 //
     /*  26206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  26214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  26218 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  26222 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  26226 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  26231 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26235 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26237 */     // (or:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  26237 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  26240 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  26244 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26249 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  26251 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  26254 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  26258 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26263 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  26266 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  26270 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  26273 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  26278 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  26283 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  26288 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
     /*  26291 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26293 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26295 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26298 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26301 */     GIR_RootConstrainSelectedInstOperands,
     /*  26302 */     // GIR_Coverage, 26043,
     /*  26302 */     GIR_EraseRootFromParent_Done,
     /*  26303 */   // Label 703: @26303
     /*  26303 */   GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(26405), // Rule ID 22781 //
     /*  26308 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26312 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26316 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  26320 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  26324 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  26328 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  26332 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  26337 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26339 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  26339 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  26342 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  26346 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26351 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  26353 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  26356 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  26360 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  26365 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  26368 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  26372 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  26375 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
     /*  26380 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
     /*  26385 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  26390 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
     /*  26393 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26395 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26397 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  26400 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26403 */     GIR_RootConstrainSelectedInstOperands,
     /*  26404 */     // GIR_Coverage, 22781,
     /*  26404 */     GIR_EraseRootFromParent_Done,
     /*  26405 */   // Label 704: @26405
     /*  26405 */   GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(26442), // Rule ID 22841 //
     /*  26410 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26413 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26417 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26421 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26425 */     // MIs[1] Operand 1
     /*  26425 */     // No operand predicates
     /*  26425 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26427 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  26427 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri),
     /*  26430 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26432 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26434 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  26437 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26440 */     GIR_RootConstrainSelectedInstOperands,
     /*  26441 */     // GIR_Coverage, 22841,
     /*  26441 */     GIR_EraseRootFromParent_Done,
     /*  26442 */   // Label 705: @26442
     /*  26442 */   GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(26479), // Rule ID 22931 //
     /*  26447 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26450 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26454 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26458 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  26462 */     // MIs[1] Operand 1
     /*  26462 */     // No operand predicates
     /*  26462 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26464 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
     /*  26464 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri_ND),
     /*  26467 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26469 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26471 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  26474 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26477 */     GIR_RootConstrainSelectedInstOperands,
     /*  26478 */     // GIR_Coverage, 22931,
     /*  26478 */     GIR_EraseRootFromParent_Done,
     /*  26479 */   // Label 706: @26479
     /*  26479 */   GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(26508), // Rule ID 22833 //
     /*  26484 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26487 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26491 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26495 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  26495 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr),
     /*  26500 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  26506 */     GIR_RootConstrainSelectedInstOperands,
     /*  26507 */     // GIR_Coverage, 22833,
     /*  26507 */     GIR_Done,
     /*  26508 */   // Label 707: @26508
     /*  26508 */   GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(26537), // Rule ID 22923 //
     /*  26513 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26516 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26520 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
     /*  26524 */     // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
     /*  26524 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr_ND),
     /*  26529 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  26535 */     GIR_RootConstrainSelectedInstOperands,
     /*  26536 */     // GIR_Coverage, 22923,
     /*  26536 */     GIR_Done,
     /*  26537 */   // Label 708: @26537
     /*  26537 */   GIM_Reject,
     /*  26538 */ // Label 698: @26538
     /*  26538 */ GIM_Reject,
     /*  26539 */ // Label 667: @26539
     /*  26539 */ GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(27994),
     /*  26544 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  26547 */   GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(26615), // Rule ID 26069 //
     /*  26552 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26555 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26558 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26562 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26566 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26570 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26573 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26577 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26581 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26585 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26587 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26594 */     // (or:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (OR32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26594 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm),
     /*  26597 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26599 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26601 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26605 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26608 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26613 */     GIR_RootConstrainSelectedInstOperands,
     /*  26614 */     // GIR_Coverage, 26069,
     /*  26614 */     GIR_EraseRootFromParent_Done,
     /*  26615 */   // Label 710: @26615
     /*  26615 */   GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(26683), // Rule ID 26088 //
     /*  26620 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26623 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26626 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26630 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26634 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26638 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26641 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26645 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26649 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26653 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26655 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26662 */     // (or:{ *:[i32] } (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>, GR32:{ *:[i32] }:$src1)  =>  (OR32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26662 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm_ND),
     /*  26665 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26667 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  26669 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26673 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26676 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26681 */     GIR_RootConstrainSelectedInstOperands,
     /*  26682 */     // GIR_Coverage, 26088,
     /*  26682 */     GIR_EraseRootFromParent_Done,
     /*  26683 */   // Label 711: @26683
     /*  26683 */   GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(26751), // Rule ID 22838 //
     /*  26688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  26691 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26694 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26698 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26710 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26713 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26717 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26721 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26723 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26730 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (OR32rm:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26730 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm),
     /*  26733 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26735 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26737 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26741 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26744 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26749 */     GIR_RootConstrainSelectedInstOperands,
     /*  26750 */     // GIR_Coverage, 22838,
     /*  26750 */     GIR_EraseRootFromParent_Done,
     /*  26751 */   // Label 712: @26751
     /*  26751 */   GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(26819), // Rule ID 22928 //
     /*  26756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  26759 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26762 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26766 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26770 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  26774 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  26778 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  26781 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  26785 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_loadi32),
     /*  26789 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  26791 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  26798 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (ld:{ *:[i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_loadi32>>)  =>  (OR32rm_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  26798 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32rm_ND),
     /*  26801 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26803 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  26805 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  26809 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26812 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  26817 */     GIR_RootConstrainSelectedInstOperands,
     /*  26818 */     // GIR_Coverage, 22928,
     /*  26818 */     GIR_EraseRootFromParent_Done,
     /*  26819 */   // Label 713: @26819
     /*  26819 */   GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(26896), // Rule ID 25009 //
     /*  26824 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26827 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26830 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26834 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26838 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26842 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26846 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26850 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26855 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  26859 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  26863 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26867 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26871 */     // MIs[2] src
     /*  26871 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  26876 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  26880 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26882 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  26882 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
     /*  26885 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26887 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  26891 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26894 */     GIR_RootConstrainSelectedInstOperands,
     /*  26895 */     // GIR_Coverage, 25009,
     /*  26895 */     GIR_EraseRootFromParent_Done,
     /*  26896 */   // Label 714: @26896
     /*  26896 */   GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(26973), // Rule ID 25011 //
     /*  26901 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26904 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  26907 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26911 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26915 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26919 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26923 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26927 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26932 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  26936 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  26940 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26944 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26948 */     // MIs[2] src
     /*  26948 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  26953 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  26957 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  26959 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  26959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
     /*  26962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  26964 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  26968 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  26971 */     GIR_RootConstrainSelectedInstOperands,
     /*  26972 */     // GIR_Coverage, 25011,
     /*  26972 */     GIR_EraseRootFromParent_Done,
     /*  26973 */   // Label 715: @26973
     /*  26973 */   GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(27051), // Rule ID 24997 //
     /*  26978 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  26981 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  26985 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26989 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26993 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  26997 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27001 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27005 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27009 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27013 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27017 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27022 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27026 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27030 */     // MIs[0] src
     /*  27030 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27035 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27037 */     // (or:{ *:[i32] } (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27037 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27040 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
     /*  27046 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27049 */     GIR_RootConstrainSelectedInstOperands,
     /*  27050 */     // GIR_Coverage, 24997,
     /*  27050 */     GIR_EraseRootFromParent_Done,
     /*  27051 */   // Label 716: @27051
     /*  27051 */   GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(27128), // Rule ID 17362 //
     /*  27056 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27059 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27062 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27066 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27070 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27074 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27078 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27082 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27087 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27091 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27095 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27099 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27103 */     // MIs[2] src
     /*  27103 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27108 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  27112 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27114 */     // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27114 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
     /*  27117 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27119 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27123 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27126 */     GIR_RootConstrainSelectedInstOperands,
     /*  27127 */     // GIR_Coverage, 17362,
     /*  27127 */     GIR_EraseRootFromParent_Done,
     /*  27128 */   // Label 717: @27128
     /*  27128 */   GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(27205), // Rule ID 17364 //
     /*  27133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27136 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27139 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27143 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27147 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27151 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27155 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27159 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27164 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27168 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  27172 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27180 */     // MIs[2] src
     /*  27180 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27185 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27189 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27191 */     // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27191 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
     /*  27194 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27196 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27200 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27203 */     GIR_RootConstrainSelectedInstOperands,
     /*  27204 */     // GIR_Coverage, 17364,
     /*  27204 */     GIR_EraseRootFromParent_Done,
     /*  27205 */   // Label 718: @27205
     /*  27205 */   GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(27279), // Rule ID 17350 //
     /*  27210 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27213 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27216 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27220 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27224 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27228 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27232 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27236 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27240 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27244 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27248 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27252 */     // MIs[2] src
     /*  27252 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27257 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  27261 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27265 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  27267 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27267 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27270 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27272 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27274 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27277 */     GIR_RootConstrainSelectedInstOperands,
     /*  27278 */     // GIR_Coverage, 17350,
     /*  27278 */     GIR_EraseRootFromParent_Done,
     /*  27279 */   // Label 719: @27279
     /*  27279 */   GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(27337), // Rule ID 25005 //
     /*  27284 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27287 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27291 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27295 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27299 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27303 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27307 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27312 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  27316 */     // MIs[0] src
     /*  27316 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27321 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27323 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27323 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
     /*  27326 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27328 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27332 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27335 */     GIR_RootConstrainSelectedInstOperands,
     /*  27336 */     // GIR_Coverage, 25005,
     /*  27336 */     GIR_EraseRootFromParent_Done,
     /*  27337 */   // Label 720: @27337
     /*  27337 */   GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(27395), // Rule ID 25007 //
     /*  27342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27345 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27349 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27353 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27357 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27361 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27365 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27370 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27374 */     // MIs[0] src
     /*  27374 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  27379 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27381 */     // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27381 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
     /*  27384 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27386 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  27390 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27393 */     GIR_RootConstrainSelectedInstOperands,
     /*  27394 */     // GIR_Coverage, 25007,
     /*  27394 */     GIR_EraseRootFromParent_Done,
     /*  27395 */   // Label 721: @27395
     /*  27395 */   GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(27504), // Rule ID 26049 //
     /*  27400 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27403 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27407 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27411 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  27415 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27419 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  27423 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  27427 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  27432 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27436 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27438 */     // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  27438 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  27441 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  27445 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27450 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  27452 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  27455 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  27459 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27464 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  27467 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  27471 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  27474 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27479 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27484 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  27489 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
     /*  27492 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27494 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  27496 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  27499 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27502 */     GIR_RootConstrainSelectedInstOperands,
     /*  27503 */     // GIR_Coverage, 26049,
     /*  27503 */     GIR_EraseRootFromParent_Done,
     /*  27504 */   // Label 722: @27504
     /*  27504 */   GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(27562), // Rule ID 24999 //
     /*  27509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27512 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  27524 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27528 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27532 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  27536 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27541 */     // MIs[0] src
     /*  27541 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  27546 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27548 */     // (or:{ *:[i32] } (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27553 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
     /*  27557 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27560 */     GIR_RootConstrainSelectedInstOperands,
     /*  27561 */     // GIR_Coverage, 24999,
     /*  27561 */     GIR_EraseRootFromParent_Done,
     /*  27562 */   // Label 723: @27562
     /*  27562 */   GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(27616), // Rule ID 17358 //
     /*  27567 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27570 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27573 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27577 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27581 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27585 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27589 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27593 */     // MIs[1] src
     /*  27593 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27598 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  27602 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27604 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27604 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
     /*  27607 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27609 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27611 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27614 */     GIR_RootConstrainSelectedInstOperands,
     /*  27615 */     // GIR_Coverage, 17358,
     /*  27615 */     GIR_EraseRootFromParent_Done,
     /*  27616 */   // Label 724: @27616
     /*  27616 */   GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(27670), // Rule ID 17360 //
     /*  27621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27624 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27627 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27631 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27635 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27639 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27643 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27647 */     // MIs[1] src
     /*  27647 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27652 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  27656 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27658 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27658 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
     /*  27661 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27663 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27665 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27668 */     GIR_RootConstrainSelectedInstOperands,
     /*  27669 */     // GIR_Coverage, 17360,
     /*  27669 */     GIR_EraseRootFromParent_Done,
     /*  27670 */   // Label 725: @27670
     /*  27670 */   GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(27779), // Rule ID 22787 //
     /*  27675 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27678 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27682 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  27694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27698 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  27702 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  27706 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  27711 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27713 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  27713 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
     /*  27716 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  27720 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27725 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  27727 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*  27730 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  27734 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  27739 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  27742 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  27746 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  27749 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27754 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
     /*  27759 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  27764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
     /*  27767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27769 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27771 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  27774 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27777 */     GIR_RootConstrainSelectedInstOperands,
     /*  27778 */     // GIR_Coverage, 22787,
     /*  27778 */     GIR_EraseRootFromParent_Done,
     /*  27779 */   // Label 726: @27779
     /*  27779 */   GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(27833), // Rule ID 17352 //
     /*  27784 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  27787 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27794 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27798 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27802 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  27806 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  27810 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  27814 */     // MIs[1] src
     /*  27814 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  27819 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27821 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
     /*  27821 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
     /*  27824 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27826 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  27828 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27831 */     GIR_RootConstrainSelectedInstOperands,
     /*  27832 */     // GIR_Coverage, 17352,
     /*  27832 */     GIR_EraseRootFromParent_Done,
     /*  27833 */   // Label 727: @27833
     /*  27833 */   GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(27877), // Rule ID 22842 //
     /*  27838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  27841 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27844 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27848 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27852 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27856 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27860 */     // MIs[1] Operand 1
     /*  27860 */     // No operand predicates
     /*  27860 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27862 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  27862 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri),
     /*  27865 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27867 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27869 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  27872 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27875 */     GIR_RootConstrainSelectedInstOperands,
     /*  27876 */     // GIR_Coverage, 22842,
     /*  27876 */     GIR_EraseRootFromParent_Done,
     /*  27877 */   // Label 728: @27877
     /*  27877 */   GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(27921), // Rule ID 22932 //
     /*  27882 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  27885 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27888 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27892 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27896 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  27900 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  27904 */     // MIs[1] Operand 1
     /*  27904 */     // No operand predicates
     /*  27904 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  27906 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
     /*  27906 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri_ND),
     /*  27909 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  27911 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  27913 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  27916 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  27919 */     GIR_RootConstrainSelectedInstOperands,
     /*  27920 */     // GIR_Coverage, 22932,
     /*  27920 */     GIR_EraseRootFromParent_Done,
     /*  27921 */   // Label 729: @27921
     /*  27921 */   GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(27957), // Rule ID 22834 //
     /*  27926 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  27929 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27932 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27936 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27940 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27944 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  27944 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr),
     /*  27949 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  27955 */     GIR_RootConstrainSelectedInstOperands,
     /*  27956 */     // GIR_Coverage, 22834,
     /*  27956 */     GIR_Done,
     /*  27957 */   // Label 730: @27957
     /*  27957 */   GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(27993), // Rule ID 22924 //
     /*  27962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  27965 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  27968 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27972 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27976 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
     /*  27980 */     // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
     /*  27980 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr_ND),
     /*  27985 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  27991 */     GIR_RootConstrainSelectedInstOperands,
     /*  27992 */     // GIR_Coverage, 22924,
     /*  27992 */     GIR_Done,
     /*  27993 */   // Label 731: @27993
     /*  27993 */   GIM_Reject,
     /*  27994 */ // Label 709: @27994
     /*  27994 */ GIM_Reject,
     /*  27995 */ // Label 668: @27995
     /*  27995 */ GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(29458),
     /*  28000 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  28003 */   GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(28071), // Rule ID 26070 //
     /*  28008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  28011 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28014 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28018 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28022 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28026 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28029 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28033 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28037 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28041 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28043 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28050 */     // (or:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (OR64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28050 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm),
     /*  28053 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28055 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28057 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28061 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28064 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28069 */     GIR_RootConstrainSelectedInstOperands,
     /*  28070 */     // GIR_Coverage, 26070,
     /*  28070 */     GIR_EraseRootFromParent_Done,
     /*  28071 */   // Label 733: @28071
     /*  28071 */   GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(28139), // Rule ID 26089 //
     /*  28076 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  28079 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28082 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28086 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28090 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28094 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28097 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28101 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28105 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28109 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28111 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28118 */     // (or:{ *:[i64] } (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, GR64:{ *:[i64] }:$src1)  =>  (OR64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28118 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm_ND),
     /*  28121 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28123 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28125 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28129 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28132 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28137 */     GIR_RootConstrainSelectedInstOperands,
     /*  28138 */     // GIR_Coverage, 26089,
     /*  28138 */     GIR_EraseRootFromParent_Done,
     /*  28139 */   // Label 734: @28139
     /*  28139 */   GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(28207), // Rule ID 22839 //
     /*  28144 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  28147 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28150 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28154 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28158 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28162 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28166 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28169 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28173 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28177 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28179 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28186 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (OR64rm:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28186 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm),
     /*  28189 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28191 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  28193 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28197 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28200 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28205 */     GIR_RootConstrainSelectedInstOperands,
     /*  28206 */     // GIR_Coverage, 22839,
     /*  28206 */     GIR_EraseRootFromParent_Done,
     /*  28207 */   // Label 735: @28207
     /*  28207 */   GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(28275), // Rule ID 22929 //
     /*  28212 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  28215 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28218 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28222 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  28234 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  28237 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  28241 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  28245 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28247 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  28254 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (ld:{ *:[i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (OR64rm_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  28254 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64rm_ND),
     /*  28257 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28259 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  28261 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  28265 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28268 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  28273 */     GIR_RootConstrainSelectedInstOperands,
     /*  28274 */     // GIR_Coverage, 22929,
     /*  28274 */     GIR_EraseRootFromParent_Done,
     /*  28275 */   // Label 736: @28275
     /*  28275 */   GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(28352), // Rule ID 25010 //
     /*  28280 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28283 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28286 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28290 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28294 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28298 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28302 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28306 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28311 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28315 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28319 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28323 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28327 */     // MIs[2] src
     /*  28327 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28332 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  28336 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28338 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28338 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
     /*  28341 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28343 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28347 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28350 */     GIR_RootConstrainSelectedInstOperands,
     /*  28351 */     // GIR_Coverage, 25010,
     /*  28351 */     GIR_EraseRootFromParent_Done,
     /*  28352 */   // Label 737: @28352
     /*  28352 */   GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(28429), // Rule ID 25012 //
     /*  28357 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28360 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28363 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28367 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28371 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28375 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28379 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28383 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28388 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  28392 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28396 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28400 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28404 */     // MIs[2] src
     /*  28404 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28409 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  28413 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28415 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
     /*  28418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28424 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28427 */     GIR_RootConstrainSelectedInstOperands,
     /*  28428 */     // GIR_Coverage, 25012,
     /*  28428 */     GIR_EraseRootFromParent_Done,
     /*  28429 */   // Label 738: @28429
     /*  28429 */   GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(28507), // Rule ID 24998 //
     /*  28434 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28437 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28441 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28445 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28449 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28453 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28457 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28461 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28465 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*  28469 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28473 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28478 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28482 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28486 */     // MIs[0] src
     /*  28486 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28491 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28493 */     // (or:{ *:[i64] } (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  28496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28498 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
     /*  28502 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28505 */     GIR_RootConstrainSelectedInstOperands,
     /*  28506 */     // GIR_Coverage, 24998,
     /*  28506 */     GIR_EraseRootFromParent_Done,
     /*  28507 */   // Label 739: @28507
     /*  28507 */   GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(28584), // Rule ID 17363 //
     /*  28512 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28515 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28518 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28522 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28526 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28530 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28534 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28538 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28543 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28547 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28551 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28555 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28559 */     // MIs[2] src
     /*  28559 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28564 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  28568 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28570 */     // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28570 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
     /*  28573 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28575 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28579 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28582 */     GIR_RootConstrainSelectedInstOperands,
     /*  28583 */     // GIR_Coverage, 17363,
     /*  28583 */     GIR_EraseRootFromParent_Done,
     /*  28584 */   // Label 740: @28584
     /*  28584 */   GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(28661), // Rule ID 17365 //
     /*  28589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28592 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28595 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28599 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28603 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28607 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28611 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28615 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28620 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28624 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  28628 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28632 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28636 */     // MIs[2] src
     /*  28636 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28641 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28645 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28647 */     // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28647 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
     /*  28650 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28656 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28659 */     GIR_RootConstrainSelectedInstOperands,
     /*  28660 */     // GIR_Coverage, 17365,
     /*  28660 */     GIR_EraseRootFromParent_Done,
     /*  28661 */   // Label 741: @28661
     /*  28661 */   GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(28735), // Rule ID 17351 //
     /*  28666 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28669 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28672 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28676 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28680 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  28684 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28688 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28692 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28696 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28700 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28704 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*  28708 */     // MIs[2] src
     /*  28708 */     GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  28713 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*  28717 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28721 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  28723 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28723 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  28726 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28728 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  28730 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28733 */     GIR_RootConstrainSelectedInstOperands,
     /*  28734 */     // GIR_Coverage, 17351,
     /*  28734 */     GIR_EraseRootFromParent_Done,
     /*  28735 */   // Label 742: @28735
     /*  28735 */   GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(28793), // Rule ID 25006 //
     /*  28740 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28743 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28747 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28751 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28755 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28759 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28763 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28768 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  28772 */     // MIs[0] src
     /*  28772 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28777 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28779 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28779 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
     /*  28782 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28784 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28788 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28791 */     GIR_RootConstrainSelectedInstOperands,
     /*  28792 */     // GIR_Coverage, 25006,
     /*  28792 */     GIR_EraseRootFromParent_Done,
     /*  28793 */   // Label 743: @28793
     /*  28793 */   GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(28851), // Rule ID 25008 //
     /*  28798 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28801 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28805 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28809 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28813 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28817 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28821 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28826 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  28830 */     // MIs[0] src
     /*  28830 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  28835 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28837 */     // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  28837 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
     /*  28840 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28842 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  28846 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28849 */     GIR_RootConstrainSelectedInstOperands,
     /*  28850 */     // GIR_Coverage, 25008,
     /*  28850 */     GIR_EraseRootFromParent_Done,
     /*  28851 */   // Label 744: @28851
     /*  28851 */   GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(28960), // Rule ID 26055 //
     /*  28856 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  28859 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28863 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28867 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  28871 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28875 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  28879 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  28883 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  28888 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28892 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  28894 */     // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  28894 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  28897 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  28901 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  28906 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  28908 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  28911 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  28915 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  28920 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  28923 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  28927 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  28930 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  28935 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  28940 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  28945 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
     /*  28948 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  28950 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  28952 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  28955 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  28958 */     GIR_RootConstrainSelectedInstOperands,
     /*  28959 */     // GIR_Coverage, 26055,
     /*  28959 */     GIR_EraseRootFromParent_Done,
     /*  28960 */   // Label 745: @28960
     /*  28960 */   GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(29018), // Rule ID 25000 //
     /*  28965 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  28968 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28972 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28976 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  28980 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  28984 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  28988 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  28992 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  28997 */     // MIs[0] src
     /*  28997 */     GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  29002 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29004 */     // (or:{ *:[i64] } (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29004 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  29007 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29009 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
     /*  29013 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29016 */     GIR_RootConstrainSelectedInstOperands,
     /*  29017 */     // GIR_Coverage, 25000,
     /*  29017 */     GIR_EraseRootFromParent_Done,
     /*  29018 */   // Label 746: @29018
     /*  29018 */   GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(29072), // Rule ID 17359 //
     /*  29023 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29026 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29029 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29033 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29037 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29041 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29045 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  29049 */     // MIs[1] src
     /*  29049 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29054 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  29058 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29060 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29060 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
     /*  29063 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29065 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29067 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29070 */     GIR_RootConstrainSelectedInstOperands,
     /*  29071 */     // GIR_Coverage, 17359,
     /*  29071 */     GIR_EraseRootFromParent_Done,
     /*  29072 */   // Label 747: @29072
     /*  29072 */   GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(29126), // Rule ID 17361 //
     /*  29077 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29080 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29083 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29087 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29091 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29095 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29099 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  29103 */     // MIs[1] src
     /*  29103 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29108 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  29112 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29114 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29114 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
     /*  29117 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29119 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29121 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29124 */     GIR_RootConstrainSelectedInstOperands,
     /*  29125 */     // GIR_Coverage, 17361,
     /*  29125 */     GIR_EraseRootFromParent_Done,
     /*  29126 */   // Label 748: @29126
     /*  29126 */   GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(29235), // Rule ID 22793 //
     /*  29131 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29138 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29142 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29146 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  29150 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  29154 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
     /*  29158 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  29162 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
     /*  29167 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29169 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
     /*  29169 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
     /*  29172 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  29176 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29181 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
     /*  29183 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  29186 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
     /*  29190 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29195 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29198 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  29202 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*  29205 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  29210 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
     /*  29215 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
     /*  29220 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
     /*  29223 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29225 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29227 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29230 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29233 */     GIR_RootConstrainSelectedInstOperands,
     /*  29234 */     // GIR_Coverage, 22793,
     /*  29234 */     GIR_EraseRootFromParent_Done,
     /*  29235 */   // Label 749: @29235
     /*  29235 */   GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(29289), // Rule ID 17353 //
     /*  29240 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
     /*  29243 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29246 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29250 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29254 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29258 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  29262 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  29266 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 254,
     /*  29270 */     // MIs[1] src
     /*  29270 */     GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  29275 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29277 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
     /*  29277 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
     /*  29280 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29282 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  29284 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29287 */     GIR_RootConstrainSelectedInstOperands,
     /*  29288 */     // GIR_Coverage, 17353,
     /*  29288 */     GIR_EraseRootFromParent_Done,
     /*  29289 */   // Label 750: @29289
     /*  29289 */   GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(29337), // Rule ID 22843 //
     /*  29294 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  29297 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29304 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29308 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29312 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29316 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  29320 */     // MIs[1] Operand 1
     /*  29320 */     // No operand predicates
     /*  29320 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29322 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  29322 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32),
     /*  29325 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29327 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29329 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  29332 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29335 */     GIR_RootConstrainSelectedInstOperands,
     /*  29336 */     // GIR_Coverage, 22843,
     /*  29336 */     GIR_EraseRootFromParent_Done,
     /*  29337 */   // Label 751: @29337
     /*  29337 */   GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(29385), // Rule ID 22933 //
     /*  29342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  29345 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29348 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29352 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29356 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29360 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  29364 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
     /*  29368 */     // MIs[1] Operand 1
     /*  29368 */     // No operand predicates
     /*  29368 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29370 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
     /*  29370 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32_ND),
     /*  29373 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29375 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29377 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
     /*  29380 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
     /*  29383 */     GIR_RootConstrainSelectedInstOperands,
     /*  29384 */     // GIR_Coverage, 22933,
     /*  29384 */     GIR_EraseRootFromParent_Done,
     /*  29385 */   // Label 752: @29385
     /*  29385 */   GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(29421), // Rule ID 22835 //
     /*  29390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
     /*  29393 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29396 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29400 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29404 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29408 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  29408 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr),
     /*  29413 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  29419 */     GIR_RootConstrainSelectedInstOperands,
     /*  29420 */     // GIR_Coverage, 22835,
     /*  29420 */     GIR_Done,
     /*  29421 */   // Label 753: @29421
     /*  29421 */   GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(29457), // Rule ID 22925 //
     /*  29426 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
     /*  29429 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  29432 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29436 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29440 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
     /*  29444 */     // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
     /*  29444 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr_ND),
     /*  29449 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
     /*  29455 */     GIR_RootConstrainSelectedInstOperands,
     /*  29456 */     // GIR_Coverage, 22925,
     /*  29456 */     GIR_Done,
     /*  29457 */   // Label 754: @29457
     /*  29457 */   GIM_Reject,
     /*  29458 */ // Label 732: @29458
     /*  29458 */ GIM_Reject,
     /*  29459 */ // Label 669: @29459
     /*  29459 */ GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(29558), // Rule ID 19493 //
     /*  29464 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
     /*  29467 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
     /*  29470 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29474 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29478 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
     /*  29482 */   // (or:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
     /*  29482 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  29485 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29489 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29494 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  29498 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29503 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  29506 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29510 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29515 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  29519 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29524 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  29527 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  29531 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29536 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29539 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  29542 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  29544 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29547 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29549 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29552 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
     /*  29557 */   // GIR_Coverage, 19493,
     /*  29557 */   GIR_EraseRootFromParent_Done,
     /*  29558 */ // Label 755: @29558
     /*  29558 */ GIM_Reject,
     /*  29559 */ // Label 670: @29559
     /*  29559 */ GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(29900),
     /*  29564 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  29567 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*  29570 */   GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(29632), // Rule ID 23369 //
     /*  29575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29582 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29586 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29590 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29593 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29597 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29601 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29605 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29607 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29614 */     // (or:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v2i64] }:$src1)  =>  (VPORrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  29617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29619 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  29621 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29625 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29630 */     GIR_RootConstrainSelectedInstOperands,
     /*  29631 */     // GIR_Coverage, 23369,
     /*  29631 */     GIR_EraseRootFromParent_Done,
     /*  29632 */   // Label 757: @29632
     /*  29632 */   GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(29694), // Rule ID 24191 //
     /*  29637 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29640 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29644 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29648 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29652 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29655 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29659 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29663 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29667 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29669 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29676 */     // (or:{ *:[v2i64] } (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v2i64] }:$src1)  =>  (VPORQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29676 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  29679 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29681 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  29683 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29687 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29692 */     GIR_RootConstrainSelectedInstOperands,
     /*  29693 */     // GIR_Coverage, 24191,
     /*  29693 */     GIR_EraseRootFromParent_Done,
     /*  29694 */   // Label 758: @29694
     /*  29694 */   GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(29756), // Rule ID 2115 //
     /*  29699 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29702 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29706 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29710 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29714 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29718 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29721 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29725 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29729 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29731 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29738 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29738 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  29741 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29743 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29745 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29749 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29754 */     GIR_RootConstrainSelectedInstOperands,
     /*  29755 */     // GIR_Coverage, 2115,
     /*  29755 */     GIR_EraseRootFromParent_Done,
     /*  29756 */   // Label 759: @29756
     /*  29756 */   GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(29818), // Rule ID 5759 //
     /*  29761 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29764 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29768 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29772 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  29776 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  29780 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  29783 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  29787 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  29791 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  29793 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  29800 */     // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, (ld:{ *:[v2i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  29800 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  29803 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29805 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  29807 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  29811 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  29816 */     GIR_RootConstrainSelectedInstOperands,
     /*  29817 */     // GIR_Coverage, 5759,
     /*  29817 */     GIR_EraseRootFromParent_Done,
     /*  29818 */   // Label 760: @29818
     /*  29818 */   GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(29845), // Rule ID 2114 //
     /*  29823 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  29826 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29830 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29834 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29838 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  29838 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  29843 */     GIR_RootConstrainSelectedInstOperands,
     /*  29844 */     // GIR_Coverage, 2114,
     /*  29844 */     GIR_Done,
     /*  29845 */   // Label 761: @29845
     /*  29845 */   GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(29872), // Rule ID 2116 //
     /*  29850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  29853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29857 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29861 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  29865 */     // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
     /*  29865 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  29870 */     GIR_RootConstrainSelectedInstOperands,
     /*  29871 */     // GIR_Coverage, 2116,
     /*  29871 */     GIR_Done,
     /*  29872 */   // Label 762: @29872
     /*  29872 */   GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(29899), // Rule ID 5756 //
     /*  29877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  29880 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29884 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29888 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  29892 */     // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
     /*  29892 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  29897 */     GIR_RootConstrainSelectedInstOperands,
     /*  29898 */     // GIR_Coverage, 5756,
     /*  29898 */     GIR_Done,
     /*  29899 */   // Label 763: @29899
     /*  29899 */   GIM_Reject,
     /*  29900 */ // Label 756: @29900
     /*  29900 */ GIM_Reject,
     /*  29901 */ // Label 671: @29901
     /*  29901 */ GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(30000), // Rule ID 19494 //
     /*  29906 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
     /*  29909 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
     /*  29912 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29916 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29920 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
     /*  29924 */   // (or:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
     /*  29924 */   GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  29927 */   GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29931 */   GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29936 */   GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  29940 */   GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29945 */   GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  29948 */   GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29952 */   GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29957 */   GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  29961 */   GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  29966 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  29969 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  29973 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  29978 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  29981 */   GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  29984 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  29986 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  29989 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  29991 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  29994 */   GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
     /*  29999 */   // GIR_Coverage, 19494,
     /*  29999 */   GIR_EraseRootFromParent_Done,
     /*  30000 */ // Label 764: @30000
     /*  30000 */ GIM_Reject,
     /*  30001 */ // Label 672: @30001
     /*  30001 */ GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(30342),
     /*  30006 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30009 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30012 */   GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(30074), // Rule ID 24209 //
     /*  30017 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30020 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30024 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30028 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30032 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30035 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30039 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30043 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30047 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30049 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30056 */     // (or:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v4i32] }:$src1)  =>  (VPORDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30056 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rm),
     /*  30059 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30061 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30063 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30067 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30072 */     GIR_RootConstrainSelectedInstOperands,
     /*  30073 */     // GIR_Coverage, 24209,
     /*  30073 */     GIR_EraseRootFromParent_Done,
     /*  30074 */   // Label 766: @30074
     /*  30074 */   GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(30136), // Rule ID 25262 //
     /*  30079 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30082 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30086 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30090 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30094 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30097 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30101 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30105 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30109 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30111 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30118 */     // (or:{ *:[v4i32] } (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v4i32] }:$src1)  =>  (VPORrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30118 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30121 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30123 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30125 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30129 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30134 */     GIR_RootConstrainSelectedInstOperands,
     /*  30135 */     // GIR_Coverage, 25262,
     /*  30135 */     GIR_EraseRootFromParent_Done,
     /*  30136 */   // Label 767: @30136
     /*  30136 */   GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(30198), // Rule ID 5786 //
     /*  30141 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30148 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30152 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30156 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30160 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30163 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30167 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30171 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30173 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30180 */     // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORDZ128rm:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30180 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rm),
     /*  30183 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30185 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30187 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30191 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30196 */     GIR_RootConstrainSelectedInstOperands,
     /*  30197 */     // GIR_Coverage, 5786,
     /*  30197 */     GIR_EraseRootFromParent_Done,
     /*  30198 */   // Label 768: @30198
     /*  30198 */   GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(30260), // Rule ID 18163 //
     /*  30203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30210 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30214 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30218 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30222 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30225 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30229 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30233 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30235 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30242 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, (ld:{ *:[v4i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30247 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30249 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30253 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30258 */     GIR_RootConstrainSelectedInstOperands,
     /*  30259 */     // GIR_Coverage, 18163,
     /*  30259 */     GIR_EraseRootFromParent_Done,
     /*  30260 */   // Label 769: @30260
     /*  30260 */   GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(30287), // Rule ID 5783 //
     /*  30265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30272 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30276 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  30280 */     // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
     /*  30280 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rr),
     /*  30285 */     GIR_RootConstrainSelectedInstOperands,
     /*  30286 */     // GIR_Coverage, 5783,
     /*  30286 */     GIR_Done,
     /*  30287 */   // Label 770: @30287
     /*  30287 */   GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(30314), // Rule ID 18151 //
     /*  30292 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30295 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30299 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30303 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30307 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  30307 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  30312 */     GIR_RootConstrainSelectedInstOperands,
     /*  30313 */     // GIR_Coverage, 18151,
     /*  30313 */     GIR_Done,
     /*  30314 */   // Label 771: @30314
     /*  30314 */   GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(30341), // Rule ID 18175 //
     /*  30319 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  30322 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30326 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30330 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30334 */     // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
     /*  30334 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  30339 */     GIR_RootConstrainSelectedInstOperands,
     /*  30340 */     // GIR_Coverage, 18175,
     /*  30340 */     GIR_Done,
     /*  30341 */   // Label 772: @30341
     /*  30341 */   GIM_Reject,
     /*  30342 */ // Label 765: @30342
     /*  30342 */ GIM_Reject,
     /*  30343 */ // Label 673: @30343
     /*  30343 */ GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(30808),
     /*  30348 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
     /*  30351 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
     /*  30354 */   GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(30416), // Rule ID 23371 //
     /*  30359 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30362 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30366 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30370 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30374 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30377 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30381 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30385 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30389 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30391 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30398 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VPORYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30398 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  30401 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30403 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30405 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30409 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30414 */     GIR_RootConstrainSelectedInstOperands,
     /*  30415 */     // GIR_Coverage, 23371,
     /*  30415 */     GIR_EraseRootFromParent_Done,
     /*  30416 */   // Label 774: @30416
     /*  30416 */   GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(30478), // Rule ID 24185 //
     /*  30421 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30424 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30428 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30432 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30436 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30439 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30443 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30447 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30451 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30453 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30460 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v4i64] }:$src1)  =>  (VPORQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30460 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  30463 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30465 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30467 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30471 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30476 */     GIR_RootConstrainSelectedInstOperands,
     /*  30477 */     // GIR_Coverage, 24185,
     /*  30477 */     GIR_EraseRootFromParent_Done,
     /*  30478 */   // Label 775: @30478
     /*  30478 */   GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(30540), // Rule ID 25252 //
     /*  30483 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30486 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30490 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30494 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30498 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30501 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30505 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30509 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30513 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30515 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30522 */     // (or:{ *:[v4i64] } (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v4i64] }:$src1)  =>  (VORPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30522 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  30525 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30527 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30529 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30533 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30538 */     GIR_RootConstrainSelectedInstOperands,
     /*  30539 */     // GIR_Coverage, 25252,
     /*  30539 */     GIR_EraseRootFromParent_Done,
     /*  30540 */   // Label 776: @30540
     /*  30540 */   GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(30602), // Rule ID 2119 //
     /*  30545 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30548 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30552 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30556 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30560 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30564 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30567 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30571 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30575 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30577 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30584 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30584 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  30587 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30589 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30591 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30595 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30600 */     GIR_RootConstrainSelectedInstOperands,
     /*  30601 */     // GIR_Coverage, 2119,
     /*  30601 */     GIR_EraseRootFromParent_Done,
     /*  30602 */   // Label 777: @30602
     /*  30602 */   GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(30664), // Rule ID 5750 //
     /*  30607 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30610 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30614 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30618 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30622 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30626 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30629 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30633 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30637 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30639 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30646 */     // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ256rm:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30646 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  30649 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30651 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30653 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30657 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30662 */     GIR_RootConstrainSelectedInstOperands,
     /*  30663 */     // GIR_Coverage, 5750,
     /*  30663 */     GIR_EraseRootFromParent_Done,
     /*  30664 */   // Label 778: @30664
     /*  30664 */   GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(30726), // Rule ID 18137 //
     /*  30669 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30672 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30676 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30680 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  30684 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30688 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30691 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30695 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30699 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30701 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30708 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, (ld:{ *:[v4i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30708 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  30711 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30713 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  30715 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30719 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  30724 */     GIR_RootConstrainSelectedInstOperands,
     /*  30725 */     // GIR_Coverage, 18137,
     /*  30725 */     GIR_EraseRootFromParent_Done,
     /*  30726 */   // Label 779: @30726
     /*  30726 */   GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(30753), // Rule ID 2118 //
     /*  30731 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  30734 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30738 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30742 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30746 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  30746 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  30751 */     GIR_RootConstrainSelectedInstOperands,
     /*  30752 */     // GIR_Coverage, 2118,
     /*  30752 */     GIR_Done,
     /*  30753 */   // Label 780: @30753
     /*  30753 */   GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(30780), // Rule ID 5747 //
     /*  30758 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  30761 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30765 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30769 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  30773 */     // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
     /*  30773 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
     /*  30778 */     GIR_RootConstrainSelectedInstOperands,
     /*  30779 */     // GIR_Coverage, 5747,
     /*  30779 */     GIR_Done,
     /*  30780 */   // Label 781: @30780
     /*  30780 */   GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(30807), // Rule ID 18121 //
     /*  30785 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  30788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30792 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30796 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  30800 */     // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
     /*  30800 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  30805 */     GIR_RootConstrainSelectedInstOperands,
     /*  30806 */     // GIR_Coverage, 18121,
     /*  30806 */     GIR_Done,
     /*  30807 */   // Label 782: @30807
     /*  30807 */   GIM_Reject,
     /*  30808 */ // Label 773: @30808
     /*  30808 */ GIM_Reject,
     /*  30809 */ // Label 674: @30809
     /*  30809 */ GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(30932),
     /*  30814 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
     /*  30817 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
     /*  30820 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30824 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30828 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
     /*  30832 */   GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(30847), // Rule ID 4417 //
     /*  30837 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
     /*  30840 */     // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
     /*  30840 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORBkk),
     /*  30845 */     GIR_RootConstrainSelectedInstOperands,
     /*  30846 */     // GIR_Coverage, 4417,
     /*  30846 */     GIR_Done,
     /*  30847 */   // Label 784: @30847
     /*  30847 */   GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(30931), // Rule ID 19491 //
     /*  30852 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
     /*  30855 */     // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
     /*  30855 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
     /*  30858 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30862 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30867 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  30871 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  30876 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
     /*  30879 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30883 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30888 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
     /*  30892 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
     /*  30897 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
     /*  30900 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  30904 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  30909 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  30912 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  30915 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  30917 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  30920 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30922 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  30925 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
     /*  30930 */     // GIR_Coverage, 19491,
     /*  30930 */     GIR_EraseRootFromParent_Done,
     /*  30931 */   // Label 785: @30931
     /*  30931 */   GIM_Reject,
     /*  30932 */ // Label 783: @30932
     /*  30932 */ GIM_Reject,
     /*  30933 */ // Label 675: @30933
     /*  30933 */ GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(31274),
     /*  30938 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*  30941 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*  30944 */   GIM_Try, /*On fail goto*//*Label 787*/ GIMT_Encode4(31006), // Rule ID 25261 //
     /*  30949 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  30952 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30956 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30960 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  30964 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  30967 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  30971 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  30975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  30979 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  30981 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  30988 */     // (or:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v8i16] }:$src1)  =>  (VPORrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  30988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  30991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  30993 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  30995 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  30999 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31004 */     GIR_RootConstrainSelectedInstOperands,
     /*  31005 */     // GIR_Coverage, 25261,
     /*  31005 */     GIR_EraseRootFromParent_Done,
     /*  31006 */   // Label 787: @31006
     /*  31006 */   GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(31068), // Rule ID 25441 //
     /*  31011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31014 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31018 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31022 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31026 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31029 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31033 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31037 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31041 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31043 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31050 */     // (or:{ *:[v8i16] } (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v8i16] }:$src1)  =>  (VPORQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31050 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  31053 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31055 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31057 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31061 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31066 */     GIR_RootConstrainSelectedInstOperands,
     /*  31067 */     // GIR_Coverage, 25441,
     /*  31067 */     GIR_EraseRootFromParent_Done,
     /*  31068 */   // Label 788: @31068
     /*  31068 */   GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(31130), // Rule ID 18162 //
     /*  31073 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31076 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31080 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31084 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31088 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31092 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31095 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31099 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31103 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31105 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31112 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31112 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  31115 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31117 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31119 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31123 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31128 */     GIR_RootConstrainSelectedInstOperands,
     /*  31129 */     // GIR_Coverage, 18162,
     /*  31129 */     GIR_EraseRootFromParent_Done,
     /*  31130 */   // Label 789: @31130
     /*  31130 */   GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(31192), // Rule ID 20027 //
     /*  31135 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31138 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31142 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31146 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31150 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31154 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31157 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31161 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31165 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31167 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31174 */     // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, (ld:{ *:[v8i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31174 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  31177 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31179 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31181 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31185 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31190 */     GIR_RootConstrainSelectedInstOperands,
     /*  31191 */     // GIR_Coverage, 20027,
     /*  31191 */     GIR_EraseRootFromParent_Done,
     /*  31192 */   // Label 790: @31192
     /*  31192 */   GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(31219), // Rule ID 18150 //
     /*  31197 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31200 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31204 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31208 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31212 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  31212 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  31217 */     GIR_RootConstrainSelectedInstOperands,
     /*  31218 */     // GIR_Coverage, 18150,
     /*  31218 */     GIR_Done,
     /*  31219 */   // Label 791: @31219
     /*  31219 */   GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(31246), // Rule ID 18174 //
     /*  31224 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  31227 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31231 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31235 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31239 */     // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
     /*  31239 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  31244 */     GIR_RootConstrainSelectedInstOperands,
     /*  31245 */     // GIR_Coverage, 18174,
     /*  31245 */     GIR_Done,
     /*  31246 */   // Label 792: @31246
     /*  31246 */   GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(31273), // Rule ID 20019 //
     /*  31251 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  31254 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31258 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31262 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  31266 */     // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
     /*  31266 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  31271 */     GIR_RootConstrainSelectedInstOperands,
     /*  31272 */     // GIR_Coverage, 20019,
     /*  31272 */     GIR_Done,
     /*  31273 */   // Label 793: @31273
     /*  31273 */   GIM_Reject,
     /*  31274 */ // Label 786: @31274
     /*  31274 */ GIM_Reject,
     /*  31275 */ // Label 676: @31275
     /*  31275 */ GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(31740),
     /*  31280 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
     /*  31283 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
     /*  31286 */   GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(31348), // Rule ID 24203 //
     /*  31291 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31294 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31298 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31302 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31306 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31309 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31313 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31317 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31321 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31323 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31330 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v8i32] }:$src1)  =>  (VPORDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31330 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rm),
     /*  31333 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31335 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31337 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31341 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31346 */     GIR_RootConstrainSelectedInstOperands,
     /*  31347 */     // GIR_Coverage, 24203,
     /*  31347 */     GIR_EraseRootFromParent_Done,
     /*  31348 */   // Label 795: @31348
     /*  31348 */   GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(31410), // Rule ID 25241 //
     /*  31353 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31360 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31364 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31368 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31371 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31375 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31379 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31383 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31385 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31392 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VPORYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31392 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  31395 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31397 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31399 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31403 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31408 */     GIR_RootConstrainSelectedInstOperands,
     /*  31409 */     // GIR_Coverage, 25241,
     /*  31409 */     GIR_EraseRootFromParent_Done,
     /*  31410 */   // Label 796: @31410
     /*  31410 */   GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(31472), // Rule ID 25251 //
     /*  31415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31422 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31426 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31430 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31433 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31437 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31441 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31445 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31447 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31454 */     // (or:{ *:[v8i32] } (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v8i32] }:$src1)  =>  (VORPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31454 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  31457 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31459 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31461 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31465 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31470 */     GIR_RootConstrainSelectedInstOperands,
     /*  31471 */     // GIR_Coverage, 25251,
     /*  31471 */     GIR_EraseRootFromParent_Done,
     /*  31472 */   // Label 797: @31472
     /*  31472 */   GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(31534), // Rule ID 5777 //
     /*  31477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31484 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31496 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31499 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31503 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31507 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31509 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31516 */     // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORDZ256rm:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31516 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rm),
     /*  31519 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31521 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31523 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31527 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31532 */     GIR_RootConstrainSelectedInstOperands,
     /*  31533 */     // GIR_Coverage, 5777,
     /*  31533 */     GIR_EraseRootFromParent_Done,
     /*  31534 */   // Label 798: @31534
     /*  31534 */   GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(31596), // Rule ID 18107 //
     /*  31539 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31542 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31546 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31550 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31554 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31558 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31561 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31565 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31569 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31571 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31578 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31578 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  31581 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31583 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31585 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31589 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31594 */     GIR_RootConstrainSelectedInstOperands,
     /*  31595 */     // GIR_Coverage, 18107,
     /*  31595 */     GIR_EraseRootFromParent_Done,
     /*  31596 */   // Label 799: @31596
     /*  31596 */   GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(31658), // Rule ID 18136 //
     /*  31601 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31604 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31608 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31612 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31616 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31620 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31623 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31627 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31631 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31633 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31640 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, (ld:{ *:[v8i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31640 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  31643 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31645 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31647 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31651 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31656 */     GIR_RootConstrainSelectedInstOperands,
     /*  31657 */     // GIR_Coverage, 18136,
     /*  31657 */     GIR_EraseRootFromParent_Done,
     /*  31658 */   // Label 800: @31658
     /*  31658 */   GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(31685), // Rule ID 5774 //
     /*  31663 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
     /*  31666 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31670 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31674 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  31678 */     // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
     /*  31678 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rr),
     /*  31683 */     GIR_RootConstrainSelectedInstOperands,
     /*  31684 */     // GIR_Coverage, 5774,
     /*  31684 */     GIR_Done,
     /*  31685 */   // Label 801: @31685
     /*  31685 */   GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(31712), // Rule ID 18095 //
     /*  31690 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  31693 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31697 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31701 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31705 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  31705 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  31710 */     GIR_RootConstrainSelectedInstOperands,
     /*  31711 */     // GIR_Coverage, 18095,
     /*  31711 */     GIR_Done,
     /*  31712 */   // Label 802: @31712
     /*  31712 */   GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(31739), // Rule ID 18120 //
     /*  31717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  31720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31728 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  31732 */     // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
     /*  31732 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  31737 */     GIR_RootConstrainSelectedInstOperands,
     /*  31738 */     // GIR_Coverage, 18120,
     /*  31738 */     GIR_Done,
     /*  31739 */   // Label 803: @31739
     /*  31739 */   GIM_Reject,
     /*  31740 */ // Label 794: @31740
     /*  31740 */ GIM_Reject,
     /*  31741 */ // Label 677: @31741
     /*  31741 */ GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(31896),
     /*  31746 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
     /*  31749 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
     /*  31752 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31756 */   GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(31814), // Rule ID 24179 //
     /*  31761 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31764 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31768 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31772 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31775 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31779 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31783 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31787 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31789 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31796 */     // (or:{ *:[v8i64] } (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v8i64] }:$src1)  =>  (VPORQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31796 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZrm),
     /*  31799 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31801 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31803 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31807 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31812 */     GIR_RootConstrainSelectedInstOperands,
     /*  31813 */     // GIR_Coverage, 24179,
     /*  31813 */     GIR_EraseRootFromParent_Done,
     /*  31814 */   // Label 805: @31814
     /*  31814 */   GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(31872), // Rule ID 5741 //
     /*  31819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31822 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31826 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  31830 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31834 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31837 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31841 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31845 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31847 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31854 */     // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, (ld:{ *:[v8i64] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZrm:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31854 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZrm),
     /*  31857 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31859 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  31861 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31865 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  31870 */     GIR_RootConstrainSelectedInstOperands,
     /*  31871 */     // GIR_Coverage, 5741,
     /*  31871 */     GIR_EraseRootFromParent_Done,
     /*  31872 */   // Label 806: @31872
     /*  31872 */   GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(31895), // Rule ID 5738 //
     /*  31877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31880 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31884 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  31888 */     // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
     /*  31888 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
     /*  31893 */     GIR_RootConstrainSelectedInstOperands,
     /*  31894 */     // GIR_Coverage, 5738,
     /*  31894 */     GIR_Done,
     /*  31895 */   // Label 807: @31895
     /*  31895 */   GIM_Reject,
     /*  31896 */ // Label 804: @31896
     /*  31896 */ GIM_Reject,
     /*  31897 */ // Label 678: @31897
     /*  31897 */ GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(31930), // Rule ID 4418 //
     /*  31902 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  31905 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
     /*  31908 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
     /*  31911 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31915 */   GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31919 */   GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
     /*  31923 */   // (or:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
     /*  31923 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORWkk),
     /*  31928 */   GIR_RootConstrainSelectedInstOperands,
     /*  31929 */   // GIR_Coverage, 4418,
     /*  31929 */   GIR_Done,
     /*  31930 */ // Label 808: @31930
     /*  31930 */ GIM_Reject,
     /*  31931 */ // Label 679: @31931
     /*  31931 */ GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(32272),
     /*  31936 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*  31939 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*  31942 */   GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(32004), // Rule ID 25260 //
     /*  31947 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  31950 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31954 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31958 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  31962 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  31965 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  31969 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  31973 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  31977 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  31979 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  31986 */     // (or:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128:{ *:[v16i8] }:$src1)  =>  (VPORrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  31986 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  31989 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  31991 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  31993 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  31997 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32002 */     GIR_RootConstrainSelectedInstOperands,
     /*  32003 */     // GIR_Coverage, 25260,
     /*  32003 */     GIR_EraseRootFromParent_Done,
     /*  32004 */   // Label 810: @32004
     /*  32004 */   GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(32066), // Rule ID 25440 //
     /*  32009 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32012 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32016 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32020 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32024 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32027 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32031 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32035 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32039 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32041 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32048 */     // (or:{ *:[v16i8] } (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR128X:{ *:[v16i8] }:$src1)  =>  (VPORQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  32051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32053 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32055 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32059 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32064 */     GIR_RootConstrainSelectedInstOperands,
     /*  32065 */     // GIR_Coverage, 25440,
     /*  32065 */     GIR_EraseRootFromParent_Done,
     /*  32066 */   // Label 811: @32066
     /*  32066 */   GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(32128), // Rule ID 18161 //
     /*  32071 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  32074 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32078 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32082 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32086 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32090 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32093 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32097 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32101 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32103 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32110 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORrm:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32110 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORrm),
     /*  32113 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32115 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32117 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32121 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32126 */     GIR_RootConstrainSelectedInstOperands,
     /*  32127 */     // GIR_Coverage, 18161,
     /*  32127 */     GIR_EraseRootFromParent_Done,
     /*  32128 */   // Label 812: @32128
     /*  32128 */   GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(32190), // Rule ID 20026 //
     /*  32133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32136 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32140 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32144 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32148 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32152 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32155 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32159 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32163 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32165 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32172 */     // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, (ld:{ *:[v16i8] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ128rm:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32172 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rm),
     /*  32175 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32177 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32179 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32183 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32188 */     GIR_RootConstrainSelectedInstOperands,
     /*  32189 */     // GIR_Coverage, 20026,
     /*  32189 */     GIR_EraseRootFromParent_Done,
     /*  32190 */   // Label 813: @32190
     /*  32190 */   GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(32217), // Rule ID 18149 //
     /*  32195 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
     /*  32198 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32202 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32206 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32210 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  32210 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
     /*  32215 */     GIR_RootConstrainSelectedInstOperands,
     /*  32216 */     // GIR_Coverage, 18149,
     /*  32216 */     GIR_Done,
     /*  32217 */   // Label 814: @32217
     /*  32217 */   GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(32244), // Rule ID 18173 //
     /*  32222 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
     /*  32225 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32229 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32233 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
     /*  32237 */     // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
     /*  32237 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
     /*  32242 */     GIR_RootConstrainSelectedInstOperands,
     /*  32243 */     // GIR_Coverage, 18173,
     /*  32243 */     GIR_Done,
     /*  32244 */   // Label 815: @32244
     /*  32244 */   GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(32271), // Rule ID 20018 //
     /*  32249 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32252 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32256 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32260 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
     /*  32264 */     // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
     /*  32264 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
     /*  32269 */     GIR_RootConstrainSelectedInstOperands,
     /*  32270 */     // GIR_Coverage, 20018,
     /*  32270 */     GIR_Done,
     /*  32271 */   // Label 816: @32271
     /*  32271 */   GIM_Reject,
     /*  32272 */ // Label 809: @32272
     /*  32272 */ GIM_Reject,
     /*  32273 */ // Label 680: @32273
     /*  32273 */ GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(32738),
     /*  32278 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
     /*  32281 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
     /*  32284 */   GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(32346), // Rule ID 25240 //
     /*  32289 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32292 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32296 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32300 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32304 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32307 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32311 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32315 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32319 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32321 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32328 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VPORYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32328 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  32331 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32333 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32335 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32339 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32344 */     GIR_RootConstrainSelectedInstOperands,
     /*  32345 */     // GIR_Coverage, 25240,
     /*  32345 */     GIR_EraseRootFromParent_Done,
     /*  32346 */   // Label 818: @32346
     /*  32346 */   GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(32408), // Rule ID 25250 //
     /*  32351 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32354 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32358 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32362 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32366 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32369 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32373 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32377 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32381 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32383 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32390 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256:{ *:[v16i16] }:$src1)  =>  (VORPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32390 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  32393 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32395 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32397 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32401 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32406 */     GIR_RootConstrainSelectedInstOperands,
     /*  32407 */     // GIR_Coverage, 25250,
     /*  32407 */     GIR_EraseRootFromParent_Done,
     /*  32408 */   // Label 819: @32408
     /*  32408 */   GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(32470), // Rule ID 25447 //
     /*  32413 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32416 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32420 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32424 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32428 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32431 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32435 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32439 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32443 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32445 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32452 */     // (or:{ *:[v16i16] } (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR256X:{ *:[v16i16] }:$src1)  =>  (VPORQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32452 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  32455 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32457 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32459 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32463 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32468 */     GIR_RootConstrainSelectedInstOperands,
     /*  32469 */     // GIR_Coverage, 25447,
     /*  32469 */     GIR_EraseRootFromParent_Done,
     /*  32470 */   // Label 820: @32470
     /*  32470 */   GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(32532), // Rule ID 18106 //
     /*  32475 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32478 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32482 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32486 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32490 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32494 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32497 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32501 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32505 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32507 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32514 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32514 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORYrm),
     /*  32517 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32519 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32521 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32525 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32530 */     GIR_RootConstrainSelectedInstOperands,
     /*  32531 */     // GIR_Coverage, 18106,
     /*  32531 */     GIR_EraseRootFromParent_Done,
     /*  32532 */   // Label 821: @32532
     /*  32532 */   GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(32594), // Rule ID 18135 //
     /*  32537 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32540 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32544 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32548 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32552 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32556 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32559 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32563 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32567 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32569 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32576 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VORPSYrm:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32576 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VORPSYrm),
     /*  32579 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32581 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32583 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32587 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32592 */     GIR_RootConstrainSelectedInstOperands,
     /*  32593 */     // GIR_Coverage, 18135,
     /*  32593 */     GIR_EraseRootFromParent_Done,
     /*  32594 */   // Label 822: @32594
     /*  32594 */   GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(32656), // Rule ID 20043 //
     /*  32599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32602 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32606 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32610 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32614 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32618 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32621 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32625 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32629 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32631 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32638 */     // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, (ld:{ *:[v16i16] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>)  =>  (VPORQZ256rm:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32638 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rm),
     /*  32641 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32643 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  32645 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32649 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32654 */     GIR_RootConstrainSelectedInstOperands,
     /*  32655 */     // GIR_Coverage, 20043,
     /*  32655 */     GIR_EraseRootFromParent_Done,
     /*  32656 */   // Label 823: @32656
     /*  32656 */   GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(32683), // Rule ID 18094 //
     /*  32661 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
     /*  32664 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32668 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32672 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32676 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  32676 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
     /*  32681 */     GIR_RootConstrainSelectedInstOperands,
     /*  32682 */     // GIR_Coverage, 18094,
     /*  32682 */     GIR_Done,
     /*  32683 */   // Label 824: @32683
     /*  32683 */   GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(32710), // Rule ID 18119 //
     /*  32688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
     /*  32691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32695 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32699 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
     /*  32703 */     // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
     /*  32703 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
     /*  32708 */     GIR_RootConstrainSelectedInstOperands,
     /*  32709 */     // GIR_Coverage, 18119,
     /*  32709 */     GIR_Done,
     /*  32710 */   // Label 825: @32710
     /*  32710 */   GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(32737), // Rule ID 20035 //
     /*  32715 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
     /*  32718 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32722 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32726 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
     /*  32730 */     // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
     /*  32730 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
     /*  32735 */     GIR_RootConstrainSelectedInstOperands,
     /*  32736 */     // GIR_Coverage, 20035,
     /*  32736 */     GIR_Done,
     /*  32737 */   // Label 826: @32737
     /*  32737 */   GIM_Reject,
     /*  32738 */ // Label 817: @32738
     /*  32738 */ GIM_Reject,
     /*  32739 */ // Label 681: @32739
     /*  32739 */ GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(32894),
     /*  32744 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
     /*  32747 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
     /*  32750 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32754 */   GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(32812), // Rule ID 24197 //
     /*  32759 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  32762 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32766 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32770 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32773 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32777 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32781 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32785 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32787 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32794 */     // (or:{ *:[v16i32] } (ld:{ *:[v16i32] } addr:{ *:[iPTR] }:$src2)<<P:Predicate_unindexedload>><<P:Predicate_load>>, VR512:{ *:[v16i32] }:$src1)  =>  (VPORDZrm:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, addr:{ *:[iPTR] }:$src2)
     /*  32794 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPORDZrm),
     /*  32797 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  32799 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  32801 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // src2
     /*  32805 */     GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
     /*  32810 */     GIR_RootConstrainSelectedInstOperands,
     /*  32811 */     // GIR_Coverage, 24197,
     /*  32811 */     GIR_EraseRootFromParent_Done,
     /*  32812 */   // Label 828: @32812
     /*  32812 */   GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(32870), // Rule ID 5768 //
     /*  32817 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
     /*  32820 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
     /*  32824 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  32828 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LOAD),
     /*  32832 */     GIM_CheckAtomicOrdering, /*MI*/1, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
     /*  32835 */     GIM_CheckMemorySizeEqualToLLT, /*MI*/1, /*MMO*/0, /*OpIdx*/0,
     /*  32839 */     GIM_CheckPointerToAny, /*MI*/1, /*Op*/1, /*SizeInBits*/0,
     /*  32843 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  32845 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_addr),
     /*  32852 */     // (or: