/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.SimpleITKJNI;

public class RecursiveGaussianImageFilter
extends ImageFilter {
    private transient long swigCPtr;

    protected RecursiveGaussianImageFilter(long l, boolean bl) {
        super(SimpleITKJNI.RecursiveGaussianImageFilter_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(RecursiveGaussianImageFilter recursiveGaussianImageFilter) {
        return recursiveGaussianImageFilter == null ? 0L : recursiveGaussianImageFilter.swigCPtr;
    }

    protected static long swigRelease(RecursiveGaussianImageFilter recursiveGaussianImageFilter) {
        long l = 0L;
        if (recursiveGaussianImageFilter != null) {
            if (!recursiveGaussianImageFilter.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = recursiveGaussianImageFilter.swigCPtr;
            recursiveGaussianImageFilter.swigCMemOwn = false;
            recursiveGaussianImageFilter.delete();
        }
        return l;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_RecursiveGaussianImageFilter(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public RecursiveGaussianImageFilter() {
        this(SimpleITKJNI.new_RecursiveGaussianImageFilter(), true);
    }

    public void setSigma(double d) {
        SimpleITKJNI.RecursiveGaussianImageFilter_setSigma(this.swigCPtr, this, d);
    }

    public double getSigma() {
        return SimpleITKJNI.RecursiveGaussianImageFilter_getSigma(this.swigCPtr, this);
    }

    public void setNormalizeAcrossScale(boolean bl) {
        SimpleITKJNI.RecursiveGaussianImageFilter_setNormalizeAcrossScale(this.swigCPtr, this, bl);
    }

    public void normalizeAcrossScaleOn() {
        SimpleITKJNI.RecursiveGaussianImageFilter_normalizeAcrossScaleOn(this.swigCPtr, this);
    }

    public void normalizeAcrossScaleOff() {
        SimpleITKJNI.RecursiveGaussianImageFilter_normalizeAcrossScaleOff(this.swigCPtr, this);
    }

    public boolean getNormalizeAcrossScale() {
        return SimpleITKJNI.RecursiveGaussianImageFilter_getNormalizeAcrossScale(this.swigCPtr, this);
    }

    public void setOrder(OrderType orderType) {
        SimpleITKJNI.RecursiveGaussianImageFilter_setOrder(this.swigCPtr, this, orderType.swigValue());
    }

    public OrderType getOrder() {
        return OrderType.swigToEnum(SimpleITKJNI.RecursiveGaussianImageFilter_getOrder(this.swigCPtr, this));
    }

    public void setDirection(long l) {
        SimpleITKJNI.RecursiveGaussianImageFilter_setDirection(this.swigCPtr, this, l);
    }

    public long getDirection() {
        return SimpleITKJNI.RecursiveGaussianImageFilter_getDirection(this.swigCPtr, this);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.RecursiveGaussianImageFilter_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.RecursiveGaussianImageFilter_toString(this.swigCPtr, this);
    }

    public Image execute(Image image) {
        return new Image(SimpleITKJNI.RecursiveGaussianImageFilter_execute(this.swigCPtr, this, Image.getCPtr(image), image), true);
    }

    public static final class OrderType {
        public static final OrderType ZeroOrder = new OrderType("ZeroOrder");
        public static final OrderType FirstOrder = new OrderType("FirstOrder");
        public static final OrderType SecondOrder = new OrderType("SecondOrder");
        private static OrderType[] swigValues = new OrderType[]{ZeroOrder, FirstOrder, SecondOrder};
        private static int swigNext = 0;
        private final int swigValue;
        private final String swigName;

        public final int swigValue() {
            return this.swigValue;
        }

        public String toString() {
            return this.swigName;
        }

        public static OrderType swigToEnum(int n) {
            if (n < swigValues.length && n >= 0 && OrderType.swigValues[n].swigValue == n) {
                return swigValues[n];
            }
            for (int i = 0; i < swigValues.length; ++i) {
                if (OrderType.swigValues[i].swigValue != n) continue;
                return swigValues[i];
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(OrderType.class) + " with value " + n);
        }

        private OrderType(String string) {
            this.swigName = string;
            this.swigValue = swigNext++;
        }

        private OrderType(String string, int n) {
            this.swigName = string;
            this.swigValue = n;
            swigNext = n + 1;
        }

        private OrderType(String string, OrderType orderType) {
            this.swigName = string;
            this.swigValue = orderType.swigValue;
            swigNext = this.swigValue + 1;
        }
    }
}

