/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.common;

import java.util.ArrayList;
import java.util.List;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectCalendarWeek;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.common.NumberHelper;

public final class ProjectCalendarHelper {
    public static ProjectCalendar createTemporaryFlattenedCalendar(ProjectCalendar calendar) {
        if (!calendar.isDerived()) {
            return calendar;
        }
        ProjectCalendar newCalendar = new ProjectCalendar(calendar.getParentFile());
        newCalendar.setName(calendar.getName());
        newCalendar.setUniqueID(calendar.getUniqueID());
        newCalendar.setType(calendar.getType());
        newCalendar.setPersonal(calendar.getPersonal());
        newCalendar.setCalendarMinutesPerDay(calendar.getCalendarMinutesPerDay());
        newCalendar.setCalendarMinutesPerWeek(calendar.getCalendarMinutesPerWeek());
        newCalendar.setCalendarMinutesPerMonth(calendar.getMinutesPerMonth());
        newCalendar.setCalendarMinutesPerYear(calendar.getCalendarMinutesPerYear());
        ProjectCalendarHelper.populateDays(newCalendar, calendar);
        ProjectCalendarHelper.populateWorkingWeeks(newCalendar, calendar);
        ProjectCalendarHelper.mergeExceptions(newCalendar, calendar);
        return newCalendar;
    }

    public static ProjectCalendar createTemporaryDerivedCalendar(ProjectCalendar baseCalendar, Resource resource) {
        ProjectFile file = baseCalendar.getParentFile();
        ProjectCalendar derivedCalendar = new ProjectCalendar(file);
        derivedCalendar.setParent(baseCalendar);
        derivedCalendar.setName(resource.getName());
        derivedCalendar.setCalendarDayType(Day.SUNDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.MONDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.TUESDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.WEDNESDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.THURSDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.FRIDAY, DayType.DEFAULT);
        derivedCalendar.setCalendarDayType(Day.SATURDAY, DayType.DEFAULT);
        if (NumberHelper.getInt(derivedCalendar.getUniqueID()) == 0) {
            derivedCalendar.setUniqueID(file.getProjectConfig().getNextCalendarUniqueID());
        }
        return derivedCalendar;
    }

    public static List<ProjectCalendarException> getExpandedExceptionsWithWorkWeeks(ProjectCalendar calendar) {
        List<ProjectCalendarException> result;
        if (calendar.getWorkWeeks().isEmpty()) {
            result = calendar.getExpandedCalendarExceptions();
        } else {
            ProjectCalendar temporaryCalendar = new ProjectCalendar(calendar.getParentFile());
            ProjectCalendarHelper.mergeExceptions(temporaryCalendar, calendar.getCalendarExceptions());
            for (ProjectCalendarWeek week : calendar.getWorkWeeks()) {
                ProjectCalendarHelper.mergeExceptions(temporaryCalendar, week.convertToRecurringExceptions(calendar));
            }
            result = temporaryCalendar.getExpandedCalendarExceptions();
        }
        return result;
    }

    public static void mergeExceptions(ProjectCalendar target, ProjectCalendar source) {
        ProjectCalendarHelper.mergeExceptions(target, source.getCalendarExceptions());
        ProjectCalendar parent = source.getParent();
        if (parent != null) {
            ProjectCalendarHelper.mergeExceptions(target, parent);
        }
    }

    public static void mergeExceptions(ProjectCalendar target, List<ProjectCalendarException> sourceExceptions) {
        ArrayList<ProjectCalendarException> expandedTargetExceptions = new ArrayList<ProjectCalendarException>(target.getExpandedCalendarExceptions());
        for (ProjectCalendarException sourceException : sourceExceptions) {
            boolean collision = false;
            List<ProjectCalendarException> expandedSourceExceptions = sourceException.getExpandedExceptions();
            for (ProjectCalendarException expandedSourceException : expandedSourceExceptions) {
                collision = expandedTargetExceptions.stream().anyMatch(e -> e.contains(expandedSourceException));
                if (!collision) continue;
                break;
            }
            if (collision) {
                for (ProjectCalendarException expandedSourceException : expandedSourceExceptions) {
                    if (!expandedTargetExceptions.stream().noneMatch(e -> e.contains(expandedSourceException))) continue;
                    ProjectCalendarException newException = target.addCalendarException(expandedSourceException.getFromDate(), expandedSourceException.getToDate());
                    newException.addAll(expandedSourceException);
                }
                continue;
            }
            ProjectCalendarException newException = sourceException.getRecurring() == null ? target.addCalendarException(sourceException.getFromDate(), sourceException.getToDate()) : target.addCalendarException(sourceException.getRecurring());
            newException.addAll(sourceException);
        }
    }

    private static void populateDays(ProjectCalendar target, ProjectCalendar source) {
        for (Day day : Day.values()) {
            ProjectCalendarHours hours = source.getHours(day);
            ProjectCalendarHours newHours = target.addCalendarHours(day);
            if (hours == null || hours.size() == 0) {
                target.setCalendarDayType(day, DayType.NON_WORKING);
                continue;
            }
            target.setCalendarDayType(day, DayType.WORKING);
            newHours.addAll(hours);
        }
    }

    private static void populateWorkingWeeks(ProjectCalendar target, ProjectCalendar source) {
        for (ProjectCalendarWeek sourceWeek : source.getWorkWeeks()) {
            ProjectCalendarWeek targetWeek = target.addWorkWeek();
            for (Day day : Day.values()) {
                targetWeek.setCalendarDayType(day, sourceWeek.getCalendarDayType(day));
                ProjectCalendarHours sourceHours = sourceWeek.getCalendarHours(day);
                if (sourceHours == null) continue;
                ProjectCalendarHours targetHours = targetWeek.addCalendarHours(day);
                targetHours.addAll(sourceHours);
            }
        }
    }
}

