# frozen_string_literal: true

class PrepareIndexVulnerabilityFindingLinksOnProjectId < Gitlab::Database::Migration[2.2]
  milestone '17.3'
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_finding_links_on_project_id'

  # -- Legacy migration
  def up
    # rubocop:disable Migration/PreventIndexCreation -- Legacy migration
    prepare_async_index :vulnerability_finding_links, :project_id, name: INDEX_NAME
    # rubocop:enable Migration/PreventIndexCreation
  end

  def down
    unprepare_async_index :vulnerability_finding_links, INDEX_NAME
  end
end
