# frozen_string_literal: true

class FinalizeBackfillGroupIdAndUserTypeForNonhumanAccessTokens < Gitlab::Database::Migration[2.3]
  milestone '18.6'

  restrict_gitlab_migration gitlab_schema: :gitlab_main

  disable_ddl_transaction!

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: 'BackfillGroupIdAndUserTypeForNonhumanAccessTokens',
      table_name: :personal_access_tokens,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down; end
end
