---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Asana client ID'
---

## Description

The response body contains content that matches the pattern of an Asana Client ID was detected. This ID is used in conjunction with the client secret. A malicious actor with access to this ID can impersonate the client application if they also have access to the client secret..
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

An Asana client ID cannot be rotated, only a new OAuth client application can be created to get a new Client ID. For more information please [see their documentation on configuring OAuth](https://developers.asana.com/docs/oauth)

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:-----------|:----|:-----|:-----|
| 798.9 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
