/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Spectrum;

public class Measurement
extends Annotation {
    public static final int PT_XY1 = 1;
    public static final int PT_XY2 = 2;
    public static final int PT_INT_LABEL = -5;
    public static final int PT_ON_LINE1 = -1;
    public static final int PT_ON_LINE2 = -2;
    public static final int PT_ON_LINE = 0;
    private Coordinate pt2 = new Coordinate();
    protected double value;

    public Measurement setM1(double d, double d2, Spectrum spectrum) {
        this.setA(d, d2, spectrum, "", false, false, 0, 6);
        this.setPt2(this.getXVal(), this.getYVal());
        return this;
    }

    public Measurement copyM() {
        Measurement measurement = new Measurement();
        measurement.setA(this.getXVal(), this.getYVal(), this.spec, this.text, false, false, this.offsetX, this.offsetY);
        measurement.setPt2(this.pt2.getXVal(), this.pt2.getYVal());
        return measurement;
    }

    public Measurement setPt2(Spectrum spectrum, boolean bl) {
        this.spec = spectrum;
        if (bl) {
            this.setPt2(this.getXVal(), this.getYVal());
        }
        return this;
    }

    public void setPt2(double d, double d2) {
        this.pt2.setXVal(d);
        this.pt2.setYVal(d2);
        this.value = Math.abs(d - this.getXVal());
        this.text = this.spec.setMeasurementText(this);
    }

    public Spectrum getSpectrum() {
        return this.spec;
    }

    public void setValue(double d) {
        this.value = d;
        this.text = this.spec.setMeasurementText(this);
    }

    public double getValue() {
        return this.value;
    }

    public double getXVal2() {
        return this.pt2.getXVal();
    }

    public double getYVal2() {
        return this.pt2.getYVal();
    }

    @Override
    public void addSpecShift(double d) {
        this.setXVal(this.getXVal() + d);
        this.pt2.setXVal(this.pt2.getXVal() + d);
    }

    public void setYVal2(double d) {
        this.pt2.setYVal(d);
    }

    public boolean overlaps(double d, double d2) {
        return Math.min(this.getXVal(), this.getXVal2()) < Math.max(d, d2) && Math.max(this.getXVal(), this.getXVal2()) > Math.min(d, d2);
    }

    @Override
    public String toString() {
        return "[" + this.getXVal() + "," + this.pt2.getXVal() + "]";
    }
}

