/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import org.hibernate.Incubating;

@Incubating
public final class EntityNameUse {
    public static final EntityNameUse PROJECTION = new EntityNameUse(UseKind.PROJECTION, true);
    public static final EntityNameUse EXPRESSION = new EntityNameUse(UseKind.EXPRESSION, true);
    public static final EntityNameUse TREAT = new EntityNameUse(UseKind.TREAT, true);
    public static final EntityNameUse BASE_TREAT = new EntityNameUse(UseKind.TREAT, null);
    public static final EntityNameUse OPTIONAL_TREAT = new EntityNameUse(UseKind.TREAT, false);
    public static final EntityNameUse FILTER = new EntityNameUse(UseKind.FILTER, true);
    private final UseKind kind;
    private final Boolean requiresRestriction;

    private EntityNameUse(UseKind kind, Boolean requiresRestriction) {
        this.kind = kind;
        this.requiresRestriction = requiresRestriction;
    }

    private static EntityNameUse get(UseKind kind) {
        switch (kind.ordinal()) {
            case 0: {
                return PROJECTION;
            }
            case 1: {
                return EXPRESSION;
            }
            case 2: {
                return TREAT;
            }
            case 3: {
                return FILTER;
            }
        }
        throw new IllegalArgumentException("Unknown kind: " + String.valueOf((Object)kind));
    }

    public UseKind getKind() {
        return this.kind;
    }

    public boolean requiresRestriction() {
        return this.requiresRestriction != Boolean.FALSE;
    }

    public EntityNameUse stronger(EntityNameUse other) {
        if (other == null || this.kind.isStrongerThan(other.kind)) {
            return this;
        }
        if (this.kind == other.kind && this.kind == UseKind.TREAT) {
            return this.requiresRestriction == null ? other : this;
        }
        return other.kind.isStrongerThan(this.kind) ? other : EntityNameUse.get(other.kind);
    }

    public EntityNameUse weaker(EntityNameUse other) {
        if (other == null || this.kind.isWeakerThan(other.kind)) {
            return this;
        }
        if (this.kind == other.kind && this.kind == UseKind.TREAT) {
            return this.requiresRestriction == null ? other : this;
        }
        return other.kind.isWeakerThan(this.kind) ? other : EntityNameUse.get(other.kind);
    }

    public static enum UseKind {
        PROJECTION,
        EXPRESSION,
        TREAT,
        FILTER;


        public boolean isStrongerThan(UseKind other) {
            return this.ordinal() > other.ordinal();
        }

        public UseKind stronger(UseKind other) {
            return other == null || this.isStrongerThan(other) ? this : other;
        }

        public boolean isWeakerThan(UseKind other) {
            return this.ordinal() < other.ordinal();
        }

        public UseKind weaker(UseKind other) {
            return other == null || this.isWeakerThan(other) ? this : other;
        }
    }
}

