/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.MutableObject;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.spi.DomainQueryExecutionContext;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.cte.CteInsertHandler;
import org.hibernate.query.sqm.mutation.spi.MultiTableHandlerBuildResult;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.tree.insert.SqmInsertStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class CteInsertStrategy
implements SqmMultiTableInsertStrategy {
    public static final String SHORT_NAME = "cte";
    private final EntityPersister rootDescriptor;
    private final SessionFactoryImplementor sessionFactory;
    private final CteTable entityCteTable;

    public CteInsertStrategy(EntityMappingType rootEntityType, RuntimeModelCreationContext runtimeModelCreationContext) {
        this(rootEntityType.getEntityPersister(), runtimeModelCreationContext);
    }

    public CteInsertStrategy(EntityPersister rootDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        this.rootDescriptor = rootDescriptor;
        this.sessionFactory = runtimeModelCreationContext.getSessionFactory();
        Dialect dialect = runtimeModelCreationContext.getDialect();
        if (!dialect.supportsNonQueryWithCTE()) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " can only be used with Dialects that support CTE that can take UPDATE or DELETE statements as well");
        }
        PersistentClass persistentClass = runtimeModelCreationContext.getMetadata().getEntityBinding(rootDescriptor.getEntityName());
        Identifier tableNameIdentifier = persistentClass instanceof SingleTableSubclass ? new Identifier(persistentClass.getTable().getNameIdentifier().getText() + persistentClass.getSubclassId(), persistentClass.getTable().getNameIdentifier().isQuoted()) : persistentClass.getTable().getNameIdentifier();
        String cteName = "HTE_" + tableNameIdentifier.getText();
        String qualifiedCteName = new Identifier(cteName.substring(0, Math.min(dialect.getMaxIdentifierLength(), cteName.length())), tableNameIdentifier.isQuoted()).render(dialect);
        this.entityCteTable = CteTable.createEntityTable(qualifiedCteName, persistentClass);
    }

    @Override
    public MultiTableHandlerBuildResult buildHandler(SqmInsertStatement<?> sqmInsertStatement, DomainParameterXref domainParameterXref, DomainQueryExecutionContext context) {
        MutableObject<JdbcParameterBindings> firstJdbcParameterBindings = new MutableObject<JdbcParameterBindings>();
        CteInsertHandler multiTableHandler = new CteInsertHandler(this.entityCteTable, sqmInsertStatement, domainParameterXref, context, firstJdbcParameterBindings);
        return new MultiTableHandlerBuildResult(multiTableHandler, firstJdbcParameterBindings.get());
    }

    protected EntityPersister getRootDescriptor() {
        return this.rootDescriptor;
    }

    protected SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    protected CteTable getEntityCteTable() {
        return this.entityCteTable;
    }
}

