/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.kubernetes;

import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.util.Strings;

public class KubernetesIdentityProviderConfig
extends IdentityProviderModel {
    public static final String ISSUER = "issuer";

    public KubernetesIdentityProviderConfig() {
    }

    public KubernetesIdentityProviderConfig(IdentityProviderModel model) {
        super(model);
    }

    public String getIssuer() {
        return (String)this.getConfig().get(ISSUER);
    }

    public int getAllowedClockSkew() {
        String allowedClockSkew = (String)this.getConfig().get("allowedClockSkew");
        if (allowedClockSkew == null || allowedClockSkew.isEmpty()) {
            return 0;
        }
        try {
            return Integer.parseInt((String)this.getConfig().get("allowedClockSkew"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Boolean isHideOnLogin() {
        return true;
    }

    public void validate(RealmModel realm) {
        super.validate(realm);
        String issuer = this.getIssuer();
        if (Strings.isEmpty((String)issuer).booleanValue()) {
            throw new IllegalArgumentException("issuer is required");
        }
        UriUtils.checkUrl((SslRequired)realm.getSslRequired(), (String)issuer, (String)ISSUER);
    }
}

