/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.TransactionOptions;
import org.keycloak.config.database.Database;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapperGrouping;
import org.keycloak.utils.StringUtil;

final class DatabasePropertyMappers
implements PropertyMapperGrouping {
    private static final Logger log = Logger.getLogger(DatabasePropertyMappers.class);
    private static final Option<String> DB_URL_PATH = new OptionBuilder("db-url-path", String.class).hidden().description("Used for internal purposes of H2 database.").build();

    DatabasePropertyMappers() {
    }

    public List<PropertyMapper<?>> getPropertyMappers() {
        List<PropertyMapper<?>> mappers = List.of(PropertyMapper.fromOption(DatabaseOptions.DB_DIALECT).mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::transformDialect).build(), PropertyMapper.fromOption(DatabaseOptions.DB_DRIVER).mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::getXaOrNonXaDriver).to("quarkus.datasource.jdbc.driver").paramLabel("driver").build(), PropertyMapper.fromOption(DatabaseOptions.DB).to("quarkus.datasource.db-kind").transformer(DatabasePropertyMappers::toDatabaseKind).paramLabel("vendor").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL).to("quarkus.datasource.jdbc.url").mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::getDatabaseUrl).paramLabel("jdbc-url").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POSTGRESQL_TARGET_SERVER_TYPE).to("quarkus.datasource.jdbc.additional-jdbc-properties.targetServerType").mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::getPostgresqlTargetServerType).isEnabled(() -> DatabasePropertyMappers.getPostgresqlTargetServerType(Configuration.getConfigValue(DatabaseOptions.DB).getValue(), null) != null).build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_HOST).paramLabel("hostname").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_DATABASE).paramLabel("dbname").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_PORT).paramLabel("port").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_PROPERTIES).paramLabel("properties").build(), PropertyMapper.fromOption(DatabaseOptions.DB_USERNAME).to("quarkus.datasource.username").paramLabel("username").build(), PropertyMapper.fromOption(DatabaseOptions.DB_PASSWORD).to("quarkus.datasource.password").paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(DatabaseOptions.DB_SCHEMA).paramLabel("schema").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_INITIAL_SIZE).to("quarkus.datasource.jdbc.initial-size").paramLabel("size").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_MIN_SIZE).mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::transformMinPoolSize).to("quarkus.datasource.jdbc.min-size").paramLabel("size").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_MAX_SIZE).to("quarkus.datasource.jdbc.max-size").paramLabel("size").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_MAX_LIFETIME).to("quarkus.datasource.jdbc.max-lifetime").mapFrom(DatabaseOptions.DB, DatabasePropertyMappers::transformPoolMaxLifetime).paramLabel("duration").build(), PropertyMapper.fromOption(DatabaseOptions.DB_SQL_JPA_DEBUG).build(), PropertyMapper.fromOption(DatabaseOptions.DB_SQL_LOG_SLOW_QUERIES).paramLabel("milliseconds").build(), PropertyMapper.fromOption(DatabaseOptions.DB_ENABLED_DATASOURCE).to("quarkus.datasource.\"<datasource>\".active").build(), PropertyMapper.fromOption(DB_URL_PATH).build());
        return Datasources.appendDatasourceMappers(mappers, Map.of(DatabaseOptions.DB, PropertyMapper.Builder::removeMapFrom, DatabaseOptions.DB_POOL_INITIAL_SIZE, mapper -> mapper.mapFrom(DatabaseOptions.DB_POOL_INITIAL_SIZE), DatabaseOptions.DB_POOL_MAX_SIZE, mapper -> mapper.mapFrom(DatabaseOptions.DB_POOL_MAX_SIZE)));
    }

    private static String getPostgresqlTargetServerType(String db, ConfigSourceInterceptorContext context) {
        Database.Vendor vendor = Database.getVendor((String)db).orElse(null);
        if (vendor != Database.Vendor.POSTGRES) {
            return null;
        }
        String dbDriver = Configuration.getConfigValue(DatabaseOptions.DB_DRIVER).getValue();
        String dbUrl = Configuration.getConfigValue(DatabaseOptions.DB_URL).getValue();
        if (!Objects.equals(Database.getDriver((String)db, (boolean)true).orElse(null), dbDriver) && !Objects.equals(Database.getDriver((String)db, (boolean)false).orElse(null), dbDriver)) {
            return null;
        }
        if (dbUrl != null && dbUrl.contains("targetServerType")) {
            return null;
        }
        log.debug((Object)"setting targetServerType for PostgreSQL to 'primary'");
        return "primary";
    }

    private static String addH2NonKeywords(String jdbcUrl) {
        if (!((String)jdbcUrl).contains("NON_KEYWORDS=")) {
            jdbcUrl = (String)jdbcUrl + ";NON_KEYWORDS=VALUE";
        }
        return jdbcUrl;
    }

    private static String addH2CloseOnExit(String jdbcUrl) {
        if (!((String)jdbcUrl).contains("DB_CLOSE_ON_EXIT=")) {
            jdbcUrl = (String)jdbcUrl + ";DB_CLOSE_ON_EXIT=FALSE";
        }
        if (!((String)jdbcUrl).contains("DB_CLOSE_DELAY=")) {
            jdbcUrl = (String)jdbcUrl + ";DB_CLOSE_DELAY=0";
        }
        return jdbcUrl;
    }

    private static String amendH2(String jdbcUrl) {
        return DatabasePropertyMappers.addH2CloseOnExit(DatabasePropertyMappers.addH2NonKeywords(jdbcUrl));
    }

    private static String getDatabaseUrl(String name, String value, ConfigSourceInterceptorContext c) {
        Object url = Database.getDefaultUrl((String)name, (String)value).orElse(null);
        if (DatabasePropertyMappers.isDevModeDatabase(value)) {
            String key = Optional.ofNullable(name).map(n -> (String)DatabaseOptions.Datasources.getNamedKey((Option)DatabaseOptions.DB_URL_PROPERTIES, (String)n).orElseThrow()).orElse(DatabaseOptions.DB_URL_PROPERTIES.getKey());
            String urlProps = Configuration.getKcConfigValue(key).getValue();
            if (urlProps != null) {
                url = (String)url + urlProps;
            }
            url = DatabasePropertyMappers.amendH2((String)url);
        }
        return url;
    }

    private static String getXaOrNonXaDriver(String name, String value, ConfigSourceInterceptorContext context) {
        String key = StringUtil.isNotBlank((String)name) ? TransactionOptions.getNamedTxXADatasource((String)name) : TransactionOptions.TRANSACTION_XA_ENABLED.getKey();
        boolean isXaEnabled = Configuration.isKcPropertyTrue(key);
        return Database.getDriver((String)value, (boolean)isXaEnabled).orElse(null);
    }

    private static String toDatabaseKind(String db, ConfigSourceInterceptorContext context) {
        return Database.getDatabaseKind((String)db).orElse(null);
    }

    private static boolean isDevModeDatabase(String database) {
        return Database.getDatabaseKind((String)database).filter("h2"::equals).isPresent();
    }

    private static String transformDialect(String db, ConfigSourceInterceptorContext context) {
        return Database.getDialect((String)db).orElse(null);
    }

    private static String transformMinPoolSize(String database, ConfigSourceInterceptorContext context) {
        Supplier<String> getParentPoolMinSize = () -> Optional.ofNullable(context.proceed("kc." + DatabaseOptions.DB_POOL_MIN_SIZE.getKey())).map(ConfigValue::getValue).orElse(null);
        return DatabasePropertyMappers.isDevModeDatabase(database) ? "1" : getParentPoolMinSize.get();
    }

    private static String transformPoolMaxLifetime(String db, ConfigSourceInterceptorContext context) {
        Database.Vendor vendor = (Database.Vendor)Database.getVendor((String)db).orElseThrow();
        return switch (vendor) {
            case Database.Vendor.MYSQL, Database.Vendor.MARIADB -> "PT7H50M";
            default -> "";
        };
    }

    public static final class Datasources {
        static List<PropertyMapper<?>> appendDatasourceMappers(List<PropertyMapper<?>> mappers, Map<Option<?>, Consumer<PropertyMapper.Builder<?>>> transformDatasourceMappers) {
            ArrayList datasourceMappers = new ArrayList(DatabaseOptions.Datasources.OPTIONS_DATASOURCES.size() + mappers.size());
            for (PropertyMapper<?> parent : mappers) {
                Consumer<PropertyMapper.Builder<?>> customTransformer;
                String transformedTo;
                Option<?> parentOption = parent.getOption();
                Optional datasourceOption = DatabaseOptions.Datasources.getDatasourceOption(parentOption);
                if (datasourceOption.isEmpty()) {
                    log.debugf("No datasource option found for '%s'", (Object)parentOption.getKey());
                    continue;
                }
                PropertyMapper.Builder created = PropertyMapper.fromOption((Option)datasourceOption.get()).isMasked(parent.isMask()).transformer(parent.getMapper());
                if (parent.getMapFrom() != null) {
                    String wildcardMapFromOption = (String)DatabaseOptions.Datasources.getKeyForDatasource((String)parent.getMapFrom()).orElseThrow(() -> new IllegalArgumentException("Option '%s' in mapFrom() method for mapper '%s' does not have any associated wildcard option".formatted(parent.getMapFrom(), ((Option)datasourceOption.get()).getKey())));
                    created.wildcardMapFrom(wildcardMapFromOption, parent.getParentMapper() != null ? (name, value, context) -> parent.getParentMapper().map(name, value, context) : null);
                }
                if (parent.getParamLabel() != null) {
                    created.paramLabel(parent.getParamLabel());
                }
                if ((transformedTo = Datasources.transformDatasourceTo(parent.getTo())) != null) {
                    created.to(transformedTo);
                }
                if ((customTransformer = transformDatasourceMappers.get(parent.getOption())) != null) {
                    customTransformer.accept(created);
                }
                datasourceMappers.add(created.build());
            }
            datasourceMappers.addAll(mappers);
            return datasourceMappers;
        }

        private static String transformDatasourceTo(String to) {
            if (StringUtil.isBlank((String)to)) {
                return null;
            }
            if (to.startsWith("quarkus.datasource.")) {
                return to.replaceFirst("quarkus\\.datasource\\.", "quarkus.datasource.\"<datasource>\".");
            }
            if (to.startsWith("kc.db-")) {
                return to.concat("-<datasource>");
            }
            log.warnf("Cannot determine how to map datasource option to '%s'", (Object)to);
            return to;
        }
    }
}

