/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.rest;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.neuralsearch.transport.NeuralSparseWarmupAction;
import org.opensearch.neuralsearch.transport.NeuralSparseWarmupRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

public class RestNeuralSparseWarmupHandler
extends BaseRestHandler {
    private static final String URL_PATH = "/warmup/{index}";
    public static String NAME = "neural_sparse_warmup_action";
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final ClusterService clusterService;

    public RestNeuralSparseWarmupHandler(ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s%s", "/_plugins/_neural", URL_PATH)));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        NeuralSparseWarmupRequest neuralSparseWarmupRequest = this.createNeuralSparseWarmupRequest(request);
        return channel -> client.execute((ActionType)NeuralSparseWarmupAction.INSTANCE, (ActionRequest)neuralSparseWarmupRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private NeuralSparseWarmupRequest createNeuralSparseWarmupRequest(RestRequest request) {
        String[] indexNames = Strings.splitStringByCommaToArray((String)request.param("index"));
        return new NeuralSparseWarmupRequest(indexNames);
    }
}

