/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mapper;

import jakarta.servlet.http.MappingMatch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.Wrapper;
import org.apache.catalina.mapper.MappingData;
import org.apache.catalina.mapper.WrapperMappingInfo;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.res.StringManager;

public final class Mapper {
    private static final Log log = LogFactory.getLog(Mapper.class);
    private static final StringManager sm = StringManager.getManager(Mapper.class);
    volatile MappedHost[] hosts = new MappedHost[0];
    private volatile String defaultHostName = null;
    private volatile MappedHost defaultHost = null;
    private final Map<Context, ContextVersion> contextObjectToContextVersionMap = new ConcurrentHashMap<Context, ContextVersion>();

    public synchronized void setDefaultHostName(String string) {
        this.defaultHostName = Mapper.renameWildcardHost(string);
        this.defaultHost = this.defaultHostName == null ? null : (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)this.defaultHostName);
    }

    public synchronized void addHost(String string, String[] stringArray, Host host) {
        Object object;
        MappedHost[] mappedHostArray = new MappedHost[this.hosts.length + 1];
        MappedHost mappedHost = new MappedHost(string = Mapper.renameWildcardHost(string), host);
        if (Mapper.insertMap(this.hosts, mappedHostArray, mappedHost)) {
            this.hosts = mappedHostArray;
            if (mappedHost.name.equals(this.defaultHostName)) {
                this.defaultHost = mappedHost;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHost.success", new Object[]{string}));
            }
        } else {
            object = this.hosts[Mapper.find(this.hosts, string)];
            if (((MappedHost)object).object == host) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("mapper.addHost.sameHost", new Object[]{string}));
                }
                mappedHost = object;
            } else {
                log.error((Object)sm.getString("mapper.duplicateHost", new Object[]{string, ((MappedHost)object).getRealHostName()}));
                return;
            }
        }
        object = new ArrayList(stringArray.length);
        for (String string2 : stringArray) {
            MappedHost mappedHost2 = new MappedHost(string2 = Mapper.renameWildcardHost(string2), mappedHost);
            if (!this.addHostAliasImpl(mappedHost2)) continue;
            object.add(mappedHost2);
        }
        mappedHost.addAliases((Collection<? extends MappedHost>)object);
    }

    public synchronized void removeHost(String string) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(string = Mapper.renameWildcardHost(string)));
        if (mappedHost == null || mappedHost.isAlias()) {
            return;
        }
        MappedHost[] mappedHostArray = (MappedHost[])this.hosts.clone();
        int n = 0;
        for (int i = 0; i < mappedHostArray.length; ++i) {
            if (mappedHostArray[i].getRealHost() == mappedHost) continue;
            mappedHostArray[n++] = mappedHostArray[i];
        }
        this.hosts = Arrays.copyOf(mappedHostArray, n);
    }

    public synchronized void addHostAlias(String string, String string2) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (mappedHost == null) {
            return;
        }
        MappedHost mappedHost2 = new MappedHost(string2 = Mapper.renameWildcardHost(string2), mappedHost);
        if (this.addHostAliasImpl(mappedHost2)) {
            mappedHost.addAlias(mappedHost2);
        }
    }

    private synchronized boolean addHostAliasImpl(MappedHost mappedHost) {
        MappedHost[] mappedHostArray = new MappedHost[this.hosts.length + 1];
        if (Mapper.insertMap(this.hosts, mappedHostArray, mappedHost)) {
            this.hosts = mappedHostArray;
            if (mappedHost.name.equals(this.defaultHostName)) {
                this.defaultHost = mappedHost;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.success", new Object[]{mappedHost.name, mappedHost.getRealHostName()}));
            }
            return true;
        }
        MappedHost mappedHost2 = this.hosts[Mapper.find(this.hosts, mappedHost.name)];
        if (mappedHost2.getRealHost() == mappedHost.getRealHost()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("mapper.addHostAlias.sameHost", new Object[]{mappedHost.name, mappedHost.getRealHostName()}));
            }
            return false;
        }
        log.error((Object)sm.getString("mapper.duplicateHostAlias", new Object[]{mappedHost.name, mappedHost.getRealHostName(), mappedHost2.getRealHostName()}));
        return false;
    }

    public synchronized void removeHostAlias(String string) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(string = Mapper.renameWildcardHost(string)));
        if (mappedHost == null || !mappedHost.isAlias()) {
            return;
        }
        MappedHost[] mappedHostArray = new MappedHost[this.hosts.length - 1];
        if (Mapper.removeMap(this.hosts, mappedHostArray, string)) {
            this.hosts = mappedHostArray;
            mappedHost.getRealHost().removeAlias(mappedHost);
        }
    }

    private void updateContextList(MappedHost mappedHost, ContextList contextList) {
        mappedHost.contextList = contextList;
        for (MappedHost mappedHost2 : mappedHost.getAliases()) {
            mappedHost2.contextList = contextList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContextVersion(String string, Host host, String string2, String string3, Context context, String[] stringArray, WebResourceRoot webResourceRoot, Collection<WrapperMappingInfo> collection) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)(string = Mapper.renameWildcardHost(string)));
        if (mappedHost == null) {
            this.addHost(string, new String[0], host);
            mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)string);
            if (mappedHost == null) {
                log.error((Object)sm.getString("mapper.addContext.noHost", new Object[]{string}));
                return;
            }
        }
        if (mappedHost.isAlias()) {
            log.error((Object)sm.getString("mapper.addContext.hostIsAlias", new Object[]{string}));
            return;
        }
        int n = Mapper.slashCount(string2);
        MappedHost mappedHost2 = mappedHost;
        synchronized (mappedHost2) {
            ContextVersion contextVersion = new ContextVersion(string3, string2, n, context, webResourceRoot, stringArray);
            if (collection != null) {
                this.addWrappers(contextVersion, collection);
            }
            ContextList contextList = mappedHost.contextList;
            MappedContext mappedContext = (MappedContext)Mapper.exactFind((MapElement[])contextList.contexts, (String)string2);
            if (mappedContext == null) {
                mappedContext = new MappedContext(string2, contextVersion);
                ContextList contextList2 = contextList.addContext(mappedContext, n);
                if (contextList2 != null) {
                    this.updateContextList(mappedHost, contextList2);
                    this.contextObjectToContextVersionMap.put(context, contextVersion);
                }
            } else {
                ContextVersion[] contextVersionArray = mappedContext.versions;
                ContextVersion[] contextVersionArray2 = new ContextVersion[contextVersionArray.length + 1];
                if (Mapper.insertMap(contextVersionArray, contextVersionArray2, contextVersion)) {
                    mappedContext.versions = contextVersionArray2;
                    this.contextObjectToContextVersionMap.put(context, contextVersion);
                } else {
                    int n2 = Mapper.find(contextVersionArray, string3);
                    if (n2 >= 0 && contextVersionArray[n2].name.equals(string3)) {
                        contextVersionArray[n2] = contextVersion;
                        this.contextObjectToContextVersionMap.put(context, contextVersion);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextVersion(Context context, String string, String string2, String string3) {
        string = Mapper.renameWildcardHost(string);
        this.contextObjectToContextVersionMap.remove(context);
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (mappedHost == null || mappedHost.isAlias()) {
            return;
        }
        MappedHost mappedHost2 = mappedHost;
        synchronized (mappedHost2) {
            ContextList contextList = mappedHost.contextList;
            MappedContext mappedContext = (MappedContext)Mapper.exactFind((MapElement[])contextList.contexts, (String)string2);
            if (mappedContext == null) {
                return;
            }
            ContextVersion[] contextVersionArray = mappedContext.versions;
            ContextVersion[] contextVersionArray2 = new ContextVersion[contextVersionArray.length - 1];
            if (Mapper.removeMap(contextVersionArray, contextVersionArray2, string3)) {
                if (contextVersionArray2.length == 0) {
                    ContextList contextList2 = contextList.removeContext(string2);
                    if (contextList2 != null) {
                        this.updateContextList(mappedHost, contextList2);
                    }
                } else {
                    mappedContext.versions = contextVersionArray2;
                }
            }
        }
    }

    public void pauseContextVersion(Context context, String string, String string2, String string3) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, true);
        if (contextVersion == null || !context.equals(contextVersion.object)) {
            return;
        }
        contextVersion.markPaused();
    }

    private ContextVersion findContextVersion(String string, String string2, String string3, boolean bl) {
        MappedHost mappedHost = (MappedHost)Mapper.exactFind((MapElement[])this.hosts, (String)string);
        if (mappedHost == null || mappedHost.isAlias()) {
            if (!bl) {
                log.error((Object)sm.getString("mapper.findContext.noHostOrAlias", new Object[]{string}));
            }
            return null;
        }
        MappedContext mappedContext = (MappedContext)Mapper.exactFind((MapElement[])mappedHost.contextList.contexts, (String)string2);
        if (mappedContext == null) {
            if (!bl) {
                log.error((Object)sm.getString("mapper.findContext.noContext", new Object[]{string2}));
            }
            return null;
        }
        ContextVersion contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])mappedContext.versions, (String)string3);
        if (contextVersion == null) {
            if (!bl) {
                log.error((Object)sm.getString("mapper.findContext.noContextVersion", new Object[]{string2, string3}));
            }
            return null;
        }
        return contextVersion;
    }

    public void addWrapper(String string, String string2, String string3, String string4, Wrapper wrapper, boolean bl, boolean bl2) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrapper(contextVersion, string4, wrapper, bl, bl2);
    }

    public void addWrappers(String string, String string2, String string3, Collection<WrapperMappingInfo> collection) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        this.addWrappers(contextVersion, collection);
    }

    private void addWrappers(ContextVersion contextVersion, Collection<WrapperMappingInfo> collection) {
        for (WrapperMappingInfo wrapperMappingInfo : collection) {
            this.addWrapper(contextVersion, wrapperMappingInfo.getMapping(), wrapperMappingInfo.getWrapper(), wrapperMappingInfo.isJspWildCard(), wrapperMappingInfo.isResourceOnly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWrapper(ContextVersion contextVersion, String string, Wrapper wrapper, boolean bl, boolean bl2) {
        ContextVersion contextVersion2 = contextVersion;
        synchronized (contextVersion2) {
            if (string.endsWith("/*")) {
                MappedWrapper[] mappedWrapperArray = contextVersion.wildcardWrappers;
                MappedWrapper[] mappedWrapperArray2 = new MappedWrapper[mappedWrapperArray.length + 1];
                String string2 = string.substring(0, string.length() - 2);
                MappedWrapper mappedWrapper = new MappedWrapper(string2, wrapper, bl, bl2);
                if (Mapper.insertMap(mappedWrapperArray, mappedWrapperArray2, mappedWrapper)) {
                    contextVersion.wildcardWrappers = mappedWrapperArray2;
                    int n = Mapper.slashCount(mappedWrapper.name);
                    if (n > contextVersion.nesting) {
                        contextVersion.nesting = n;
                    }
                }
            } else if (string.startsWith("*.")) {
                MappedWrapper[] mappedWrapperArray = contextVersion.extensionWrappers;
                MappedWrapper[] mappedWrapperArray3 = new MappedWrapper[mappedWrapperArray.length + 1];
                String string3 = string.substring(2);
                MappedWrapper mappedWrapper = new MappedWrapper(string3, wrapper, bl, bl2);
                if (Mapper.insertMap(mappedWrapperArray, mappedWrapperArray3, mappedWrapper)) {
                    contextVersion.extensionWrappers = mappedWrapperArray3;
                }
            } else if (string.equals("/")) {
                contextVersion.defaultWrapper = new MappedWrapper("", wrapper, bl, bl2);
            } else {
                MappedWrapper[] mappedWrapperArray = contextVersion.exactWrappers;
                MappedWrapper[] mappedWrapperArray4 = new MappedWrapper[mappedWrapperArray.length + 1];
                String string4 = string.isEmpty() ? "/" : string;
                MappedWrapper mappedWrapper = new MappedWrapper(string4, wrapper, bl, bl2);
                if (Mapper.insertMap(mappedWrapperArray, mappedWrapperArray4, mappedWrapper)) {
                    contextVersion.exactWrappers = mappedWrapperArray4;
                }
            }
        }
    }

    public void removeWrapper(String string, String string2, String string3, String string4) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, true);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        this.removeWrapper(contextVersion, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWrapper(ContextVersion contextVersion, String string) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("mapper.removeWrapper", new Object[]{contextVersion.name, string}));
        }
        ContextVersion contextVersion2 = contextVersion;
        synchronized (contextVersion2) {
            if (string.endsWith("/*")) {
                String string2 = string.substring(0, string.length() - 2);
                MappedWrapper[] mappedWrapperArray = contextVersion.wildcardWrappers;
                if (mappedWrapperArray.length == 0) {
                    return;
                }
                MappedWrapper[] mappedWrapperArray2 = new MappedWrapper[mappedWrapperArray.length - 1];
                if (Mapper.removeMap(mappedWrapperArray, mappedWrapperArray2, string2)) {
                    contextVersion.nesting = 0;
                    for (MappedWrapper mappedWrapper : mappedWrapperArray2) {
                        int n = Mapper.slashCount(mappedWrapper.name);
                        if (n <= contextVersion.nesting) continue;
                        contextVersion.nesting = n;
                    }
                    contextVersion.wildcardWrappers = mappedWrapperArray2;
                }
            } else if (string.startsWith("*.")) {
                String string3 = string.substring(2);
                MappedWrapper[] mappedWrapperArray = contextVersion.extensionWrappers;
                if (mappedWrapperArray.length == 0) {
                    return;
                }
                MappedWrapper[] mappedWrapperArray3 = new MappedWrapper[mappedWrapperArray.length - 1];
                if (Mapper.removeMap(mappedWrapperArray, mappedWrapperArray3, string3)) {
                    contextVersion.extensionWrappers = mappedWrapperArray3;
                }
            } else if (string.equals("/")) {
                contextVersion.defaultWrapper = null;
            } else {
                String string4 = string.isEmpty() ? "/" : string;
                MappedWrapper[] mappedWrapperArray = contextVersion.exactWrappers;
                if (mappedWrapperArray.length == 0) {
                    return;
                }
                MappedWrapper[] mappedWrapperArray4 = new MappedWrapper[mappedWrapperArray.length - 1];
                if (Mapper.removeMap(mappedWrapperArray, mappedWrapperArray4, string4)) {
                    contextVersion.exactWrappers = mappedWrapperArray4;
                }
            }
        }
    }

    public void addWelcomeFile(String string, String string2, String string3, String string4) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        int n = contextVersion.welcomeResources.length + 1;
        String[] stringArray = new String[n];
        System.arraycopy(contextVersion.welcomeResources, 0, stringArray, 0, n - 1);
        stringArray[n - 1] = string4;
        contextVersion.welcomeResources = stringArray;
    }

    public void removeWelcomeFile(String string, String string2, String string3, String string4) {
        int n;
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, false);
        if (contextVersion == null || contextVersion.isPaused()) {
            return;
        }
        int n2 = -1;
        for (n = 0; n < contextVersion.welcomeResources.length; ++n) {
            if (!string4.equals(contextVersion.welcomeResources[n])) continue;
            n2 = n;
            break;
        }
        if (n2 > -1) {
            n = contextVersion.welcomeResources.length - 1;
            String[] stringArray = new String[n];
            System.arraycopy(contextVersion.welcomeResources, 0, stringArray, 0, n2);
            if (n2 < n) {
                System.arraycopy(contextVersion.welcomeResources, n2 + 1, stringArray, n2, n - n2);
            }
            contextVersion.welcomeResources = stringArray;
        }
    }

    public void clearWelcomeFiles(String string, String string2, String string3) {
        ContextVersion contextVersion = this.findContextVersion(string = Mapper.renameWildcardHost(string), string2, string3, false);
        if (contextVersion == null) {
            return;
        }
        contextVersion.welcomeResources = new String[0];
    }

    public void map(MessageBytes messageBytes, MessageBytes messageBytes2, String string, MappingData mappingData) throws IOException {
        if (messageBytes.isNull()) {
            String string2 = this.defaultHostName;
            if (string2 == null) {
                return;
            }
            messageBytes.setChars(MessageBytes.EMPTY_CHAR_ARRAY, 0, 0);
            messageBytes.getCharChunk().append(string2);
        }
        messageBytes.toChars();
        messageBytes2.toChars();
        this.internalMap(messageBytes.getCharChunk(), messageBytes2.getCharChunk(), string, mappingData);
    }

    public void map(Context context, MessageBytes messageBytes, MappingData mappingData) throws IOException {
        ContextVersion contextVersion = this.contextObjectToContextVersionMap.get(context);
        messageBytes.toChars();
        CharChunk charChunk = messageBytes.getCharChunk();
        charChunk.setLimit(-1);
        this.internalMapWrapper(contextVersion, charChunk, mappingData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalMap(CharChunk charChunk, CharChunk charChunk2, String string, MappingData mappingData) throws IOException {
        if (mappingData.host != null) {
            throw new AssertionError();
        }
        MapElement[] mapElementArray = this.hosts;
        MappedHost mappedHost = (MappedHost)Mapper.exactFindIgnoreCase((MapElement[])mapElementArray, (CharChunk)charChunk);
        if (mappedHost == null) {
            int n = charChunk.indexOf('.');
            if (n > -1) {
                int n2 = charChunk.getStart();
                try {
                    charChunk.setStart(n + n2);
                    mappedHost = (MappedHost)Mapper.exactFindIgnoreCase((MapElement[])mapElementArray, (CharChunk)charChunk);
                }
                finally {
                    charChunk.setStart(n2);
                }
            }
            if (mappedHost == null && (mappedHost = this.defaultHost) == null) {
                return;
            }
        }
        mappingData.host = (Host)mappedHost.object;
        if (charChunk2.isNull()) {
            return;
        }
        charChunk2.setLimit(-1);
        ContextList contextList = mappedHost.contextList;
        MappedContext[] mappedContextArray = contextList.contexts;
        int n = Mapper.find(mappedContextArray, charChunk2);
        if (n == -1) {
            return;
        }
        int n3 = -1;
        int n4 = charChunk2.getEnd();
        boolean bl = false;
        MappedContext mappedContext = null;
        while (n >= 0) {
            mappedContext = mappedContextArray[n];
            if (charChunk2.startsWith(mappedContext.name)) {
                int n5 = mappedContext.name.length();
                if (charChunk2.getLength() == n5) {
                    bl = true;
                    break;
                }
                if (charChunk2.startsWithIgnoreCase("/", n5)) {
                    bl = true;
                    break;
                }
            }
            n3 = n3 == -1 ? Mapper.nthSlash(charChunk2, contextList.nesting + 1) : Mapper.lastSlash(charChunk2);
            charChunk2.setEnd(n3);
            n = Mapper.find(mappedContextArray, charChunk2);
        }
        charChunk2.setEnd(n4);
        if (!bl) {
            mappedContext = mappedContextArray[0].name.isEmpty() ? mappedContextArray[0] : null;
        }
        if (mappedContext == null) {
            return;
        }
        ContextVersion contextVersion = null;
        MapElement[] mapElementArray2 = mappedContext.versions;
        int n6 = mapElementArray2.length;
        if (n6 > 1) {
            Context[] contextArray = new Context[mapElementArray2.length];
            for (int i = 0; i < contextArray.length; ++i) {
                contextArray[i] = (Context)mapElementArray2[i].object;
            }
            mappingData.contexts = contextArray;
            if (string != null) {
                contextVersion = (ContextVersion)Mapper.exactFind((MapElement[])mapElementArray2, (String)string);
            }
        }
        if (contextVersion == null) {
            contextVersion = mapElementArray2[n6 - 1];
        }
        mappingData.context = (Context)contextVersion.object;
        mappingData.contextSlashCount = contextVersion.slashCount;
        if (!contextVersion.isPaused()) {
            this.internalMapWrapper(contextVersion, charChunk2, mappingData);
        }
    }

    private void internalMapWrapper(ContextVersion contextVersion, CharChunk charChunk, MappingData mappingData) throws IOException {
        Object object;
        char[] cArray;
        boolean bl;
        MappedWrapper[] mappedWrapperArray;
        int n = charChunk.getStart();
        int n2 = charChunk.getEnd();
        boolean bl2 = false;
        int n3 = contextVersion.path.length();
        if (n3 == n2 - n) {
            bl2 = true;
        }
        int n4 = n + n3;
        charChunk.setStart(n4);
        MappedWrapper[] mappedWrapperArray2 = contextVersion.exactWrappers;
        this.internalMapExactWrapper(mappedWrapperArray2, charChunk, mappingData);
        boolean bl3 = false;
        MappedWrapper[] mappedWrapperArray3 = contextVersion.wildcardWrappers;
        if (mappingData.wrapper == null) {
            this.internalMapWildcardWrapper(mappedWrapperArray3, contextVersion.nesting, charChunk, mappingData);
            if (mappingData.wrapper != null && mappingData.jspWildCard) {
                mappedWrapperArray = (MappedWrapper[])charChunk.getBuffer();
                if (mappedWrapperArray[n2 - 1] == 47) {
                    mappingData.wrapper = null;
                    bl3 = true;
                } else {
                    mappingData.wrapperPath.setChars((char[])mappedWrapperArray, charChunk.getStart(), charChunk.getLength());
                    mappingData.pathInfo.recycle();
                }
            }
        }
        if (mappingData.wrapper == null && bl2 && ((Context)contextVersion.object).getMapperContextRootRedirectEnabled()) {
            charChunk.append('/');
            n2 = charChunk.getEnd();
            mappingData.redirectPath.setChars(charChunk.getBuffer(), n, n2 - n);
            charChunk.setEnd(n2 - 1);
            return;
        }
        mappedWrapperArray = contextVersion.extensionWrappers;
        if (mappingData.wrapper == null && !bl3) {
            this.internalMapExtensionWrapper(mappedWrapperArray, charChunk, mappingData, true);
        }
        if (mappingData.wrapper == null) {
            bl = bl3;
            if (!bl) {
                cArray = charChunk.getBuffer();
                boolean bl4 = bl = cArray[n2 - 1] == '/';
            }
            if (bl) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    WebResource webResource;
                    charChunk.setStart(n);
                    charChunk.setEnd(n2);
                    charChunk.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    charChunk.setStart(n4);
                    this.internalMapExactWrapper(mappedWrapperArray2, charChunk, mappingData);
                    if (mappingData.wrapper == null) {
                        this.internalMapWildcardWrapper(mappedWrapperArray3, contextVersion.nesting, charChunk, mappingData);
                    }
                    if (mappingData.wrapper != null || contextVersion.resources == null || (webResource = contextVersion.resources.getResource((String)(object = charChunk.toString()))) == null || !webResource.isFile()) continue;
                    this.internalMapExtensionWrapper(mappedWrapperArray, charChunk, mappingData, true);
                    if (mappingData.wrapper != null || contextVersion.defaultWrapper == null) continue;
                    mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                    mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    mappingData.wrapperPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    mappingData.requestPath.setString((String)object);
                    mappingData.wrapperPath.setString((String)object);
                }
                charChunk.setStart(n4);
                charChunk.setEnd(n2);
            }
        }
        if (mappingData.wrapper == null) {
            bl = bl3;
            if (!bl) {
                cArray = charChunk.getBuffer();
                boolean bl5 = bl = cArray[n2 - 1] == '/';
            }
            if (bl) {
                for (int i = 0; i < contextVersion.welcomeResources.length && mappingData.wrapper == null; ++i) {
                    charChunk.setStart(n);
                    charChunk.setEnd(n2);
                    charChunk.append(contextVersion.welcomeResources[i], 0, contextVersion.welcomeResources[i].length());
                    charChunk.setStart(n4);
                    this.internalMapExtensionWrapper(mappedWrapperArray, charChunk, mappingData, false);
                }
                charChunk.setStart(n4);
                charChunk.setEnd(n2);
            }
        }
        if (mappingData.wrapper == null && !bl3) {
            if (contextVersion.defaultWrapper != null) {
                mappingData.wrapper = (Wrapper)contextVersion.defaultWrapper.object;
                mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                mappingData.wrapperPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                mappingData.matchType = MappingMatch.DEFAULT;
            }
            char[] cArray2 = charChunk.getBuffer();
            if (contextVersion.resources != null && cArray2[n2 - 1] != '/') {
                String string = charChunk.toString();
                if (((Context)contextVersion.object).getMapperDirectoryRedirectEnabled()) {
                    object = string.isEmpty() ? contextVersion.resources.getResource("/") : contextVersion.resources.getResource(string);
                    if (object != null && object.isDirectory()) {
                        charChunk.setStart(n);
                        charChunk.append('/');
                        mappingData.redirectPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                    } else {
                        mappingData.requestPath.setString(string);
                        mappingData.wrapperPath.setString(string);
                    }
                } else {
                    mappingData.requestPath.setString(string);
                    mappingData.wrapperPath.setString(string);
                }
            }
        }
        charChunk.setStart(n);
        charChunk.setEnd(n2);
    }

    private void internalMapExactWrapper(MappedWrapper[] mappedWrapperArray, CharChunk charChunk, MappingData mappingData) {
        MappedWrapper mappedWrapper = (MappedWrapper)Mapper.exactFind((MapElement[])mappedWrapperArray, (CharChunk)charChunk);
        if (mappedWrapper != null) {
            mappingData.requestPath.setString(mappedWrapper.name);
            mappingData.wrapper = (Wrapper)mappedWrapper.object;
            if (charChunk.equals("/")) {
                mappingData.pathInfo.setString("/");
                mappingData.wrapperPath.setString("");
                mappingData.matchType = MappingMatch.CONTEXT_ROOT;
            } else {
                mappingData.wrapperPath.setString(mappedWrapper.name);
                mappingData.matchType = MappingMatch.EXACT;
            }
        }
    }

    private void internalMapWildcardWrapper(MappedWrapper[] mappedWrapperArray, int n, CharChunk charChunk, MappingData mappingData) {
        int n2 = charChunk.getEnd();
        int n3 = -1;
        int n4 = -1;
        int n5 = Mapper.find(mappedWrapperArray, charChunk);
        if (n5 != -1) {
            boolean bl = false;
            while (n5 >= 0) {
                if (charChunk.startsWith(mappedWrapperArray[n5].name)) {
                    n4 = mappedWrapperArray[n5].name.length();
                    if (charChunk.getLength() == n4) {
                        bl = true;
                        break;
                    }
                    if (charChunk.startsWithIgnoreCase("/", n4)) {
                        bl = true;
                        break;
                    }
                }
                n3 = n3 == -1 ? Mapper.nthSlash(charChunk, n + 1) : Mapper.lastSlash(charChunk);
                charChunk.setEnd(n3);
                n5 = Mapper.find(mappedWrapperArray, charChunk);
            }
            charChunk.setEnd(n2);
            if (bl) {
                mappingData.wrapperPath.setString(mappedWrapperArray[n5].name);
                if (charChunk.getLength() > n4) {
                    mappingData.pathInfo.setChars(charChunk.getBuffer(), charChunk.getStart() + n4, charChunk.getLength() - n4);
                }
                mappingData.requestPath.setChars(charChunk.getBuffer(), charChunk.getStart(), charChunk.getLength());
                mappingData.wrapper = (Wrapper)mappedWrapperArray[n5].object;
                mappingData.jspWildCard = mappedWrapperArray[n5].jspWildCard;
                mappingData.matchType = MappingMatch.PATH;
            }
        }
    }

    private void internalMapExtensionWrapper(MappedWrapper[] mappedWrapperArray, CharChunk charChunk, MappingData mappingData, boolean bl) {
        int n;
        char[] cArray = charChunk.getBuffer();
        int n2 = charChunk.getEnd();
        int n3 = charChunk.getStart();
        int n4 = -1;
        for (n = n2 - 1; n >= n3; --n) {
            if (cArray[n] != '/') continue;
            n4 = n;
            break;
        }
        if (n4 >= 0) {
            n = -1;
            for (int i = n2 - 1; i > n4; --i) {
                if (cArray[i] != '.') continue;
                n = i;
                break;
            }
            if (n >= 0) {
                charChunk.setStart(n + 1);
                charChunk.setEnd(n2);
                MappedWrapper mappedWrapper = (MappedWrapper)Mapper.exactFind((MapElement[])mappedWrapperArray, (CharChunk)charChunk);
                if (mappedWrapper != null && (bl || !mappedWrapper.resourceOnly)) {
                    mappingData.wrapperPath.setChars(cArray, n3, n2 - n3);
                    mappingData.requestPath.setChars(cArray, n3, n2 - n3);
                    mappingData.wrapper = (Wrapper)mappedWrapper.object;
                    mappingData.matchType = MappingMatch.EXTENSION;
                }
                charChunk.setStart(n3);
                charChunk.setEnd(n2);
            }
        }
    }

    private static <T> int find(MapElement<T>[] mapElementArray, CharChunk charChunk) {
        return Mapper.find(mapElementArray, charChunk, charChunk.getStart(), charChunk.getEnd());
    }

    private static <T> int find(MapElement<T>[] mapElementArray, CharChunk charChunk, int n, int n2) {
        int n3 = 0;
        int n4 = mapElementArray.length - 1;
        if (n4 == -1) {
            return -1;
        }
        if (Mapper.compare(charChunk, n, n2, mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        do {
            int n5 = n4 + n3 >>> 1;
            int n6 = Mapper.compare(charChunk, n, n2, mapElementArray[n5].name);
            if (n6 == 1) {
                n3 = n5;
                continue;
            }
            if (n6 == 0) {
                return n5;
            }
            n4 = n5;
        } while (n4 - n3 != 1);
        int n7 = Mapper.compare(charChunk, n, n2, mapElementArray[n4].name);
        if (n7 < 0) {
            return n3;
        }
        return n4;
    }

    private static <T> int findIgnoreCase(MapElement<T>[] mapElementArray, CharChunk charChunk) {
        return Mapper.findIgnoreCase(mapElementArray, charChunk, charChunk.getStart(), charChunk.getEnd());
    }

    private static <T> int findIgnoreCase(MapElement<T>[] mapElementArray, CharChunk charChunk, int n, int n2) {
        int n3 = 0;
        int n4 = mapElementArray.length - 1;
        if (n4 == -1) {
            return -1;
        }
        if (Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n4 == 0) {
            return 0;
        }
        do {
            int n5 = n4 + n3 >>> 1;
            int n6 = Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[n5].name);
            if (n6 == 1) {
                n3 = n5;
                continue;
            }
            if (n6 == 0) {
                return n5;
            }
            n4 = n5;
        } while (n4 - n3 != 1);
        int n7 = Mapper.compareIgnoreCase(charChunk, n, n2, mapElementArray[n4].name);
        if (n7 < 0) {
            return n3;
        }
        return n4;
    }

    private static <T> int find(MapElement<T>[] mapElementArray, String string) {
        int n = 0;
        int n2 = mapElementArray.length - 1;
        if (n2 == -1) {
            return -1;
        }
        if (string.compareTo(mapElementArray[0].name) < 0) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        do {
            int n3 = n2 + n >>> 1;
            int n4 = string.compareTo(mapElementArray[n3].name);
            if (n4 > 0) {
                n = n3;
                continue;
            }
            if (n4 == 0) {
                return n3;
            }
            n2 = n3;
        } while (n2 - n != 1);
        int n5 = string.compareTo(mapElementArray[n2].name);
        if (n5 < 0) {
            return n;
        }
        return n2;
    }

    private static <T, E extends MapElement<T>> E exactFind(E[] EArray, String string) {
        int n = Mapper.find(EArray, string);
        if (n >= 0) {
            E e = EArray[n];
            if (string.equals(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static <T, E extends MapElement<T>> E exactFind(E[] EArray, CharChunk charChunk) {
        int n = Mapper.find(EArray, charChunk);
        if (n >= 0) {
            E e = EArray[n];
            if (charChunk.equals(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static <T, E extends MapElement<T>> E exactFindIgnoreCase(E[] EArray, CharChunk charChunk) {
        int n = Mapper.findIgnoreCase(EArray, charChunk);
        if (n >= 0) {
            E e = EArray[n];
            if (charChunk.equalsIgnoreCase(((MapElement)e).name)) {
                return e;
            }
        }
        return null;
    }

    private static int compare(CharChunk charChunk, int n, int n2, String string) {
        int n3 = 0;
        char[] cArray = charChunk.getBuffer();
        int n4 = string.length();
        int n5 = n4;
        if (n2 - n < n5) {
            n5 = n2 - n;
        }
        for (int i = 0; i < n5 && n3 == 0; ++i) {
            char c = cArray[i + n];
            char c2 = string.charAt(i);
            if (c > c2) {
                n3 = 1;
                continue;
            }
            if (c >= c2) continue;
            n3 = -1;
        }
        if (n3 == 0) {
            if (n4 > n2 - n) {
                n3 = -1;
            } else if (n4 < n2 - n) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static int compareIgnoreCase(CharChunk charChunk, int n, int n2, String string) {
        int n3 = 0;
        char[] cArray = charChunk.getBuffer();
        int n4 = string.length();
        int n5 = n4;
        if (n2 - n < n5) {
            n5 = n2 - n;
        }
        for (int i = 0; i < n5 && n3 == 0; ++i) {
            int n6;
            int n7 = Ascii.toLower((int)cArray[i + n]);
            if (n7 > (n6 = Ascii.toLower((int)string.charAt(i)))) {
                n3 = 1;
                continue;
            }
            if (n7 >= n6) continue;
            n3 = -1;
        }
        if (n3 == 0) {
            if (n4 > n2 - n) {
                n3 = -1;
            } else if (n4 < n2 - n) {
                n3 = 1;
            }
        }
        return n3;
    }

    private static int lastSlash(CharChunk charChunk) {
        char[] cArray = charChunk.getBuffer();
        int n = charChunk.getEnd();
        int n2 = charChunk.getStart();
        int n3 = n;
        while (n3 > n2 && cArray[--n3] != '/') {
        }
        return n3;
    }

    private static int nthSlash(CharChunk charChunk, int n) {
        char[] cArray = charChunk.getBuffer();
        int n2 = charChunk.getEnd();
        int n3 = charChunk.getStart();
        int n4 = 0;
        while (n3 < n2) {
            if (cArray[n3++] != '/' || ++n4 != n) continue;
            --n3;
            break;
        }
        return n3;
    }

    private static int slashCount(String string) {
        int n = -1;
        int n2 = 0;
        while ((n = string.indexOf(47, n + 1)) != -1) {
            ++n2;
        }
        return n2;
    }

    private static <T> boolean insertMap(MapElement<T>[] mapElementArray, MapElement<T>[] mapElementArray2, MapElement<T> mapElement) {
        int n = Mapper.find(mapElementArray, mapElement.name);
        if (n != -1 && mapElement.name.equals(mapElementArray[n].name)) {
            return false;
        }
        System.arraycopy(mapElementArray, 0, mapElementArray2, 0, n + 1);
        mapElementArray2[n + 1] = mapElement;
        System.arraycopy(mapElementArray, n + 1, mapElementArray2, n + 2, mapElementArray.length - n - 1);
        return true;
    }

    private static <T> boolean removeMap(MapElement<T>[] mapElementArray, MapElement<T>[] mapElementArray2, String string) {
        int n = Mapper.find(mapElementArray, string);
        if (n != -1 && string.equals(mapElementArray[n].name)) {
            System.arraycopy(mapElementArray, 0, mapElementArray2, 0, n);
            System.arraycopy(mapElementArray, n + 1, mapElementArray2, n, mapElementArray.length - n - 1);
            return true;
        }
        return false;
    }

    private static String renameWildcardHost(String string) {
        if (string != null && string.startsWith("*.")) {
            return string.substring(1);
        }
        return string;
    }

    protected static final class MappedHost
    extends MapElement<Host> {
        public volatile ContextList contextList;
        private final MappedHost realHost;
        private final List<MappedHost> aliases;

        public MappedHost(String string, Host host) {
            super(string, host);
            this.realHost = this;
            this.contextList = new ContextList();
            this.aliases = new CopyOnWriteArrayList<MappedHost>();
        }

        public MappedHost(String string, MappedHost mappedHost) {
            super(string, (Host)mappedHost.object);
            this.realHost = mappedHost;
            this.contextList = mappedHost.contextList;
            this.aliases = null;
        }

        public boolean isAlias() {
            return this.realHost != this;
        }

        public MappedHost getRealHost() {
            return this.realHost;
        }

        public String getRealHostName() {
            return this.realHost.name;
        }

        public Collection<MappedHost> getAliases() {
            return this.aliases;
        }

        public void addAlias(MappedHost mappedHost) {
            this.aliases.add(mappedHost);
        }

        public void addAliases(Collection<? extends MappedHost> collection) {
            this.aliases.addAll(collection);
        }

        public void removeAlias(MappedHost mappedHost) {
            this.aliases.remove(mappedHost);
        }
    }

    protected static abstract class MapElement<T> {
        public final String name;
        public final T object;

        public MapElement(String string, T t) {
            this.name = string;
            this.object = t;
        }
    }

    protected static final class ContextList {
        public final MappedContext[] contexts;
        public final int nesting;

        public ContextList() {
            this(new MappedContext[0], 0);
        }

        private ContextList(MappedContext[] mappedContextArray, int n) {
            this.contexts = mappedContextArray;
            this.nesting = n;
        }

        public ContextList addContext(MappedContext mappedContext, int n) {
            MappedContext[] mappedContextArray = new MappedContext[this.contexts.length + 1];
            if (Mapper.insertMap(this.contexts, mappedContextArray, mappedContext)) {
                return new ContextList(mappedContextArray, Math.max(this.nesting, n));
            }
            return null;
        }

        public ContextList removeContext(String string) {
            MappedContext[] mappedContextArray = new MappedContext[this.contexts.length - 1];
            if (Mapper.removeMap(this.contexts, mappedContextArray, string)) {
                int n = 0;
                for (MappedContext mappedContext : mappedContextArray) {
                    n = Math.max(n, Mapper.slashCount(mappedContext.name));
                }
                return new ContextList(mappedContextArray, n);
            }
            return null;
        }
    }

    protected static final class ContextVersion
    extends MapElement<Context> {
        public final String path;
        public final int slashCount;
        public final WebResourceRoot resources;
        public String[] welcomeResources;
        public MappedWrapper defaultWrapper = null;
        public MappedWrapper[] exactWrappers = new MappedWrapper[0];
        public MappedWrapper[] wildcardWrappers = new MappedWrapper[0];
        public MappedWrapper[] extensionWrappers = new MappedWrapper[0];
        public int nesting = 0;
        private volatile boolean paused;

        public ContextVersion(String string, String string2, int n, Context context, WebResourceRoot webResourceRoot, String[] stringArray) {
            super(string, context);
            this.path = string2;
            this.slashCount = n;
            this.resources = webResourceRoot;
            this.welcomeResources = stringArray;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void markPaused() {
            this.paused = true;
        }
    }

    protected static final class MappedContext
    extends MapElement<Void> {
        public volatile ContextVersion[] versions;

        public MappedContext(String string, ContextVersion contextVersion) {
            super(string, null);
            this.versions = new ContextVersion[]{contextVersion};
        }
    }

    protected static class MappedWrapper
    extends MapElement<Wrapper> {
        public final boolean jspWildCard;
        public final boolean resourceOnly;

        public MappedWrapper(String string, Wrapper wrapper, boolean bl, boolean bl2) {
            super(string, wrapper);
            this.jspWildCard = bl;
            this.resourceOnly = bl2;
        }
    }
}

