/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#pragma once

#ifdef __cplusplus
extern "C" {
#endif

/* Opaque structures to hide cryptographic implementation details. */
struct x509_crt;
struct x509_crt_stack;

/*!
 * @brief Certificate issuer information.
 */
struct crt_issuer_info {
	char *o; /*!< Organisation name. */
	char *ou; /*!< Organisation unit name. */
	char *n; /*!< Common name. */
	char *c; /*!< Country name. */
};

/*!
 * @brief Certificate verification outcome structure.
 */
struct crt_verif_outcome {
	int parent_crt_not_found;
	int time_validity_fail;
	int crt_revoked;
	int crt_signature_invalid;
};

/*!
 * @brief Describes DER (binary, raw) data type used in the application.
 */
enum der_data_type {
	DER_UNKNOWN = 0, /*!< Unknown type. */
	DER_XML_TST, /*!< Timestamp data held within the XML tree of the envelope. */
	DER_TST, /*!< CMS container signature timestamp token. */
	DER_ARCHIVE_TST /*!< Archive timestamp tokens added to the CMS container. */
};

/*!
 * @brief DER data portion.
 */
struct der_data {
	enum der_data_type type; /*!< Held data type. */
	void *data; /*!< Pointer to data. */
	size_t size; /*!< Size of data. */
};

/*!
 * @brief List entry holding DER data.
 */
struct der_data_list_entry {
	struct der_data der;
	struct der_data_list_entry *next;
};

#ifdef __cplusplus
} /* extern "C" */
#endif
