// Copyright 2019 Drone IO, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package core

import (
	"context"
	"errors"
)

var (
	// ErrValidatorSkip is returned if the pipeline
	// validation fails, but the pipeline should be skipped
	// and silently ignored instead of erroring.
	ErrValidatorSkip = errors.New("validation failed: skip pipeline")

	// ErrValidatorBlock is returned if the pipeline
	// validation fails, but the pipeline should be blocked
	// pending manual approval instead of erroring.
	ErrValidatorBlock = errors.New("validation failed: block pipeline")
)

type (
	// ValidateArgs represents a request to the pipeline
	// validation service.
	ValidateArgs struct {
		User   *User       `json:"-"`
		Repo   *Repository `json:"repo,omitempty"`
		Build  *Build      `json:"build,omitempty"`
		Config *Config     `json:"config,omitempty"`
	}

	// ValidateService validates the yaml configuration
	// and returns an error if the yaml is deemed invalid.
	ValidateService interface {
		Validate(context.Context, *ValidateArgs) error
	}
)
