/* gitg-diff-view-file.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view-file.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include "libgitg.h"
#include <glib.h>
#include <gee.h>
#include <libgit2-glib/ggit.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_VIEW_FILE (gitg_diff_view_file_get_type ())
#define GITG_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile))
#define GITG_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))
#define GITG_IS_DIFF_VIEW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_IS_DIFF_VIEW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE))
#define GITG_DIFF_VIEW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFileClass))

typedef struct _GitgDiffViewFile GitgDiffViewFile;
typedef struct _GitgDiffViewFileClass GitgDiffViewFileClass;
typedef struct _GitgDiffViewFilePrivate GitgDiffViewFilePrivate;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER (gitg_diff_view_file_renderer_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRenderer))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER))
#define GITG_DIFF_VIEW_FILE_RENDERER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER, GitgDiffViewFileRendererIface))

typedef struct _GitgDiffViewFileRenderer GitgDiffViewFileRenderer;
typedef struct _GitgDiffViewFileRendererIface GitgDiffViewFileRendererIface;

#define GITG_TYPE_DIFF_VIEW_FILE_INFO (gitg_diff_view_file_info_get_type ())
#define GITG_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfo))
#define GITG_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))
#define GITG_IS_DIFF_VIEW_FILE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_IS_DIFF_VIEW_FILE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_INFO))
#define GITG_DIFF_VIEW_FILE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_INFO, GitgDiffViewFileInfoClass))

typedef struct _GitgDiffViewFileInfo GitgDiffViewFileInfo;
typedef struct _GitgDiffViewFileInfoClass GitgDiffViewFileInfoClass;
enum  {
	GITG_DIFF_VIEW_FILE_0_PROPERTY,
	GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY,
	GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY,
	GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY,
	GITG_DIFF_VIEW_FILE_INFO_PROPERTY,
	GITG_DIFF_VIEW_FILE_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TYPE_DIFF_SELECTABLE (gitg_diff_selectable_get_type ())
#define GITG_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectable))
#define GITG_IS_DIFF_SELECTABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_SELECTABLE))
#define GITG_DIFF_SELECTABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GITG_TYPE_DIFF_SELECTABLE, GitgDiffSelectableIface))

typedef struct _GitgDiffSelectable GitgDiffSelectable;
typedef struct _GitgDiffSelectableIface GitgDiffSelectableIface;
#define _gitg_patch_set_unref0(var) ((var == NULL) ? NULL : (var = (gitg_patch_set_unref (var), NULL)))

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT (gitg_diff_view_file_renderer_text_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererText))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT, GitgDiffViewFileRendererTextClass))

typedef struct _GitgDiffViewFileRendererText GitgDiffViewFileRendererText;
typedef struct _GitgDiffViewFileRendererTextClass GitgDiffViewFileRendererTextClass;
typedef enum  {
	GITG_DIFF_VIEW_FILE_RENDERER_TEXT_STYLE_ONE,
	GITG_DIFF_VIEW_FILE_RENDERER_TEXT_STYLE_OLD,
	GITG_DIFF_VIEW_FILE_RENDERER_TEXT_STYLE_NEW
} GitgDiffViewFileRendererTextStyle;

#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_TYPE_STYLE (gitg_diff_view_file_renderer_text_style_get_type ())

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT (gitg_diff_view_file_renderer_text_split_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT, GitgDiffViewFileRendererTextSplit))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT, GitgDiffViewFileRendererTextSplitClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT))
#define GITG_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_TEXT_SPLIT, GitgDiffViewFileRendererTextSplitClass))

typedef struct _GitgDiffViewFileRendererTextSplit GitgDiffViewFileRendererTextSplit;
typedef struct _GitgDiffViewFileRendererTextSplitClass GitgDiffViewFileRendererTextSplitClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY (gitg_diff_view_file_renderer_binary_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_BINARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY, GitgDiffViewFileRendererBinary))
#define GITG_DIFF_VIEW_FILE_RENDERER_BINARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY, GitgDiffViewFileRendererBinaryClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_BINARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_BINARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY))
#define GITG_DIFF_VIEW_FILE_RENDERER_BINARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_BINARY, GitgDiffViewFileRendererBinaryClass))

typedef struct _GitgDiffViewFileRendererBinary GitgDiffViewFileRendererBinary;
typedef struct _GitgDiffViewFileRendererBinaryClass GitgDiffViewFileRendererBinaryClass;

#define GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE (gitg_diff_view_file_renderer_image_get_type ())
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImage))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImageClass))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE))
#define GITG_IS_DIFF_VIEW_FILE_RENDERER_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE))
#define GITG_DIFF_VIEW_FILE_RENDERER_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_FILE_RENDERER_IMAGE, GitgDiffViewFileRendererImageClass))

typedef struct _GitgDiffViewFileRendererImage GitgDiffViewFileRendererImage;
typedef struct _GitgDiffViewFileRendererImageClass GitgDiffViewFileRendererImageClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _ggit_diff_file_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_file_unref (var), NULL)))
#define _ggit_diff_delta_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_delta_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GitgDiffViewFile {
	GtkGrid parent_instance;
	GitgDiffViewFilePrivate * priv;
};

struct _GitgDiffViewFileClass {
	GtkGridClass parent_class;
};

struct _GitgDiffViewFileRendererIface {
	GTypeInterface parent_iface;
	void (*add_hunk) (GitgDiffViewFileRenderer* self, GgitDiffHunk* hunk, GeeArrayList* lines);
};

struct _GitgDiffViewFilePrivate {
	GtkExpander* d_expander;
	GtkLabel* d_label_file_header;
	GitgDiffStat* d_diff_stat_file;
	GtkRevealer* d_revealer_content;
	GtkStackSwitcher* d_stack_switcher;
	GtkStack* d_stack_file_renderer;
	gboolean d_expanded;
	GeeArrayList* _renderer_list;
	gboolean _new_is_workdir;
	GitgDiffViewFileInfo* _info;
	GeeHashMap* d_diff_stat_visible_map;
};

struct _GitgDiffSelectableIface {
	GTypeInterface parent_iface;
	void (*clear_selection) (GitgDiffSelectable* self);
	gboolean (*get_has_selection) (GitgDiffSelectable* self);
	gboolean (*get_can_select) (GitgDiffSelectable* self);
	void (*set_can_select) (GitgDiffSelectable* self, gboolean value);
	GitgPatchSet* (*get_selection) (GitgDiffSelectable* self);
};

struct _Block10Data {
	int _ref_count_;
	GitgDiffViewFile* self;
	GFile* location;
};

static gint GitgDiffViewFile_private_offset;
static gpointer gitg_diff_view_file_parent_class = NULL;

VALA_EXTERN GType gitg_diff_view_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_view_file_renderer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType gitg_diff_view_file_info_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean gitg_diff_view_file_has_selection (GitgDiffViewFile* self);
VALA_EXTERN GeeArrayList* gitg_diff_view_file_get_renderer_list (GitgDiffViewFile* self);
VALA_EXTERN GType gitg_diff_selectable_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean gitg_diff_selectable_get_has_selection (GitgDiffSelectable* self);
VALA_EXTERN void gitg_diff_view_file_clear_selection (GitgDiffViewFile* self);
VALA_EXTERN void gitg_diff_selectable_clear_selection (GitgDiffSelectable* self);
VALA_EXTERN GitgPatchSet* gitg_diff_view_file_get_selection (GitgDiffViewFile* self);
VALA_EXTERN GitgPatchSet* gitg_diff_selectable_get_selection (GitgDiffSelectable* self);
VALA_EXTERN GitgDiffViewFile* gitg_diff_view_file_new (GitgDiffViewFileInfo* info);
VALA_EXTERN GitgDiffViewFile* gitg_diff_view_file_construct (GType object_type,
                                                 GitgDiffViewFileInfo* info);
static void gitg_diff_view_file_page_changed (GitgDiffViewFile* self);
static void _gitg_diff_view_file_page_changed_g_object_notify (GObject* _sender,
                                                        GParamSpec* pspec,
                                                        gpointer self);
static void gitg_diff_view_file_set_renderer_list (GitgDiffViewFile* self,
                                            GeeArrayList* value);
VALA_EXTERN void gitg_diff_view_file_add_renderer (GitgDiffViewFile* self,
                                       GitgDiffViewFileRenderer* renderer,
                                       GtkWidget* widget,
                                       const gchar* name,
                                       const gchar* title,
                                       gboolean show_stats);
VALA_EXTERN void gitg_diff_view_file_add_text_renderer (GitgDiffViewFile* self,
                                            gboolean handle_selection);
VALA_EXTERN GType gitg_diff_view_file_renderer_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgDiffViewFileInfo* gitg_diff_view_file_get_info (GitgDiffViewFile* self);
VALA_EXTERN GType gitg_diff_view_file_renderer_text_style_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgDiffViewFileRendererText* gitg_diff_view_file_renderer_text_new (GitgDiffViewFileInfo* info,
                                                                     gboolean can_select,
                                                                     GitgDiffViewFileRendererTextStyle style);
VALA_EXTERN GitgDiffViewFileRendererText* gitg_diff_view_file_renderer_text_construct (GType object_type,
                                                                           GitgDiffViewFileInfo* info,
                                                                           gboolean can_select,
                                                                           GitgDiffViewFileRendererTextStyle style);
VALA_EXTERN GType gitg_diff_view_file_renderer_text_split_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgDiffViewFileRendererTextSplit* gitg_diff_view_file_renderer_text_split_new (GitgDiffViewFileInfo* info,
                                                                                gboolean handle_selection);
VALA_EXTERN GitgDiffViewFileRendererTextSplit* gitg_diff_view_file_renderer_text_split_construct (GType object_type,
                                                                                      GitgDiffViewFileInfo* info,
                                                                                      gboolean handle_selection);
VALA_EXTERN void gitg_diff_view_file_add_binary_renderer (GitgDiffViewFile* self);
VALA_EXTERN GType gitg_diff_view_file_renderer_binary_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgDiffViewFileRendererBinary* gitg_diff_view_file_renderer_binary_new (void);
VALA_EXTERN GitgDiffViewFileRendererBinary* gitg_diff_view_file_renderer_binary_construct (GType object_type);
VALA_EXTERN void gitg_diff_view_file_add_image_renderer (GitgDiffViewFile* self);
VALA_EXTERN GType gitg_diff_view_file_renderer_image_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GitgRepository* gitg_diff_view_file_info_get_repository (GitgDiffViewFileInfo* self);
VALA_EXTERN GgitDiffDelta* gitg_diff_view_file_info_get_delta (GitgDiffViewFileInfo* self);
VALA_EXTERN GitgDiffViewFileRendererImage* gitg_diff_view_file_renderer_image_new (GitgRepository* repository,
                                                                       GgitDiffDelta* delta);
VALA_EXTERN GitgDiffViewFileRendererImage* gitg_diff_view_file_renderer_image_construct (GType object_type,
                                                                             GitgRepository* repository,
                                                                             GgitDiffDelta* delta);
static void gitg_diff_view_file_real_constructed (GObject* base);
static gboolean gitg_diff_view_file_expander_popup_menu (GitgDiffViewFile* self,
                                                  GtkWidget* widget);
static gboolean _gitg_diff_view_file_expander_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                         gpointer self);
static gboolean gitg_diff_view_file_expander_button_press_event (GitgDiffViewFile* self,
                                                          GtkWidget* widget,
                                                          GdkEventButton* event);
static gboolean _gitg_diff_view_file_expander_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                         GdkEventButton* event,
                                                                                         gpointer self);
static void gitg_diff_view_file_show_popup (GitgDiffViewFile* self,
                                     GdkEventButton* event);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda61_ (Block10Data* _data10_);
static void ___lambda61__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda62_ (Block10Data* _data10_);
static void ___lambda62__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda63_ (Block10Data* _data10_);
static void ___lambda63__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
VALA_EXTERN void gitg_diff_view_file_add_hunk (GitgDiffViewFile* self,
                                   GgitDiffHunk* hunk,
                                   GeeArrayList* lines);
VALA_EXTERN void gitg_diff_view_file_renderer_add_hunk (GitgDiffViewFileRenderer* self,
                                            GgitDiffHunk* hunk,
                                            GeeArrayList* lines);
VALA_EXTERN gboolean gitg_diff_view_file_get_new_is_workdir (GitgDiffViewFile* self);
VALA_EXTERN void gitg_diff_view_file_set_new_is_workdir (GitgDiffViewFile* self,
                                             gboolean value);
VALA_EXTERN gboolean gitg_diff_view_file_get_expanded (GitgDiffViewFile* self);
VALA_EXTERN void gitg_diff_view_file_set_expanded (GitgDiffViewFile* self,
                                       gboolean value);
VALA_EXTERN void gitg_diff_view_file_set_info (GitgDiffViewFile* self,
                                   GitgDiffViewFileInfo* value);
static void gitg_diff_view_file_finalize (GObject * obj);
static GType gitg_diff_view_file_get_type_once (void);
static void _vala_gitg_diff_view_file_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_gitg_diff_view_file_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static inline gpointer
gitg_diff_view_file_get_instance_private (GitgDiffViewFile* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewFile_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
gitg_diff_view_file_has_selection (GitgDiffViewFile* self)
{
	gboolean has_selection = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	has_selection = FALSE;
	{
		GeeArrayList* _renderer_list = NULL;
		GeeArrayList* _tmp0_;
		gint _renderer_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _renderer_index = 0;
		_tmp0_ = self->priv->_renderer_list;
		_renderer_list = _tmp0_;
		_tmp1_ = _renderer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_renderer_size = _tmp3_;
		_renderer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgDiffViewFileRenderer* renderer = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GitgDiffSelectable* selectable = NULL;
			GitgDiffViewFileRenderer* _tmp8_;
			GitgDiffSelectable* _tmp9_;
			GitgDiffSelectable* _tmp10_;
			_renderer_index = _renderer_index + 1;
			_tmp4_ = _renderer_index;
			_tmp5_ = _renderer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _renderer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _renderer_index);
			renderer = (GitgDiffViewFileRenderer*) _tmp7_;
			_tmp8_ = renderer;
			_tmp9_ = _g_object_ref0 (GITG_IS_DIFF_SELECTABLE (_tmp8_) ? ((GitgDiffSelectable*) _tmp8_) : NULL);
			selectable = _tmp9_;
			_tmp10_ = selectable;
			if (_tmp10_ != NULL) {
				GitgDiffSelectable* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = selectable;
				_tmp12_ = gitg_diff_selectable_get_has_selection (_tmp11_);
				_tmp13_ = _tmp12_;
				has_selection = _tmp13_;
			}
			if (has_selection) {
				_g_object_unref0 (selectable);
				_g_object_unref0 (renderer);
				break;
			}
			_g_object_unref0 (selectable);
			_g_object_unref0 (renderer);
		}
	}
	result = has_selection;
	return result;
}

void
gitg_diff_view_file_clear_selection (GitgDiffViewFile* self)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _renderer_list = NULL;
		GeeArrayList* _tmp0_;
		gint _renderer_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _renderer_index = 0;
		_tmp0_ = self->priv->_renderer_list;
		_renderer_list = _tmp0_;
		_tmp1_ = _renderer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_renderer_size = _tmp3_;
		_renderer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgDiffViewFileRenderer* renderer = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GitgDiffSelectable* sel = NULL;
			GitgDiffViewFileRenderer* _tmp8_;
			GitgDiffSelectable* _tmp9_;
			GitgDiffSelectable* _tmp10_;
			_renderer_index = _renderer_index + 1;
			_tmp4_ = _renderer_index;
			_tmp5_ = _renderer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _renderer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _renderer_index);
			renderer = (GitgDiffViewFileRenderer*) _tmp7_;
			_tmp8_ = renderer;
			_tmp9_ = _g_object_ref0 (GITG_IS_DIFF_SELECTABLE (_tmp8_) ? ((GitgDiffSelectable*) _tmp8_) : NULL);
			sel = _tmp9_;
			_tmp10_ = sel;
			gitg_diff_selectable_clear_selection (_tmp10_);
			_g_object_unref0 (sel);
			_g_object_unref0 (renderer);
		}
	}
}

GitgPatchSet*
gitg_diff_view_file_get_selection (GitgDiffViewFile* self)
{
	GitgPatchSet* ret = NULL;
	GitgPatchSet* _tmp0_;
	GitgPatchSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gitg_patch_set_new ();
	ret = _tmp0_;
	{
		GeeArrayList* _renderer_list = NULL;
		GeeArrayList* _tmp1_;
		gint _renderer_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _renderer_index = 0;
		_tmp1_ = self->priv->_renderer_list;
		_renderer_list = _tmp1_;
		_tmp2_ = _renderer_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_renderer_size = _tmp4_;
		_renderer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			GitgDiffViewFileRenderer* renderer = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GitgDiffSelectable* sel = NULL;
			GitgDiffViewFileRenderer* _tmp9_;
			GitgDiffSelectable* _tmp10_;
			gboolean _tmp11_ = FALSE;
			gboolean _tmp12_ = FALSE;
			GitgDiffSelectable* _tmp13_;
			_renderer_index = _renderer_index + 1;
			_tmp5_ = _renderer_index;
			_tmp6_ = _renderer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _renderer_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _renderer_index);
			renderer = (GitgDiffViewFileRenderer*) _tmp8_;
			_tmp9_ = renderer;
			_tmp10_ = _g_object_ref0 (GITG_IS_DIFF_SELECTABLE (_tmp9_) ? ((GitgDiffSelectable*) _tmp9_) : NULL);
			sel = _tmp10_;
			_tmp13_ = sel;
			if (_tmp13_ != NULL) {
				GitgDiffSelectable* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = sel;
				_tmp15_ = gitg_diff_selectable_get_has_selection (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp12_ = _tmp16_;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				GitgDiffSelectable* _tmp17_;
				GitgPatchSet* _tmp18_;
				GitgPatchSet* _tmp19_;
				GitgPatchSet* _tmp20_;
				GitgPatchSetPatch* _tmp21_;
				gint _tmp21__length1;
				_tmp17_ = sel;
				_tmp18_ = gitg_diff_selectable_get_selection (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_;
				_tmp21_ = _tmp20_->patches;
				_tmp21__length1 = _tmp20_->patches_length1;
				_tmp11_ = _tmp21__length1 != 0;
				_gitg_patch_set_unref0 (_tmp20_);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				GitgDiffSelectable* _tmp22_;
				GitgPatchSet* _tmp23_;
				GitgPatchSet* _tmp24_;
				_tmp22_ = sel;
				_tmp23_ = gitg_diff_selectable_get_selection (_tmp22_);
				_tmp24_ = _tmp23_;
				_gitg_patch_set_unref0 (ret);
				ret = _tmp24_;
				_g_object_unref0 (sel);
				_g_object_unref0 (renderer);
				break;
			}
			_g_object_unref0 (sel);
			_g_object_unref0 (renderer);
		}
	}
	result = ret;
	return result;
}

static void
_gitg_diff_view_file_page_changed_g_object_notify (GObject* _sender,
                                                   GParamSpec* pspec,
                                                   gpointer self)
{
	gitg_diff_view_file_page_changed ((GitgDiffViewFile*) self);
}

GitgDiffViewFile*
gitg_diff_view_file_construct (GType object_type,
                               GitgDiffViewFileInfo* info)
{
	GitgDiffViewFile * self = NULL;
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	self = (GitgDiffViewFile*) g_object_new (object_type, "info", info, NULL);
	_tmp0_ = self->priv->d_stack_file_renderer;
	g_object_bind_property_with_closures ((GObject*) self, "vexpand", (GObject*) _tmp0_, "vexpand", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp1_ = self->priv->d_stack_file_renderer;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::visible-child", (GCallback) _gitg_diff_view_file_page_changed_g_object_notify, self, 0);
	_tmp2_ = gee_array_list_new (GITG_TYPE_DIFF_VIEW_FILE_RENDERER, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	gitg_diff_view_file_set_renderer_list (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	return self;
}

GitgDiffViewFile*
gitg_diff_view_file_new (GitgDiffViewFileInfo* info)
{
	return gitg_diff_view_file_construct (GITG_TYPE_DIFF_VIEW_FILE, info);
}

static void
gitg_diff_view_file_page_changed (GitgDiffViewFile* self)
{
	GtkWidget* visible_child = NULL;
	GtkStack* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp2_;
	gboolean visible = FALSE;
	GeeHashMap* _tmp3_;
	gpointer _tmp4_;
	GitgDiffStat* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->d_stack_file_renderer;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	visible_child = _tmp2_;
	_tmp3_ = self->priv->d_diff_stat_visible_map;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, visible_child);
	visible = (gboolean) ((gintptr) _tmp4_);
	_tmp5_ = self->priv->d_diff_stat_file;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, visible);
	_g_object_unref0 (visible_child);
}

void
gitg_diff_view_file_add_renderer (GitgDiffViewFile* self,
                                  GitgDiffViewFileRenderer* renderer,
                                  GtkWidget* widget,
                                  const gchar* name,
                                  const gchar* title,
                                  gboolean show_stats)
{
	GeeHashMap* _tmp0_;
	GeeArrayList* _tmp1_;
	GtkStack* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (renderer != NULL);
	g_return_if_fail (widget != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = self->priv->d_diff_stat_visible_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, widget, (gpointer) ((gintptr) show_stats));
	_tmp1_ = self->priv->_renderer_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, renderer);
	_tmp2_ = self->priv->d_stack_file_renderer;
	gtk_stack_add_titled (_tmp2_, widget, name, title);
}

void
gitg_diff_view_file_add_text_renderer (GitgDiffViewFile* self,
                                       gboolean handle_selection)
{
	GitgDiffViewFileRendererText* renderer = NULL;
	GitgDiffViewFileInfo* _tmp0_;
	GitgDiffViewFileRendererText* _tmp1_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp2_;
	GitgDiffStat* _tmp3_;
	GitgDiffStat* _tmp4_;
	GitgDiffViewFileRendererTextSplit* renderer_split = NULL;
	GitgDiffViewFileInfo* _tmp5_;
	GitgDiffViewFileRendererTextSplit* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = gitg_diff_view_file_renderer_text_new (_tmp0_, handle_selection, GITG_DIFF_VIEW_FILE_RENDERER_TEXT_STYLE_ONE);
	g_object_ref_sink (_tmp1_);
	renderer = _tmp1_;
	gtk_widget_show ((GtkWidget*) renderer);
	_tmp2_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp2_);
	scrolled_window = _tmp2_;
	gtk_scrolled_window_set_policy (scrolled_window, GTK_POLICY_AUTOMATIC, GTK_POLICY_NEVER);
	gtk_container_add ((GtkContainer*) scrolled_window, (GtkWidget*) renderer);
	gtk_widget_show ((GtkWidget*) scrolled_window);
	_tmp3_ = self->priv->d_diff_stat_file;
	g_object_bind_property_with_closures ((GObject*) renderer, "added", (GObject*) _tmp3_, "added", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp4_ = self->priv->d_diff_stat_file;
	g_object_bind_property_with_closures ((GObject*) renderer, "removed", (GObject*) _tmp4_, "removed", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	gitg_diff_view_file_add_renderer (self, (GitgDiffViewFileRenderer*) renderer, (GtkWidget*) scrolled_window, "text", _ ("Unif"), TRUE);
	_tmp5_ = self->priv->_info;
	_tmp6_ = gitg_diff_view_file_renderer_text_split_new (_tmp5_, handle_selection);
	g_object_ref_sink (_tmp6_);
	renderer_split = _tmp6_;
	gtk_widget_show ((GtkWidget*) renderer_split);
	gitg_diff_view_file_add_renderer (self, (GitgDiffViewFileRenderer*) renderer_split, (GtkWidget*) renderer_split, "splittext", _ ("Split"), TRUE);
	_g_object_unref0 (renderer_split);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (renderer);
}

void
gitg_diff_view_file_add_binary_renderer (GitgDiffViewFile* self)
{
	GitgDiffViewFileRendererBinary* renderer = NULL;
	GitgDiffViewFileRendererBinary* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gitg_diff_view_file_renderer_binary_new ();
	g_object_ref_sink (_tmp0_);
	renderer = _tmp0_;
	gtk_widget_show ((GtkWidget*) renderer);
	gitg_diff_view_file_add_renderer (self, (GitgDiffViewFileRenderer*) renderer, (GtkWidget*) renderer, "binary", _ ("Binary"), FALSE);
	_g_object_unref0 (renderer);
}

void
gitg_diff_view_file_add_image_renderer (GitgDiffViewFile* self)
{
	GitgDiffViewFileRendererImage* renderer = NULL;
	GitgDiffViewFileInfo* _tmp0_;
	GitgRepository* _tmp1_;
	GitgRepository* _tmp2_;
	GitgDiffViewFileInfo* _tmp3_;
	GgitDiffDelta* _tmp4_;
	GgitDiffDelta* _tmp5_;
	GitgDiffViewFileRendererImage* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info;
	_tmp1_ = gitg_diff_view_file_info_get_repository (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_info;
	_tmp4_ = gitg_diff_view_file_info_get_delta (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = gitg_diff_view_file_renderer_image_new (_tmp2_, _tmp5_);
	g_object_ref_sink (_tmp6_);
	renderer = _tmp6_;
	gtk_widget_show ((GtkWidget*) renderer);
	gitg_diff_view_file_add_renderer (self, (GitgDiffViewFileRenderer*) renderer, (GtkWidget*) renderer, "image", _ ("Image"), FALSE);
	_g_object_unref0 (renderer);
}

static gpointer
_ggit_diff_delta_ref0 (gpointer self)
{
	return self ? ggit_diff_delta_ref (self) : NULL;
}

static gpointer
_ggit_diff_file_ref0 (gpointer self)
{
	return self ? ggit_diff_file_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gboolean
_gitg_diff_view_file_expander_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender,
                                                                gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_expander_popup_menu ((GitgDiffViewFile*) self, _sender);
	return result;
}

static gboolean
_gitg_diff_view_file_expander_button_press_event_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                                GdkEventButton* event,
                                                                                gpointer self)
{
	gboolean result;
	result = gitg_diff_view_file_expander_button_press_event ((GitgDiffViewFile*) self, _sender, event);
	return result;
}

static void
gitg_diff_view_file_real_constructed (GObject* base)
{
	GitgDiffViewFile * self;
	GgitDiffDelta* delta = NULL;
	GitgDiffViewFileInfo* _tmp0_;
	GgitDiffDelta* _tmp1_;
	GgitDiffDelta* _tmp2_;
	GgitDiffDelta* _tmp3_;
	GgitDiffFile* oldfile = NULL;
	GgitDiffDelta* _tmp4_;
	GgitDiffFile* _tmp5_;
	GgitDiffFile* _tmp6_;
	GgitDiffFile* newfile = NULL;
	GgitDiffDelta* _tmp7_;
	GgitDiffFile* _tmp8_;
	GgitDiffFile* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GgitDiffFile* _tmp11_;
	gchar* oldpath = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	GgitDiffFile* _tmp16_;
	gchar* newpath = NULL;
	gchar* _tmp19_;
	GgitDiffDelta* _tmp20_;
	GtkExpander* _tmp35_;
	GitgRepository* repository = NULL;
	GitgDiffViewFileInfo* _tmp36_;
	GitgRepository* _tmp37_;
	GitgRepository* _tmp38_;
	GitgRepository* _tmp39_;
	gboolean _tmp40_ = FALSE;
	GitgRepository* _tmp41_;
	self = (GitgDiffViewFile*) base;
	G_OBJECT_CLASS (gitg_diff_view_file_parent_class)->constructed ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_grid_get_type (), GtkGrid));
	_tmp0_ = self->priv->_info;
	_tmp1_ = gitg_diff_view_file_info_get_delta (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _ggit_diff_delta_ref0 (_tmp2_);
	delta = _tmp3_;
	_tmp4_ = delta;
	_tmp5_ = ggit_diff_delta_get_old_file (_tmp4_);
	_tmp6_ = _ggit_diff_file_ref0 (_tmp5_);
	oldfile = _tmp6_;
	_tmp7_ = delta;
	_tmp8_ = ggit_diff_delta_get_new_file (_tmp7_);
	_tmp9_ = _ggit_diff_file_ref0 (_tmp8_);
	newfile = _tmp9_;
	_tmp11_ = oldfile;
	if (_tmp11_ != NULL) {
		GgitDiffFile* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = oldfile;
		_tmp13_ = ggit_diff_file_get_path (_tmp12_);
		_tmp10_ = _tmp13_;
	} else {
		_tmp10_ = NULL;
	}
	_tmp14_ = g_strdup (_tmp10_);
	oldpath = _tmp14_;
	_tmp16_ = newfile;
	if (_tmp16_ != NULL) {
		GgitDiffFile* _tmp17_;
		const gchar* _tmp18_;
		_tmp17_ = newfile;
		_tmp18_ = ggit_diff_file_get_path (_tmp17_);
		_tmp15_ = _tmp18_;
	} else {
		_tmp15_ = NULL;
	}
	_tmp19_ = g_strdup (_tmp15_);
	newpath = _tmp19_;
	_tmp20_ = delta;
	if (ggit_diff_delta_get_similarity (_tmp20_) > ((guint) 0)) {
		GtkLabel* _tmp21_;
		GgitDiffFile* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		GgitDiffFile* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp21_ = self->priv->d_label_file_header;
		_tmp22_ = newfile;
		_tmp23_ = ggit_diff_file_get_path (_tmp22_);
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = oldfile;
		_tmp26_ = ggit_diff_file_get_path (_tmp25_);
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = g_strconcat (_tmp24_, " ← ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		gtk_label_set_label (_tmp21_, _tmp29_);
		_g_free0 (_tmp29_);
	} else {
		const gchar* _tmp30_;
		_tmp30_ = newpath;
		if (_tmp30_ != NULL) {
			GtkLabel* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = self->priv->d_label_file_header;
			_tmp32_ = newpath;
			gtk_label_set_label (_tmp31_, _tmp32_);
		} else {
			GtkLabel* _tmp33_;
			const gchar* _tmp34_;
			_tmp33_ = self->priv->d_label_file_header;
			_tmp34_ = oldpath;
			gtk_label_set_label (_tmp33_, _tmp34_);
		}
	}
	_tmp35_ = self->priv->d_expander;
	g_object_bind_property_with_closures ((GObject*) _tmp35_, "expanded", (GObject*) self, "expanded", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp36_ = self->priv->_info;
	_tmp37_ = gitg_diff_view_file_info_get_repository (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = _g_object_ref0 (_tmp38_);
	repository = _tmp39_;
	_tmp41_ = repository;
	if (_tmp41_ != NULL) {
		GitgRepository* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		_tmp42_ = repository;
		g_object_get ((GgitRepository*) _tmp42_, "is-bare", &_tmp43_, NULL);
		_tmp44_ = _tmp43_;
		_tmp40_ = !_tmp44_;
	} else {
		_tmp40_ = FALSE;
	}
	if (_tmp40_) {
		GtkExpander* _tmp45_;
		GtkExpander* _tmp46_;
		_tmp45_ = self->priv->d_expander;
		g_signal_connect_object ((GtkWidget*) _tmp45_, "popup-menu", (GCallback) _gitg_diff_view_file_expander_popup_menu_gtk_widget_popup_menu, self, 0);
		_tmp46_ = self->priv->d_expander;
		g_signal_connect_object ((GtkWidget*) _tmp46_, "button-press-event", (GCallback) _gitg_diff_view_file_expander_button_press_event_gtk_widget_button_press_event, self, 0);
	}
	_g_object_unref0 (repository);
	_g_free0 (newpath);
	_g_free0 (oldpath);
	_ggit_diff_file_unref0 (newfile);
	_ggit_diff_file_unref0 (oldfile);
	_ggit_diff_delta_unref0 (delta);
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		GitgDiffViewFile* self;
		self = _data10_->self;
		_g_object_unref0 (_data10_->location);
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}

static void
__lambda61_ (Block10Data* _data10_)
{
	GitgDiffViewFile* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	{
		GtkExpander* _tmp0_;
		GtkWidget* _tmp1_;
		GFile* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp0_ = self->priv->d_expander;
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp0_);
		_tmp2_ = _data10_->location;
		_tmp3_ = g_file_get_uri (_tmp2_);
		_tmp4_ = _tmp3_;
		gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp4_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat ("Failed to open file: ", _tmp8_, "\n", NULL);
		_tmp10_ = _tmp9_;
		fprintf (_tmp5_, "%s", _tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda61__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda61_ (self);
}

static void
__lambda62_ (Block10Data* _data10_)
{
	GitgDiffViewFile* self;
	GError* _inner_error0_ = NULL;
	self = _data10_->self;
	{
		GtkExpander* _tmp0_;
		GtkWidget* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp0_ = self->priv->d_expander;
		_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) _tmp0_);
		_tmp2_ = _data10_->location;
		_tmp3_ = g_file_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_uri (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_show_uri_on_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow), _tmp6_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		_g_free0 (_tmp6_);
		_g_object_unref0 (_tmp4_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = stderr;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("Failed to open folder: ", _tmp10_, "\n", NULL);
		_tmp12_ = _tmp11_;
		fprintf (_tmp7_, "%s", _tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda62__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda62_ (self);
}

static void
__lambda63_ (Block10Data* _data10_)
{
	GitgDiffViewFile* self;
	GtkClipboard* clip = NULL;
	GtkExpander* _tmp0_;
	GtkClipboard* _tmp1_;
	GtkClipboard* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = _data10_->self;
	_tmp0_ = self->priv->d_expander;
	_tmp1_ = gtk_widget_get_clipboard ((GtkWidget*) _tmp0_, GDK_SELECTION_CLIPBOARD);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	clip = _tmp2_;
	_tmp3_ = _data10_->location;
	_tmp4_ = g_file_get_path (_tmp3_);
	_tmp5_ = _tmp4_;
	gtk_clipboard_set_text (clip, _tmp5_, -1);
	_g_free0 (_tmp5_);
	_g_object_unref0 (clip);
}

static void
___lambda63__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
	__lambda63_ (self);
}

static void
gitg_diff_view_file_show_popup (GitgDiffViewFile* self,
                                GdkEventButton* event)
{
	Block10Data* _data10_;
	GtkMenu* menu = NULL;
	GtkMenu* _tmp0_;
	GgitDiffDelta* delta = NULL;
	GitgDiffViewFileInfo* _tmp1_;
	GgitDiffDelta* _tmp2_;
	GgitDiffDelta* _tmp3_;
	GgitDiffDelta* _tmp4_;
	gchar* oldpath = NULL;
	GgitDiffDelta* _tmp5_;
	GgitDiffFile* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* newpath = NULL;
	GgitDiffDelta* _tmp9_;
	GgitDiffFile* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GtkMenuItem* open_file = NULL;
	GtkMenuItem* _tmp13_;
	GtkMenuItem* _tmp14_;
	GitgRepository* repository = NULL;
	GitgDiffViewFileInfo* _tmp15_;
	GitgRepository* _tmp16_;
	GitgRepository* _tmp17_;
	GitgRepository* _tmp18_;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	GFile* _tmp35_;
	GtkMenuItem* _tmp36_;
	GtkMenu* _tmp37_;
	GtkMenuItem* _tmp38_;
	GtkMenuItem* open_folder = NULL;
	GtkMenuItem* _tmp39_;
	GtkMenuItem* _tmp40_;
	GtkMenuItem* _tmp41_;
	GtkMenu* _tmp42_;
	GtkMenuItem* _tmp43_;
	GtkSeparatorMenuItem* separator = NULL;
	GtkSeparatorMenuItem* _tmp44_;
	GtkSeparatorMenuItem* _tmp45_;
	GtkMenu* _tmp46_;
	GtkSeparatorMenuItem* _tmp47_;
	GtkMenuItem* copy_file_path = NULL;
	GtkMenuItem* _tmp48_;
	GtkMenuItem* _tmp49_;
	GtkMenuItem* _tmp50_;
	GtkMenu* _tmp51_;
	GtkMenuItem* _tmp52_;
	GtkMenu* _tmp53_;
	GtkExpander* _tmp54_;
	GtkMenu* _tmp55_;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp0_);
	menu = _tmp0_;
	_tmp1_ = self->priv->_info;
	_tmp2_ = gitg_diff_view_file_info_get_delta (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _ggit_diff_delta_ref0 (_tmp3_);
	delta = _tmp4_;
	_tmp5_ = delta;
	_tmp6_ = ggit_diff_delta_get_old_file (_tmp5_);
	_tmp7_ = ggit_diff_file_get_path (_tmp6_);
	_tmp8_ = g_strdup (_tmp7_);
	oldpath = _tmp8_;
	_tmp9_ = delta;
	_tmp10_ = ggit_diff_delta_get_new_file (_tmp9_);
	_tmp11_ = ggit_diff_file_get_path (_tmp10_);
	_tmp12_ = g_strdup (_tmp11_);
	newpath = _tmp12_;
	_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Open file"));
	g_object_ref_sink (_tmp13_);
	open_file = _tmp13_;
	_tmp14_ = open_file;
	gtk_widget_show ((GtkWidget*) _tmp14_);
	_data10_->location = NULL;
	_tmp15_ = self->priv->_info;
	_tmp16_ = gitg_diff_view_file_info_get_repository (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _g_object_ref0 (_tmp17_);
	repository = _tmp18_;
	_tmp20_ = newpath;
	if (_tmp20_ != NULL) {
		const gchar* _tmp21_;
		_tmp21_ = newpath;
		_tmp19_ = g_strcmp0 (_tmp21_, "") != 0;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		GitgRepository* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		const gchar* _tmp25_;
		GFile* _tmp26_;
		_tmp22_ = repository;
		_tmp23_ = ggit_repository_get_workdir ((GgitRepository*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = newpath;
		_tmp26_ = g_file_get_child (_tmp24_, _tmp25_);
		_g_object_unref0 (_data10_->location);
		_data10_->location = _tmp26_;
		_g_object_unref0 (_tmp24_);
	} else {
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		_tmp28_ = oldpath;
		if (_tmp28_ != NULL) {
			const gchar* _tmp29_;
			_tmp29_ = oldpath;
			_tmp27_ = g_strcmp0 (_tmp29_, "") != 0;
		} else {
			_tmp27_ = FALSE;
		}
		if (_tmp27_) {
			GitgRepository* _tmp30_;
			GFile* _tmp31_;
			GFile* _tmp32_;
			const gchar* _tmp33_;
			GFile* _tmp34_;
			_tmp30_ = repository;
			_tmp31_ = ggit_repository_get_workdir ((GgitRepository*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = oldpath;
			_tmp34_ = g_file_get_child (_tmp32_, _tmp33_);
			_g_object_unref0 (_data10_->location);
			_data10_->location = _tmp34_;
			_g_object_unref0 (_tmp32_);
		}
	}
	_tmp35_ = _data10_->location;
	if (_tmp35_ == NULL) {
		_g_object_unref0 (repository);
		_g_object_unref0 (open_file);
		_g_free0 (newpath);
		_g_free0 (oldpath);
		_ggit_diff_delta_unref0 (delta);
		_g_object_unref0 (menu);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp36_ = open_file;
	g_signal_connect_data (_tmp36_, "activate", (GCallback) ___lambda61__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp37_ = menu;
	_tmp38_ = open_file;
	gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
	_tmp39_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("Open containing _folder"));
	g_object_ref_sink (_tmp39_);
	open_folder = _tmp39_;
	_tmp40_ = open_folder;
	gtk_widget_show ((GtkWidget*) _tmp40_);
	_tmp41_ = open_folder;
	g_signal_connect_data (_tmp41_, "activate", (GCallback) ___lambda62__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp42_ = menu;
	_tmp43_ = open_folder;
	gtk_container_add ((GtkContainer*) _tmp42_, (GtkWidget*) _tmp43_);
	_tmp44_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp44_);
	separator = _tmp44_;
	_tmp45_ = separator;
	gtk_widget_show ((GtkWidget*) _tmp45_);
	_tmp46_ = menu;
	_tmp47_ = separator;
	gtk_container_add ((GtkContainer*) _tmp46_, (GtkWidget*) _tmp47_);
	_tmp48_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_ ("_Copy file path"));
	g_object_ref_sink (_tmp48_);
	copy_file_path = _tmp48_;
	_tmp49_ = copy_file_path;
	gtk_widget_show ((GtkWidget*) _tmp49_);
	_tmp50_ = copy_file_path;
	g_signal_connect_data (_tmp50_, "activate", (GCallback) ___lambda63__gtk_menu_item_activate, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
	_tmp51_ = menu;
	_tmp52_ = copy_file_path;
	gtk_container_add ((GtkContainer*) _tmp51_, (GtkWidget*) _tmp52_);
	_tmp53_ = menu;
	_tmp54_ = self->priv->d_expander;
	gtk_menu_attach_to_widget (_tmp53_, (GtkWidget*) _tmp54_, NULL);
	_tmp55_ = menu;
	gtk_menu_popup_at_pointer (_tmp55_, (GdkEvent*) event);
	_g_object_unref0 (copy_file_path);
	_g_object_unref0 (separator);
	_g_object_unref0 (open_folder);
	_g_object_unref0 (repository);
	_g_object_unref0 (open_file);
	_g_free0 (newpath);
	_g_free0 (oldpath);
	_ggit_diff_delta_unref0 (delta);
	_g_object_unref0 (menu);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}

static gboolean
gitg_diff_view_file_expander_button_press_event (GitgDiffViewFile* self,
                                                 GtkWidget* widget,
                                                 GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	if (gdk_event_triggers_context_menu ((GdkEvent*) event)) {
		gitg_diff_view_file_show_popup (self, event);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
gitg_diff_view_file_expander_popup_menu (GitgDiffViewFile* self,
                                         GtkWidget* widget)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	gitg_diff_view_file_show_popup (self, NULL);
	result = TRUE;
	return result;
}

void
gitg_diff_view_file_add_hunk (GitgDiffViewFile* self,
                              GgitDiffHunk* hunk,
                              GeeArrayList* lines)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (hunk != NULL);
	g_return_if_fail (lines != NULL);
	{
		GeeArrayList* _renderer_list = NULL;
		GeeArrayList* _tmp0_;
		gint _renderer_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _renderer_index = 0;
		_tmp0_ = self->priv->_renderer_list;
		_renderer_list = _tmp0_;
		_tmp1_ = _renderer_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_renderer_size = _tmp3_;
		_renderer_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgDiffViewFileRenderer* renderer = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GitgDiffViewFileRenderer* _tmp8_;
			_renderer_index = _renderer_index + 1;
			_tmp4_ = _renderer_index;
			_tmp5_ = _renderer_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _renderer_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _renderer_index);
			renderer = (GitgDiffViewFileRenderer*) _tmp7_;
			_tmp8_ = renderer;
			gitg_diff_view_file_renderer_add_hunk (_tmp8_, hunk, lines);
			_g_object_unref0 (renderer);
		}
	}
}

GeeArrayList*
gitg_diff_view_file_get_renderer_list (GitgDiffViewFile* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_renderer_list;
	result = _tmp0_;
	return result;
}

static void
gitg_diff_view_file_set_renderer_list (GitgDiffViewFile* self,
                                       GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_get_renderer_list (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_renderer_list);
		self->priv->_renderer_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY]);
	}
}

gboolean
gitg_diff_view_file_get_new_is_workdir (GitgDiffViewFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_new_is_workdir;
	return result;
}

void
gitg_diff_view_file_set_new_is_workdir (GitgDiffViewFile* self,
                                        gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_get_new_is_workdir (self);
	if (old_value != value) {
		self->priv->_new_is_workdir = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY]);
	}
}

gboolean
gitg_diff_view_file_get_expanded (GitgDiffViewFile* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->d_expanded;
	return result;
}

void
gitg_diff_view_file_set_expanded (GitgDiffViewFile* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->d_expanded != value) {
		GtkRevealer* _tmp0_;
		gboolean visible = FALSE;
		GtkStackSwitcher* _tmp4_;
		GtkStyleContext* ctx = NULL;
		GtkStyleContext* _tmp5_;
		GtkStyleContext* _tmp6_;
		self->priv->d_expanded = value;
		_tmp0_ = self->priv->d_revealer_content;
		gtk_revealer_set_reveal_child (_tmp0_, self->priv->d_expanded);
		visible = FALSE;
		if (self->priv->d_expanded) {
			GtkStack* _tmp1_;
			GList* _tmp2_;
			GList* _tmp3_;
			_tmp1_ = self->priv->d_stack_file_renderer;
			_tmp2_ = gtk_container_get_children ((GtkContainer*) _tmp1_);
			_tmp3_ = _tmp2_;
			visible = g_list_length (_tmp3_) > ((guint) 1);
			(_tmp3_ == NULL) ? NULL : (_tmp3_ = (g_list_free (_tmp3_), NULL));
		}
		_tmp4_ = self->priv->d_stack_switcher;
		gtk_widget_set_visible ((GtkWidget*) _tmp4_, visible);
		_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp6_ = _g_object_ref0 (_tmp5_);
		ctx = _tmp6_;
		if (self->priv->d_expanded) {
			GtkStyleContext* _tmp7_;
			_tmp7_ = ctx;
			gtk_style_context_add_class (_tmp7_, "expanded");
		} else {
			GtkStyleContext* _tmp8_;
			_tmp8_ = ctx;
			gtk_style_context_remove_class (_tmp8_, "expanded");
		}
		_g_object_unref0 (ctx);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY]);
}

GitgDiffViewFileInfo*
gitg_diff_view_file_get_info (GitgDiffViewFile* self)
{
	GitgDiffViewFileInfo* result;
	GitgDiffViewFileInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_info;
	result = _tmp0_;
	return result;
}

void
gitg_diff_view_file_set_info (GitgDiffViewFile* self,
                              GitgDiffViewFileInfo* value)
{
	GitgDiffViewFileInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_file_get_info (self);
	if (old_value != value) {
		GitgDiffViewFileInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_info);
		self->priv->_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_INFO_PROPERTY]);
	}
}

static void
gitg_diff_view_file_class_init (GitgDiffViewFileClass * klass,
                                gpointer klass_data)
{
	gitg_diff_view_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewFile_private_offset);
	((GObjectClass *) klass)->constructed = (void (*) (GObject*)) gitg_diff_view_file_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_file_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_file_set_property;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_file_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY] = g_param_spec_object ("renderer-list", "renderer-list", "renderer-list", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY] = g_param_spec_boolean ("new-is-workdir", "new-is-workdir", "new-is-workdir", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_FILE_INFO_PROPERTY, gitg_diff_view_file_properties[GITG_DIFF_VIEW_FILE_INFO_PROPERTY] = g_param_spec_object ("info", "info", "info", GITG_TYPE_DIFF_VIEW_FILE_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/gitg/ui/gitg-diff-view-file.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "expander", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_expander));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label_file_header", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_label_file_header));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "diff_stat_file", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_diff_stat_file));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "revealer_content", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_revealer_content));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_switcher", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_stack_switcher));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_file_renderer", FALSE, GitgDiffViewFile_private_offset + G_STRUCT_OFFSET (GitgDiffViewFilePrivate, d_stack_file_renderer));
}

static void
gitg_diff_view_file_instance_init (GitgDiffViewFile * self,
                                   gpointer klass)
{
	GeeHashMap* _tmp0_;
	self->priv = gitg_diff_view_file_get_instance_private (self);
	_tmp0_ = gee_hash_map_new (gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->d_diff_stat_visible_map = _tmp0_;
	g_type_ensure (GITG_TYPE_DIFF_STAT);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
gitg_diff_view_file_finalize (GObject * obj)
{
	GitgDiffViewFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile);
	_g_object_unref0 (self->priv->_renderer_list);
	_g_object_unref0 (self->priv->_info);
	_g_object_unref0 (self->priv->d_diff_stat_visible_map);
	G_OBJECT_CLASS (gitg_diff_view_file_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewFile), 0, (GInstanceInitFunc) gitg_diff_view_file_instance_init, NULL };
	GType gitg_diff_view_file_type_id;
	gitg_diff_view_file_type_id = g_type_register_static (gtk_grid_get_type (), "GitgDiffViewFile", &g_define_type_info, 0);
	GitgDiffViewFile_private_offset = g_type_add_instance_private (gitg_diff_view_file_type_id, sizeof (GitgDiffViewFilePrivate));
	return gitg_diff_view_file_type_id;
}

GType
gitg_diff_view_file_get_type (void)
{
	static gsize gitg_diff_view_file_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_file_type_id__once)) {
		GType gitg_diff_view_file_type_id;
		gitg_diff_view_file_type_id = gitg_diff_view_file_get_type_once ();
		g_once_init_leave (&gitg_diff_view_file_type_id__once, gitg_diff_view_file_type_id);
	}
	return gitg_diff_view_file_type_id__once;
}

static void
_vala_gitg_diff_view_file_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	GitgDiffViewFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY:
		g_value_set_object (value, gitg_diff_view_file_get_renderer_list (self));
		break;
		case GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_file_get_new_is_workdir (self));
		break;
		case GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY:
		g_value_set_boolean (value, gitg_diff_view_file_get_expanded (self));
		break;
		case GITG_DIFF_VIEW_FILE_INFO_PROPERTY:
		g_value_set_object (value, gitg_diff_view_file_get_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_file_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	GitgDiffViewFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_FILE, GitgDiffViewFile);
	switch (property_id) {
		case GITG_DIFF_VIEW_FILE_RENDERER_LIST_PROPERTY:
		gitg_diff_view_file_set_renderer_list (self, g_value_get_object (value));
		break;
		case GITG_DIFF_VIEW_FILE_NEW_IS_WORKDIR_PROPERTY:
		gitg_diff_view_file_set_new_is_workdir (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_FILE_EXPANDED_PROPERTY:
		gitg_diff_view_file_set_expanded (self, g_value_get_boolean (value));
		break;
		case GITG_DIFF_VIEW_FILE_INFO_PROPERTY:
		gitg_diff_view_file_set_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

