/* dreamcast-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dreamcast-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-dreamcast-plugin.h"

#define GAMES_DREAMCAST_PLUGIN_GDI_MIME_TYPE "application/x-gd-rom-cue"
#define GAMES_DREAMCAST_PLUGIN_CDI_MIME_TYPE "application/x-discjuggler-cd-image"
#define GAMES_DREAMCAST_PLUGIN_DREAMCAST_MIME_TYPE "application/x-dreamcast-rom"
#define GAMES_DREAMCAST_PLUGIN_PLATFORM_ID "Dreamcast"
#define GAMES_DREAMCAST_PLUGIN_PLATFORM_NAME _ ("Dreamcast")
#define GAMES_DREAMCAST_PLUGIN_PLATFORM_UID_PREFIX "dreamcast"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_DREAMCAST_PLUGIN (games_dreamcast_plugin_get_type ())
#define GAMES_DREAMCAST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DREAMCAST_PLUGIN, GamesDreamcastPlugin))
#define GAMES_DREAMCAST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DREAMCAST_PLUGIN, GamesDreamcastPluginClass))
#define GAMES_IS_DREAMCAST_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DREAMCAST_PLUGIN))
#define GAMES_IS_DREAMCAST_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DREAMCAST_PLUGIN))
#define GAMES_DREAMCAST_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DREAMCAST_PLUGIN, GamesDreamcastPluginClass))

typedef struct _GamesDreamcastPlugin GamesDreamcastPlugin;
typedef struct _GamesDreamcastPluginClass GamesDreamcastPluginClass;
typedef struct _GamesDreamcastPluginPrivate GamesDreamcastPluginPrivate;
enum  {
	GAMES_DREAMCAST_PLUGIN_0_PROPERTY,
	GAMES_DREAMCAST_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_dreamcast_plugin_properties[GAMES_DREAMCAST_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_DREAMCAST_HEADER (games_dreamcast_header_get_type ())
#define GAMES_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeader))
#define GAMES_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))
#define GAMES_IS_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_IS_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_DREAMCAST_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))

typedef struct _GamesDreamcastHeader GamesDreamcastHeader;
typedef struct _GamesDreamcastHeaderClass GamesDreamcastHeaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_DREAMCAST_ERROR (games_dreamcast_error_get_type ())

struct _GamesDreamcastPlugin {
	GObject parent_instance;
	GamesDreamcastPluginPrivate * priv;
};

struct _GamesDreamcastPluginClass {
	GObjectClass parent_class;
};

typedef enum  {
	GAMES_DREAMCAST_ERROR_INVALID_GDI,
	GAMES_DREAMCAST_ERROR_INVALID_FILE_TYPE,
	GAMES_DREAMCAST_ERROR_INVALID_HEADER
} GamesDreamcastError;
#define GAMES_DREAMCAST_ERROR games_dreamcast_error_quark ()

static gpointer games_dreamcast_plugin_parent_class = NULL;
static GamesRetroPlatform* games_dreamcast_plugin_platform;
static GamesRetroPlatform* games_dreamcast_plugin_platform = NULL;
static GamesPluginIface * games_dreamcast_plugin_games_plugin_parent_iface = NULL;
static GType games_dreamcast_plugin_type_id = 0;

GType games_dreamcast_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_dreamcast_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_dreamcast_plugin_real_get_platforms (GamesPlugin* base,
                                                           gint* result_length1);
static gchar** games_dreamcast_plugin_real_get_mime_types (GamesPlugin* base,
                                                    gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static GamesUriGameFactory** games_dreamcast_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                          gint* result_length1);
static GamesGame* games_dreamcast_plugin_game_for_uri (GamesUri* uri,
                                                GError** error);
static GamesGame* _games_dreamcast_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                             gpointer self,
                                                                                             GError** error);
static GamesRunnerFactory** games_dreamcast_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                       gint* result_length1);
GType games_dreamcast_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_dreamcast_header_get_type (void) G_GNUC_CONST ;
static gchar* games_dreamcast_plugin_get_uid (GamesDreamcastHeader* header,
                                       GError** error);
VALA_EXTERN gchar* games_dreamcast_header_get_product_number (GamesDreamcastHeader* self,
                                                  GError** error);
VALA_EXTERN gchar* games_dreamcast_header_get_areas (GamesDreamcastHeader* self,
                                         GError** error);
static GFile* games_dreamcast_plugin_get_binary_file (GamesGdi* gdi,
                                               GError** error);
VALA_EXTERN GQuark games_dreamcast_error_quark (void);
VALA_EXTERN GType games_dreamcast_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDreamcastHeader* games_dreamcast_header_new (GFile* file);
VALA_EXTERN GamesDreamcastHeader* games_dreamcast_header_construct (GType object_type,
                                                        GFile* file);
VALA_EXTERN void games_dreamcast_header_check_validity (GamesDreamcastHeader* self,
                                            GError** error);
VALA_EXTERN GamesDreamcastPlugin* games_dreamcast_plugin_new (void);
VALA_EXTERN GamesDreamcastPlugin* games_dreamcast_plugin_construct (GType object_type);
static void games_dreamcast_plugin_finalize (GObject * obj);
GType games_dreamcast_header_register_type (GTypeModule * module);
GType games_gdi_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* GAMES_DREAMCAST_PLUGIN_MIME_TYPES[2] = {GAMES_DREAMCAST_PLUGIN_GDI_MIME_TYPE, GAMES_DREAMCAST_PLUGIN_CDI_MIME_TYPE};

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_dreamcast_plugin_real_get_platforms (GamesPlugin* base,
                                           gint* result_length1)
{
	GamesDreamcastPlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesDreamcastPlugin*) base;
	_tmp0_ = games_dreamcast_plugin_platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static gchar**
games_dreamcast_plugin_real_get_mime_types (GamesPlugin* base,
                                            gint* result_length1)
{
	GamesDreamcastPlugin * self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** result;
	self = (GamesDreamcastPlugin*) base;
	_tmp0_ = _vala_array_dup1 (GAMES_DREAMCAST_PLUGIN_MIME_TYPES, G_N_ELEMENTS (GAMES_DREAMCAST_PLUGIN_MIME_TYPES));
	_tmp0__length1 = G_N_ELEMENTS (GAMES_DREAMCAST_PLUGIN_MIME_TYPES);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}

static GamesGame*
_games_dreamcast_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                  gpointer self,
                                                                                  GError** error)
{
	GamesGame* result;
	result = games_dreamcast_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_dreamcast_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                    gint* result_length1)
{
	GamesDreamcastPlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericGameUriAdapter* _tmp1_;
	GamesGenericUriGameFactory* _tmp2_;
	GamesGenericUriGameFactory* _tmp5_;
	GamesUriGameFactory* _tmp6_;
	GamesUriGameFactory** _tmp7_;
	GamesUriGameFactory** _tmp8_;
	gint _tmp8__length1;
	GamesUriGameFactory** result;
	self = (GamesDreamcastPlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_dreamcast_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = game_uri_adapter;
	_tmp2_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) _tmp1_);
	factory = _tmp2_;
	{
		const gchar** mime_type_collection = NULL;
		gint mime_type_collection_length1 = 0;
		gint _mime_type_collection_size_ = 0;
		gint mime_type_it = 0;
		mime_type_collection = GAMES_DREAMCAST_PLUGIN_MIME_TYPES;
		mime_type_collection_length1 = G_N_ELEMENTS (GAMES_DREAMCAST_PLUGIN_MIME_TYPES);
		for (mime_type_it = 0; mime_type_it < mime_type_collection_length1; mime_type_it = mime_type_it + 1) {
			const gchar* mime_type = NULL;
			mime_type = mime_type_collection[mime_type_it];
			{
				GamesGenericUriGameFactory* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = factory;
				_tmp4_ = mime_type;
				games_generic_uri_game_factory_add_mime_type (_tmp3_, _tmp4_);
			}
		}
	}
	_tmp5_ = factory;
	_tmp6_ = _g_object_ref0 ((GamesUriGameFactory*) _tmp5_);
	_tmp7_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp8__length1;
	}
	result = _tmp8_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_dreamcast_plugin_real_get_runner_factories (GamesPlugin* base,
                                                  gint* result_length1)
{
	GamesDreamcastPlugin * self;
	GamesRetroRunnerFactory* factory = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesDreamcastPlugin*) base;
	_tmp0_ = games_dreamcast_plugin_platform;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_dreamcast_plugin_get_uid (GamesDreamcastHeader* header,
                                GError** error)
{
	gchar* product_number = NULL;
	gchar* _tmp0_;
	gchar* areas = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (header != NULL, NULL);
	_tmp0_ = games_dreamcast_header_get_product_number (header, &_inner_error0_);
	product_number = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = games_dreamcast_header_get_areas (header, &_inner_error0_);
	areas = _tmp1_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (product_number);
		return NULL;
	}
	_tmp2_ = string_to_string (GAMES_DREAMCAST_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp3_ = product_number;
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = areas;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat (_tmp2_, "-", _tmp4_, "-", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_utf8_strdown (_tmp8_, (gssize) -1);
	_tmp10_ = _tmp9_;
	_g_free0 (_tmp8_);
	result = _tmp10_;
	_g_free0 (areas);
	_g_free0 (product_number);
	return result;
}

static GamesGame*
games_dreamcast_plugin_game_for_uri (GamesUri* uri,
                                     GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFileInfo* file_info = NULL;
	GFile* _tmp1_;
	GFileInfo* _tmp2_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GFile* bin_file = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	GQuark _tmp9_ = 0U;
	static GQuark _tmp8_label0 = 0;
	static GQuark _tmp8_label1 = 0;
	GamesDreamcastHeader* header = NULL;
	GFile* _tmp24_;
	GamesDreamcastHeader* _tmp25_;
	GamesDreamcastHeader* _tmp26_;
	gchar* _tmp27_ = NULL;
	GamesDreamcastHeader* _tmp28_;
	gchar* _tmp29_;
	GamesUid* uid = NULL;
	GamesUid* _tmp30_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp31_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp32_;
	GamesGriloMedia* _tmp33_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp34_;
	GamesGriloMedia* _tmp35_;
	GamesUid* _tmp36_;
	GamesGriloCover* _tmp37_;
	GamesCover** _tmp38_;
	GamesCover** _tmp39_;
	gint _tmp39__length1;
	GamesCompositeCover* _tmp40_;
	GamesCompositeCover* _tmp41_;
	GamesGame* game = NULL;
	GamesUid* _tmp42_;
	GamesFilenameTitle* _tmp43_;
	GamesRetroPlatform* _tmp44_;
	GamesGame* _tmp45_;
	GamesGame* _tmp46_;
	GamesCompositeCover* _tmp47_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp3_ = file_info;
	_tmp4_ = g_file_info_get_content_type (_tmp3_);
	_tmp5_ = g_strdup (_tmp4_);
	mime_type = _tmp5_;
	_tmp6_ = mime_type;
	_tmp7_ = _tmp6_;
	_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
	if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string (GAMES_DREAMCAST_PLUGIN_GDI_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GamesGdi* gdi = NULL;
				GFile* _tmp10_;
				GamesGdi* _tmp11_;
				GamesGdi* _tmp12_;
				GFile* _tmp13_ = NULL;
				GamesGdi* _tmp14_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				_tmp10_ = file;
				_tmp11_ = games_gdi_new (_tmp10_);
				gdi = _tmp11_;
				_tmp12_ = gdi;
				games_gdi_parse (_tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (gdi);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp14_ = gdi;
				_tmp15_ = games_dreamcast_plugin_get_binary_file (_tmp14_, &_inner_error0_);
				_tmp13_ = _tmp15_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_object_unref0 (gdi);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return NULL;
				}
				_tmp16_ = _tmp13_;
				_tmp13_ = NULL;
				_g_object_unref0 (bin_file);
				bin_file = _tmp16_;
				_g_object_unref0 (_tmp13_);
				_g_object_unref0 (gdi);
				break;
			}
		}
	} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string (GAMES_DREAMCAST_PLUGIN_CDI_MIME_TYPE)))) {
		switch (0) {
			default:
			{
				GFile* _tmp17_;
				GFile* _tmp18_;
				_tmp17_ = file;
				_tmp18_ = _g_object_ref0 (_tmp17_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp18_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				GError* _tmp22_;
				GError* _tmp23_;
				_tmp19_ = mime_type;
				_tmp20_ = games_uri_to_string (uri);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_error_new (GAMES_DREAMCAST_ERROR, GAMES_DREAMCAST_ERROR_INVALID_FILE_TYPE, "Invalid file type: expected %s or %s but got %s for file %s.", GAMES_DREAMCAST_PLUGIN_GDI_MIME_TYPE, GAMES_DREAMCAST_PLUGIN_CDI_MIME_TYPE, _tmp19_, _tmp21_);
				_tmp23_ = _tmp22_;
				_g_free0 (_tmp21_);
				_inner_error0_ = _tmp23_;
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return NULL;
			}
		}
	}
	_tmp24_ = bin_file;
	_tmp25_ = games_dreamcast_header_new (_tmp24_);
	header = _tmp25_;
	_tmp26_ = header;
	games_dreamcast_header_check_validity (_tmp26_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp28_ = header;
	_tmp29_ = games_dreamcast_plugin_get_uid (_tmp28_, &_inner_error0_);
	_tmp27_ = _tmp29_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp30_ = games_uid_new (_tmp27_);
	uid = _tmp30_;
	_tmp31_ = games_filename_title_new (uri);
	title = _tmp31_;
	_tmp32_ = title;
	_tmp33_ = games_grilo_media_new ((GamesTitle*) _tmp32_, GAMES_DREAMCAST_PLUGIN_DREAMCAST_MIME_TYPE);
	media = _tmp33_;
	_tmp34_ = games_local_cover_new (uri);
	_tmp35_ = media;
	_tmp36_ = uid;
	_tmp37_ = games_grilo_cover_new (_tmp35_, _tmp36_);
	_tmp38_ = g_new0 (GamesCover*, 2 + 1);
	_tmp38_[0] = (GamesCover*) _tmp34_;
	_tmp38_[1] = (GamesCover*) _tmp37_;
	_tmp39_ = _tmp38_;
	_tmp39__length1 = 2;
	_tmp40_ = games_composite_cover_new (_tmp39_, 2);
	_tmp41_ = _tmp40_;
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp41_;
	_tmp42_ = uid;
	_tmp43_ = title;
	_tmp44_ = games_dreamcast_plugin_platform;
	_tmp45_ = games_game_new (_tmp42_, uri, (GamesTitle*) _tmp43_, (GamesPlatform*) _tmp44_);
	game = _tmp45_;
	_tmp46_ = game;
	_tmp47_ = cover;
	games_game_set_cover (_tmp46_, (GamesCover*) _tmp47_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp27_);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
	return result;
}

static GFile*
games_dreamcast_plugin_get_binary_file (GamesGdi* gdi,
                                        GError** error)
{
	guint _tmp0_;
	guint _tmp1_;
	GamesGdiTrackNode track = {0};
	GamesGdiTrackNode _tmp8_ = {0};
	GFile* file = NULL;
	GamesGdiTrackNode _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GFileInfo* file_info = NULL;
	GFile* _tmp12_;
	GFileInfo* _tmp13_;
	GFileInfo* _tmp14_;
	const gchar* _tmp15_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	g_return_val_if_fail (gdi != NULL, NULL);
	_tmp0_ = games_gdi_get_tracks_number (gdi);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == ((guint) 0)) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp2_ = games_gdi_get_file (gdi);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new (GAMES_DREAMCAST_ERROR, GAMES_DREAMCAST_ERROR_INVALID_GDI, "The file “%s” doesn’t have a track.", _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error0_ = _tmp7_;
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	games_gdi_get_track (gdi, (guint) 0, &_tmp8_, &_inner_error0_);
	track = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = track;
	_tmp10_ = _tmp9_.file;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	file = _tmp11_;
	_tmp12_ = file;
	_tmp13_ = g_file_query_info (_tmp12_, "*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
	file_info = _tmp13_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file);
		games_gdi_track_node_destroy (&track);
		return NULL;
	}
	_tmp14_ = file_info;
	_tmp15_ = g_file_info_get_content_type (_tmp14_);
	if (g_strcmp0 (_tmp15_, GAMES_DREAMCAST_PLUGIN_DREAMCAST_MIME_TYPE) != 0) {
		GFile* _tmp16_;
		GFile* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GError* _tmp20_;
		GError* _tmp21_;
		_tmp16_ = games_gdi_get_file (gdi);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_file_get_uri (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_error_new (GAMES_DREAMCAST_ERROR, GAMES_DREAMCAST_ERROR_INVALID_FILE_TYPE, "The file “%s” doesn’t have a valid Dreamcast binary file.", _tmp19_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp19_);
		_inner_error0_ = _tmp21_;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		games_gdi_track_node_destroy (&track);
		return NULL;
	}
	result = file;
	_g_object_unref0 (file_info);
	games_gdi_track_node_destroy (&track);
	return result;
}

GamesDreamcastPlugin*
games_dreamcast_plugin_construct (GType object_type)
{
	GamesDreamcastPlugin * self = NULL;
	self = (GamesDreamcastPlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesDreamcastPlugin*
games_dreamcast_plugin_new (void)
{
	return games_dreamcast_plugin_construct (GAMES_TYPE_DREAMCAST_PLUGIN);
}

static void
games_dreamcast_plugin_class_init (GamesDreamcastPluginClass * klass,
                                   gpointer klass_data)
{
	GamesRetroPlatform* _tmp0_;
	games_dreamcast_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_dreamcast_plugin_finalize;
	_tmp0_ = games_retro_platform_new (GAMES_DREAMCAST_PLUGIN_PLATFORM_ID, GAMES_DREAMCAST_PLUGIN_PLATFORM_NAME, GAMES_DREAMCAST_PLUGIN_MIME_TYPES, G_N_ELEMENTS (GAMES_DREAMCAST_PLUGIN_MIME_TYPES), GAMES_DREAMCAST_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_dreamcast_plugin_platform);
	games_dreamcast_plugin_platform = _tmp0_;
}

static void
games_dreamcast_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                    gpointer iface_data)
{
	games_dreamcast_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_dreamcast_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_dreamcast_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_dreamcast_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_dreamcast_plugin_real_get_runner_factories;
}

static void
games_dreamcast_plugin_instance_init (GamesDreamcastPlugin * self,
                                      gpointer klass)
{
}

static void
games_dreamcast_plugin_finalize (GObject * obj)
{
	GamesDreamcastPlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DREAMCAST_PLUGIN, GamesDreamcastPlugin);
	G_OBJECT_CLASS (games_dreamcast_plugin_parent_class)->finalize (obj);
}

GType
games_dreamcast_plugin_get_type (void)
{
	return games_dreamcast_plugin_type_id;
}

GType
games_dreamcast_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesDreamcastPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_dreamcast_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDreamcastPlugin), 0, (GInstanceInitFunc) games_dreamcast_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_dreamcast_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_dreamcast_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDreamcastPlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_dreamcast_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_dreamcast_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_dreamcast_header_register_type (module);
	games_dreamcast_plugin_register_type (module);
	games_gdi_register_type (module);
	result = GAMES_TYPE_DREAMCAST_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

