{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Generated when the window visibility status has changed.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.EventVisibility
    ( 

-- * Exported types
    EventVisibility(..)                     ,
    newZeroEventVisibility                  ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveEventVisibilityMethod            ,
#endif



 -- * Properties


-- ** sendEvent #attr:sendEvent#
-- | 'P.True' if the event was sent explicitly.

#if defined(ENABLE_OVERLOADING)
    eventVisibility_sendEvent               ,
#endif
    getEventVisibilitySendEvent             ,
    setEventVisibilitySendEvent             ,


-- ** state #attr:state#
-- | the new visibility state ('GI.Gdk.Enums.VisibilityStateFullyObscured',
--   'GI.Gdk.Enums.VisibilityStatePartial' or 'GI.Gdk.Enums.VisibilityStateUnobscured').

#if defined(ENABLE_OVERLOADING)
    eventVisibility_state                   ,
#endif
    getEventVisibilityState                 ,
    setEventVisibilityState                 ,


-- ** type #attr:type#
-- | the type of the event ('GI.Gdk.Enums.EventTypeVisibilityNotify').

#if defined(ENABLE_OVERLOADING)
    eventVisibility_type                    ,
#endif
    getEventVisibilityType                  ,
    setEventVisibilityType                  ,


-- ** window #attr:window#
-- | the window which received the event.

    clearEventVisibilityWindow              ,
#if defined(ENABLE_OVERLOADING)
    eventVisibility_window                  ,
#endif
    getEventVisibilityWindow                ,
    setEventVisibilityWindow                ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.Cairo.Structs.Pattern as Cairo.Pattern
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceManager as Gdk.DeviceManager
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.DragContext as Gdk.DragContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawingContext as Gdk.DrawingContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Screen as Gdk.Screen
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Visual as Gdk.Visual
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window
import {-# SOURCE #-} qualified GI.Gdk.Structs.Atom as Gdk.Atom
import {-# SOURCE #-} qualified GI.Gdk.Structs.Color as Gdk.Color
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventAny as Gdk.EventAny
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventButton as Gdk.EventButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventConfigure as Gdk.EventConfigure
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventCrossing as Gdk.EventCrossing
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventDND as Gdk.EventDND
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventExpose as Gdk.EventExpose
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventFocus as Gdk.EventFocus
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventGrabBroken as Gdk.EventGrabBroken
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventKey as Gdk.EventKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventMotion as Gdk.EventMotion
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventOwnerChange as Gdk.EventOwnerChange
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadAxis as Gdk.EventPadAxis
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadButton as Gdk.EventPadButton
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventPadGroupMode as Gdk.EventPadGroupMode
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProperty as Gdk.EventProperty
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventProximity as Gdk.EventProximity
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventScroll as Gdk.EventScroll
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSelection as Gdk.EventSelection
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSetting as Gdk.EventSetting
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouch as Gdk.EventTouch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadPinch as Gdk.EventTouchpadPinch
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventTouchpadSwipe as Gdk.EventTouchpadSwipe
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventWindowState as Gdk.EventWindowState
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.Geometry as Gdk.Geometry
import {-# SOURCE #-} qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.WindowAttr as Gdk.WindowAttr
import {-# SOURCE #-} qualified GI.Gdk.Unions.Event as Gdk.Event
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext

#else
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.Window as Gdk.Window

#endif

-- | Memory-managed wrapper type.
newtype EventVisibility = EventVisibility (SP.ManagedPtr EventVisibility)
    deriving (Eq)

instance SP.ManagedPtrNewtype EventVisibility where
    toManagedPtr (EventVisibility p) = p

instance BoxedPtr EventVisibility where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 24 >=> B.ManagedPtr.wrapPtr EventVisibility)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr EventVisibility where
    boxedPtrCalloc = callocBytes 24


-- | Construct a t'EventVisibility' struct initialized to zero.
newZeroEventVisibility :: MonadIO m => m EventVisibility
newZeroEventVisibility = liftIO $ boxedPtrCalloc >>= wrapPtr EventVisibility

instance tag ~ 'AttrSet => Constructible EventVisibility tag where
    new _ attrs = do
        o <- newZeroEventVisibility
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventVisibility #type
-- @
getEventVisibilityType :: MonadIO m => EventVisibility -> m Gdk.Enums.EventType
getEventVisibilityType s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@type@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventVisibility [ #type 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventVisibilityType :: MonadIO m => EventVisibility -> Gdk.Enums.EventType -> m ()
setEventVisibilityType s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 0) (val' :: CInt)

#if defined(ENABLE_OVERLOADING)
data EventVisibilityTypeFieldInfo
instance AttrInfo EventVisibilityTypeFieldInfo where
    type AttrBaseTypeConstraint EventVisibilityTypeFieldInfo = (~) EventVisibility
    type AttrAllowedOps EventVisibilityTypeFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventVisibilityTypeFieldInfo = (~) Gdk.Enums.EventType
    type AttrTransferTypeConstraint EventVisibilityTypeFieldInfo = (~)Gdk.Enums.EventType
    type AttrTransferType EventVisibilityTypeFieldInfo = Gdk.Enums.EventType
    type AttrGetType EventVisibilityTypeFieldInfo = Gdk.Enums.EventType
    type AttrLabel EventVisibilityTypeFieldInfo = "type"
    type AttrOrigin EventVisibilityTypeFieldInfo = EventVisibility
    attrGet = getEventVisibilityType
    attrSet = setEventVisibilityType
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventVisibility.type"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventVisibility.html#g:attr:type"
        })

eventVisibility_type :: AttrLabelProxy "type"
eventVisibility_type = AttrLabelProxy

#endif


-- | Get the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventVisibility #window
-- @
getEventVisibilityWindow :: MonadIO m => EventVisibility -> m (Maybe Gdk.Window.Window)
getEventVisibilityWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO (Ptr Gdk.Window.Window)
    result <- SP.convertIfNonNull val $ \val' -> do
        val'' <- (newObject Gdk.Window.Window) val'
        return val''
    return result

-- | Set the value of the “@window@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventVisibility [ #window 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventVisibilityWindow :: MonadIO m => EventVisibility -> Ptr Gdk.Window.Window -> m ()
setEventVisibilityWindow s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Ptr Gdk.Window.Window)

-- | Set the value of the “@window@” field to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #window
-- @
clearEventVisibilityWindow :: MonadIO m => EventVisibility -> m ()
clearEventVisibilityWindow s = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (FP.nullPtr :: Ptr Gdk.Window.Window)

#if defined(ENABLE_OVERLOADING)
data EventVisibilityWindowFieldInfo
instance AttrInfo EventVisibilityWindowFieldInfo where
    type AttrBaseTypeConstraint EventVisibilityWindowFieldInfo = (~) EventVisibility
    type AttrAllowedOps EventVisibilityWindowFieldInfo = '[ 'AttrSet, 'AttrGet, 'AttrClear]
    type AttrSetTypeConstraint EventVisibilityWindowFieldInfo = (~) (Ptr Gdk.Window.Window)
    type AttrTransferTypeConstraint EventVisibilityWindowFieldInfo = (~)(Ptr Gdk.Window.Window)
    type AttrTransferType EventVisibilityWindowFieldInfo = (Ptr Gdk.Window.Window)
    type AttrGetType EventVisibilityWindowFieldInfo = Maybe Gdk.Window.Window
    type AttrLabel EventVisibilityWindowFieldInfo = "window"
    type AttrOrigin EventVisibilityWindowFieldInfo = EventVisibility
    attrGet = getEventVisibilityWindow
    attrSet = setEventVisibilityWindow
    attrConstruct = undefined
    attrClear = clearEventVisibilityWindow
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventVisibility.window"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventVisibility.html#g:attr:window"
        })

eventVisibility_window :: AttrLabelProxy "window"
eventVisibility_window = AttrLabelProxy

#endif


-- | Get the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventVisibility #sendEvent
-- @
getEventVisibilitySendEvent :: MonadIO m => EventVisibility -> m Int8
getEventVisibilitySendEvent s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO Int8
    return val

-- | Set the value of the “@send_event@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventVisibility [ #sendEvent 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventVisibilitySendEvent :: MonadIO m => EventVisibility -> Int8 -> m ()
setEventVisibilitySendEvent s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 16) (val :: Int8)

#if defined(ENABLE_OVERLOADING)
data EventVisibilitySendEventFieldInfo
instance AttrInfo EventVisibilitySendEventFieldInfo where
    type AttrBaseTypeConstraint EventVisibilitySendEventFieldInfo = (~) EventVisibility
    type AttrAllowedOps EventVisibilitySendEventFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventVisibilitySendEventFieldInfo = (~) Int8
    type AttrTransferTypeConstraint EventVisibilitySendEventFieldInfo = (~)Int8
    type AttrTransferType EventVisibilitySendEventFieldInfo = Int8
    type AttrGetType EventVisibilitySendEventFieldInfo = Int8
    type AttrLabel EventVisibilitySendEventFieldInfo = "send_event"
    type AttrOrigin EventVisibilitySendEventFieldInfo = EventVisibility
    attrGet = getEventVisibilitySendEvent
    attrSet = setEventVisibilitySendEvent
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventVisibility.sendEvent"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventVisibility.html#g:attr:sendEvent"
        })

eventVisibility_sendEvent :: AttrLabelProxy "sendEvent"
eventVisibility_sendEvent = AttrLabelProxy

#endif


-- | Get the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' eventVisibility #state
-- @
getEventVisibilityState :: MonadIO m => EventVisibility -> m Gdk.Enums.VisibilityState
getEventVisibilityState s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 20) :: IO CUInt
    let val' = (toEnum . fromIntegral) val
    return val'

-- | Set the value of the “@state@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' eventVisibility [ #state 'Data.GI.Base.Attributes.:=' value ]
-- @
setEventVisibilityState :: MonadIO m => EventVisibility -> Gdk.Enums.VisibilityState -> m ()
setEventVisibilityState s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = (fromIntegral . fromEnum) val
    poke (ptr `plusPtr` 20) (val' :: CUInt)

#if defined(ENABLE_OVERLOADING)
data EventVisibilityStateFieldInfo
instance AttrInfo EventVisibilityStateFieldInfo where
    type AttrBaseTypeConstraint EventVisibilityStateFieldInfo = (~) EventVisibility
    type AttrAllowedOps EventVisibilityStateFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint EventVisibilityStateFieldInfo = (~) Gdk.Enums.VisibilityState
    type AttrTransferTypeConstraint EventVisibilityStateFieldInfo = (~)Gdk.Enums.VisibilityState
    type AttrTransferType EventVisibilityStateFieldInfo = Gdk.Enums.VisibilityState
    type AttrGetType EventVisibilityStateFieldInfo = Gdk.Enums.VisibilityState
    type AttrLabel EventVisibilityStateFieldInfo = "state"
    type AttrOrigin EventVisibilityStateFieldInfo = EventVisibility
    attrGet = getEventVisibilityState
    attrSet = setEventVisibilityState
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.EventVisibility.state"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-EventVisibility.html#g:attr:state"
        })

eventVisibility_state :: AttrLabelProxy "state"
eventVisibility_state = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList EventVisibility
type instance O.AttributeList EventVisibility = EventVisibilityAttributeList
type EventVisibilityAttributeList = ('[ '("type", EventVisibilityTypeFieldInfo), '("window", EventVisibilityWindowFieldInfo), '("sendEvent", EventVisibilitySendEventFieldInfo), '("state", EventVisibilityStateFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveEventVisibilityMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveEventVisibilityMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveEventVisibilityMethod t EventVisibility, O.OverloadedMethod info EventVisibility p) => OL.IsLabel t (EventVisibility -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveEventVisibilityMethod t EventVisibility, O.OverloadedMethod info EventVisibility p, R.HasField t EventVisibility p) => R.HasField t EventVisibility p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveEventVisibilityMethod t EventVisibility, O.OverloadedMethodInfo info EventVisibility) => OL.IsLabel t (O.MethodProxy info EventVisibility) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


