{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Defines the x and y coordinates of a point.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.Point
    ( 

-- * Exported types
    Point(..)                               ,
    newZeroPoint                            ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolvePointMethod                      ,
#endif



 -- * Properties


-- ** x #attr:x#
-- | the x coordinate of the point.

    getPointX                               ,
#if defined(ENABLE_OVERLOADING)
    point_x                                 ,
#endif
    setPointX                               ,


-- ** y #attr:y#
-- | the y coordinate of the point.

    getPointY                               ,
#if defined(ENABLE_OVERLOADING)
    point_y                                 ,
#endif
    setPointY                               ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Point = Point (SP.ManagedPtr Point)
    deriving (Eq)

instance SP.ManagedPtrNewtype Point where
    toManagedPtr (Point p) = p

instance BoxedPtr Point where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr Point)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr Point where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'Point' struct initialized to zero.
newZeroPoint :: MonadIO m => m Point
newZeroPoint = liftIO $ boxedPtrCalloc >>= wrapPtr Point

instance tag ~ 'AttrSet => Constructible Point tag where
    new _ attrs = do
        o <- newZeroPoint
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point #x
-- @
getPointX :: MonadIO m => Point -> m Int32
getPointX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setPointX :: MonadIO m => Point -> Int32 -> m ()
setPointX s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data PointXFieldInfo
instance AttrInfo PointXFieldInfo where
    type AttrBaseTypeConstraint PointXFieldInfo = (~) Point
    type AttrAllowedOps PointXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PointXFieldInfo = (~) Int32
    type AttrTransferTypeConstraint PointXFieldInfo = (~)Int32
    type AttrTransferType PointXFieldInfo = Int32
    type AttrGetType PointXFieldInfo = Int32
    type AttrLabel PointXFieldInfo = "x"
    type AttrOrigin PointXFieldInfo = Point
    attrGet = getPointX
    attrSet = setPointX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Point.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Point.html#g:attr:x"
        })

point_x :: AttrLabelProxy "x"
point_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' point #y
-- @
getPointY :: MonadIO m => Point -> m Int32
getPointY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' point [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setPointY :: MonadIO m => Point -> Int32 -> m ()
setPointY s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data PointYFieldInfo
instance AttrInfo PointYFieldInfo where
    type AttrBaseTypeConstraint PointYFieldInfo = (~) Point
    type AttrAllowedOps PointYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint PointYFieldInfo = (~) Int32
    type AttrTransferTypeConstraint PointYFieldInfo = (~)Int32
    type AttrTransferType PointYFieldInfo = Int32
    type AttrGetType PointYFieldInfo = Int32
    type AttrLabel PointYFieldInfo = "y"
    type AttrOrigin PointYFieldInfo = Point
    attrGet = getPointY
    attrSet = setPointY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.Point.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-3.0.29/docs/GI-Gdk-Structs-Point.html#g:attr:y"
        })

point_y :: AttrLabelProxy "y"
point_y = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Point
type instance O.AttributeList Point = PointAttributeList
type PointAttributeList = ('[ '("x", PointXFieldInfo), '("y", PointYFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePointMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePointMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePointMethod t Point, O.OverloadedMethod info Point p) => OL.IsLabel t (Point -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePointMethod t Point, O.OverloadedMethod info Point p, R.HasField t Point p) => R.HasField t Point p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePointMethod t Point, O.OverloadedMethodInfo info Point) => OL.IsLabel t (O.MethodProxy info Point) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


