{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GIcon@ is a very minimal interface for icons. It provides functions
-- for checking the equality of two icons, hashing of icons and
-- serializing an icon to and from strings.
-- 
-- @GIcon@ does not provide the actual pixmap for the icon as this is out
-- of GIO\'s scope, however implementations of @GIcon@ may contain the name
-- of an icon (see t'GI.Gio.Objects.ThemedIcon.ThemedIcon'), or the path to an icon
-- (see t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon').
-- 
-- To obtain a hash of a @GIcon@, see 'GI.Gio.Interfaces.Icon.iconHash'.
-- 
-- To check if two @GIcon@s are equal, see 'GI.Gio.Interfaces.Icon.iconEqual'.
-- 
-- For serializing a @GIcon@, use 'GI.Gio.Interfaces.Icon.iconSerialize' and
-- 'GI.Gio.Interfaces.Icon.iconDeserialize'.
-- 
-- If you want to consume @GIcon@ (for example, in a toolkit) you must
-- be prepared to handle at least the three following cases:
-- t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon', t'GI.Gio.Objects.ThemedIcon.ThemedIcon' and t'GI.Gio.Objects.EmblemedIcon.EmblemedIcon'.
-- It may also make sense to have fast-paths for other cases (like handling
-- <https://docs.gtk.org/gdk-pixbuf/class.Pixbuf.html `GdkPixbuf`> directly,
-- for example) but all compliant @GIcon@ implementations outside of GIO must
-- implement t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.
-- 
-- If your application or library provides one or more @GIcon@
-- implementations you need to ensure that your new implementation also
-- implements t'GI.Gio.Interfaces.LoadableIcon.LoadableIcon'.  Additionally, you must provide an
-- implementation of 'GI.Gio.Interfaces.Icon.iconSerialize' that gives a result that is
-- understood by 'GI.Gio.Interfaces.Icon.iconDeserialize', yielding one of the built-in
-- icon types.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.Icon
    ( 

-- * Exported types
    Icon(..)                                ,
    IsIcon                                  ,
    toIcon                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [equal]("GI.Gio.Interfaces.Icon#g:method:equal"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [hash]("GI.Gio.Interfaces.Icon#g:method:hash"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [serialize]("GI.Gio.Interfaces.Icon#g:method:serialize"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toString]("GI.Gio.Interfaces.Icon#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveIconMethod                       ,
#endif

-- ** deserialize #method:deserialize#

    iconDeserialize                         ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    IconEqualMethodInfo                     ,
#endif
    iconEqual                               ,


-- ** hash #method:hash#

#if defined(ENABLE_OVERLOADING)
    IconHashMethodInfo                      ,
#endif
    iconHash                                ,


-- ** newForString #method:newForString#

    iconNewForString                        ,


-- ** serialize #method:serialize#

#if defined(ENABLE_OVERLOADING)
    IconSerializeMethodInfo                 ,
#endif
    iconSerialize                           ,


-- ** toString #method:toString#

#if defined(ENABLE_OVERLOADING)
    IconToStringMethodInfo                  ,
#endif
    iconToString                            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object

#else
import qualified GI.GObject.Objects.Object as GObject.Object

#endif

-- interface Icon 
-- | Memory-managed wrapper type.
newtype Icon = Icon (SP.ManagedPtr Icon)
    deriving (Eq)

instance SP.ManagedPtrNewtype Icon where
    toManagedPtr (Icon p) = p

foreign import ccall "g_icon_get_type"
    c_g_icon_get_type :: IO B.Types.GType

instance B.Types.TypedObject Icon where
    glibType = c_g_icon_get_type

instance B.Types.GObject Icon

-- | Type class for types which can be safely cast to t'Icon', for instance with `toIcon`.
class (SP.GObject o, O.IsDescendantOf Icon o) => IsIcon o
instance (SP.GObject o, O.IsDescendantOf Icon o) => IsIcon o

instance O.HasParentTypes Icon
type instance O.ParentTypes Icon = '[GObject.Object.Object]

-- | Cast to t'Icon', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toIcon :: (MIO.MonadIO m, IsIcon o) => o -> m Icon
toIcon = MIO.liftIO . B.ManagedPtr.unsafeCastTo Icon

-- | Convert t'Icon' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Icon) where
    gvalueGType_ = c_g_icon_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Icon)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Icon)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Icon ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Icon
type instance O.AttributeList Icon = IconAttributeList
type IconAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveIconMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveIconMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveIconMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveIconMethod "equal" o = IconEqualMethodInfo
    ResolveIconMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveIconMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveIconMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveIconMethod "hash" o = IconHashMethodInfo
    ResolveIconMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveIconMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveIconMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveIconMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveIconMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveIconMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveIconMethod "serialize" o = IconSerializeMethodInfo
    ResolveIconMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveIconMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveIconMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveIconMethod "toString" o = IconToStringMethodInfo
    ResolveIconMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveIconMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveIconMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveIconMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveIconMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveIconMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveIconMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveIconMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveIconMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveIconMethod t Icon, O.OverloadedMethod info Icon p) => OL.IsLabel t (Icon -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveIconMethod t Icon, O.OverloadedMethod info Icon p, R.HasField t Icon p) => R.HasField t Icon p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveIconMethod t Icon, O.OverloadedMethodInfo info Icon) => OL.IsLabel t (O.MethodProxy info Icon) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method Icon::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon1"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to the first #GIcon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "icon2"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "pointer to the second #GIcon."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_icon_equal" g_icon_equal :: 
    Ptr Icon ->                             -- icon1 : TInterface (Name {namespace = "Gio", name = "Icon"})
    Ptr Icon ->                             -- icon2 : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO CInt

-- | Checks if two icons are equal.
iconEqual ::
    (B.CallStack.HasCallStack, MonadIO m, IsIcon a, IsIcon b) =>
    Maybe (a)
    -- ^ /@icon1@/: pointer to the first t'GI.Gio.Interfaces.Icon.Icon'.
    -> Maybe (b)
    -- ^ /@icon2@/: pointer to the second t'GI.Gio.Interfaces.Icon.Icon'.
    -> m Bool
    -- ^ __Returns:__ 'P.True' if /@icon1@/ is equal to /@icon2@/. 'P.False' otherwise.
iconEqual icon1 icon2 = liftIO $ do
    maybeIcon1 <- case icon1 of
        Nothing -> return FP.nullPtr
        Just jIcon1 -> do
            jIcon1' <- unsafeManagedPtrCastPtr jIcon1
            return jIcon1'
    maybeIcon2 <- case icon2 of
        Nothing -> return FP.nullPtr
        Just jIcon2 -> do
            jIcon2' <- unsafeManagedPtrCastPtr jIcon2
            return jIcon2'
    result <- g_icon_equal maybeIcon1 maybeIcon2
    let result' = (/= 0) result
    whenJust icon1 touchManagedPtr
    whenJust icon2 touchManagedPtr
    return result'

#if defined(ENABLE_OVERLOADING)
data IconEqualMethodInfo
instance (signature ~ (Maybe (b) -> m Bool), MonadIO m, IsIcon a, IsIcon b) => O.OverloadedMethod IconEqualMethodInfo a signature where
    overloadedMethod i = iconEqual (Just i)

instance O.OverloadedMethodInfo IconEqualMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Icon.iconEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-Icon.html#v:iconEqual"
        })


#endif

-- method Icon::hash
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "#gconstpointer to an icon object."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "g_icon_hash" g_icon_hash :: 
    Ptr Icon ->                             -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO Word32

-- | Gets a hash for an icon.
iconHash ::
    (B.CallStack.HasCallStack, MonadIO m, IsIcon a) =>
    a
    -- ^ /@icon@/: @/gconstpointer/@ to an icon object.
    -> m Word32
    -- ^ __Returns:__ a @/guint/@ containing a hash for the /@icon@/, suitable for
    --   use in a t'GI.GLib.Structs.HashTable.HashTable' or similar data structure.
iconHash icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_icon_hash icon'
    touchManagedPtr icon
    return result

#if defined(ENABLE_OVERLOADING)
data IconHashMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsIcon a) => O.OverloadedMethod IconHashMethodInfo a signature where
    overloadedMethod = iconHash

instance O.OverloadedMethodInfo IconHashMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Icon.iconHash",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-Icon.html#v:iconHash"
        })


#endif

-- method Icon::serialize
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIcon" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TVariant
-- throws : False
-- Skip return : False

foreign import ccall "g_icon_serialize" g_icon_serialize :: 
    Ptr Icon ->                             -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO (Ptr GVariant)

-- | Serializes a t'GI.Gio.Interfaces.Icon.Icon' into a t'GVariant'. An equivalent t'GI.Gio.Interfaces.Icon.Icon' can be retrieved
-- back by calling 'GI.Gio.Functions.iconDeserialize' on the returned value.
-- As serialization will avoid using raw icon data when possible, it only
-- makes sense to transfer the t'GVariant' between processes on the same machine,
-- (as opposed to over the network), and within the same file system namespace.
-- 
-- /Since: 2.38/
iconSerialize ::
    (B.CallStack.HasCallStack, MonadIO m, IsIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.Icon.Icon'
    -> m (Maybe GVariant)
    -- ^ __Returns:__ a t'GVariant', or 'P.Nothing' when serialization fails. The t'GVariant' will not be floating.
iconSerialize icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_icon_serialize icon'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- B.GVariant.wrapGVariantPtr result'
        return result''
    touchManagedPtr icon
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconSerializeMethodInfo
instance (signature ~ (m (Maybe GVariant)), MonadIO m, IsIcon a) => O.OverloadedMethod IconSerializeMethodInfo a signature where
    overloadedMethod = iconSerialize

instance O.OverloadedMethodInfo IconSerializeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Icon.iconSerialize",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-Icon.html#v:iconSerialize"
        })


#endif

-- method Icon::to_string
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "icon"
--           , argType = TInterface Name { namespace = "Gio" , name = "Icon" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GIcon." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_icon_to_string" g_icon_to_string :: 
    Ptr Icon ->                             -- icon : TInterface (Name {namespace = "Gio", name = "Icon"})
    IO CString

-- | Generates a textual representation of /@icon@/ that can be used for
-- serialization such as when passing /@icon@/ to a different process or
-- saving it to persistent storage. Use 'GI.Gio.Functions.iconNewForString' to
-- get /@icon@/ back from the returned string.
-- 
-- The encoding of the returned string is proprietary to t'GI.Gio.Interfaces.Icon.Icon' except
-- in the following two cases
-- 
-- * If /@icon@/ is a t'GI.Gio.Objects.FileIcon.FileIcon', the returned string is a native path
--   (such as @\/path\/to\/my icon.png@) without escaping
--   if the t'GI.Gio.Interfaces.File.File' for /@icon@/ is a native file.  If the file is not
--   native, the returned string is the result of 'GI.Gio.Interfaces.File.fileGetUri'
--   (such as @sftp:\/\/path\/to\/my%20icon.png@).
-- * If /@icon@/ is a t'GI.Gio.Objects.ThemedIcon.ThemedIcon' with exactly one name and no fallbacks,
--   the encoding is simply the name (such as @network-server@).
-- 
-- 
-- /Since: 2.20/
iconToString ::
    (B.CallStack.HasCallStack, MonadIO m, IsIcon a) =>
    a
    -- ^ /@icon@/: a t'GI.Gio.Interfaces.Icon.Icon'.
    -> m (Maybe T.Text)
    -- ^ __Returns:__ An allocated NUL-terminated UTF8 string or
    -- 'P.Nothing' if /@icon@/ can\'t be serialized. Use 'GI.GLib.Functions.free' to free.
iconToString icon = liftIO $ do
    icon' <- unsafeManagedPtrCastPtr icon
    result <- g_icon_to_string icon'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        freeMem result'
        return result''
    touchManagedPtr icon
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data IconToStringMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsIcon a) => O.OverloadedMethod IconToStringMethodInfo a signature where
    overloadedMethod = iconToString

instance O.OverloadedMethodInfo IconToStringMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.Icon.iconToString",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-Icon.html#v:iconToString"
        })


#endif

-- method Icon::deserialize
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TVariant
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GVariant created with g_icon_serialize()"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : False
-- Skip return : False

foreign import ccall "g_icon_deserialize" g_icon_deserialize :: 
    Ptr GVariant ->                         -- value : TVariant
    IO (Ptr Icon)

-- | Deserializes a t'GI.Gio.Interfaces.Icon.Icon' previously serialized using 'GI.Gio.Interfaces.Icon.iconSerialize'.
-- 
-- /Since: 2.38/
iconDeserialize ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GVariant
    -- ^ /@value@/: a t'GVariant' created with 'GI.Gio.Interfaces.Icon.iconSerialize'
    -> m (Maybe Icon)
    -- ^ __Returns:__ a t'GI.Gio.Interfaces.Icon.Icon', or 'P.Nothing' when deserialization fails.
iconDeserialize value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- g_icon_deserialize value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Icon) result'
        return result''
    touchManagedPtr value
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Icon::new_for_string
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "str"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A string obtained via g_icon_to_string()."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "Icon" })
-- throws : True
-- Skip return : False

foreign import ccall "g_icon_new_for_string" g_icon_new_for_string :: 
    CString ->                              -- str : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Icon)

-- | Generate a t'GI.Gio.Interfaces.Icon.Icon' instance from /@str@/. This function can fail if
-- /@str@/ is not valid - see 'GI.Gio.Interfaces.Icon.iconToString' for discussion.
-- 
-- If your application or library provides one or more t'GI.Gio.Interfaces.Icon.Icon'
-- implementations you need to ensure that each t'GType' is registered
-- with the type system prior to calling 'GI.Gio.Functions.iconNewForString'.
-- 
-- /Since: 2.20/
iconNewForString ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@str@/: A string obtained via 'GI.Gio.Interfaces.Icon.iconToString'.
    -> m Icon
    -- ^ __Returns:__ An object implementing the t'GI.Gio.Interfaces.Icon.Icon'
    --          interface or 'P.Nothing' if /@error@/ is set. /(Can throw 'Data.GI.Base.GError.GError')/
iconNewForString str = liftIO $ do
    str' <- textToCString str
    onException (do
        result <- propagateGError $ g_icon_new_for_string str'
        checkUnexpectedReturnNULL "iconNewForString" result
        result' <- (wrapObject Icon) result
        freeMem str'
        return result'
     ) (do
        freeMem str'
     )

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Icon = IconSignalList
type IconSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


