/* shotwell-video-thumbnailer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from shotwell-video-thumbnailer.vala, do not modify */

/* Copyright 2011-2013 Yorba Foundation
 *
 * This is a Vala-rewrite of GStreamer snapshot example. Adapted from earlier
 * work from Wim Taymans.
 *
 * This software is licensed under the GNU LGPL (version 2.1 or later).
 * See the COPYING file in this distribution.
 */
/* Shotwell Thumbnailer takes in a video file and returns a thumbnail to stdout.  This is*/
/* a replacement for totem-video-thumbnailer*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gst/gst.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define SHOTWELL_THUMBNAILER_CAPS_STRING "video/x-raw,format=RGB,pixel-aspect-ratio=1/1"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SHOTWELL_THUMBNAILER (shotwell_thumbnailer_get_type ())
#define SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer))
#define SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))
#define IS_SHOTWELL_THUMBNAILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHOTWELL_THUMBNAILER))
#define IS_SHOTWELL_THUMBNAILER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHOTWELL_THUMBNAILER))
#define SHOTWELL_THUMBNAILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailerClass))

typedef struct _ShotwellThumbnailer ShotwellThumbnailer;
typedef struct _ShotwellThumbnailerClass ShotwellThumbnailerClass;
typedef struct _ShotwellThumbnailerPrivate ShotwellThumbnailerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_sample_unref0(var) ((var == NULL) ? NULL : (var = (gst_sample_unref (var), NULL)))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecShotwellThumbnailer ParamSpecShotwellThumbnailer;

struct _ShotwellThumbnailer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ShotwellThumbnailerPrivate * priv;
};

struct _ShotwellThumbnailerClass {
	GTypeClass parent_class;
	void (*finalize) (ShotwellThumbnailer *self);
};

struct _ParamSpecShotwellThumbnailer {
	GParamSpec parent_instance;
};

static gpointer shotwell_thumbnailer_parent_class = NULL;

VALA_EXTERN gpointer shotwell_thumbnailer_ref (gpointer instance);
VALA_EXTERN void shotwell_thumbnailer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_shotwell_thumbnailer (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
VALA_EXTERN void value_set_shotwell_thumbnailer (GValue* value,
                                     gpointer v_object);
VALA_EXTERN void value_take_shotwell_thumbnailer (GValue* value,
                                      gpointer v_object);
VALA_EXTERN gpointer value_get_shotwell_thumbnailer (const GValue* value);
VALA_EXTERN GType shotwell_thumbnailer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ShotwellThumbnailer, shotwell_thumbnailer_unref)
static gint shotwell_thumbnailer_main (gchar** args,
                                gint args_length1);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN ShotwellThumbnailer* shotwell_thumbnailer_new (void);
VALA_EXTERN ShotwellThumbnailer* shotwell_thumbnailer_construct (GType object_type);
static void shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj);
static GType shotwell_thumbnailer_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_gst_caps_ref0 (gpointer self)
{
	return self ? gst_caps_ref (self) : NULL;
}

static gpointer
_gst_buffer_ref0 (gpointer self)
{
	return self ? gst_buffer_ref (self) : NULL;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static gint
shotwell_thumbnailer_main (gchar** args,
                           gint args_length1)
{
	GstElement* pipeline = NULL;
	GstElement* sink = NULL;
	gint width = 0;
	gint height = 0;
	GstSample* sample = NULL;
	gchar* descr = NULL;
	GdkPixbuf* pixbuf = NULL;
	gint64 duration = 0LL;
	gint64 position = 0LL;
	GstStateChangeReturn ret = 0;
	gboolean res = FALSE;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GError* _inner_error0_ = NULL;
	gint result;
	gst_init ((gint*) (&args_length1), &args);
	if (args_length1 != 2) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = stdout;
		_tmp1_ = args[0];
		fprintf (_tmp0_, "usage: %s [filename]\n Writes video thumbnail to stdout\n", _tmp1_);
		result = 1;
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_gst_sample_unref0 (sample);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		return result;
	}
	_tmp2_ = args[1];
	_tmp3_ = g_strdup_printf ("filesrc location=\"%s\" ! decodebin ! videoconvert ! videoscale ! ", _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("appsink name=sink caps=\"%s\"", SHOTWELL_THUMBNAILER_CAPS_STRING);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
	_g_free0 (descr);
	descr = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	{
		GstElement* _tmp8_ = NULL;
		const gchar* _tmp9_;
		GstElement* _tmp10_;
		GstElement* _tmp11_;
		GstElement* _tmp12_;
		GstElement* _tmp13_;
		GstElement* _tmp14_;
		GstElement* _tmp17_;
		GstElement* _tmp19_;
		gint64 _tmp20_ = 0LL;
		GstElement* _tmp21_;
		GstElement* _tmp22_;
		GstSample* _tmp23_ = NULL;
		GstSample* _tmp24_;
		GstElement* _tmp56_;
		_tmp9_ = descr;
		_tmp10_ = gst_parse_launch_full (_tmp9_, NULL, GST_PARSE_FLAG_NONE, &_inner_error0_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp11_ = _tmp8_;
		_tmp8_ = NULL;
		if (_tmp11_ != NULL) {
			g_object_ref_sink (_tmp11_);
		}
		_g_object_unref0 (pipeline);
		pipeline = _tmp11_;
		_tmp12_ = pipeline;
		_tmp13_ = gst_bin_get_by_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gst_bin_get_type (), GstBin), "sink");
		_g_object_unref0 (sink);
		sink = _tmp13_;
		_tmp14_ = pipeline;
		ret = gst_element_set_state (_tmp14_, GST_STATE_PAUSED);
		if (ret == GST_STATE_CHANGE_FAILURE) {
			FILE* _tmp15_;
			_tmp15_ = stderr;
			fprintf (_tmp15_, "Failed to play the file: couldn't set state\n");
			result = 3;
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_gst_sample_unref0 (sample);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		} else {
			if (ret == GST_STATE_CHANGE_NO_PREROLL) {
				FILE* _tmp16_;
				_tmp16_ = stderr;
				fprintf (_tmp16_, "Live sources not supported yet.\n");
				result = 4;
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (pixbuf);
				_g_free0 (descr);
				_gst_sample_unref0 (sample);
				_g_object_unref0 (sink);
				_g_object_unref0 (pipeline);
				return result;
			}
		}
		_tmp17_ = pipeline;
		ret = gst_element_get_state (_tmp17_, NULL, NULL, (GstClockTime) (5 * GST_SECOND));
		if (ret == GST_STATE_CHANGE_FAILURE) {
			FILE* _tmp18_;
			_tmp18_ = stderr;
			fprintf (_tmp18_, "Failed to play the file: couldn't get state.\n");
			result = 3;
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_gst_sample_unref0 (sample);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		}
		_tmp19_ = pipeline;
		gst_element_query_duration (_tmp19_, GST_FORMAT_TIME, &_tmp20_);
		duration = _tmp20_;
		position = (gint64) (1 * GST_SECOND);
		_tmp21_ = pipeline;
		gst_element_seek_simple (_tmp21_, GST_FORMAT_TIME, GST_SEEK_FLAG_KEY_UNIT | GST_SEEK_FLAG_FLUSH, position);
		_tmp22_ = sink;
		g_signal_emit_by_name (_tmp22_, "pull-preroll", &_tmp23_, NULL, NULL);
		_gst_sample_unref0 (sample);
		sample = _tmp23_;
		_tmp24_ = sample;
		if (_tmp24_ != NULL) {
			GstBuffer* buffer = NULL;
			GstCaps* caps = NULL;
			GstStructure* s = NULL;
			GstMapInfo mapinfo = {0};
			guint8* pngdata = NULL;
			gint pngdata_length1 = 0;
			gint _pngdata_size_ = 0;
			GstSample* _tmp25_;
			GstCaps* _tmp26_;
			GstCaps* _tmp27_;
			GstCaps* _tmp28_;
			GstCaps* _tmp30_;
			GstStructure* _tmp31_;
			GstStructure* _tmp32_;
			gint _tmp33_ = 0;
			gboolean _tmp34_;
			GstStructure* _tmp35_;
			gint _tmp36_ = 0;
			gboolean _tmp37_;
			GstSample* _tmp39_;
			GstBuffer* _tmp40_;
			GstBuffer* _tmp41_;
			GstBuffer* _tmp42_;
			GstMapInfo _tmp43_ = {0};
			GstMapInfo _tmp44_;
			guint8* _tmp45_;
			gint _tmp45__length1;
			guint8* _tmp46_;
			gint _tmp46__length1;
			GdkPixbuf* _tmp47_;
			GdkPixbuf* _tmp48_;
			guint8* _tmp49_ = NULL;
			gsize _tmp50_ = 0;
			FILE* _tmp51_;
			guint8* _tmp52_;
			gint _tmp52__length1;
			GstBuffer* _tmp53_;
			GstMapInfo _tmp54_;
			_tmp25_ = sample;
			_tmp26_ = gst_sample_get_caps (_tmp25_);
			_tmp27_ = _gst_caps_ref0 (_tmp26_);
			_gst_caps_unref0 (caps);
			caps = _tmp27_;
			_tmp28_ = caps;
			if (_tmp28_ == NULL) {
				FILE* _tmp29_;
				_tmp29_ = stderr;
				fprintf (_tmp29_, "could not get snapshot format\n");
				result = 5;
				pngdata = (g_free (pngdata), NULL);
				_gst_caps_unref0 (caps);
				_gst_buffer_unref0 (buffer);
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (pixbuf);
				_g_free0 (descr);
				_gst_sample_unref0 (sample);
				_g_object_unref0 (sink);
				_g_object_unref0 (pipeline);
				return result;
			}
			_tmp30_ = caps;
			_tmp31_ = gst_caps_get_structure (_tmp30_, (guint) 0);
			s = _tmp31_;
			_tmp32_ = s;
			_tmp34_ = gst_structure_get_int (_tmp32_, "width", &_tmp33_);
			width = _tmp33_;
			res = _tmp34_;
			_tmp35_ = s;
			_tmp37_ = gst_structure_get_int (_tmp35_, "height", &_tmp36_);
			height = _tmp36_;
			res |= _tmp37_;
			if (!res) {
				FILE* _tmp38_;
				_tmp38_ = stderr;
				fprintf (_tmp38_, "Could not get snapshot dimension\n");
				result = 6;
				pngdata = (g_free (pngdata), NULL);
				_gst_caps_unref0 (caps);
				_gst_buffer_unref0 (buffer);
				_g_object_unref0 (_tmp8_);
				_g_object_unref0 (pixbuf);
				_g_free0 (descr);
				_gst_sample_unref0 (sample);
				_g_object_unref0 (sink);
				_g_object_unref0 (pipeline);
				return result;
			}
			_tmp39_ = sample;
			_tmp40_ = gst_sample_get_buffer (_tmp39_);
			_tmp41_ = _gst_buffer_ref0 (_tmp40_);
			_gst_buffer_unref0 (buffer);
			buffer = _tmp41_;
			_tmp42_ = buffer;
			gst_buffer_map (_tmp42_, &_tmp43_, GST_MAP_READ);
			mapinfo = _tmp43_;
			_tmp44_ = mapinfo;
			_tmp45_ = _tmp44_.data;
			_tmp45__length1 = _tmp44_.size;
			_tmp46_ = (_tmp45_ != NULL) ? _vala_array_dup1 (_tmp45_, _tmp45__length1) : _tmp45_;
			_tmp46__length1 = _tmp45__length1;
			_tmp47_ = gdk_pixbuf_new_from_data (_tmp46_, GDK_COLORSPACE_RGB, FALSE, 8, width, height, ((width * 3) + 3) & (~3), NULL, NULL);
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp47_;
			_tmp48_ = pixbuf;
			gdk_pixbuf_save_to_buffer (_tmp48_, &_tmp49_, &_tmp50_, "png", &_inner_error0_, NULL);
			pngdata = (g_free (pngdata), NULL);
			pngdata = _tmp49_;
			pngdata_length1 = _tmp50_;
			_pngdata_size_ = pngdata_length1;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				pngdata = (g_free (pngdata), NULL);
				_gst_caps_unref0 (caps);
				_gst_buffer_unref0 (buffer);
				_g_object_unref0 (_tmp8_);
				goto __catch0_g_error;
			}
			_tmp51_ = stdout;
			_tmp52_ = pngdata;
			_tmp52__length1 = pngdata_length1;
			fwrite (_tmp52_, (gsize) 1, (gint) _tmp52__length1, _tmp51_);
			_tmp53_ = buffer;
			_tmp54_ = mapinfo;
			gst_buffer_unmap (_tmp53_, &_tmp54_);
			pngdata = (g_free (pngdata), NULL);
			_gst_caps_unref0 (caps);
			_gst_buffer_unref0 (buffer);
		} else {
			FILE* _tmp55_;
			_tmp55_ = stderr;
			fprintf (_tmp55_, "Could not make snapshot\n");
			result = 10;
			_g_object_unref0 (_tmp8_);
			_g_object_unref0 (pixbuf);
			_g_free0 (descr);
			_gst_sample_unref0 (sample);
			_g_object_unref0 (sink);
			_g_object_unref0 (pipeline);
			return result;
		}
		_tmp56_ = pipeline;
		gst_element_set_state (_tmp56_, GST_STATE_NULL);
		_g_object_unref0 (_tmp8_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp57_;
		GError* _tmp58_;
		const gchar* _tmp59_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp57_ = stderr;
		_tmp58_ = e;
		_tmp59_ = _tmp58_->message;
		fprintf (_tmp57_, "%s", _tmp59_);
		result = 2;
		_g_error_free0 (e);
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_gst_sample_unref0 (sample);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp60_ = -1;
		_g_object_unref0 (pixbuf);
		_g_free0 (descr);
		_gst_sample_unref0 (sample);
		_g_object_unref0 (sink);
		_g_object_unref0 (pipeline);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp60_;
	}
	result = 0;
	_g_object_unref0 (pixbuf);
	_g_free0 (descr);
	_gst_sample_unref0 (sample);
	_g_object_unref0 (sink);
	_g_object_unref0 (pipeline);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return shotwell_thumbnailer_main (argv, argc);
}

ShotwellThumbnailer*
shotwell_thumbnailer_construct (GType object_type)
{
	ShotwellThumbnailer* self = NULL;
	self = (ShotwellThumbnailer*) g_type_create_instance (object_type);
	return self;
}

ShotwellThumbnailer*
shotwell_thumbnailer_new (void)
{
	return shotwell_thumbnailer_construct (TYPE_SHOTWELL_THUMBNAILER);
}

static void
value_shotwell_thumbnailer_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_shotwell_thumbnailer_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		shotwell_thumbnailer_unref (value->data[0].v_pointer);
	}
}

static void
value_shotwell_thumbnailer_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = shotwell_thumbnailer_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_shotwell_thumbnailer_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_shotwell_thumbnailer_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ShotwellThumbnailer * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = shotwell_thumbnailer_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_shotwell_thumbnailer_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ShotwellThumbnailer ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = shotwell_thumbnailer_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_shotwell_thumbnailer (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ParamSpecShotwellThumbnailer* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SHOTWELL_THUMBNAILER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_shotwell_thumbnailer (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER), NULL);
	return value->data[0].v_pointer;
}

void
value_set_shotwell_thumbnailer (GValue* value,
                                gpointer v_object)
{
	ShotwellThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		shotwell_thumbnailer_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shotwell_thumbnailer_unref (old);
	}
}

void
value_take_shotwell_thumbnailer (GValue* value,
                                 gpointer v_object)
{
	ShotwellThumbnailer * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SHOTWELL_THUMBNAILER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SHOTWELL_THUMBNAILER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		shotwell_thumbnailer_unref (old);
	}
}

static void
shotwell_thumbnailer_class_init (ShotwellThumbnailerClass * klass,
                                 gpointer klass_data)
{
	shotwell_thumbnailer_parent_class = g_type_class_peek_parent (klass);
	((ShotwellThumbnailerClass *) klass)->finalize = shotwell_thumbnailer_finalize;
}

static void
shotwell_thumbnailer_instance_init (ShotwellThumbnailer * self,
                                    gpointer klass)
{
	self->ref_count = 1;
}

static void
shotwell_thumbnailer_finalize (ShotwellThumbnailer * obj)
{
	ShotwellThumbnailer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHOTWELL_THUMBNAILER, ShotwellThumbnailer);
	g_signal_handlers_destroy (self);
}

static GType
shotwell_thumbnailer_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_shotwell_thumbnailer_init, value_shotwell_thumbnailer_free_value, value_shotwell_thumbnailer_copy_value, value_shotwell_thumbnailer_peek_pointer, "p", value_shotwell_thumbnailer_collect_value, "p", value_shotwell_thumbnailer_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ShotwellThumbnailerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shotwell_thumbnailer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ShotwellThumbnailer), 0, (GInstanceInitFunc) shotwell_thumbnailer_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType shotwell_thumbnailer_type_id;
	shotwell_thumbnailer_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ShotwellThumbnailer", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return shotwell_thumbnailer_type_id;
}

GType
shotwell_thumbnailer_get_type (void)
{
	static volatile gsize shotwell_thumbnailer_type_id__once = 0;
	if (g_once_init_enter (&shotwell_thumbnailer_type_id__once)) {
		GType shotwell_thumbnailer_type_id;
		shotwell_thumbnailer_type_id = shotwell_thumbnailer_get_type_once ();
		g_once_init_leave (&shotwell_thumbnailer_type_id__once, shotwell_thumbnailer_type_id);
	}
	return shotwell_thumbnailer_type_id__once;
}

gpointer
shotwell_thumbnailer_ref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
shotwell_thumbnailer_unref (gpointer instance)
{
	ShotwellThumbnailer * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SHOTWELL_THUMBNAILER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

