// python wrapper for vtkSurfaceLICRepresentation
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkSurfaceLICRepresentation.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSurfaceLICRepresentation(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSurfaceLICRepresentation_ClassNew(); }

#ifndef DECLARED_PyvtkGeometryRepresentationWithFaces_ClassNew
extern "C" { PyObject *PyvtkGeometryRepresentationWithFaces_ClassNew(); }
#define DECLARED_PyvtkGeometryRepresentationWithFaces_ClassNew
#endif

static PyObject *
PyvtkSurfaceLICRepresentation_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSurfaceLICRepresentation::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSurfaceLICRepresentation::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSurfaceLICRepresentation *tempr = vtkSurfaceLICRepresentation::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSurfaceLICRepresentation *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSurfaceLICRepresentation::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSurfaceLICRepresentation::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSurfaceLICRepresentation::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_ProcessViewRequest(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ProcessViewRequest");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  vtkInformationRequestKey *temp0 = nullptr;
  vtkInformation *temp1 = nullptr;
  vtkInformation *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetVTKObject(temp0, "vtkInformationRequestKey") &&
      ap.GetVTKObject(temp1, "vtkInformation") &&
      ap.GetVTKObject(temp2, "vtkInformation"))
  {
    int tempr = (ap.IsBound() ?
      op->ProcessViewRequest(temp0, temp1, temp2) :
      op->vtkSurfaceLICRepresentation::ProcessViewRequest(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetUseLICForLOD(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetUseLICForLOD");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetUseLICForLOD(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetUseLICForLOD(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetEnable(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnable");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnable(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetEnable(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNumberOfSteps(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfSteps");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfSteps(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNumberOfSteps(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetStepSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetStepSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetStepSize(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetStepSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNormalizeVectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNormalizeVectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNormalizeVectors(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNormalizeVectors(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetEnhancedLIC(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnhancedLIC");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnhancedLIC(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetEnhancedLIC(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetEnhanceContrast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnhanceContrast");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnhanceContrast(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetEnhanceContrast(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetLowLICContrastEnhancementFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLowLICContrastEnhancementFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLowLICContrastEnhancementFactor(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetLowLICContrastEnhancementFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetHighLICContrastEnhancementFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHighLICContrastEnhancementFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHighLICContrastEnhancementFactor(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetHighLICContrastEnhancementFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetLowColorContrastEnhancementFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLowColorContrastEnhancementFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLowColorContrastEnhancementFactor(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetLowColorContrastEnhancementFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetHighColorContrastEnhancementFactor(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetHighColorContrastEnhancementFactor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetHighColorContrastEnhancementFactor(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetHighColorContrastEnhancementFactor(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetAntiAlias(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetAntiAlias");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetAntiAlias(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetAntiAlias(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetColorMode(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColorMode");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetColorMode(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetColorMode(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMapModeBias(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMapModeBias");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMapModeBias(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMapModeBias(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetLICIntensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLICIntensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLICIntensity(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetLICIntensity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskOnSurface(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskOnSurface");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskOnSurface(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaskOnSurface(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskThreshold(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskThreshold");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskThreshold(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaskThreshold(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskColor_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  size_t size0 = ap.GetArgSize(0);
  vtkPythonArgs::Array<double> store0(2*size0);
  double *temp0 = store0.Data();
  double *save0 = (size0 == 0 ? nullptr : temp0 + size0);
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->SetMaskColor(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaskColor(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskColor_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskColor");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  double temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    if (ap.IsBound())
    {
      op->SetMaskColor(temp0, temp1, temp2);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaskColor(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskColor(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSurfaceLICRepresentation_SetMaskColor_s1(self, args);
    case 3:
      return PyvtkSurfaceLICRepresentation_SetMaskColor_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetMaskColor");
  return nullptr;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMaskIntensity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaskIntensity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaskIntensity(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaskIntensity(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetGenerateNoiseTexture(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGenerateNoiseTexture");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetGenerateNoiseTexture(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetGenerateNoiseTexture(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNoiseType(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNoiseType");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNoiseType(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNoiseType(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNoiseTextureSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNoiseTextureSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNoiseTextureSize(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNoiseTextureSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNoiseGrainSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNoiseGrainSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNoiseGrainSize(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNoiseGrainSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMinNoiseValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMinNoiseValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMinNoiseValue(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMinNoiseValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetMaxNoiseValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetMaxNoiseValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetMaxNoiseValue(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetMaxNoiseValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNumberOfNoiseLevels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNumberOfNoiseLevels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNumberOfNoiseLevels(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNumberOfNoiseLevels(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetImpulseNoiseProbability(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImpulseNoiseProbability");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImpulseNoiseProbability(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetImpulseNoiseProbability(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetImpulseNoiseBackgroundValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetImpulseNoiseBackgroundValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetImpulseNoiseBackgroundValue(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetImpulseNoiseBackgroundValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetNoiseGeneratorSeed(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetNoiseGeneratorSeed");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetNoiseGeneratorSeed(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetNoiseGeneratorSeed(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SetCompositeStrategy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetCompositeStrategy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetCompositeStrategy(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SetCompositeStrategy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_WriteTimerLog(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteTimerLog");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->WriteTimerLog(temp0);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::WriteTimerLog(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSurfaceLICRepresentation_SelectInputVectors(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SelectInputVectors");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSurfaceLICRepresentation *op = static_cast<vtkSurfaceLICRepresentation *>(vp);

  int temp0;
  int temp1;
  int temp2;
  int temp3;
  const char *temp4 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(5) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2) &&
      ap.GetValue(temp3) &&
      ap.GetValue(temp4))
  {
    if (ap.IsBound())
    {
      op->SelectInputVectors(temp0, temp1, temp2, temp3, temp4);
    }
    else
    {
      op->vtkSurfaceLICRepresentation::SelectInputVectors(temp0, temp1, temp2, temp3, temp4);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSurfaceLICRepresentation_Methods[] = {
  {"IsTypeOf", PyvtkSurfaceLICRepresentation_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSurfaceLICRepresentation_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSurfaceLICRepresentation_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSurfaceLICRepresentation\nC++: static vtkSurfaceLICRepresentation *SafeDownCast(\n    vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSurfaceLICRepresentation_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSurfaceLICRepresentation\nC++: vtkSurfaceLICRepresentation *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSurfaceLICRepresentation_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSurfaceLICRepresentation_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"ProcessViewRequest", PyvtkSurfaceLICRepresentation_ProcessViewRequest, METH_VARARGS,
   "ProcessViewRequest(self, request_type:vtkInformationRequestKey,\n    inInfo:vtkInformation, outInfo:vtkInformation) -> int\nC++: int ProcessViewRequest(\n    vtkInformationRequestKey *request_type,\n    vtkInformation *inInfo, vtkInformation *outInfo) override;\n\nvtkAlgorithm::ProcessRequest() equivalent for rendering passes.\nThis is typically called by the vtkView to request meta-data from\nthe representations or ask them to perform certain tasks e.g.\nPrepareForRendering.\n"},
  {"SetUseLICForLOD", PyvtkSurfaceLICRepresentation_SetUseLICForLOD, METH_VARARGS,
   "SetUseLICForLOD(self, val:bool) -> None\nC++: void SetUseLICForLOD(bool val)\n\nIndicates whether LIC should be used when doing LOD rendering.\n"},
  {"SetEnable", PyvtkSurfaceLICRepresentation_SetEnable, METH_VARARGS,
   "SetEnable(self, val:bool) -> None\nC++: void SetEnable(bool val)\n\n"},
  {"SetNumberOfSteps", PyvtkSurfaceLICRepresentation_SetNumberOfSteps, METH_VARARGS,
   "SetNumberOfSteps(self, val:int) -> None\nC++: void SetNumberOfSteps(int val)\n\n"},
  {"SetStepSize", PyvtkSurfaceLICRepresentation_SetStepSize, METH_VARARGS,
   "SetStepSize(self, val:float) -> None\nC++: void SetStepSize(double val)\n\n"},
  {"SetNormalizeVectors", PyvtkSurfaceLICRepresentation_SetNormalizeVectors, METH_VARARGS,
   "SetNormalizeVectors(self, val:int) -> None\nC++: void SetNormalizeVectors(int val)\n\n"},
  {"SetEnhancedLIC", PyvtkSurfaceLICRepresentation_SetEnhancedLIC, METH_VARARGS,
   "SetEnhancedLIC(self, val:int) -> None\nC++: void SetEnhancedLIC(int val)\n\n"},
  {"SetEnhanceContrast", PyvtkSurfaceLICRepresentation_SetEnhanceContrast, METH_VARARGS,
   "SetEnhanceContrast(self, val:int) -> None\nC++: void SetEnhanceContrast(int val)\n\n"},
  {"SetLowLICContrastEnhancementFactor", PyvtkSurfaceLICRepresentation_SetLowLICContrastEnhancementFactor, METH_VARARGS,
   "SetLowLICContrastEnhancementFactor(self, val:float) -> None\nC++: void SetLowLICContrastEnhancementFactor(double val)\n\n"},
  {"SetHighLICContrastEnhancementFactor", PyvtkSurfaceLICRepresentation_SetHighLICContrastEnhancementFactor, METH_VARARGS,
   "SetHighLICContrastEnhancementFactor(self, val:float) -> None\nC++: void SetHighLICContrastEnhancementFactor(double val)\n\n"},
  {"SetLowColorContrastEnhancementFactor", PyvtkSurfaceLICRepresentation_SetLowColorContrastEnhancementFactor, METH_VARARGS,
   "SetLowColorContrastEnhancementFactor(self, val:float) -> None\nC++: void SetLowColorContrastEnhancementFactor(double val)\n\n"},
  {"SetHighColorContrastEnhancementFactor", PyvtkSurfaceLICRepresentation_SetHighColorContrastEnhancementFactor, METH_VARARGS,
   "SetHighColorContrastEnhancementFactor(self, val:float) -> None\nC++: void SetHighColorContrastEnhancementFactor(double val)\n\n"},
  {"SetAntiAlias", PyvtkSurfaceLICRepresentation_SetAntiAlias, METH_VARARGS,
   "SetAntiAlias(self, val:int) -> None\nC++: void SetAntiAlias(int val)\n\n"},
  {"SetColorMode", PyvtkSurfaceLICRepresentation_SetColorMode, METH_VARARGS,
   "SetColorMode(self, val:int) -> None\nC++: void SetColorMode(int val)\n\n"},
  {"SetMapModeBias", PyvtkSurfaceLICRepresentation_SetMapModeBias, METH_VARARGS,
   "SetMapModeBias(self, val:float) -> None\nC++: void SetMapModeBias(double val)\n\n"},
  {"SetLICIntensity", PyvtkSurfaceLICRepresentation_SetLICIntensity, METH_VARARGS,
   "SetLICIntensity(self, val:float) -> None\nC++: void SetLICIntensity(double val)\n\n"},
  {"SetMaskOnSurface", PyvtkSurfaceLICRepresentation_SetMaskOnSurface, METH_VARARGS,
   "SetMaskOnSurface(self, val:int) -> None\nC++: void SetMaskOnSurface(int val)\n\n"},
  {"SetMaskThreshold", PyvtkSurfaceLICRepresentation_SetMaskThreshold, METH_VARARGS,
   "SetMaskThreshold(self, val:float) -> None\nC++: void SetMaskThreshold(double val)\n\n"},
  {"SetMaskColor", PyvtkSurfaceLICRepresentation_SetMaskColor, METH_VARARGS,
   "SetMaskColor(self, val:[float, ...]) -> None\nC++: void SetMaskColor(double *val)\nSetMaskColor(self, r:float, g:float, b:float) -> None\nC++: void SetMaskColor(double r, double g, double b)\n\n"},
  {"SetMaskIntensity", PyvtkSurfaceLICRepresentation_SetMaskIntensity, METH_VARARGS,
   "SetMaskIntensity(self, val:float) -> None\nC++: void SetMaskIntensity(double val)\n\n"},
  {"SetGenerateNoiseTexture", PyvtkSurfaceLICRepresentation_SetGenerateNoiseTexture, METH_VARARGS,
   "SetGenerateNoiseTexture(self, val:int) -> None\nC++: void SetGenerateNoiseTexture(int val)\n\n"},
  {"SetNoiseType", PyvtkSurfaceLICRepresentation_SetNoiseType, METH_VARARGS,
   "SetNoiseType(self, val:int) -> None\nC++: void SetNoiseType(int val)\n\n"},
  {"SetNoiseTextureSize", PyvtkSurfaceLICRepresentation_SetNoiseTextureSize, METH_VARARGS,
   "SetNoiseTextureSize(self, val:int) -> None\nC++: void SetNoiseTextureSize(int val)\n\n"},
  {"SetNoiseGrainSize", PyvtkSurfaceLICRepresentation_SetNoiseGrainSize, METH_VARARGS,
   "SetNoiseGrainSize(self, val:int) -> None\nC++: void SetNoiseGrainSize(int val)\n\n"},
  {"SetMinNoiseValue", PyvtkSurfaceLICRepresentation_SetMinNoiseValue, METH_VARARGS,
   "SetMinNoiseValue(self, val:float) -> None\nC++: void SetMinNoiseValue(double val)\n\n"},
  {"SetMaxNoiseValue", PyvtkSurfaceLICRepresentation_SetMaxNoiseValue, METH_VARARGS,
   "SetMaxNoiseValue(self, val:float) -> None\nC++: void SetMaxNoiseValue(double val)\n\n"},
  {"SetNumberOfNoiseLevels", PyvtkSurfaceLICRepresentation_SetNumberOfNoiseLevels, METH_VARARGS,
   "SetNumberOfNoiseLevels(self, val:int) -> None\nC++: void SetNumberOfNoiseLevels(int val)\n\n"},
  {"SetImpulseNoiseProbability", PyvtkSurfaceLICRepresentation_SetImpulseNoiseProbability, METH_VARARGS,
   "SetImpulseNoiseProbability(self, val:float) -> None\nC++: void SetImpulseNoiseProbability(double val)\n\n"},
  {"SetImpulseNoiseBackgroundValue", PyvtkSurfaceLICRepresentation_SetImpulseNoiseBackgroundValue, METH_VARARGS,
   "SetImpulseNoiseBackgroundValue(self, val:float) -> None\nC++: void SetImpulseNoiseBackgroundValue(double val)\n\n"},
  {"SetNoiseGeneratorSeed", PyvtkSurfaceLICRepresentation_SetNoiseGeneratorSeed, METH_VARARGS,
   "SetNoiseGeneratorSeed(self, val:int) -> None\nC++: void SetNoiseGeneratorSeed(int val)\n\n"},
  {"SetCompositeStrategy", PyvtkSurfaceLICRepresentation_SetCompositeStrategy, METH_VARARGS,
   "SetCompositeStrategy(self, val:int) -> None\nC++: void SetCompositeStrategy(int val)\n\n"},
  {"WriteTimerLog", PyvtkSurfaceLICRepresentation_WriteTimerLog, METH_VARARGS,
   "WriteTimerLog(self, fileName:str) -> None\nC++: void WriteTimerLog(const char *fileName)\n\n"},
  {"SelectInputVectors", PyvtkSurfaceLICRepresentation_SelectInputVectors, METH_VARARGS,
   "SelectInputVectors(self, __a:int, __b:int, __c:int,\n    attributeMode:int, name:str) -> None\nC++: void SelectInputVectors(int, int, int, int attributeMode,\n    const char *name)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSurfaceLICRepresentation_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("use_lic_for_lod"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetUseLICForLOD(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetUseLICForLOD(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetUseLICForLOD\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetEnable(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetEnable(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnable\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("step_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetStepSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetStepSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetStepSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("normalize_vectors"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNormalizeVectors(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNormalizeVectors(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNormalizeVectors\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enhanced_lic"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetEnhancedLIC(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetEnhancedLIC(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnhancedLIC\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enhance_contrast"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetEnhanceContrast(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetEnhanceContrast(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetEnhanceContrast\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("low_lic_contrast_enhancement_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetLowLICContrastEnhancementFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetLowLICContrastEnhancementFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLowLICContrastEnhancementFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("high_lic_contrast_enhancement_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetHighLICContrastEnhancementFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetHighLICContrastEnhancementFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHighLICContrastEnhancementFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("low_color_contrast_enhancement_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetLowColorContrastEnhancementFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetLowColorContrastEnhancementFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLowColorContrastEnhancementFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("high_color_contrast_enhancement_factor"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetHighColorContrastEnhancementFactor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetHighColorContrastEnhancementFactor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetHighColorContrastEnhancementFactor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("anti_alias"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetAntiAlias(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetAntiAlias(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetAntiAlias\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("color_mode"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetColorMode(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetColorMode(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetColorMode\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("map_mode_bias"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMapModeBias(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMapModeBias(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMapModeBias\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("lic_intensity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetLICIntensity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetLICIntensity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetLICIntensity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_on_surface"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaskOnSurface(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaskOnSurface(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaskOnSurface\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_threshold"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaskThreshold(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaskThreshold(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaskThreshold\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaskColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaskColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaskColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_color"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaskColor(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaskColor(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaskColor\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("mask_intensity"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaskIntensity(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaskIntensity(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaskIntensity\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("generate_noise_texture"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetGenerateNoiseTexture(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetGenerateNoiseTexture(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGenerateNoiseTexture\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("noise_type"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseType(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseType(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNoiseType\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("noise_texture_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseTextureSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseTextureSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNoiseTextureSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("noise_grain_size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseGrainSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseGrainSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNoiseGrainSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("min_noise_value"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMinNoiseValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMinNoiseValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMinNoiseValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("max_noise_value"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetMaxNoiseValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetMaxNoiseValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetMaxNoiseValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("impulse_noise_probability"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetImpulseNoiseProbability(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetImpulseNoiseProbability(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetImpulseNoiseProbability\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("impulse_noise_background_value"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetImpulseNoiseBackgroundValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetImpulseNoiseBackgroundValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetImpulseNoiseBackgroundValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("noise_generator_seed"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseGeneratorSeed(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNoiseGeneratorSeed(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNoiseGeneratorSeed\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("composite_strategy"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetCompositeStrategy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetCompositeStrategy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetCompositeStrategy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_steps"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNumberOfSteps(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNumberOfSteps(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfSteps\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_noise_levels"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSurfaceLICRepresentation_SetNumberOfNoiseLevels(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSurfaceLICRepresentation_SetNumberOfNoiseLevels(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetNumberOfNoiseLevels\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSurfaceLICRepresentation_Doc =
  "vtkSurfaceLICRepresentation\n\n"
  "Superclass: vtkGeometryRepresentationWithFaces\n\n"
  "vtkSurfaceLICRepresentation extends vtkGeometryRepresentation to use\n"
  "surface lic when rendering surfaces.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSurfaceLICRepresentation_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSurfaceLICRepresentation", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSurfaceLICRepresentation_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSurfaceLICRepresentation_StaticNew()
{
  return vtkSurfaceLICRepresentation::New();
}

PyObject *PyvtkSurfaceLICRepresentation_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSurfaceLICRepresentation_Type, PyvtkSurfaceLICRepresentation_Methods,
    "vtkSurfaceLICRepresentation",
 &PyvtkSurfaceLICRepresentation_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkGeometryRepresentationWithFaces_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSurfaceLICRepresentation_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSurfaceLICRepresentation(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSurfaceLICRepresentation_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSurfaceLICRepresentation", o) != 0)
  {
    Py_DECREF(o);
  }

}

