// components/services/storage/public/mojom/quota_client.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/public/mojom/quota_client.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/public/mojom/quota_client.mojom-params-data.h"
#include "components/services/storage/public/mojom/quota_client.mojom-shared-message-ids.h"

#include "components/services/storage/public/mojom/quota_client.mojom-import-headers.h"
#include "components/services/storage/public/mojom/quota_client.mojom-test-utils.h"


namespace storage::mojom {
const char QuotaClient::Name_[] = "storage.mojom.QuotaClient";

QuotaClient::IPCStableHashFunction QuotaClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::QuotaClient>(message.name())) {
    case messages::QuotaClient::kGetBucketUsage: {
      return &QuotaClient::GetBucketUsage_Sym::IPCStableHash;
    }
    case messages::QuotaClient::kGetStorageKeysForType: {
      return &QuotaClient::GetStorageKeysForType_Sym::IPCStableHash;
    }
    case messages::QuotaClient::kDeleteBucketData: {
      return &QuotaClient::DeleteBucketData_Sym::IPCStableHash;
    }
    case messages::QuotaClient::kPerformStorageCleanup: {
      return &QuotaClient::PerformStorageCleanup_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* QuotaClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::QuotaClient>(message.name())) {
      case messages::QuotaClient::kGetBucketUsage:
            return "Receive storage::mojom::QuotaClient::GetBucketUsage";
      case messages::QuotaClient::kGetStorageKeysForType:
            return "Receive storage::mojom::QuotaClient::GetStorageKeysForType";
      case messages::QuotaClient::kDeleteBucketData:
            return "Receive storage::mojom::QuotaClient::DeleteBucketData";
      case messages::QuotaClient::kPerformStorageCleanup:
            return "Receive storage::mojom::QuotaClient::PerformStorageCleanup";
    }
  } else {
    switch (static_cast<messages::QuotaClient>(message.name())) {
      case messages::QuotaClient::kGetBucketUsage:
            return "Receive reply storage::mojom::QuotaClient::GetBucketUsage";
      case messages::QuotaClient::kGetStorageKeysForType:
            return "Receive reply storage::mojom::QuotaClient::GetStorageKeysForType";
      case messages::QuotaClient::kDeleteBucketData:
            return "Receive reply storage::mojom::QuotaClient::DeleteBucketData";
      case messages::QuotaClient::kPerformStorageCleanup:
            return "Receive reply storage::mojom::QuotaClient::PerformStorageCleanup";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t QuotaClient::GetBucketUsage_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaClient::GetBucketUsage");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaClient::GetStorageKeysForType_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaClient::GetStorageKeysForType");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaClient::DeleteBucketData_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaClient::DeleteBucketData");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t QuotaClient::PerformStorageCleanup_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)storage::mojom::QuotaClient::PerformStorageCleanup");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class QuotaClient_GetBucketUsage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetBucketUsage_ForwardToCallback(
      QuotaClient::GetBucketUsageCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaClient_GetBucketUsage_ForwardToCallback(const QuotaClient_GetBucketUsage_ForwardToCallback&) = delete;
  QuotaClient_GetBucketUsage_ForwardToCallback& operator=(const QuotaClient_GetBucketUsage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetBucketUsageCallback callback_;
};

class QuotaClient_GetStorageKeysForType_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_GetStorageKeysForType_ForwardToCallback(
      QuotaClient::GetStorageKeysForTypeCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaClient_GetStorageKeysForType_ForwardToCallback(const QuotaClient_GetStorageKeysForType_ForwardToCallback&) = delete;
  QuotaClient_GetStorageKeysForType_ForwardToCallback& operator=(const QuotaClient_GetStorageKeysForType_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::GetStorageKeysForTypeCallback callback_;
};

class QuotaClient_DeleteBucketData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_DeleteBucketData_ForwardToCallback(
      QuotaClient::DeleteBucketDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaClient_DeleteBucketData_ForwardToCallback(const QuotaClient_DeleteBucketData_ForwardToCallback&) = delete;
  QuotaClient_DeleteBucketData_ForwardToCallback& operator=(const QuotaClient_DeleteBucketData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::DeleteBucketDataCallback callback_;
};

class QuotaClient_PerformStorageCleanup_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  QuotaClient_PerformStorageCleanup_ForwardToCallback(
      QuotaClient::PerformStorageCleanupCallback callback
      ) : callback_(std::move(callback)) {
  }

  QuotaClient_PerformStorageCleanup_ForwardToCallback(const QuotaClient_PerformStorageCleanup_ForwardToCallback&) = delete;
  QuotaClient_PerformStorageCleanup_ForwardToCallback& operator=(const QuotaClient_PerformStorageCleanup_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  QuotaClient::PerformStorageCleanupCallback callback_;
};

QuotaClientProxy::QuotaClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void QuotaClientProxy::GetBucketUsage(
    const ::storage::BucketLocator& in_bucket, GetBucketUsageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaClient::GetBucketUsage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket"), in_bucket,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kGetBucketUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetBucketUsage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket)::BaseType> bucket_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket, bucket_fragment);
  params->bucket.Set(
      bucket_fragment.is_null() ? nullptr : bucket_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket in QuotaClient.GetBucketUsage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetBucketUsage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetBucketUsage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaClientProxy::GetStorageKeysForType(
    ::blink::mojom::StorageType in_type, GetStorageKeysForTypeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaClient::GetStorageKeysForType", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kGetStorageKeysForType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForType_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForType");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_GetStorageKeysForType_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaClientProxy::DeleteBucketData(
    const ::storage::BucketLocator& in_bucket, DeleteBucketDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaClient::DeleteBucketData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bucket"), in_bucket,
                        "<value of type const ::storage::BucketLocator&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kDeleteBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteBucketData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bucket)::BaseType> bucket_fragment(
          params.message());
  mojo::internal::Serialize<::storage::mojom::BucketLocatorDataView>(
      in_bucket, bucket_fragment);
  params->bucket.Set(
      bucket_fragment.is_null() ? nullptr : bucket_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bucket.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bucket in QuotaClient.DeleteBucketData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteBucketData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_DeleteBucketData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void QuotaClientProxy::PerformStorageCleanup(
    ::blink::mojom::StorageType in_type, PerformStorageCleanupCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send storage::mojom::QuotaClient::PerformStorageCleanup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::blink::mojom::StorageType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kPerformStorageCleanup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::StorageType>(
      in_type, &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new QuotaClient_PerformStorageCleanup_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class QuotaClient_GetBucketUsage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaClient::GetBucketUsageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaClient_GetBucketUsage_ProxyToResponder> proxy(
        new QuotaClient_GetBucketUsage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaClient_GetBucketUsage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetBucketUsage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaClient_GetBucketUsage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetBucketUsageCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int64_t in_usage);
};

bool QuotaClient_GetBucketUsage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaClient_GetBucketUsage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetBucketUsage_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for QuotaClient.0
  bool success = true;
  int64_t p_usage{};
  QuotaClient_GetBucketUsage_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_usage = input_data_view.usage();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_usage));
  return true;
}

void QuotaClient_GetBucketUsage_ProxyToResponder::Run(
    int64_t in_usage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaClient::GetBucketUsage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("usage"), in_usage,
                        "<value of type int64_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kGetBucketUsage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetBucketUsage_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->usage = in_usage;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetBucketUsage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_GetStorageKeysForType_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaClient::GetStorageKeysForTypeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaClient_GetStorageKeysForType_ProxyToResponder> proxy(
        new QuotaClient_GetStorageKeysForType_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaClient_GetStorageKeysForType_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_GetStorageKeysForType_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaClient_GetStorageKeysForType_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::GetStorageKeysForTypeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::blink::StorageKey>& in_storage_keys);
};

bool QuotaClient_GetStorageKeysForType_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for QuotaClient.1
  bool success = true;
  std::vector<::blink::StorageKey> p_storage_keys{};
  QuotaClient_GetStorageKeysForType_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStorageKeys(&p_storage_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_storage_keys));
  return true;
}

void QuotaClient_GetStorageKeysForType_ProxyToResponder::Run(
    const std::vector<::blink::StorageKey>& in_storage_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaClient::GetStorageKeysForType", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_keys"), in_storage_keys,
                        "<value of type const std::vector<::blink::StorageKey>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kGetStorageKeysForType), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->storage_keys)::BaseType>
      storage_keys_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& storage_keys_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::StorageKeyDataView>>(
      in_storage_keys, storage_keys_fragment, &storage_keys_validate_params);
  params->storage_keys.Set(
      storage_keys_fragment.is_null() ? nullptr : storage_keys_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->storage_keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null storage_keys in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("GetStorageKeysForType");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_DeleteBucketData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaClient::DeleteBucketDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaClient_DeleteBucketData_ProxyToResponder> proxy(
        new QuotaClient_DeleteBucketData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaClient_DeleteBucketData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_DeleteBucketData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaClient_DeleteBucketData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::DeleteBucketDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::QuotaStatusCode in_status);
};

bool QuotaClient_DeleteBucketData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaClient_DeleteBucketData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_DeleteBucketData_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for QuotaClient.2
  bool success = true;
  ::blink::mojom::QuotaStatusCode p_status{};
  QuotaClient_DeleteBucketData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status));
  return true;
}

void QuotaClient_DeleteBucketData_ProxyToResponder::Run(
    ::blink::mojom::QuotaStatusCode in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply storage::mojom::QuotaClient::DeleteBucketData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::QuotaStatusCode>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kDeleteBucketData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_DeleteBucketData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::QuotaStatusCode>(
      in_status, &params->status);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("DeleteBucketData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class QuotaClient_PerformStorageCleanup_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static QuotaClient::PerformStorageCleanupCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<QuotaClient_PerformStorageCleanup_ProxyToResponder> proxy(
        new QuotaClient_PerformStorageCleanup_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&QuotaClient_PerformStorageCleanup_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~QuotaClient_PerformStorageCleanup_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  QuotaClient_PerformStorageCleanup_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "QuotaClient::PerformStorageCleanupCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool QuotaClient_PerformStorageCleanup_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data* params =
      reinterpret_cast<
          internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for QuotaClient.3
  bool success = true;
  QuotaClient_PerformStorageCleanup_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        QuotaClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void QuotaClient_PerformStorageCleanup_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply storage::mojom::QuotaClient::PerformStorageCleanup");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::QuotaClient::kPerformStorageCleanup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::storage::mojom::internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(QuotaClient::Name_);
  message.set_method_name("PerformStorageCleanup");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool QuotaClientStubDispatch::Accept(
    QuotaClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::QuotaClient>(message->header()->name)) {
    case messages::QuotaClient::kGetBucketUsage: {
      break;
    }
    case messages::QuotaClient::kGetStorageKeysForType: {
      break;
    }
    case messages::QuotaClient::kDeleteBucketData: {
      break;
    }
    case messages::QuotaClient::kPerformStorageCleanup: {
      break;
    }
  }
  return false;
}

// static
bool QuotaClientStubDispatch::AcceptWithResponder(
    QuotaClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::QuotaClient>(message->header()->name)) {
    case messages::QuotaClient::kGetBucketUsage: {
      internal::QuotaClient_GetBucketUsage_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetBucketUsage_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for QuotaClient.0
      bool success = true;
      ::storage::BucketLocator p_bucket{};
      QuotaClient_GetBucketUsage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucket(&p_bucket))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 0, false);
        return false;
      }
      QuotaClient::GetBucketUsageCallback callback =
          QuotaClient_GetBucketUsage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetBucketUsage(        
        std::move(p_bucket), std::move(callback));
      return true;
    }
    case messages::QuotaClient::kGetStorageKeysForType: {
      internal::QuotaClient_GetStorageKeysForType_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_GetStorageKeysForType_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for QuotaClient.1
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_GetStorageKeysForType_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 1, false);
        return false;
      }
      QuotaClient::GetStorageKeysForTypeCallback callback =
          QuotaClient_GetStorageKeysForType_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetStorageKeysForType(        
        std::move(p_type), std::move(callback));
      return true;
    }
    case messages::QuotaClient::kDeleteBucketData: {
      internal::QuotaClient_DeleteBucketData_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_DeleteBucketData_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for QuotaClient.2
      bool success = true;
      ::storage::BucketLocator p_bucket{};
      QuotaClient_DeleteBucketData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadBucket(&p_bucket))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 2, false);
        return false;
      }
      QuotaClient::DeleteBucketDataCallback callback =
          QuotaClient_DeleteBucketData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteBucketData(        
        std::move(p_bucket), std::move(callback));
      return true;
    }
    case messages::QuotaClient::kPerformStorageCleanup: {
      internal::QuotaClient_PerformStorageCleanup_Params_Data* params =
          reinterpret_cast<
              internal::QuotaClient_PerformStorageCleanup_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for QuotaClient.3
      bool success = true;
      ::blink::mojom::StorageType p_type{};
      QuotaClient_PerformStorageCleanup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            QuotaClient::Name_, 3, false);
        return false;
      }
      QuotaClient::PerformStorageCleanupCallback callback =
          QuotaClient_PerformStorageCleanup_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformStorageCleanup(        
        std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kQuotaClientValidationInfo[] = {
    {base::to_underlying(messages::QuotaClient::kGetBucketUsage),
     { &internal::QuotaClient_GetBucketUsage_Params_Data::Validate,
      &internal::QuotaClient_GetBucketUsage_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::QuotaClient::kGetStorageKeysForType),
     { &internal::QuotaClient_GetStorageKeysForType_Params_Data::Validate,
      &internal::QuotaClient_GetStorageKeysForType_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::QuotaClient::kDeleteBucketData),
     { &internal::QuotaClient_DeleteBucketData_Params_Data::Validate,
      &internal::QuotaClient_DeleteBucketData_ResponseParams_Data::Validate}},
    {base::to_underlying(messages::QuotaClient::kPerformStorageCleanup),
     { &internal::QuotaClient_PerformStorageCleanup_Params_Data::Validate,
      &internal::QuotaClient_PerformStorageCleanup_ResponseParams_Data::Validate}},
};

bool QuotaClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kQuotaClientValidationInfo);
}

bool QuotaClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::storage::mojom::QuotaClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kQuotaClientValidationInfo);

}


}  // storage::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {


void QuotaClientInterceptorForTesting::GetBucketUsage(const ::storage::BucketLocator& bucket, GetBucketUsageCallback callback) {
  GetForwardingInterface()->GetBucketUsage(
    std::move(bucket)
    , std::move(callback));
}
void QuotaClientInterceptorForTesting::GetStorageKeysForType(::blink::mojom::StorageType type, GetStorageKeysForTypeCallback callback) {
  GetForwardingInterface()->GetStorageKeysForType(
    std::move(type)
    , std::move(callback));
}
void QuotaClientInterceptorForTesting::DeleteBucketData(const ::storage::BucketLocator& bucket, DeleteBucketDataCallback callback) {
  GetForwardingInterface()->DeleteBucketData(
    std::move(bucket)
    , std::move(callback));
}
void QuotaClientInterceptorForTesting::PerformStorageCleanup(::blink::mojom::StorageType type, PerformStorageCleanupCallback callback) {
  GetForwardingInterface()->PerformStorageCleanup(
    std::move(type)
    , std::move(callback));
}
QuotaClientAsyncWaiter::QuotaClientAsyncWaiter(
    QuotaClient* proxy) : proxy_(proxy) {}

QuotaClientAsyncWaiter::~QuotaClientAsyncWaiter() = default;

void QuotaClientAsyncWaiter::GetBucketUsage(
    const ::storage::BucketLocator& bucket, int64_t* out_usage) {
  base::RunLoop loop;
  proxy_->GetBucketUsage(
      std::move(bucket),
      base::BindOnce(
          [](base::RunLoop* loop,
             int64_t* out_usage
,
             int64_t usage) {*out_usage = std::move(usage);
            loop->Quit();
          },
          &loop,
          out_usage));
  loop.Run();
}

int64_t QuotaClientAsyncWaiter::GetBucketUsage(
    const ::storage::BucketLocator& bucket) {
  int64_t async_wait_result;
  GetBucketUsage(std::move(bucket),&async_wait_result);
  return async_wait_result;
}

void QuotaClientAsyncWaiter::GetStorageKeysForType(
    ::blink::mojom::StorageType type, std::vector<::blink::StorageKey>* out_storage_keys) {
  base::RunLoop loop;
  proxy_->GetStorageKeysForType(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::blink::StorageKey>* out_storage_keys
,
             const std::vector<::blink::StorageKey>& storage_keys) {*out_storage_keys = std::move(storage_keys);
            loop->Quit();
          },
          &loop,
          out_storage_keys));
  loop.Run();
}

std::vector<::blink::StorageKey> QuotaClientAsyncWaiter::GetStorageKeysForType(
    ::blink::mojom::StorageType type) {
  std::vector<::blink::StorageKey> async_wait_result;
  GetStorageKeysForType(std::move(type),&async_wait_result);
  return async_wait_result;
}

void QuotaClientAsyncWaiter::DeleteBucketData(
    const ::storage::BucketLocator& bucket, ::blink::mojom::QuotaStatusCode* out_status) {
  base::RunLoop loop;
  proxy_->DeleteBucketData(
      std::move(bucket),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::QuotaStatusCode* out_status
,
             ::blink::mojom::QuotaStatusCode status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::blink::mojom::QuotaStatusCode QuotaClientAsyncWaiter::DeleteBucketData(
    const ::storage::BucketLocator& bucket) {
  ::blink::mojom::QuotaStatusCode async_wait_result;
  DeleteBucketData(std::move(bucket),&async_wait_result);
  return async_wait_result;
}

void QuotaClientAsyncWaiter::PerformStorageCleanup(
    ::blink::mojom::StorageType type) {
  base::RunLoop loop;
  proxy_->PerformStorageCleanup(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif