// components/web_cache/public/mojom/web_cache.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_WEB_CACHE_PUBLIC_MOJOM_WEB_CACHE_MOJOM_H_
#define COMPONENTS_WEB_CACHE_PUBLIC_MOJOM_WEB_CACHE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/web_cache/public/mojom/web_cache.mojom-features.h"  // IWYU pragma: export
#include "components/web_cache/public/mojom/web_cache.mojom-shared.h"  // IWYU pragma: export
#include "components/web_cache/public/mojom/web_cache.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace web_cache::mojom {

class WebCacheProxy;

template <typename ImplRefTraits>
class WebCacheStub;

class WebCacheRequestValidator;


class WebCache
    : public WebCacheInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebCacheInterfaceBase;
  using Proxy_ = WebCacheProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebCacheStub<ImplRefTraits>;

  using RequestValidator_ = WebCacheRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kClearCacheMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ClearCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebCache() = default;

  
  virtual void ClearCache(bool on_navigation) = 0;
};



class  WebCacheProxy
    : public WebCache {
 public:
  using InterfaceType = WebCache;

  explicit WebCacheProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ClearCache(bool on_navigation) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebCacheStubDispatch {
 public:
  static bool Accept(WebCache* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebCache* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebCache>>
class WebCacheStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebCacheStub() = default;
  ~WebCacheStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebCacheStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebCacheStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebCacheRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // web_cache::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_WEB_CACHE_PUBLIC_MOJOM_WEB_CACHE_MOJOM_H_