// media/mojo/mojom/renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "media/mojo/mojom/renderer.mojom-shared-internal.h"
#include "media/mojo/mojom/demuxer_stream.mojom-shared.h"
#include "media/mojo/mojom/media_types.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/storage_access_api.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace media::mojom {
class MediaUrlParamsDataView;



}  // media::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::MediaUrlParamsDataView> {
  using Data = ::media::mojom::internal::MediaUrlParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media::mojom {
// Interface base classes. They are used for type safety check.
class RendererInterfaceBase {};

using RendererPtrDataView =
    mojo::InterfacePtrDataView<RendererInterfaceBase>;
using RendererRequestDataView =
    mojo::InterfaceRequestDataView<RendererInterfaceBase>;
using RendererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererInterfaceBase>;
using RendererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererInterfaceBase>;
class RendererClientInterfaceBase {};

using RendererClientPtrDataView =
    mojo::InterfacePtrDataView<RendererClientInterfaceBase>;
using RendererClientRequestDataView =
    mojo::InterfaceRequestDataView<RendererClientInterfaceBase>;
using RendererClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RendererClientInterfaceBase>;
using RendererClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RendererClientInterfaceBase>;


class MediaUrlParamsDataView {
 public:
  MediaUrlParamsDataView() = default;

  MediaUrlParamsDataView(
      internal::MediaUrlParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaUrl(UserType* output) {
    
    auto* pointer = data_->media_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStorageAccessApiStatus(UserType* output) const {
    auto data_value = data_->storage_access_api_status;
    return mojo::internal::Deserialize<::network::mojom::StorageAccessApiStatus>(
        data_value, output);
  }
  ::network::mojom::StorageAccessApiStatus storage_access_api_status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::StorageAccessApiStatus>(data_->storage_access_api_status));
  }
  bool allow_credentials() const {
    return data_->allow_credentials;
  }
  bool is_hls() const {
    return data_->is_hls;
  }
  inline void GetHeadersDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHeaders(UserType* output) {
    
    auto* pointer = data_->headers.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaUrlParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::MediaUrlParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::MediaUrlParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media::mojom::internal::MediaUrlParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::media_url(input)) in_media_url = Traits::media_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_url)::BaseType> media_url_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_media_url, media_url_fragment);
    fragment->media_url.Set(
        media_url_fragment.is_null() ? nullptr : media_url_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->media_url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null media_url in MediaUrlParams struct");
    decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
        in_site_for_cookies, site_for_cookies_fragment);
    fragment->site_for_cookies.Set(
        site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site_for_cookies.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in MediaUrlParams struct");
    decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
            fragment.message());
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
        in_top_frame_origin, top_frame_origin_fragment);
    fragment->top_frame_origin.Set(
        top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->top_frame_origin.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_origin in MediaUrlParams struct");
    mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
        Traits::storage_access_api_status(input), &fragment->storage_access_api_status);
    fragment->allow_credentials = Traits::allow_credentials(input);
    fragment->is_hls = Traits::is_hls(input);
    decltype(Traits::headers(input)) in_headers = Traits::headers(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->headers)::BaseType>
        headers_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        in_headers, headers_fragment, &headers_validate_params);
    fragment->headers.Set(
        headers_fragment.is_null() ? nullptr : headers_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null headers in MediaUrlParams struct");
  }

  static bool Deserialize(::media::mojom::internal::MediaUrlParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::MediaUrlParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media::mojom {

inline void MediaUrlParamsDataView::GetMediaUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->media_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void MediaUrlParamsDataView::GetSiteForCookiesDataView(
    ::network::mojom::SiteForCookiesDataView* output) {
  auto pointer = data_->site_for_cookies.Get();
  *output = ::network::mojom::SiteForCookiesDataView(pointer, message_);
}
inline void MediaUrlParamsDataView::GetTopFrameOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->top_frame_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void MediaUrlParamsDataView::GetHeadersDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->headers.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}



}  // media::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // MEDIA_MOJO_MOJOM_RENDERER_MOJOM_SHARED_H_