// services/device/public/mojom/sensor_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/sensor_provider.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/sensor_provider.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/sensor_provider.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "services/device/public/mojom/sensor.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class SensorProviderProxy;

template <typename ImplRefTraits>
class SensorProviderStub;

class SensorProviderRequestValidator;
class SensorProviderResponseValidator;


class SensorProvider
    : public SensorProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SensorProviderInterfaceBase;
  using Proxy_ = SensorProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = SensorProviderStub<ImplRefTraits>;

  using RequestValidator_ = SensorProviderRequestValidator;
  using ResponseValidator_ = SensorProviderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetSensorMinVersion = 0,
    kCreateVirtualSensorMinVersion = 0,
    kUpdateVirtualSensorMinVersion = 0,
    kRemoveVirtualSensorMinVersion = 0,
    kGetVirtualSensorInformationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetSensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateVirtualSensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateVirtualSensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveVirtualSensor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetVirtualSensorInformation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SensorProvider() = default;


  using GetSensorCallback = base::OnceCallback<void(SensorCreationResult, SensorInitParamsPtr)>;
  
  virtual void GetSensor(::device::mojom::SensorType type, GetSensorCallback callback) = 0;


  using CreateVirtualSensorCallback = base::OnceCallback<void(CreateVirtualSensorResult)>;
  
  virtual void CreateVirtualSensor(::device::mojom::SensorType type, VirtualSensorMetadataPtr metadata, CreateVirtualSensorCallback callback) = 0;


  using UpdateVirtualSensorCallback = base::OnceCallback<void(UpdateVirtualSensorResult)>;
  
  virtual void UpdateVirtualSensor(::device::mojom::SensorType type, const ::device::SensorReading& reading, UpdateVirtualSensorCallback callback) = 0;


  using RemoveVirtualSensorCallback = base::OnceCallback<void()>;
  
  virtual void RemoveVirtualSensor(::device::mojom::SensorType type, RemoveVirtualSensorCallback callback) = 0;


  using GetVirtualSensorInformationCallback = base::OnceCallback<void(GetVirtualSensorInformationResultPtr)>;
  
  virtual void GetVirtualSensorInformation(::device::mojom::SensorType type, GetVirtualSensorInformationCallback callback) = 0;
};



class  SensorProviderProxy
    : public SensorProvider {
 public:
  using InterfaceType = SensorProvider;

  explicit SensorProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetSensor(::device::mojom::SensorType type, GetSensorCallback callback) final;
  
  void CreateVirtualSensor(::device::mojom::SensorType type, VirtualSensorMetadataPtr metadata, CreateVirtualSensorCallback callback) final;
  
  void UpdateVirtualSensor(::device::mojom::SensorType type, const ::device::SensorReading& reading, UpdateVirtualSensorCallback callback) final;
  
  void RemoveVirtualSensor(::device::mojom::SensorType type, RemoveVirtualSensorCallback callback) final;
  
  void GetVirtualSensorInformation(::device::mojom::SensorType type, GetVirtualSensorInformationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SensorProviderStubDispatch {
 public:
  static bool Accept(SensorProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SensorProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SensorProvider>>
class SensorProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SensorProviderStub() = default;
  ~SensorProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SensorProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SensorProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SensorProviderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  VirtualSensorMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VirtualSensorMetadata, T>::value>;
  using DataView = VirtualSensorMetadataDataView;
  using Data_ = internal::VirtualSensorMetadata_Data;

  template <typename... Args>
  static VirtualSensorMetadataPtr New(Args&&... args) {
    return VirtualSensorMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VirtualSensorMetadataPtr From(const U& u) {
    return mojo::TypeConverter<VirtualSensorMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VirtualSensorMetadata>::Convert(*this);
  }


  VirtualSensorMetadata();

  VirtualSensorMetadata(
      bool available,
      std::optional<double> maximum_frequency,
      std::optional<double> minimum_frequency,
      std::optional<::device::mojom::ReportingMode> reporting_mode);


  ~VirtualSensorMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VirtualSensorMetadataPtr>
  VirtualSensorMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VirtualSensorMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VirtualSensorMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VirtualSensorMetadata_UnserializedMessageContext<
            UserType, VirtualSensorMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VirtualSensorMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VirtualSensorMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VirtualSensorMetadata_UnserializedMessageContext<
            UserType, VirtualSensorMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VirtualSensorMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool available;
  
  std::optional<double> maximum_frequency;
  
  std::optional<double> minimum_frequency;
  
  std::optional<::device::mojom::ReportingMode> reporting_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VirtualSensorMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  VirtualSensorInformation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<VirtualSensorInformation, T>::value>;
  using DataView = VirtualSensorInformationDataView;
  using Data_ = internal::VirtualSensorInformation_Data;

  template <typename... Args>
  static VirtualSensorInformationPtr New(Args&&... args) {
    return VirtualSensorInformationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static VirtualSensorInformationPtr From(const U& u) {
    return mojo::TypeConverter<VirtualSensorInformationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, VirtualSensorInformation>::Convert(*this);
  }


  VirtualSensorInformation();

  explicit VirtualSensorInformation(
      double sampling_frequency);


  ~VirtualSensorInformation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = VirtualSensorInformationPtr>
  VirtualSensorInformationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;
  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        VirtualSensorInformation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        VirtualSensorInformation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::VirtualSensorInformation_UnserializedMessageContext<
            UserType, VirtualSensorInformation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<VirtualSensorInformation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return VirtualSensorInformation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::VirtualSensorInformation_UnserializedMessageContext<
            UserType, VirtualSensorInformation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<VirtualSensorInformation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double sampling_frequency;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, VirtualSensorInformation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GetVirtualSensorInformationResult {
 public:
  using DataView = GetVirtualSensorInformationResultDataView;
  using Data_ = internal::GetVirtualSensorInformationResult_Data;
  using Tag = Data_::GetVirtualSensorInformationResult_Tag;

  template <typename... Args>
  static GetVirtualSensorInformationResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }
  // Construct an instance holding |info|.
  static GetVirtualSensorInformationResultPtr
  NewInfo(
      VirtualSensorInformationPtr value) {
    auto result = GetVirtualSensorInformationResultPtr(std::in_place);
    result->set_info(std::move(value));
    return result;
  }
  // Construct an instance holding |error|.
  static GetVirtualSensorInformationResultPtr
  NewError(
      GetVirtualSensorInformationError value) {
    auto result = GetVirtualSensorInformationResultPtr(std::in_place);
    result->set_error(std::move(value));
    return result;
  }

  template <typename U>
  static GetVirtualSensorInformationResultPtr From(const U& u) {
    return mojo::TypeConverter<GetVirtualSensorInformationResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetVirtualSensorInformationResult>::Convert(*this);
  }

  GetVirtualSensorInformationResult();
  ~GetVirtualSensorInformationResult();
  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetVirtualSensorInformationResult(const GetVirtualSensorInformationResult& other) = delete;
  GetVirtualSensorInformationResult& operator=(const GetVirtualSensorInformationResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetVirtualSensorInformationResultPtr>
  GetVirtualSensorInformationResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetVirtualSensorInformationResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetVirtualSensorInformationResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_info() const { return tag_ == Tag::kInfo; }

  
  VirtualSensorInformationPtr& get_info() const {
    CHECK(tag_ == Tag::kInfo);
    return *(data_.info);
  }

  
  void set_info(
      VirtualSensorInformationPtr info);
  
  bool is_error() const { return tag_ == Tag::kError; }

  
  GetVirtualSensorInformationError get_error() const {
    CHECK(tag_ == Tag::kError);
    return data_.error;
  }

  
  void set_error(
      GetVirtualSensorInformationError error);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetVirtualSensorInformationResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetVirtualSensorInformationResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  union Union_ {
    Union_() = default;
    ~Union_() = default;
    VirtualSensorInformationPtr* info;
    GetVirtualSensorInformationError error;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  SensorInitParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SensorInitParams, T>::value>;
  using DataView = SensorInitParamsDataView;
  using Data_ = internal::SensorInitParams_Data;
  
  static constexpr uint64_t kReadBufferSizeForTests = 48ULL;

  template <typename... Args>
  static SensorInitParamsPtr New(Args&&... args) {
    return SensorInitParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SensorInitParamsPtr From(const U& u) {
    return mojo::TypeConverter<SensorInitParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SensorInitParams>::Convert(*this);
  }


  SensorInitParams();

  SensorInitParams(
      ::mojo::PendingRemote<::device::mojom::Sensor> sensor,
      ::mojo::PendingReceiver<::device::mojom::SensorClient> client_receiver,
      ::base::ReadOnlySharedMemoryRegion memory,
      uint64_t buffer_offset,
      ::device::mojom::ReportingMode mode,
      const ::device::PlatformSensorConfiguration& default_configuration,
      double maximum_frequency,
      double minimum_frequency);

SensorInitParams(const SensorInitParams&) = delete;
SensorInitParams& operator=(const SensorInitParams&) = delete;

  ~SensorInitParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SensorInitParamsPtr>
  SensorInitParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SensorInitParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SensorInitParams_UnserializedMessageContext<
            UserType, SensorInitParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SensorInitParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SensorInitParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SensorInitParams_UnserializedMessageContext<
            UserType, SensorInitParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SensorInitParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::device::mojom::Sensor> sensor;
  
  ::mojo::PendingReceiver<::device::mojom::SensorClient> client_receiver;
  
  ::base::ReadOnlySharedMemoryRegion memory;
  
  uint64_t buffer_offset;
  
  ::device::mojom::ReportingMode mode;
  
  ::device::PlatformSensorConfiguration default_configuration;
  
  double maximum_frequency;
  
  double minimum_frequency;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SensorInitParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}



template <typename UnionPtrType>
GetVirtualSensorInformationResultPtr GetVirtualSensorInformationResult::Clone() const {
  switch (tag_) {
    case Tag::kInfo:
      return NewInfo(
          mojo::Clone(*data_.info));
    case Tag::kError:
      return NewError(
          mojo::Clone(data_.error));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetVirtualSensorInformationResult>::value>::type*>
bool GetVirtualSensorInformationResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInfo:
      return mojo::Equals(*(data_.info), *(other.data_.info));
    case Tag::kError:
      return mojo::Equals(data_.error, other.data_.error);
  }

  return false;
}
template <typename StructPtrType>
SensorInitParamsPtr SensorInitParams::Clone() const {
  return New(
      mojo::Clone(sensor),
      mojo::Clone(client_receiver),
      mojo::Clone(memory),
      mojo::Clone(buffer_offset),
      mojo::Clone(mode),
      mojo::Clone(default_configuration),
      mojo::Clone(maximum_frequency),
      mojo::Clone(minimum_frequency)
  );
}

template <typename T, SensorInitParams::EnableIfSame<T>*>
bool SensorInitParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sensor, other_struct.sensor))
    return false;
  if (!mojo::Equals(this->client_receiver, other_struct.client_receiver))
    return false;
  if (!mojo::Equals(this->memory, other_struct.memory))
    return false;
  if (!mojo::Equals(this->buffer_offset, other_struct.buffer_offset))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  if (!mojo::Equals(this->default_configuration, other_struct.default_configuration))
    return false;
  if (!mojo::Equals(this->maximum_frequency, other_struct.maximum_frequency))
    return false;
  if (!mojo::Equals(this->minimum_frequency, other_struct.minimum_frequency))
    return false;
  return true;
}

template <typename T, SensorInitParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sensor < rhs.sensor)
    return true;
  if (rhs.sensor < lhs.sensor)
    return false;
  if (lhs.client_receiver < rhs.client_receiver)
    return true;
  if (rhs.client_receiver < lhs.client_receiver)
    return false;
  if (lhs.memory < rhs.memory)
    return true;
  if (rhs.memory < lhs.memory)
    return false;
  if (lhs.buffer_offset < rhs.buffer_offset)
    return true;
  if (rhs.buffer_offset < lhs.buffer_offset)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  if (lhs.default_configuration < rhs.default_configuration)
    return true;
  if (rhs.default_configuration < lhs.default_configuration)
    return false;
  if (lhs.maximum_frequency < rhs.maximum_frequency)
    return true;
  if (rhs.maximum_frequency < lhs.maximum_frequency)
    return false;
  if (lhs.minimum_frequency < rhs.minimum_frequency)
    return true;
  if (rhs.minimum_frequency < lhs.minimum_frequency)
    return false;
  return false;
}
template <typename StructPtrType>
VirtualSensorMetadataPtr VirtualSensorMetadata::Clone() const {
  return New(
      mojo::Clone(available),
      mojo::Clone(maximum_frequency),
      mojo::Clone(minimum_frequency),
      mojo::Clone(reporting_mode)
  );
}

template <typename T, VirtualSensorMetadata::EnableIfSame<T>*>
bool VirtualSensorMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->available, other_struct.available))
    return false;
  if (!mojo::Equals(this->maximum_frequency, other_struct.maximum_frequency))
    return false;
  if (!mojo::Equals(this->minimum_frequency, other_struct.minimum_frequency))
    return false;
  if (!mojo::Equals(this->reporting_mode, other_struct.reporting_mode))
    return false;
  return true;
}

template <typename T, VirtualSensorMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.available < rhs.available)
    return true;
  if (rhs.available < lhs.available)
    return false;
  if (lhs.maximum_frequency < rhs.maximum_frequency)
    return true;
  if (rhs.maximum_frequency < lhs.maximum_frequency)
    return false;
  if (lhs.minimum_frequency < rhs.minimum_frequency)
    return true;
  if (rhs.minimum_frequency < lhs.minimum_frequency)
    return false;
  if (lhs.reporting_mode < rhs.reporting_mode)
    return true;
  if (rhs.reporting_mode < lhs.reporting_mode)
    return false;
  return false;
}
template <typename StructPtrType>
VirtualSensorInformationPtr VirtualSensorInformation::Clone() const {
  return New(
      mojo::Clone(sampling_frequency)
  );
}

template <typename T, VirtualSensorInformation::EnableIfSame<T>*>
bool VirtualSensorInformation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sampling_frequency, other_struct.sampling_frequency))
    return false;
  return true;
}

template <typename T, VirtualSensorInformation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sampling_frequency < rhs.sampling_frequency)
    return true;
  if (rhs.sampling_frequency < lhs.sampling_frequency)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::SensorInitParams::DataView,
                                         ::device::mojom::SensorInitParamsPtr> {
  static bool IsNull(const ::device::mojom::SensorInitParamsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::SensorInitParamsPtr* output) { output->reset(); }

  static  decltype(::device::mojom::SensorInitParams::sensor)& sensor(
       ::device::mojom::SensorInitParamsPtr& input) {
    return input->sensor;
  }

  static  decltype(::device::mojom::SensorInitParams::client_receiver)& client_receiver(
       ::device::mojom::SensorInitParamsPtr& input) {
    return input->client_receiver;
  }

  static  decltype(::device::mojom::SensorInitParams::memory)& memory(
       ::device::mojom::SensorInitParamsPtr& input) {
    return input->memory;
  }

  static decltype(::device::mojom::SensorInitParams::buffer_offset) buffer_offset(
      const ::device::mojom::SensorInitParamsPtr& input) {
    return input->buffer_offset;
  }

  static decltype(::device::mojom::SensorInitParams::mode) mode(
      const ::device::mojom::SensorInitParamsPtr& input) {
    return input->mode;
  }

  static const decltype(::device::mojom::SensorInitParams::default_configuration)& default_configuration(
      const ::device::mojom::SensorInitParamsPtr& input) {
    return input->default_configuration;
  }

  static decltype(::device::mojom::SensorInitParams::maximum_frequency) maximum_frequency(
      const ::device::mojom::SensorInitParamsPtr& input) {
    return input->maximum_frequency;
  }

  static decltype(::device::mojom::SensorInitParams::minimum_frequency) minimum_frequency(
      const ::device::mojom::SensorInitParamsPtr& input) {
    return input->minimum_frequency;
  }

  static bool Read(::device::mojom::SensorInitParams::DataView input, ::device::mojom::SensorInitParamsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::VirtualSensorMetadata::DataView,
                                         ::device::mojom::VirtualSensorMetadataPtr> {
  static bool IsNull(const ::device::mojom::VirtualSensorMetadataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::VirtualSensorMetadataPtr* output) { output->reset(); }

  static decltype(::device::mojom::VirtualSensorMetadata::available) available(
      const ::device::mojom::VirtualSensorMetadataPtr& input) {
    return input->available;
  }

  static decltype(::device::mojom::VirtualSensorMetadata::maximum_frequency) maximum_frequency(
      const ::device::mojom::VirtualSensorMetadataPtr& input) {
    return input->maximum_frequency;
  }

  static decltype(::device::mojom::VirtualSensorMetadata::minimum_frequency) minimum_frequency(
      const ::device::mojom::VirtualSensorMetadataPtr& input) {
    return input->minimum_frequency;
  }

  static decltype(::device::mojom::VirtualSensorMetadata::reporting_mode) reporting_mode(
      const ::device::mojom::VirtualSensorMetadataPtr& input) {
    return input->reporting_mode;
  }

  static bool Read(::device::mojom::VirtualSensorMetadata::DataView input, ::device::mojom::VirtualSensorMetadataPtr* output);
};


template <>
struct  StructTraits<::device::mojom::VirtualSensorInformation::DataView,
                                         ::device::mojom::VirtualSensorInformationPtr> {
  static bool IsNull(const ::device::mojom::VirtualSensorInformationPtr& input) { return !input; }
  static void SetToNull(::device::mojom::VirtualSensorInformationPtr* output) { output->reset(); }

  static decltype(::device::mojom::VirtualSensorInformation::sampling_frequency) sampling_frequency(
      const ::device::mojom::VirtualSensorInformationPtr& input) {
    return input->sampling_frequency;
  }

  static bool Read(::device::mojom::VirtualSensorInformation::DataView input, ::device::mojom::VirtualSensorInformationPtr* output);
};


template <>
struct  UnionTraits<::device::mojom::GetVirtualSensorInformationResult::DataView,
                                        ::device::mojom::GetVirtualSensorInformationResultPtr> {
  static bool IsNull(const ::device::mojom::GetVirtualSensorInformationResultPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GetVirtualSensorInformationResultPtr* output) { output->reset(); }

  static ::device::mojom::GetVirtualSensorInformationResult::Tag GetTag(const ::device::mojom::GetVirtualSensorInformationResultPtr& input) {
    return input->which();
  }

  static const ::device::mojom::VirtualSensorInformationPtr& info(const ::device::mojom::GetVirtualSensorInformationResultPtr& input) {
    return input->get_info();
  }

  static  ::device::mojom::GetVirtualSensorInformationError error(const ::device::mojom::GetVirtualSensorInformationResultPtr& input) {
    return input->get_error();
  }

  static bool Read(::device::mojom::GetVirtualSensorInformationResult::DataView input, ::device::mojom::GetVirtualSensorInformationResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_H_