// services/network/public/mojom/network_context.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_context.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_context.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* TrustTokenOperationPolicyVerdictToStringHelper(TrustTokenOperationPolicyVerdict value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TrustTokenOperationPolicyVerdict::kForbid:
      return "kForbid";
    case TrustTokenOperationPolicyVerdict::kPotentiallyPermit:
      return "kPotentiallyPermit";
    default:
      return nullptr;
  }
}

std::string TrustTokenOperationPolicyVerdictToString(TrustTokenOperationPolicyVerdict value) {
  const char *str = TrustTokenOperationPolicyVerdictToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TrustTokenOperationPolicyVerdict value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TrustTokenOperationPolicyVerdict value) {
  return os << TrustTokenOperationPolicyVerdictToString(value);
}

NOINLINE static const char* SCTAuditingModeToStringHelper(SCTAuditingMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SCTAuditingMode::kDisabled:
      return "kDisabled";
    case SCTAuditingMode::kEnhancedSafeBrowsingReporting:
      return "kEnhancedSafeBrowsingReporting";
    case SCTAuditingMode::kHashdance:
      return "kHashdance";
    default:
      return nullptr;
  }
}

std::string SCTAuditingModeToString(SCTAuditingMode value) {
  const char *str = SCTAuditingModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SCTAuditingMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SCTAuditingMode value) {
  return os << SCTAuditingModeToString(value);
}

NOINLINE static const char* NetworkContext_DomainReliabilityClearModeToStringHelper(NetworkContext_DomainReliabilityClearMode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NetworkContext_DomainReliabilityClearMode::CLEAR_CONTEXTS:
      return "CLEAR_CONTEXTS";
    case NetworkContext_DomainReliabilityClearMode::CLEAR_BEACONS:
      return "CLEAR_BEACONS";
    default:
      return nullptr;
  }
}

std::string NetworkContext_DomainReliabilityClearModeToString(NetworkContext_DomainReliabilityClearMode value) {
  const char *str = NetworkContext_DomainReliabilityClearModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NetworkContext_DomainReliabilityClearMode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NetworkContext_DomainReliabilityClearMode value) {
  return os << NetworkContext_DomainReliabilityClearModeToString(value);
}

namespace internal {


// static
bool CustomProxyConfig_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomProxyConfig_Data* object =
      static_cast<const CustomProxyConfig_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->rules, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->rules, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->connect_tunnel_headers, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->connect_tunnel_headers, validation_context))
    return false;

  return true;
}

CustomProxyConfig_Data::CustomProxyConfig_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CertVerifierServiceRemoteParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CertVerifierServiceRemoteParams_Data* object =
      static_cast<const CertVerifierServiceRemoteParams_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->cert_verifier_service,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->cert_verifier_service_client_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CertVerifierServiceRemoteParams_Data::CertVerifierServiceRemoteParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpAuthStaticNetworkContextParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpAuthStaticNetworkContextParams_Data* object =
      static_cast<const HttpAuthStaticNetworkContextParams_Data*>(data);


  if (!::network::mojom::internal::DefaultCredentials_Data
        ::Validate(object->allow_default_credentials, validation_context))
    return false;

  return true;
}

HttpAuthStaticNetworkContextParams_Data::HttpAuthStaticNetworkContextParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CTPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CTPolicy_Data* object =
      static_cast<const CTPolicy_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->excluded_hosts, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& excluded_hosts_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->excluded_hosts, validation_context,
                                         &excluded_hosts_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->excluded_spkis, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& excluded_spkis_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->excluded_spkis, validation_context,
                                         &excluded_spkis_validate_params)) {
    return false;
  }

  return true;
}

CTPolicy_Data::CTPolicy_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContextFilePaths_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 128, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContextFilePaths_Data* object =
      static_cast<const NetworkContextFilePaths_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->shared_dictionary_directory, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->http_cache_directory, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data_directory, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data_directory, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->unsandboxed_data_path, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_database_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->device_bound_sessions_database_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_database_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->http_server_properties_file_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->transport_security_persister_file_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reporting_and_nel_store_database_name, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sct_auditing_pending_reports_file_name, validation_context))
    return false;

  return true;
}

NetworkContextFilePaths_Data::NetworkContextFilePaths_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContextParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 264, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContextParams_Data* object =
      static_cast<const NetworkContextParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_agent, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_agent_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_agent, validation_context,
                                         &user_agent_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->accept_language, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& accept_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->accept_language, validation_context,
                                         &accept_language_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_resolver_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->http_cache_file_operations_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initial_ssl_config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->ssl_config_client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initial_proxy_config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_config_client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initial_custom_proxy_config, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->custom_proxy_config_client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->custom_proxy_connection_observer_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_config_poller_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_error_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->ip_protection_core_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->ip_protection_control,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::SCTAuditingMode_Data
        ::Validate(object->sct_auditing_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->ct_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert_verifier_params, 32, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert_verifier_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_manager_params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_manager,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain_reliability_upload_reporter, 36, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_reliability_upload_reporter_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain_reliability_upload_reporter, validation_context,
                                         &domain_reliability_upload_reporter_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->reporting_delivery_interval, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_origin_access_list, 40, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cors_origin_access_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cors_origin_access_list, validation_context,
                                         &cors_origin_access_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cors_exempt_header_list, 41, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cors_exempt_header_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cors_exempt_header_list, validation_context,
                                         &cors_exempt_header_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hsts_policy_bypass_list, 43, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hsts_policy_bypass_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->hsts_policy_bypass_list, validation_context,
                                         &hsts_policy_bypass_list_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->http_auth_static_network_context_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->file_paths, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->first_party_sets_access_delegate_params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->first_party_sets_access_delegate_receiver,
                                                 validation_context)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& cookie_deprecation_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookie_deprecation_label, validation_context,
                                         &cookie_deprecation_label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_encryption_provider,
                                                 validation_context)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& enterprise_reporting_endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->enterprise_reporting_endpoints, validation_context,
                                         &enterprise_reporting_endpoints_validate_params)) {
    return false;
  }

  return true;
}

NetworkContextParams_Data::NetworkContextParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkConditions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkConditions_Data* object =
      static_cast<const NetworkConditions_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->latency, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->latency, validation_context))
    return false;

  return true;
}

NetworkConditions_Data::NetworkConditions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SharedDictionaryInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SharedDictionaryInfo_Data* object =
      static_cast<const SharedDictionaryInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& match_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->match, validation_context,
                                         &match_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->match_dest, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& match_dest_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::RequestDestination_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->match_dest, validation_context,
                                         &match_dest_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dictionary_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dictionary_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_fetch_time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_fetch_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiration, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_used_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_used_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hash, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hash, validation_context))
    return false;

  return true;
}

SharedDictionaryInfo_Data::SharedDictionaryInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SignedExchangeReport_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 88, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SignedExchangeReport_Data* object =
      static_cast<const SignedExchangeReport_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->outer_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->outer_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->inner_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->inner_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cert_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cert_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& referrer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->referrer, validation_context,
                                         &referrer_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_ip_address, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->server_ip_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->protocol, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->protocol, validation_context,
                                         &protocol_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->elapsed_time, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->elapsed_time, validation_context))
    return false;

  return true;
}

SignedExchangeReport_Data::SignedExchangeReport_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderFactoryOverride_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderFactoryOverride_Data* object =
      static_cast<const URLLoaderFactoryOverride_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->overriding_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->overriding_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->overridden_factory_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

URLLoaderFactoryOverride_Data::URLLoaderFactoryOverride_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLLoaderFactoryParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 160, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLLoaderFactoryParams_Data* object =
      static_cast<const URLLoaderFactoryParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->request_initiator_origin_lock, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->header_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_info, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->top_frame_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->factory_override, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->coep_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->dip_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->trust_token_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->shared_dictionary_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_network_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->devtools_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->device_bound_session_observer,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::TrustTokenOperationPolicyVerdict_Data
        ::Validate(object->trust_token_issuance_policy, validation_context))
    return false;


  if (!::network::mojom::internal::TrustTokenOperationPolicyVerdict_Data
        ::Validate(object->trust_token_redemption_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->debug_tag, 25, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& debug_tag_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->debug_tag, validation_context,
                                         &debug_tag_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_setting_overrides, 26, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_setting_overrides, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_cookie_setting_overrides, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_cookie_setting_overrides, validation_context))
    return false;

  return true;
}

URLLoaderFactoryParams_Data::URLLoaderFactoryParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomProxyConnectionObserver_OnFallback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomProxyConnectionObserver_OnFallback_Params_Data* object =
      static_cast<const CustomProxyConnectionObserver_OnFallback_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bad_chain, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bad_chain, validation_context))
    return false;

  return true;
}

CustomProxyConnectionObserver_OnFallback_Params_Data::CustomProxyConnectionObserver_OnFallback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data* object =
      static_cast<const CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_chain, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_chain, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_headers, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_headers, validation_context))
    return false;

  return true;
}

CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data::CustomProxyConnectionObserver_OnTunnelHeadersReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data* object =
      static_cast<const CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->proxy_config, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->proxy_config, validation_context))
    return false;

  return true;
}

CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data* object =
      static_cast<const CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data*>(data);

  return true;
}

CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data::CustomProxyConfigClient_OnCustomProxyConfigUpdated_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedHeaderClient_OnBeforeSendHeaders_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedHeaderClient_OnBeforeSendHeaders_Params_Data* object =
      static_cast<const TrustedHeaderClient_OnBeforeSendHeaders_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  return true;
}

TrustedHeaderClient_OnBeforeSendHeaders_Params_Data::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data* object =
      static_cast<const TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  return true;
}

TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedHeaderClient_OnHeadersReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedHeaderClient_OnHeadersReceived_Params_Data* object =
      static_cast<const TrustedHeaderClient_OnHeadersReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  return true;
}

TrustedHeaderClient_OnHeadersReceived_Params_Data::TrustedHeaderClient_OnHeadersReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data* object =
      static_cast<const TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->preserve_fragment_on_redirect_url, validation_context))
    return false;

  return true;
}

TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data* object =
      static_cast<const TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->header_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->header_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data* object =
      static_cast<const TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->header_client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->header_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetClient_Params_Data* object =
      static_cast<const NetworkContext_SetClient_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_SetClient_Params_Data::NetworkContext_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateURLLoaderFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateURLLoaderFactory_Params_Data* object =
      static_cast<const NetworkContext_CreateURLLoaderFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->url_loader_factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_factory,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetworkContext_CreateURLLoaderFactory_Params_Data::NetworkContext_CreateURLLoaderFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ResetURLLoaderFactories_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ResetURLLoaderFactories_Params_Data* object =
      static_cast<const NetworkContext_ResetURLLoaderFactories_Params_Data*>(data);

  return true;
}

NetworkContext_ResetURLLoaderFactories_Params_Data::NetworkContext_ResetURLLoaderFactories_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetViaObliviousHttp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetViaObliviousHttp_Params_Data* object =
      static_cast<const NetworkContext_GetViaObliviousHttp_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_GetViaObliviousHttp_Params_Data::NetworkContext_GetViaObliviousHttp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetCookieManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetCookieManager_Params_Data* object =
      static_cast<const NetworkContext_GetCookieManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->cookie_manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_GetCookieManager_Params_Data::NetworkContext_GetCookieManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetRestrictedCookieManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetRestrictedCookieManager_Params_Data* object =
      static_cast<const NetworkContext_GetRestrictedCookieManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->restricted_cookie_manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->restricted_cookie_manager,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::RestrictedCookieManagerRole_Data
        ::Validate(object->role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_info, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookie_setting_overrides, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cookie_setting_overrides, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_cookie_setting_overrides, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_cookie_setting_overrides, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->cookie_observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_GetRestrictedCookieManager_Params_Data::NetworkContext_GetRestrictedCookieManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetTrustTokenQueryAnswerer_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetTrustTokenQueryAnswerer_Params_Data* object =
      static_cast<const NetworkContext_GetTrustTokenQueryAnswerer_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->trust_token_query_answerer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->trust_token_query_answerer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->top_frame_origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->top_frame_origin, validation_context))
    return false;

  return true;
}

NetworkContext_GetTrustTokenQueryAnswerer_Params_Data::NetworkContext_GetTrustTokenQueryAnswerer_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearTrustTokenData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearTrustTokenData_Params_Data* object =
      static_cast<const NetworkContext_ClearTrustTokenData_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearTrustTokenData_Params_Data::NetworkContext_ClearTrustTokenData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearTrustTokenData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearTrustTokenData_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearTrustTokenData_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearTrustTokenData_ResponseParams_Data::NetworkContext_ClearTrustTokenData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data* object =
      static_cast<const NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data*>(data);

  return true;
}

NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data::NetworkContext_ClearTrustTokenSessionOnlyData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data::NetworkContext_ClearTrustTokenSessionOnlyData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetStoredTrustTokenCounts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetStoredTrustTokenCounts_Params_Data* object =
      static_cast<const NetworkContext_GetStoredTrustTokenCounts_Params_Data*>(data);

  return true;
}

NetworkContext_GetStoredTrustTokenCounts_Params_Data::NetworkContext_GetStoredTrustTokenCounts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tokens, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tokens_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->tokens, validation_context,
                                         &tokens_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data::NetworkContext_GetStoredTrustTokenCounts_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data* object =
      static_cast<const NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data*>(data);

  return true;
}

NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data::NetworkContext_GetPrivateStateTokenRedemptionRecords_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuer_redemption_record_map, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issuer_redemption_record_map_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->issuer_redemption_record_map, validation_context,
                                         &issuer_redemption_record_map_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data::NetworkContext_GetPrivateStateTokenRedemptionRecords_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_DeleteStoredTrustTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_DeleteStoredTrustTokens_Params_Data* object =
      static_cast<const NetworkContext_DeleteStoredTrustTokens_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issuer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->issuer, validation_context))
    return false;

  return true;
}

NetworkContext_DeleteStoredTrustTokens_Params_Data::NetworkContext_DeleteStoredTrustTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data* object =
      static_cast<const NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data*>(data);


  if (!::network::mojom::internal::DeleteStoredTrustTokensStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data::NetworkContext_DeleteStoredTrustTokens_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetBlockTrustTokens_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetBlockTrustTokens_Params_Data* object =
      static_cast<const NetworkContext_SetBlockTrustTokens_Params_Data*>(data);

  return true;
}

NetworkContext_SetBlockTrustTokens_Params_Data::NetworkContext_SetBlockTrustTokens_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearNetworkingHistoryBetween_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearNetworkingHistoryBetween_Params_Data* object =
      static_cast<const NetworkContext_ClearNetworkingHistoryBetween_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  return true;
}

NetworkContext_ClearNetworkingHistoryBetween_Params_Data::NetworkContext_ClearNetworkingHistoryBetween_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHttpCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHttpCache_Params_Data* object =
      static_cast<const NetworkContext_ClearHttpCache_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearHttpCache_Params_Data::NetworkContext_ClearHttpCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHttpCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHttpCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearHttpCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearHttpCache_ResponseParams_Data::NetworkContext_ClearHttpCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ComputeHttpCacheSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ComputeHttpCacheSize_Params_Data* object =
      static_cast<const NetworkContext_ComputeHttpCacheSize_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  return true;
}

NetworkContext_ComputeHttpCacheSize_Params_Data::NetworkContext_ComputeHttpCacheSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ComputeHttpCacheSize_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ComputeHttpCacheSize_ResponseParams_Data* object =
      static_cast<const NetworkContext_ComputeHttpCacheSize_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ComputeHttpCacheSize_ResponseParams_Data::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_NotifyExternalCacheHit_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_NotifyExternalCacheHit_Params_Data* object =
      static_cast<const NetworkContext_NotifyExternalCacheHit_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_method, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& http_method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->http_method, validation_context,
                                         &http_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->key, validation_context))
    return false;

  return true;
}

NetworkContext_NotifyExternalCacheHit_Params_Data::NetworkContext_NotifyExternalCacheHit_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHostCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHostCache_Params_Data* object =
      static_cast<const NetworkContext_ClearHostCache_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearHostCache_Params_Data::NetworkContext_ClearHostCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHostCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHostCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearHostCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearHostCache_ResponseParams_Data::NetworkContext_ClearHostCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHttpAuthCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHttpAuthCache_Params_Data* object =
      static_cast<const NetworkContext_ClearHttpAuthCache_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearHttpAuthCache_Params_Data::NetworkContext_ClearHttpAuthCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearHttpAuthCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearHttpAuthCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearHttpAuthCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearHttpAuthCache_ResponseParams_Data::NetworkContext_ClearHttpAuthCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearCorsPreflightCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearCorsPreflightCache_Params_Data* object =
      static_cast<const NetworkContext_ClearCorsPreflightCache_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearCorsPreflightCache_Params_Data::NetworkContext_ClearCorsPreflightCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearCorsPreflightCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearCorsPreflightCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearCorsPreflightCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearCorsPreflightCache_ResponseParams_Data::NetworkContext_ClearCorsPreflightCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearReportingCacheReports_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearReportingCacheReports_Params_Data* object =
      static_cast<const NetworkContext_ClearReportingCacheReports_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearReportingCacheReports_Params_Data::NetworkContext_ClearReportingCacheReports_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearReportingCacheReports_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearReportingCacheReports_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearReportingCacheReports_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearReportingCacheReports_ResponseParams_Data::NetworkContext_ClearReportingCacheReports_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearReportingCacheClients_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearReportingCacheClients_Params_Data* object =
      static_cast<const NetworkContext_ClearReportingCacheClients_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearReportingCacheClients_Params_Data::NetworkContext_ClearReportingCacheClients_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearReportingCacheClients_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearReportingCacheClients_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearReportingCacheClients_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearReportingCacheClients_ResponseParams_Data::NetworkContext_ClearReportingCacheClients_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearNetworkErrorLogging_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearNetworkErrorLogging_Params_Data* object =
      static_cast<const NetworkContext_ClearNetworkErrorLogging_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearNetworkErrorLogging_Params_Data::NetworkContext_ClearNetworkErrorLogging_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearDomainReliability_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearDomainReliability_Params_Data* object =
      static_cast<const NetworkContext_ClearDomainReliability_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;


  if (!::network::mojom::internal::NetworkContext_DomainReliabilityClearMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

NetworkContext_ClearDomainReliability_Params_Data::NetworkContext_ClearDomainReliability_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearDomainReliability_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearDomainReliability_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearDomainReliability_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearDomainReliability_ResponseParams_Data::NetworkContext_ClearDomainReliability_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearSharedDictionaryCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearSharedDictionaryCache_Params_Data* object =
      static_cast<const NetworkContext_ClearSharedDictionaryCache_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

NetworkContext_ClearSharedDictionaryCache_Params_Data::NetworkContext_ClearSharedDictionaryCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data::NetworkContext_ClearSharedDictionaryCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data* object =
      static_cast<const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_key, validation_context))
    return false;

  return true;
}

NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data::NetworkContext_ClearSharedDictionaryCacheForIsolationKey_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetDocumentReportingEndpoints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetDocumentReportingEndpoints_Params_Data* object =
      static_cast<const NetworkContext_SetDocumentReportingEndpoints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_source, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetDocumentReportingEndpoints_Params_Data::NetworkContext_SetDocumentReportingEndpoints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetEnterpriseReportingEndpoints_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetEnterpriseReportingEndpoints_Params_Data* object =
      static_cast<const NetworkContext_SetEnterpriseReportingEndpoints_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetEnterpriseReportingEndpoints_Params_Data::NetworkContext_SetEnterpriseReportingEndpoints_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SendReportsAndRemoveSource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SendReportsAndRemoveSource_Params_Data* object =
      static_cast<const NetworkContext_SendReportsAndRemoveSource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reporting_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->reporting_source, validation_context))
    return false;

  return true;
}

NetworkContext_SendReportsAndRemoveSource_Params_Data::NetworkContext_SendReportsAndRemoveSource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_QueueReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_QueueReport_Params_Data* object =
      static_cast<const NetworkContext_QueueReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group, validation_context,
                                         &group_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reporting_source, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  return true;
}

NetworkContext_QueueReport_Params_Data::NetworkContext_QueueReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_QueueEnterpriseReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_QueueEnterpriseReport_Params_Data* object =
      static_cast<const NetworkContext_QueueEnterpriseReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->type, validation_context,
                                         &type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group, validation_context,
                                         &group_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  return true;
}

NetworkContext_QueueEnterpriseReport_Params_Data::NetworkContext_QueueEnterpriseReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_QueueSignedExchangeReport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_QueueSignedExchangeReport_Params_Data* object =
      static_cast<const NetworkContext_QueueSignedExchangeReport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  return true;
}

NetworkContext_QueueSignedExchangeReport_Params_Data::NetworkContext_QueueSignedExchangeReport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CloseAllConnections_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CloseAllConnections_Params_Data* object =
      static_cast<const NetworkContext_CloseAllConnections_Params_Data*>(data);

  return true;
}

NetworkContext_CloseAllConnections_Params_Data::NetworkContext_CloseAllConnections_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CloseAllConnections_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CloseAllConnections_ResponseParams_Data* object =
      static_cast<const NetworkContext_CloseAllConnections_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_CloseAllConnections_ResponseParams_Data::NetworkContext_CloseAllConnections_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CloseIdleConnections_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CloseIdleConnections_Params_Data* object =
      static_cast<const NetworkContext_CloseIdleConnections_Params_Data*>(data);

  return true;
}

NetworkContext_CloseIdleConnections_Params_Data::NetworkContext_CloseIdleConnections_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CloseIdleConnections_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CloseIdleConnections_ResponseParams_Data* object =
      static_cast<const NetworkContext_CloseIdleConnections_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_CloseIdleConnections_ResponseParams_Data::NetworkContext_CloseIdleConnections_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetNetworkConditions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetNetworkConditions_Params_Data* object =
      static_cast<const NetworkContext_SetNetworkConditions_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->throttling_profile_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->throttling_profile_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->conditions, validation_context))
    return false;

  return true;
}

NetworkContext_SetNetworkConditions_Params_Data::NetworkContext_SetNetworkConditions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetAcceptLanguage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetAcceptLanguage_Params_Data* object =
      static_cast<const NetworkContext_SetAcceptLanguage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_accept_language, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_accept_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_accept_language, validation_context,
                                         &new_accept_language_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetAcceptLanguage_Params_Data::NetworkContext_SetAcceptLanguage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetUserAgent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetUserAgent_Params_Data* object =
      static_cast<const NetworkContext_SetUserAgent_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_user_agent, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& new_user_agent_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->new_user_agent, validation_context,
                                         &new_user_agent_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetUserAgent_Params_Data::NetworkContext_SetUserAgent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetEnableReferrers_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetEnableReferrers_Params_Data* object =
      static_cast<const NetworkContext_SetEnableReferrers_Params_Data*>(data);

  return true;
}

NetworkContext_SetEnableReferrers_Params_Data::NetworkContext_SetEnableReferrers_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetCTPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetCTPolicy_Params_Data* object =
      static_cast<const NetworkContext_SetCTPolicy_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ct_policy, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ct_policy, validation_context))
    return false;

  return true;
}

NetworkContext_SetCTPolicy_Params_Data::NetworkContext_SetCTPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateUDPSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateUDPSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateUDPSocket_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateUDPSocket_Params_Data::NetworkContext_CreateUDPSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateRestrictedUDPSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateRestrictedUDPSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateRestrictedUDPSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->addr, validation_context))
    return false;


  if (!::network::mojom::internal::RestrictedUDPSocketMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateRestrictedUDPSocket_Params_Data::NetworkContext_CreateRestrictedUDPSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data* object =
      static_cast<const NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr_out, validation_context))
    return false;

  return true;
}

NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data::NetworkContext_CreateRestrictedUDPSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPServerSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPServerSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateTCPServerSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateTCPServerSocket_Params_Data::NetworkContext_CreateTCPServerSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPServerSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPServerSocket_ResponseParams_Data* object =
      static_cast<const NetworkContext_CreateTCPServerSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr_out, validation_context))
    return false;

  return true;
}

NetworkContext_CreateTCPServerSocket_ResponseParams_Data::NetworkContext_CreateTCPServerSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPConnectedSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPConnectedSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateTCPConnectedSocket_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_addr_list, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_addr_list, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->tcp_connected_socket_options, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateTCPConnectedSocket_Params_Data::NetworkContext_CreateTCPConnectedSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data* object =
      static_cast<const NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->peer_addr, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->receive_stream,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->send_stream,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPBoundSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPBoundSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateTCPBoundSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->local_addr, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateTCPBoundSocket_Params_Data::NetworkContext_CreateTCPBoundSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateTCPBoundSocket_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateTCPBoundSocket_ResponseParams_Data* object =
      static_cast<const NetworkContext_CreateTCPBoundSocket_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->local_addr, validation_context))
    return false;

  return true;
}

NetworkContext_CreateTCPBoundSocket_ResponseParams_Data::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateProxyResolvingSocketFactory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateProxyResolvingSocketFactory_Params_Data* object =
      static_cast<const NetworkContext_CreateProxyResolvingSocketFactory_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->factory, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->factory,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateProxyResolvingSocketFactory_Params_Data::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_LookUpProxyForURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_LookUpProxyForURL_Params_Data* object =
      static_cast<const NetworkContext_LookUpProxyForURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->proxy_lookup_client, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_lookup_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_LookUpProxyForURL_Params_Data::NetworkContext_LookUpProxyForURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ForceReloadProxyConfig_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ForceReloadProxyConfig_Params_Data* object =
      static_cast<const NetworkContext_ForceReloadProxyConfig_Params_Data*>(data);

  return true;
}

NetworkContext_ForceReloadProxyConfig_Params_Data::NetworkContext_ForceReloadProxyConfig_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ForceReloadProxyConfig_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ForceReloadProxyConfig_ResponseParams_Data* object =
      static_cast<const NetworkContext_ForceReloadProxyConfig_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ForceReloadProxyConfig_ResponseParams_Data::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearBadProxiesCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearBadProxiesCache_Params_Data* object =
      static_cast<const NetworkContext_ClearBadProxiesCache_Params_Data*>(data);

  return true;
}

NetworkContext_ClearBadProxiesCache_Params_Data::NetworkContext_ClearBadProxiesCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearBadProxiesCache_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearBadProxiesCache_ResponseParams_Data* object =
      static_cast<const NetworkContext_ClearBadProxiesCache_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ClearBadProxiesCache_ResponseParams_Data::NetworkContext_ClearBadProxiesCache_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateWebSocket_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateWebSocket_Params_Data* object =
      static_cast<const NetworkContext_CreateWebSocket_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requested_protocols, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requested_protocols_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->requested_protocols, validation_context,
                                         &requested_protocols_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site_for_cookies, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site_for_cookies, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_info, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->additional_headers, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& additional_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->additional_headers, validation_context,
                                         &additional_headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handshake_client, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handshake_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->url_loader_network_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->auth_handler,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->header_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->throttling_profile_id, validation_context))
    return false;

  return true;
}

NetworkContext_CreateWebSocket_Params_Data::NetworkContext_CreateWebSocket_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateWebTransport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateWebTransport_Params_Data* object =
      static_cast<const NetworkContext_CreateWebTransport_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fingerprints, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& fingerprints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->fingerprints, validation_context,
                                         &fingerprints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handshake_client, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handshake_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateWebTransport_Params_Data::NetworkContext_CreateWebTransport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateNetLogExporter_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateNetLogExporter_Params_Data* object =
      static_cast<const NetworkContext_CreateNetLogExporter_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateNetLogExporter_Params_Data::NetworkContext_CreateNetLogExporter_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_PreconnectSockets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_PreconnectSockets_Params_Data* object =
      static_cast<const NetworkContext_PreconnectSockets_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::CredentialsMode_Data
        ::Validate(object->credentials_mode, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  return true;
}

NetworkContext_PreconnectSockets_Params_Data::NetworkContext_PreconnectSockets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateP2PSocketManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateP2PSocketManager_Params_Data* object =
      static_cast<const NetworkContext_CreateP2PSocketManager_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->trusted_socket_manager, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->trusted_socket_manager,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->socket_manager, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->socket_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateP2PSocketManager_Params_Data::NetworkContext_CreateP2PSocketManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateMdnsResponder_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateMdnsResponder_Params_Data* object =
      static_cast<const NetworkContext_CreateMdnsResponder_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->responder_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->responder_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateMdnsResponder_Params_Data::NetworkContext_CreateMdnsResponder_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ResolveHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ResolveHost_Params_Data* object =
      static_cast<const NetworkContext_ResolveHost_Params_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->host, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->optional_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_client, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_ResolveHost_Params_Data::NetworkContext_ResolveHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_CreateHostResolver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_CreateHostResolver_Params_Data* object =
      static_cast<const NetworkContext_CreateHostResolver_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->config_overrides, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host_resolver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host_resolver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_CreateHostResolver_Params_Data::NetworkContext_CreateHostResolver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_VerifyCertForSignedExchange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_VerifyCertForSignedExchange_Params_Data* object =
      static_cast<const NetworkContext_VerifyCertForSignedExchange_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ocsp_response, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ocsp_response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ocsp_response, validation_context,
                                         &ocsp_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sct_list, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sct_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sct_list, validation_context,
                                         &sct_list_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_VerifyCertForSignedExchange_Params_Data::NetworkContext_VerifyCertForSignedExchange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data* object =
      static_cast<const NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cv_result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cv_result, validation_context))
    return false;

  return true;
}

NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddHSTS_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddHSTS_Params_Data* object =
      static_cast<const NetworkContext_AddHSTS_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->expiry, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->expiry, validation_context))
    return false;

  return true;
}

NetworkContext_AddHSTS_Params_Data::NetworkContext_AddHSTS_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddHSTS_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddHSTS_ResponseParams_Data* object =
      static_cast<const NetworkContext_AddHSTS_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_AddHSTS_ResponseParams_Data::NetworkContext_AddHSTS_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_IsHSTSActiveForHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_IsHSTSActiveForHost_Params_Data* object =
      static_cast<const NetworkContext_IsHSTSActiveForHost_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_IsHSTSActiveForHost_Params_Data::NetworkContext_IsHSTSActiveForHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_IsHSTSActiveForHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_IsHSTSActiveForHost_ResponseParams_Data* object =
      static_cast<const NetworkContext_IsHSTSActiveForHost_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_IsHSTSActiveForHost_ResponseParams_Data::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetHSTSState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetHSTSState_Params_Data* object =
      static_cast<const NetworkContext_GetHSTSState_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->domain, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& domain_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->domain, validation_context,
                                         &domain_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetHSTSState_Params_Data::NetworkContext_GetHSTSState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetHSTSState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetHSTSState_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetHSTSState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->state, validation_context))
    return false;

  return true;
}

NetworkContext_GetHSTSState_ResponseParams_Data::NetworkContext_GetHSTSState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data* object =
      static_cast<const NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->allow_patterns, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& allow_patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->allow_patterns, validation_context,
                                         &allow_patterns_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->block_patterns, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& block_patterns_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->block_patterns, validation_context,
                                         &block_patterns_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data* object =
      static_cast<const NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_DeleteDynamicDataForHost_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_DeleteDynamicDataForHost_Params_Data* object =
      static_cast<const NetworkContext_DeleteDynamicDataForHost_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& host_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->host, validation_context,
                                         &host_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_DeleteDynamicDataForHost_Params_Data::NetworkContext_DeleteDynamicDataForHost_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data* object =
      static_cast<const NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data* object =
      static_cast<const NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data*>(data);

  return true;
}

NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data::NetworkContext_SetSplitAuthCacheByNetworkAnonymizationKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data* object =
      static_cast<const NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data*>(data);

  return true;
}

NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data* object =
      static_cast<const NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_key, validation_context))
    return false;

  return true;
}

NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data* object =
      static_cast<const NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cache_key, validation_context))
    return false;

  return true;
}

NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data* object =
      static_cast<const NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddAuthCacheEntry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddAuthCacheEntry_Params_Data* object =
      static_cast<const NetworkContext_AddAuthCacheEntry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->challenge, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->challenge, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->credentials, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->credentials, validation_context))
    return false;

  return true;
}

NetworkContext_AddAuthCacheEntry_Params_Data::NetworkContext_AddAuthCacheEntry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddAuthCacheEntry_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddAuthCacheEntry_ResponseParams_Data* object =
      static_cast<const NetworkContext_AddAuthCacheEntry_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_AddAuthCacheEntry_ResponseParams_Data::NetworkContext_AddAuthCacheEntry_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data* object =
      static_cast<const NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data*>(data);

  return true;
}

NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data::NetworkContext_SetCorsNonWildcardRequestHeadersSupport_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_LookupServerBasicAuthCredentials_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_LookupServerBasicAuthCredentials_Params_Data* object =
      static_cast<const NetworkContext_LookupServerBasicAuthCredentials_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->network_anonymization_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->network_anonymization_key, validation_context))
    return false;

  return true;
}

NetworkContext_LookupServerBasicAuthCredentials_Params_Data::NetworkContext_LookupServerBasicAuthCredentials_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data* object =
      static_cast<const NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->credentials, validation_context))
    return false;

  return true;
}

NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_EnableStaticKeyPinningForTesting_Params_Data* object =
      static_cast<const NetworkContext_EnableStaticKeyPinningForTesting_Params_Data*>(data);

  return true;
}

NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_VerifyCertificateForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_VerifyCertificateForTesting_Params_Data* object =
      static_cast<const NetworkContext_VerifyCertificateForTesting_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hostname, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& hostname_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->hostname, validation_context,
                                         &hostname_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ocsp_response, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ocsp_response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ocsp_response, validation_context,
                                         &ocsp_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sct_list, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sct_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sct_list, validation_context,
                                         &sct_list_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_VerifyCertificateForTesting_Params_Data::NetworkContext_VerifyCertificateForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_VerifyCertificateForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_VerifyCertificateForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_VerifyCertificateForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_VerifyCertificateForTesting_ResponseParams_Data::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddDomainReliabilityContextForTesting_Params_Data* object =
      static_cast<const NetworkContext_AddDomainReliabilityContextForTesting_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->upload_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->upload_url, validation_context))
    return false;

  return true;
}

NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data* object =
      static_cast<const NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data*>(data);

  return true;
}

NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetSCTAuditingMode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetSCTAuditingMode_Params_Data* object =
      static_cast<const NetworkContext_SetSCTAuditingMode_Params_Data*>(data);


  if (!::network::mojom::internal::SCTAuditingMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  return true;
}

NetworkContext_SetSCTAuditingMode_Params_Data::NetworkContext_SetSCTAuditingMode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryUsageInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryUsageInfo_Params_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryUsageInfo_Params_Data*>(data);

  return true;
}

NetworkContext_GetSharedDictionaryUsageInfo_Params_Data::NetworkContext_GetSharedDictionaryUsageInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->usage_info, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& usage_info_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->usage_info, validation_context,
                                         &usage_info_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data::NetworkContext_GetSharedDictionaryUsageInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryInfo_Params_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryInfo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->isolation_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->isolation_key, validation_context))
    return false;

  return true;
}

NetworkContext_GetSharedDictionaryInfo_Params_Data::NetworkContext_GetSharedDictionaryInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dictionaries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& dictionaries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->dictionaries, validation_context,
                                         &dictionaries_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data::NetworkContext_GetSharedDictionaryInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->start_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->start_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->end_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->end_time, validation_context))
    return false;

  return true;
}

NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data::NetworkContext_GetSharedDictionaryOriginsBetween_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data::NetworkContext_GetSharedDictionaryOriginsBetween_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data* object =
      static_cast<const NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data*>(data);

  return true;
}

NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data::NetworkContext_SetSharedDictionaryCacheMaxSize_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data* object =
      static_cast<const NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->preload_handle, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->preload_handle,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data::NetworkContext_PreloadSharedDictionaryInfoForDocument_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data* object =
      static_cast<const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data*>(data);

  return true;
}

NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data::NetworkContext_HasPreloadedSharedDictionaryInfoForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data* object =
      static_cast<const NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_token, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_token, validation_context))
    return false;

  return true;
}

NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data::NetworkContext_ResourceSchedulerClientVisibilityChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_FlushCachedClientCertIfNeeded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_FlushCachedClientCertIfNeeded_Params_Data* object =
      static_cast<const NetworkContext_FlushCachedClientCertIfNeeded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->host, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  return true;
}

NetworkContext_FlushCachedClientCertIfNeeded_Params_Data::NetworkContext_FlushCachedClientCertIfNeeded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_FlushMatchingCachedClientCert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_FlushMatchingCachedClientCert_Params_Data* object =
      static_cast<const NetworkContext_FlushMatchingCachedClientCert_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->certificate, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->certificate, validation_context))
    return false;

  return true;
}

NetworkContext_FlushMatchingCachedClientCert_Params_Data::NetworkContext_FlushMatchingCachedClientCert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_SetCookieDeprecationLabel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_SetCookieDeprecationLabel_Params_Data* object =
      static_cast<const NetworkContext_SetCookieDeprecationLabel_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_SetCookieDeprecationLabel_Params_Data::NetworkContext_SetCookieDeprecationLabel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_RevokeNetworkForNonces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_RevokeNetworkForNonces_Params_Data* object =
      static_cast<const NetworkContext_RevokeNetworkForNonces_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonces, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nonces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nonces, validation_context,
                                         &nonces_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_RevokeNetworkForNonces_Params_Data::NetworkContext_RevokeNetworkForNonces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_RevokeNetworkForNonces_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_RevokeNetworkForNonces_ResponseParams_Data* object =
      static_cast<const NetworkContext_RevokeNetworkForNonces_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_RevokeNetworkForNonces_ResponseParams_Data::NetworkContext_RevokeNetworkForNonces_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ClearNonces_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ClearNonces_Params_Data* object =
      static_cast<const NetworkContext_ClearNonces_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonces, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& nonces_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->nonces, validation_context,
                                         &nonces_validate_params)) {
    return false;
  }

  return true;
}

NetworkContext_ClearNonces_Params_Data::NetworkContext_ClearNonces_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data* object =
      static_cast<const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->exempted_url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->exempted_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->nonce, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->nonce, validation_context))
    return false;

  return true;
}

NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data* object =
      static_cast<const NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data::NetworkContext_ExemptUrlFromNetworkRevocationForNonce_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_Prefetch_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_Prefetch_Params_Data* object =
      static_cast<const NetworkContext_Prefetch_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  return true;
}

NetworkContext_Prefetch_Params_Data::NetworkContext_Prefetch_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetBoundNetworkForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetBoundNetworkForTesting_Params_Data* object =
      static_cast<const NetworkContext_GetBoundNetworkForTesting_Params_Data*>(data);

  return true;
}

NetworkContext_GetBoundNetworkForTesting_Params_Data::NetworkContext_GetBoundNetworkForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data* object =
      static_cast<const NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data*>(data);

  return true;
}

NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data::NetworkContext_GetBoundNetworkForTesting_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkContext_GetDeviceBoundSessionManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkContext_GetDeviceBoundSessionManager_Params_Data* object =
      static_cast<const NetworkContext_GetDeviceBoundSessionManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->device_bound_session_manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->device_bound_session_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkContext_GetDeviceBoundSessionManager_Params_Data::NetworkContext_GetDeviceBoundSessionManager_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::TrustTokenOperationPolicyVerdict>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::TrustTokenOperationPolicyVerdict value) {
  return std::move(context).WriteString(::network::mojom::TrustTokenOperationPolicyVerdictToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::SCTAuditingMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::SCTAuditingMode value) {
  return std::move(context).WriteString(::network::mojom::SCTAuditingModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::NetworkContext_DomainReliabilityClearMode>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::NetworkContext_DomainReliabilityClearMode value) {
  return std::move(context).WriteString(::network::mojom::NetworkContext_DomainReliabilityClearModeToString(value));
}

} // namespace perfetto