// services/viz/public/mojom/compositing/transferable_resource.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/viz/public/mojom/compositing/transferable_resource.mojom-params-data.h"
namespace viz {
namespace mojom {

NOINLINE static const char* SynchronizationTypeToStringHelper(SynchronizationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SynchronizationType::kSyncToken:
      return "kSyncToken";
    case SynchronizationType::kGpuCommandsCompleted:
      return "kGpuCommandsCompleted";
    case SynchronizationType::kReleaseFence:
      return "kReleaseFence";
    default:
      return nullptr;
  }
}

std::string SynchronizationTypeToString(SynchronizationType value) {
  const char *str = SynchronizationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SynchronizationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SynchronizationType value) {
  return os << SynchronizationTypeToString(value);
}

namespace internal {


// static
bool TransferableResource_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 96, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TransferableResource_Data* object =
      static_cast<const TransferableResource_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->format, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->memory_buffer_id, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->memory_buffer_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;


  if (!::viz::mojom::internal::SynchronizationType_Data
        ::Validate(object->synchronization_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->color_space, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->color_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hdr_metadata, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hdr_metadata, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->ycbcr_info, validation_context))
    return false;


  if (!::skia::mojom::internal::SurfaceOrigin_Data
        ::Validate(object->origin, validation_context))
    return false;

  return true;
}

TransferableResource_Data::TransferableResource_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace viz

namespace perfetto {

// static
void TraceFormatTraits<::viz::mojom::SynchronizationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::viz::mojom::SynchronizationType value) {
  return std::move(context).WriteString(::viz::mojom::SynchronizationTypeToString(value));
}

} // namespace perfetto