/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  FeatureADX = 0,
  FeatureAES = 1,
  FeatureAMXAVX512 = 2,
  FeatureAMXBF16 = 3,
  FeatureAMXCOMPLEX = 4,
  FeatureAMXFP8 = 5,
  FeatureAMXFP16 = 6,
  FeatureAMXINT8 = 7,
  FeatureAMXMOVRS = 8,
  FeatureAMXTF32 = 9,
  FeatureAMXTILE = 10,
  FeatureAMXTRANSPOSE = 11,
  FeatureAVX = 12,
  FeatureAVX2 = 13,
  FeatureAVX10_1 = 14,
  FeatureAVX10_1_512 = 15,
  FeatureAVX10_2 = 16,
  FeatureAVX10_2_512 = 17,
  FeatureAVX512 = 18,
  FeatureAVXIFMA = 19,
  FeatureAVXNECONVERT = 20,
  FeatureAVXVNNI = 21,
  FeatureAVXVNNIINT8 = 22,
  FeatureAVXVNNIINT16 = 23,
  FeatureBF16 = 24,
  FeatureBITALG = 25,
  FeatureBMI = 26,
  FeatureBMI2 = 27,
  FeatureBWI = 28,
  FeatureCCMP = 29,
  FeatureCDI = 30,
  FeatureCF = 31,
  FeatureCLDEMOTE = 32,
  FeatureCLFLUSHOPT = 33,
  FeatureCLWB = 34,
  FeatureCLZERO = 35,
  FeatureCMOV = 36,
  FeatureCMPCCXADD = 37,
  FeatureCRC32 = 38,
  FeatureCX8 = 39,
  FeatureCX16 = 40,
  FeatureDQI = 41,
  FeatureEGPR = 42,
  FeatureENQCMD = 43,
  FeatureERMSB = 44,
  FeatureEVEX512 = 45,
  FeatureF16C = 46,
  FeatureFMA = 47,
  FeatureFMA4 = 48,
  FeatureFP16 = 49,
  FeatureFSGSBase = 50,
  FeatureFSRM = 51,
  FeatureFXSR = 52,
  FeatureGFNI = 53,
  FeatureHRESET = 54,
  FeatureHardenSlsIJmp = 55,
  FeatureHardenSlsRet = 56,
  FeatureIFMA = 57,
  FeatureINVPCID = 58,
  FeatureKL = 59,
  FeatureLAHFSAHF64 = 60,
  FeatureLVIControlFlowIntegrity = 61,
  FeatureLVILoadHardening = 62,
  FeatureLWP = 63,
  FeatureLZCNT = 64,
  FeatureMMX = 65,
  FeatureMOVBE = 66,
  FeatureMOVDIR64B = 67,
  FeatureMOVDIRI = 68,
  FeatureMOVRS = 69,
  FeatureMWAITX = 70,
  FeatureNDD = 71,
  FeatureNF = 72,
  FeatureNOPL = 73,
  FeaturePCLMUL = 74,
  FeaturePCONFIG = 75,
  FeaturePKU = 76,
  FeaturePOPCNT = 77,
  FeaturePPX = 78,
  FeaturePREFETCHI = 79,
  FeaturePRFCHW = 80,
  FeaturePTWRITE = 81,
  FeaturePush2Pop2 = 82,
  FeatureRAOINT = 83,
  FeatureRDPID = 84,
  FeatureRDPRU = 85,
  FeatureRDRAND = 86,
  FeatureRDSEED = 87,
  FeatureRTM = 88,
  FeatureRetpoline = 89,
  FeatureRetpolineExternalThunk = 90,
  FeatureRetpolineIndirectBranches = 91,
  FeatureRetpolineIndirectCalls = 92,
  FeatureSERIALIZE = 93,
  FeatureSGX = 94,
  FeatureSHA = 95,
  FeatureSHA512 = 96,
  FeatureSHSTK = 97,
  FeatureSM3 = 98,
  FeatureSM4 = 99,
  FeatureSSE1 = 100,
  FeatureSSE2 = 101,
  FeatureSSE3 = 102,
  FeatureSSE4A = 103,
  FeatureSSE41 = 104,
  FeatureSSE42 = 105,
  FeatureSSEUnalignedMem = 106,
  FeatureSSSE3 = 107,
  FeatureSoftFloat = 108,
  FeatureSpeculativeExecutionSideEffectSuppression = 109,
  FeatureTBM = 110,
  FeatureTSXLDTRK = 111,
  FeatureTaggedGlobals = 112,
  FeatureUINTR = 113,
  FeatureUSERMSR = 114,
  FeatureUseGPR32InInlineAsm = 115,
  FeatureVAES = 116,
  FeatureVBMI = 117,
  FeatureVBMI2 = 118,
  FeatureVLX = 119,
  FeatureVNNI = 120,
  FeatureVP2INTERSECT = 121,
  FeatureVPCLMULQDQ = 122,
  FeatureVPOPCNTDQ = 123,
  FeatureWAITPKG = 124,
  FeatureWBNOINVD = 125,
  FeatureWIDEKL = 126,
  FeatureX86_64 = 127,
  FeatureX87 = 128,
  FeatureXOP = 129,
  FeatureXSAVE = 130,
  FeatureXSAVEC = 131,
  FeatureXSAVEOPT = 132,
  FeatureXSAVES = 133,
  FeatureZU = 134,
  Is16Bit = 135,
  Is32Bit = 136,
  Is64Bit = 137,
  IsX32 = 138,
  ProcIntelAtom = 139,
  TuningAllowLight256Bit = 140,
  TuningBranchFusion = 141,
  TuningBranchHint = 142,
  TuningFast7ByteNOP = 143,
  TuningFast11ByteNOP = 144,
  TuningFast15ByteNOP = 145,
  TuningFastBEXTR = 146,
  TuningFastDPWSSD = 147,
  TuningFastGather = 148,
  TuningFastHorizontalOps = 149,
  TuningFastImm16 = 150,
  TuningFastImmVectorShift = 151,
  TuningFastLZCNT = 152,
  TuningFastMOVBE = 153,
  TuningFastSHLDRotate = 154,
  TuningFastScalarFSQRT = 155,
  TuningFastScalarShiftMasks = 156,
  TuningFastVariableCrossLaneShuffle = 157,
  TuningFastVariablePerLaneShuffle = 158,
  TuningFastVectorFSQRT = 159,
  TuningFastVectorShiftMasks = 160,
  TuningGETMANTFalseDeps = 161,
  TuningInsertVZEROUPPER = 162,
  TuningLEAForSP = 163,
  TuningLEAUsesAG = 164,
  TuningLZCNTFalseDeps = 165,
  TuningMULCFalseDeps = 166,
  TuningMULLQFalseDeps = 167,
  TuningMacroFusion = 168,
  TuningNoDomainDelay = 169,
  TuningNoDomainDelayBlend = 170,
  TuningNoDomainDelayMov = 171,
  TuningNoDomainDelayShuffle = 172,
  TuningPERMFalseDeps = 173,
  TuningPOPCNTFalseDeps = 174,
  TuningPadShortFunctions = 175,
  TuningPrefer128Bit = 176,
  TuningPrefer256Bit = 177,
  TuningPreferMaskRegisters = 178,
  TuningPreferMovmskOverVTest = 179,
  TuningPreferNoGather = 180,
  TuningPreferNoScatter = 181,
  TuningPreferShiftShuffle = 182,
  TuningRANGEFalseDeps = 183,
  TuningSBBDepBreaking = 184,
  TuningSlow3OpsLEA = 185,
  TuningSlowDivide32 = 186,
  TuningSlowDivide64 = 187,
  TuningSlowIncDec = 188,
  TuningSlowLEA = 189,
  TuningSlowPMADDWD = 190,
  TuningSlowPMULLD = 191,
  TuningSlowSHLD = 192,
  TuningSlowTwoMemOps = 193,
  TuningSlowUAMem16 = 194,
  TuningSlowUAMem32 = 195,
  TuningUseGLMDivSqrtCosts = 196,
  TuningUseSLMArithCosts = 197,
  NumSubtargetFeatures = 198
};
} // namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(FastImmVectorShift, false, fastImmVectorShift)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXAVX512, false, hasAMXAVX512)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXCOMPLEX, false, hasAMXCOMPLEX)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXFP8, false, hasAMXFP8)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXMOVRS, false, hasAMXMOVRS)
GET_SUBTARGETINFO_MACRO(HasAMXTF32, false, hasAMXTF32)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasAMXTRANSPOSE, false, hasAMXTRANSPOSE)
GET_SUBTARGETINFO_MACRO(HasAVX10_1, false, hasAVX10_1)
GET_SUBTARGETINFO_MACRO(HasAVX10_1_512, false, hasAVX10_1_512)
GET_SUBTARGETINFO_MACRO(HasAVX10_2, false, hasAVX10_2)
GET_SUBTARGETINFO_MACRO(HasAVX10_2_512, false, hasAVX10_2_512)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT16, false, hasAVXVNNIINT16)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasBranchHint, false, hasBranchHint)
GET_SUBTARGETINFO_MACRO(HasCCMP, false, hasCCMP)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasCF, false, hasCF)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasEGPR, false, hasEGPR)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasEVEX512, false, hasEVEX512)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastDPWSSD, false, hasFastDPWSSD)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastImm16, false, hasFastImm16)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMMX, false, hasMMX)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMOVRS, false, hasMOVRS)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasNDD, false, hasNDD)
GET_SUBTARGETINFO_MACRO(HasNF, false, hasNF)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPPX, false, hasPPX)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasPush2Pop2, false, hasPush2Pop2)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHA512, false, hasSHA512)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(HasSM3, false, hasSM3)
GET_SUBTARGETINFO_MACRO(HasSM4, false, hasSM4)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(HasUSERMSR, false, hasUSERMSR)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
GET_SUBTARGETINFO_MACRO(HasZU, false, hasZU)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(IsX32, false, isX32)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(NoDomainDelay, false, noDomainDelay)
GET_SUBTARGETINFO_MACRO(NoDomainDelayBlend, false, noDomainDelayBlend)
GET_SUBTARGETINFO_MACRO(NoDomainDelayMov, false, noDomainDelayMov)
GET_SUBTARGETINFO_MACRO(NoDomainDelayShuffle, false, noDomainDelayShuffle)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferGather, true, preferGather)
GET_SUBTARGETINFO_MACRO(PreferLowerShuffleAsShift, false, preferLowerShuffleAsShift)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(PreferMovmskOverVTest, false, preferMovmskOverVTest)
GET_SUBTARGETINFO_MACRO(PreferScatter, true, preferScatter)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseInlineAsmGPR32, false, useInlineAsmGPR32)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-avx512", "Support AMX-AVX512 instructions", X86::FeatureAMXAVX512, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-complex", "Support AMX-COMPLEX instructions", X86::FeatureAMXCOMPLEX, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp8", "Support AMX-FP8 instructions", X86::FeatureAMXFP8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-movrs", "Support AMX-MOVRS instructions", X86::FeatureAMXMOVRS, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tf32", "Support AMX-TF32 instructions", X86::FeatureAMXTF32, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-transpose", "Support AMX amx-transpose instructions", X86::FeatureAMXTRANSPOSE, { { { 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x20000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1", "Support AVX10.1 instruction", X86::FeatureAVX10_1, { { { 0x202020043000000ULL, 0x9e0000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-512", "Support AVX10.1 instruction", X86::FeatureAVX10_1_512, { { { 0x4000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.2", "Support AVX10.2 instruction", X86::FeatureAVX10_2, { { { 0x4000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.2-512", "Support AVX10.2 instruction", X86::FeatureAVX10_2_512, { { { 0x10000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0xc00000002000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x40000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint16", "Enable AVX-VNNI-INT16", X86::FeatureAVXVNNIINT16, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branch-hint", "Target has branch hint feature", X86::TuningBranchHint, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ccmp", "Support conditional cmp & test instructions", X86::FeatureCCMP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cf", "Support conditional faulting", X86::FeatureCF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x8000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "egpr", "Support extended general purpose register", X86::FeatureEGPR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "evex512", "Support ZMM and 64-bit mask instructions", X86::FeatureEVEX512, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-dpwssd", "Prefer vpdpwssd instruction over vpmaddwd+vpaddd instruction sequence", X86::TuningFastDPWSSD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-imm16", "Prefer a i16 instruction with i16 immediate over extension to i32", X86::TuningFastImm16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "faster-shift-than-shuffle", "Shifts are faster (or as fast) as shuffle", X86::TuningPreferShiftShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x1000ULL, 0x8000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "inline-asm-use-gpr32", "Enable use of GPR32 in inline assembly for APX", X86::FeatureUseGPR32InInlineAsm, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movrs", "Enable MOVRS", X86::FeatureMOVRS, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ndd", "Support non-destructive destination", X86::FeatureNDD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nf", "Support status flags update suppression", X86::FeatureNF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay", "Has no bypass delay when using the 'wrong' domain", X86::TuningNoDomainDelay, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-blend", "Has no bypass delay when using the 'wrong' blend type", X86::TuningNoDomainDelayBlend, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-mov", "Has no bypass delay when using the 'wrong' mov type", X86::TuningNoDomainDelayMov, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-shuffle", "Has no bypass delay when using the 'wrong' shuffle type", X86::TuningNoDomainDelayShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppx", "Support Push-Pop Acceleration", X86::FeaturePPX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-movmsk-over-vtest", "Prefer movmsk over vtest instruction", X86::TuningPreferMovmskOverVTest, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-gather", "Prefer no gather instructions", X86::TuningPreferNoGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-scatter", "Prefer no scatter instructions", X86::TuningPreferNoScatter, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "push2pop2", "Support PUSH2/POP2 instructions", X86::FeaturePush2Pop2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x18000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x2000000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha512", "Support SHA512 instructions", X86::FeatureSHA512, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm3", "Support SM3 instructions", X86::FeatureSM3, { { { 0x1000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm4", "Support SM4 instructions", X86::FeatureSM4, { { { 0x2000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x1000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x2000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x80000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x10000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x4000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x4000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tuning-fast-imm-vector-shift", "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)", X86::TuningFastImmVectorShift, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "usermsr", "Support USERMSR instructions", X86::FeatureUSERMSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x2002ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x1000ULL, 0x400ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x800000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x32", "64-bit with ILP32 programming model (e.g. x32 ABI)", X86::IsX32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x1000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x0ULL, 0x4ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "zu", "Support zero-upper SETcc/IMUL", X86::FeatureZU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#define DBGVAL_OR_NULLPTR(x) x
#else
#define DBGFIELD(x)
#define DBGVAL_OR_NULLPTR(x) nullptr
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, ReleaseAtCycle, AcquireAtCycle}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0,  0 }, // Invalid
  { 5,  1,   0}, // #1
  {28,  1,   0}, // #2
  { 1,  1,   0}, // #3
  { 2,  1,   0}, // #4
  { 3,  1,   0}, // #5
  { 4,  1,   0}, // #6
  { 5,  1,   0}, // #7
  { 6,  1,   0}, // #8
  { 7,  1,   0}, // #9
  { 8,  1,   0}, // #10
  {28,  1,   0}, // #11
  { 4,  1,   0}, // #12
  { 5,  1,   0}, // #13
  { 7,  1,   0}, // #14
  { 8,  1,   0}, // #15
  {28,  1,   0}, // #16
  { 4,  2,   0}, // #17
  { 5,  3,   0}, // #18
  { 7,  2,   0}, // #19
  { 8,  2,   0}, // #20
  {15,  2,   0}, // #21
  {16,  1,   0}, // #22
  {19,  1,   0}, // #23
  {23,  1,   0}, // #24
  {28,  6,   0}, // #25
  { 4,  1,   0}, // #26
  { 5,  1,   0}, // #27
  { 7,  1,   0}, // #28
  { 8,  1,   0}, // #29
  {13,  1,   0}, // #30
  {14,  1,   0}, // #31
  {15,  1,   0}, // #32
  {16,  1,   0}, // #33
  {28,  2,   0}, // #34
  {15,  1,   0}, // #35
  {19,  1,   0}, // #36
  {23,  1,   0}, // #37
  {28,  2,   0}, // #38
  {15,  1,   0}, // #39
  {16,  1,   0}, // #40
  {28,  1,   0}, // #41
  { 4,  1,   0}, // #42
  { 5,  1,   0}, // #43
  {28,  1,   0}, // #44
  { 2,  1,   0}, // #45
  { 3,  1,   0}, // #46
  { 4,  1,   0}, // #47
  { 5,  1,   0}, // #48
  { 9,  1,   0}, // #49
  {10,  1,   0}, // #50
  {11,  1,   0}, // #51
  {28,  1,   0}, // #52
  {15,  2,   0}, // #53
  {16,  1,   0}, // #54
  {19,  1,   0}, // #55
  {23,  1,   0}, // #56
  {28,  3,   0}, // #57
  { 5,  1,   0}, // #58
  {15,  2,   0}, // #59
  {16,  1,   0}, // #60
  {19,  1,   0}, // #61
  {23,  1,   0}, // #62
  {28,  4,   0}, // #63
  { 4,  1,   0}, // #64
  { 5,  2,   0}, // #65
  { 7,  1,   0}, // #66
  { 8,  1,   0}, // #67
  {15,  2,   0}, // #68
  {16,  1,   0}, // #69
  {19,  1,   0}, // #70
  {23,  1,   0}, // #71
  {28,  5,   0}, // #72
  { 4,  1,   0}, // #73
  { 5,  2,   0}, // #74
  { 7,  1,   0}, // #75
  { 8,  1,   0}, // #76
  {28,  2,   0}, // #77
  { 3,  1,   0}, // #78
  { 4,  1,   0}, // #79
  { 5,  1,   0}, // #80
  {10,  1,   0}, // #81
  {11,  1,   0}, // #82
  {15,  1,   0}, // #83
  {16,  1,   0}, // #84
  {28,  2,   0}, // #85
  { 3,  1,   0}, // #86
  { 4,  1,   0}, // #87
  { 5,  1,   0}, // #88
  {10,  1,   0}, // #89
  {11,  1,   0}, // #90
  {28,  1,   0}, // #91
  { 3,  1,   0}, // #92
  { 4,  1,   0}, // #93
  { 5,  1,   0}, // #94
  { 6,  1,   0}, // #95
  { 7,  1,   0}, // #96
  {10,  1,   0}, // #97
  {11,  1,   0}, // #98
  {20,  1,   0}, // #99
  {28,  1,   0}, // #100
  { 2,  1,   0}, // #101
  { 3,  1,   0}, // #102
  { 4,  1,   0}, // #103
  { 5,  1,   0}, // #104
  {15,  1,   0}, // #105
  {16,  1,   0}, // #106
  {28,  2,   0}, // #107
  { 2,  1,   0}, // #108
  { 3,  1,   0}, // #109
  { 4,  1,   0}, // #110
  { 5,  1,   0}, // #111
  {28,  1,   0}, // #112
  { 2,  2,   0}, // #113
  { 3,  2,   0}, // #114
  { 4,  2,   0}, // #115
  { 5,  2,   0}, // #116
  {15,  1,   0}, // #117
  {16,  1,   0}, // #118
  {28,  3,   0}, // #119
  { 2,  2,   0}, // #120
  { 3,  2,   0}, // #121
  { 4,  2,   0}, // #122
  { 5,  2,   0}, // #123
  {28,  2,   0}, // #124
  { 1,  4,   0}, // #125
  { 2,  5,   0}, // #126
  { 3, 11,   0}, // #127
  { 4, 13,   0}, // #128
  { 5, 13,   0}, // #129
  { 6,  7,   0}, // #130
  { 7,  9,   0}, // #131
  { 8,  6,   0}, // #132
  {10,  6,   0}, // #133
  {11,  6,   0}, // #134
  {15,  1,   0}, // #135
  {16,  1,   0}, // #136
  {20,  3,   0}, // #137
  {28, 14,   0}, // #138
  { 1,  4,   0}, // #139
  { 2,  5,   0}, // #140
  { 3, 12,   0}, // #141
  { 4, 14,   0}, // #142
  { 5, 14,   0}, // #143
  { 6,  7,   0}, // #144
  { 7,  9,   0}, // #145
  { 8,  6,   0}, // #146
  {10,  6,   0}, // #147
  {11,  6,   0}, // #148
  {20,  3,   0}, // #149
  {28, 14,   0}, // #150
  { 2,  1,   0}, // #151
  { 3,  1,   0}, // #152
  { 4,  2,   0}, // #153
  { 5,  2,   0}, // #154
  { 7,  1,   0}, // #155
  { 8,  1,   0}, // #156
  { 9,  1,   0}, // #157
  {10,  1,   0}, // #158
  {11,  1,   0}, // #159
  {15,  1,   0}, // #160
  {16,  1,   0}, // #161
  {28,  3,   0}, // #162
  { 2,  1,   0}, // #163
  { 3,  1,   0}, // #164
  { 4,  2,   0}, // #165
  { 5,  2,   0}, // #166
  { 7,  1,   0}, // #167
  { 8,  1,   0}, // #168
  { 9,  1,   0}, // #169
  {10,  1,   0}, // #170
  {11,  1,   0}, // #171
  {28,  2,   0}, // #172
  { 5,  1,   0}, // #173
  {11,  1,   0}, // #174
  {15,  1,   0}, // #175
  {16,  1,   0}, // #176
  {28,  2,   0}, // #177
  { 5,  1,   0}, // #178
  {11,  1,   0}, // #179
  {28,  1,   0}, // #180
  { 2,  1,   0}, // #181
  { 3,  1,   0}, // #182
  { 4,  1,   0}, // #183
  { 5,  1,   0}, // #184
  { 9,  1,   0}, // #185
  {10,  1,   0}, // #186
  {11,  1,   0}, // #187
  {15,  1,   0}, // #188
  {16,  1,   0}, // #189
  {28,  2,   0}, // #190
  { 2,  1,   0}, // #191
  { 3,  1,   0}, // #192
  { 4,  3,   0}, // #193
  { 5,  9,   0}, // #194
  { 7,  2,   0}, // #195
  { 8,  2,   0}, // #196
  { 9,  1,   0}, // #197
  {10,  1,   0}, // #198
  {11,  3,   0}, // #199
  {15,  1,   0}, // #200
  {16,  1,   0}, // #201
  {28, 10,   0}, // #202
  { 2,  1,   0}, // #203
  { 3,  1,   0}, // #204
  { 4,  1,   0}, // #205
  { 5,  1,   0}, // #206
  { 9,  1,   0}, // #207
  {10,  1,   0}, // #208
  {11,  1,   0}, // #209
  {15,  2,   0}, // #210
  {16,  1,   0}, // #211
  {19,  1,   0}, // #212
  {23,  1,   0}, // #213
  {28,  4,   0}, // #214
  { 2,  1,   0}, // #215
  { 3,  1,   0}, // #216
  { 4,  3,   0}, // #217
  { 5,  8,   0}, // #218
  { 7,  2,   0}, // #219
  { 8,  2,   0}, // #220
  { 9,  1,   0}, // #221
  {10,  1,   0}, // #222
  {11,  3,   0}, // #223
  {15,  2,   0}, // #224
  {16,  1,   0}, // #225
  {19,  1,   0}, // #226
  {23,  1,   0}, // #227
  {28, 11,   0}, // #228
  { 4,  1,   0}, // #229
  { 5,  1,   0}, // #230
  { 7,  1,   0}, // #231
  { 8,  1,   0}, // #232
  {15,  1,   0}, // #233
  {16,  1,   0}, // #234
  {28,  2,   0}, // #235
  { 5,  3,   0}, // #236
  {28,  3,   0}, // #237
  { 4,  2,   0}, // #238
  { 5,  5,   0}, // #239
  { 7,  2,   0}, // #240
  { 8,  2,   0}, // #241
  {28,  5,   0}, // #242
  { 1,  1,   0}, // #243
  { 2,  1,   0}, // #244
  { 3,  1,   0}, // #245
  { 4,  1,   0}, // #246
  { 5,  1,   0}, // #247
  { 6,  1,   0}, // #248
  { 7,  1,   0}, // #249
  { 8,  1,   0}, // #250
  {15,  1,   0}, // #251
  {16,  1,   0}, // #252
  {28,  2,   0}, // #253
  { 2,  1,   0}, // #254
  { 3,  2,   0}, // #255
  { 4,  2,   0}, // #256
  { 5,  2,   0}, // #257
  { 6,  1,   0}, // #258
  { 7,  1,   0}, // #259
  {10,  1,   0}, // #260
  {11,  1,   0}, // #261
  {20,  1,   0}, // #262
  {28,  2,   0}, // #263
  { 2,  1,   0}, // #264
  { 3,  2,   0}, // #265
  { 4,  2,   0}, // #266
  { 5,  2,   0}, // #267
  { 6,  1,   0}, // #268
  { 7,  1,   0}, // #269
  {10,  1,   0}, // #270
  {11,  1,   0}, // #271
  {15,  1,   0}, // #272
  {16,  1,   0}, // #273
  {20,  1,   0}, // #274
  {28,  3,   0}, // #275
  { 1,  1,   0}, // #276
  { 2,  2,   0}, // #277
  { 3,  2,   0}, // #278
  { 4,  2,   0}, // #279
  { 5,  2,   0}, // #280
  { 6,  1,   0}, // #281
  { 7,  1,   0}, // #282
  { 8,  1,   0}, // #283
  {15,  1,   0}, // #284
  {16,  1,   0}, // #285
  {28,  3,   0}, // #286
  { 1,  1,   0}, // #287
  { 2,  2,   0}, // #288
  { 3,  2,   0}, // #289
  { 4,  2,   0}, // #290
  { 5,  2,   0}, // #291
  { 6,  1,   0}, // #292
  { 7,  1,   0}, // #293
  { 8,  1,   0}, // #294
  {28,  2,   0}, // #295
  { 2,  3,   0}, // #296
  { 3,  3,   0}, // #297
  { 4,  3,   0}, // #298
  { 5,  4,   0}, // #299
  { 9,  3,   0}, // #300
  {10,  3,   0}, // #301
  {11,  3,   0}, // #302
  {15,  1,   0}, // #303
  {16,  1,   0}, // #304
  {28,  5,   0}, // #305
  { 2,  3,   0}, // #306
  { 3,  3,   0}, // #307
  { 4,  3,   0}, // #308
  { 5,  4,   0}, // #309
  { 9,  3,   0}, // #310
  {10,  3,   0}, // #311
  {11,  3,   0}, // #312
  {28,  4,   0}, // #313
  { 2,  3,   0}, // #314
  { 3,  3,   0}, // #315
  { 4,  3,   0}, // #316
  { 5,  3,   0}, // #317
  { 9,  3,   0}, // #318
  {10,  3,   0}, // #319
  {11,  3,   0}, // #320
  {15,  1,   0}, // #321
  {16,  1,   0}, // #322
  {28,  4,   0}, // #323
  { 2,  3,   0}, // #324
  { 3,  3,   0}, // #325
  { 4,  3,   0}, // #326
  { 5,  3,   0}, // #327
  { 9,  3,   0}, // #328
  {10,  3,   0}, // #329
  {11,  3,   0}, // #330
  {28,  3,   0}, // #331
  { 2,  2,   0}, // #332
  { 3,  3,   0}, // #333
  { 4,  3,   0}, // #334
  { 5,  3,   0}, // #335
  {10,  1,   0}, // #336
  {11,  1,   0}, // #337
  {15,  1,   0}, // #338
  {16,  1,   0}, // #339
  {28,  4,   0}, // #340
  { 2,  2,   0}, // #341
  { 3,  3,   0}, // #342
  { 4,  3,   0}, // #343
  { 5,  3,   0}, // #344
  {10,  1,   0}, // #345
  {11,  1,   0}, // #346
  {28,  3,   0}, // #347
  { 2,  2,   0}, // #348
  { 3,  5,   0}, // #349
  { 4,  6,   0}, // #350
  { 5,  6,   0}, // #351
  { 6,  1,   0}, // #352
  { 7,  2,   0}, // #353
  { 8,  1,   0}, // #354
  {10,  3,   0}, // #355
  {11,  3,   0}, // #356
  {15,  1,   0}, // #357
  {16,  1,   0}, // #358
  {20,  1,   0}, // #359
  {28,  7,   0}, // #360
  { 2,  2,   0}, // #361
  { 3,  5,   0}, // #362
  { 4,  6,   0}, // #363
  { 5,  6,   0}, // #364
  { 6,  1,   0}, // #365
  { 7,  2,   0}, // #366
  { 8,  1,   0}, // #367
  {10,  3,   0}, // #368
  {11,  3,   0}, // #369
  {20,  1,   0}, // #370
  {28,  6,   0}, // #371
  { 3,  1,   0}, // #372
  { 4,  1,   0}, // #373
  { 5,  1,   0}, // #374
  {10,  1,   0}, // #375
  {11,  1,   0}, // #376
  {15,  1,   0}, // #377
  {19,  1,   0}, // #378
  {23,  1,   0}, // #379
  {28,  3,   0}, // #380
  { 1,  1,   0}, // #381
  { 2,  1,   0}, // #382
  { 3,  2,   0}, // #383
  { 4,  2,   0}, // #384
  { 5,  2,   0}, // #385
  { 6,  1,   0}, // #386
  { 7,  1,   0}, // #387
  { 8,  1,   0}, // #388
  {10,  1,   0}, // #389
  {11,  1,   0}, // #390
  {28,  2,   0}, // #391
  { 3,  1,   0}, // #392
  { 4,  1,   0}, // #393
  { 5,  1,   0}, // #394
  { 6,  1,   0}, // #395
  { 7,  1,   0}, // #396
  {10,  1,   0}, // #397
  {11,  1,   0}, // #398
  {13,  1,   0}, // #399
  {14,  1,   0}, // #400
  {15,  1,   0}, // #401
  {16,  1,   0}, // #402
  {20,  1,   0}, // #403
  {28,  2,   0}, // #404
  { 1,  1,   0}, // #405
  { 2,  1,   0}, // #406
  { 3,  9,   0}, // #407
  { 4, 10,   0}, // #408
  { 5, 10,   0}, // #409
  { 6,  9,   0}, // #410
  { 7, 10,   0}, // #411
  { 8,  2,   0}, // #412
  {28, 10,   0}, // #413
  { 3,  2,   0}, // #414
  { 4,  2,   0}, // #415
  { 5,  2,   0}, // #416
  { 6,  2,   0}, // #417
  { 7,  2,   0}, // #418
  {28,  2,   0}, // #419
  { 3,  3,   0}, // #420
  { 4,  3,   0}, // #421
  { 5,  3,   0}, // #422
  { 6,  2,   0}, // #423
  { 7,  2,   0}, // #424
  {10,  3,   0}, // #425
  {11,  3,   0}, // #426
  {15,  1,   0}, // #427
  {16,  1,   0}, // #428
  {20,  2,   0}, // #429
  {28,  4,   0}, // #430
  { 3,  3,   0}, // #431
  { 4,  3,   0}, // #432
  { 5,  3,   0}, // #433
  { 6,  2,   0}, // #434
  { 7,  2,   0}, // #435
  {10,  3,   0}, // #436
  {11,  3,   0}, // #437
  {20,  2,   0}, // #438
  {28,  3,   0}, // #439
  { 2,  1,   0}, // #440
  { 3,  1,   0}, // #441
  { 4,  2,   0}, // #442
  { 5,  4,   0}, // #443
  { 7,  1,   0}, // #444
  { 8,  1,   0}, // #445
  { 9,  1,   0}, // #446
  {10,  1,   0}, // #447
  {11,  1,   0}, // #448
  {15,  1,   0}, // #449
  {16,  1,   0}, // #450
  {28,  5,   0}, // #451
  { 2,  1,   0}, // #452
  { 3,  1,   0}, // #453
  { 4,  2,   0}, // #454
  { 5,  4,   0}, // #455
  { 7,  1,   0}, // #456
  { 8,  1,   0}, // #457
  { 9,  1,   0}, // #458
  {10,  1,   0}, // #459
  {11,  1,   0}, // #460
  {28,  4,   0}, // #461
  { 2,  1,   0}, // #462
  { 3,  1,   0}, // #463
  { 4,  1,   0}, // #464
  { 5,  2,   0}, // #465
  { 9,  1,   0}, // #466
  {10,  1,   0}, // #467
  {11,  1,   0}, // #468
  {15,  1,   0}, // #469
  {16,  1,   0}, // #470
  {28,  3,   0}, // #471
  { 2,  1,   0}, // #472
  { 3,  1,   0}, // #473
  { 4,  1,   0}, // #474
  { 5,  2,   0}, // #475
  { 9,  1,   0}, // #476
  {10,  1,   0}, // #477
  {11,  1,   0}, // #478
  {28,  2,   0}, // #479
  { 2,  1,   0}, // #480
  { 3,  1,   0}, // #481
  { 4,  2,   0}, // #482
  { 5,  3,   0}, // #483
  { 7,  1,   0}, // #484
  { 8,  1,   0}, // #485
  { 9,  1,   0}, // #486
  {10,  1,   0}, // #487
  {11,  1,   0}, // #488
  {15,  1,   0}, // #489
  {16,  1,   0}, // #490
  {28,  4,   0}, // #491
  { 2,  1,   0}, // #492
  { 3,  1,   0}, // #493
  { 4,  2,   0}, // #494
  { 5,  3,   0}, // #495
  { 7,  1,   0}, // #496
  { 8,  1,   0}, // #497
  { 9,  1,   0}, // #498
  {10,  1,   0}, // #499
  {11,  1,   0}, // #500
  {28,  3,   0}, // #501
  { 2,  1,   0}, // #502
  { 3,  2,   0}, // #503
  { 4,  2,   0}, // #504
  { 5,  2,   0}, // #505
  { 6,  1,   0}, // #506
  { 7,  1,   0}, // #507
  { 9,  1,   0}, // #508
  {10,  2,   0}, // #509
  {11,  2,   0}, // #510
  {15,  1,   0}, // #511
  {16,  1,   0}, // #512
  {20,  1,   0}, // #513
  {28,  3,   0}, // #514
  { 2,  1,   0}, // #515
  { 3,  2,   0}, // #516
  { 4,  2,   0}, // #517
  { 5,  2,   0}, // #518
  { 6,  1,   0}, // #519
  { 7,  1,   0}, // #520
  { 9,  1,   0}, // #521
  {10,  2,   0}, // #522
  {11,  2,   0}, // #523
  {20,  1,   0}, // #524
  {28,  2,   0}, // #525
  { 3,  1,   0}, // #526
  { 4,  1,   0}, // #527
  { 5,  1,   0}, // #528
  { 6,  1,   0}, // #529
  { 7,  1,   0}, // #530
  {10,  1,   0}, // #531
  {11,  1,   0}, // #532
  {15,  1,   0}, // #533
  {16,  1,   0}, // #534
  {20,  1,   0}, // #535
  {28,  2,   0}, // #536
  { 1,  1,   0}, // #537
  { 2,  1,   0}, // #538
  { 3,  2,   0}, // #539
  { 4,  3,   0}, // #540
  { 5,  3,   0}, // #541
  { 6,  1,   0}, // #542
  { 7,  2,   0}, // #543
  { 8,  2,   0}, // #544
  {15,  1,   0}, // #545
  {16,  1,   0}, // #546
  {28,  4,   0}, // #547
  { 3,  1,   0}, // #548
  { 4,  1,   0}, // #549
  { 5,  1,   0}, // #550
  { 6,  1,   0}, // #551
  { 7,  1,   0}, // #552
  {28,  1,   0}, // #553
  { 3,  1,   0}, // #554
  { 4,  1,   0}, // #555
  { 5,  1,   0}, // #556
  { 6,  1,   0}, // #557
  { 7,  1,   0}, // #558
  {15,  1,   0}, // #559
  {16,  1,   0}, // #560
  {28,  2,   0}, // #561
  { 3,  3,   0}, // #562
  { 4,  3,   0}, // #563
  { 5,  3,   0}, // #564
  { 6,  3,   0}, // #565
  { 7,  3,   0}, // #566
  {10,  2,   0}, // #567
  {11,  2,   0}, // #568
  {15,  1,   0}, // #569
  {16,  1,   0}, // #570
  {20,  2,   0}, // #571
  {28,  4,   0}, // #572
  { 3,  3,   0}, // #573
  { 4,  3,   0}, // #574
  { 5,  3,   0}, // #575
  { 6,  3,   0}, // #576
  { 7,  3,   0}, // #577
  {10,  2,   0}, // #578
  {11,  2,   0}, // #579
  {20,  2,   0}, // #580
  {28,  3,   0}, // #581
  { 3,  2,   0}, // #582
  { 4,  2,   0}, // #583
  { 5,  2,   0}, // #584
  { 6,  1,   0}, // #585
  { 7,  1,   0}, // #586
  {10,  2,   0}, // #587
  {11,  2,   0}, // #588
  {20,  1,   0}, // #589
  {28,  2,   0}, // #590
  { 1,  1,   0}, // #591
  { 2,  1,   0}, // #592
  { 3,  2,   0}, // #593
  { 4,  2,   0}, // #594
  { 5,  2,   0}, // #595
  { 6,  2,   0}, // #596
  { 7,  2,   0}, // #597
  { 8,  1,   0}, // #598
  {10,  1,   0}, // #599
  {11,  1,   0}, // #600
  {15,  1,   0}, // #601
  {16,  1,   0}, // #602
  {20,  1,   0}, // #603
  {28,  3,   0}, // #604
  { 1,  1,   0}, // #605
  { 2,  1,   0}, // #606
  { 3,  2,   0}, // #607
  { 4,  2,   0}, // #608
  { 5,  2,   0}, // #609
  { 6,  2,   0}, // #610
  { 7,  2,   0}, // #611
  { 8,  1,   0}, // #612
  {10,  1,   0}, // #613
  {11,  1,   0}, // #614
  {20,  1,   0}, // #615
  {28,  2,   0}, // #616
  { 3,  2,   0}, // #617
  { 4,  2,   0}, // #618
  { 5,  2,   0}, // #619
  { 6,  1,   0}, // #620
  { 7,  1,   0}, // #621
  {10,  2,   0}, // #622
  {11,  2,   0}, // #623
  {15,  1,   0}, // #624
  {16,  1,   0}, // #625
  {20,  1,   0}, // #626
  {28,  3,   0}, // #627
  { 1,  3,   0}, // #628
  { 2,  4,   0}, // #629
  { 3,  6,   0}, // #630
  { 4,  7,   0}, // #631
  { 5,  7,   0}, // #632
  { 6,  4,   0}, // #633
  { 7,  5,   0}, // #634
  { 8,  4,   0}, // #635
  { 9,  1,   0}, // #636
  {10,  2,   0}, // #637
  {11,  2,   0}, // #638
  {15,  1,   0}, // #639
  {16,  1,   0}, // #640
  {20,  1,   0}, // #641
  {28,  8,   0}, // #642
  { 1,  3,   0}, // #643
  { 2,  4,   0}, // #644
  { 3,  7,   0}, // #645
  { 4,  8,   0}, // #646
  { 5,  8,   0}, // #647
  { 6,  4,   0}, // #648
  { 7,  5,   0}, // #649
  { 8,  4,   0}, // #650
  { 9,  1,   0}, // #651
  {10,  2,   0}, // #652
  {11,  2,   0}, // #653
  {20,  1,   0}, // #654
  {28,  8,   0}, // #655
  { 1,  3,   0}, // #656
  { 2,  4,   0}, // #657
  { 3,  7,   0}, // #658
  { 4,  8,   0}, // #659
  { 5,  8,   0}, // #660
  { 6,  4,   0}, // #661
  { 7,  5,   0}, // #662
  { 8,  4,   0}, // #663
  { 9,  1,   0}, // #664
  {10,  2,   0}, // #665
  {11,  2,   0}, // #666
  {15,  1,   0}, // #667
  {16,  1,   0}, // #668
  {20,  1,   0}, // #669
  {28,  9,   0}, // #670
  { 1,  3,   0}, // #671
  { 2,  4,   0}, // #672
  { 3,  8,   0}, // #673
  { 4,  9,   0}, // #674
  { 5,  9,   0}, // #675
  { 6,  4,   0}, // #676
  { 7,  5,   0}, // #677
  { 8,  4,   0}, // #678
  { 9,  1,   0}, // #679
  {10,  2,   0}, // #680
  {11,  2,   0}, // #681
  {20,  1,   0}, // #682
  {28,  9,   0}, // #683
  { 1,  3,   0}, // #684
  { 2,  3,   0}, // #685
  { 3,  3,   0}, // #686
  { 4,  3,   0}, // #687
  { 5,  3,   0}, // #688
  { 6,  3,   0}, // #689
  { 7,  3,   0}, // #690
  { 8,  3,   0}, // #691
  {15,  1,   0}, // #692
  {16,  1,   0}, // #693
  {28,  4,   0}, // #694
  { 1,  3,   0}, // #695
  { 2,  3,   0}, // #696
  { 3,  3,   0}, // #697
  { 4,  3,   0}, // #698
  { 5,  3,   0}, // #699
  { 6,  3,   0}, // #700
  { 7,  3,   0}, // #701
  { 8,  3,   0}, // #702
  {28,  3,   0}, // #703
  { 3,  3,   0}, // #704
  { 4,  3,   0}, // #705
  { 5,  3,   0}, // #706
  {10,  2,   0}, // #707
  {11,  2,   0}, // #708
  {15,  1,   0}, // #709
  {16,  1,   0}, // #710
  {28,  4,   0}, // #711
  { 3,  3,   0}, // #712
  { 4,  3,   0}, // #713
  { 5,  3,   0}, // #714
  {10,  2,   0}, // #715
  {11,  2,   0}, // #716
  {28,  3,   0}, // #717
  { 2,  1,   0}, // #718
  { 3,  2,   0}, // #719
  { 4,  2,   0}, // #720
  { 5,  2,   0}, // #721
  {10,  1,   0}, // #722
  {11,  1,   0}, // #723
  {28,  2,   0}, // #724
  { 4,  4,   0}, // #725
  { 5,  6,   0}, // #726
  { 7,  4,   0}, // #727
  { 8,  4,   0}, // #728
  {28,  6,   0}, // #729
  { 2,  2,   0}, // #730
  { 3,  2,   0}, // #731
  { 4,  5,   0}, // #732
  { 5,  7,   0}, // #733
  { 7,  3,   0}, // #734
  { 8,  3,   0}, // #735
  { 9,  2,   0}, // #736
  {10,  2,   0}, // #737
  {11,  2,   0}, // #738
  {15,  2,   0}, // #739
  {16,  1,   0}, // #740
  {19,  1,   0}, // #741
  {23,  1,   0}, // #742
  {28, 10,   0}, // #743
  { 2,  2,   0}, // #744
  { 3,  2,   0}, // #745
  { 4,  7,   0}, // #746
  { 5,  9,   0}, // #747
  { 7,  5,   0}, // #748
  { 8,  5,   0}, // #749
  { 9,  2,   0}, // #750
  {10,  2,   0}, // #751
  {11,  2,   0}, // #752
  {28,  9,   0}, // #753
  { 4,  2,   0}, // #754
  { 5,  3,   0}, // #755
  { 7,  2,   0}, // #756
  { 8,  2,   0}, // #757
  {28,  3,   0}, // #758
  { 4,  2,   0}, // #759
  { 5,  2,   0}, // #760
  { 7,  2,   0}, // #761
  { 8,  2,   0}, // #762
  {28,  2,   0}, // #763
  { 4,  1,   0}, // #764
  { 5,  1,   0}, // #765
  { 7,  1,   0}, // #766
  { 8,  1,   0}, // #767
  {15,  2,   0}, // #768
  {16,  1,   0}, // #769
  {19,  1,   0}, // #770
  {23,  1,   0}, // #771
  {28,  4,   0}, // #772
  { 4,  2,   0}, // #773
  { 5,  2,   0}, // #774
  { 7,  2,   0}, // #775
  { 8,  2,   0}, // #776
  {15,  2,   0}, // #777
  {16,  1,   0}, // #778
  {19,  1,   0}, // #779
  {23,  1,   0}, // #780
  {28,  5,   0}, // #781
  { 4,  4,   0}, // #782
  { 5,  4,   0}, // #783
  { 7,  4,   0}, // #784
  { 8,  4,   0}, // #785
  {28,  4,   0}, // #786
  { 4,  2,   0}, // #787
  { 5,  2,   0}, // #788
  { 7,  2,   0}, // #789
  { 8,  2,   0}, // #790
  {15,  1,   0}, // #791
  {19,  1,   0}, // #792
  {23,  1,   0}, // #793
  {28,  4,   0}, // #794
  { 2,  1,   0}, // #795
  { 3,  1,   0}, // #796
  { 4,  2,   0}, // #797
  { 5,  3,   0}, // #798
  { 7,  1,   0}, // #799
  { 8,  1,   0}, // #800
  { 9,  1,   0}, // #801
  {10,  1,   0}, // #802
  {11,  1,   0}, // #803
  {15,  2,   0}, // #804
  {16,  1,   0}, // #805
  {19,  1,   0}, // #806
  {23,  1,   0}, // #807
  {28,  6,   0}, // #808
  { 2,  1,   0}, // #809
  { 3,  1,   0}, // #810
  { 4,  1,   0}, // #811
  { 5,  2,   0}, // #812
  { 9,  1,   0}, // #813
  {10,  1,   0}, // #814
  {11,  1,   0}, // #815
  {15,  2,   0}, // #816
  {16,  1,   0}, // #817
  {19,  1,   0}, // #818
  {23,  1,   0}, // #819
  {28,  5,   0}, // #820
  { 1,  1,   0}, // #821
  { 2,  1,   0}, // #822
  { 3,  1,   0}, // #823
  { 4,  1,   0}, // #824
  { 5,  1,   0}, // #825
  { 6,  1,   0}, // #826
  { 7,  1,   0}, // #827
  { 8,  1,   0}, // #828
  {28,  1,   0}, // #829
  {29,  7,   0}, // #830
  { 1,  1,   0}, // #831
  { 2,  1,   0}, // #832
  { 3,  1,   0}, // #833
  { 4,  2,   0}, // #834
  { 5,  2,   0}, // #835
  { 6,  1,   0}, // #836
  { 7,  2,   0}, // #837
  { 8,  2,   0}, // #838
  {15,  1,   0}, // #839
  {19,  1,   0}, // #840
  {23,  1,   0}, // #841
  {28,  4,   0}, // #842
  { 3,  3,   0}, // #843
  { 4,  3,   0}, // #844
  { 5,  3,   0}, // #845
  {15,  1,   0}, // #846
  {16,  1,   0}, // #847
  {28,  4,   0}, // #848
  { 3,  3,   0}, // #849
  { 4,  3,   0}, // #850
  { 5,  3,   0}, // #851
  {28,  3,   0}, // #852
  { 2,  1,   0}, // #853
  { 3,  1,   0}, // #854
  { 4,  1,   0}, // #855
  { 5,  1,   0}, // #856
  {15,  1,   0}, // #857
  {19,  1,   0}, // #858
  {23,  1,   0}, // #859
  {28,  3,   0}, // #860
  { 1,  1,   0}, // #861
  { 2,  1,   0}, // #862
  { 3,  1,   0}, // #863
  { 4,  1,   0}, // #864
  { 5,  1,   0}, // #865
  { 6,  1,   0}, // #866
  { 7,  1,   0}, // #867
  { 8,  1,   0}, // #868
  {15,  1,   0}, // #869
  {19,  1,   0}, // #870
  {23,  1,   0}, // #871
  {28,  3,   0}, // #872
  { 1,  1,   0}, // #873
  { 2,  1,   0}, // #874
  { 3,  2,   0}, // #875
  { 4,  2,   0}, // #876
  { 5,  2,   0}, // #877
  { 6,  1,   0}, // #878
  { 7,  1,   0}, // #879
  { 8,  1,   0}, // #880
  {28,  2,   0}, // #881
  { 1,  2,   0}, // #882
  { 2,  3,   0}, // #883
  { 3,  7,   0}, // #884
  { 4, 15,   0}, // #885
  { 5, 15,   0}, // #886
  { 6,  6,   0}, // #887
  { 7, 10,   0}, // #888
  { 8,  6,   0}, // #889
  { 9,  1,   0}, // #890
  {10,  3,   0}, // #891
  {11,  3,   0}, // #892
  {20,  2,   0}, // #893
  {21,  4,   0}, // #894
  {28, 15,   0}, // #895
  { 2,  1,   0}, // #896
  { 3,  3,   0}, // #897
  { 4,  3,   0}, // #898
  { 5,  3,   0}, // #899
  { 6,  2,   0}, // #900
  { 7,  2,   0}, // #901
  {10,  2,   0}, // #902
  {11,  2,   0}, // #903
  {20,  2,   0}, // #904
  {28,  3,   0}, // #905
  { 1,  1,   0}, // #906
  { 2,  2,   0}, // #907
  { 3,  3,   0}, // #908
  { 4,  3,   0}, // #909
  { 5,  3,   0}, // #910
  { 6,  2,   0}, // #911
  { 7,  2,   0}, // #912
  { 8,  1,   0}, // #913
  {10,  1,   0}, // #914
  {11,  1,   0}, // #915
  {20,  1,   0}, // #916
  {28,  3,   0}, // #917
  {14,  1,   0}, // #918
  {15,  1,   0}, // #919
  {18,  1,   0}, // #920
  {19,  1,   0}, // #921
  {28,  2,   0}, // #922
  { 5,  4,   0}, // #923
  {15,  2,   0}, // #924
  {16,  1,   0}, // #925
  {19,  1,   0}, // #926
  {23,  1,   0}, // #927
  {28,  7,   0}, // #928
  { 4,  1,   0}, // #929
  { 5,  6,   0}, // #930
  { 7,  1,   0}, // #931
  { 8,  1,   0}, // #932
  {15,  2,   0}, // #933
  {16,  1,   0}, // #934
  {19,  1,   0}, // #935
  {23,  1,   0}, // #936
  {28,  9,   0}, // #937
  { 4,  2,   0}, // #938
  { 5,  2,   0}, // #939
  { 7,  1,   0}, // #940
  { 8,  1,   0}, // #941
  {28,  2,   0}, // #942
  {13,  1,   0}, // #943
  {14,  1,   0}, // #944
  {15,  1,   0}, // #945
  {16,  1,   0}, // #946
  {28,  1,   0}, // #947
  { 1,  1,   0}, // #948
  { 2,  1,   0}, // #949
  { 3,  2,   0}, // #950
  { 4,  2,   0}, // #951
  { 5,  2,   0}, // #952
  { 6,  2,   0}, // #953
  { 7,  2,   0}, // #954
  { 8,  1,   0}, // #955
  {13,  1,   0}, // #956
  {14,  1,   0}, // #957
  {15,  1,   0}, // #958
  {16,  1,   0}, // #959
  {28,  3,   0}, // #960
  { 3,  1,   0}, // #961
  { 4,  1,   0}, // #962
  { 5,  1,   0}, // #963
  { 6,  1,   0}, // #964
  { 7,  1,   0}, // #965
  {10,  1,   0}, // #966
  {11,  1,   0}, // #967
  {14,  1,   0}, // #968
  {15,  1,   0}, // #969
  {18,  1,   0}, // #970
  {19,  1,   0}, // #971
  {20,  1,   0}, // #972
  {28,  3,   0}, // #973
  { 2,  1,   0}, // #974
  { 3,  1,   0}, // #975
  { 4,  7,   0}, // #976
  { 5, 11,   0}, // #977
  { 7,  6,   0}, // #978
  { 8,  6,   0}, // #979
  { 9,  1,   0}, // #980
  {10,  1,   0}, // #981
  {11,  1,   0}, // #982
  {28, 11,   0}, // #983
  { 4,  1,   0}, // #984
  { 5,  1,   0}, // #985
  { 7,  1,   0}, // #986
  { 8,  1,   0}, // #987
  {14,  1,   0}, // #988
  {15,  1,   0}, // #989
  {18,  1,   0}, // #990
  {19,  1,   0}, // #991
  {21,  1,   0}, // #992
  {28,  3,   0}, // #993
  { 3,  1,   0}, // #994
  { 4,  2,   0}, // #995
  { 5,  2,   0}, // #996
  { 6,  1,   0}, // #997
  { 7,  2,   0}, // #998
  { 8,  1,   0}, // #999
  {10,  1,   0}, // #1000
  {11,  1,   0}, // #1001
  {20,  1,   0}, // #1002
  {28,  2,   0}, // #1003
  { 2,  2,   0}, // #1004
  { 3,  2,   0}, // #1005
  { 4,  9,   0}, // #1006
  { 5, 13,   0}, // #1007
  { 7,  7,   0}, // #1008
  { 8,  7,   0}, // #1009
  { 9,  2,   0}, // #1010
  {10,  2,   0}, // #1011
  {11,  2,   0}, // #1012
  {15,  2,   0}, // #1013
  {16,  1,   0}, // #1014
  {19,  1,   0}, // #1015
  {23,  1,   0}, // #1016
  {28, 16,   0}, // #1017
  { 2,  1,   0}, // #1018
  { 3,  1,   0}, // #1019
  { 4,  5,   0}, // #1020
  { 5,  7,   0}, // #1021
  { 7,  4,   0}, // #1022
  { 8,  4,   0}, // #1023
  { 9,  1,   0}, // #1024
  {10,  1,   0}, // #1025
  {11,  1,   0}, // #1026
  {28,  7,   0}, // #1027
  { 1,  2,   0}, // #1028
  { 2,  2,   0}, // #1029
  { 3,  6,   0}, // #1030
  { 4, 12,   0}, // #1031
  { 5, 19,   0}, // #1032
  { 6,  4,   0}, // #1033
  { 7, 10,   0}, // #1034
  { 8,  8,   0}, // #1035
  {10,  4,   0}, // #1036
  {11,  4,   0}, // #1037
  {15,  2,   0}, // #1038
  {16,  1,   0}, // #1039
  {19,  1,   0}, // #1040
  {20,  2,   0}, // #1041
  {23,  1,   0}, // #1042
  {28, 22,   0}, // #1043
  { 4,  4,   0}, // #1044
  { 5,  4,   0}, // #1045
  {28,  4,   0}, // #1046
  { 1,  2,   0}, // #1047
  { 2,  8,   0}, // #1048
  { 3, 12,   0}, // #1049
  { 4, 21,   0}, // #1050
  { 5, 21,   0}, // #1051
  { 6,  5,   0}, // #1052
  { 7, 14,   0}, // #1053
  { 8,  9,   0}, // #1054
  { 9,  4,   0}, // #1055
  {10,  7,   0}, // #1056
  {11,  7,   0}, // #1057
  {20,  3,   0}, // #1058
  {28, 21,   0}, // #1059
  { 1,  2,   0}, // #1060
  { 2,  4,   0}, // #1061
  { 3, 13,   0}, // #1062
  { 4, 34,   0}, // #1063
  { 5, 34,   0}, // #1064
  { 6, 11,   0}, // #1065
  { 7, 32,   0}, // #1066
  { 8, 23,   0}, // #1067
  { 9,  2,   0}, // #1068
  {10, 11,   0}, // #1069
  {11, 11,   0}, // #1070
  {15, 19,   0}, // #1071
  {16, 14,   0}, // #1072
  {19,  4,   0}, // #1073
  {20,  9,   0}, // #1074
  {23,  5,   0}, // #1075
  {28, 57,   0}, // #1076
  { 2,  1,   0}, // #1077
  { 3,  1,   0}, // #1078
  { 4,  3,   0}, // #1079
  { 5,  9,   0}, // #1080
  { 7,  2,   0}, // #1081
  { 8,  2,   0}, // #1082
  { 9,  1,   0}, // #1083
  {10,  1,   0}, // #1084
  {11,  1,   0}, // #1085
  {15,  1,   0}, // #1086
  {16,  1,   0}, // #1087
  {28, 10,   0}, // #1088
  { 3,  1,   0}, // #1089
  { 4, 10,   0}, // #1090
  { 5, 10,   0}, // #1091
  { 6,  1,   0}, // #1092
  { 7,  3,   0}, // #1093
  { 8,  2,   0}, // #1094
  {10,  1,   0}, // #1095
  {11,  1,   0}, // #1096
  {20,  1,   0}, // #1097
  {21,  2,   0}, // #1098
  {28, 10,   0}, // #1099
  { 1,  7,   0}, // #1100
  { 2, 24,   0}, // #1101
  { 3, 44,   0}, // #1102
  { 4, 70,   0}, // #1103
  { 5, 75,   0}, // #1104
  { 6, 26,   0}, // #1105
  { 7, 52,   0}, // #1106
  { 8, 32,   0}, // #1107
  { 9, 17,   0}, // #1108
  {10, 36,   0}, // #1109
  {11, 37,   0}, // #1110
  {15, 10,   0}, // #1111
  {16,  9,   0}, // #1112
  {19,  1,   0}, // #1113
  {20, 19,   0}, // #1114
  {23,  1,   0}, // #1115
  {28, 86,   0}, // #1116
  { 3,  9,   0}, // #1117
  { 4, 15,   0}, // #1118
  { 5, 15,   0}, // #1119
  { 6,  9,   0}, // #1120
  { 7,  9,   0}, // #1121
  {10,  6,   0}, // #1122
  {11,  6,   0}, // #1123
  {20,  6,   0}, // #1124
  {28, 15,   0}, // #1125
  { 1,  5,   0}, // #1126
  { 2, 20,   0}, // #1127
  { 3, 35,   0}, // #1128
  { 4, 61,   0}, // #1129
  { 5, 66,   0}, // #1130
  { 6, 20,   0}, // #1131
  { 7, 46,   0}, // #1132
  { 8, 31,   0}, // #1133
  { 9, 15,   0}, // #1134
  {10, 30,   0}, // #1135
  {11, 30,   0}, // #1136
  {15,  6,   0}, // #1137
  {16,  5,   0}, // #1138
  {19,  1,   0}, // #1139
  {20, 15,   0}, // #1140
  {23,  1,   0}, // #1141
  {28, 73,   0}, // #1142
  { 1,  5,   0}, // #1143
  { 2, 20,   0}, // #1144
  { 3, 36,   0}, // #1145
  { 4, 61,   0}, // #1146
  { 5, 66,   0}, // #1147
  { 6, 21,   0}, // #1148
  { 7, 46,   0}, // #1149
  { 8, 30,   0}, // #1150
  { 9, 15,   0}, // #1151
  {10, 30,   0}, // #1152
  {11, 30,   0}, // #1153
  {15,  6,   0}, // #1154
  {16,  5,   0}, // #1155
  {19,  1,   0}, // #1156
  {20, 15,   0}, // #1157
  {23,  1,   0}, // #1158
  {28, 73,   0}, // #1159
  { 1,  6,   0}, // #1160
  { 2, 23,   0}, // #1161
  { 3, 41,   0}, // #1162
  { 4, 68,   0}, // #1163
  { 5, 73,   0}, // #1164
  { 6, 24,   0}, // #1165
  { 7, 51,   0}, // #1166
  { 8, 33,   0}, // #1167
  { 9, 16,   0}, // #1168
  {10, 34,   0}, // #1169
  {11, 34,   0}, // #1170
  {15,  9,   0}, // #1171
  {16,  8,   0}, // #1172
  {19,  1,   0}, // #1173
  {20, 18,   0}, // #1174
  {23,  1,   0}, // #1175
  {28, 83,   0}, // #1176
  { 2,  9,   0}, // #1177
  { 3, 23,   0}, // #1178
  { 4, 53,   0}, // #1179
  { 5, 54,   0}, // #1180
  { 6,  3,   0}, // #1181
  { 7, 33,   0}, // #1182
  { 8, 20,   0}, // #1183
  { 9,  8,   0}, // #1184
  {10, 15,   0}, // #1185
  {11, 16,   0}, // #1186
  {20,  2,   0}, // #1187
  {28, 54,   0}, // #1188
  { 1,  7,   0}, // #1189
  { 2, 26,   0}, // #1190
  { 3, 46,   0}, // #1191
  { 4, 71,   0}, // #1192
  { 5, 79,   0}, // #1193
  { 6, 27,   0}, // #1194
  { 7, 52,   0}, // #1195
  { 8, 32,   0}, // #1196
  { 9, 19,   0}, // #1197
  {10, 39,   0}, // #1198
  {11, 41,   0}, // #1199
  {15,  8,   0}, // #1200
  {16,  8,   0}, // #1201
  {20, 20,   0}, // #1202
  {28, 87,   0}, // #1203
  { 1,  7,   0}, // #1204
  { 2, 26,   0}, // #1205
  { 3, 46,   0}, // #1206
  { 4, 71,   0}, // #1207
  { 5, 79,   0}, // #1208
  { 6, 27,   0}, // #1209
  { 7, 52,   0}, // #1210
  { 8, 32,   0}, // #1211
  { 9, 19,   0}, // #1212
  {10, 39,   0}, // #1213
  {11, 41,   0}, // #1214
  {15,  7,   0}, // #1215
  {16,  7,   0}, // #1216
  {20, 20,   0}, // #1217
  {28, 86,   0}, // #1218
  { 1,  2,   0}, // #1219
  { 2,  9,   0}, // #1220
  { 3, 14,   0}, // #1221
  { 4, 24,   0}, // #1222
  { 5, 24,   0}, // #1223
  { 6,  7,   0}, // #1224
  { 7, 17,   0}, // #1225
  { 8, 12,   0}, // #1226
  { 9,  6,   0}, // #1227
  {10, 11,   0}, // #1228
  {11, 11,   0}, // #1229
  {15,  1,   0}, // #1230
  {19,  1,   0}, // #1231
  {20,  5,   0}, // #1232
  {23,  1,   0}, // #1233
  {28, 26,   0}, // #1234
  { 1,  2,   0}, // #1235
  { 2, 12,   0}, // #1236
  { 3, 17,   0}, // #1237
  { 4, 27,   0}, // #1238
  { 5, 32,   0}, // #1239
  { 6,  7,   0}, // #1240
  { 7, 17,   0}, // #1241
  { 8, 12,   0}, // #1242
  { 9, 10,   0}, // #1243
  {10, 15,   0}, // #1244
  {11, 15,   0}, // #1245
  {15, 40,   0}, // #1246
  {16,  2,   0}, // #1247
  {19, 38,   0}, // #1248
  {20,  5,   0}, // #1249
  {23, 38,   0}, // #1250
  {28, 110,   0}, // #1251
  { 1,  4,   0}, // #1252
  { 2,  4,   0}, // #1253
  { 3,  6,   0}, // #1254
  { 4, 57,   0}, // #1255
  { 5, 57,   0}, // #1256
  { 6,  5,   0}, // #1257
  { 7,  9,   0}, // #1258
  { 8,  8,   0}, // #1259
  {10,  1,   0}, // #1260
  {11,  1,   0}, // #1261
  {13, 33,   0}, // #1262
  {14, 33,   0}, // #1263
  {15, 33,   0}, // #1264
  {16, 33,   0}, // #1265
  {21,  2,   0}, // #1266
  {28, 90,   0}, // #1267
  { 1,  8,   0}, // #1268
  { 2, 35,   0}, // #1269
  { 3, 79,   0}, // #1270
  { 4, 142,   0}, // #1271
  { 5, 142,   0}, // #1272
  { 6, 37,   0}, // #1273
  { 7, 100,   0}, // #1274
  { 8, 71,   0}, // #1275
  { 9, 21,   0}, // #1276
  {10, 46,   0}, // #1277
  {11, 46,   0}, // #1278
  {15,  1,   0}, // #1279
  {19,  1,   0}, // #1280
  {20, 10,   0}, // #1281
  {23,  1,   0}, // #1282
  {28, 144,   0}, // #1283
  { 1,  1,   0}, // #1284
  { 2,  1,   0}, // #1285
  { 3,  1,   0}, // #1286
  { 4,  2,   0}, // #1287
  { 5,  2,   0}, // #1288
  { 6,  1,   0}, // #1289
  { 7,  1,   0}, // #1290
  { 8,  1,   0}, // #1291
  {28,  2,   0}, // #1292
  { 3,  2,   0}, // #1293
  { 4,  2,   0}, // #1294
  { 5,  2,   0}, // #1295
  { 6,  1,   0}, // #1296
  { 7,  1,   0}, // #1297
  {28,  2,   0}, // #1298
  { 2,  1,   0}, // #1299
  { 3,  1,   0}, // #1300
  { 4,  1,   0}, // #1301
  { 5,  1,   0}, // #1302
  { 9,  1,   0}, // #1303
  {10,  1,   0}, // #1304
  {11,  1,   0}, // #1305
  {15,  1,   0}, // #1306
  {19,  1,   0}, // #1307
  {23,  1,   0}, // #1308
  {28,  3,   0}, // #1309
  { 2,  1,   0}, // #1310
  { 3,  1,   0}, // #1311
  { 4,  3,   0}, // #1312
  { 5,  3,   0}, // #1313
  { 7,  2,   0}, // #1314
  { 8,  2,   0}, // #1315
  { 9,  1,   0}, // #1316
  {10,  1,   0}, // #1317
  {11,  1,   0}, // #1318
  {28,  3,   0}, // #1319
  { 3,  1,   0}, // #1320
  { 4,  1,   0}, // #1321
  { 5,  1,   0}, // #1322
  { 6,  1,   0}, // #1323
  { 7,  1,   0}, // #1324
  {10,  1,   0}, // #1325
  {11,  1,   0}, // #1326
  {15,  1,   0}, // #1327
  {19,  1,   0}, // #1328
  {20,  1,   0}, // #1329
  {23,  1,   0}, // #1330
  {28,  3,   0}, // #1331
  { 5,  2,   0}, // #1332
  {15,  1,   0}, // #1333
  {19,  1,   0}, // #1334
  {23,  1,   0}, // #1335
  {28,  4,   0}, // #1336
  { 2,  1,   0}, // #1337
  { 3,  1,   0}, // #1338
  { 4,  2,   0}, // #1339
  { 5,  2,   0}, // #1340
  { 7,  1,   0}, // #1341
  { 8,  1,   0}, // #1342
  { 9,  1,   0}, // #1343
  {10,  1,   0}, // #1344
  {11,  1,   0}, // #1345
  {15,  1,   0}, // #1346
  {19,  1,   0}, // #1347
  {23,  1,   0}, // #1348
  {28,  4,   0}, // #1349
  { 1,  5,   0}, // #1350
  { 2, 13,   0}, // #1351
  { 3, 13,   0}, // #1352
  { 4, 13,   0}, // #1353
  { 5, 13,   0}, // #1354
  { 6,  5,   0}, // #1355
  { 7,  5,   0}, // #1356
  { 8,  5,   0}, // #1357
  { 9,  8,   0}, // #1358
  {10,  8,   0}, // #1359
  {11,  8,   0}, // #1360
  {15, 21,   0}, // #1361
  {16, 21,   0}, // #1362
  {28, 34,   0}, // #1363
  { 4,  1,   0}, // #1364
  { 5,  1,   0}, // #1365
  { 7,  1,   0}, // #1366
  { 8,  1,   0}, // #1367
  {13,  1,   0}, // #1368
  {14,  1,   0}, // #1369
  {15,  1,   0}, // #1370
  {16,  1,   0}, // #1371
  {21,  1,   0}, // #1372
  {28,  2,   0}, // #1373
  { 1,  1,   0}, // #1374
  { 2,  1,   0}, // #1375
  { 3,  1,   0}, // #1376
  { 4,  1,   0}, // #1377
  { 5,  1,   0}, // #1378
  { 6,  1,   0}, // #1379
  { 7,  1,   0}, // #1380
  { 8,  1,   0}, // #1381
  {14,  1,   0}, // #1382
  {15,  1,   0}, // #1383
  {18,  1,   0}, // #1384
  {19,  1,   0}, // #1385
  {28,  3,   0}, // #1386
  { 5,  5,   0}, // #1387
  {15,  2,   0}, // #1388
  {16,  2,   0}, // #1389
  {28,  7,   0}, // #1390
  { 5,  2,   0}, // #1391
  {15,  2,   0}, // #1392
  {16,  1,   0}, // #1393
  {19,  1,   0}, // #1394
  {23,  1,   0}, // #1395
  {28,  5,   0}, // #1396
  { 4,  2,   0}, // #1397
  { 5,  2,   0}, // #1398
  { 7,  1,   0}, // #1399
  { 8,  1,   0}, // #1400
  {13,  1,   0}, // #1401
  {14,  2,   0}, // #1402
  {15,  2,   0}, // #1403
  {16,  1,   0}, // #1404
  {18,  1,   0}, // #1405
  {19,  1,   0}, // #1406
  {21,  1,   0}, // #1407
  {28,  5,   0}, // #1408
  { 4,  1,   0}, // #1409
  { 5,  3,   0}, // #1410
  { 7,  1,   0}, // #1411
  { 8,  1,   0}, // #1412
  {15,  2,   0}, // #1413
  {16,  1,   0}, // #1414
  {19,  1,   0}, // #1415
  {23,  1,   0}, // #1416
  {28,  6,   0}, // #1417
  { 3,  2,   0}, // #1418
  { 4,  2,   0}, // #1419
  { 5,  2,   0}, // #1420
  { 6,  2,   0}, // #1421
  { 7,  2,   0}, // #1422
  {10,  2,   0}, // #1423
  {11,  2,   0}, // #1424
  {13,  1,   0}, // #1425
  {14,  1,   0}, // #1426
  {15,  1,   0}, // #1427
  {16,  1,   0}, // #1428
  {20,  2,   0}, // #1429
  {28,  3,   0}, // #1430
  { 1,  1,   0}, // #1431
  { 2,  1,   0}, // #1432
  { 3,  1,   0}, // #1433
  { 4,  1,   0}, // #1434
  { 5,  1,   0}, // #1435
  { 6,  1,   0}, // #1436
  { 7,  1,   0}, // #1437
  { 8,  1,   0}, // #1438
  {13,  1,   0}, // #1439
  {14,  1,   0}, // #1440
  {15,  1,   0}, // #1441
  {16,  1,   0}, // #1442
  {28,  2,   0}, // #1443
  { 1,  1,   0}, // #1444
  { 2,  1,   0}, // #1445
  { 3,  2,   0}, // #1446
  { 4,  2,   0}, // #1447
  { 5,  2,   0}, // #1448
  { 6,  2,   0}, // #1449
  { 7,  2,   0}, // #1450
  { 8,  1,   0}, // #1451
  {10,  1,   0}, // #1452
  {11,  1,   0}, // #1453
  {13,  1,   0}, // #1454
  {14,  1,   0}, // #1455
  {15,  1,   0}, // #1456
  {16,  1,   0}, // #1457
  {20,  1,   0}, // #1458
  {28,  3,   0}, // #1459
  { 2,  3,   0}, // #1460
  { 3,  4,   0}, // #1461
  { 4,  7,   0}, // #1462
  { 5, 10,   0}, // #1463
  { 7,  3,   0}, // #1464
  { 8,  3,   0}, // #1465
  { 9,  3,   0}, // #1466
  {10,  3,   0}, // #1467
  {11,  4,   0}, // #1468
  {28, 10,   0}, // #1469
  { 4,  2,   0}, // #1470
  { 5,  2,   0}, // #1471
  { 7,  2,   0}, // #1472
  { 8,  2,   0}, // #1473
  {15,  1,   0}, // #1474
  {16,  1,   0}, // #1475
  {28,  3,   0}, // #1476
  { 2,  2,   0}, // #1477
  { 3,  3,   0}, // #1478
  { 4,  9,   0}, // #1479
  { 5, 18,   0}, // #1480
  { 6,  1,   0}, // #1481
  { 7,  7,   0}, // #1482
  { 8,  6,   0}, // #1483
  { 9,  2,   0}, // #1484
  {10,  3,   0}, // #1485
  {11,  3,   0}, // #1486
  {20,  1,   0}, // #1487
  {28, 18,   0}, // #1488
  { 1,  2,   0}, // #1489
  { 2,  9,   0}, // #1490
  { 3, 14,   0}, // #1491
  { 4, 21,   0}, // #1492
  { 5, 24,   0}, // #1493
  { 6,  4,   0}, // #1494
  { 7, 11,   0}, // #1495
  { 8,  7,   0}, // #1496
  { 9,  7,   0}, // #1497
  {10, 12,   0}, // #1498
  {11, 12,   0}, // #1499
  {15,  1,   0}, // #1500
  {16,  1,   0}, // #1501
  {20,  2,   0}, // #1502
  {28, 25,   0}, // #1503
  { 2,  2,   0}, // #1504
  { 3,  2,   0}, // #1505
  { 4,  2,   0}, // #1506
  { 5,  3,   0}, // #1507
  { 9,  2,   0}, // #1508
  {10,  2,   0}, // #1509
  {11,  2,   0}, // #1510
  {15,  2,   0}, // #1511
  {19,  2,   0}, // #1512
  {23,  2,   0}, // #1513
  {28,  7,   0}, // #1514
  { 4,  1,   0}, // #1515
  { 5,  1,   0}, // #1516
  { 7,  1,   0}, // #1517
  { 8,  1,   0}, // #1518
  {15,  1,   0}, // #1519
  {19,  1,   0}, // #1520
  {23,  1,   0}, // #1521
  {28,  3,   0}, // #1522
  { 2,  5,   0}, // #1523
  { 3,  5,   0}, // #1524
  { 4, 16,   0}, // #1525
  { 5, 23,   0}, // #1526
  { 7, 11,   0}, // #1527
  { 8,  8,   0}, // #1528
  { 9,  5,   0}, // #1529
  {10,  5,   0}, // #1530
  {11,  5,   0}, // #1531
  {28, 23,   0}, // #1532
  { 3,  2,   0}, // #1533
  { 4,  2,   0}, // #1534
  { 5,  2,   0}, // #1535
  { 6,  2,   0}, // #1536
  { 7,  2,   0}, // #1537
  {10,  2,   0}, // #1538
  {11,  2,   0}, // #1539
  {15,  1,   0}, // #1540
  {16,  1,   0}, // #1541
  {20,  2,   0}, // #1542
  {28,  3,   0}, // #1543
  { 3,  2,   0}, // #1544
  { 4,  2,   0}, // #1545
  { 5,  2,   0}, // #1546
  { 6,  2,   0}, // #1547
  { 7,  2,   0}, // #1548
  {10,  2,   0}, // #1549
  {11,  2,   0}, // #1550
  {20,  2,   0}, // #1551
  {28,  2,   0}, // #1552
  { 1,  1,   0}, // #1553
  { 2,  6,   0}, // #1554
  { 3,  8,   0}, // #1555
  { 4, 17,   0}, // #1556
  { 5, 20,   0}, // #1557
  { 6,  2,   0}, // #1558
  { 7, 11,   0}, // #1559
  { 8,  9,   0}, // #1560
  { 9,  5,   0}, // #1561
  {10,  7,   0}, // #1562
  {11,  7,   0}, // #1563
  {15,  2,   0}, // #1564
  {16,  2,   0}, // #1565
  {20,  1,   0}, // #1566
  {28, 22,   0}, // #1567
  { 1,  1,   0}, // #1568
  { 2,  4,   0}, // #1569
  { 3,  5,   0}, // #1570
  { 4, 10,   0}, // #1571
  { 5, 10,   0}, // #1572
  { 6,  2,   0}, // #1573
  { 7,  7,   0}, // #1574
  { 8,  6,   0}, // #1575
  { 9,  3,   0}, // #1576
  {10,  4,   0}, // #1577
  {11,  4,   0}, // #1578
  {15,  3,   0}, // #1579
  {16,  3,   0}, // #1580
  {20,  1,   0}, // #1581
  {28, 13,   0}, // #1582
  { 2,  8,   0}, // #1583
  { 3, 14,   0}, // #1584
  { 4, 30,   0}, // #1585
  { 5, 54,   0}, // #1586
  { 6,  2,   0}, // #1587
  { 7, 18,   0}, // #1588
  { 8, 14,   0}, // #1589
  { 9,  8,   0}, // #1590
  {10, 10,   0}, // #1591
  {11, 11,   0}, // #1592
  {20,  2,   0}, // #1593
  {28, 54,   0}, // #1594
  { 2,  3,   0}, // #1595
  { 3,  3,   0}, // #1596
  { 4,  7,   0}, // #1597
  { 5, 10,   0}, // #1598
  { 7,  4,   0}, // #1599
  { 8,  4,   0}, // #1600
  { 9,  3,   0}, // #1601
  {10,  3,   0}, // #1602
  {11,  3,   0}, // #1603
  {28, 10,   0}, // #1604
  { 2,  3,   0}, // #1605
  { 3,  4,   0}, // #1606
  { 4, 10,   0}, // #1607
  { 5, 15,   0}, // #1608
  { 6,  1,   0}, // #1609
  { 7,  7,   0}, // #1610
  { 8,  6,   0}, // #1611
  { 9,  3,   0}, // #1612
  {10,  4,   0}, // #1613
  {11,  4,   0}, // #1614
  {20,  1,   0}, // #1615
  {28, 15,   0}, // #1616
  { 2,  1,   0}, // #1617
  { 3,  1,   0}, // #1618
  { 4, 30,   0}, // #1619
  { 5, 30,   0}, // #1620
  { 7,  8,   0}, // #1621
  { 8,  8,   0}, // #1622
  { 9,  1,   0}, // #1623
  {10,  1,   0}, // #1624
  {11,  1,   0}, // #1625
  {13,  1,   0}, // #1626
  {14,  1,   0}, // #1627
  {15,  1,   0}, // #1628
  {16,  1,   0}, // #1629
  {21,  8,   0}, // #1630
  {28, 31,   0}, // #1631
  { 2, 35,   0}, // #1632
  { 3, 90,   0}, // #1633
  { 4, 134,   0}, // #1634
  { 5, 134,   0}, // #1635
  { 6, 34,   0}, // #1636
  { 7, 78,   0}, // #1637
  { 8, 44,   0}, // #1638
  { 9, 21,   0}, // #1639
  {10, 51,   0}, // #1640
  {11, 51,   0}, // #1641
  {15,  5,   0}, // #1642
  {16,  4,   0}, // #1643
  {19,  1,   0}, // #1644
  {20,  9,   0}, // #1645
  {23,  1,   0}, // #1646
  {28, 140,   0}, // #1647
  { 2, 52,   0}, // #1648
  { 3, 97,   0}, // #1649
  { 4, 150,   0}, // #1650
  { 5, 150,   0}, // #1651
  { 6, 45,   0}, // #1652
  { 7, 98,   0}, // #1653
  { 8, 53,   0}, // #1654
  { 9, 27,   0}, // #1655
  {10, 37,   0}, // #1656
  {11, 37,   0}, // #1657
  {15,  5,   0}, // #1658
  {16,  4,   0}, // #1659
  {19,  1,   0}, // #1660
  {20, 10,   0}, // #1661
  {23,  1,   0}, // #1662
  {28, 156,   0}, // #1663
  { 2,  1,   0}, // #1664
  { 3,  4,   0}, // #1665
  { 4, 15,   0}, // #1666
  { 5, 15,   0}, // #1667
  { 6,  2,   0}, // #1668
  { 7,  5,   0}, // #1669
  { 8,  3,   0}, // #1670
  { 9,  1,   0}, // #1671
  {10,  4,   0}, // #1672
  {11,  4,   0}, // #1673
  {13,  1,   0}, // #1674
  {14,  2,   0}, // #1675
  {15,  2,   0}, // #1676
  {16,  1,   0}, // #1677
  {18,  1,   0}, // #1678
  {19,  1,   0}, // #1679
  {20,  2,   0}, // #1680
  {21,  3,   0}, // #1681
  {28, 18,   0}, // #1682
  { 1,  2,   0}, // #1683
  { 2,  2,   0}, // #1684
  { 3,  7,   0}, // #1685
  { 4, 56,   0}, // #1686
  { 5, 56,   0}, // #1687
  { 6,  7,   0}, // #1688
  { 7, 17,   0}, // #1689
  { 8, 12,   0}, // #1690
  {13,  8,   0}, // #1691
  {14,  8,   0}, // #1692
  {15,  8,   0}, // #1693
  {16,  8,   0}, // #1694
  {28, 64,   0}, // #1695
  { 1,  4,   0}, // #1696
  { 2,  4,   0}, // #1697
  { 3,  6,   0}, // #1698
  { 4, 57,   0}, // #1699
  { 5, 57,   0}, // #1700
  { 6,  5,   0}, // #1701
  { 7, 11,   0}, // #1702
  { 8, 10,   0}, // #1703
  {10,  1,   0}, // #1704
  {11,  1,   0}, // #1705
  {13, 31,   0}, // #1706
  {14, 31,   0}, // #1707
  {15, 31,   0}, // #1708
  {16, 31,   0}, // #1709
  {21,  4,   0}, // #1710
  {28, 88,   0}, // #1711
  { 1,  9,   0}, // #1712
  { 2, 10,   0}, // #1713
  { 3, 26,   0}, // #1714
  { 4, 78,   0}, // #1715
  { 5, 78,   0}, // #1716
  { 6, 25,   0}, // #1717
  { 7, 47,   0}, // #1718
  { 8, 31,   0}, // #1719
  { 9,  1,   0}, // #1720
  {10, 17,   0}, // #1721
  {11, 17,   0}, // #1722
  {14, 11,   0}, // #1723
  {15, 11,   0}, // #1724
  {18, 11,   0}, // #1725
  {19, 11,   0}, // #1726
  {20, 16,   0}, // #1727
  {21,  1,   0}, // #1728
  {28, 100,   0}, // #1729
  { 1,  1,   0}, // #1730
  { 2,  1,   0}, // #1731
  { 3,  3,   0}, // #1732
  { 4,  3,   0}, // #1733
  { 5,  3,   0}, // #1734
  { 6,  1,   0}, // #1735
  { 7,  1,   0}, // #1736
  { 8,  1,   0}, // #1737
  {10,  1,   0}, // #1738
  {11,  1,   0}, // #1739
  {15,  2,   0}, // #1740
  {16,  2,   0}, // #1741
  {28,  5,   0}, // #1742
  { 1,  1,   0}, // #1743
  { 2,  1,   0}, // #1744
  { 3,  4,   0}, // #1745
  { 4,  4,   0}, // #1746
  { 5,  4,   0}, // #1747
  { 6,  1,   0}, // #1748
  { 7,  1,   0}, // #1749
  { 8,  1,   0}, // #1750
  {10,  2,   0}, // #1751
  {11,  2,   0}, // #1752
  {15,  4,   0}, // #1753
  {16,  4,   0}, // #1754
  {28,  8,   0}, // #1755
  { 1,  1,   0}, // #1756
  { 2,  1,   0}, // #1757
  { 3,  4,   0}, // #1758
  { 4,  4,   0}, // #1759
  { 5,  4,   0}, // #1760
  { 6,  1,   0}, // #1761
  { 7,  1,   0}, // #1762
  { 8,  1,   0}, // #1763
  {10,  2,   0}, // #1764
  {11,  2,   0}, // #1765
  {15,  8,   0}, // #1766
  {16,  8,   0}, // #1767
  {28, 12,   0}, // #1768
  { 4,  2,   0}, // #1769
  { 5,  2,   0}, // #1770
  { 7,  1,   0}, // #1771
  { 8,  1,   0}, // #1772
  {13,  1,   0}, // #1773
  {14,  1,   0}, // #1774
  {15,  1,   0}, // #1775
  {16,  1,   0}, // #1776
  {21,  1,   0}, // #1777
  {28,  3,   0}, // #1778
  { 2,  1,   0}, // #1779
  { 3,  1,   0}, // #1780
  { 4,  3,   0}, // #1781
  { 5,  3,   0}, // #1782
  { 7,  2,   0}, // #1783
  { 8,  2,   0}, // #1784
  { 9,  1,   0}, // #1785
  {10,  1,   0}, // #1786
  {11,  1,   0}, // #1787
  {15,  1,   0}, // #1788
  {16,  1,   0}, // #1789
  {28,  4,   0}, // #1790
  { 1,  2,   0}, // #1791
  { 2,  2,   0}, // #1792
  { 3,  2,   0}, // #1793
  { 4,  2,   0}, // #1794
  { 5,  2,   0}, // #1795
  { 6,  2,   0}, // #1796
  { 7,  2,   0}, // #1797
  { 8,  2,   0}, // #1798
  {15,  1,   0}, // #1799
  {19,  1,   0}, // #1800
  {23,  1,   0}, // #1801
  {28,  4,   0}, // #1802
  { 2,  3,   0}, // #1803
  { 3,  6,   0}, // #1804
  { 4,  7,   0}, // #1805
  { 5,  7,   0}, // #1806
  { 6,  1,   0}, // #1807
  { 7,  2,   0}, // #1808
  { 8,  1,   0}, // #1809
  {10,  1,   0}, // #1810
  {11,  1,   0}, // #1811
  {20,  1,   0}, // #1812
  {28,  7,   0}, // #1813
  { 2,  3,   0}, // #1814
  { 3,  6,   0}, // #1815
  { 4,  7,   0}, // #1816
  { 5,  7,   0}, // #1817
  { 6,  1,   0}, // #1818
  { 7,  2,   0}, // #1819
  { 8,  1,   0}, // #1820
  {10,  1,   0}, // #1821
  {11,  1,   0}, // #1822
  {15,  1,   0}, // #1823
  {16,  1,   0}, // #1824
  {20,  1,   0}, // #1825
  {28,  8,   0}, // #1826
  { 2,  2,   0}, // #1827
  { 3,  6,   0}, // #1828
  { 4,  7,   0}, // #1829
  { 5,  7,   0}, // #1830
  { 7,  1,   0}, // #1831
  { 8,  1,   0}, // #1832
  {10,  2,   0}, // #1833
  {11,  2,   0}, // #1834
  {28,  7,   0}, // #1835
  { 2,  2,   0}, // #1836
  { 3,  6,   0}, // #1837
  { 4,  7,   0}, // #1838
  { 5,  7,   0}, // #1839
  { 7,  1,   0}, // #1840
  { 8,  1,   0}, // #1841
  {10,  2,   0}, // #1842
  {11,  2,   0}, // #1843
  {15,  1,   0}, // #1844
  {16,  1,   0}, // #1845
  {28,  8,   0}, // #1846
  { 2,  1,   0}, // #1847
  { 3,  3,   0}, // #1848
  { 4,  3,   0}, // #1849
  { 5,  3,   0}, // #1850
  {10,  1,   0}, // #1851
  {11,  1,   0}, // #1852
  {28,  3,   0}, // #1853
  { 2,  1,   0}, // #1854
  { 3,  3,   0}, // #1855
  { 4,  3,   0}, // #1856
  { 5,  3,   0}, // #1857
  {10,  1,   0}, // #1858
  {11,  1,   0}, // #1859
  {15,  1,   0}, // #1860
  {16,  1,   0}, // #1861
  {28,  4,   0}, // #1862
  { 4,  1,   0}, // #1863
  { 5,  2,   0}, // #1864
  { 7,  1,   0}, // #1865
  { 8,  1,   0}, // #1866
  {15,  1,   0}, // #1867
  {16,  1,   0}, // #1868
  {28,  3,   0}, // #1869
  { 4,  1,   0}, // #1870
  { 5,  5,   0}, // #1871
  { 7,  1,   0}, // #1872
  { 8,  1,   0}, // #1873
  {15,  2,   0}, // #1874
  {16,  1,   0}, // #1875
  {19,  1,   0}, // #1876
  {23,  1,   0}, // #1877
  {28,  8,   0}, // #1878
  { 2,  2,   0}, // #1879
  { 3,  2,   0}, // #1880
  { 4,  5,   0}, // #1881
  { 5,  7,   0}, // #1882
  { 7,  3,   0}, // #1883
  { 8,  3,   0}, // #1884
  { 9,  2,   0}, // #1885
  {10,  2,   0}, // #1886
  {11,  2,   0}, // #1887
  {28,  7,   0}, // #1888
  { 1,  1,   0}, // #1889
  { 2,  4,   0}, // #1890
  { 3,  5,   0}, // #1891
  { 4,  9,   0}, // #1892
  { 5, 13,   0}, // #1893
  { 6,  2,   0}, // #1894
  { 7,  6,   0}, // #1895
  { 8,  5,   0}, // #1896
  { 9,  3,   0}, // #1897
  {10,  4,   0}, // #1898
  {11,  4,   0}, // #1899
  {15,  2,   0}, // #1900
  {16,  2,   0}, // #1901
  {20,  1,   0}, // #1902
  {28, 15,   0}, // #1903
  { 1,  1,   0}, // #1904
  { 2,  1,   0}, // #1905
  { 3,  3,   0}, // #1906
  { 4,  3,   0}, // #1907
  { 5,  3,   0}, // #1908
  { 6,  3,   0}, // #1909
  { 7,  3,   0}, // #1910
  { 8,  1,   0}, // #1911
  {10,  2,   0}, // #1912
  {11,  2,   0}, // #1913
  {20,  2,   0}, // #1914
  {28,  3,   0}, // #1915
  { 2,  1,   0}, // #1916
  { 3,  3,   0}, // #1917
  { 4,  3,   0}, // #1918
  { 5,  3,   0}, // #1919
  {10,  2,   0}, // #1920
  {11,  2,   0}, // #1921
  {28,  3,   0}, // #1922
  { 1,  1,   0}, // #1923
  { 2,  1,   0}, // #1924
  { 3,  3,   0}, // #1925
  { 4,  3,   0}, // #1926
  { 5,  3,   0}, // #1927
  { 6,  3,   0}, // #1928
  { 7,  3,   0}, // #1929
  { 8,  1,   0}, // #1930
  {10,  2,   0}, // #1931
  {11,  2,   0}, // #1932
  {15,  1,   0}, // #1933
  {16,  1,   0}, // #1934
  {20,  2,   0}, // #1935
  {28,  4,   0}, // #1936
  { 2,  1,   0}, // #1937
  { 3,  3,   0}, // #1938
  { 4,  3,   0}, // #1939
  { 5,  3,   0}, // #1940
  {10,  2,   0}, // #1941
  {11,  2,   0}, // #1942
  {15,  1,   0}, // #1943
  {16,  1,   0}, // #1944
  {28,  4,   0}, // #1945
  { 2, 52,   0}, // #1946
  { 3, 125,   0}, // #1947
  { 4, 178,   0}, // #1948
  { 5, 178,   0}, // #1949
  { 6, 41,   0}, // #1950
  { 7, 94,   0}, // #1951
  { 8, 53,   0}, // #1952
  { 9, 29,   0}, // #1953
  {10, 69,   0}, // #1954
  {11, 69,   0}, // #1955
  {15,  6,   0}, // #1956
  {16,  4,   0}, // #1957
  {19,  2,   0}, // #1958
  {20,  8,   0}, // #1959
  {23,  2,   0}, // #1960
  {28, 186,   0}, // #1961
  { 4,  1,   0}, // #1962
  { 5,  1,   0}, // #1963
  {13,  1,   0}, // #1964
  {14,  2,   0}, // #1965
  {15,  2,   0}, // #1966
  {16,  1,   0}, // #1967
  {18,  1,   0}, // #1968
  {19,  1,   0}, // #1969
  {28,  4,   0}, // #1970
  { 2,  1,   0}, // #1971
  { 3,  1,   0}, // #1972
  { 4,  3,   0}, // #1973
  { 5,  8,   0}, // #1974
  { 7,  2,   0}, // #1975
  { 8,  2,   0}, // #1976
  { 9,  1,   0}, // #1977
  {10,  1,   0}, // #1978
  {11,  1,   0}, // #1979
  {15,  1,   0}, // #1980
  {16,  1,   0}, // #1981
  {28,  9,   0}, // #1982
  { 2,  1,   0}, // #1983
  { 3,  1,   0}, // #1984
  { 4,  3,   0}, // #1985
  { 5,  7,   0}, // #1986
  { 7,  2,   0}, // #1987
  { 8,  2,   0}, // #1988
  { 9,  1,   0}, // #1989
  {10,  1,   0}, // #1990
  {11,  1,   0}, // #1991
  {15,  2,   0}, // #1992
  {16,  1,   0}, // #1993
  {19,  1,   0}, // #1994
  {23,  1,   0}, // #1995
  {28, 10,   0}, // #1996
  { 4,  1,   0}, // #1997
  { 5,  2,   0}, // #1998
  { 7,  1,   0}, // #1999
  { 8,  1,   0}, // #2000
  {15,  1,   0}, // #2001
  {19,  1,   0}, // #2002
  {23,  1,   0}, // #2003
  {28,  4,   0}, // #2004
  { 2,  1,   0}, // #2005
  { 3,  4,   0}, // #2006
  { 4, 10,   0}, // #2007
  { 5, 10,   0}, // #2008
  { 6,  3,   0}, // #2009
  { 7,  9,   0}, // #2010
  { 8,  6,   0}, // #2011
  { 9,  1,   0}, // #2012
  {10,  4,   0}, // #2013
  {11,  4,   0}, // #2014
  {20,  3,   0}, // #2015
  {28, 10,   0}, // #2016
  { 1,  7,   0}, // #2017
  { 2, 26,   0}, // #2018
  { 3, 47,   0}, // #2019
  { 4, 73,   0}, // #2020
  { 5, 80,   0}, // #2021
  { 6, 28,   0}, // #2022
  { 7, 54,   0}, // #2023
  { 8, 33,   0}, // #2024
  { 9, 19,   0}, // #2025
  {10, 40,   0}, // #2026
  {11, 42,   0}, // #2027
  {15,  7,   0}, // #2028
  {16,  7,   0}, // #2029
  {20, 21,   0}, // #2030
  {28, 87,   0}, // #2031
  { 1,  7,   0}, // #2032
  { 2, 27,   0}, // #2033
  { 3, 47,   0}, // #2034
  { 4, 73,   0}, // #2035
  { 5, 80,   0}, // #2036
  { 6, 27,   0}, // #2037
  { 7, 53,   0}, // #2038
  { 8, 33,   0}, // #2039
  { 9, 19,   0}, // #2040
  {10, 39,   0}, // #2041
  {11, 42,   0}, // #2042
  {15,  7,   0}, // #2043
  {16,  7,   0}, // #2044
  {20, 20,   0}, // #2045
  {28, 87,   0}, // #2046
  { 1,  7,   0}, // #2047
  { 2, 28,   0}, // #2048
  { 3, 48,   0}, // #2049
  { 4, 76,   0}, // #2050
  { 5, 84,   0}, // #2051
  { 6, 27,   0}, // #2052
  { 7, 55,   0}, // #2053
  { 8, 35,   0}, // #2054
  { 9, 21,   0}, // #2055
  {10, 41,   0}, // #2056
  {11, 43,   0}, // #2057
  {15, 10,   0}, // #2058
  {16, 10,   0}, // #2059
  {20, 20,   0}, // #2060
  {28, 94,   0}, // #2061
  { 1,  7,   0}, // #2062
  { 2, 28,   0}, // #2063
  { 3, 49,   0}, // #2064
  { 4, 77,   0}, // #2065
  { 5, 88,   0}, // #2066
  { 6, 28,   0}, // #2067
  { 7, 56,   0}, // #2068
  { 8, 35,   0}, // #2069
  { 9, 21,   0}, // #2070
  {10, 42,   0}, // #2071
  {11, 44,   0}, // #2072
  {15, 11,   0}, // #2073
  {16, 11,   0}, // #2074
  {20, 21,   0}, // #2075
  {28, 99,   0}, // #2076
  { 1,  7,   0}, // #2077
  { 2, 24,   0}, // #2078
  { 3, 43,   0}, // #2079
  { 4, 67,   0}, // #2080
  { 5, 73,   0}, // #2081
  { 6, 26,   0}, // #2082
  { 7, 50,   0}, // #2083
  { 8, 31,   0}, // #2084
  { 9, 17,   0}, // #2085
  {10, 36,   0}, // #2086
  {11, 36,   0}, // #2087
  {15,  9,   0}, // #2088
  {16,  8,   0}, // #2089
  {19,  1,   0}, // #2090
  {20, 19,   0}, // #2091
  {23,  1,   0}, // #2092
  {28, 83,   0}, // #2093
  { 1,  7,   0}, // #2094
  { 2, 24,   0}, // #2095
  { 3, 46,   0}, // #2096
  { 4, 74,   0}, // #2097
  { 5, 79,   0}, // #2098
  { 6, 28,   0}, // #2099
  { 7, 56,   0}, // #2100
  { 8, 34,   0}, // #2101
  { 9, 17,   0}, // #2102
  {10, 38,   0}, // #2103
  {11, 38,   0}, // #2104
  {15, 12,   0}, // #2105
  {16, 11,   0}, // #2106
  {19,  1,   0}, // #2107
  {20, 21,   0}, // #2108
  {23,  1,   0}, // #2109
  {28, 92,   0}, // #2110
  { 1,  5,   0}, // #2111
  { 2, 11,   0}, // #2112
  { 3, 18,   0}, // #2113
  { 4, 26,   0}, // #2114
  { 5, 32,   0}, // #2115
  { 6, 12,   0}, // #2116
  { 7, 20,   0}, // #2117
  { 8, 13,   0}, // #2118
  { 9,  6,   0}, // #2119
  {10, 13,   0}, // #2120
  {11, 15,   0}, // #2121
  {15,  5,   0}, // #2122
  {19,  5,   0}, // #2123
  {20,  7,   0}, // #2124
  {23,  5,   0}, // #2125
  {28, 42,   0}, // #2126
  { 4,  1,   0}, // #2127
  { 5,  1,   0}, // #2128
  { 7,  1,   0}, // #2129
  { 8,  1,   0}, // #2130
  {21,  1,   0}, // #2131
  {28,  1,   0}, // #2132
  { 1,  8,   0}, // #2133
  { 2, 22,   0}, // #2134
  { 3, 23,   0}, // #2135
  { 4, 25,   0}, // #2136
  { 5, 25,   0}, // #2137
  { 6,  9,   0}, // #2138
  { 7, 11,   0}, // #2139
  { 8, 10,   0}, // #2140
  { 9, 14,   0}, // #2141
  {10, 15,   0}, // #2142
  {11, 15,   0}, // #2143
  {15,  3,   0}, // #2144
  {16,  3,   0}, // #2145
  {20,  1,   0}, // #2146
  {28, 28,   0}, // #2147
  { 1,  1,   0}, // #2148
  { 2,  6,   0}, // #2149
  { 3,  9,   0}, // #2150
  { 4, 18,   0}, // #2151
  { 5, 20,   0}, // #2152
  { 6,  4,   0}, // #2153
  { 7, 13,   0}, // #2154
  { 8, 10,   0}, // #2155
  { 9,  5,   0}, // #2156
  {10,  6,   0}, // #2157
  {11,  6,   0}, // #2158
  {15,  3,   0}, // #2159
  {16,  3,   0}, // #2160
  {20,  1,   0}, // #2161
  {28, 23,   0}, // #2162
  { 1,  1,   0}, // #2163
  { 2,  4,   0}, // #2164
  { 3,  4,   0}, // #2165
  { 4,  8,   0}, // #2166
  { 5, 10,   0}, // #2167
  { 6,  1,   0}, // #2168
  { 7,  5,   0}, // #2169
  { 8,  5,   0}, // #2170
  { 9,  3,   0}, // #2171
  {10,  3,   0}, // #2172
  {11,  3,   0}, // #2173
  {15,  3,   0}, // #2174
  {16,  2,   0}, // #2175
  {19,  1,   0}, // #2176
  {23,  1,   0}, // #2177
  {28, 14,   0}, // #2178
  { 2,  3,   0}, // #2179
  { 3,  4,   0}, // #2180
  { 4,  9,   0}, // #2181
  { 5, 10,   0}, // #2182
  { 6,  1,   0}, // #2183
  { 7,  6,   0}, // #2184
  { 8,  5,   0}, // #2185
  { 9,  3,   0}, // #2186
  {10,  3,   0}, // #2187
  {11,  3,   0}, // #2188
  {15,  3,   0}, // #2189
  {16,  2,   0}, // #2190
  {19,  1,   0}, // #2191
  {23,  1,   0}, // #2192
  {28, 14,   0}, // #2193
  { 2,  3,   0}, // #2194
  { 3,  3,   0}, // #2195
  { 4,  8,   0}, // #2196
  { 5,  8,   0}, // #2197
  { 7,  5,   0}, // #2198
  { 8,  5,   0}, // #2199
  { 9,  3,   0}, // #2200
  {10,  3,   0}, // #2201
  {11,  3,   0}, // #2202
  {15,  3,   0}, // #2203
  {16,  2,   0}, // #2204
  {19,  1,   0}, // #2205
  {23,  1,   0}, // #2206
  {28, 12,   0}, // #2207
  { 2,  3,   0}, // #2208
  { 3,  3,   0}, // #2209
  { 4,  7,   0}, // #2210
  { 5,  8,   0}, // #2211
  { 7,  4,   0}, // #2212
  { 8,  4,   0}, // #2213
  { 9,  3,   0}, // #2214
  {10,  3,   0}, // #2215
  {11,  3,   0}, // #2216
  {15,  2,   0}, // #2217
  {16,  1,   0}, // #2218
  {19,  1,   0}, // #2219
  {23,  1,   0}, // #2220
  {28, 11,   0}, // #2221
  { 1,  1,   0}, // #2222
  { 2,  4,   0}, // #2223
  { 3, 12,   0}, // #2224
  { 4, 20,   0}, // #2225
  { 5, 22,   0}, // #2226
  { 6,  8,   0}, // #2227
  { 7, 16,   0}, // #2228
  { 8,  9,   0}, // #2229
  { 9,  3,   0}, // #2230
  {10, 10,   0}, // #2231
  {11, 10,   0}, // #2232
  {15,  3,   0}, // #2233
  {16,  1,   0}, // #2234
  {19,  2,   0}, // #2235
  {20,  7,   0}, // #2236
  {23,  2,   0}, // #2237
  {28, 27,   0}, // #2238
  { 2,  1,   0}, // #2239
  { 3,  6,   0}, // #2240
  { 4, 13,   0}, // #2241
  { 5, 18,   0}, // #2242
  { 6,  5,   0}, // #2243
  { 7, 12,   0}, // #2244
  { 8,  7,   0}, // #2245
  { 9,  1,   0}, // #2246
  {10,  6,   0}, // #2247
  {11,  6,   0}, // #2248
  {15,  2,   0}, // #2249
  {19,  2,   0}, // #2250
  {20,  5,   0}, // #2251
  {23,  2,   0}, // #2252
  {28, 22,   0}, // #2253
  { 2,  8,   0}, // #2254
  { 3, 22,   0}, // #2255
  { 4, 38,   0}, // #2256
  { 5, 44,   0}, // #2257
  { 6, 12,   0}, // #2258
  { 7, 28,   0}, // #2259
  { 8, 16,   0}, // #2260
  { 9,  7,   0}, // #2261
  {10, 19,   0}, // #2262
  {11, 21,   0}, // #2263
  {15,  2,   0}, // #2264
  {19,  2,   0}, // #2265
  {20, 12,   0}, // #2266
  {23,  2,   0}, // #2267
  {28, 48,   0}, // #2268
  { 3,  1,   0}, // #2269
  { 4,  2,   0}, // #2270
  { 5,  3,   0}, // #2271
  { 6,  1,   0}, // #2272
  { 7,  2,   0}, // #2273
  { 8,  1,   0}, // #2274
  {10,  1,   0}, // #2275
  {11,  1,   0}, // #2276
  {20,  1,   0}, // #2277
  {28,  3,   0}, // #2278
  { 2,  4,   0}, // #2279
  { 3, 10,   0}, // #2280
  { 4, 18,   0}, // #2281
  { 5, 24,   0}, // #2282
  { 6,  3,   0}, // #2283
  { 7, 11,   0}, // #2284
  { 8,  8,   0}, // #2285
  { 9,  4,   0}, // #2286
  {10,  7,   0}, // #2287
  {11,  9,   0}, // #2288
  {20,  3,   0}, // #2289
  {28, 24,   0}, // #2290
  { 1,  6,   0}, // #2291
  { 2, 21,   0}, // #2292
  { 3, 38,   0}, // #2293
  { 4, 66,   0}, // #2294
  { 5, 70,   0}, // #2295
  { 6, 23,   0}, // #2296
  { 7, 51,   0}, // #2297
  { 8, 34,   0}, // #2298
  { 9, 15,   0}, // #2299
  {10, 31,   0}, // #2300
  {11, 31,   0}, // #2301
  {15,  8,   0}, // #2302
  {16,  7,   0}, // #2303
  {19,  1,   0}, // #2304
  {20, 16,   0}, // #2305
  {23,  1,   0}, // #2306
  {28, 79,   0}, // #2307
  { 1,  6,   0}, // #2308
  { 2, 21,   0}, // #2309
  { 3, 37,   0}, // #2310
  { 4, 64,   0}, // #2311
  { 5, 70,   0}, // #2312
  { 6, 22,   0}, // #2313
  { 7, 49,   0}, // #2314
  { 8, 33,   0}, // #2315
  { 9, 15,   0}, // #2316
  {10, 31,   0}, // #2317
  {11, 31,   0}, // #2318
  {15,  8,   0}, // #2319
  {16,  7,   0}, // #2320
  {19,  1,   0}, // #2321
  {20, 16,   0}, // #2322
  {23,  1,   0}, // #2323
  {28, 79,   0}, // #2324
  { 1,  6,   0}, // #2325
  { 2, 21,   0}, // #2326
  { 3, 40,   0}, // #2327
  { 4, 70,   0}, // #2328
  { 5, 74,   0}, // #2329
  { 6, 25,   0}, // #2330
  { 7, 55,   0}, // #2331
  { 8, 36,   0}, // #2332
  { 9, 15,   0}, // #2333
  {10, 33,   0}, // #2334
  {11, 33,   0}, // #2335
  {15, 10,   0}, // #2336
  {16,  9,   0}, // #2337
  {19,  1,   0}, // #2338
  {20, 18,   0}, // #2339
  {23,  1,   0}, // #2340
  {28, 85,   0}, // #2341
  { 1,  6,   0}, // #2342
  { 2, 21,   0}, // #2343
  { 3, 39,   0}, // #2344
  { 4, 68,   0}, // #2345
  { 5, 74,   0}, // #2346
  { 6, 24,   0}, // #2347
  { 7, 53,   0}, // #2348
  { 8, 35,   0}, // #2349
  { 9, 15,   0}, // #2350
  {10, 33,   0}, // #2351
  {11, 33,   0}, // #2352
  {15, 10,   0}, // #2353
  {16,  9,   0}, // #2354
  {19,  1,   0}, // #2355
  {20, 18,   0}, // #2356
  {23,  1,   0}, // #2357
  {28, 85,   0}, // #2358
  { 1,  7,   0}, // #2359
  { 2, 23,   0}, // #2360
  { 3, 40,   0}, // #2361
  { 4, 65,   0}, // #2362
  { 5, 71,   0}, // #2363
  { 6, 24,   0}, // #2364
  { 7, 49,   0}, // #2365
  { 8, 32,   0}, // #2366
  { 9, 16,   0}, // #2367
  {10, 33,   0}, // #2368
  {11, 33,   0}, // #2369
  {15,  8,   0}, // #2370
  {16,  7,   0}, // #2371
  {19,  1,   0}, // #2372
  {20, 17,   0}, // #2373
  {23,  1,   0}, // #2374
  {28, 80,   0}, // #2375
  { 1,  7,   0}, // #2376
  { 2, 23,   0}, // #2377
  { 3, 43,   0}, // #2378
  { 4, 71,   0}, // #2379
  { 5, 77,   0}, // #2380
  { 6, 27,   0}, // #2381
  { 7, 55,   0}, // #2382
  { 8, 35,   0}, // #2383
  { 9, 16,   0}, // #2384
  {10, 36,   0}, // #2385
  {11, 36,   0}, // #2386
  {15, 11,   0}, // #2387
  {16, 10,   0}, // #2388
  {19,  1,   0}, // #2389
  {20, 20,   0}, // #2390
  {23,  1,   0}, // #2391
  {28, 89,   0}, // #2392
  { 4,  2,   0}, // #2393
  { 5,  3,   0}, // #2394
  { 7,  2,   0}, // #2395
  { 8,  2,   0}, // #2396
  {15,  1,   0}, // #2397
  {16,  1,   0}, // #2398
  {21,  2,   0}, // #2399
  {28,  4,   0}, // #2400
  { 4,  2,   0}, // #2401
  { 5,  3,   0}, // #2402
  { 7,  2,   0}, // #2403
  { 8,  2,   0}, // #2404
  {21,  2,   0}, // #2405
  {28,  3,   0}, // #2406
  { 4,  2,   0}, // #2407
  { 5,  4,   0}, // #2408
  { 7,  2,   0}, // #2409
  { 8,  2,   0}, // #2410
  {21,  2,   0}, // #2411
  {28,  4,   0}, // #2412
  { 2,  2,   0}, // #2413
  { 3,  2,   0}, // #2414
  { 4,  7,   0}, // #2415
  { 5,  8,   0}, // #2416
  { 7,  5,   0}, // #2417
  { 8,  5,   0}, // #2418
  { 9,  2,   0}, // #2419
  {10,  2,   0}, // #2420
  {11,  2,   0}, // #2421
  {15,  2,   0}, // #2422
  {16,  1,   0}, // #2423
  {19,  1,   0}, // #2424
  {23,  1,   0}, // #2425
  {28, 11,   0}, // #2426
  { 2,  3,   0}, // #2427
  { 3,  3,   0}, // #2428
  { 4,  7,   0}, // #2429
  { 5,  9,   0}, // #2430
  { 7,  4,   0}, // #2431
  { 8,  4,   0}, // #2432
  { 9,  3,   0}, // #2433
  {10,  3,   0}, // #2434
  {11,  3,   0}, // #2435
  {15,  2,   0}, // #2436
  {16,  1,   0}, // #2437
  {19,  1,   0}, // #2438
  {23,  1,   0}, // #2439
  {28, 12,   0}, // #2440
  { 1,  2,   0}, // #2441
  { 2,  9,   0}, // #2442
  { 3, 16,   0}, // #2443
  { 4, 24,   0}, // #2444
  { 5, 24,   0}, // #2445
  { 6,  6,   0}, // #2446
  { 7, 14,   0}, // #2447
  { 8,  7,   0}, // #2448
  { 9,  7,   0}, // #2449
  {10, 11,   0}, // #2450
  {11, 11,   0}, // #2451
  {15,  1,   0}, // #2452
  {16,  1,   0}, // #2453
  {20,  4,   0}, // #2454
  {28, 25,   0}, // #2455
  { 2,  1,   0}, // #2456
  { 3,  1,   0}, // #2457
  { 4,  3,   0}, // #2458
  { 5,  5,   0}, // #2459
  { 7,  2,   0}, // #2460
  { 8,  2,   0}, // #2461
  { 9,  1,   0}, // #2462
  {10,  1,   0}, // #2463
  {11,  1,   0}, // #2464
  {15,  1,   0}, // #2465
  {19,  1,   0}, // #2466
  {23,  1,   0}, // #2467
  {28,  7,   0}, // #2468
  { 3,  1,   0}, // #2469
  { 4,  1,   0}, // #2470
  { 5,  2,   0}, // #2471
  { 6,  1,   0}, // #2472
  { 7,  1,   0}, // #2473
  {10,  1,   0}, // #2474
  {11,  1,   0}, // #2475
  {20,  1,   0}, // #2476
  {28,  2,   0}, // #2477
  { 2,  1,   0}, // #2478
  { 3,  1,   0}, // #2479
  { 4,  5,   0}, // #2480
  { 5,  6,   0}, // #2481
  { 7,  4,   0}, // #2482
  { 8,  4,   0}, // #2483
  { 9,  1,   0}, // #2484
  {10,  1,   0}, // #2485
  {11,  1,   0}, // #2486
  {28,  6,   0}, // #2487
  { 1,  6,   0}, // #2488
  { 2, 13,   0}, // #2489
  { 3, 13,   0}, // #2490
  { 4, 13,   0}, // #2491
  { 5, 13,   0}, // #2492
  { 6,  6,   0}, // #2493
  { 7,  6,   0}, // #2494
  { 8,  6,   0}, // #2495
  { 9,  7,   0}, // #2496
  {10,  7,   0}, // #2497
  {11,  7,   0}, // #2498
  {15, 18,   0}, // #2499
  {16, 18,   0}, // #2500
  {28, 31,   0}, // #2501
  { 1,  6,   0}, // #2502
  { 2, 13,   0}, // #2503
  { 3, 13,   0}, // #2504
  { 4, 13,   0}, // #2505
  { 5, 13,   0}, // #2506
  { 6,  6,   0}, // #2507
  { 7,  6,   0}, // #2508
  { 8,  6,   0}, // #2509
  { 9,  7,   0}, // #2510
  {10,  7,   0}, // #2511
  {11,  7,   0}, // #2512
  {15, 17,   0}, // #2513
  {16, 17,   0}, // #2514
  {28, 30,   0}, // #2515
  { 1,  5,   0}, // #2516
  { 2, 13,   0}, // #2517
  { 3, 13,   0}, // #2518
  { 4, 13,   0}, // #2519
  { 5, 13,   0}, // #2520
  { 6,  5,   0}, // #2521
  { 7,  5,   0}, // #2522
  { 8,  5,   0}, // #2523
  { 9,  8,   0}, // #2524
  {10,  8,   0}, // #2525
  {11,  8,   0}, // #2526
  {15, 20,   0}, // #2527
  {16, 20,   0}, // #2528
  {28, 33,   0}, // #2529
  { 1,  1,   0}, // #2530
  { 2,  1,   0}, // #2531
  { 3,  1,   0}, // #2532
  { 4,  2,   0}, // #2533
  { 5,  2,   0}, // #2534
  { 6,  1,   0}, // #2535
  { 7,  2,   0}, // #2536
  { 8,  2,   0}, // #2537
  {15,  1,   0}, // #2538
  {16,  1,   0}, // #2539
  {28,  3,   0}, // #2540
  { 2,  4,   0}, // #2541
  { 3,  5,   0}, // #2542
  { 4,  6,   0}, // #2543
  { 5,  8,   0}, // #2544
  { 6,  1,   0}, // #2545
  { 7,  2,   0}, // #2546
  { 8,  1,   0}, // #2547
  { 9,  4,   0}, // #2548
  {10,  5,   0}, // #2549
  {11,  5,   0}, // #2550
  {20,  1,   0}, // #2551
  {28,  8,   0}, // #2552
  { 1,  1,   0}, // #2553
  { 2, 43,   0}, // #2554
  { 3, 91,   0}, // #2555
  { 4, 143,   0}, // #2556
  { 5, 143,   0}, // #2557
  { 6, 49,   0}, // #2558
  { 7, 101,   0}, // #2559
  { 8, 53,   0}, // #2560
  { 9, 23,   0}, // #2561
  {10, 35,   0}, // #2562
  {11, 35,   0}, // #2563
  {15,  6,   0}, // #2564
  {16,  4,   0}, // #2565
  {19,  2,   0}, // #2566
  {20, 12,   0}, // #2567
  {23,  2,   0}, // #2568
  {28, 151,   0}, // #2569
  { 1,  1,   0}, // #2570
  { 2, 43,   0}, // #2571
  { 3, 91,   0}, // #2572
  { 4, 144,   0}, // #2573
  { 5, 144,   0}, // #2574
  { 6, 49,   0}, // #2575
  { 7, 102,   0}, // #2576
  { 8, 54,   0}, // #2577
  { 9, 23,   0}, // #2578
  {10, 35,   0}, // #2579
  {11, 35,   0}, // #2580
  {15,  6,   0}, // #2581
  {16,  4,   0}, // #2582
  {19,  2,   0}, // #2583
  {20, 12,   0}, // #2584
  {23,  2,   0}, // #2585
  {28, 152,   0}, // #2586
  { 2, 52,   0}, // #2587
  { 3, 97,   0}, // #2588
  { 4, 149,   0}, // #2589
  { 5, 149,   0}, // #2590
  { 6, 45,   0}, // #2591
  { 7, 97,   0}, // #2592
  { 8, 52,   0}, // #2593
  { 9, 27,   0}, // #2594
  {10, 37,   0}, // #2595
  {11, 37,   0}, // #2596
  {15,  5,   0}, // #2597
  {16,  4,   0}, // #2598
  {19,  1,   0}, // #2599
  {20, 10,   0}, // #2600
  {23,  1,   0}, // #2601
  {28, 155,   0}, // #2602
  { 2, 52,   0}, // #2603
  { 3, 123,   0}, // #2604
  { 4, 176,   0}, // #2605
  { 5, 176,   0}, // #2606
  { 6, 41,   0}, // #2607
  { 7, 94,   0}, // #2608
  { 8, 53,   0}, // #2609
  { 9, 29,   0}, // #2610
  {10, 68,   0}, // #2611
  {11, 68,   0}, // #2612
  {15,  6,   0}, // #2613
  {16,  4,   0}, // #2614
  {19,  2,   0}, // #2615
  {20,  9,   0}, // #2616
  {23,  2,   0}, // #2617
  {28, 184,   0}, // #2618
  { 1,  1,   0}, // #2619
  { 3,  2,   0}, // #2620
  { 1,  1,   0}, // #2621
  { 3,  1,   0}, // #2622
  { 1,  6,   0}, // #2623
  { 2,  6,   0}, // #2624
  { 3, 12,   0}, // #2625
  { 1,  5,   0}, // #2626
  { 2,  5,   0}, // #2627
  { 3, 10,   0}, // #2628
  { 1, 16,   0}, // #2629
  { 2, 16,   0}, // #2630
  { 3, 32,   0}, // #2631
  { 3, 15,   0}, // #2632
  { 1, 10,   0}, // #2633
  { 2, 10,   0}, // #2634
  { 3, 20,   0}, // #2635
  { 1,  9,   0}, // #2636
  { 2,  9,   0}, // #2637
  { 3, 18,   0}, // #2638
  { 1,  5,   0}, // #2639
  { 3,  5,   0}, // #2640
  { 1,  7,   0}, // #2641
  { 2,  7,   0}, // #2642
  { 3, 14,   0}, // #2643
  { 1,  8,   0}, // #2644
  { 2,  8,   0}, // #2645
  { 3, 16,   0}, // #2646
  { 1, 12,   0}, // #2647
  { 2, 12,   0}, // #2648
  { 3, 24,   0}, // #2649
  { 1, 11,   0}, // #2650
  { 2, 11,   0}, // #2651
  { 3, 22,   0}, // #2652
  { 1, 50,   0}, // #2653
  { 2, 50,   0}, // #2654
  { 3, 100,   0}, // #2655
  { 1, 130,   0}, // #2656
  { 2, 130,   0}, // #2657
  { 3, 260,   0}, // #2658
  { 1, 68,   0}, // #2659
  { 2, 68,   0}, // #2660
  { 3, 136,   0}, // #2661
  { 1, 125,   0}, // #2662
  { 2, 125,   0}, // #2663
  { 3, 250,   0}, // #2664
  { 1, 70,   0}, // #2665
  { 2, 70,   0}, // #2666
  { 3, 140,   0}, // #2667
  { 1, 34,   0}, // #2668
  { 2, 34,   0}, // #2669
  { 3, 68,   0}, // #2670
  { 1, 62,   0}, // #2671
  { 2, 62,   0}, // #2672
  { 3, 124,   0}, // #2673
  { 1,  2,   0}, // #2674
  { 3,  2,   0}, // #2675
  { 1, 14,   0}, // #2676
  { 2, 14,   0}, // #2677
  { 3, 28,   0}, // #2678
  { 1,  3,   0}, // #2679
  { 3,  3,   0}, // #2680
  { 1,  4,   0}, // #2681
  { 2,  4,   0}, // #2682
  { 3,  8,   0}, // #2683
  { 1,  3,   0}, // #2684
  { 2,  3,   0}, // #2685
  { 3,  6,   0}, // #2686
  { 1,  2,   0}, // #2687
  { 2,  2,   0}, // #2688
  { 3,  4,   0}, // #2689
  { 1,  4,   0}, // #2690
  { 3,  4,   0}, // #2691
  { 1, 71,   0}, // #2692
  { 3, 71,   0}, // #2693
  { 1, 15,   0}, // #2694
  { 2, 15,   0}, // #2695
  { 3, 30,   0}, // #2696
  { 3, 21,   0}, // #2697
  { 3, 25,   0}, // #2698
  { 3, 29,   0}, // #2699
  { 3, 45,   0}, // #2700
  { 3, 55,   0}, // #2701
  { 3, 59,   0}, // #2702
  { 3, 63,   0}, // #2703
  { 3, 72,   0}, // #2704
  { 3, 74,   0}, // #2705
  { 3, 77,   0}, // #2706
  { 3, 78,   0}, // #2707
  { 3, 92,   0}, // #2708
  { 3, 94,   0}, // #2709
  { 3, 99,   0}, // #2710
  { 3, 121,   0}, // #2711
  { 3, 127,   0}, // #2712
  { 3, 130,   0}, // #2713
  { 3, 141,   0}, // #2714
  { 3, 146,   0}, // #2715
  { 3, 147,   0}, // #2716
  { 3, 168,   0}, // #2717
  { 3, 174,   0}, // #2718
  { 3, 183,   0}, // #2719
  { 3, 202,   0}, // #2720
  { 9,  6,   0}, // #2721
  {10,  2,   0}, // #2722
  { 4,  1,   0}, // #2723
  { 6,  1,   0}, // #2724
  { 5,  2,   0}, // #2725
  { 6,  2,   0}, // #2726
  {10,  1,   0}, // #2727
  { 5,  1,   0}, // #2728
  { 6,  1,   0}, // #2729
  {10,  1,   0}, // #2730
  { 4,  5,   0}, // #2731
  { 6,  5,   0}, // #2732
  {10,  1,   0}, // #2733
  { 4,  4,   0}, // #2734
  { 6,  4,   0}, // #2735
  {10,  1,   0}, // #2736
  { 4,  1,   0}, // #2737
  { 6,  1,   0}, // #2738
  {10,  1,   0}, // #2739
  { 7, 10,   0}, // #2740
  { 8, 10,   0}, // #2741
  { 9, 20,   0}, // #2742
  {10,  1,   0}, // #2743
  { 7,  1,   0}, // #2744
  { 8,  1,   0}, // #2745
  { 9,  2,   0}, // #2746
  {10,  1,   0}, // #2747
  { 7,  1,   0}, // #2748
  { 8,  1,   0}, // #2749
  { 9,  2,   0}, // #2750
  {10,  2,   0}, // #2751
  { 4,  2,   0}, // #2752
  { 6,  2,   0}, // #2753
  {10,  1,   0}, // #2754
  { 1, 25,   0}, // #2755
  { 9,  1,   0}, // #2756
  {10,  1,   0}, // #2757
  { 2, 69,   0}, // #2758
  { 4,  1,   0}, // #2759
  { 6,  1,   0}, // #2760
  {10,  1,   0}, // #2761
  { 2, 39,   0}, // #2762
  { 4,  1,   0}, // #2763
  { 6,  1,   0}, // #2764
  {10,  1,   0}, // #2765
  { 2, 17,   0}, // #2766
  { 4,  1,   0}, // #2767
  { 6,  1,   0}, // #2768
  {10,  1,   0}, // #2769
  { 2, 32,   0}, // #2770
  { 4,  1,   0}, // #2771
  { 6,  1,   0}, // #2772
  {10,  1,   0}, // #2773
  { 5,  8,   0}, // #2774
  { 6,  8,   0}, // #2775
  {10,  1,   0}, // #2776
  { 5, 12,   0}, // #2777
  { 6, 12,   0}, // #2778
  {10,  1,   0}, // #2779
  { 4,  1,   0}, // #2780
  { 6,  1,   0}, // #2781
  {10,  2,   0}, // #2782
  { 6, 10,   0}, // #2783
  { 5,  6,   0}, // #2784
  { 6,  6,   0}, // #2785
  {10,  1,   0}, // #2786
  { 8,  5,   0}, // #2787
  { 9,  5,   0}, // #2788
  {10,  1,   0}, // #2789
  { 8,  4,   0}, // #2790
  { 9,  4,   0}, // #2791
  {10,  1,   0}, // #2792
  { 8,  7,   0}, // #2793
  { 9,  7,   0}, // #2794
  {10,  1,   0}, // #2795
  { 8,  2,   0}, // #2796
  { 9,  2,   0}, // #2797
  {10,  1,   0}, // #2798
  { 7,  1,   0}, // #2799
  { 9,  1,   0}, // #2800
  {10,  1,   0}, // #2801
  { 3,  4,   0}, // #2802
  { 4,  1,   0}, // #2803
  { 6,  1,   0}, // #2804
  {10,  1,   0}, // #2805
  { 3,  2,   0}, // #2806
  { 4,  1,   0}, // #2807
  { 6,  1,   0}, // #2808
  {10,  1,   0}, // #2809
  { 4, 10,   0}, // #2810
  { 6, 10,   0}, // #2811
  {10,  1,   0}, // #2812
  { 4, 21,   0}, // #2813
  { 6, 21,   0}, // #2814
  {10,  1,   0}, // #2815
  { 4, 17,   0}, // #2816
  { 6, 17,   0}, // #2817
  {10,  1,   0}, // #2818
  { 4, 13,   0}, // #2819
  { 6, 13,   0}, // #2820
  {10,  1,   0}, // #2821
  { 4, 11,   0}, // #2822
  { 6, 11,   0}, // #2823
  {10,  1,   0}, // #2824
  { 7,  2,   0}, // #2825
  { 9,  2,   0}, // #2826
  {10,  1,   0}, // #2827
  { 4,  8,   0}, // #2828
  { 6,  8,   0}, // #2829
  {10,  1,   0}, // #2830
  { 2, 70,   0}, // #2831
  { 4,  1,   0}, // #2832
  { 6,  1,   0}, // #2833
  {10,  1,   0}, // #2834
  { 2, 40,   0}, // #2835
  { 4,  1,   0}, // #2836
  { 6,  1,   0}, // #2837
  {10,  1,   0}, // #2838
  { 2, 35,   0}, // #2839
  { 4,  1,   0}, // #2840
  { 6,  1,   0}, // #2841
  {10,  1,   0}, // #2842
  { 2, 20,   0}, // #2843
  { 4,  1,   0}, // #2844
  { 6,  1,   0}, // #2845
  {10,  1,   0}, // #2846
  { 5,  2,   0}, // #2847
  { 8,  2,   0}, // #2848
  {11,  1,   0}, // #2849
  {14,  1,   0}, // #2850
  {20,  1,   0}, // #2851
  { 2,  1,   0}, // #2852
  { 5,  1,   0}, // #2853
  { 7,  1,   0}, // #2854
  { 8,  1,   0}, // #2855
  { 1,  2,   0}, // #2856
  { 5, 44,   0}, // #2857
  { 7, 44,   0}, // #2858
  { 8, 44,   0}, // #2859
  {22,  1,   0}, // #2860
  {24,  1,   0}, // #2861
  { 1,  3,   0}, // #2862
  { 2,  1,   0}, // #2863
  { 5,  1,   0}, // #2864
  { 7,  1,   0}, // #2865
  { 8,  1,   0}, // #2866
  {22,  3,   0}, // #2867
  { 1,  1,   0}, // #2868
  {13,  1,   0}, // #2869
  {14,  3,   0}, // #2870
  {20,  3,   0}, // #2871
  {24,  1,   0}, // #2872
  { 1,  3,   0}, // #2873
  {10,  3,   0}, // #2874
  {14,  1,   0}, // #2875
  {19,  1,   0}, // #2876
  {22,  3,   0}, // #2877
  { 5,  1,   0}, // #2878
  { 8,  1,   0}, // #2879
  { 1,  1,   0}, // #2880
  {24,  1,   0}, // #2881
  { 5,  6,   0}, // #2882
  { 8,  6,   0}, // #2883
  { 1,  1,   0}, // #2884
  {13,  2,   0}, // #2885
  {14, 36,   0}, // #2886
  {20, 36,   0}, // #2887
  {24,  1,   0}, // #2888
  { 1,  4,   0}, // #2889
  { 5,  2,   0}, // #2890
  { 8,  2,   0}, // #2891
  {22,  3,   0}, // #2892
  {24,  1,   0}, // #2893
  {10,  4,   0}, // #2894
  {14,  1,   0}, // #2895
  {16,  1,   0}, // #2896
  {19,  1,   0}, // #2897
  { 1,  3,   0}, // #2898
  { 5,  2,   0}, // #2899
  { 8,  2,   0}, // #2900
  {22,  3,   0}, // #2901
  { 1,  3,   0}, // #2902
  {10,  1,   0}, // #2903
  {14,  1,   0}, // #2904
  {15,  1,   0}, // #2905
  {19,  1,   0}, // #2906
  {22,  3,   0}, // #2907
  { 1,  3,   0}, // #2908
  {12,  1,   0}, // #2909
  {14,  1,   0}, // #2910
  {15,  1,   0}, // #2911
  {19,  1,   0}, // #2912
  {22,  3,   0}, // #2913
  { 1,  3,   0}, // #2914
  {11,  1,   0}, // #2915
  {14,  1,   0}, // #2916
  {20,  1,   0}, // #2917
  {22,  3,   0}, // #2918
  { 1,  3,   0}, // #2919
  {14,  1,   0}, // #2920
  {16,  1,   0}, // #2921
  {19,  1,   0}, // #2922
  {21,  1,   0}, // #2923
  {22,  3,   0}, // #2924
  { 1,  3,   0}, // #2925
  { 5,  6,   0}, // #2926
  { 8,  6,   0}, // #2927
  {22,  3,   0}, // #2928
  { 1,  3,   0}, // #2929
  { 5,  8,   0}, // #2930
  { 8,  8,   0}, // #2931
  {22,  3,   0}, // #2932
  { 1,  2,   0}, // #2933
  { 5,  7,   0}, // #2934
  { 8,  7,   0}, // #2935
  {22,  2,   0}, // #2936
  { 1,  1,   0}, // #2937
  { 5, 42,   0}, // #2938
  { 8, 42,   0}, // #2939
  {22,  1,   0}, // #2940
  { 1,  1,   0}, // #2941
  { 5, 44,   0}, // #2942
  { 8, 44,   0}, // #2943
  {22,  1,   0}, // #2944
  { 1,  3,   0}, // #2945
  { 5,  1,   0}, // #2946
  { 8,  1,   0}, // #2947
  {22,  3,   0}, // #2948
  { 1,  2,   0}, // #2949
  {22,  2,   0}, // #2950
  { 5,  3,   0}, // #2951
  { 7,  3,   0}, // #2952
  { 8,  3,   0}, // #2953
  { 1,  3,   0}, // #2954
  { 5,  1,   0}, // #2955
  { 6,  1,   0}, // #2956
  { 8,  1,   0}, // #2957
  {10,  1,   0}, // #2958
  {14,  1,   0}, // #2959
  {15,  1,   0}, // #2960
  {19,  1,   0}, // #2961
  {22,  3,   0}, // #2962
  { 1,  3,   0}, // #2963
  { 5,  4,   0}, // #2964
  { 8,  4,   0}, // #2965
  {22,  3,   0}, // #2966
  { 1,  3,   0}, // #2967
  { 9,  1,   0}, // #2968
  {13,  1,   0}, // #2969
  {14,  1,   0}, // #2970
  {15,  1,   0}, // #2971
  {19,  1,   0}, // #2972
  {22,  3,   0}, // #2973
  { 1,  3,   0}, // #2974
  { 5,  1,   0}, // #2975
  { 6,  1,   0}, // #2976
  { 8,  1,   0}, // #2977
  { 9,  1,   0}, // #2978
  {10,  1,   0}, // #2979
  {13,  1,   0}, // #2980
  {14,  1,   0}, // #2981
  {15,  1,   0}, // #2982
  {19,  1,   0}, // #2983
  {22,  3,   0}, // #2984
  { 1,  3,   0}, // #2985
  { 9,  2,   0}, // #2986
  {13,  1,   0}, // #2987
  {14,  1,   0}, // #2988
  {15,  1,   0}, // #2989
  {19,  1,   0}, // #2990
  {22,  3,   0}, // #2991
  { 1,  3,   0}, // #2992
  { 4, 15,   0}, // #2993
  { 5,  1,   0}, // #2994
  { 7,  1,   0}, // #2995
  { 8,  1,   0}, // #2996
  {22,  3,   0}, // #2997
  { 1,  3,   0}, // #2998
  { 4, 14,   0}, // #2999
  { 5,  1,   0}, // #3000
  { 7,  1,   0}, // #3001
  { 8,  1,   0}, // #3002
  {22,  3,   0}, // #3003
  { 1,  3,   0}, // #3004
  { 4, 12,   0}, // #3005
  { 5,  1,   0}, // #3006
  { 7,  1,   0}, // #3007
  { 8,  1,   0}, // #3008
  {22,  3,   0}, // #3009
  { 1,  3,   0}, // #3010
  {10,  9,   0}, // #3011
  {14,  1,   0}, // #3012
  {16,  1,   0}, // #3013
  {19,  1,   0}, // #3014
  {22,  3,   0}, // #3015
  { 1,  3,   0}, // #3016
  {10, 10,   0}, // #3017
  {14,  1,   0}, // #3018
  {16,  1,   0}, // #3019
  {19,  1,   0}, // #3020
  {22,  3,   0}, // #3021
  { 1,  3,   0}, // #3022
  {10, 14,   0}, // #3023
  {14,  1,   0}, // #3024
  {16,  1,   0}, // #3025
  {19,  1,   0}, // #3026
  {22,  3,   0}, // #3027
  { 1,  1,   0}, // #3028
  {13,  1,   0}, // #3029
  {14,  2,   0}, // #3030
  {16,  2,   0}, // #3031
  {19,  2,   0}, // #3032
  {24,  1,   0}, // #3033
  { 5,  1,   0}, // #3034
  { 6,  1,   0}, // #3035
  { 8,  1,   0}, // #3036
  {10,  3,   0}, // #3037
  {14,  1,   0}, // #3038
  {15,  1,   0}, // #3039
  {19,  1,   0}, // #3040
  {10,  1,   0}, // #3041
  {14,  1,   0}, // #3042
  {19,  1,   0}, // #3043
  {13,  1,   0}, // #3044
  {14,  1,   0}, // #3045
  {16,  1,   0}, // #3046
  {19,  1,   0}, // #3047
  { 1,  3,   0}, // #3048
  {10,  5,   0}, // #3049
  {14,  1,   0}, // #3050
  {15,  1,   0}, // #3051
  {19,  1,   0}, // #3052
  {22,  3,   0}, // #3053
  { 1,  3,   0}, // #3054
  { 4, 17,   0}, // #3055
  { 5,  1,   0}, // #3056
  { 7,  1,   0}, // #3057
  { 8,  1,   0}, // #3058
  {22,  3,   0}, // #3059
  { 1,  3,   0}, // #3060
  { 4, 25,   0}, // #3061
  { 5,  1,   0}, // #3062
  { 7,  1,   0}, // #3063
  { 8,  1,   0}, // #3064
  {22,  3,   0}, // #3065
  { 1,  3,   0}, // #3066
  { 5,  1,   0}, // #3067
  { 7,  1,   0}, // #3068
  { 8,  1,   0}, // #3069
  {22,  3,   0}, // #3070
  {23,  5,   0}, // #3071
  { 5,  1,   0}, // #3072
  { 7,  1,   0}, // #3073
  { 8,  1,   0}, // #3074
  {23,  5,   0}, // #3075
  { 1,  3,   0}, // #3076
  { 5,  1,   0}, // #3077
  { 7,  1,   0}, // #3078
  { 8,  1,   0}, // #3079
  {22,  3,   0}, // #3080
  {23,  2,   0}, // #3081
  { 5,  1,   0}, // #3082
  { 7,  1,   0}, // #3083
  { 8,  1,   0}, // #3084
  {23,  2,   0}, // #3085
  { 1,  3,   0}, // #3086
  { 5,  1,   0}, // #3087
  { 7,  1,   0}, // #3088
  { 8,  1,   0}, // #3089
  {22,  3,   0}, // #3090
  {23,  4,   0}, // #3091
  { 5,  1,   0}, // #3092
  { 7,  1,   0}, // #3093
  { 8,  1,   0}, // #3094
  {23,  4,   0}, // #3095
  { 1,  3,   0}, // #3096
  { 5,  1,   0}, // #3097
  { 7,  1,   0}, // #3098
  { 8,  1,   0}, // #3099
  {22,  3,   0}, // #3100
  {23,  6,   0}, // #3101
  { 5,  1,   0}, // #3102
  { 7,  1,   0}, // #3103
  { 8,  1,   0}, // #3104
  {23,  6,   0}, // #3105
  { 1,  3,   0}, // #3106
  {10,  2,   0}, // #3107
  {14,  1,   0}, // #3108
  {19,  1,   0}, // #3109
  {22,  3,   0}, // #3110
  { 1,  3,   0}, // #3111
  {11,  3,   0}, // #3112
  {14,  1,   0}, // #3113
  {19,  1,   0}, // #3114
  {22,  3,   0}, // #3115
  { 1,  1,   0}, // #3116
  {22,  1,   0}, // #3117
  { 1,  3,   0}, // #3118
  { 5,  2,   0}, // #3119
  { 6,  2,   0}, // #3120
  { 8,  2,   0}, // #3121
  {22,  3,   0}, // #3122
  {11,  2,   0}, // #3123
  {14,  1,   0}, // #3124
  {19,  1,   0}, // #3125
  { 1,  1,   0}, // #3126
  {13,  1,   0}, // #3127
  {14,  1,   0}, // #3128
  {16,  1,   0}, // #3129
  {19,  1,   0}, // #3130
  {24,  1,   0}, // #3131
  {11,  1,   0}, // #3132
  {14,  1,   0}, // #3133
  {19,  1,   0}, // #3134
  { 1,  3,   0}, // #3135
  {11,  4,   0}, // #3136
  {14,  1,   0}, // #3137
  {19,  1,   0}, // #3138
  {22,  3,   0}, // #3139
  { 1,  3,   0}, // #3140
  {11,  2,   0}, // #3141
  {14,  1,   0}, // #3142
  {19,  1,   0}, // #3143
  {22,  3,   0}, // #3144
  { 1,  3,   0}, // #3145
  {12,  4,   0}, // #3146
  {14,  1,   0}, // #3147
  {15,  1,   0}, // #3148
  {19,  1,   0}, // #3149
  {22,  3,   0}, // #3150
  { 1,  3,   0}, // #3151
  {10,  1,   0}, // #3152
  {14,  1,   0}, // #3153
  {16,  1,   0}, // #3154
  {19,  1,   0}, // #3155
  {22,  3,   0}, // #3156
  { 1,  3,   0}, // #3157
  {12,  7,   0}, // #3158
  {14,  1,   0}, // #3159
  {15,  1,   0}, // #3160
  {19,  1,   0}, // #3161
  {22,  3,   0}, // #3162
  { 1, 23,   0}, // #3163
  { 5,  1,   0}, // #3164
  { 6,  1,   0}, // #3165
  { 8,  1,   0}, // #3166
  {10,  1,   0}, // #3167
  {11, 10,   0}, // #3168
  {14,  1,   0}, // #3169
  {16,  1,   0}, // #3170
  {19,  1,   0}, // #3171
  {22, 13,   0}, // #3172
  {24, 10,   0}, // #3173
  { 1, 20,   0}, // #3174
  { 5,  1,   0}, // #3175
  { 6,  1,   0}, // #3176
  { 8,  1,   0}, // #3177
  {10,  1,   0}, // #3178
  {11, 10,   0}, // #3179
  {14,  1,   0}, // #3180
  {16,  1,   0}, // #3181
  {19,  1,   0}, // #3182
  {22, 10,   0}, // #3183
  {24, 10,   0}, // #3184
  { 1,  3,   0}, // #3185
  { 5,  1,   0}, // #3186
  { 6,  1,   0}, // #3187
  { 8,  1,   0}, // #3188
  {10,  6,   0}, // #3189
  {14,  1,   0}, // #3190
  {16,  1,   0}, // #3191
  {19,  1,   0}, // #3192
  {22,  3,   0}, // #3193
  { 1,  3,   0}, // #3194
  { 5,  1,   0}, // #3195
  { 6,  1,   0}, // #3196
  { 8,  1,   0}, // #3197
  {10,  8,   0}, // #3198
  {14,  1,   0}, // #3199
  {16,  1,   0}, // #3200
  {19,  1,   0}, // #3201
  {22,  3,   0}, // #3202
  { 1,  3,   0}, // #3203
  {11,  1,   0}, // #3204
  {14,  1,   0}, // #3205
  {15,  1,   0}, // #3206
  {19,  1,   0}, // #3207
  {22,  3,   0}, // #3208
  { 1,  3,   0}, // #3209
  {11,  1,   0}, // #3210
  {12,  2,   0}, // #3211
  {14,  3,   0}, // #3212
  {15,  2,   0}, // #3213
  {19,  3,   0}, // #3214
  {22,  3,   0}, // #3215
  { 1,  3,   0}, // #3216
  {22,  2,   0}, // #3217
  {24,  1,   0}, // #3218
  { 1,  4,   0}, // #3219
  { 5,  1,   0}, // #3220
  { 8,  1,   0}, // #3221
  {22,  3,   0}, // #3222
  {24,  1,   0}, // #3223
  { 1,  3,   0}, // #3224
  {13,  1,   0}, // #3225
  {14,  1,   0}, // #3226
  {16,  1,   0}, // #3227
  {19,  1,   0}, // #3228
  {22,  3,   0}, // #3229
  { 1,  3,   0}, // #3230
  {10,  2,   0}, // #3231
  {14,  1,   0}, // #3232
  {16,  1,   0}, // #3233
  {19,  1,   0}, // #3234
  {22,  3,   0}, // #3235
  { 1,  1,   0}, // #3236
  { 5,  1,   0}, // #3237
  { 8,  1,   0}, // #3238
  {24,  1,   0}, // #3239
  { 1,  1,   0}, // #3240
  { 5, 22,   0}, // #3241
  { 8, 22,   0}, // #3242
  {22,  1,   0}, // #3243
  {10, 18,   0}, // #3244
  {14,  1,   0}, // #3245
  {16,  1,   0}, // #3246
  {19,  1,   0}, // #3247
  { 1, 18,   0}, // #3248
  {24, 18,   0}, // #3249
  { 1,  3,   0}, // #3250
  {10,  3,   0}, // #3251
  {14,  1,   0}, // #3252
  {22,  3,   0}, // #3253
  { 1,  3,   0}, // #3254
  {10,  2,   0}, // #3255
  {14,  1,   0}, // #3256
  {15,  1,   0}, // #3257
  {19,  1,   0}, // #3258
  {22,  3,   0}, // #3259
  { 1,  3,   0}, // #3260
  {14,  2,   0}, // #3261
  {16,  2,   0}, // #3262
  {19,  2,   0}, // #3263
  {21,  2,   0}, // #3264
  {22,  3,   0}, // #3265
  { 1,  3,   0}, // #3266
  {11,  2,   0}, // #3267
  {14,  2,   0}, // #3268
  {20,  2,   0}, // #3269
  {22,  3,   0}, // #3270
  { 1,  3,   0}, // #3271
  {11,  1,   0}, // #3272
  {14,  1,   0}, // #3273
  {19,  1,   0}, // #3274
  {22,  3,   0}, // #3275
  { 1,  3,   0}, // #3276
  { 9,  2,   0}, // #3277
  {10,  1,   0}, // #3278
  {13,  1,   0}, // #3279
  {14,  1,   0}, // #3280
  {15,  1,   0}, // #3281
  {19,  1,   0}, // #3282
  {22,  3,   0}, // #3283
  { 1,  1,   0}, // #3284
  { 9,  2,   0}, // #3285
  {10,  1,   0}, // #3286
  {13,  1,   0}, // #3287
  {14,  1,   0}, // #3288
  {15,  1,   0}, // #3289
  {19,  1,   0}, // #3290
  {24,  1,   0}, // #3291
  { 1,  1,   0}, // #3292
  { 9,  2,   0}, // #3293
  {13,  1,   0}, // #3294
  {14,  1,   0}, // #3295
  {15,  1,   0}, // #3296
  {19,  1,   0}, // #3297
  {24,  1,   0}, // #3298
  { 1,  3,   0}, // #3299
  {10, 18,   0}, // #3300
  {14,  2,   0}, // #3301
  {16,  2,   0}, // #3302
  {19,  2,   0}, // #3303
  {22,  3,   0}, // #3304
  { 1,  3,   0}, // #3305
  {10, 25,   0}, // #3306
  {14,  2,   0}, // #3307
  {16,  2,   0}, // #3308
  {19,  2,   0}, // #3309
  {22,  3,   0}, // #3310
  { 1,  3,   0}, // #3311
  {13,  1,   0}, // #3312
  {14,  2,   0}, // #3313
  {16,  2,   0}, // #3314
  {19,  2,   0}, // #3315
  {22,  3,   0}, // #3316
  { 1,  3,   0}, // #3317
  {10,  8,   0}, // #3318
  {14,  1,   0}, // #3319
  {15,  1,   0}, // #3320
  {19,  1,   0}, // #3321
  {22,  3,   0}, // #3322
  { 1,  3,   0}, // #3323
  {11,  3,   0}, // #3324
  {14,  2,   0}, // #3325
  {19,  2,   0}, // #3326
  {22,  3,   0}, // #3327
  { 1,  2,   0}, // #3328
  {10, 376,   0}, // #3329
  {14,  2,   0}, // #3330
  {19,  2,   0}, // #3331
  {24,  2,   0}, // #3332
  { 1,  3,   0}, // #3333
  {10,  4,   0}, // #3334
  {14,  2,   0}, // #3335
  {19,  2,   0}, // #3336
  {22,  3,   0}, // #3337
  { 1,  1,   0}, // #3338
  {10, 188,   0}, // #3339
  {14,  1,   0}, // #3340
  {19,  1,   0}, // #3341
  {24,  1,   0}, // #3342
  { 1,  3,   0}, // #3343
  {10,  4,   0}, // #3344
  {14,  1,   0}, // #3345
  {19,  1,   0}, // #3346
  {22,  3,   0}, // #3347
  {10,  2,   0}, // #3348
  {14,  2,   0}, // #3349
  {19,  2,   0}, // #3350
  { 1,  2,   0}, // #3351
  {13,  2,   0}, // #3352
  {14, 36,   0}, // #3353
  {20, 36,   0}, // #3354
  {24,  2,   0}, // #3355
  {11,  2,   0}, // #3356
  {14,  2,   0}, // #3357
  {19,  2,   0}, // #3358
  { 1,  3,   0}, // #3359
  {11,  4,   0}, // #3360
  {14,  2,   0}, // #3361
  {19,  2,   0}, // #3362
  {22,  3,   0}, // #3363
  { 1,  2,   0}, // #3364
  {13,  2,   0}, // #3365
  {14,  2,   0}, // #3366
  {16,  2,   0}, // #3367
  {19,  2,   0}, // #3368
  {24,  2,   0}, // #3369
  { 1,  3,   0}, // #3370
  { 5,  1,   0}, // #3371
  { 6,  1,   0}, // #3372
  { 8,  1,   0}, // #3373
  {10,  4,   0}, // #3374
  {14,  2,   0}, // #3375
  {19,  2,   0}, // #3376
  {22,  3,   0}, // #3377
  { 1,  3,   0}, // #3378
  {10,  1,   0}, // #3379
  {14,  2,   0}, // #3380
  {16,  2,   0}, // #3381
  {19,  2,   0}, // #3382
  {22,  3,   0}, // #3383
  { 1,  3,   0}, // #3384
  {10,  2,   0}, // #3385
  {14,  2,   0}, // #3386
  {16,  2,   0}, // #3387
  {19,  2,   0}, // #3388
  {22,  3,   0}, // #3389
  { 1,  3,   0}, // #3390
  { 5,  1,   0}, // #3391
  { 6,  1,   0}, // #3392
  { 8,  1,   0}, // #3393
  {10,  4,   0}, // #3394
  {14,  4,   0}, // #3395
  {19,  4,   0}, // #3396
  {22,  3,   0}, // #3397
  { 9,  3,   0}, // #3398
  {13,  1,   0}, // #3399
  {14,  1,   0}, // #3400
  {15,  1,   0}, // #3401
  {19,  1,   0}, // #3402
  { 5, 23,   0}, // #3403
  { 7, 23,   0}, // #3404
  { 8, 23,   0}, // #3405
  { 5, 21,   0}, // #3406
  { 7, 21,   0}, // #3407
  { 8, 21,   0}, // #3408
  { 5, 26,   0}, // #3409
  { 7, 26,   0}, // #3410
  { 8, 26,   0}, // #3411
  { 5, 69,   0}, // #3412
  { 7, 69,   0}, // #3413
  { 8, 69,   0}, // #3414
  { 5, 14,   0}, // #3415
  { 8, 14,   0}, // #3416
  { 5, 25,   0}, // #3417
  { 8, 25,   0}, // #3418
  { 5, 20,   0}, // #3419
  { 7, 20,   0}, // #3420
  { 8, 20,   0}, // #3421
  { 1,  3,   0}, // #3422
  {10, 10,   0}, // #3423
  {14,  1,   0}, // #3424
  {15,  1,   0}, // #3425
  {19,  1,   0}, // #3426
  {22,  3,   0}, // #3427
  { 1,  3,   0}, // #3428
  {10, 18,   0}, // #3429
  {14,  1,   0}, // #3430
  {15,  1,   0}, // #3431
  {19,  1,   0}, // #3432
  {22,  3,   0}, // #3433
  { 1,  1,   0}, // #3434
  {10,  4,   0}, // #3435
  {14,  2,   0}, // #3436
  {19,  2,   0}, // #3437
  {22,  1,   0}, // #3438
  { 5, 375,   0}, // #3439
  { 8, 375,   0}, // #3440
  { 5, 24,   0}, // #3441
  { 8, 24,   0}, // #3442
  {10,  6,   0}, // #3443
  {14,  1,   0}, // #3444
  {19,  1,   0}, // #3445
  {10,  8,   0}, // #3446
  {14,  1,   0}, // #3447
  {19,  1,   0}, // #3448
  { 5,  3,   0}, // #3449
  { 8,  3,   0}, // #3450
  { 5, 18,   0}, // #3451
  { 8, 18,   0}, // #3452
  { 5, 88,   0}, // #3453
  { 8, 88,   0}, // #3454
  { 1,  3,   0}, // #3455
  { 5,  3,   0}, // #3456
  { 8,  3,   0}, // #3457
  {22,  3,   0}, // #3458
  { 5, 10,   0}, // #3459
  { 8, 10,   0}, // #3460
  { 5, 12,   0}, // #3461
  { 8, 12,   0}, // #3462
  { 5, 17,   0}, // #3463
  { 8, 17,   0}, // #3464
  { 5,  5,   0}, // #3465
  { 8,  5,   0}, // #3466
  { 5, 23,   0}, // #3467
  { 8, 23,   0}, // #3468
  { 5, 20,   0}, // #3469
  { 8, 20,   0}, // #3470
  { 5, 19,   0}, // #3471
  { 8, 19,   0}, // #3472
  { 5, 13,   0}, // #3473
  { 8, 13,   0}, // #3474
  { 5, 21,   0}, // #3475
  { 8, 21,   0}, // #3476
  { 5, 15,   0}, // #3477
  { 8, 15,   0}, // #3478
  {13,  1,   0}, // #3479
  {14, 10,   0}, // #3480
  {16, 10,   0}, // #3481
  {19, 10,   0}, // #3482
  {13,  1,   0}, // #3483
  {14,  3,   0}, // #3484
  {16,  3,   0}, // #3485
  {19,  3,   0}, // #3486
  {13,  1,   0}, // #3487
  {14,  4,   0}, // #3488
  {16,  4,   0}, // #3489
  {19,  4,   0}, // #3490
  {11,  1,   0}, // #3491
  {12,  1,   0}, // #3492
  {14,  1,   0}, // #3493
  {15,  1,   0}, // #3494
  {19,  1,   0}, // #3495
  {11,  1,   0}, // #3496
  {22,  1,   0}, // #3497
  { 1,  1,   0}, // #3498
  { 4,  1,   0}, // #3499
  { 1,  2,   0}, // #3500
  { 4,  1,   0}, // #3501
  {11,  1,   0}, // #3502
  {15,  1,   0}, // #3503
  {18,  1,   0}, // #3504
  {20,  1,   0}, // #3505
  {21,  1,   0}, // #3506
  {22,  1,   0}, // #3507
  { 1,  1,   0}, // #3508
  {11,  1,   0}, // #3509
  {21,  1,   0}, // #3510
  { 1,  1,   0}, // #3511
  {11,  1,   0}, // #3512
  {16,  1,   0}, // #3513
  {22,  1,   0}, // #3514
  { 1,  1,   0}, // #3515
  { 4,  2,   0}, // #3516
  { 1,  1,   0}, // #3517
  { 4, 12,   0}, // #3518
  { 1,  1,   0}, // #3519
  { 4, 16,   0}, // #3520
  { 1,  1,   0}, // #3521
  {11,  2,   0}, // #3522
  {14,  1,   0}, // #3523
  {16,  1,   0}, // #3524
  {17,  1,   0}, // #3525
  {19,  1,   0}, // #3526
  {21,  1,   0}, // #3527
  {22,  1,   0}, // #3528
  { 1,  1,   0}, // #3529
  {11,  1,   0}, // #3530
  {12,  1,   0}, // #3531
  {16,  1,   0}, // #3532
  {17,  1,   0}, // #3533
  {18,  1,   0}, // #3534
  {22,  1,   0}, // #3535
  { 1,  1,   0}, // #3536
  {11,  1,   0}, // #3537
  {15,  1,   0}, // #3538
  {18,  1,   0}, // #3539
  {20,  1,   0}, // #3540
  {21,  1,   0}, // #3541
  {22,  1,   0}, // #3542
  { 1,  1,   0}, // #3543
  {11,  2,   0}, // #3544
  {15,  2,   0}, // #3545
  {18,  2,   0}, // #3546
  {20,  2,   0}, // #3547
  {21,  2,   0}, // #3548
  {22,  2,   0}, // #3549
  { 1,  1,   0}, // #3550
  { 4,  1,   0}, // #3551
  { 7,  1,   0}, // #3552
  {10, 17,   0}, // #3553
  { 1,  1,   0}, // #3554
  { 4,  1,   0}, // #3555
  { 7,  1,   0}, // #3556
  {10, 25,   0}, // #3557
  { 1,  1,   0}, // #3558
  { 4,  1,   0}, // #3559
  { 7,  1,   0}, // #3560
  {10, 41,   0}, // #3561
  { 1,  1,   0}, // #3562
  { 4,  1,   0}, // #3563
  { 7,  1,   0}, // #3564
  {10, 15,   0}, // #3565
  { 1,  1,   0}, // #3566
  {11,  5,   0}, // #3567
  {15,  5,   0}, // #3568
  {18,  5,   0}, // #3569
  {20,  5,   0}, // #3570
  {21,  5,   0}, // #3571
  {22,  5,   0}, // #3572
  { 1,  1,   0}, // #3573
  {11,  3,   0}, // #3574
  {15,  3,   0}, // #3575
  {18,  3,   0}, // #3576
  {20,  3,   0}, // #3577
  {21,  3,   0}, // #3578
  {22,  3,   0}, // #3579
  { 1,  1,   0}, // #3580
  {11,  5,   0}, // #3581
  {14,  3,   0}, // #3582
  {17,  3,   0}, // #3583
  {19,  5,   0}, // #3584
  {21,  3,   0}, // #3585
  {11,  3,   0}, // #3586
  {14,  2,   0}, // #3587
  {17,  2,   0}, // #3588
  {19,  3,   0}, // #3589
  {21,  2,   0}, // #3590
  { 1,  1,   0}, // #3591
  {11,  1,   0}, // #3592
  {22,  1,   0}, // #3593
  { 1,  1,   0}, // #3594
  { 4,  1,   0}, // #3595
  { 6,  1,   0}, // #3596
  {23,  1,   0}, // #3597
  { 1,  1,   0}, // #3598
  {11,  1,   0}, // #3599
  {19,  1,   0}, // #3600
  { 1,  1,   0}, // #3601
  {11,  1,   0}, // #3602
  {20,  1,   0}, // #3603
  {22,  1,   0}, // #3604
  {11,  1,   0}, // #3605
  {14,  1,   0}, // #3606
  {17,  1,   0}, // #3607
  {19,  1,   0}, // #3608
  {21,  1,   0}, // #3609
  { 1,  1,   0}, // #3610
  {11,  1,   0}, // #3611
  {14,  1,   0}, // #3612
  {17,  1,   0}, // #3613
  {19,  1,   0}, // #3614
  {21,  1,   0}, // #3615
  { 1,  1,   0}, // #3616
  { 4,  1,   0}, // #3617
  { 6,  1,   0}, // #3618
  {23,  2,   0}, // #3619
  { 1,  1,   0}, // #3620
  {11,  2,   0}, // #3621
  {12,  2,   0}, // #3622
  {16,  2,   0}, // #3623
  {17,  2,   0}, // #3624
  {18,  2,   0}, // #3625
  {22,  2,   0}, // #3626
  { 1,  1,   0}, // #3627
  {11,  2,   0}, // #3628
  {19,  2,   0}, // #3629
  { 1,  1,   0}, // #3630
  {11,  8,   0}, // #3631
  {15,  8,   0}, // #3632
  {18,  8,   0}, // #3633
  {20,  8,   0}, // #3634
  {21,  8,   0}, // #3635
  {22,  8,   0}, // #3636
  {11, 20,   0}, // #3637
  {15, 20,   0}, // #3638
  {18, 20,   0}, // #3639
  {20, 20,   0}, // #3640
  {21, 20,   0}, // #3641
  {22, 20,   0}, // #3642
  { 1,  1,   0}, // #3643
  {11,  2,   0}, // #3644
  {21,  2,   0}, // #3645
  { 1,  1,   0}, // #3646
  {11,  2,   0}, // #3647
  {16,  2,   0}, // #3648
  {22,  2,   0}, // #3649
  { 1,  1,   0}, // #3650
  {11,  6,   0}, // #3651
  {15,  6,   0}, // #3652
  {18,  6,   0}, // #3653
  {20,  6,   0}, // #3654
  {21,  6,   0}, // #3655
  {22,  6,   0}, // #3656
  { 1,  1,   0}, // #3657
  {11,  9,   0}, // #3658
  {15,  9,   0}, // #3659
  {18,  9,   0}, // #3660
  {20,  9,   0}, // #3661
  {21,  9,   0}, // #3662
  {22,  9,   0}, // #3663
  { 1,  1,   0}, // #3664
  {11,  2,   0}, // #3665
  {22,  2,   0}, // #3666
  { 1,  1,   0}, // #3667
  {11,  3,   0}, // #3668
  {16,  3,   0}, // #3669
  {22,  3,   0}, // #3670
  { 1,  1,   0}, // #3671
  {11,  4,   0}, // #3672
  {19,  4,   0}, // #3673
  {11,  2,   0}, // #3674
  {14,  2,   0}, // #3675
  {17,  2,   0}, // #3676
  {19,  2,   0}, // #3677
  {21,  2,   0}, // #3678
  { 1,  1,   0}, // #3679
  {11,  4,   0}, // #3680
  {12,  4,   0}, // #3681
  {16,  4,   0}, // #3682
  {17,  4,   0}, // #3683
  {18,  4,   0}, // #3684
  {22,  4,   0}, // #3685
  { 1,  1,   0}, // #3686
  {11,  2,   0}, // #3687
  {14,  2,   0}, // #3688
  {17,  2,   0}, // #3689
  {19,  2,   0}, // #3690
  {21,  2,   0}, // #3691
  { 1,  1,   0}, // #3692
  {11,  2,   0}, // #3693
  {13,  2,   0}, // #3694
  {16,  2,   0}, // #3695
  {19,  2,   0}, // #3696
  {20,  2,   0}, // #3697
  {22,  2,   0}, // #3698
  { 1,  1,   0}, // #3699
  {11,  4,   0}, // #3700
  {13,  4,   0}, // #3701
  {16,  4,   0}, // #3702
  {19,  4,   0}, // #3703
  {20,  4,   0}, // #3704
  {22,  4,   0}, // #3705
  { 1,  1,   0}, // #3706
  {11, 10,   0}, // #3707
  {15, 10,   0}, // #3708
  {18, 10,   0}, // #3709
  {20, 10,   0}, // #3710
  {21, 10,   0}, // #3711
  {22, 10,   0}, // #3712
  { 1,  1,   0}, // #3713
  {11, 16,   0}, // #3714
  {15, 16,   0}, // #3715
  {18, 16,   0}, // #3716
  {20, 16,   0}, // #3717
  {21, 16,   0}, // #3718
  {22, 16,   0}, // #3719
  {11,  2,   0}, // #3720
  {15,  1,   0}, // #3721
  {18,  1,   0}, // #3722
  {19,  1,   0}, // #3723
  {20,  1,   0}, // #3724
  {21,  1,   0}, // #3725
  {22,  1,   0}, // #3726
  { 1,  1,   0}, // #3727
  {11,  2,   0}, // #3728
  {15,  1,   0}, // #3729
  {18,  1,   0}, // #3730
  {19,  1,   0}, // #3731
  {20,  1,   0}, // #3732
  {21,  1,   0}, // #3733
  {22,  1,   0}, // #3734
  { 4,  1,   0}, // #3735
  { 9,  1,   0}, // #3736
  { 1,  1,   0}, // #3737
  {11,  1,   0}, // #3738
  {17,  1,   0}, // #3739
  { 1,  5,   0}, // #3740
  {11,  3,   0}, // #3741
  {14,  2,   0}, // #3742
  {17,  2,   0}, // #3743
  {19,  3,   0}, // #3744
  {21,  2,   0}, // #3745
  { 1,  1,   0}, // #3746
  {11,  1,   0}, // #3747
  {18,  1,   0}, // #3748
  {22,  1,   0}, // #3749
  { 1,  1,   0}, // #3750
  {11,  3,   0}, // #3751
  {18,  3,   0}, // #3752
  {22,  3,   0}, // #3753
  { 1,  1,   0}, // #3754
  {11,  2,   0}, // #3755
  {18,  2,   0}, // #3756
  {22,  2,   0}, // #3757
  { 1,  1,   0}, // #3758
  { 4,  1,   0}, // #3759
  { 9,  1,   0}, // #3760
  {11,  6,   0}, // #3761
  {12,  3,   0}, // #3762
  {16,  3,   0}, // #3763
  {17,  3,   0}, // #3764
  {18,  3,   0}, // #3765
  {19,  3,   0}, // #3766
  {22,  3,   0}, // #3767
  { 1,  1,   0}, // #3768
  {11,  6,   0}, // #3769
  {12,  3,   0}, // #3770
  {16,  3,   0}, // #3771
  {17,  3,   0}, // #3772
  {18,  3,   0}, // #3773
  {19,  3,   0}, // #3774
  {22,  3,   0}, // #3775
  {11,  2,   0}, // #3776
  {15,  1,   0}, // #3777
  {18,  1,   0}, // #3778
  {20,  1,   0}, // #3779
  {21,  1,   0}, // #3780
  {22,  2,   0}, // #3781
  {11,  2,   0}, // #3782
  {14,  1,   0}, // #3783
  {15,  1,   0}, // #3784
  {17,  1,   0}, // #3785
  {18,  1,   0}, // #3786
  {19,  1,   0}, // #3787
  {20,  1,   0}, // #3788
  {21,  2,   0}, // #3789
  {22,  1,   0}, // #3790
  { 1,  1,   0}, // #3791
  {11,  2,   0}, // #3792
  {14,  1,   0}, // #3793
  {15,  1,   0}, // #3794
  {17,  1,   0}, // #3795
  {18,  1,   0}, // #3796
  {19,  1,   0}, // #3797
  {20,  1,   0}, // #3798
  {21,  2,   0}, // #3799
  {22,  1,   0}, // #3800
  {11,  2,   0}, // #3801
  {14,  1,   0}, // #3802
  {17,  1,   0}, // #3803
  {19,  2,   0}, // #3804
  {21,  1,   0}, // #3805
  {11,  2,   0}, // #3806
  {13,  1,   0}, // #3807
  {16,  1,   0}, // #3808
  {18,  1,   0}, // #3809
  {19,  1,   0}, // #3810
  {20,  1,   0}, // #3811
  {22,  2,   0}, // #3812
  {11,  1,   0}, // #3813
  {13,  1,   0}, // #3814
  {16,  1,   0}, // #3815
  {19,  1,   0}, // #3816
  {20,  1,   0}, // #3817
  {22,  1,   0}, // #3818
  { 1,  1,   0}, // #3819
  {11,  1,   0}, // #3820
  {13,  1,   0}, // #3821
  {16,  1,   0}, // #3822
  {19,  1,   0}, // #3823
  {20,  1,   0}, // #3824
  {22,  1,   0}, // #3825
  {22,  1,   0}, // #3826
  {23,  1,   0}, // #3827
  {15,  1,   0}, // #3828
  {19,  1,   0}, // #3829
  {22,  1,   0}, // #3830
  {23,  1,   0}, // #3831
  {14,  1,   0}, // #3832
  {20,  1,   0}, // #3833
  {22,  1,   0}, // #3834
  {23,  1,   0}, // #3835
  { 7,  1,   0}, // #3836
  {12,  1,   0}, // #3837
  {14,  2,   0}, // #3838
  {17,  1,   0}, // #3839
  {20,  2,   0}, // #3840
  {21,  2,   0}, // #3841
  {22,  3,   0}, // #3842
  {23,  6,   0}, // #3843
  {14,  1,   0}, // #3844
  {17,  1,   0}, // #3845
  {20,  1,   0}, // #3846
  {21,  1,   0}, // #3847
  {22,  1,   0}, // #3848
  {23,  2,   0}, // #3849
  { 7,  1,   0}, // #3850
  {12,  1,   0}, // #3851
  {21,  1,   0}, // #3852
  {23,  2,   0}, // #3853
  {17,  1,   0}, // #3854
  {21,  1,   0}, // #3855
  {23,  1,   0}, // #3856
  { 4,  1,   0}, // #3857
  {11,  1,   0}, // #3858
  {15,  1,   0}, // #3859
  {16,  1,   0}, // #3860
  {19,  1,   0}, // #3861
  {22,  1,   0}, // #3862
  {23,  1,   0}, // #3863
  { 7,  1,   0}, // #3864
  {12,  1,   0}, // #3865
  {17,  1,   0}, // #3866
  {21,  2,   0}, // #3867
  {22,  1,   0}, // #3868
  {23,  4,   0}, // #3869
  { 8,  1,   0}, // #3870
  {13,  1,   0}, // #3871
  {15,  1,   0}, // #3872
  {18,  1,   0}, // #3873
  {19,  1,   0}, // #3874
  {20,  1,   0}, // #3875
  {22,  1,   0}, // #3876
  {23,  1,   0}, // #3877
  {17,  1,   0}, // #3878
  {21,  1,   0}, // #3879
  {22,  1,   0}, // #3880
  {23,  2,   0}, // #3881
  { 4,  1,   0}, // #3882
  {11,  1,   0}, // #3883
  {15,  1,   0}, // #3884
  {16,  1,   0}, // #3885
  {17,  1,   0}, // #3886
  {19,  1,   0}, // #3887
  {21,  1,   0}, // #3888
  {22,  1,   0}, // #3889
  {23,  2,   0}, // #3890
  { 8,  1,   0}, // #3891
  {13,  1,   0}, // #3892
  {15,  1,   0}, // #3893
  {17,  1,   0}, // #3894
  {18,  1,   0}, // #3895
  {19,  1,   0}, // #3896
  {20,  1,   0}, // #3897
  {21,  1,   0}, // #3898
  {22,  1,   0}, // #3899
  {23,  2,   0}, // #3900
  { 8,  2,   0}, // #3901
  {13,  2,   0}, // #3902
  {15,  2,   0}, // #3903
  {17,  1,   0}, // #3904
  {18,  2,   0}, // #3905
  {19,  2,   0}, // #3906
  {20,  2,   0}, // #3907
  {21,  1,   0}, // #3908
  {22,  2,   0}, // #3909
  {23,  3,   0}, // #3910
  { 8,  2,   0}, // #3911
  {13,  2,   0}, // #3912
  {15,  2,   0}, // #3913
  {18,  2,   0}, // #3914
  {19,  2,   0}, // #3915
  {20,  2,   0}, // #3916
  {22,  2,   0}, // #3917
  {23,  2,   0}, // #3918
  { 3,  2,   0}, // #3919
  { 8,  7,   0}, // #3920
  {11,  2,   0}, // #3921
  {12,  2,   0}, // #3922
  {13,  9,   0}, // #3923
  {14,  2,   0}, // #3924
  {15,  7,   0}, // #3925
  {17,  1,   0}, // #3926
  {18,  7,   0}, // #3927
  {19, 10,   0}, // #3928
  {20,  9,   0}, // #3929
  {21,  1,   0}, // #3930
  {22, 10,   0}, // #3931
  {23, 11,   0}, // #3932
  { 3,  2,   0}, // #3933
  { 8,  7,   0}, // #3934
  {11,  2,   0}, // #3935
  {12,  2,   0}, // #3936
  {13,  9,   0}, // #3937
  {14,  2,   0}, // #3938
  {15,  7,   0}, // #3939
  {18,  7,   0}, // #3940
  {19, 11,   0}, // #3941
  {20,  9,   0}, // #3942
  {22, 11,   0}, // #3943
  {23, 11,   0}, // #3944
  {14,  1,   0}, // #3945
  {15,  1,   0}, // #3946
  {17,  1,   0}, // #3947
  {19,  1,   0}, // #3948
  {20,  1,   0}, // #3949
  {21,  1,   0}, // #3950
  {22,  2,   0}, // #3951
  {23,  3,   0}, // #3952
  {14,  1,   0}, // #3953
  {15,  1,   0}, // #3954
  {19,  1,   0}, // #3955
  {20,  1,   0}, // #3956
  {22,  2,   0}, // #3957
  {23,  2,   0}, // #3958
  {15,  1,   0}, // #3959
  {17,  1,   0}, // #3960
  {19,  1,   0}, // #3961
  {21,  1,   0}, // #3962
  {22,  1,   0}, // #3963
  {23,  2,   0}, // #3964
  { 7,  1,   0}, // #3965
  {12,  1,   0}, // #3966
  {14,  1,   0}, // #3967
  {17,  1,   0}, // #3968
  {20,  1,   0}, // #3969
  {21,  2,   0}, // #3970
  {22,  1,   0}, // #3971
  {23,  4,   0}, // #3972
  {22,  3,   0}, // #3973
  {23,  3,   0}, // #3974
  {14,  2,   0}, // #3975
  {20,  2,   0}, // #3976
  {22,  5,   0}, // #3977
  {23,  5,   0}, // #3978
  { 4,  1,   0}, // #3979
  { 8,  1,   0}, // #3980
  {11,  1,   0}, // #3981
  {13,  1,   0}, // #3982
  {15,  2,   0}, // #3983
  {16,  1,   0}, // #3984
  {18,  1,   0}, // #3985
  {19,  2,   0}, // #3986
  {20,  1,   0}, // #3987
  {22,  2,   0}, // #3988
  {23,  2,   0}, // #3989
  { 4,  1,   0}, // #3990
  { 8,  1,   0}, // #3991
  {11,  1,   0}, // #3992
  {13,  1,   0}, // #3993
  {15,  2,   0}, // #3994
  {16,  1,   0}, // #3995
  {17,  1,   0}, // #3996
  {18,  1,   0}, // #3997
  {19,  2,   0}, // #3998
  {20,  1,   0}, // #3999
  {21,  1,   0}, // #4000
  {22,  2,   0}, // #4001
  {23,  3,   0}, // #4002
  { 3,  1,   0}, // #4003
  {11,  1,   0}, // #4004
  {12,  1,   0}, // #4005
  {13,  1,   0}, // #4006
  {14,  1,   0}, // #4007
  {17,  1,   0}, // #4008
  {19,  1,   0}, // #4009
  {20,  1,   0}, // #4010
  {21,  1,   0}, // #4011
  {22,  1,   0}, // #4012
  {23,  2,   0}, // #4013
  { 3,  1,   0}, // #4014
  { 8,  1,   0}, // #4015
  {11,  1,   0}, // #4016
  {12,  1,   0}, // #4017
  {13,  2,   0}, // #4018
  {14,  1,   0}, // #4019
  {15,  1,   0}, // #4020
  {18,  1,   0}, // #4021
  {19,  2,   0}, // #4022
  {20,  2,   0}, // #4023
  {22,  2,   0}, // #4024
  {23,  2,   0}, // #4025
  { 3,  1,   0}, // #4026
  { 4,  1,   0}, // #4027
  {11,  2,   0}, // #4028
  {12,  1,   0}, // #4029
  {13,  1,   0}, // #4030
  {14,  1,   0}, // #4031
  {15,  1,   0}, // #4032
  {16,  1,   0}, // #4033
  {17,  1,   0}, // #4034
  {19,  2,   0}, // #4035
  {20,  1,   0}, // #4036
  {21,  1,   0}, // #4037
  {22,  2,   0}, // #4038
  {23,  3,   0}, // #4039
  { 3,  1,   0}, // #4040
  { 4,  1,   0}, // #4041
  {11,  2,   0}, // #4042
  {12,  1,   0}, // #4043
  {13,  1,   0}, // #4044
  {14,  1,   0}, // #4045
  {15,  1,   0}, // #4046
  {16,  1,   0}, // #4047
  {19,  2,   0}, // #4048
  {20,  1,   0}, // #4049
  {22,  2,   0}, // #4050
  {23,  2,   0}, // #4051
  { 3,  2,   0}, // #4052
  { 4,  2,   0}, // #4053
  { 8,  2,   0}, // #4054
  {11,  4,   0}, // #4055
  {12,  2,   0}, // #4056
  {13,  4,   0}, // #4057
  {14,  2,   0}, // #4058
  {15,  4,   0}, // #4059
  {16,  2,   0}, // #4060
  {17,  1,   0}, // #4061
  {18,  2,   0}, // #4062
  {19,  6,   0}, // #4063
  {20,  4,   0}, // #4064
  {21,  1,   0}, // #4065
  {22,  7,   0}, // #4066
  {23,  8,   0}, // #4067
  { 3,  7,   0}, // #4068
  { 4,  7,   0}, // #4069
  { 8,  3,   0}, // #4070
  { 9,  3,   0}, // #4071
  {11, 15,   0}, // #4072
  {12,  7,   0}, // #4073
  {13, 10,   0}, // #4074
  {14, 10,   0}, // #4075
  {15, 10,   0}, // #4076
  {16, 10,   0}, // #4077
  {18,  6,   0}, // #4078
  {19, 18,   0}, // #4079
  {20, 13,   0}, // #4080
  {22, 32,   0}, // #4081
  {23, 32,   0}, // #4082
  { 1, 10,   0}, // #4083
  { 3,  1,   0}, // #4084
  {11,  1,   0}, // #4085
  {12,  1,   0}, // #4086
  {13,  1,   0}, // #4087
  {14,  1,   0}, // #4088
  {19,  1,   0}, // #4089
  {20,  1,   0}, // #4090
  {22,  1,   0}, // #4091
  {23,  1,   0}, // #4092
  { 2,  8,   0}, // #4093
  { 3,  1,   0}, // #4094
  {11,  1,   0}, // #4095
  {12,  1,   0}, // #4096
  {13,  1,   0}, // #4097
  {14,  1,   0}, // #4098
  {17,  1,   0}, // #4099
  {19,  1,   0}, // #4100
  {20,  1,   0}, // #4101
  {21,  1,   0}, // #4102
  {22,  1,   0}, // #4103
  {23,  2,   0}, // #4104
  { 2,  8,   0}, // #4105
  { 3,  1,   0}, // #4106
  {11,  1,   0}, // #4107
  {12,  1,   0}, // #4108
  {13,  1,   0}, // #4109
  {14,  1,   0}, // #4110
  {19,  1,   0}, // #4111
  {20,  1,   0}, // #4112
  {22,  1,   0}, // #4113
  {23,  1,   0}, // #4114
  { 2,  5,   0}, // #4115
  { 3,  1,   0}, // #4116
  {11,  1,   0}, // #4117
  {12,  1,   0}, // #4118
  {13,  1,   0}, // #4119
  {14,  1,   0}, // #4120
  {17,  1,   0}, // #4121
  {19,  1,   0}, // #4122
  {20,  1,   0}, // #4123
  {21,  1,   0}, // #4124
  {22,  1,   0}, // #4125
  {23,  2,   0}, // #4126
  { 2,  5,   0}, // #4127
  { 3,  1,   0}, // #4128
  {11,  1,   0}, // #4129
  {12,  1,   0}, // #4130
  {13,  1,   0}, // #4131
  {14,  1,   0}, // #4132
  {19,  1,   0}, // #4133
  {20,  1,   0}, // #4134
  {22,  1,   0}, // #4135
  {23,  1,   0}, // #4136
  { 2,  3,   0}, // #4137
  { 3,  1,   0}, // #4138
  {11,  1,   0}, // #4139
  {12,  1,   0}, // #4140
  {13,  1,   0}, // #4141
  {14,  1,   0}, // #4142
  {19,  1,   0}, // #4143
  {20,  1,   0}, // #4144
  {22,  1,   0}, // #4145
  {23,  1,   0}, // #4146
  { 2,  4,   0}, // #4147
  { 3,  1,   0}, // #4148
  {11,  1,   0}, // #4149
  {12,  1,   0}, // #4150
  {13,  1,   0}, // #4151
  {14,  1,   0}, // #4152
  {19,  1,   0}, // #4153
  {20,  1,   0}, // #4154
  {22,  1,   0}, // #4155
  {23,  1,   0}, // #4156
  { 3,  1,   0}, // #4157
  { 4,  1,   0}, // #4158
  { 8,  1,   0}, // #4159
  {11,  2,   0}, // #4160
  {12,  1,   0}, // #4161
  {13,  2,   0}, // #4162
  {14,  1,   0}, // #4163
  {15,  2,   0}, // #4164
  {16,  1,   0}, // #4165
  {17,  1,   0}, // #4166
  {18,  1,   0}, // #4167
  {19,  3,   0}, // #4168
  {20,  2,   0}, // #4169
  {21,  1,   0}, // #4170
  {22,  3,   0}, // #4171
  {23,  4,   0}, // #4172
  { 3,  1,   0}, // #4173
  { 4,  1,   0}, // #4174
  { 8,  1,   0}, // #4175
  {11,  2,   0}, // #4176
  {12,  1,   0}, // #4177
  {13,  2,   0}, // #4178
  {14,  1,   0}, // #4179
  {15,  2,   0}, // #4180
  {16,  1,   0}, // #4181
  {18,  1,   0}, // #4182
  {19,  3,   0}, // #4183
  {20,  2,   0}, // #4184
  {22,  3,   0}, // #4185
  {23,  3,   0}, // #4186
  { 3,  2,   0}, // #4187
  { 4,  1,   0}, // #4188
  { 8,  1,   0}, // #4189
  {11,  3,   0}, // #4190
  {12,  2,   0}, // #4191
  {13,  3,   0}, // #4192
  {14,  3,   0}, // #4193
  {15,  2,   0}, // #4194
  {16,  1,   0}, // #4195
  {17,  1,   0}, // #4196
  {18,  1,   0}, // #4197
  {19,  4,   0}, // #4198
  {20,  4,   0}, // #4199
  {21,  1,   0}, // #4200
  {22,  5,   0}, // #4201
  {23,  6,   0}, // #4202
  { 3,  2,   0}, // #4203
  { 4,  1,   0}, // #4204
  { 8,  1,   0}, // #4205
  {11,  3,   0}, // #4206
  {12,  2,   0}, // #4207
  {13,  3,   0}, // #4208
  {14,  2,   0}, // #4209
  {15,  2,   0}, // #4210
  {16,  1,   0}, // #4211
  {18,  1,   0}, // #4212
  {19,  4,   0}, // #4213
  {20,  3,   0}, // #4214
  {22,  4,   0}, // #4215
  {23,  4,   0}, // #4216
  { 7,  1,   0}, // #4217
  { 8,  1,   0}, // #4218
  {12,  1,   0}, // #4219
  {13,  1,   0}, // #4220
  {15,  1,   0}, // #4221
  {18,  1,   0}, // #4222
  {19,  1,   0}, // #4223
  {20,  1,   0}, // #4224
  {21,  1,   0}, // #4225
  {22,  1,   0}, // #4226
  {23,  3,   0}, // #4227
  {11,  8,   0}, // #4228
  {15,  1,   0}, // #4229
  {19, 30,   0}, // #4230
  {22, 31,   0}, // #4231
  {23, 31,   0}, // #4232
  {11,  2,   0}, // #4233
  {19,  2,   0}, // #4234
  {22,  2,   0}, // #4235
  {23,  2,   0}, // #4236
  { 4,  1,   0}, // #4237
  { 8,  2,   0}, // #4238
  {11,  1,   0}, // #4239
  {13,  2,   0}, // #4240
  {15,  3,   0}, // #4241
  {16,  1,   0}, // #4242
  {17,  1,   0}, // #4243
  {18,  2,   0}, // #4244
  {19,  3,   0}, // #4245
  {20,  2,   0}, // #4246
  {21,  1,   0}, // #4247
  {22,  3,   0}, // #4248
  {23,  4,   0}, // #4249
  { 4,  1,   0}, // #4250
  { 8,  2,   0}, // #4251
  {11,  1,   0}, // #4252
  {13,  2,   0}, // #4253
  {15,  3,   0}, // #4254
  {16,  1,   0}, // #4255
  {18,  2,   0}, // #4256
  {19,  3,   0}, // #4257
  {20,  2,   0}, // #4258
  {22,  3,   0}, // #4259
  {23,  3,   0}, // #4260
  { 4,  1,   0}, // #4261
  {11,  1,   0}, // #4262
  {14,  1,   0}, // #4263
  {15,  1,   0}, // #4264
  {16,  1,   0}, // #4265
  {17,  1,   0}, // #4266
  {19,  1,   0}, // #4267
  {20,  1,   0}, // #4268
  {21,  1,   0}, // #4269
  {22,  4,   0}, // #4270
  {23,  5,   0}, // #4271
  { 4,  1,   0}, // #4272
  {11,  1,   0}, // #4273
  {14,  1,   0}, // #4274
  {15,  1,   0}, // #4275
  {16,  1,   0}, // #4276
  {19,  1,   0}, // #4277
  {20,  1,   0}, // #4278
  {22,  4,   0}, // #4279
  {23,  4,   0}, // #4280
  { 4,  1,   0}, // #4281
  {11,  1,   0}, // #4282
  {15,  1,   0}, // #4283
  {16,  1,   0}, // #4284
  {17,  1,   0}, // #4285
  {19,  1,   0}, // #4286
  {21,  1,   0}, // #4287
  {22,  2,   0}, // #4288
  {23,  3,   0}, // #4289
  { 4,  1,   0}, // #4290
  {11,  1,   0}, // #4291
  {15,  1,   0}, // #4292
  {16,  1,   0}, // #4293
  {19,  1,   0}, // #4294
  {22,  2,   0}, // #4295
  {23,  2,   0}, // #4296
  { 4,  1,   0}, // #4297
  {11,  1,   0}, // #4298
  {14,  1,   0}, // #4299
  {15,  1,   0}, // #4300
  {16,  1,   0}, // #4301
  {17,  1,   0}, // #4302
  {19,  1,   0}, // #4303
  {20,  1,   0}, // #4304
  {21,  1,   0}, // #4305
  {22,  3,   0}, // #4306
  {23,  4,   0}, // #4307
  { 4,  1,   0}, // #4308
  {11,  1,   0}, // #4309
  {14,  1,   0}, // #4310
  {15,  1,   0}, // #4311
  {16,  1,   0}, // #4312
  {19,  1,   0}, // #4313
  {20,  1,   0}, // #4314
  {22,  3,   0}, // #4315
  {23,  3,   0}, // #4316
  { 3,  1,   0}, // #4317
  {11,  1,   0}, // #4318
  {12,  1,   0}, // #4319
  {13,  1,   0}, // #4320
  {14,  1,   0}, // #4321
  {17,  1,   0}, // #4322
  {19,  1,   0}, // #4323
  {20,  1,   0}, // #4324
  {21,  1,   0}, // #4325
  {22,  2,   0}, // #4326
  {23,  3,   0}, // #4327
  {11,  1,   0}, // #4328
  {19,  1,   0}, // #4329
  {22,  1,   0}, // #4330
  {23,  1,   0}, // #4331
  { 7,  1,   0}, // #4332
  {12,  1,   0}, // #4333
  {17,  1,   0}, // #4334
  {21,  1,   0}, // #4335
  {23,  2,   0}, // #4336
  { 8,  2,   0}, // #4337
  {13,  2,   0}, // #4338
  {15,  3,   0}, // #4339
  {17,  1,   0}, // #4340
  {18,  2,   0}, // #4341
  {19,  3,   0}, // #4342
  {20,  2,   0}, // #4343
  {21,  1,   0}, // #4344
  {22,  3,   0}, // #4345
  {23,  4,   0}, // #4346
  { 8,  2,   0}, // #4347
  {13,  2,   0}, // #4348
  {15,  3,   0}, // #4349
  {18,  2,   0}, // #4350
  {19,  3,   0}, // #4351
  {20,  2,   0}, // #4352
  {22,  3,   0}, // #4353
  {23,  3,   0}, // #4354
  { 3,  1,   0}, // #4355
  { 8,  2,   0}, // #4356
  {11,  1,   0}, // #4357
  {12,  1,   0}, // #4358
  {13,  3,   0}, // #4359
  {14,  1,   0}, // #4360
  {15,  2,   0}, // #4361
  {17,  1,   0}, // #4362
  {18,  2,   0}, // #4363
  {19,  3,   0}, // #4364
  {20,  3,   0}, // #4365
  {21,  1,   0}, // #4366
  {22,  3,   0}, // #4367
  {23,  4,   0}, // #4368
  { 3,  1,   0}, // #4369
  { 8,  2,   0}, // #4370
  {11,  1,   0}, // #4371
  {12,  1,   0}, // #4372
  {13,  3,   0}, // #4373
  {14,  1,   0}, // #4374
  {15,  2,   0}, // #4375
  {18,  2,   0}, // #4376
  {19,  3,   0}, // #4377
  {20,  3,   0}, // #4378
  {22,  3,   0}, // #4379
  {23,  3,   0}, // #4380
  {11,  1,   0}, // #4381
  {17,  1,   0}, // #4382
  {19,  1,   0}, // #4383
  {21,  1,   0}, // #4384
  {22,  1,   0}, // #4385
  {23,  2,   0}, // #4386
  { 3,  4,   0}, // #4387
  { 8,  3,   0}, // #4388
  {11,  4,   0}, // #4389
  {12,  4,   0}, // #4390
  {13,  7,   0}, // #4391
  {14,  4,   0}, // #4392
  {15,  3,   0}, // #4393
  {17,  1,   0}, // #4394
  {18,  3,   0}, // #4395
  {19,  7,   0}, // #4396
  {20,  7,   0}, // #4397
  {21,  1,   0}, // #4398
  {22,  8,   0}, // #4399
  {23,  9,   0}, // #4400
  { 3,  4,   0}, // #4401
  { 8,  3,   0}, // #4402
  {11,  4,   0}, // #4403
  {12,  4,   0}, // #4404
  {13,  7,   0}, // #4405
  {14,  4,   0}, // #4406
  {15,  3,   0}, // #4407
  {18,  3,   0}, // #4408
  {19,  7,   0}, // #4409
  {20,  7,   0}, // #4410
  {22,  8,   0}, // #4411
  {23,  8,   0}, // #4412
  { 3,  4,   0}, // #4413
  { 8,  3,   0}, // #4414
  {11,  4,   0}, // #4415
  {12,  4,   0}, // #4416
  {13,  7,   0}, // #4417
  {14,  4,   0}, // #4418
  {15,  3,   0}, // #4419
  {17,  1,   0}, // #4420
  {18,  3,   0}, // #4421
  {19,  8,   0}, // #4422
  {20,  7,   0}, // #4423
  {21,  1,   0}, // #4424
  {22,  9,   0}, // #4425
  {23, 10,   0}, // #4426
  { 3,  4,   0}, // #4427
  { 8,  3,   0}, // #4428
  {11,  4,   0}, // #4429
  {12,  4,   0}, // #4430
  {13,  7,   0}, // #4431
  {14,  4,   0}, // #4432
  {15,  3,   0}, // #4433
  {18,  3,   0}, // #4434
  {19,  8,   0}, // #4435
  {20,  7,   0}, // #4436
  {22,  9,   0}, // #4437
  {23,  9,   0}, // #4438
  { 3,  3,   0}, // #4439
  {11,  3,   0}, // #4440
  {12,  3,   0}, // #4441
  {13,  3,   0}, // #4442
  {14,  3,   0}, // #4443
  {17,  1,   0}, // #4444
  {19,  3,   0}, // #4445
  {20,  3,   0}, // #4446
  {21,  1,   0}, // #4447
  {22,  3,   0}, // #4448
  {23,  4,   0}, // #4449
  { 3,  3,   0}, // #4450
  {11,  3,   0}, // #4451
  {12,  3,   0}, // #4452
  {13,  3,   0}, // #4453
  {14,  3,   0}, // #4454
  {19,  3,   0}, // #4455
  {20,  3,   0}, // #4456
  {22,  3,   0}, // #4457
  {23,  3,   0}, // #4458
  { 3,  2,   0}, // #4459
  {11,  2,   0}, // #4460
  {12,  2,   0}, // #4461
  {13,  2,   0}, // #4462
  {14,  2,   0}, // #4463
  {17,  1,   0}, // #4464
  {19,  2,   0}, // #4465
  {20,  2,   0}, // #4466
  {21,  1,   0}, // #4467
  {22,  2,   0}, // #4468
  {23,  3,   0}, // #4469
  { 3,  2,   0}, // #4470
  {11,  2,   0}, // #4471
  {12,  2,   0}, // #4472
  {13,  2,   0}, // #4473
  {14,  2,   0}, // #4474
  {19,  2,   0}, // #4475
  {20,  2,   0}, // #4476
  {22,  2,   0}, // #4477
  {23,  2,   0}, // #4478
  { 7,  1,   0}, // #4479
  {12,  1,   0}, // #4480
  {17,  1,   0}, // #4481
  {21,  2,   0}, // #4482
  {23,  3,   0}, // #4483
  { 3,  1,   0}, // #4484
  { 8,  1,   0}, // #4485
  {11,  1,   0}, // #4486
  {12,  1,   0}, // #4487
  {13,  2,   0}, // #4488
  {14,  1,   0}, // #4489
  {15,  1,   0}, // #4490
  {17,  1,   0}, // #4491
  {18,  1,   0}, // #4492
  {19,  2,   0}, // #4493
  {20,  2,   0}, // #4494
  {21,  1,   0}, // #4495
  {22,  2,   0}, // #4496
  {23,  3,   0}, // #4497
  {14,  2,   0}, // #4498
  {17,  1,   0}, // #4499
  {20,  2,   0}, // #4500
  {21,  1,   0}, // #4501
  {22,  2,   0}, // #4502
  {23,  3,   0}, // #4503
  { 7,  1,   0}, // #4504
  {12,  1,   0}, // #4505
  {14,  3,   0}, // #4506
  {17,  1,   0}, // #4507
  {20,  3,   0}, // #4508
  {21,  2,   0}, // #4509
  {22,  3,   0}, // #4510
  {23,  6,   0}, // #4511
  {14,  6,   0}, // #4512
  {17,  1,   0}, // #4513
  {20,  6,   0}, // #4514
  {21,  1,   0}, // #4515
  {22,  6,   0}, // #4516
  {23,  7,   0}, // #4517
  {14,  3,   0}, // #4518
  {20,  3,   0}, // #4519
  {22,  3,   0}, // #4520
  {23,  3,   0}, // #4521
  { 4,  2,   0}, // #4522
  {11,  2,   0}, // #4523
  {15,  2,   0}, // #4524
  {16,  2,   0}, // #4525
  {17,  1,   0}, // #4526
  {19,  2,   0}, // #4527
  {21,  1,   0}, // #4528
  {22,  2,   0}, // #4529
  {23,  3,   0}, // #4530
  { 4,  2,   0}, // #4531
  {11,  2,   0}, // #4532
  {15,  2,   0}, // #4533
  {16,  2,   0}, // #4534
  {19,  2,   0}, // #4535
  {22,  2,   0}, // #4536
  {23,  2,   0}, // #4537
  { 7,  1,   0}, // #4538
  {12,  1,   0}, // #4539
  {14,  1,   0}, // #4540
  {20,  1,   0}, // #4541
  {21,  1,   0}, // #4542
  {22,  1,   0}, // #4543
  {23,  3,   0}, // #4544
  { 4,  1,   0}, // #4545
  {11,  1,   0}, // #4546
  {14,  1,   0}, // #4547
  {15,  1,   0}, // #4548
  {16,  1,   0}, // #4549
  {17,  1,   0}, // #4550
  {19,  1,   0}, // #4551
  {20,  1,   0}, // #4552
  {21,  2,   0}, // #4553
  {22,  4,   0}, // #4554
  {23,  6,   0}, // #4555
  { 4,  1,   0}, // #4556
  {11,  1,   0}, // #4557
  {15,  1,   0}, // #4558
  {16,  1,   0}, // #4559
  {17,  1,   0}, // #4560
  {19,  1,   0}, // #4561
  {21,  2,   0}, // #4562
  {22,  2,   0}, // #4563
  {23,  4,   0}, // #4564
  { 2, 14,   0}, // #4565
  { 3,  1,   0}, // #4566
  {11,  1,   0}, // #4567
  {12,  1,   0}, // #4568
  {13,  1,   0}, // #4569
  {14,  1,   0}, // #4570
  {17,  1,   0}, // #4571
  {19,  1,   0}, // #4572
  {20,  1,   0}, // #4573
  {21,  1,   0}, // #4574
  {22,  1,   0}, // #4575
  {23,  2,   0}, // #4576
  { 2, 14,   0}, // #4577
  { 3,  1,   0}, // #4578
  {11,  1,   0}, // #4579
  {12,  1,   0}, // #4580
  {13,  1,   0}, // #4581
  {14,  1,   0}, // #4582
  {19,  1,   0}, // #4583
  {20,  1,   0}, // #4584
  {22,  1,   0}, // #4585
  {23,  1,   0}, // #4586
  { 2,  7,   0}, // #4587
  { 3,  1,   0}, // #4588
  {11,  1,   0}, // #4589
  {12,  1,   0}, // #4590
  {13,  1,   0}, // #4591
  {14,  1,   0}, // #4592
  {17,  1,   0}, // #4593
  {19,  1,   0}, // #4594
  {20,  1,   0}, // #4595
  {21,  1,   0}, // #4596
  {22,  1,   0}, // #4597
  {23,  2,   0}, // #4598
  { 2,  7,   0}, // #4599
  { 3,  1,   0}, // #4600
  {11,  1,   0}, // #4601
  {12,  1,   0}, // #4602
  {13,  1,   0}, // #4603
  {14,  1,   0}, // #4604
  {19,  1,   0}, // #4605
  {20,  1,   0}, // #4606
  {22,  1,   0}, // #4607
  {23,  1,   0}, // #4608
  { 2,  9,   0}, // #4609
  { 3,  1,   0}, // #4610
  {11,  1,   0}, // #4611
  {12,  1,   0}, // #4612
  {13,  1,   0}, // #4613
  {14,  1,   0}, // #4614
  {19,  1,   0}, // #4615
  {20,  1,   0}, // #4616
  {22,  1,   0}, // #4617
  {23,  1,   0}, // #4618
  { 4,  1,   0}, // #4619
  { 7,  1,   0}, // #4620
  {11,  1,   0}, // #4621
  {12,  1,   0}, // #4622
  {15,  1,   0}, // #4623
  {16,  1,   0}, // #4624
  {19,  1,   0}, // #4625
  {21,  1,   0}, // #4626
  {22,  1,   0}, // #4627
  {23,  3,   0}, // #4628
  { 2, 10,   0}, // #4629
  { 3,  2,   0}, // #4630
  {11,  2,   0}, // #4631
  {12,  2,   0}, // #4632
  {13,  2,   0}, // #4633
  {14,  2,   0}, // #4634
  {17,  1,   0}, // #4635
  {19,  3,   0}, // #4636
  {20,  2,   0}, // #4637
  {21,  1,   0}, // #4638
  {22,  3,   0}, // #4639
  {23,  4,   0}, // #4640
  { 2, 10,   0}, // #4641
  { 3,  2,   0}, // #4642
  {11,  2,   0}, // #4643
  {12,  2,   0}, // #4644
  {13,  2,   0}, // #4645
  {14,  2,   0}, // #4646
  {19,  3,   0}, // #4647
  {20,  2,   0}, // #4648
  {22,  3,   0}, // #4649
  {23,  3,   0}, // #4650
  { 2, 16,   0}, // #4651
  { 3,  2,   0}, // #4652
  {11,  2,   0}, // #4653
  {12,  2,   0}, // #4654
  {13,  2,   0}, // #4655
  {14,  2,   0}, // #4656
  {17,  1,   0}, // #4657
  {19,  3,   0}, // #4658
  {20,  2,   0}, // #4659
  {21,  1,   0}, // #4660
  {22,  3,   0}, // #4661
  {23,  4,   0}, // #4662
  { 2, 16,   0}, // #4663
  { 3,  2,   0}, // #4664
  {11,  2,   0}, // #4665
  {12,  2,   0}, // #4666
  {13,  2,   0}, // #4667
  {14,  2,   0}, // #4668
  {19,  3,   0}, // #4669
  {20,  2,   0}, // #4670
  {22,  3,   0}, // #4671
  {23,  3,   0}, // #4672
  { 3,  1,   0}, // #4673
  { 4,  1,   0}, // #4674
  { 7,  1,   0}, // #4675
  {11,  2,   0}, // #4676
  {12,  2,   0}, // #4677
  {13,  1,   0}, // #4678
  {14,  1,   0}, // #4679
  {15,  1,   0}, // #4680
  {16,  1,   0}, // #4681
  {17,  1,   0}, // #4682
  {19,  2,   0}, // #4683
  {20,  1,   0}, // #4684
  {21,  1,   0}, // #4685
  {22,  2,   0}, // #4686
  {23,  4,   0}, // #4687
  { 3,  2,   0}, // #4688
  { 8,  1,   0}, // #4689
  {11,  2,   0}, // #4690
  {12,  2,   0}, // #4691
  {13,  3,   0}, // #4692
  {14,  2,   0}, // #4693
  {15,  1,   0}, // #4694
  {17,  1,   0}, // #4695
  {18,  1,   0}, // #4696
  {19,  3,   0}, // #4697
  {20,  3,   0}, // #4698
  {21,  1,   0}, // #4699
  {22,  3,   0}, // #4700
  {23,  4,   0}, // #4701
  { 3,  2,   0}, // #4702
  { 8,  1,   0}, // #4703
  {11,  2,   0}, // #4704
  {12,  2,   0}, // #4705
  {13,  3,   0}, // #4706
  {14,  2,   0}, // #4707
  {15,  1,   0}, // #4708
  {18,  1,   0}, // #4709
  {19,  3,   0}, // #4710
  {20,  3,   0}, // #4711
  {22,  3,   0}, // #4712
  {23,  3,   0}, // #4713
  { 2, 14,   0}, // #4714
  { 3,  2,   0}, // #4715
  {11,  2,   0}, // #4716
  {12,  2,   0}, // #4717
  {13,  2,   0}, // #4718
  {14,  2,   0}, // #4719
  {17,  1,   0}, // #4720
  {19,  3,   0}, // #4721
  {20,  2,   0}, // #4722
  {21,  1,   0}, // #4723
  {22,  3,   0}, // #4724
  {23,  4,   0}, // #4725
  { 2, 14,   0}, // #4726
  { 3,  2,   0}, // #4727
  {11,  2,   0}, // #4728
  {12,  2,   0}, // #4729
  {13,  2,   0}, // #4730
  {14,  2,   0}, // #4731
  {19,  3,   0}, // #4732
  {20,  2,   0}, // #4733
  {22,  3,   0}, // #4734
  {23,  3,   0}, // #4735
  { 2, 28,   0}, // #4736
  { 3,  2,   0}, // #4737
  {11,  2,   0}, // #4738
  {12,  2,   0}, // #4739
  {13,  2,   0}, // #4740
  {14,  2,   0}, // #4741
  {17,  1,   0}, // #4742
  {19,  3,   0}, // #4743
  {20,  2,   0}, // #4744
  {21,  1,   0}, // #4745
  {22,  3,   0}, // #4746
  {23,  4,   0}, // #4747
  { 2, 28,   0}, // #4748
  { 3,  2,   0}, // #4749
  {11,  2,   0}, // #4750
  {12,  2,   0}, // #4751
  {13,  2,   0}, // #4752
  {14,  2,   0}, // #4753
  {19,  3,   0}, // #4754
  {20,  2,   0}, // #4755
  {22,  3,   0}, // #4756
  {23,  3,   0}, // #4757
  {14,  1,   0}, // #4758
  {17,  1,   0}, // #4759
  {20,  1,   0}, // #4760
  {21,  2,   0}, // #4761
  {22,  3,   0}, // #4762
  {23,  5,   0}, // #4763
  { 4,  2,   0}, // #4764
  {11,  2,   0}, // #4765
  {14,  3,   0}, // #4766
  {15,  3,   0}, // #4767
  {16,  2,   0}, // #4768
  {17,  1,   0}, // #4769
  {19,  3,   0}, // #4770
  {20,  3,   0}, // #4771
  {21,  2,   0}, // #4772
  {22,  9,   0}, // #4773
  {23, 11,   0}, // #4774
  { 3,  2,   0}, // #4775
  { 4,  1,   0}, // #4776
  { 9,  4,   0}, // #4777
  {11,  3,   0}, // #4778
  {12,  2,   0}, // #4779
  {13,  2,   0}, // #4780
  {14,  6,   0}, // #4781
  {15,  1,   0}, // #4782
  {16,  5,   0}, // #4783
  {18,  4,   0}, // #4784
  {19,  3,   0}, // #4785
  {20,  6,   0}, // #4786
  {22, 12,   0}, // #4787
  {23, 12,   0}, // #4788
  {17,  1,   0}, // #4789
  {21,  1,   0}, // #4790
  {22,  2,   0}, // #4791
  {23,  3,   0}, // #4792
  { 9,  1,   0}, // #4793
  {14,  1,   0}, // #4794
  {16,  1,   0}, // #4795
  {18,  1,   0}, // #4796
  {20,  1,   0}, // #4797
  {22,  3,   0}, // #4798
  {23,  3,   0}, // #4799
  { 7,  1,   0}, // #4800
  {12,  1,   0}, // #4801
  {17,  1,   0}, // #4802
  {21,  2,   0}, // #4803
  {22,  3,   0}, // #4804
  {23,  6,   0}, // #4805
  {14,  1,   0}, // #4806
  {20,  1,   0}, // #4807
  {22,  2,   0}, // #4808
  {23,  2,   0}, // #4809
  { 3,  1,   0}, // #4810
  {11,  2,   0}, // #4811
  {12,  1,   0}, // #4812
  {13,  1,   0}, // #4813
  {14,  1,   0}, // #4814
  {17,  1,   0}, // #4815
  {19,  2,   0}, // #4816
  {20,  1,   0}, // #4817
  {21,  1,   0}, // #4818
  {22,  2,   0}, // #4819
  {23,  3,   0}, // #4820
  {14,  2,   0}, // #4821
  {20,  2,   0}, // #4822
  {22, 11,   0}, // #4823
  {23, 11,   0}, // #4824
  { 7,  1,   0}, // #4825
  { 9,  1,   0}, // #4826
  {12,  1,   0}, // #4827
  {14,  1,   0}, // #4828
  {16,  1,   0}, // #4829
  {18,  1,   0}, // #4830
  {20,  1,   0}, // #4831
  {21,  1,   0}, // #4832
  {22,  1,   0}, // #4833
  {23,  3,   0}, // #4834
  { 9,  1,   0}, // #4835
  {14,  1,   0}, // #4836
  {16,  1,   0}, // #4837
  {18,  1,   0}, // #4838
  {20,  1,   0}, // #4839
  {22,  5,   0}, // #4840
  {23,  5,   0}, // #4841
  { 7,  1,   0}, // #4842
  {12,  1,   0}, // #4843
  {14,  4,   0}, // #4844
  {15,  2,   0}, // #4845
  {17,  1,   0}, // #4846
  {19,  2,   0}, // #4847
  {20,  4,   0}, // #4848
  {21,  2,   0}, // #4849
  {22, 11,   0}, // #4850
  {23, 14,   0}, // #4851
  { 9,  2,   0}, // #4852
  {14,  4,   0}, // #4853
  {15,  1,   0}, // #4854
  {16,  2,   0}, // #4855
  {18,  2,   0}, // #4856
  {19,  1,   0}, // #4857
  {20,  4,   0}, // #4858
  {22,  7,   0}, // #4859
  {23,  7,   0}, // #4860
  { 9,  1,   0}, // #4861
  {14,  1,   0}, // #4862
  {16,  1,   0}, // #4863
  {18,  1,   0}, // #4864
  {20,  1,   0}, // #4865
  {22,  6,   0}, // #4866
  {23,  6,   0}, // #4867
  { 3,  2,   0}, // #4868
  { 7,  1,   0}, // #4869
  { 8,  4,   0}, // #4870
  {11,  2,   0}, // #4871
  {12,  3,   0}, // #4872
  {13,  6,   0}, // #4873
  {14,  6,   0}, // #4874
  {15,  4,   0}, // #4875
  {17,  1,   0}, // #4876
  {18,  4,   0}, // #4877
  {19,  6,   0}, // #4878
  {20, 10,   0}, // #4879
  {21,  2,   0}, // #4880
  {22, 16,   0}, // #4881
  {23, 19,   0}, // #4882
  { 8,  2,   0}, // #4883
  {13,  2,   0}, // #4884
  {15,  2,   0}, // #4885
  {18,  2,   0}, // #4886
  {19,  2,   0}, // #4887
  {20,  2,   0}, // #4888
  {22, 22,   0}, // #4889
  {23, 22,   0}, // #4890
  { 7,  1,   0}, // #4891
  { 8,  1,   0}, // #4892
  { 9,  1,   0}, // #4893
  {12,  1,   0}, // #4894
  {13,  1,   0}, // #4895
  {14,  2,   0}, // #4896
  {15,  1,   0}, // #4897
  {16,  1,   0}, // #4898
  {17,  1,   0}, // #4899
  {18,  2,   0}, // #4900
  {19,  1,   0}, // #4901
  {20,  3,   0}, // #4902
  {21,  2,   0}, // #4903
  {22,  5,   0}, // #4904
  {23,  8,   0}, // #4905
  { 8,  6,   0}, // #4906
  {11,  3,   0}, // #4907
  {13,  6,   0}, // #4908
  {15,  6,   0}, // #4909
  {18,  6,   0}, // #4910
  {19,  9,   0}, // #4911
  {20,  6,   0}, // #4912
  {22, 15,   0}, // #4913
  {23, 15,   0}, // #4914
  { 8,  1,   0}, // #4915
  { 9,  5,   0}, // #4916
  {13,  1,   0}, // #4917
  {14,  9,   0}, // #4918
  {15,  1,   0}, // #4919
  {16,  5,   0}, // #4920
  {17,  2,   0}, // #4921
  {18,  6,   0}, // #4922
  {19,  1,   0}, // #4923
  {20, 10,   0}, // #4924
  {21,  3,   0}, // #4925
  {22, 20,   0}, // #4926
  {23, 23,   0}, // #4927
  { 8,  1,   0}, // #4928
  { 9,  5,   0}, // #4929
  {13,  1,   0}, // #4930
  {14,  9,   0}, // #4931
  {15,  1,   0}, // #4932
  {16,  5,   0}, // #4933
  {17,  3,   0}, // #4934
  {18,  6,   0}, // #4935
  {19,  1,   0}, // #4936
  {20, 10,   0}, // #4937
  {21,  3,   0}, // #4938
  {22, 20,   0}, // #4939
  {23, 23,   0}, // #4940
  { 8,  1,   0}, // #4941
  { 9,  1,   0}, // #4942
  {13,  1,   0}, // #4943
  {14,  2,   0}, // #4944
  {15,  1,   0}, // #4945
  {16,  1,   0}, // #4946
  {18,  2,   0}, // #4947
  {19,  1,   0}, // #4948
  {20,  3,   0}, // #4949
  {22,  8,   0}, // #4950
  {23,  8,   0}, // #4951
  { 3,  4,   0}, // #4952
  { 9,  2,   0}, // #4953
  {11,  4,   0}, // #4954
  {12,  4,   0}, // #4955
  {13,  5,   0}, // #4956
  {14,  8,   0}, // #4957
  {15,  1,   0}, // #4958
  {16,  2,   0}, // #4959
  {17, 33,   0}, // #4960
  {18,  2,   0}, // #4961
  {19,  6,   0}, // #4962
  {20,  9,   0}, // #4963
  {21, 33,   0}, // #4964
  {22, 57,   0}, // #4965
  {23, 90,   0}, // #4966
  { 9,  1,   0}, // #4967
  {14,  1,   0}, // #4968
  {16,  1,   0}, // #4969
  {17,  1,   0}, // #4970
  {18,  1,   0}, // #4971
  {20,  1,   0}, // #4972
  {21,  1,   0}, // #4973
  {22,  2,   0}, // #4974
  {23,  3,   0}, // #4975
  { 3,  1,   0}, // #4976
  {11,  1,   0}, // #4977
  {12,  1,   0}, // #4978
  {13,  1,   0}, // #4979
  {14,  1,   0}, // #4980
  {19,  1,   0}, // #4981
  {20,  1,   0}, // #4982
  {22,  2,   0}, // #4983
  {23,  2,   0}, // #4984
  {11,  1,   0}, // #4985
  {19,  2,   0}, // #4986
  {22,  2,   0}, // #4987
  {23,  2,   0}, // #4988
  {14,  1,   0}, // #4989
  {20,  1,   0}, // #4990
  {22,  3,   0}, // #4991
  {23,  3,   0}, // #4992
  { 4,  2,   0}, // #4993
  {11,  2,   0}, // #4994
  {14,  4,   0}, // #4995
  {15,  2,   0}, // #4996
  {16,  2,   0}, // #4997
  {19,  2,   0}, // #4998
  {20,  4,   0}, // #4999
  {22,  8,   0}, // #5000
  {23,  8,   0}, // #5001
  { 7,  1,   0}, // #5002
  {12,  1,   0}, // #5003
  {21,  1,   0}, // #5004
  {22,  1,   0}, // #5005
  {23,  3,   0}, // #5006
  { 7,  1,   0}, // #5007
  {12,  1,   0}, // #5008
  {14,  1,   0}, // #5009
  {20,  1,   0}, // #5010
  {21,  1,   0}, // #5011
  {22,  2,   0}, // #5012
  {23,  4,   0}, // #5013
  { 7,  1,   0}, // #5014
  { 9,  1,   0}, // #5015
  {12,  1,   0}, // #5016
  {14,  1,   0}, // #5017
  {16,  1,   0}, // #5018
  {18,  1,   0}, // #5019
  {20,  1,   0}, // #5020
  {21,  1,   0}, // #5021
  {22,  2,   0}, // #5022
  {23,  4,   0}, // #5023
  { 7,  1,   0}, // #5024
  {12,  1,   0}, // #5025
  {21,  1,   0}, // #5026
  {22,  4,   0}, // #5027
  {23,  6,   0}, // #5028
  { 9,  1,   0}, // #5029
  {14,  1,   0}, // #5030
  {16,  1,   0}, // #5031
  {18,  1,   0}, // #5032
  {20,  1,   0}, // #5033
  {22,  2,   0}, // #5034
  {23,  2,   0}, // #5035
  { 9,  1,   0}, // #5036
  {14,  1,   0}, // #5037
  {16,  1,   0}, // #5038
  {17,  1,   0}, // #5039
  {18,  1,   0}, // #5040
  {20,  1,   0}, // #5041
  {21,  1,   0}, // #5042
  {22,  1,   0}, // #5043
  {23,  2,   0}, // #5044
  { 3,  1,   0}, // #5045
  { 7,  1,   0}, // #5046
  {11,  1,   0}, // #5047
  {12,  2,   0}, // #5048
  {13,  1,   0}, // #5049
  {14,  1,   0}, // #5050
  {19,  1,   0}, // #5051
  {20,  1,   0}, // #5052
  {21,  1,   0}, // #5053
  {22,  1,   0}, // #5054
  {23,  3,   0}, // #5055
  { 4,  1,   0}, // #5056
  { 9,  1,   0}, // #5057
  {11,  1,   0}, // #5058
  {14,  2,   0}, // #5059
  {15,  1,   0}, // #5060
  {16,  2,   0}, // #5061
  {18,  1,   0}, // #5062
  {19,  1,   0}, // #5063
  {20,  2,   0}, // #5064
  {22,  4,   0}, // #5065
  {23,  4,   0}, // #5066
  { 7,  1,   0}, // #5067
  { 9,  1,   0}, // #5068
  {12,  1,   0}, // #5069
  {14,  1,   0}, // #5070
  {16,  1,   0}, // #5071
  {17,  1,   0}, // #5072
  {18,  1,   0}, // #5073
  {20,  1,   0}, // #5074
  {21,  2,   0}, // #5075
  {22,  2,   0}, // #5076
  {23,  5,   0}, // #5077
  { 7,  1,   0}, // #5078
  {12,  1,   0}, // #5079
  {14,  2,   0}, // #5080
  {17,  1,   0}, // #5081
  {20,  2,   0}, // #5082
  {21,  2,   0}, // #5083
  {22,  2,   0}, // #5084
  {23,  5,   0}, // #5085
  { 7,  1,   0}, // #5086
  {12,  1,   0}, // #5087
  {17,  1,   0}, // #5088
  {21,  2,   0}, // #5089
  {22,  2,   0}, // #5090
  {23,  5,   0}, // #5091
  { 8,  1,   0}, // #5092
  { 9,  1,   0}, // #5093
  {13,  1,   0}, // #5094
  {14,  1,   0}, // #5095
  {15,  1,   0}, // #5096
  {16,  1,   0}, // #5097
  {18,  2,   0}, // #5098
  {19,  1,   0}, // #5099
  {20,  2,   0}, // #5100
  {22,  2,   0}, // #5101
  {23,  2,   0}, // #5102
  {14,  1,   0}, // #5103
  {17,  1,   0}, // #5104
  {20,  1,   0}, // #5105
  {21,  1,   0}, // #5106
  {22,  4,   0}, // #5107
  {23,  5,   0}, // #5108
  { 9,  1,   0}, // #5109
  {14,  1,   0}, // #5110
  {16,  1,   0}, // #5111
  {18,  1,   0}, // #5112
  {20,  1,   0}, // #5113
  {22,  1,   0}, // #5114
  {23,  1,   0}, // #5115
  { 7,  1,   0}, // #5116
  {12,  1,   0}, // #5117
  {15,  1,   0}, // #5118
  {19,  1,   0}, // #5119
  {21,  1,   0}, // #5120
  {22,  1,   0}, // #5121
  {23,  3,   0}, // #5122
  {14,  2,   0}, // #5123
  {20,  2,   0}, // #5124
  {22,  2,   0}, // #5125
  {23,  2,   0}, // #5126
  { 8,  1,   0}, // #5127
  {13,  1,   0}, // #5128
  {15,  1,   0}, // #5129
  {17,  1,   0}, // #5130
  {18,  1,   0}, // #5131
  {19,  2,   0}, // #5132
  {20,  1,   0}, // #5133
  {21,  1,   0}, // #5134
  {22,  2,   0}, // #5135
  {23,  3,   0}, // #5136
  { 4,  2,   0}, // #5137
  { 9,  2,   0}, // #5138
  {11,  2,   0}, // #5139
  {14,  2,   0}, // #5140
  {15,  2,   0}, // #5141
  {16,  4,   0}, // #5142
  {17,  1,   0}, // #5143
  {18,  2,   0}, // #5144
  {19,  2,   0}, // #5145
  {20,  2,   0}, // #5146
  {21,  1,   0}, // #5147
  {22,  7,   0}, // #5148
  {23,  8,   0}, // #5149
  { 4,  1,   0}, // #5150
  { 9,  2,   0}, // #5151
  {11,  1,   0}, // #5152
  {14,  2,   0}, // #5153
  {15,  1,   0}, // #5154
  {16,  3,   0}, // #5155
  {17,  1,   0}, // #5156
  {18,  2,   0}, // #5157
  {19,  1,   0}, // #5158
  {20,  2,   0}, // #5159
  {21,  1,   0}, // #5160
  {22,  4,   0}, // #5161
  {23,  5,   0}, // #5162
  { 4,  1,   0}, // #5163
  { 9,  1,   0}, // #5164
  {11,  1,   0}, // #5165
  {14,  2,   0}, // #5166
  {15,  1,   0}, // #5167
  {16,  2,   0}, // #5168
  {18,  1,   0}, // #5169
  {19,  1,   0}, // #5170
  {20,  2,   0}, // #5171
  {22,  3,   0}, // #5172
  {23,  3,   0}, // #5173
  {14,  1,   0}, // #5174
  {20,  1,   0}, // #5175
  {22,  5,   0}, // #5176
  {23,  5,   0}, // #5177
  { 4,  1,   0}, // #5178
  {11,  1,   0}, // #5179
  {14,  4,   0}, // #5180
  {15,  2,   0}, // #5181
  {16,  1,   0}, // #5182
  {17,  1,   0}, // #5183
  {19,  2,   0}, // #5184
  {20,  4,   0}, // #5185
  {21,  2,   0}, // #5186
  {22,  8,   0}, // #5187
  {23, 10,   0}, // #5188
  { 4,  2,   0}, // #5189
  {11,  2,   0}, // #5190
  {14,  2,   0}, // #5191
  {15,  2,   0}, // #5192
  {16,  2,   0}, // #5193
  {19,  2,   0}, // #5194
  {20,  2,   0}, // #5195
  {22,  7,   0}, // #5196
  {23,  7,   0}, // #5197
  { 4,  1,   0}, // #5198
  {11,  1,   0}, // #5199
  {14,  4,   0}, // #5200
  {15,  2,   0}, // #5201
  {16,  1,   0}, // #5202
  {19,  2,   0}, // #5203
  {20,  4,   0}, // #5204
  {22,  9,   0}, // #5205
  {23,  9,   0}, // #5206
  { 4,  2,   0}, // #5207
  {11,  2,   0}, // #5208
  {14,  3,   0}, // #5209
  {15,  3,   0}, // #5210
  {16,  2,   0}, // #5211
  {19,  3,   0}, // #5212
  {20,  3,   0}, // #5213
  {22, 10,   0}, // #5214
  {23, 10,   0}, // #5215
  { 9,  3,   0}, // #5216
  {14,  3,   0}, // #5217
  {16,  3,   0}, // #5218
  {17,  1,   0}, // #5219
  {18,  3,   0}, // #5220
  {20,  3,   0}, // #5221
  {21,  1,   0}, // #5222
  {22, 18,   0}, // #5223
  {23, 19,   0}, // #5224
  { 7,  1,   0}, // #5225
  { 9,  5,   0}, // #5226
  {12,  1,   0}, // #5227
  {14,  5,   0}, // #5228
  {16,  5,   0}, // #5229
  {17,  1,   0}, // #5230
  {18,  5,   0}, // #5231
  {20,  5,   0}, // #5232
  {21,  2,   0}, // #5233
  {22, 24,   0}, // #5234
  {23, 27,   0}, // #5235
  { 7,  1,   0}, // #5236
  { 9,  6,   0}, // #5237
  {12,  1,   0}, // #5238
  {14,  6,   0}, // #5239
  {16,  6,   0}, // #5240
  {17,  1,   0}, // #5241
  {18,  6,   0}, // #5242
  {20,  6,   0}, // #5243
  {21,  2,   0}, // #5244
  {22, 25,   0}, // #5245
  {23, 28,   0}, // #5246
  { 3,  2,   0}, // #5247
  {11,  4,   0}, // #5248
  {12,  2,   0}, // #5249
  {13,  3,   0}, // #5250
  {14, 12,   0}, // #5251
  {17,  8,   0}, // #5252
  {19,  7,   0}, // #5253
  {20, 13,   0}, // #5254
  {21,  8,   0}, // #5255
  {22, 56,   0}, // #5256
  {23, 64,   0}, // #5257
  { 3,  4,   0}, // #5258
  { 9,  4,   0}, // #5259
  {11,  4,   0}, // #5260
  {12,  4,   0}, // #5261
  {13,  5,   0}, // #5262
  {14, 10,   0}, // #5263
  {15,  1,   0}, // #5264
  {16,  4,   0}, // #5265
  {17, 31,   0}, // #5266
  {18,  4,   0}, // #5267
  {19,  6,   0}, // #5268
  {20, 11,   0}, // #5269
  {21, 31,   0}, // #5270
  {22, 57,   0}, // #5271
  {23, 88,   0}, // #5272
  { 3,  9,   0}, // #5273
  { 4,  9,   0}, // #5274
  { 7, 11,   0}, // #5275
  { 8,  8,   0}, // #5276
  { 9,  1,   0}, // #5277
  {11, 18,   0}, // #5278
  {12, 20,   0}, // #5279
  {13, 17,   0}, // #5280
  {14, 31,   0}, // #5281
  {15, 17,   0}, // #5282
  {16, 10,   0}, // #5283
  {18,  9,   0}, // #5284
  {19, 26,   0}, // #5285
  {20, 39,   0}, // #5286
  {21, 11,   0}, // #5287
  {22, 78,   0}, // #5288
  {23, 100,   0}, // #5289
  { 7,  1,   0}, // #5290
  { 8,  3,   0}, // #5291
  {12,  1,   0}, // #5292
  {13,  3,   0}, // #5293
  {15,  3,   0}, // #5294
  {17,  2,   0}, // #5295
  {18,  3,   0}, // #5296
  {19,  3,   0}, // #5297
  {20,  3,   0}, // #5298
  {21,  2,   0}, // #5299
  {22,  4,   0}, // #5300
  {23,  7,   0}, // #5301
  { 7,  1,   0}, // #5302
  { 8,  3,   0}, // #5303
  {12,  1,   0}, // #5304
  {13,  3,   0}, // #5305
  {15,  3,   0}, // #5306
  {17,  4,   0}, // #5307
  {18,  3,   0}, // #5308
  {19,  3,   0}, // #5309
  {20,  3,   0}, // #5310
  {21,  4,   0}, // #5311
  {22,  4,   0}, // #5312
  {23,  9,   0}, // #5313
  { 7,  1,   0}, // #5314
  { 8,  4,   0}, // #5315
  {12,  1,   0}, // #5316
  {13,  4,   0}, // #5317
  {15,  4,   0}, // #5318
  {17,  4,   0}, // #5319
  {18,  4,   0}, // #5320
  {19,  4,   0}, // #5321
  {20,  4,   0}, // #5322
  {21,  4,   0}, // #5323
  {22,  5,   0}, // #5324
  {23, 10,   0}, // #5325
  { 7,  1,   0}, // #5326
  { 8,  4,   0}, // #5327
  {12,  1,   0}, // #5328
  {13,  4,   0}, // #5329
  {15,  4,   0}, // #5330
  {17,  8,   0}, // #5331
  {18,  4,   0}, // #5332
  {19,  4,   0}, // #5333
  {20,  4,   0}, // #5334
  {21,  8,   0}, // #5335
  {22,  5,   0}, // #5336
  {23, 14,   0}, // #5337
  { 7,  1,   0}, // #5338
  { 8,  5,   0}, // #5339
  {12,  1,   0}, // #5340
  {13,  5,   0}, // #5341
  {15,  5,   0}, // #5342
  {17,  2,   0}, // #5343
  {18,  5,   0}, // #5344
  {19,  5,   0}, // #5345
  {20,  5,   0}, // #5346
  {21,  2,   0}, // #5347
  {22,  6,   0}, // #5348
  {23,  9,   0}, // #5349
  { 9,  1,   0}, // #5350
  {14,  1,   0}, // #5351
  {16,  1,   0}, // #5352
  {17,  1,   0}, // #5353
  {18,  1,   0}, // #5354
  {20,  1,   0}, // #5355
  {21,  1,   0}, // #5356
  {22, 17,   0}, // #5357
  {23, 18,   0}, // #5358
  {14,  1,   0}, // #5359
  {17,  1,   0}, // #5360
  {20,  1,   0}, // #5361
  {21,  1,   0}, // #5362
  {22,  2,   0}, // #5363
  {23,  3,   0}, // #5364
  { 9,  1,   0}, // #5365
  {16,  1,   0}, // #5366
  { 3,  3,   0}, // #5367
  {11,  1,   0}, // #5368
  {12,  2,   0}, // #5369
  {14,  1,   0}, // #5370
  { 8,  1,   0}, // #5371
  { 9,  1,   0}, // #5372
  {12,  1,   0}, // #5373
  {14,  1,   0}, // #5374
  {15,  1,   0}, // #5375
  { 9,  1,   0}, // #5376
  {10,  1,   0}, // #5377
  {11,  1,   0}, // #5378
  {12,  1,   0}, // #5379
  { 8,  2,   0}, // #5380
  { 9,  2,   0}, // #5381
  {12,  2,   0}, // #5382
  {14,  2,   0}, // #5383
  {15,  2,   0}, // #5384
  { 3,  1,   0}, // #5385
  {11,  1,   0}, // #5386
  {12,  2,   0}, // #5387
  {14,  1,   0}, // #5388
  { 3,  2,   0}, // #5389
  {11,  1,   0}, // #5390
  {12,  2,   0}, // #5391
  {14,  1,   0}, // #5392
  { 3,  2,   0}, // #5393
  {11,  1,   0}, // #5394
  {12,  1,   0}, // #5395
  { 5,  1,   0}, // #5396
  { 7,  1,   0}, // #5397
  { 9,  1,   0}, // #5398
  {10,  1,   0}, // #5399
  {11,  1,   0}, // #5400
  {12,  1,   0}, // #5401
  { 7,  1,   0}, // #5402
  { 9,  2,   0}, // #5403
  {11,  1,   0}, // #5404
  {12,  1,   0}, // #5405
  {16,  1,   0}, // #5406
  {19,  1,   0}, // #5407
  { 7,  1,   0}, // #5408
  { 9,  2,   0}, // #5409
  {16,  1,   0}, // #5410
  {19,  1,   0}, // #5411
  { 7,  1,   0}, // #5412
  { 9,  1,   0}, // #5413
  {11,  1,   0}, // #5414
  {12,  1,   0}, // #5415
  {19,  1,   0}, // #5416
  { 7,  1,   0}, // #5417
  { 9,  1,   0}, // #5418
  {19,  1,   0}, // #5419
  { 9,  4,   0}, // #5420
  {10,  4,   0}, // #5421
  {11,  1,   0}, // #5422
  {12,  1,   0}, // #5423
  { 3,  8,   0}, // #5424
  {11,  1,   0}, // #5425
  {12,  1,   0}, // #5426
  { 1,  1,   0}, // #5427
  { 3,  1,   0}, // #5428
  { 5,  1,   0}, // #5429
  { 7,  1,   0}, // #5430
  { 9,  1,   0}, // #5431
  {10,  1,   0}, // #5432
  {11,  1,   0}, // #5433
  {12,  1,   0}, // #5434
  { 3,  4,   0}, // #5435
  {11,  1,   0}, // #5436
  {12,  1,   0}, // #5437
  { 8,  1,   0}, // #5438
  { 9,  1,   0}, // #5439
  {11,  1,   0}, // #5440
  {12,  1,   0}, // #5441
  {15,  1,   0}, // #5442
  { 8,  1,   0}, // #5443
  { 9,  1,   0}, // #5444
  {15,  1,   0}, // #5445
  { 1,  1,   0}, // #5446
  { 3,  1,   0}, // #5447
  { 5,  1,   0}, // #5448
  { 7,  1,   0}, // #5449
  { 8,  1,   0}, // #5450
  { 9,  2,   0}, // #5451
  {10,  1,   0}, // #5452
  {11,  1,   0}, // #5453
  {12,  1,   0}, // #5454
  {15,  1,   0}, // #5455
  { 1,  1,   0}, // #5456
  { 3,  1,   0}, // #5457
  { 5,  1,   0}, // #5458
  { 7,  1,   0}, // #5459
  { 8,  1,   0}, // #5460
  { 9,  2,   0}, // #5461
  {10,  1,   0}, // #5462
  {15,  1,   0}, // #5463
  { 8,  1,   0}, // #5464
  { 9,  1,   0}, // #5465
  {11,  1,   0}, // #5466
  {12,  1,   0}, // #5467
  {15,  2,   0}, // #5468
  { 8,  1,   0}, // #5469
  { 9,  1,   0}, // #5470
  {15,  2,   0}, // #5471
  { 2,  1,   0}, // #5472
  { 3,  1,   0}, // #5473
  { 4, 17,   0}, // #5474
  {11,  1,   0}, // #5475
  {12,  1,   0}, // #5476
  { 2,  1,   0}, // #5477
  { 3,  1,   0}, // #5478
  { 4, 25,   0}, // #5479
  {11,  1,   0}, // #5480
  {12,  1,   0}, // #5481
  { 2,  1,   0}, // #5482
  { 3,  1,   0}, // #5483
  { 4, 41,   0}, // #5484
  {11,  1,   0}, // #5485
  {12,  1,   0}, // #5486
  { 2,  1,   0}, // #5487
  { 3,  1,   0}, // #5488
  { 4, 12,   0}, // #5489
  {11,  1,   0}, // #5490
  {12,  1,   0}, // #5491
  { 6, 19,   0}, // #5492
  { 8,  1,   0}, // #5493
  { 9,  1,   0}, // #5494
  {10, 19,   0}, // #5495
  {11,  1,   0}, // #5496
  {12,  1,   0}, // #5497
  { 5,  3,   0}, // #5498
  { 6,  3,   0}, // #5499
  { 8,  1,   0}, // #5500
  { 9,  1,   0}, // #5501
  {10,  6,   0}, // #5502
  {11,  1,   0}, // #5503
  {12,  1,   0}, // #5504
  { 9,  1,   0}, // #5505
  {11,  1,   0}, // #5506
  {12,  1,   0}, // #5507
  {16,  1,   0}, // #5508
  { 2,  1,   0}, // #5509
  { 3,  1,   0}, // #5510
  {11,  1,   0}, // #5511
  {12,  1,   0}, // #5512
  {13,  3,   0}, // #5513
  { 2,  1,   0}, // #5514
  { 3,  1,   0}, // #5515
  {13,  3,   0}, // #5516
  { 2,  1,   0}, // #5517
  { 3,  1,   0}, // #5518
  {11,  1,   0}, // #5519
  {12,  1,   0}, // #5520
  {13,  1,   0}, // #5521
  { 2,  1,   0}, // #5522
  { 3,  1,   0}, // #5523
  {11,  1,   0}, // #5524
  {12,  1,   0}, // #5525
  {13,  2,   0}, // #5526
  { 2,  1,   0}, // #5527
  { 3,  1,   0}, // #5528
  {13,  1,   0}, // #5529
  { 2,  1,   0}, // #5530
  { 3,  1,   0}, // #5531
  {13,  2,   0}, // #5532
  { 2,  1,   0}, // #5533
  { 3,  1,   0}, // #5534
  {11,  1,   0}, // #5535
  {12,  1,   0}, // #5536
  {13,  4,   0}, // #5537
  { 2,  1,   0}, // #5538
  { 3,  1,   0}, // #5539
  {13,  4,   0}, // #5540
  { 7,  1,   0}, // #5541
  { 9,  1,   0}, // #5542
  {11,  1,   0}, // #5543
  {12,  1,   0}, // #5544
  {19,  2,   0}, // #5545
  { 7,  1,   0}, // #5546
  { 9,  1,   0}, // #5547
  {19,  2,   0}, // #5548
  { 6,  2,   0}, // #5549
  { 8,  1,   0}, // #5550
  { 9,  1,   0}, // #5551
  {10,  2,   0}, // #5552
  {11,  1,   0}, // #5553
  {12,  1,   0}, // #5554
  { 6,  1,   0}, // #5555
  { 8,  1,   0}, // #5556
  { 9,  1,   0}, // #5557
  {10,  1,   0}, // #5558
  {11,  1,   0}, // #5559
  {12,  1,   0}, // #5560
  { 9,  4,   0}, // #5561
  {11,  1,   0}, // #5562
  {12,  1,   0}, // #5563
  {16,  4,   0}, // #5564
  { 9,  4,   0}, // #5565
  {16,  4,   0}, // #5566
  { 1,  1,   0}, // #5567
  { 3,  1,   0}, // #5568
  { 5,  1,   0}, // #5569
  { 8,  1,   0}, // #5570
  { 9,  1,   0}, // #5571
  {10,  1,   0}, // #5572
  {11,  3,   0}, // #5573
  {12,  5,   0}, // #5574
  {14,  2,   0}, // #5575
  {16, 10,   0}, // #5576
  {18,  4,   0}, // #5577
  { 1,  1,   0}, // #5578
  { 3,  1,   0}, // #5579
  { 5,  1,   0}, // #5580
  { 8,  1,   0}, // #5581
  { 9,  1,   0}, // #5582
  {10,  1,   0}, // #5583
  {11,  2,   0}, // #5584
  {12,  4,   0}, // #5585
  {14,  2,   0}, // #5586
  {16, 10,   0}, // #5587
  {18,  4,   0}, // #5588
  { 1,  1,   0}, // #5589
  { 3,  1,   0}, // #5590
  { 5,  1,   0}, // #5591
  { 7,  1,   0}, // #5592
  { 8,  2,   0}, // #5593
  { 9,  3,   0}, // #5594
  {10,  1,   0}, // #5595
  {11,  1,   0}, // #5596
  {12,  1,   0}, // #5597
  {16,  2,   0}, // #5598
  {18,  2,   0}, // #5599
  { 1,  1,   0}, // #5600
  { 3,  1,   0}, // #5601
  { 5,  1,   0}, // #5602
  { 7,  1,   0}, // #5603
  { 8,  2,   0}, // #5604
  { 9,  3,   0}, // #5605
  {10,  1,   0}, // #5606
  {16,  2,   0}, // #5607
  {18,  2,   0}, // #5608
  { 7,  2,   0}, // #5609
  { 9,  3,   0}, // #5610
  {11,  1,   0}, // #5611
  {12,  1,   0}, // #5612
  {16,  1,   0}, // #5613
  {19,  2,   0}, // #5614
  { 7,  2,   0}, // #5615
  { 9,  3,   0}, // #5616
  {16,  1,   0}, // #5617
  {19,  2,   0}, // #5618
  { 9,  1,   0}, // #5619
  {11,  1,   0}, // #5620
  {12,  1,   0}, // #5621
  {16,  4,   0}, // #5622
  { 9,  1,   0}, // #5623
  {16,  4,   0}, // #5624
  { 3,  1,   0}, // #5625
  {12,  1,   0}, // #5626
  {14,  1,   0}, // #5627
  { 3, 22,   0}, // #5628
  {11,  1,   0}, // #5629
  {12,  1,   0}, // #5630
  { 6, 27,   0}, // #5631
  { 8,  1,   0}, // #5632
  { 9,  1,   0}, // #5633
  {10, 27,   0}, // #5634
  {11,  1,   0}, // #5635
  {12,  1,   0}, // #5636
  { 6, 21,   0}, // #5637
  { 8,  1,   0}, // #5638
  { 9,  1,   0}, // #5639
  {10, 21,   0}, // #5640
  {11,  1,   0}, // #5641
  {12,  1,   0}, // #5642
  { 6, 35,   0}, // #5643
  { 8,  1,   0}, // #5644
  { 9,  1,   0}, // #5645
  {10, 35,   0}, // #5646
  { 5,  2,   0}, // #5647
  { 7,  2,   0}, // #5648
  { 9,  2,   0}, // #5649
  {10,  2,   0}, // #5650
  {11,  2,   0}, // #5651
  {12,  2,   0}, // #5652
  { 8,  2,   0}, // #5653
  { 9,  2,   0}, // #5654
  {15,  2,   0}, // #5655
  { 9,  6,   0}, // #5656
  {10,  6,   0}, // #5657
  {11,  2,   0}, // #5658
  {12,  2,   0}, // #5659
  { 9,  2,   0}, // #5660
  {10,  2,   0}, // #5661
  {11,  1,   0}, // #5662
  {12,  1,   0}, // #5663
  { 8,  2,   0}, // #5664
  { 9,  2,   0}, // #5665
  {10,  4,   0}, // #5666
  {11,  2,   0}, // #5667
  {12,  2,   0}, // #5668
  {15,  2,   0}, // #5669
  { 8,  2,   0}, // #5670
  { 9,  2,   0}, // #5671
  {10,  4,   0}, // #5672
  {15,  2,   0}, // #5673
  { 8,  2,   0}, // #5674
  { 9,  2,   0}, // #5675
  {11,  2,   0}, // #5676
  {12,  2,   0}, // #5677
  {15,  2,   0}, // #5678
  { 8,  2,   0}, // #5679
  { 9,  2,   0}, // #5680
  {10,  2,   0}, // #5681
  {12,  1,   0}, // #5682
  {14,  1,   0}, // #5683
  {15,  2,   0}, // #5684
  { 8,  2,   0}, // #5685
  { 9,  2,   0}, // #5686
  {10,  2,   0}, // #5687
  {15,  2,   0}, // #5688
  { 6, 38,   0}, // #5689
  { 8,  2,   0}, // #5690
  { 9,  2,   0}, // #5691
  {10, 38,   0}, // #5692
  {11,  2,   0}, // #5693
  {12,  2,   0}, // #5694
  { 5,  6,   0}, // #5695
  { 6,  6,   0}, // #5696
  { 8,  2,   0}, // #5697
  { 9,  2,   0}, // #5698
  {10, 12,   0}, // #5699
  {11,  2,   0}, // #5700
  {12,  2,   0}, // #5701
  { 3,  4,   0}, // #5702
  { 5,  1,   0}, // #5703
  { 7,  1,   0}, // #5704
  { 8,  4,   0}, // #5705
  { 9,  5,   0}, // #5706
  {10,  1,   0}, // #5707
  {11,  4,   0}, // #5708
  {12,  8,   0}, // #5709
  {14,  4,   0}, // #5710
  {15,  4,   0}, // #5711
  { 9,  4,   0}, // #5712
  {10,  4,   0}, // #5713
  {11,  2,   0}, // #5714
  {12,  2,   0}, // #5715
  { 3,  2,   0}, // #5716
  { 5,  1,   0}, // #5717
  { 7,  1,   0}, // #5718
  { 8,  2,   0}, // #5719
  { 9,  3,   0}, // #5720
  {10,  1,   0}, // #5721
  {11,  2,   0}, // #5722
  {12,  4,   0}, // #5723
  {14,  2,   0}, // #5724
  {15,  2,   0}, // #5725
  { 3,  8,   0}, // #5726
  { 5,  1,   0}, // #5727
  { 7,  1,   0}, // #5728
  { 8, 10,   0}, // #5729
  { 9, 11,   0}, // #5730
  {10,  1,   0}, // #5731
  {11,  8,   0}, // #5732
  {12, 16,   0}, // #5733
  {14,  8,   0}, // #5734
  {15, 10,   0}, // #5735
  { 3,  4,   0}, // #5736
  { 5,  1,   0}, // #5737
  { 7,  1,   0}, // #5738
  { 8,  5,   0}, // #5739
  { 9,  6,   0}, // #5740
  {10,  1,   0}, // #5741
  {11,  4,   0}, // #5742
  {12,  8,   0}, // #5743
  {14,  4,   0}, // #5744
  {15,  5,   0}, // #5745
  { 9,  2,   0}, // #5746
  {16,  2,   0}, // #5747
  { 6,  2,   0}, // #5748
  { 8,  2,   0}, // #5749
  { 9,  2,   0}, // #5750
  {10,  2,   0}, // #5751
  {11,  2,   0}, // #5752
  {12,  2,   0}, // #5753
  { 6,  4,   0}, // #5754
  { 8,  2,   0}, // #5755
  { 9,  2,   0}, // #5756
  {10,  4,   0}, // #5757
  {11,  2,   0}, // #5758
  {12,  2,   0}, // #5759
  { 9,  2,   0}, // #5760
  {10,  6,   0}, // #5761
  {11,  2,   0}, // #5762
  {12,  2,   0}, // #5763
  { 9,  1,   0}, // #5764
  {10,  4,   0}, // #5765
  {11,  1,   0}, // #5766
  {12,  1,   0}, // #5767
  { 9,  4,   0}, // #5768
  {11,  2,   0}, // #5769
  {12,  2,   0}, // #5770
  {16,  4,   0}, // #5771
  { 9,  2,   0}, // #5772
  {11,  1,   0}, // #5773
  {12,  1,   0}, // #5774
  {16,  2,   0}, // #5775
  { 1,  1,   0}, // #5776
  { 3,  1,   0}, // #5777
  { 5,  2,   0}, // #5778
  { 9,  2,   0}, // #5779
  {10,  4,   0}, // #5780
  {11,  2,   0}, // #5781
  {12,  2,   0}, // #5782
  { 6, 42,   0}, // #5783
  { 8,  2,   0}, // #5784
  { 9,  2,   0}, // #5785
  {10, 42,   0}, // #5786
  {11,  2,   0}, // #5787
  {12,  2,   0}, // #5788
  { 6, 54,   0}, // #5789
  { 8,  2,   0}, // #5790
  { 9,  2,   0}, // #5791
  {10, 54,   0}, // #5792
  {11,  2,   0}, // #5793
  {12,  2,   0}, // #5794
  { 3,  2,   0}, // #5795
  {11, 16,   0}, // #5796
  {12, 32,   0}, // #5797
  {14, 16,   0}, // #5798
  { 9,  2,   0}, // #5799
  {10,  4,   0}, // #5800
  {11,  1,   0}, // #5801
  {12,  1,   0}, // #5802
  { 3, 42,   0}, // #5803
  { 5,  1,   0}, // #5804
  { 7,  1,   0}, // #5805
  { 8,  2,   0}, // #5806
  { 9,  3,   0}, // #5807
  {10,  1,   0}, // #5808
  {11,  2,   0}, // #5809
  {12, 18,   0}, // #5810
  {14, 16,   0}, // #5811
  {15,  2,   0}, // #5812
  { 3,  3,   0}, // #5813
  {11, 19,   0}, // #5814
  {12, 38,   0}, // #5815
  {14, 19,   0}, // #5816
  { 3,  6,   0}, // #5817
  {11, 38,   0}, // #5818
  {12, 76,   0}, // #5819
  {14, 38,   0}, // #5820
  { 3,  3,   0}, // #5821
  {11, 16,   0}, // #5822
  {12, 32,   0}, // #5823
  {14, 16,   0}, // #5824
  { 3,  3,   0}, // #5825
  {11, 17,   0}, // #5826
  {12, 34,   0}, // #5827
  {14, 17,   0}, // #5828
  { 3,  6,   0}, // #5829
  {11,  1,   0}, // #5830
  {12,  2,   0}, // #5831
  {14,  1,   0}, // #5832
  { 2,  1,   0}, // #5833
  { 3,  1,   0}, // #5834
  {12,  1,   0}, // #5835
  {14,  1,   0}, // #5836
  { 3,  1,   0}, // #5837
  {11, 19,   0}, // #5838
  {12, 38,   0}, // #5839
  {14, 19,   0}, // #5840
  {13,  1,   0}, // #5841
  {19,  1,   0}, // #5842
  {20,  1,   0}, // #5843
  {22,  1,   0}, // #5844
  {23,  1,   0}, // #5845
  { 3,  3,   0}, // #5846
  { 8,  6,   0}, // #5847
  {11,  3,   0}, // #5848
  {12,  3,   0}, // #5849
  {13,  9,   0}, // #5850
  {14,  3,   0}, // #5851
  {15,  6,   0}, // #5852
  {17,  1,   0}, // #5853
  {18,  6,   0}, // #5854
  {19, 10,   0}, // #5855
  {20,  9,   0}, // #5856
  {21,  1,   0}, // #5857
  {22, 10,   0}, // #5858
  {23, 11,   0}, // #5859
  { 3,  3,   0}, // #5860
  { 8,  6,   0}, // #5861
  {11,  3,   0}, // #5862
  {12,  3,   0}, // #5863
  {13,  9,   0}, // #5864
  {14,  3,   0}, // #5865
  {15,  6,   0}, // #5866
  {18,  6,   0}, // #5867
  {19, 11,   0}, // #5868
  {20,  9,   0}, // #5869
  {22, 11,   0}, // #5870
  {23, 11,   0}, // #5871
  { 8,  1,   0}, // #5872
  {11,  1,   0}, // #5873
  {13,  1,   0}, // #5874
  {15,  1,   0}, // #5875
  {17,  1,   0}, // #5876
  {18,  1,   0}, // #5877
  {19,  2,   0}, // #5878
  {20,  1,   0}, // #5879
  {21,  1,   0}, // #5880
  {22,  2,   0}, // #5881
  {23,  3,   0}, // #5882
  { 8,  1,   0}, // #5883
  {11,  1,   0}, // #5884
  {13,  1,   0}, // #5885
  {15,  1,   0}, // #5886
  {18,  1,   0}, // #5887
  {19,  2,   0}, // #5888
  {20,  1,   0}, // #5889
  {22,  2,   0}, // #5890
  {23,  2,   0}, // #5891
  {11,  2,   0}, // #5892
  {17,  1,   0}, // #5893
  {19,  2,   0}, // #5894
  {21,  1,   0}, // #5895
  {22,  2,   0}, // #5896
  {23,  3,   0}, // #5897
  { 1, 10,   0}, // #5898
  { 3,  1,   0}, // #5899
  {11,  1,   0}, // #5900
  {12,  1,   0}, // #5901
  {13,  1,   0}, // #5902
  {14,  1,   0}, // #5903
  {17,  1,   0}, // #5904
  {19,  1,   0}, // #5905
  {20,  1,   0}, // #5906
  {21,  1,   0}, // #5907
  {22,  1,   0}, // #5908
  {23,  2,   0}, // #5909
  { 3,  7,   0}, // #5910
  { 4,  2,   0}, // #5911
  { 8,  8,   0}, // #5912
  { 9,  3,   0}, // #5913
  {11,  9,   0}, // #5914
  {12,  7,   0}, // #5915
  {13, 16,   0}, // #5916
  {14, 10,   0}, // #5917
  {15, 10,   0}, // #5918
  {16,  5,   0}, // #5919
  {18, 11,   0}, // #5920
  {19, 18,   0}, // #5921
  {20, 19,   0}, // #5922
  {22, 32,   0}, // #5923
  {23, 32,   0}, // #5924
  { 2,  4,   0}, // #5925
  { 3,  1,   0}, // #5926
  {11,  1,   0}, // #5927
  {12,  1,   0}, // #5928
  {13,  1,   0}, // #5929
  {14,  1,   0}, // #5930
  {17,  1,   0}, // #5931
  {19,  1,   0}, // #5932
  {20,  1,   0}, // #5933
  {21,  1,   0}, // #5934
  {22,  1,   0}, // #5935
  {23,  2,   0}, // #5936
  { 2,  3,   0}, // #5937
  { 3,  1,   0}, // #5938
  {11,  1,   0}, // #5939
  {12,  1,   0}, // #5940
  {13,  1,   0}, // #5941
  {14,  1,   0}, // #5942
  {17,  1,   0}, // #5943
  {19,  1,   0}, // #5944
  {20,  1,   0}, // #5945
  {21,  1,   0}, // #5946
  {22,  1,   0}, // #5947
  {23,  2,   0}, // #5948
  { 8,  1,   0}, // #5949
  {13,  1,   0}, // #5950
  {15,  1,   0}, // #5951
  {17,  1,   0}, // #5952
  {18,  1,   0}, // #5953
  {19,  3,   0}, // #5954
  {20,  1,   0}, // #5955
  {21,  1,   0}, // #5956
  {22,  3,   0}, // #5957
  {23,  4,   0}, // #5958
  { 8,  1,   0}, // #5959
  {13,  1,   0}, // #5960
  {15,  1,   0}, // #5961
  {18,  1,   0}, // #5962
  {19,  3,   0}, // #5963
  {20,  1,   0}, // #5964
  {22,  3,   0}, // #5965
  {23,  3,   0}, // #5966
  { 8,  1,   0}, // #5967
  {11,  3,   0}, // #5968
  {13,  1,   0}, // #5969
  {14,  1,   0}, // #5970
  {15,  1,   0}, // #5971
  {17,  1,   0}, // #5972
  {18,  1,   0}, // #5973
  {19,  4,   0}, // #5974
  {20,  2,   0}, // #5975
  {21,  1,   0}, // #5976
  {22,  5,   0}, // #5977
  {23,  6,   0}, // #5978
  { 8,  1,   0}, // #5979
  {11,  3,   0}, // #5980
  {13,  1,   0}, // #5981
  {15,  1,   0}, // #5982
  {18,  1,   0}, // #5983
  {19,  4,   0}, // #5984
  {20,  1,   0}, // #5985
  {22,  4,   0}, // #5986
  {23,  4,   0}, // #5987
  {13,  9,   0}, // #5988
  {19,  9,   0}, // #5989
  {20,  9,   0}, // #5990
  {22, 10,   0}, // #5991
  {23, 10,   0}, // #5992
  {13,  2,   0}, // #5993
  {19,  2,   0}, // #5994
  {20,  2,   0}, // #5995
  {22,  2,   0}, // #5996
  {23,  2,   0}, // #5997
  { 8,  2,   0}, // #5998
  {11,  1,   0}, // #5999
  {13,  2,   0}, // #6000
  {15,  2,   0}, // #6001
  {17,  1,   0}, // #6002
  {18,  2,   0}, // #6003
  {19,  3,   0}, // #6004
  {20,  2,   0}, // #6005
  {21,  1,   0}, // #6006
  {22,  3,   0}, // #6007
  {23,  4,   0}, // #6008
  { 8,  2,   0}, // #6009
  {11,  1,   0}, // #6010
  {13,  2,   0}, // #6011
  {15,  2,   0}, // #6012
  {18,  2,   0}, // #6013
  {19,  3,   0}, // #6014
  {20,  2,   0}, // #6015
  {22,  3,   0}, // #6016
  {23,  3,   0}, // #6017
  { 3,  2,   0}, // #6018
  { 8,  4,   0}, // #6019
  {11,  2,   0}, // #6020
  {12,  2,   0}, // #6021
  {13,  6,   0}, // #6022
  {14,  2,   0}, // #6023
  {15,  4,   0}, // #6024
  {17,  1,   0}, // #6025
  {18,  4,   0}, // #6026
  {19,  6,   0}, // #6027
  {20,  6,   0}, // #6028
  {21,  1,   0}, // #6029
  {22,  7,   0}, // #6030
  {23,  8,   0}, // #6031
  { 3,  4,   0}, // #6032
  { 4,  2,   0}, // #6033
  { 8,  4,   0}, // #6034
  { 9,  8,   0}, // #6035
  {11,  6,   0}, // #6036
  {12,  4,   0}, // #6037
  {13,  8,   0}, // #6038
  {14, 26,   0}, // #6039
  {15,  6,   0}, // #6040
  {16, 10,   0}, // #6041
  {18, 12,   0}, // #6042
  {19, 10,   0}, // #6043
  {20, 30,   0}, // #6044
  {22, 66,   0}, // #6045
  {23, 66,   0}, // #6046
  {13,  1,   0}, // #6047
  {17,  1,   0}, // #6048
  {19,  1,   0}, // #6049
  {20,  1,   0}, // #6050
  {21,  1,   0}, // #6051
  {22,  1,   0}, // #6052
  {23,  2,   0}, // #6053
  { 8,  2,   0}, // #6054
  {13,  3,   0}, // #6055
  {15,  2,   0}, // #6056
  {17,  1,   0}, // #6057
  {18,  2,   0}, // #6058
  {19,  3,   0}, // #6059
  {20,  3,   0}, // #6060
  {21,  1,   0}, // #6061
  {22,  3,   0}, // #6062
  {23,  4,   0}, // #6063
  { 8,  2,   0}, // #6064
  {13,  3,   0}, // #6065
  {15,  2,   0}, // #6066
  {18,  2,   0}, // #6067
  {19,  3,   0}, // #6068
  {20,  3,   0}, // #6069
  {22,  3,   0}, // #6070
  {23,  3,   0}, // #6071
  { 8,  2,   0}, // #6072
  {13,  2,   0}, // #6073
  {15,  2,   0}, // #6074
  {17,  1,   0}, // #6075
  {18,  2,   0}, // #6076
  {19,  3,   0}, // #6077
  {20,  2,   0}, // #6078
  {21,  1,   0}, // #6079
  {22,  3,   0}, // #6080
  {23,  4,   0}, // #6081
  { 8,  2,   0}, // #6082
  {13,  2,   0}, // #6083
  {15,  2,   0}, // #6084
  {18,  2,   0}, // #6085
  {19,  3,   0}, // #6086
  {20,  2,   0}, // #6087
  {22,  3,   0}, // #6088
  {23,  3,   0}, // #6089
  { 4,  1,   0}, // #6090
  {11,  1,   0}, // #6091
  {14,  2,   0}, // #6092
  {15,  1,   0}, // #6093
  {16,  1,   0}, // #6094
  {17,  1,   0}, // #6095
  {19,  1,   0}, // #6096
  {20,  2,   0}, // #6097
  {21,  2,   0}, // #6098
  {22,  4,   0}, // #6099
  {23,  6,   0}, // #6100
  { 4,  1,   0}, // #6101
  {11,  1,   0}, // #6102
  {14,  2,   0}, // #6103
  {15,  1,   0}, // #6104
  {16,  1,   0}, // #6105
  {19,  1,   0}, // #6106
  {20,  2,   0}, // #6107
  {22,  4,   0}, // #6108
  {23,  4,   0}, // #6109
  { 2,  6,   0}, // #6110
  { 3,  1,   0}, // #6111
  {11,  1,   0}, // #6112
  {12,  1,   0}, // #6113
  {13,  1,   0}, // #6114
  {14,  1,   0}, // #6115
  {17,  1,   0}, // #6116
  {19,  1,   0}, // #6117
  {20,  1,   0}, // #6118
  {21,  1,   0}, // #6119
  {22,  1,   0}, // #6120
  {23,  2,   0}, // #6121
  { 2,  6,   0}, // #6122
  { 3,  1,   0}, // #6123
  {11,  1,   0}, // #6124
  {12,  1,   0}, // #6125
  {13,  1,   0}, // #6126
  {14,  1,   0}, // #6127
  {19,  1,   0}, // #6128
  {20,  1,   0}, // #6129
  {22,  1,   0}, // #6130
  {23,  1,   0}, // #6131
  { 8,  1,   0}, // #6132
  {13,  2,   0}, // #6133
  {15,  1,   0}, // #6134
  {17,  1,   0}, // #6135
  {18,  1,   0}, // #6136
  {19,  2,   0}, // #6137
  {20,  2,   0}, // #6138
  {21,  1,   0}, // #6139
  {22,  2,   0}, // #6140
  {23,  3,   0}, // #6141
  { 8,  1,   0}, // #6142
  {13,  2,   0}, // #6143
  {15,  1,   0}, // #6144
  {18,  1,   0}, // #6145
  {19,  2,   0}, // #6146
  {20,  2,   0}, // #6147
  {22,  2,   0}, // #6148
  {23,  2,   0}, // #6149
  {13,  2,   0}, // #6150
  {17,  1,   0}, // #6151
  {19,  2,   0}, // #6152
  {20,  2,   0}, // #6153
  {21,  1,   0}, // #6154
  {22,  2,   0}, // #6155
  {23,  3,   0}, // #6156
  { 7,  1,   0}, // #6157
  { 8,  1,   0}, // #6158
  {11,  1,   0}, // #6159
  {12,  1,   0}, // #6160
  {13,  1,   0}, // #6161
  {15,  1,   0}, // #6162
  {18,  1,   0}, // #6163
  {19,  2,   0}, // #6164
  {20,  1,   0}, // #6165
  {21,  1,   0}, // #6166
  {22,  2,   0}, // #6167
  {23,  4,   0}, // #6168
  { 7,  1,   0}, // #6169
  { 8,  1,   0}, // #6170
  {12,  1,   0}, // #6171
  {13,  2,   0}, // #6172
  {15,  1,   0}, // #6173
  {18,  1,   0}, // #6174
  {19,  2,   0}, // #6175
  {20,  2,   0}, // #6176
  {21,  1,   0}, // #6177
  {22,  2,   0}, // #6178
  {23,  4,   0}, // #6179
  { 2, 10,   0}, // #6180
  { 3,  2,   0}, // #6181
  { 8,  1,   0}, // #6182
  {11,  2,   0}, // #6183
  {12,  2,   0}, // #6184
  {13,  3,   0}, // #6185
  {14,  2,   0}, // #6186
  {15,  1,   0}, // #6187
  {17,  1,   0}, // #6188
  {18,  1,   0}, // #6189
  {19,  3,   0}, // #6190
  {20,  3,   0}, // #6191
  {21,  1,   0}, // #6192
  {22,  3,   0}, // #6193
  {23,  4,   0}, // #6194
  { 2, 10,   0}, // #6195
  { 3,  2,   0}, // #6196
  { 8,  1,   0}, // #6197
  {11,  2,   0}, // #6198
  {12,  2,   0}, // #6199
  {13,  3,   0}, // #6200
  {14,  2,   0}, // #6201
  {15,  1,   0}, // #6202
  {18,  1,   0}, // #6203
  {19,  3,   0}, // #6204
  {20,  3,   0}, // #6205
  {22,  3,   0}, // #6206
  {23,  3,   0}, // #6207
  { 2, 16,   0}, // #6208
  { 3,  2,   0}, // #6209
  { 8,  1,   0}, // #6210
  {11,  2,   0}, // #6211
  {12,  2,   0}, // #6212
  {13,  3,   0}, // #6213
  {14,  2,   0}, // #6214
  {15,  1,   0}, // #6215
  {17,  1,   0}, // #6216
  {18,  1,   0}, // #6217
  {19,  3,   0}, // #6218
  {20,  3,   0}, // #6219
  {21,  1,   0}, // #6220
  {22,  3,   0}, // #6221
  {23,  4,   0}, // #6222
  { 2, 16,   0}, // #6223
  { 3,  2,   0}, // #6224
  { 8,  1,   0}, // #6225
  {11,  2,   0}, // #6226
  {12,  2,   0}, // #6227
  {13,  3,   0}, // #6228
  {14,  2,   0}, // #6229
  {15,  1,   0}, // #6230
  {18,  1,   0}, // #6231
  {19,  3,   0}, // #6232
  {20,  3,   0}, // #6233
  {22,  3,   0}, // #6234
  {23,  3,   0}, // #6235
  { 3,  1,   0}, // #6236
  { 7,  1,   0}, // #6237
  {11,  1,   0}, // #6238
  {12,  2,   0}, // #6239
  {13,  1,   0}, // #6240
  {14,  1,   0}, // #6241
  {17,  1,   0}, // #6242
  {19,  1,   0}, // #6243
  {20,  1,   0}, // #6244
  {21,  1,   0}, // #6245
  {22,  1,   0}, // #6246
  {23,  3,   0}, // #6247
  { 2, 12,   0}, // #6248
  { 3,  2,   0}, // #6249
  { 8,  1,   0}, // #6250
  {11,  2,   0}, // #6251
  {12,  2,   0}, // #6252
  {13,  3,   0}, // #6253
  {14,  2,   0}, // #6254
  {15,  1,   0}, // #6255
  {17,  1,   0}, // #6256
  {18,  1,   0}, // #6257
  {19,  3,   0}, // #6258
  {20,  3,   0}, // #6259
  {21,  1,   0}, // #6260
  {22,  3,   0}, // #6261
  {23,  4,   0}, // #6262
  { 2, 12,   0}, // #6263
  { 3,  2,   0}, // #6264
  { 8,  1,   0}, // #6265
  {11,  2,   0}, // #6266
  {12,  2,   0}, // #6267
  {13,  3,   0}, // #6268
  {14,  2,   0}, // #6269
  {15,  1,   0}, // #6270
  {18,  1,   0}, // #6271
  {19,  3,   0}, // #6272
  {20,  3,   0}, // #6273
  {22,  3,   0}, // #6274
  {23,  3,   0}, // #6275
  { 2, 12,   0}, // #6276
  { 3,  1,   0}, // #6277
  {11,  1,   0}, // #6278
  {12,  1,   0}, // #6279
  {13,  1,   0}, // #6280
  {14,  1,   0}, // #6281
  {17,  1,   0}, // #6282
  {19,  1,   0}, // #6283
  {20,  1,   0}, // #6284
  {21,  1,   0}, // #6285
  {22,  1,   0}, // #6286
  {23,  2,   0}, // #6287
  { 2, 12,   0}, // #6288
  { 3,  1,   0}, // #6289
  {11,  1,   0}, // #6290
  {12,  1,   0}, // #6291
  {13,  1,   0}, // #6292
  {14,  1,   0}, // #6293
  {19,  1,   0}, // #6294
  {20,  1,   0}, // #6295
  {22,  1,   0}, // #6296
  {23,  1,   0}, // #6297
  { 2, 24,   0}, // #6298
  { 3,  2,   0}, // #6299
  { 8,  1,   0}, // #6300
  {11,  2,   0}, // #6301
  {12,  2,   0}, // #6302
  {13,  3,   0}, // #6303
  {14,  2,   0}, // #6304
  {15,  1,   0}, // #6305
  {17,  1,   0}, // #6306
  {18,  1,   0}, // #6307
  {19,  3,   0}, // #6308
  {20,  3,   0}, // #6309
  {21,  1,   0}, // #6310
  {22,  3,   0}, // #6311
  {23,  4,   0}, // #6312
  { 2, 24,   0}, // #6313
  { 3,  2,   0}, // #6314
  { 8,  1,   0}, // #6315
  {11,  2,   0}, // #6316
  {12,  2,   0}, // #6317
  {13,  3,   0}, // #6318
  {14,  2,   0}, // #6319
  {15,  1,   0}, // #6320
  {18,  1,   0}, // #6321
  {19,  3,   0}, // #6322
  {20,  3,   0}, // #6323
  {22,  3,   0}, // #6324
  {23,  3,   0}, // #6325
  { 4,  2,   0}, // #6326
  {11,  2,   0}, // #6327
  {14,  4,   0}, // #6328
  {15,  3,   0}, // #6329
  {16,  2,   0}, // #6330
  {17,  1,   0}, // #6331
  {19,  3,   0}, // #6332
  {20,  4,   0}, // #6333
  {21,  2,   0}, // #6334
  {22,  9,   0}, // #6335
  {23, 11,   0}, // #6336
  { 3,  2,   0}, // #6337
  { 4,  1,   0}, // #6338
  { 8,  2,   0}, // #6339
  { 9,  4,   0}, // #6340
  {11,  3,   0}, // #6341
  {12,  2,   0}, // #6342
  {13,  6,   0}, // #6343
  {14,  6,   0}, // #6344
  {15,  3,   0}, // #6345
  {16,  5,   0}, // #6346
  {18,  6,   0}, // #6347
  {19,  7,   0}, // #6348
  {20, 10,   0}, // #6349
  {22, 15,   0}, // #6350
  {23, 15,   0}, // #6351
  { 3,  1,   0}, // #6352
  { 8,  1,   0}, // #6353
  {11,  2,   0}, // #6354
  {12,  1,   0}, // #6355
  {13,  2,   0}, // #6356
  {14,  1,   0}, // #6357
  {15,  1,   0}, // #6358
  {18,  1,   0}, // #6359
  {19,  3,   0}, // #6360
  {20,  2,   0}, // #6361
  {22,  3,   0}, // #6362
  {23,  3,   0}, // #6363
  { 7,  1,   0}, // #6364
  { 9,  1,   0}, // #6365
  {12,  1,   0}, // #6366
  {14,  2,   0}, // #6367
  {16,  1,   0}, // #6368
  {17,  1,   0}, // #6369
  {18,  1,   0}, // #6370
  {20,  2,   0}, // #6371
  {21,  2,   0}, // #6372
  {22,  5,   0}, // #6373
  {23,  8,   0}, // #6374
  { 3,  1,   0}, // #6375
  {11,  1,   0}, // #6376
  {12,  1,   0}, // #6377
  {13,  2,   0}, // #6378
  {14,  1,   0}, // #6379
  {17,  1,   0}, // #6380
  {19,  2,   0}, // #6381
  {20,  2,   0}, // #6382
  {21,  1,   0}, // #6383
  {22,  2,   0}, // #6384
  {23,  3,   0}, // #6385
  { 9,  1,   0}, // #6386
  {14,  1,   0}, // #6387
  {16,  1,   0}, // #6388
  {18,  1,   0}, // #6389
  {20,  1,   0}, // #6390
  {22,  4,   0}, // #6391
  {23,  4,   0}, // #6392
  { 9,  1,   0}, // #6393
  {14,  4,   0}, // #6394
  {15,  1,   0}, // #6395
  {16,  1,   0}, // #6396
  {18,  1,   0}, // #6397
  {19,  1,   0}, // #6398
  {20,  4,   0}, // #6399
  {22,  7,   0}, // #6400
  {23,  7,   0}, // #6401
  { 8,  1,   0}, // #6402
  { 9,  2,   0}, // #6403
  {13,  1,   0}, // #6404
  {14,  2,   0}, // #6405
  {15,  1,   0}, // #6406
  {16,  2,   0}, // #6407
  {18,  3,   0}, // #6408
  {19,  1,   0}, // #6409
  {20,  3,   0}, // #6410
  {22, 10,   0}, // #6411
  {23, 10,   0}, // #6412
  { 8,  6,   0}, // #6413
  {13,  9,   0}, // #6414
  {15,  6,   0}, // #6415
  {18,  6,   0}, // #6416
  {19,  9,   0}, // #6417
  {20,  9,   0}, // #6418
  {22, 15,   0}, // #6419
  {23, 15,   0}, // #6420
  { 4,  1,   0}, // #6421
  { 9,  5,   0}, // #6422
  {11,  1,   0}, // #6423
  {13,  4,   0}, // #6424
  {14,  5,   0}, // #6425
  {15,  1,   0}, // #6426
  {16,  6,   0}, // #6427
  {18,  5,   0}, // #6428
  {19,  5,   0}, // #6429
  {20,  9,   0}, // #6430
  {22, 10,   0}, // #6431
  {23, 10,   0}, // #6432
  { 4,  1,   0}, // #6433
  { 9,  1,   0}, // #6434
  {11,  1,   0}, // #6435
  {14,  1,   0}, // #6436
  {15,  1,   0}, // #6437
  {16,  2,   0}, // #6438
  {18,  1,   0}, // #6439
  {19,  1,   0}, // #6440
  {20,  1,   0}, // #6441
  {22,  4,   0}, // #6442
  {23,  4,   0}, // #6443
  { 4,  1,   0}, // #6444
  {11,  1,   0}, // #6445
  {14,  5,   0}, // #6446
  {15,  2,   0}, // #6447
  {16,  1,   0}, // #6448
  {17,  1,   0}, // #6449
  {19,  2,   0}, // #6450
  {20,  5,   0}, // #6451
  {21,  2,   0}, // #6452
  {22,  8,   0}, // #6453
  {23, 10,   0}, // #6454
  { 4,  2,   0}, // #6455
  {11,  2,   0}, // #6456
  {14,  3,   0}, // #6457
  {15,  2,   0}, // #6458
  {16,  2,   0}, // #6459
  {19,  2,   0}, // #6460
  {20,  3,   0}, // #6461
  {22,  7,   0}, // #6462
  {23,  7,   0}, // #6463
  { 4,  1,   0}, // #6464
  {11,  1,   0}, // #6465
  {14,  5,   0}, // #6466
  {15,  2,   0}, // #6467
  {16,  1,   0}, // #6468
  {19,  2,   0}, // #6469
  {20,  5,   0}, // #6470
  {22,  9,   0}, // #6471
  {23,  9,   0}, // #6472
  { 4,  2,   0}, // #6473
  {11,  2,   0}, // #6474
  {14,  4,   0}, // #6475
  {15,  3,   0}, // #6476
  {16,  2,   0}, // #6477
  {19,  3,   0}, // #6478
  {20,  4,   0}, // #6479
  {22, 10,   0}, // #6480
  {23, 10,   0}, // #6481
  { 4,  1,   0}, // #6482
  { 9,  8,   0}, // #6483
  {11,  1,   0}, // #6484
  {14,  8,   0}, // #6485
  {15,  1,   0}, // #6486
  {16,  9,   0}, // #6487
  {17,  1,   0}, // #6488
  {18,  8,   0}, // #6489
  {19,  1,   0}, // #6490
  {20,  8,   0}, // #6491
  {21,  1,   0}, // #6492
  {22, 30,   0}, // #6493
  {23, 31,   0}, // #6494
  { 7,  1,   0}, // #6495
  { 9, 10,   0}, // #6496
  {12,  1,   0}, // #6497
  {14, 10,   0}, // #6498
  {16, 10,   0}, // #6499
  {17,  1,   0}, // #6500
  {18, 10,   0}, // #6501
  {20, 10,   0}, // #6502
  {21,  2,   0}, // #6503
  {22, 36,   0}, // #6504
  {23, 39,   0}, // #6505
  { 7,  1,   0}, // #6506
  { 9, 11,   0}, // #6507
  {12,  1,   0}, // #6508
  {14, 11,   0}, // #6509
  {16, 11,   0}, // #6510
  {17,  1,   0}, // #6511
  {18, 11,   0}, // #6512
  {20, 11,   0}, // #6513
  {21,  2,   0}, // #6514
  {22, 37,   0}, // #6515
  {23, 40,   0}, // #6516
  { 4,  1,   0}, // #6517
  { 7,  1,   0}, // #6518
  { 8,  2,   0}, // #6519
  { 9,  3,   0}, // #6520
  {11,  1,   0}, // #6521
  {12,  1,   0}, // #6522
  {13,  2,   0}, // #6523
  {14,  3,   0}, // #6524
  {15,  4,   0}, // #6525
  {16,  4,   0}, // #6526
  {17,  1,   0}, // #6527
  {18,  5,   0}, // #6528
  {19,  4,   0}, // #6529
  {20,  5,   0}, // #6530
  {21,  2,   0}, // #6531
  {22, 15,   0}, // #6532
  {23, 18,   0}, // #6533
  { 3,  2,   0}, // #6534
  {11,  2,   0}, // #6535
  {12,  2,   0}, // #6536
  {13,  7,   0}, // #6537
  {14, 12,   0}, // #6538
  {17,  8,   0}, // #6539
  {19,  7,   0}, // #6540
  {20, 17,   0}, // #6541
  {21,  8,   0}, // #6542
  {22, 56,   0}, // #6543
  {23, 64,   0}, // #6544
  { 3,  9,   0}, // #6545
  { 4,  1,   0}, // #6546
  { 7, 11,   0}, // #6547
  { 8, 16,   0}, // #6548
  { 9,  1,   0}, // #6549
  {11, 10,   0}, // #6550
  {12, 20,   0}, // #6551
  {13, 25,   0}, // #6552
  {14, 31,   0}, // #6553
  {15, 17,   0}, // #6554
  {16,  2,   0}, // #6555
  {18, 17,   0}, // #6556
  {19, 26,   0}, // #6557
  {20, 47,   0}, // #6558
  {21, 11,   0}, // #6559
  {22, 78,   0}, // #6560
  {23, 100,   0}, // #6561
  { 3,  1,   0}, // #6562
  { 8,  1,   0}, // #6563
  {11,  1,   0}, // #6564
  {12,  1,   0}, // #6565
  {13,  2,   0}, // #6566
  {14,  1,   0}, // #6567
  {15,  1,   0}, // #6568
  {17,  2,   0}, // #6569
  {18,  1,   0}, // #6570
  {19,  3,   0}, // #6571
  {20,  2,   0}, // #6572
  {21,  2,   0}, // #6573
  {22,  3,   0}, // #6574
  {23,  5,   0}, // #6575
  { 3,  1,   0}, // #6576
  { 8,  1,   0}, // #6577
  {11,  1,   0}, // #6578
  {12,  1,   0}, // #6579
  {13,  2,   0}, // #6580
  {14,  1,   0}, // #6581
  {15,  1,   0}, // #6582
  {17,  4,   0}, // #6583
  {18,  1,   0}, // #6584
  {19,  3,   0}, // #6585
  {20,  2,   0}, // #6586
  {21,  4,   0}, // #6587
  {22,  3,   0}, // #6588
  {23,  7,   0}, // #6589
  { 3,  1,   0}, // #6590
  { 8,  1,   0}, // #6591
  {11,  1,   0}, // #6592
  {12,  1,   0}, // #6593
  {13,  2,   0}, // #6594
  {14,  1,   0}, // #6595
  {15,  1,   0}, // #6596
  {17,  8,   0}, // #6597
  {18,  1,   0}, // #6598
  {19,  3,   0}, // #6599
  {20,  2,   0}, // #6600
  {21,  8,   0}, // #6601
  {22,  3,   0}, // #6602
  {23, 11,   0}, // #6603
  { 8,  5,   0}, // #6604
  {11,  5,   0}, // #6605
  {13,  5,   0}, // #6606
  {15,  5,   0}, // #6607
  {18,  5,   0}, // #6608
  {19, 14,   0}, // #6609
  {20,  5,   0}, // #6610
  {22, 14,   0}, // #6611
  {23, 14,   0}, // #6612
  { 8,  9,   0}, // #6613
  {11,  7,   0}, // #6614
  {13,  9,   0}, // #6615
  {15,  9,   0}, // #6616
  {18,  9,   0}, // #6617
  {19, 21,   0}, // #6618
  {20,  9,   0}, // #6619
  {22, 21,   0}, // #6620
  {23, 21,   0}, // #6621
  { 8, 17,   0}, // #6622
  {11, 11,   0}, // #6623
  {13, 17,   0}, // #6624
  {15, 17,   0}, // #6625
  {18, 17,   0}, // #6626
  {19, 35,   0}, // #6627
  {20, 17,   0}, // #6628
  {22, 35,   0}, // #6629
  {23, 35,   0}, // #6630
  { 7,  2,   0}, // #6631
  {12,  2,   0}, // #6632
  {15,  1,   0}, // #6633
  {19,  1,   0}, // #6634
  {21,  2,   0}, // #6635
  {22,  1,   0}, // #6636
  {23,  5,   0}, // #6637
  { 7,  1,   0}, // #6638
  {11,  1,   0}, // #6639
  {12,  1,   0}, // #6640
  {19,  1,   0}, // #6641
  {21,  1,   0}, // #6642
  {22,  1,   0}, // #6643
  {23,  3,   0}, // #6644
  { 7,  1,   0}, // #6645
  { 8,  2,   0}, // #6646
  {12,  1,   0}, // #6647
  {13,  2,   0}, // #6648
  {15,  2,   0}, // #6649
  {18,  2,   0}, // #6650
  {19,  2,   0}, // #6651
  {20,  2,   0}, // #6652
  {21,  1,   0}, // #6653
  {22,  2,   0}, // #6654
  {23,  4,   0}, // #6655
  { 8,  1,   0}, // #6656
  {13,  1,   0}, // #6657
  {15,  1,   0}, // #6658
  {17,  1,   0}, // #6659
  {18,  1,   0}, // #6660
  {19,  1,   0}, // #6661
  {20,  1,   0}, // #6662
  {21,  1,   0}, // #6663
  {22,  2,   0}, // #6664
  {23,  3,   0}, // #6665
  { 3,  1,   0}, // #6666
  { 7,  2,   0}, // #6667
  {11,  1,   0}, // #6668
  {12,  3,   0}, // #6669
  {13,  1,   0}, // #6670
  {14,  1,   0}, // #6671
  {19,  1,   0}, // #6672
  {20,  1,   0}, // #6673
  {21,  2,   0}, // #6674
  {22,  3,   0}, // #6675
  {23,  7,   0}, // #6676
  { 3,  1,   0}, // #6677
  { 7,  4,   0}, // #6678
  {11,  1,   0}, // #6679
  {12,  5,   0}, // #6680
  {13,  1,   0}, // #6681
  {14,  1,   0}, // #6682
  {19,  1,   0}, // #6683
  {20,  1,   0}, // #6684
  {21,  4,   0}, // #6685
  {22,  3,   0}, // #6686
  {23, 11,   0}, // #6687
  { 3,  1,   0}, // #6688
  { 7,  8,   0}, // #6689
  {11,  1,   0}, // #6690
  {12,  9,   0}, // #6691
  {13,  1,   0}, // #6692
  {14,  1,   0}, // #6693
  {19,  1,   0}, // #6694
  {20,  1,   0}, // #6695
  {21,  8,   0}, // #6696
  {22,  3,   0}, // #6697
  {23, 19,   0}, // #6698
  { 3,  1,   0}, // #6699
  { 7, 16,   0}, // #6700
  { 8,  1,   0}, // #6701
  {11,  1,   0}, // #6702
  {12, 17,   0}, // #6703
  {13,  2,   0}, // #6704
  {14,  1,   0}, // #6705
  {15,  1,   0}, // #6706
  {18,  1,   0}, // #6707
  {19,  2,   0}, // #6708
  {20,  2,   0}, // #6709
  {21, 16,   0}, // #6710
  {22,  4,   0}, // #6711
  {23, 36,   0}, // #6712
  { 3,  1,   0}, // #6713
  { 7,  2,   0}, // #6714
  { 8,  1,   0}, // #6715
  {11,  1,   0}, // #6716
  {12,  3,   0}, // #6717
  {13,  2,   0}, // #6718
  {14,  1,   0}, // #6719
  {15,  1,   0}, // #6720
  {18,  1,   0}, // #6721
  {19,  2,   0}, // #6722
  {20,  2,   0}, // #6723
  {21,  2,   0}, // #6724
  {22,  4,   0}, // #6725
  {23,  8,   0}, // #6726
  { 3,  1,   0}, // #6727
  { 7,  4,   0}, // #6728
  { 8,  1,   0}, // #6729
  {11,  1,   0}, // #6730
  {12,  5,   0}, // #6731
  {13,  2,   0}, // #6732
  {14,  1,   0}, // #6733
  {15,  1,   0}, // #6734
  {18,  1,   0}, // #6735
  {19,  2,   0}, // #6736
  {20,  2,   0}, // #6737
  {21,  4,   0}, // #6738
  {22,  4,   0}, // #6739
  {23, 12,   0}, // #6740
  { 3,  1,   0}, // #6741
  { 7,  8,   0}, // #6742
  { 8,  1,   0}, // #6743
  {11,  1,   0}, // #6744
  {12,  9,   0}, // #6745
  {13,  2,   0}, // #6746
  {14,  1,   0}, // #6747
  {15,  1,   0}, // #6748
  {18,  1,   0}, // #6749
  {19,  2,   0}, // #6750
  {20,  2,   0}, // #6751
  {21,  8,   0}, // #6752
  {22,  4,   0}, // #6753
  {23, 20,   0}, // #6754
  {11,  3,   0}, // #6755
  {19,  3,   0}, // #6756
  {22,  3,   0}, // #6757
  {23,  3,   0}, // #6758
  {13,  3,   0}, // #6759
  {19,  3,   0}, // #6760
  {20,  3,   0}, // #6761
  {22,  3,   0}, // #6762
  {23,  3,   0}, // #6763
  { 4,  1,   0}, // #6764
  { 8,  2,   0}, // #6765
  {11,  3,   0}, // #6766
  {13,  2,   0}, // #6767
  {15,  3,   0}, // #6768
  {16,  1,   0}, // #6769
  {17,  1,   0}, // #6770
  {18,  2,   0}, // #6771
  {19,  7,   0}, // #6772
  {20,  2,   0}, // #6773
  {21,  1,   0}, // #6774
  {22,  7,   0}, // #6775
  {23,  8,   0}, // #6776
  {11,  3,   0}, // #6777
  {17,  1,   0}, // #6778
  {19,  3,   0}, // #6779
  {21,  1,   0}, // #6780
  {22,  3,   0}, // #6781
  {23,  4,   0}, // #6782
  {13,  3,   0}, // #6783
  {17,  1,   0}, // #6784
  {19,  3,   0}, // #6785
  {20,  3,   0}, // #6786
  {21,  1,   0}, // #6787
  {22,  3,   0}, // #6788
  {23,  4,   0}, // #6789
  { 3,  1,   0}, // #6790
  {11,  1,   0}, // #6791
  {12,  1,   0}, // #6792
  {13,  1,   0}, // #6793
  {14,  1,   0}, // #6794
  {17,  2,   0}, // #6795
  {19,  2,   0}, // #6796
  {20,  1,   0}, // #6797
  {21,  2,   0}, // #6798
  {22,  3,   0}, // #6799
  {23,  5,   0}, // #6800
  { 3,  1,   0}, // #6801
  {11,  1,   0}, // #6802
  {12,  1,   0}, // #6803
  {13,  1,   0}, // #6804
  {14,  1,   0}, // #6805
  {17,  4,   0}, // #6806
  {19,  2,   0}, // #6807
  {20,  1,   0}, // #6808
  {21,  4,   0}, // #6809
  {22,  3,   0}, // #6810
  {23,  7,   0}, // #6811
  { 3,  1,   0}, // #6812
  {11,  1,   0}, // #6813
  {12,  1,   0}, // #6814
  {13,  1,   0}, // #6815
  {14,  1,   0}, // #6816
  {17,  8,   0}, // #6817
  {19,  2,   0}, // #6818
  {20,  1,   0}, // #6819
  {21,  8,   0}, // #6820
  {22,  3,   0}, // #6821
  {23, 11,   0}, // #6822
  { 3,  1,   0}, // #6823
  {11,  1,   0}, // #6824
  {12,  1,   0}, // #6825
  {13,  1,   0}, // #6826
  {14,  1,   0}, // #6827
  {17, 16,   0}, // #6828
  {19,  2,   0}, // #6829
  {20,  1,   0}, // #6830
  {21, 16,   0}, // #6831
  {22,  3,   0}, // #6832
  {23, 19,   0}, // #6833
  { 8,  5,   0}, // #6834
  {11,  5,   0}, // #6835
  {13,  5,   0}, // #6836
  {15,  5,   0}, // #6837
  {17,  1,   0}, // #6838
  {18,  5,   0}, // #6839
  {19, 14,   0}, // #6840
  {20,  5,   0}, // #6841
  {21,  1,   0}, // #6842
  {22, 14,   0}, // #6843
  {23, 15,   0}, // #6844
  { 8,  9,   0}, // #6845
  {11,  7,   0}, // #6846
  {13,  9,   0}, // #6847
  {15,  9,   0}, // #6848
  {17,  1,   0}, // #6849
  {18,  9,   0}, // #6850
  {19, 21,   0}, // #6851
  {20,  9,   0}, // #6852
  {21,  1,   0}, // #6853
  {22, 21,   0}, // #6854
  {23, 22,   0}, // #6855
  { 8, 17,   0}, // #6856
  {11, 11,   0}, // #6857
  {13, 17,   0}, // #6858
  {15, 17,   0}, // #6859
  {17,  1,   0}, // #6860
  {18, 17,   0}, // #6861
  {19, 35,   0}, // #6862
  {20, 17,   0}, // #6863
  {21,  1,   0}, // #6864
  {22, 35,   0}, // #6865
  {23, 36,   0}, // #6866
  { 7,  1,   0}, // #6867
  {12,  1,   0}, // #6868
  {14,  2,   0}, // #6869
  {20,  2,   0}, // #6870
  {21,  1,   0}, // #6871
  {22,  2,   0}, // #6872
  {23,  4,   0}, // #6873
  { 4,  1,   0}, // #6874
  { 7,  1,   0}, // #6875
  { 9,  1,   0}, // #6876
  {11,  1,   0}, // #6877
  {12,  1,   0}, // #6878
  { 6,  1,   0}, // #6879
  { 8,  1,   0}, // #6880
  { 9,  1,   0}, // #6881
  {11,  1,   0}, // #6882
  {12,  1,   0}, // #6883
  { 5,  1,   0}, // #6884
  { 6,  2,   0}, // #6885
  { 8,  2,   0}, // #6886
  { 9,  2,   0}, // #6887
  {10,  2,   0}, // #6888
  {11,  3,   0}, // #6889
  {12,  6,   0}, // #6890
  { 6,  1,   0}, // #6891
  { 8,  1,   0}, // #6892
  { 9,  1,   0}, // #6893
  {10,  1,   0}, // #6894
  {11,  1,   0}, // #6895
  {12,  2,   0}, // #6896
  { 5,  1,   0}, // #6897
  {10,  1,   0}, // #6898
  {12,  2,   0}, // #6899
  {10,  1,   0}, // #6900
  {12,  1,   0}, // #6901
  { 5,  1,   0}, // #6902
  {10,  2,   0}, // #6903
  {11,  1,   0}, // #6904
  {12,  4,   0}, // #6905
  { 5,  1,   0}, // #6906
  {10,  2,   0}, // #6907
  {11,  3,   0}, // #6908
  {12,  6,   0}, // #6909
  { 8,  1,   0}, // #6910
  {10,  1,   0}, // #6911
  {11,  2,   0}, // #6912
  {12,  3,   0}, // #6913
  { 4,  1,   0}, // #6914
  { 7,  1,   0}, // #6915
  { 9,  1,   0}, // #6916
  {10,  1,   0}, // #6917
  {11,  1,   0}, // #6918
  {12,  2,   0}, // #6919
  { 6,  1,   0}, // #6920
  { 8,  1,   0}, // #6921
  { 9,  1,   0}, // #6922
  {10,  1,   0}, // #6923
  {11,  2,   0}, // #6924
  {12,  3,   0}, // #6925
  { 6,  1,   0}, // #6926
  { 8,  1,   0}, // #6927
  { 9,  1,   0}, // #6928
  {11,  2,   0}, // #6929
  {12,  2,   0}, // #6930
  { 6,  2,   0}, // #6931
  { 8,  2,   0}, // #6932
  { 9,  2,   0}, // #6933
  {10,  1,   0}, // #6934
  {11,  2,   0}, // #6935
  {12,  3,   0}, // #6936
  { 6,  2,   0}, // #6937
  { 8,  2,   0}, // #6938
  { 9,  2,   0}, // #6939
  {11,  2,   0}, // #6940
  {12,  2,   0}, // #6941
  {10,  1,   0}, // #6942
  {11, 10,   0}, // #6943
  {12, 11,   0}, // #6944
  {11, 11,   0}, // #6945
  {12, 11,   0}, // #6946
  { 4,  1,   0}, // #6947
  { 7,  1,   0}, // #6948
  { 8,  1,   0}, // #6949
  { 9,  1,   0}, // #6950
  {10,  1,   0}, // #6951
  {11,  2,   0}, // #6952
  {12,  3,   0}, // #6953
  { 4,  1,   0}, // #6954
  { 7,  1,   0}, // #6955
  { 8,  1,   0}, // #6956
  { 9,  1,   0}, // #6957
  {11,  2,   0}, // #6958
  {12,  2,   0}, // #6959
  { 8,  1,   0}, // #6960
  {10,  1,   0}, // #6961
  {11,  1,   0}, // #6962
  {12,  2,   0}, // #6963
  { 8,  2,   0}, // #6964
  {10,  1,   0}, // #6965
  {11,  2,   0}, // #6966
  {12,  3,   0}, // #6967
  { 8,  2,   0}, // #6968
  {11,  2,   0}, // #6969
  {12,  2,   0}, // #6970
  { 5,  1,   0}, // #6971
  { 6,  1,   0}, // #6972
  { 8,  2,   0}, // #6973
  { 9,  1,   0}, // #6974
  {10,  2,   0}, // #6975
  {11,  3,   0}, // #6976
  {12,  6,   0}, // #6977
  { 5,  1,   0}, // #6978
  { 8,  1,   0}, // #6979
  {10,  2,   0}, // #6980
  {11,  1,   0}, // #6981
  {12,  4,   0}, // #6982
  { 6,  2,   0}, // #6983
  { 8,  3,   0}, // #6984
  { 9,  2,   0}, // #6985
  {11,  3,   0}, // #6986
  {12,  3,   0}, // #6987
  { 8,  1,   0}, // #6988
  {11,  4,   0}, // #6989
  {12,  4,   0}, // #6990
  { 4,  1,   0}, // #6991
  { 6,  1,   0}, // #6992
  { 7,  1,   0}, // #6993
  { 8,  1,   0}, // #6994
  { 9,  2,   0}, // #6995
  {10,  1,   0}, // #6996
  {11,  2,   0}, // #6997
  {12,  3,   0}, // #6998
  { 4,  1,   0}, // #6999
  { 6,  1,   0}, // #7000
  { 7,  1,   0}, // #7001
  { 8,  1,   0}, // #7002
  { 9,  2,   0}, // #7003
  {11,  2,   0}, // #7004
  {12,  2,   0}, // #7005
  { 3,  1,   0}, // #7006
  { 7,  1,   0}, // #7007
  { 8,  1,   0}, // #7008
  {10,  1,   0}, // #7009
  {11,  1,   0}, // #7010
  {12,  2,   0}, // #7011
  { 3,  1,   0}, // #7012
  { 6,  1,   0}, // #7013
  { 7,  1,   0}, // #7014
  { 8,  2,   0}, // #7015
  { 9,  1,   0}, // #7016
  {11,  2,   0}, // #7017
  {12,  2,   0}, // #7018
  { 3,  1,   0}, // #7019
  { 4,  1,   0}, // #7020
  { 7,  2,   0}, // #7021
  { 8,  1,   0}, // #7022
  { 9,  1,   0}, // #7023
  {10,  1,   0}, // #7024
  {11,  2,   0}, // #7025
  {12,  3,   0}, // #7026
  { 3,  1,   0}, // #7027
  { 4,  1,   0}, // #7028
  { 7,  2,   0}, // #7029
  { 8,  1,   0}, // #7030
  { 9,  1,   0}, // #7031
  {11,  2,   0}, // #7032
  {12,  2,   0}, // #7033
  { 4,  1,   0}, // #7034
  { 6,  2,   0}, // #7035
  { 7,  1,   0}, // #7036
  { 8,  2,   0}, // #7037
  { 9,  3,   0}, // #7038
  {11,  3,   0}, // #7039
  {12,  3,   0}, // #7040
  { 1, 10,   0}, // #7041
  { 3,  1,   0}, // #7042
  { 7,  1,   0}, // #7043
  { 8,  1,   0}, // #7044
  {10,  1,   0}, // #7045
  {11,  1,   0}, // #7046
  {12,  2,   0}, // #7047
  { 1, 10,   0}, // #7048
  { 3,  1,   0}, // #7049
  { 7,  1,   0}, // #7050
  { 8,  1,   0}, // #7051
  {11,  1,   0}, // #7052
  {12,  1,   0}, // #7053
  { 2, 22,   0}, // #7054
  { 3,  1,   0}, // #7055
  { 7,  1,   0}, // #7056
  { 8,  1,   0}, // #7057
  {10,  1,   0}, // #7058
  {11,  1,   0}, // #7059
  {12,  2,   0}, // #7060
  { 2, 22,   0}, // #7061
  { 3,  1,   0}, // #7062
  { 7,  1,   0}, // #7063
  { 8,  1,   0}, // #7064
  {11,  1,   0}, // #7065
  {12,  1,   0}, // #7066
  { 2, 14,   0}, // #7067
  { 3,  1,   0}, // #7068
  { 7,  1,   0}, // #7069
  { 8,  1,   0}, // #7070
  {10,  1,   0}, // #7071
  {11,  1,   0}, // #7072
  {12,  2,   0}, // #7073
  { 2, 14,   0}, // #7074
  { 3,  1,   0}, // #7075
  { 7,  1,   0}, // #7076
  { 8,  1,   0}, // #7077
  {11,  1,   0}, // #7078
  {12,  1,   0}, // #7079
  { 3,  1,   0}, // #7080
  { 4,  1,   0}, // #7081
  { 6,  1,   0}, // #7082
  { 7,  2,   0}, // #7083
  { 8,  2,   0}, // #7084
  { 9,  2,   0}, // #7085
  {10,  1,   0}, // #7086
  {11,  3,   0}, // #7087
  {12,  4,   0}, // #7088
  { 3,  1,   0}, // #7089
  { 4,  1,   0}, // #7090
  { 6,  1,   0}, // #7091
  { 7,  2,   0}, // #7092
  { 8,  2,   0}, // #7093
  { 9,  2,   0}, // #7094
  {11,  3,   0}, // #7095
  {12,  3,   0}, // #7096
  { 3,  1,   0}, // #7097
  { 4,  2,   0}, // #7098
  { 6,  2,   0}, // #7099
  { 7,  3,   0}, // #7100
  { 8,  3,   0}, // #7101
  { 9,  4,   0}, // #7102
  {10,  1,   0}, // #7103
  {11,  5,   0}, // #7104
  {12,  6,   0}, // #7105
  { 3,  1,   0}, // #7106
  { 4,  2,   0}, // #7107
  { 6,  1,   0}, // #7108
  { 7,  3,   0}, // #7109
  { 8,  2,   0}, // #7110
  { 9,  3,   0}, // #7111
  {11,  4,   0}, // #7112
  {12,  4,   0}, // #7113
  { 5,  1,   0}, // #7114
  { 9,  1,   0}, // #7115
  {10,  1,   0}, // #7116
  {11,  1,   0}, // #7117
  {12,  3,   0}, // #7118
  { 3,  1,   0}, // #7119
  { 7,  1,   0}, // #7120
  { 8,  1,   0}, // #7121
  { 9,  1,   0}, // #7122
  {11,  2,   0}, // #7123
  {12,  2,   0}, // #7124
  {11, 31,   0}, // #7125
  {12, 31,   0}, // #7126
  { 4,  1,   0}, // #7127
  { 6,  2,   0}, // #7128
  { 7,  1,   0}, // #7129
  { 8,  2,   0}, // #7130
  { 9,  3,   0}, // #7131
  {10,  1,   0}, // #7132
  {11,  3,   0}, // #7133
  {12,  4,   0}, // #7134
  { 4,  1,   0}, // #7135
  { 7,  1,   0}, // #7136
  { 8,  1,   0}, // #7137
  { 9,  1,   0}, // #7138
  {10,  1,   0}, // #7139
  {11,  4,   0}, // #7140
  {12,  5,   0}, // #7141
  { 4,  1,   0}, // #7142
  { 7,  1,   0}, // #7143
  { 8,  1,   0}, // #7144
  { 9,  1,   0}, // #7145
  {11,  4,   0}, // #7146
  {12,  4,   0}, // #7147
  { 4,  1,   0}, // #7148
  { 7,  1,   0}, // #7149
  { 9,  1,   0}, // #7150
  {10,  1,   0}, // #7151
  {11,  2,   0}, // #7152
  {12,  3,   0}, // #7153
  { 4,  1,   0}, // #7154
  { 7,  1,   0}, // #7155
  { 9,  1,   0}, // #7156
  {11,  2,   0}, // #7157
  {12,  2,   0}, // #7158
  { 4,  1,   0}, // #7159
  { 7,  1,   0}, // #7160
  { 8,  1,   0}, // #7161
  { 9,  1,   0}, // #7162
  {10,  1,   0}, // #7163
  {11,  3,   0}, // #7164
  {12,  4,   0}, // #7165
  { 4,  1,   0}, // #7166
  { 7,  1,   0}, // #7167
  { 8,  1,   0}, // #7168
  { 9,  1,   0}, // #7169
  {11,  3,   0}, // #7170
  {12,  3,   0}, // #7171
  { 3,  1,   0}, // #7172
  { 5,  1,   0}, // #7173
  { 6,  1,   0}, // #7174
  { 7,  1,   0}, // #7175
  { 8,  2,   0}, // #7176
  { 9,  1,   0}, // #7177
  {10,  1,   0}, // #7178
  {11,  2,   0}, // #7179
  {12,  4,   0}, // #7180
  { 6,  1,   0}, // #7181
  { 8,  1,   0}, // #7182
  { 9,  2,   0}, // #7183
  {11,  2,   0}, // #7184
  {12,  2,   0}, // #7185
  { 3,  1,   0}, // #7186
  { 7,  1,   0}, // #7187
  { 8,  1,   0}, // #7188
  { 9,  2,   0}, // #7189
  {10,  1,   0}, // #7190
  {11,  3,   0}, // #7191
  {12,  4,   0}, // #7192
  { 3,  1,   0}, // #7193
  { 7,  1,   0}, // #7194
  { 8,  1,   0}, // #7195
  { 9,  2,   0}, // #7196
  {11,  3,   0}, // #7197
  {12,  3,   0}, // #7198
  {10,  1,   0}, // #7199
  {11, 17,   0}, // #7200
  {12, 18,   0}, // #7201
  {11, 18,   0}, // #7202
  {12, 18,   0}, // #7203
  {10,  1,   0}, // #7204
  {11,  7,   0}, // #7205
  {12,  8,   0}, // #7206
  {11,  8,   0}, // #7207
  {12,  8,   0}, // #7208
  { 3,  3,   0}, // #7209
  { 7,  3,   0}, // #7210
  { 8,  3,   0}, // #7211
  {10,  1,   0}, // #7212
  {11,  3,   0}, // #7213
  {12,  4,   0}, // #7214
  { 3,  3,   0}, // #7215
  { 7,  3,   0}, // #7216
  { 8,  3,   0}, // #7217
  {11,  3,   0}, // #7218
  {12,  3,   0}, // #7219
  { 5,  1,   0}, // #7220
  {10,  2,   0}, // #7221
  {12,  3,   0}, // #7222
  { 3,  1,   0}, // #7223
  { 7,  1,   0}, // #7224
  { 8,  1,   0}, // #7225
  { 9,  1,   0}, // #7226
  {10,  1,   0}, // #7227
  {11,  2,   0}, // #7228
  {12,  3,   0}, // #7229
  { 3,  1,   0}, // #7230
  { 6,  1,   0}, // #7231
  { 7,  1,   0}, // #7232
  { 8,  2,   0}, // #7233
  { 9,  1,   0}, // #7234
  {10,  1,   0}, // #7235
  {11,  2,   0}, // #7236
  {12,  3,   0}, // #7237
  { 5,  1,   0}, // #7238
  { 8,  2,   0}, // #7239
  {10,  2,   0}, // #7240
  {11,  2,   0}, // #7241
  {12,  5,   0}, // #7242
  { 8,  4,   0}, // #7243
  {10,  1,   0}, // #7244
  {11,  4,   0}, // #7245
  {12,  5,   0}, // #7246
  { 5,  1,   0}, // #7247
  { 8,  3,   0}, // #7248
  {10,  2,   0}, // #7249
  {11,  3,   0}, // #7250
  {12,  6,   0}, // #7251
  { 8,  6,   0}, // #7252
  {10,  1,   0}, // #7253
  {11,  6,   0}, // #7254
  {12,  7,   0}, // #7255
  { 5,  1,   0}, // #7256
  { 8,  1,   0}, // #7257
  {10,  1,   0}, // #7258
  {11,  1,   0}, // #7259
  {12,  3,   0}, // #7260
  { 5,  1,   0}, // #7261
  { 8,  3,   0}, // #7262
  {10,  2,   0}, // #7263
  {11,  4,   0}, // #7264
  {12,  7,   0}, // #7265
  { 5,  1,   0}, // #7266
  { 8,  1,   0}, // #7267
  {10,  2,   0}, // #7268
  {11,  2,   0}, // #7269
  {12,  5,   0}, // #7270
  { 2, 21,   0}, // #7271
  { 3,  1,   0}, // #7272
  { 7,  1,   0}, // #7273
  { 8,  1,   0}, // #7274
  {10,  1,   0}, // #7275
  {11,  1,   0}, // #7276
  {12,  2,   0}, // #7277
  { 2, 21,   0}, // #7278
  { 3,  1,   0}, // #7279
  { 7,  1,   0}, // #7280
  { 8,  1,   0}, // #7281
  {11,  1,   0}, // #7282
  {12,  1,   0}, // #7283
  { 2, 24,   0}, // #7284
  { 3,  1,   0}, // #7285
  { 7,  1,   0}, // #7286
  { 8,  1,   0}, // #7287
  {11,  1,   0}, // #7288
  {12,  1,   0}, // #7289
  { 7,  1,   0}, // #7290
  {10,  1,   0}, // #7291
  {11,  1,   0}, // #7292
  {12,  2,   0}, // #7293
  { 3,  1,   0}, // #7294
  { 4,  1,   0}, // #7295
  { 5,  1,   0}, // #7296
  { 7,  2,   0}, // #7297
  { 8,  1,   0}, // #7298
  { 9,  1,   0}, // #7299
  {10,  1,   0}, // #7300
  {11,  2,   0}, // #7301
  {12,  4,   0}, // #7302
  { 2, 28,   0}, // #7303
  { 3,  2,   0}, // #7304
  { 7,  2,   0}, // #7305
  { 8,  3,   0}, // #7306
  {10,  1,   0}, // #7307
  {11,  3,   0}, // #7308
  {12,  4,   0}, // #7309
  { 2, 28,   0}, // #7310
  { 3,  2,   0}, // #7311
  { 7,  2,   0}, // #7312
  { 8,  3,   0}, // #7313
  {11,  3,   0}, // #7314
  {12,  3,   0}, // #7315
  { 2, 44,   0}, // #7316
  { 3,  2,   0}, // #7317
  { 7,  2,   0}, // #7318
  { 8,  3,   0}, // #7319
  {10,  1,   0}, // #7320
  {11,  3,   0}, // #7321
  {12,  4,   0}, // #7322
  { 2, 44,   0}, // #7323
  { 3,  2,   0}, // #7324
  { 7,  2,   0}, // #7325
  { 8,  3,   0}, // #7326
  {11,  3,   0}, // #7327
  {12,  3,   0}, // #7328
  { 5,  1,   0}, // #7329
  { 7,  2,   0}, // #7330
  {10,  1,   0}, // #7331
  {11,  2,   0}, // #7332
  {12,  4,   0}, // #7333
  { 8,  7,   0}, // #7334
  {10,  4,   0}, // #7335
  {11,  7,   0}, // #7336
  {12, 11,   0}, // #7337
  { 5,  1,   0}, // #7338
  {10,  2,   0}, // #7339
  {11,  2,   0}, // #7340
  {12,  5,   0}, // #7341
  { 6,  1,   0}, // #7342
  { 7,  1,   0}, // #7343
  { 8,  1,   0}, // #7344
  { 9,  1,   0}, // #7345
  {10,  1,   0}, // #7346
  {11,  2,   0}, // #7347
  {12,  3,   0}, // #7348
  { 5,  1,   0}, // #7349
  { 6,  2,   0}, // #7350
  { 8,  2,   0}, // #7351
  { 9,  2,   0}, // #7352
  {10,  2,   0}, // #7353
  {11,  2,   0}, // #7354
  {12,  5,   0}, // #7355
  { 4,  1,   0}, // #7356
  { 5,  1,   0}, // #7357
  { 7,  1,   0}, // #7358
  { 9,  1,   0}, // #7359
  {10,  2,   0}, // #7360
  {11,  1,   0}, // #7361
  {12,  4,   0}, // #7362
  { 4,  1,   0}, // #7363
  { 6,  3,   0}, // #7364
  { 7,  1,   0}, // #7365
  { 8,  5,   0}, // #7366
  { 9,  4,   0}, // #7367
  {11, 12,   0}, // #7368
  {12, 12,   0}, // #7369
  { 5,  1,   0}, // #7370
  { 6,  1,   0}, // #7371
  { 8,  1,   0}, // #7372
  { 9,  1,   0}, // #7373
  {10,  2,   0}, // #7374
  {11,  1,   0}, // #7375
  {12,  4,   0}, // #7376
  { 6,  1,   0}, // #7377
  { 8,  1,   0}, // #7378
  { 9,  1,   0}, // #7379
  {11,  4,   0}, // #7380
  {12,  4,   0}, // #7381
  { 4,  1,   0}, // #7382
  { 6,  3,   0}, // #7383
  { 7,  1,   0}, // #7384
  { 8,  3,   0}, // #7385
  { 9,  4,   0}, // #7386
  {11,  8,   0}, // #7387
  {12,  8,   0}, // #7388
  { 5,  1,   0}, // #7389
  { 6,  2,   0}, // #7390
  { 7,  1,   0}, // #7391
  { 8,  2,   0}, // #7392
  { 9,  2,   0}, // #7393
  {10,  1,   0}, // #7394
  {11,  3,   0}, // #7395
  {12,  5,   0}, // #7396
  { 3,  1,   0}, // #7397
  { 7,  1,   0}, // #7398
  { 8,  1,   0}, // #7399
  {11,  2,   0}, // #7400
  {12,  2,   0}, // #7401
  { 8,  2,   0}, // #7402
  {11,  3,   0}, // #7403
  {12,  3,   0}, // #7404
  { 4,  1,   0}, // #7405
  { 6,  1,   0}, // #7406
  { 7,  1,   0}, // #7407
  { 8,  5,   0}, // #7408
  { 9,  2,   0}, // #7409
  {11,  8,   0}, // #7410
  {12,  8,   0}, // #7411
  { 8,  8,   0}, // #7412
  {11,  8,   0}, // #7413
  {12,  8,   0}, // #7414
  { 4,  1,   0}, // #7415
  { 5,  1,   0}, // #7416
  { 7,  1,   0}, // #7417
  { 9,  1,   0}, // #7418
  {10,  1,   0}, // #7419
  {11,  1,   0}, // #7420
  {12,  3,   0}, // #7421
  { 5,  1,   0}, // #7422
  { 6,  1,   0}, // #7423
  { 8,  1,   0}, // #7424
  { 9,  1,   0}, // #7425
  {10,  1,   0}, // #7426
  {11,  1,   0}, // #7427
  {12,  3,   0}, // #7428
  { 5,  1,   0}, // #7429
  {10,  1,   0}, // #7430
  {11,  1,   0}, // #7431
  {12,  3,   0}, // #7432
  { 3,  1,   0}, // #7433
  { 5,  1,   0}, // #7434
  { 7,  1,   0}, // #7435
  { 8,  1,   0}, // #7436
  { 9,  1,   0}, // #7437
  {10,  1,   0}, // #7438
  {11,  2,   0}, // #7439
  {12,  4,   0}, // #7440
  { 5,  1,   0}, // #7441
  { 6,  1,   0}, // #7442
  { 7,  1,   0}, // #7443
  { 8,  1,   0}, // #7444
  { 9,  1,   0}, // #7445
  {10,  1,   0}, // #7446
  {11,  2,   0}, // #7447
  {12,  4,   0}, // #7448
  { 3,  1,   0}, // #7449
  { 5,  1,   0}, // #7450
  { 7,  1,   0}, // #7451
  { 8,  1,   0}, // #7452
  {10,  2,   0}, // #7453
  {11,  1,   0}, // #7454
  {12,  4,   0}, // #7455
  { 4,  1,   0}, // #7456
  { 6,  2,   0}, // #7457
  { 7,  1,   0}, // #7458
  { 8,  2,   0}, // #7459
  { 9,  3,   0}, // #7460
  {11,  4,   0}, // #7461
  {12,  4,   0}, // #7462
  {10,  2,   0}, // #7463
  {11,  3,   0}, // #7464
  {12,  5,   0}, // #7465
  { 5,  1,   0}, // #7466
  { 6,  1,   0}, // #7467
  { 7,  1,   0}, // #7468
  { 8,  1,   0}, // #7469
  { 9,  1,   0}, // #7470
  {10,  2,   0}, // #7471
  {11,  2,   0}, // #7472
  {12,  5,   0}, // #7473
  { 5,  1,   0}, // #7474
  { 8,  2,   0}, // #7475
  {10,  2,   0}, // #7476
  {11,  3,   0}, // #7477
  {12,  6,   0}, // #7478
  { 4,  2,   0}, // #7479
  { 7,  2,   0}, // #7480
  { 9,  2,   0}, // #7481
  {10,  1,   0}, // #7482
  {11,  2,   0}, // #7483
  {12,  3,   0}, // #7484
  { 8,  2,   0}, // #7485
  {10,  1,   0}, // #7486
  {11,  3,   0}, // #7487
  {12,  4,   0}, // #7488
  { 5,  1,   0}, // #7489
  { 8,  2,   0}, // #7490
  {10,  1,   0}, // #7491
  {11,  2,   0}, // #7492
  {12,  4,   0}, // #7493
  { 3,  1,   0}, // #7494
  { 4,  1,   0}, // #7495
  { 8,  1,   0}, // #7496
  { 9,  1,   0}, // #7497
  {11,  2,   0}, // #7498
  {12,  1,   0}, // #7499
  {13,  2,   0}, // #7500
  {14,  2,   0}, // #7501
  {15,  2,   0}, // #7502
  {16,  2,   0}, // #7503
  {18,  2,   0}, // #7504
  {19,  3,   0}, // #7505
  {20,  3,   0}, // #7506
  {22,  4,   0}, // #7507
  {23,  4,   0}, // #7508
  { 4,  1,   0}, // #7509
  { 9,  1,   0}, // #7510
  {11,  1,   0}, // #7511
  {14,  1,   0}, // #7512
  {15,  1,   0}, // #7513
  {16,  2,   0}, // #7514
  {17,  1,   0}, // #7515
  {18,  1,   0}, // #7516
  {19,  1,   0}, // #7517
  {20,  1,   0}, // #7518
  {21,  1,   0}, // #7519
  {22,  2,   0}, // #7520
  {23,  3,   0}, // #7521
  { 4,  1,   0}, // #7522
  { 9,  1,   0}, // #7523
  {11,  1,   0}, // #7524
  {14,  1,   0}, // #7525
  {15,  1,   0}, // #7526
  {16,  2,   0}, // #7527
  {18,  1,   0}, // #7528
  {19,  1,   0}, // #7529
  {20,  1,   0}, // #7530
  {22,  2,   0}, // #7531
  {23,  2,   0}, // #7532
  { 2, 17,   0}, // #7533
  { 3,  1,   0}, // #7534
  {11,  1,   0}, // #7535
  {12,  1,   0}, // #7536
  {13,  1,   0}, // #7537
  {14,  1,   0}, // #7538
  {19,  1,   0}, // #7539
  {20,  1,   0}, // #7540
  {22,  1,   0}, // #7541
  {23,  1,   0}, // #7542
  { 4,  1,   0}, // #7543
  { 7,  1,   0}, // #7544
  { 8,  1,   0}, // #7545
  {11,  1,   0}, // #7546
  {12,  1,   0}, // #7547
  {13,  1,   0}, // #7548
  {15,  2,   0}, // #7549
  {16,  1,   0}, // #7550
  {18,  1,   0}, // #7551
  {19,  2,   0}, // #7552
  {20,  1,   0}, // #7553
  {21,  1,   0}, // #7554
  {22,  2,   0}, // #7555
  {23,  4,   0}, // #7556
  { 2, 14,   0}, // #7557
  { 3,  2,   0}, // #7558
  {11,  2,   0}, // #7559
  {12,  2,   0}, // #7560
  {13,  2,   0}, // #7561
  {14,  2,   0}, // #7562
  {15,  1,   0}, // #7563
  {17,  1,   0}, // #7564
  {19,  3,   0}, // #7565
  {20,  2,   0}, // #7566
  {21,  1,   0}, // #7567
  {22,  3,   0}, // #7568
  {23,  4,   0}, // #7569
  { 2, 14,   0}, // #7570
  { 3,  2,   0}, // #7571
  {11,  2,   0}, // #7572
  {12,  2,   0}, // #7573
  {13,  2,   0}, // #7574
  {14,  2,   0}, // #7575
  {15,  1,   0}, // #7576
  {19,  3,   0}, // #7577
  {20,  2,   0}, // #7578
  {22,  3,   0}, // #7579
  {23,  3,   0}, // #7580
  { 2, 28,   0}, // #7581
  { 3,  2,   0}, // #7582
  {11,  2,   0}, // #7583
  {12,  2,   0}, // #7584
  {13,  2,   0}, // #7585
  {14,  2,   0}, // #7586
  {15,  1,   0}, // #7587
  {17,  1,   0}, // #7588
  {19,  3,   0}, // #7589
  {20,  2,   0}, // #7590
  {21,  1,   0}, // #7591
  {22,  3,   0}, // #7592
  {23,  4,   0}, // #7593
  { 2, 28,   0}, // #7594
  { 3,  2,   0}, // #7595
  {11,  2,   0}, // #7596
  {12,  2,   0}, // #7597
  {13,  2,   0}, // #7598
  {14,  2,   0}, // #7599
  {15,  1,   0}, // #7600
  {19,  3,   0}, // #7601
  {20,  2,   0}, // #7602
  {22,  3,   0}, // #7603
  {23,  3,   0}, // #7604
  { 3,  2,   0}, // #7605
  { 4,  1,   0}, // #7606
  { 8,  2,   0}, // #7607
  { 9,  4,   0}, // #7608
  {11,  5,   0}, // #7609
  {12,  2,   0}, // #7610
  {13,  4,   0}, // #7611
  {14,  6,   0}, // #7612
  {15,  3,   0}, // #7613
  {16,  5,   0}, // #7614
  {18,  6,   0}, // #7615
  {19,  7,   0}, // #7616
  {20,  8,   0}, // #7617
  {22, 15,   0}, // #7618
  {23, 15,   0}, // #7619
  { 7,  1,   0}, // #7620
  {12,  1,   0}, // #7621
  {17,  2,   0}, // #7622
  {21,  2,   0}, // #7623
  {22,  2,   0}, // #7624
  {23,  5,   0}, // #7625
  {17,  1,   0}, // #7626
  {21,  1,   0}, // #7627
  {22, 14,   0}, // #7628
  {23, 15,   0}, // #7629
  {17,  2,   0}, // #7630
  {21,  2,   0}, // #7631
  {22,  3,   0}, // #7632
  {23,  5,   0}, // #7633
  { 9,  2,   0}, // #7634
  {14,  2,   0}, // #7635
  {16,  2,   0}, // #7636
  {17,  1,   0}, // #7637
  {18,  2,   0}, // #7638
  {19,  1,   0}, // #7639
  {20,  2,   0}, // #7640
  {21,  1,   0}, // #7641
  {22,  3,   0}, // #7642
  {23,  4,   0}, // #7643
  {17,  1,   0}, // #7644
  {19, 16,   0}, // #7645
  {21,  1,   0}, // #7646
  {22, 16,   0}, // #7647
  {23, 17,   0}, // #7648
  { 3,  2,   0}, // #7649
  { 8,  2,   0}, // #7650
  {11,  2,   0}, // #7651
  {12,  2,   0}, // #7652
  {13,  4,   0}, // #7653
  {14,  4,   0}, // #7654
  {15,  3,   0}, // #7655
  {17,  2,   0}, // #7656
  {18,  2,   0}, // #7657
  {19,  8,   0}, // #7658
  {20,  6,   0}, // #7659
  {21,  2,   0}, // #7660
  {22, 10,   0}, // #7661
  {23, 12,   0}, // #7662
  { 3,  3,   0}, // #7663
  { 8,  3,   0}, // #7664
  {11,  3,   0}, // #7665
  {12,  3,   0}, // #7666
  {13,  6,   0}, // #7667
  {14,  7,   0}, // #7668
  {15,  4,   0}, // #7669
  {17,  4,   0}, // #7670
  {18,  3,   0}, // #7671
  {19, 12,   0}, // #7672
  {20, 10,   0}, // #7673
  {21,  4,   0}, // #7674
  {22, 16,   0}, // #7675
  {23, 20,   0}, // #7676
  { 3,  5,   0}, // #7677
  { 8,  3,   0}, // #7678
  {11,  5,   0}, // #7679
  {12,  5,   0}, // #7680
  {13,  8,   0}, // #7681
  {14, 13,   0}, // #7682
  {15,  4,   0}, // #7683
  {17,  8,   0}, // #7684
  {18,  3,   0}, // #7685
  {19, 18,   0}, // #7686
  {20, 16,   0}, // #7687
  {21,  8,   0}, // #7688
  {22, 26,   0}, // #7689
  {23, 34,   0}, // #7690
  { 3,  3,   0}, // #7691
  { 8,  3,   0}, // #7692
  {11,  3,   0}, // #7693
  {12,  3,   0}, // #7694
  {13,  6,   0}, // #7695
  {14,  5,   0}, // #7696
  {15,  4,   0}, // #7697
  {17,  2,   0}, // #7698
  {18,  3,   0}, // #7699
  {19, 10,   0}, // #7700
  {20,  8,   0}, // #7701
  {21,  2,   0}, // #7702
  {22, 12,   0}, // #7703
  {23, 14,   0}, // #7704
  { 3,  5,   0}, // #7705
  { 8,  3,   0}, // #7706
  {11,  5,   0}, // #7707
  {12,  5,   0}, // #7708
  {13,  8,   0}, // #7709
  {14,  9,   0}, // #7710
  {15,  4,   0}, // #7711
  {17,  4,   0}, // #7712
  {18,  3,   0}, // #7713
  {19, 14,   0}, // #7714
  {20, 12,   0}, // #7715
  {21,  4,   0}, // #7716
  {22, 18,   0}, // #7717
  {23, 22,   0}, // #7718
  { 3,  3,   0}, // #7719
  { 8,  3,   0}, // #7720
  {11,  3,   0}, // #7721
  {12,  3,   0}, // #7722
  {13,  6,   0}, // #7723
  {14,  5,   0}, // #7724
  {15,  4,   0}, // #7725
  {17,  2,   0}, // #7726
  {18,  3,   0}, // #7727
  {19, 11,   0}, // #7728
  {20,  8,   0}, // #7729
  {21,  2,   0}, // #7730
  {22, 13,   0}, // #7731
  {23, 15,   0}, // #7732
  {14,  1,   0}, // #7733
  {17,  1,   0}, // #7734
  {20,  1,   0}, // #7735
  {21,  1,   0}, // #7736
  {22,  3,   0}, // #7737
  {23,  4,   0}, // #7738
  { 4,  2,   0}, // #7739
  { 5,  3,   0}, // #7740
  { 7,  2,   0}, // #7741
  { 8,  2,   0}, // #7742
  {14,  2,   0}, // #7743
  {15,  1,   0}, // #7744
  {18,  1,   0}, // #7745
  {23,  1,   0}, // #7746
  {28,  6,   0}, // #7747
  { 4,  1,   0}, // #7748
  { 5,  1,   0}, // #7749
  { 7,  1,   0}, // #7750
  { 8,  1,   0}, // #7751
  {14,  1,   0}, // #7752
  {15,  1,   0}, // #7753
  {28,  2,   0}, // #7754
  {14,  1,   0}, // #7755
  {18,  1,   0}, // #7756
  {23,  1,   0}, // #7757
  {28,  2,   0}, // #7758
  {14,  1,   0}, // #7759
  {15,  1,   0}, // #7760
  {28,  1,   0}, // #7761
  {14,  2,   0}, // #7762
  {15,  1,   0}, // #7763
  {18,  1,   0}, // #7764
  {23,  1,   0}, // #7765
  {28,  3,   0}, // #7766
  { 5,  1,   0}, // #7767
  {14,  2,   0}, // #7768
  {15,  1,   0}, // #7769
  {18,  1,   0}, // #7770
  {23,  1,   0}, // #7771
  {28,  4,   0}, // #7772
  { 4,  1,   0}, // #7773
  { 5,  2,   0}, // #7774
  { 7,  1,   0}, // #7775
  { 8,  1,   0}, // #7776
  {14,  2,   0}, // #7777
  {15,  1,   0}, // #7778
  {18,  1,   0}, // #7779
  {23,  1,   0}, // #7780
  {28,  5,   0}, // #7781
  { 3,  1,   0}, // #7782
  { 4,  1,   0}, // #7783
  { 5,  1,   0}, // #7784
  {10,  1,   0}, // #7785
  {11,  1,   0}, // #7786
  {14,  1,   0}, // #7787
  {15,  1,   0}, // #7788
  {28,  2,   0}, // #7789
  { 2,  1,   0}, // #7790
  { 3,  1,   0}, // #7791
  { 4,  1,   0}, // #7792
  { 5,  1,   0}, // #7793
  {14,  1,   0}, // #7794
  {15,  1,   0}, // #7795
  {28,  2,   0}, // #7796
  { 2,  2,   0}, // #7797
  { 3,  2,   0}, // #7798
  { 4,  2,   0}, // #7799
  { 5,  2,   0}, // #7800
  {14,  1,   0}, // #7801
  {15,  1,   0}, // #7802
  {28,  3,   0}, // #7803
  { 1,  4,   0}, // #7804
  { 2,  5,   0}, // #7805
  { 3, 11,   0}, // #7806
  { 4, 13,   0}, // #7807
  { 5, 13,   0}, // #7808
  { 6,  7,   0}, // #7809
  { 7,  9,   0}, // #7810
  { 8,  6,   0}, // #7811
  {10,  6,   0}, // #7812
  {11,  6,   0}, // #7813
  {14,  1,   0}, // #7814
  {15,  1,   0}, // #7815
  {19,  3,   0}, // #7816
  {20,  3,   0}, // #7817
  {28, 14,   0}, // #7818
  { 1,  4,   0}, // #7819
  { 2,  5,   0}, // #7820
  { 3, 12,   0}, // #7821
  { 4, 14,   0}, // #7822
  { 5, 14,   0}, // #7823
  { 6,  7,   0}, // #7824
  { 7,  9,   0}, // #7825
  { 8,  6,   0}, // #7826
  {10,  6,   0}, // #7827
  {11,  6,   0}, // #7828
  {19,  3,   0}, // #7829
  {20,  3,   0}, // #7830
  {28, 14,   0}, // #7831
  { 2,  1,   0}, // #7832
  { 3,  1,   0}, // #7833
  { 4,  2,   0}, // #7834
  { 5,  2,   0}, // #7835
  { 7,  1,   0}, // #7836
  { 8,  1,   0}, // #7837
  { 9,  1,   0}, // #7838
  {10,  1,   0}, // #7839
  {11,  1,   0}, // #7840
  {14,  1,   0}, // #7841
  {15,  1,   0}, // #7842
  {28,  3,   0}, // #7843
  { 5,  1,   0}, // #7844
  {11,  1,   0}, // #7845
  {14,  1,   0}, // #7846
  {15,  1,   0}, // #7847
  {28,  2,   0}, // #7848
  { 2,  1,   0}, // #7849
  { 3,  1,   0}, // #7850
  { 4,  1,   0}, // #7851
  { 5,  1,   0}, // #7852
  { 9,  1,   0}, // #7853
  {10,  1,   0}, // #7854
  {11,  1,   0}, // #7855
  {14,  1,   0}, // #7856
  {15,  1,   0}, // #7857
  {28,  2,   0}, // #7858
  { 2,  1,   0}, // #7859
  { 3,  1,   0}, // #7860
  { 4,  3,   0}, // #7861
  { 5,  9,   0}, // #7862
  { 7,  2,   0}, // #7863
  { 8,  2,   0}, // #7864
  { 9,  1,   0}, // #7865
  {10,  1,   0}, // #7866
  {11,  3,   0}, // #7867
  {14,  1,   0}, // #7868
  {15,  1,   0}, // #7869
  {28, 10,   0}, // #7870
  { 2,  1,   0}, // #7871
  { 3,  1,   0}, // #7872
  { 4,  1,   0}, // #7873
  { 5,  1,   0}, // #7874
  { 9,  1,   0}, // #7875
  {10,  1,   0}, // #7876
  {11,  1,   0}, // #7877
  {14,  2,   0}, // #7878
  {15,  1,   0}, // #7879
  {18,  1,   0}, // #7880
  {23,  1,   0}, // #7881
  {28,  4,   0}, // #7882
  { 2,  1,   0}, // #7883
  { 3,  1,   0}, // #7884
  { 4,  3,   0}, // #7885
  { 5,  8,   0}, // #7886
  { 7,  2,   0}, // #7887
  { 8,  2,   0}, // #7888
  { 9,  1,   0}, // #7889
  {10,  1,   0}, // #7890
  {11,  3,   0}, // #7891
  {14,  2,   0}, // #7892
  {15,  1,   0}, // #7893
  {18,  1,   0}, // #7894
  {23,  1,   0}, // #7895
  {28, 11,   0}, // #7896
  { 1,  1,   0}, // #7897
  { 2,  1,   0}, // #7898
  { 3,  1,   0}, // #7899
  { 4,  1,   0}, // #7900
  { 5,  1,   0}, // #7901
  { 6,  1,   0}, // #7902
  { 7,  1,   0}, // #7903
  { 8,  1,   0}, // #7904
  {14,  1,   0}, // #7905
  {15,  1,   0}, // #7906
  {28,  2,   0}, // #7907
  { 3,  1,   0}, // #7908
  { 4,  1,   0}, // #7909
  { 5,  1,   0}, // #7910
  { 6,  1,   0}, // #7911
  { 7,  1,   0}, // #7912
  {10,  1,   0}, // #7913
  {11,  1,   0}, // #7914
  {19,  1,   0}, // #7915
  {20,  1,   0}, // #7916
  {28,  1,   0}, // #7917
  { 2,  1,   0}, // #7918
  { 3,  2,   0}, // #7919
  { 4,  2,   0}, // #7920
  { 5,  2,   0}, // #7921
  { 6,  1,   0}, // #7922
  { 7,  1,   0}, // #7923
  {10,  1,   0}, // #7924
  {11,  1,   0}, // #7925
  {19,  1,   0}, // #7926
  {20,  1,   0}, // #7927
  {28,  2,   0}, // #7928
  { 2,  1,   0}, // #7929
  { 3,  2,   0}, // #7930
  { 4,  2,   0}, // #7931
  { 5,  2,   0}, // #7932
  { 6,  1,   0}, // #7933
  { 7,  1,   0}, // #7934
  {10,  1,   0}, // #7935
  {11,  1,   0}, // #7936
  {14,  1,   0}, // #7937
  {15,  1,   0}, // #7938
  {19,  1,   0}, // #7939
  {20,  1,   0}, // #7940
  {28,  3,   0}, // #7941
  { 1,  1,   0}, // #7942
  { 2,  2,   0}, // #7943
  { 3,  2,   0}, // #7944
  { 4,  2,   0}, // #7945
  { 5,  2,   0}, // #7946
  { 6,  1,   0}, // #7947
  { 7,  1,   0}, // #7948
  { 8,  1,   0}, // #7949
  {14,  1,   0}, // #7950
  {15,  1,   0}, // #7951
  {28,  3,   0}, // #7952
  { 2,  1,   0}, // #7953
  { 3,  3,   0}, // #7954
  { 4,  3,   0}, // #7955
  { 5,  3,   0}, // #7956
  { 6,  1,   0}, // #7957
  { 7,  1,   0}, // #7958
  {10,  1,   0}, // #7959
  {11,  1,   0}, // #7960
  {19,  1,   0}, // #7961
  {20,  1,   0}, // #7962
  {28,  3,   0}, // #7963
  { 2,  3,   0}, // #7964
  { 3,  3,   0}, // #7965
  { 4,  3,   0}, // #7966
  { 5,  4,   0}, // #7967
  { 9,  3,   0}, // #7968
  {10,  3,   0}, // #7969
  {11,  3,   0}, // #7970
  {14,  1,   0}, // #7971
  {15,  1,   0}, // #7972
  {28,  5,   0}, // #7973
  { 2,  3,   0}, // #7974
  { 3,  3,   0}, // #7975
  { 4,  3,   0}, // #7976
  { 5,  3,   0}, // #7977
  { 9,  3,   0}, // #7978
  {10,  3,   0}, // #7979
  {11,  3,   0}, // #7980
  {14,  1,   0}, // #7981
  {15,  1,   0}, // #7982
  {28,  4,   0}, // #7983
  { 2,  2,   0}, // #7984
  { 3,  3,   0}, // #7985
  { 4,  3,   0}, // #7986
  { 5,  3,   0}, // #7987
  {10,  1,   0}, // #7988
  {11,  1,   0}, // #7989
  {14,  1,   0}, // #7990
  {15,  1,   0}, // #7991
  {28,  4,   0}, // #7992
  { 2,  2,   0}, // #7993
  { 3,  5,   0}, // #7994
  { 4,  6,   0}, // #7995
  { 5,  6,   0}, // #7996
  { 6,  1,   0}, // #7997
  { 7,  2,   0}, // #7998
  { 8,  1,   0}, // #7999
  {10,  3,   0}, // #8000
  {11,  3,   0}, // #8001
  {14,  1,   0}, // #8002
  {15,  1,   0}, // #8003
  {19,  1,   0}, // #8004
  {20,  1,   0}, // #8005
  {28,  7,   0}, // #8006
  { 2,  2,   0}, // #8007
  { 3,  5,   0}, // #8008
  { 4,  6,   0}, // #8009
  { 5,  6,   0}, // #8010
  { 6,  1,   0}, // #8011
  { 7,  2,   0}, // #8012
  { 8,  1,   0}, // #8013
  {10,  3,   0}, // #8014
  {11,  3,   0}, // #8015
  {19,  1,   0}, // #8016
  {20,  1,   0}, // #8017
  {28,  6,   0}, // #8018
  { 3,  1,   0}, // #8019
  { 4,  1,   0}, // #8020
  { 5,  1,   0}, // #8021
  {10,  1,   0}, // #8022
  {11,  1,   0}, // #8023
  {14,  1,   0}, // #8024
  {18,  1,   0}, // #8025
  {23,  1,   0}, // #8026
  {28,  3,   0}, // #8027
  { 3,  1,   0}, // #8028
  { 4,  1,   0}, // #8029
  { 5,  1,   0}, // #8030
  { 6,  1,   0}, // #8031
  { 7,  1,   0}, // #8032
  {10,  1,   0}, // #8033
  {11,  1,   0}, // #8034
  {14,  1,   0}, // #8035
  {15,  1,   0}, // #8036
  {19,  1,   0}, // #8037
  {20,  1,   0}, // #8038
  {28,  2,   0}, // #8039
  { 3,  3,   0}, // #8040
  { 4,  3,   0}, // #8041
  { 5,  3,   0}, // #8042
  { 6,  2,   0}, // #8043
  { 7,  2,   0}, // #8044
  {10,  3,   0}, // #8045
  {11,  3,   0}, // #8046
  {14,  1,   0}, // #8047
  {15,  1,   0}, // #8048
  {19,  2,   0}, // #8049
  {20,  2,   0}, // #8050
  {28,  4,   0}, // #8051
  { 3,  3,   0}, // #8052
  { 4,  3,   0}, // #8053
  { 5,  3,   0}, // #8054
  { 6,  2,   0}, // #8055
  { 7,  2,   0}, // #8056
  {10,  3,   0}, // #8057
  {11,  3,   0}, // #8058
  {19,  2,   0}, // #8059
  {20,  2,   0}, // #8060
  {28,  3,   0}, // #8061
  { 2,  1,   0}, // #8062
  { 3,  1,   0}, // #8063
  { 4,  2,   0}, // #8064
  { 5,  4,   0}, // #8065
  { 7,  1,   0}, // #8066
  { 8,  1,   0}, // #8067
  { 9,  1,   0}, // #8068
  {10,  1,   0}, // #8069
  {11,  1,   0}, // #8070
  {14,  1,   0}, // #8071
  {15,  1,   0}, // #8072
  {28,  5,   0}, // #8073
  { 2,  1,   0}, // #8074
  { 3,  1,   0}, // #8075
  { 4,  1,   0}, // #8076
  { 5,  2,   0}, // #8077
  { 9,  1,   0}, // #8078
  {10,  1,   0}, // #8079
  {11,  1,   0}, // #8080
  {14,  1,   0}, // #8081
  {15,  1,   0}, // #8082
  {28,  3,   0}, // #8083
  { 2,  1,   0}, // #8084
  { 3,  1,   0}, // #8085
  { 4,  2,   0}, // #8086
  { 5,  3,   0}, // #8087
  { 7,  1,   0}, // #8088
  { 8,  1,   0}, // #8089
  { 9,  1,   0}, // #8090
  {10,  1,   0}, // #8091
  {11,  1,   0}, // #8092
  {14,  1,   0}, // #8093
  {15,  1,   0}, // #8094
  {28,  4,   0}, // #8095
  { 2,  1,   0}, // #8096
  { 3,  2,   0}, // #8097
  { 4,  2,   0}, // #8098
  { 5,  2,   0}, // #8099
  { 6,  1,   0}, // #8100
  { 7,  1,   0}, // #8101
  { 9,  1,   0}, // #8102
  {10,  2,   0}, // #8103
  {11,  2,   0}, // #8104
  {14,  1,   0}, // #8105
  {15,  1,   0}, // #8106
  {19,  1,   0}, // #8107
  {20,  1,   0}, // #8108
  {28,  3,   0}, // #8109
  { 2,  1,   0}, // #8110
  { 3,  2,   0}, // #8111
  { 4,  2,   0}, // #8112
  { 5,  2,   0}, // #8113
  { 6,  1,   0}, // #8114
  { 7,  1,   0}, // #8115
  { 9,  1,   0}, // #8116
  {10,  2,   0}, // #8117
  {11,  2,   0}, // #8118
  {19,  1,   0}, // #8119
  {20,  1,   0}, // #8120
  {28,  2,   0}, // #8121
  { 1,  1,   0}, // #8122
  { 2,  1,   0}, // #8123
  { 3,  2,   0}, // #8124
  { 4,  3,   0}, // #8125
  { 5,  3,   0}, // #8126
  { 6,  1,   0}, // #8127
  { 7,  2,   0}, // #8128
  { 8,  2,   0}, // #8129
  {14,  1,   0}, // #8130
  {15,  1,   0}, // #8131
  {28,  4,   0}, // #8132
  { 3,  1,   0}, // #8133
  { 4,  1,   0}, // #8134
  { 5,  1,   0}, // #8135
  { 6,  1,   0}, // #8136
  { 7,  1,   0}, // #8137
  {14,  1,   0}, // #8138
  {15,  1,   0}, // #8139
  {28,  2,   0}, // #8140
  { 3,  3,   0}, // #8141
  { 4,  3,   0}, // #8142
  { 5,  3,   0}, // #8143
  { 6,  3,   0}, // #8144
  { 7,  3,   0}, // #8145
  {10,  2,   0}, // #8146
  {11,  2,   0}, // #8147
  {14,  1,   0}, // #8148
  {15,  1,   0}, // #8149
  {19,  2,   0}, // #8150
  {20,  2,   0}, // #8151
  {28,  4,   0}, // #8152
  { 3,  3,   0}, // #8153
  { 4,  3,   0}, // #8154
  { 5,  3,   0}, // #8155
  { 6,  3,   0}, // #8156
  { 7,  3,   0}, // #8157
  {10,  2,   0}, // #8158
  {11,  2,   0}, // #8159
  {19,  2,   0}, // #8160
  {20,  2,   0}, // #8161
  {28,  3,   0}, // #8162
  { 3,  2,   0}, // #8163
  { 4,  2,   0}, // #8164
  { 5,  2,   0}, // #8165
  { 6,  1,   0}, // #8166
  { 7,  1,   0}, // #8167
  {10,  2,   0}, // #8168
  {11,  2,   0}, // #8169
  {19,  1,   0}, // #8170
  {20,  1,   0}, // #8171
  {28,  2,   0}, // #8172
  { 1,  1,   0}, // #8173
  { 2,  1,   0}, // #8174
  { 3,  2,   0}, // #8175
  { 4,  2,   0}, // #8176
  { 5,  2,   0}, // #8177
  { 6,  2,   0}, // #8178
  { 7,  2,   0}, // #8179
  { 8,  1,   0}, // #8180
  {10,  1,   0}, // #8181
  {11,  1,   0}, // #8182
  {14,  1,   0}, // #8183
  {15,  1,   0}, // #8184
  {19,  1,   0}, // #8185
  {20,  1,   0}, // #8186
  {28,  3,   0}, // #8187
  { 1,  1,   0}, // #8188
  { 2,  1,   0}, // #8189
  { 3,  2,   0}, // #8190
  { 4,  2,   0}, // #8191
  { 5,  2,   0}, // #8192
  { 6,  2,   0}, // #8193
  { 7,  2,   0}, // #8194
  { 8,  1,   0}, // #8195
  {10,  1,   0}, // #8196
  {11,  1,   0}, // #8197
  {19,  1,   0}, // #8198
  {20,  1,   0}, // #8199
  {28,  2,   0}, // #8200
  { 3,  2,   0}, // #8201
  { 4,  2,   0}, // #8202
  { 5,  2,   0}, // #8203
  { 6,  1,   0}, // #8204
  { 7,  1,   0}, // #8205
  {10,  2,   0}, // #8206
  {11,  2,   0}, // #8207
  {14,  1,   0}, // #8208
  {15,  1,   0}, // #8209
  {19,  1,   0}, // #8210
  {20,  1,   0}, // #8211
  {28,  3,   0}, // #8212
  { 1,  3,   0}, // #8213
  { 2,  4,   0}, // #8214
  { 3,  6,   0}, // #8215
  { 4,  7,   0}, // #8216
  { 5,  7,   0}, // #8217
  { 6,  4,   0}, // #8218
  { 7,  5,   0}, // #8219
  { 8,  4,   0}, // #8220
  { 9,  1,   0}, // #8221
  {10,  2,   0}, // #8222
  {11,  2,   0}, // #8223
  {14,  1,   0}, // #8224
  {15,  1,   0}, // #8225
  {19,  1,   0}, // #8226
  {20,  1,   0}, // #8227
  {28,  8,   0}, // #8228
  { 1,  3,   0}, // #8229
  { 2,  4,   0}, // #8230
  { 3,  7,   0}, // #8231
  { 4,  8,   0}, // #8232
  { 5,  8,   0}, // #8233
  { 6,  4,   0}, // #8234
  { 7,  5,   0}, // #8235
  { 8,  4,   0}, // #8236
  { 9,  1,   0}, // #8237
  {10,  2,   0}, // #8238
  {11,  2,   0}, // #8239
  {19,  1,   0}, // #8240
  {20,  1,   0}, // #8241
  {28,  8,   0}, // #8242
  { 1,  3,   0}, // #8243
  { 2,  4,   0}, // #8244
  { 3,  7,   0}, // #8245
  { 4,  8,   0}, // #8246
  { 5,  8,   0}, // #8247
  { 6,  4,   0}, // #8248
  { 7,  5,   0}, // #8249
  { 8,  4,   0}, // #8250
  { 9,  1,   0}, // #8251
  {10,  2,   0}, // #8252
  {11,  2,   0}, // #8253
  {14,  1,   0}, // #8254
  {15,  1,   0}, // #8255
  {19,  1,   0}, // #8256
  {20,  1,   0}, // #8257
  {28,  9,   0}, // #8258
  { 1,  3,   0}, // #8259
  { 2,  4,   0}, // #8260
  { 3,  8,   0}, // #8261
  { 4,  9,   0}, // #8262
  { 5,  9,   0}, // #8263
  { 6,  4,   0}, // #8264
  { 7,  5,   0}, // #8265
  { 8,  4,   0}, // #8266
  { 9,  1,   0}, // #8267
  {10,  2,   0}, // #8268
  {11,  2,   0}, // #8269
  {19,  1,   0}, // #8270
  {20,  1,   0}, // #8271
  {28,  9,   0}, // #8272
  { 1,  3,   0}, // #8273
  { 2,  3,   0}, // #8274
  { 3,  3,   0}, // #8275
  { 4,  3,   0}, // #8276
  { 5,  3,   0}, // #8277
  { 6,  3,   0}, // #8278
  { 7,  3,   0}, // #8279
  { 8,  3,   0}, // #8280
  {14,  1,   0}, // #8281
  {15,  1,   0}, // #8282
  {28,  4,   0}, // #8283
  { 3,  3,   0}, // #8284
  { 4,  3,   0}, // #8285
  { 5,  3,   0}, // #8286
  {10,  2,   0}, // #8287
  {11,  2,   0}, // #8288
  {14,  1,   0}, // #8289
  {15,  1,   0}, // #8290
  {28,  4,   0}, // #8291
  { 2,  2,   0}, // #8292
  { 3,  2,   0}, // #8293
  { 4,  5,   0}, // #8294
  { 5,  7,   0}, // #8295
  { 7,  3,   0}, // #8296
  { 8,  3,   0}, // #8297
  { 9,  2,   0}, // #8298
  {10,  2,   0}, // #8299
  {11,  2,   0}, // #8300
  {14,  2,   0}, // #8301
  {15,  1,   0}, // #8302
  {18,  1,   0}, // #8303
  {23,  1,   0}, // #8304
  {28, 10,   0}, // #8305
  { 4,  1,   0}, // #8306
  { 5,  1,   0}, // #8307
  { 7,  1,   0}, // #8308
  { 8,  1,   0}, // #8309
  {14,  2,   0}, // #8310
  {15,  1,   0}, // #8311
  {18,  1,   0}, // #8312
  {23,  1,   0}, // #8313
  {28,  4,   0}, // #8314
  { 4,  2,   0}, // #8315
  { 5,  2,   0}, // #8316
  { 7,  2,   0}, // #8317
  { 8,  2,   0}, // #8318
  {14,  2,   0}, // #8319
  {15,  1,   0}, // #8320
  {18,  1,   0}, // #8321
  {23,  1,   0}, // #8322
  {28,  5,   0}, // #8323
  { 4,  2,   0}, // #8324
  { 5,  2,   0}, // #8325
  { 7,  2,   0}, // #8326
  { 8,  2,   0}, // #8327
  {14,  1,   0}, // #8328
  {18,  1,   0}, // #8329
  {23,  1,   0}, // #8330
  {28,  4,   0}, // #8331
  { 2,  1,   0}, // #8332
  { 3,  1,   0}, // #8333
  { 4,  2,   0}, // #8334
  { 5,  3,   0}, // #8335
  { 7,  1,   0}, // #8336
  { 8,  1,   0}, // #8337
  { 9,  1,   0}, // #8338
  {10,  1,   0}, // #8339
  {11,  1,   0}, // #8340
  {14,  2,   0}, // #8341
  {15,  1,   0}, // #8342
  {18,  1,   0}, // #8343
  {23,  1,   0}, // #8344
  {28,  6,   0}, // #8345
  { 2,  1,   0}, // #8346
  { 3,  1,   0}, // #8347
  { 4,  1,   0}, // #8348
  { 5,  2,   0}, // #8349
  { 9,  1,   0}, // #8350
  {10,  1,   0}, // #8351
  {11,  1,   0}, // #8352
  {14,  2,   0}, // #8353
  {15,  1,   0}, // #8354
  {18,  1,   0}, // #8355
  {23,  1,   0}, // #8356
  {28,  5,   0}, // #8357
  { 1,  1,   0}, // #8358
  { 2,  1,   0}, // #8359
  { 3,  1,   0}, // #8360
  { 4,  2,   0}, // #8361
  { 5,  2,   0}, // #8362
  { 6,  1,   0}, // #8363
  { 7,  2,   0}, // #8364
  { 8,  2,   0}, // #8365
  {14,  1,   0}, // #8366
  {18,  1,   0}, // #8367
  {23,  1,   0}, // #8368
  {28,  4,   0}, // #8369
  { 3,  2,   0}, // #8370
  { 4,  2,   0}, // #8371
  { 5,  2,   0}, // #8372
  { 6,  2,   0}, // #8373
  { 7,  2,   0}, // #8374
  {10,  2,   0}, // #8375
  {11,  2,   0}, // #8376
  {19,  2,   0}, // #8377
  {20,  2,   0}, // #8378
  {28,  2,   0}, // #8379
  { 1,  1,   0}, // #8380
  { 2,  1,   0}, // #8381
  { 3,  4,   0}, // #8382
  { 4,  5,   0}, // #8383
  { 5,  5,   0}, // #8384
  { 6,  4,   0}, // #8385
  { 7,  5,   0}, // #8386
  { 8,  2,   0}, // #8387
  {10,  1,   0}, // #8388
  {11,  1,   0}, // #8389
  {14,  1,   0}, // #8390
  {15,  1,   0}, // #8391
  {19,  1,   0}, // #8392
  {20,  1,   0}, // #8393
  {28,  6,   0}, // #8394
  { 1,  1,   0}, // #8395
  { 2,  1,   0}, // #8396
  { 3,  4,   0}, // #8397
  { 4,  4,   0}, // #8398
  { 5,  4,   0}, // #8399
  { 6,  4,   0}, // #8400
  { 7,  4,   0}, // #8401
  { 8,  1,   0}, // #8402
  {10,  1,   0}, // #8403
  {11,  1,   0}, // #8404
  {19,  1,   0}, // #8405
  {20,  1,   0}, // #8406
  {28,  4,   0}, // #8407
  { 2,  1,   0}, // #8408
  { 3,  1,   0}, // #8409
  { 4,  1,   0}, // #8410
  { 5,  1,   0}, // #8411
  {14,  1,   0}, // #8412
  {18,  1,   0}, // #8413
  {23,  1,   0}, // #8414
  {28,  3,   0}, // #8415
  { 1,  1,   0}, // #8416
  { 2,  1,   0}, // #8417
  { 3,  1,   0}, // #8418
  { 4,  1,   0}, // #8419
  { 5,  1,   0}, // #8420
  { 6,  1,   0}, // #8421
  { 7,  1,   0}, // #8422
  { 8,  1,   0}, // #8423
  {14,  1,   0}, // #8424
  {18,  1,   0}, // #8425
  {23,  1,   0}, // #8426
  {28,  3,   0}, // #8427
  { 1,  2,   0}, // #8428
  { 2,  2,   0}, // #8429
  { 3,  3,   0}, // #8430
  { 4,  3,   0}, // #8431
  { 5,  3,   0}, // #8432
  { 6,  3,   0}, // #8433
  { 7,  3,   0}, // #8434
  { 8,  2,   0}, // #8435
  {14,  1,   0}, // #8436
  {15,  1,   0}, // #8437
  {28,  4,   0}, // #8438
  { 1,  2,   0}, // #8439
  { 2,  2,   0}, // #8440
  { 3,  3,   0}, // #8441
  { 4,  3,   0}, // #8442
  { 5,  3,   0}, // #8443
  { 6,  3,   0}, // #8444
  { 7,  3,   0}, // #8445
  { 8,  2,   0}, // #8446
  {28,  3,   0}, // #8447
  { 1,  2,   0}, // #8448
  { 2,  2,   0}, // #8449
  { 3,  2,   0}, // #8450
  { 4,  2,   0}, // #8451
  { 5,  2,   0}, // #8452
  { 6,  2,   0}, // #8453
  { 7,  2,   0}, // #8454
  { 8,  2,   0}, // #8455
  {14,  1,   0}, // #8456
  {15,  1,   0}, // #8457
  {28,  3,   0}, // #8458
  { 1,  2,   0}, // #8459
  { 2,  2,   0}, // #8460
  { 3,  2,   0}, // #8461
  { 4,  2,   0}, // #8462
  { 5,  2,   0}, // #8463
  { 6,  2,   0}, // #8464
  { 7,  2,   0}, // #8465
  { 8,  2,   0}, // #8466
  {28,  2,   0}, // #8467
  { 1,  2,   0}, // #8468
  { 2,  3,   0}, // #8469
  { 3,  7,   0}, // #8470
  { 4, 15,   0}, // #8471
  { 5, 15,   0}, // #8472
  { 6,  6,   0}, // #8473
  { 7, 10,   0}, // #8474
  { 8,  6,   0}, // #8475
  { 9,  1,   0}, // #8476
  {10,  3,   0}, // #8477
  {11,  3,   0}, // #8478
  {19,  2,   0}, // #8479
  {20,  2,   0}, // #8480
  {21,  4,   0}, // #8481
  {28, 15,   0}, // #8482
  { 2,  1,   0}, // #8483
  { 3,  3,   0}, // #8484
  { 4,  3,   0}, // #8485
  { 5,  3,   0}, // #8486
  { 6,  2,   0}, // #8487
  { 7,  2,   0}, // #8488
  {10,  2,   0}, // #8489
  {11,  2,   0}, // #8490
  {19,  2,   0}, // #8491
  {20,  2,   0}, // #8492
  {28,  3,   0}, // #8493
  { 1,  1,   0}, // #8494
  { 2,  2,   0}, // #8495
  { 3,  3,   0}, // #8496
  { 4,  3,   0}, // #8497
  { 5,  3,   0}, // #8498
  { 6,  2,   0}, // #8499
  { 7,  2,   0}, // #8500
  { 8,  1,   0}, // #8501
  {10,  1,   0}, // #8502
  {11,  1,   0}, // #8503
  {19,  1,   0}, // #8504
  {20,  1,   0}, // #8505
  {28,  3,   0}, // #8506
  { 5,  3,   0}, // #8507
  {14,  1,   0}, // #8508
  {15,  1,   0}, // #8509
  {28,  4,   0}, // #8510
  {17,  1,   0}, // #8511
  {18,  2,   0}, // #8512
  {28,  2,   0}, // #8513
  { 5,  4,   0}, // #8514
  {14,  2,   0}, // #8515
  {15,  1,   0}, // #8516
  {18,  1,   0}, // #8517
  {23,  1,   0}, // #8518
  {28,  7,   0}, // #8519
  { 4,  1,   0}, // #8520
  { 5,  6,   0}, // #8521
  { 7,  1,   0}, // #8522
  { 8,  1,   0}, // #8523
  {14,  2,   0}, // #8524
  {15,  1,   0}, // #8525
  {18,  1,   0}, // #8526
  {23,  1,   0}, // #8527
  {28,  9,   0}, // #8528
  { 1,  1,   0}, // #8529
  { 2,  1,   0}, // #8530
  { 3,  2,   0}, // #8531
  { 4,  2,   0}, // #8532
  { 5,  2,   0}, // #8533
  { 6,  2,   0}, // #8534
  { 7,  2,   0}, // #8535
  { 8,  1,   0}, // #8536
  {14,  1,   0}, // #8537
  {15,  1,   0}, // #8538
  {28,  3,   0}, // #8539
  { 3,  1,   0}, // #8540
  { 4,  1,   0}, // #8541
  { 5,  1,   0}, // #8542
  { 6,  1,   0}, // #8543
  { 7,  1,   0}, // #8544
  {10,  1,   0}, // #8545
  {11,  1,   0}, // #8546
  {17,  1,   0}, // #8547
  {18,  2,   0}, // #8548
  {19,  1,   0}, // #8549
  {20,  1,   0}, // #8550
  {28,  3,   0}, // #8551
  { 4,  1,   0}, // #8552
  { 5,  1,   0}, // #8553
  { 7,  1,   0}, // #8554
  { 8,  1,   0}, // #8555
  {17,  1,   0}, // #8556
  {18,  2,   0}, // #8557
  {21,  1,   0}, // #8558
  {28,  3,   0}, // #8559
  { 3,  1,   0}, // #8560
  { 4,  2,   0}, // #8561
  { 5,  2,   0}, // #8562
  { 6,  1,   0}, // #8563
  { 7,  2,   0}, // #8564
  { 8,  1,   0}, // #8565
  {10,  1,   0}, // #8566
  {11,  1,   0}, // #8567
  {19,  1,   0}, // #8568
  {20,  1,   0}, // #8569
  {28,  2,   0}, // #8570
  { 2,  2,   0}, // #8571
  { 3,  2,   0}, // #8572
  { 4,  9,   0}, // #8573
  { 5, 13,   0}, // #8574
  { 7,  7,   0}, // #8575
  { 8,  7,   0}, // #8576
  { 9,  2,   0}, // #8577
  {10,  2,   0}, // #8578
  {11,  2,   0}, // #8579
  {14,  2,   0}, // #8580
  {15,  1,   0}, // #8581
  {18,  1,   0}, // #8582
  {23,  1,   0}, // #8583
  {28, 16,   0}, // #8584
  { 1,  2,   0}, // #8585
  { 2,  2,   0}, // #8586
  { 3,  6,   0}, // #8587
  { 4, 12,   0}, // #8588
  { 5, 19,   0}, // #8589
  { 6,  4,   0}, // #8590
  { 7, 10,   0}, // #8591
  { 8,  8,   0}, // #8592
  {10,  4,   0}, // #8593
  {11,  4,   0}, // #8594
  {14,  2,   0}, // #8595
  {15,  1,   0}, // #8596
  {18,  1,   0}, // #8597
  {19,  2,   0}, // #8598
  {20,  2,   0}, // #8599
  {23,  1,   0}, // #8600
  {28, 22,   0}, // #8601
  { 1,  2,   0}, // #8602
  { 2,  8,   0}, // #8603
  { 3, 12,   0}, // #8604
  { 4, 21,   0}, // #8605
  { 5, 21,   0}, // #8606
  { 6,  5,   0}, // #8607
  { 7, 14,   0}, // #8608
  { 8,  9,   0}, // #8609
  { 9,  4,   0}, // #8610
  {10,  7,   0}, // #8611
  {11,  7,   0}, // #8612
  {19,  3,   0}, // #8613
  {20,  3,   0}, // #8614
  {28, 21,   0}, // #8615
  { 1,  2,   0}, // #8616
  { 2,  4,   0}, // #8617
  { 3, 13,   0}, // #8618
  { 4, 34,   0}, // #8619
  { 5, 34,   0}, // #8620
  { 6, 11,   0}, // #8621
  { 7, 32,   0}, // #8622
  { 8, 23,   0}, // #8623
  { 9,  2,   0}, // #8624
  {10, 11,   0}, // #8625
  {11, 11,   0}, // #8626
  {14, 19,   0}, // #8627
  {15, 14,   0}, // #8628
  {18,  4,   0}, // #8629
  {19,  9,   0}, // #8630
  {20,  9,   0}, // #8631
  {23,  5,   0}, // #8632
  {28, 57,   0}, // #8633
  { 2,  1,   0}, // #8634
  { 3,  1,   0}, // #8635
  { 4,  3,   0}, // #8636
  { 5,  9,   0}, // #8637
  { 7,  2,   0}, // #8638
  { 8,  2,   0}, // #8639
  { 9,  1,   0}, // #8640
  {10,  1,   0}, // #8641
  {11,  1,   0}, // #8642
  {14,  1,   0}, // #8643
  {15,  1,   0}, // #8644
  {28, 10,   0}, // #8645
  { 3,  1,   0}, // #8646
  { 4, 10,   0}, // #8647
  { 5, 10,   0}, // #8648
  { 6,  1,   0}, // #8649
  { 7,  3,   0}, // #8650
  { 8,  2,   0}, // #8651
  {10,  1,   0}, // #8652
  {11,  1,   0}, // #8653
  {19,  1,   0}, // #8654
  {20,  1,   0}, // #8655
  {21,  2,   0}, // #8656
  {28, 10,   0}, // #8657
  { 1,  7,   0}, // #8658
  { 2, 24,   0}, // #8659
  { 3, 44,   0}, // #8660
  { 4, 70,   0}, // #8661
  { 5, 75,   0}, // #8662
  { 6, 26,   0}, // #8663
  { 7, 52,   0}, // #8664
  { 8, 32,   0}, // #8665
  { 9, 17,   0}, // #8666
  {10, 36,   0}, // #8667
  {11, 37,   0}, // #8668
  {14, 10,   0}, // #8669
  {15,  9,   0}, // #8670
  {18,  1,   0}, // #8671
  {19, 19,   0}, // #8672
  {20, 19,   0}, // #8673
  {23,  1,   0}, // #8674
  {28, 86,   0}, // #8675
  { 3,  9,   0}, // #8676
  { 4, 15,   0}, // #8677
  { 5, 15,   0}, // #8678
  { 6,  9,   0}, // #8679
  { 7,  9,   0}, // #8680
  {10,  6,   0}, // #8681
  {11,  6,   0}, // #8682
  {19,  6,   0}, // #8683
  {20,  6,   0}, // #8684
  {28, 15,   0}, // #8685
  { 1,  5,   0}, // #8686
  { 2, 20,   0}, // #8687
  { 3, 35,   0}, // #8688
  { 4, 61,   0}, // #8689
  { 5, 66,   0}, // #8690
  { 6, 20,   0}, // #8691
  { 7, 46,   0}, // #8692
  { 8, 31,   0}, // #8693
  { 9, 15,   0}, // #8694
  {10, 30,   0}, // #8695
  {11, 30,   0}, // #8696
  {14,  6,   0}, // #8697
  {15,  5,   0}, // #8698
  {18,  1,   0}, // #8699
  {19, 15,   0}, // #8700
  {20, 15,   0}, // #8701
  {23,  1,   0}, // #8702
  {28, 73,   0}, // #8703
  { 1,  5,   0}, // #8704
  { 2, 20,   0}, // #8705
  { 3, 36,   0}, // #8706
  { 4, 61,   0}, // #8707
  { 5, 66,   0}, // #8708
  { 6, 21,   0}, // #8709
  { 7, 46,   0}, // #8710
  { 8, 30,   0}, // #8711
  { 9, 15,   0}, // #8712
  {10, 30,   0}, // #8713
  {11, 30,   0}, // #8714
  {14,  6,   0}, // #8715
  {15,  5,   0}, // #8716
  {18,  1,   0}, // #8717
  {19, 15,   0}, // #8718
  {20, 15,   0}, // #8719
  {23,  1,   0}, // #8720
  {28, 73,   0}, // #8721
  { 1,  6,   0}, // #8722
  { 2, 23,   0}, // #8723
  { 3, 41,   0}, // #8724
  { 4, 68,   0}, // #8725
  { 5, 73,   0}, // #8726
  { 6, 24,   0}, // #8727
  { 7, 51,   0}, // #8728
  { 8, 33,   0}, // #8729
  { 9, 16,   0}, // #8730
  {10, 34,   0}, // #8731
  {11, 34,   0}, // #8732
  {14,  9,   0}, // #8733
  {15,  8,   0}, // #8734
  {18,  1,   0}, // #8735
  {19, 18,   0}, // #8736
  {20, 18,   0}, // #8737
  {23,  1,   0}, // #8738
  {28, 83,   0}, // #8739
  { 2,  9,   0}, // #8740
  { 3, 23,   0}, // #8741
  { 4, 53,   0}, // #8742
  { 5, 54,   0}, // #8743
  { 6,  3,   0}, // #8744
  { 7, 33,   0}, // #8745
  { 8, 20,   0}, // #8746
  { 9,  8,   0}, // #8747
  {10, 15,   0}, // #8748
  {11, 16,   0}, // #8749
  {19,  2,   0}, // #8750
  {20,  2,   0}, // #8751
  {28, 54,   0}, // #8752
  { 1,  7,   0}, // #8753
  { 2, 26,   0}, // #8754
  { 3, 46,   0}, // #8755
  { 4, 71,   0}, // #8756
  { 5, 79,   0}, // #8757
  { 6, 27,   0}, // #8758
  { 7, 52,   0}, // #8759
  { 8, 32,   0}, // #8760
  { 9, 19,   0}, // #8761
  {10, 39,   0}, // #8762
  {11, 41,   0}, // #8763
  {14,  8,   0}, // #8764
  {15,  8,   0}, // #8765
  {19, 20,   0}, // #8766
  {20, 20,   0}, // #8767
  {28, 87,   0}, // #8768
  { 1,  7,   0}, // #8769
  { 2, 26,   0}, // #8770
  { 3, 46,   0}, // #8771
  { 4, 71,   0}, // #8772
  { 5, 79,   0}, // #8773
  { 6, 27,   0}, // #8774
  { 7, 52,   0}, // #8775
  { 8, 32,   0}, // #8776
  { 9, 19,   0}, // #8777
  {10, 39,   0}, // #8778
  {11, 41,   0}, // #8779
  {14,  7,   0}, // #8780
  {15,  7,   0}, // #8781
  {19, 20,   0}, // #8782
  {20, 20,   0}, // #8783
  {28, 86,   0}, // #8784
  { 1,  2,   0}, // #8785
  { 2,  9,   0}, // #8786
  { 3, 14,   0}, // #8787
  { 4, 24,   0}, // #8788
  { 5, 24,   0}, // #8789
  { 6,  7,   0}, // #8790
  { 7, 17,   0}, // #8791
  { 8, 12,   0}, // #8792
  { 9,  6,   0}, // #8793
  {10, 11,   0}, // #8794
  {11, 11,   0}, // #8795
  {14,  1,   0}, // #8796
  {18,  1,   0}, // #8797
  {19,  5,   0}, // #8798
  {20,  5,   0}, // #8799
  {23,  1,   0}, // #8800
  {28, 26,   0}, // #8801
  { 1,  2,   0}, // #8802
  { 2, 12,   0}, // #8803
  { 3, 17,   0}, // #8804
  { 4, 27,   0}, // #8805
  { 5, 32,   0}, // #8806
  { 6,  7,   0}, // #8807
  { 7, 17,   0}, // #8808
  { 8, 12,   0}, // #8809
  { 9, 10,   0}, // #8810
  {10, 15,   0}, // #8811
  {11, 15,   0}, // #8812
  {14, 40,   0}, // #8813
  {15,  2,   0}, // #8814
  {18, 38,   0}, // #8815
  {19,  5,   0}, // #8816
  {20,  5,   0}, // #8817
  {23, 38,   0}, // #8818
  {28, 110,   0}, // #8819
  { 1,  4,   0}, // #8820
  { 2,  4,   0}, // #8821
  { 3,  6,   0}, // #8822
  { 4, 10,   0}, // #8823
  { 5, 10,   0}, // #8824
  { 6,  5,   0}, // #8825
  { 7,  9,   0}, // #8826
  { 8,  8,   0}, // #8827
  {10,  1,   0}, // #8828
  {11,  1,   0}, // #8829
  {13, 47,   0}, // #8830
  {14, 80,   0}, // #8831
  {15, 80,   0}, // #8832
  {21,  2,   0}, // #8833
  {28, 90,   0}, // #8834
  { 1,  8,   0}, // #8835
  { 2, 35,   0}, // #8836
  { 3, 79,   0}, // #8837
  { 4, 142,   0}, // #8838
  { 5, 142,   0}, // #8839
  { 6, 37,   0}, // #8840
  { 7, 100,   0}, // #8841
  { 8, 71,   0}, // #8842
  { 9, 21,   0}, // #8843
  {10, 46,   0}, // #8844
  {11, 46,   0}, // #8845
  {14,  1,   0}, // #8846
  {18,  1,   0}, // #8847
  {19, 10,   0}, // #8848
  {20, 10,   0}, // #8849
  {23,  1,   0}, // #8850
  {28, 144,   0}, // #8851
  { 2,  1,   0}, // #8852
  { 3,  1,   0}, // #8853
  { 4,  1,   0}, // #8854
  { 5,  1,   0}, // #8855
  { 9,  1,   0}, // #8856
  {10,  1,   0}, // #8857
  {11,  1,   0}, // #8858
  {14,  1,   0}, // #8859
  {18,  1,   0}, // #8860
  {23,  1,   0}, // #8861
  {28,  3,   0}, // #8862
  { 3,  1,   0}, // #8863
  { 4,  1,   0}, // #8864
  { 5,  1,   0}, // #8865
  { 6,  1,   0}, // #8866
  { 7,  1,   0}, // #8867
  {10,  1,   0}, // #8868
  {11,  1,   0}, // #8869
  {14,  1,   0}, // #8870
  {18,  1,   0}, // #8871
  {19,  1,   0}, // #8872
  {20,  1,   0}, // #8873
  {23,  1,   0}, // #8874
  {28,  3,   0}, // #8875
  { 5,  2,   0}, // #8876
  {14,  1,   0}, // #8877
  {18,  1,   0}, // #8878
  {23,  1,   0}, // #8879
  {28,  4,   0}, // #8880
  { 2,  1,   0}, // #8881
  { 3,  1,   0}, // #8882
  { 4,  2,   0}, // #8883
  { 5,  2,   0}, // #8884
  { 7,  1,   0}, // #8885
  { 8,  1,   0}, // #8886
  { 9,  1,   0}, // #8887
  {10,  1,   0}, // #8888
  {11,  1,   0}, // #8889
  {14,  1,   0}, // #8890
  {18,  1,   0}, // #8891
  {23,  1,   0}, // #8892
  {28,  4,   0}, // #8893
  { 1,  5,   0}, // #8894
  { 2, 13,   0}, // #8895
  { 3, 13,   0}, // #8896
  { 4, 13,   0}, // #8897
  { 5, 13,   0}, // #8898
  { 6,  5,   0}, // #8899
  { 7,  5,   0}, // #8900
  { 8,  5,   0}, // #8901
  { 9,  8,   0}, // #8902
  {10,  8,   0}, // #8903
  {11,  8,   0}, // #8904
  {14, 21,   0}, // #8905
  {15, 21,   0}, // #8906
  {28, 34,   0}, // #8907
  { 4,  1,   0}, // #8908
  { 5,  1,   0}, // #8909
  { 7,  1,   0}, // #8910
  { 8,  1,   0}, // #8911
  {14,  1,   0}, // #8912
  {15,  1,   0}, // #8913
  {21,  1,   0}, // #8914
  {28,  2,   0}, // #8915
  { 1,  1,   0}, // #8916
  { 2,  1,   0}, // #8917
  { 3,  1,   0}, // #8918
  { 4,  1,   0}, // #8919
  { 5,  1,   0}, // #8920
  { 6,  1,   0}, // #8921
  { 7,  1,   0}, // #8922
  { 8,  1,   0}, // #8923
  {17,  1,   0}, // #8924
  {18,  2,   0}, // #8925
  {28,  3,   0}, // #8926
  { 5,  5,   0}, // #8927
  {14,  2,   0}, // #8928
  {15,  2,   0}, // #8929
  {28,  7,   0}, // #8930
  { 5,  2,   0}, // #8931
  {14,  2,   0}, // #8932
  {15,  1,   0}, // #8933
  {18,  1,   0}, // #8934
  {23,  1,   0}, // #8935
  {28,  5,   0}, // #8936
  { 4,  1,   0}, // #8937
  { 5,  1,   0}, // #8938
  { 7,  1,   0}, // #8939
  { 8,  1,   0}, // #8940
  {13,  1,   0}, // #8941
  {14,  2,   0}, // #8942
  {15,  2,   0}, // #8943
  {17,  1,   0}, // #8944
  {18,  2,   0}, // #8945
  {21,  1,   0}, // #8946
  {28,  5,   0}, // #8947
  { 4,  1,   0}, // #8948
  { 5,  3,   0}, // #8949
  { 7,  1,   0}, // #8950
  { 8,  1,   0}, // #8951
  {14,  2,   0}, // #8952
  {15,  1,   0}, // #8953
  {18,  1,   0}, // #8954
  {23,  1,   0}, // #8955
  {28,  6,   0}, // #8956
  { 3,  2,   0}, // #8957
  { 4,  2,   0}, // #8958
  { 5,  2,   0}, // #8959
  { 6,  2,   0}, // #8960
  { 7,  2,   0}, // #8961
  {10,  2,   0}, // #8962
  {11,  2,   0}, // #8963
  {14,  1,   0}, // #8964
  {15,  1,   0}, // #8965
  {19,  2,   0}, // #8966
  {20,  2,   0}, // #8967
  {28,  3,   0}, // #8968
  { 4,  2,   0}, // #8969
  { 5,  2,   0}, // #8970
  { 7,  2,   0}, // #8971
  { 8,  2,   0}, // #8972
  {14,  1,   0}, // #8973
  {15,  1,   0}, // #8974
  {28,  3,   0}, // #8975
  { 2,  2,   0}, // #8976
  { 3,  3,   0}, // #8977
  { 4,  9,   0}, // #8978
  { 5, 18,   0}, // #8979
  { 6,  1,   0}, // #8980
  { 7,  7,   0}, // #8981
  { 8,  6,   0}, // #8982
  { 9,  2,   0}, // #8983
  {10,  3,   0}, // #8984
  {11,  3,   0}, // #8985
  {19,  1,   0}, // #8986
  {20,  1,   0}, // #8987
  {28, 18,   0}, // #8988
  { 1,  2,   0}, // #8989
  { 2,  9,   0}, // #8990
  { 3, 14,   0}, // #8991
  { 4, 21,   0}, // #8992
  { 5, 24,   0}, // #8993
  { 6,  4,   0}, // #8994
  { 7, 11,   0}, // #8995
  { 8,  7,   0}, // #8996
  { 9,  7,   0}, // #8997
  {10, 12,   0}, // #8998
  {11, 12,   0}, // #8999
  {14,  1,   0}, // #9000
  {15,  1,   0}, // #9001
  {19,  2,   0}, // #9002
  {20,  2,   0}, // #9003
  {28, 25,   0}, // #9004
  { 2,  2,   0}, // #9005
  { 3,  2,   0}, // #9006
  { 4,  2,   0}, // #9007
  { 5,  3,   0}, // #9008
  { 9,  2,   0}, // #9009
  {10,  2,   0}, // #9010
  {11,  2,   0}, // #9011
  {14,  2,   0}, // #9012
  {18,  2,   0}, // #9013
  {23,  2,   0}, // #9014
  {28,  7,   0}, // #9015
  { 4,  1,   0}, // #9016
  { 5,  1,   0}, // #9017
  { 7,  1,   0}, // #9018
  { 8,  1,   0}, // #9019
  {14,  1,   0}, // #9020
  {18,  1,   0}, // #9021
  {23,  1,   0}, // #9022
  {28,  3,   0}, // #9023
  { 1,  1,   0}, // #9024
  { 2,  6,   0}, // #9025
  { 3,  8,   0}, // #9026
  { 4, 17,   0}, // #9027
  { 5, 20,   0}, // #9028
  { 6,  2,   0}, // #9029
  { 7, 11,   0}, // #9030
  { 8,  9,   0}, // #9031
  { 9,  5,   0}, // #9032
  {10,  7,   0}, // #9033
  {11,  7,   0}, // #9034
  {14,  2,   0}, // #9035
  {15,  2,   0}, // #9036
  {19,  1,   0}, // #9037
  {20,  1,   0}, // #9038
  {28, 22,   0}, // #9039
  { 1,  1,   0}, // #9040
  { 2,  4,   0}, // #9041
  { 3,  5,   0}, // #9042
  { 4, 10,   0}, // #9043
  { 5, 10,   0}, // #9044
  { 6,  2,   0}, // #9045
  { 7,  7,   0}, // #9046
  { 8,  6,   0}, // #9047
  { 9,  3,   0}, // #9048
  {10,  4,   0}, // #9049
  {11,  4,   0}, // #9050
  {14,  3,   0}, // #9051
  {15,  3,   0}, // #9052
  {19,  1,   0}, // #9053
  {20,  1,   0}, // #9054
  {28, 13,   0}, // #9055
  { 2,  8,   0}, // #9056
  { 3, 14,   0}, // #9057
  { 4, 30,   0}, // #9058
  { 5, 54,   0}, // #9059
  { 6,  2,   0}, // #9060
  { 7, 18,   0}, // #9061
  { 8, 14,   0}, // #9062
  { 9,  8,   0}, // #9063
  {10, 10,   0}, // #9064
  {11, 11,   0}, // #9065
  {19,  2,   0}, // #9066
  {20,  2,   0}, // #9067
  {28, 54,   0}, // #9068
  { 2,  3,   0}, // #9069
  { 3,  4,   0}, // #9070
  { 4, 10,   0}, // #9071
  { 5, 15,   0}, // #9072
  { 6,  1,   0}, // #9073
  { 7,  7,   0}, // #9074
  { 8,  6,   0}, // #9075
  { 9,  3,   0}, // #9076
  {10,  4,   0}, // #9077
  {11,  4,   0}, // #9078
  {19,  1,   0}, // #9079
  {20,  1,   0}, // #9080
  {28, 15,   0}, // #9081
  { 2,  1,   0}, // #9082
  { 3,  1,   0}, // #9083
  { 4,  9,   0}, // #9084
  { 5,  9,   0}, // #9085
  { 7,  8,   0}, // #9086
  { 8,  8,   0}, // #9087
  { 9,  1,   0}, // #9088
  {10,  1,   0}, // #9089
  {11,  1,   0}, // #9090
  {13, 21,   0}, // #9091
  {14, 22,   0}, // #9092
  {15, 22,   0}, // #9093
  {21,  8,   0}, // #9094
  {28, 31,   0}, // #9095
  { 2, 35,   0}, // #9096
  { 3, 90,   0}, // #9097
  { 4, 134,   0}, // #9098
  { 5, 134,   0}, // #9099
  { 6, 34,   0}, // #9100
  { 7, 78,   0}, // #9101
  { 8, 44,   0}, // #9102
  { 9, 21,   0}, // #9103
  {10, 51,   0}, // #9104
  {11, 51,   0}, // #9105
  {14,  5,   0}, // #9106
  {15,  4,   0}, // #9107
  {18,  1,   0}, // #9108
  {19,  9,   0}, // #9109
  {20,  9,   0}, // #9110
  {23,  1,   0}, // #9111
  {28, 140,   0}, // #9112
  { 2, 52,   0}, // #9113
  { 3, 97,   0}, // #9114
  { 4, 150,   0}, // #9115
  { 5, 150,   0}, // #9116
  { 6, 45,   0}, // #9117
  { 7, 98,   0}, // #9118
  { 8, 53,   0}, // #9119
  { 9, 27,   0}, // #9120
  {10, 37,   0}, // #9121
  {11, 37,   0}, // #9122
  {14,  5,   0}, // #9123
  {15,  4,   0}, // #9124
  {18,  1,   0}, // #9125
  {19, 10,   0}, // #9126
  {20, 10,   0}, // #9127
  {23,  1,   0}, // #9128
  {28, 156,   0}, // #9129
  { 2,  1,   0}, // #9130
  { 3,  4,   0}, // #9131
  { 4,  7,   0}, // #9132
  { 5,  7,   0}, // #9133
  { 6,  2,   0}, // #9134
  { 7,  5,   0}, // #9135
  { 8,  3,   0}, // #9136
  { 9,  1,   0}, // #9137
  {10,  4,   0}, // #9138
  {11,  4,   0}, // #9139
  {13,  1,   0}, // #9140
  {14,  9,   0}, // #9141
  {15,  9,   0}, // #9142
  {17,  1,   0}, // #9143
  {18,  2,   0}, // #9144
  {19,  2,   0}, // #9145
  {20,  2,   0}, // #9146
  {21,  3,   0}, // #9147
  {28, 18,   0}, // #9148
  { 1,  2,   0}, // #9149
  { 2,  2,   0}, // #9150
  { 3,  7,   0}, // #9151
  { 4, 17,   0}, // #9152
  { 5, 17,   0}, // #9153
  { 6,  7,   0}, // #9154
  { 7, 17,   0}, // #9155
  { 8, 12,   0}, // #9156
  {13, 39,   0}, // #9157
  {14, 47,   0}, // #9158
  {15, 47,   0}, // #9159
  {28, 64,   0}, // #9160
  { 1,  4,   0}, // #9161
  { 2,  4,   0}, // #9162
  { 3,  6,   0}, // #9163
  { 4, 12,   0}, // #9164
  { 5, 12,   0}, // #9165
  { 6,  5,   0}, // #9166
  { 7, 11,   0}, // #9167
  { 8, 10,   0}, // #9168
  {10,  1,   0}, // #9169
  {11,  1,   0}, // #9170
  {13, 45,   0}, // #9171
  {14, 76,   0}, // #9172
  {15, 76,   0}, // #9173
  {21,  4,   0}, // #9174
  {28, 88,   0}, // #9175
  { 1,  9,   0}, // #9176
  { 2, 10,   0}, // #9177
  { 3, 26,   0}, // #9178
  { 4, 59,   0}, // #9179
  { 5, 59,   0}, // #9180
  { 6, 25,   0}, // #9181
  { 7, 47,   0}, // #9182
  { 8, 31,   0}, // #9183
  { 9,  1,   0}, // #9184
  {10, 17,   0}, // #9185
  {11, 17,   0}, // #9186
  {17, 30,   0}, // #9187
  {18, 41,   0}, // #9188
  {19, 16,   0}, // #9189
  {20, 16,   0}, // #9190
  {21,  1,   0}, // #9191
  {28, 100,   0}, // #9192
  { 1,  1,   0}, // #9193
  { 2,  1,   0}, // #9194
  { 3,  3,   0}, // #9195
  { 4,  3,   0}, // #9196
  { 5,  3,   0}, // #9197
  { 6,  1,   0}, // #9198
  { 7,  1,   0}, // #9199
  { 8,  1,   0}, // #9200
  {10,  1,   0}, // #9201
  {11,  1,   0}, // #9202
  {14,  2,   0}, // #9203
  {15,  2,   0}, // #9204
  {28,  5,   0}, // #9205
  { 1,  1,   0}, // #9206
  { 2,  1,   0}, // #9207
  { 3,  4,   0}, // #9208
  { 4,  4,   0}, // #9209
  { 5,  4,   0}, // #9210
  { 6,  1,   0}, // #9211
  { 7,  1,   0}, // #9212
  { 8,  1,   0}, // #9213
  {10,  2,   0}, // #9214
  {11,  2,   0}, // #9215
  {14,  4,   0}, // #9216
  {15,  4,   0}, // #9217
  {28,  8,   0}, // #9218
  { 1,  1,   0}, // #9219
  { 2,  1,   0}, // #9220
  { 3,  4,   0}, // #9221
  { 4,  4,   0}, // #9222
  { 5,  4,   0}, // #9223
  { 6,  1,   0}, // #9224
  { 7,  1,   0}, // #9225
  { 8,  1,   0}, // #9226
  {10,  2,   0}, // #9227
  {11,  2,   0}, // #9228
  {14,  8,   0}, // #9229
  {15,  8,   0}, // #9230
  {28, 12,   0}, // #9231
  { 4,  1,   0}, // #9232
  { 5,  1,   0}, // #9233
  { 7,  1,   0}, // #9234
  { 8,  1,   0}, // #9235
  {13,  1,   0}, // #9236
  {14,  2,   0}, // #9237
  {15,  2,   0}, // #9238
  {21,  1,   0}, // #9239
  {28,  3,   0}, // #9240
  { 2,  1,   0}, // #9241
  { 3,  1,   0}, // #9242
  { 4,  3,   0}, // #9243
  { 5,  3,   0}, // #9244
  { 7,  2,   0}, // #9245
  { 8,  2,   0}, // #9246
  { 9,  1,   0}, // #9247
  {10,  1,   0}, // #9248
  {11,  1,   0}, // #9249
  {14,  1,   0}, // #9250
  {15,  1,   0}, // #9251
  {28,  4,   0}, // #9252
  { 1,  2,   0}, // #9253
  { 2,  2,   0}, // #9254
  { 3,  2,   0}, // #9255
  { 4,  2,   0}, // #9256
  { 5,  2,   0}, // #9257
  { 6,  2,   0}, // #9258
  { 7,  2,   0}, // #9259
  { 8,  2,   0}, // #9260
  {14,  1,   0}, // #9261
  {18,  1,   0}, // #9262
  {23,  1,   0}, // #9263
  {28,  4,   0}, // #9264
  { 2,  3,   0}, // #9265
  { 3,  6,   0}, // #9266
  { 4,  7,   0}, // #9267
  { 5,  7,   0}, // #9268
  { 6,  1,   0}, // #9269
  { 7,  2,   0}, // #9270
  { 8,  1,   0}, // #9271
  {10,  1,   0}, // #9272
  {11,  1,   0}, // #9273
  {19,  1,   0}, // #9274
  {20,  1,   0}, // #9275
  {28,  7,   0}, // #9276
  { 2,  3,   0}, // #9277
  { 3,  6,   0}, // #9278
  { 4,  7,   0}, // #9279
  { 5,  7,   0}, // #9280
  { 6,  1,   0}, // #9281
  { 7,  2,   0}, // #9282
  { 8,  1,   0}, // #9283
  {10,  1,   0}, // #9284
  {11,  1,   0}, // #9285
  {14,  1,   0}, // #9286
  {15,  1,   0}, // #9287
  {19,  1,   0}, // #9288
  {20,  1,   0}, // #9289
  {28,  8,   0}, // #9290
  { 2,  2,   0}, // #9291
  { 3,  6,   0}, // #9292
  { 4,  7,   0}, // #9293
  { 5,  7,   0}, // #9294
  { 7,  1,   0}, // #9295
  { 8,  1,   0}, // #9296
  {10,  2,   0}, // #9297
  {11,  2,   0}, // #9298
  {14,  1,   0}, // #9299
  {15,  1,   0}, // #9300
  {28,  8,   0}, // #9301
  { 2,  1,   0}, // #9302
  { 3,  3,   0}, // #9303
  { 4,  3,   0}, // #9304
  { 5,  3,   0}, // #9305
  {10,  1,   0}, // #9306
  {11,  1,   0}, // #9307
  {14,  1,   0}, // #9308
  {15,  1,   0}, // #9309
  {28,  4,   0}, // #9310
  { 4,  1,   0}, // #9311
  { 5,  2,   0}, // #9312
  { 7,  1,   0}, // #9313
  { 8,  1,   0}, // #9314
  {14,  1,   0}, // #9315
  {15,  1,   0}, // #9316
  {28,  3,   0}, // #9317
  { 4,  1,   0}, // #9318
  { 5,  5,   0}, // #9319
  { 7,  1,   0}, // #9320
  { 8,  1,   0}, // #9321
  {14,  2,   0}, // #9322
  {15,  1,   0}, // #9323
  {18,  1,   0}, // #9324
  {23,  1,   0}, // #9325
  {28,  8,   0}, // #9326
  { 2,  2,   0}, // #9327
  { 3,  4,   0}, // #9328
  { 4,  4,   0}, // #9329
  { 5,  4,   0}, // #9330
  { 6,  2,   0}, // #9331
  { 7,  2,   0}, // #9332
  {10,  2,   0}, // #9333
  {11,  2,   0}, // #9334
  {19,  2,   0}, // #9335
  {20,  2,   0}, // #9336
  {28,  4,   0}, // #9337
  { 1,  2,   0}, // #9338
  { 2,  2,   0}, // #9339
  { 3,  4,   0}, // #9340
  { 4,  4,   0}, // #9341
  { 5,  4,   0}, // #9342
  { 6,  4,   0}, // #9343
  { 7,  4,   0}, // #9344
  { 8,  2,   0}, // #9345
  {10,  2,   0}, // #9346
  {11,  2,   0}, // #9347
  {19,  2,   0}, // #9348
  {20,  2,   0}, // #9349
  {28,  4,   0}, // #9350
  { 2,  1,   0}, // #9351
  { 3,  2,   0}, // #9352
  { 4,  2,   0}, // #9353
  { 5,  2,   0}, // #9354
  {28,  2,   0}, // #9355
  { 1,  1,   0}, // #9356
  { 2,  1,   0}, // #9357
  { 3,  2,   0}, // #9358
  { 4,  2,   0}, // #9359
  { 5,  2,   0}, // #9360
  { 6,  2,   0}, // #9361
  { 7,  2,   0}, // #9362
  { 8,  1,   0}, // #9363
  {28,  2,   0}, // #9364
  { 2,  5,   0}, // #9365
  { 3, 15,   0}, // #9366
  { 4, 15,   0}, // #9367
  { 5, 15,   0}, // #9368
  { 6,  5,   0}, // #9369
  { 7,  5,   0}, // #9370
  {10,  5,   0}, // #9371
  {11,  5,   0}, // #9372
  {19,  5,   0}, // #9373
  {20,  5,   0}, // #9374
  {28, 15,   0}, // #9375
  { 2,  7,   0}, // #9376
  { 3, 22,   0}, // #9377
  { 4, 23,   0}, // #9378
  { 5, 23,   0}, // #9379
  { 6,  9,   0}, // #9380
  { 7, 10,   0}, // #9381
  { 8,  1,   0}, // #9382
  {10,  9,   0}, // #9383
  {11,  9,   0}, // #9384
  {19,  9,   0}, // #9385
  {20,  9,   0}, // #9386
  {28, 23,   0}, // #9387
  { 1, 11,   0}, // #9388
  { 2, 11,   0}, // #9389
  { 3, 37,   0}, // #9390
  { 4, 37,   0}, // #9391
  { 5, 37,   0}, // #9392
  { 6, 37,   0}, // #9393
  { 7, 37,   0}, // #9394
  { 8, 11,   0}, // #9395
  {10, 17,   0}, // #9396
  {11, 17,   0}, // #9397
  {19, 17,   0}, // #9398
  {20, 17,   0}, // #9399
  {28, 37,   0}, // #9400
  { 1,  1,   0}, // #9401
  { 2,  4,   0}, // #9402
  { 3,  5,   0}, // #9403
  { 4,  9,   0}, // #9404
  { 5, 13,   0}, // #9405
  { 6,  2,   0}, // #9406
  { 7,  6,   0}, // #9407
  { 8,  5,   0}, // #9408
  { 9,  3,   0}, // #9409
  {10,  4,   0}, // #9410
  {11,  4,   0}, // #9411
  {14,  2,   0}, // #9412
  {15,  2,   0}, // #9413
  {19,  1,   0}, // #9414
  {20,  1,   0}, // #9415
  {28, 15,   0}, // #9416
  { 1,  1,   0}, // #9417
  { 2,  1,   0}, // #9418
  { 3,  3,   0}, // #9419
  { 4,  3,   0}, // #9420
  { 5,  3,   0}, // #9421
  { 6,  3,   0}, // #9422
  { 7,  3,   0}, // #9423
  { 8,  1,   0}, // #9424
  {10,  2,   0}, // #9425
  {11,  2,   0}, // #9426
  {19,  2,   0}, // #9427
  {20,  2,   0}, // #9428
  {28,  3,   0}, // #9429
  { 1,  1,   0}, // #9430
  { 2,  1,   0}, // #9431
  { 3,  3,   0}, // #9432
  { 4,  3,   0}, // #9433
  { 5,  3,   0}, // #9434
  { 6,  3,   0}, // #9435
  { 7,  3,   0}, // #9436
  { 8,  1,   0}, // #9437
  {10,  2,   0}, // #9438
  {11,  2,   0}, // #9439
  {14,  1,   0}, // #9440
  {15,  1,   0}, // #9441
  {19,  2,   0}, // #9442
  {20,  2,   0}, // #9443
  {28,  4,   0}, // #9444
  { 2,  1,   0}, // #9445
  { 3,  3,   0}, // #9446
  { 4,  3,   0}, // #9447
  { 5,  3,   0}, // #9448
  {10,  2,   0}, // #9449
  {11,  2,   0}, // #9450
  {14,  1,   0}, // #9451
  {15,  1,   0}, // #9452
  {28,  4,   0}, // #9453
  { 2, 52,   0}, // #9454
  { 3, 125,   0}, // #9455
  { 4, 178,   0}, // #9456
  { 5, 178,   0}, // #9457
  { 6, 41,   0}, // #9458
  { 7, 94,   0}, // #9459
  { 8, 53,   0}, // #9460
  { 9, 29,   0}, // #9461
  {10, 69,   0}, // #9462
  {11, 69,   0}, // #9463
  {14,  6,   0}, // #9464
  {15,  4,   0}, // #9465
  {18,  2,   0}, // #9466
  {19,  8,   0}, // #9467
  {20,  8,   0}, // #9468
  {23,  2,   0}, // #9469
  {28, 186,   0}, // #9470
  { 3,  2,   0}, // #9471
  { 4,  2,   0}, // #9472
  { 5,  2,   0}, // #9473
  { 6,  1,   0}, // #9474
  { 7,  1,   0}, // #9475
  {10,  2,   0}, // #9476
  {11,  2,   0}, // #9477
  {14,  1,   0}, // #9478
  {18,  1,   0}, // #9479
  {19,  1,   0}, // #9480
  {20,  1,   0}, // #9481
  {23,  1,   0}, // #9482
  {28,  4,   0}, // #9483
  { 3,  2,   0}, // #9484
  { 4,  2,   0}, // #9485
  { 5,  2,   0}, // #9486
  { 6,  2,   0}, // #9487
  { 7,  2,   0}, // #9488
  {10,  2,   0}, // #9489
  {11,  2,   0}, // #9490
  {14,  1,   0}, // #9491
  {18,  1,   0}, // #9492
  {19,  2,   0}, // #9493
  {20,  2,   0}, // #9494
  {23,  1,   0}, // #9495
  {28,  4,   0}, // #9496
  { 1,  1,   0}, // #9497
  { 2,  2,   0}, // #9498
  { 3,  2,   0}, // #9499
  { 4,  2,   0}, // #9500
  { 5,  3,   0}, // #9501
  { 6,  1,   0}, // #9502
  { 7,  1,   0}, // #9503
  { 8,  1,   0}, // #9504
  {14,  2,   0}, // #9505
  {18,  2,   0}, // #9506
  {23,  2,   0}, // #9507
  {28,  7,   0}, // #9508
  { 1,  1,   0}, // #9509
  { 2,  2,   0}, // #9510
  { 3,  2,   0}, // #9511
  { 4,  2,   0}, // #9512
  { 5,  3,   0}, // #9513
  { 6,  1,   0}, // #9514
  { 7,  1,   0}, // #9515
  { 8,  1,   0}, // #9516
  {14,  4,   0}, // #9517
  {18,  4,   0}, // #9518
  {23,  4,   0}, // #9519
  {28, 11,   0}, // #9520
  { 1,  2,   0}, // #9521
  { 2,  2,   0}, // #9522
  { 3,  2,   0}, // #9523
  { 4,  2,   0}, // #9524
  { 5,  3,   0}, // #9525
  { 6,  2,   0}, // #9526
  { 7,  2,   0}, // #9527
  { 8,  2,   0}, // #9528
  {14,  8,   0}, // #9529
  {18,  8,   0}, // #9530
  {23,  8,   0}, // #9531
  {28, 19,   0}, // #9532
  { 1,  2,   0}, // #9533
  { 2,  2,   0}, // #9534
  { 3,  2,   0}, // #9535
  { 4,  2,   0}, // #9536
  { 5,  3,   0}, // #9537
  { 6,  2,   0}, // #9538
  { 7,  2,   0}, // #9539
  { 8,  2,   0}, // #9540
  {14, 16,   0}, // #9541
  {18, 16,   0}, // #9542
  {23, 16,   0}, // #9543
  {28, 35,   0}, // #9544
  { 1,  1,   0}, // #9545
  { 2,  2,   0}, // #9546
  { 3,  2,   0}, // #9547
  { 4,  2,   0}, // #9548
  { 5,  3,   0}, // #9549
  { 6,  1,   0}, // #9550
  { 7,  1,   0}, // #9551
  { 8,  1,   0}, // #9552
  {14,  8,   0}, // #9553
  {18,  8,   0}, // #9554
  {23,  8,   0}, // #9555
  {28, 19,   0}, // #9556
  { 3,  3,   0}, // #9557
  { 4,  3,   0}, // #9558
  { 5,  3,   0}, // #9559
  { 6,  2,   0}, // #9560
  { 7,  2,   0}, // #9561
  {10,  2,   0}, // #9562
  {11,  2,   0}, // #9563
  {14,  1,   0}, // #9564
  {15,  1,   0}, // #9565
  {19,  2,   0}, // #9566
  {20,  2,   0}, // #9567
  {28,  4,   0}, // #9568
  { 2,  3,   0}, // #9569
  { 3,  3,   0}, // #9570
  { 4,  3,   0}, // #9571
  { 5,  3,   0}, // #9572
  {28,  3,   0}, // #9573
  { 2,  5,   0}, // #9574
  { 3, 14,   0}, // #9575
  { 4, 14,   0}, // #9576
  { 5, 14,   0}, // #9577
  { 6,  5,   0}, // #9578
  { 7,  5,   0}, // #9579
  {10,  5,   0}, // #9580
  {11,  5,   0}, // #9581
  {14,  1,   0}, // #9582
  {15,  1,   0}, // #9583
  {19,  5,   0}, // #9584
  {20,  5,   0}, // #9585
  {28, 15,   0}, // #9586
  { 2,  3,   0}, // #9587
  { 3,  3,   0}, // #9588
  { 4,  3,   0}, // #9589
  { 5,  3,   0}, // #9590
  {14,  1,   0}, // #9591
  {15,  1,   0}, // #9592
  {28,  4,   0}, // #9593
  { 1,  1,   0}, // #9594
  { 2,  1,   0}, // #9595
  { 3,  2,   0}, // #9596
  { 4,  2,   0}, // #9597
  { 5,  2,   0}, // #9598
  { 6,  1,   0}, // #9599
  { 7,  1,   0}, // #9600
  { 8,  1,   0}, // #9601
  {10,  1,   0}, // #9602
  {11,  1,   0}, // #9603
  {14,  2,   0}, // #9604
  {15,  2,   0}, // #9605
  {28,  4,   0}, // #9606
  { 1,  1,   0}, // #9607
  { 2,  1,   0}, // #9608
  { 3,  3,   0}, // #9609
  { 4,  3,   0}, // #9610
  { 5,  3,   0}, // #9611
  { 6,  1,   0}, // #9612
  { 7,  1,   0}, // #9613
  { 8,  1,   0}, // #9614
  {10,  2,   0}, // #9615
  {11,  2,   0}, // #9616
  {14,  4,   0}, // #9617
  {15,  4,   0}, // #9618
  {28,  7,   0}, // #9619
  { 1,  1,   0}, // #9620
  { 2,  1,   0}, // #9621
  { 3,  3,   0}, // #9622
  { 4,  3,   0}, // #9623
  { 5,  3,   0}, // #9624
  { 6,  1,   0}, // #9625
  { 7,  1,   0}, // #9626
  { 8,  1,   0}, // #9627
  {10,  2,   0}, // #9628
  {11,  2,   0}, // #9629
  {14,  8,   0}, // #9630
  {15,  8,   0}, // #9631
  {28, 11,   0}, // #9632
  { 1,  1,   0}, // #9633
  { 2,  1,   0}, // #9634
  { 3,  3,   0}, // #9635
  { 4,  3,   0}, // #9636
  { 5,  3,   0}, // #9637
  { 6,  3,   0}, // #9638
  { 7,  3,   0}, // #9639
  { 8,  1,   0}, // #9640
  {10,  2,   0}, // #9641
  {11,  2,   0}, // #9642
  {14, 16,   0}, // #9643
  {15, 16,   0}, // #9644
  {19,  2,   0}, // #9645
  {20,  2,   0}, // #9646
  {28, 19,   0}, // #9647
  { 1,  7,   0}, // #9648
  { 2,  7,   0}, // #9649
  { 3, 22,   0}, // #9650
  { 4, 22,   0}, // #9651
  { 5, 22,   0}, // #9652
  { 6, 22,   0}, // #9653
  { 7, 22,   0}, // #9654
  { 8,  7,   0}, // #9655
  {10,  9,   0}, // #9656
  {11,  9,   0}, // #9657
  {19,  9,   0}, // #9658
  {20,  9,   0}, // #9659
  {28, 22,   0}, // #9660
  { 2,  7,   0}, // #9661
  { 3, 21,   0}, // #9662
  { 4, 22,   0}, // #9663
  { 5, 22,   0}, // #9664
  { 6,  9,   0}, // #9665
  { 7, 10,   0}, // #9666
  { 8,  1,   0}, // #9667
  {10,  9,   0}, // #9668
  {11,  9,   0}, // #9669
  {14,  1,   0}, // #9670
  {15,  1,   0}, // #9671
  {19,  9,   0}, // #9672
  {20,  9,   0}, // #9673
  {28, 23,   0}, // #9674
  { 1,  7,   0}, // #9675
  { 2,  7,   0}, // #9676
  { 3, 21,   0}, // #9677
  { 4, 21,   0}, // #9678
  { 5, 21,   0}, // #9679
  { 6, 21,   0}, // #9680
  { 7, 21,   0}, // #9681
  { 8,  7,   0}, // #9682
  {10,  9,   0}, // #9683
  {11,  9,   0}, // #9684
  {14,  1,   0}, // #9685
  {15,  1,   0}, // #9686
  {19,  9,   0}, // #9687
  {20,  9,   0}, // #9688
  {28, 22,   0}, // #9689
  { 1, 11,   0}, // #9690
  { 2, 11,   0}, // #9691
  { 3, 36,   0}, // #9692
  { 4, 36,   0}, // #9693
  { 5, 36,   0}, // #9694
  { 6, 36,   0}, // #9695
  { 7, 36,   0}, // #9696
  { 8, 11,   0}, // #9697
  {10, 17,   0}, // #9698
  {11, 17,   0}, // #9699
  {14,  1,   0}, // #9700
  {15,  1,   0}, // #9701
  {19, 17,   0}, // #9702
  {20, 17,   0}, // #9703
  {28, 37,   0}, // #9704
  {13,  1,   0}, // #9705
  {14,  2,   0}, // #9706
  {15,  2,   0}, // #9707
  {17,  1,   0}, // #9708
  {18,  2,   0}, // #9709
  {28,  4,   0}, // #9710
  { 2,  1,   0}, // #9711
  { 3,  1,   0}, // #9712
  { 4,  3,   0}, // #9713
  { 5,  8,   0}, // #9714
  { 7,  2,   0}, // #9715
  { 8,  2,   0}, // #9716
  { 9,  1,   0}, // #9717
  {10,  1,   0}, // #9718
  {11,  1,   0}, // #9719
  {14,  1,   0}, // #9720
  {15,  1,   0}, // #9721
  {28,  9,   0}, // #9722
  { 2,  1,   0}, // #9723
  { 3,  1,   0}, // #9724
  { 4,  3,   0}, // #9725
  { 5,  7,   0}, // #9726
  { 7,  2,   0}, // #9727
  { 8,  2,   0}, // #9728
  { 9,  1,   0}, // #9729
  {10,  1,   0}, // #9730
  {11,  1,   0}, // #9731
  {14,  2,   0}, // #9732
  {15,  1,   0}, // #9733
  {18,  1,   0}, // #9734
  {23,  1,   0}, // #9735
  {28, 10,   0}, // #9736
  { 4,  1,   0}, // #9737
  { 5,  2,   0}, // #9738
  { 7,  1,   0}, // #9739
  { 8,  1,   0}, // #9740
  {14,  1,   0}, // #9741
  {18,  1,   0}, // #9742
  {23,  1,   0}, // #9743
  {28,  4,   0}, // #9744
  { 2,  1,   0}, // #9745
  { 3,  4,   0}, // #9746
  { 4, 10,   0}, // #9747
  { 5, 10,   0}, // #9748
  { 6,  3,   0}, // #9749
  { 7,  9,   0}, // #9750
  { 8,  6,   0}, // #9751
  { 9,  1,   0}, // #9752
  {10,  4,   0}, // #9753
  {11,  4,   0}, // #9754
  {19,  3,   0}, // #9755
  {20,  3,   0}, // #9756
  {28, 10,   0}, // #9757
  { 1,  7,   0}, // #9758
  { 2, 26,   0}, // #9759
  { 3, 47,   0}, // #9760
  { 4, 73,   0}, // #9761
  { 5, 80,   0}, // #9762
  { 6, 28,   0}, // #9763
  { 7, 54,   0}, // #9764
  { 8, 33,   0}, // #9765
  { 9, 19,   0}, // #9766
  {10, 40,   0}, // #9767
  {11, 42,   0}, // #9768
  {14,  7,   0}, // #9769
  {15,  7,   0}, // #9770
  {19, 21,   0}, // #9771
  {20, 21,   0}, // #9772
  {28, 87,   0}, // #9773
  { 1,  7,   0}, // #9774
  { 2, 27,   0}, // #9775
  { 3, 47,   0}, // #9776
  { 4, 73,   0}, // #9777
  { 5, 80,   0}, // #9778
  { 6, 27,   0}, // #9779
  { 7, 53,   0}, // #9780
  { 8, 33,   0}, // #9781
  { 9, 19,   0}, // #9782
  {10, 39,   0}, // #9783
  {11, 42,   0}, // #9784
  {14,  7,   0}, // #9785
  {15,  7,   0}, // #9786
  {19, 20,   0}, // #9787
  {20, 20,   0}, // #9788
  {28, 87,   0}, // #9789
  { 1,  7,   0}, // #9790
  { 2, 28,   0}, // #9791
  { 3, 48,   0}, // #9792
  { 4, 76,   0}, // #9793
  { 5, 84,   0}, // #9794
  { 6, 27,   0}, // #9795
  { 7, 55,   0}, // #9796
  { 8, 35,   0}, // #9797
  { 9, 21,   0}, // #9798
  {10, 41,   0}, // #9799
  {11, 43,   0}, // #9800
  {14, 10,   0}, // #9801
  {15, 10,   0}, // #9802
  {19, 20,   0}, // #9803
  {20, 20,   0}, // #9804
  {28, 94,   0}, // #9805
  { 1,  7,   0}, // #9806
  { 2, 28,   0}, // #9807
  { 3, 49,   0}, // #9808
  { 4, 77,   0}, // #9809
  { 5, 88,   0}, // #9810
  { 6, 28,   0}, // #9811
  { 7, 56,   0}, // #9812
  { 8, 35,   0}, // #9813
  { 9, 21,   0}, // #9814
  {10, 42,   0}, // #9815
  {11, 44,   0}, // #9816
  {14, 11,   0}, // #9817
  {15, 11,   0}, // #9818
  {19, 21,   0}, // #9819
  {20, 21,   0}, // #9820
  {28, 99,   0}, // #9821
  { 1,  7,   0}, // #9822
  { 2, 24,   0}, // #9823
  { 3, 43,   0}, // #9824
  { 4, 67,   0}, // #9825
  { 5, 73,   0}, // #9826
  { 6, 26,   0}, // #9827
  { 7, 50,   0}, // #9828
  { 8, 31,   0}, // #9829
  { 9, 17,   0}, // #9830
  {10, 36,   0}, // #9831
  {11, 36,   0}, // #9832
  {14,  9,   0}, // #9833
  {15,  8,   0}, // #9834
  {18,  1,   0}, // #9835
  {19, 19,   0}, // #9836
  {20, 19,   0}, // #9837
  {23,  1,   0}, // #9838
  {28, 83,   0}, // #9839
  { 1,  7,   0}, // #9840
  { 2, 24,   0}, // #9841
  { 3, 46,   0}, // #9842
  { 4, 74,   0}, // #9843
  { 5, 79,   0}, // #9844
  { 6, 28,   0}, // #9845
  { 7, 56,   0}, // #9846
  { 8, 34,   0}, // #9847
  { 9, 17,   0}, // #9848
  {10, 38,   0}, // #9849
  {11, 38,   0}, // #9850
  {14, 12,   0}, // #9851
  {15, 11,   0}, // #9852
  {18,  1,   0}, // #9853
  {19, 21,   0}, // #9854
  {20, 21,   0}, // #9855
  {23,  1,   0}, // #9856
  {28, 92,   0}, // #9857
  { 1,  5,   0}, // #9858
  { 2, 11,   0}, // #9859
  { 3, 18,   0}, // #9860
  { 4, 26,   0}, // #9861
  { 5, 32,   0}, // #9862
  { 6, 12,   0}, // #9863
  { 7, 20,   0}, // #9864
  { 8, 13,   0}, // #9865
  { 9,  6,   0}, // #9866
  {10, 13,   0}, // #9867
  {11, 15,   0}, // #9868
  {14,  5,   0}, // #9869
  {18,  5,   0}, // #9870
  {19,  7,   0}, // #9871
  {20,  7,   0}, // #9872
  {23,  5,   0}, // #9873
  {28, 42,   0}, // #9874
  { 1,  8,   0}, // #9875
  { 2, 22,   0}, // #9876
  { 3, 23,   0}, // #9877
  { 4, 25,   0}, // #9878
  { 5, 25,   0}, // #9879
  { 6,  9,   0}, // #9880
  { 7, 11,   0}, // #9881
  { 8, 10,   0}, // #9882
  { 9, 14,   0}, // #9883
  {10, 15,   0}, // #9884
  {11, 15,   0}, // #9885
  {14,  3,   0}, // #9886
  {15,  3,   0}, // #9887
  {19,  1,   0}, // #9888
  {20,  1,   0}, // #9889
  {28, 28,   0}, // #9890
  { 1,  1,   0}, // #9891
  { 2,  6,   0}, // #9892
  { 3,  9,   0}, // #9893
  { 4, 18,   0}, // #9894
  { 5, 20,   0}, // #9895
  { 6,  4,   0}, // #9896
  { 7, 13,   0}, // #9897
  { 8, 10,   0}, // #9898
  { 9,  5,   0}, // #9899
  {10,  6,   0}, // #9900
  {11,  6,   0}, // #9901
  {14,  3,   0}, // #9902
  {15,  3,   0}, // #9903
  {19,  1,   0}, // #9904
  {20,  1,   0}, // #9905
  {28, 23,   0}, // #9906
  { 1,  1,   0}, // #9907
  { 2,  4,   0}, // #9908
  { 3,  4,   0}, // #9909
  { 4,  8,   0}, // #9910
  { 5, 10,   0}, // #9911
  { 6,  1,   0}, // #9912
  { 7,  5,   0}, // #9913
  { 8,  5,   0}, // #9914
  { 9,  3,   0}, // #9915
  {10,  3,   0}, // #9916
  {11,  3,   0}, // #9917
  {14,  3,   0}, // #9918
  {15,  2,   0}, // #9919
  {18,  1,   0}, // #9920
  {23,  1,   0}, // #9921
  {28, 14,   0}, // #9922
  { 2,  3,   0}, // #9923
  { 3,  4,   0}, // #9924
  { 4,  9,   0}, // #9925
  { 5, 10,   0}, // #9926
  { 6,  1,   0}, // #9927
  { 7,  6,   0}, // #9928
  { 8,  5,   0}, // #9929
  { 9,  3,   0}, // #9930
  {10,  3,   0}, // #9931
  {11,  3,   0}, // #9932
  {14,  3,   0}, // #9933
  {15,  2,   0}, // #9934
  {18,  1,   0}, // #9935
  {23,  1,   0}, // #9936
  {28, 14,   0}, // #9937
  { 2,  3,   0}, // #9938
  { 3,  3,   0}, // #9939
  { 4,  8,   0}, // #9940
  { 5,  8,   0}, // #9941
  { 7,  5,   0}, // #9942
  { 8,  5,   0}, // #9943
  { 9,  3,   0}, // #9944
  {10,  3,   0}, // #9945
  {11,  3,   0}, // #9946
  {14,  3,   0}, // #9947
  {15,  2,   0}, // #9948
  {18,  1,   0}, // #9949
  {23,  1,   0}, // #9950
  {28, 12,   0}, // #9951
  { 2,  3,   0}, // #9952
  { 3,  3,   0}, // #9953
  { 4,  7,   0}, // #9954
  { 5,  8,   0}, // #9955
  { 7,  4,   0}, // #9956
  { 8,  4,   0}, // #9957
  { 9,  3,   0}, // #9958
  {10,  3,   0}, // #9959
  {11,  3,   0}, // #9960
  {14,  2,   0}, // #9961
  {15,  1,   0}, // #9962
  {18,  1,   0}, // #9963
  {23,  1,   0}, // #9964
  {28, 11,   0}, // #9965
  { 1,  1,   0}, // #9966
  { 2,  4,   0}, // #9967
  { 3, 12,   0}, // #9968
  { 4, 20,   0}, // #9969
  { 5, 22,   0}, // #9970
  { 6,  8,   0}, // #9971
  { 7, 16,   0}, // #9972
  { 8,  9,   0}, // #9973
  { 9,  3,   0}, // #9974
  {10, 10,   0}, // #9975
  {11, 10,   0}, // #9976
  {14,  3,   0}, // #9977
  {15,  1,   0}, // #9978
  {18,  2,   0}, // #9979
  {19,  7,   0}, // #9980
  {20,  7,   0}, // #9981
  {23,  2,   0}, // #9982
  {28, 27,   0}, // #9983
  { 2,  1,   0}, // #9984
  { 3,  6,   0}, // #9985
  { 4, 13,   0}, // #9986
  { 5, 18,   0}, // #9987
  { 6,  5,   0}, // #9988
  { 7, 12,   0}, // #9989
  { 8,  7,   0}, // #9990
  { 9,  1,   0}, // #9991
  {10,  6,   0}, // #9992
  {11,  6,   0}, // #9993
  {14,  2,   0}, // #9994
  {18,  2,   0}, // #9995
  {19,  5,   0}, // #9996
  {20,  5,   0}, // #9997
  {23,  2,   0}, // #9998
  {28, 22,   0}, // #9999
  { 2,  8,   0}, // #10000
  { 3, 22,   0}, // #10001
  { 4, 38,   0}, // #10002
  { 5, 44,   0}, // #10003
  { 6, 12,   0}, // #10004
  { 7, 28,   0}, // #10005
  { 8, 16,   0}, // #10006
  { 9,  7,   0}, // #10007
  {10, 19,   0}, // #10008
  {11, 21,   0}, // #10009
  {14,  2,   0}, // #10010
  {18,  2,   0}, // #10011
  {19, 12,   0}, // #10012
  {20, 12,   0}, // #10013
  {23,  2,   0}, // #10014
  {28, 48,   0}, // #10015
  { 3,  1,   0}, // #10016
  { 4,  2,   0}, // #10017
  { 5,  3,   0}, // #10018
  { 6,  1,   0}, // #10019
  { 7,  2,   0}, // #10020
  { 8,  1,   0}, // #10021
  {10,  1,   0}, // #10022
  {11,  1,   0}, // #10023
  {19,  1,   0}, // #10024
  {20,  1,   0}, // #10025
  {28,  3,   0}, // #10026
  { 2,  4,   0}, // #10027
  { 3, 10,   0}, // #10028
  { 4, 18,   0}, // #10029
  { 5, 24,   0}, // #10030
  { 6,  3,   0}, // #10031
  { 7, 11,   0}, // #10032
  { 8,  8,   0}, // #10033
  { 9,  4,   0}, // #10034
  {10,  7,   0}, // #10035
  {11,  9,   0}, // #10036
  {19,  3,   0}, // #10037
  {20,  3,   0}, // #10038
  {28, 24,   0}, // #10039
  { 1,  6,   0}, // #10040
  { 2, 21,   0}, // #10041
  { 3, 38,   0}, // #10042
  { 4, 66,   0}, // #10043
  { 5, 70,   0}, // #10044
  { 6, 23,   0}, // #10045
  { 7, 51,   0}, // #10046
  { 8, 34,   0}, // #10047
  { 9, 15,   0}, // #10048
  {10, 31,   0}, // #10049
  {11, 31,   0}, // #10050
  {14,  8,   0}, // #10051
  {15,  7,   0}, // #10052
  {18,  1,   0}, // #10053
  {19, 16,   0}, // #10054
  {20, 16,   0}, // #10055
  {23,  1,   0}, // #10056
  {28, 79,   0}, // #10057
  { 1,  6,   0}, // #10058
  { 2, 21,   0}, // #10059
  { 3, 37,   0}, // #10060
  { 4, 64,   0}, // #10061
  { 5, 70,   0}, // #10062
  { 6, 22,   0}, // #10063
  { 7, 49,   0}, // #10064
  { 8, 33,   0}, // #10065
  { 9, 15,   0}, // #10066
  {10, 31,   0}, // #10067
  {11, 31,   0}, // #10068
  {14,  8,   0}, // #10069
  {15,  7,   0}, // #10070
  {18,  1,   0}, // #10071
  {19, 16,   0}, // #10072
  {20, 16,   0}, // #10073
  {23,  1,   0}, // #10074
  {28, 79,   0}, // #10075
  { 1,  6,   0}, // #10076
  { 2, 21,   0}, // #10077
  { 3, 40,   0}, // #10078
  { 4, 70,   0}, // #10079
  { 5, 74,   0}, // #10080
  { 6, 25,   0}, // #10081
  { 7, 55,   0}, // #10082
  { 8, 36,   0}, // #10083
  { 9, 15,   0}, // #10084
  {10, 33,   0}, // #10085
  {11, 33,   0}, // #10086
  {14, 10,   0}, // #10087
  {15,  9,   0}, // #10088
  {18,  1,   0}, // #10089
  {19, 18,   0}, // #10090
  {20, 18,   0}, // #10091
  {23,  1,   0}, // #10092
  {28, 85,   0}, // #10093
  { 1,  6,   0}, // #10094
  { 2, 21,   0}, // #10095
  { 3, 39,   0}, // #10096
  { 4, 68,   0}, // #10097
  { 5, 74,   0}, // #10098
  { 6, 24,   0}, // #10099
  { 7, 53,   0}, // #10100
  { 8, 35,   0}, // #10101
  { 9, 15,   0}, // #10102
  {10, 33,   0}, // #10103
  {11, 33,   0}, // #10104
  {14, 10,   0}, // #10105
  {15,  9,   0}, // #10106
  {18,  1,   0}, // #10107
  {19, 18,   0}, // #10108
  {20, 18,   0}, // #10109
  {23,  1,   0}, // #10110
  {28, 85,   0}, // #10111
  { 1,  7,   0}, // #10112
  { 2, 23,   0}, // #10113
  { 3, 40,   0}, // #10114
  { 4, 65,   0}, // #10115
  { 5, 71,   0}, // #10116
  { 6, 24,   0}, // #10117
  { 7, 49,   0}, // #10118
  { 8, 32,   0}, // #10119
  { 9, 16,   0}, // #10120
  {10, 33,   0}, // #10121
  {11, 33,   0}, // #10122
  {14,  8,   0}, // #10123
  {15,  7,   0}, // #10124
  {18,  1,   0}, // #10125
  {19, 17,   0}, // #10126
  {20, 17,   0}, // #10127
  {23,  1,   0}, // #10128
  {28, 80,   0}, // #10129
  { 1,  7,   0}, // #10130
  { 2, 23,   0}, // #10131
  { 3, 43,   0}, // #10132
  { 4, 71,   0}, // #10133
  { 5, 77,   0}, // #10134
  { 6, 27,   0}, // #10135
  { 7, 55,   0}, // #10136
  { 8, 35,   0}, // #10137
  { 9, 16,   0}, // #10138
  {10, 36,   0}, // #10139
  {11, 36,   0}, // #10140
  {14, 11,   0}, // #10141
  {15, 10,   0}, // #10142
  {18,  1,   0}, // #10143
  {19, 20,   0}, // #10144
  {20, 20,   0}, // #10145
  {23,  1,   0}, // #10146
  {28, 89,   0}, // #10147
  { 4,  2,   0}, // #10148
  { 5,  3,   0}, // #10149
  { 7,  2,   0}, // #10150
  { 8,  2,   0}, // #10151
  {14,  1,   0}, // #10152
  {15,  1,   0}, // #10153
  {21,  2,   0}, // #10154
  {28,  4,   0}, // #10155
  { 2,  2,   0}, // #10156
  { 3,  2,   0}, // #10157
  { 4,  7,   0}, // #10158
  { 5,  8,   0}, // #10159
  { 7,  5,   0}, // #10160
  { 8,  5,   0}, // #10161
  { 9,  2,   0}, // #10162
  {10,  2,   0}, // #10163
  {11,  2,   0}, // #10164
  {14,  2,   0}, // #10165
  {15,  1,   0}, // #10166
  {18,  1,   0}, // #10167
  {23,  1,   0}, // #10168
  {28, 11,   0}, // #10169
  { 2,  3,   0}, // #10170
  { 3,  3,   0}, // #10171
  { 4,  7,   0}, // #10172
  { 5,  9,   0}, // #10173
  { 7,  4,   0}, // #10174
  { 8,  4,   0}, // #10175
  { 9,  3,   0}, // #10176
  {10,  3,   0}, // #10177
  {11,  3,   0}, // #10178
  {14,  2,   0}, // #10179
  {15,  1,   0}, // #10180
  {18,  1,   0}, // #10181
  {23,  1,   0}, // #10182
  {28, 12,   0}, // #10183
  { 1,  2,   0}, // #10184
  { 2,  9,   0}, // #10185
  { 3, 16,   0}, // #10186
  { 4, 24,   0}, // #10187
  { 5, 24,   0}, // #10188
  { 6,  6,   0}, // #10189
  { 7, 14,   0}, // #10190
  { 8,  7,   0}, // #10191
  { 9,  7,   0}, // #10192
  {10, 11,   0}, // #10193
  {11, 11,   0}, // #10194
  {14,  1,   0}, // #10195
  {15,  1,   0}, // #10196
  {19,  4,   0}, // #10197
  {20,  4,   0}, // #10198
  {28, 25,   0}, // #10199
  { 2,  1,   0}, // #10200
  { 3,  1,   0}, // #10201
  { 4,  3,   0}, // #10202
  { 5,  5,   0}, // #10203
  { 7,  2,   0}, // #10204
  { 8,  2,   0}, // #10205
  { 9,  1,   0}, // #10206
  {10,  1,   0}, // #10207
  {11,  1,   0}, // #10208
  {14,  1,   0}, // #10209
  {18,  1,   0}, // #10210
  {23,  1,   0}, // #10211
  {28,  7,   0}, // #10212
  { 3,  1,   0}, // #10213
  { 4,  1,   0}, // #10214
  { 5,  2,   0}, // #10215
  { 6,  1,   0}, // #10216
  { 7,  1,   0}, // #10217
  {10,  1,   0}, // #10218
  {11,  1,   0}, // #10219
  {19,  1,   0}, // #10220
  {20,  1,   0}, // #10221
  {28,  2,   0}, // #10222
  { 1,  6,   0}, // #10223
  { 2, 13,   0}, // #10224
  { 3, 13,   0}, // #10225
  { 4, 13,   0}, // #10226
  { 5, 13,   0}, // #10227
  { 6,  6,   0}, // #10228
  { 7,  6,   0}, // #10229
  { 8,  6,   0}, // #10230
  { 9,  7,   0}, // #10231
  {10,  7,   0}, // #10232
  {11,  7,   0}, // #10233
  {14, 18,   0}, // #10234
  {15, 18,   0}, // #10235
  {28, 31,   0}, // #10236
  { 1,  6,   0}, // #10237
  { 2, 13,   0}, // #10238
  { 3, 13,   0}, // #10239
  { 4, 13,   0}, // #10240
  { 5, 13,   0}, // #10241
  { 6,  6,   0}, // #10242
  { 7,  6,   0}, // #10243
  { 8,  6,   0}, // #10244
  { 9,  7,   0}, // #10245
  {10,  7,   0}, // #10246
  {11,  7,   0}, // #10247
  {14, 17,   0}, // #10248
  {15, 17,   0}, // #10249
  {28, 30,   0}, // #10250
  { 1,  5,   0}, // #10251
  { 2, 13,   0}, // #10252
  { 3, 13,   0}, // #10253
  { 4, 13,   0}, // #10254
  { 5, 13,   0}, // #10255
  { 6,  5,   0}, // #10256
  { 7,  5,   0}, // #10257
  { 8,  5,   0}, // #10258
  { 9,  8,   0}, // #10259
  {10,  8,   0}, // #10260
  {11,  8,   0}, // #10261
  {14, 20,   0}, // #10262
  {15, 20,   0}, // #10263
  {28, 33,   0}, // #10264
  { 1,  1,   0}, // #10265
  { 2,  1,   0}, // #10266
  { 3,  1,   0}, // #10267
  { 4,  2,   0}, // #10268
  { 5,  2,   0}, // #10269
  { 6,  1,   0}, // #10270
  { 7,  2,   0}, // #10271
  { 8,  2,   0}, // #10272
  {14,  1,   0}, // #10273
  {15,  1,   0}, // #10274
  {28,  3,   0}, // #10275
  { 2,  4,   0}, // #10276
  { 3,  5,   0}, // #10277
  { 4,  6,   0}, // #10278
  { 5,  8,   0}, // #10279
  { 6,  1,   0}, // #10280
  { 7,  2,   0}, // #10281
  { 8,  1,   0}, // #10282
  { 9,  4,   0}, // #10283
  {10,  5,   0}, // #10284
  {11,  5,   0}, // #10285
  {19,  1,   0}, // #10286
  {20,  1,   0}, // #10287
  {28,  8,   0}, // #10288
  { 1,  1,   0}, // #10289
  { 2, 43,   0}, // #10290
  { 3, 91,   0}, // #10291
  { 4, 143,   0}, // #10292
  { 5, 143,   0}, // #10293
  { 6, 49,   0}, // #10294
  { 7, 101,   0}, // #10295
  { 8, 53,   0}, // #10296
  { 9, 23,   0}, // #10297
  {10, 35,   0}, // #10298
  {11, 35,   0}, // #10299
  {14,  6,   0}, // #10300
  {15,  4,   0}, // #10301
  {18,  2,   0}, // #10302
  {19, 12,   0}, // #10303
  {20, 12,   0}, // #10304
  {23,  2,   0}, // #10305
  {28, 151,   0}, // #10306
  { 1,  1,   0}, // #10307
  { 2, 43,   0}, // #10308
  { 3, 91,   0}, // #10309
  { 4, 144,   0}, // #10310
  { 5, 144,   0}, // #10311
  { 6, 49,   0}, // #10312
  { 7, 102,   0}, // #10313
  { 8, 54,   0}, // #10314
  { 9, 23,   0}, // #10315
  {10, 35,   0}, // #10316
  {11, 35,   0}, // #10317
  {14,  6,   0}, // #10318
  {15,  4,   0}, // #10319
  {18,  2,   0}, // #10320
  {19, 12,   0}, // #10321
  {20, 12,   0}, // #10322
  {23,  2,   0}, // #10323
  {28, 152,   0}, // #10324
  { 2, 52,   0}, // #10325
  { 3, 97,   0}, // #10326
  { 4, 149,   0}, // #10327
  { 5, 149,   0}, // #10328
  { 6, 45,   0}, // #10329
  { 7, 97,   0}, // #10330
  { 8, 52,   0}, // #10331
  { 9, 27,   0}, // #10332
  {10, 37,   0}, // #10333
  {11, 37,   0}, // #10334
  {14,  5,   0}, // #10335
  {15,  4,   0}, // #10336
  {18,  1,   0}, // #10337
  {19, 10,   0}, // #10338
  {20, 10,   0}, // #10339
  {23,  1,   0}, // #10340
  {28, 155,   0}, // #10341
  { 2, 52,   0}, // #10342
  { 3, 123,   0}, // #10343
  { 4, 176,   0}, // #10344
  { 5, 176,   0}, // #10345
  { 6, 41,   0}, // #10346
  { 7, 94,   0}, // #10347
  { 8, 53,   0}, // #10348
  { 9, 29,   0}, // #10349
  {10, 68,   0}, // #10350
  {11, 68,   0}, // #10351
  {14,  6,   0}, // #10352
  {15,  4,   0}, // #10353
  {18,  2,   0}, // #10354
  {19,  9,   0}, // #10355
  {20,  9,   0}, // #10356
  {23,  2,   0}, // #10357
  {28, 184,   0}, // #10358
  { 2,  1,   0}, // #10359
  { 3,  3,   0}, // #10360
  { 4,  3,   0}, // #10361
  { 5,  3,   0}, // #10362
  { 6,  1,   0}, // #10363
  { 7,  1,   0}, // #10364
  {10,  2,   0}, // #10365
  {11,  2,   0}, // #10366
  {14,  1,   0}, // #10367
  {15,  1,   0}, // #10368
  {19,  1,   0}, // #10369
  {20,  1,   0}, // #10370
  {28,  4,   0}, // #10371
  { 2,  1,   0}, // #10372
  { 3,  3,   0}, // #10373
  { 4,  3,   0}, // #10374
  { 5,  3,   0}, // #10375
  { 6,  1,   0}, // #10376
  { 7,  1,   0}, // #10377
  {10,  2,   0}, // #10378
  {11,  2,   0}, // #10379
  {19,  1,   0}, // #10380
  {20,  1,   0}, // #10381
  {28,  3,   0}, // #10382
  { 2,  2,   0}, // #10383
  { 3,  4,   0}, // #10384
  { 4,  4,   0}, // #10385
  { 5,  4,   0}, // #10386
  { 6,  1,   0}, // #10387
  { 7,  1,   0}, // #10388
  {10,  2,   0}, // #10389
  {11,  2,   0}, // #10390
  {14,  1,   0}, // #10391
  {15,  1,   0}, // #10392
  {19,  1,   0}, // #10393
  {20,  1,   0}, // #10394
  {28,  5,   0}, // #10395
  { 2,  2,   0}, // #10396
  { 3,  4,   0}, // #10397
  { 4,  4,   0}, // #10398
  { 5,  4,   0}, // #10399
  { 6,  1,   0}, // #10400
  { 7,  1,   0}, // #10401
  {10,  2,   0}, // #10402
  {11,  2,   0}, // #10403
  {19,  1,   0}, // #10404
  {20,  1,   0}, // #10405
  {28,  4,   0}, // #10406
  { 1,  2,   0}, // #10407
  { 2,  2,   0}, // #10408
  { 3,  4,   0}, // #10409
  { 4,  4,   0}, // #10410
  { 5,  4,   0}, // #10411
  { 6,  4,   0}, // #10412
  { 7,  4,   0}, // #10413
  { 8,  2,   0}, // #10414
  {10,  2,   0}, // #10415
  {11,  2,   0}, // #10416
  {14,  1,   0}, // #10417
  {15,  1,   0}, // #10418
  {19,  2,   0}, // #10419
  {20,  2,   0}, // #10420
  {28,  5,   0}, // #10421
  { 2,  2,   0}, // #10422
  { 3,  5,   0}, // #10423
  { 4,  6,   0}, // #10424
  { 5,  6,   0}, // #10425
  { 6,  2,   0}, // #10426
  { 7,  3,   0}, // #10427
  { 8,  1,   0}, // #10428
  {10,  2,   0}, // #10429
  {11,  2,   0}, // #10430
  {14,  1,   0}, // #10431
  {15,  1,   0}, // #10432
  {19,  2,   0}, // #10433
  {20,  2,   0}, // #10434
  {28,  7,   0}, // #10435
  { 2,  2,   0}, // #10436
  { 3,  5,   0}, // #10437
  { 4,  5,   0}, // #10438
  { 5,  5,   0}, // #10439
  { 6,  2,   0}, // #10440
  { 7,  2,   0}, // #10441
  {10,  2,   0}, // #10442
  {11,  2,   0}, // #10443
  {19,  2,   0}, // #10444
  {20,  2,   0}, // #10445
  {28,  5,   0}, // #10446
  { 2,  2,   0}, // #10447
  { 3,  4,   0}, // #10448
  { 4,  5,   0}, // #10449
  { 5,  5,   0}, // #10450
  { 6,  2,   0}, // #10451
  { 7,  3,   0}, // #10452
  { 8,  1,   0}, // #10453
  {10,  2,   0}, // #10454
  {11,  2,   0}, // #10455
  {14,  1,   0}, // #10456
  {15,  1,   0}, // #10457
  {19,  2,   0}, // #10458
  {20,  2,   0}, // #10459
  {28,  6,   0}, // #10460
  { 1,  2,   0}, // #10461
  { 2,  2,   0}, // #10462
  { 3,  4,   0}, // #10463
  { 4,  5,   0}, // #10464
  { 5,  5,   0}, // #10465
  { 6,  4,   0}, // #10466
  { 7,  5,   0}, // #10467
  { 8,  3,   0}, // #10468
  {10,  2,   0}, // #10469
  {11,  2,   0}, // #10470
  {14,  1,   0}, // #10471
  {15,  1,   0}, // #10472
  {19,  2,   0}, // #10473
  {20,  2,   0}, // #10474
  {28,  6,   0}, // #10475
  { 2,  2,   0}, // #10476
  { 3,  5,   0}, // #10477
  { 4,  6,   0}, // #10478
  { 5,  6,   0}, // #10479
  { 6,  2,   0}, // #10480
  { 7,  3,   0}, // #10481
  { 8,  1,   0}, // #10482
  {10,  2,   0}, // #10483
  {11,  2,   0}, // #10484
  {19,  2,   0}, // #10485
  {20,  2,   0}, // #10486
  {28,  6,   0}, // #10487
  { 2,  2,   0}, // #10488
  { 3,  4,   0}, // #10489
  { 4,  4,   0}, // #10490
  { 5,  4,   0}, // #10491
  { 6,  2,   0}, // #10492
  { 7,  2,   0}, // #10493
  {10,  2,   0}, // #10494
  {11,  2,   0}, // #10495
  {14,  1,   0}, // #10496
  {15,  1,   0}, // #10497
  {19,  2,   0}, // #10498
  {20,  2,   0}, // #10499
  {28,  5,   0}, // #10500
  { 2,  1,   0}, // #10501
  { 3,  4,   0}, // #10502
  { 4,  5,   0}, // #10503
  { 5,  5,   0}, // #10504
  { 6,  1,   0}, // #10505
  { 7,  2,   0}, // #10506
  { 8,  1,   0}, // #10507
  {10,  1,   0}, // #10508
  {11,  1,   0}, // #10509
  {14,  1,   0}, // #10510
  {15,  1,   0}, // #10511
  {19,  1,   0}, // #10512
  {20,  1,   0}, // #10513
  {28,  6,   0}, // #10514
  { 2,  1,   0}, // #10515
  { 3,  4,   0}, // #10516
  { 4,  4,   0}, // #10517
  { 5,  4,   0}, // #10518
  { 6,  1,   0}, // #10519
  { 7,  1,   0}, // #10520
  {10,  1,   0}, // #10521
  {11,  1,   0}, // #10522
  {19,  1,   0}, // #10523
  {20,  1,   0}, // #10524
  {28,  4,   0}, // #10525
  { 2,  1,   0}, // #10526
  { 3,  4,   0}, // #10527
  { 4,  4,   0}, // #10528
  { 5,  4,   0}, // #10529
  { 6,  1,   0}, // #10530
  { 7,  1,   0}, // #10531
  {10,  2,   0}, // #10532
  {11,  2,   0}, // #10533
  {14,  1,   0}, // #10534
  {15,  1,   0}, // #10535
  {19,  1,   0}, // #10536
  {20,  1,   0}, // #10537
  {28,  5,   0}, // #10538
  { 2,  1,   0}, // #10539
  { 3,  4,   0}, // #10540
  { 4,  4,   0}, // #10541
  { 5,  4,   0}, // #10542
  { 6,  1,   0}, // #10543
  { 7,  1,   0}, // #10544
  {10,  2,   0}, // #10545
  {11,  2,   0}, // #10546
  {19,  1,   0}, // #10547
  {20,  1,   0}, // #10548
  {28,  4,   0}, // #10549
  { 1,  1,   0}, // #10550
  { 2,  1,   0}, // #10551
  { 3,  4,   0}, // #10552
  { 4,  4,   0}, // #10553
  { 5,  4,   0}, // #10554
  { 6,  4,   0}, // #10555
  { 7,  4,   0}, // #10556
  { 8,  1,   0}, // #10557
  {10,  2,   0}, // #10558
  {11,  2,   0}, // #10559
  {14,  1,   0}, // #10560
  {15,  1,   0}, // #10561
  {19,  2,   0}, // #10562
  {20,  2,   0}, // #10563
  {28,  5,   0}, // #10564
  { 1,  1,   0}, // #10565
  { 2,  1,   0}, // #10566
  { 3,  4,   0}, // #10567
  { 4,  4,   0}, // #10568
  { 5,  4,   0}, // #10569
  { 6,  4,   0}, // #10570
  { 7,  4,   0}, // #10571
  { 8,  1,   0}, // #10572
  {10,  2,   0}, // #10573
  {11,  2,   0}, // #10574
  {19,  2,   0}, // #10575
  {20,  2,   0}, // #10576
  {28,  4,   0}, // #10577
  { 2,  2,   0}, // #10578
  { 3,  5,   0}, // #10579
  { 4,  6,   0}, // #10580
  { 5,  6,   0}, // #10581
  { 6,  1,   0}, // #10582
  { 7,  2,   0}, // #10583
  { 8,  1,   0}, // #10584
  {10,  1,   0}, // #10585
  {11,  1,   0}, // #10586
  {14,  1,   0}, // #10587
  {15,  1,   0}, // #10588
  {19,  1,   0}, // #10589
  {20,  1,   0}, // #10590
  {28,  7,   0}, // #10591
  { 2,  2,   0}, // #10592
  { 3,  4,   0}, // #10593
  { 4,  4,   0}, // #10594
  { 5,  4,   0}, // #10595
  { 6,  1,   0}, // #10596
  { 7,  1,   0}, // #10597
  {10,  1,   0}, // #10598
  {11,  1,   0}, // #10599
  {19,  1,   0}, // #10600
  {20,  1,   0}, // #10601
  {28,  4,   0}, // #10602
  { 2,  2,   0}, // #10603
  { 3,  3,   0}, // #10604
  { 4,  3,   0}, // #10605
  { 5,  3,   0}, // #10606
  { 6,  1,   0}, // #10607
  { 7,  1,   0}, // #10608
  {10,  1,   0}, // #10609
  {11,  1,   0}, // #10610
  {14,  1,   0}, // #10611
  {15,  1,   0}, // #10612
  {19,  1,   0}, // #10613
  {20,  1,   0}, // #10614
  {28,  4,   0}, // #10615
  { 2,  2,   0}, // #10616
  { 3,  3,   0}, // #10617
  { 4,  3,   0}, // #10618
  { 5,  3,   0}, // #10619
  { 6,  1,   0}, // #10620
  { 7,  1,   0}, // #10621
  {10,  1,   0}, // #10622
  {11,  1,   0}, // #10623
  {19,  1,   0}, // #10624
  {20,  1,   0}, // #10625
  {28,  3,   0}, // #10626
  { 1,  1,   0}, // #10627
  { 2,  2,   0}, // #10628
  { 3,  3,   0}, // #10629
  { 4,  3,   0}, // #10630
  { 5,  3,   0}, // #10631
  { 6,  1,   0}, // #10632
  { 7,  1,   0}, // #10633
  { 8,  1,   0}, // #10634
  {28,  3,   0}, // #10635
  { 2,  1,   0}, // #10636
  { 3,  2,   0}, // #10637
  { 4,  2,   0}, // #10638
  { 5,  2,   0}, // #10639
  {14,  1,   0}, // #10640
  {15,  1,   0}, // #10641
  {28,  3,   0}, // #10642
  { 1,  2,   0}, // #10643
  { 2,  2,   0}, // #10644
  { 3,  3,   0}, // #10645
  { 4,  3,   0}, // #10646
  { 5,  3,   0}, // #10647
  { 6,  2,   0}, // #10648
  { 7,  2,   0}, // #10649
  { 8,  2,   0}, // #10650
  {14,  1,   0}, // #10651
  {15,  1,   0}, // #10652
  {28,  4,   0}, // #10653
  { 1,  2,   0}, // #10654
  { 2,  2,   0}, // #10655
  { 3,  3,   0}, // #10656
  { 4,  3,   0}, // #10657
  { 5,  3,   0}, // #10658
  { 6,  2,   0}, // #10659
  { 7,  2,   0}, // #10660
  { 8,  2,   0}, // #10661
  {28,  3,   0}, // #10662
  { 1,  4,   0}, // #10663
  { 2,  4,   0}, // #10664
  { 3,  7,   0}, // #10665
  { 4,  8,   0}, // #10666
  { 5,  8,   0}, // #10667
  { 6,  7,   0}, // #10668
  { 7,  8,   0}, // #10669
  { 8,  5,   0}, // #10670
  {10,  1,   0}, // #10671
  {11,  1,   0}, // #10672
  {14,  1,   0}, // #10673
  {15,  1,   0}, // #10674
  {19,  1,   0}, // #10675
  {20,  1,   0}, // #10676
  {28,  9,   0}, // #10677
  { 1,  4,   0}, // #10678
  { 2,  4,   0}, // #10679
  { 3,  5,   0}, // #10680
  { 4,  6,   0}, // #10681
  { 5,  6,   0}, // #10682
  { 6,  5,   0}, // #10683
  { 7,  6,   0}, // #10684
  { 8,  5,   0}, // #10685
  {10,  1,   0}, // #10686
  {11,  1,   0}, // #10687
  {19,  1,   0}, // #10688
  {20,  1,   0}, // #10689
  {28,  6,   0}, // #10690
  { 1,  1,   0}, // #10691
  { 2,  1,   0}, // #10692
  { 3,  3,   0}, // #10693
  { 4,  3,   0}, // #10694
  { 5,  3,   0}, // #10695
  { 6,  3,   0}, // #10696
  { 7,  3,   0}, // #10697
  { 8,  1,   0}, // #10698
  {10,  2,   0}, // #10699
  {11,  2,   0}, // #10700
  {14,  8,   0}, // #10701
  {15,  8,   0}, // #10702
  {19,  2,   0}, // #10703
  {20,  2,   0}, // #10704
  {28, 11,   0}, // #10705
  { 5,  1,   0}, // #10706
  {14,  2,   0}, // #10707
  {18,  2,   0}, // #10708
  {23,  2,   0}, // #10709
  {28,  5,   0}, // #10710
  { 3, 11,   0}, // #10711
  { 4, 11,   0}, // #10712
  { 5, 11,   0}, // #10713
  { 6,  8,   0}, // #10714
  { 7,  8,   0}, // #10715
  {10,  8,   0}, // #10716
  {11,  8,   0}, // #10717
  {14,  1,   0}, // #10718
  {15,  1,   0}, // #10719
  {19,  8,   0}, // #10720
  {20,  8,   0}, // #10721
  {28, 12,   0}, // #10722
  { 3, 12,   0}, // #10723
  { 4, 12,   0}, // #10724
  { 5, 12,   0}, // #10725
  { 6,  8,   0}, // #10726
  { 7,  8,   0}, // #10727
  {10,  8,   0}, // #10728
  {11,  8,   0}, // #10729
  {19,  8,   0}, // #10730
  {20,  8,   0}, // #10731
  {28, 12,   0}, // #10732
  { 1,  1,   0}, // #10733
  { 2,  9,   0}, // #10734
  { 3, 29,   0}, // #10735
  { 4, 29,   0}, // #10736
  { 5, 29,   0}, // #10737
  { 6, 12,   0}, // #10738
  { 7, 12,   0}, // #10739
  { 8,  1,   0}, // #10740
  {10, 13,   0}, // #10741
  {11, 13,   0}, // #10742
  {14,  1,   0}, // #10743
  {15,  1,   0}, // #10744
  {19, 11,   0}, // #10745
  {20, 11,   0}, // #10746
  {28, 30,   0}, // #10747
  { 1,  1,   0}, // #10748
  { 2,  9,   0}, // #10749
  { 3, 30,   0}, // #10750
  { 4, 30,   0}, // #10751
  { 5, 30,   0}, // #10752
  { 6, 12,   0}, // #10753
  { 7, 12,   0}, // #10754
  { 8,  1,   0}, // #10755
  {10, 13,   0}, // #10756
  {11, 13,   0}, // #10757
  {19, 11,   0}, // #10758
  {20, 11,   0}, // #10759
  {28, 30,   0}, // #10760
  { 1, 13,   0}, // #10761
  { 2, 13,   0}, // #10762
  { 3, 45,   0}, // #10763
  { 4, 45,   0}, // #10764
  { 5, 45,   0}, // #10765
  { 6, 45,   0}, // #10766
  { 7, 45,   0}, // #10767
  { 8, 13,   0}, // #10768
  {10, 23,   0}, // #10769
  {11, 23,   0}, // #10770
  {14,  1,   0}, // #10771
  {15,  1,   0}, // #10772
  {19, 23,   0}, // #10773
  {20, 23,   0}, // #10774
  {28, 46,   0}, // #10775
  { 1, 13,   0}, // #10776
  { 2, 13,   0}, // #10777
  { 3, 46,   0}, // #10778
  { 4, 46,   0}, // #10779
  { 5, 46,   0}, // #10780
  { 6, 46,   0}, // #10781
  { 7, 46,   0}, // #10782
  { 8, 13,   0}, // #10783
  {10, 23,   0}, // #10784
  {11, 23,   0}, // #10785
  {19, 23,   0}, // #10786
  {20, 23,   0}, // #10787
  {28, 46,   0}, // #10788
  { 3,  4,   0}, // #10789
  { 4,  4,   0}, // #10790
  { 5,  4,   0}, // #10791
  { 6,  4,   0}, // #10792
  { 7,  4,   0}, // #10793
  {10,  4,   0}, // #10794
  {11,  4,   0}, // #10795
  {14,  1,   0}, // #10796
  {15,  1,   0}, // #10797
  {19,  4,   0}, // #10798
  {20,  4,   0}, // #10799
  {28,  5,   0}, // #10800
  { 3,  4,   0}, // #10801
  { 4,  4,   0}, // #10802
  { 5,  4,   0}, // #10803
  { 6,  4,   0}, // #10804
  { 7,  4,   0}, // #10805
  {10,  4,   0}, // #10806
  {11,  4,   0}, // #10807
  {19,  4,   0}, // #10808
  {20,  4,   0}, // #10809
  {28,  4,   0}, // #10810
  { 1,  8,   0}, // #10811
  { 2,  8,   0}, // #10812
  { 3, 29,   0}, // #10813
  { 4, 29,   0}, // #10814
  { 5, 29,   0}, // #10815
  { 6, 29,   0}, // #10816
  { 7, 29,   0}, // #10817
  { 8,  8,   0}, // #10818
  {10, 14,   0}, // #10819
  {11, 14,   0}, // #10820
  {14,  1,   0}, // #10821
  {15,  1,   0}, // #10822
  {19, 14,   0}, // #10823
  {20, 14,   0}, // #10824
  {28, 30,   0}, // #10825
  { 1,  8,   0}, // #10826
  { 2,  8,   0}, // #10827
  { 3, 30,   0}, // #10828
  { 4, 30,   0}, // #10829
  { 5, 30,   0}, // #10830
  { 6, 30,   0}, // #10831
  { 7, 30,   0}, // #10832
  { 8,  8,   0}, // #10833
  {10, 14,   0}, // #10834
  {11, 14,   0}, // #10835
  {19, 14,   0}, // #10836
  {20, 14,   0}, // #10837
  {28, 30,   0}, // #10838
  { 1,  1,   0}, // #10839
  { 2,  1,   0}, // #10840
  { 3,  3,   0}, // #10841
  { 4,  4,   0}, // #10842
  { 5,  4,   0}, // #10843
  { 6,  3,   0}, // #10844
  { 7,  4,   0}, // #10845
  { 8,  2,   0}, // #10846
  {10,  2,   0}, // #10847
  {11,  2,   0}, // #10848
  {14,  1,   0}, // #10849
  {18,  1,   0}, // #10850
  {19,  2,   0}, // #10851
  {20,  2,   0}, // #10852
  {23,  1,   0}, // #10853
  {28,  6,   0}, // #10854
  { 1,  1,   0}, // #10855
  { 2,  1,   0}, // #10856
  { 3,  3,   0}, // #10857
  { 4,  3,   0}, // #10858
  { 5,  4,   0}, // #10859
  { 6,  3,   0}, // #10860
  { 7,  3,   0}, // #10861
  { 8,  1,   0}, // #10862
  {10,  2,   0}, // #10863
  {11,  2,   0}, // #10864
  {14,  2,   0}, // #10865
  {18,  2,   0}, // #10866
  {19,  2,   0}, // #10867
  {20,  2,   0}, // #10868
  {23,  2,   0}, // #10869
  {28,  8,   0}, // #10870
  { 4,  1,   0}, // #10871
  { 5,  3,   0}, // #10872
  { 7,  1,   0}, // #10873
  { 8,  1,   0}, // #10874
  {28,  3,   0}, // #10875
  {25,  1,   0}, // #10876
  {26,  1,   0}, // #10877
  {15,  1,   0}, // #10878
  {23,  1,   0}, // #10879
  {24,  1,   0}, // #10880
  {25,  1,   0}, // #10881
  {26,  1,   0}, // #10882
  {16,  1,   0}, // #10883
  {24,  1,   0}, // #10884
  {25,  1,   0}, // #10885
  {26,  1,   0}, // #10886
  {16,  2,   0}, // #10887
  {19,  1,   0}, // #10888
  {20,  1,   0}, // #10889
  {22,  1,   0}, // #10890
  {24,  2,   0}, // #10891
  {25,  3,   0}, // #10892
  {26,  6,   0}, // #10893
  {16,  1,   0}, // #10894
  {19,  1,   0}, // #10895
  {24,  1,   0}, // #10896
  {25,  1,   0}, // #10897
  {26,  2,   0}, // #10898
  {20,  1,   0}, // #10899
  {22,  1,   0}, // #10900
  {26,  2,   0}, // #10901
  {19,  1,   0}, // #10902
  {26,  1,   0}, // #10903
  {17,  1,   0}, // #10904
  {23,  1,   0}, // #10905
  {25,  1,   0}, // #10906
  {26,  1,   0}, // #10907
  { 4,  1,   0}, // #10908
  {13,  1,   0}, // #10909
  {17,  1,   0}, // #10910
  {18,  1,   0}, // #10911
  {23,  1,   0}, // #10912
  {25,  1,   0}, // #10913
  {26,  1,   0}, // #10914
  {19,  1,   0}, // #10915
  {20,  1,   0}, // #10916
  {22,  1,   0}, // #10917
  {25,  1,   0}, // #10918
  {26,  4,   0}, // #10919
  { 3,  1,   0}, // #10920
  {13,  1,   0}, // #10921
  {14,  1,   0}, // #10922
  {15,  1,   0}, // #10923
  {16,  1,   0}, // #10924
  {23,  1,   0}, // #10925
  {24,  1,   0}, // #10926
  {25,  1,   0}, // #10927
  {26,  1,   0}, // #10928
  {19,  1,   0}, // #10929
  {25,  1,   0}, // #10930
  {26,  2,   0}, // #10931
  {13,  1,   0}, // #10932
  {19,  1,   0}, // #10933
  {23,  1,   0}, // #10934
  {25,  1,   0}, // #10935
  {26,  2,   0}, // #10936
  {13,  1,   0}, // #10937
  {23,  1,   0}, // #10938
  {25,  1,   0}, // #10939
  {26,  1,   0}, // #10940
  { 3,  1,   0}, // #10941
  {13,  1,   0}, // #10942
  {14,  1,   0}, // #10943
  {15,  1,   0}, // #10944
  {16,  1,   0}, // #10945
  {19,  1,   0}, // #10946
  {23,  1,   0}, // #10947
  {24,  1,   0}, // #10948
  {25,  1,   0}, // #10949
  {26,  2,   0}, // #10950
  { 3,  2,   0}, // #10951
  {13,  2,   0}, // #10952
  {14,  2,   0}, // #10953
  {15,  2,   0}, // #10954
  {16,  2,   0}, // #10955
  {19,  1,   0}, // #10956
  {23,  2,   0}, // #10957
  {24,  2,   0}, // #10958
  {25,  2,   0}, // #10959
  {26,  3,   0}, // #10960
  { 3,  2,   0}, // #10961
  {13,  2,   0}, // #10962
  {14,  2,   0}, // #10963
  {15,  2,   0}, // #10964
  {16,  2,   0}, // #10965
  {23,  2,   0}, // #10966
  {24,  2,   0}, // #10967
  {25,  2,   0}, // #10968
  {26,  2,   0}, // #10969
  { 3,  3,   0}, // #10970
  { 8,  6,   0}, // #10971
  {13,  3,   0}, // #10972
  {14,  3,   0}, // #10973
  {15,  9,   0}, // #10974
  {16,  3,   0}, // #10975
  {17,  6,   0}, // #10976
  {19,  1,   0}, // #10977
  {21,  6,   0}, // #10978
  {23, 10,   0}, // #10979
  {24,  9,   0}, // #10980
  {25, 10,   0}, // #10981
  {26, 11,   0}, // #10982
  { 3,  3,   0}, // #10983
  { 8,  6,   0}, // #10984
  {13,  3,   0}, // #10985
  {14,  3,   0}, // #10986
  {15,  9,   0}, // #10987
  {16,  3,   0}, // #10988
  {17,  6,   0}, // #10989
  {21,  6,   0}, // #10990
  {23, 11,   0}, // #10991
  {24,  9,   0}, // #10992
  {25, 11,   0}, // #10993
  {26, 11,   0}, // #10994
  {16,  1,   0}, // #10995
  {17,  1,   0}, // #10996
  {19,  1,   0}, // #10997
  {23,  1,   0}, // #10998
  {24,  1,   0}, // #10999
  {25,  2,   0}, // #11000
  {26,  3,   0}, // #11001
  {16,  1,   0}, // #11002
  {17,  1,   0}, // #11003
  {23,  1,   0}, // #11004
  {24,  1,   0}, // #11005
  {25,  2,   0}, // #11006
  {26,  2,   0}, // #11007
  {19,  1,   0}, // #11008
  {23,  2,   0}, // #11009
  {25,  2,   0}, // #11010
  {26,  3,   0}, // #11011
  {23,  2,   0}, // #11012
  {25,  2,   0}, // #11013
  {26,  2,   0}, // #11014
  {17,  1,   0}, // #11015
  {19,  1,   0}, // #11016
  {23,  1,   0}, // #11017
  {25,  1,   0}, // #11018
  {26,  2,   0}, // #11019
  { 4,  1,   0}, // #11020
  {13,  1,   0}, // #11021
  {17,  1,   0}, // #11022
  {18,  1,   0}, // #11023
  {19,  1,   0}, // #11024
  {23,  1,   0}, // #11025
  {25,  1,   0}, // #11026
  {26,  2,   0}, // #11027
  {16,  1,   0}, // #11028
  {19,  1,   0}, // #11029
  {20,  1,   0}, // #11030
  {22,  1,   0}, // #11031
  {24,  1,   0}, // #11032
  {25,  1,   0}, // #11033
  {26,  4,   0}, // #11034
  {25,  3,   0}, // #11035
  {26,  3,   0}, // #11036
  {16,  2,   0}, // #11037
  {24,  2,   0}, // #11038
  {25,  5,   0}, // #11039
  {26,  5,   0}, // #11040
  { 8,  1,   0}, // #11041
  {13,  1,   0}, // #11042
  {15,  1,   0}, // #11043
  {17,  1,   0}, // #11044
  {19,  1,   0}, // #11045
  {21,  1,   0}, // #11046
  {23,  2,   0}, // #11047
  {24,  1,   0}, // #11048
  {25,  2,   0}, // #11049
  {26,  3,   0}, // #11050
  { 8,  1,   0}, // #11051
  {13,  1,   0}, // #11052
  {15,  1,   0}, // #11053
  {17,  1,   0}, // #11054
  {21,  1,   0}, // #11055
  {23,  2,   0}, // #11056
  {24,  1,   0}, // #11057
  {25,  2,   0}, // #11058
  {26,  2,   0}, // #11059
  {13,  2,   0}, // #11060
  {19,  1,   0}, // #11061
  {23,  2,   0}, // #11062
  {25,  2,   0}, // #11063
  {26,  3,   0}, // #11064
  {13,  2,   0}, // #11065
  {23,  2,   0}, // #11066
  {25,  2,   0}, // #11067
  {26,  2,   0}, // #11068
  { 1, 10,   0}, // #11069
  { 3,  1,   0}, // #11070
  {13,  1,   0}, // #11071
  {14,  1,   0}, // #11072
  {15,  1,   0}, // #11073
  {16,  1,   0}, // #11074
  {19,  1,   0}, // #11075
  {23,  1,   0}, // #11076
  {24,  1,   0}, // #11077
  {25,  1,   0}, // #11078
  {26,  2,   0}, // #11079
  { 3,  7,   0}, // #11080
  { 4,  2,   0}, // #11081
  { 8,  8,   0}, // #11082
  { 9,  3,   0}, // #11083
  {13,  9,   0}, // #11084
  {14,  7,   0}, // #11085
  {15, 16,   0}, // #11086
  {16, 10,   0}, // #11087
  {17, 10,   0}, // #11088
  {18,  5,   0}, // #11089
  {21, 11,   0}, // #11090
  {23, 18,   0}, // #11091
  {24, 19,   0}, // #11092
  {25, 32,   0}, // #11093
  {26, 32,   0}, // #11094
  { 1, 10,   0}, // #11095
  { 3,  1,   0}, // #11096
  {13,  1,   0}, // #11097
  {14,  1,   0}, // #11098
  {15,  1,   0}, // #11099
  {16,  1,   0}, // #11100
  {23,  1,   0}, // #11101
  {24,  1,   0}, // #11102
  {25,  1,   0}, // #11103
  {26,  1,   0}, // #11104
  { 2,  4,   0}, // #11105
  { 3,  1,   0}, // #11106
  {13,  1,   0}, // #11107
  {14,  1,   0}, // #11108
  {15,  1,   0}, // #11109
  {16,  1,   0}, // #11110
  {19,  1,   0}, // #11111
  {23,  1,   0}, // #11112
  {24,  1,   0}, // #11113
  {25,  1,   0}, // #11114
  {26,  2,   0}, // #11115
  { 2,  4,   0}, // #11116
  { 3,  1,   0}, // #11117
  {13,  1,   0}, // #11118
  {14,  1,   0}, // #11119
  {15,  1,   0}, // #11120
  {16,  1,   0}, // #11121
  {23,  1,   0}, // #11122
  {24,  1,   0}, // #11123
  {25,  1,   0}, // #11124
  {26,  1,   0}, // #11125
  { 2,  3,   0}, // #11126
  { 3,  1,   0}, // #11127
  {13,  1,   0}, // #11128
  {14,  1,   0}, // #11129
  {15,  1,   0}, // #11130
  {16,  1,   0}, // #11131
  {19,  1,   0}, // #11132
  {23,  1,   0}, // #11133
  {24,  1,   0}, // #11134
  {25,  1,   0}, // #11135
  {26,  2,   0}, // #11136
  { 2,  3,   0}, // #11137
  { 3,  1,   0}, // #11138
  {13,  1,   0}, // #11139
  {14,  1,   0}, // #11140
  {15,  1,   0}, // #11141
  {16,  1,   0}, // #11142
  {23,  1,   0}, // #11143
  {24,  1,   0}, // #11144
  {25,  1,   0}, // #11145
  {26,  1,   0}, // #11146
  { 8,  1,   0}, // #11147
  {15,  1,   0}, // #11148
  {17,  1,   0}, // #11149
  {19,  1,   0}, // #11150
  {21,  1,   0}, // #11151
  {23,  3,   0}, // #11152
  {24,  1,   0}, // #11153
  {25,  3,   0}, // #11154
  {26,  4,   0}, // #11155
  { 8,  1,   0}, // #11156
  {15,  1,   0}, // #11157
  {17,  1,   0}, // #11158
  {21,  1,   0}, // #11159
  {23,  3,   0}, // #11160
  {24,  1,   0}, // #11161
  {25,  3,   0}, // #11162
  {26,  3,   0}, // #11163
  { 8,  1,   0}, // #11164
  {15,  1,   0}, // #11165
  {17,  1,   0}, // #11166
  {19,  1,   0}, // #11167
  {21,  1,   0}, // #11168
  {23,  4,   0}, // #11169
  {24,  1,   0}, // #11170
  {25,  4,   0}, // #11171
  {26,  5,   0}, // #11172
  { 8,  1,   0}, // #11173
  {15,  1,   0}, // #11174
  {17,  1,   0}, // #11175
  {21,  1,   0}, // #11176
  {23,  4,   0}, // #11177
  {24,  1,   0}, // #11178
  {25,  4,   0}, // #11179
  {26,  4,   0}, // #11180
  {17,  1,   0}, // #11181
  {20,  1,   0}, // #11182
  {22,  1,   0}, // #11183
  {23,  1,   0}, // #11184
  {25,  1,   0}, // #11185
  {26,  3,   0}, // #11186
  { 3,  1,   0}, // #11187
  {13,  1,   0}, // #11188
  {14,  1,   0}, // #11189
  {15,  1,   0}, // #11190
  {16,  1,   0}, // #11191
  {17,  1,   0}, // #11192
  {23,  2,   0}, // #11193
  {24,  1,   0}, // #11194
  {25,  2,   0}, // #11195
  {26,  2,   0}, // #11196
  {15,  9,   0}, // #11197
  {23,  9,   0}, // #11198
  {24,  9,   0}, // #11199
  {25, 10,   0}, // #11200
  {26, 10,   0}, // #11201
  {15,  2,   0}, // #11202
  {23,  2,   0}, // #11203
  {24,  2,   0}, // #11204
  {25,  2,   0}, // #11205
  {26,  2,   0}, // #11206
  { 8,  2,   0}, // #11207
  {13,  1,   0}, // #11208
  {15,  2,   0}, // #11209
  {17,  2,   0}, // #11210
  {19,  1,   0}, // #11211
  {21,  2,   0}, // #11212
  {23,  3,   0}, // #11213
  {24,  2,   0}, // #11214
  {25,  3,   0}, // #11215
  {26,  4,   0}, // #11216
  { 8,  2,   0}, // #11217
  {13,  1,   0}, // #11218
  {15,  2,   0}, // #11219
  {17,  2,   0}, // #11220
  {21,  2,   0}, // #11221
  {23,  3,   0}, // #11222
  {24,  2,   0}, // #11223
  {25,  3,   0}, // #11224
  {26,  3,   0}, // #11225
  { 3,  2,   0}, // #11226
  { 8,  4,   0}, // #11227
  {13,  2,   0}, // #11228
  {14,  2,   0}, // #11229
  {15,  6,   0}, // #11230
  {16,  2,   0}, // #11231
  {17,  4,   0}, // #11232
  {19,  1,   0}, // #11233
  {21,  4,   0}, // #11234
  {23,  6,   0}, // #11235
  {24,  6,   0}, // #11236
  {25,  7,   0}, // #11237
  {26,  8,   0}, // #11238
  { 3,  4,   0}, // #11239
  { 4,  2,   0}, // #11240
  { 8,  4,   0}, // #11241
  { 9,  8,   0}, // #11242
  {13,  6,   0}, // #11243
  {14,  4,   0}, // #11244
  {15,  8,   0}, // #11245
  {16, 26,   0}, // #11246
  {17,  6,   0}, // #11247
  {18, 10,   0}, // #11248
  {21, 12,   0}, // #11249
  {23, 10,   0}, // #11250
  {24, 30,   0}, // #11251
  {25, 66,   0}, // #11252
  {26, 66,   0}, // #11253
  { 4,  1,   0}, // #11254
  {13,  1,   0}, // #11255
  {16,  1,   0}, // #11256
  {17,  1,   0}, // #11257
  {18,  1,   0}, // #11258
  {19,  1,   0}, // #11259
  {23,  1,   0}, // #11260
  {24,  1,   0}, // #11261
  {25,  4,   0}, // #11262
  {26,  5,   0}, // #11263
  { 4,  1,   0}, // #11264
  {13,  1,   0}, // #11265
  {16,  1,   0}, // #11266
  {17,  1,   0}, // #11267
  {18,  1,   0}, // #11268
  {23,  1,   0}, // #11269
  {24,  1,   0}, // #11270
  {25,  4,   0}, // #11271
  {26,  4,   0}, // #11272
  { 4,  1,   0}, // #11273
  {13,  1,   0}, // #11274
  {17,  1,   0}, // #11275
  {18,  1,   0}, // #11276
  {19,  1,   0}, // #11277
  {23,  1,   0}, // #11278
  {25,  2,   0}, // #11279
  {26,  3,   0}, // #11280
  { 4,  1,   0}, // #11281
  {13,  1,   0}, // #11282
  {17,  1,   0}, // #11283
  {18,  1,   0}, // #11284
  {23,  1,   0}, // #11285
  {25,  2,   0}, // #11286
  {26,  2,   0}, // #11287
  { 4,  1,   0}, // #11288
  {13,  1,   0}, // #11289
  {16,  1,   0}, // #11290
  {17,  1,   0}, // #11291
  {18,  1,   0}, // #11292
  {19,  1,   0}, // #11293
  {23,  1,   0}, // #11294
  {24,  1,   0}, // #11295
  {25,  3,   0}, // #11296
  {26,  4,   0}, // #11297
  { 4,  1,   0}, // #11298
  {13,  1,   0}, // #11299
  {16,  1,   0}, // #11300
  {17,  1,   0}, // #11301
  {18,  1,   0}, // #11302
  {23,  1,   0}, // #11303
  {24,  1,   0}, // #11304
  {25,  3,   0}, // #11305
  {26,  3,   0}, // #11306
  { 4,  1,   0}, // #11307
  { 8,  1,   0}, // #11308
  {13,  1,   0}, // #11309
  {15,  1,   0}, // #11310
  {17,  2,   0}, // #11311
  {18,  1,   0}, // #11312
  {19,  1,   0}, // #11313
  {21,  1,   0}, // #11314
  {23,  2,   0}, // #11315
  {24,  1,   0}, // #11316
  {25,  2,   0}, // #11317
  {26,  3,   0}, // #11318
  { 4,  1,   0}, // #11319
  { 8,  1,   0}, // #11320
  {13,  1,   0}, // #11321
  {15,  1,   0}, // #11322
  {17,  2,   0}, // #11323
  {18,  1,   0}, // #11324
  {21,  1,   0}, // #11325
  {23,  2,   0}, // #11326
  {24,  1,   0}, // #11327
  {25,  2,   0}, // #11328
  {26,  2,   0}, // #11329
  { 8,  1,   0}, // #11330
  {15,  1,   0}, // #11331
  {17,  1,   0}, // #11332
  {21,  1,   0}, // #11333
  {23,  1,   0}, // #11334
  {24,  1,   0}, // #11335
  {25,  1,   0}, // #11336
  {26,  1,   0}, // #11337
  { 3,  1,   0}, // #11338
  {13,  1,   0}, // #11339
  {14,  1,   0}, // #11340
  {15,  1,   0}, // #11341
  {16,  1,   0}, // #11342
  {19,  1,   0}, // #11343
  {23,  1,   0}, // #11344
  {24,  1,   0}, // #11345
  {25,  2,   0}, // #11346
  {26,  3,   0}, // #11347
  {15,  1,   0}, // #11348
  {19,  1,   0}, // #11349
  {23,  1,   0}, // #11350
  {24,  1,   0}, // #11351
  {25,  1,   0}, // #11352
  {26,  2,   0}, // #11353
  { 8,  1,   0}, // #11354
  {15,  1,   0}, // #11355
  {17,  1,   0}, // #11356
  {19,  1,   0}, // #11357
  {21,  1,   0}, // #11358
  {23,  1,   0}, // #11359
  {24,  1,   0}, // #11360
  {25,  1,   0}, // #11361
  {26,  2,   0}, // #11362
  { 8,  2,   0}, // #11363
  {15,  3,   0}, // #11364
  {17,  2,   0}, // #11365
  {19,  1,   0}, // #11366
  {21,  2,   0}, // #11367
  {23,  3,   0}, // #11368
  {24,  3,   0}, // #11369
  {25,  3,   0}, // #11370
  {26,  4,   0}, // #11371
  { 8,  2,   0}, // #11372
  {15,  3,   0}, // #11373
  {17,  2,   0}, // #11374
  {21,  2,   0}, // #11375
  {23,  3,   0}, // #11376
  {24,  3,   0}, // #11377
  {25,  3,   0}, // #11378
  {26,  3,   0}, // #11379
  { 8,  1,   0}, // #11380
  {15,  1,   0}, // #11381
  {17,  2,   0}, // #11382
  {21,  1,   0}, // #11383
  {23,  2,   0}, // #11384
  {24,  1,   0}, // #11385
  {25,  2,   0}, // #11386
  {26,  2,   0}, // #11387
  { 3,  1,   0}, // #11388
  { 8,  1,   0}, // #11389
  {13,  1,   0}, // #11390
  {14,  1,   0}, // #11391
  {15,  2,   0}, // #11392
  {16,  1,   0}, // #11393
  {17,  1,   0}, // #11394
  {19,  1,   0}, // #11395
  {21,  1,   0}, // #11396
  {23,  2,   0}, // #11397
  {24,  2,   0}, // #11398
  {25,  2,   0}, // #11399
  {26,  3,   0}, // #11400
  { 3,  1,   0}, // #11401
  { 8,  1,   0}, // #11402
  {13,  1,   0}, // #11403
  {14,  1,   0}, // #11404
  {15,  2,   0}, // #11405
  {16,  1,   0}, // #11406
  {17,  1,   0}, // #11407
  {21,  1,   0}, // #11408
  {23,  2,   0}, // #11409
  {24,  2,   0}, // #11410
  {25,  2,   0}, // #11411
  {26,  2,   0}, // #11412
  { 8,  1,   0}, // #11413
  {15,  1,   0}, // #11414
  {17,  2,   0}, // #11415
  {19,  1,   0}, // #11416
  {21,  1,   0}, // #11417
  {23,  2,   0}, // #11418
  {24,  1,   0}, // #11419
  {25,  2,   0}, // #11420
  {26,  3,   0}, // #11421
  { 3,  4,   0}, // #11422
  { 8,  3,   0}, // #11423
  {13,  4,   0}, // #11424
  {14,  4,   0}, // #11425
  {15,  7,   0}, // #11426
  {16,  4,   0}, // #11427
  {17,  3,   0}, // #11428
  {19,  1,   0}, // #11429
  {21,  3,   0}, // #11430
  {23,  7,   0}, // #11431
  {24,  7,   0}, // #11432
  {25,  8,   0}, // #11433
  {26,  9,   0}, // #11434
  { 3,  4,   0}, // #11435
  { 8,  3,   0}, // #11436
  {13,  4,   0}, // #11437
  {14,  4,   0}, // #11438
  {15,  7,   0}, // #11439
  {16,  4,   0}, // #11440
  {17,  3,   0}, // #11441
  {21,  3,   0}, // #11442
  {23,  7,   0}, // #11443
  {24,  7,   0}, // #11444
  {25,  8,   0}, // #11445
  {26,  8,   0}, // #11446
  { 3,  4,   0}, // #11447
  { 8,  3,   0}, // #11448
  {13,  4,   0}, // #11449
  {14,  4,   0}, // #11450
  {15,  7,   0}, // #11451
  {16,  4,   0}, // #11452
  {17,  3,   0}, // #11453
  {19,  1,   0}, // #11454
  {21,  3,   0}, // #11455
  {23,  8,   0}, // #11456
  {24,  7,   0}, // #11457
  {25,  9,   0}, // #11458
  {26, 10,   0}, // #11459
  { 3,  4,   0}, // #11460
  { 8,  3,   0}, // #11461
  {13,  4,   0}, // #11462
  {14,  4,   0}, // #11463
  {15,  7,   0}, // #11464
  {16,  4,   0}, // #11465
  {17,  3,   0}, // #11466
  {21,  3,   0}, // #11467
  {23,  8,   0}, // #11468
  {24,  7,   0}, // #11469
  {25,  9,   0}, // #11470
  {26,  9,   0}, // #11471
  { 3,  3,   0}, // #11472
  {13,  3,   0}, // #11473
  {14,  3,   0}, // #11474
  {15,  3,   0}, // #11475
  {16,  3,   0}, // #11476
  {19,  1,   0}, // #11477
  {23,  3,   0}, // #11478
  {24,  3,   0}, // #11479
  {25,  3,   0}, // #11480
  {26,  4,   0}, // #11481
  { 3,  3,   0}, // #11482
  {13,  3,   0}, // #11483
  {14,  3,   0}, // #11484
  {15,  3,   0}, // #11485
  {16,  3,   0}, // #11486
  {23,  3,   0}, // #11487
  {24,  3,   0}, // #11488
  {25,  3,   0}, // #11489
  {26,  3,   0}, // #11490
  {17,  2,   0}, // #11491
  {19,  1,   0}, // #11492
  {23,  3,   0}, // #11493
  {25,  3,   0}, // #11494
  {26,  4,   0}, // #11495
  {17,  2,   0}, // #11496
  {23,  3,   0}, // #11497
  {25,  3,   0}, // #11498
  {26,  3,   0}, // #11499
  {19,  1,   0}, // #11500
  {20,  1,   0}, // #11501
  {22,  1,   0}, // #11502
  {26,  3,   0}, // #11503
  {13,  1,   0}, // #11504
  {17,  1,   0}, // #11505
  {23,  2,   0}, // #11506
  {25,  2,   0}, // #11507
  {26,  2,   0}, // #11508
  {16,  2,   0}, // #11509
  {19,  1,   0}, // #11510
  {24,  2,   0}, // #11511
  {25,  2,   0}, // #11512
  {26,  3,   0}, // #11513
  {16,  3,   0}, // #11514
  {19,  1,   0}, // #11515
  {20,  1,   0}, // #11516
  {22,  1,   0}, // #11517
  {24,  3,   0}, // #11518
  {25,  3,   0}, // #11519
  {26,  6,   0}, // #11520
  {16,  6,   0}, // #11521
  {19,  1,   0}, // #11522
  {24,  6,   0}, // #11523
  {25,  6,   0}, // #11524
  {26,  7,   0}, // #11525
  {16,  3,   0}, // #11526
  {24,  3,   0}, // #11527
  {25,  3,   0}, // #11528
  {26,  3,   0}, // #11529
  {16,  1,   0}, // #11530
  {20,  1,   0}, // #11531
  {22,  1,   0}, // #11532
  {24,  1,   0}, // #11533
  {25,  1,   0}, // #11534
  {26,  3,   0}, // #11535
  { 4,  1,   0}, // #11536
  {13,  1,   0}, // #11537
  {16,  2,   0}, // #11538
  {17,  1,   0}, // #11539
  {18,  1,   0}, // #11540
  {19,  1,   0}, // #11541
  {22,  1,   0}, // #11542
  {23,  1,   0}, // #11543
  {24,  2,   0}, // #11544
  {25,  4,   0}, // #11545
  {26,  6,   0}, // #11546
  { 4,  1,   0}, // #11547
  {13,  1,   0}, // #11548
  {17,  1,   0}, // #11549
  {18,  1,   0}, // #11550
  {19,  1,   0}, // #11551
  {22,  1,   0}, // #11552
  {23,  1,   0}, // #11553
  {25,  2,   0}, // #11554
  {26,  4,   0}, // #11555
  { 4,  1,   0}, // #11556
  {13,  1,   0}, // #11557
  {16,  2,   0}, // #11558
  {17,  1,   0}, // #11559
  {18,  1,   0}, // #11560
  {23,  1,   0}, // #11561
  {24,  2,   0}, // #11562
  {25,  4,   0}, // #11563
  {26,  4,   0}, // #11564
  { 2,  6,   0}, // #11565
  { 3,  1,   0}, // #11566
  {13,  1,   0}, // #11567
  {14,  1,   0}, // #11568
  {15,  1,   0}, // #11569
  {16,  1,   0}, // #11570
  {19,  1,   0}, // #11571
  {23,  1,   0}, // #11572
  {24,  1,   0}, // #11573
  {25,  1,   0}, // #11574
  {26,  2,   0}, // #11575
  { 2,  6,   0}, // #11576
  { 3,  1,   0}, // #11577
  {13,  1,   0}, // #11578
  {14,  1,   0}, // #11579
  {15,  1,   0}, // #11580
  {16,  1,   0}, // #11581
  {23,  1,   0}, // #11582
  {24,  1,   0}, // #11583
  {25,  1,   0}, // #11584
  {26,  1,   0}, // #11585
  { 2,  7,   0}, // #11586
  { 3,  1,   0}, // #11587
  {13,  1,   0}, // #11588
  {14,  1,   0}, // #11589
  {15,  1,   0}, // #11590
  {16,  1,   0}, // #11591
  {23,  1,   0}, // #11592
  {24,  1,   0}, // #11593
  {25,  1,   0}, // #11594
  {26,  1,   0}, // #11595
  { 8,  1,   0}, // #11596
  {15,  1,   0}, // #11597
  {17,  1,   0}, // #11598
  {20,  1,   0}, // #11599
  {21,  1,   0}, // #11600
  {22,  1,   0}, // #11601
  {23,  1,   0}, // #11602
  {24,  1,   0}, // #11603
  {25,  1,   0}, // #11604
  {26,  3,   0}, // #11605
  {15,  2,   0}, // #11606
  {19,  1,   0}, // #11607
  {23,  2,   0}, // #11608
  {24,  2,   0}, // #11609
  {25,  2,   0}, // #11610
  {26,  3,   0}, // #11611
  { 8,  1,   0}, // #11612
  {13,  1,   0}, // #11613
  {15,  1,   0}, // #11614
  {17,  1,   0}, // #11615
  {20,  1,   0}, // #11616
  {21,  1,   0}, // #11617
  {22,  1,   0}, // #11618
  {23,  2,   0}, // #11619
  {24,  1,   0}, // #11620
  {25,  2,   0}, // #11621
  {26,  4,   0}, // #11622
  { 8,  1,   0}, // #11623
  {15,  2,   0}, // #11624
  {17,  1,   0}, // #11625
  {20,  1,   0}, // #11626
  {21,  1,   0}, // #11627
  {22,  1,   0}, // #11628
  {23,  2,   0}, // #11629
  {24,  2,   0}, // #11630
  {25,  2,   0}, // #11631
  {26,  4,   0}, // #11632
  { 8,  1,   0}, // #11633
  {15,  2,   0}, // #11634
  {17,  1,   0}, // #11635
  {21,  1,   0}, // #11636
  {23,  2,   0}, // #11637
  {24,  2,   0}, // #11638
  {25,  2,   0}, // #11639
  {26,  2,   0}, // #11640
  { 2,  5,   0}, // #11641
  { 3,  1,   0}, // #11642
  {13,  1,   0}, // #11643
  {14,  1,   0}, // #11644
  {15,  1,   0}, // #11645
  {16,  1,   0}, // #11646
  {19,  1,   0}, // #11647
  {23,  1,   0}, // #11648
  {24,  1,   0}, // #11649
  {25,  1,   0}, // #11650
  {26,  2,   0}, // #11651
  { 2,  5,   0}, // #11652
  { 3,  1,   0}, // #11653
  {13,  1,   0}, // #11654
  {14,  1,   0}, // #11655
  {15,  1,   0}, // #11656
  {16,  1,   0}, // #11657
  {23,  1,   0}, // #11658
  {24,  1,   0}, // #11659
  {25,  1,   0}, // #11660
  {26,  1,   0}, // #11661
  { 2, 10,   0}, // #11662
  { 3,  2,   0}, // #11663
  { 8,  1,   0}, // #11664
  {13,  2,   0}, // #11665
  {14,  2,   0}, // #11666
  {15,  3,   0}, // #11667
  {16,  2,   0}, // #11668
  {17,  1,   0}, // #11669
  {19,  1,   0}, // #11670
  {21,  1,   0}, // #11671
  {23,  3,   0}, // #11672
  {24,  3,   0}, // #11673
  {25,  3,   0}, // #11674
  {26,  4,   0}, // #11675
  { 2, 10,   0}, // #11676
  { 3,  2,   0}, // #11677
  { 8,  1,   0}, // #11678
  {13,  2,   0}, // #11679
  {14,  2,   0}, // #11680
  {15,  3,   0}, // #11681
  {16,  2,   0}, // #11682
  {17,  1,   0}, // #11683
  {21,  1,   0}, // #11684
  {23,  3,   0}, // #11685
  {24,  3,   0}, // #11686
  {25,  3,   0}, // #11687
  {26,  3,   0}, // #11688
  { 2,  8,   0}, // #11689
  { 3,  1,   0}, // #11690
  {13,  1,   0}, // #11691
  {14,  1,   0}, // #11692
  {15,  1,   0}, // #11693
  {16,  1,   0}, // #11694
  {19,  1,   0}, // #11695
  {23,  1,   0}, // #11696
  {24,  1,   0}, // #11697
  {25,  1,   0}, // #11698
  {26,  2,   0}, // #11699
  { 2,  8,   0}, // #11700
  { 3,  1,   0}, // #11701
  {13,  1,   0}, // #11702
  {14,  1,   0}, // #11703
  {15,  1,   0}, // #11704
  {16,  1,   0}, // #11705
  {23,  1,   0}, // #11706
  {24,  1,   0}, // #11707
  {25,  1,   0}, // #11708
  {26,  1,   0}, // #11709
  { 2, 16,   0}, // #11710
  { 3,  2,   0}, // #11711
  { 8,  1,   0}, // #11712
  {13,  2,   0}, // #11713
  {14,  2,   0}, // #11714
  {15,  3,   0}, // #11715
  {16,  2,   0}, // #11716
  {17,  1,   0}, // #11717
  {19,  1,   0}, // #11718
  {21,  1,   0}, // #11719
  {23,  3,   0}, // #11720
  {24,  3,   0}, // #11721
  {25,  3,   0}, // #11722
  {26,  4,   0}, // #11723
  { 2, 16,   0}, // #11724
  { 3,  2,   0}, // #11725
  { 8,  1,   0}, // #11726
  {13,  2,   0}, // #11727
  {14,  2,   0}, // #11728
  {15,  3,   0}, // #11729
  {16,  2,   0}, // #11730
  {17,  1,   0}, // #11731
  {21,  1,   0}, // #11732
  {23,  3,   0}, // #11733
  {24,  3,   0}, // #11734
  {25,  3,   0}, // #11735
  {26,  3,   0}, // #11736
  { 3,  1,   0}, // #11737
  {13,  1,   0}, // #11738
  {14,  1,   0}, // #11739
  {15,  1,   0}, // #11740
  {16,  1,   0}, // #11741
  {20,  1,   0}, // #11742
  {22,  1,   0}, // #11743
  {23,  1,   0}, // #11744
  {24,  1,   0}, // #11745
  {25,  1,   0}, // #11746
  {26,  3,   0}, // #11747
  { 2, 12,   0}, // #11748
  { 3,  2,   0}, // #11749
  { 8,  1,   0}, // #11750
  {13,  2,   0}, // #11751
  {14,  2,   0}, // #11752
  {15,  3,   0}, // #11753
  {16,  2,   0}, // #11754
  {17,  1,   0}, // #11755
  {19,  1,   0}, // #11756
  {21,  1,   0}, // #11757
  {23,  3,   0}, // #11758
  {24,  3,   0}, // #11759
  {25,  3,   0}, // #11760
  {26,  4,   0}, // #11761
  { 2, 12,   0}, // #11762
  { 3,  2,   0}, // #11763
  { 8,  1,   0}, // #11764
  {13,  2,   0}, // #11765
  {14,  2,   0}, // #11766
  {15,  3,   0}, // #11767
  {16,  2,   0}, // #11768
  {17,  1,   0}, // #11769
  {21,  1,   0}, // #11770
  {23,  3,   0}, // #11771
  {24,  3,   0}, // #11772
  {25,  3,   0}, // #11773
  {26,  3,   0}, // #11774
  { 2, 12,   0}, // #11775
  { 3,  1,   0}, // #11776
  {13,  1,   0}, // #11777
  {14,  1,   0}, // #11778
  {15,  1,   0}, // #11779
  {16,  1,   0}, // #11780
  {19,  1,   0}, // #11781
  {23,  1,   0}, // #11782
  {24,  1,   0}, // #11783
  {25,  1,   0}, // #11784
  {26,  2,   0}, // #11785
  { 2, 12,   0}, // #11786
  { 3,  1,   0}, // #11787
  {13,  1,   0}, // #11788
  {14,  1,   0}, // #11789
  {15,  1,   0}, // #11790
  {16,  1,   0}, // #11791
  {23,  1,   0}, // #11792
  {24,  1,   0}, // #11793
  {25,  1,   0}, // #11794
  {26,  1,   0}, // #11795
  { 2, 24,   0}, // #11796
  { 3,  2,   0}, // #11797
  { 8,  1,   0}, // #11798
  {13,  2,   0}, // #11799
  {14,  2,   0}, // #11800
  {15,  3,   0}, // #11801
  {16,  2,   0}, // #11802
  {17,  1,   0}, // #11803
  {19,  1,   0}, // #11804
  {21,  1,   0}, // #11805
  {23,  3,   0}, // #11806
  {24,  3,   0}, // #11807
  {25,  3,   0}, // #11808
  {26,  4,   0}, // #11809
  { 2, 24,   0}, // #11810
  { 3,  2,   0}, // #11811
  { 8,  1,   0}, // #11812
  {13,  2,   0}, // #11813
  {14,  2,   0}, // #11814
  {15,  3,   0}, // #11815
  {16,  2,   0}, // #11816
  {17,  1,   0}, // #11817
  {21,  1,   0}, // #11818
  {23,  3,   0}, // #11819
  {24,  3,   0}, // #11820
  {25,  3,   0}, // #11821
  {26,  3,   0}, // #11822
  {16,  1,   0}, // #11823
  {19,  1,   0}, // #11824
  {22,  1,   0}, // #11825
  {24,  1,   0}, // #11826
  {25,  3,   0}, // #11827
  {26,  5,   0}, // #11828
  { 4,  2,   0}, // #11829
  {13,  2,   0}, // #11830
  {16,  4,   0}, // #11831
  {17,  3,   0}, // #11832
  {18,  2,   0}, // #11833
  {19,  1,   0}, // #11834
  {22,  1,   0}, // #11835
  {23,  3,   0}, // #11836
  {24,  4,   0}, // #11837
  {25,  9,   0}, // #11838
  {26, 11,   0}, // #11839
  { 8,  2,   0}, // #11840
  {15,  2,   0}, // #11841
  {17,  2,   0}, // #11842
  {21,  2,   0}, // #11843
  {23,  2,   0}, // #11844
  {24,  2,   0}, // #11845
  {25,  2,   0}, // #11846
  {26,  2,   0}, // #11847
  { 3,  2,   0}, // #11848
  { 4,  1,   0}, // #11849
  { 8,  2,   0}, // #11850
  { 9,  4,   0}, // #11851
  {13,  3,   0}, // #11852
  {14,  2,   0}, // #11853
  {15,  6,   0}, // #11854
  {16,  6,   0}, // #11855
  {17,  3,   0}, // #11856
  {18,  5,   0}, // #11857
  {21,  6,   0}, // #11858
  {23,  7,   0}, // #11859
  {24, 10,   0}, // #11860
  {25, 15,   0}, // #11861
  {26, 15,   0}, // #11862
  { 3,  1,   0}, // #11863
  { 8,  1,   0}, // #11864
  {13,  2,   0}, // #11865
  {14,  1,   0}, // #11866
  {15,  2,   0}, // #11867
  {16,  1,   0}, // #11868
  {17,  1,   0}, // #11869
  {21,  1,   0}, // #11870
  {23,  3,   0}, // #11871
  {24,  2,   0}, // #11872
  {25,  3,   0}, // #11873
  {26,  3,   0}, // #11874
  {19,  1,   0}, // #11875
  {25,  2,   0}, // #11876
  {26,  3,   0}, // #11877
  { 9,  1,   0}, // #11878
  {16,  1,   0}, // #11879
  {18,  1,   0}, // #11880
  {21,  1,   0}, // #11881
  {24,  1,   0}, // #11882
  {25,  3,   0}, // #11883
  {26,  3,   0}, // #11884
  { 9,  1,   0}, // #11885
  {16,  2,   0}, // #11886
  {18,  1,   0}, // #11887
  {19,  1,   0}, // #11888
  {20,  1,   0}, // #11889
  {21,  1,   0}, // #11890
  {22,  1,   0}, // #11891
  {24,  2,   0}, // #11892
  {25,  5,   0}, // #11893
  {26,  8,   0}, // #11894
  {16,  1,   0}, // #11895
  {24,  1,   0}, // #11896
  {25,  2,   0}, // #11897
  {26,  2,   0}, // #11898
  { 3,  1,   0}, // #11899
  {13,  1,   0}, // #11900
  {14,  1,   0}, // #11901
  {15,  2,   0}, // #11902
  {16,  1,   0}, // #11903
  {19,  1,   0}, // #11904
  {23,  2,   0}, // #11905
  {24,  2,   0}, // #11906
  {25,  2,   0}, // #11907
  {26,  3,   0}, // #11908
  {16,  2,   0}, // #11909
  {24,  2,   0}, // #11910
  {25, 11,   0}, // #11911
  {26, 11,   0}, // #11912
  { 9,  1,   0}, // #11913
  {16,  1,   0}, // #11914
  {18,  1,   0}, // #11915
  {20,  1,   0}, // #11916
  {21,  1,   0}, // #11917
  {22,  1,   0}, // #11918
  {24,  1,   0}, // #11919
  {25,  1,   0}, // #11920
  {26,  3,   0}, // #11921
  { 9,  1,   0}, // #11922
  {16,  1,   0}, // #11923
  {18,  1,   0}, // #11924
  {21,  1,   0}, // #11925
  {24,  1,   0}, // #11926
  {25,  4,   0}, // #11927
  {26,  4,   0}, // #11928
  {16,  4,   0}, // #11929
  {17,  2,   0}, // #11930
  {19,  1,   0}, // #11931
  {20,  1,   0}, // #11932
  {22,  1,   0}, // #11933
  {23,  2,   0}, // #11934
  {24,  4,   0}, // #11935
  {25, 11,   0}, // #11936
  {26, 14,   0}, // #11937
  { 9,  1,   0}, // #11938
  {16,  4,   0}, // #11939
  {17,  1,   0}, // #11940
  {18,  1,   0}, // #11941
  {21,  1,   0}, // #11942
  {23,  1,   0}, // #11943
  {24,  4,   0}, // #11944
  {25,  7,   0}, // #11945
  {26,  7,   0}, // #11946
  { 9,  1,   0}, // #11947
  {16,  1,   0}, // #11948
  {18,  1,   0}, // #11949
  {21,  1,   0}, // #11950
  {24,  1,   0}, // #11951
  {25,  6,   0}, // #11952
  {26,  6,   0}, // #11953
  { 3,  2,   0}, // #11954
  { 8,  4,   0}, // #11955
  {13,  2,   0}, // #11956
  {14,  2,   0}, // #11957
  {15,  6,   0}, // #11958
  {16,  6,   0}, // #11959
  {17,  4,   0}, // #11960
  {19,  1,   0}, // #11961
  {20,  1,   0}, // #11962
  {21,  4,   0}, // #11963
  {22,  1,   0}, // #11964
  {23,  6,   0}, // #11965
  {24, 10,   0}, // #11966
  {25, 16,   0}, // #11967
  {26, 19,   0}, // #11968
  { 8,  2,   0}, // #11969
  {15,  2,   0}, // #11970
  {17,  2,   0}, // #11971
  {21,  2,   0}, // #11972
  {23,  2,   0}, // #11973
  {24,  2,   0}, // #11974
  {25, 22,   0}, // #11975
  {26, 22,   0}, // #11976
  { 8,  1,   0}, // #11977
  { 9,  2,   0}, // #11978
  {15,  1,   0}, // #11979
  {16,  2,   0}, // #11980
  {17,  1,   0}, // #11981
  {18,  2,   0}, // #11982
  {21,  3,   0}, // #11983
  {23,  1,   0}, // #11984
  {24,  3,   0}, // #11985
  {25, 10,   0}, // #11986
  {26, 10,   0}, // #11987
  { 8,  1,   0}, // #11988
  { 9,  1,   0}, // #11989
  {15,  1,   0}, // #11990
  {16,  2,   0}, // #11991
  {17,  1,   0}, // #11992
  {18,  1,   0}, // #11993
  {19,  1,   0}, // #11994
  {20,  1,   0}, // #11995
  {21,  2,   0}, // #11996
  {22,  1,   0}, // #11997
  {23,  1,   0}, // #11998
  {24,  3,   0}, // #11999
  {25,  5,   0}, // #12000
  {26,  8,   0}, // #12001
  { 8,  6,   0}, // #12002
  {15,  9,   0}, // #12003
  {17,  6,   0}, // #12004
  {21,  6,   0}, // #12005
  {23,  9,   0}, // #12006
  {24,  9,   0}, // #12007
  {25, 15,   0}, // #12008
  {26, 15,   0}, // #12009
  { 8,  1,   0}, // #12010
  { 9,  5,   0}, // #12011
  {15,  1,   0}, // #12012
  {16,  9,   0}, // #12013
  {17,  1,   0}, // #12014
  {18,  5,   0}, // #12015
  {19,  2,   0}, // #12016
  {21,  6,   0}, // #12017
  {22,  1,   0}, // #12018
  {23,  1,   0}, // #12019
  {24, 10,   0}, // #12020
  {25, 20,   0}, // #12021
  {26, 23,   0}, // #12022
  { 8,  1,   0}, // #12023
  { 9,  5,   0}, // #12024
  {15,  1,   0}, // #12025
  {16,  9,   0}, // #12026
  {17,  1,   0}, // #12027
  {18,  5,   0}, // #12028
  {19,  3,   0}, // #12029
  {21,  6,   0}, // #12030
  {23,  1,   0}, // #12031
  {24, 10,   0}, // #12032
  {25, 20,   0}, // #12033
  {26, 23,   0}, // #12034
  { 8,  1,   0}, // #12035
  { 9,  1,   0}, // #12036
  {15,  1,   0}, // #12037
  {16,  2,   0}, // #12038
  {17,  1,   0}, // #12039
  {18,  1,   0}, // #12040
  {21,  2,   0}, // #12041
  {23,  1,   0}, // #12042
  {24,  3,   0}, // #12043
  {25,  8,   0}, // #12044
  {26,  8,   0}, // #12045
  { 3,  4,   0}, // #12046
  { 9,  2,   0}, // #12047
  {13,  4,   0}, // #12048
  {14,  4,   0}, // #12049
  {15,  5,   0}, // #12050
  {16,  8,   0}, // #12051
  {17,  1,   0}, // #12052
  {18,  2,   0}, // #12053
  {19, 33,   0}, // #12054
  {21,  2,   0}, // #12055
  {23,  6,   0}, // #12056
  {24,  9,   0}, // #12057
  {25, 57,   0}, // #12058
  {26, 90,   0}, // #12059
  { 9,  1,   0}, // #12060
  {16,  1,   0}, // #12061
  {18,  1,   0}, // #12062
  {19,  1,   0}, // #12063
  {21,  1,   0}, // #12064
  {24,  1,   0}, // #12065
  {25,  2,   0}, // #12066
  {26,  3,   0}, // #12067
  { 3,  1,   0}, // #12068
  {13,  1,   0}, // #12069
  {14,  1,   0}, // #12070
  {15,  1,   0}, // #12071
  {16,  1,   0}, // #12072
  {23,  1,   0}, // #12073
  {24,  1,   0}, // #12074
  {25,  2,   0}, // #12075
  {26,  2,   0}, // #12076
  {16,  1,   0}, // #12077
  {24,  1,   0}, // #12078
  {25,  3,   0}, // #12079
  {26,  3,   0}, // #12080
  { 4,  2,   0}, // #12081
  {13,  2,   0}, // #12082
  {16,  3,   0}, // #12083
  {17,  2,   0}, // #12084
  {18,  2,   0}, // #12085
  {23,  2,   0}, // #12086
  {24,  3,   0}, // #12087
  {25,  7,   0}, // #12088
  {26,  7,   0}, // #12089
  {20,  1,   0}, // #12090
  {22,  1,   0}, // #12091
  {25,  1,   0}, // #12092
  {26,  3,   0}, // #12093
  {16,  1,   0}, // #12094
  {20,  1,   0}, // #12095
  {22,  1,   0}, // #12096
  {24,  1,   0}, // #12097
  {25,  2,   0}, // #12098
  {26,  4,   0}, // #12099
  { 9,  1,   0}, // #12100
  {16,  1,   0}, // #12101
  {18,  1,   0}, // #12102
  {20,  1,   0}, // #12103
  {21,  1,   0}, // #12104
  {22,  1,   0}, // #12105
  {24,  1,   0}, // #12106
  {25,  2,   0}, // #12107
  {26,  4,   0}, // #12108
  {20,  1,   0}, // #12109
  {22,  1,   0}, // #12110
  {25,  4,   0}, // #12111
  {26,  6,   0}, // #12112
  { 9,  1,   0}, // #12113
  {16,  1,   0}, // #12114
  {18,  1,   0}, // #12115
  {21,  1,   0}, // #12116
  {24,  1,   0}, // #12117
  {25,  2,   0}, // #12118
  {26,  2,   0}, // #12119
  { 9,  1,   0}, // #12120
  {16,  1,   0}, // #12121
  {18,  1,   0}, // #12122
  {19,  1,   0}, // #12123
  {21,  1,   0}, // #12124
  {24,  1,   0}, // #12125
  {25,  1,   0}, // #12126
  {26,  2,   0}, // #12127
  { 4,  1,   0}, // #12128
  { 9,  1,   0}, // #12129
  {13,  1,   0}, // #12130
  {16,  2,   0}, // #12131
  {17,  1,   0}, // #12132
  {18,  2,   0}, // #12133
  {21,  1,   0}, // #12134
  {23,  1,   0}, // #12135
  {24,  2,   0}, // #12136
  {25,  4,   0}, // #12137
  {26,  4,   0}, // #12138
  { 9,  1,   0}, // #12139
  {16,  1,   0}, // #12140
  {18,  1,   0}, // #12141
  {19,  1,   0}, // #12142
  {20,  1,   0}, // #12143
  {21,  1,   0}, // #12144
  {22,  1,   0}, // #12145
  {24,  1,   0}, // #12146
  {25,  2,   0}, // #12147
  {26,  5,   0}, // #12148
  {16,  2,   0}, // #12149
  {19,  1,   0}, // #12150
  {20,  1,   0}, // #12151
  {22,  1,   0}, // #12152
  {24,  2,   0}, // #12153
  {25,  2,   0}, // #12154
  {26,  5,   0}, // #12155
  {19,  1,   0}, // #12156
  {20,  1,   0}, // #12157
  {22,  1,   0}, // #12158
  {25,  2,   0}, // #12159
  {26,  5,   0}, // #12160
  { 8,  2,   0}, // #12161
  {15,  2,   0}, // #12162
  {17,  2,   0}, // #12163
  {19,  1,   0}, // #12164
  {21,  2,   0}, // #12165
  {23,  2,   0}, // #12166
  {24,  2,   0}, // #12167
  {25,  2,   0}, // #12168
  {26,  3,   0}, // #12169
  { 4,  1,   0}, // #12170
  { 9,  5,   0}, // #12171
  {13,  1,   0}, // #12172
  {15,  4,   0}, // #12173
  {16,  5,   0}, // #12174
  {17,  1,   0}, // #12175
  {18,  6,   0}, // #12176
  {21,  5,   0}, // #12177
  {23,  5,   0}, // #12178
  {24,  9,   0}, // #12179
  {25, 10,   0}, // #12180
  {26, 10,   0}, // #12181
  { 9,  1,   0}, // #12182
  {16,  1,   0}, // #12183
  {18,  1,   0}, // #12184
  {21,  1,   0}, // #12185
  {24,  1,   0}, // #12186
  {25,  1,   0}, // #12187
  {26,  1,   0}, // #12188
  {16,  2,   0}, // #12189
  {24,  2,   0}, // #12190
  {25,  2,   0}, // #12191
  {26,  2,   0}, // #12192
  { 4,  1,   0}, // #12193
  { 9,  1,   0}, // #12194
  {13,  1,   0}, // #12195
  {16,  1,   0}, // #12196
  {17,  1,   0}, // #12197
  {18,  2,   0}, // #12198
  {21,  1,   0}, // #12199
  {23,  1,   0}, // #12200
  {24,  1,   0}, // #12201
  {25,  4,   0}, // #12202
  {26,  4,   0}, // #12203
  { 4,  1,   0}, // #12204
  { 9,  2,   0}, // #12205
  {13,  1,   0}, // #12206
  {16,  2,   0}, // #12207
  {17,  1,   0}, // #12208
  {18,  3,   0}, // #12209
  {19,  1,   0}, // #12210
  {21,  2,   0}, // #12211
  {23,  1,   0}, // #12212
  {24,  2,   0}, // #12213
  {25,  4,   0}, // #12214
  {26,  5,   0}, // #12215
  { 4,  1,   0}, // #12216
  { 9,  1,   0}, // #12217
  {13,  1,   0}, // #12218
  {16,  2,   0}, // #12219
  {17,  1,   0}, // #12220
  {18,  2,   0}, // #12221
  {21,  1,   0}, // #12222
  {23,  1,   0}, // #12223
  {24,  2,   0}, // #12224
  {25,  3,   0}, // #12225
  {26,  3,   0}, // #12226
  {16,  1,   0}, // #12227
  {24,  1,   0}, // #12228
  {25,  5,   0}, // #12229
  {26,  5,   0}, // #12230
  { 4,  1,   0}, // #12231
  {13,  1,   0}, // #12232
  {16,  5,   0}, // #12233
  {17,  2,   0}, // #12234
  {18,  1,   0}, // #12235
  {19,  1,   0}, // #12236
  {22,  1,   0}, // #12237
  {23,  2,   0}, // #12238
  {24,  5,   0}, // #12239
  {25,  8,   0}, // #12240
  {26, 10,   0}, // #12241
  { 4,  1,   0}, // #12242
  {13,  1,   0}, // #12243
  {16,  5,   0}, // #12244
  {17,  2,   0}, // #12245
  {18,  1,   0}, // #12246
  {23,  2,   0}, // #12247
  {24,  5,   0}, // #12248
  {25,  9,   0}, // #12249
  {26,  9,   0}, // #12250
  { 4,  2,   0}, // #12251
  {13,  2,   0}, // #12252
  {16,  4,   0}, // #12253
  {17,  3,   0}, // #12254
  {18,  2,   0}, // #12255
  {23,  3,   0}, // #12256
  {24,  4,   0}, // #12257
  {25, 10,   0}, // #12258
  {26, 10,   0}, // #12259
  { 4,  1,   0}, // #12260
  { 9,  8,   0}, // #12261
  {13,  1,   0}, // #12262
  {16,  8,   0}, // #12263
  {17,  1,   0}, // #12264
  {18,  9,   0}, // #12265
  {19,  1,   0}, // #12266
  {21,  8,   0}, // #12267
  {23,  1,   0}, // #12268
  {24,  8,   0}, // #12269
  {25, 30,   0}, // #12270
  {26, 31,   0}, // #12271
  { 9, 10,   0}, // #12272
  {16, 10,   0}, // #12273
  {18, 10,   0}, // #12274
  {19,  1,   0}, // #12275
  {20,  1,   0}, // #12276
  {21, 10,   0}, // #12277
  {22,  1,   0}, // #12278
  {24, 10,   0}, // #12279
  {25, 36,   0}, // #12280
  {26, 39,   0}, // #12281
  { 9, 11,   0}, // #12282
  {16, 11,   0}, // #12283
  {18, 11,   0}, // #12284
  {19,  1,   0}, // #12285
  {20,  1,   0}, // #12286
  {21, 11,   0}, // #12287
  {22,  1,   0}, // #12288
  {24, 11,   0}, // #12289
  {25, 37,   0}, // #12290
  {26, 40,   0}, // #12291
  { 4,  1,   0}, // #12292
  { 8,  2,   0}, // #12293
  { 9,  3,   0}, // #12294
  {13,  1,   0}, // #12295
  {15,  2,   0}, // #12296
  {16,  3,   0}, // #12297
  {17,  4,   0}, // #12298
  {18,  4,   0}, // #12299
  {19,  1,   0}, // #12300
  {20,  1,   0}, // #12301
  {21,  5,   0}, // #12302
  {22,  1,   0}, // #12303
  {23,  4,   0}, // #12304
  {24,  5,   0}, // #12305
  {25, 15,   0}, // #12306
  {26, 18,   0}, // #12307
  { 3,  2,   0}, // #12308
  {13,  2,   0}, // #12309
  {14,  2,   0}, // #12310
  {15,  7,   0}, // #12311
  {16, 12,   0}, // #12312
  {19,  8,   0}, // #12313
  {23,  7,   0}, // #12314
  {24, 17,   0}, // #12315
  {25, 56,   0}, // #12316
  {26, 64,   0}, // #12317
  { 3,  4,   0}, // #12318
  { 9,  4,   0}, // #12319
  {13,  4,   0}, // #12320
  {14,  4,   0}, // #12321
  {15,  5,   0}, // #12322
  {16, 10,   0}, // #12323
  {17,  1,   0}, // #12324
  {18,  4,   0}, // #12325
  {19, 31,   0}, // #12326
  {21,  4,   0}, // #12327
  {23,  6,   0}, // #12328
  {24, 11,   0}, // #12329
  {25, 57,   0}, // #12330
  {26, 88,   0}, // #12331
  { 3,  9,   0}, // #12332
  { 4,  1,   0}, // #12333
  { 8, 16,   0}, // #12334
  { 9,  1,   0}, // #12335
  {13, 10,   0}, // #12336
  {14,  9,   0}, // #12337
  {15, 25,   0}, // #12338
  {16, 31,   0}, // #12339
  {17, 17,   0}, // #12340
  {18,  2,   0}, // #12341
  {20, 11,   0}, // #12342
  {21, 17,   0}, // #12343
  {22, 11,   0}, // #12344
  {23, 26,   0}, // #12345
  {24, 47,   0}, // #12346
  {25, 78,   0}, // #12347
  {26, 100,   0}, // #12348
  { 3,  1,   0}, // #12349
  { 8,  1,   0}, // #12350
  {13,  1,   0}, // #12351
  {14,  1,   0}, // #12352
  {15,  2,   0}, // #12353
  {16,  1,   0}, // #12354
  {17,  1,   0}, // #12355
  {19,  2,   0}, // #12356
  {21,  1,   0}, // #12357
  {23,  3,   0}, // #12358
  {24,  2,   0}, // #12359
  {25,  3,   0}, // #12360
  {26,  5,   0}, // #12361
  { 3,  1,   0}, // #12362
  { 8,  1,   0}, // #12363
  {13,  1,   0}, // #12364
  {14,  1,   0}, // #12365
  {15,  2,   0}, // #12366
  {16,  1,   0}, // #12367
  {17,  1,   0}, // #12368
  {19,  4,   0}, // #12369
  {21,  1,   0}, // #12370
  {23,  3,   0}, // #12371
  {24,  2,   0}, // #12372
  {25,  3,   0}, // #12373
  {26,  7,   0}, // #12374
  { 3,  1,   0}, // #12375
  { 8,  1,   0}, // #12376
  {13,  1,   0}, // #12377
  {14,  1,   0}, // #12378
  {15,  2,   0}, // #12379
  {16,  1,   0}, // #12380
  {17,  1,   0}, // #12381
  {19,  8,   0}, // #12382
  {21,  1,   0}, // #12383
  {23,  3,   0}, // #12384
  {24,  2,   0}, // #12385
  {25,  3,   0}, // #12386
  {26, 11,   0}, // #12387
  { 8,  5,   0}, // #12388
  {13,  5,   0}, // #12389
  {15,  5,   0}, // #12390
  {17,  5,   0}, // #12391
  {21,  5,   0}, // #12392
  {23, 14,   0}, // #12393
  {24,  5,   0}, // #12394
  {25, 14,   0}, // #12395
  {26, 14,   0}, // #12396
  { 8,  9,   0}, // #12397
  {13,  7,   0}, // #12398
  {15,  9,   0}, // #12399
  {17,  9,   0}, // #12400
  {21,  9,   0}, // #12401
  {23, 21,   0}, // #12402
  {24,  9,   0}, // #12403
  {25, 21,   0}, // #12404
  {26, 21,   0}, // #12405
  { 8, 17,   0}, // #12406
  {13, 11,   0}, // #12407
  {15, 17,   0}, // #12408
  {17, 17,   0}, // #12409
  {21, 17,   0}, // #12410
  {23, 35,   0}, // #12411
  {24, 17,   0}, // #12412
  {25, 35,   0}, // #12413
  {26, 35,   0}, // #12414
  { 3,  1,   0}, // #12415
  { 8,  2,   0}, // #12416
  {13,  1,   0}, // #12417
  {14,  1,   0}, // #12418
  {15,  3,   0}, // #12419
  {16,  1,   0}, // #12420
  {17,  2,   0}, // #12421
  {21,  2,   0}, // #12422
  {23,  3,   0}, // #12423
  {24,  3,   0}, // #12424
  {25,  3,   0}, // #12425
  {26,  3,   0}, // #12426
  {13,  1,   0}, // #12427
  {17,  2,   0}, // #12428
  {23,  3,   0}, // #12429
  {25,  3,   0}, // #12430
  {26,  3,   0}, // #12431
  { 3,  1,   0}, // #12432
  { 8,  2,   0}, // #12433
  {13,  1,   0}, // #12434
  {14,  1,   0}, // #12435
  {15,  3,   0}, // #12436
  {16,  1,   0}, // #12437
  {17,  2,   0}, // #12438
  {19,  1,   0}, // #12439
  {21,  2,   0}, // #12440
  {23,  3,   0}, // #12441
  {24,  3,   0}, // #12442
  {25,  3,   0}, // #12443
  {26,  4,   0}, // #12444
  {13,  1,   0}, // #12445
  {17,  2,   0}, // #12446
  {19,  1,   0}, // #12447
  {23,  3,   0}, // #12448
  {25,  3,   0}, // #12449
  {26,  4,   0}, // #12450
  {17,  1,   0}, // #12451
  {20,  2,   0}, // #12452
  {22,  2,   0}, // #12453
  {23,  1,   0}, // #12454
  {25,  1,   0}, // #12455
  {26,  5,   0}, // #12456
  { 8,  2,   0}, // #12457
  {15,  2,   0}, // #12458
  {17,  2,   0}, // #12459
  {21,  2,   0}, // #12460
  {23,  3,   0}, // #12461
  {24,  2,   0}, // #12462
  {25,  3,   0}, // #12463
  {26,  3,   0}, // #12464
  {13,  1,   0}, // #12465
  {20,  1,   0}, // #12466
  {22,  1,   0}, // #12467
  {23,  1,   0}, // #12468
  {25,  1,   0}, // #12469
  {26,  3,   0}, // #12470
  { 8,  2,   0}, // #12471
  {15,  2,   0}, // #12472
  {17,  2,   0}, // #12473
  {20,  1,   0}, // #12474
  {21,  2,   0}, // #12475
  {22,  1,   0}, // #12476
  {23,  2,   0}, // #12477
  {24,  2,   0}, // #12478
  {25,  2,   0}, // #12479
  {26,  4,   0}, // #12480
  { 8,  1,   0}, // #12481
  {15,  1,   0}, // #12482
  {17,  1,   0}, // #12483
  {19,  1,   0}, // #12484
  {21,  1,   0}, // #12485
  {23,  1,   0}, // #12486
  {24,  1,   0}, // #12487
  {25,  2,   0}, // #12488
  {26,  3,   0}, // #12489
  { 3,  1,   0}, // #12490
  {13,  1,   0}, // #12491
  {14,  1,   0}, // #12492
  {15,  1,   0}, // #12493
  {16,  1,   0}, // #12494
  {20,  2,   0}, // #12495
  {22,  2,   0}, // #12496
  {23,  1,   0}, // #12497
  {24,  1,   0}, // #12498
  {25,  3,   0}, // #12499
  {26,  7,   0}, // #12500
  { 3,  1,   0}, // #12501
  {13,  1,   0}, // #12502
  {14,  1,   0}, // #12503
  {15,  1,   0}, // #12504
  {16,  1,   0}, // #12505
  {20,  4,   0}, // #12506
  {22,  4,   0}, // #12507
  {23,  1,   0}, // #12508
  {24,  1,   0}, // #12509
  {25,  3,   0}, // #12510
  {26, 11,   0}, // #12511
  { 3,  1,   0}, // #12512
  {13,  1,   0}, // #12513
  {14,  1,   0}, // #12514
  {15,  1,   0}, // #12515
  {16,  1,   0}, // #12516
  {20,  8,   0}, // #12517
  {22,  8,   0}, // #12518
  {23,  1,   0}, // #12519
  {24,  1,   0}, // #12520
  {25,  3,   0}, // #12521
  {26, 19,   0}, // #12522
  { 3,  1,   0}, // #12523
  { 8,  1,   0}, // #12524
  {13,  1,   0}, // #12525
  {14,  1,   0}, // #12526
  {15,  2,   0}, // #12527
  {16,  1,   0}, // #12528
  {17,  1,   0}, // #12529
  {20, 16,   0}, // #12530
  {21,  1,   0}, // #12531
  {22, 16,   0}, // #12532
  {23,  2,   0}, // #12533
  {24,  2,   0}, // #12534
  {25,  4,   0}, // #12535
  {26, 36,   0}, // #12536
  { 3,  1,   0}, // #12537
  { 8,  1,   0}, // #12538
  {13,  1,   0}, // #12539
  {14,  1,   0}, // #12540
  {15,  2,   0}, // #12541
  {16,  1,   0}, // #12542
  {17,  1,   0}, // #12543
  {20,  2,   0}, // #12544
  {21,  1,   0}, // #12545
  {22,  2,   0}, // #12546
  {23,  2,   0}, // #12547
  {24,  2,   0}, // #12548
  {25,  4,   0}, // #12549
  {26,  8,   0}, // #12550
  { 3,  1,   0}, // #12551
  { 8,  1,   0}, // #12552
  {13,  1,   0}, // #12553
  {14,  1,   0}, // #12554
  {15,  2,   0}, // #12555
  {16,  1,   0}, // #12556
  {17,  1,   0}, // #12557
  {20,  4,   0}, // #12558
  {21,  1,   0}, // #12559
  {22,  4,   0}, // #12560
  {23,  2,   0}, // #12561
  {24,  2,   0}, // #12562
  {25,  4,   0}, // #12563
  {26, 12,   0}, // #12564
  { 3,  1,   0}, // #12565
  { 8,  1,   0}, // #12566
  {13,  1,   0}, // #12567
  {14,  1,   0}, // #12568
  {15,  2,   0}, // #12569
  {16,  1,   0}, // #12570
  {17,  1,   0}, // #12571
  {20,  8,   0}, // #12572
  {21,  1,   0}, // #12573
  {22,  8,   0}, // #12574
  {23,  2,   0}, // #12575
  {24,  2,   0}, // #12576
  {25,  4,   0}, // #12577
  {26, 20,   0}, // #12578
  { 8,  2,   0}, // #12579
  {15,  2,   0}, // #12580
  {17,  2,   0}, // #12581
  {19,  1,   0}, // #12582
  {21,  2,   0}, // #12583
  {23,  3,   0}, // #12584
  {24,  2,   0}, // #12585
  {25,  3,   0}, // #12586
  {26,  4,   0}, // #12587
  {13,  3,   0}, // #12588
  {23,  3,   0}, // #12589
  {25,  3,   0}, // #12590
  {26,  3,   0}, // #12591
  { 3,  1,   0}, // #12592
  {13,  2,   0}, // #12593
  {14,  1,   0}, // #12594
  {15,  1,   0}, // #12595
  {16,  1,   0}, // #12596
  {19,  1,   0}, // #12597
  {23,  2,   0}, // #12598
  {24,  1,   0}, // #12599
  {25,  2,   0}, // #12600
  {26,  3,   0}, // #12601
  { 4,  1,   0}, // #12602
  { 8,  2,   0}, // #12603
  {13,  3,   0}, // #12604
  {15,  2,   0}, // #12605
  {17,  3,   0}, // #12606
  {18,  1,   0}, // #12607
  {19,  1,   0}, // #12608
  {21,  2,   0}, // #12609
  {23,  7,   0}, // #12610
  {24,  2,   0}, // #12611
  {25,  7,   0}, // #12612
  {26,  8,   0}, // #12613
  {13,  3,   0}, // #12614
  {19,  1,   0}, // #12615
  {23,  3,   0}, // #12616
  {25,  3,   0}, // #12617
  {26,  4,   0}, // #12618
  { 3,  1,   0}, // #12619
  {13,  1,   0}, // #12620
  {14,  1,   0}, // #12621
  {15,  1,   0}, // #12622
  {16,  1,   0}, // #12623
  {19,  2,   0}, // #12624
  {23,  2,   0}, // #12625
  {24,  1,   0}, // #12626
  {25,  3,   0}, // #12627
  {26,  5,   0}, // #12628
  { 3,  1,   0}, // #12629
  {13,  1,   0}, // #12630
  {14,  1,   0}, // #12631
  {15,  1,   0}, // #12632
  {16,  1,   0}, // #12633
  {19,  4,   0}, // #12634
  {23,  2,   0}, // #12635
  {24,  1,   0}, // #12636
  {25,  3,   0}, // #12637
  {26,  7,   0}, // #12638
  { 3,  1,   0}, // #12639
  {13,  1,   0}, // #12640
  {14,  1,   0}, // #12641
  {15,  1,   0}, // #12642
  {16,  1,   0}, // #12643
  {19,  8,   0}, // #12644
  {23,  2,   0}, // #12645
  {24,  1,   0}, // #12646
  {25,  3,   0}, // #12647
  {26, 11,   0}, // #12648
  { 3,  1,   0}, // #12649
  {13,  1,   0}, // #12650
  {14,  1,   0}, // #12651
  {15,  1,   0}, // #12652
  {16,  1,   0}, // #12653
  {19, 16,   0}, // #12654
  {23,  2,   0}, // #12655
  {24,  1,   0}, // #12656
  {25,  3,   0}, // #12657
  {26, 19,   0}, // #12658
  { 8,  5,   0}, // #12659
  {13,  5,   0}, // #12660
  {15,  5,   0}, // #12661
  {17,  5,   0}, // #12662
  {19,  1,   0}, // #12663
  {21,  5,   0}, // #12664
  {23, 14,   0}, // #12665
  {24,  5,   0}, // #12666
  {25, 14,   0}, // #12667
  {26, 15,   0}, // #12668
  { 8,  9,   0}, // #12669
  {13,  7,   0}, // #12670
  {15,  9,   0}, // #12671
  {17,  9,   0}, // #12672
  {19,  1,   0}, // #12673
  {21,  9,   0}, // #12674
  {23, 21,   0}, // #12675
  {24,  9,   0}, // #12676
  {25, 21,   0}, // #12677
  {26, 22,   0}, // #12678
  { 8, 17,   0}, // #12679
  {13, 11,   0}, // #12680
  {15, 17,   0}, // #12681
  {17, 17,   0}, // #12682
  {19,  1,   0}, // #12683
  {21, 17,   0}, // #12684
  {23, 35,   0}, // #12685
  {24, 17,   0}, // #12686
  {25, 35,   0}, // #12687
  {26, 36,   0}, // #12688
  {16,  2,   0}, // #12689
  {20,  1,   0}, // #12690
  {22,  1,   0}, // #12691
  {24,  2,   0}, // #12692
  {25,  2,   0}, // #12693
  {26,  4,   0}, // #12694
  { 2,  1,   0}, // #12695
  { 5,  1,   0}, // #12696
  {22,  1,   0}, // #12697
  {22,  1,   0}, // #12698
  {24,  1,   0}, // #12699
  {25,  1,   0}, // #12700
  {26,  1,   0}, // #12701
  { 2,  1,   0}, // #12702
  { 3,  1,   0}, // #12703
  {22,  1,   0}, // #12704
  { 2,  3,   0}, // #12705
  { 3,  2,   0}, // #12706
  {11,  1,   0}, // #12707
  {14,  2,   0}, // #12708
  {15,  2,   0}, // #12709
  {22,  6,   0}, // #12710
  { 2,  1,   0}, // #12711
  { 3,  1,   0}, // #12712
  {14,  1,   0}, // #12713
  {15,  1,   0}, // #12714
  {22,  2,   0}, // #12715
  { 2,  1,   0}, // #12716
  {22,  1,   0}, // #12717
  {11,  1,   0}, // #12718
  {15,  1,   0}, // #12719
  {19,  1,   0}, // #12720
  {22,  2,   0}, // #12721
  {14,  1,   0}, // #12722
  {15,  1,   0}, // #12723
  {22,  1,   0}, // #12724
  { 2,  1,   0}, // #12725
  { 4,  1,   0}, // #12726
  { 5,  1,   0}, // #12727
  {22,  1,   0}, // #12728
  {11,  1,   0}, // #12729
  {14,  1,   0}, // #12730
  {15,  2,   0}, // #12731
  {19,  1,   0}, // #12732
  {22,  3,   0}, // #12733
  {14,  6,   0}, // #12734
  {15,  6,   0}, // #12735
  {22,  6,   0}, // #12736
  {14,  7,   0}, // #12737
  {15,  7,   0}, // #12738
  {22,  7,   0}, // #12739
  { 2,  1,   0}, // #12740
  { 5,  1,   0}, // #12741
  {11,  1,   0}, // #12742
  {14,  2,   0}, // #12743
  {15,  3,   0}, // #12744
  {19,  1,   0}, // #12745
  {22,  5,   0}, // #12746
  {22,  1,   0}, // #12747
  {25,  1,   0}, // #12748
  {26,  1,   0}, // #12749
  { 2,  2,   0}, // #12750
  { 3,  1,   0}, // #12751
  {11,  1,   0}, // #12752
  {14,  1,   0}, // #12753
  {15,  2,   0}, // #12754
  {19,  1,   0}, // #12755
  {22,  5,   0}, // #12756
  { 2,  2,   0}, // #12757
  { 3,  1,   0}, // #12758
  {22,  2,   0}, // #12759
  { 2,  1,   0}, // #12760
  { 5,  1,   0}, // #12761
  {14,  1,   0}, // #12762
  {15,  1,   0}, // #12763
  {22,  2,   0}, // #12764
  {14,  1,   0}, // #12765
  {15,  1,   0}, // #12766
  {22,  2,   0}, // #12767
  {26,  1,   0}, // #12768
  {29,  1,   0}, // #12769
  {22,  1,   0}, // #12770
  {26,  1,   0}, // #12771
  {29,  1,   0}, // #12772
  {14,  7,   0}, // #12773
  {15,  7,   0}, // #12774
  {22, 11,   0}, // #12775
  {25,  4,   0}, // #12776
  {26,  4,   0}, // #12777
  {22,  4,   0}, // #12778
  {25,  4,   0}, // #12779
  {26,  4,   0}, // #12780
  {14,  6,   0}, // #12781
  {15,  6,   0}, // #12782
  {22,  7,   0}, // #12783
  {26,  1,   0}, // #12784
  { 2,  2,   0}, // #12785
  { 5,  2,   0}, // #12786
  {22,  2,   0}, // #12787
  { 2,  1,   0}, // #12788
  { 5,  1,   0}, // #12789
  {14,  4,   0}, // #12790
  {15,  4,   0}, // #12791
  {22,  5,   0}, // #12792
  { 2,  9,   0}, // #12793
  { 3,  3,   0}, // #12794
  { 5,  2,   0}, // #12795
  {14,  1,   0}, // #12796
  {15,  1,   0}, // #12797
  {22, 10,   0}, // #12798
  { 2,  1,   0}, // #12799
  { 5,  1,   0}, // #12800
  {11,  1,   0}, // #12801
  {14,  1,   0}, // #12802
  {15,  2,   0}, // #12803
  {19,  1,   0}, // #12804
  {22,  4,   0}, // #12805
  { 2,  8,   0}, // #12806
  { 3,  3,   0}, // #12807
  { 5,  2,   0}, // #12808
  {11,  1,   0}, // #12809
  {14,  1,   0}, // #12810
  {15,  2,   0}, // #12811
  {19,  1,   0}, // #12812
  {22, 11,   0}, // #12813
  { 2,  1,   0}, // #12814
  {14,  4,   0}, // #12815
  {15,  4,   0}, // #12816
  {22,  5,   0}, // #12817
  { 2,  3,   0}, // #12818
  {22,  3,   0}, // #12819
  {14,  6,   0}, // #12820
  {15,  6,   0}, // #12821
  {22, 10,   0}, // #12822
  {25,  4,   0}, // #12823
  {26,  4,   0}, // #12824
  { 2,  5,   0}, // #12825
  { 3,  2,   0}, // #12826
  {22,  5,   0}, // #12827
  {14,  6,   0}, // #12828
  {15,  6,   0}, // #12829
  {22,  9,   0}, // #12830
  {25,  3,   0}, // #12831
  {26,  3,   0}, // #12832
  {22,  3,   0}, // #12833
  {25,  3,   0}, // #12834
  {26,  3,   0}, // #12835
  { 2,  3,   0}, // #12836
  { 5,  3,   0}, // #12837
  {14,  4,   0}, // #12838
  {15,  4,   0}, // #12839
  {22,  7,   0}, // #12840
  { 2,  3,   0}, // #12841
  { 5,  3,   0}, // #12842
  {22,  3,   0}, // #12843
  {14,  1,   0}, // #12844
  {15,  1,   0}, // #12845
  {22,  2,   0}, // #12846
  {25,  1,   0}, // #12847
  {26,  1,   0}, // #12848
  {22,  2,   0}, // #12849
  {25,  1,   0}, // #12850
  {26,  2,   0}, // #12851
  {29,  1,   0}, // #12852
  {14,  1,   0}, // #12853
  {15,  1,   0}, // #12854
  {22,  3,   0}, // #12855
  {25,  1,   0}, // #12856
  {26,  2,   0}, // #12857
  {29,  1,   0}, // #12858
  {22,  5,   0}, // #12859
  {25,  4,   0}, // #12860
  {26,  5,   0}, // #12861
  {29,  1,   0}, // #12862
  {14,  4,   0}, // #12863
  {15,  4,   0}, // #12864
  {22, 11,   0}, // #12865
  {25,  7,   0}, // #12866
  {26,  7,   0}, // #12867
  {22,  7,   0}, // #12868
  {25,  7,   0}, // #12869
  {26,  7,   0}, // #12870
  {14,  6,   0}, // #12871
  {15,  6,   0}, // #12872
  {22, 11,   0}, // #12873
  {25,  4,   0}, // #12874
  {26,  5,   0}, // #12875
  {29,  1,   0}, // #12876
  { 2,  4,   0}, // #12877
  { 5,  4,   0}, // #12878
  {22,  8,   0}, // #12879
  {25,  4,   0}, // #12880
  {26,  4,   0}, // #12881
  { 2,  4,   0}, // #12882
  { 4,  3,   0}, // #12883
  { 5,  3,   0}, // #12884
  {14,  1,   0}, // #12885
  {15,  1,   0}, // #12886
  {22,  5,   0}, // #12887
  { 2,  4,   0}, // #12888
  { 4,  3,   0}, // #12889
  { 5,  3,   0}, // #12890
  {22,  4,   0}, // #12891
  { 2,  3,   0}, // #12892
  { 4,  3,   0}, // #12893
  { 5,  3,   0}, // #12894
  {14,  1,   0}, // #12895
  {15,  1,   0}, // #12896
  {22,  4,   0}, // #12897
  { 2,  3,   0}, // #12898
  { 4,  3,   0}, // #12899
  { 5,  3,   0}, // #12900
  {22,  3,   0}, // #12901
  {14,  6,   0}, // #12902
  {15,  6,   0}, // #12903
  {22, 16,   0}, // #12904
  {25, 10,   0}, // #12905
  {26, 10,   0}, // #12906
  {22, 10,   0}, // #12907
  {25, 10,   0}, // #12908
  {26, 10,   0}, // #12909
  {14,  6,   0}, // #12910
  {15,  6,   0}, // #12911
  {22, 13,   0}, // #12912
  {25,  7,   0}, // #12913
  {26,  7,   0}, // #12914
  {14,  1,   0}, // #12915
  {15,  1,   0}, // #12916
  {22,  4,   0}, // #12917
  {25,  2,   0}, // #12918
  {26,  3,   0}, // #12919
  {29,  1,   0}, // #12920
  {22,  3,   0}, // #12921
  {25,  2,   0}, // #12922
  {26,  3,   0}, // #12923
  {29,  1,   0}, // #12924
  {14,  1,   0}, // #12925
  {15,  1,   0}, // #12926
  {22,  7,   0}, // #12927
  {25,  3,   0}, // #12928
  {26,  6,   0}, // #12929
  {29,  3,   0}, // #12930
  {22,  6,   0}, // #12931
  {25,  3,   0}, // #12932
  {26,  6,   0}, // #12933
  {29,  3,   0}, // #12934
  {11,  1,   0}, // #12935
  {15,  1,   0}, // #12936
  {19,  1,   0}, // #12937
  {22,  3,   0}, // #12938
  {26,  1,   0}, // #12939
  {29,  1,   0}, // #12940
  {22,  4,   0}, // #12941
  {25,  3,   0}, // #12942
  {26,  4,   0}, // #12943
  {29,  1,   0}, // #12944
  { 2,  1,   0}, // #12945
  { 4,  1,   0}, // #12946
  { 5,  1,   0}, // #12947
  {22, 10,   0}, // #12948
  {25,  8,   0}, // #12949
  {26,  9,   0}, // #12950
  {29,  1,   0}, // #12951
  {22,  2,   0}, // #12952
  {26,  2,   0}, // #12953
  {29,  2,   0}, // #12954
  {14,  6,   0}, // #12955
  {15,  6,   0}, // #12956
  {22,  7,   0}, // #12957
  {25,  1,   0}, // #12958
  {26,  1,   0}, // #12959
  {14,  6,   0}, // #12960
  {15,  6,   0}, // #12961
  {22, 11,   0}, // #12962
  {26,  5,   0}, // #12963
  {29,  5,   0}, // #12964
  {22,  5,   0}, // #12965
  {26,  5,   0}, // #12966
  {29,  5,   0}, // #12967
  { 2,  4,   0}, // #12968
  { 5,  3,   0}, // #12969
  {14,  1,   0}, // #12970
  {15,  1,   0}, // #12971
  {22,  5,   0}, // #12972
  { 2,  4,   0}, // #12973
  { 5,  3,   0}, // #12974
  {22,  4,   0}, // #12975
  { 2,  3,   0}, // #12976
  { 5,  3,   0}, // #12977
  {14,  1,   0}, // #12978
  {15,  1,   0}, // #12979
  {22,  4,   0}, // #12980
  { 2,  3,   0}, // #12981
  { 3,  1,   0}, // #12982
  { 5,  2,   0}, // #12983
  {14,  1,   0}, // #12984
  {15,  1,   0}, // #12985
  {22,  4,   0}, // #12986
  { 2,  3,   0}, // #12987
  { 3,  1,   0}, // #12988
  { 5,  2,   0}, // #12989
  {22,  3,   0}, // #12990
  { 2,  2,   0}, // #12991
  { 5,  1,   0}, // #12992
  {14,  1,   0}, // #12993
  {15,  1,   0}, // #12994
  {22,  3,   0}, // #12995
  { 2,  2,   0}, // #12996
  { 5,  1,   0}, // #12997
  {22,  2,   0}, // #12998
  { 2,  2,   0}, // #12999
  { 3,  1,   0}, // #13000
  { 5,  1,   0}, // #13001
  {14,  1,   0}, // #13002
  {15,  1,   0}, // #13003
  {22,  3,   0}, // #13004
  { 2,  2,   0}, // #13005
  { 3,  1,   0}, // #13006
  { 5,  1,   0}, // #13007
  {22,  2,   0}, // #13008
  {15,  1,   0}, // #13009
  {19,  1,   0}, // #13010
  {22,  4,   0}, // #13011
  {25,  1,   0}, // #13012
  {26,  3,   0}, // #13013
  {29,  1,   0}, // #13014
  { 2,  1,   0}, // #13015
  { 4,  1,   0}, // #13016
  { 5,  1,   0}, // #13017
  {14,  1,   0}, // #13018
  {15,  1,   0}, // #13019
  {22,  2,   0}, // #13020
  {14,  1,   0}, // #13021
  {15,  1,   0}, // #13022
  {22,  2,   0}, // #13023
  {24,  1,   0}, // #13024
  {25,  1,   0}, // #13025
  {26,  1,   0}, // #13026
  {14,  1,   0}, // #13027
  {15,  1,   0}, // #13028
  {22,  4,   0}, // #13029
  {26,  3,   0}, // #13030
  {29,  2,   0}, // #13031
  {22,  3,   0}, // #13032
  {26,  3,   0}, // #13033
  {29,  2,   0}, // #13034
  {14,  6,   0}, // #13035
  {15,  6,   0}, // #13036
  {22,  7,   0}, // #13037
  {26,  1,   0}, // #13038
  {29,  1,   0}, // #13039
  { 2,  4,   0}, // #13040
  { 5,  4,   0}, // #13041
  {22,  5,   0}, // #13042
  {26,  1,   0}, // #13043
  {29,  1,   0}, // #13044
  {14,  1,   0}, // #13045
  {15,  1,   0}, // #13046
  {22,  3,   0}, // #13047
  {26,  2,   0}, // #13048
  {29,  2,   0}, // #13049
  { 2,  3,   0}, // #13050
  { 5,  2,   0}, // #13051
  {14,  1,   0}, // #13052
  {15,  1,   0}, // #13053
  {22,  4,   0}, // #13054
  { 2,  3,   0}, // #13055
  { 5,  2,   0}, // #13056
  {22,  3,   0}, // #13057
  { 2,  2,   0}, // #13058
  { 5,  2,   0}, // #13059
  {14,  1,   0}, // #13060
  {15,  1,   0}, // #13061
  {22,  3,   0}, // #13062
  {14,  6,   0}, // #13063
  {15,  6,   0}, // #13064
  {22,  9,   0}, // #13065
  {26,  3,   0}, // #13066
  { 1,  3,   0}, // #13067
  { 2,  7,   0}, // #13068
  { 3,  3,   0}, // #13069
  { 5,  3,   0}, // #13070
  {14,  1,   0}, // #13071
  {15,  1,   0}, // #13072
  {22,  8,   0}, // #13073
  { 1,  3,   0}, // #13074
  { 2,  8,   0}, // #13075
  { 3,  4,   0}, // #13076
  { 5,  2,   0}, // #13077
  {22,  8,   0}, // #13078
  { 1,  3,   0}, // #13079
  { 2,  8,   0}, // #13080
  { 3,  3,   0}, // #13081
  { 5,  3,   0}, // #13082
  {14,  1,   0}, // #13083
  {15,  1,   0}, // #13084
  {22,  9,   0}, // #13085
  { 1,  3,   0}, // #13086
  { 2,  9,   0}, // #13087
  { 3,  3,   0}, // #13088
  { 5,  3,   0}, // #13089
  {22,  9,   0}, // #13090
  { 1,  3,   0}, // #13091
  { 2,  3,   0}, // #13092
  { 3,  3,   0}, // #13093
  {14,  1,   0}, // #13094
  {15,  1,   0}, // #13095
  {22,  4,   0}, // #13096
  { 1,  3,   0}, // #13097
  { 2,  3,   0}, // #13098
  { 3,  3,   0}, // #13099
  {22,  3,   0}, // #13100
  {14,  6,   0}, // #13101
  {15,  6,   0}, // #13102
  {22, 10,   0}, // #13103
  {25,  3,   0}, // #13104
  {26,  4,   0}, // #13105
  {29,  1,   0}, // #13106
  { 2,  3,   0}, // #13107
  { 5,  2,   0}, // #13108
  {11,  1,   0}, // #13109
  {14,  1,   0}, // #13110
  {15,  2,   0}, // #13111
  {19,  1,   0}, // #13112
  {22,  6,   0}, // #13113
  { 2,  6,   0}, // #13114
  { 5,  4,   0}, // #13115
  {22,  6,   0}, // #13116
  { 2,  7,   0}, // #13117
  { 5,  5,   0}, // #13118
  {11,  1,   0}, // #13119
  {14,  1,   0}, // #13120
  {15,  2,   0}, // #13121
  {19,  1,   0}, // #13122
  {22, 10,   0}, // #13123
  { 2,  9,   0}, // #13124
  { 5,  7,   0}, // #13125
  {22,  9,   0}, // #13126
  {14,  6,   0}, // #13127
  {15,  6,   0}, // #13128
  {22, 14,   0}, // #13129
  {25,  8,   0}, // #13130
  {26,  8,   0}, // #13131
  {22,  8,   0}, // #13132
  {25,  8,   0}, // #13133
  {26,  8,   0}, // #13134
  { 2,  1,   0}, // #13135
  { 5,  1,   0}, // #13136
  {11,  1,   0}, // #13137
  {14,  5,   0}, // #13138
  {15,  6,   0}, // #13139
  {19,  1,   0}, // #13140
  {22,  8,   0}, // #13141
  { 2,  2,   0}, // #13142
  { 5,  2,   0}, // #13143
  {14,  4,   0}, // #13144
  {15,  4,   0}, // #13145
  {22,  6,   0}, // #13146
  { 2,  2,   0}, // #13147
  { 3,  2,   0}, // #13148
  {11,  1,   0}, // #13149
  {14,  1,   0}, // #13150
  {15,  2,   0}, // #13151
  {19,  1,   0}, // #13152
  {22,  5,   0}, // #13153
  { 2,  4,   0}, // #13154
  { 3,  4,   0}, // #13155
  {22,  4,   0}, // #13156
  { 2,  2,   0}, // #13157
  { 3,  2,   0}, // #13158
  {22,  2,   0}, // #13159
  { 2,  2,   0}, // #13160
  { 5,  2,   0}, // #13161
  {11,  1,   0}, // #13162
  {15,  1,   0}, // #13163
  {19,  1,   0}, // #13164
  {22,  4,   0}, // #13165
  { 2,  2,   0}, // #13166
  { 5,  1,   0}, // #13167
  {11,  1,   0}, // #13168
  {14,  1,   0}, // #13169
  {15,  2,   0}, // #13170
  {19,  1,   0}, // #13171
  {22,  5,   0}, // #13172
  {14,  6,   0}, // #13173
  {15,  6,   0}, // #13174
  {22, 21,   0}, // #13175
  {25, 15,   0}, // #13176
  {26, 15,   0}, // #13177
  {22, 15,   0}, // #13178
  {25, 15,   0}, // #13179
  {26, 15,   0}, // #13180
  {22,  1,   0}, // #13181
  {23,  7,   0}, // #13182
  {25,  1,   0}, // #13183
  {26,  1,   0}, // #13184
  { 2,  1,   0}, // #13185
  { 3,  1,   0}, // #13186
  {11,  1,   0}, // #13187
  {15,  1,   0}, // #13188
  {19,  1,   0}, // #13189
  {22,  9,   0}, // #13190
  {25,  6,   0}, // #13191
  {26,  6,   0}, // #13192
  {14,  7,   0}, // #13193
  {15,  7,   0}, // #13194
  {22,  8,   0}, // #13195
  {26,  1,   0}, // #13196
  {22,  7,   0}, // #13197
  {25,  4,   0}, // #13198
  {26,  7,   0}, // #13199
  {29,  3,   0}, // #13200
  {14,  7,   0}, // #13201
  {15,  7,   0}, // #13202
  {22, 10,   0}, // #13203
  {26,  3,   0}, // #13204
  {29,  3,   0}, // #13205
  {11,  1,   0}, // #13206
  {15,  1,   0}, // #13207
  {19,  1,   0}, // #13208
  {22,  6,   0}, // #13209
  {25,  4,   0}, // #13210
  {26,  4,   0}, // #13211
  {14,  7,   0}, // #13212
  {15,  7,   0}, // #13213
  {22, 14,   0}, // #13214
  {25,  7,   0}, // #13215
  {26,  7,   0}, // #13216
  {14,  7,   0}, // #13217
  {15,  7,   0}, // #13218
  {22, 17,   0}, // #13219
  {25, 10,   0}, // #13220
  {26, 10,   0}, // #13221
  {14,  7,   0}, // #13222
  {15,  7,   0}, // #13223
  {22, 15,   0}, // #13224
  {25,  8,   0}, // #13225
  {26,  8,   0}, // #13226
  {14,  7,   0}, // #13227
  {15,  7,   0}, // #13228
  {22,  8,   0}, // #13229
  {25,  1,   0}, // #13230
  {26,  1,   0}, // #13231
  {14,  7,   0}, // #13232
  {15,  7,   0}, // #13233
  {22, 12,   0}, // #13234
  {26,  5,   0}, // #13235
  {29,  5,   0}, // #13236
  {11,  1,   0}, // #13237
  {15,  1,   0}, // #13238
  {19,  1,   0}, // #13239
  {22,  3,   0}, // #13240
  {25,  1,   0}, // #13241
  {26,  1,   0}, // #13242
  {14,  7,   0}, // #13243
  {15,  7,   0}, // #13244
  {22, 10,   0}, // #13245
  {25,  3,   0}, // #13246
  {26,  3,   0}, // #13247
  {14,  7,   0}, // #13248
  {15,  7,   0}, // #13249
  {22,  8,   0}, // #13250
  {26,  1,   0}, // #13251
  {29,  1,   0}, // #13252
  {14,  7,   0}, // #13253
  {15,  7,   0}, // #13254
  {22, 22,   0}, // #13255
  {25, 15,   0}, // #13256
  {26, 15,   0}, // #13257
  {22,  5,   0}, // #13258
  {25,  5,   0}, // #13259
  {26,  5,   0}, // #13260
  { 2,  7,   0}, // #13261
  { 3,  4,   0}, // #13262
  { 5,  3,   0}, // #13263
  {22, 15,   0}, // #13264
  {25,  2,   0}, // #13265
  {26,  8,   0}, // #13266
  {14,  8,   0}, // #13267
  {15,  8,   0}, // #13268
  {22, 12,   0}, // #13269
  {25,  4,   0}, // #13270
  {26,  4,   0}, // #13271
  { 2,  1,   0}, // #13272
  { 5,  1,   0}, // #13273
  {14,  1,   0}, // #13274
  {15,  1,   0}, // #13275
  {22,  3,   0}, // #13276
  {25,  1,   0}, // #13277
  {26,  1,   0}, // #13278
  { 2,  2,   0}, // #13279
  { 5,  2,   0}, // #13280
  {22,  3,   0}, // #13281
  {25,  1,   0}, // #13282
  {26,  1,   0}, // #13283
  { 2,  4,   0}, // #13284
  { 5,  4,   0}, // #13285
  {22,  9,   0}, // #13286
  {25,  4,   0}, // #13287
  {26,  5,   0}, // #13288
  {29,  1,   0}, // #13289
  { 2,  1,   0}, // #13290
  { 5,  1,   0}, // #13291
  {22,  3,   0}, // #13292
  {25,  1,   0}, // #13293
  {26,  2,   0}, // #13294
  {29,  1,   0}, // #13295
  {22,  8,   0}, // #13296
  {25,  7,   0}, // #13297
  {26,  8,   0}, // #13298
  {29,  1,   0}, // #13299
  { 2,  1,   0}, // #13300
  {14,  1,   0}, // #13301
  {15,  1,   0}, // #13302
  {22,  2,   0}, // #13303
  {11,  1,   0}, // #13304
  {14,  1,   0}, // #13305
  {15,  1,   0}, // #13306
  {22,  2,   0}, // #13307
  { 2,  4,   0}, // #13308
  {11,  1,   0}, // #13309
  {14,  1,   0}, // #13310
  {15,  2,   0}, // #13311
  {19,  1,   0}, // #13312
  {22,  7,   0}, // #13313
  { 2,  6,   0}, // #13314
  { 3,  1,   0}, // #13315
  {11,  1,   0}, // #13316
  {14,  1,   0}, // #13317
  {15,  2,   0}, // #13318
  {19,  1,   0}, // #13319
  {22,  9,   0}, // #13320
  { 2,  1,   0}, // #13321
  { 5,  1,   0}, // #13322
  {14,  1,   0}, // #13323
  {15,  1,   0}, // #13324
  {22,  3,   0}, // #13325
  {26,  1,   0}, // #13326
  {29,  1,   0}, // #13327
  { 2,  3,   0}, // #13328
  { 3,  2,   0}, // #13329
  {11,  1,   0}, // #13330
  {14,  1,   0}, // #13331
  {15,  2,   0}, // #13332
  {19,  1,   0}, // #13333
  {22,  6,   0}, // #13334
  { 2,  2,   0}, // #13335
  {14,  1,   0}, // #13336
  {15,  1,   0}, // #13337
  {22,  3,   0}, // #13338
  { 2, 11,   0}, // #13339
  { 3,  6,   0}, // #13340
  { 5,  1,   0}, // #13341
  {22, 11,   0}, // #13342
  {11,  1,   0}, // #13343
  {14,  1,   0}, // #13344
  {15,  1,   0}, // #13345
  {22,  3,   0}, // #13346
  {26,  1,   0}, // #13347
  {29,  1,   0}, // #13348
  { 2, 13,   0}, // #13349
  { 3,  7,   0}, // #13350
  { 4,  2,   0}, // #13351
  { 5,  2,   0}, // #13352
  {11,  1,   0}, // #13353
  {14,  1,   0}, // #13354
  {15,  2,   0}, // #13355
  {19,  1,   0}, // #13356
  {22, 16,   0}, // #13357
  { 1,  2,   0}, // #13358
  { 2, 17,   0}, // #13359
  { 3,  8,   0}, // #13360
  { 5,  2,   0}, // #13361
  {11,  1,   0}, // #13362
  {14,  1,   0}, // #13363
  {15,  2,   0}, // #13364
  {19,  1,   0}, // #13365
  {22, 22,   0}, // #13366
  {26,  2,   0}, // #13367
  {29,  2,   0}, // #13368
  {22,  4,   0}, // #13369
  {26,  4,   0}, // #13370
  { 1,  2,   0}, // #13371
  { 2, 34,   0}, // #13372
  { 3, 23,   0}, // #13373
  { 4,  2,   0}, // #13374
  { 5, 11,   0}, // #13375
  {11,  4,   0}, // #13376
  {14, 14,   0}, // #13377
  {15, 19,   0}, // #13378
  {19,  5,   0}, // #13379
  {22, 57,   0}, // #13380
  { 2,  9,   0}, // #13381
  { 3,  2,   0}, // #13382
  { 5,  1,   0}, // #13383
  {14,  1,   0}, // #13384
  {15,  1,   0}, // #13385
  {22, 10,   0}, // #13386
  { 2,  9,   0}, // #13387
  { 5,  9,   0}, // #13388
  {22, 15,   0}, // #13389
  {26,  6,   0}, // #13390
  { 1,  2,   0}, // #13391
  { 2, 23,   0}, // #13392
  { 3, 12,   0}, // #13393
  { 4,  6,   0}, // #13394
  { 5, 11,   0}, // #13395
  {11,  1,   0}, // #13396
  {15,  1,   0}, // #13397
  {19,  1,   0}, // #13398
  {22, 26,   0}, // #13399
  {25,  1,   0}, // #13400
  {26,  1,   0}, // #13401
  { 2, 30,   0}, // #13402
  { 3, 10,   0}, // #13403
  { 4, 10,   0}, // #13404
  { 5, 15,   0}, // #13405
  {11, 38,   0}, // #13406
  {14,  2,   0}, // #13407
  {15, 40,   0}, // #13408
  {19, 38,   0}, // #13409
  {22, 110,   0}, // #13410
  {26,  2,   0}, // #13411
  {29,  2,   0}, // #13412
  { 2,  3,   0}, // #13413
  { 3,  2,   0}, // #13414
  { 5,  1,   0}, // #13415
  {14, 33,   0}, // #13416
  {15, 33,   0}, // #13417
  {22, 90,   0}, // #13418
  {26, 54,   0}, // #13419
  {29,  7,   0}, // #13420
  { 2, 94,   0}, // #13421
  { 3, 63,   0}, // #13422
  { 5, 31,   0}, // #13423
  {11,  1,   0}, // #13424
  {15,  1,   0}, // #13425
  {19,  1,   0}, // #13426
  {22, 144,   0}, // #13427
  {25, 14,   0}, // #13428
  {26, 48,   0}, // #13429
  {29, 15,   0}, // #13430
  {22,  2,   0}, // #13431
  {26,  2,   0}, // #13432
  {29,  1,   0}, // #13433
  { 2,  1,   0}, // #13434
  { 5,  1,   0}, // #13435
  {11,  1,   0}, // #13436
  {15,  1,   0}, // #13437
  {19,  1,   0}, // #13438
  {22,  3,   0}, // #13439
  { 2,  1,   0}, // #13440
  { 5,  1,   0}, // #13441
  {22,  2,   0}, // #13442
  {26,  1,   0}, // #13443
  {29,  1,   0}, // #13444
  { 2,  3,   0}, // #13445
  { 3,  2,   0}, // #13446
  { 4,  1,   0}, // #13447
  { 5,  1,   0}, // #13448
  {22,  3,   0}, // #13449
  { 2,  2,   0}, // #13450
  {11,  1,   0}, // #13451
  {15,  1,   0}, // #13452
  {19,  1,   0}, // #13453
  {22,  4,   0}, // #13454
  { 2,  2,   0}, // #13455
  { 3,  1,   0}, // #13456
  { 5,  1,   0}, // #13457
  {11,  1,   0}, // #13458
  {15,  1,   0}, // #13459
  {19,  1,   0}, // #13460
  {22,  4,   0}, // #13461
  { 2,  1,   0}, // #13462
  {11,  1,   0}, // #13463
  {15,  1,   0}, // #13464
  {19,  1,   0}, // #13465
  {22,  3,   0}, // #13466
  { 2,  5,   0}, // #13467
  {14,  2,   0}, // #13468
  {15,  2,   0}, // #13469
  {22,  7,   0}, // #13470
  { 2,  2,   0}, // #13471
  {11,  1,   0}, // #13472
  {14,  1,   0}, // #13473
  {15,  2,   0}, // #13474
  {19,  1,   0}, // #13475
  {22,  5,   0}, // #13476
  { 2,  1,   0}, // #13477
  {11,  1,   0}, // #13478
  {14,  2,   0}, // #13479
  {15,  2,   0}, // #13480
  {22,  5,   0}, // #13481
  {26,  1,   0}, // #13482
  {29,  1,   0}, // #13483
  { 2,  3,   0}, // #13484
  { 3,  1,   0}, // #13485
  {11,  1,   0}, // #13486
  {14,  1,   0}, // #13487
  {15,  2,   0}, // #13488
  {19,  1,   0}, // #13489
  {22,  6,   0}, // #13490
  {14,  6,   0}, // #13491
  {15,  6,   0}, // #13492
  {22,  9,   0}, // #13493
  {26,  3,   0}, // #13494
  {29,  3,   0}, // #13495
  { 2,  1,   0}, // #13496
  { 5,  1,   0}, // #13497
  {22,  3,   0}, // #13498
  {26,  2,   0}, // #13499
  {29,  1,   0}, // #13500
  { 1,  1,   0}, // #13501
  { 2,  1,   0}, // #13502
  { 3,  1,   0}, // #13503
  {14,  1,   0}, // #13504
  {15,  1,   0}, // #13505
  {22,  2,   0}, // #13506
  { 1,  1,   0}, // #13507
  { 2,  2,   0}, // #13508
  { 3,  1,   0}, // #13509
  { 5,  1,   0}, // #13510
  {14,  1,   0}, // #13511
  {15,  1,   0}, // #13512
  {22,  3,   0}, // #13513
  { 2, 10,   0}, // #13514
  { 3,  3,   0}, // #13515
  { 5,  5,   0}, // #13516
  {22, 10,   0}, // #13517
  {22,  3,   0}, // #13518
  {26,  3,   0}, // #13519
  {29,  3,   0}, // #13520
  { 2,  2,   0}, // #13521
  { 3,  2,   0}, // #13522
  {14,  1,   0}, // #13523
  {15,  1,   0}, // #13524
  {22,  3,   0}, // #13525
  { 2,  3,   0}, // #13526
  { 5,  2,   0}, // #13527
  {11,  2,   0}, // #13528
  {15,  2,   0}, // #13529
  {19,  2,   0}, // #13530
  {22,  7,   0}, // #13531
  { 2,  1,   0}, // #13532
  { 3,  1,   0}, // #13533
  {11,  1,   0}, // #13534
  {15,  1,   0}, // #13535
  {19,  1,   0}, // #13536
  {22,  3,   0}, // #13537
  { 2, 20,   0}, // #13538
  { 3,  8,   0}, // #13539
  { 5,  5,   0}, // #13540
  {22, 23,   0}, // #13541
  {26,  3,   0}, // #13542
  { 2, 52,   0}, // #13543
  { 3, 14,   0}, // #13544
  { 5, 15,   0}, // #13545
  {22, 54,   0}, // #13546
  {26,  2,   0}, // #13547
  { 2,  9,   0}, // #13548
  { 3,  5,   0}, // #13549
  { 5,  2,   0}, // #13550
  {22,  9,   0}, // #13551
  { 2, 10,   0}, // #13552
  { 3,  4,   0}, // #13553
  { 5,  3,   0}, // #13554
  {22, 10,   0}, // #13555
  { 2, 15,   0}, // #13556
  { 3,  6,   0}, // #13557
  { 5,  4,   0}, // #13558
  {22, 15,   0}, // #13559
  { 2,  9,   0}, // #13560
  { 3,  8,   0}, // #13561
  { 5,  1,   0}, // #13562
  {14,  1,   0}, // #13563
  {15,  1,   0}, // #13564
  {22, 31,   0}, // #13565
  {26, 21,   0}, // #13566
  { 1,  1,   0}, // #13567
  { 2,  1,   0}, // #13568
  { 3,  1,   0}, // #13569
  {22,  1,   0}, // #13570
  { 2, 74,   0}, // #13571
  { 3, 44,   0}, // #13572
  { 5, 30,   0}, // #13573
  {11,  1,   0}, // #13574
  {14,  4,   0}, // #13575
  {15,  5,   0}, // #13576
  {19,  1,   0}, // #13577
  {22, 140,   0}, // #13578
  {25, 14,   0}, // #13579
  {26, 60,   0}, // #13580
  {29, 21,   0}, // #13581
  { 2, 90,   0}, // #13582
  { 3, 53,   0}, // #13583
  { 5, 37,   0}, // #13584
  {11,  1,   0}, // #13585
  {14,  4,   0}, // #13586
  {15,  5,   0}, // #13587
  {19,  1,   0}, // #13588
  {22, 156,   0}, // #13589
  {25, 25,   0}, // #13590
  {26, 60,   0}, // #13591
  { 2,  6,   0}, // #13592
  { 3,  3,   0}, // #13593
  { 5,  3,   0}, // #13594
  {11,  1,   0}, // #13595
  {14,  2,   0}, // #13596
  {15,  2,   0}, // #13597
  {22, 18,   0}, // #13598
  {26,  9,   0}, // #13599
  {29,  1,   0}, // #13600
  { 2, 15,   0}, // #13601
  { 3, 10,   0}, // #13602
  { 5,  5,   0}, // #13603
  {14,  8,   0}, // #13604
  {15,  8,   0}, // #13605
  {22, 64,   0}, // #13606
  {26, 41,   0}, // #13607
  {29,  2,   0}, // #13608
  { 2,  3,   0}, // #13609
  { 3,  2,   0}, // #13610
  { 5,  1,   0}, // #13611
  {14, 31,   0}, // #13612
  {15, 31,   0}, // #13613
  {22, 88,   0}, // #13614
  {26, 54,   0}, // #13615
  {29,  9,   0}, // #13616
  { 2, 38,   0}, // #13617
  { 3, 21,   0}, // #13618
  { 4,  1,   0}, // #13619
  { 5, 17,   0}, // #13620
  {11, 11,   0}, // #13621
  {14, 11,   0}, // #13622
  {15, 11,   0}, // #13623
  {22, 100,   0}, // #13624
  {26, 40,   0}, // #13625
  {29, 10,   0}, // #13626
  { 2,  1,   0}, // #13627
  { 5,  1,   0}, // #13628
  {14,  2,   0}, // #13629
  {15,  2,   0}, // #13630
  {22,  5,   0}, // #13631
  {25,  1,   0}, // #13632
  {26,  2,   0}, // #13633
  {29,  1,   0}, // #13634
  { 2,  1,   0}, // #13635
  { 5,  1,   0}, // #13636
  {14,  4,   0}, // #13637
  {15,  4,   0}, // #13638
  {22,  8,   0}, // #13639
  {25,  1,   0}, // #13640
  {26,  3,   0}, // #13641
  {29,  2,   0}, // #13642
  { 2,  1,   0}, // #13643
  { 5,  1,   0}, // #13644
  {14,  8,   0}, // #13645
  {15,  8,   0}, // #13646
  {22, 12,   0}, // #13647
  {25,  1,   0}, // #13648
  {26,  3,   0}, // #13649
  {29,  2,   0}, // #13650
  { 2,  3,   0}, // #13651
  { 3,  2,   0}, // #13652
  { 5,  1,   0}, // #13653
  {14,  1,   0}, // #13654
  {15,  1,   0}, // #13655
  {22,  4,   0}, // #13656
  {11,  1,   0}, // #13657
  {15,  1,   0}, // #13658
  {19,  1,   0}, // #13659
  {22,  4,   0}, // #13660
  {25,  2,   0}, // #13661
  {26,  2,   0}, // #13662
  { 2,  3,   0}, // #13663
  { 3,  1,   0}, // #13664
  { 5,  2,   0}, // #13665
  {22,  7,   0}, // #13666
  {25,  2,   0}, // #13667
  {26,  4,   0}, // #13668
  {29,  2,   0}, // #13669
  { 2,  3,   0}, // #13670
  { 3,  1,   0}, // #13671
  { 5,  2,   0}, // #13672
  {14,  1,   0}, // #13673
  {15,  1,   0}, // #13674
  {22,  8,   0}, // #13675
  {25,  2,   0}, // #13676
  {26,  4,   0}, // #13677
  {29,  2,   0}, // #13678
  {22,  3,   0}, // #13679
  {25,  1,   0}, // #13680
  {26,  3,   0}, // #13681
  {29,  1,   0}, // #13682
  {14,  6,   0}, // #13683
  {15,  6,   0}, // #13684
  {22,  9,   0}, // #13685
  {25,  1,   0}, // #13686
  {26,  3,   0}, // #13687
  {29,  1,   0}, // #13688
  { 2,  5,   0}, // #13689
  { 3,  1,   0}, // #13690
  {11,  1,   0}, // #13691
  {14,  1,   0}, // #13692
  {15,  2,   0}, // #13693
  {19,  1,   0}, // #13694
  {22,  8,   0}, // #13695
  { 2,  7,   0}, // #13696
  { 3,  3,   0}, // #13697
  { 5,  2,   0}, // #13698
  {22,  7,   0}, // #13699
  {14,  8,   0}, // #13700
  {15,  8,   0}, // #13701
  {22, 13,   0}, // #13702
  {25,  4,   0}, // #13703
  {26,  5,   0}, // #13704
  {29,  1,   0}, // #13705
  {14,  6,   0}, // #13706
  {15,  6,   0}, // #13707
  {22,  8,   0}, // #13708
  {26,  2,   0}, // #13709
  {29,  1,   0}, // #13710
  { 2,  2,   0}, // #13711
  { 5,  2,   0}, // #13712
  {22,  3,   0}, // #13713
  {26,  1,   0}, // #13714
  {22,  3,   0}, // #13715
  {25,  1,   0}, // #13716
  {26,  3,   0}, // #13717
  {29,  2,   0}, // #13718
  { 2,  2,   0}, // #13719
  { 5,  2,   0}, // #13720
  {14,  1,   0}, // #13721
  {15,  1,   0}, // #13722
  {22,  4,   0}, // #13723
  {25,  1,   0}, // #13724
  {26,  1,   0}, // #13725
  {14,  1,   0}, // #13726
  {15,  1,   0}, // #13727
  {22,  4,   0}, // #13728
  {25,  1,   0}, // #13729
  {26,  3,   0}, // #13730
  {29,  2,   0}, // #13731
  {14,  7,   0}, // #13732
  {15,  7,   0}, // #13733
  {22, 10,   0}, // #13734
  {25,  1,   0}, // #13735
  {26,  3,   0}, // #13736
  {29,  2,   0}, // #13737
  { 2, 90,   0}, // #13738
  { 3, 53,   0}, // #13739
  { 5, 37,   0}, // #13740
  {11,  2,   0}, // #13741
  {14,  4,   0}, // #13742
  {15,  6,   0}, // #13743
  {19,  2,   0}, // #13744
  {22, 186,   0}, // #13745
  {25, 23,   0}, // #13746
  {26, 88,   0}, // #13747
  {29, 32,   0}, // #13748
  { 2,  1,   0}, // #13749
  {11,  1,   0}, // #13750
  {14,  2,   0}, // #13751
  {15,  2,   0}, // #13752
  {22,  4,   0}, // #13753
  { 2,  1,   0}, // #13754
  {11,  1,   0}, // #13755
  {14,  1,   0}, // #13756
  {15,  2,   0}, // #13757
  {19,  1,   0}, // #13758
  {22,  4,   0}, // #13759
  { 2,  8,   0}, // #13760
  { 3,  2,   0}, // #13761
  { 4,  1,   0}, // #13762
  { 5,  1,   0}, // #13763
  {14,  1,   0}, // #13764
  {15,  1,   0}, // #13765
  {22,  9,   0}, // #13766
  { 2,  7,   0}, // #13767
  { 3,  2,   0}, // #13768
  { 4,  1,   0}, // #13769
  { 5,  1,   0}, // #13770
  {11,  1,   0}, // #13771
  {14,  1,   0}, // #13772
  {15,  2,   0}, // #13773
  {19,  1,   0}, // #13774
  {22, 10,   0}, // #13775
  { 2,  2,   0}, // #13776
  { 3,  1,   0}, // #13777
  {11,  1,   0}, // #13778
  {15,  1,   0}, // #13779
  {19,  1,   0}, // #13780
  {22,  4,   0}, // #13781
  { 2, 10,   0}, // #13782
  { 3,  6,   0}, // #13783
  { 4,  1,   0}, // #13784
  { 5,  4,   0}, // #13785
  {22, 10,   0}, // #13786
  { 2,  1,   0}, // #13787
  { 3,  1,   0}, // #13788
  {11,  1,   0}, // #13789
  {14,  1,   0}, // #13790
  {15,  2,   0}, // #13791
  {19,  1,   0}, // #13792
  {22,  4,   0}, // #13793
  { 2,  3,   0}, // #13794
  { 3,  1,   0}, // #13795
  { 5,  1,   0}, // #13796
  {22,  3,   0}, // #13797
  { 2,  8,   0}, // #13798
  { 3,  5,   0}, // #13799
  { 5,  2,   0}, // #13800
  {11,  1,   0}, // #13801
  {14,  1,   0}, // #13802
  {15,  2,   0}, // #13803
  {19,  1,   0}, // #13804
  {22, 11,   0}, // #13805
  { 2,  9,   0}, // #13806
  { 3,  4,   0}, // #13807
  { 5,  3,   0}, // #13808
  {11,  1,   0}, // #13809
  {14,  1,   0}, // #13810
  {15,  2,   0}, // #13811
  {19,  1,   0}, // #13812
  {22, 12,   0}, // #13813
  { 2,  5,   0}, // #13814
  { 3,  2,   0}, // #13815
  { 5,  1,   0}, // #13816
  {11,  1,   0}, // #13817
  {15,  1,   0}, // #13818
  {19,  1,   0}, // #13819
  {22,  7,   0}, // #13820
  { 2,  6,   0}, // #13821
  { 3,  4,   0}, // #13822
  { 5,  1,   0}, // #13823
  {22,  6,   0}, // #13824
  { 2,  2,   0}, // #13825
  { 5,  2,   0}, // #13826
  {22,  3,   0}, // #13827
  {26,  1,   0}, // #13828
  {29,  1,   0}, // #13829
  { 2,  1,   0}, // #13830
  { 3,  1,   0}, // #13831
  {14,  1,   0}, // #13832
  {15,  1,   0}, // #13833
  {22,  3,   0}, // #13834
  {25,  1,   0}, // #13835
  {26,  1,   0}, // #13836
  { 2,  8,   0}, // #13837
  { 3,  1,   0}, // #13838
  { 5,  5,   0}, // #13839
  {22,  8,   0}, // #13840
  { 2, 87,   0}, // #13841
  { 3, 52,   0}, // #13842
  { 5, 35,   0}, // #13843
  {11,  2,   0}, // #13844
  {14,  4,   0}, // #13845
  {15,  6,   0}, // #13846
  {19,  2,   0}, // #13847
  {22, 151,   0}, // #13848
  {25, 20,   0}, // #13849
  {26, 56,   0}, // #13850
  { 2, 88,   0}, // #13851
  { 3, 53,   0}, // #13852
  { 5, 35,   0}, // #13853
  {11,  2,   0}, // #13854
  {14,  4,   0}, // #13855
  {15,  6,   0}, // #13856
  {19,  2,   0}, // #13857
  {22, 152,   0}, // #13858
  {25, 20,   0}, // #13859
  {26, 56,   0}, // #13860
  { 2, 89,   0}, // #13861
  { 3, 52,   0}, // #13862
  { 5, 37,   0}, // #13863
  {11,  1,   0}, // #13864
  {14,  4,   0}, // #13865
  {15,  5,   0}, // #13866
  {19,  1,   0}, // #13867
  {22, 155,   0}, // #13868
  {25, 25,   0}, // #13869
  {26, 60,   0}, // #13870
  { 2, 91,   0}, // #13871
  { 3, 53,   0}, // #13872
  { 5, 38,   0}, // #13873
  {11,  2,   0}, // #13874
  {14,  4,   0}, // #13875
  {15,  6,   0}, // #13876
  {19,  2,   0}, // #13877
  {22, 184,   0}, // #13878
  {25, 23,   0}, // #13879
  {26, 85,   0}, // #13880
  {29, 30,   0}, // #13881
  { 3,  1,   0}, // #13882
  {11,  2,   0}, // #13883
  {12,  1,   0}, // #13884
  {13,  1,   0}, // #13885
  {14,  1,   0}, // #13886
  {19,  2,   0}, // #13887
  {20,  1,   0}, // #13888
  {22,  2,   0}, // #13889
  {23,  2,   0}, // #13890
  { 8,  1,   0}, // #13891
  {11,  2,   0}, // #13892
  {13,  1,   0}, // #13893
  {15,  1,   0}, // #13894
  {17,  1,   0}, // #13895
  {18,  1,   0}, // #13896
  {19,  3,   0}, // #13897
  {20,  1,   0}, // #13898
  {21,  1,   0}, // #13899
  {22,  3,   0}, // #13900
  {23,  4,   0}, // #13901
  { 8,  1,   0}, // #13902
  {11,  2,   0}, // #13903
  {13,  1,   0}, // #13904
  {15,  1,   0}, // #13905
  {18,  1,   0}, // #13906
  {19,  3,   0}, // #13907
  {20,  1,   0}, // #13908
  {22,  3,   0}, // #13909
  {23,  3,   0}, // #13910
  {22, 16,   0}, // #13911
  {23, 16,   0}, // #13912
  { 7,  1,   0}, // #13913
  { 9, 11,   0}, // #13914
  {12,  1,   0}, // #13915
  {14, 11,   0}, // #13916
  {16, 11,   0}, // #13917
  {17,  1,   0}, // #13918
  {18, 11,   0}, // #13919
  {20, 11,   0}, // #13920
  {21,  2,   0}, // #13921
  {22, 41,   0}, // #13922
  {23, 44,   0}, // #13923
  {12,  1,   0}, // #13924
  {23,  1,   0}, // #13925
  { 1,  2,   0}, // #13926
  { 5,  1,   0}, // #13927
  {12,  1,   0}, // #13928
  {16,  1,   0}, // #13929
  {19,  1,   0}, // #13930
  {21,  1,   0}, // #13931
  {22,  1,   0}, // #13932
  {23,  1,   0}, // #13933
  { 1,  1,   0}, // #13934
  {12,  1,   0}, // #13935
  {22,  1,   0}, // #13936
  { 1,  1,   0}, // #13937
  {12,  1,   0}, // #13938
  {17,  1,   0}, // #13939
  {23,  1,   0}, // #13940
  { 1,  1,   0}, // #13941
  { 5,  2,   0}, // #13942
  { 1,  1,   0}, // #13943
  { 5, 12,   0}, // #13944
  { 1,  1,   0}, // #13945
  { 5, 16,   0}, // #13946
  { 1,  1,   0}, // #13947
  {12,  2,   0}, // #13948
  {15,  1,   0}, // #13949
  {17,  1,   0}, // #13950
  {18,  1,   0}, // #13951
  {20,  1,   0}, // #13952
  {22,  1,   0}, // #13953
  {23,  1,   0}, // #13954
  { 1,  1,   0}, // #13955
  {12,  1,   0}, // #13956
  {13,  1,   0}, // #13957
  {17,  1,   0}, // #13958
  {18,  1,   0}, // #13959
  {19,  1,   0}, // #13960
  {23,  1,   0}, // #13961
  { 1,  1,   0}, // #13962
  {12,  1,   0}, // #13963
  {16,  1,   0}, // #13964
  {19,  1,   0}, // #13965
  {21,  1,   0}, // #13966
  {22,  1,   0}, // #13967
  {23,  1,   0}, // #13968
  { 1,  1,   0}, // #13969
  {12,  2,   0}, // #13970
  {16,  2,   0}, // #13971
  {19,  2,   0}, // #13972
  {21,  2,   0}, // #13973
  {22,  2,   0}, // #13974
  {23,  2,   0}, // #13975
  { 1,  1,   0}, // #13976
  { 5,  1,   0}, // #13977
  { 8,  1,   0}, // #13978
  {11, 17,   0}, // #13979
  { 1,  1,   0}, // #13980
  { 5,  1,   0}, // #13981
  { 8,  1,   0}, // #13982
  {11, 25,   0}, // #13983
  { 1,  1,   0}, // #13984
  { 5,  1,   0}, // #13985
  { 8,  1,   0}, // #13986
  {11, 41,   0}, // #13987
  { 1,  1,   0}, // #13988
  { 5,  1,   0}, // #13989
  { 8,  1,   0}, // #13990
  {11, 15,   0}, // #13991
  { 1,  1,   0}, // #13992
  {12,  6,   0}, // #13993
  {16,  6,   0}, // #13994
  {19,  6,   0}, // #13995
  {21,  6,   0}, // #13996
  {22,  6,   0}, // #13997
  {23,  6,   0}, // #13998
  { 1,  1,   0}, // #13999
  {12,  5,   0}, // #14000
  {16,  5,   0}, // #14001
  {19,  5,   0}, // #14002
  {21,  5,   0}, // #14003
  {22,  5,   0}, // #14004
  {23,  5,   0}, // #14005
  { 1,  1,   0}, // #14006
  {12,  5,   0}, // #14007
  {15,  3,   0}, // #14008
  {18,  3,   0}, // #14009
  {20,  5,   0}, // #14010
  {22,  3,   0}, // #14011
  {12,  3,   0}, // #14012
  {15,  2,   0}, // #14013
  {18,  2,   0}, // #14014
  {20,  3,   0}, // #14015
  {22,  2,   0}, // #14016
  { 1,  1,   0}, // #14017
  {12,  1,   0}, // #14018
  {23,  1,   0}, // #14019
  { 1,  1,   0}, // #14020
  { 5,  1,   0}, // #14021
  { 7,  1,   0}, // #14022
  {24,  1,   0}, // #14023
  { 1,  1,   0}, // #14024
  {12,  1,   0}, // #14025
  {20,  1,   0}, // #14026
  { 1,  1,   0}, // #14027
  {12,  1,   0}, // #14028
  {21,  1,   0}, // #14029
  {23,  1,   0}, // #14030
  {12,  1,   0}, // #14031
  {15,  1,   0}, // #14032
  {18,  1,   0}, // #14033
  {20,  1,   0}, // #14034
  {22,  1,   0}, // #14035
  { 1,  1,   0}, // #14036
  {12,  1,   0}, // #14037
  {15,  1,   0}, // #14038
  {18,  1,   0}, // #14039
  {20,  1,   0}, // #14040
  {22,  1,   0}, // #14041
  { 1,  1,   0}, // #14042
  { 5,  1,   0}, // #14043
  { 7,  1,   0}, // #14044
  {24,  2,   0}, // #14045
  { 1,  1,   0}, // #14046
  {12,  2,   0}, // #14047
  {13,  2,   0}, // #14048
  {17,  2,   0}, // #14049
  {18,  2,   0}, // #14050
  {19,  2,   0}, // #14051
  {23,  2,   0}, // #14052
  { 1,  1,   0}, // #14053
  {12,  2,   0}, // #14054
  {20,  2,   0}, // #14055
  { 1,  1,   0}, // #14056
  {12, 10,   0}, // #14057
  {16, 10,   0}, // #14058
  {19, 10,   0}, // #14059
  {21, 10,   0}, // #14060
  {22, 10,   0}, // #14061
  {23, 10,   0}, // #14062
  { 1,  1,   0}, // #14063
  {12,  7,   0}, // #14064
  {16,  7,   0}, // #14065
  {19,  7,   0}, // #14066
  {21,  7,   0}, // #14067
  {22,  7,   0}, // #14068
  {23,  7,   0}, // #14069
  {12, 20,   0}, // #14070
  {16, 20,   0}, // #14071
  {19, 20,   0}, // #14072
  {21, 20,   0}, // #14073
  {22, 20,   0}, // #14074
  {23, 20,   0}, // #14075
  { 1,  1,   0}, // #14076
  {12,  2,   0}, // #14077
  {17,  2,   0}, // #14078
  {23,  2,   0}, // #14079
  {12,  2,   0}, // #14080
  {15,  2,   0}, // #14081
  {18,  2,   0}, // #14082
  {20,  2,   0}, // #14083
  {22,  2,   0}, // #14084
  { 1,  1,   0}, // #14085
  {12,  2,   0}, // #14086
  {14,  2,   0}, // #14087
  {17,  2,   0}, // #14088
  {20,  2,   0}, // #14089
  {21,  2,   0}, // #14090
  {23,  2,   0}, // #14091
  {12,  2,   0}, // #14092
  {16,  1,   0}, // #14093
  {19,  1,   0}, // #14094
  {20,  1,   0}, // #14095
  {21,  1,   0}, // #14096
  {22,  1,   0}, // #14097
  {23,  1,   0}, // #14098
  { 1,  1,   0}, // #14099
  {12,  2,   0}, // #14100
  {16,  1,   0}, // #14101
  {19,  1,   0}, // #14102
  {20,  1,   0}, // #14103
  {21,  1,   0}, // #14104
  {22,  1,   0}, // #14105
  {23,  1,   0}, // #14106
  { 1,  1,   0}, // #14107
  {12,  1,   0}, // #14108
  {18,  1,   0}, // #14109
  { 1,  5,   0}, // #14110
  {12,  3,   0}, // #14111
  {15,  2,   0}, // #14112
  {18,  2,   0}, // #14113
  {20,  3,   0}, // #14114
  {22,  2,   0}, // #14115
  { 1,  1,   0}, // #14116
  {12,  1,   0}, // #14117
  {19,  1,   0}, // #14118
  {23,  1,   0}, // #14119
  { 1,  1,   0}, // #14120
  {12,  3,   0}, // #14121
  {19,  3,   0}, // #14122
  {23,  3,   0}, // #14123
  { 1,  1,   0}, // #14124
  {12,  3,   0}, // #14125
  {17,  3,   0}, // #14126
  {23,  3,   0}, // #14127
  { 1,  1,   0}, // #14128
  { 5,  1,   0}, // #14129
  {10,  1,   0}, // #14130
  {12,  2,   0}, // #14131
  {16,  1,   0}, // #14132
  {19,  1,   0}, // #14133
  {21,  1,   0}, // #14134
  {22,  1,   0}, // #14135
  {23,  2,   0}, // #14136
  {12,  2,   0}, // #14137
  {15,  1,   0}, // #14138
  {16,  1,   0}, // #14139
  {18,  1,   0}, // #14140
  {19,  1,   0}, // #14141
  {20,  1,   0}, // #14142
  {21,  1,   0}, // #14143
  {22,  2,   0}, // #14144
  {23,  1,   0}, // #14145
  { 1,  1,   0}, // #14146
  {12,  2,   0}, // #14147
  {15,  1,   0}, // #14148
  {16,  1,   0}, // #14149
  {18,  1,   0}, // #14150
  {19,  1,   0}, // #14151
  {20,  1,   0}, // #14152
  {21,  1,   0}, // #14153
  {22,  2,   0}, // #14154
  {23,  1,   0}, // #14155
  {12,  2,   0}, // #14156
  {15,  1,   0}, // #14157
  {18,  1,   0}, // #14158
  {20,  2,   0}, // #14159
  {22,  1,   0}, // #14160
  {12,  2,   0}, // #14161
  {14,  1,   0}, // #14162
  {17,  1,   0}, // #14163
  {19,  1,   0}, // #14164
  {20,  1,   0}, // #14165
  {21,  1,   0}, // #14166
  {23,  2,   0}, // #14167
  {12,  1,   0}, // #14168
  {14,  1,   0}, // #14169
  {17,  1,   0}, // #14170
  {20,  1,   0}, // #14171
  {21,  1,   0}, // #14172
  {23,  1,   0}, // #14173
  { 1,  1,   0}, // #14174
  {12,  1,   0}, // #14175
  {14,  1,   0}, // #14176
  {17,  1,   0}, // #14177
  {20,  1,   0}, // #14178
  {21,  1,   0}, // #14179
  {23,  1,   0}, // #14180
  {11,  1,   0}, // #14181
  {36,  1,   0}, // #14182
  {11,  0,   0}, // #14183
  {36,  0,   0}, // #14184
  {14,  1,   0}, // #14185
  {25,  1,   0}, // #14186
  {28,  1,   0}, // #14187
  {31,  1,   0}, // #14188
  {32,  1,   0}, // #14189
  {13,  1,   0}, // #14190
  {36,  1,   0}, // #14191
  {11, 12,   0}, // #14192
  {36, 12,   0}, // #14193
  { 4,  1,   0}, // #14194
  {13,  1,   0}, // #14195
  {36,  2,   0}, // #14196
  {37,  1,   0}, // #14197
  {38,  1,   0}, // #14198
  {11,  4,   0}, // #14199
  {36,  4,   0}, // #14200
  {19,  1,   0}, // #14201
  {27,  1,   0}, // #14202
  {37,  1,   0}, // #14203
  {39,  1,   0}, // #14204
  {14,  1,   0}, // #14205
  {19,  1,   0}, // #14206
  {37,  1,   0}, // #14207
  {38,  1,   0}, // #14208
  {11, 100,   0}, // #14209
  {36, 100,   0}, // #14210
  { 4,  1,   0}, // #14211
  {36,  1,   0}, // #14212
  { 4,  1,   0}, // #14213
  {36,  1,   0}, // #14214
  {37,  1,   0}, // #14215
  {39,  1,   0}, // #14216
  {10,  3,   0}, // #14217
  {11,  3,   0}, // #14218
  {36,  3,   0}, // #14219
  { 4,  2,   0}, // #14220
  {11,  1,   0}, // #14221
  {36,  3,   0}, // #14222
  {37,  2,   0}, // #14223
  {38,  1,   0}, // #14224
  {39,  1,   0}, // #14225
  {14,  2,   0}, // #14226
  {20,  2,   0}, // #14227
  {21,  2,   0}, // #14228
  {25,  2,   0}, // #14229
  {26,  2,   0}, // #14230
  {28,  2,   0}, // #14231
  {29,  2,   0}, // #14232
  {31,  2,   0}, // #14233
  {32,  2,   0}, // #14234
  { 4,  2,   0}, // #14235
  {11,  4,   0}, // #14236
  {36,  6,   0}, // #14237
  {37,  2,   0}, // #14238
  {38,  1,   0}, // #14239
  {39,  1,   0}, // #14240
  { 4,  1,   0}, // #14241
  {11,  4,   0}, // #14242
  {36,  5,   0}, // #14243
  {37,  1,   0}, // #14244
  {38,  1,   0}, // #14245
  { 4,  1,   0}, // #14246
  {11,  1,   0}, // #14247
  {36,  2,   0}, // #14248
  {37,  1,   0}, // #14249
  {38,  1,   0}, // #14250
  {14,  2,   0}, // #14251
  {19,  1,   0}, // #14252
  {22,  1,   0}, // #14253
  {23,  1,   0}, // #14254
  {25,  1,   0}, // #14255
  {28,  1,   0}, // #14256
  {31,  1,   0}, // #14257
  {32,  1,   0}, // #14258
  {37,  1,   0}, // #14259
  {38,  1,   0}, // #14260
  {14,  1,   0}, // #14261
  {22,  1,   0}, // #14262
  {23,  1,   0}, // #14263
  {25,  1,   0}, // #14264
  {28,  1,   0}, // #14265
  {31,  1,   0}, // #14266
  {32,  1,   0}, // #14267
  {14,  2,   0}, // #14268
  {19,  1,   0}, // #14269
  {20,  1,   0}, // #14270
  {21,  1,   0}, // #14271
  {25,  1,   0}, // #14272
  {26,  1,   0}, // #14273
  {28,  1,   0}, // #14274
  {29,  1,   0}, // #14275
  {31,  1,   0}, // #14276
  {32,  1,   0}, // #14277
  {37,  1,   0}, // #14278
  {38,  1,   0}, // #14279
  {14,  1,   0}, // #14280
  {20,  1,   0}, // #14281
  {21,  1,   0}, // #14282
  {25,  1,   0}, // #14283
  {26,  1,   0}, // #14284
  {28,  1,   0}, // #14285
  {29,  1,   0}, // #14286
  {31,  1,   0}, // #14287
  {32,  1,   0}, // #14288
  {14,  2,   0}, // #14289
  {19,  1,   0}, // #14290
  {25,  1,   0}, // #14291
  {28,  1,   0}, // #14292
  {31,  1,   0}, // #14293
  {32,  1,   0}, // #14294
  {37,  1,   0}, // #14295
  {38,  1,   0}, // #14296
  { 4,  1,   0}, // #14297
  {10,  1,   0}, // #14298
  {11,  1,   0}, // #14299
  {36,  2,   0}, // #14300
  {37,  1,   0}, // #14301
  {38,  1,   0}, // #14302
  {10,  1,   0}, // #14303
  {11,  1,   0}, // #14304
  {36,  1,   0}, // #14305
  { 4,  1,   0}, // #14306
  {11,  2,   0}, // #14307
  {36,  3,   0}, // #14308
  {37,  1,   0}, // #14309
  {38,  1,   0}, // #14310
  {11,  2,   0}, // #14311
  {36,  2,   0}, // #14312
  { 4,  1,   0}, // #14313
  { 6,  3,   0}, // #14314
  {10,  3,   0}, // #14315
  {11,  3,   0}, // #14316
  {36,  4,   0}, // #14317
  {37,  1,   0}, // #14318
  {38,  1,   0}, // #14319
  { 6,  3,   0}, // #14320
  {10,  3,   0}, // #14321
  {11,  3,   0}, // #14322
  {36,  3,   0}, // #14323
  { 4,  1,   0}, // #14324
  { 6,  4,   0}, // #14325
  {10,  4,   0}, // #14326
  {11,  4,   0}, // #14327
  {36,  5,   0}, // #14328
  {37,  1,   0}, // #14329
  {38,  1,   0}, // #14330
  { 6,  4,   0}, // #14331
  {10,  4,   0}, // #14332
  {11,  4,   0}, // #14333
  {36,  4,   0}, // #14334
  { 4,  2,   0}, // #14335
  {10,  1,   0}, // #14336
  {11,  1,   0}, // #14337
  {36,  3,   0}, // #14338
  {37,  2,   0}, // #14339
  {38,  1,   0}, // #14340
  {39,  1,   0}, // #14341
  {10,  2,   0}, // #14342
  {11,  2,   0}, // #14343
  {36,  2,   0}, // #14344
  { 9,  1,   0}, // #14345
  {11,  1,   0}, // #14346
  {36,  1,   0}, // #14347
  { 4,  1,   0}, // #14348
  { 9,  1,   0}, // #14349
  {11,  1,   0}, // #14350
  {36,  2,   0}, // #14351
  {37,  1,   0}, // #14352
  {38,  1,   0}, // #14353
  { 4,  1,   0}, // #14354
  {36,  1,   0}, // #14355
  {37,  1,   0}, // #14356
  {38,  1,   0}, // #14357
  {11, 28,   0}, // #14358
  {36, 28,   0}, // #14359
  {11,  8,   0}, // #14360
  {36,  8,   0}, // #14361
  {14,  3,   0}, // #14362
  {19,  1,   0}, // #14363
  {20,  2,   0}, // #14364
  {21,  2,   0}, // #14365
  {25,  2,   0}, // #14366
  {26,  2,   0}, // #14367
  {28,  2,   0}, // #14368
  {29,  2,   0}, // #14369
  {31,  2,   0}, // #14370
  {32,  2,   0}, // #14371
  {37,  1,   0}, // #14372
  {38,  1,   0}, // #14373
  { 4,  1,   0}, // #14374
  { 6,  1,   0}, // #14375
  {10,  1,   0}, // #14376
  {11,  1,   0}, // #14377
  {36,  2,   0}, // #14378
  {37,  1,   0}, // #14379
  {38,  1,   0}, // #14380
  { 6,  1,   0}, // #14381
  {10,  1,   0}, // #14382
  {11,  1,   0}, // #14383
  {36,  1,   0}, // #14384
  {14,  3,   0}, // #14385
  {19,  1,   0}, // #14386
  {22,  2,   0}, // #14387
  {23,  2,   0}, // #14388
  {25,  2,   0}, // #14389
  {28,  2,   0}, // #14390
  {31,  2,   0}, // #14391
  {32,  2,   0}, // #14392
  {37,  1,   0}, // #14393
  {38,  1,   0}, // #14394
  {14,  2,   0}, // #14395
  {22,  2,   0}, // #14396
  {23,  2,   0}, // #14397
  {25,  2,   0}, // #14398
  {28,  2,   0}, // #14399
  {31,  2,   0}, // #14400
  {32,  2,   0}, // #14401
  { 4,  1,   0}, // #14402
  { 5, 11,   0}, // #14403
  { 9, 11,   0}, // #14404
  {11, 11,   0}, // #14405
  {13, 11,   0}, // #14406
  {36, 12,   0}, // #14407
  {37,  1,   0}, // #14408
  {38,  1,   0}, // #14409
  { 5, 11,   0}, // #14410
  { 9, 11,   0}, // #14411
  {11, 11,   0}, // #14412
  {13, 11,   0}, // #14413
  {36, 11,   0}, // #14414
  { 4,  1,   0}, // #14415
  { 5, 13,   0}, // #14416
  { 9, 13,   0}, // #14417
  {11, 13,   0}, // #14418
  {13, 13,   0}, // #14419
  {36, 14,   0}, // #14420
  {37,  1,   0}, // #14421
  {38,  1,   0}, // #14422
  { 5, 13,   0}, // #14423
  { 9, 13,   0}, // #14424
  {11, 13,   0}, // #14425
  {13, 13,   0}, // #14426
  {36, 13,   0}, // #14427
  { 4,  1,   0}, // #14428
  { 5, 17,   0}, // #14429
  { 9, 17,   0}, // #14430
  {11, 17,   0}, // #14431
  {13, 17,   0}, // #14432
  {36, 18,   0}, // #14433
  {37,  1,   0}, // #14434
  {38,  1,   0}, // #14435
  { 5, 17,   0}, // #14436
  { 9, 17,   0}, // #14437
  {11, 17,   0}, // #14438
  {13, 17,   0}, // #14439
  {36, 17,   0}, // #14440
  { 4,  1,   0}, // #14441
  { 5, 10,   0}, // #14442
  { 9, 10,   0}, // #14443
  {11, 10,   0}, // #14444
  {13, 10,   0}, // #14445
  {36, 11,   0}, // #14446
  {37,  1,   0}, // #14447
  {38,  1,   0}, // #14448
  { 5, 10,   0}, // #14449
  { 9, 10,   0}, // #14450
  {11, 10,   0}, // #14451
  {13, 10,   0}, // #14452
  {36, 10,   0}, // #14453
  {14,  6,   0}, // #14454
  {16,  5,   0}, // #14455
  {19,  1,   0}, // #14456
  {20,  5,   0}, // #14457
  {21,  5,   0}, // #14458
  {24,  5,   0}, // #14459
  {25,  5,   0}, // #14460
  {26,  5,   0}, // #14461
  {28,  5,   0}, // #14462
  {29,  5,   0}, // #14463
  {30,  5,   0}, // #14464
  {31,  5,   0}, // #14465
  {32,  5,   0}, // #14466
  {34,  5,   0}, // #14467
  {35,  5,   0}, // #14468
  {37,  1,   0}, // #14469
  {38,  1,   0}, // #14470
  {14,  5,   0}, // #14471
  {16,  5,   0}, // #14472
  {20,  5,   0}, // #14473
  {21,  5,   0}, // #14474
  {24,  5,   0}, // #14475
  {25,  5,   0}, // #14476
  {26,  5,   0}, // #14477
  {28,  5,   0}, // #14478
  {29,  5,   0}, // #14479
  {30,  5,   0}, // #14480
  {31,  5,   0}, // #14481
  {32,  5,   0}, // #14482
  {34,  5,   0}, // #14483
  {35,  5,   0}, // #14484
  {14,  4,   0}, // #14485
  {16,  3,   0}, // #14486
  {19,  1,   0}, // #14487
  {20,  3,   0}, // #14488
  {21,  3,   0}, // #14489
  {24,  3,   0}, // #14490
  {25,  3,   0}, // #14491
  {26,  3,   0}, // #14492
  {28,  3,   0}, // #14493
  {29,  3,   0}, // #14494
  {30,  3,   0}, // #14495
  {31,  3,   0}, // #14496
  {32,  3,   0}, // #14497
  {34,  3,   0}, // #14498
  {35,  3,   0}, // #14499
  {37,  1,   0}, // #14500
  {38,  1,   0}, // #14501
  {14,  3,   0}, // #14502
  {16,  3,   0}, // #14503
  {20,  3,   0}, // #14504
  {21,  3,   0}, // #14505
  {24,  3,   0}, // #14506
  {25,  3,   0}, // #14507
  {26,  3,   0}, // #14508
  {28,  3,   0}, // #14509
  {29,  3,   0}, // #14510
  {30,  3,   0}, // #14511
  {31,  3,   0}, // #14512
  {32,  3,   0}, // #14513
  {34,  3,   0}, // #14514
  {35,  3,   0}, // #14515
  {14,  7,   0}, // #14516
  {19,  1,   0}, // #14517
  {20,  6,   0}, // #14518
  {21,  6,   0}, // #14519
  {25,  6,   0}, // #14520
  {26,  6,   0}, // #14521
  {28,  6,   0}, // #14522
  {29,  6,   0}, // #14523
  {31,  6,   0}, // #14524
  {32,  6,   0}, // #14525
  {37,  1,   0}, // #14526
  {38,  1,   0}, // #14527
  {14,  6,   0}, // #14528
  {20,  6,   0}, // #14529
  {21,  6,   0}, // #14530
  {25,  6,   0}, // #14531
  {26,  6,   0}, // #14532
  {28,  6,   0}, // #14533
  {29,  6,   0}, // #14534
  {31,  6,   0}, // #14535
  {32,  6,   0}, // #14536
  {14,  9,   0}, // #14537
  {19,  1,   0}, // #14538
  {20,  8,   0}, // #14539
  {21,  8,   0}, // #14540
  {25,  8,   0}, // #14541
  {26,  8,   0}, // #14542
  {28,  8,   0}, // #14543
  {29,  8,   0}, // #14544
  {31,  8,   0}, // #14545
  {32,  8,   0}, // #14546
  {37,  1,   0}, // #14547
  {38,  1,   0}, // #14548
  {14,  8,   0}, // #14549
  {20,  8,   0}, // #14550
  {21,  8,   0}, // #14551
  {25,  8,   0}, // #14552
  {26,  8,   0}, // #14553
  {28,  8,   0}, // #14554
  {29,  8,   0}, // #14555
  {31,  8,   0}, // #14556
  {32,  8,   0}, // #14557
  { 4,  1,   0}, // #14558
  {36,  1,   0}, // #14559
  {37,  2,   0}, // #14560
  {39,  2,   0}, // #14561
  {14,  2,   0}, // #14562
  {16,  1,   0}, // #14563
  {19,  1,   0}, // #14564
  {20,  1,   0}, // #14565
  {21,  1,   0}, // #14566
  {24,  1,   0}, // #14567
  {25,  1,   0}, // #14568
  {26,  1,   0}, // #14569
  {28,  1,   0}, // #14570
  {29,  1,   0}, // #14571
  {30,  1,   0}, // #14572
  {31,  1,   0}, // #14573
  {32,  1,   0}, // #14574
  {34,  1,   0}, // #14575
  {35,  1,   0}, // #14576
  {37,  1,   0}, // #14577
  {38,  1,   0}, // #14578
  {14,  2,   0}, // #14579
  {19,  1,   0}, // #14580
  {25,  1,   0}, // #14581
  {28,  1,   0}, // #14582
  {31,  1,   0}, // #14583
  {32,  1,   0}, // #14584
  {33,  1,   0}, // #14585
  {37,  1,   0}, // #14586
  {38,  1,   0}, // #14587
  {14,  1,   0}, // #14588
  {25,  1,   0}, // #14589
  {28,  1,   0}, // #14590
  {31,  1,   0}, // #14591
  {32,  1,   0}, // #14592
  {33,  1,   0}, // #14593
  {14,  3,   0}, // #14594
  {17,  2,   0}, // #14595
  {19,  1,   0}, // #14596
  {22,  2,   0}, // #14597
  {23,  2,   0}, // #14598
  {24,  2,   0}, // #14599
  {25,  2,   0}, // #14600
  {28,  2,   0}, // #14601
  {30,  2,   0}, // #14602
  {31,  2,   0}, // #14603
  {32,  2,   0}, // #14604
  {34,  2,   0}, // #14605
  {35,  2,   0}, // #14606
  {37,  1,   0}, // #14607
  {38,  1,   0}, // #14608
  {14,  2,   0}, // #14609
  {17,  2,   0}, // #14610
  {22,  2,   0}, // #14611
  {23,  2,   0}, // #14612
  {24,  2,   0}, // #14613
  {25,  2,   0}, // #14614
  {28,  2,   0}, // #14615
  {30,  2,   0}, // #14616
  {31,  2,   0}, // #14617
  {32,  2,   0}, // #14618
  {34,  2,   0}, // #14619
  {35,  2,   0}, // #14620
  {14,  2,   0}, // #14621
  {19,  1,   0}, // #14622
  {24,  1,   0}, // #14623
  {25,  1,   0}, // #14624
  {28,  1,   0}, // #14625
  {30,  1,   0}, // #14626
  {31,  1,   0}, // #14627
  {32,  1,   0}, // #14628
  {34,  1,   0}, // #14629
  {35,  1,   0}, // #14630
  {37,  1,   0}, // #14631
  {38,  1,   0}, // #14632
  {14,  1,   0}, // #14633
  {24,  1,   0}, // #14634
  {25,  1,   0}, // #14635
  {28,  1,   0}, // #14636
  {30,  1,   0}, // #14637
  {31,  1,   0}, // #14638
  {32,  1,   0}, // #14639
  {34,  1,   0}, // #14640
  {35,  1,   0}, // #14641
  { 8,  1,   0}, // #14642
  { 9,  1,   0}, // #14643
  {11,  1,   0}, // #14644
  {36,  1,   0}, // #14645
  { 4,  1,   0}, // #14646
  {11,  6,   0}, // #14647
  {36,  7,   0}, // #14648
  {37,  1,   0}, // #14649
  {38,  1,   0}, // #14650
  {14,  3,   0}, // #14651
  {15,  2,   0}, // #14652
  {19,  1,   0}, // #14653
  {20,  2,   0}, // #14654
  {21,  2,   0}, // #14655
  {25,  2,   0}, // #14656
  {26,  2,   0}, // #14657
  {28,  2,   0}, // #14658
  {29,  2,   0}, // #14659
  {31,  2,   0}, // #14660
  {32,  2,   0}, // #14661
  {33,  2,   0}, // #14662
  {37,  1,   0}, // #14663
  {38,  1,   0}, // #14664
  {14,  2,   0}, // #14665
  {15,  2,   0}, // #14666
  {20,  2,   0}, // #14667
  {21,  2,   0}, // #14668
  {25,  2,   0}, // #14669
  {26,  2,   0}, // #14670
  {28,  2,   0}, // #14671
  {29,  2,   0}, // #14672
  {31,  2,   0}, // #14673
  {32,  2,   0}, // #14674
  {33,  2,   0}, // #14675
  {14,  3,   0}, // #14676
  {19,  3,   0}, // #14677
  {37,  1,   0}, // #14678
  {38,  1,   0}, // #14679
  {14,  1,   0}, // #14680
  {17,  1,   0}, // #14681
  {22,  1,   0}, // #14682
  {23,  1,   0}, // #14683
  {24,  1,   0}, // #14684
  {25,  1,   0}, // #14685
  {28,  1,   0}, // #14686
  {30,  1,   0}, // #14687
  {31,  1,   0}, // #14688
  {32,  1,   0}, // #14689
  {34,  1,   0}, // #14690
  {35,  1,   0}, // #14691
  {14,  3,   0}, // #14692
  {19,  1,   0}, // #14693
  {25,  2,   0}, // #14694
  {28,  2,   0}, // #14695
  {31,  2,   0}, // #14696
  {32,  2,   0}, // #14697
  {37,  1,   0}, // #14698
  {38,  1,   0}, // #14699
  {14,  2,   0}, // #14700
  {25,  2,   0}, // #14701
  {28,  2,   0}, // #14702
  {31,  2,   0}, // #14703
  {32,  2,   0}, // #14704
  {14,  9,   0}, // #14705
  {19,  1,   0}, // #14706
  {25,  8,   0}, // #14707
  {28,  8,   0}, // #14708
  {31,  8,   0}, // #14709
  {32,  8,   0}, // #14710
  {37,  1,   0}, // #14711
  {38,  1,   0}, // #14712
  {14,  8,   0}, // #14713
  {25,  8,   0}, // #14714
  {28,  8,   0}, // #14715
  {31,  8,   0}, // #14716
  {32,  8,   0}, // #14717
  {14,  5,   0}, // #14718
  {19,  1,   0}, // #14719
  {20,  4,   0}, // #14720
  {21,  4,   0}, // #14721
  {25,  4,   0}, // #14722
  {26,  4,   0}, // #14723
  {28,  4,   0}, // #14724
  {29,  4,   0}, // #14725
  {31,  4,   0}, // #14726
  {32,  4,   0}, // #14727
  {37,  1,   0}, // #14728
  {38,  1,   0}, // #14729
  {14,  4,   0}, // #14730
  {20,  4,   0}, // #14731
  {21,  4,   0}, // #14732
  {25,  4,   0}, // #14733
  {26,  4,   0}, // #14734
  {28,  4,   0}, // #14735
  {29,  4,   0}, // #14736
  {31,  4,   0}, // #14737
  {32,  4,   0}, // #14738
  {14, 13,   0}, // #14739
  {19,  1,   0}, // #14740
  {25, 12,   0}, // #14741
  {28, 12,   0}, // #14742
  {31, 12,   0}, // #14743
  {32, 12,   0}, // #14744
  {37,  1,   0}, // #14745
  {38,  1,   0}, // #14746
  {14, 12,   0}, // #14747
  {25, 12,   0}, // #14748
  {28, 12,   0}, // #14749
  {31, 12,   0}, // #14750
  {32, 12,   0}, // #14751
  { 4,  2,   0}, // #14752
  {36,  2,   0}, // #14753
  {37,  3,   0}, // #14754
  {38,  1,   0}, // #14755
  {39,  2,   0}, // #14756
  {14,  2,   0}, // #14757
  {19,  2,   0}, // #14758
  {24,  1,   0}, // #14759
  {25,  1,   0}, // #14760
  {27,  1,   0}, // #14761
  {28,  1,   0}, // #14762
  {30,  1,   0}, // #14763
  {31,  1,   0}, // #14764
  {32,  1,   0}, // #14765
  {34,  1,   0}, // #14766
  {35,  1,   0}, // #14767
  {37,  1,   0}, // #14768
  {38,  1,   0}, // #14769
  {14,  1,   0}, // #14770
  {19,  1,   0}, // #14771
  {24,  1,   0}, // #14772
  {25,  1,   0}, // #14773
  {27,  1,   0}, // #14774
  {28,  1,   0}, // #14775
  {30,  1,   0}, // #14776
  {31,  1,   0}, // #14777
  {32,  1,   0}, // #14778
  {34,  1,   0}, // #14779
  {35,  1,   0}, // #14780
  { 4,  1,   0}, // #14781
  {10,  2,   0}, // #14782
  {11,  2,   0}, // #14783
  {36,  3,   0}, // #14784
  {37,  1,   0}, // #14785
  {38,  1,   0}, // #14786
  {14,  1,   0}, // #14787
  {16,  1,   0}, // #14788
  {20,  1,   0}, // #14789
  {21,  1,   0}, // #14790
  {24,  1,   0}, // #14791
  {25,  1,   0}, // #14792
  {26,  1,   0}, // #14793
  {28,  1,   0}, // #14794
  {29,  1,   0}, // #14795
  {30,  1,   0}, // #14796
  {31,  1,   0}, // #14797
  {32,  1,   0}, // #14798
  {34,  1,   0}, // #14799
  {35,  1,   0}, // #14800
  { 4,  1,   0}, // #14801
  { 9,  2,   0}, // #14802
  {11,  2,   0}, // #14803
  {36,  3,   0}, // #14804
  {37,  1,   0}, // #14805
  {39,  1,   0}, // #14806
  { 9,  2,   0}, // #14807
  {11,  2,   0}, // #14808
  {36,  2,   0}, // #14809
  { 4,  1,   0}, // #14810
  {10,  4,   0}, // #14811
  {11,  4,   0}, // #14812
  {36,  5,   0}, // #14813
  {37,  1,   0}, // #14814
  {38,  1,   0}, // #14815
  {14, 10,   0}, // #14816
  {16,  9,   0}, // #14817
  {19,  1,   0}, // #14818
  {20,  9,   0}, // #14819
  {21,  9,   0}, // #14820
  {24,  9,   0}, // #14821
  {25,  9,   0}, // #14822
  {26,  9,   0}, // #14823
  {28,  9,   0}, // #14824
  {29,  9,   0}, // #14825
  {30,  9,   0}, // #14826
  {31,  9,   0}, // #14827
  {32,  9,   0}, // #14828
  {34,  9,   0}, // #14829
  {35,  9,   0}, // #14830
  {37,  1,   0}, // #14831
  {38,  1,   0}, // #14832
  {14,  9,   0}, // #14833
  {16,  9,   0}, // #14834
  {20,  9,   0}, // #14835
  {21,  9,   0}, // #14836
  {24,  9,   0}, // #14837
  {25,  9,   0}, // #14838
  {26,  9,   0}, // #14839
  {28,  9,   0}, // #14840
  {29,  9,   0}, // #14841
  {30,  9,   0}, // #14842
  {31,  9,   0}, // #14843
  {32,  9,   0}, // #14844
  {34,  9,   0}, // #14845
  {35,  9,   0}, // #14846
  {14, 23,   0}, // #14847
  {16, 23,   0}, // #14848
  {20, 23,   0}, // #14849
  {21, 23,   0}, // #14850
  {24, 23,   0}, // #14851
  {25, 23,   0}, // #14852
  {26, 23,   0}, // #14853
  {28, 23,   0}, // #14854
  {29, 23,   0}, // #14855
  {30, 23,   0}, // #14856
  {31, 23,   0}, // #14857
  {32, 23,   0}, // #14858
  {34, 23,   0}, // #14859
  {35, 23,   0}, // #14860
  { 4,  1,   0}, // #14861
  {11, 60,   0}, // #14862
  {36, 61,   0}, // #14863
  {37,  1,   0}, // #14864
  {39,  1,   0}, // #14865
  {14,  2,   0}, // #14866
  {19,  1,   0}, // #14867
  {22,  2,   0}, // #14868
  {23,  2,   0}, // #14869
  {25,  2,   0}, // #14870
  {27,  1,   0}, // #14871
  {28,  2,   0}, // #14872
  {31,  2,   0}, // #14873
  {32,  2,   0}, // #14874
  {37,  1,   0}, // #14875
  {39,  1,   0}, // #14876
  {14,  1,   0}, // #14877
  {19,  1,   0}, // #14878
  {22,  1,   0}, // #14879
  {23,  1,   0}, // #14880
  {25,  1,   0}, // #14881
  {27,  1,   0}, // #14882
  {28,  1,   0}, // #14883
  {31,  1,   0}, // #14884
  {32,  1,   0}, // #14885
  {37,  1,   0}, // #14886
  {39,  1,   0}, // #14887
  {19,  6,   0}, // #14888
  {27,  6,   0}, // #14889
  {37,  1,   0}, // #14890
  {39,  1,   0}, // #14891
  {19,  4,   0}, // #14892
  {27,  4,   0}, // #14893
  {37,  1,   0}, // #14894
  {39,  1,   0}, // #14895
  {19, 12,   0}, // #14896
  {27, 12,   0}, // #14897
  {37,  1,   0}, // #14898
  {39,  1,   0}, // #14899
  {14,  4,   0}, // #14900
  {19,  1,   0}, // #14901
  {24,  3,   0}, // #14902
  {25,  3,   0}, // #14903
  {28,  3,   0}, // #14904
  {30,  3,   0}, // #14905
  {31,  3,   0}, // #14906
  {32,  3,   0}, // #14907
  {34,  3,   0}, // #14908
  {35,  3,   0}, // #14909
  {37,  1,   0}, // #14910
  {38,  1,   0}, // #14911
  {14,  3,   0}, // #14912
  {24,  3,   0}, // #14913
  {25,  3,   0}, // #14914
  {28,  3,   0}, // #14915
  {30,  3,   0}, // #14916
  {31,  3,   0}, // #14917
  {32,  3,   0}, // #14918
  {34,  3,   0}, // #14919
  {35,  3,   0}, // #14920
  {14,  3,   0}, // #14921
  {19,  1,   0}, // #14922
  {24,  2,   0}, // #14923
  {25,  2,   0}, // #14924
  {28,  2,   0}, // #14925
  {30,  2,   0}, // #14926
  {31,  2,   0}, // #14927
  {32,  2,   0}, // #14928
  {34,  2,   0}, // #14929
  {35,  2,   0}, // #14930
  {37,  1,   0}, // #14931
  {38,  1,   0}, // #14932
  {14,  2,   0}, // #14933
  {24,  2,   0}, // #14934
  {25,  2,   0}, // #14935
  {28,  2,   0}, // #14936
  {30,  2,   0}, // #14937
  {31,  2,   0}, // #14938
  {32,  2,   0}, // #14939
  {34,  2,   0}, // #14940
  {35,  2,   0}, // #14941
  {37, 30,   0}, // #14942
  { 4,  3,   0}, // #14943
  {36,  3,   0}, // #14944
  {37,  1,   0}, // #14945
  {38,  1,   0}, // #14946
  { 4,  1,   0}, // #14947
  {11, 12,   0}, // #14948
  {36, 13,   0}, // #14949
  {37,  1,   0}, // #14950
  {38,  1,   0}, // #14951
  {11, 24,   0}, // #14952
  {36, 24,   0}, // #14953
  {11, 59,   0}, // #14954
  {36, 59,   0}, // #14955
  {10,  6,   0}, // #14956
  {11,  6,   0}, // #14957
  {36,  6,   0}, // #14958
  {10,  8,   0}, // #14959
  {11,  8,   0}, // #14960
  {36,  8,   0}, // #14961
  { 4,  1,   0}, // #14962
  {14,  1,   0}, // #14963
  {15,  1,   0}, // #14964
  {20,  1,   0}, // #14965
  {21,  1,   0}, // #14966
  {25,  1,   0}, // #14967
  {26,  1,   0}, // #14968
  {28,  1,   0}, // #14969
  {29,  1,   0}, // #14970
  {31,  1,   0}, // #14971
  {32,  1,   0}, // #14972
  {33,  1,   0}, // #14973
  {36,  1,   0}, // #14974
  {37,  1,   0}, // #14975
  {38,  1,   0}, // #14976
  { 4,  1,   0}, // #14977
  {14, 24,   0}, // #14978
  {25, 24,   0}, // #14979
  {28, 24,   0}, // #14980
  {31, 24,   0}, // #14981
  {32, 24,   0}, // #14982
  {36,  1,   0}, // #14983
  {37,  1,   0}, // #14984
  {38,  1,   0}, // #14985
  { 4,  1,   0}, // #14986
  {14, 62,   0}, // #14987
  {25, 62,   0}, // #14988
  {28, 62,   0}, // #14989
  {31, 62,   0}, // #14990
  {32, 62,   0}, // #14991
  {36,  1,   0}, // #14992
  {37,  1,   0}, // #14993
  {38,  1,   0}, // #14994
  { 4,  1,   0}, // #14995
  {11,  4,   0}, // #14996
  {36,  5,   0}, // #14997
  {37,  1,   0}, // #14998
  {39,  1,   0}, // #14999
  { 4,  1,   0}, // #15000
  {14,  1,   0}, // #15001
  {16,  1,   0}, // #15002
  {20,  1,   0}, // #15003
  {21,  1,   0}, // #15004
  {24,  1,   0}, // #15005
  {25,  1,   0}, // #15006
  {26,  1,   0}, // #15007
  {28,  1,   0}, // #15008
  {29,  1,   0}, // #15009
  {30,  1,   0}, // #15010
  {31,  1,   0}, // #15011
  {32,  1,   0}, // #15012
  {34,  1,   0}, // #15013
  {35,  1,   0}, // #15014
  {36,  1,   0}, // #15015
  {37,  1,   0}, // #15016
  {38,  1,   0}, // #15017
  {14,  1,   0}, // #15018
  {15,  1,   0}, // #15019
  {19,  1,   0}, // #15020
  {20,  1,   0}, // #15021
  {21,  1,   0}, // #15022
  {25,  1,   0}, // #15023
  {26,  1,   0}, // #15024
  {27,  1,   0}, // #15025
  {28,  1,   0}, // #15026
  {29,  1,   0}, // #15027
  {31,  1,   0}, // #15028
  {32,  1,   0}, // #15029
  {33,  1,   0}, // #15030
  {37,  1,   0}, // #15031
  {39,  1,   0}, // #15032
  {14,  6,   0}, // #15033
  {22,  6,   0}, // #15034
  {23,  6,   0}, // #15035
  {25,  6,   0}, // #15036
  {28,  6,   0}, // #15037
  {31,  6,   0}, // #15038
  {32,  6,   0}, // #15039
  { 4,  1,   0}, // #15040
  {14,  8,   0}, // #15041
  {25,  8,   0}, // #15042
  {28,  8,   0}, // #15043
  {31,  8,   0}, // #15044
  {32,  8,   0}, // #15045
  {36,  1,   0}, // #15046
  {37,  1,   0}, // #15047
  {38,  1,   0}, // #15048
  {14,  3,   0}, // #15049
  {25,  3,   0}, // #15050
  {28,  3,   0}, // #15051
  {31,  3,   0}, // #15052
  {32,  3,   0}, // #15053
  { 4,  1,   0}, // #15054
  {14,  3,   0}, // #15055
  {25,  3,   0}, // #15056
  {28,  3,   0}, // #15057
  {31,  3,   0}, // #15058
  {32,  3,   0}, // #15059
  {36,  1,   0}, // #15060
  {37,  1,   0}, // #15061
  {38,  1,   0}, // #15062
  { 4,  1,   0}, // #15063
  {14,  2,   0}, // #15064
  {25,  2,   0}, // #15065
  {28,  2,   0}, // #15066
  {31,  2,   0}, // #15067
  {32,  2,   0}, // #15068
  {36,  1,   0}, // #15069
  {37,  1,   0}, // #15070
  {38,  1,   0}, // #15071
  { 4,  1,   0}, // #15072
  {11,  7,   0}, // #15073
  {36,  8,   0}, // #15074
  {37,  2,   0}, // #15075
  {38,  1,   0}, // #15076
  {39,  1,   0}, // #15077
  { 4,  1,   0}, // #15078
  {10,  8,   0}, // #15079
  {11,  8,   0}, // #15080
  {36,  9,   0}, // #15081
  {37,  1,   0}, // #15082
  {38,  1,   0}, // #15083
  {14,  5,   0}, // #15084
  {19,  1,   0}, // #15085
  {25,  4,   0}, // #15086
  {28,  4,   0}, // #15087
  {31,  4,   0}, // #15088
  {32,  4,   0}, // #15089
  { 4,  1,   0}, // #15090
  {14,  2,   0}, // #15091
  {16,  2,   0}, // #15092
  {20,  2,   0}, // #15093
  {21,  2,   0}, // #15094
  {24,  2,   0}, // #15095
  {25,  2,   0}, // #15096
  {26,  2,   0}, // #15097
  {28,  2,   0}, // #15098
  {29,  2,   0}, // #15099
  {30,  2,   0}, // #15100
  {31,  2,   0}, // #15101
  {32,  2,   0}, // #15102
  {34,  2,   0}, // #15103
  {35,  2,   0}, // #15104
  {36,  1,   0}, // #15105
  {37,  1,   0}, // #15106
  {38,  1,   0}, // #15107
  {11,  1,   0}, // #15108
  {41,  1,   0}, // #15109
  {11,  0,   0}, // #15110
  {41,  0,   0}, // #15111
  {14,  1,   0}, // #15112
  {28,  1,   0}, // #15113
  {33,  1,   0}, // #15114
  {36,  1,   0}, // #15115
  {37,  1,   0}, // #15116
  {13,  1,   0}, // #15117
  {41,  1,   0}, // #15118
  {11, 12,   0}, // #15119
  {41, 12,   0}, // #15120
  { 4,  1,   0}, // #15121
  {13,  1,   0}, // #15122
  {41,  2,   0}, // #15123
  {42,  1,   0}, // #15124
  {43,  1,   0}, // #15125
  {11,  4,   0}, // #15126
  {41,  4,   0}, // #15127
  {19,  1,   0}, // #15128
  {32,  1,   0}, // #15129
  {42,  1,   0}, // #15130
  {44,  1,   0}, // #15131
  {14,  1,   0}, // #15132
  {19,  1,   0}, // #15133
  {30,  1,   0}, // #15134
  {42,  1,   0}, // #15135
  {43,  1,   0}, // #15136
  {11, 100,   0}, // #15137
  {41, 100,   0}, // #15138
  { 4,  1,   0}, // #15139
  {41,  1,   0}, // #15140
  { 4,  1,   0}, // #15141
  {41,  1,   0}, // #15142
  {42,  1,   0}, // #15143
  {44,  1,   0}, // #15144
  {10,  3,   0}, // #15145
  {11,  3,   0}, // #15146
  {41,  3,   0}, // #15147
  { 4,  2,   0}, // #15148
  {11,  1,   0}, // #15149
  {41,  3,   0}, // #15150
  {42,  2,   0}, // #15151
  {43,  1,   0}, // #15152
  {44,  1,   0}, // #15153
  {14,  2,   0}, // #15154
  {20,  2,   0}, // #15155
  {21,  2,   0}, // #15156
  {24,  2,   0}, // #15157
  {28,  2,   0}, // #15158
  {29,  2,   0}, // #15159
  {33,  2,   0}, // #15160
  {34,  2,   0}, // #15161
  {36,  2,   0}, // #15162
  {37,  2,   0}, // #15163
  { 4,  2,   0}, // #15164
  {11,  4,   0}, // #15165
  {41,  6,   0}, // #15166
  {42,  2,   0}, // #15167
  {43,  1,   0}, // #15168
  {44,  1,   0}, // #15169
  { 4,  1,   0}, // #15170
  {11,  4,   0}, // #15171
  {41,  5,   0}, // #15172
  {42,  1,   0}, // #15173
  {43,  1,   0}, // #15174
  { 4,  1,   0}, // #15175
  {11,  1,   0}, // #15176
  {41,  2,   0}, // #15177
  {42,  1,   0}, // #15178
  {43,  1,   0}, // #15179
  {14,  2,   0}, // #15180
  {19,  1,   0}, // #15181
  {22,  1,   0}, // #15182
  {23,  1,   0}, // #15183
  {26,  1,   0}, // #15184
  {27,  1,   0}, // #15185
  {28,  1,   0}, // #15186
  {30,  1,   0}, // #15187
  {31,  1,   0}, // #15188
  {33,  1,   0}, // #15189
  {36,  1,   0}, // #15190
  {37,  1,   0}, // #15191
  {42,  1,   0}, // #15192
  {43,  1,   0}, // #15193
  {14,  1,   0}, // #15194
  {22,  1,   0}, // #15195
  {23,  1,   0}, // #15196
  {26,  1,   0}, // #15197
  {27,  1,   0}, // #15198
  {28,  1,   0}, // #15199
  {31,  1,   0}, // #15200
  {33,  1,   0}, // #15201
  {36,  1,   0}, // #15202
  {37,  1,   0}, // #15203
  {14,  2,   0}, // #15204
  {19,  1,   0}, // #15205
  {20,  1,   0}, // #15206
  {21,  1,   0}, // #15207
  {24,  1,   0}, // #15208
  {28,  1,   0}, // #15209
  {29,  1,   0}, // #15210
  {30,  1,   0}, // #15211
  {33,  1,   0}, // #15212
  {34,  1,   0}, // #15213
  {36,  1,   0}, // #15214
  {37,  1,   0}, // #15215
  {42,  1,   0}, // #15216
  {43,  1,   0}, // #15217
  {14,  1,   0}, // #15218
  {20,  1,   0}, // #15219
  {21,  1,   0}, // #15220
  {24,  1,   0}, // #15221
  {28,  1,   0}, // #15222
  {29,  1,   0}, // #15223
  {33,  1,   0}, // #15224
  {34,  1,   0}, // #15225
  {36,  1,   0}, // #15226
  {37,  1,   0}, // #15227
  {14,  2,   0}, // #15228
  {19,  1,   0}, // #15229
  {28,  1,   0}, // #15230
  {30,  1,   0}, // #15231
  {33,  1,   0}, // #15232
  {36,  1,   0}, // #15233
  {37,  1,   0}, // #15234
  {42,  1,   0}, // #15235
  {43,  1,   0}, // #15236
  { 4,  1,   0}, // #15237
  {10,  1,   0}, // #15238
  {11,  1,   0}, // #15239
  {41,  2,   0}, // #15240
  {42,  1,   0}, // #15241
  {43,  1,   0}, // #15242
  {10,  1,   0}, // #15243
  {11,  1,   0}, // #15244
  {41,  1,   0}, // #15245
  { 4,  1,   0}, // #15246
  { 6,  1,   0}, // #15247
  {10,  1,   0}, // #15248
  {11,  1,   0}, // #15249
  {41,  2,   0}, // #15250
  {42,  1,   0}, // #15251
  {43,  1,   0}, // #15252
  { 6,  1,   0}, // #15253
  {10,  1,   0}, // #15254
  {11,  1,   0}, // #15255
  {41,  1,   0}, // #15256
  { 4,  2,   0}, // #15257
  {10,  1,   0}, // #15258
  {11,  1,   0}, // #15259
  {41,  3,   0}, // #15260
  {42,  2,   0}, // #15261
  {43,  1,   0}, // #15262
  {44,  1,   0}, // #15263
  {10,  2,   0}, // #15264
  {11,  2,   0}, // #15265
  {41,  2,   0}, // #15266
  { 9,  1,   0}, // #15267
  {11,  1,   0}, // #15268
  {41,  1,   0}, // #15269
  { 4,  1,   0}, // #15270
  { 9,  1,   0}, // #15271
  {11,  1,   0}, // #15272
  {41,  2,   0}, // #15273
  {42,  1,   0}, // #15274
  {43,  1,   0}, // #15275
  { 4,  1,   0}, // #15276
  {41,  1,   0}, // #15277
  {42,  1,   0}, // #15278
  {43,  1,   0}, // #15279
  {11, 28,   0}, // #15280
  {41, 28,   0}, // #15281
  {11,  8,   0}, // #15282
  {41,  8,   0}, // #15283
  {14,  3,   0}, // #15284
  {19,  1,   0}, // #15285
  {20,  2,   0}, // #15286
  {21,  2,   0}, // #15287
  {24,  2,   0}, // #15288
  {28,  2,   0}, // #15289
  {29,  2,   0}, // #15290
  {30,  1,   0}, // #15291
  {33,  2,   0}, // #15292
  {34,  2,   0}, // #15293
  {36,  2,   0}, // #15294
  {37,  2,   0}, // #15295
  {42,  1,   0}, // #15296
  {43,  1,   0}, // #15297
  {14,  3,   0}, // #15298
  {19,  1,   0}, // #15299
  {22,  2,   0}, // #15300
  {23,  2,   0}, // #15301
  {26,  2,   0}, // #15302
  {27,  2,   0}, // #15303
  {28,  2,   0}, // #15304
  {30,  1,   0}, // #15305
  {31,  2,   0}, // #15306
  {33,  2,   0}, // #15307
  {36,  2,   0}, // #15308
  {37,  2,   0}, // #15309
  {42,  1,   0}, // #15310
  {43,  1,   0}, // #15311
  {14,  2,   0}, // #15312
  {22,  2,   0}, // #15313
  {23,  2,   0}, // #15314
  {26,  2,   0}, // #15315
  {27,  2,   0}, // #15316
  {28,  2,   0}, // #15317
  {31,  2,   0}, // #15318
  {33,  2,   0}, // #15319
  {36,  2,   0}, // #15320
  {37,  2,   0}, // #15321
  {14,  6,   0}, // #15322
  {19,  1,   0}, // #15323
  {22,  5,   0}, // #15324
  {23,  5,   0}, // #15325
  {26,  5,   0}, // #15326
  {27,  5,   0}, // #15327
  {28,  5,   0}, // #15328
  {30,  1,   0}, // #15329
  {31,  5,   0}, // #15330
  {33,  5,   0}, // #15331
  {36,  5,   0}, // #15332
  {37,  5,   0}, // #15333
  {42,  1,   0}, // #15334
  {43,  1,   0}, // #15335
  {14,  5,   0}, // #15336
  {22,  5,   0}, // #15337
  {23,  5,   0}, // #15338
  {26,  5,   0}, // #15339
  {27,  5,   0}, // #15340
  {28,  5,   0}, // #15341
  {31,  5,   0}, // #15342
  {33,  5,   0}, // #15343
  {36,  5,   0}, // #15344
  {37,  5,   0}, // #15345
  { 4,  1,   0}, // #15346
  { 5, 11,   0}, // #15347
  { 9, 11,   0}, // #15348
  {11, 11,   0}, // #15349
  {13, 11,   0}, // #15350
  {41, 12,   0}, // #15351
  {42,  1,   0}, // #15352
  {43,  1,   0}, // #15353
  { 5, 11,   0}, // #15354
  { 9, 11,   0}, // #15355
  {11, 11,   0}, // #15356
  {13, 11,   0}, // #15357
  {41, 11,   0}, // #15358
  { 4,  1,   0}, // #15359
  { 5, 13,   0}, // #15360
  { 9, 13,   0}, // #15361
  {11, 13,   0}, // #15362
  {13, 13,   0}, // #15363
  {41, 14,   0}, // #15364
  {42,  1,   0}, // #15365
  {43,  1,   0}, // #15366
  { 5, 13,   0}, // #15367
  { 9, 13,   0}, // #15368
  {11, 13,   0}, // #15369
  {13, 13,   0}, // #15370
  {41, 13,   0}, // #15371
  { 4,  1,   0}, // #15372
  { 5, 17,   0}, // #15373
  { 9, 17,   0}, // #15374
  {11, 17,   0}, // #15375
  {13, 17,   0}, // #15376
  {41, 18,   0}, // #15377
  {42,  1,   0}, // #15378
  {43,  1,   0}, // #15379
  { 5, 17,   0}, // #15380
  { 9, 17,   0}, // #15381
  {11, 17,   0}, // #15382
  {13, 17,   0}, // #15383
  {41, 17,   0}, // #15384
  { 4,  1,   0}, // #15385
  { 5, 10,   0}, // #15386
  { 9, 10,   0}, // #15387
  {11, 10,   0}, // #15388
  {13, 10,   0}, // #15389
  {41, 11,   0}, // #15390
  {42,  1,   0}, // #15391
  {43,  1,   0}, // #15392
  { 5, 10,   0}, // #15393
  { 9, 10,   0}, // #15394
  {11, 10,   0}, // #15395
  {13, 10,   0}, // #15396
  {41, 10,   0}, // #15397
  {14,  6,   0}, // #15398
  {16,  5,   0}, // #15399
  {19,  1,   0}, // #15400
  {20,  5,   0}, // #15401
  {21,  5,   0}, // #15402
  {24,  5,   0}, // #15403
  {25,  5,   0}, // #15404
  {27,  5,   0}, // #15405
  {28,  5,   0}, // #15406
  {29,  5,   0}, // #15407
  {30,  1,   0}, // #15408
  {33,  5,   0}, // #15409
  {34,  5,   0}, // #15410
  {35,  5,   0}, // #15411
  {36,  5,   0}, // #15412
  {37,  5,   0}, // #15413
  {39,  5,   0}, // #15414
  {40,  5,   0}, // #15415
  {42,  1,   0}, // #15416
  {43,  1,   0}, // #15417
  {14,  5,   0}, // #15418
  {16,  5,   0}, // #15419
  {20,  5,   0}, // #15420
  {21,  5,   0}, // #15421
  {24,  5,   0}, // #15422
  {25,  5,   0}, // #15423
  {27,  5,   0}, // #15424
  {28,  5,   0}, // #15425
  {29,  5,   0}, // #15426
  {33,  5,   0}, // #15427
  {34,  5,   0}, // #15428
  {35,  5,   0}, // #15429
  {36,  5,   0}, // #15430
  {37,  5,   0}, // #15431
  {39,  5,   0}, // #15432
  {40,  5,   0}, // #15433
  {14,  4,   0}, // #15434
  {16,  3,   0}, // #15435
  {19,  1,   0}, // #15436
  {20,  3,   0}, // #15437
  {21,  3,   0}, // #15438
  {24,  3,   0}, // #15439
  {25,  3,   0}, // #15440
  {27,  3,   0}, // #15441
  {28,  3,   0}, // #15442
  {29,  3,   0}, // #15443
  {30,  1,   0}, // #15444
  {33,  3,   0}, // #15445
  {34,  3,   0}, // #15446
  {35,  3,   0}, // #15447
  {36,  3,   0}, // #15448
  {37,  3,   0}, // #15449
  {39,  3,   0}, // #15450
  {40,  3,   0}, // #15451
  {42,  1,   0}, // #15452
  {43,  1,   0}, // #15453
  {14,  3,   0}, // #15454
  {16,  3,   0}, // #15455
  {20,  3,   0}, // #15456
  {21,  3,   0}, // #15457
  {24,  3,   0}, // #15458
  {25,  3,   0}, // #15459
  {27,  3,   0}, // #15460
  {28,  3,   0}, // #15461
  {29,  3,   0}, // #15462
  {33,  3,   0}, // #15463
  {34,  3,   0}, // #15464
  {35,  3,   0}, // #15465
  {36,  3,   0}, // #15466
  {37,  3,   0}, // #15467
  {39,  3,   0}, // #15468
  {40,  3,   0}, // #15469
  {14,  7,   0}, // #15470
  {19,  1,   0}, // #15471
  {20,  6,   0}, // #15472
  {21,  6,   0}, // #15473
  {24,  6,   0}, // #15474
  {28,  6,   0}, // #15475
  {29,  6,   0}, // #15476
  {30,  1,   0}, // #15477
  {33,  6,   0}, // #15478
  {34,  6,   0}, // #15479
  {36,  6,   0}, // #15480
  {37,  6,   0}, // #15481
  {42,  1,   0}, // #15482
  {43,  1,   0}, // #15483
  {14,  6,   0}, // #15484
  {20,  6,   0}, // #15485
  {21,  6,   0}, // #15486
  {24,  6,   0}, // #15487
  {28,  6,   0}, // #15488
  {29,  6,   0}, // #15489
  {33,  6,   0}, // #15490
  {34,  6,   0}, // #15491
  {36,  6,   0}, // #15492
  {37,  6,   0}, // #15493
  {14,  9,   0}, // #15494
  {19,  1,   0}, // #15495
  {20,  8,   0}, // #15496
  {21,  8,   0}, // #15497
  {24,  8,   0}, // #15498
  {28,  8,   0}, // #15499
  {29,  8,   0}, // #15500
  {30,  1,   0}, // #15501
  {33,  8,   0}, // #15502
  {34,  8,   0}, // #15503
  {36,  8,   0}, // #15504
  {37,  8,   0}, // #15505
  {42,  1,   0}, // #15506
  {43,  1,   0}, // #15507
  {14,  8,   0}, // #15508
  {20,  8,   0}, // #15509
  {21,  8,   0}, // #15510
  {24,  8,   0}, // #15511
  {28,  8,   0}, // #15512
  {29,  8,   0}, // #15513
  {33,  8,   0}, // #15514
  {34,  8,   0}, // #15515
  {36,  8,   0}, // #15516
  {37,  8,   0}, // #15517
  { 4,  1,   0}, // #15518
  {41,  1,   0}, // #15519
  {42,  2,   0}, // #15520
  {44,  2,   0}, // #15521
  {14,  2,   0}, // #15522
  {19,  2,   0}, // #15523
  {30,  2,   0}, // #15524
  {14,  2,   0}, // #15525
  {16,  1,   0}, // #15526
  {19,  1,   0}, // #15527
  {20,  1,   0}, // #15528
  {21,  1,   0}, // #15529
  {24,  1,   0}, // #15530
  {25,  1,   0}, // #15531
  {27,  1,   0}, // #15532
  {28,  1,   0}, // #15533
  {29,  1,   0}, // #15534
  {30,  1,   0}, // #15535
  {33,  1,   0}, // #15536
  {34,  1,   0}, // #15537
  {35,  1,   0}, // #15538
  {36,  1,   0}, // #15539
  {37,  1,   0}, // #15540
  {39,  1,   0}, // #15541
  {40,  1,   0}, // #15542
  {42,  1,   0}, // #15543
  {43,  1,   0}, // #15544
  {14,  2,   0}, // #15545
  {19,  1,   0}, // #15546
  {28,  1,   0}, // #15547
  {30,  1,   0}, // #15548
  {33,  1,   0}, // #15549
  {36,  1,   0}, // #15550
  {37,  1,   0}, // #15551
  {38,  1,   0}, // #15552
  {42,  1,   0}, // #15553
  {43,  1,   0}, // #15554
  {14,  1,   0}, // #15555
  {28,  1,   0}, // #15556
  {33,  1,   0}, // #15557
  {36,  1,   0}, // #15558
  {37,  1,   0}, // #15559
  {38,  1,   0}, // #15560
  {14,  3,   0}, // #15561
  {17,  2,   0}, // #15562
  {19,  1,   0}, // #15563
  {22,  2,   0}, // #15564
  {23,  2,   0}, // #15565
  {25,  2,   0}, // #15566
  {26,  2,   0}, // #15567
  {27,  2,   0}, // #15568
  {28,  2,   0}, // #15569
  {30,  1,   0}, // #15570
  {31,  2,   0}, // #15571
  {33,  2,   0}, // #15572
  {35,  2,   0}, // #15573
  {36,  2,   0}, // #15574
  {37,  2,   0}, // #15575
  {39,  2,   0}, // #15576
  {40,  2,   0}, // #15577
  {42,  1,   0}, // #15578
  {43,  1,   0}, // #15579
  {14,  2,   0}, // #15580
  {17,  2,   0}, // #15581
  {22,  2,   0}, // #15582
  {23,  2,   0}, // #15583
  {25,  2,   0}, // #15584
  {26,  2,   0}, // #15585
  {27,  2,   0}, // #15586
  {28,  2,   0}, // #15587
  {31,  2,   0}, // #15588
  {33,  2,   0}, // #15589
  {35,  2,   0}, // #15590
  {36,  2,   0}, // #15591
  {37,  2,   0}, // #15592
  {39,  2,   0}, // #15593
  {40,  2,   0}, // #15594
  { 4,  1,   0}, // #15595
  { 6,  3,   0}, // #15596
  {10,  3,   0}, // #15597
  {11,  3,   0}, // #15598
  {41,  4,   0}, // #15599
  {42,  1,   0}, // #15600
  {43,  1,   0}, // #15601
  { 6,  3,   0}, // #15602
  {10,  3,   0}, // #15603
  {11,  3,   0}, // #15604
  {41,  3,   0}, // #15605
  { 4,  1,   0}, // #15606
  { 6,  4,   0}, // #15607
  {10,  4,   0}, // #15608
  {11,  4,   0}, // #15609
  {41,  5,   0}, // #15610
  {42,  1,   0}, // #15611
  {43,  1,   0}, // #15612
  { 6,  4,   0}, // #15613
  {10,  4,   0}, // #15614
  {11,  4,   0}, // #15615
  {41,  4,   0}, // #15616
  {14,  2,   0}, // #15617
  {19,  1,   0}, // #15618
  {25,  1,   0}, // #15619
  {27,  1,   0}, // #15620
  {28,  1,   0}, // #15621
  {30,  1,   0}, // #15622
  {33,  1,   0}, // #15623
  {35,  1,   0}, // #15624
  {36,  1,   0}, // #15625
  {37,  1,   0}, // #15626
  {39,  1,   0}, // #15627
  {40,  1,   0}, // #15628
  {42,  1,   0}, // #15629
  {43,  1,   0}, // #15630
  {14,  1,   0}, // #15631
  {25,  1,   0}, // #15632
  {27,  1,   0}, // #15633
  {28,  1,   0}, // #15634
  {33,  1,   0}, // #15635
  {35,  1,   0}, // #15636
  {36,  1,   0}, // #15637
  {37,  1,   0}, // #15638
  {39,  1,   0}, // #15639
  {40,  1,   0}, // #15640
  { 8,  1,   0}, // #15641
  { 9,  1,   0}, // #15642
  {11,  1,   0}, // #15643
  {41,  1,   0}, // #15644
  { 4,  1,   0}, // #15645
  {11,  6,   0}, // #15646
  {41,  7,   0}, // #15647
  {42,  1,   0}, // #15648
  {43,  1,   0}, // #15649
  {14,  3,   0}, // #15650
  {15,  2,   0}, // #15651
  {19,  1,   0}, // #15652
  {20,  2,   0}, // #15653
  {21,  2,   0}, // #15654
  {24,  2,   0}, // #15655
  {28,  2,   0}, // #15656
  {29,  2,   0}, // #15657
  {30,  1,   0}, // #15658
  {33,  2,   0}, // #15659
  {34,  2,   0}, // #15660
  {36,  2,   0}, // #15661
  {37,  2,   0}, // #15662
  {38,  2,   0}, // #15663
  {42,  1,   0}, // #15664
  {43,  1,   0}, // #15665
  {14,  2,   0}, // #15666
  {15,  2,   0}, // #15667
  {20,  2,   0}, // #15668
  {21,  2,   0}, // #15669
  {24,  2,   0}, // #15670
  {28,  2,   0}, // #15671
  {29,  2,   0}, // #15672
  {33,  2,   0}, // #15673
  {34,  2,   0}, // #15674
  {36,  2,   0}, // #15675
  {37,  2,   0}, // #15676
  {38,  2,   0}, // #15677
  {14,  3,   0}, // #15678
  {19,  3,   0}, // #15679
  {30,  3,   0}, // #15680
  {42,  1,   0}, // #15681
  {43,  1,   0}, // #15682
  {14,  1,   0}, // #15683
  {17,  1,   0}, // #15684
  {22,  1,   0}, // #15685
  {23,  1,   0}, // #15686
  {25,  1,   0}, // #15687
  {26,  1,   0}, // #15688
  {27,  1,   0}, // #15689
  {28,  1,   0}, // #15690
  {31,  1,   0}, // #15691
  {33,  1,   0}, // #15692
  {35,  1,   0}, // #15693
  {36,  1,   0}, // #15694
  {37,  1,   0}, // #15695
  {39,  1,   0}, // #15696
  {40,  1,   0}, // #15697
  {14,  3,   0}, // #15698
  {19,  1,   0}, // #15699
  {28,  2,   0}, // #15700
  {30,  1,   0}, // #15701
  {33,  2,   0}, // #15702
  {36,  2,   0}, // #15703
  {37,  2,   0}, // #15704
  {42,  1,   0}, // #15705
  {43,  1,   0}, // #15706
  {14,  2,   0}, // #15707
  {28,  2,   0}, // #15708
  {33,  2,   0}, // #15709
  {36,  2,   0}, // #15710
  {37,  2,   0}, // #15711
  {14,  9,   0}, // #15712
  {19,  1,   0}, // #15713
  {28,  8,   0}, // #15714
  {30,  1,   0}, // #15715
  {33,  8,   0}, // #15716
  {36,  8,   0}, // #15717
  {37,  8,   0}, // #15718
  {42,  1,   0}, // #15719
  {43,  1,   0}, // #15720
  {14,  8,   0}, // #15721
  {28,  8,   0}, // #15722
  {33,  8,   0}, // #15723
  {36,  8,   0}, // #15724
  {37,  8,   0}, // #15725
  {14,  5,   0}, // #15726
  {19,  1,   0}, // #15727
  {20,  4,   0}, // #15728
  {21,  4,   0}, // #15729
  {24,  4,   0}, // #15730
  {28,  4,   0}, // #15731
  {29,  4,   0}, // #15732
  {30,  1,   0}, // #15733
  {33,  4,   0}, // #15734
  {34,  4,   0}, // #15735
  {36,  4,   0}, // #15736
  {37,  4,   0}, // #15737
  {42,  1,   0}, // #15738
  {43,  1,   0}, // #15739
  {14,  4,   0}, // #15740
  {20,  4,   0}, // #15741
  {21,  4,   0}, // #15742
  {24,  4,   0}, // #15743
  {28,  4,   0}, // #15744
  {29,  4,   0}, // #15745
  {33,  4,   0}, // #15746
  {34,  4,   0}, // #15747
  {36,  4,   0}, // #15748
  {37,  4,   0}, // #15749
  {14, 13,   0}, // #15750
  {19,  1,   0}, // #15751
  {28, 12,   0}, // #15752
  {30,  1,   0}, // #15753
  {33, 12,   0}, // #15754
  {36, 12,   0}, // #15755
  {37, 12,   0}, // #15756
  {42,  1,   0}, // #15757
  {43,  1,   0}, // #15758
  {14, 12,   0}, // #15759
  {28, 12,   0}, // #15760
  {33, 12,   0}, // #15761
  {36, 12,   0}, // #15762
  {37, 12,   0}, // #15763
  { 4,  2,   0}, // #15764
  {41,  2,   0}, // #15765
  {42,  3,   0}, // #15766
  {43,  1,   0}, // #15767
  {44,  2,   0}, // #15768
  {14,  3,   0}, // #15769
  {19,  1,   0}, // #15770
  {25,  2,   0}, // #15771
  {27,  2,   0}, // #15772
  {28,  2,   0}, // #15773
  {30,  1,   0}, // #15774
  {33,  2,   0}, // #15775
  {35,  2,   0}, // #15776
  {36,  2,   0}, // #15777
  {37,  2,   0}, // #15778
  {39,  2,   0}, // #15779
  {40,  2,   0}, // #15780
  {42,  1,   0}, // #15781
  {43,  1,   0}, // #15782
  {14,  2,   0}, // #15783
  {25,  2,   0}, // #15784
  {27,  2,   0}, // #15785
  {28,  2,   0}, // #15786
  {33,  2,   0}, // #15787
  {35,  2,   0}, // #15788
  {36,  2,   0}, // #15789
  {37,  2,   0}, // #15790
  {39,  2,   0}, // #15791
  {40,  2,   0}, // #15792
  {14,  2,   0}, // #15793
  {19,  2,   0}, // #15794
  {25,  1,   0}, // #15795
  {27,  1,   0}, // #15796
  {28,  1,   0}, // #15797
  {30,  1,   0}, // #15798
  {32,  1,   0}, // #15799
  {33,  1,   0}, // #15800
  {35,  1,   0}, // #15801
  {36,  1,   0}, // #15802
  {37,  1,   0}, // #15803
  {39,  1,   0}, // #15804
  {40,  1,   0}, // #15805
  {42,  1,   0}, // #15806
  {43,  1,   0}, // #15807
  {14,  1,   0}, // #15808
  {19,  1,   0}, // #15809
  {25,  1,   0}, // #15810
  {27,  1,   0}, // #15811
  {28,  1,   0}, // #15812
  {32,  1,   0}, // #15813
  {33,  1,   0}, // #15814
  {35,  1,   0}, // #15815
  {36,  1,   0}, // #15816
  {37,  1,   0}, // #15817
  {39,  1,   0}, // #15818
  {40,  1,   0}, // #15819
  { 4,  1,   0}, // #15820
  {10,  2,   0}, // #15821
  {11,  2,   0}, // #15822
  {41,  3,   0}, // #15823
  {42,  1,   0}, // #15824
  {43,  1,   0}, // #15825
  {14,  1,   0}, // #15826
  {16,  1,   0}, // #15827
  {20,  1,   0}, // #15828
  {21,  1,   0}, // #15829
  {24,  1,   0}, // #15830
  {25,  1,   0}, // #15831
  {27,  1,   0}, // #15832
  {28,  1,   0}, // #15833
  {29,  1,   0}, // #15834
  {33,  1,   0}, // #15835
  {34,  1,   0}, // #15836
  {35,  1,   0}, // #15837
  {36,  1,   0}, // #15838
  {37,  1,   0}, // #15839
  {39,  1,   0}, // #15840
  {40,  1,   0}, // #15841
  { 4,  1,   0}, // #15842
  { 9,  2,   0}, // #15843
  {11,  2,   0}, // #15844
  {41,  3,   0}, // #15845
  {42,  1,   0}, // #15846
  {44,  1,   0}, // #15847
  { 9,  2,   0}, // #15848
  {11,  2,   0}, // #15849
  {41,  2,   0}, // #15850
  { 4,  1,   0}, // #15851
  {10,  4,   0}, // #15852
  {11,  4,   0}, // #15853
  {41,  5,   0}, // #15854
  {42,  1,   0}, // #15855
  {43,  1,   0}, // #15856
  {14, 10,   0}, // #15857
  {16,  9,   0}, // #15858
  {19,  1,   0}, // #15859
  {20,  9,   0}, // #15860
  {21,  9,   0}, // #15861
  {24,  9,   0}, // #15862
  {25,  9,   0}, // #15863
  {27,  9,   0}, // #15864
  {28,  9,   0}, // #15865
  {29,  9,   0}, // #15866
  {30,  1,   0}, // #15867
  {33,  9,   0}, // #15868
  {34,  9,   0}, // #15869
  {35,  9,   0}, // #15870
  {36,  9,   0}, // #15871
  {37,  9,   0}, // #15872
  {39,  9,   0}, // #15873
  {40,  9,   0}, // #15874
  {42,  1,   0}, // #15875
  {43,  1,   0}, // #15876
  {14,  9,   0}, // #15877
  {16,  9,   0}, // #15878
  {20,  9,   0}, // #15879
  {21,  9,   0}, // #15880
  {24,  9,   0}, // #15881
  {25,  9,   0}, // #15882
  {27,  9,   0}, // #15883
  {28,  9,   0}, // #15884
  {29,  9,   0}, // #15885
  {33,  9,   0}, // #15886
  {34,  9,   0}, // #15887
  {35,  9,   0}, // #15888
  {36,  9,   0}, // #15889
  {37,  9,   0}, // #15890
  {39,  9,   0}, // #15891
  {40,  9,   0}, // #15892
  {14, 23,   0}, // #15893
  {16, 23,   0}, // #15894
  {20, 23,   0}, // #15895
  {21, 23,   0}, // #15896
  {24, 23,   0}, // #15897
  {25, 23,   0}, // #15898
  {27, 23,   0}, // #15899
  {28, 23,   0}, // #15900
  {29, 23,   0}, // #15901
  {33, 23,   0}, // #15902
  {34, 23,   0}, // #15903
  {35, 23,   0}, // #15904
  {36, 23,   0}, // #15905
  {37, 23,   0}, // #15906
  {39, 23,   0}, // #15907
  {40, 23,   0}, // #15908
  { 4,  1,   0}, // #15909
  {11, 60,   0}, // #15910
  {41, 61,   0}, // #15911
  {42,  1,   0}, // #15912
  {44,  1,   0}, // #15913
  {14,  5,   0}, // #15914
  {19,  1,   0}, // #15915
  {22,  4,   0}, // #15916
  {23,  4,   0}, // #15917
  {26,  4,   0}, // #15918
  {27,  4,   0}, // #15919
  {28,  4,   0}, // #15920
  {30,  1,   0}, // #15921
  {31,  4,   0}, // #15922
  {33,  4,   0}, // #15923
  {36,  4,   0}, // #15924
  {37,  4,   0}, // #15925
  {42,  1,   0}, // #15926
  {43,  1,   0}, // #15927
  {14,  4,   0}, // #15928
  {22,  4,   0}, // #15929
  {23,  4,   0}, // #15930
  {26,  4,   0}, // #15931
  {27,  4,   0}, // #15932
  {28,  4,   0}, // #15933
  {31,  4,   0}, // #15934
  {33,  4,   0}, // #15935
  {36,  4,   0}, // #15936
  {37,  4,   0}, // #15937
  {14,  3,   0}, // #15938
  {19,  1,   0}, // #15939
  {28,  2,   0}, // #15940
  {30,  1,   0}, // #15941
  {33,  2,   0}, // #15942
  {36,  2,   0}, // #15943
  {37,  2,   0}, // #15944
  {38,  2,   0}, // #15945
  {42,  1,   0}, // #15946
  {43,  1,   0}, // #15947
  {14,  2,   0}, // #15948
  {28,  2,   0}, // #15949
  {33,  2,   0}, // #15950
  {36,  2,   0}, // #15951
  {37,  2,   0}, // #15952
  {38,  2,   0}, // #15953
  {14,  2,   0}, // #15954
  {19,  1,   0}, // #15955
  {22,  2,   0}, // #15956
  {23,  2,   0}, // #15957
  {26,  2,   0}, // #15958
  {27,  2,   0}, // #15959
  {28,  2,   0}, // #15960
  {31,  2,   0}, // #15961
  {32,  1,   0}, // #15962
  {33,  2,   0}, // #15963
  {36,  2,   0}, // #15964
  {37,  2,   0}, // #15965
  {42,  1,   0}, // #15966
  {44,  1,   0}, // #15967
  {14,  1,   0}, // #15968
  {19,  1,   0}, // #15969
  {22,  1,   0}, // #15970
  {23,  1,   0}, // #15971
  {26,  1,   0}, // #15972
  {27,  1,   0}, // #15973
  {28,  1,   0}, // #15974
  {31,  1,   0}, // #15975
  {32,  1,   0}, // #15976
  {33,  1,   0}, // #15977
  {36,  1,   0}, // #15978
  {37,  1,   0}, // #15979
  {42,  1,   0}, // #15980
  {44,  1,   0}, // #15981
  {14,  5,   0}, // #15982
  {19,  1,   0}, // #15983
  {28,  4,   0}, // #15984
  {30,  1,   0}, // #15985
  {33,  4,   0}, // #15986
  {36,  4,   0}, // #15987
  {37,  4,   0}, // #15988
  {42,  1,   0}, // #15989
  {43,  1,   0}, // #15990
  {14,  4,   0}, // #15991
  {28,  4,   0}, // #15992
  {33,  4,   0}, // #15993
  {36,  4,   0}, // #15994
  {37,  4,   0}, // #15995
  {14,  7,   0}, // #15996
  {16,  6,   0}, // #15997
  {19,  1,   0}, // #15998
  {20,  6,   0}, // #15999
  {21,  6,   0}, // #16000
  {24,  6,   0}, // #16001
  {25,  6,   0}, // #16002
  {27,  6,   0}, // #16003
  {28,  6,   0}, // #16004
  {29,  6,   0}, // #16005
  {30,  1,   0}, // #16006
  {33,  6,   0}, // #16007
  {34,  6,   0}, // #16008
  {35,  6,   0}, // #16009
  {36,  6,   0}, // #16010
  {37,  6,   0}, // #16011
  {39,  6,   0}, // #16012
  {40,  6,   0}, // #16013
  {42,  1,   0}, // #16014
  {43,  1,   0}, // #16015
  {14,  6,   0}, // #16016
  {16,  6,   0}, // #16017
  {20,  6,   0}, // #16018
  {21,  6,   0}, // #16019
  {24,  6,   0}, // #16020
  {25,  6,   0}, // #16021
  {27,  6,   0}, // #16022
  {28,  6,   0}, // #16023
  {29,  6,   0}, // #16024
  {33,  6,   0}, // #16025
  {34,  6,   0}, // #16026
  {35,  6,   0}, // #16027
  {36,  6,   0}, // #16028
  {37,  6,   0}, // #16029
  {39,  6,   0}, // #16030
  {40,  6,   0}, // #16031
  {14, 11,   0}, // #16032
  {16, 10,   0}, // #16033
  {19,  1,   0}, // #16034
  {20, 10,   0}, // #16035
  {21, 10,   0}, // #16036
  {24, 10,   0}, // #16037
  {25, 10,   0}, // #16038
  {27, 10,   0}, // #16039
  {28, 10,   0}, // #16040
  {29, 10,   0}, // #16041
  {30,  1,   0}, // #16042
  {33, 10,   0}, // #16043
  {34, 10,   0}, // #16044
  {35, 10,   0}, // #16045
  {36, 10,   0}, // #16046
  {37, 10,   0}, // #16047
  {39, 10,   0}, // #16048
  {40, 10,   0}, // #16049
  {42,  1,   0}, // #16050
  {43,  1,   0}, // #16051
  {14, 10,   0}, // #16052
  {16, 10,   0}, // #16053
  {20, 10,   0}, // #16054
  {21, 10,   0}, // #16055
  {24, 10,   0}, // #16056
  {25, 10,   0}, // #16057
  {27, 10,   0}, // #16058
  {28, 10,   0}, // #16059
  {29, 10,   0}, // #16060
  {33, 10,   0}, // #16061
  {34, 10,   0}, // #16062
  {35, 10,   0}, // #16063
  {36, 10,   0}, // #16064
  {37, 10,   0}, // #16065
  {39, 10,   0}, // #16066
  {40, 10,   0}, // #16067
  {19,  6,   0}, // #16068
  {32,  6,   0}, // #16069
  {42,  1,   0}, // #16070
  {44,  1,   0}, // #16071
  {19,  4,   0}, // #16072
  {32,  4,   0}, // #16073
  {42,  1,   0}, // #16074
  {44,  1,   0}, // #16075
  {19, 12,   0}, // #16076
  {32, 12,   0}, // #16077
  {42,  1,   0}, // #16078
  {44,  1,   0}, // #16079
  {14,  4,   0}, // #16080
  {15,  3,   0}, // #16081
  {19,  1,   0}, // #16082
  {20,  3,   0}, // #16083
  {21,  3,   0}, // #16084
  {24,  3,   0}, // #16085
  {28,  3,   0}, // #16086
  {29,  3,   0}, // #16087
  {30,  1,   0}, // #16088
  {33,  3,   0}, // #16089
  {34,  3,   0}, // #16090
  {36,  3,   0}, // #16091
  {37,  3,   0}, // #16092
  {38,  3,   0}, // #16093
  {42,  1,   0}, // #16094
  {43,  1,   0}, // #16095
  {14,  3,   0}, // #16096
  {15,  3,   0}, // #16097
  {20,  3,   0}, // #16098
  {21,  3,   0}, // #16099
  {24,  3,   0}, // #16100
  {28,  3,   0}, // #16101
  {29,  3,   0}, // #16102
  {33,  3,   0}, // #16103
  {34,  3,   0}, // #16104
  {36,  3,   0}, // #16105
  {37,  3,   0}, // #16106
  {38,  3,   0}, // #16107
  {14,  4,   0}, // #16108
  {19,  1,   0}, // #16109
  {25,  3,   0}, // #16110
  {27,  3,   0}, // #16111
  {28,  3,   0}, // #16112
  {30,  1,   0}, // #16113
  {33,  3,   0}, // #16114
  {35,  3,   0}, // #16115
  {36,  3,   0}, // #16116
  {37,  3,   0}, // #16117
  {39,  3,   0}, // #16118
  {40,  3,   0}, // #16119
  {42,  1,   0}, // #16120
  {43,  1,   0}, // #16121
  {14,  3,   0}, // #16122
  {25,  3,   0}, // #16123
  {27,  3,   0}, // #16124
  {28,  3,   0}, // #16125
  {33,  3,   0}, // #16126
  {35,  3,   0}, // #16127
  {36,  3,   0}, // #16128
  {37,  3,   0}, // #16129
  {39,  3,   0}, // #16130
  {40,  3,   0}, // #16131
  {14,  3,   0}, // #16132
  {16,  2,   0}, // #16133
  {19,  1,   0}, // #16134
  {20,  2,   0}, // #16135
  {21,  2,   0}, // #16136
  {24,  2,   0}, // #16137
  {25,  2,   0}, // #16138
  {27,  2,   0}, // #16139
  {28,  2,   0}, // #16140
  {29,  2,   0}, // #16141
  {30,  1,   0}, // #16142
  {33,  2,   0}, // #16143
  {34,  2,   0}, // #16144
  {35,  2,   0}, // #16145
  {36,  2,   0}, // #16146
  {37,  2,   0}, // #16147
  {39,  2,   0}, // #16148
  {40,  2,   0}, // #16149
  {42,  1,   0}, // #16150
  {43,  1,   0}, // #16151
  {14,  2,   0}, // #16152
  {16,  2,   0}, // #16153
  {20,  2,   0}, // #16154
  {21,  2,   0}, // #16155
  {24,  2,   0}, // #16156
  {25,  2,   0}, // #16157
  {27,  2,   0}, // #16158
  {28,  2,   0}, // #16159
  {29,  2,   0}, // #16160
  {33,  2,   0}, // #16161
  {34,  2,   0}, // #16162
  {35,  2,   0}, // #16163
  {36,  2,   0}, // #16164
  {37,  2,   0}, // #16165
  {39,  2,   0}, // #16166
  {40,  2,   0}, // #16167
  {14, 19,   0}, // #16168
  {16, 18,   0}, // #16169
  {19,  1,   0}, // #16170
  {20, 18,   0}, // #16171
  {21, 18,   0}, // #16172
  {24, 18,   0}, // #16173
  {25, 18,   0}, // #16174
  {27, 18,   0}, // #16175
  {28, 18,   0}, // #16176
  {29, 18,   0}, // #16177
  {30,  1,   0}, // #16178
  {33, 18,   0}, // #16179
  {34, 18,   0}, // #16180
  {35, 18,   0}, // #16181
  {36, 18,   0}, // #16182
  {37, 18,   0}, // #16183
  {39, 18,   0}, // #16184
  {40, 18,   0}, // #16185
  {42,  1,   0}, // #16186
  {43,  1,   0}, // #16187
  {14, 18,   0}, // #16188
  {16, 18,   0}, // #16189
  {20, 18,   0}, // #16190
  {21, 18,   0}, // #16191
  {24, 18,   0}, // #16192
  {25, 18,   0}, // #16193
  {27, 18,   0}, // #16194
  {28, 18,   0}, // #16195
  {29, 18,   0}, // #16196
  {33, 18,   0}, // #16197
  {34, 18,   0}, // #16198
  {35, 18,   0}, // #16199
  {36, 18,   0}, // #16200
  {37, 18,   0}, // #16201
  {39, 18,   0}, // #16202
  {40, 18,   0}, // #16203
  {42, 30,   0}, // #16204
  { 4,  1,   0}, // #16205
  {11,  2,   0}, // #16206
  {41,  3,   0}, // #16207
  {42,  1,   0}, // #16208
  {43,  1,   0}, // #16209
  { 4,  3,   0}, // #16210
  {41,  3,   0}, // #16211
  {42,  1,   0}, // #16212
  {43,  1,   0}, // #16213
  { 4,  1,   0}, // #16214
  {11, 12,   0}, // #16215
  {41, 13,   0}, // #16216
  {42,  1,   0}, // #16217
  {43,  1,   0}, // #16218
  {11, 24,   0}, // #16219
  {41, 24,   0}, // #16220
  {11, 59,   0}, // #16221
  {41, 59,   0}, // #16222
  {10,  6,   0}, // #16223
  {11,  6,   0}, // #16224
  {41,  6,   0}, // #16225
  {10,  8,   0}, // #16226
  {11,  8,   0}, // #16227
  {41,  8,   0}, // #16228
  { 4,  1,   0}, // #16229
  {14,  1,   0}, // #16230
  {15,  1,   0}, // #16231
  {20,  1,   0}, // #16232
  {21,  1,   0}, // #16233
  {24,  1,   0}, // #16234
  {28,  1,   0}, // #16235
  {29,  1,   0}, // #16236
  {33,  1,   0}, // #16237
  {34,  1,   0}, // #16238
  {36,  1,   0}, // #16239
  {37,  1,   0}, // #16240
  {38,  1,   0}, // #16241
  {41,  1,   0}, // #16242
  {42,  1,   0}, // #16243
  {43,  1,   0}, // #16244
  { 4,  1,   0}, // #16245
  {14, 24,   0}, // #16246
  {28, 24,   0}, // #16247
  {33, 24,   0}, // #16248
  {36, 24,   0}, // #16249
  {37, 24,   0}, // #16250
  {41,  1,   0}, // #16251
  {42,  1,   0}, // #16252
  {43,  1,   0}, // #16253
  { 4,  1,   0}, // #16254
  {14, 62,   0}, // #16255
  {28, 62,   0}, // #16256
  {33, 62,   0}, // #16257
  {36, 62,   0}, // #16258
  {37, 62,   0}, // #16259
  {41,  1,   0}, // #16260
  {42,  1,   0}, // #16261
  {43,  1,   0}, // #16262
  { 4,  1,   0}, // #16263
  {11,  4,   0}, // #16264
  {41,  5,   0}, // #16265
  {42,  1,   0}, // #16266
  {44,  1,   0}, // #16267
  { 4,  1,   0}, // #16268
  {14,  1,   0}, // #16269
  {16,  1,   0}, // #16270
  {20,  1,   0}, // #16271
  {21,  1,   0}, // #16272
  {24,  1,   0}, // #16273
  {25,  1,   0}, // #16274
  {27,  1,   0}, // #16275
  {28,  1,   0}, // #16276
  {29,  1,   0}, // #16277
  {33,  1,   0}, // #16278
  {34,  1,   0}, // #16279
  {35,  1,   0}, // #16280
  {36,  1,   0}, // #16281
  {37,  1,   0}, // #16282
  {39,  1,   0}, // #16283
  {40,  1,   0}, // #16284
  {41,  1,   0}, // #16285
  {42,  1,   0}, // #16286
  {43,  1,   0}, // #16287
  {14,  1,   0}, // #16288
  {15,  1,   0}, // #16289
  {19,  1,   0}, // #16290
  {20,  1,   0}, // #16291
  {21,  1,   0}, // #16292
  {24,  1,   0}, // #16293
  {28,  1,   0}, // #16294
  {29,  1,   0}, // #16295
  {32,  1,   0}, // #16296
  {33,  1,   0}, // #16297
  {34,  1,   0}, // #16298
  {36,  1,   0}, // #16299
  {37,  1,   0}, // #16300
  {38,  1,   0}, // #16301
  {42,  1,   0}, // #16302
  {44,  1,   0}, // #16303
  { 4,  1,   0}, // #16304
  {14,  8,   0}, // #16305
  {28,  8,   0}, // #16306
  {33,  8,   0}, // #16307
  {36,  8,   0}, // #16308
  {37,  8,   0}, // #16309
  {41,  1,   0}, // #16310
  {42,  1,   0}, // #16311
  {43,  1,   0}, // #16312
  {14,  3,   0}, // #16313
  {28,  3,   0}, // #16314
  {33,  3,   0}, // #16315
  {36,  3,   0}, // #16316
  {37,  3,   0}, // #16317
  { 4,  1,   0}, // #16318
  {14,  3,   0}, // #16319
  {28,  3,   0}, // #16320
  {33,  3,   0}, // #16321
  {36,  3,   0}, // #16322
  {37,  3,   0}, // #16323
  {41,  1,   0}, // #16324
  {42,  1,   0}, // #16325
  {43,  1,   0}, // #16326
  { 4,  1,   0}, // #16327
  {14,  2,   0}, // #16328
  {28,  2,   0}, // #16329
  {33,  2,   0}, // #16330
  {36,  2,   0}, // #16331
  {37,  2,   0}, // #16332
  {41,  1,   0}, // #16333
  {42,  1,   0}, // #16334
  {43,  1,   0}, // #16335
  { 4,  1,   0}, // #16336
  {11,  7,   0}, // #16337
  {41,  8,   0}, // #16338
  {42,  2,   0}, // #16339
  {43,  1,   0}, // #16340
  {44,  1,   0}, // #16341
  { 4,  1,   0}, // #16342
  {10,  8,   0}, // #16343
  {11,  8,   0}, // #16344
  {41,  9,   0}, // #16345
  {42,  1,   0}, // #16346
  {43,  1,   0}, // #16347
  { 4,  1,   0}, // #16348
  {14,  2,   0}, // #16349
  {16,  2,   0}, // #16350
  {20,  2,   0}, // #16351
  {21,  2,   0}, // #16352
  {24,  2,   0}, // #16353
  {25,  2,   0}, // #16354
  {27,  2,   0}, // #16355
  {28,  2,   0}, // #16356
  {29,  2,   0}, // #16357
  {33,  2,   0}, // #16358
  {34,  2,   0}, // #16359
  {35,  2,   0}, // #16360
  {36,  2,   0}, // #16361
  {37,  2,   0}, // #16362
  {39,  2,   0}, // #16363
  {40,  2,   0}, // #16364
  {41,  1,   0}, // #16365
  {42,  1,   0}, // #16366
  {43,  1,   0}, // #16367
  {14,  1,   0}, // #16368
  {30,  1,   0}, // #16369
  {14,  6,   0}, // #16370
  {22,  6,   0}, // #16371
  {23,  6,   0}, // #16372
  {26,  6,   0}, // #16373
  {27,  6,   0}, // #16374
  {28,  6,   0}, // #16375
  {31,  6,   0}, // #16376
  {33,  6,   0}, // #16377
  {36,  6,   0}, // #16378
  {37,  6,   0}, // #16379
  {14,  3,   0}, // #16380
  {20,  3,   0}, // #16381
  {21,  3,   0}, // #16382
  {24,  3,   0}, // #16383
  {28,  3,   0}, // #16384
  {29,  3,   0}, // #16385
  {33,  3,   0}, // #16386
  {34,  3,   0}, // #16387
  {36,  3,   0}, // #16388
  {37,  3,   0}, // #16389
  {14,  5,   0}, // #16390
  {20,  5,   0}, // #16391
  {21,  5,   0}, // #16392
  {24,  5,   0}, // #16393
  {28,  5,   0}, // #16394
  {29,  5,   0}, // #16395
  {33,  5,   0}, // #16396
  {34,  5,   0}, // #16397
  {36,  5,   0}, // #16398
  {37,  5,   0}, // #16399
  {14,  6,   0}, // #16400
  {20,  2,   0}, // #16401
  {21,  2,   0}, // #16402
  {22,  2,   0}, // #16403
  {23,  2,   0}, // #16404
  {24,  2,   0}, // #16405
  {25,  2,   0}, // #16406
  {26,  2,   0}, // #16407
  {27,  4,   0}, // #16408
  {28,  6,   0}, // #16409
  {29,  2,   0}, // #16410
  {31,  2,   0}, // #16411
  {33,  6,   0}, // #16412
  {34,  2,   0}, // #16413
  {35,  2,   0}, // #16414
  {36,  6,   0}, // #16415
  {37,  6,   0}, // #16416
  {39,  2,   0}, // #16417
  {40,  2,   0}, // #16418
  {14,  2,   0}, // #16419
  {27,  2,   0}, // #16420
  {28,  2,   0}, // #16421
  {33,  2,   0}, // #16422
  {36,  2,   0}, // #16423
  {37,  2,   0} // #16424
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteLEA_WriteRMW_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStore_WriteFLoad_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteCMOVLd_WriteLoad_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteSHDrri_WriteLAHFSAHF_WriteVecMoveToGpr_WriteVecTest_WriteSETCCStore_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBEXTR_WriteFCmp64X_WriteFCmpX_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WritePOPCNT_WriteVecShiftX_WriteFVarBlendY_WriteFCmpY_WriteFCmp64Y_WriteVecStoreNTY_WriteFStoreNTY_WriteVarBlendY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_WriteBLS_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteLZCNT_WritePHAdd_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup5_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteFVarBlendZ_WriteVarBlendZ_SPRWriteResGroup43_SPRWriteResGroup164_SPRWriteResGroup160_SPRWriteResGroup193_SPRWriteResGroup52_SPRWriteResGroup61_SPRWriteResGroup23_SPRWriteResGroup58_SPRWriteResGroup24_SPRWriteResGroup195_SPRWriteResGroup216_SPRWriteResGroup95_SPRWriteResGroup137_SPRWriteResGroup92_SPRWriteResGroup78_SPRWriteResGroup81_SPRWriteResGroup89_SPRWriteResGroup138_SPRWriteResGroup139_SPRWriteResGroup140_SPRWriteResGroup147_SPRWriteResGroup153_SPRWriteResGroup192_SPRWriteResGroup214_SPRWriteResGroup240_SPRWriteResGroup508_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_LNLPWriteResGroupX40_LNLPWriteResGroupX155_LNLPWriteResGroup16_LNLPWriteResGroupX188_LNLPWriteResGroupX189_LNLPWriteResGroupX57_LNLPWriteResGroupX21_LNLPWriteResGroupX54_LNLPWriteResGroupX22_LNLPWriteResGroupX191_LNLPWriteResGroupX6_LNLPWriteResGroupX151_LNLPWriteResGroupX212_LNLPWriteResGroupX173_LNLPWriteResGroup40_LNLPWriteResGroup46_LNLPWriteResGroupX77_LNLPWriteResGroupX85_LNLPWriteResGroupX128_LNLPWriteResGroupX129_LNLPWriteResGroupX130_LNLPWriteResGroupX137_LNLPWriteResGroupX144_LNLPWriteResGroupX187_LNLPWriteResGroupX210_LNLPWriteResGroupX235_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMX_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_Zn3WriteSFENCE_WriteBSF_WriteBSR_WriteCvtSD2I_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMX_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteSFENCE_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStore_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmpYLd_WriteFCmp64YLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMulYLd_WriteFMul64YLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup142_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrri_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteCvtPD2IYLd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_WriteMPSADLd_WriteCvtPD2PSYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMulZLd_WriteFMul64ZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteFAddYLd_WriteFAddZLd_WriteFCmpZLd_WriteCvtI2PSZLd_WriteCvtPS2PHZSt_WriteFRndZLd_WriteFCmp64ZLd_SPRWriteResGroup37_SPRWriteResGroup185_SPRWriteResGroup54_SPRWriteResGroup182_SPRWriteResGroup554_SPRWriteResGroup148_SPRWriteResGroup129_SPRWriteResGroup151_SPRWriteResGroup124_SPRWriteResGroup235_SPRWriteResGroup449_SPRWriteResGroup504_SPRWriteResGroup501_SPRWriteResGroup505_SPRWriteResGroup502_SPRWriteResGroup257_SPRWriteResGroup73_SPRWriteResGroup136_SPRWriteResGroup144_SPRWriteResGroup265_SPRWriteResGroup272_SPRWriteResGroup303_SPRWriteResGroup347_SPRWriteResGroup351_SPRWriteResGroup419_SPRWriteResGroup444_SPRWriteResGroup446_SPRWriteResGroup465_SPRWriteResGroup467_SPRWriteResGroup489_SPRWriteResGroup517_SPRWriteResGroup518_SPRWriteResGroup546_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_LNLPWriteResGroupX36_LNLPWriteResGroupX179_LNLPWriteResGroupX50_LNLPWriteResGroupX176_LNLPWriteResGroupX139_LNLPWriteResGroupX120_LNLPWriteResGroupX142_LNLPWriteResGroupX115_LNLPWriteResGroup33_LNLPWriteResGroupX127_LNLPWriteResGroupX134_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_Zn3WriteVPERMDYm_WriteFRcpZLd_WriteFRsqrtZLd_Zn4WriteVPERMYm
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup232_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLZCNTLd_WritePHAdd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteXADDm_PdWriteVBROADCASTYLd_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteSHDrrcl_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_SPRWriteResGroup104_SPRWriteResGroup5_SPRWriteResGroup103_SPRWriteResGroup163_SPRWriteResGroup243_SPRWriteResGroup57_SPRWriteResGroup239_SPRWriteResGroup32_SPRWriteResGroup213_SPRWriteResGroup120_SPRWriteResGroup237_SPRWriteResGroup230_SPRWriteResGroup234_SPRWriteResGroup494_SPRWriteResGroup150_SPRWriteResGroup162_SPRWriteResGroup251_SPRWriteResGroup253_SPRWriteResGroup365_SPRWriteResGroup437_SPRWriteResGroup438_SPRWriteResGroup443_SPRWriteResGroup520_SPRWriteResGroup538_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_WriteIMul64ImmLd_LNLPWriteResGroupX5_LNLPWriteResGroupX154_LNLPWriteResGroupX238_LNLPWriteResGroup14_LNLPWriteResGroupX53_LNLPWriteResGroupX234_LNLPWriteResGroupX30_LNLPWriteResGroupX209_LNLPWriteResGroupX224_LNLPWriteResGroupX153_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3WriteSHA1RNDS4rri_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4WriteSHA1RNDS4rri_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  { 7,  0}, // #4 WriteFLoad_WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup13_ADLPWriteResGroup41_ADLPWriteResGroup143_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteCvtSD2SSLd_WriteIMul64_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WriteFMul64X_WriteVarBlendLd_WritePHMINPOSLd_WriteFRcpLd_WriteFRsqrtLd_SLMWriteResGroup1rm_WriteFLogicLd_WriteFBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmpYLd_WriteFCmp64YLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL3264rCL_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteFHAdd_WriteFHAddY_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteVecIMulXLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteVecLoadNTY_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup59_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSZLd_WriteCvtPH2PSYLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtPD2IZ_SPRWriteResGroup121_SPRWriteResGroup161_SPRWriteResGroup82_SPRWriteResGroup62_SPRWriteResGroup565_SPRWriteResGroup212_SPRWriteResGroup246_SPRWriteResGroup20_SPRWriteResGroup199_SPRWriteResGroup115_SPRWriteResGroup149_SPRWriteResGroup464_SPRWriteResGroup39_SPRWriteResGroup268_SPRWriteResGroup0_SPRWriteResGroup15_SPRWriteResGroup44_SPRWriteResGroup152_SPRWriteResGroup415_SPRWriteResGroup93_SPRWriteResGroup271_SPRWriteResGroup470_SPRWriteResGroup486_SPRWriteResGroup488_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup92_ICXWriteResGroup96_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_WriteBSRLd_WriteBZHILd_WriteCRC32Ld_WriteFDivX_WriteIMul32RegLd_WriteIMul64RegLd_WriteLZCNTLd_WritePOPCNTLd_WriteTZCNTLd_WriteFDivY_LNLPWriteResGroupX152_LNLPWriteResGroup19_LNLPWriteResGroupX58_LNLPWriteResGroupX278_LNLPWriteResGroupX208_LNLPWriteResGroupX241_LNLPWriteResGroup36_LNLPWriteResGroupX18_LNLPWriteResGroupX52_LNLPWriteResGroupX195_LNLPWriteResGroup29_LNLPWriteResGroupX0_LNLPWriteResGroupX12_LNLPWriteResGroupX13_LNLPWriteResGroupX41_LNLPWriteResGroupX78_LNLPWriteResGroup20_LNLPWriteResGroup21_LNLPWriteResGroupX256_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteIMul16Ld_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteRotateRightMCL_WriteDPPD_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteRotateRightMCL_Zn4WriteVPERMPSYrr
  {100,  0}, // #5 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_ZnWriteMicrocoded_SPRWriteResGroup177_SPRWriteResGroup202_SPRWriteResGroup72_SPRWriteResGroup556_SPRWriteResGroup29_SPRWriteResGroup205_SPRWriteResGroup207_SPRWriteResGroup30_SPRWriteResGroup86_SPRWriteResGroup105_SPRWriteResGroup106_SPRWriteResGroup107_SPRWriteResGroup108_SPRWriteResGroup109_SPRWriteResGroup110_SPRWriteResGroup145_SPRWriteResGroup175_SPRWriteResGroup176_SPRWriteResGroup189_SPRWriteResGroup190_SPRWriteResGroup191_SPRWriteResGroup203_SPRWriteResGroup204_SPRWriteResGroup209_SPRWriteResGroup224_SPRWriteResGroup241_SPRWriteResGroup244_SPRWriteResGroup557_SPRWriteResGroup576_WriteSTMXCSR_WriteVecTestY_LNLPWriteResGroup8_LNLPWriteResGroupX68_LNLPWriteResGroupX269_LNLPWriteResGroupX27_LNLPWriteResGroup7_LNLPWriteResGroup31_LNLPWriteResGroup13_LNLPWriteResGroupX28_LNLPWriteResGroupX135_LNLPWriteResGroup15_LNLPWriteResGroupX218_LNLPWriteResGroupX236_LNLPWriteResGroupX239_LNLPWriteResGroupX270_LNLPWriteResGroup10_LNLPWriteResGroup51_LNLPWriteResGroup52_LNLPWriteResGroup53_Zn2WriteMicrocoded
  { 3,  0}, // #6 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAddY_WriteFAdd64Y_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup16_ADLPWriteResGroup119_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteFLoad_WriteFLoadX_WriteLoad_WriteXCHG_WriteFCmp64X_WriteFCmpX_WriteVecLoadX_WriteVecLoadNT_WriteFRnd_WriteFMaskedLoad_WriteVecMaskedLoad_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_ZnWriteVCVTPS2PDY_WriteFMulY_WritePHAddY_WriteVarVecShiftY_ZnWriteVPERM2r_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteRotateCL_WriteShiftCL_WriteFCmpY_WriteFCmp64Y_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteVecMOVMSKY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAddZ_WriteFAdd64Z_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteMove_WriteShuffleZ_WriteVecALUZ_WriteVarShuffleZ_SPRWriteResGroup25_SPRWriteResGroup113_SPRWriteResGroup112_SPRWriteResGroup67_SPRWriteResGroup127_SPRWriteResGroup22_SPRWriteResGroup68_SPRWriteResGroup26_SPRWriteResGroup21_SPRWriteResGroup232_SPRWriteResGroup18_SPRWriteResGroup128_SPRWriteResGroup133_SPRWriteResGroup418_SPRWriteResGroup250_SPRWriteResGroup96_SPRWriteResGroup263_SPRWriteResGroup223_SPRWriteResGroup260_SPRWriteResGroup267_SPRWriteResGroup441_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup36_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_WriteIMulHLd_LNLPWriteResGroupX23_LNLPWriteResGroupX104_LNLPWriteResGroupX63_LNLPWriteResGroupX118_LNLPWriteResGroupX20_LNLPWriteResGroupX64_LNLPWriteResGroup18_LNLPWriteResGroupX24_LNLPWriteResGroupX19_LNLPWriteResGroup30_LNLPWriteResGroup22_LNLPWriteResGroup12_LNLPWriteResGroupX124_LNLPWriteResGroupX8_LNLPWriteResGroupX16_LNLPWriteResGroupX217_LNLPWriteResGroupX245_LNLPWriteResGroup5_LNLPWriteResGroup26_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteVPERM2r_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WritePDEP_PEXT_Zn3WriteEXTRQ_INSERTQ_WriteVecIMulZ_WriteFMulZ_WriteFMul64Z_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WriteSHA256MSG2rr_Zn4WritePDEP_PEXT_Zn4WriteEXTRQ_INSERTQ_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup192_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup175_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteAESDecEnc_WriteAESKeyGen_WriteCvtI2PSLd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteIMul32Ld_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePSADBWXLd_SLMWriteResGroup2rm_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtPD2PSY_WriteCvtI2PDY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_WriteFLoadX_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteMULX32Ld_WriteMULX64Ld_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFCmpYLd_WriteFCmp64YLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteVarBlendYLd_WriteVPMOV256Ld_WriteVecShiftImmXLd_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteVPERM2m_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAddYLd_WriteFAdd64YLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleZLd_WriteFLogicZLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleZLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup12_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_SPRWriteResGroup40_SPRWriteResGroup41_SPRWriteResGroup178_SPRWriteResGroup126_SPRWriteResGroup179_SPRWriteResGroup119_SPRWriteResGroup231_SPRWriteResGroup196_SPRWriteResGroup383_SPRWriteResGroup289_SPRWriteResGroup156_SPRWriteResGroup159_SPRWriteResGroup181_SPRWriteResGroup222_SPRWriteResGroup245_SPRWriteResGroup219_SPRWriteResGroup283_SPRWriteResGroup291_SPRWriteResGroup297_SPRWriteResGroup320_SPRWriteResGroup343_SPRWriteResGroup361_SPRWriteResGroup362_SPRWriteResGroup484_SPRWriteResGroup506_SPRWriteResGroup521_SPRWriteResGroup533_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_WriteDPPD_WriteIMul64Ld_LNLPWriteResGroupX37_LNLPWriteResGroupX38_LNLPWriteResGroup4_LNLPWriteResGroup41_LNLPWriteResGroupX117_LNLPWriteResGroup47_LNLPWriteResGroupX192_LNLPWriteResGroup27_LNLPWriteResGroup44_LNLPWriteResGroup45_LNLPWriteResGroupX147_LNLPWriteResGroupX150_LNLPWriteResGroupX216_LNLPWriteResGroupX240_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteVPERM2m_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateLeftMI_Zn3WriteRotateLeftMCL_WriteFVarBlendZLd_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateLeftMI_Zn4WriteRotateLeftMCL
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAddYLd_WriteFAdd64YLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WritePMULLD_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulXLd_WriteVecIMulLd_WritePMULLDLd_WriteFRndLd_ZnWriteCVTPD2PSYLd_WriteVecIMulYLd_WriteFRndYLd_WriteFMul64YLd_WritePMULLDYLd_WriteVecTestYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_BWWriteResGroup122_1_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFMAZLd_WriteFAddZLd_WriteFAdd64ZLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64YLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMulYLd_WriteFMulZLd_WriteFMul64ZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteFAddXLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WritePSADBWZLd_WriteVarShuffleZLd_SPRWriteResGroup60_SPRWriteResGroup165_SPRWriteResGroup258_SPRWriteResGroup132_SPRWriteResGroup417_SPRWriteResGroup255_SPRWriteResGroup313_SPRWriteResGroup455_SPRWriteResGroup483_SPRWriteResGroup254_SPRWriteResGroup317_SPRWriteResGroup321_SPRWriteResGroup354_SPRWriteResGroup374_SPRWriteResGroup482_SPRWriteResGroup515_SPRWriteResGroup535_SPRWriteResGroup537_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_LNLPWriteResGroupX56_LNLPWriteResGroupX156_LNLPWriteResGroup3_LNLPWriteResGroupX123_LNLPWriteResGroup39_LNLPWriteResGroup37_WriteCvtPD2ILd_WriteCvtI2PSYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_Zn3WriteVINSERTF128rmr_Zn3WriteVEXTRACTI128mr_WriteCvtI2PDZLd_WriteCvtPH2PSZLd_WriteCvtPS2IZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVINSERTF128rmr_Zn4WriteVEXTRACTI128mr
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteIMul64Ld_WriteLDMXCSR_WriteMPSADLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAddYLd_WriteFAdd64YLd_WriteFMAXLd_WriteFMAYLd_WriteFMulYLd_WriteFMul64YLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePSADBWLd_WritePHAddXLd_WritePSADBWYLd_WriteFDivY_WriteVarVecShiftLd_WriteVarVecShiftYLd_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteCvtPH2PSYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAddZLd_WriteFAdd64ZLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64YLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_SPRWriteResGroup10_SPRWriteResGroup485_SPRWriteResGroup389_SPRWriteResGroup17_SPRWriteResGroup8_SPRWriteResGroup259_SPRWriteResGroup264_SPRWriteResGroup284_SPRWriteResGroup290_SPRWriteResGroup292_SPRWriteResGroup298_SPRWriteResGroup334_SPRWriteResGroup344_SPRWriteResGroup350_SPRWriteResGroup358_SPRWriteResGroup410_SPRWriteResGroup413_SPRWriteResGroup431_SPRWriteResGroup432_SPRWriteResGroup479_SPRWriteResGroup511_SPRWriteResGroup513_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteVecTestLd_WriteFSqrtX_WriteFDiv64Y_WriteFSqrtY_LNLPWriteResGroupX9_LNLPWriteResGroup43_LNLPWriteResGroupX15_LNLPWriteResGroup48_LNLPWriteResGroup0_LNLPWriteResGroup38_LNLPWriteResGroup50_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup140_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteDiv8_WriteIDiv8_WriteVecIMulYLd_WriteCvtPH2PSLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_WriteVecIMulZLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteFMulZLd_WriteFMul64ZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERM2F128rm_Zn4WriteSHA256MSG2rm
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteRMW_WriteCMOVLd_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_WriteJumpLd_WriteFLoad_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAddY_WriteFAdd64Y_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMulY_WriteFMul64Y_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteBEXTRLd_WriteVecExtractSt_WriteStore_WritePOPCNTLd_ZnWriteCVTPD2PSYr_WriteCvtI2PDY_WriteCvtI2PSY_WriteCvtPD2IY_WriteCvtPS2IY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMulZ_WriteFMul64Z_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_SPRWriteResGroup186_SPRWriteResGroup111_SPRWriteResGroup247_SPRWriteResGroup575_SPRWriteResGroup187_SPRWriteResGroup236_SPRWriteResGroup367_SPRWriteResGroup340_SPRWriteResGroup31_SPRWriteResGroup74_SPRWriteResGroup135_SPRWriteResGroup142_SPRWriteResGroup414_SPRWriteResGroup252_SPRWriteResGroup463_SPRWriteResGroup469_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_WriteVecInsert_WriteCvtPS2PHYSt_LNLPWriteResGroup11_LNLPWriteResGroupX180_LNLPWriteResGroupX181_LNLPWriteResGroupX242_LNLPWriteResGroupX288_LNLPWriteResGroupX182_LNLPWriteResGroup34_LNLPWriteResGroupX29_LNLPWriteResGroupX126_LNLPWriteResGroupX132_LNLPWriteResGroupX254_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDPPDLd_WriteDPPS_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WriteDiv8_WriteIDiv8_WriteFDiv64Y_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteCvtPD2PSZLd_SPRWriteResGroup47_SPRWriteResGroup299_SPRWriteResGroup266_SPRWriteResGroup498_SPRWriteResGroup500_SPRWriteResGroup473_SPRWriteResGroup300_SPRWriteResGroup218_SPRWriteResGroup269_SPRWriteResGroup281_SPRWriteResGroup304_SPRWriteResGroup311_SPRWriteResGroup328_SPRWriteResGroup341_SPRWriteResGroup382_SPRWriteResGroup393_SPRWriteResGroup397_SPRWriteResGroup408_SPRWriteResGroup411_SPRWriteResGroup475_SPRWriteResGroup493_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_WritePCmpIStrMLd_WriteFSqrt64X_WriteFSqrt64Y_LNLPWriteResGroupX44_SKLWriteResGroup174_SKLWriteResGroup171_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup219_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup14_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteCMOV_WriteVecALU_WriteFStore_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmpY_WriteFCmp64Y_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteFSign_WriteVecExtract_WriteVecMoveToGpr_WriteVecTest_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_WriteVecMOVMSKY_WriteFTest_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteRMW_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteMMXMOVMSK_WriteFMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup41_SKXWriteResGroup13_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SPRWriteResGroup248_SPRWriteResGroup555_SPRWriteResGroup88_SPRWriteResGroup66_SPRWriteResGroup114_SPRWriteResGroup59_SPRWriteResGroup42_SPRWriteResGroup28_SPRWriteResGroup102_SPRWriteResGroup228_SPRWriteResGroup225_SPRWriteResGroup184_SPRWriteResGroup13_SPRWriteResGroup16_SPRWriteResGroup27_SPRWriteResGroup491_SPRWriteResGroup509_SPRWriteResGroup514_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup53_ICXWriteResGroup20_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup13_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_WriteFAdd_WriteIMul32Imm_WriteIMul64Imm_LNLPWriteResGroupX243_LNLPWriteResGroupX268_LNLPWriteResGroupX62_LNLPWriteResGroupX105_LNLPWriteResGroupX55_LNLPWriteResGroupX39_LNLPWriteResGroup32_LNLPWriteResGroupX93_LNLPWriteResGroup28_LNLPWriteResGroupX219_LNLPWriteResGroup24_LNLPWriteResGroupX11_LNLPWriteResGroupX14_LNLPWriteResGroupX25_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteResGroup39_SKLWriteResGroup13_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4WriteSHA256MSG1rr_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGNR_Zn4WriteALIGNRZ_Zn4WritePACK_Zn4WritePACKZ_Zn4WriteFCmp64_Zn4MOVDUPZ_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteDPPSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_WriteCvtPS2IZLd_WritePMULLDZLd_SPRWriteResGroup36_SPRWriteResGroup210_SPRWriteResGroup125_SPRWriteResGroup286_SPRWriteResGroup288_SPRWriteResGroup294_SPRWriteResGroup296_SPRWriteResGroup312_SPRWriteResGroup318_SPRWriteResGroup319_SPRWriteResGroup329_SPRWriteResGroup335_SPRWriteResGroup345_SPRWriteResGroup348_SPRWriteResGroup352_SPRWriteResGroup356_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_LNLPWriteResGroupX34_LNLPWriteResGroupX206_LNLPWriteResGroupX116_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmpY_WriteFCmp64Y_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMulY_WriteFMul64Y_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteJumpLd_WriteADCLd_WriteALULd_WriteFAdd64X_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecExtractSt_WriteVecALUXLd_WriteIMul16Reg_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteStore_WriteVecTestLd_WriteShiftLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_WriteBSR_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteVPERM2F128rr_PdWriteMOVQ2DQrr_PdWriteVPMACS_WriteAESDecEnc_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WritePMULLD_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_WriteVecTestY_WriteFTestY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteBEXTRLd_WriteBSF_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WritePOPCNTLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFAddX_WriteFAddY_WriteFAddZ_WriteFAdd64Y_WriteFAdd64Z_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMulZ_WriteFMul64Z_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFRndZ_SPRWriteResGroup87_SPRWriteResGroup64_SPRWriteResGroup55_SPRWriteResGroup194_SPRWriteResGroup564_SPRWriteResGroup130_SPRWriteResGroup167_SPRWriteResGroup91_SPRWriteResGroup314_SPRWriteResGroup516_SPRWriteResGroup519_SPRWriteResGroup220_SPRWriteResGroup456_SPRWriteResGroup249_SPRWriteResGroup256_SPRWriteResGroup481_SPRWriteResGroup492_SPRWriteResGroup522_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup41_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_LNLPWriteResGroupX60_LNLPWriteResGroupX51_LNLPWriteResGroupX190_LNLPWriteResGroupX277_LNLPWriteResGroupX121_LNLPWriteResGroupX158_LNLPWriteResGroupX214_LNLPWriteResGroup42_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPH2PSZ_WriteCvtPS2IZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WritePCmpEStrMLd_WritePCmpIStrILd_WriteDPPDLd_WriteFDiv64Ld_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_SPRWriteResGroup168_SPRWriteResGroup85_SPRWriteResGroup51_SPRWriteResGroup495_SPRWriteResGroup457_SPRWriteResGroup83_SPRWriteResGroup84_SPRWriteResGroup346_SPRWriteResGroup349_SPRWriteResGroup357_SPRWriteResGroup525_SPRWriteResGroup529_SPRWriteResGroup540_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_LNLPWriteResGroupX48_LNLPWriteResGroupX45_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_WriteCvtPH2PSZLd_SPRWriteResGroup478_SPRWriteResGroup461_SPRWriteResGroup285_SPRWriteResGroup287_SPRWriteResGroup293_SPRWriteResGroup295_SPRWriteResGroup308_SPRWriteResGroup324_SPRWriteResGroup336_SPRWriteResGroup337_SPRWriteResGroup338_SPRWriteResGroup339_SPRWriteResGroup364_SPRWriteResGroup384_SPRWriteResGroup390_SPRWriteResGroup394_SPRWriteResGroup471_SPRWriteResGroup523_SPRWriteResGroup528_SPRWriteResGroup532_ICXWriteResGroup199_WriteFDiv64XLd_WriteFDiv64Ld_WriteStore_LNLPWriteResGroupX267_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteDiv8Ld_WriteIDiv8Ld_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SPRWriteResGroup503_SPRWriteResGroup48_SPRWriteResGroup270_SPRWriteResGroup301_SPRWriteResGroup325_SPRWriteResGroup553_ICXWriteGatherEVEX4
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WriteFSqrtLd_WritePCmpEStrILd_WriteFSqrt80_WriteFDivYLd_WriteFDiv64Y_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_SPRWriteResGroup497_SPRWriteResGroup499_SPRWriteResGroup459_SPRWriteResGroup309_SPRWriteResGroup322_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_WriteFDivLd_WriteFDiv64YLd_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_SPRWriteResGroup49_SPRWriteResGroup302_SPRWriteResGroup326_SPRWriteResGroup526_SPRWriteResGroup530_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64YLd_LNLPWriteResGroupX46_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WritePCmpIStrI_WriteCLMulLd_WriteDiv16_WriteFDivXLd_WriteFDivLd_WriteIDiv16_WriteFDivYLd_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_SPRWriteResGroup563_SPRWriteResGroup451_SPRWriteResGroup448_SPRWriteResGroup19_SPRWriteResGroup273_SPRWriteResGroup277_SPRWriteResGroup282_SPRWriteResGroup316_SPRWriteResGroup333_SPRWriteResGroup342_SPRWriteResGroup379_SPRWriteResGroup460_SPRWriteResGroup474_SPRWriteResGroup476_SPRWriteResGroup534_SPRWriteResGroup536_ICXWriteResGroup202_ICXWriteGatherEVEX2_WriteFDiv64YLd_WriteFSqrtYLd_LNLPWriteResGroupX276_LNLPWriteResGroupX17_SKLWriteResGroup180_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WritePMULLDLd_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDivYLd_WriteFDiv64YLd_WriteFSqrtYLd_WriteFSqrt64YLd_WriteFHAddLd_WriteFHAddYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup141_BWWriteResGroup144_BWWriteResGroup145_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup187_SKXWriteResGroup190_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_SPRWriteResGroup166_SPRWriteResGroup496_SPRWriteResGroup276_SPRWriteResGroup280_SPRWriteResGroup315_SPRWriteResGroup331_SPRWriteResGroup355_SPRWriteResGroup363_SPRWriteResGroup381_SPRWriteResGroup445_SPRWriteResGroup447_SPRWriteResGroup466_SPRWriteResGroup468_SPRWriteResGroup487_ICXWriteResGroup187_ICXWriteResGroup190_ICXWriteResGroup188_ICXWriteResGroup189_LNLPWriteResGroupX157_SKLWriteResGroup169_SKLWriteResGroup170_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld_Zn3WriteVPERMPSYrm_Zn4WriteVPERMPSYrm
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup197_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WritePHAddLd_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDivY_WriteFDiv64Y_WriteFRndYLd_WriteFSqrtY_WriteFSqrt64Y_PdWriteX87Div_PdWriteRCR16rCL_ZnWriteMul64Ld_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteFVarShuffle256Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAddYLd_WriteFAdd64YLd_WriteFCmpYLd_WriteFCmp64YLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFMul64YLd_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup80_HWWriteResGroup87_WriteShuffleZLd_WriteFLogicZLd_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVecShiftZLd_SPRWriteResGroup123_SPRWriteResGroup131_SPRWriteResGroup262_SPRWriteResGroup134_SPRWriteResGroup201_SPRWriteResGroup227_SPRWriteResGroup183_SPRWriteResGroup472_SPRWriteResGroup477_SPRWriteResGroup261_SPRWriteResGroup442_SPRWriteResGroup275_SPRWriteResGroup279_SPRWriteResGroup330_SPRWriteResGroup366_SPRWriteResGroup392_SPRWriteResGroup396_SPRWriteResGroup409_SPRWriteResGroup412_SPRWriteResGroup507_SPRWriteResGroup510_SPRWriteResGroup512_SPRWriteResGroup524_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteFComXLd_WriteFMulXLd_LNLPWriteResGroup2_LNLPWriteResGroupX122_LNLPWriteResGroup17_LNLPWriteResGroupX197_LNLPWriteResGroup35_LNLPWriteResGroup23_LNLPWriteResGroup49_LNLPWriteResGroupX125_LNLPWriteResGroupX244_LNLPWriteResGroupX264_LNLPWriteResGroup25_WriteCvtPS2PDLd_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1MSG1rm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4Writerm_SHA256MSG1rm_Zn4WriteSHA1MSG1rm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WritePCmpEStrI_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WriteFSqrt64YLd_SPRWriteResGroup226_SPRWriteResGroup274_SPRWriteResGroup278_SPRWriteResGroup305_SPRWriteResGroup353_SPRWriteResGroup380_SPRWriteResGroup391_SPRWriteResGroup395_ICXWriteResGroup205_ICXWriteGatherEVEX8_LNLPWriteResGroupX220_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup231_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_AtomWrite01_13_WriteBSFLd_WriteBSRLd_WriteCLMulLd_WritePCmpIStrM_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtPD2PSYLd_WriteCvtI2PDYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteCvtPS2PHZSt_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteVecIMulZLd_WriteCvtPS2PDZLd_SPRWriteResGroup122_SPRWriteResGroup35_SPRWriteResGroup11_SPRWriteResGroup229_SPRWriteResGroup233_SPRWriteResGroup4_SPRWriteResGroup480_SPRWriteResGroup332_SPRWriteResGroup458_SPRWriteResGroup7_SPRWriteResGroup94_SPRWriteResGroup238_SPRWriteResGroup307_SPRWriteResGroup359_SPRWriteResGroup360_SPRWriteResGroup462_SPRWriteResGroup490_SPRWriteResGroup527_SPRWriteResGroup531_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_WriteFDivXLd_WriteFDivLd_WriteDPPDLd_LNLPWriteResGroup9_LNLPWriteResGroupX33_LNLPWriteResGroupX10_LNLPWriteResGroupX223_LNLPWriteResGroup6_LNLPWriteResGroupX7_LNLPWriteResGroupX138_LNLPWriteResGroupX233_SKLWriteResGroup162_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_Zn3WriteVPERMPDYmi_WriteCvtPD2PSZLd_WriteFDiv64Z_Zn4WriteVPERMPDYmi
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145_SPRWriteResGroup154
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148_SPRWriteResGroup157_LNLPWriteResGroupX148
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149_SPRWriteResGroup158_LNLPWriteResGroupX149
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165_WriteFSqrt64ZLd_SPRWriteResGroup370_SPRWriteResGroup543
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271_SPRWriteResGroup215_SPRWriteResGroup558_LNLPWriteResGroupX211_LNLPWriteResGroupX271
  { 1,  0}, // #34 WriteRMW_WriteShift
  {12,  0}, // #35 WriteRotateLd_WriteShiftCLLd
  { 2,  0}, // #36 WriteRotate_WriteShiftCL
  {19,  0}, // #37 WriteRotateCLLd
  { 1,  0}, // #38 WriteRMW
  {19,  0}, // #39 WriteRotateCLLd
  { 2,  0}, // #40 WriteRotateCL
  {24,  0}, // #41 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrILd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162_SPRWriteResGroup118_SPRWriteResGroup450_SPRWriteResGroup242_SPRWriteResGroup306_LNLPWriteResGroupX237
  { 5,  0}, // #42 WriteLoad
  { 5,  0}, // #43 WriteVecMaskedGatherWriteback
  {507,  0}, // #44 WriteVecStoreNTY
  {542,  0}, // #45 WriteFStoreNTY
  {25,  0}, // #46 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDPPS_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteFDiv64Ld_SPRWriteResGroup34_SPRWriteResGroup50_SPRWriteResGroup454_SPRWriteResGroup327_SPRWriteResGroup539_ICXWriteResGroup233_ICXWriteGatherEVEX16_LNLPWriteResGroupX32_LNLPWriteResGroupX47_SKLWriteResGroup202
  {11,  0}, // #47 WriteALULd
  { 1,  0}, // #48 WriteRMW
  {39,  0}, // #49 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFDivX_WriteFSqrt64ZLd_SPRWriteResGroup561_SPRWriteResGroup560_SPRWriteResGroup373_SPRWriteResGroup542_LNLPWriteResGroupX274_LNLPWriteResGroupX273
  { 1,  0}, // #50 WriteRMW
  {32,  0}, // #51 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z_SPRWriteResGroup33_LNLPWriteResGroupX31
  {42,  0}, // #52 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_WriteFDivXLd_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_SPRWriteResGroup211_SPRWriteResGroup567_SPRWriteResGroup572_SPRWriteResGroup574_SPRWriteResGroup569_SPRWriteResGroup570_SPRWriteResGroup571_SPRWriteResGroup573_SPRWriteResGroup548_ICXWriteResGroup254_ICXWriteResGroup255_LNLPWriteResGroupX280_LNLPWriteResGroupX287_LNLPWriteResGroupX282_LNLPWriteResGroupX283_LNLPWriteResGroupX286_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #53 ADLPWriteResGroup49_SPRWriteResGroup53_LNLPWriteResGroupX49
  {75,  0}, // #54 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SPRWriteResGroup65_ICXWriteResGroup263_LNLPWriteResGroupX61_SKLWriteResGroup220
  {35,  0}, // #55 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteFSqrt64_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SPRWriteResGroup174_SPRWriteResGroup173_SPRWriteResGroup79_SPRWriteResGroup80_SPRWriteResGroup75_SPRWriteResGroup76_SPRWriteResGroup77_SPRWriteResGroup169_SPRWriteResGroup170_SPRWriteResGroup171_SPRWriteResGroup172_SPRWriteResGroup545_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #56 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SPRWriteResGroup70_SPRWriteResGroup71_SPRWriteResGroup117_ICXWriteResGroup260_ICXWriteResGroup259_LNLPWriteResGroupX66_LNLPWriteResGroupX67_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #57 ADLPWriteResGroup248_ADLPWriteResGroup246_SPRWriteResGroup387_SPRWriteResGroup385
  {13,  0}, // #58 ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup213_ADLPWriteResGroup215_SPRWriteResGroup559_SPRWriteResGroup197_SPRWriteResGroup217_SPRWriteResGroup221_LNLPWriteResGroupX272_LNLPWriteResGroupX193_LNLPWriteResGroupX213_LNLPWriteResGroupX215
  { 1,  0}, // #59 WriteRMW
  {65,  0}, // #60 ADLPWriteResGroup90_SPRWriteResGroup100
  {70,  0}, // #61 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd_SPRWriteResGroup116
  {37,  0}, // #62 ADLPWriteResGroup279_WriteFDiv64Ld_SKXWriteResGroup250_SKXWriteResGroup249_SPRWriteResGroup566_SPRWriteResGroup372_ICXWriteResGroup250_ICXWriteResGroup249_LNLPWriteResGroupX279_SKLWriteResGroup211
  {27,  0}, // #63 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrtYLd_WriteFSqrtZLd_SKXWriteResGroup239_HWWriteFPREM1_HWWriteResGroup155_SPRWriteResGroup45_SPRWriteResGroup433_SPRWriteResGroup434_ICXWriteResGroup239_LNLPWriteResGroupX42_SKLWriteResGroup206
  {30,  0}, // #64 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SPRWriteResGroup46_SPRWriteResGroup440_ICXWriteResGroup243_LNLPWriteResGroupX43_SKLWriteResGroup208
  {41,  0}, // #65 ADLPWriteResGroup281_WriteFSqrtX_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_SPRWriteResGroup568_SPRWriteResGroup377_SPRWriteResGroup544_ICXWriteResGroup253_LNLPWriteResGroupX281_SKLWriteResGroup213
  {46,  0}, // #66 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_LNLPWriteResGroupX285_LNLPWriteResGroupX284_SKLWriteResGroup216
  {40,  0}, // #67 ADLPWriteResGroup257_WriteFSqrt80_SKXWriteResGroup252_SPRWriteResGroup416_SPRWriteResGroup435_SPRWriteResGroup436_SPRWriteResGroup547_ICXWriteResGroup252_LNLPWriteResGroupX257_SKLWriteResGroup212
  {62,  0}, // #68 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SPRWriteResGroup63_ICXWriteResGroup258_LNLPWriteResGroupX59_SKLWriteResGroup217
  {106,  0}, // #69 ADLPWriteResGroup65_SKXWriteResGroup266_SPRWriteResGroup69_ICXWriteResGroup266_LNLPWriteResGroupX65_SKLWriteResGroup223
  {20,  0}, // #70 ADLPWriteResGroup251_SPRWriteResGroup402_SPRWriteResGroup399_LNLPWriteResGroupX251
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {29,  0}, // #72 ADLPWriteResGroup250_AtomWrite01_29_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_SPRWriteResGroup398_SPRWriteResGroup405_SPRWriteResGroup439_ICXWriteResGroup242_LNLPWriteResGroupX250
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {28,  0}, // #74 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_SPRWriteResGroup407_SPRWriteResGroup400_SPRWriteResGroup401_LNLPWriteResGroupX253_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #75 WriteVecMaskedGatherWriteback
  {30,  0}, // #76 ADLPWriteResGroup252_SPRWriteResGroup403_SPRWriteResGroup406_LNLPWriteResGroupX252
  { 5,  0}, // #77 WriteVecMaskedGatherWriteback
  {40,  0}, // #78 ADLPWriteResGroup275_SPRWriteResGroup562_LNLPWriteResGroupX275
  { 1,  0}, // #79 WriteRMW
  {26,  0}, // #80 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd_SPRWriteResGroup38_SPRWriteResGroup310_SPRWriteResGroup323_SPRWriteResGroup453
  {198,  0}, // #81 ADLPWriteResGroup87_SPRWriteResGroup97
  {66,  0}, // #82 ADLPWriteResGroup88_SPRWriteResGroup98
  {71,  0}, // #83 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_SPRWriteResGroup99_SPRWriteResGroup101
  {217,  0}, // #84 ADLPWriteResGroup133_SPRWriteResGroup143
  {181,  0}, // #85 ADLPWriteResGroup136_SPRWriteResGroup146
  {514,  0}, // #86 ADLPWriteResGroup146_SPRWriteResGroup155
  {20,  0}, // #87 ADLPWriteResGroup194_ADLPWriteResGroup196_SPRWriteResGroup198_SPRWriteResGroup200_LNLPWriteResGroupX194_LNLPWriteResGroupX196
  { 1,  0}, // #88 WriteRMW
  {1386,  0}, // #89 ADLPWriteResGroup202_SPRWriteResGroup206
  {1381,  0}, // #90 ADLPWriteResGroup204_SPRWriteResGroup208
  {74,  0}, // #91 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_WriteFSqrt64XLd_SKXWriteResGroup262_SPRWriteResGroup386_SPRWriteResGroup388_ICXWriteResGroup262
  {521,  0}, // #92 ADLPWriteResGroup259_SPRWriteResGroup423_LNLPWriteResGroupX259
  {473,  0}, // #93 ADLPWriteResGroup260_SPRWriteResGroup422_LNLPWriteResGroupX260
  {494,  0}, // #94 ADLPWriteResGroup261_SPRWriteResGroup427_LNLPWriteResGroupX261
  {470,  0}, // #95 ADLPWriteResGroup262_SPRWriteResGroup421_LNLPWriteResGroupX262
  {50,  0}, // #96 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #97 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #98 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #99 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #100 WriteFDivLd_WriteFSqrtLd_WriteFDiv64_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166
  { 1,  0}, // #101 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #102 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {45,  0}, // #103 AtomWrite01_45_WriteDiv64Ld_WriteIDiv64Ld_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_SPRWriteResGroup551
  {48,  0}, // #104 AtomWrite01_48
  {55,  0}, // #105 AtomWrite01_55_SPRWriteResGroup550
  {59,  0}, // #106 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #107 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #108 AtomWrite01_77
  {78,  0}, // #109 AtomWrite01_78
  {79,  0}, // #110 AtomWrite01_79
  {92,  0}, // #111 AtomWrite01_92
  {94,  0}, // #112 AtomWrite01_94
  {99,  0}, // #113 AtomWrite01_99
  {121,  0}, // #114 AtomWrite01_121
  {127,  0}, // #115 AtomWrite01_127
  {140,  0}, // #116 AtomWrite01_140_SKXWriteResGroup267_SPRWriteResGroup180_ICXWriteResGroup267
  {141,  0}, // #117 AtomWrite01_141
  {146,  0}, // #118 AtomWrite01_146
  {147,  0}, // #119 AtomWrite01_147
  {168,  0}, // #120 AtomWrite01_168
  {174,  0}, // #121 AtomWrite01_174
  {183,  0}, // #122 AtomWrite01_183
  {202,  0}, // #123 AtomWrite01_202
  {69,  0}, // #124 WriteFDiv64X
  { 4,  0}, // #125 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #126 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {44,  0}, // #127 WriteFSqrtXLd_WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_ICXWriteResGroup256
  {38,  0}, // #128 WriteFSqrt64Ld_WriteFDivY_WriteFDiv64Y_JWriteLOCK_CMPXCHG16B_SPRWriteResGroup369_SPRWriteResGroup541
  { 5,  0}, // #129 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #130 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {90,  0}, // #131 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #132 PdWriteLARrr
  { 7,  0}, // #133 WriteIMulHLd
  { 8,  0}, // #134 WriteMULX32Ld_WriteMULX64Ld_WriteRotateCLLd_WriteShiftCLLd
  { 3,  0}, // #135 WriteIMulH_WriteRotateCL_WriteShiftCL
  { 3,  0}, // #136 WriteMULX32_WriteMULX64
  { 4,  0}, // #137 WriteLoad
  { 8,  0}, // #138 WriteVecMaskedGatherWriteback
  {33,  0}, // #139 WriteAESKeyGenLd_SPRWriteResGroup452_SPRWriteResGroup371
  {80,  0}, // #140 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #141 WriteIMulHLd
  { 8,  0}, // #142 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #143 WriteIMulH
  { 3,  0}, // #144 WriteMULX32_WriteMULX64
  { 6,  0}, // #145 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #146 WriteRMW_WriteRotate_WriteShift
  { 8,  0}, // #147 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #148 WriteRMW
  {60,  0}, // #149 BWWriteResGroup197
  {115,  0}, // #150 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #151 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #152 WriteRMW
  {43,  0}, // #153 WriteFDivYLd_WriteFDiv64YLd_SPRWriteResGroup378
  {47,  0}, // #154 WriteFSqrtYLd_HWWriteFBLD_SPRWriteResGroup552
  {54,  0}, // #155 WriteFSqrt64Y
  {11,  0}, // #156 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #157 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #158 JWriteXADDrm_XCHG_Part
  {11,  0}, // #159 JWriteXADDrm_LdSt_Part
  {76,  0}, // #160 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #161 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #162 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #163 WriteRotateLd
  { 1,  0}, // #164 WriteRMW
  { 7,  0}, // #165 WriteRotateLd
  { 2,  0}, // #166 WriteRotate
  {36,  0}, // #167 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171_SPRWriteResGroup368
  {52,  0}, // #168 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {98,  0}, // #169 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #170 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #171 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #172 HWWriteResGroup177
  {27,  0}, // #173 SPRWriteResGroup404
  { 5,  0}, // #174 WriteVecMaskedGatherWriteback
  {49,  0}, // #175 SPRWriteResGroup375
  {51,  0}, // #176 SPRWriteResGroup376
  {477,  0}, // #177 SPRWriteResGroup420
  {550,  0}, // #178 SPRWriteResGroup424
  {474,  0}, // #179 SPRWriteResGroup425
  {464,  0}, // #180 SPRWriteResGroup426
  {475,  0}, // #181 SPRWriteResGroup428
  {476,  0}, // #182 SPRWriteResGroup429
  {471,  0}, // #183 SPRWriteResGroup430
  {53,  0}, // #184 SPRWriteResGroup549
  { 4,  0}, // #185 WriteLoad
  { 5,  0}, // #186 WriteVecMaskedGatherWriteback
  { 7,  0}, // #187 WriteIMulHLd
  { 7,  0}, // #188 WriteMULX32Ld_WriteMULX64Ld
  { 8,  0}, // #189 WriteIMulHLd
  { 7,  0} // #190 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  5}, // #1
  {5,  0,  5}, // #2
  {6,  0,  5}, // #3
  {0,  0,  5}, // #4
  {6,  0,  5}, // #5
  {0,  0,  6}, // #6
  {1,  0,  0}, // #7
  {0,  0,  6}, // #8
  {6,  0,  6}, // #9
  {0,  0,  6}, // #10
  {1,  0,  6}, // #11
  {0,  0,  5}, // #12
  {1,  0,  5}, // #13
  {0,  0,  3}, // #14
  {5,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {6,  0,  3}, // #18
  {0,  0,  3}, // #19
  {1,  0,  3}, // #20
  {0,  0,  4}, // #21
  {5,  0,  4}, // #22
  {6,  0,  4}, // #23
  {0,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0, -10}, // #26
  {1,  0, -10}, // #27
  {0,  0,  8}, // #28
  {0,  0,  8}, // #29
  {6,  0,  8}, // #30
  {0,  0,  8}, // #31
  {1,  0,  8}, // #32
  {0,  0, -6}, // #33
  {1,  0, -6}, // #34
  {5,  0,  3}, // #35
  {6,  0,  3}, // #36
  {7,  0,  3}, // #37
  {8,  0,  3}, // #38
  {0,  0,  7}, // #39
  {0,  0,  7}, // #40
  {6,  0,  7}, // #41
  {0,  0,  7}, // #42
  {1,  0,  7}, // #43
  {0,  0,  4}, // #44
  {1,  0,  4}, // #45
  {0,  0, -1}, // #46
  {1,  0, -1} // #47
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD(1)  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD(/*WriteALU*/ 19)           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD(/*WriteZero*/ 28)          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD(/*WriteVecALU*/ 38)        1, false, false, false,  3, 9,  1, 1,  0, 0}, // #3
  {DBGFIELD(/*WriteJump*/ 50)          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #4
  {DBGFIELD(/*WriteCMPXCHGRMW*/ 60)    6, false, false, false, 17, 9,  2, 1,  0, 0}, // #5
  {DBGFIELD(/*WriteJumpLd*/ 76)        2, false, false, false, 26, 9,  3, 1,  0, 0}, // #6
  {DBGFIELD(/*WriteMove*/ 88)          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD(/*WriteFStore*/ 98)        2, false, false, false, 35, 4,  2, 1,  0, 0}, // #8
  {DBGFIELD(/*WriteFLoad*/ 110)         1, false, false, false, 39, 3,  4, 1,  0, 0}, // #9
  {DBGFIELD(/*WriteSystem*/ 121)        1, false, false, false, 42, 3,  5, 1,  0, 0}, // #10
  {DBGFIELD(/*WriteLEA*/ 133)           1, false, false, false, 45, 8,  1, 1,  0, 0}, // #11
  {DBGFIELD(/*WriteRMW*/ 142)           3, false, false, false, 53, 5,  1, 1,  0, 0}, // #12
  {DBGFIELD(/*WriteADC*/ 151)           1, false, false, false, 12, 5,  1, 1,  0, 0}, // #13
  {DBGFIELD(/*WriteSHDrri*/ 160)        1, false, false, false, 45, 8,  6, 1,  0, 0}, // #14
  {DBGFIELD(/*WriteFStoreX*/ 172)       2, false, false, false, 35, 4,  2, 1,  0, 0}, // #15
  {DBGFIELD(/*WriteFLoadX*/ 185)        1, false, false, false, 39, 3,  4, 1,  0, 0}, // #16
  {DBGFIELD(/*WriteFStoreY*/ 197)       2, false, false, false, 35, 4,  2, 1,  0, 0}, // #17
  {DBGFIELD(/*WriteFLoadY*/ 210)        1, false, false, false, 39, 3,  7, 1,  0, 0}, // #18
  {DBGFIELD(/*WriteMicrocoded*/ 222)    1, false, false, false, 42, 3,  5, 1,  0, 0}, // #19
  {DBGFIELD(/*WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault*/ 238) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #20
  {DBGFIELD(/*WriteFSign*/ 310)         1, false, false, false,  3, 9,  1, 1,  0, 0}, // #21
  {DBGFIELD(/*WriteADCRMW*/ 321)        5, false, false, false, 64, 9,  2, 1,  0, 0}, // #22
  {DBGFIELD(/*WriteADCLd_ReadAfterLd*/ 333) 2, false, false, false, 73, 5,  8, 1,  1, 1}, // #23
  {DBGFIELD(/*WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 356) 5, false, false, false, 64, 9,  2, 1,  2, 2}, // #24
  {DBGFIELD(/*WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 452) 2, false, false, false, 73, 5,  8, 1,  4, 2}, // #25
  {DBGFIELD(/*WriteALURMW*/ 547)        4, false, false, false, 58, 6,  2, 1,  0, 0}, // #26
  {DBGFIELD(/*WriteALULd_ReadAfterLd*/ 559) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #27
  {DBGFIELD(/*WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 582) 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #28
  {DBGFIELD(/*WriteFAdd64XLd_ReadAfterVecXLd*/ 666) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #29
  {DBGFIELD(/*WriteFAdd64X*/ 697)       1, false, false, false, 86, 6,  6, 1,  0, 0}, // #30
  {DBGFIELD(/*WriteFAddXLd_ReadAfterVecXLd*/ 710) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #31
  {DBGFIELD(/*WriteFAddX*/ 739)         1, false, false, false, 86, 6,  6, 1,  0, 0}, // #32
  {DBGFIELD(/*WriteNop*/ 750)           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #33
  {DBGFIELD(/*WriteFAdd64Ld_ReadAfterVecLd*/ 759) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #34
  {DBGFIELD(/*WriteFAdd64*/ 788)        1, false, false, false, 86, 6,  6, 1,  0, 0}, // #35
  {DBGFIELD(/*WriteFAddLd_ReadAfterVecLd*/ 800) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #36
  {DBGFIELD(/*WriteFAdd*/ 827)          1, false, false, false, 92, 9,  6, 1,  0, 0}, // #37
  {DBGFIELD(/*WriteFAddLd*/ 837)        2, false, false, false, 78, 8,  9, 1,  0, 0}, // #38
  {DBGFIELD(/*WriteAESDecEncLd_ReadAfterVecXLd*/ 849) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #39
  {DBGFIELD(/*WriteAESDecEnc*/ 882)     1, false, false, false, 108, 5, 10, 1,  0, 0}, // #40
  {DBGFIELD(/*WriteAESIMCLd*/ 897)      3, false, false, false, 113, 7, 11, 1,  0, 0}, // #41
  {DBGFIELD(/*WriteAESIMC*/ 911)        2, false, false, false, 120, 5,  7, 1,  0, 0}, // #42
  {DBGFIELD(/*WriteAESKeyGenLd*/ 923)   14, false, false, false, 125, 14,  2, 1,  0, 0}, // #43
  {DBGFIELD(/*WriteAESKeyGen*/ 940)     14, false, false, false, 139, 12,  4, 1,  0, 0}, // #44
  {DBGFIELD(/*WriteFLogicLd_ReadAfterVecXLd*/ 955) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #45
  {DBGFIELD(/*WriteFLogic*/ 985)        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #46
  {DBGFIELD(/*WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 997) 3, false, false, false, 151, 12,  8, 1,  2, 1}, // #47
  {DBGFIELD(/*WriteBEXTR*/ 1082)         2, false, false, false, 163, 10,  3, 1,  0, 0}, // #48
  {DBGFIELD(/*WriteBEXTRLd*/ 1093)       3, false, false, false, 151, 12,  8, 1,  0, 0}, // #49
  {DBGFIELD(/*WriteALULd*/ 1106)         1, false, false, false,  1, 2,  8, 1,  0, 0}, // #50
  {DBGFIELD(/*WriteFBlendLd_ReadAfterVecXLd*/ 1117) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #51
  {DBGFIELD(/*WriteFBlend*/ 1147)        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #52
  {DBGFIELD(/*WriteFVarBlendLd_ReadAfterVecXLd*/ 1159) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #53
  {DBGFIELD(/*WriteFVarBlend*/ 1192)     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #54
  {DBGFIELD(/*WriteBLSLd*/ 1207)         2, false, false, false, 173, 5,  4, 1,  0, 0}, // #55
  {DBGFIELD(/*WriteBLS*/ 1218)           1, false, false, false, 178, 3, 12, 1,  0, 0}, // #56
  {DBGFIELD(/*WriteBSFLd*/ 1227)         2, false, false, false, 181, 10,  7, 1,  0, 0}, // #57
  {DBGFIELD(/*WriteBSF*/ 1238)           1, false, false, false, 45, 8,  6, 1,  0, 0}, // #58
  {DBGFIELD(/*WriteBSRLd*/ 1247)         2, false, false, false, 181, 10,  7, 1,  0, 0}, // #59
  {DBGFIELD(/*WriteBSR*/ 1258)           1, false, false, false, 45, 8,  6, 1,  0, 0}, // #60
  {DBGFIELD(/*WriteBSWAP32*/ 1267)       1, false, false, false, 45, 8,  1, 1,  0, 0}, // #61
  {DBGFIELD(/*WriteBSWAP64*/ 1280)       2, false, false, false, 163, 10, 12, 1,  0, 0}, // #62
  {DBGFIELD(/*WriteBitTestImmLd*/ 1293)  2, false, false, false, 181, 10,  3, 1,  0, 0}, // #63
  {DBGFIELD(/*WriteBitTestRegLd*/ 1311)  10, false, false, false, 191, 12,  8, 1,  0, 0}, // #64
  {DBGFIELD(/*WriteBitTest*/ 1329)       1, false, false, false, 45, 8,  1, 1,  0, 0}, // #65
  {DBGFIELD(/*WriteBitTestSetImmRMW*/ 1342) 4, false, false, false, 203, 12,  2, 1,  0, 0}, // #66
  {DBGFIELD(/*WriteBitTestSetRegRMW*/ 1364) 11, false, false, false, 215, 14, 13, 1,  0, 0}, // #67
  {DBGFIELD(/*WriteBitTestSet*/ 1386)    1, false, false, false, 45, 8,  1, 1,  0, 0}, // #68
  {DBGFIELD(/*WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 1402) 2, false, false, false, 181, 10,  7, 1,  2, 1}, // #69
  {DBGFIELD(/*WriteBZHI*/ 1486)          1, false, false, false, 45, 8,  6, 1,  0, 0}, // #70
  {DBGFIELD(/*WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault*/ 1496) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #71
  {DBGFIELD(/*WriteCMOVLd_ReadAfterLd*/ 1566) 2, false, false, false, 229, 7,  4, 1,  1, 1}, // #72
  {DBGFIELD(/*WriteCMOV*/ 1590)          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #73
  {DBGFIELD(/*WriteLoad*/ 1600)          1, false, false, false, 39, 3, 10, 1,  0, 0}, // #74
  {DBGFIELD(/*WriteFCMOV*/ 1610)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #75
  {DBGFIELD(/*WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 1621) 1, false, false, false,  1, 2,  8, 1,  2, 1}, // #76
  {DBGFIELD(/*WriteXCHG*/ 1704)          3, false, false, false, 236, 2, 12, 1,  0, 0}, // #77
  {DBGFIELD(/*WriteFCmp64XLd_ReadAfterVecXLd*/ 1714) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #78
  {DBGFIELD(/*WriteFCmp64X*/ 1745)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #79
  {DBGFIELD(/*WriteFCmpXLd_ReadAfterVecXLd*/ 1758) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #80
  {DBGFIELD(/*WriteFCmpX*/ 1787)         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #81
  {DBGFIELD(/*WriteFCmp64Ld_ReadAfterVecLd*/ 1798) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #82
  {DBGFIELD(/*WriteFCmp64*/ 1827)        1, false, false, false, 108, 5, 14, 1,  0, 0}, // #83
  {DBGFIELD(/*WriteFCmpLd_ReadAfterVecLd*/ 1839) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #84
  {DBGFIELD(/*WriteFCmp*/ 1866)          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #85
  {DBGFIELD(/*WriteCMPXCHG*/ 1876)       5, false, false, false, 238, 5,  6, 1,  0, 0}, // #86
  {DBGFIELD(/*WriteFComXLd_ReadAfterVecLd*/ 1889) 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #87
  {DBGFIELD(/*WriteFComX*/ 1917)         1, false, false, false,  3, 9,  6, 1,  0, 0}, // #88
  {DBGFIELD(/*WriteFCom*/ 1928)          1, false, false, false, 92, 9,  1, 1,  0, 0}, // #89
  {DBGFIELD(/*WriteCRC32Ld_ReadAfterLd*/ 1938) 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #90
  {DBGFIELD(/*WriteCRC32*/ 1963)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #91
  {DBGFIELD(/*WriteCvtI2PDLd*/ 1974)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #92
  {DBGFIELD(/*WriteCvtI2PD*/ 1989)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #93
  {DBGFIELD(/*WriteCvtI2PSLd*/ 2002)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #94
  {DBGFIELD(/*WriteCvtI2PS*/ 2017)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #95
  {DBGFIELD(/*WriteCvtPD2ILd*/ 2030)     3, false, false, false, 264, 12,  2, 1,  0, 0}, // #96
  {DBGFIELD(/*WriteCvtPD2I*/ 2045)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #97
  {DBGFIELD(/*WriteCvtPD2PSLd*/ 2058)    3, false, false, false, 264, 12,  2, 1,  0, 0}, // #98
  {DBGFIELD(/*WriteCvtPD2PS*/ 2074)      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #99
  {DBGFIELD(/*WriteCvtPS2ILd*/ 2088)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #100
  {DBGFIELD(/*WriteCvtPS2I*/ 2103)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #101
  {DBGFIELD(/*WriteCvtPS2PDLd*/ 2116)    2, false, false, false, 101, 7,  8, 1,  0, 0}, // #102
  {DBGFIELD(/*WriteCvtPS2PD*/ 2132)      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #103
  {DBGFIELD(/*WriteCvtSD2ILd*/ 2146)     3, false, false, false, 276, 11,  2, 1,  0, 0}, // #104
  {DBGFIELD(/*WriteCvtSD2I_ReadDefault*/ 2161) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #105
  {DBGFIELD(/*WriteCvtSD2I*/ 2186)       2, false, false, false, 287, 9,  4, 1,  0, 0}, // #106
  {DBGFIELD(/*WriteCvtSD2SSLd_ReadAfterVecLd*/ 2199) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #107
  {DBGFIELD(/*WriteCvtSD2SS*/ 2230)      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #108
  {DBGFIELD(/*WriteCvtI2SDLd*/ 2244)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #109
  {DBGFIELD(/*WriteCvtI2SDLd_ReadAfterVecLd*/ 2259) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #110
  {DBGFIELD(/*WriteCvtI2SD_ReadInt2Fpu*/ 2289) 2, false, false, false, 254, 10,  4, 1,  0, 1}, // #111
  {DBGFIELD(/*WriteCvtI2SD_ReadDefault_ReadInt2Fpu*/ 2314) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #112
  {DBGFIELD(/*WriteCvtI2SSLd*/ 2351)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #113
  {DBGFIELD(/*WriteCvtI2SSLd_ReadAfterVecLd*/ 2366) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #114
  {DBGFIELD(/*WriteCvtI2SS_ReadInt2Fpu*/ 2396) 2, false, false, false, 254, 10,  4, 1,  0, 1}, // #115
  {DBGFIELD(/*WriteCvtI2SS_ReadDefault_ReadInt2Fpu*/ 2421) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #116
  {DBGFIELD(/*WriteCvtSS2SDLd_ReadAfterVecLd*/ 2458) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #117
  {DBGFIELD(/*WriteCvtSS2SD*/ 2489)      2, false, false, false, 254, 10, 10, 1,  0, 0}, // #118
  {DBGFIELD(/*WriteCvtSS2ILd*/ 2503)     3, false, false, false, 276, 11,  2, 1,  0, 0}, // #119
  {DBGFIELD(/*WriteCvtSS2I_ReadDefault*/ 2518) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #120
  {DBGFIELD(/*WriteCvtSS2I*/ 2543)       2, false, false, false, 287, 9,  4, 1,  0, 0}, // #121
  {DBGFIELD(/*WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2556) 5, false, false, false, 296, 10, 15, 1,  2, 2}, // #122
  {DBGFIELD(/*WriteDiv16*/ 2653)         4, false, false, false, 306, 8, 16, 1,  0, 0}, // #123
  {DBGFIELD(/*WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2664) 5, false, false, false, 296, 10, 17, 1,  2, 2}, // #124
  {DBGFIELD(/*WriteDiv32*/ 2761)         4, false, false, false, 306, 8, 11, 1,  0, 0}, // #125
  {DBGFIELD(/*WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2772) 4, false, false, false, 314, 10, 18, 1,  2, 2}, // #126
  {DBGFIELD(/*WriteDiv64*/ 2869)         3, false, false, false, 324, 8, 13, 1,  0, 0}, // #127
  {DBGFIELD(/*WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2880) 3, false, false, false, 324, 8, 19, 1,  2, 2}, // #128
  {DBGFIELD(/*WriteDiv8*/ 2976)          3, false, false, false, 324, 8, 20, 1,  0, 0}, // #129
  {DBGFIELD(/*WriteFDiv64XLd_ReadAfterVecXLd*/ 2986) 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #130
  {DBGFIELD(/*WriteFDiv64X*/ 3017)       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #131
  {DBGFIELD(/*WriteFDivXLd_ReadAfterVecXLd*/ 3030) 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #132
  {DBGFIELD(/*WriteFDivX*/ 3059)         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #133
  {DBGFIELD(/*WriteFDivLd*/ 3070)        2, false, false, false, 243, 11, 13, 1,  0, 0}, // #134
  {DBGFIELD(/*WriteFDiv*/ 3082)          1, false, false, false,  3, 9,  8, 1,  0, 0}, // #135
  {DBGFIELD(/*WriteFDiv64Ld_ReadAfterVecLd*/ 3092) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #136
  {DBGFIELD(/*WriteFDiv64*/ 3121)        1, false, false, false,  3, 9, 21, 1,  0, 0}, // #137
  {DBGFIELD(/*WriteFDivLd_ReadAfterVecLd*/ 3133) 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #138
  {DBGFIELD(/*WriteDPPDLd_ReadAfterVecXLd*/ 3160) 4, false, false, false, 332, 9, 16, 1,  6, 1}, // #139
  {DBGFIELD(/*WriteDPPD*/ 3188)          3, false, false, false, 341, 7, 22, 1,  0, 0}, // #140
  {DBGFIELD(/*WriteDPPSLd_ReadAfterVecXLd*/ 3198) 7, false, false, false, 348, 13, 23, 1,  6, 1}, // #141
  {DBGFIELD(/*WriteDPPS*/ 3226)          6, false, false, false, 361, 11, 21, 1,  0, 0}, // #142
  {DBGFIELD(/*WriteStore*/ 3236)         2, false, false, false, 35, 4,  2, 1,  0, 0}, // #143
  {DBGFIELD(/*WriteVecExtractSt*/ 3247)  3, false, false, false, 372, 9, 17, 1,  0, 0}, // #144
  {DBGFIELD(/*WriteVecExtract*/ 3265)    2, false, false, false, 381, 11, 14, 1,  0, 0}, // #145
  {DBGFIELD(/*WriteVecALUX*/ 3281)       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #146
  {DBGFIELD(/*WriteFComLd*/ 3294)        2, false, false, false, 392, 13,  7, 1,  0, 0}, // #147
  {DBGFIELD(/*WriteEMMS*/ 3306)          10, false, false, false, 405, 9,  9, 1,  0, 0}, // #148
  {DBGFIELD(/*WriteFLDC*/ 3316)          2, false, false, false, 414, 6,  1, 1,  0, 0}, // #149
  {DBGFIELD(/*WriteVecIMulXLd_ReadAfterVecXLd*/ 3326) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #150
  {DBGFIELD(/*WriteVecIMulX*/ 3358)      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #151
  {DBGFIELD(/*WriteVecALUXLd_ReadAfterVecXLd*/ 3372) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #152
  {DBGFIELD(/*WriteFHAddLd_ReadAfterVecXLd*/ 3403) 4, false, false, false, 420, 11,  2, 1,  6, 1}, // #153
  {DBGFIELD(/*WriteFHAdd*/ 3432)         3, false, false, false, 431, 9,  3, 1,  0, 0}, // #154
  {DBGFIELD(/*WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3443) 5, false, false, false, 296, 10, 15, 1,  2, 2}, // #155
  {DBGFIELD(/*WriteIDiv16*/ 3541)        4, false, false, false, 306, 8, 16, 1,  0, 0}, // #156
  {DBGFIELD(/*WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3553) 5, false, false, false, 296, 10, 17, 1,  2, 2}, // #157
  {DBGFIELD(/*WriteIDiv32*/ 3651)        4, false, false, false, 306, 8, 11, 1,  0, 0}, // #158
  {DBGFIELD(/*WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3663) 4, false, false, false, 314, 10, 18, 1,  2, 2}, // #159
  {DBGFIELD(/*WriteIDiv64*/ 3761)        3, false, false, false, 324, 8, 13, 1,  0, 0}, // #160
  {DBGFIELD(/*WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3773) 3, false, false, false, 324, 8, 19, 1,  2, 2}, // #161
  {DBGFIELD(/*WriteIDiv8*/ 3870)         3, false, false, false, 324, 8, 20, 1,  0, 0}, // #162
  {DBGFIELD(/*WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3881) 5, false, false, false, 440, 12,  9, 1,  2, 2}, // #163
  {DBGFIELD(/*WriteIMul16*/ 3979)        4, false, false, false, 452, 10, 10, 1,  0, 0}, // #164
  {DBGFIELD(/*WriteIMul16RegLd_ReadAfterLd*/ 3991) 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #165
  {DBGFIELD(/*WriteIMul16ImmLd*/ 4020)   3, false, false, false, 462, 10, 22, 1,  0, 0}, // #166
  {DBGFIELD(/*WriteIMul16Reg*/ 4037)     1, false, false, false, 45, 8,  6, 1,  0, 0}, // #167
  {DBGFIELD(/*WriteIMul16Imm*/ 4052)     2, false, false, false, 472, 8, 14, 1,  0, 0}, // #168
  {DBGFIELD(/*WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4067) 4, false, false, false, 480, 12, 22, 1,  2, 2}, // #169
  {DBGFIELD(/*WriteIMul32*/ 4165)        3, false, false, false, 492, 10, 14, 1,  0, 0}, // #170
  {DBGFIELD(/*WriteIMul32RegLd_ReadAfterLd*/ 4177) 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #171
  {DBGFIELD(/*WriteIMul32ImmLd*/ 4206)   2, false, false, false, 181, 10,  7, 1,  0, 0}, // #172
  {DBGFIELD(/*WriteIMul32Reg*/ 4223)     1, false, false, false, 45, 8,  6, 1,  0, 0}, // #173
  {DBGFIELD(/*WriteIMul32Imm*/ 4238)     1, false, false, false, 45, 8,  6, 1,  0, 0}, // #174
  {DBGFIELD(/*WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4253) 3, false, false, false, 502, 13, 22, 1,  2, 2}, // #175
  {DBGFIELD(/*WriteIMul64*/ 4351)        2, false, false, false, 515, 11, 14, 1,  0, 0}, // #176
  {DBGFIELD(/*WriteIMul64RegLd_ReadAfterLd*/ 4363) 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #177
  {DBGFIELD(/*WriteIMul64ImmLd*/ 4392)   2, false, false, false, 181, 10,  7, 1,  0, 0}, // #178
  {DBGFIELD(/*WriteIMul64Reg*/ 4409)     1, false, false, false, 45, 8,  6, 1,  0, 0}, // #179
  {DBGFIELD(/*WriteIMul64Imm*/ 4424)     1, false, false, false, 45, 8,  6, 1,  0, 0}, // #180
  {DBGFIELD(/*WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4439) 2, false, false, false, 181, 10,  7, 1,  2, 2}, // #181
  {DBGFIELD(/*WriteIMul8*/ 4536)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #182
  {DBGFIELD(/*WriteFShuffleLd_ReadAfterVecXLd*/ 4547) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #183
  {DBGFIELD(/*WriteFShuffle*/ 4579)      1, false, false, false, 92, 9,  1, 1,  0, 0}, // #184
  {DBGFIELD(/*WriteVecLogicX*/ 4593)     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #185
  {DBGFIELD(/*WriteShuffle*/ 4608)       1, false, false, false, 92, 9,  1, 1,  0, 0}, // #186
  {DBGFIELD(/*WriteLAHFSAHF*/ 4621)      1, false, false, false, 12, 5,  6, 1,  0, 0}, // #187
  {DBGFIELD(/*WriteVecLoadX*/ 4635)      1, false, false, false, 39, 3,  4, 1,  0, 0}, // #188
  {DBGFIELD(/*WriteLDMXCSR*/ 4649)       4, false, false, false, 537, 11,  4, 1,  0, 0}, // #189
  {DBGFIELD(/*WriteFLD0*/ 4662)          1, false, false, false, 548, 6,  1, 1,  0, 0}, // #190
  {DBGFIELD(/*WriteFLD1*/ 4672)          2, false, false, false, 414, 6,  1, 1,  0, 0}, // #191
  {DBGFIELD(/*WriteFence*/ 4682)         1, false, false, false, 12, 5, 12, 1,  0, 0}, // #192
  {DBGFIELD(/*WriteLZCNTLd*/ 4693)       2, false, false, false, 181, 10,  7, 1,  0, 0}, // #193
  {DBGFIELD(/*WriteLZCNT*/ 4706)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #194
  {DBGFIELD(/*WriteVecStoreX*/ 4717)     2, false, false, false, 35, 4,  2, 1,  0, 0}, // #195
  {DBGFIELD(/*WriteVecStore*/ 4732)      2, false, false, false, 35, 4,  2, 1,  0, 0}, // #196
  {DBGFIELD(/*WriteVecMoveToGpr*/ 4746)  1, false, false, false,  3, 9,  6, 1,  0, 0}, // #197
  {DBGFIELD(/*WriteVecLoad*/ 4764)       1, false, false, false, 39, 3,  4, 1,  0, 0}, // #198
  {DBGFIELD(/*WriteVecMoveFromGpr*/ 4777) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #199
  {DBGFIELD(/*WriteVecMoveX*/ 4797)      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #200
  {DBGFIELD(/*WriteVecStoreNT*/ 4811)    2, false, false, false, 35, 4, 25, 1,  0, 0}, // #201
  {DBGFIELD(/*WriteVecMove*/ 4827)       1, false, false, false, 548, 6,  1, 1,  0, 0}, // #202
  {DBGFIELD(/*WriteVecALULd*/ 4840)      2, false, false, false, 243, 11, 22, 1,  0, 0}, // #203
  {DBGFIELD(/*WriteShuffleLd_ReadAfterVecLd*/ 4854) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #204
  {DBGFIELD(/*WriteVecALULd_ReadAfterVecLd*/ 4884) 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #205
  {DBGFIELD(/*WriteVecLogicLd_ReadAfterVecLd*/ 4913) 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #206
  {DBGFIELD(/*WriteVecLogic*/ 4944)      1, false, false, false, 548, 6,  1, 1,  0, 0}, // #207
  {DBGFIELD(/*WritePHAddLd_ReadAfterVecLd*/ 4958) 4, false, false, false, 562, 11,  8, 1,  6, 1}, // #208
  {DBGFIELD(/*WritePHAdd*/ 4986)         3, false, false, false, 573, 9,  6, 1,  0, 0}, // #209
  {DBGFIELD(/*WriteVecInsertLd_ReadAfterLd*/ 4997) 2, false, false, false, 78, 8,  7, 1,  1, 1}, // #210
  {DBGFIELD(/*WriteVecInsert_ReadDefault_ReadInt2Fpu*/ 5026) 2, false, false, false, 582, 9, 14, 1,  7, 1}, // #211
  {DBGFIELD(/*WriteVecIMulLd_ReadAfterVecLd*/ 5065) 2, false, false, false, 243, 11, 24, 1,  6, 1}, // #212
  {DBGFIELD(/*WriteVecIMul*/ 5095)       1, false, false, false,  3, 9, 10, 1,  0, 0}, // #213
  {DBGFIELD(/*WriteMMXMOVMSK*/ 5108)     1, false, false, false,  3, 9,  6, 1,  0, 0}, // #214
  {DBGFIELD(/*WritePSADBWLd_ReadAfterVecLd*/ 5123) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #215
  {DBGFIELD(/*WritePSADBW*/ 5152)        1, false, false, false, 92, 9,  6, 1,  0, 0}, // #216
  {DBGFIELD(/*WriteVarShuffleLd_ReadAfterVecLd*/ 5164) 3, false, false, false, 591, 14,  8, 1,  6, 1}, // #217
  {DBGFIELD(/*WriteVarShuffle*/ 5197)    2, false, false, false, 605, 12,  6, 1,  0, 0}, // #218
  {DBGFIELD(/*WriteShuffleLd*/ 5213)     2, false, false, false, 526, 11, 22, 1,  0, 0}, // #219
  {DBGFIELD(/*WriteVecShiftImm*/ 5228)   1, false, false, false,  3, 9,  1, 1,  0, 0}, // #220
  {DBGFIELD(/*WriteVecShiftLd_ReadAfterVecLd*/ 5245) 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #221
  {DBGFIELD(/*WriteVecShift*/ 5276)      1, false, false, false,  3, 9,  1, 1,  0, 0}, // #222
  {DBGFIELD(/*WriteFMoveX*/ 5290)        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #223
  {DBGFIELD(/*WriteFShuffleLd*/ 5302)    2, false, false, false, 526, 11,  7, 1,  0, 0}, // #224
  {DBGFIELD(/*WriteFMOVMSK*/ 5318)       1, false, false, false,  3, 9,  6, 1,  0, 0}, // #225
  {DBGFIELD(/*WriteVecLoadNT*/ 5331)     1, false, false, false, 39, 3,  4, 1,  0, 0}, // #226
  {DBGFIELD(/*WriteStoreNT*/ 5346)       2, false, false, false, 35, 4, 26, 1,  0, 0}, // #227
  {DBGFIELD(/*WriteFStoreNTX*/ 5359)     2, false, false, false, 35, 4, 27, 1,  0, 0}, // #228
  {DBGFIELD(/*WriteFStoreNT*/ 5374)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #229
  {DBGFIELD(/*WriteMPSADLd_ReadAfterVecXLd*/ 5388) 3, false, false, false, 617, 11,  8, 1,  6, 1}, // #230
  {DBGFIELD(/*WriteMPSAD*/ 5417)         2, false, false, false, 582, 9, 14, 1,  0, 0}, // #231
  {DBGFIELD(/*WriteFMul64XLd_ReadAfterVecXLd*/ 5428) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #232
  {DBGFIELD(/*WriteFMul64X*/ 5459)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #233
  {DBGFIELD(/*WriteFMulXLd_ReadAfterVecXLd*/ 5472) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #234
  {DBGFIELD(/*WriteFMulX*/ 5501)         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #235
  {DBGFIELD(/*WriteFMul64Ld_ReadAfterVecLd*/ 5512) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #236
  {DBGFIELD(/*WriteFMul64*/ 5541)        1, false, false, false, 108, 5, 14, 1,  0, 0}, // #237
  {DBGFIELD(/*WriteFMulLd_ReadAfterVecLd*/ 5553) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #238
  {DBGFIELD(/*WriteFMul*/ 5580)          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #239
  {DBGFIELD(/*WriteMULX32Ld*/ 5590)      3, false, false, false, 480, 12, 22, 1,  0, 0}, // #240
  {DBGFIELD(/*WriteMULX32*/ 5604)        2, false, false, false, 492, 10, 14, 1,  0, 0}, // #241
  {DBGFIELD(/*WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 5616) 4, false, false, false, 480, 12, 28, 2,  2, 1}, // #242
  {DBGFIELD(/*WriteIMulH_WriteMULX32*/ 5715) 3, false, false, false, 492, 10, 30, 2,  0, 0}, // #243
  {DBGFIELD(/*WriteMULX64Ld*/ 5738)      2, false, false, false, 502, 13, 22, 1,  0, 0}, // #244
  {DBGFIELD(/*WriteMULX64*/ 5752)        1, false, false, false, 515, 11, 14, 1,  0, 0}, // #245
  {DBGFIELD(/*WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 5764) 3, false, false, false, 502, 13, 28, 2,  2, 1}, // #246
  {DBGFIELD(/*WriteIMulH_WriteMULX64*/ 5863) 2, false, false, false, 515, 11, 30, 2,  0, 0}, // #247
  {DBGFIELD(/*WriteFMulLd*/ 5886)        2, false, false, false, 101, 7,  8, 1,  0, 0}, // #248
  {DBGFIELD(/*WriteVecALUXLd*/ 5898)     2, false, false, false, 101, 7,  7, 1,  0, 0}, // #249
  {DBGFIELD(/*WriteShuffleXLd_ReadAfterVecXLd*/ 5913) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #250
  {DBGFIELD(/*WriteShuffleX*/ 5945)      1, false, false, false, 86, 6,  1, 1,  0, 0}, // #251
  {DBGFIELD(/*WriteVecLogicXLd_ReadAfterVecXLd*/ 5959) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #252
  {DBGFIELD(/*WriteVarBlendLd_ReadAfterVecXLd*/ 5992) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #253
  {DBGFIELD(/*WriteVarBlend*/ 6024)      1, false, false, false, 109, 4,  1, 1,  0, 0}, // #254
  {DBGFIELD(/*WriteBlendLd_ReadAfterVecXLd*/ 6038) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #255
  {DBGFIELD(/*WriteBlend*/ 6067)         1, false, false, false, 86, 6,  1, 1,  0, 0}, // #256
  {DBGFIELD(/*WriteCLMulLd_ReadAfterVecXLd*/ 6078) 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #257
  {DBGFIELD(/*WriteCLMul*/ 6107)         1, false, false, false, 92, 9,  6, 1,  0, 0}, // #258
  {DBGFIELD(/*WritePCmpEStrILd_ReadAfterVecXLd*/ 6118) 8, false, false, false, 628, 15, 32, 1,  6, 1}, // #259
  {DBGFIELD(/*WritePCmpEStrI*/ 6151)     8, false, false, false, 643, 13, 16, 1,  0, 0}, // #260
  {DBGFIELD(/*WritePCmpEStrMLd_ReadAfterVecXLd*/ 6166) 9, false, false, false, 656, 15, 20, 1,  6, 1}, // #261
  {DBGFIELD(/*WritePCmpEStrM*/ 6199)     9, false, false, false, 671, 13, 16, 1,  0, 0}, // #262
  {DBGFIELD(/*WritePCmpIStrILd_ReadAfterVecXLd*/ 6214) 4, false, false, false, 684, 11, 32, 1,  6, 1}, // #263
  {DBGFIELD(/*WritePCmpIStrI*/ 6247)     3, false, false, false, 695, 9,  8, 1,  0, 0}, // #264
  {DBGFIELD(/*WritePCmpIStrMLd_ReadAfterVecXLd*/ 6262) 4, false, false, false, 684, 11, 16, 1,  6, 1}, // #265
  {DBGFIELD(/*WritePCmpIStrM*/ 6295)     3, false, false, false, 695, 9,  8, 1,  0, 0}, // #266
  {DBGFIELD(/*WriteCvtPS2ILd_ReadAfterVecXLd*/ 6310) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #267
  {DBGFIELD(/*WritePHAddXLd_ReadAfterVecXLd*/ 6341) 4, false, false, false, 704, 8, 22, 1,  6, 1}, // #268
  {DBGFIELD(/*WritePHAddX*/ 6371)        3, false, false, false, 712, 6, 12, 1,  0, 0}, // #269
  {DBGFIELD(/*WritePHMINPOSLd*/ 6383)    2, false, false, false, 243, 11,  8, 1,  0, 0}, // #270
  {DBGFIELD(/*WritePHMINPOS*/ 6399)      1, false, false, false,  3, 9, 14, 1,  0, 0}, // #271
  {DBGFIELD(/*WriteCvtI2PSLd_ReadAfterVecXLd*/ 6413) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #272
  {DBGFIELD(/*WriteVecMOVMSK*/ 6444)     1, false, false, false,  3, 9,  6, 1,  0, 0}, // #273
  {DBGFIELD(/*WriteShuffleXLd*/ 6459)    2, false, false, false, 78, 8,  7, 1,  0, 0}, // #274
  {DBGFIELD(/*WritePMULLDLd_ReadAfterVecXLd*/ 6475) 3, false, false, false, 113, 7, 13, 1,  6, 1}, // #275
  {DBGFIELD(/*WritePMULLD*/ 6505)        2, false, false, false, 120, 5,  9, 1,  0, 0}, // #276
  {DBGFIELD(/*WriteCopy*/ 6517)          3, false, false, false, 53, 5, 20, 1,  0, 0}, // #277
  {DBGFIELD(/*WritePOPCNTLd*/ 6527)      2, false, false, false, 181, 10,  7, 1,  0, 0}, // #278
  {DBGFIELD(/*WritePOPCNT*/ 6541)        1, false, false, false, 45, 8,  6, 1,  0, 0}, // #279
  {DBGFIELD(/*WritePSADBWXLd_ReadAfterVecXLd*/ 6553) 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #280
  {DBGFIELD(/*WritePSADBWX*/ 6584)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #281
  {DBGFIELD(/*WriteVarShuffleXLd_ReadAfterVecXLd*/ 6597) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #282
  {DBGFIELD(/*WriteVarShuffleX*/ 6632)   1, false, false, false, 86, 6,  1, 1,  0, 0}, // #283
  {DBGFIELD(/*WriteVecShiftImmX*/ 6649)  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #284
  {DBGFIELD(/*WriteVecShiftXLd_ReadAfterVecXLd*/ 6667) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #285
  {DBGFIELD(/*WriteVecShiftX*/ 6700)     2, false, false, false, 718, 7, 12, 1,  0, 0}, // #286
  {DBGFIELD(/*WriteVecTestLd_ReadAfterVecXLd*/ 6715) 3, false, false, false, 591, 14, 22, 1,  6, 1}, // #287
  {DBGFIELD(/*WriteVecTest*/ 6746)       2, false, false, false, 605, 12, 14, 1,  0, 0}, // #288
  {DBGFIELD(/*WriteRotateLd_WriteRMW*/ 6759) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #289
  {DBGFIELD(/*WriteRotateLd_WriteRotate*/ 6782) 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #290
  {DBGFIELD(/*WriteRotateCLLd_WriteRMW*/ 6808) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #291
  {DBGFIELD(/*WriteRotateCLLd_WriteRotateCL*/ 6833) 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #292
  {DBGFIELD(/*WriteRotate*/ 6863)        3, false, false, false, 754, 5, 12, 1,  0, 0}, // #293
  {DBGFIELD(/*WriteRotateCL*/ 6875)      2, false, false, false, 759, 5, 12, 1,  0, 0}, // #294
  {DBGFIELD(/*WriteFRcpXLd*/ 6889)       2, false, false, false, 243, 11,  8, 1,  0, 0}, // #295
  {DBGFIELD(/*WriteFRcpX*/ 6902)         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #296
  {DBGFIELD(/*WriteFRcpLd*/ 6913)        2, false, false, false, 243, 11,  8, 1,  0, 0}, // #297
  {DBGFIELD(/*WriteFRcpLd_ReadAfterVecLd*/ 6925) 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #298
  {DBGFIELD(/*WriteFRcp*/ 6952)          1, false, false, false,  3, 9, 14, 1,  0, 0}, // #299
  {DBGFIELD(/*WriteShiftLd*/ 6962)       1, false, false, false, 12, 5,  2, 1,  0, 0}, // #300
  {DBGFIELD(/*WriteShift*/ 6975)         1, false, false, false, 12, 5,  1, 1,  0, 0}, // #301
  {DBGFIELD(/*WriteFRndLd*/ 6986)        3, false, false, false, 113, 7, 11, 1,  0, 0}, // #302
  {DBGFIELD(/*WriteFRnd*/ 6998)          2, false, false, false, 120, 5,  7, 1,  0, 0}, // #303
  {DBGFIELD(/*WriteFRndLd_ReadAfterVecXLd*/ 7008) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #304
  {DBGFIELD(/*WriteFRsqrtXLd*/ 7036)     2, false, false, false, 243, 11,  8, 1,  0, 0}, // #305
  {DBGFIELD(/*WriteFRsqrtX*/ 7051)       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #306
  {DBGFIELD(/*WriteFRsqrtLd*/ 7064)      2, false, false, false, 243, 11,  8, 1,  0, 0}, // #307
  {DBGFIELD(/*WriteFRsqrtLd_ReadAfterVecLd*/ 7078) 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #308
  {DBGFIELD(/*WriteFRsqrt*/ 7107)        1, false, false, false,  3, 9, 14, 1,  0, 0}, // #309
  {DBGFIELD(/*WriteShiftLd_WriteRMW*/ 7119) 4, false, false, false, 764, 9, 33, 2,  0, 0}, // #310
  {DBGFIELD(/*WriteShiftLd_WriteShift*/ 7141) 2, false, false, false, 759, 5, 33, 2,  0, 0}, // #311
  {DBGFIELD(/*WriteShiftCLLd_WriteRMW*/ 7165) 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #312
  {DBGFIELD(/*WriteShiftCLLd_WriteShiftCL*/ 7189) 4, false, false, false, 782, 5, 35, 2,  0, 0}, // #313
  {DBGFIELD(/*WriteShiftCL*/ 7217)       2, false, false, false, 759, 5, 12, 1,  0, 0}, // #314
  {DBGFIELD(/*WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 7230) 1, false, false, false, 12, 5,  2, 1,  2, 1}, // #315
  {DBGFIELD(/*WriteSETCCStore*/ 7315)    4, false, false, false, 787, 8, 24, 1,  0, 0}, // #316
  {DBGFIELD(/*WriteSETCC*/ 7331)         2, false, false, false, 759, 5, 12, 1,  0, 0}, // #317
  {DBGFIELD(/*WriteSHDmrcl*/ 7342)       6, false, false, false, 795, 14,  2, 1,  0, 0}, // #318
  {DBGFIELD(/*WriteSHDmri*/ 7355)        5, false, false, false, 809, 12,  2, 1,  0, 0}, // #319
  {DBGFIELD(/*WriteSHDrrcl*/ 7367)       3, false, false, false, 492, 10, 10, 1,  0, 0}, // #320
  {DBGFIELD(/*WriteFSqrt64XLd*/ 7380)    2, false, false, false, 243, 11, 41, 1,  0, 0}, // #321
  {DBGFIELD(/*WriteFSqrt64X*/ 7396)      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #322
  {DBGFIELD(/*WriteFSqrtXLd*/ 7410)      2, false, false, false, 243, 11, 17, 1,  0, 0}, // #323
  {DBGFIELD(/*WriteFSqrtX*/ 7424)        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #324
  {DBGFIELD(/*WriteFSqrt64Ld*/ 7436)     2, false, false, false, 243, 11, 18, 1,  0, 0}, // #325
  {DBGFIELD(/*WriteFSqrt64Ld_ReadAfterVecLd*/ 7451) 2, false, false, false, 243, 11, 18, 1,  6, 1}, // #326
  {DBGFIELD(/*WriteFSqrt64*/ 7481)       1, false, false, false,  3, 9, 13, 1,  0, 0}, // #327
  {DBGFIELD(/*WriteFSqrtLd*/ 7494)       2, false, false, false, 243, 11, 17, 1,  0, 0}, // #328
  {DBGFIELD(/*WriteFSqrtLd_ReadAfterVecLd*/ 7507) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #329
  {DBGFIELD(/*WriteFSqrt*/ 7535)         1, false, false, false,  3, 9,  2, 1,  0, 0}, // #330
  {DBGFIELD(/*WriteFSqrt80*/ 7546)       1, false, false, false, 821, 10, 23, 1,  0, 0}, // #331
  {DBGFIELD(/*WriteSTMXCSR*/ 7559)       4, false, false, false, 831, 12,  2, 1,  0, 0}, // #332
  {DBGFIELD(/*WriteTZCNTLd*/ 7572)       2, false, false, false, 181, 10,  7, 1,  0, 0}, // #333
  {DBGFIELD(/*WriteTZCNT*/ 7585)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #334
  {DBGFIELD(/*WriteFMAZLd*/ 7596)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD(/*WriteFMALd*/ 7608)         2, false, false, false, 101, 7,  8, 1,  0, 0}, // #336
  {DBGFIELD(/*WriteFAddYLd_ReadAfterVecYLd*/ 7619) 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #337
  {DBGFIELD(/*WriteFAddY*/ 7648)         1, false, false, false, 86, 6,  6, 1,  0, 0}, // #338
  {DBGFIELD(/*WriteFAddZLd_ReadAfterVecYLd*/ 7659) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD(/*WriteFAddZ*/ 7688)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD(/*WriteFAdd64YLd_ReadAfterVecYLd*/ 7699) 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #341
  {DBGFIELD(/*WriteFAdd64Y*/ 7730)       1, false, false, false, 86, 6,  6, 1,  0, 0}, // #342
  {DBGFIELD(/*WriteFAdd64ZLd_ReadAfterVecYLd*/ 7743) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD(/*WriteFAdd64Z*/ 7774)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD(/*WriteShuffleYLd_ReadAfterVecYLd*/ 7787) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #345
  {DBGFIELD(/*WriteShuffleY*/ 7819)      1, false, false, false, 86, 6,  1, 1,  0, 0}, // #346
  {DBGFIELD(/*WriteShuffleZLd_ReadAfterVecYLd*/ 7833) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD(/*WriteShuffleZ*/ 7865)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD(/*WriteFLogicYLd_ReadAfterVecYLd*/ 7879) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #349
  {DBGFIELD(/*WriteFLogicY*/ 7910)       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #350
  {DBGFIELD(/*WriteFLogicZLd_ReadAfterVecYLd*/ 7923) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD(/*WriteFLogicZ*/ 7954)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD(/*WriteCvtPH2PSY*/ 7967)     2, false, false, false, 254, 10,  7, 1,  0, 0}, // #353
  {DBGFIELD(/*WriteCvtPH2PS*/ 7982)      2, false, false, false, 254, 10,  3, 1,  0, 0}, // #354
  {DBGFIELD(/*WriteFVarBlendYLd_ReadAfterVecYLd*/ 7996) 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #355
  {DBGFIELD(/*WriteFVarBlendY*/ 8030)    3, false, false, false, 849, 4,  6, 1,  0, 0}, // #356
  {DBGFIELD(/*WriteFVarBlendZLd_ReadAfterVecYLd*/ 8046) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD(/*WriteFVarBlendZ*/ 8080)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD(/*WriteFBlendYLd_ReadAfterVecYLd*/ 8096) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #359
  {DBGFIELD(/*WriteFBlendY*/ 8127)       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #360
  {DBGFIELD(/*WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 8140) 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #361
  {DBGFIELD(/*WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 8250) 2, false, false, false, 102, 6,  7, 1,  8, 2}, // #362
  {DBGFIELD(/*WriteShuffle256Ld*/ 8359)  2, false, false, false, 526, 11,  8, 1,  0, 0}, // #363
  {DBGFIELD(/*WriteShuffle256*/ 8377)    1, false, false, false, 92, 9,  6, 1,  0, 0}, // #364
  {DBGFIELD(/*WriteShuffleYLd*/ 8393)    2, false, false, false, 78, 8, 22, 1,  0, 0}, // #365
  {DBGFIELD(/*WriteFShuffle256*/ 8409)   1, false, false, false, 92, 9,  6, 1,  0, 0}, // #366
  {DBGFIELD(/*WriteFShuffle256Ld*/ 8426) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #367
  {DBGFIELD(/*WriteFCmpYLd_ReadAfterVecYLd*/ 8445) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #368
  {DBGFIELD(/*WriteFCmpY*/ 8474)         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #369
  {DBGFIELD(/*WriteFCmpZLd_ReadAfterVecYLd*/ 8485) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD(/*WriteFCmpZ*/ 8514)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD(/*WriteFCmp64YLd_ReadAfterVecYLd*/ 8525) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #372
  {DBGFIELD(/*WriteFCmp64Y*/ 8556)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #373
  {DBGFIELD(/*WriteVarShuffle256Ld*/ 8569) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #374
  {DBGFIELD(/*WriteVarShuffle256*/ 8590) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #375
  {DBGFIELD(/*WriteCvtPD2PSLd_ReadAfterVecXLd*/ 8609) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #376
  {DBGFIELD(/*WriteCvtPD2PSYLd_ReadAfterVecYLd*/ 8641) 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #377
  {DBGFIELD(/*WriteCvtPD2PSY*/ 8674)     2, false, false, false, 254, 10,  4, 1,  0, 0}, // #378
  {DBGFIELD(/*WriteCvtPD2PSZLd_ReadAfterVecYLd*/ 8689) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD(/*WriteCvtPD2PSZ*/ 8722)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD(/*WriteVecIMulYLd_ReadAfterVecYLd*/ 8737) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #381
  {DBGFIELD(/*WriteVecIMulY*/ 8769)      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #382
  {DBGFIELD(/*WriteVecIMulZLd_ReadAfterVecYLd*/ 8783) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD(/*WriteVecIMulZ*/ 8815)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #384
  {DBGFIELD(/*WriteCvtI2PDYLd*/ 8829)    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #385
  {DBGFIELD(/*WriteCvtI2PDY*/ 8845)      2, false, false, false, 254, 10,  4, 1,  0, 0}, // #386
  {DBGFIELD(/*WriteCvtI2PDZLd*/ 8859)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD(/*WriteCvtI2PDZ*/ 8875)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD(/*WriteCvtI2PSYLd*/ 8889)    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #389
  {DBGFIELD(/*WriteCvtI2PSY*/ 8905)      1, false, false, false, 108, 5, 14, 1,  0, 0}, // #390
  {DBGFIELD(/*WriteCvtI2PSZLd*/ 8919)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD(/*WriteCvtI2PSZ*/ 8935)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD(/*WriteCvtPH2PSZLd*/ 8949)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD(/*WriteCvtPH2PSZ*/ 8966)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD(/*WriteCvtPD2PSYLd*/ 8981)   3, false, false, false, 264, 12, 11, 1,  0, 0}, // #395
  {DBGFIELD(/*WriteCvtPD2PSZLd*/ 8998)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD(/*WriteCvtPD2IYLd*/ 9015)    3, false, false, false, 264, 12, 11, 1,  0, 0}, // #397
  {DBGFIELD(/*WriteCvtPD2IY*/ 9031)      2, false, false, false, 254, 10,  4, 1,  0, 0}, // #398
  {DBGFIELD(/*WriteCvtPD2IZLd*/ 9045)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD(/*WriteCvtPD2IZ*/ 9061)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD(/*WriteCvtPS2IYLd*/ 9075)    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #401
  {DBGFIELD(/*WriteCvtPS2IY*/ 9091)      1, false, false, false, 108, 5, 14, 1,  0, 0}, // #402
  {DBGFIELD(/*WriteCvtPS2IZLd*/ 9105)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD(/*WriteCvtPS2IZ*/ 9121)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD(/*WriteCvtPS2PDYLd*/ 9135)   2, false, false, false, 101, 7,  2, 1,  0, 0}, // #405
  {DBGFIELD(/*WriteCvtPS2PDY*/ 9152)     2, false, false, false, 254, 10,  4, 1,  0, 0}, // #406
  {DBGFIELD(/*WriteCvtPS2PDZLd*/ 9167)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD(/*WriteCvtPS2PDZ*/ 9184)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD(/*WriteCvtPH2PSYLd*/ 9199)   2, false, false, false, 101, 7,  2, 1,  0, 0}, // #409
  {DBGFIELD(/*WriteCvtPH2PSLd*/ 9216)    2, false, false, false, 101, 7,  2, 1,  0, 0}, // #410
  {DBGFIELD(/*WriteCvtPS2PHYSt*/ 9232)   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #411
  {DBGFIELD(/*WriteCvtPS2PHY*/ 9249)     2, false, false, false, 254, 10,  7, 1,  0, 0}, // #412
  {DBGFIELD(/*WriteCvtPS2PHSt*/ 9264)    3, false, false, false, 853, 8,  2, 1,  0, 0}, // #413
  {DBGFIELD(/*WriteCvtPS2PH*/ 9280)      2, false, false, false, 254, 10,  3, 1,  0, 0}, // #414
  {DBGFIELD(/*WriteCvtPS2PHZSt*/ 9294)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD(/*WriteCvtPS2PHZ*/ 9311)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD(/*WriteCvtSD2ILd_ReadAfterVecLd*/ 9326) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #417
  {DBGFIELD(/*WriteCvtSS2ILd_ReadAfterVecLd*/ 9356) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #418
  {DBGFIELD(/*WritePSADBWYLd_ReadAfterVecYLd*/ 9386) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #419
  {DBGFIELD(/*WritePSADBWY*/ 9417)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #420
  {DBGFIELD(/*WritePSADBWZLd_ReadAfterVecYLd*/ 9430) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD(/*WritePSADBWZ*/ 9461)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD(/*WriteFDivYLd_ReadAfterVecYLd*/ 9474) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #423
  {DBGFIELD(/*WriteFDivY*/ 9503)         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #424
  {DBGFIELD(/*WriteFDivZLd_ReadAfterVecYLd*/ 9514) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD(/*WriteFDivZ*/ 9543)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD(/*WriteFDiv64YLd_ReadAfterVecYLd*/ 9554) 2, false, false, false, 243, 11, 23, 1,  6, 1}, // #427
  {DBGFIELD(/*WriteFDiv64Y*/ 9585)       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #428
  {DBGFIELD(/*WriteFDiv64ZLd_ReadAfterVecYLd*/ 9598) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD(/*WriteFDiv64Z*/ 9629)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD(/*WriteFMAXLd_ReadAfterVecXLd*/ 9642) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #431
  {DBGFIELD(/*WriteFMAX*/ 9670)          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #432
  {DBGFIELD(/*WriteFMAYLd_ReadAfterVecYLd*/ 9680) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #433
  {DBGFIELD(/*WriteFMAY*/ 9708)          1, false, false, false, 108, 5, 14, 1,  0, 0}, // #434
  {DBGFIELD(/*WriteFMAZLd_ReadAfterVecYLd*/ 9718) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD(/*WriteFMAZ*/ 9746)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD(/*WriteDPPSYLd_ReadAfterVecYLd*/ 9756) 7, false, false, false, 348, 13, 19, 1,  6, 1}, // #437
  {DBGFIELD(/*WriteDPPSY*/ 9785)         6, false, false, false, 361, 11, 21, 1,  0, 0}, // #438
  {DBGFIELD(/*WriteVarShuffle256Ld_ReadAfterVecYLd*/ 9796) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #439
  {DBGFIELD(/*WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd*/ 9833) 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #440
  {DBGFIELD(/*WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 9877) 2, false, false, false, 101, 7,  2, 1, 10, 2}, // #441
  {DBGFIELD(/*WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 9921) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD(/*WriteFMALd_ReadAfterVecLd_ReadAfterVecLd*/ 9965) 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #443
  {DBGFIELD(/*WriteFMA*/ 10006)           1, false, false, false, 108, 5, 14, 1,  0, 0}, // #444
  {DBGFIELD(/*WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 10015) 2, false, false, false, 101, 7,  2, 1,  8, 2}, // #445
  {DBGFIELD(/*WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 10119) 2, false, false, false, 101, 7,  8, 1,  8, 2}, // #446
  {DBGFIELD(/*WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd*/ 10223) 2, false, false, false, 101, 7,  8, 1,  8, 2}, // #447
  {DBGFIELD(/*WriteFRndYLd_ReadAfterVecYLd*/ 10324) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #448
  {DBGFIELD(/*WriteFRndY*/ 10353)         2, false, false, false, 120, 5,  7, 1,  0, 0}, // #449
  {DBGFIELD(/*WriteLoad_WriteVecMaskedGatherWriteback*/ 10364) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #450
  {DBGFIELD(/*WriteFRndZLd_ReadAfterVecYLd*/ 10404) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD(/*WriteFRndZ*/ 10433)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD(/*WriteVecALUYLd_ReadAfterVecYLd*/ 10444) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #453
  {DBGFIELD(/*WriteVecALUY*/ 10475)       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #454
  {DBGFIELD(/*WriteVecALUZLd_ReadAfterVecYLd*/ 10488) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD(/*WriteVecALUZ*/ 10519)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD(/*WriteFHAddYLd_ReadAfterVecYLd*/ 10532) 4, false, false, false, 420, 11, 24, 1,  6, 1}, // #457
  {DBGFIELD(/*WriteFHAddY*/ 10562)        3, false, false, false, 431, 9, 10, 1,  0, 0}, // #458
  {DBGFIELD(/*WriteFShuffle256Ld_ReadAfterVecYLd*/ 10574) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #459
  {DBGFIELD(/*WriteShuffle256Ld_ReadAfterVecYLd*/ 10609) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #460
  {DBGFIELD(/*WriteVecLoadY*/ 10643)      1, false, false, false, 39, 3,  7, 1,  0, 0}, // #461
  {DBGFIELD(/*WriteFMaskedStore64Y*/ 10657) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #462
  {DBGFIELD(/*WriteFMaskedLoadY*/ 10678)  2, false, false, false, 102, 6, 22, 1,  0, 0}, // #463
  {DBGFIELD(/*WriteFMaskedStore64*/ 10696) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #464
  {DBGFIELD(/*WriteFMaskedLoad*/ 10716)   2, false, false, false, 102, 6,  7, 1,  0, 0}, // #465
  {DBGFIELD(/*WriteFMaskedStore32Y*/ 10733) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #466
  {DBGFIELD(/*WriteFMaskedStore32*/ 10754) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #467
  {DBGFIELD(/*WriteFCmp64ZLd_ReadAfterVecYLd*/ 10774) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD(/*WriteFCmp64Z*/ 10805)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD(/*WriteFMoveY*/ 10818)        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #470
  {DBGFIELD(/*WriteFMoveZ*/ 10830)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD(/*WriteFShuffleYLd*/ 10842)   2, false, false, false, 526, 11, 22, 1,  0, 0}, // #472
  {DBGFIELD(/*WriteFShuffleY*/ 10859)     1, false, false, false, 92, 9,  1, 1,  0, 0}, // #473
  {DBGFIELD(/*WriteFShuffleZLd*/ 10874)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD(/*WriteFShuffleZ*/ 10891)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD(/*WriteVecStoreY*/ 10906)     2, false, false, false, 35, 4,  2, 1,  0, 0}, // #476
  {DBGFIELD(/*WriteVecMoveY*/ 10921)      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #477
  {DBGFIELD(/*WriteVecMoveZ*/ 10935)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD(/*WriteVecLoadNTY*/ 10949)    1, false, false, false, 39, 3,  7, 1,  0, 0}, // #479
  {DBGFIELD(/*WriteVecStoreNTY*/ 10965)   2, false, false, false, 35, 4, 44, 1,  0, 0}, // #480
  {DBGFIELD(/*WriteFStoreNTY*/ 10982)     2, false, false, false, 35, 4, 45, 1,  0, 0}, // #481
  {DBGFIELD(/*WriteMPSADYLd_ReadAfterVecYLd*/ 10997) 3, false, false, false, 617, 11,  2, 1,  6, 1}, // #482
  {DBGFIELD(/*WriteMPSADY*/ 11027)        2, false, false, false, 582, 9, 14, 1,  0, 0}, // #483
  {DBGFIELD(/*WriteFMulYLd_ReadAfterVecYLd*/ 11039) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #484
  {DBGFIELD(/*WriteFMulY*/ 11068)         1, false, false, false, 108, 5, 14, 1,  0, 0}, // #485
  {DBGFIELD(/*WriteFMulZLd_ReadAfterVecYLd*/ 11079) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD(/*WriteFMulZ*/ 11108)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD(/*WriteFMul64YLd_ReadAfterVecYLd*/ 11119) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #488
  {DBGFIELD(/*WriteFMul64Y*/ 11150)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #489
  {DBGFIELD(/*WriteFMul64ZLd_ReadAfterVecYLd*/ 11163) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD(/*WriteFMul64Z*/ 11194)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD(/*WriteVecALUYLd*/ 11207)     2, false, false, false, 101, 7, 22, 1,  0, 0}, // #492
  {DBGFIELD(/*WriteVecALUZLd*/ 11222)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD(/*WriteVecLogicYLd_ReadAfterVecYLd*/ 11237) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #494
  {DBGFIELD(/*WriteVecLogicY*/ 11270)     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #495
  {DBGFIELD(/*WriteVecLogicZLd_ReadAfterVecYLd*/ 11285) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD(/*WriteVecLogicZ*/ 11318)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD(/*WriteBlendYLd_ReadAfterVecYLd*/ 11333) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #498
  {DBGFIELD(/*WriteBlendY*/ 11363)        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #499
  {DBGFIELD(/*WriteVarBlendYLd_ReadAfterVecYLd*/ 11375) 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #500
  {DBGFIELD(/*WriteVarBlendY*/ 11408)     3, false, false, false, 849, 4,  6, 1,  0, 0}, // #501
  {DBGFIELD(/*WriteVarBlendZLd_ReadAfterVecYLd*/ 11423) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD(/*WriteVarBlendZ*/ 11456)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD(/*WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 11471) 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #504
  {DBGFIELD(/*WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 11580) 2, false, false, false, 102, 6,  7, 1,  8, 2}, // #505
  {DBGFIELD(/*WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 11688) 2, false, false, false, 78, 8, 22, 1,  8, 2}, // #506
  {DBGFIELD(/*WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 11796) 2, false, false, false, 78, 8, 22, 1, 10, 2}, // #507
  {DBGFIELD(/*WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 11844) 2, false, false, false, 78, 8,  7, 1,  8, 2}, // #508
  {DBGFIELD(/*WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd*/ 11952) 2, false, false, false, 78, 8,  7, 1, 10, 2}, // #509
  {DBGFIELD(/*WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd*/ 12000) 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #510
  {DBGFIELD(/*WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 12048) 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #511
  {DBGFIELD(/*WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 12096) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD(/*WriteFVarShuffle256Ld_ReadAfterVecYLd*/ 12144) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #513
  {DBGFIELD(/*WriteFVarShuffle256*/ 12182) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #514
  {DBGFIELD(/*WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 12202) 2, false, false, false, 526, 11, 22, 1,  8, 2}, // #515
  {DBGFIELD(/*WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd*/ 12314) 2, false, false, false, 526, 11, 22, 1, 10, 2}, // #516
  {DBGFIELD(/*WriteFVarShuffleY*/ 12366)  1, false, false, false, 92, 9,  1, 1,  0, 0}, // #517
  {DBGFIELD(/*WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 12384) 2, false, false, false, 526, 11,  7, 1,  8, 2}, // #518
  {DBGFIELD(/*WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd*/ 12495) 2, false, false, false, 526, 11,  7, 1, 10, 2}, // #519
  {DBGFIELD(/*WriteFVarShuffle*/ 12546)   1, false, false, false, 92, 9,  1, 1,  0, 0}, // #520
  {DBGFIELD(/*WriteFVarShuffleYLd_ReadAfterVecYLd*/ 12563) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #521
  {DBGFIELD(/*WriteFVarShuffleLd_ReadAfterVecXLd*/ 12599) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #522
  {DBGFIELD(/*WriteFVarShuffleZLd_ReadAfterVecYLd*/ 12634) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD(/*WriteFVarShuffleZ*/ 12670)  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD(/*WritePHAddYLd_ReadAfterVecYLd*/ 12688) 4, false, false, false, 704, 8,  9, 1,  6, 1}, // #525
  {DBGFIELD(/*WritePHAddY*/ 12718)        3, false, false, false, 712, 6, 12, 1,  0, 0}, // #526
  {DBGFIELD(/*WriteVecInsert*/ 12730)     2, false, false, false, 582, 9, 14, 1,  0, 0}, // #527
  {DBGFIELD(/*WriteVecIMulXLd*/ 12745)    2, false, false, false, 101, 7, 24, 1,  0, 0}, // #528
  {DBGFIELD(/*WriteVecIMulYLd*/ 12761)    2, false, false, false, 101, 7, 24, 1,  0, 0}, // #529
  {DBGFIELD(/*WriteVecIMulZLd*/ 12777)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD(/*WriteVecMaskedStore32Y*/ 12793) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #531
  {DBGFIELD(/*WriteVecMaskedLoadY*/ 12816) 2, false, false, false, 102, 6, 22, 1,  0, 0}, // #532
  {DBGFIELD(/*WriteVecMaskedStore32*/ 12836) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #533
  {DBGFIELD(/*WriteVecMaskedLoad*/ 12858) 2, false, false, false, 102, 6,  7, 1,  0, 0}, // #534
  {DBGFIELD(/*WriteVecMaskedStore64Y*/ 12877) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #535
  {DBGFIELD(/*WriteVecMaskedStore64*/ 12900) 3, false, false, false, 861, 12, 21, 1,  0, 0}, // #536
  {DBGFIELD(/*WriteVPMOV256Ld*/ 12922)    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #537
  {DBGFIELD(/*WriteVPMOV256*/ 12938)      1, false, false, false, 92, 9,  6, 1,  0, 0}, // #538
  {DBGFIELD(/*WriteVecMOVMSKY*/ 12952)    1, false, false, false,  3, 9, 14, 1,  0, 0}, // #539
  {DBGFIELD(/*WritePMULLDYLd_ReadAfterVecYLd*/ 12968) 3, false, false, false, 113, 7, 13, 1,  6, 1}, // #540
  {DBGFIELD(/*WritePMULLDY*/ 12999)       2, false, false, false, 120, 5,  9, 1,  0, 0}, // #541
  {DBGFIELD(/*WritePMULLDZLd_ReadAfterVecYLd*/ 13012) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD(/*WritePMULLDZ*/ 13043)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD(/*WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 13056) 2, false, false, false, 78, 8,  7, 1,  8, 2}, // #544
  {DBGFIELD(/*WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd*/ 13167) 2, false, false, false, 78, 8,  7, 1, 10, 2}, // #545
  {DBGFIELD(/*WriteVecShiftImmXLd*/ 13218) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD(/*WriteVecShiftImmYLd*/ 13238) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD(/*WriteVecShiftImmY*/ 13258)  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #548
  {DBGFIELD(/*WriteVecShiftImmZLd*/ 13276) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD(/*WriteVecShiftImmZ*/ 13296)  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD(/*WriteVarVecShiftLd_ReadAfterVecXLd*/ 13314) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #551
  {DBGFIELD(/*WriteVarVecShift*/ 13349)   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #552
  {DBGFIELD(/*WriteVarVecShiftYLd_ReadAfterVecYLd*/ 13366) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #553
  {DBGFIELD(/*WriteVarVecShiftY*/ 13402)  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #554
  {DBGFIELD(/*WriteVarVecShiftZLd_ReadAfterVecYLd*/ 13420) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD(/*WriteVarVecShiftZ*/ 13456)  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD(/*WriteVecShiftImmXLd_ReadAfterVecXLd*/ 13474) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD(/*WriteVarShuffleYLd_ReadAfterVecYLd*/ 13510) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #558
  {DBGFIELD(/*WriteVarShuffleY*/ 13545)   1, false, false, false, 86, 6,  1, 1,  0, 0}, // #559
  {DBGFIELD(/*WriteVarShuffleZLd_ReadAfterVecYLd*/ 13562) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD(/*WriteVarShuffleZ*/ 13597)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD(/*WriteShuffleZLd*/ 13614)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD(/*WriteVecShiftYLd_ReadAfterVecYLd*/ 13630) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #563
  {DBGFIELD(/*WriteVecShiftY*/ 13663)     2, false, false, false, 254, 10, 14, 1,  0, 0}, // #564
  {DBGFIELD(/*WriteVecShiftZLd_ReadAfterVecYLd*/ 13678) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD(/*WriteVecShiftZ*/ 13711)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD(/*WriteVecTestYLd_ReadAfterVecYLd*/ 13726) 3, false, false, false, 591, 14,  2, 1,  6, 1}, // #567
  {DBGFIELD(/*WriteVecTestY*/ 13758)      2, false, false, false, 605, 12,  3, 1,  0, 0}, // #568
  {DBGFIELD(/*WriteFRcpXLd_ReadAfterVecXLd*/ 13772) 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #569
  {DBGFIELD(/*WriteFRcpYLd_ReadAfterVecYLd*/ 13801) 2, false, false, false, 243, 11,  2, 1,  6, 1}, // #570
  {DBGFIELD(/*WriteFRcpY*/ 13830)         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #571
  {DBGFIELD(/*WriteFRcpZLd_ReadAfterVecYLd*/ 13841) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD(/*WriteFRcpZ*/ 13870)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD(/*WriteFRcpYLd*/ 13881)       2, false, false, false, 243, 11,  2, 1,  0, 0}, // #574
  {DBGFIELD(/*WriteFRndYLd*/ 13894)       3, false, false, false, 113, 7, 16, 1,  0, 0}, // #575
  {DBGFIELD(/*WriteFRsqrtXLd_ReadAfterVecXLd*/ 13907) 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #576
  {DBGFIELD(/*WriteFRsqrtYLd_ReadAfterVecYLd*/ 13938) 2, false, false, false, 243, 11,  2, 1,  6, 1}, // #577
  {DBGFIELD(/*WriteFRsqrtY*/ 13969)       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #578
  {DBGFIELD(/*WriteFRsqrtZLd_ReadAfterVecYLd*/ 13982) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD(/*WriteFRsqrtZ*/ 14013)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD(/*WriteFRsqrtYLd*/ 14026)     2, false, false, false, 243, 11,  2, 1,  0, 0}, // #581
  {DBGFIELD(/*WriteFShuffleYLd_ReadAfterVecYLd*/ 14041) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #582
  {DBGFIELD(/*WriteFShuffleZLd_ReadAfterVecYLd*/ 14074) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD(/*WriteFSqrtXLd_ReadAfterVecXLd*/ 14107) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #584
  {DBGFIELD(/*WriteFSqrtYLd_ReadAfterVecYLd*/ 14137) 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #585
  {DBGFIELD(/*WriteFSqrtY*/ 14167)        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #586
  {DBGFIELD(/*WriteFSqrtZLd_ReadAfterVecYLd*/ 14179) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD(/*WriteFSqrtZ*/ 14209)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD(/*WriteFSqrt64YLd*/ 14221)    2, false, false, false, 243, 11, 46, 1,  0, 0}, // #589
  {DBGFIELD(/*WriteFSqrt64Y*/ 14237)      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #590
  {DBGFIELD(/*WriteFSqrt64XLd_ReadAfterVecXLd*/ 14251) 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #591
  {DBGFIELD(/*WriteFSqrt64YLd_ReadAfterVecYLd*/ 14283) 2, false, false, false, 243, 11, 46, 1,  6, 1}, // #592
  {DBGFIELD(/*WriteFSqrt64ZLd_ReadAfterVecYLd*/ 14315) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD(/*WriteFSqrt64Z*/ 14347)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD(/*WriteFSqrtYLd*/ 14361)      2, false, false, false, 243, 11, 15, 1,  0, 0}, // #595
  {DBGFIELD(/*WriteFTestYLd_ReadAfterVecYLd*/ 14375) 2, false, false, false, 243, 11,  8, 1,  6, 1}, // #596
  {DBGFIELD(/*WriteFTestY*/ 14405)        1, false, false, false,  3, 9, 10, 1,  0, 0}, // #597
  {DBGFIELD(/*WriteFTestLd_ReadAfterVecXLd*/ 14417) 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #598
  {DBGFIELD(/*WriteFTest*/ 14446)         1, false, false, false,  3, 9,  6, 1,  0, 0}, // #599
  {DBGFIELD(/*WriteALULd_WriteRMW*/ 14457) 4, false, false, false, 58, 6, 47, 2,  0, 0}, // #600
  {DBGFIELD(/*COPY*/ 14477)               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #601
  {DBGFIELD(/*XAM_F*/ 14482)              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #602
  {DBGFIELD(/*LD_Frr*/ 14488)             1, false, false, false, 42, 3,  1, 1,  0, 0}, // #603
  {DBGFIELD(/*MOVSX64rr32*/ 14495)        1, false, false, false, 178, 3,  1, 1,  0, 0}, // #604
  {DBGFIELD(/*RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF*/ 14507) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #605
  {DBGFIELD(/*RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND*/ 15335) 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #606
  {DBGFIELD(/*RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF*/ 15899) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #607
  {DBGFIELD(/*RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND*/ 16353) 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #608
  {DBGFIELD(/*SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF*/ 16659) 4, false, false, false, 764, 9, 33, 2,  0, 0}, // #609
  {DBGFIELD(/*SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND*/ 17409) 2, false, false, false, 759, 5, 33, 2,  0, 0}, // #610
  {DBGFIELD(/*SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF*/ 17997) 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #611
  {DBGFIELD(/*SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND*/ 18408) 4, false, false, false, 782, 5, 35, 2,  0, 0}, // #612
  {DBGFIELD(/*MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8*/ 18726) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD(/*FCOMPP*/ 18852)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #614
  {DBGFIELD(/*UCOM_FPPr_UCOM_FPr_UCOM_Fr*/ 18859) 1, false, false, false,  3, 9, 12, 1,  0, 0}, // #615
  {DBGFIELD(/*MMX_CVTPI2PSrr*/ 18886)     2, false, false, false, 287, 9,  4, 1,  0, 0}, // #616
  {DBGFIELD(/*MMX_CVTPI2PSrm*/ 18901)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #617
  {DBGFIELD(/*MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr*/ 18916) 2, false, false, false, 873, 9, 22, 1,  0, 0}, // #618
  {DBGFIELD(/*POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr*/ 18947) 1, false, false, false, 39, 3, 10, 1,  0, 0}, // #619
  {DBGFIELD(/*PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32*/ 18988) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #620
  {DBGFIELD(/*XCH_F*/ 19095)              15, false, false, false, 882, 14, 20, 1,  0, 0}, // #621
  {DBGFIELD(/*RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64*/ 19101) 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #622
  {DBGFIELD(/*MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm*/ 19148) 2, false, false, false, 243, 11, 24, 1,  0, 0}, // #623
  {DBGFIELD(/*ILD_F16m_ILD_F32m_ILD_F64m*/ 19179) 2, false, false, false, 392, 13,  9, 1,  0, 0}, // #624
  {DBGFIELD(/*CVTSI642SDrm*/ 19206)       2, false, false, false, 101, 7,  8, 1,  0, 0}, // #625
  {DBGFIELD(/*CVTSI642SDrm_Int*/ 19219)   2, false, false, false, 101, 7,  8, 1,  6, 1}, // #626
  {DBGFIELD(/*CVTSI642SSrm*/ 19236)       3, false, false, false, 264, 12,  2, 1,  0, 0}, // #627
  {DBGFIELD(/*CVTSI642SSrm_Int*/ 19249)   3, false, false, false, 264, 12,  2, 1,  6, 1}, // #628
  {DBGFIELD(/*CVTSI642SSrr*/ 19266)       3, false, false, false, 896, 10,  7, 1,  0, 1}, // #629
  {DBGFIELD(/*CVTSI642SSrr_Int*/ 19279)   3, false, false, false, 896, 10,  7, 1,  7, 1}, // #630
  {DBGFIELD(/*CVTSS2SI64rr_CVTTSS2SI64rr*/ 19296) 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #631
  {DBGFIELD(/*CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int*/ 19323) 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #632
  {DBGFIELD(/*CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int*/ 19358) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #633
  {DBGFIELD(/*FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW*/ 19420) 2, false, false, false, 122, 3, 12, 1,  0, 0}, // #634
  {DBGFIELD(/*LFENCE*/ 19478)             1, false, false, false, 12, 5, 12, 1,  0, 0}, // #635
  {DBGFIELD(/*MOVSSrr_MOVSSrr_REV*/ 19485) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #636
  {DBGFIELD(/*LEAVE_LEAVE64*/ 19505)      3, false, false, false, 116, 4,  3, 1,  0, 0}, // #637
  {DBGFIELD(/*POP16r*/ 19519)             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #638
  {DBGFIELD(/*PUSH16rmm_PUSH32rmm_PUSH64rmm*/ 19526) 3, false, false, false, 53, 5,  1, 1,  0, 0}, // #639
  {DBGFIELD(/*LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW*/ 19556) 4, false, false, false, 845, 4,  3, 1,  0, 0}, // #640
  {DBGFIELD(/*PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32*/ 19604) 1, false, false, false, 42, 3,  5, 1,  0, 0}, // #641
  {DBGFIELD(/*ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m*/ 19730) 1, false, false, false, 918, 5,  1, 1,  0, 0}, // #642
  {DBGFIELD(/*ST_FPrr_ST_Frr*/ 19797)     1, false, false, false, 42, 3,  1, 1,  0, 0}, // #643
  {DBGFIELD(/*MMX_PADDQrr_MMX_PSUBQrr*/ 19812) 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #644
  {DBGFIELD(/*MOVSX16rr8_MOVZX16rr8*/ 19836) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #645
  {DBGFIELD(/*MOVDQUmr_MASKMOVDQU_MASKMOVDQU64*/ 19858) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #646
  {DBGFIELD(/*MOVUPDmr_MOVUPSmr*/ 19891)  2, false, false, false, 35, 4,  2, 1,  0, 0}, // #647
  {DBGFIELD(/*PADDQrr_PSUBQrr*/ 19909)    1, false, false, false, 109, 4,  1, 1,  0, 0}, // #648
  {DBGFIELD(/*CLD*/ 19925)                2, false, false, false, 73, 5,  6, 1,  0, 0}, // #649
  {DBGFIELD(/*LDDQUrm*/ 19929)            1, false, false, false, 39, 3,  4, 1,  0, 0}, // #650
  {DBGFIELD(/*CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW*/ 19937) 7, false, false, false, 923, 6,  4, 1,  0, 0}, // #651
  {DBGFIELD(/*POP16rmm_POP32rmm_POP64rmm*/ 19985) 3, false, false, false, 53, 5,  2, 1,  0, 0}, // #652
  {DBGFIELD(/*XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm*/ 20012) 9, false, false, false, 929, 9, 49, 2,  0, 0}, // #653
  {DBGFIELD(/*PHADDDrr_PHSUBDrr*/ 20082)  3, false, false, false, 712, 6, 12, 1,  0, 0}, // #654
  {DBGFIELD(/*MOVSX16rm8_MOVZX16rm8*/ 20100) 2, false, false, false, 173, 5,  3, 1,  0, 0}, // #655
  {DBGFIELD(/*MMX_PADDQrm_MMX_PSUBQrm*/ 20122) 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #656
  {DBGFIELD(/*MOVDQUrm*/ 20146)           1, false, false, false, 39, 3,  4, 1,  0, 0}, // #657
  {DBGFIELD(/*MOVUPDrm_MOVUPSrm*/ 20155)  1, false, false, false, 39, 3,  4, 1,  0, 0}, // #658
  {DBGFIELD(/*PADDQrm_PSUBQrm*/ 20173)    2, false, false, false, 102, 6,  7, 1,  6, 1}, // #659
  {DBGFIELD(/*CBW_CWD_CWDE_CDQ_CDQE_CQO*/ 20189) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #660
  {DBGFIELD(/*JCXZ_JECXZ_JRCXZ*/ 20215)   2, false, false, false, 938, 5, 12, 1,  0, 0}, // #661
  {DBGFIELD(/*LD_F80m*/ 20232)            1, false, false, false, 943, 5,  4, 1,  0, 0}, // #662
  {DBGFIELD(/*PHADDDrm_PHSUBDrm*/ 20240)  4, false, false, false, 704, 8, 22, 1,  6, 1}, // #663
  {DBGFIELD(/*MMX_PEXTRWrri_PEXTRWrri_PEXTRWrri_REV*/ 20258) 2, false, false, false, 381, 11, 14, 1,  0, 0}, // #664
  {DBGFIELD(/*FLDCW16m*/ 20296)           3, false, false, false, 948, 13,  4, 1,  0, 0}, // #665
  {DBGFIELD(/*ST_FP80m*/ 20305)           2, false, false, false, 918, 5,  1, 1,  0, 0}, // #666
  {DBGFIELD(/*MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr*/ 20314) 3, false, false, false, 573, 9,  6, 1,  0, 0}, // #667
  {DBGFIELD(/*CMPXCHG8rm*/ 20368)         6, false, false, false, 17, 9, 24, 1,  0, 0}, // #668
  {DBGFIELD(/*INTO*/ 20379)               1, false, false, false, 42, 3,  5, 1,  0, 0}, // #669
  {DBGFIELD(/*XLAT*/ 20384)               3, false, false, false, 116, 4,  4, 1,  0, 0}, // #670
  {DBGFIELD(/*SHLD16rrCL_SHRD16rrCL*/ 20389) 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #671
  {DBGFIELD(/*SHLD16rri8_SHRD16rri8*/ 20411) 1, false, false, false, 45, 8,  6, 1,  0, 0}, // #672
  {DBGFIELD(/*SHLD16mrCL_SHRD16mrCL*/ 20433) 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #673
  {DBGFIELD(/*SHLD16mri8_SHRD16mri8*/ 20455) 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #674
  {DBGFIELD(/*IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m*/ 20477) 3, false, false, false, 961, 13, 14, 1,  0, 0}, // #675
  {DBGFIELD(/*MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm*/ 20525) 4, false, false, false, 562, 11,  8, 1,  6, 1}, // #676
  {DBGFIELD(/*AAD8i8*/ 20579)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #677
  {DBGFIELD(/*LOOPE*/ 20586)              11, false, false, false, 974, 10,  6, 1,  0, 0}, // #678
  {DBGFIELD(/*PUSHA16_PUSHA32*/ 20592)    1, false, false, false, 918, 5,  1, 1,  0, 0}, // #679
  {DBGFIELD(/*SHLD64rrCL_SHRD64rrCL*/ 20608) 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #680
  {DBGFIELD(/*FNSTCW16m*/ 20630)          3, false, false, false, 984, 10, 12, 1,  0, 0}, // #681
  {DBGFIELD(/*POPA16_POPA32*/ 20640)      1, false, false, false, 943, 5, 10, 1,  0, 0}, // #682
  {DBGFIELD(/*PUSHF16_PUSHF32_PUSHF64*/ 20654) 1, false, false, false, 918, 5,  1, 1,  0, 0}, // #683
  {DBGFIELD(/*SHLD64mrCL_SHRD64mrCL*/ 20678) 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #684
  {DBGFIELD(/*SHLD64mri8_SHRD64mri8*/ 20700) 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #685
  {DBGFIELD(/*SHLD64rri8_SHRD64rri8*/ 20722) 1, false, false, false, 45, 8,  6, 1,  0, 0}, // #686
  {DBGFIELD(/*CMPXCHG8rr*/ 20744)         5, false, false, false, 238, 5,  6, 1,  0, 0}, // #687
  {DBGFIELD(/*COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80*/ 20755) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #688
  {DBGFIELD(/*BOUNDS16rm_BOUNDS32rm*/ 20824) 1, false, false, false, 42, 3,  5, 1,  0, 0}, // #689
  {DBGFIELD(/*AAA_AAS*/ 20846)            1, false, false, false, 42, 3,  5, 1,  0, 0}, // #690
  {DBGFIELD(/*CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm*/ 20854) 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #691
  {DBGFIELD(/*LOOPNE*/ 20890)             11, false, false, false, 974, 10, 12, 1,  0, 0}, // #692
  {DBGFIELD(/*PAUSE*/ 20897)              2, false, false, false, 994, 10, 14, 1,  0, 0}, // #693
  {DBGFIELD(/*CMPXCHG8B*/ 20903)          16, false, false, false, 1004, 14, 46, 1,  0, 0}, // #694
  {DBGFIELD(/*DAA*/ 20913)                1, false, false, false, 42, 3,  5, 1,  0, 0}, // #695
  {DBGFIELD(/*LOOP*/ 20917)               7, false, false, false, 1018, 10,  6, 1,  0, 0}, // #696
  {DBGFIELD(/*DAS*/ 20922)                1, false, false, false, 42, 3,  5, 1,  0, 0}, // #697
  {DBGFIELD(/*AAM8i8*/ 20926)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #698
  {DBGFIELD(/*STD*/ 20933)                2, false, false, false, 73, 5,  3, 1,  0, 0}, // #699
  {DBGFIELD(/*CMPXCHG16B*/ 20937)         22, false, false, false, 1028, 16, 51, 1,  0, 0}, // #700
  {DBGFIELD(/*ARPL16mr_ARPL16rr*/ 20948)  1, false, false, false, 42, 3,  5, 1,  0, 0}, // #701
  {DBGFIELD(/*FNCLEX_FXTRACT*/ 20966)     4, false, false, false, 1044, 3, 14, 1,  0, 0}, // #702
  {DBGFIELD(/*POPF32_POPF64*/ 20981)      1, false, false, false, 943, 5, 10, 1,  0, 0}, // #703
  {DBGFIELD(/*POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64*/ 20995) 1, false, false, false, 42, 3,  5, 1,  0, 0}, // #704
  {DBGFIELD(/*RDTSC_RDTSCP*/ 21075)       21, false, false, false, 1047, 13, 52, 1,  0, 0}, // #705
  {DBGFIELD(/*ENTER*/ 21088)              57, false, false, false, 1060, 17, 53, 1,  0, 0}, // #706
  {DBGFIELD(/*POPF16*/ 21094)             10, false, false, false, 1077, 12, 10, 1,  0, 0}, // #707
  {DBGFIELD(/*MONITOR32rrr_MONITOR64rrr*/ 21101) 1, false, false, false, 42, 3,  5, 1,  0, 0}, // #708
  {DBGFIELD(/*FRNDINT*/ 21127)            1, false, false, false, 42, 3,  5, 1,  0, 0}, // #709
  {DBGFIELD(/*MWAITrr_RDPMC*/ 21135)      10, false, false, false, 1089, 11, 15, 1,  0, 0}, // #710
  {DBGFIELD(/*POPSS16_POPSS32*/ 21149)    1, false, false, false, 42, 3,  5, 1,  0, 0}, // #711
  {DBGFIELD(/*FPREM*/ 21165)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #712
  {DBGFIELD(/*INSB_INSL_INSW*/ 21171)     86, false, false, false, 1100, 17, 15, 1,  0, 0}, // #713
  {DBGFIELD(/*FNINIT*/ 21186)             15, false, false, false, 1117, 9, 54, 1,  0, 0}, // #714
  {DBGFIELD(/*OUT8rr_OUT16rr_OUT32rr*/ 21193) 73, false, false, false, 1126, 17, 55, 1,  0, 0}, // #715
  {DBGFIELD(/*FPREM1*/ 21216)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #716
  {DBGFIELD(/*INVLPG_INVLPGA32_INVLPGA64*/ 21223) 1, false, false, false, 42, 3,  5, 1,  0, 0}, // #717
  {DBGFIELD(/*OUT8ir_OUT16ir_OUT32ir*/ 21250) 73, false, false, false, 1143, 17, 55, 1,  0, 0}, // #718
  {DBGFIELD(/*OUTSB_OUTSL_OUTSW*/ 21273)  83, false, false, false, 1160, 17,  5, 1,  0, 0}, // #719
  {DBGFIELD(/*FSCALE*/ 21291)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #720
  {DBGFIELD(/*RDMSR*/ 21298)              54, false, false, false, 1177, 12,  5, 1,  0, 0}, // #721
  {DBGFIELD(/*RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64*/ 21304) 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #722
  {DBGFIELD(/*IN8ri_IN16ri_IN32ri*/ 21371) 87, false, false, false, 1189, 15, 55, 1,  0, 0}, // #723
  {DBGFIELD(/*IN8rr_IN16rr_IN32rr*/ 21391) 86, false, false, false, 1204, 15, 55, 1,  0, 0}, // #724
  {DBGFIELD(/*F2XM1*/ 21411)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #725
  {DBGFIELD(/*CPUID*/ 21417)              26, false, false, false, 1219, 16, 13, 1,  0, 0}, // #726
  {DBGFIELD(/*INT*/ 21423)                1, false, false, false, 42, 3,  5, 1,  0, 0}, // #727
  {DBGFIELD(/*INT3*/ 21427)               1, false, false, false, 42, 3,  5, 1,  0, 0}, // #728
  {DBGFIELD(/*FXSAVE_FXSAVE64*/ 21432)    110, false, false, false, 1235, 17,  5, 1,  0, 0}, // #729
  {DBGFIELD(/*FXRSTOR_FXRSTOR64*/ 21448)  90, false, false, false, 1252, 16, 56, 1,  0, 0}, // #730
  {DBGFIELD(/*FYL2X*/ 21466)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #731
  {DBGFIELD(/*FYL2XP1*/ 21472)            1, false, false, false, 42, 3,  5, 1,  0, 0}, // #732
  {DBGFIELD(/*FPTAN*/ 21480)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #733
  {DBGFIELD(/*FSINCOS_FSIN_FCOS*/ 21486)  1, false, false, false, 42, 3,  5, 1,  0, 0}, // #734
  {DBGFIELD(/*FPATAN*/ 21504)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #735
  {DBGFIELD(/*WRMSR*/ 21511)              144, false, false, false, 1268, 16,  5, 1,  0, 0}, // #736
  {DBGFIELD(/*COMP_FST0r_COM_FST0r*/ 21517) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #737
  {DBGFIELD(/*UCOM_FPr_UCOM_Fr*/ 21538)   1, false, false, false, 92, 9,  1, 1,  0, 0}, // #738
  {DBGFIELD(/*FDECSTP_FINCSTP_FFREE_FFREEP*/ 21555) 2, false, false, false, 414, 6, 12, 1,  0, 0}, // #739
  {DBGFIELD(/*FNOP*/ 21584)               1, false, false, false, 548, 6,  1, 1,  0, 0}, // #740
  {DBGFIELD(/*RET64*/ 21589)              2, false, false, false, 229, 7,  4, 1,  0, 0}, // #741
  {DBGFIELD(/*CDQ_CQO*/ 21595)            1, false, false, false, 12, 5,  1, 1,  0, 0}, // #742
  {DBGFIELD(/*MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr*/ 21603) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #743
  {DBGFIELD(/*MMX_PALIGNRrri*/ 21678)     1, false, false, false, 92, 9,  1, 1,  0, 0}, // #744
  {DBGFIELD(/*SCASB_SCASL_SCASQ_SCASW*/ 21693) 4, false, false, false, 845, 4,  3, 1,  0, 0}, // #745
  {DBGFIELD(/*COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int*/ 21717) 1, false, false, false,  3, 9,  6, 1,  0, 0}, // #746
  {DBGFIELD(/*CWD*/ 21909)                2, false, false, false, 73, 5, 12, 1,  0, 0}, // #747
  {DBGFIELD(/*FNSTSW16r*/ 21913)          2, false, false, false, 1284, 9,  6, 1,  0, 0}, // #748
  {DBGFIELD(/*MMX_MOVDQ2Qrr*/ 21923)      2, false, false, false, 1293, 6,  6, 1,  0, 0}, // #749
  {DBGFIELD(/*PUSHFS64*/ 21937)           3, false, false, false, 1299, 11,  1, 1,  0, 0}, // #750
  {DBGFIELD(/*EXTRACTPSrri_VEXTRACTPSrri*/ 21946) 2, false, false, false, 605, 12, 14, 1,  0, 0}, // #751
  {DBGFIELD(/*RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1*/ 21973) 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #752
  {DBGFIELD(/*RCR8ri_RCR16ri_RCR32ri_RCR64ri*/ 22035) 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #753
  {DBGFIELD(/*RCL8ri_RCL16ri_RCL32ri_RCL64ri*/ 22066) 3, false, false, false, 754, 5, 12, 1,  0, 0}, // #754
  {DBGFIELD(/*COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr*/ 22097) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #755
  {DBGFIELD(/*MOV64sr*/ 22133)            1, false, false, false, 42, 3,  1, 1,  0, 0}, // #756
  {DBGFIELD(/*RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND*/ 22141) 2, false, false, false, 759, 5, 12, 1,  0, 0}, // #757
  {DBGFIELD(/*PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr*/ 22415) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #758
  {DBGFIELD(/*CLI*/ 22478)                3, false, false, false, 1310, 10,  5, 1,  0, 0}, // #759
  {DBGFIELD(/*PUSHGS64*/ 22482)           3, false, false, false, 1299, 11,  1, 1,  0, 0}, // #760
  {DBGFIELD(/*ISTT_FP16m_ISTT_FP32m_ISTT_FP64m*/ 22491) 3, false, false, false, 961, 13, 14, 1,  0, 0}, // #761
  {DBGFIELD(/*CALL64pcrel32*/ 22524)      2, false, false, false, 35, 4,  6, 1,  0, 0}, // #762
  {DBGFIELD(/*CALL64r_ImpCall_CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT*/ 22538) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #763
  {DBGFIELD(/*EXTRACTPSmri_VEXTRACTPSmri*/ 22628) 3, false, false, false, 1320, 12,  2, 1,  0, 0}, // #764
  {DBGFIELD(/*STOSB_STOSL_STOSQ_STOSW*/ 22655) 4, false, false, false, 1332, 5,  4, 1,  0, 0}, // #765
  {DBGFIELD(/*PEXTRDmri_PEXTRQmri_VPEXTRDmri_VPEXTRQmri*/ 22679) 3, false, false, false, 372, 9,  2, 1,  0, 0}, // #766
  {DBGFIELD(/*PUSHF16_PUSHF64*/ 22721)    4, false, false, false, 1337, 13, 14, 1,  0, 0}, // #767
  {DBGFIELD(/*CLFLUSH_CLFLUSHOPT*/ 22737) 3, false, false, false, 856, 5, 12, 1,  0, 0}, // #768
  {DBGFIELD(/*VBROADCASTSSrm*/ 22756)     1, false, false, false, 39, 3,  4, 1,  0, 0}, // #769
  {DBGFIELD(/*MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm*/ 22771) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #770
  {DBGFIELD(/*MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm*/ 22848) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #771
  {DBGFIELD(/*MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt*/ 22915) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #772
  {DBGFIELD(/*MOV16sm*/ 22999)            1, false, false, false, 42, 3,  1, 1,  0, 0}, // #773
  {DBGFIELD(/*MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm*/ 23007) 2, false, false, false, 243, 11, 22, 1,  0, 0}, // #774
  {DBGFIELD(/*MMX_PALIGNRrmi*/ 23043)     2, false, false, false, 526, 11, 22, 1,  6, 1}, // #775
  {DBGFIELD(/*MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm*/ 23058) 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #776
  {DBGFIELD(/*LODSL_LODSQ*/ 23097)        3, false, false, false, 116, 4, 10, 1,  0, 0}, // #777
  {DBGFIELD(/*VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm*/ 23109) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #778
  {DBGFIELD(/*VINSERTF128rmi*/ 23147)     2, false, false, false, 102, 6, 22, 1,  6, 1}, // #779
  {DBGFIELD(/*VERRm_VERWm*/ 23162)        34, false, false, false, 1350, 14, 57, 1,  0, 0}, // #780
  {DBGFIELD(/*FARJMP64m*/ 23174)          2, false, false, false, 1364, 10,  3, 1,  0, 0}, // #781
  {DBGFIELD(/*FNSTSWm*/ 23184)            3, false, false, false, 1374, 13,  6, 1,  0, 0}, // #782
  {DBGFIELD(/*SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r*/ 23192) 2, false, false, false, 472, 8,  3, 1,  0, 0}, // #783
  {DBGFIELD(/*CALL64m_RVMARKER_CALL64m_CALL64m_NT*/ 23237) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #784
  {DBGFIELD(/*CALL16m_CALL16m_NT_CALL32m_CALL32m_NT*/ 23273) 5, false, false, false, 64, 9,  4, 1,  0, 0}, // #785
  {DBGFIELD(/*COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int*/ 23311) 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #786
  {DBGFIELD(/*CMPSB_CMPSL_CMPSQ_CMPSW*/ 23503) 7, false, false, false, 1387, 4,  3, 1,  0, 0}, // #787
  {DBGFIELD(/*ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF*/ 23527) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #788
  {DBGFIELD(/*ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND*/ 24027) 6, false, false, false, 725, 5, 35, 2,  0, 0}, // #789
  {DBGFIELD(/*XADD16rm_XADD32rm_XADD64rm_XADD8rm*/ 24419) 5, false, false, false, 1391, 6, 58, 2,  0, 0}, // #790
  {DBGFIELD(/*FARCALL64m*/ 24454)         5, false, false, false, 1397, 12,  4, 1,  0, 0}, // #791
  {DBGFIELD(/*LD_F32m_LD_F64m*/ 24465)    1, false, false, false, 943, 5,  4, 1,  0, 0}, // #792
  {DBGFIELD(/*ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF*/ 24481) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #793
  {DBGFIELD(/*ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND*/ 24755) 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #794
  {DBGFIELD(/*ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr*/ 24967) 6, false, false, false, 1409, 9,  2, 1, 12, 2}, // #795
  {DBGFIELD(/*ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m*/ 25029) 2, false, false, false, 392, 13,  9, 1,  0, 0}, // #796
  {DBGFIELD(/*PCMPGTQrm_VPCMPGTQrm*/ 25085) 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #797
  {DBGFIELD(/*FICOM16m_FICOM32m_FICOMP16m_FICOMP32m*/ 25106) 3, false, false, false, 1418, 13,  8, 1,  0, 0}, // #798
  {DBGFIELD(/*MUL_F32m_MUL_F64m*/ 25144)  2, false, false, false, 1431, 13,  8, 1,  0, 0}, // #799
  {DBGFIELD(/*ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m*/ 25162) 3, false, false, false, 1418, 13, 24, 1,  0, 0}, // #800
  {DBGFIELD(/*MUL_FI16m_MUL_FI32m*/ 25224) 3, false, false, false, 1444, 16, 21, 1,  0, 0}, // #801
  {DBGFIELD(/*DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m*/ 25244) 2, false, false, false, 1431, 13, 19, 1,  0, 0}, // #802
  {DBGFIELD(/*DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m*/ 25282) 3, false, false, false, 1444, 16, 46, 1,  0, 0}, // #803
  {DBGFIELD(/*VZEROALL*/ 25324)           10, false, false, false, 1460, 10, 16, 1,  0, 0}, // #804
  {DBGFIELD(/*VZEROUPPER*/ 25333)         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #805
  {DBGFIELD(/*CLC*/ 25344)                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #806
  {DBGFIELD(/*SUB32rr_SUB64rr_XOR32rr_XOR64rr*/ 25348) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #807
  {DBGFIELD(/*XORPSrr_VXORPSrr_XORPDrr_VXORPDrr*/ 25380) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #808
  {DBGFIELD(/*VXORPSYrr_VXORPDYrr*/ 25414) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #809
  {DBGFIELD(/*PXORrr_VPXORrr*/ 25434)     1, false, false, false, 109, 4,  1, 1,  0, 0}, // #810
  {DBGFIELD(/*PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr*/ 25449) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #811
  {DBGFIELD(/*PSUBQrr*/ 25572)            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #812
  {DBGFIELD(/*PCMPGTQrr_VPCMPGTQrr*/ 25580) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #813
  {DBGFIELD(/*CMOV16rr_CMOV32rr_CMOV64rr*/ 25601) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #814
  {DBGFIELD(/*CMOV16rm_CMOV32rm_CMOV64rm*/ 25628) 2, false, false, false, 229, 7,  4, 1,  1, 1}, // #815
  {DBGFIELD(/*SETCCr*/ 25655)             2, false, false, false, 759, 5, 12, 1,  0, 0}, // #816
  {DBGFIELD(/*SETCCm*/ 25662)             4, false, false, false, 787, 8, 24, 1,  0, 0}, // #817
  {DBGFIELD(/*MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm*/ 25669) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #818
  {DBGFIELD(/*RETI16_RETI32_RETI64*/ 25745) 3, false, false, false, 1470, 7,  3, 1,  0, 0}, // #819
  {DBGFIELD(/*LRETI16_LRETI32_LRETI64*/ 25766) 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #820
  {DBGFIELD(/*RDPMC*/ 25790)              18, false, false, false, 1477, 12,  5, 1,  0, 0}, // #821
  {DBGFIELD(/*RDRAND16r_RDRAND32r_RDRAND64r*/ 25796) 25, false, false, false, 1489, 15,  5, 1,  0, 0}, // #822
  {DBGFIELD(/*FBLDm*/ 25826)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #823
  {DBGFIELD(/*FFREE_FFREEP*/ 25832)       1, false, false, false, 42, 3,  5, 1,  0, 0}, // #824
  {DBGFIELD(/*FSAVEm*/ 25845)             1, false, false, false, 42, 3,  5, 1,  0, 0}, // #825
  {DBGFIELD(/*FRSTORm*/ 25852)            1, false, false, false, 42, 3,  5, 1,  0, 0}, // #826
  {DBGFIELD(/*FXTRACT*/ 25860)            1, false, false, false, 42, 3,  5, 1,  0, 0}, // #827
  {DBGFIELD(/*VPBROADCASTDrm_VPBROADCASTQrm*/ 25868) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #828
  {DBGFIELD(/*VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm*/ 25898) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #829
  {DBGFIELD(/*VBROADCASTI128rm*/ 25947)   1, false, false, false, 39, 3,  7, 1,  0, 0}, // #830
  {DBGFIELD(/*VPBROADCASTDYrm_VPBROADCASTQYrm*/ 25964) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #831
  {DBGFIELD(/*FBSTPm*/ 25996)             2, false, false, false, 918, 5,  1, 1,  0, 0}, // #832
  {DBGFIELD(/*VMPTRSTm*/ 26003)           2, false, false, false, 918, 5,  1, 1,  0, 0}, // #833
  {DBGFIELD(/*ST_FP32m_ST_FP64m*/ 26012)  2, false, false, false, 918, 5,  1, 1,  0, 0}, // #834
  {DBGFIELD(/*VPSLLVQYrr_VPSRLVQYrr*/ 26030) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #835
  {DBGFIELD(/*VPSLLVQrr_VPSRLVQrr*/ 26052) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #836
  {DBGFIELD(/*JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX*/ 26072) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #837
  {DBGFIELD(/*FINCSTP*/ 26134)            1, false, false, false, 548, 6,  1, 1,  0, 0}, // #838
  {DBGFIELD(/*ANDN32rr_ANDN32rr_EVEX_ANDN32rr_NF_ANDN64rr_ANDN64rr_EVEX_ANDN64rr_NF*/ 26142) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #839
  {DBGFIELD(/*VPBLENDDYrri*/ 26212)       1, false, false, false, 109, 4,  1, 1,  0, 0}, // #840
  {DBGFIELD(/*VPBLENDDrri*/ 26225)        1, false, false, false, 109, 4,  1, 1,  0, 0}, // #841
  {DBGFIELD(/*SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL*/ 26237) 7, false, false, false, 1504, 11, 23, 1,  0, 0}, // #842
  {DBGFIELD(/*VPSLLVQrm_VPSRLVQrm*/ 26274) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #843
  {DBGFIELD(/*VPSLLVQYrm_VPSRLVQYrm*/ 26294) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #844
  {DBGFIELD(/*PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX*/ 26316) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #845
  {DBGFIELD(/*PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm*/ 26408) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #846
  {DBGFIELD(/*VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm*/ 26684) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #847
  {DBGFIELD(/*JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX*/ 26723) 2, false, false, false, 1364, 10,  3, 1,  0, 0}, // #848
  {DBGFIELD(/*ANDN32rm_ANDN32rm_EVEX_ANDN32rm_NF_ANDN64rm_ANDN64rm_EVEX_ANDN64rm_NF*/ 26785) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #849
  {DBGFIELD(/*MOVBE16rm_MOVBE16rm_EVEX_MOVBE32rm_MOVBE32rm_EVEX_MOVBE64rm_MOVBE64rm_EVEX*/ 26855) 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #850
  {DBGFIELD(/*VINSERTI128rmi*/ 26930)     2, false, false, false, 102, 6, 22, 1,  6, 1}, // #851
  {DBGFIELD(/*VPBLENDDrmi*/ 26945)        2, false, false, false, 102, 6,  7, 1,  6, 1}, // #852
  {DBGFIELD(/*VPBLENDDYrmi*/ 26957)       2, false, false, false, 102, 6, 22, 1,  6, 1}, // #853
  {DBGFIELD(/*POP32r_POP64r*/ 26970)      1, false, false, false, 39, 3, 10, 1,  0, 0}, // #854
  {DBGFIELD(/*MOVBE32mr_MOVBE32mr_EVEX_MOVBE64mr_MOVBE64mr_EVEX*/ 26984) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #855
  {DBGFIELD(/*MOVBE16mr*/ 27034)          3, false, false, false, 1515, 8,  2, 1,  0, 0}, // #856
  {DBGFIELD(/*PUSH16r_PUSH32r_PUSH64r_PUSH64i8*/ 27044) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #857
  {DBGFIELD(/*XGETBV*/ 27077)             23, false, false, false, 1523, 10, 14, 1,  0, 0}, // #858
  {DBGFIELD(/*MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm*/ 27084) 3, false, false, false, 1533, 11,  2, 1,  6, 1}, // #859
  {DBGFIELD(/*LRET64_RET32*/ 27129)       2, false, false, false, 229, 7,  3, 1,  0, 0}, // #860
  {DBGFIELD(/*ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1*/ 27142) 2, false, false, false, 759, 5,  1, 1,  0, 0}, // #861
  {DBGFIELD(/*PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX*/ 27204) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #862
  {DBGFIELD(/*VPBROADCASTBrr_VPBROADCASTWrr*/ 27296) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #863
  {DBGFIELD(/*VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm*/ 27326) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #864
  {DBGFIELD(/*MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr*/ 27378) 2, false, false, false, 1544, 9, 14, 1,  0, 0}, // #865
  {DBGFIELD(/*CLDEMOTE*/ 27423)           3, false, false, false, 856, 5,  6, 1,  0, 0}, // #866
  {DBGFIELD(/*VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm*/ 27432) 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #867
  {DBGFIELD(/*LAR16rr_LAR32rr_LAR64rr*/ 27494) 22, false, false, false, 1553, 15, 60, 1,  0, 0}, // #868
  {DBGFIELD(/*LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm*/ 27518) 13, false, false, false, 1568, 15, 61, 1,  0, 0}, // #869
  {DBGFIELD(/*MUL_FPrST0_MUL_FST0r_MUL_FrST0*/ 27566) 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #870
  {DBGFIELD(/*VPCMPGTQYrm*/ 27597)        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #871
  {DBGFIELD(/*VCVTSI642SSrr_VCVTSI642SSrr_Int*/ 27609) 3, false, false, false, 896, 10,  7, 1,  7, 1}, // #872
  {DBGFIELD(/*STR16r_STR32r_STR64r*/ 27641) 2, false, false, false, 472, 8, 10, 1,  0, 0}, // #873
  {DBGFIELD(/*XSETBV*/ 27662)             54, false, false, false, 1583, 12, 10, 1,  0, 0}, // #874
  {DBGFIELD(/*RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX*/ 27669) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #875
  {DBGFIELD(/*RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND*/ 27759) 9, false, false, false, 744, 10, 39, 2,  0, 0}, // #876
  {DBGFIELD(/*RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND*/ 27806) 2, false, false, false, 759, 5, 12, 1,  0, 0}, // #877
  {DBGFIELD(/*RCL8rCL*/ 28016)            9, false, false, false, 744, 10,  4, 1,  0, 0}, // #878
  {DBGFIELD(/*RCR8rCL*/ 28024)            10, false, false, false, 1595, 10, 22, 1,  0, 0}, // #879
  {DBGFIELD(/*RDTSC*/ 28032)              15, false, false, false, 1605, 12, 13, 1,  0, 0}, // #880
  {DBGFIELD(/*XRSTOR_XRSTOR64_XRSTORS_XRSTORS64*/ 28038) 31, false, false, false, 1617, 15, 62, 1,  0, 0}, // #881
  {DBGFIELD(/*DIV_FPrST0_DIV_FST0r_DIV_FrST0*/ 28072) 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #882
  {DBGFIELD(/*DIVR_F32m_DIVR_F64m*/ 28103) 2, false, false, false, 1431, 13, 63, 1,  0, 0}, // #883
  {DBGFIELD(/*DIVR_FI16m_DIVR_FI32m*/ 28123) 3, false, false, false, 1444, 16, 64, 1,  0, 0}, // #884
  {DBGFIELD(/*DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0*/ 28145) 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #885
  {DBGFIELD(/*XSAVE64*/ 28179)            140, false, false, false, 1632, 16, 65, 1,  0, 0}, // #886
  {DBGFIELD(/*XSAVE*/ 28187)              140, false, false, false, 1632, 16, 52, 1,  0, 0}, // #887
  {DBGFIELD(/*XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64*/ 28193) 156, false, false, false, 1648, 16, 66, 1,  0, 0}, // #888
  {DBGFIELD(/*VMCLEARm*/ 28245)           18, false, false, false, 1664, 19, 67, 1,  0, 0}, // #889
  {DBGFIELD(/*FLDENVm*/ 28254)            64, false, false, false, 1683, 13, 68, 1,  0, 0}, // #890
  {DBGFIELD(/*FXRSTOR64*/ 28262)          88, false, false, false, 1696, 16, 56, 1,  0, 0}, // #891
  {DBGFIELD(/*FSTENVm*/ 28272)            100, false, false, false, 1712, 18, 69, 1,  0, 0}, // #892
  {DBGFIELD(/*VGATHERDPDrm_VPGATHERDQrm*/ 28280) 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #893
  {DBGFIELD(/*VGATHERDPDYrm_VPGATHERDQYrm*/ 28306) 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #894
  {DBGFIELD(/*VGATHERDPSrm_VPGATHERDDrm*/ 28334) 8, false, false, false, 1743, 13, 74, 2,  0, 0}, // #895
  {DBGFIELD(/*VGATHERDPSYrm_VPGATHERDDYrm*/ 28360) 12, false, false, false, 1756, 13, 76, 2,  0, 0}, // #896
  {DBGFIELD(/*VGATHERQPDrm_VPGATHERQQrm*/ 28388) 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #897
  {DBGFIELD(/*VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm*/ 28414) 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #898
  {DBGFIELD(/*VGATHERQPSrm_VPGATHERQDrm*/ 28470) 5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #899
  {DBGFIELD(/*VPXORYrr*/ 28496)           1, false, false, false, 109, 4,  1, 1,  0, 0}, // #900
  {DBGFIELD(/*VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr*/ 28505) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #901
  {DBGFIELD(/*VPCMPGTQYrr*/ 28581)        1, false, false, false, 92, 9,  6, 1,  0, 0}, // #902
  {DBGFIELD(/*ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8*/ 28593) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #903
  {DBGFIELD(/*ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32*/ 28647) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #904
  {DBGFIELD(/*MOVBE16mr_EVEX*/ 28715)     2, false, false, false, 35, 4,  2, 1,  0, 0}, // #905
  {DBGFIELD(/*FCOM32m_FCOM64m_FCOMP32m_FCOMP64m*/ 28730) 2, false, false, false, 392, 13,  7, 1,  0, 0}, // #906
  {DBGFIELD(/*LRET64*/ 28764)             3, false, false, false, 1769, 10,  4, 1,  0, 0}, // #907
  {DBGFIELD(/*POPF64*/ 28771)             7, false, false, false, 1779, 12, 10, 1,  0, 0}, // #908
  {DBGFIELD(/*VGATHERQPDYrm_VPGATHERQQYrm*/ 28778) 8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #909
  {DBGFIELD(/*PCMPEQQrr*/ 28806)          1, false, false, false, 108, 5,  1, 1,  0, 0}, // #910
  {DBGFIELD(/*PCMPGTQrr*/ 28816)          1, false, false, false, 92, 9,  6, 1,  0, 0}, // #911
  {DBGFIELD(/*PCMPEQQrm*/ 28826)          2, false, false, false, 101, 7,  7, 1,  6, 1}, // #912
  {DBGFIELD(/*PCMPGTQrm*/ 28836)          2, false, false, false, 526, 11,  9, 1,  6, 1}, // #913
  {DBGFIELD(/*MOV16rm*/ 28846)            2, false, false, false, 104, 4,  3, 1,  0, 0}, // #914
  {DBGFIELD(/*POP16rmm*/ 28854)           3, false, false, false, 53, 5,  2, 1,  0, 0}, // #915
  {DBGFIELD(/*PUSH16rmm_PUSH32rmm*/ 28863) 3, false, false, false, 53, 5,  2, 1,  0, 0}, // #916
  {DBGFIELD(/*PUSHF16*/ 28883)            4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #917
  {DBGFIELD(/*LAHF*/ 28891)               1, false, false, false, 12, 5,  6, 1,  0, 0}, // #918
  {DBGFIELD(/*ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF*/ 28896) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #919
  {DBGFIELD(/*ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND*/ 29384) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #920
  {DBGFIELD(/*ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX*/ 29946) 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #921
  {DBGFIELD(/*ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF*/ 30110) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #922
  {DBGFIELD(/*ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX*/ 30196) 5, false, false, false, 64, 9,  2, 1,  0, 0}, // #923
  {DBGFIELD(/*ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND*/ 30522) 2, false, false, false, 73, 5,  8, 1,  1, 1}, // #924
  {DBGFIELD(/*ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX*/ 30770) 5, false, false, false, 64, 9,  2, 1,  2, 2}, // #925
  {DBGFIELD(/*DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX*/ 30872) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #926
  {DBGFIELD(/*DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND*/ 31285) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #927
  {DBGFIELD(/*CALL16r_CALL16r_NT_CALL32r_CALL32r_NT*/ 31594) 3, false, false, false, 1515, 8,  6, 1,  0, 0}, // #928
  {DBGFIELD(/*RET16_LRET16_LRET32*/ 31632) 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #929
  {DBGFIELD(/*IRET16_IRET32_IRET64*/ 31652) 2, false, false, false, 26, 9,  3, 1,  0, 0}, // #930
  {DBGFIELD(/*AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF*/ 31673) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #931
  {DBGFIELD(/*AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND*/ 32397) 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #932
  {DBGFIELD(/*AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX*/ 33218) 4, false, false, false, 58, 6,  2, 1,  2, 1}, // #933
  {DBGFIELD(/*AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF*/ 33456) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #934
  {DBGFIELD(/*SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND*/ 33581) 5, false, false, false, 809, 12,  2, 1,  0, 0}, // #935
  {DBGFIELD(/*SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND*/ 33969) 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #936
  {DBGFIELD(/*SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND*/ 34357) 6, false, false, false, 795, 14,  2, 1,  0, 0}, // #937
  {DBGFIELD(/*XADD16rr_XADD32rr_XADD64rr_XADD8rr*/ 34745) 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #938
  {DBGFIELD(/*CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80*/ 34780) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #939
  {DBGFIELD(/*MMX_MASKMOVQ_MMX_MASKMOVQ64*/ 34813) 4, false, false, false, 1791, 12,  2, 1,  0, 0}, // #940
  {DBGFIELD(/*MASKMOVDQU_MASKMOVDQU64*/ 34841) 2, false, false, false, 918, 5,  1, 1,  0, 0}, // #941
  {DBGFIELD(/*VMASKMOVDQU_VMASKMOVDQU64*/ 34865) 2, false, false, false, 918, 5,  1, 1,  0, 0}, // #942
  {DBGFIELD(/*VPMASKMOVDYrm*/ 34891)      2, false, false, false, 102, 6, 22, 1,  0, 0}, // #943
  {DBGFIELD(/*VPMASKMOVDrm*/ 34905)       2, false, false, false, 102, 6,  7, 1,  0, 0}, // #944
  {DBGFIELD(/*VPMASKMOVDYmr*/ 34918)      3, false, false, false, 861, 12, 21, 1,  0, 0}, // #945
  {DBGFIELD(/*VPMASKMOVDmr*/ 34932)       3, false, false, false, 861, 12, 21, 1,  0, 0}, // #946
  {DBGFIELD(/*VPMASKMOVQYmr*/ 34945)      3, false, false, false, 861, 12, 21, 1,  0, 0}, // #947
  {DBGFIELD(/*VPMASKMOVQmr*/ 34959)       3, false, false, false, 861, 12, 21, 1,  0, 0}, // #948
  {DBGFIELD(/*VPBROADCASTBrm_VPBROADCASTWrm*/ 34972) 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #949
  {DBGFIELD(/*VPGATHERDDYrm*/ 35002)      12, false, false, false, 1756, 13, 76, 2,  0, 0}, // #950
  {DBGFIELD(/*VPGATHERDDrm*/ 35016)       8, false, false, false, 1743, 13, 74, 2,  0, 0}, // #951
  {DBGFIELD(/*VPGATHERDQYrm*/ 35029)      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #952
  {DBGFIELD(/*VPGATHERDQrm*/ 35043)       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #953
  {DBGFIELD(/*VPGATHERQDYrm*/ 35056)      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #954
  {DBGFIELD(/*VPGATHERQDrm*/ 35070)       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #955
  {DBGFIELD(/*VPGATHERQQYrm*/ 35083)      8, false, false, false, 1743, 13, 72, 2,  0, 0}, // #956
  {DBGFIELD(/*VPGATHERQQrm*/ 35097)       5, false, false, false, 1730, 13, 70, 2,  0, 0}, // #957
  {DBGFIELD(/*VPERM2F128rri*/ 35110)      1, false, false, false, 92, 9,  6, 1,  0, 0}, // #958
  {DBGFIELD(/*VPERM2I128rri*/ 35124)      1, false, false, false, 92, 9,  6, 1,  0, 0}, // #959
  {DBGFIELD(/*VPERM2F128rmi*/ 35138)      2, false, false, false, 526, 11,  8, 1,  6, 1}, // #960
  {DBGFIELD(/*VPERM2I128rmi*/ 35152)      2, false, false, false, 526, 11,  8, 1,  6, 1}, // #961
  {DBGFIELD(/*VBROADCASTF128rm*/ 35166)   1, false, false, false, 39, 3,  7, 1,  0, 0}, // #962
  {DBGFIELD(/*VEXTRACTF128rri*/ 35183)    1, false, false, false, 92, 9,  6, 1,  0, 0}, // #963
  {DBGFIELD(/*VEXTRACTI128rri*/ 35199)    1, false, false, false, 92, 9,  6, 1,  0, 0}, // #964
  {DBGFIELD(/*VEXTRACTF128mri*/ 35215)    2, false, false, false, 35, 4,  2, 1,  0, 0}, // #965
  {DBGFIELD(/*VEXTRACTI128mri*/ 35231)    2, false, false, false, 35, 4,  2, 1,  0, 0}, // #966
  {DBGFIELD(/*VINSERTF128rri*/ 35247)     1, false, false, false, 92, 9,  6, 1,  0, 0}, // #967
  {DBGFIELD(/*VINSERTI128rri*/ 35262)     1, false, false, false, 92, 9,  6, 1,  0, 0}, // #968
  {DBGFIELD(/*CVTDQ2PDrr_VCVTDQ2PDrr*/ 35277) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #969
  {DBGFIELD(/*VCVTDQ2PDYrr*/ 35300)       2, false, false, false, 254, 10,  4, 1,  0, 0}, // #970
  {DBGFIELD(/*CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr*/ 35313) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #971
  {DBGFIELD(/*CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm*/ 35361) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #972
  {DBGFIELD(/*VCVTPD2DQYrr_VCVTTPD2DQYrr*/ 35409) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #973
  {DBGFIELD(/*VCVTPD2DQYrm_VCVTTPD2DQYrm*/ 35436) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #974
  {DBGFIELD(/*MMX_CVTPI2PDrr*/ 35463)     2, false, false, false, 254, 10,  3, 1,  0, 0}, // #975
  {DBGFIELD(/*MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr*/ 35478) 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #976
  {DBGFIELD(/*CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr*/ 35509) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #977
  {DBGFIELD(/*CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int*/ 35586) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #978
  {DBGFIELD(/*CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int*/ 35687) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #979
  {DBGFIELD(/*CVTSI2SDrr_CVTSI642SDrr*/ 35865) 2, false, false, false, 254, 10,  4, 1,  0, 1}, // #980
  {DBGFIELD(/*CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int*/ 35889) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #981
  {DBGFIELD(/*CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr*/ 35981) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #982
  {DBGFIELD(/*CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int*/ 36085) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #983
  {DBGFIELD(/*VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int*/ 36185) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #984
  {DBGFIELD(/*CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm*/ 36221) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #985
  {DBGFIELD(/*VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int*/ 36425) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #986
  {DBGFIELD(/*EXTRQ_EXTRQI*/ 36461)       1, false, false, false, 108, 5,  1, 1,  0, 0}, // #987
  {DBGFIELD(/*INSERTQ_INSERTQI*/ 36474)   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #988
  {DBGFIELD(/*SHA256MSG2rm*/ 36491)       3, false, false, false, 1533, 11, 24, 1,  6, 1}, // #989
  {DBGFIELD(/*SHA256MSG2rr*/ 36504)       2, false, false, false, 1544, 9,  3, 1,  0, 0}, // #990
  {DBGFIELD(/*SHA1MSG1rr_SHA256MSG1rr*/ 36517) 7, false, false, false, 1803, 11, 10, 1,  0, 0}, // #991
  {DBGFIELD(/*SHA1MSG1rm_SHA256MSG1rm*/ 36541) 8, false, false, false, 1814, 13,  2, 1,  6, 1}, // #992
  {DBGFIELD(/*SHA1MSG2rr*/ 36565)         7, false, false, false, 1827, 9,  3, 1,  0, 0}, // #993
  {DBGFIELD(/*SHA1MSG2rm*/ 36576)         8, false, false, false, 1836, 11, 24, 1,  6, 1}, // #994
  {DBGFIELD(/*SHA1NEXTErr*/ 36587)        3, false, false, false, 1847, 7,  6, 1,  0, 0}, // #995
  {DBGFIELD(/*SHA1NEXTErm*/ 36599)        4, false, false, false, 1854, 9,  7, 1,  6, 1}, // #996
  {DBGFIELD(/*SHA1RNDS4rri*/ 36611)       1, false, false, false, 92, 9,  3, 1,  0, 0}, // #997
  {DBGFIELD(/*SHA1RNDS4rmi*/ 36624)       2, false, false, false, 526, 11, 24, 1,  6, 1}, // #998
  {DBGFIELD(/*SHA256RNDS2rr*/ 36637)      1, false, false, false, 92, 9,  3, 1,  0, 0}, // #999
  {DBGFIELD(/*SHA256RNDS2rm*/ 36651)      2, false, false, false, 526, 11, 24, 1,  6, 1}, // #1000
  {DBGFIELD(/*XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar*/ 36665) 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1001
  {DBGFIELD(/*CVTDQ2PSrr_VCVTDQ2PSrr*/ 36727) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1002
  {DBGFIELD(/*VCVTDQ2PSYrr*/ 36750)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1003
  {DBGFIELD(/*CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr*/ 36763) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1004
  {DBGFIELD(/*MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16*/ 36811) 1, false, false, false, 39, 3, 10, 1,  0, 0}, // #1005
  {DBGFIELD(/*MOVBE16rm*/ 36867)          3, false, false, false, 1863, 7,  4, 1,  0, 0}, // #1006
  {DBGFIELD(/*MOVBE32mr_MOVBE64mr*/ 36877) 4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1007
  {DBGFIELD(/*ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32*/ 36897) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1008
  {DBGFIELD(/*MOVSX16rr16_MOVSX16rr32_MOVZX16rr16*/ 37063) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1009
  {DBGFIELD(/*MOV32ri_MOV32ri_alt_MOV64ri32*/ 37099) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1010
  {DBGFIELD(/*PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr*/ 37129) 1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1011
  {DBGFIELD(/*ADC8mr_SBB8mr*/ 37165)      6, false, false, false, 1409, 9, 24, 1, 12, 2}, // #1012
  {DBGFIELD(/*LEA32r_LEA64r_LEA64_32r*/ 37179) 1, false, false, false, 45, 8,  1, 1,  0, 0}, // #1013
  {DBGFIELD(/*LEA16r*/ 37203)             2, false, false, false, 472, 8, 12, 1,  0, 0}, // #1014
  {DBGFIELD(/*LCMPXCHG8*/ 37210)          6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1015
  {DBGFIELD(/*LCMPXCHG16B*/ 37220)        6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1016
  {DBGFIELD(/*XCHG8rr_XCHG16rr_XCHG16ar*/ 37232) 3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1017
  {DBGFIELD(/*XCHG8rm_XCHG16rm*/ 37258)   8, false, false, false, 1870, 9, 78, 2,  0, 0}, // #1018
  {DBGFIELD(/*POPCNT16rr*/ 37275)         1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1019
  {DBGFIELD(/*LZCNT16rr*/ 37286)          1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1020
  {DBGFIELD(/*TZCNT16rr*/ 37296)          1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1021
  {DBGFIELD(/*RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1*/ 37306) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1022
  {DBGFIELD(/*RCR8mi_RCR16mi_RCR32mi_RCR64mi*/ 37368) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1023
  {DBGFIELD(/*RCL8mi_RCL16mi_RCL32mi_RCL64mi*/ 37399) 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1024
  {DBGFIELD(/*RCR16rCL_RCR32rCL_RCR64rCL*/ 37430) 7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1025
  {DBGFIELD(/*RCR8mCL_RCR16mCL_RCR32mCL_RCR64mCL*/ 37457) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #1026
  {DBGFIELD(/*RCL16rCL_RCL32rCL_RCL64rCL*/ 37492) 7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1027
  {DBGFIELD(/*RCL8mCL_RCL16mCL_RCL32mCL_RCL64mCL*/ 37519) 10, false, false, false, 730, 14, 37, 2,  0, 0}, // #1028
  {DBGFIELD(/*MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr*/ 37554) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1029
  {DBGFIELD(/*MMX_MOVQ2FR64rr_MMX_MOVQ2DQrr*/ 37592) 2, false, false, false, 873, 9,  6, 1,  0, 0}, // #1030
  {DBGFIELD(/*MMX_MOVD64rr_MMX_MOVD64to64rr*/ 37622) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1031
  {DBGFIELD(/*EXTRQ*/ 37652)              1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1032
  {DBGFIELD(/*INSERTQ*/ 37658)            1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1033
  {DBGFIELD(/*PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr*/ 37666) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1034
  {DBGFIELD(/*MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr*/ 37979) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1035
  {DBGFIELD(/*VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr*/ 38111) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1036
  {DBGFIELD(/*MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm*/ 38298) 3, false, false, false, 264, 12, 41, 1,  0, 0}, // #1037
  {DBGFIELD(/*MMX_CVTPI2PDrm*/ 38329)     2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1038
  {DBGFIELD(/*SHA1MSG1rr*/ 38344)         2, false, false, false, 255, 9, 12, 1,  0, 0}, // #1039
  {DBGFIELD(/*SHA1MSG1rm*/ 38355)         3, false, false, false, 265, 11, 22, 1,  6, 1}, // #1040
  {DBGFIELD(/*VPERMPSYrm*/ 38366)         2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1041
  {DBGFIELD(/*VPERMPDYri*/ 38377)         1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1042
  {DBGFIELD(/*VPERMQYri*/ 38388)          1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1043
  {DBGFIELD(/*VPERMPDYmi*/ 38398)         2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1044
  {DBGFIELD(/*VPERMQYmi*/ 38409)          2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1045
  {DBGFIELD(/*VPERMDYrm*/ 38419)          2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1046
  {DBGFIELD(/*SFENCE*/ 38429)             2, false, false, false, 35, 4, 12, 1,  0, 0}, // #1047
  {DBGFIELD(/*MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV*/ 38436) 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1048
  {DBGFIELD(/*MOVSX32rr32*/ 38476)        1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1049
  {DBGFIELD(/*XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV*/ 38488) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1050
  {DBGFIELD(/*CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV*/ 38536) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1051
  {DBGFIELD(/*VXORPSrr_VXORPDrr*/ 38614)  1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1052
  {DBGFIELD(/*VANDNPSrr_VANDNPDrr*/ 38632) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1053
  {DBGFIELD(/*VANDNPSYrr_VANDNPDYrr*/ 38652) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1054
  {DBGFIELD(/*VPXORrr*/ 38674)            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1055
  {DBGFIELD(/*VPANDNrr*/ 38682)           1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1056
  {DBGFIELD(/*VPANDNYrr*/ 38691)          1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD(/*VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr*/ 38701) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD(/*KADDBkk_KADDDkk_KADDQkk_KADDWkk_KANDBkk_KANDDkk_KANDQkk_KANDWkk_KANDNBkk_KANDNDkk_KANDNQkk_KANDNWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KORTESTBkk_KORTESTDkk_KORTESTQkk_KORTESTWkk_KTESTBkk_KTESTDkk_KTESTQkk_KTESTWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk*/ 38770) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1059
  {DBGFIELD(/*KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk*/ 39078) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1060
  {DBGFIELD(/*KUNPCKBWkk_KUNPCKDQkk_KUNPCKWDkk*/ 39142) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1061
  {DBGFIELD(/*KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk*/ 39175) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1062
  {DBGFIELD(/*KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr*/ 39207) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1063
  {DBGFIELD(/*VALIGNDZrri_VALIGNQZrri*/ 39239) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1064
  {DBGFIELD(/*VALIGNDZ128rri_VALIGNQZ128rri*/ 39263) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1065
  {DBGFIELD(/*VALIGNDZ256rri_VALIGNQZ256rri*/ 39293) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1066
  {DBGFIELD(/*VPERMPSYrr*/ 39323)         1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1067
  {DBGFIELD(/*VPERMDYrr*/ 39334)          1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1068
  {DBGFIELD(/*VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz*/ 39344) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1069
  {DBGFIELD(/*VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz*/ 39740) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1070
  {DBGFIELD(/*VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz*/ 39962) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1071
  {DBGFIELD(/*VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz*/ 40206) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1072
  {DBGFIELD(/*VSCALEFSDZrrb_Int_VSCALEFSSZrrb_Int*/ 40276) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1073
  {DBGFIELD(/*VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz*/ 40312) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1074
  {DBGFIELD(/*VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz*/ 40606) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD(/*VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz*/ 40792) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1076
  {DBGFIELD(/*VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz*/ 40840) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1077
  {DBGFIELD(/*VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz*/ 40888) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1078
  {DBGFIELD(/*VPDPBUSDSYrr_VPDPBUSDSZ256rr_VPDPBUSDSZ256rrk_VPDPBUSDSZ256rrkz_VPDPBUSDYrr_VPDPBUSDZ256rr_VPDPBUSDZ256rrk_VPDPBUSDZ256rrkz_VPDPWSSDSYrr_VPDPWSSDSZ256rr_VPDPWSSDSZ256rrk_VPDPWSSDSZ256rrkz_VPDPWSSDYrr_VPDPWSSDZ256rr_VPDPWSSDZ256rrk_VPDPWSSDZ256rrkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz*/ 40927) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1079
  {DBGFIELD(/*VPDPBUSDSZ128rr_VPDPBUSDSZ128rrk_VPDPBUSDSZ128rrkz_VPDPBUSDSrr_VPDPBUSDZ128rr_VPDPBUSDZ128rrk_VPDPBUSDZ128rrkz_VPDPBUSDrr_VPDPWSSDSZ128rr_VPDPWSSDSZ128rrk_VPDPWSSDSZ128rrkz_VPDPWSSDSrr_VPDPWSSDZ128rr_VPDPWSSDZ128rrk_VPDPWSSDZ128rrkz_VPDPWSSDrr_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz*/ 41283) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1080
  {DBGFIELD(/*VPDPBUSDSZrr_VPDPBUSDSZrrk_VPDPBUSDSZrrkz_VPDPBUSDZrr_VPDPBUSDZrrk_VPDPBUSDZrrkz_VPDPWSSDSZrr_VPDPWSSDSZrrk_VPDPWSSDSZrrkz_VPDPWSSDZrr_VPDPWSSDZrrk_VPDPWSSDZrrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz*/ 41635) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1081
  {DBGFIELD(/*VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk*/ 41887) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1082
  {DBGFIELD(/*VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz*/ 42496) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1083
  {DBGFIELD(/*VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz*/ 43066) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1084
  {DBGFIELD(/*PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr*/ 43528) 2, false, false, false, 718, 7, 12, 1,  0, 0}, // #1085
  {DBGFIELD(/*VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz*/ 44042) 2, false, false, false, 254, 10, 14, 1,  0, 0}, // #1086
  {DBGFIELD(/*VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz*/ 44500) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1087
  {DBGFIELD(/*VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri*/ 44797) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1088
  {DBGFIELD(/*PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri*/ 44847) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1089
  {DBGFIELD(/*VPSLLDQZri_VPSRLDQZri*/ 44885) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1090
  {DBGFIELD(/*VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz*/ 44907) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1091
  {DBGFIELD(/*VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz*/ 44963) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1092
  {DBGFIELD(/*VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz*/ 45008) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1093
  {DBGFIELD(/*VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz*/ 45044) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1094
  {DBGFIELD(/*VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz*/ 45224) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1095
  {DBGFIELD(/*VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz*/ 45404) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1096
  {DBGFIELD(/*VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz*/ 45548) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1097
  {DBGFIELD(/*VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz*/ 45716) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1098
  {DBGFIELD(/*VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz*/ 45884) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1099
  {DBGFIELD(/*VFMSUB231SSZrkz_Int*/ 46016) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1100
  {DBGFIELD(/*VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz*/ 46036) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1101
  {DBGFIELD(/*VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz*/ 46414) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1102
  {DBGFIELD(/*VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz*/ 46792) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD(/*PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri*/ 47089) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1104
  {DBGFIELD(/*VPALIGNRYrri_VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz*/ 47163) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1105
  {DBGFIELD(/*VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz*/ 47227) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1106
  {DBGFIELD(/*PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr*/ 47269) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1107
  {DBGFIELD(/*VPACKSSDWYrr_VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBYrr_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWYrr_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBYrr_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz*/ 47565) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1108
  {DBGFIELD(/*VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz*/ 47821) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1109
  {DBGFIELD(/*CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz*/ 47989) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1110
  {DBGFIELD(/*CMPPSrri_VCMPPSrri*/ 48182) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1111
  {DBGFIELD(/*CMPSDrri_CMPSDrri_Int_VCMPSDrri_VCMPSDrri_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrrk_Int_VMAXSDZrrkz_Int_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrrk_Int_VMINSDZrrkz_Int_VMINSDrr_Int*/ 48201) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1112
  {DBGFIELD(/*CMPSSrri_CMPSSrri_Int_VCMPSSrri_VCMPSSrri_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrrk_Int_VMAXSSZrrkz_Int_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrrk_Int_VMINSSZrrkz_Int_VMINSSrr_Int*/ 48387) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1113
  {DBGFIELD(/*VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz*/ 48573) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1114
  {DBGFIELD(/*VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz*/ 48753) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1115
  {DBGFIELD(/*VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz*/ 48933) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1116
  {DBGFIELD(/*VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz*/ 49077) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1117
  {DBGFIELD(/*VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz*/ 49251) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1118
  {DBGFIELD(/*VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz*/ 49461) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1119
  {DBGFIELD(/*VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz*/ 49509) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1120
  {DBGFIELD(/*VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz*/ 49557) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1121
  {DBGFIELD(/*PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBDrr_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBQrr_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXBWrr_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXDQrr_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWDrr_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVSXWQrr_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBDrr_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBQrr_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXBWrr_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXDQrr_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWDrr_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz_VPMOVZXWQrr*/ 49596) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1122
  {DBGFIELD(/*VPMOVSXBDYrr_VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQYrr_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWYrr_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQYrr_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDYrr_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQYrr_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDYrr_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQYrr_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWYrr_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQYrr_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDYrr_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQYrr_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQDZ256rr_VPMOVQDZ256rrk_VPMOVQDZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVUSQWZ256rr_VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz*/ 50484) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1123
  {DBGFIELD(/*VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz*/ 52980) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1124
  {DBGFIELD(/*VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQDZrr_VPMOVQDZrrk_VPMOVQDZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz*/ 53484) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1125
  {DBGFIELD(/*VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk*/ 54186) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1126
  {DBGFIELD(/*VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk*/ 54318) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1127
  {DBGFIELD(/*VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk*/ 54574) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1128
  {DBGFIELD(/*VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz*/ 54682) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1129
  {DBGFIELD(/*VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz*/ 54796) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1130
  {DBGFIELD(/*VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz*/ 54910) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1131
  {DBGFIELD(/*VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz*/ 55006) 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1132
  {DBGFIELD(/*VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz*/ 55108) 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1133
  {DBGFIELD(/*VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz*/ 55210) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1134
  {DBGFIELD(/*VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz*/ 55294) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1135
  {DBGFIELD(/*VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz*/ 55422) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1136
  {DBGFIELD(/*VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz*/ 55524) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1137
  {DBGFIELD(/*VPERMI2PDZ128rr_VPERMI2PDZ128rrk_VPERMI2PDZ128rrkz_VPERMI2PSZ128rr_VPERMI2PSZ128rrk_VPERMI2PSZ128rrkz_VPERMT2PDZ128rr_VPERMT2PDZ128rrk_VPERMT2PDZ128rrkz_VPERMT2PSZ128rr_VPERMT2PSZ128rrk_VPERMT2PSZ128rrkz*/ 55608) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1138
  {DBGFIELD(/*VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz_VPERMI2BZ128rr_VPERMI2BZ128rrk_VPERMI2BZ128rrkz_VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2BZ128rr_VPERMT2BZ128rrk_VPERMT2BZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz*/ 55812) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1139
  {DBGFIELD(/*VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz*/ 56196) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1140
  {DBGFIELD(/*VPERMI2PDZ256rr_VPERMI2PDZ256rrk_VPERMI2PDZ256rrkz_VPERMI2PSZ256rr_VPERMI2PSZ256rrk_VPERMI2PSZ256rrkz_VPERMT2PDZ256rr_VPERMT2PDZ256rrk_VPERMT2PDZ256rrkz_VPERMT2PSZ256rr_VPERMT2PSZ256rrk_VPERMT2PSZ256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz*/ 56622) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1141
  {DBGFIELD(/*VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2BZ256rr_VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2BZ256rr_VPERMT2BZ256rrk_VPERMT2BZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz*/ 56916) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1142
  {DBGFIELD(/*VPERMI2PDZrr_VPERMI2PDZrrk_VPERMI2PDZrrkz_VPERMI2PSZrr_VPERMI2PSZrrk_VPERMI2PSZrrkz_VPERMT2PDZrr_VPERMT2PDZrrk_VPERMT2PDZrrkz_VPERMT2PSZrr_VPERMT2PSZrrk_VPERMT2PSZrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz*/ 57912) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1143
  {DBGFIELD(/*VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2BZrr_VPERMI2BZrrk_VPERMI2BZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2BZrr_VPERMT2BZrrk_VPERMT2BZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz*/ 58152) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1144
  {DBGFIELD(/*VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz*/ 58935) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1145
  {DBGFIELD(/*VXORPSZ128rr_VXORPDZ128rr_VANDNPSZ128rr_VANDNPDZ128rr*/ 59751) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1146
  {DBGFIELD(/*VXORPSZ256rr_VXORPDZ256rr_VANDNPSZ256rr_VANDNPDZ256rr*/ 59805) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1147
  {DBGFIELD(/*VXORPSZrr_VXORPDZrr_VANDNPSZrr_VANDNPDZrr*/ 59859) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1148
  {DBGFIELD(/*VPXORDZ128rr_VPXORQZ128rr_VPANDNDZ128rr_VPANDNQZ128rr*/ 59901) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1149
  {DBGFIELD(/*VPXORDZ256rr_VPXORQZ256rr_VPANDNDZ256rr_VPANDNQZ256rr*/ 59955) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1150
  {DBGFIELD(/*VPXORDZrr_VPXORQZrr_VPANDNDZrr_VPANDNQZrr*/ 60009) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1151
  {DBGFIELD(/*VPSUBBZ128rr_VPSUBWZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPCMPGTBZ128rr_VPCMPGTWZ128rr_VPCMPGTDZ128rr_VPCMPGTQZ128rr*/ 60051) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1152
  {DBGFIELD(/*VPSUBBZ256rr_VPSUBWZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPCMPGTBZ256rr_VPCMPGTWZ256rr_VPCMPGTDZ256rr_VPCMPGTQZ256rr*/ 60163) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1153
  {DBGFIELD(/*VPSUBBZrr_VPSUBWZrr_VPSUBDZrr_VPSUBQZrr_VPCMPGTBZrr_VPCMPGTWZrr_VPCMPGTDZrr_VPCMPGTQZrr*/ 60275) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1154
  {DBGFIELD(/*LSL16rr_LSL32rr_LSL64rr*/ 60363) 15, false, false, false, 1889, 15, 56, 1,  0, 0}, // #1155
  {DBGFIELD(/*LXADD8_LXADD16_LXADD32_LXADD64*/ 60387) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #1156
  {DBGFIELD(/*BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr*/ 60418) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1157
  {DBGFIELD(/*BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm*/ 60606) 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #1158
  {DBGFIELD(/*ADC64ri32_SBB64ri32*/ 60794) 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1159
  {DBGFIELD(/*CRC32r32r16*/ 60814)        1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1160
  {DBGFIELD(/*CRC32r32r32*/ 60826)        1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1161
  {DBGFIELD(/*CRC32r64r64*/ 60838)        1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1162
  {DBGFIELD(/*SAHF*/ 60850)               2, false, false, false, 759, 5, 14, 1,  0, 0}, // #1163
  {DBGFIELD(/*BEXTRI32ri_BEXTRI64ri*/ 60855) 2, false, false, false, 163, 10,  3, 1,  0, 0}, // #1164
  {DBGFIELD(/*BEXTRI32mi_BEXTRI64mi*/ 60877) 3, false, false, false, 151, 12,  8, 1,  0, 0}, // #1165
  {DBGFIELD(/*RCR8ri*/ 60899)             3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1166
  {DBGFIELD(/*RCL16rCL*/ 60906)           7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1167
  {DBGFIELD(/*RCR16ri*/ 60915)            3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1168
  {DBGFIELD(/*RCR32rCL_RCR64rCL*/ 60923)  7, false, false, false, 1879, 10,  7, 1,  0, 0}, // #1169
  {DBGFIELD(/*RCL16ri*/ 60941)            3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1170
  {DBGFIELD(/*RCL32ri_RCL64ri*/ 60949)    3, false, false, false, 754, 5, 12, 1,  0, 0}, // #1171
  {DBGFIELD(/*SHLD16rrCL*/ 60965)         3, false, false, false, 492, 10, 10, 1,  0, 0}, // #1172
  {DBGFIELD(/*SHLD32rrCL_SHRD32rrCL*/ 60976) 3, false, false, false, 492, 10, 10, 1,  0, 0}, // #1173
  {DBGFIELD(/*VMOVUPDYmr_VMOVUPSYmr*/ 60998) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1174
  {DBGFIELD(/*TST_F*/ 61020)              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #1175
  {DBGFIELD(/*VDPPSrri*/ 61026)           6, false, false, false, 361, 11, 21, 1,  0, 0}, // #1176
  {DBGFIELD(/*VFRCZPDrr_VFRCZPSrr*/ 61035) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1177
  {DBGFIELD(/*VFRCZSDrr_VFRCZSSrr*/ 61055) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1178
  {DBGFIELD(/*VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm*/ 61075) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1179
  {DBGFIELD(/*VFRCZPSYrr_VFRCZPDYrr*/ 61115) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1180
  {DBGFIELD(/*VFRCZPSYrm_VFRCZPDYrm*/ 61137) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #1181
  {DBGFIELD(/*MMX_CVTTPD2PIrr*/ 61159)    2, false, false, false, 254, 10,  7, 1,  0, 0}, // #1182
  {DBGFIELD(/*CVTSI2SSrr*/ 61175)         2, false, false, false, 254, 10,  4, 1,  0, 1}, // #1183
  {DBGFIELD(/*VMOVDQUYmr*/ 61186)         2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1184
  {DBGFIELD(/*MOVDQArr*/ 61197)           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1185
  {DBGFIELD(/*MMX_MOVQ2DQrr*/ 61206)      2, false, false, false, 873, 9,  6, 1,  0, 0}, // #1186
  {DBGFIELD(/*VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr*/ 61220) 2, false, false, false, 120, 5,  9, 1,  0, 0}, // #1187
  {DBGFIELD(/*VPPERMrrr_VPPERMrrr_REV*/ 61270) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1188
  {DBGFIELD(/*VPPERMrrm*/ 61294)          2, false, false, false, 78, 8,  7, 1, 10, 2}, // #1189
  {DBGFIELD(/*VPPERMrmr*/ 61304)          2, false, false, false, 78, 8,  7, 1,  8, 2}, // #1190
  {DBGFIELD(/*PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr*/ 61314) 3, false, false, false, 712, 6, 12, 1,  0, 0}, // #1191
  {DBGFIELD(/*PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm*/ 61414) 4, false, false, false, 704, 8, 22, 1,  6, 1}, // #1192
  {DBGFIELD(/*VPCLMULQDQrri*/ 61514)      1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1193
  {DBGFIELD(/*ANDNPSrr_ANDNPDrr*/ 61528)  1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1194
  {DBGFIELD(/*MMX_PXORrr_MMX_PANDNrr*/ 61546) 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1195
  {DBGFIELD(/*PANDNrr*/ 61569)            1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1196
  {DBGFIELD(/*MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr*/ 61577) 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1197
  {DBGFIELD(/*MMX_PSUBQrr*/ 61655)        1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1198
  {DBGFIELD(/*LCMPXCHG16_LCMPXCHG32_LCMPXCHG64*/ 61667) 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1199
  {DBGFIELD(/*CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr*/ 61700) 5, false, false, false, 238, 5,  6, 1,  0, 0}, // #1200
  {DBGFIELD(/*LCMPXCHG8B*/ 61736)         6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1201
  {DBGFIELD(/*INC8m_INC16m_INC32m_INC64m_DEC8m_DEC16m_DEC32m_DEC64m_NOT8m_NOT16m_NOT32m_NOT64m_NEG8m_NEG16m_NEG32m_NEG64m*/ 61747) 4, false, false, false, 58, 6,  2, 1,  0, 0}, // #1202
  {DBGFIELD(/*XCHG8rr*/ 61855)            3, false, false, false, 236, 2, 12, 1,  0, 0}, // #1203
  {DBGFIELD(/*MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr*/ 61863) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1204
  {DBGFIELD(/*PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr*/ 61917) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1205
  {DBGFIELD(/*MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr*/ 61997) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1206
  {DBGFIELD(/*MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr*/ 62091) 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1207
  {DBGFIELD(/*CLAC_STAC*/ 62133)          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1208
  {DBGFIELD(/*PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr*/ 62143) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1209
  {DBGFIELD(/*VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr*/ 62203) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1210
  {DBGFIELD(/*ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0*/ 62243) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1211
  {DBGFIELD(/*MMX_PHADDSWrr_MMX_PHSUBSWrr*/ 62339) 3, false, false, false, 1904, 12,  6, 1,  0, 0}, // #1212
  {DBGFIELD(/*PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr*/ 62367) 3, false, false, false, 1916, 7, 12, 1,  0, 0}, // #1213
  {DBGFIELD(/*VPHADDSWYrr_VPHSUBSWYrr*/ 62409) 3, false, false, false, 1916, 7, 12, 1,  0, 0}, // #1214
  {DBGFIELD(/*MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm*/ 62433) 2, false, false, false, 243, 11, 22, 1,  6, 1}, // #1215
  {DBGFIELD(/*PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm*/ 62701) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1216
  {DBGFIELD(/*VCVTSS2SI64rr_VCVTTSS2SI64rr*/ 62821) 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #1217
  {DBGFIELD(/*VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int*/ 62850) 3, false, false, false, 906, 12,  7, 1,  0, 0}, // #1218
  {DBGFIELD(/*VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm*/ 62887) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #1219
  {DBGFIELD(/*MMX_PHADDSWrm_MMX_PHSUBSWrm*/ 62967) 4, false, false, false, 1923, 14,  8, 1,  6, 1}, // #1220
  {DBGFIELD(/*PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm*/ 62995) 4, false, false, false, 1937, 9, 22, 1,  6, 1}, // #1221
  {DBGFIELD(/*VPHADDSWYrm_VPHSUBSWYrm*/ 63037) 4, false, false, false, 1937, 9,  9, 1,  6, 1}, // #1222
  {DBGFIELD(/*XSAVEC_XSAVEC64_XSAVES_XSAVES64*/ 63061) 186, false, false, false, 1946, 16, 52, 1,  0, 0}, // #1223
  {DBGFIELD(/*PCMPGTBrr_PCMPGTDrr_PCMPGTWrr*/ 63093) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1224
  {DBGFIELD(/*VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr*/ 63123) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1225
  {DBGFIELD(/*VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr*/ 63156) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1226
  {DBGFIELD(/*KANDBkk_KANDDkk_KANDQkk_KANDWkk_KANDNBkk_KANDNDkk_KANDNQkk_KANDNWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk*/ 63192) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1227
  {DBGFIELD(/*KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk*/ 63388) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1228
  {DBGFIELD(/*KMOVBkk_EVEX_KMOVDkk_EVEX_KMOVQkk_EVEX_KMOVWkk_EVEX_VPMOVB2MZ128kr_VPMOVB2MZ256kr_VPMOVB2MZkr_VPMOVD2MZ128kr_VPMOVD2MZ256kr_VPMOVD2MZkr_VPMOVQ2MZ128kr_VPMOVQ2MZ256kr_VPMOVQ2MZkr_VPMOVW2MZ128kr_VPMOVW2MZ256kr_VPMOVW2MZkr*/ 63420) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1229
  {DBGFIELD(/*KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W*/ 63640) 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1230
  {DBGFIELD(/*KMOVBkr_EVEX_KMOVDkr_EVEX_KMOVQkr_EVEX_KMOVWkr_EVEX*/ 63682) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1231
  {DBGFIELD(/*VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz*/ 63734) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1232
  {DBGFIELD(/*VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz*/ 63836) 3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1233
  {DBGFIELD(/*VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz*/ 63938) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1234
  {DBGFIELD(/*VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz*/ 64336) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1235
  {DBGFIELD(/*VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz*/ 64734) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1236
  {DBGFIELD(/*VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz*/ 65054) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1237
  {DBGFIELD(/*VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz*/ 65258) 3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1238
  {DBGFIELD(/*KMOVBmk_EVEX_KMOVDmk_EVEX_KMOVQmk_EVEX_KMOVWmk_EVEX*/ 65462) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1239
  {DBGFIELD(/*VMOVDQU8Zmr_VMOVDQU8Zmrk*/ 65514) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1240
  {DBGFIELD(/*KMOVBrk_EVEX_KMOVDrk_EVEX_KMOVQrk_EVEX_KMOVWrk_EVEX*/ 65539) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1241
  {DBGFIELD(/*KORTESTBkk_KORTESTDkk_KORTESTQkk_KORTESTWkk_KTESTBkk_KTESTDkk_KTESTQkk_KTESTWkk*/ 65591) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1242
  {DBGFIELD(/*VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz*/ 65671) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1243
  {DBGFIELD(/*VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz*/ 65737) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1244
  {DBGFIELD(/*VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz*/ 65803) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1245
  {DBGFIELD(/*KSHIFTLBki_KSHIFTLDki_KSHIFTLQki_KSHIFTLWki_KSHIFTRBki_KSHIFTRDki_KSHIFTRQki_KSHIFTRWki*/ 65857) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1246
  {DBGFIELD(/*VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128ri_VFPCLASSPDZ128rik_VFPCLASSPSZ128ri_VFPCLASSPSZ128rik*/ 65945) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1247
  {DBGFIELD(/*VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256ri_VFPCLASSPDZ256rik_VFPCLASSPSZ256ri_VFPCLASSPSZ256rik*/ 66073) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1248
  {DBGFIELD(/*VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZri_VFPCLASSPDZrik_VFPCLASSPSZri_VFPCLASSPSZrik*/ 66201) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD(/*VCMPSDZrri_VCMPSDZrri_Int_VCMPSDZrrib_Int_VCMPSDZrribk_Int_VCMPSDZrrik_Int_VCMPSSZrri_VCMPSSZrri_Int_VCMPSSZrrib_Int_VCMPSSZrribk_Int_VCMPSSZrrik_Int_VFPCLASSSDZri_VFPCLASSSDZrik_VFPCLASSSSZri_VFPCLASSSSZrik*/ 66355) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1250
  {DBGFIELD(/*VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rrk_VPCMPGTDZ128rrk_VPCMPGTQZ128rrk_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik*/ 66563) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1251
  {DBGFIELD(/*VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rrk_VPCMPGTDZ256rrk_VPCMPGTQZ256rrk_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik*/ 66991) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1252
  {DBGFIELD(/*VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrrk_VPCMPGTDZrrk_VPCMPGTQZrrk_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik*/ 67419) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1253
  {DBGFIELD(/*VPCMPGTBZ128rr_VPCMPGTDZ128rr_VPCMPGTQZ128rr_VPCMPGTWZ128rr*/ 67763) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1254
  {DBGFIELD(/*VPCMPGTBZ256rr_VPCMPGTDZ256rr_VPCMPGTQZ256rr_VPCMPGTWZ256rr*/ 67823) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1255
  {DBGFIELD(/*VPCMPGTBZrr_VPCMPGTDZrr_VPCMPGTQZrr_VPCMPGTWZrr*/ 67883) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1256
  {DBGFIELD(/*VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr*/ 67931) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1257
  {DBGFIELD(/*VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr*/ 68055) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1258
  {DBGFIELD(/*VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz*/ 68155) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1259
  {DBGFIELD(/*VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz*/ 68371) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1260
  {DBGFIELD(/*VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz*/ 68587) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1261
  {DBGFIELD(/*VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz*/ 68816) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1262
  {DBGFIELD(/*VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr*/ 69032) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1263
  {DBGFIELD(/*VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr*/ 69088) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1264
  {DBGFIELD(/*VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz*/ 69144) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1265
  {DBGFIELD(/*VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz*/ 69720) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1266
  {DBGFIELD(/*VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz*/ 71256) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1267
  {DBGFIELD(/*VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk*/ 71880) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1268
  {DBGFIELD(/*VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz*/ 71961) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1269
  {DBGFIELD(/*VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz*/ 72066) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1270
  {DBGFIELD(/*VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr*/ 72282) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1271
  {DBGFIELD(/*VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz*/ 72356) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1272
  {DBGFIELD(/*VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz*/ 72572) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1273
  {DBGFIELD(/*VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int*/ 72677) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #1274
  {DBGFIELD(/*VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int*/ 72819) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #1275
  {DBGFIELD(/*VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrbk_Int_VCVTSS2SDZrrbkz_Int_VCVTSS2SDZrrk_Int_VCVTSS2SDZrrkz_Int_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int*/ 72992) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1276
  {DBGFIELD(/*VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz*/ 73170) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1277
  {DBGFIELD(/*VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk*/ 73227) 3, false, false, false, 853, 8,  2, 1,  0, 0}, // #1278
  {DBGFIELD(/*VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk*/ 73260) 3, false, false, false, 853, 8,  2, 1,  0, 0}, // #1279
  {DBGFIELD(/*VCVTPS2PHZmr_VCVTPS2PHZmrk*/ 73293) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1280
  {DBGFIELD(/*VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk*/ 73320) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1281
  {DBGFIELD(/*VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz*/ 74805) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1282
  {DBGFIELD(/*VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz*/ 75075) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1283
  {DBGFIELD(/*VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz*/ 75345) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1284
  {DBGFIELD(/*VMOV64toPQIZrm_VMOVQI2PQIZrm*/ 75570) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1285
  {DBGFIELD(/*VMOVDI2PDIZrm*/ 75599)      1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1286
  {DBGFIELD(/*VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int*/ 75613) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #1287
  {DBGFIELD(/*VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz*/ 75724) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1288
  {DBGFIELD(/*VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz*/ 75818) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1289
  {DBGFIELD(/*VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz*/ 75923) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1290
  {DBGFIELD(/*VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz*/ 76139) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1291
  {DBGFIELD(/*VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz*/ 76203) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1292
  {DBGFIELD(/*VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz*/ 76419) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1293
  {DBGFIELD(/*VCVTDQ2PDZrr_VCVTUDQ2PDZrr*/ 76524) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1294
  {DBGFIELD(/*VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr*/ 76551) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1295
  {DBGFIELD(/*VCVTPS2PDZrr*/ 76607)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1296
  {DBGFIELD(/*VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr*/ 76620) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1297
  {DBGFIELD(/*VCVTQQ2PSZrr_VCVTUQQ2PSZrr*/ 76676) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1298
  {DBGFIELD(/*VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz*/ 76703) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1299
  {DBGFIELD(/*VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz*/ 76913) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1300
  {DBGFIELD(/*VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz*/ 77102) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1301
  {DBGFIELD(/*VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz*/ 77162) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1302
  {DBGFIELD(/*VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz*/ 77382) 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1303
  {DBGFIELD(/*VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz*/ 77532) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1304
  {DBGFIELD(/*VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz*/ 77835) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1305
  {DBGFIELD(/*VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz*/ 78585) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1306
  {DBGFIELD(/*VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz*/ 78897) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1307
  {DBGFIELD(/*VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz*/ 78993) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1308
  {DBGFIELD(/*VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz*/ 79089) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1309
  {DBGFIELD(/*VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int*/ 79167) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #1310
  {DBGFIELD(/*KMOVBkm_KMOVBkm_EVEX_KMOVDkm_KMOVDkm_EVEX_KMOVQkm_KMOVQkm_EVEX_KMOVWkm_KMOVWkm_EVEX*/ 79379) 1, false, false, false, 39, 3, 10, 1,  0, 0}, // #1311
  {DBGFIELD(/*VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk*/ 79463) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1312
  {DBGFIELD(/*VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr*/ 79883) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1313
  {DBGFIELD(/*VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr*/ 79955) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1314
  {DBGFIELD(/*VPSCATTERDQZmr_VPSCATTERQDZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPSZmr_VSCATTERQPDZmr*/ 80027) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1315
  {DBGFIELD(/*VSCATTERDPSZmr*/ 80117)     2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1316
  {DBGFIELD(/*VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz*/ 80132) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1317
  {DBGFIELD(/*VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz*/ 80354) 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #1318
  {DBGFIELD(/*VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz*/ 80564) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1319
  {DBGFIELD(/*VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz*/ 80738) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1320
  {DBGFIELD(/*VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4Zrm_VBROADCASTF32X4Zrmk_VBROADCASTF32X4Zrmkz_VBROADCASTF32X8Zrm_VBROADCASTF32X8Zrmk_VBROADCASTF32X8Zrmkz_VBROADCASTF64X2Z256rm_VBROADCASTF64X2Z256rmk_VBROADCASTF64X2Z256rmkz_VBROADCASTF64X2Zrm_VBROADCASTF64X2Zrmk_VBROADCASTF64X2Zrmkz_VBROADCASTF64X4Zrm_VBROADCASTF64X4Zrmk_VBROADCASTF64X4Zrmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4Zrm_VBROADCASTI32X4Zrmk_VBROADCASTI32X4Zrmkz_VBROADCASTI32X8Zrm_VBROADCASTI32X8Zrmk_VBROADCASTI32X8Zrmkz_VBROADCASTI64X2Z256rm_VBROADCASTI64X2Z256rmk_VBROADCASTI64X2Z256rmkz_VBROADCASTI64X2Zrm_VBROADCASTI64X2Zrmk_VBROADCASTI64X2Zrmkz_VBROADCASTI64X4Zrm_VBROADCASTI64X4Zrmk_VBROADCASTI64X4Zrmkz*/ 81218) 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1321
  {DBGFIELD(/*VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz*/ 81974) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1322
  {DBGFIELD(/*VINSERTF32X4Z256rmi_VINSERTF32X4Z256rmik_VINSERTF32X4Z256rmikz_VINSERTF32X4Zrmi_VINSERTF32X4Zrmik_VINSERTF32X4Zrmikz_VINSERTF32X8Zrmi_VINSERTF32X8Zrmik_VINSERTF32X8Zrmikz_VINSERTF64X2Z256rmi_VINSERTF64X2Z256rmik_VINSERTF64X2Z256rmikz_VINSERTF64X2Zrmi_VINSERTF64X2Zrmik_VINSERTF64X2Zrmikz_VINSERTF64X4Zrmi_VINSERTF64X4Zrmik_VINSERTF64X4Zrmikz*/ 82196) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1323
  {DBGFIELD(/*VINSERTI32X4Z256rmi_VINSERTI32X4Z256rmik_VINSERTI32X4Z256rmikz_VINSERTI32X4Zrmi_VINSERTI32X4Zrmik_VINSERTI32X4Zrmikz_VINSERTI32X8Zrmi_VINSERTI32X8Zrmik_VINSERTI32X8Zrmikz_VINSERTI64X2Z256rmi_VINSERTI64X2Z256rmik_VINSERTI64X2Z256rmikz_VINSERTI64X2Zrmi_VINSERTI64X2Zrmik_VINSERTI64X2Zrmikz_VINSERTI64X4Zrmi_VINSERTI64X4Zrmik_VINSERTI64X4Zrmikz*/ 82538) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1324
  {DBGFIELD(/*VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz*/ 82880) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1325
  {DBGFIELD(/*VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz*/ 83244) 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1326
  {DBGFIELD(/*VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz*/ 83394) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1327
  {DBGFIELD(/*VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz*/ 83517) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1328
  {DBGFIELD(/*VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz*/ 84069) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1329
  {DBGFIELD(/*VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz*/ 84819) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1330
  {DBGFIELD(/*VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz*/ 85425) 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #1331
  {DBGFIELD(/*VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz*/ 85737) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1332
  {DBGFIELD(/*VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr*/ 85995) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1333
  {DBGFIELD(/*VPSCATTERDDZ128mr_VSCATTERDPSZ128mr*/ 86067) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1334
  {DBGFIELD(/*VPSCATTERDDZ256mr_VSCATTERDPSZ256mr*/ 86103) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1335
  {DBGFIELD(/*VPSCATTERDDZmr*/ 86139)     2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1336
  {DBGFIELD(/*VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz*/ 86154) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1337
  {DBGFIELD(/*VFPCLASSSDZmi_VFPCLASSSDZmik_VFPCLASSSSZmi_VFPCLASSSSZmik*/ 86352) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1338
  {DBGFIELD(/*VPERMI2DZ128rm_VPERMI2DZ128rmb_VPERMI2DZ128rmbk_VPERMI2DZ128rmbkz_VPERMI2DZ128rmk_VPERMI2DZ128rmkz_VPERMI2QZ128rm_VPERMI2QZ128rmb_VPERMI2QZ128rmbk_VPERMI2QZ128rmbkz_VPERMI2QZ128rmk_VPERMI2QZ128rmkz_VPERMT2DZ128rm_VPERMT2DZ128rmb_VPERMT2DZ128rmbk_VPERMT2DZ128rmbkz_VPERMT2DZ128rmk_VPERMT2DZ128rmkz_VPERMT2QZ128rm_VPERMT2QZ128rmb_VPERMT2QZ128rmbk_VPERMT2QZ128rmbkz_VPERMT2QZ128rmk_VPERMT2QZ128rmkz*/ 86410) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1339
  {DBGFIELD(/*VPERMI2PDZ128rm_VPERMI2PDZ128rmb_VPERMI2PDZ128rmbk_VPERMI2PDZ128rmbkz_VPERMI2PDZ128rmk_VPERMI2PDZ128rmkz_VPERMI2PSZ128rm_VPERMI2PSZ128rmb_VPERMI2PSZ128rmbk_VPERMI2PSZ128rmbkz_VPERMI2PSZ128rmk_VPERMI2PSZ128rmkz_VPERMT2PDZ128rm_VPERMT2PDZ128rmb_VPERMT2PDZ128rmbk_VPERMT2PDZ128rmbkz_VPERMT2PDZ128rmk_VPERMT2PDZ128rmkz_VPERMT2PSZ128rm_VPERMT2PSZ128rmb_VPERMT2PSZ128rmbk_VPERMT2PSZ128rmbkz_VPERMT2PSZ128rmk_VPERMT2PSZ128rmkz*/ 86806) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1340
  {DBGFIELD(/*VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz*/ 87226) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1341
  {DBGFIELD(/*VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128mbi_VFPCLASSPDZ128mbik_VFPCLASSPDZ128mi_VFPCLASSPDZ128mik_VFPCLASSPSZ128mbi_VFPCLASSPSZ128mbik_VFPCLASSPSZ128mi_VFPCLASSPSZ128mik*/ 87598) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1342
  {DBGFIELD(/*VCMPSDZrmi_VCMPSDZrmi_Int_VCMPSDZrmik_Int_VCMPSSZrmi_VCMPSSZrmi_Int_VCMPSSZrmik_Int*/ 87862) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1343
  {DBGFIELD(/*VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmbi_VPCMPDZ128rmbik_VPCMPDZ128rmi_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmbi_VPCMPQZ128rmbik_VPCMPQZ128rmi_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmbi_VPCMPUDZ128rmbik_VPCMPUDZ128rmi_VPCMPUDZ128rmik_VPCMPUQZ128rmbi_VPCMPUQZ128rmbik_VPCMPUQZ128rmi_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik*/ 87946) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1344
  {DBGFIELD(/*VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk*/ 88694) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #1345
  {DBGFIELD(/*CVTPS2PDrm_VCVTPS2PDrm*/ 89086) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1346
  {DBGFIELD(/*VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz*/ 89109) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1347
  {DBGFIELD(/*VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz*/ 89307) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD(/*VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz*/ 89469) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1349
  {DBGFIELD(/*VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz*/ 89841) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD(/*VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256mbi_VFPCLASSPDZ256mbik_VFPCLASSPDZ256mi_VFPCLASSPDZ256mik_VFPCLASSPSZ256mbi_VFPCLASSPSZ256mbik_VFPCLASSPSZ256mi_VFPCLASSPSZ256mik*/ 90141) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1351
  {DBGFIELD(/*VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZmbi_VFPCLASSPDZmbik_VFPCLASSPDZmi_VFPCLASSPDZmik_VFPCLASSPSZmbi_VFPCLASSPSZmbik_VFPCLASSPSZmi_VFPCLASSPSZmik*/ 90405) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1352
  {DBGFIELD(/*VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmbi_VPCMPDZ256rmbik_VPCMPDZ256rmi_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmbi_VPCMPQZ256rmbik_VPCMPQZ256rmi_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmbi_VPCMPUDZ256rmbik_VPCMPUDZ256rmi_VPCMPUDZ256rmik_VPCMPUQZ256rmbi_VPCMPUQZ256rmbik_VPCMPUQZ256rmi_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik*/ 90621) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1353
  {DBGFIELD(/*VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmbi_VPCMPDZrmbik_VPCMPDZrmi_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmbi_VPCMPQZrmbik_VPCMPQZrmi_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmbi_VPCMPUDZrmbik_VPCMPUDZrmi_VPCMPUDZrmik_VPCMPUQZrmbi_VPCMPUQZrmbik_VPCMPUQZrmi_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik*/ 91369) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1354
  {DBGFIELD(/*VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk*/ 91973) 2, false, false, false, 102, 6, 22, 1,  6, 1}, // #1355
  {DBGFIELD(/*VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk*/ 92365) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1356
  {DBGFIELD(/*VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz*/ 92685) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1357
  {DBGFIELD(/*VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz*/ 93117) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1358
  {DBGFIELD(/*VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz*/ 93572) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1359
  {DBGFIELD(/*VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz*/ 94016) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1360
  {DBGFIELD(/*VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz*/ 94067) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1361
  {DBGFIELD(/*VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz*/ 95003) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1362
  {DBGFIELD(/*VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrmk_Int_VCVTSS2SDZrmkz_Int_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int*/ 95108) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1363
  {DBGFIELD(/*VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz*/ 95229) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1364
  {DBGFIELD(/*VCVTDQ2PSYrm*/ 95433)       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1365
  {DBGFIELD(/*VCVTPS2PDYrm*/ 95446)       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1366
  {DBGFIELD(/*VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz*/ 95459) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1367
  {DBGFIELD(/*VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz*/ 95891) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD(/*VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz*/ 96251) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1369
  {DBGFIELD(/*VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz*/ 96683) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD(/*VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz*/ 96863) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1371
  {DBGFIELD(/*VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz*/ 96914) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD(/*VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz*/ 96956) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1373
  {DBGFIELD(/*VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz*/ 97061) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1374
  {DBGFIELD(/*VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz*/ 97148) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #1375
  {DBGFIELD(/*VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz*/ 97592) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1376
  {DBGFIELD(/*VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz*/ 97964) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1377
  {DBGFIELD(/*VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz*/ 98879) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1378
  {DBGFIELD(/*VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz*/ 99251) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1379
  {DBGFIELD(/*CVTDQ2PDrm_VCVTDQ2PDrm*/ 99623) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1380
  {DBGFIELD(/*CVTPD2DQrm_CVTTPD2DQrm*/ 99646) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1381
  {DBGFIELD(/*VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz*/ 99669) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1382
  {DBGFIELD(/*VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz*/ 99786) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1383
  {DBGFIELD(/*VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz*/ 99831) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1384
  {DBGFIELD(/*VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz*/ 99876) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1385
  {DBGFIELD(/*VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz*/ 99912) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1386
  {DBGFIELD(/*VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int*/ 99954) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1387
  {DBGFIELD(/*VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int*/ 100006) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1388
  {DBGFIELD(/*VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz*/ 100064) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1389
  {DBGFIELD(/*VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz*/ 100436) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1390
  {DBGFIELD(/*VCVTDQ2PDYrm*/ 100511)       2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1391
  {DBGFIELD(/*VPERMI2WZ128rm_VPERMI2WZ128rmk_VPERMI2WZ128rmkz_VPERMT2WZ128rm_VPERMT2WZ128rmk_VPERMT2WZ128rmkz*/ 100524) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1392
  {DBGFIELD(/*VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz*/ 100620) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD(/*VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz*/ 100992) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1394
  {DBGFIELD(/*VPERMI2WZ256rm_VPERMI2WZ256rmk_VPERMI2WZ256rmkz_VPERMI2WZrm_VPERMI2WZrmk_VPERMI2WZrmkz_VPERMT2WZ256rm_VPERMT2WZ256rmk_VPERMT2WZ256rmkz_VPERMT2WZrm_VPERMT2WZrmk_VPERMT2WZrmkz*/ 101172) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1395
  {DBGFIELD(/*VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz*/ 101346) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1396
  {DBGFIELD(/*VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz*/ 101463) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1397
  {DBGFIELD(/*VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz*/ 101556) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1398
  {DBGFIELD(/*VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz*/ 101649) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1399
  {DBGFIELD(/*VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm*/ 101724) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #1400
  {DBGFIELD(/*VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm*/ 101826) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #1401
  {DBGFIELD(/*VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm*/ 101962) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #1402
  {DBGFIELD(/*VGATHERDPSZrm_VPGATHERDDZrm*/ 102080) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #1403
  {DBGFIELD(/*VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz*/ 102108) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1404
  {DBGFIELD(/*VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz*/ 102165) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1405
  {DBGFIELD(/*VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz*/ 102282) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD(/*VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz*/ 102330) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1407
  {DBGFIELD(/*VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz*/ 102447) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1408
  {DBGFIELD(/*VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz*/ 102546) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD(/*VXORPSZ128rr_VXORPDZ128rr*/ 102645) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1410
  {DBGFIELD(/*VXORPSZ256rr_VXORPDZ256rr*/ 102671) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1411
  {DBGFIELD(/*VXORPSZrr_VXORPDZrr*/ 102697) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD(/*VPXORDZ128rr_VPXORQZ128rr*/ 102717) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1413
  {DBGFIELD(/*VPXORDZ256rr_VPXORQZ256rr*/ 102743) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1414
  {DBGFIELD(/*VPXORDZrr_VPXORQZrr*/ 102769) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1415
  {DBGFIELD(/*VPBROADCASTDrr_VPBROADCASTQrr*/ 102789) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1416
  {DBGFIELD(/*INSERTPSrri_VINSERTPSZrri_VINSERTPSrri_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr*/ 102819) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1417
  {DBGFIELD(/*VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz*/ 103367) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1418
  {DBGFIELD(/*VPERMILPDrr_VPERMILPSrr*/ 103763) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1419
  {DBGFIELD(/*MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV*/ 103787) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1420
  {DBGFIELD(/*VEXTRACTPSZrri*/ 104007)     2, false, false, false, 381, 11, 14, 1,  0, 0}, // #1421
  {DBGFIELD(/*VEXTRACTPSZmri*/ 104022)     3, false, false, false, 372, 9, 17, 1,  0, 0}, // #1422
  {DBGFIELD(/*VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz*/ 104037) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1423
  {DBGFIELD(/*INSERTPSrmi_VINSERTPSZrmi_VINSERTPSrmi_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm*/ 104157) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1424
  {DBGFIELD(/*PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi*/ 104708) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1425
  {DBGFIELD(/*VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi*/ 104782) 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1426
  {DBGFIELD(/*VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm*/ 105016) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1427
  {DBGFIELD(/*VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz*/ 105250) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1428
  {DBGFIELD(/*VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz*/ 105314) 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1429
  {DBGFIELD(/*VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz*/ 105550) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1430
  {DBGFIELD(/*VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz*/ 105786) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1431
  {DBGFIELD(/*PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm*/ 106258) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1432
  {DBGFIELD(/*VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz*/ 106662) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1433
  {DBGFIELD(/*VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz*/ 107026) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1434
  {DBGFIELD(/*AADD64mr_AAND64mr_AOR64mr_AXOR64mr*/ 107284) 3, false, false, false, 1962, 9,  4, 1,  0, 0}, // #1435
  {DBGFIELD(/*JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT*/ 107319) 2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1436
  {DBGFIELD(/*RET16*/ 107370)              2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1437
  {DBGFIELD(/*RORX32mi_RORX64mi*/ 107376)  2, false, false, false, 229, 7,  3, 1,  0, 0}, // #1438
  {DBGFIELD(/*ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm*/ 107394) 2, false, false, false, 229, 7,  3, 1, 12, 2}, // #1439
  {DBGFIELD(/*ADC8mi_ADC8mi8_SBB8mi_SBB8mi8*/ 107492) 5, false, false, false, 64, 9, 24, 1,  0, 0}, // #1440
  {DBGFIELD(/*CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8*/ 107522) 2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1441
  {DBGFIELD(/*MOV8rm*/ 107580)             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1442
  {DBGFIELD(/*POP16rmr_POP32rmr*/ 107587)  2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1443
  {DBGFIELD(/*POP32r*/ 107605)             2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1444
  {DBGFIELD(/*CMP64mi32*/ 107612)          2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1445
  {DBGFIELD(/*MOV8rm_NOREX*/ 107622)       2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1446
  {DBGFIELD(/*MOVZX16rm8*/ 107635)         2, false, false, false, 104, 4,  3, 1,  0, 0}, // #1447
  {DBGFIELD(/*ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm*/ 107646) 2, false, false, false, 104, 4,  3, 1,  1, 1}, // #1448
  {DBGFIELD(/*CMP16mr_CMP32mr_CMP64mr_CMP8mr*/ 107805) 2, false, false, false, 104, 4,  3, 1,  1, 1}, // #1449
  {DBGFIELD(/*ADD64ri8_SUB64ri8_DEC64r_INC64r*/ 107836) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1450
  {DBGFIELD(/*MOV64rr_MOV64rr_REV*/ 107868) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1451
  {DBGFIELD(/*JMP_2*/ 107888)              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1452
  {DBGFIELD(/*ADD8mi_ADD8mi8_SUB8mi_SUB8mi8*/ 107894) 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1453
  {DBGFIELD(/*AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8*/ 107924) 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1454
  {DBGFIELD(/*DEC8m_INC8m_NEG8m_NOT8m*/ 107967) 4, false, false, false, 58, 6, 24, 1,  0, 0}, // #1455
  {DBGFIELD(/*ADD8mr*/ 107991)             4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1456
  {DBGFIELD(/*AND8mr_OR8mr_XOR8mr*/ 107998) 4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1457
  {DBGFIELD(/*SUB8mr*/ 108018)             4, false, false, false, 58, 6, 24, 1,  1, 1}, // #1458
  {DBGFIELD(/*ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int*/ 108025) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1459
  {DBGFIELD(/*AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr*/ 108109) 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1460
  {DBGFIELD(/*AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8*/ 108559) 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1461
  {DBGFIELD(/*XOR32rr_XOR64rr*/ 108631)    1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1462
  {DBGFIELD(/*XOR32rr_REV_XOR64rr_REV*/ 108647) 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1463
  {DBGFIELD(/*XOR8rr_NOREX*/ 108671)       1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1464
  {DBGFIELD(/*TEST16mi_TEST32mi_TEST8mi*/ 108684) 2, false, false, false, 104, 4,  4, 1,  0, 0}, // #1465
  {DBGFIELD(/*TEST64mi32*/ 108710)         2, false, false, false, 104, 4,  4, 1,  0, 0}, // #1466
  {DBGFIELD(/*OR64rm_XOR64rm*/ 108721)     2, false, false, false, 104, 4,  4, 1,  1, 1}, // #1467
  {DBGFIELD(/*AND64rm*/ 108736)            2, false, false, false, 104, 4,  4, 1,  1, 1}, // #1468
  {DBGFIELD(/*TEST16mr_TEST32mr_TEST64mr_TEST8mr*/ 108744) 2, false, false, false, 104, 4,  4, 1,  1, 1}, // #1469
  {DBGFIELD(/*ANDN32rm_ANDN64rm*/ 108779)  2, false, false, false, 173, 5,  4, 1,  1, 1}, // #1470
  {DBGFIELD(/*ANDN32rr_ANDN64rr*/ 108797)  1, false, false, false, 178, 3, 12, 1,  0, 0}, // #1471
  {DBGFIELD(/*BT64mr*/ 108815)             9, false, false, false, 1971, 12,  9, 1,  0, 0}, // #1472
  {DBGFIELD(/*BT64rr*/ 108822)             1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1473
  {DBGFIELD(/*BTC64rr_BTR64rr_BTS64rr*/ 108829) 1, false, false, false, 45, 8,  6, 1,  0, 0}, // #1474
  {DBGFIELD(/*BTC64mr_BTR64mr_BTS64mr*/ 108853) 10, false, false, false, 1983, 14, 20, 1,  0, 0}, // #1475
  {DBGFIELD(/*CALL64m_CALL64m_NT*/ 108877) 5, false, false, false, 64, 9,  4, 1,  0, 0}, // #1476
  {DBGFIELD(/*CALL64r_CALL64r_NT*/ 108896) 3, false, false, false, 1515, 8,  6, 1,  0, 0}, // #1477
  {DBGFIELD(/*MFENCE*/ 108915)             2, false, false, false, 35, 4,  6, 1,  0, 0}, // #1478
  {DBGFIELD(/*CDQE_CWDE*/ 108922)          1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1479
  {DBGFIELD(/*MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri*/ 108932) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1480
  {DBGFIELD(/*VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri*/ 109020) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1481
  {DBGFIELD(/*VPBLENDWYrri*/ 109070)       1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1482
  {DBGFIELD(/*CLFLUSH*/ 109083)            4, false, false, false, 1997, 8, 12, 1,  0, 0}, // #1483
  {DBGFIELD(/*CLTS*/ 109091)               10, false, false, false, 2005, 12,  5, 1,  0, 0}, // #1484
  {DBGFIELD(/*MOV16o16a_MOV16o32a_MOV16o64a*/ 109096) 3, false, false, false, 856, 5, 10, 1,  0, 0}, // #1485
  {DBGFIELD(/*CLWB*/ 109126)               3, false, false, false, 856, 5, 10, 1,  0, 0}, // #1486
  {DBGFIELD(/*CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm*/ 109131) 3, false, false, false, 276, 11, 80, 1,  0, 0}, // #1487
  {DBGFIELD(/*VCVTTSD2SIrm_Int*/ 109226)   3, false, false, false, 276, 11, 80, 1,  0, 0}, // #1488
  {DBGFIELD(/*VCVTSI642SSrm_Int*/ 109243)  3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1489
  {DBGFIELD(/*VCVTSI642SSrm*/ 109261)      3, false, false, false, 264, 12,  2, 1,  6, 1}, // #1490
  {DBGFIELD(/*VCVTSI642SSrr_Int*/ 109275)  3, false, false, false, 896, 10,  7, 1,  7, 1}, // #1491
  {DBGFIELD(/*JECXZ_JRCXZ*/ 109293)        2, false, false, false, 73, 5, 12, 1,  0, 0}, // #1492
  {DBGFIELD(/*ST_Frr*/ 109305)             1, false, false, false, 42, 3,  1, 1,  0, 0}, // #1493
  {DBGFIELD(/*MOV16sr_MOV32sr*/ 109312)    1, false, false, false, 42, 3,  1, 1,  0, 0}, // #1494
  {DBGFIELD(/*DEC16r_alt_SALC*/ 109328)    1, false, false, false, 42, 3,  1, 1,  0, 0}, // #1495
  {DBGFIELD(/*SYSCALL*/ 109344)            1, false, false, false, 42, 3,  1, 1,  0, 0}, // #1496
  {DBGFIELD(/*DEC32r_alt*/ 109352)         1, false, false, false, 764, 9,  4, 1,  0, 0}, // #1497
  {DBGFIELD(/*DIVR_FPrST0_DIVR_FrST0*/ 109363) 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #1498
  {DBGFIELD(/*DIVSDrm_Int_VDIVSDrm_Int*/ 109386) 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #1499
  {DBGFIELD(/*DIV_FPrST0_DIV_FrST0*/ 109411) 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #1500
  {DBGFIELD(/*SMSW16m*/ 109432)            3, false, false, false, 1320, 12,  2, 1,  0, 0}, // #1501
  {DBGFIELD(/*MMX_PEXTRWrri*/ 109440)      2, false, false, false, 605, 12, 14, 1,  0, 0}, // #1502
  {DBGFIELD(/*MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr*/ 109454) 1, false, false, false, 548, 6,  1, 1,  0, 0}, // #1503
  {DBGFIELD(/*GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi*/ 109490) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1504
  {DBGFIELD(/*GF2P8MULBrm_VGF2P8MULBrm*/ 109566) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1505
  {DBGFIELD(/*VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi*/ 109591) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1506
  {DBGFIELD(/*VGF2P8MULBYrm*/ 109632)      2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1507
  {DBGFIELD(/*GF2P8MULBrr_VGF2P8MULBrr*/ 109646) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1508
  {DBGFIELD(/*VGF2P8MULBYrr*/ 109671)      1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1509
  {DBGFIELD(/*IN16ri*/ 109685)             87, false, false, false, 2017, 15, 55, 1,  0, 0}, // #1510
  {DBGFIELD(/*IN16rr*/ 109692)             87, false, false, false, 2032, 15, 55, 1,  0, 0}, // #1511
  {DBGFIELD(/*IN32ri*/ 109699)             94, false, false, false, 2047, 15, 55, 1,  0, 0}, // #1512
  {DBGFIELD(/*IN32rr*/ 109706)             99, false, false, false, 2062, 15,  1, 1,  0, 0}, // #1513
  {DBGFIELD(/*INC16r_alt*/ 109713)         4, false, false, false, 12, 5,  1, 1,  0, 0}, // #1514
  {DBGFIELD(/*INC32r_alt*/ 109724)         1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1515
  {DBGFIELD(/*INSB*/ 109735)               83, false, false, false, 2077, 17, 15, 1,  0, 0}, // #1516
  {DBGFIELD(/*INSL*/ 109740)               92, false, false, false, 2094, 17, 15, 1,  0, 0}, // #1517
  {DBGFIELD(/*INVLPG*/ 109745)             42, false, false, false, 2111, 16,  5, 1,  0, 0}, // #1518
  {DBGFIELD(/*JMP64r_REX*/ 109752)         1, false, false, false, 2127, 6,  1, 1,  0, 0}, // #1519
  {DBGFIELD(/*JMP_1_JMP_4*/ 109763)        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1520
  {DBGFIELD(/*LAR16rm*/ 109775)            81, false, false, false, 2133, 15, 81, 1,  0, 0}, // #1521
  {DBGFIELD(/*LAR16rr*/ 109783)            22, false, false, false, 1553, 15, 82, 1,  0, 0}, // #1522
  {DBGFIELD(/*LAR32rm*/ 109791)            85, false, false, false, 2148, 15, 83, 1,  0, 0}, // #1523
  {DBGFIELD(/*LAR64rm*/ 109799)            87, false, false, false, 2148, 15, 83, 1,  0, 0}, // #1524
  {DBGFIELD(/*LEAVE*/ 109807)              4, false, false, false, 845, 4,  3, 1,  0, 0}, // #1525
  {DBGFIELD(/*LGDT64m*/ 109813)            14, false, false, false, 2163, 16,  5, 1,  0, 0}, // #1526
  {DBGFIELD(/*LIDT64m*/ 109821)            14, false, false, false, 2179, 15,  5, 1,  0, 0}, // #1527
  {DBGFIELD(/*LLDT16m*/ 109829)            12, false, false, false, 2194, 14,  5, 1,  0, 0}, // #1528
  {DBGFIELD(/*LLDT16r*/ 109837)            11, false, false, false, 2208, 14,  5, 1,  0, 0}, // #1529
  {DBGFIELD(/*LMSW16m*/ 109845)            27, false, false, false, 2222, 17,  5, 1,  0, 0}, // #1530
  {DBGFIELD(/*LMSW16r*/ 109853)            22, false, false, false, 2239, 15,  5, 1,  0, 0}, // #1531
  {DBGFIELD(/*MMX_MOVD64mr*/ 109861)       2, false, false, false, 35, 4, 13, 1,  0, 0}, // #1532
  {DBGFIELD(/*MMX_MOVD64rm_MMX_MOVQ64rm*/ 109874) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1533
  {DBGFIELD(/*MMX_MOVD64to64rm*/ 109900)   1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1534
  {DBGFIELD(/*MMX_MOVFR642Qrr*/ 109917)    2, false, false, false, 1293, 6,  6, 1,  0, 0}, // #1535
  {DBGFIELD(/*MMX_PACKSSDWrm_MMX_PACKSSWBrm*/ 109933) 3, false, false, false, 1533, 11,  2, 1,  6, 1}, // #1536
  {DBGFIELD(/*MMX_PACKSSDWrr_MMX_PACKSSWBrr*/ 109963) 2, false, false, false, 1544, 9, 14, 1,  0, 0}, // #1537
  {DBGFIELD(/*MMX_PINSRWrri*/ 109993)      2, false, false, false, 1544, 9, 14, 1,  7, 1}, // #1538
  {DBGFIELD(/*MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm*/ 110007) 2, false, false, false, 554, 8, 22, 1,  6, 1}, // #1539
  {DBGFIELD(/*MMX_PINSRWrmi*/ 110079)      2, false, false, false, 526, 11, 22, 1,  1, 1}, // #1540
  {DBGFIELD(/*VPALIGNRYrmi*/ 110093)       2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1541
  {DBGFIELD(/*MOV16ao16_MOV16ao32_MOV16ao64*/ 110106) 2, false, false, false, 104, 4, 10, 1,  0, 0}, // #1542
  {DBGFIELD(/*PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32*/ 110136) 3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1543
  {DBGFIELD(/*MOV16ms*/ 110172)            3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1544
  {DBGFIELD(/*MOVBE32mr*/ 110180)          3, false, false, false, 1299, 11,  2, 1,  0, 0}, // #1545
  {DBGFIELD(/*MOV16rs_MOV32rs_MOV64rs*/ 110190) 2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1546
  {DBGFIELD(/*SLDT16r*/ 110214)            2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1547
  {DBGFIELD(/*STR16r*/ 110222)             2, false, false, false, 472, 8,  1, 1,  0, 0}, // #1548
  {DBGFIELD(/*MOV32ao16_MOV32ao32_MOV32ao64*/ 110229) 1, false, false, false, 39, 3,  1, 1,  0, 0}, // #1549
  {DBGFIELD(/*MOV64ao64*/ 110259)          1, false, false, false, 39, 3,  1, 1,  0, 0}, // #1550
  {DBGFIELD(/*MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a*/ 110269) 3, false, false, false, 856, 5,  1, 1,  0, 0}, // #1551
  {DBGFIELD(/*MOVZX32rr8_MOVZX64rr8*/ 110336) 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1552
  {DBGFIELD(/*MOVZX32rr8_NOREX*/ 110358)   1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1553
  {DBGFIELD(/*MOV64ao32*/ 110375)          1, false, false, false, 39, 3, 10, 1,  0, 0}, // #1554
  {DBGFIELD(/*MOV64dr*/ 110385)            48, false, false, false, 2254, 15, 84, 1,  0, 0}, // #1555
  {DBGFIELD(/*MOV64o32a*/ 110393)          2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1556
  {DBGFIELD(/*MOV64rc*/ 110403)            3, false, false, false, 2269, 10,  5, 1,  0, 0}, // #1557
  {DBGFIELD(/*MOV64rd*/ 110411)            24, false, false, false, 2279, 12, 85, 1,  0, 0}, // #1558
  {DBGFIELD(/*MOV8ao16_MOV8ao32_MOV8ao64*/ 110419) 2, false, false, false, 104, 4,  1, 1,  0, 0}, // #1559
  {DBGFIELD(/*MOV8mi_MOV8mr*/ 110446)      2, false, false, false, 35, 4, 24, 1,  0, 0}, // #1560
  {DBGFIELD(/*MOV8mr_NOREX*/ 110460)       2, false, false, false, 35, 4, 24, 1,  0, 0}, // #1561
  {DBGFIELD(/*MOVBE32rm*/ 110473)          2, false, false, false, 181, 10,  3, 1,  0, 0}, // #1562
  {DBGFIELD(/*SLDT16m*/ 110483)            4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1563
  {DBGFIELD(/*STRm*/ 110491)               4, false, false, false, 1337, 13,  2, 1,  0, 0}, // #1564
  {DBGFIELD(/*MOVBE64rm*/ 110496)          3, false, false, false, 151, 12,  4, 1,  0, 0}, // #1565
  {DBGFIELD(/*MOVDIR64B16_MOVDIR64B32_MOVDIR64B64*/ 110506) 4, false, false, false, 764, 9,  1, 1,  0, 0}, // #1566
  {DBGFIELD(/*MOVDIRI32*/ 110542)          2, false, false, false, 35, 4, 25, 1,  0, 0}, // #1567
  {DBGFIELD(/*MOVDIRI64*/ 110552)          2, false, false, false, 35, 4, 86, 1,  0, 0}, // #1568
  {DBGFIELD(/*MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm*/ 110562) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1569
  {DBGFIELD(/*SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi*/ 110600) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1570
  {DBGFIELD(/*MOVNTDQmr*/ 110642)          2, false, false, false, 35, 4, 26, 1,  0, 0}, // #1571
  {DBGFIELD(/*MOVNTImr*/ 110652)           2, false, false, false, 35, 4, 27, 1,  0, 0}, // #1572
  {DBGFIELD(/*MOVSB*/ 110661)              7, false, false, false, 923, 6,  7, 1,  0, 0}, // #1573
  {DBGFIELD(/*MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV*/ 110667) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1574
  {DBGFIELD(/*MOVSX16rm16_MOVSX16rm32*/ 110731) 1, false, false, false, 39, 3,  3, 1,  0, 0}, // #1575
  {DBGFIELD(/*MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8*/ 110755) 1, false, false, false, 39, 3,  3, 1,  0, 0}, // #1576
  {DBGFIELD(/*MOVSX32rm8_NOREX*/ 110825)   1, false, false, false, 39, 3,  3, 1,  0, 0}, // #1577
  {DBGFIELD(/*MOVSX16rr16_MOVSX16rr32*/ 110842) 1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1578
  {DBGFIELD(/*MOVSX16rr8*/ 110866)         1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1579
  {DBGFIELD(/*MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8*/ 110877) 1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1580
  {DBGFIELD(/*MOVSX32rr8_NOREX*/ 110923)   1, false, false, false, 178, 3,  1, 1,  0, 0}, // #1581
  {DBGFIELD(/*MUL_FPrST0_MUL_FrST0*/ 110940) 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1582
  {DBGFIELD(/*OUT16ir*/ 110961)            79, false, false, false, 2291, 17, 55, 1,  0, 0}, // #1583
  {DBGFIELD(/*OUT16rr*/ 110969)            79, false, false, false, 2308, 17, 55, 1,  0, 0}, // #1584
  {DBGFIELD(/*OUT32ir*/ 110977)            85, false, false, false, 2325, 17, 55, 1,  0, 0}, // #1585
  {DBGFIELD(/*OUT32rr*/ 110985)            85, false, false, false, 2342, 17, 55, 1,  0, 0}, // #1586
  {DBGFIELD(/*OUTSB*/ 110993)              80, false, false, false, 2359, 17,  5, 1,  0, 0}, // #1587
  {DBGFIELD(/*OUTSL*/ 110999)              89, false, false, false, 2376, 17,  5, 1,  0, 0}, // #1588
  {DBGFIELD(/*PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm*/ 111005) 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1589
  {DBGFIELD(/*PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr*/ 111097) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1590
  {DBGFIELD(/*VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr*/ 111189) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1591
  {DBGFIELD(/*PALIGNRrmi_VPALIGNRrmi*/ 111241) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1592
  {DBGFIELD(/*PALIGNRrri_VPALIGNRrri*/ 111264) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1593
  {DBGFIELD(/*VPALIGNRYrri*/ 111287)       1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1594
  {DBGFIELD(/*PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm*/ 111300) 2, false, false, false, 181, 10,  7, 1,  1, 1}, // #1595
  {DBGFIELD(/*PREFETCHIT0_PREFETCHIT1*/ 111336) 1, false, false, false, 943, 5, 10, 1,  0, 0}, // #1596
  {DBGFIELD(/*PREFETCHT0_PREFETCHT1_PREFETCHT2*/ 111360) 1, false, false, false, 39, 3,  0, 1,  0, 0}, // #1597
  {DBGFIELD(/*PREFETCHNTA*/ 111393)        1, false, false, false, 39, 3,  0, 1,  0, 0}, // #1598
  {DBGFIELD(/*PTWRITE64m_PTWRITEm*/ 111405) 4, false, false, false, 2393, 8,  5, 1,  0, 0}, // #1599
  {DBGFIELD(/*PTWRITE64r*/ 111425)         3, false, false, false, 2401, 6,  5, 1,  0, 0}, // #1600
  {DBGFIELD(/*PTWRITEr*/ 111436)           4, false, false, false, 2407, 6,  5, 1,  0, 0}, // #1601
  {DBGFIELD(/*PUSH64r*/ 111445)            2, false, false, false, 35, 4,  1, 1,  0, 0}, // #1602
  {DBGFIELD(/*PUSH64rmr*/ 111453)          2, false, false, false, 35, 4,  1, 1,  0, 0}, // #1603
  {DBGFIELD(/*RCL8m1_RCR8m1*/ 111463)      6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1604
  {DBGFIELD(/*RCL8mi*/ 111477)             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1605
  {DBGFIELD(/*RCR8mi*/ 111484)             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1606
  {DBGFIELD(/*RCL8mCL*/ 111491)            11, false, false, false, 2413, 14, 87, 2,  0, 0}, // #1607
  {DBGFIELD(/*RCR8mCL*/ 111499)            12, false, false, false, 2427, 14, 87, 2,  0, 0}, // #1608
  {DBGFIELD(/*RDPID64*/ 111507)            1, false, false, false, 45, 8,  5, 1,  0, 0}, // #1609
  {DBGFIELD(/*RDPKRUr*/ 111515)            3, false, false, false, 492, 10,  5, 1,  0, 0}, // #1610
  {DBGFIELD(/*RDRAND16r*/ 111523)          25, false, false, false, 1489, 15, 89, 1,  0, 0}, // #1611
  {DBGFIELD(/*RDSEED16r*/ 111533)          25, false, false, false, 2441, 15, 90, 1,  0, 0}, // #1612
  {DBGFIELD(/*RDSEED32r_RDSEED64r*/ 111543) 25, false, false, false, 2441, 15,  5, 1,  0, 0}, // #1613
  {DBGFIELD(/*REX64_PREFIX*/ 111563)       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1614
  {DBGFIELD(/*ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi*/ 111576) 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #1615
  {DBGFIELD(/*ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL*/ 111672) 5, false, false, false, 773, 9, 33, 2,  0, 0}, // #1616
  {DBGFIELD(/*ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri*/ 111726) 2, false, false, false, 759, 5,  1, 1,  0, 0}, // #1617
  {DBGFIELD(/*ROL8m1_ROL8mi_ROR8m1_ROR8mi*/ 111788) 5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1618
  {DBGFIELD(/*ROL8mCL_ROR8mCL*/ 111816)    5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1619
  {DBGFIELD(/*SHL8mCL_SAR8mCL_SHR8mCL*/ 111832) 5, false, false, false, 773, 9, 58, 2,  0, 0}, // #1620
  {DBGFIELD(/*SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi*/ 111856) 4, false, false, false, 764, 9, 58, 2,  0, 0}, // #1621
  {DBGFIELD(/*SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm*/ 111898) 2, false, false, false, 229, 7,  7, 1,  1, 1}, // #1622
  {DBGFIELD(/*SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr*/ 111952) 1, false, false, false, 12, 5,  6, 1,  0, 0}, // #1623
  {DBGFIELD(/*SERIALIZE*/ 112006)          7, false, false, false, 2456, 13,  5, 1,  0, 0}, // #1624
  {DBGFIELD(/*SHRD16mri8*/ 112016)         5, false, false, false, 809, 12, 24, 1,  0, 0}, // #1625
  {DBGFIELD(/*SMSW16r*/ 112027)            2, false, false, false, 2469, 9,  1, 1,  0, 0}, // #1626
  {DBGFIELD(/*SMSW32r_SMSW64r*/ 112035)    2, false, false, false, 2469, 9,  5, 1,  0, 0}, // #1627
  {DBGFIELD(/*SQRTSDm_Int_VSQRTSDm_Int*/ 112051) 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #1628
  {DBGFIELD(/*STI*/ 112076)                6, false, false, false, 2478, 10,  5, 1,  0, 0}, // #1629
  {DBGFIELD(/*STOSB*/ 112080)              4, false, false, false, 1332, 5,  7, 1,  0, 0}, // #1630
  {DBGFIELD(/*VBLENDVPDrmr_VBLENDVPSrmr*/ 112086) 4, false, false, false, 843, 6, 22, 1, 10, 2}, // #1631
  {DBGFIELD(/*VPBLENDVBrmr*/ 112112)       4, false, false, false, 843, 6, 22, 1, 10, 2}, // #1632
  {DBGFIELD(/*VBLENDVPDrrr_VBLENDVPSrrr*/ 112125) 3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1633
  {DBGFIELD(/*VPBLENDVBrrr*/ 112151)       3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1634
  {DBGFIELD(/*VERRm*/ 112164)              31, false, false, false, 2488, 14, 57, 1,  0, 0}, // #1635
  {DBGFIELD(/*VERRr*/ 112170)              30, false, false, false, 2502, 14, 91, 1,  0, 0}, // #1636
  {DBGFIELD(/*VERWr*/ 112176)              33, false, false, false, 2516, 14, 91, 1,  0, 0}, // #1637
  {DBGFIELD(/*VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr*/ 112182) 3, false, false, false, 431, 9, 10, 1,  0, 0}, // #1638
  {DBGFIELD(/*VLDMXCSR*/ 112222)           3, false, false, false, 2530, 11,  4, 1,  0, 0}, // #1639
  {DBGFIELD(/*VMOVMSKPDYrr_VMOVMSKPSYrr*/ 112231) 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1640
  {DBGFIELD(/*VMOVNTDQmr*/ 112257)         2, false, false, false, 35, 4, 92, 1,  0, 0}, // #1641
  {DBGFIELD(/*VMOVNTPDmr*/ 112268)         2, false, false, false, 35, 4, 93, 1,  0, 0}, // #1642
  {DBGFIELD(/*VMOVNTPSYmr*/ 112279)        2, false, false, false, 35, 4, 94, 1,  0, 0}, // #1643
  {DBGFIELD(/*VMOVNTPSmr*/ 112291)         2, false, false, false, 35, 4, 95, 1,  0, 0}, // #1644
  {DBGFIELD(/*VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm*/ 112302) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1645
  {DBGFIELD(/*VPCLMULQDQYrmi*/ 112354)     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1646
  {DBGFIELD(/*VSHUFPDYrmi_VSHUFPSYrmi*/ 112369) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1647
  {DBGFIELD(/*VPBLENDWYrmi*/ 112393)       2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1648
  {DBGFIELD(/*WRPKRUr*/ 112406)            8, false, false, false, 2541, 12,  5, 1,  0, 0}, // #1649
  {DBGFIELD(/*XADD16rm_XADD32rm_XADD64rm*/ 112414) 5, false, false, false, 1391, 6, 33, 2,  0, 0}, // #1650
  {DBGFIELD(/*XCHG16rm*/ 112441)           8, false, false, false, 1870, 9, 49, 2,  0, 0}, // #1651
  {DBGFIELD(/*XCHG32rm*/ 112450)           8, false, false, false, 1870, 9, 49, 2,  0, 0}, // #1652
  {DBGFIELD(/*XRSTOR_XRSTOR64_XRSTORS*/ 112459) 31, false, false, false, 1617, 15, 62, 1,  0, 0}, // #1653
  {DBGFIELD(/*XSAVEC*/ 112483)             151, false, false, false, 2553, 17, 52, 1,  0, 0}, // #1654
  {DBGFIELD(/*XSAVEC64*/ 112490)           152, false, false, false, 2570, 17, 52, 1,  0, 0}, // #1655
  {DBGFIELD(/*XSAVEOPT*/ 112499)           155, false, false, false, 2587, 16, 66, 1,  0, 0}, // #1656
  {DBGFIELD(/*XSAVES*/ 112508)             184, false, false, false, 2603, 16, 52, 1,  0, 0}, // #1657
  {DBGFIELD(/*CMPPDrmi_VCMPPDrmi*/ 112515) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1658
  {DBGFIELD(/*CMPPSrmi_VCMPPSrmi*/ 112534) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1659
  {DBGFIELD(/*GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi*/ 112553) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1660
  {DBGFIELD(/*GF2P8MULBrm*/ 112590)        2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1661
  {DBGFIELD(/*CMPSDrmi_CMPSDrmi_Int_VCMPSDrmi_VCMPSDrmi_Int*/ 112602) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1662
  {DBGFIELD(/*CMPSSrmi_CMPSSrmi_Int_VCMPSSrmi_VCMPSSrmi_Int*/ 112648) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1663
  {DBGFIELD(/*CVTSS2SI64rm_Int_CVTTSS2SI64rm_Int*/ 112694) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #1664
  {DBGFIELD(/*CVTSS2SIrm_Int_CVTTSS2SIrm_Int_CVTSS2SIrm_CVTTSS2SIrm*/ 112729) 3, false, false, false, 276, 11,  2, 1,  0, 0}, // #1665
  {DBGFIELD(/*GF2P8AFFINEINVQBrri_GF2P8AFFINEQBrri*/ 112783) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1666
  {DBGFIELD(/*GF2P8MULBrr*/ 112820)        1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1667
  {DBGFIELD(/*MMX_CVTPS2PIrr*/ 112832)     2, false, false, false, 873, 9, 22, 1,  0, 0}, // #1668
  {DBGFIELD(/*VPBROADCASTWrm*/ 112847)     2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1669
  {DBGFIELD(/*VSHA512MSG1rr_VSHA512MSG2rr*/ 112862) 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1670
  {DBGFIELD(/*PSHUFDmi_PSHUFHWmi_PSHUFLWmi_VPSHUFDmi_VPSHUFHWmi_VPSHUFLWmi*/ 112890) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1671
  {DBGFIELD(/*VPERMILPDmi_VPERMILPSmi*/ 112951) 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1672
  {DBGFIELD(/*VINSERTPSrmi*/ 112975)       2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1673
  {DBGFIELD(/*VPBLENDWrmi*/ 112988)        2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1674
  {DBGFIELD(/*PMULUDQrm_VPMULUDQrm*/ 113000) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1675
  {DBGFIELD(/*VPMULDQrm*/ 113021)          2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1676
  {DBGFIELD(/*PMULUDQrr_VPMULUDQrr*/ 113031) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1677
  {DBGFIELD(/*VPMULDQYrr_VPMULUDQYrr*/ 113052) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1678
  {DBGFIELD(/*VMOVSDto64Zrr*/ 113075)      1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1679
  {DBGFIELD(/*VPMULDQrr*/ 113089)          1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1680
  {DBGFIELD(/*VPBROADCASTWYrm*/ 113099)    2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1681
  {DBGFIELD(/*VCMPPDYrmi*/ 113115)         2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1682
  {DBGFIELD(/*VCMPPSYrmi*/ 113126)         2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1683
  {DBGFIELD(/*VCVTPS2DQrm_VCVTTPS2DQrm*/ 113137) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1684
  {DBGFIELD(/*VPSHUFDYmi_VPSHUFHWYmi_VPSHUFLWYmi*/ 113162) 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1685
  {DBGFIELD(/*VPBLENDWrri*/ 113197)        1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1686
  {DBGFIELD(/*VUNPCKHPDYrm_VUNPCKHPSYrm_VUNPCKLPDYrm_VUNPCKLPSYrm*/ 113209) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #1687
  {DBGFIELD(/*VPMULDQYrm_VPMULUDQYrm*/ 113261) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1688
  {DBGFIELD(/*VSHA512RNDS2rr*/ 113284)     1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1689
  {DBGFIELD(/*VSM3MSG1rm_VSM3MSG2rm*/ 113299) 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1690
  {DBGFIELD(/*VSM3MSG1rr_VSM3MSG2rr*/ 113321) 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1691
  {DBGFIELD(/*VTESTPSYrr*/ 113343)         1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1692
  {DBGFIELD(/*VMOVAPDZrr_VMOVAPDZrr_REV_VMOVAPSZrr_VMOVAPSZrr_REV_VMOVUPDZrr_VMOVUPDZrr_REV_VMOVUPSZrr_VMOVUPSZrr_REV*/ 113354) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1693
  {DBGFIELD(/*VMOVDQA32Z256rr_VMOVDQA32Z256rr_REV_VMOVDQA64Z256rr_VMOVDQA64Z256rr_REV_VMOVDQAYrr_VMOVDQAYrr_REV_VMOVDQUYrr_VMOVDQUYrr_REV_VMOVDQU16Z256rr_VMOVDQU16Z256rr_REV_VMOVDQU32Z256rr_VMOVDQU32Z256rr_REV_VMOVDQU64Z256rr_VMOVDQU64Z256rr_REV_VMOVDQU8Z256rr_VMOVDQU8Z256rr_REV*/ 113458) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1694
  {DBGFIELD(/*VMOVDQA32Zrr_VMOVDQA32Zrr_REV_VMOVDQA64Zrr_VMOVDQA64Zrr_REV_VMOVDQU16Zrr_VMOVDQU16Zrr_REV_VMOVDQU32Zrr_VMOVDQU32Zrr_REV_VMOVDQU64Zrr_VMOVDQU64Zrr_REV_VMOVDQU8Zrr_VMOVDQU8Zrr_REV*/ 113724) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1695
  {DBGFIELD(/*ADDPSrm_SUBPSrm_VADDPSrm_VSUBPSrm_ADDSUBPSrm_VADDSUBPSrm_VADDPSZ128rm_VADDPSZ128rmb_VADDPSZ128rmbk_VADDPSZ128rmk_VADDPSZ128rmkz_VSUBPSZ128rm_VSUBPSZ128rmb_VSUBPSZ128rmbk_VSUBPSZ128rmk_VSUBPSZ128rmkz_VADDPSZ128rmbkz_VSUBPSZ128rmbkz*/ 113902) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1696
  {DBGFIELD(/*ADDPSrr_SUBPSrr_VADDPSrr_VSUBPSrr_ADDSUBPSrr_VADDSUBPSrr_VADDPSZ128rr_VADDPSZ128rrk_VSUBPSZ128rr_VSUBPSZ128rrk*/ 114133) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1697
  {DBGFIELD(/*VADDPSYrr_VSUBPSYrr_VADDPSZ256rr_VADDPSZ256rrk_VSUBPSZ256rr_VSUBPSZ256rrk*/ 114244) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1698
  {DBGFIELD(/*VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz*/ 114318) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1699
  {DBGFIELD(/*VPSHUFBZ128rrk_VPSHUFBZ128rrkz*/ 114388) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1700
  {DBGFIELD(/*VPSHUFBZ256rrk_VPSHUFBZ256rrkz*/ 114419) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1701
  {DBGFIELD(/*VPSHUFHWZ128rik_VPSHUFHWZ128rikz_VPSHUFLWZ128rik_VPSHUFLWZ128rikz_VPUNPCKHBWZ128rrk_VPUNPCKHBWZ128rrkz_VPUNPCKHWDZ128rrk_VPUNPCKHWDZ128rrkz_VPUNPCKLBWZ128rrk_VPUNPCKLBWZ128rrkz_VPUNPCKLWDZ128rrk_VPUNPCKLWDZ128rrkz*/ 114450) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1702
  {DBGFIELD(/*VPSHUFHWZ256rik_VPSHUFHWZ256rikz_VPSHUFLWZ256rik_VPSHUFLWZ256rikz_VPUNPCKHBWZ256rrk_VPUNPCKHBWZ256rrkz_VPUNPCKHWDZ256rrk_VPUNPCKHWDZ256rrkz_VPUNPCKLBWZ256rrk_VPUNPCKLBWZ256rrkz_VPUNPCKLWDZ256rrk_VPUNPCKLWDZ256rrkz*/ 114664) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1703
  {DBGFIELD(/*VADDSUBPSYrr*/ 114878)       1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1704
  {DBGFIELD(/*VPOPCNTBZ128rm_VPOPCNTDZ128rm_VPOPCNTQZ128rm_VPOPCNTWZ128rm_VPOPCNTDZ128rmb_VPOPCNTDZ128rmk_VPOPCNTDZ128rmkz_VPOPCNTQZ128rmb_VPOPCNTQZ128rmk_VPOPCNTQZ128rmkz_VPOPCNTDZ128rmbk_VPOPCNTDZ128rmbkz_VPOPCNTQZ128rmbk_VPOPCNTQZ128rmbkz*/ 114891) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1705
  {DBGFIELD(/*VFPCLASSPDZ128mbi_VFPCLASSPSZ128mbi*/ 115119) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1706
  {DBGFIELD(/*VFPCLASSPHZ128mbi*/ 115155)  2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1707
  {DBGFIELD(/*VPACKSSDWZ128rm_VPACKSSWBZ128rm_VPACKUSDWZ128rm_VPACKUSWBZ128rm_VPACKSSDWZ128rmb_VPACKUSDWZ128rmb*/ 115173) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1708
  {DBGFIELD(/*VPMULTISHIFTQBZ128rm_VPMULTISHIFTQBZ128rmb*/ 115271) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1709
  {DBGFIELD(/*VFPCLASSPHZ128mi*/ 115314)   2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1710
  {DBGFIELD(/*VFPCLASSPDZ256mi_VFPCLASSPSZ256mi*/ 115331) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1711
  {DBGFIELD(/*VFPCLASSPDZmi_VFPCLASSPSZmi*/ 115365) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1712
  {DBGFIELD(/*VFPCLASSPHZ256mi*/ 115393)   2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1713
  {DBGFIELD(/*VFPCLASSPHZmi*/ 115410)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1714
  {DBGFIELD(/*VPERMBZ128rm*/ 115424)       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1715
  {DBGFIELD(/*VPEXPANDBZ128rmk_VPEXPANDBZ128rmkz_VPEXPANDBZ256rmk_VPEXPANDBZ256rmkz_VPEXPANDWZ128rmk_VPEXPANDWZ128rmkz_VPEXPANDWZ256rmk_VPEXPANDWZ256rmkz_VPEXPANDBZrmk_VPEXPANDBZrmkz_VPEXPANDWZrmk_VPEXPANDWZrmkz*/ 115437) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1716
  {DBGFIELD(/*ADD_FPrST0_ADD_FrST0_SUBR_FPrST0_SUBR_FrST0_SUB_FPrST0_SUB_FrST0_SUBR_FST0r_SUB_FST0r*/ 115635) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1717
  {DBGFIELD(/*KMOVBkr_KMOVDkr_KMOVWkr*/ 115721) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1718
  {DBGFIELD(/*VCMPPHZ128rri_VCMPPHZ128rrik_VFPCLASSPHZ128ri_VFPCLASSPHZ128rik*/ 115745) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1719
  {DBGFIELD(/*VCMPPHZ256rri_VCMPPHZ256rrik_VFPCLASSPHZ256ri_VFPCLASSPHZ256rik*/ 115809) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1720
  {DBGFIELD(/*VCMPSDZrri_VCMPSSZrri_VCMPSDZrri_Int_VCMPSDZrrik_Int_VCMPSSZrri_Int_VCMPSSZrrik_Int_VFPCLASSSDZri_VFPCLASSSDZrik_VFPCLASSSSZri_VFPCLASSSSZrik*/ 115873) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1721
  {DBGFIELD(/*VCMPSHZrri_VCMPSHZrri_Int_VCMPSHZrrik_Int_VFPCLASSSHZri_VFPCLASSSHZrik*/ 116015) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1722
  {DBGFIELD(/*VPACKSSDWZ128rr_VPACKSSWBZ128rr_VPACKUSDWZ128rr_VPACKUSWBZ128rr*/ 116086) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1723
  {DBGFIELD(/*VPACKSSDWZ256rr_VPACKSSWBZ256rr_VPACKUSDWZ256rr_VPACKUSWBZ256rr*/ 116150) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1724
  {DBGFIELD(/*VPALIGNRZ128rrik_VPALIGNRZ128rrikz*/ 116214) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1725
  {DBGFIELD(/*VPALIGNRZ256rrik_VPALIGNRZ256rrikz*/ 116249) 1, false, false, false, 86, 6,  1, 1,  0, 0}, // #1726
  {DBGFIELD(/*VPBROADCASTBZ128rrk_VPBROADCASTBZ128rrkz_VPBROADCASTWZ128rrk_VPBROADCASTWZ128rrkz*/ 116284) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1727
  {DBGFIELD(/*VPERMBZ128rr*/ 116366)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1728
  {DBGFIELD(/*VPERMBZ256rr_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz*/ 116379) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1729
  {DBGFIELD(/*VPERMBZrr_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz*/ 116668) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1730
  {DBGFIELD(/*VPERMQZrr_VPERMQZrrk_VPERMQZrrkz*/ 116867) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1731
  {DBGFIELD(/*VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz*/ 116900) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1732
  {DBGFIELD(/*VPMULTISHIFTQBZ128rr*/ 117092) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1733
  {DBGFIELD(/*VPMULTISHIFTQBZ256rr_VPOPCNTBZ256rr_VPOPCNTDZ256rr_VPOPCNTQZ256rr_VPOPCNTWZ256rr_VPOPCNTDZ256rrk_VPOPCNTDZ256rrkz_VPOPCNTQZ256rrk_VPOPCNTQZ256rrkz*/ 117113) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1734
  {DBGFIELD(/*VPOPCNTBZ128rr_VPOPCNTDZ128rr_VPOPCNTQZ128rr_VPOPCNTWZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz*/ 117260) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1735
  {DBGFIELD(/*VMOVSHDUPZ128rr_VMOVSHDUPZ128rrk_VMOVSHDUPZ128rrkz_VMOVSLDUPZ128rr_VMOVSLDUPZ128rrk_VMOVSLDUPZ128rrkz_VSHUFPDZ128rri_VSHUFPDZ128rrik_VSHUFPDZ128rrikz_VSHUFPSZ128rri_VSHUFPSZ128rrik_VSHUFPSZ128rrikz*/ 117386) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1736
  {DBGFIELD(/*VMOVSHDUPZ256rr_VMOVSHDUPZ256rrk_VMOVSHDUPZ256rrkz_VMOVSLDUPZ256rr_VMOVSLDUPZ256rrk_VMOVSLDUPZ256rrkz_VSHUFPDZ256rri_VSHUFPDZ256rrik_VSHUFPDZ256rrikz_VSHUFPSZ256rri_VSHUFPSZ256rrik_VSHUFPSZ256rrikz*/ 117584) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1737
  {DBGFIELD(/*VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz*/ 117782) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1738
  {DBGFIELD(/*VCVTPD2DQZ128rm_VCVTPD2DQZ128rmb_VCVTPD2DQZ128rmbk_VCVTPD2DQZ128rmk_VCVTPD2DQZ128rmkz_VCVTPD2UDQZ128rm_VCVTPD2UDQZ128rmb_VCVTPD2UDQZ128rmbk_VCVTPD2UDQZ128rmk_VCVTPD2UDQZ128rmkz_VCVTTPD2DQZ128rm_VCVTTPD2DQZ128rmb_VCVTTPD2DQZ128rmbk_VCVTTPD2DQZ128rmk_VCVTTPD2DQZ128rmkz_VCVTTPD2UDQZ128rm_VCVTTPD2UDQZ128rmb_VCVTTPD2UDQZ128rmbk_VCVTTPD2UDQZ128rmk_VCVTTPD2UDQZ128rmkz_VCVTPD2DQZ128rmbkz_VCVTPD2UDQZ128rmbkz_VCVTTPD2DQZ128rmbkz_VCVTTPD2UDQZ128rmbkz*/ 117827) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1739
  {DBGFIELD(/*VCVTPH2PSXZ128rm_VCVTPH2PSXZ128rmb*/ 118271) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1740
  {DBGFIELD(/*VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz_VCVTQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmbkz*/ 118306) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1741
  {DBGFIELD(/*VCVTSI642SSZrm_VCVTSI642SSZrm_Int_VCVTUSI642SSZrm_VCVTUSI642SSZrm_Int*/ 118522) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1742
  {DBGFIELD(/*VCVTSD2SIZrm_VCVTTSD2SIZrm_VCVTSD2SIZrm_Int_VCVTTSD2SIZrm_Int*/ 118592) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1743
  {DBGFIELD(/*VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_Int*/ 118654) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #1744
  {DBGFIELD(/*CVTSI2SSrr_Int_VCVTSI2SSrr_Int_VCVTSI2SSZrr_VCVTUSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int*/ 118691) 2, false, false, false, 254, 10,  4, 1,  7, 1}, // #1745
  {DBGFIELD(/*VCVTSS2SI64Zrr_VCVTTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int*/ 118821) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #1746
  {DBGFIELD(/*DIVSDrm_VDIVSDrm*/ 119016)   2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1747
  {DBGFIELD(/*VDIVSDZrm*/ 119033)          2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1748
  {DBGFIELD(/*VSQRTSHZm_Int_VSQRTSHZmk_Int_VSQRTSHZmkz_Int*/ 119043) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1749
  {DBGFIELD(/*VSQRTSHZm*/ 119088)          2, false, false, false, 243, 11, 17, 1,  6, 1}, // #1750
  {DBGFIELD(/*ENQCMD16_ENQCMD32_ENQCMD64_ENQCMDS16_ENQCMDS32_ENQCMDS64*/ 119098) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1751
  {DBGFIELD(/*VPMOVQDZ256mr_VPMOVQDZmr*/ 119155) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1752
  {DBGFIELD(/*VPERMWZrr*/ 119180)          1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1753
  {DBGFIELD(/*VPEXPANDBZ256rm_VPEXPANDBZrm_VPEXPANDWZ256rm_VPEXPANDWZrm*/ 119190) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1754
  {DBGFIELD(/*VPADDBZrr_VPADDDZrr_VPADDQZrr_VPADDWZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrrk_VPADDQZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz*/ 119248) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1755
  {DBGFIELD(/*VPLZCNTDZ256rm_VPLZCNTDZ256rmb_VPLZCNTDZ256rmbk_VPLZCNTDZ256rmk_VPLZCNTDZ256rmkz_VPLZCNTQZ256rm_VPLZCNTQZ256rmb_VPLZCNTQZ256rmbk_VPLZCNTQZ256rmk_VPLZCNTQZ256rmkz_VPLZCNTDZ256rmbkz_VPLZCNTQZ256rmbkz*/ 119476) 2, false, false, false, 101, 7, 24, 1,  0, 0}, // #1756
  {DBGFIELD(/*VADDPHZ128rm_VADDPHZ128rmb_VADDPHZ128rmbk_VADDPHZ128rmk_VADDPHZ128rmkz_VSUBPHZ128rm_VSUBPHZ128rmb_VSUBPHZ128rmbk_VSUBPHZ128rmk_VSUBPHZ128rmkz_VADDPHZ128rmbkz_VSUBPHZ128rmbkz*/ 119674) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1757
  {DBGFIELD(/*VGETEXPPHZ128m_VGETEXPPHZ128mb_VGETEXPPHZ128mbk_VGETEXPPHZ128mk_VGETEXPPHZ128mkz_VGETEXPSHZm_VGETEXPSHZmk_VGETEXPSHZmkz_VGETMANTPHZ128rmbi_VGETMANTPHZ128rmik_VGETMANTPHZ128rmbik_VGETMANTPHZ128rmbikz_VGETMANTPHZ128rmi_VGETMANTPHZ128rmikz_VGETMANTSHZrmi_VGETMANTSHZrmik_VGETMANTSHZrmikz*/ 119848) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1758
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ128rmbi_VGF2P8AFFINEINVQBZ128rmi_VGF2P8AFFINEQBZ128rmbi_VGF2P8AFFINEQBZ128rmi*/ 120133) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1759
  {DBGFIELD(/*VMAXCPHZ128rm_VMAXCPHZ128rmb_VMAXCPHZ128rmbk_VMAXCPHZ128rmk_VMAXCPHZ128rmkz_VMINCPHZ128rm_VMINCPHZ128rmb_VMINCPHZ128rmbk_VMINCPHZ128rmk_VMINCPHZ128rmkz_VMAXCPHZ128rmbkz_VMINCPHZ128rmbkz_VMAXPHZ128rm_VMAXPHZ128rmb_VMAXPHZ128rmbk_VMAXPHZ128rmk_VMAXPHZ128rmkz_VMINPHZ128rm_VMINPHZ128rmb_VMINPHZ128rmbk_VMINPHZ128rmk_VMINPHZ128rmkz_VMAXPHZ128rmbkz_VMINPHZ128rmbkz*/ 120229) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1760
  {DBGFIELD(/*VMULPHZ128rm_VMULPHZ128rmb_VMULPHZ128rmbk_VMULPHZ128rmk_VMULPHZ128rmkz_VMULPHZ128rmbkz*/ 120589) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1761
  {DBGFIELD(/*VGETEXPPHZ128mbkz*/ 120676)  3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1762
  {DBGFIELD(/*VGF2P8MULBZ128rm*/ 120694)   2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1763
  {DBGFIELD(/*VADDSHZrm_VSUBSHZrm_VADDSHZrm_Int_VADDSHZrmk_Int_VADDSHZrmkz_Int_VSUBSHZrm_Int_VSUBSHZrmk_Int_VSUBSHZrmkz_Int*/ 120711) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #1764
  {DBGFIELD(/*VCVTSH2SSZrm_VCVTSH2SSZrm_Int*/ 120821) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1765
  {DBGFIELD(/*VMAXCSHZrm_VMINCSHZrm_VMAXSHZrm_VMINSHZrm_VMAXSHZrm_Int_VMAXSHZrmk_Int_VMAXSHZrmkz_Int_VMINSHZrm_Int_VMINSHZrmk_Int_VMINSHZrmkz_Int*/ 120851) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1766
  {DBGFIELD(/*VMULSHZrm_VMULSHZrm_Int_VMULSHZrmk_Int_VMULSHZrmkz_Int*/ 120983) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1767
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ256rmbi_VGF2P8AFFINEINVQBZ256rmi_VGF2P8AFFINEQBZ256rmbi_VGF2P8AFFINEQBZ256rmi*/ 121038) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #1768
  {DBGFIELD(/*VGF2P8MULBZ256rm*/ 121134)   2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1769
  {DBGFIELD(/*VFMADD132PHZ128m_VFMADD132PHZ128mb_VFMADD132PHZ128mbk_VFMADD132PHZ128mk_VFMADD132PHZ128mkz_VFMADD213PHZ128m_VFMADD213PHZ128mb_VFMADD213PHZ128mbk_VFMADD213PHZ128mk_VFMADD213PHZ128mkz_VFMADD231PHZ128m_VFMADD231PHZ128mb_VFMADD231PHZ128mbk_VFMADD231PHZ128mk_VFMADD231PHZ128mkz_VFMSUB132PHZ128m_VFMSUB132PHZ128mb_VFMSUB132PHZ128mbk_VFMSUB132PHZ128mk_VFMSUB132PHZ128mkz_VFMSUB213PHZ128m_VFMSUB213PHZ128mb_VFMSUB213PHZ128mbk_VFMSUB213PHZ128mk_VFMSUB213PHZ128mkz_VFMSUB231PHZ128m_VFMSUB231PHZ128mb_VFMSUB231PHZ128mbk_VFMSUB231PHZ128mk_VFMSUB231PHZ128mkz_VFNMADD132PHZ128m_VFNMADD132PHZ128mb_VFNMADD132PHZ128mbk_VFNMADD132PHZ128mk_VFNMADD132PHZ128mkz_VFNMADD213PHZ128m_VFNMADD213PHZ128mb_VFNMADD213PHZ128mbk_VFNMADD213PHZ128mk_VFNMADD213PHZ128mkz_VFNMADD231PHZ128m_VFNMADD231PHZ128mb_VFNMADD231PHZ128mbk_VFNMADD231PHZ128mk_VFNMADD231PHZ128mkz_VFNMSUB132PHZ128m_VFNMSUB132PHZ128mb_VFNMSUB132PHZ128mbk_VFNMSUB132PHZ128mk_VFNMSUB132PHZ128mkz_VFNMSUB213PHZ128m_VFNMSUB213PHZ128mb_VFNMSUB213PHZ128mbk_VFNMSUB213PHZ128mk_VFNMSUB213PHZ128mkz_VFNMSUB231PHZ128m_VFNMSUB231PHZ128mb_VFNMSUB231PHZ128mbk_VFNMSUB231PHZ128mk_VFNMSUB231PHZ128mkz_VFMADD132PHZ128mbkz_VFMADD213PHZ128mbkz_VFMADD231PHZ128mbkz_VFMSUB132PHZ128mbkz_VFMSUB213PHZ128mbkz_VFMSUB231PHZ128mbkz_VFNMADD132PHZ128mbkz_VFNMADD213PHZ128mbkz_VFNMADD231PHZ128mbkz_VFNMSUB132PHZ128mbkz_VFNMSUB213PHZ128mbkz_VFNMSUB231PHZ128mbkz_VFMADDSUB132PHZ128m_VFMADDSUB132PHZ128mb_VFMADDSUB132PHZ128mbk_VFMADDSUB132PHZ128mk_VFMADDSUB132PHZ128mkz_VFMADDSUB213PHZ128m_VFMADDSUB213PHZ128mb_VFMADDSUB213PHZ128mbk_VFMADDSUB213PHZ128mk_VFMADDSUB213PHZ128mkz_VFMADDSUB231PHZ128m_VFMADDSUB231PHZ128mb_VFMADDSUB231PHZ128mbk_VFMADDSUB231PHZ128mk_VFMADDSUB231PHZ128mkz_VFMADDSUB132PHZ128mbkz_VFMADDSUB213PHZ128mbkz_VFMADDSUB231PHZ128mbkz_VFMSUBADD132PHZ128m_VFMSUBADD132PHZ128mb_VFMSUBADD132PHZ128mbk_VFMSUBADD132PHZ128mk_VFMSUBADD132PHZ128mkz_VFMSUBADD213PHZ128m_VFMSUBADD213PHZ128mb_VFMSUBADD213PHZ128mbk_VFMSUBADD213PHZ128mk_VFMSUBADD213PHZ128mkz_VFMSUBADD231PHZ128m_VFMSUBADD231PHZ128mb_VFMSUBADD231PHZ128mbk_VFMSUBADD231PHZ128mk_VFMSUBADD231PHZ128mkz_VFMSUBADD132PHZ128mbkz_VFMSUBADD213PHZ128mbkz_VFMSUBADD231PHZ128mbkz*/ 121151) 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #1770
  {DBGFIELD(/*VFMADD132SHZm_VFMADD213SHZm_VFMADD231SHZm_VFMSUB132SHZm_VFMSUB213SHZm_VFMSUB231SHZm_VFNMADD132SHZm_VFNMADD213SHZm_VFNMADD231SHZm_VFNMSUB132SHZm_VFNMSUB213SHZm_VFNMSUB231SHZm_VFMADD132SHZm_Int_VFMADD132SHZmk_Int_VFMADD132SHZmkz_Int_VFMADD213SHZm_Int_VFMADD213SHZmk_Int_VFMADD213SHZmkz_Int_VFMADD231SHZm_Int_VFMADD231SHZmk_Int_VFMADD231SHZmkz_Int_VFMSUB132SHZm_Int_VFMSUB132SHZmk_Int_VFMSUB132SHZmkz_Int_VFMSUB213SHZm_Int_VFMSUB213SHZmk_Int_VFMSUB213SHZmkz_Int_VFMSUB231SHZm_Int_VFMSUB231SHZmk_Int_VFMSUB231SHZmkz_Int_VFNMADD132SHZm_Int_VFNMADD132SHZmk_Int_VFNMADD132SHZmkz_Int_VFNMADD213SHZm_Int_VFNMADD213SHZmk_Int_VFNMADD213SHZmkz_Int_VFNMADD231SHZm_Int_VFNMADD231SHZmk_Int_VFNMADD231SHZmkz_Int_VFNMSUB132SHZm_Int_VFNMSUB132SHZmk_Int_VFNMSUB132SHZmkz_Int_VFNMSUB213SHZm_Int_VFNMSUB213SHZmk_Int_VFNMSUB213SHZmkz_Int_VFNMSUB231SHZm_Int_VFNMSUB231SHZmk_Int_VFNMSUB231SHZmkz_Int*/ 123293) 2, false, false, false, 101, 7,  8, 1, 10, 2}, // #1771
  {DBGFIELD(/*VPMADD52HUQZ256m_VPMADD52HUQZ256mb_VPMADD52HUQZ256mbk_VPMADD52HUQZ256mk_VPMADD52HUQZ256mkz_VPMADD52LUQZ256m_VPMADD52LUQZ256mb_VPMADD52LUQZ256mbk_VPMADD52LUQZ256mk_VPMADD52LUQZ256mkz_VPMADD52HUQZ256mbkz_VPMADD52LUQZ256mbkz*/ 124169) 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #1772
  {DBGFIELD(/*VADDPHZ128rr_VSUBPHZ128rr*/ 124391) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1773
  {DBGFIELD(/*VADDPHZ256rr_VSUBPHZ256rr*/ 124417) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1774
  {DBGFIELD(/*VADDSHZrr_VSUBSHZrr_VADDSHZrr_Int_VADDSHZrrb_Int_VSUBSHZrr_Int_VSUBSHZrrb_Int*/ 124443) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1775
  {DBGFIELD(/*VCVTPH2UWZ128rr_VCVTPH2WZ128rr_VCVTTPH2UWZ128rr_VCVTTPH2WZ128rr_VCVTUW2PHZ128rr_VCVTW2PHZ128rr*/ 124521) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1776
  {DBGFIELD(/*VCVTPH2UWZ256rr_VCVTPH2WZ256rr_VCVTTPH2UWZ256rr_VCVTTPH2WZ256rr_VCVTUW2PHZ256rr_VCVTW2PHZ256rr*/ 124616) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1777
  {DBGFIELD(/*VCVTSH2SSZrr_Int_VCVTSH2SSZrrb_Int*/ 124711) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1778
  {DBGFIELD(/*VFMADD132PHZ128r_VFMADD213PHZ128r_VFMADD231PHZ128r_VFMSUB132PHZ128r_VFMSUB213PHZ128r_VFMSUB231PHZ128r_VFNMADD132PHZ128r_VFNMADD213PHZ128r_VFNMADD231PHZ128r_VFNMSUB132PHZ128r_VFNMSUB213PHZ128r_VFNMSUB231PHZ128r_VFMADDSUB132PHZ128r_VFMADDSUB213PHZ128r_VFMADDSUB231PHZ128r_VFMSUBADD132PHZ128r_VFMSUBADD213PHZ128r_VFMSUBADD231PHZ128r*/ 124746) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1779
  {DBGFIELD(/*VFMADD132PHZ256r_VFMADD213PHZ256r_VFMADD231PHZ256r_VFMSUB132PHZ256r_VFMSUB213PHZ256r_VFMSUB231PHZ256r_VFNMADD132PHZ256r_VFNMADD213PHZ256r_VFNMADD231PHZ256r_VFNMSUB132PHZ256r_VFNMSUB213PHZ256r_VFNMSUB231PHZ256r_VFMADDSUB132PHZ256r_VFMADDSUB213PHZ256r_VFMADDSUB231PHZ256r_VFMSUBADD132PHZ256r_VFMSUBADD213PHZ256r_VFMSUBADD231PHZ256r*/ 125076) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1780
  {DBGFIELD(/*VFMADD132SHZr_VFMADD132SHZr_Int_VFMADD132SHZrb_VFMADD132SHZrb_Int_VFMADD213SHZr_VFMADD213SHZr_Int_VFMADD213SHZrb_VFMADD213SHZrb_Int_VFMADD231SHZr_VFMADD231SHZr_Int_VFMADD231SHZrb_VFMADD231SHZrb_Int_VFMSUB132SHZr_VFMSUB132SHZr_Int_VFMSUB132SHZrb_VFMSUB132SHZrb_Int_VFMSUB213SHZr_VFMSUB213SHZr_Int_VFMSUB213SHZrb_VFMSUB213SHZrb_Int_VFMSUB231SHZr_VFMSUB231SHZr_Int_VFMSUB231SHZrb_VFMSUB231SHZrb_Int_VFNMADD132SHZr_VFNMADD132SHZr_Int_VFNMADD132SHZrb_VFNMADD132SHZrb_Int_VFNMADD213SHZr_VFNMADD213SHZr_Int_VFNMADD213SHZrb_VFNMADD213SHZrb_Int_VFNMADD231SHZr_VFNMADD231SHZr_Int_VFNMADD231SHZrb_VFNMADD231SHZrb_Int_VFNMSUB132SHZr_VFNMSUB132SHZr_Int_VFNMSUB132SHZrb_VFNMSUB132SHZrb_Int_VFNMSUB213SHZr_VFNMSUB213SHZr_Int_VFNMSUB213SHZrb_VFNMSUB213SHZrb_Int_VFNMSUB231SHZr_VFNMSUB231SHZr_Int_VFNMSUB231SHZrb_VFNMSUB231SHZrb_Int*/ 125406) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1781
  {DBGFIELD(/*VGETEXPPHZ128r_VGETEXPSHZr_VGETEXPSHZrb_VGETMANTPHZ128rri_VGETMANTSHZrri_VGETMANTSHZrrib*/ 126222) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1782
  {DBGFIELD(/*VGETEXPPHZ256r_VGETMANTPHZ256rri*/ 126311) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1783
  {DBGFIELD(/*VGF2P8MULBZ128rr*/ 126344)   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1784
  {DBGFIELD(/*VGF2P8MULBZ256rr*/ 126361)   1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1785
  {DBGFIELD(/*VMAXCPHZ128rr_VMINCPHZ128rr_VMAXPHZ128rr_VMINPHZ128rr*/ 126378) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1786
  {DBGFIELD(/*VMAXCPHZ256rr_VMINCPHZ256rr_VMAXPHZ256rr_VMINPHZ256rr*/ 126432) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1787
  {DBGFIELD(/*VMAXCSHZrr_VMINCSHZrr_VMAXSHZrr_VMINSHZrr_VMAXSHZrr_Int_VMAXSHZrrb_Int_VMINSHZrr_Int_VMINSHZrrb_Int*/ 126486) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1788
  {DBGFIELD(/*VMULPHZ128rr*/ 126586)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1789
  {DBGFIELD(/*VMULPHZ256rr*/ 126599)       1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1790
  {DBGFIELD(/*VMULSHZrr_VMULSHZrr_Int_VMULSHZrrb_Int*/ 126612) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1791
  {DBGFIELD(/*VCVTSH2SSZrr*/ 126651)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1792
  {DBGFIELD(/*VBROADCASTSSZ128rm*/ 126664) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1793
  {DBGFIELD(/*VMOVDDUPZ128rm_VMOVSHDUPZ128rm_VMOVSLDUPZ128rm*/ 126683) 2, false, false, false, 526, 11,  7, 1,  0, 0}, // #1794
  {DBGFIELD(/*VPBROADCASTDZ128rm_VPBROADCASTQZ128rm*/ 126730) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1795
  {DBGFIELD(/*VBROADCASTI32X2Z128rm*/ 126768) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1796
  {DBGFIELD(/*KANDBkk_KANDDkk_KANDNDkk_KANDNQkk_KANDNWkk_KANDQkk_KANDWkk_KNOTBkk_KNOTDkk_KNOTQkk_KNOTWkk_KORBkk_KORDkk_KORQkk_KORWkk_KXNORBkk_KXNORDkk_KXNORQkk_KXNORWkk_KXORBkk_KXORDkk_KXORQkk_KXORWkk*/ 126790) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #1797
  {DBGFIELD(/*VPABSBZrr_VPSUBSBZrr_VPABSDZrr_VPABSQZrr_VPABSWZrr_VPABSDZrrk_VPABSDZrrkz_VPABSQZrrk_VPABSQZrrkz_VPADDSBZrr_VPADDSWZrr_VPADDUSBZrr_VPADDUSWZrr_VPAVGBZrr_VPAVGWZrr_VPMAXSBZrr_VPMAXUDZrr_VPMAXUWZrr_VPMINSBZrr_VPMINUDZrr_VPMINUWZrr_VPMAXSDZrr_VPMAXUBZrr_VPMINSDZrr_VPMINUBZrr_VPMAXSDZrrk_VPMAXSDZrrkz_VPMAXUDZrrk_VPMAXUDZrrkz_VPMINSDZrrk_VPMINSDZrrkz_VPMINUDZrrk_VPMINUDZrrkz_VPMAXSWZrr_VPMINSWZrr_VPSUBSWZrr_VPSUBUSWZrr*/ 126977) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1798
  {DBGFIELD(/*VPSHLDDZrri_VPSHLDQZrri_VPSHLDWZrri_VPSHRDDZrri_VPSHRDQZrri_VPSHRDWZrri_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz*/ 127395) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1799
  {DBGFIELD(/*VPSHLDVDZr_VPSHLDVQZr_VPSHLDVWZr_VPSHRDVDZr_VPSHRDVQZr_VPSHRDVWZr*/ 127567) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1800
  {DBGFIELD(/*VPSUBUSBZrr*/ 127633)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1801
  {DBGFIELD(/*KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm*/ 127645) 1, false, false, false, 39, 3, 10, 1,  0, 0}, // #1802
  {DBGFIELD(/*KMOVBmk*/ 127677)            2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1803
  {DBGFIELD(/*VBROADCASTSSZ128rr_VBROADCASTSSZ128rrk_VBROADCASTSSZ128rrkz*/ 127685) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1804
  {DBGFIELD(/*VPALIGNRZrri*/ 127745)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1805
  {DBGFIELD(/*VPSHUFDZri_VPSHUFHWZri_VPSHUFLWZri_VPSHUFDZrik_VPSHUFDZrikz_VPUNPCKHBWZrr_VPUNPCKHWDZrr_VPUNPCKLBWZrr_VPUNPCKLWDZrr_VPUNPCKHDQZrr_VPUNPCKHDQZrrk_VPUNPCKHDQZrrkz_VPUNPCKLDQZrr_VPUNPCKLDQZrrk_VPUNPCKLDQZrrkz_VPUNPCKLQDQZrr_VPUNPCKLQDQZrrk_VPUNPCKLQDQZrrkz_VPUNPCKHQDQZrr_VPUNPCKHQDQZrrk_VPUNPCKHQDQZrrkz*/ 127758) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1806
  {DBGFIELD(/*VPSHUFBZrr*/ 128060)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1807
  {DBGFIELD(/*VPABSBZrrk_VPABSBZrrkz_VPABSWZrrk_VPABSWZrrkz_VPSUBSBZrrk_VPSUBSBZrrkz_VPSUBSWZrrk_VPSUBSWZrrkz_VPADDSBZrrk_VPADDSBZrrkz_VPADDSWZrrk_VPADDSWZrrkz_VPADDUSBZrrk_VPADDUSBZrrkz_VPADDUSWZrrk_VPADDUSWZrrkz_VPAVGBZrrk_VPAVGBZrrkz_VPAVGWZrrk_VPAVGWZrrkz_VPMAXSBZrrk_VPMAXSBZrrkz_VPMAXUWZrrk_VPMAXUWZrrkz_VPMINSBZrrk_VPMINSBZrrkz_VPMINUWZrrk_VPMINUWZrrkz_VPMAXSWZrrk_VPMAXSWZrrkz_VPMAXUBZrrk_VPMAXUBZrrkz_VPMINSWZrrk_VPMINSWZrrkz_VPMINUBZrrk_VPMINUBZrrkz_VPSUBUSBZrrk_VPSUBUSBZrrkz_VPSUBUSWZrrk_VPSUBUSWZrrkz*/ 128071) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1808
  {DBGFIELD(/*VPSHLDVWZrk_VPSHLDVWZrkz_VPSHRDVWZrk_VPSHRDVWZrkz*/ 128571) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1809
  {DBGFIELD(/*VPSLLVWZrrk_VPSLLVWZrrkz_VPSRLVWZrrk_VPSRLVWZrrkz_VPSRAVWZrrk_VPSRAVWZrrkz*/ 128621) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1810
  {DBGFIELD(/*VPSLLWZrik_VPSLLWZrikz_VPSRLWZrik_VPSRLWZrikz_VPSRAWZrik_VPSRAWZrikz*/ 128696) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1811
  {DBGFIELD(/*VCVTPH2DQZ128rr_VCVTPH2UDQZ128rr_VCVTTPH2DQZ128rr_VCVTTPH2UDQZ128rr*/ 128765) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1812
  {DBGFIELD(/*VCVTPH2DQZ256rr_VCVTPH2UDQZ256rr_VCVTTPH2DQZ256rr_VCVTTPH2UDQZ256rr*/ 128833) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1813
  {DBGFIELD(/*VCVTPH2PSXZ256rr*/ 128901)   2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1814
  {DBGFIELD(/*VCVTPS2PHXZ256rr*/ 128918)   2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1815
  {DBGFIELD(/*VCVTPH2PSXZ128rr*/ 128935)   2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1816
  {DBGFIELD(/*VCVTPS2PHXZ128rr*/ 128952)   2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1817
  {DBGFIELD(/*VPERMWZ128rrk_VPERMWZ128rrkz*/ 128969) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1818
  {DBGFIELD(/*VPERMWZ256rrk_VPERMWZ256rrkz*/ 128998) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1819
  {DBGFIELD(/*VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRLWZ256rrk_VPSRLWZ256rrkz_VPSRAWZ256rrk_VPSRAWZ256rrkz*/ 129027) 2, false, false, false, 254, 10, 14, 1,  0, 0}, // #1820
  {DBGFIELD(/*VMOVSHZmr_VMOVWmr*/ 129114)  2, false, false, false, 35, 4,  2, 1,  0, 0}, // #1821
  {DBGFIELD(/*VBROADCASTF32X2Z256rm_VBROADCASTI32X2Z256rm_VBROADCASTF32X2Zrm_VBROADCASTI32X2Zrm_VPBROADCASTQZrm_VPBROADCASTDZ256rm_VPBROADCASTQZ256rm_VPBROADCASTDZrm*/ 129132) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1822
  {DBGFIELD(/*VBROADCASTF32X4Z256rm_VBROADCASTI32X4Z256rm_VBROADCASTF32X8Zrm_VBROADCASTI32X8Zrm_VBROADCASTF32X4Zrm_VBROADCASTF64X4Zrm_VBROADCASTI32X4Zrm_VBROADCASTI64X4Zrm_VBROADCASTF64X2Z256rm_VBROADCASTF64X2Zrm_VBROADCASTI64X2Z256rm_VBROADCASTI64X2Zrm*/ 129284) 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1823
  {DBGFIELD(/*VBROADCASTSSZrm_VBROADCASTSDZ256rm_VBROADCASTSSZ256rm_VBROADCASTSDZrm*/ 129524) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1824
  {DBGFIELD(/*VMOVDDUPZrm_VMOVSHDUPZrm_VMOVSLDUPZrm*/ 129594) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1825
  {DBGFIELD(/*VMOVDDUPZ256rm_VMOVSHDUPZ256rm_VMOVSLDUPZ256rm*/ 129632) 2, false, false, false, 526, 11, 22, 1,  0, 0}, // #1826
  {DBGFIELD(/*VPMOVDBZrr_VPMOVQBZrr_VPMOVSQBZrr_VPMOVSWBZrr_VPMOVWBZrr_VPMOVDWZrr_VPMOVQWZrr_VPMOVSDWZrr_VPMOVSQWZrr_VPMOVUSDWZrr_VPMOVSDBZrr_VPMOVSQDZrr_VPMOVUSDBZrr_VPMOVUSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSQBZrr_VPMOVUSWBZrr*/ 129679) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1827
  {DBGFIELD(/*VPMOVUSQWZrr*/ 129927)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1828
  {DBGFIELD(/*VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZrmk_VPBROADCASTQZrmkz*/ 129940) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1829
  {DBGFIELD(/*VBROADCASTF32X8Zrmk_VBROADCASTF32X8Zrmkz_VBROADCASTI32X8Zrmk_VBROADCASTI32X8Zrmkz_VBROADCASTF32X4Zrmk_VBROADCASTF32X4Zrmkz_VBROADCASTF64X4Zrmk_VBROADCASTF64X4Zrmkz_VBROADCASTI32X4Zrmk_VBROADCASTI32X4Zrmkz_VBROADCASTI64X4Zrmk_VBROADCASTI64X4Zrmkz_VBROADCASTF64X2Zrmk_VBROADCASTF64X2Zrmkz_VBROADCASTI64X2Zrmk_VBROADCASTI64X2Zrmkz*/ 130092) 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1830
  {DBGFIELD(/*VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZrmk_VBROADCASTSSZrmkz*/ 130420) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1831
  {DBGFIELD(/*VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZrmk_VMOVUPSZrmkz*/ 130490) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1832
  {DBGFIELD(/*VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Zrmk_VMOVDQU64Zrmkz*/ 130590) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1833
  {DBGFIELD(/*VINSERTF32X4Zrmi_VINSERTF32X4Zrmik_VINSERTF32X4Zrmikz_VINSERTF64X4Zrmi_VINSERTF64X4Zrmik_VINSERTF64X4Zrmikz_VINSERTF32X8Zrmi_VINSERTF32X8Zrmik_VINSERTF32X8Zrmikz_VINSERTF64X2Zrmi_VINSERTF64X2Zrmik_VINSERTF64X2Zrmikz*/ 130706) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1834
  {DBGFIELD(/*VINSERTI32X4Zrmi_VINSERTI32X4Zrmik_VINSERTI32X4Zrmikz_VINSERTI64X4Zrmi_VINSERTI64X4Zrmik_VINSERTI64X4Zrmikz_VINSERTI32X8Zrmi_VINSERTI32X8Zrmik_VINSERTI32X8Zrmikz_VINSERTI64X2Zrmi_VINSERTI64X2Zrmik_VINSERTI64X2Zrmikz*/ 130922) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1835
  {DBGFIELD(/*VPADDBZrm_VPADDDZrm_VPADDQZrm_VPADDWZrm_VPSUBBZrm_VPSUBDZrm_VPSUBQZrm_VPSUBWZrm_VPADDDZrmb_VPADDDZrmk_VPADDDZrmkz_VPADDQZrmb_VPADDQZrmk_VPADDQZrmkz_VPSUBDZrmb_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrmb_VPSUBQZrmk_VPSUBQZrmkz_VPADDDZrmbk_VPADDDZrmbkz_VPADDQZrmbk_VPADDQZrmbkz_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBQZrmbk_VPSUBQZrmbkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmik_VPTERNLOGQZrmbi_VPTERNLOGQZrmik_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmikz_VPTERNLOGQZrmi_VPTERNLOGQZrmikz*/ 131138) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1836
  {DBGFIELD(/*VPBROADCASTWZrm_VPBROADCASTBZ256rm_VPBROADCASTWZ256rm_VPBROADCASTBZrm*/ 131652) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1837
  {DBGFIELD(/*VFPCLASSPDZ128mi_VFPCLASSPSZ128mi*/ 131722) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1838
  {DBGFIELD(/*VFPCLASSSDZmi_VFPCLASSSSZmi*/ 131756) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1839
  {DBGFIELD(/*VFPCLASSSHZmi*/ 131784)      2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1840
  {DBGFIELD(/*VPALIGNRZ256rmi*/ 131798)    2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1841
  {DBGFIELD(/*VPSHUFBZrm*/ 131814)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1842
  {DBGFIELD(/*MOV16ri_MOV64ri_MOV8ri_MOV16ri_alt_MOV8ri_alt_MOV16rr_MOV16rr_REV_MOV8rr_MOV8rr_REV*/ 131825) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1843
  {DBGFIELD(/*MOV32ri_MOV32ri_alt*/ 131909) 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1844
  {DBGFIELD(/*MOV8rr_NOREX*/ 131929)       1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1845
  {DBGFIELD(/*VMOVLPDZ128rm_VMOVLPSZ128rm_VSHUFPDZ128rmbi_VSHUFPDZ128rmik_VSHUFPSZ128rmbi_VSHUFPSZ128rmik_VSHUFPDZ128rmbik_VSHUFPDZ128rmbikz_VSHUFPSZ128rmbik_VSHUFPSZ128rmbikz_VSHUFPDZ128rmi_VSHUFPDZ128rmikz_VSHUFPSZ128rmi_VSHUFPSZ128rmikz*/ 131942) 2, false, false, false, 526, 11,  7, 1,  6, 1}, // #1846
  {DBGFIELD(/*VMOVAPDZ128rrk_VMOVAPDZ128rrk_REV_VMOVAPDZ128rrkz_VMOVAPDZ128rrkz_REV_VMOVAPSZ128rrk_VMOVAPSZ128rrk_REV_VMOVAPSZ128rrkz_VMOVAPSZ128rrkz_REV_VMOVUPDZ128rrk_VMOVUPDZ128rrk_REV_VMOVUPDZ128rrkz_VMOVUPDZ128rrkz_REV_VMOVUPSZ128rrk_VMOVUPSZ128rrk_REV_VMOVUPSZ128rrkz_VMOVUPSZ128rrkz_REV*/ 132168) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1847
  {DBGFIELD(/*VMOVAPDZ256rrk_VMOVAPDZ256rrk_REV_VMOVAPDZ256rrkz_VMOVAPDZ256rrkz_REV_VMOVAPSZ256rrk_VMOVAPSZ256rrk_REV_VMOVAPSZ256rrkz_VMOVAPSZ256rrkz_REV_VMOVUPDZ256rrk_VMOVUPDZ256rrk_REV_VMOVUPDZ256rrkz_VMOVUPDZ256rrkz_REV_VMOVUPSZ256rrk_VMOVUPSZ256rrk_REV_VMOVUPSZ256rrkz_VMOVUPSZ256rrkz_REV*/ 132448) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1848
  {DBGFIELD(/*VMOVDQA32Z128rrk_VMOVDQA32Z128rrk_REV_VMOVDQA32Z128rrkz_VMOVDQA32Z128rrkz_REV_VMOVDQA64Z128rrk_VMOVDQA64Z128rrk_REV_VMOVDQA64Z128rrkz_VMOVDQA64Z128rrkz_REV_VMOVDQU32Z128rrk_VMOVDQU32Z128rrk_REV_VMOVDQU32Z128rrkz_VMOVDQU32Z128rrkz_REV_VMOVDQU64Z128rrk_VMOVDQU64Z128rrk_REV_VMOVDQU64Z128rrkz_VMOVDQU64Z128rrkz_REV_VPMOVM2DZ128rk_VPMOVM2QZ128rk*/ 132728) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1849
  {DBGFIELD(/*VMOVSHZrr_VMOVSHZrr_REV*/ 133070) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #1850
  {DBGFIELD(/*VPADDBZ128rr_VPADDDZ128rr_VPADDQZ128rr_VPADDWZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rrk_VPADDQZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz*/ 133094) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1851
  {DBGFIELD(/*VPADDBZ256rr_VPADDDZ256rr_VPADDQZ256rr_VPADDWZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rrk_VPADDQZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz*/ 133376) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #1852
  {DBGFIELD(/*VPABSBZrmk_VPABSBZrmkz_VPABSWZrmk_VPABSWZrmkz*/ 133658) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1853
  {DBGFIELD(/*VPSLLWZmik_VPSLLWZmikz_VPSRLWZmik_VPSRLWZmikz_VPSRAWZmik_VPSRAWZmikz*/ 133704) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1854
  {DBGFIELD(/*VPADDSBZrmk_VPADDSBZrmkz_VPADDSWZrmk_VPADDSWZrmkz_VPADDUSBZrmk_VPADDUSBZrmkz_VPADDUSWZrmk_VPADDUSWZrmkz_VPSUBSBZrmk_VPSUBSBZrmkz_VPSUBSWZrmk_VPSUBSWZrmkz_VPSUBUSBZrmk_VPSUBUSBZrmkz_VPSUBUSWZrmk_VPSUBUSWZrmkz_VPAVGBZrmk_VPAVGBZrmkz_VPAVGWZrmk_VPAVGWZrmkz_VPMAXSBZrmk_VPMAXSBZrmkz_VPMAXUWZrmk_VPMAXUWZrmkz_VPMINSBZrmk_VPMINSBZrmkz_VPMINUWZrmk_VPMINUWZrmkz_VPMAXSWZrmk_VPMAXSWZrmkz_VPMAXUBZrmk_VPMAXUBZrmkz_VPMINSWZrmk_VPMINSWZrmkz_VPMINUBZrmk_VPMINUBZrmkz*/ 133773) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1855
  {DBGFIELD(/*VPSHLDVWZmk_VPSHLDVWZmkz_VPSHRDVWZmk_VPSHRDVWZmkz*/ 134227) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1856
  {DBGFIELD(/*VPSLLVWZrmk_VPSLLVWZrmkz_VPSRLVWZrmk_VPSRLVWZrmkz_VPSRAVWZrmk_VPSRAVWZrmkz*/ 134277) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1857
  {DBGFIELD(/*VPSLLWZrmk_VPSLLWZrmkz_VPSRLWZrmk_VPSRLWZrmkz_VPSRAWZrmk_VPSRAWZrmkz*/ 134352) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1858
  {DBGFIELD(/*VCOMISHZrr_VCOMISHZrrb_VUCOMISHZrr_VUCOMISHZrrb_VCOMISHZrr_Int_VUCOMISHZrr_Int*/ 134421) 1, false, false, false,  3, 9,  6, 1,  0, 0}, // #1859
  {DBGFIELD(/*VCVTPD2QQZrrb_VCVTPD2QQZrrbk_VCVTPD2QQZrrk_VCVTPD2QQZrrkz_VCVTPD2UQQZrrb_VCVTPD2UQQZrrbk_VCVTPD2UQQZrrk_VCVTPD2UQQZrrkz_VCVTTPD2QQZrrb_VCVTTPD2QQZrrbk_VCVTTPD2QQZrrk_VCVTTPD2QQZrrkz_VCVTTPD2UQQZrrb_VCVTTPD2UQQZrrbk_VCVTTPD2UQQZrrk_VCVTTPD2UQQZrrkz_VCVTPD2QQZrrbkz_VCVTPD2UQQZrrbkz_VCVTTPD2QQZrrbkz_VCVTTPD2UQQZrrbkz*/ 134500) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1860
  {DBGFIELD(/*VCVTPS2DQZrrb_VCVTPS2DQZrrbk_VCVTPS2DQZrrk_VCVTPS2DQZrrkz_VCVTPS2UDQZrrb_VCVTPS2UDQZrrbk_VCVTPS2UDQZrrk_VCVTPS2UDQZrrkz_VCVTTPS2DQZrrb_VCVTTPS2DQZrrbk_VCVTTPS2DQZrrk_VCVTTPS2DQZrrkz_VCVTTPS2UDQZrrb_VCVTTPS2UDQZrrbk_VCVTTPS2UDQZrrk_VCVTTPS2UDQZrrkz_VCVTPS2DQZrrbkz_VCVTPS2UDQZrrbkz_VCVTTPS2DQZrrbkz_VCVTTPS2UDQZrrbkz*/ 134816) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1861
  {DBGFIELD(/*VMAXCPSZrr_VMAXCPSZrrk_VMAXCPSZrrkz_VMAXPSZrr_VMAXPSZrrk_VMAXPSZrrkz_VMINCPSZrr_VMINCPSZrrk_VMINCPSZrrkz_VMINPSZrr_VMINPSZrrk_VMINPSZrrkz_VMAXPSZrrb_VMAXPSZrrbk_VMAXPSZrrbkz_VMINPSZrrb_VMINPSZrrbk_VMINPSZrrbkz*/ 135132) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1862
  {DBGFIELD(/*VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz*/ 135342) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1863
  {DBGFIELD(/*VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz*/ 135420) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1864
  {DBGFIELD(/*VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rmk_VMOVUPSZ128rmkz*/ 135510) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1865
  {DBGFIELD(/*VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz*/ 135634) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1866
  {DBGFIELD(/*VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrmk_VMOVSSZrmkz*/ 135774) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #1867
  {DBGFIELD(/*VPADDBZ128rm_VPADDDZ128rm_VPADDQZ128rm_VPADDWZ128rm_VPSUBBZ128rm_VPSUBDZ128rm_VPSUBQZ128rm_VPSUBWZ128rm_VPADDDZ128rmb_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rmb_VPADDQZ128rmk_VPADDQZ128rmkz_VPSUBDZ128rmb_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rmb_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmik_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmik_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmikz*/ 135820) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1868
  {DBGFIELD(/*VPBROADCASTBZ128rm_VPBROADCASTWZ128rm*/ 136454) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1869
  {DBGFIELD(/*VPALIGNRZ128rmi*/ 136492)    2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1870
  {DBGFIELD(/*VPEXTRDZmri_VPEXTRQZmri*/ 136508) 3, false, false, false, 372, 9, 17, 1,  0, 0}, // #1871
  {DBGFIELD(/*VPMOVQDZ128mr_VPMOVQDZ128mrk*/ 136532) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1872
  {DBGFIELD(/*ROUNDPDmi_ROUNDPSmi_VROUNDPDmi_VROUNDPSmi*/ 136561) 3, false, false, false, 113, 7, 11, 1,  0, 0}, // #1873
  {DBGFIELD(/*ROUNDSDmi_ROUNDSDmi_Int_ROUNDSSmi_ROUNDSSmi_Int_VROUNDSDmi_VROUNDSDmi_Int_VROUNDSSmi_VROUNDSSmi_Int_VRNDSCALEPDZ128rmbi_VRNDSCALEPDZ128rmik_VRNDSCALEPSZ128rmbi_VRNDSCALEPSZ128rmik_VRNDSCALEPDZ128rmbik_VRNDSCALEPDZ128rmbikz_VRNDSCALEPSZ128rmbik_VRNDSCALEPSZ128rmbikz_VRNDSCALEPDZ128rmi_VRNDSCALEPDZ128rmikz_VRNDSCALEPSZ128rmi_VRNDSCALEPSZ128rmikz_VRNDSCALESDZrmi_VRNDSCALESSZrmi_VRNDSCALESDZrmi_Int_VRNDSCALESDZrmik_Int_VRNDSCALESDZrmikz_Int_VRNDSCALESSZrmi_Int_VRNDSCALESSZrmik_Int_VRNDSCALESSZrmikz_Int*/ 136603) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #1874
  {DBGFIELD(/*ROUNDPDri_ROUNDSSri_VROUNDPDri_VROUNDSSri_ROUNDPSri_ROUNDSDri_VROUNDPSri_VROUNDSDri_ROUNDSDri_Int_ROUNDSSri_Int_VROUNDSDri_Int_VROUNDSSri_Int_VRNDSCALEPDZ128rri_VRNDSCALEPDZ128rrik_VRNDSCALEPDZ128rrikz_VRNDSCALEPSZ128rri_VRNDSCALEPSZ128rrik_VRNDSCALEPSZ128rrikz_VRNDSCALESDZrri_VRNDSCALESSZrri_VRNDSCALESDZrri_Int_VRNDSCALESDZrrib_Int_VRNDSCALESDZrribk_Int_VRNDSCALESDZrribkz_Int_VRNDSCALESDZrrik_Int_VRNDSCALESDZrrikz_Int_VRNDSCALESSZrri_Int_VRNDSCALESSZrrib_Int_VRNDSCALESSZrribk_Int_VRNDSCALESSZrribkz_Int_VRNDSCALESSZrrik_Int_VRNDSCALESSZrrikz_Int*/ 137107) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1875
  {DBGFIELD(/*VRNDSCALEPDZ256rri_VRNDSCALEPDZ256rrik_VRNDSCALEPDZ256rrikz_VRNDSCALEPSZ256rri_VRNDSCALEPSZ256rrik_VRNDSCALEPSZ256rrikz_VROUNDPDYri_VROUNDPSYri*/ 137659) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1876
  {DBGFIELD(/*VPMOVSXBWZ256rmk_VPMOVSXBWZ256rmkz_VPMOVSXBWZrmk_VPMOVSXBWZrmkz_VPMOVZXBWZ256rmk_VPMOVZXBWZ256rmkz_VPMOVZXBWZrmk_VPMOVZXBWZrmkz*/ 137803) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1877
  {DBGFIELD(/*VPOPCNTBZ128rmk_VPOPCNTBZ128rmkz_VPOPCNTWZ128rmk_VPOPCNTWZ128rmkz*/ 137931) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #1878
  {DBGFIELD(/*VPOPCNTBZ256rmk_VPOPCNTBZ256rmkz_VPOPCNTWZ256rmk_VPOPCNTWZ256rmkz*/ 137997) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1879
  {DBGFIELD(/*VPOPCNTBZrmk_VPOPCNTBZrmkz_VPOPCNTWZrmk_VPOPCNTWZrmkz*/ 138063) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1880
  {DBGFIELD(/*VDBPSADBWZ128rmik_VDBPSADBWZ128rmikz*/ 138117) 2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1881
  {DBGFIELD(/*VPMULTISHIFTQBZ128rmbk_VPMULTISHIFTQBZ128rmkz_VPMULTISHIFTQBZ128rmbkz_VPMULTISHIFTQBZ128rmk*/ 138154) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #1882
  {DBGFIELD(/*VDBPSADBWZ256rmik_VDBPSADBWZ256rmikz*/ 138246) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1883
  {DBGFIELD(/*VDBPSADBWZrmik_VDBPSADBWZrmikz*/ 138283) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1884
  {DBGFIELD(/*VPACKSSDWZ256rmbk_VPACKSSDWZ256rmkz_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmkz_VPACKSSDWZ256rmbkz_VPACKUSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSWBZ256rmk_VPACKUSDWZ256rmk_VPACKUSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSWBZ256rmkz*/ 138314) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1885
  {DBGFIELD(/*VPACKSSDWZrmbk_VPACKSSDWZrmkz_VPACKUSDWZrmbk_VPACKUSDWZrmkz_VPACKSSDWZrmbkz_VPACKUSDWZrmbkz_VPACKSSDWZrmk_VPACKSSWBZrmk_VPACKUSDWZrmk_VPACKUSWBZrmk_VPACKSSWBZrmkz_VPACKUSWBZrmkz*/ 138528) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1886
  {DBGFIELD(/*VPERMBZ128rmk_VPERMBZ128rmkz_VPERMBZ256rmk_VPERMBZ256rmkz_VPERMBZrmk_VPERMBZrmkz*/ 138706) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #1887
  {DBGFIELD(/*VPMULTISHIFTQBZ256rmbk_VPMULTISHIFTQBZ256rmkz_VPMULTISHIFTQBZ256rmbkz_VPMULTISHIFTQBZ256rmk*/ 138787) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1888
  {DBGFIELD(/*VPMULTISHIFTQBZrmbk_VPMULTISHIFTQBZrmkz_VPMULTISHIFTQBZrmbkz_VPMULTISHIFTQBZrmk*/ 138879) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1889
  {DBGFIELD(/*VPMOVUSQWZrrk_VPMOVUSQWZrrkz*/ 138959) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1890
  {DBGFIELD(/*VSQRTSDZm_Int*/ 138988)      2, false, false, false, 243, 11, 18, 1,  6, 1}, // #1891
  {DBGFIELD(/*VADDPDZ128rrkz_VSUBPDZ128rrkz*/ 139002) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1892
  {DBGFIELD(/*VADDPDZ256rrkz_VSUBPDZ256rrkz*/ 139032) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1893
  {DBGFIELD(/*VADDPSZ128rrkz_VSUBPSZ128rrkz*/ 139062) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1894
  {DBGFIELD(/*VADDPSZ256rrkz_VSUBPSZ256rrkz*/ 139092) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1895
  {DBGFIELD(/*VADDSDZrrbkz_Int_VADDSDZrrkz_Int_VSUBSDZrrbkz_Int_VSUBSDZrrkz_Int*/ 139122) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1896
  {DBGFIELD(/*VADDSSZrrbkz_Int_VADDSSZrrkz_Int_VSUBSSZrrbkz_Int_VSUBSSZrrkz_Int*/ 139188) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1897
  {DBGFIELD(/*VADDPDZrr_VADDPDZrrb_VSUBPDZrr_VSUBPDZrrb*/ 139254) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1898
  {DBGFIELD(/*VADDPSZrr_VADDPSZrrb_VSUBPSZrr_VSUBPSZrrb*/ 139296) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1899
  {DBGFIELD(/*VMOVDQU16Zrrk_VMOVDQU16Zrrk_REV_VMOVDQU16Zrrkz_VMOVDQU16Zrrkz_REV_VMOVDQU8Zrrk_VMOVDQU8Zrrk_REV_VMOVDQU8Zrrkz_VMOVDQU8Zrrkz_REV_VPMOVM2BZrk_VPMOVM2WZrk*/ 139338) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1900
  {DBGFIELD(/*VPBLENDMBZrrk_VPBLENDMBZrrkz_VPBLENDMWZrrk_VPBLENDMWZrrkz*/ 139490) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1901
  {DBGFIELD(/*VADDPHZ128rrk_VADDPHZ128rrkz_VSUBPHZ128rrk_VSUBPHZ128rrkz*/ 139548) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1902
  {DBGFIELD(/*VADDPHZ256rrk_VADDPHZ256rrkz_VSUBPHZ256rrk_VSUBPHZ256rrkz*/ 139606) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #1903
  {DBGFIELD(/*VADDSHZrrbk_Int_VADDSHZrrbkz_Int_VADDSHZrrk_Int_VADDSHZrrkz_Int_VSUBSHZrrbk_Int_VSUBSHZrrbkz_Int_VSUBSHZrrk_Int_VSUBSHZrrkz_Int*/ 139664) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1904
  {DBGFIELD(/*VCVTPH2UWZ128rrk_VCVTPH2UWZ128rrkz_VCVTPH2WZ128rrk_VCVTPH2WZ128rrkz_VCVTTPH2UWZ128rrk_VCVTTPH2UWZ128rrkz_VCVTTPH2WZ128rrk_VCVTTPH2WZ128rrkz_VCVTUW2PHZ128rrk_VCVTUW2PHZ128rrkz_VCVTW2PHZ128rrk_VCVTW2PHZ128rrkz*/ 139792) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #1905
  {DBGFIELD(/*VCVTPH2UWZ256rrk_VCVTPH2UWZ256rrkz_VCVTPH2WZ256rrk_VCVTPH2WZ256rrkz_VCVTTPH2UWZ256rrk_VCVTTPH2UWZ256rrkz_VCVTTPH2WZ256rrk_VCVTTPH2WZ256rrkz_VCVTUW2PHZ256rrk_VCVTUW2PHZ256rrkz_VCVTW2PHZ256rrk_VCVTW2PHZ256rrkz*/ 140000) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #1906
  {DBGFIELD(/*VFMADD132PHZ128rk_VFMADD132PHZ128rkz_VFMADD213PHZ128rk_VFMADD213PHZ128rkz_VFMADD231PHZ128rk_VFMADD231PHZ128rkz_VFMSUB132PHZ128rk_VFMSUB132PHZ128rkz_VFMSUB213PHZ128rk_VFMSUB213PHZ128rkz_VFMSUB231PHZ128rk_VFMSUB231PHZ128rkz_VFNMADD132PHZ128rk_VFNMADD132PHZ128rkz_VFNMADD213PHZ128rk_VFNMADD213PHZ128rkz_VFNMADD231PHZ128rk_VFNMADD231PHZ128rkz_VFNMSUB132PHZ128rk_VFNMSUB132PHZ128rkz_VFNMSUB213PHZ128rk_VFNMSUB213PHZ128rkz_VFNMSUB231PHZ128rk_VFNMSUB231PHZ128rkz_VFMADDSUB132PHZ128rk_VFMADDSUB132PHZ128rkz_VFMADDSUB213PHZ128rk_VFMADDSUB213PHZ128rkz_VFMADDSUB231PHZ128rk_VFMADDSUB231PHZ128rkz_VFMSUBADD132PHZ128rk_VFMSUBADD132PHZ128rkz_VFMSUBADD213PHZ128rk_VFMSUBADD213PHZ128rkz_VFMSUBADD231PHZ128rk_VFMSUBADD231PHZ128rkz*/ 140208) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1907
  {DBGFIELD(/*VFMADD132PHZ256rk_VFMADD132PHZ256rkz_VFMADD213PHZ256rk_VFMADD213PHZ256rkz_VFMADD231PHZ256rk_VFMADD231PHZ256rkz_VFMSUB132PHZ256rk_VFMSUB132PHZ256rkz_VFMSUB213PHZ256rk_VFMSUB213PHZ256rkz_VFMSUB231PHZ256rk_VFMSUB231PHZ256rkz_VFNMADD132PHZ256rk_VFNMADD132PHZ256rkz_VFNMADD213PHZ256rk_VFNMADD213PHZ256rkz_VFNMADD231PHZ256rk_VFNMADD231PHZ256rkz_VFNMSUB132PHZ256rk_VFNMSUB132PHZ256rkz_VFNMSUB213PHZ256rk_VFNMSUB213PHZ256rkz_VFNMSUB231PHZ256rk_VFNMSUB231PHZ256rkz_VFMADDSUB132PHZ256rk_VFMADDSUB132PHZ256rkz_VFMADDSUB213PHZ256rk_VFMADDSUB213PHZ256rkz_VFMADDSUB231PHZ256rk_VFMADDSUB231PHZ256rkz_VFMSUBADD132PHZ256rk_VFMSUBADD132PHZ256rkz_VFMSUBADD213PHZ256rk_VFMSUBADD213PHZ256rkz_VFMSUBADD231PHZ256rk_VFMSUBADD231PHZ256rkz*/ 140922) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1908
  {DBGFIELD(/*VFMADD132SHZrbk_Int_VFMADD132SHZrbkz_Int_VFMADD132SHZrk_Int_VFMADD132SHZrkz_Int_VFMADD213SHZrbk_Int_VFMADD213SHZrbkz_Int_VFMADD213SHZrk_Int_VFMADD213SHZrkz_Int_VFMADD231SHZrbk_Int_VFMADD231SHZrbkz_Int_VFMADD231SHZrk_Int_VFMADD231SHZrkz_Int_VFMSUB132SHZrbk_Int_VFMSUB132SHZrbkz_Int_VFMSUB132SHZrk_Int_VFMSUB132SHZrkz_Int_VFMSUB213SHZrbk_Int_VFMSUB213SHZrbkz_Int_VFMSUB213SHZrk_Int_VFMSUB213SHZrkz_Int_VFMSUB231SHZrbk_Int_VFMSUB231SHZrbkz_Int_VFMSUB231SHZrk_Int_VFMSUB231SHZrkz_Int_VFNMADD132SHZrbk_Int_VFNMADD132SHZrbkz_Int_VFNMADD132SHZrk_Int_VFNMADD132SHZrkz_Int_VFNMADD213SHZrbk_Int_VFNMADD213SHZrbkz_Int_VFNMADD213SHZrk_Int_VFNMADD213SHZrkz_Int_VFNMADD231SHZrbk_Int_VFNMADD231SHZrbkz_Int_VFNMADD231SHZrk_Int_VFNMADD231SHZrkz_Int_VFNMSUB132SHZrbk_Int_VFNMSUB132SHZrbkz_Int_VFNMSUB132SHZrk_Int_VFNMSUB132SHZrkz_Int_VFNMSUB213SHZrbk_Int_VFNMSUB213SHZrbkz_Int_VFNMSUB213SHZrk_Int_VFNMSUB213SHZrkz_Int_VFNMSUB231SHZrbk_Int_VFNMSUB231SHZrbkz_Int_VFNMSUB231SHZrk_Int_VFNMSUB231SHZrkz_Int*/ 141636) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1909
  {DBGFIELD(/*VGETEXPPHZ128rk_VGETEXPPHZ128rkz_VGETEXPSHZrbk_VGETEXPSHZrkz_VGETEXPSHZrbkz_VGETEXPSHZrk_VGETMANTPHZ128rrik_VGETMANTPHZ128rrikz_VGETMANTSHZrribk_VGETMANTSHZrrikz_VGETMANTSHZrribkz_VGETMANTSHZrrik*/ 142620) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1910
  {DBGFIELD(/*VGETEXPPHZ256rk_VGETEXPPHZ256rkz_VGETMANTPHZ256rrik_VGETMANTPHZ256rrikz*/ 142816) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #1911
  {DBGFIELD(/*VMAXCPHZ128rrk_VMAXCPHZ128rrkz_VMINCPHZ128rrk_VMINCPHZ128rrkz_VMAXPHZ128rrk_VMAXPHZ128rrkz_VMINPHZ128rrk_VMINPHZ128rrkz*/ 142888) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1912
  {DBGFIELD(/*VMAXCPHZ256rrk_VMAXCPHZ256rrkz_VMINCPHZ256rrk_VMINCPHZ256rrkz_VMAXPHZ256rrk_VMAXPHZ256rrkz_VMINPHZ256rrk_VMINPHZ256rrkz*/ 143008) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1913
  {DBGFIELD(/*VMULPHZ128rrk_VMULPHZ128rrkz*/ 143128) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1914
  {DBGFIELD(/*VMULPHZ256rrk_VMULPHZ256rrkz*/ 143157) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1915
  {DBGFIELD(/*VMAXSHZrrbk_Int_VMAXSHZrrbkz_Int_VMAXSHZrrk_Int_VMAXSHZrrkz_Int_VMINSHZrrbk_Int_VMINSHZrrbkz_Int_VMINSHZrrk_Int_VMINSHZrrkz_Int*/ 143186) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1916
  {DBGFIELD(/*VMULSHZrrbk_Int_VMULSHZrrbkz_Int_VMULSHZrrk_Int_VMULSHZrrkz_Int*/ 143314) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1917
  {DBGFIELD(/*VADDPHZrr_VADDPHZrrb_VSUBPHZrr_VSUBPHZrrb*/ 143378) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1918
  {DBGFIELD(/*VAESDECLASTZrr_VAESDECZrr_VAESENCLASTZrr_VAESENCZrr*/ 143420) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #1919
  {DBGFIELD(/*VCVTPH2UWZrr_VCVTPH2UWZrrb_VCVTPH2WZrr_VCVTPH2WZrrb_VCVTTPH2UWZrr_VCVTTPH2UWZrrb_VCVTTPH2WZrr_VCVTTPH2WZrrb_VCVTUW2PHZrr_VCVTUW2PHZrrb_VCVTW2PHZrr_VCVTW2PHZrrb*/ 143472) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1920
  {DBGFIELD(/*VFMADD132PHZr_VFMADD132PHZrb_VFMADD213PHZr_VFMADD213PHZrb_VFMADD231PHZr_VFMADD231PHZrb_VFMSUB132PHZr_VFMSUB132PHZrb_VFMSUB213PHZr_VFMSUB213PHZrb_VFMSUB231PHZr_VFMSUB231PHZrb_VFNMADD132PHZr_VFNMADD132PHZrb_VFNMADD213PHZr_VFNMADD213PHZrb_VFNMADD231PHZr_VFNMADD231PHZrb_VFNMSUB132PHZr_VFNMSUB132PHZrb_VFNMSUB213PHZr_VFNMSUB213PHZrb_VFNMSUB231PHZr_VFNMSUB231PHZrb_VFMADDSUB132PHZr_VFMADDSUB132PHZrb_VFMADDSUB213PHZr_VFMADDSUB213PHZrb_VFMADDSUB231PHZr_VFMADDSUB231PHZrb_VFMSUBADD132PHZr_VFMSUBADD132PHZrb_VFMSUBADD213PHZr_VFMSUBADD213PHZrb_VFMSUBADD231PHZr_VFMSUBADD231PHZrb*/ 143632) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1921
  {DBGFIELD(/*VGETEXPPHZr_VGETEXPPHZrb_VGETMANTPHZrri_VGETMANTPHZrrib*/ 144202) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1922
  {DBGFIELD(/*VMAXCPHZrr_VMINCPHZrr_VMAXPHZrr_VMAXPHZrrb_VMINPHZrr_VMINPHZrrb*/ 144258) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1923
  {DBGFIELD(/*VMULPHZrr_VMULPHZrrb*/ 144322) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1924
  {DBGFIELD(/*VGF2P8MULBZrr*/ 144343)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1925
  {DBGFIELD(/*VADDPHZrrbk_VADDPHZrrkz_VSUBPHZrrbk_VSUBPHZrrkz_VADDPHZrrbkz_VADDPHZrrk_VSUBPHZrrbkz_VSUBPHZrrk*/ 144357) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1926
  {DBGFIELD(/*VCVTPH2UWZrrbk_VCVTPH2UWZrrkz_VCVTPH2WZrrbk_VCVTPH2WZrrkz_VCVTTPH2UWZrrbk_VCVTTPH2UWZrrkz_VCVTTPH2WZrrbk_VCVTTPH2WZrrkz_VCVTPH2UWZrrbkz_VCVTPH2UWZrrk_VCVTPH2WZrrbkz_VCVTPH2WZrrk_VCVTTPH2UWZrrbkz_VCVTTPH2UWZrrk_VCVTTPH2WZrrbkz_VCVTTPH2WZrrk_VCVTUW2PHZrrbk_VCVTUW2PHZrrkz_VCVTW2PHZrrbk_VCVTW2PHZrrkz_VCVTUW2PHZrrbkz_VCVTUW2PHZrrk_VCVTW2PHZrrbkz_VCVTW2PHZrrk*/ 144453) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1927
  {DBGFIELD(/*VFMADD132PHZrbk_VFMADD132PHZrkz_VFMADD213PHZrbk_VFMADD213PHZrkz_VFMADD231PHZrbk_VFMADD231PHZrkz_VFMSUB132PHZrbk_VFMSUB132PHZrkz_VFMSUB213PHZrbk_VFMSUB213PHZrkz_VFMSUB231PHZrbk_VFMSUB231PHZrkz_VFNMADD132PHZrbk_VFNMADD132PHZrkz_VFNMADD213PHZrbk_VFNMADD213PHZrkz_VFNMADD231PHZrbk_VFNMADD231PHZrkz_VFNMSUB132PHZrbk_VFNMSUB132PHZrkz_VFNMSUB213PHZrbk_VFNMSUB213PHZrkz_VFNMSUB231PHZrbk_VFNMSUB231PHZrkz_VFMADD132PHZrbkz_VFMADD132PHZrk_VFMADD213PHZrbkz_VFMADD213PHZrk_VFMADD231PHZrbkz_VFMADD231PHZrk_VFMSUB132PHZrbkz_VFMSUB132PHZrk_VFMSUB213PHZrbkz_VFMSUB213PHZrk_VFMSUB231PHZrbkz_VFMSUB231PHZrk_VFNMADD132PHZrbkz_VFNMADD132PHZrk_VFNMADD213PHZrbkz_VFNMADD213PHZrk_VFNMADD231PHZrbkz_VFNMADD231PHZrk_VFNMSUB132PHZrbkz_VFNMSUB132PHZrk_VFNMSUB213PHZrbkz_VFNMSUB213PHZrk_VFNMSUB231PHZrbkz_VFNMSUB231PHZrk_VFMADDSUB132PHZrbk_VFMADDSUB132PHZrkz_VFMADDSUB213PHZrbk_VFMADDSUB213PHZrkz_VFMADDSUB231PHZrbk_VFMADDSUB231PHZrkz_VFMADDSUB132PHZrbkz_VFMADDSUB132PHZrk_VFMADDSUB213PHZrbkz_VFMADDSUB213PHZrk_VFMADDSUB231PHZrbkz_VFMADDSUB231PHZrk_VFMSUBADD132PHZrbk_VFMSUBADD132PHZrkz_VFMSUBADD213PHZrbk_VFMSUBADD213PHZrkz_VFMSUBADD231PHZrbk_VFMSUBADD231PHZrkz_VFMSUBADD132PHZrbkz_VFMSUBADD132PHZrk_VFMSUBADD213PHZrbkz_VFMSUBADD213PHZrk_VFMSUBADD231PHZrbkz_VFMSUBADD231PHZrk*/ 144809) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1928
  {DBGFIELD(/*VGETEXPPHZrbk_VGETEXPPHZrkz_VGETEXPPHZrbkz_VGETEXPPHZrk_VGETMANTPHZrribk_VGETMANTPHZrrikz_VGETMANTPHZrribkz_VGETMANTPHZrrik*/ 146057) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1929
  {DBGFIELD(/*VMAXCPHZrrk_VMAXCPHZrrkz_VMINCPHZrrk_VMINCPHZrrkz_VMAXPHZrrbk_VMAXPHZrrkz_VMINPHZrrbk_VMINPHZrrkz_VMAXPHZrrbkz_VMAXPHZrrk_VMINPHZrrbkz_VMINPHZrrk*/ 146181) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1930
  {DBGFIELD(/*VMULPHZrrbk_VMULPHZrrkz_VMULPHZrrbkz_VMULPHZrrk*/ 146327) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1931
  {DBGFIELD(/*VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPSHUFHWZ128mik_VPSHUFHWZ128mikz_VPSHUFLWZ128mik_VPSHUFLWZ128mikz*/ 146375) 2, false, false, false, 78, 8,  7, 1,  0, 0}, // #1932
  {DBGFIELD(/*VPSHUFHWZ256mik_VPSHUFHWZ256mikz_VPSHUFLWZ256mik_VPSHUFLWZ256mikz*/ 146511) 2, false, false, false, 78, 8, 22, 1,  0, 0}, // #1933
  {DBGFIELD(/*VADDPSYrm_VSUBPSYrm_VADDPSZ256rm_VADDPSZ256rmb_VADDPSZ256rmbk_VADDPSZ256rmk_VADDPSZ256rmkz_VSUBPSZ256rm_VSUBPSZ256rmb_VSUBPSZ256rmbk_VSUBPSZ256rmk_VSUBPSZ256rmkz_VADDPSZ256rmbkz_VSUBPSZ256rmbkz*/ 146577) 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #1934
  {DBGFIELD(/*VPSHUFBZ256rmk_VPSHUFBZ256rmkz*/ 146771) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1935
  {DBGFIELD(/*VPUNPCKHBWZ256rmk_VPUNPCKHBWZ256rmkz_VPUNPCKHWDZ256rmk_VPUNPCKHWDZ256rmkz_VPUNPCKLBWZ256rmk_VPUNPCKLBWZ256rmkz_VPUNPCKLWDZ256rmk_VPUNPCKLWDZ256rmkz*/ 146802) 2, false, false, false, 78, 8, 22, 1,  6, 1}, // #1936
  {DBGFIELD(/*VADDSUBPSYrm*/ 146950)       2, false, false, false, 78, 8,  8, 1,  6, 1}, // #1937
  {DBGFIELD(/*VPSHUFBZ128rmk_VPSHUFBZ128rmkz*/ 146963) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1938
  {DBGFIELD(/*VPUNPCKHBWZ128rmk_VPUNPCKHBWZ128rmkz_VPUNPCKHWDZ128rmk_VPUNPCKHWDZ128rmkz_VPUNPCKLBWZ128rmk_VPUNPCKLBWZ128rmkz_VPUNPCKLWDZ128rmk_VPUNPCKLWDZ128rmkz*/ 146994) 2, false, false, false, 78, 8,  7, 1,  6, 1}, // #1939
  {DBGFIELD(/*VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU8Zrmk_VMOVDQU8Zrmkz*/ 147142) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1940
  {DBGFIELD(/*VADDPSZrm_VADDPSZrmb_VADDPSZrmbk_VADDPSZrmk_VADDPSZrmkz_VSUBPSZrm_VSUBPSZrmb_VSUBPSZrmbk_VSUBPSZrmk_VSUBPSZrmkz_VADDPSZrmbkz_VSUBPSZrmbkz*/ 147198) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1941
  {DBGFIELD(/*VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMWZrmk_VPBLENDMWZrmkz*/ 147336) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1942
  {DBGFIELD(/*VADDPSZrrbk_VADDPSZrrkz_VSUBPSZrrbk_VSUBPSZrrkz_VADDPSZrrbkz_VADDPSZrrk_VSUBPSZrrbkz_VSUBPSZrrk*/ 147394) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1943
  {DBGFIELD(/*VPLZCNTDZrm_VPLZCNTDZrmb_VPLZCNTDZrmbk_VPLZCNTDZrmk_VPLZCNTDZrmkz_VPLZCNTQZrm_VPLZCNTQZrmb_VPLZCNTQZrmbk_VPLZCNTQZrmk_VPLZCNTQZrmkz_VPLZCNTDZrmbkz_VPLZCNTQZrmbkz*/ 147490) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1944
  {DBGFIELD(/*VAESDECLASTZrm_VAESDECZrm_VAESENCLASTZrm_VAESENCZrm*/ 147652) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1945
  {DBGFIELD(/*VGF2P8AFFINEINVQBZrmbi_VGF2P8AFFINEINVQBZrmi_VGF2P8AFFINEQBZrmbi_VGF2P8AFFINEQBZrmi*/ 147704) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1946
  {DBGFIELD(/*VGF2P8MULBZrm*/ 147788)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1947
  {DBGFIELD(/*VPMADD52HUQZm_VPMADD52HUQZmb_VPMADD52HUQZmbk_VPMADD52HUQZmk_VPMADD52HUQZmkz_VPMADD52LUQZm_VPMADD52LUQZmb_VPMADD52LUQZmbk_VPMADD52LUQZmk_VPMADD52LUQZmkz_VPMADD52HUQZmbkz_VPMADD52LUQZmbkz*/ 147802) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1948
  {DBGFIELD(/*VPOPCNTBZ256rm_VPOPCNTDZ256rm_VPOPCNTQZ256rm_VPOPCNTWZ256rm_VPOPCNTDZ256rmb_VPOPCNTDZ256rmk_VPOPCNTDZ256rmkz_VPOPCNTQZ256rmb_VPOPCNTQZ256rmk_VPOPCNTQZ256rmkz_VPOPCNTDZ256rmbk_VPOPCNTDZ256rmbkz_VPOPCNTQZ256rmbk_VPOPCNTQZ256rmbkz*/ 147988) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #1949
  {DBGFIELD(/*VPOPCNTBZrm_VPOPCNTDZrm_VPOPCNTQZrm_VPOPCNTWZrm_VPOPCNTDZrmb_VPOPCNTDZrmk_VPOPCNTDZrmkz_VPOPCNTQZrmb_VPOPCNTQZrmk_VPOPCNTQZrmkz_VPOPCNTDZrmbk_VPOPCNTDZrmbkz_VPOPCNTQZrmbk_VPOPCNTQZrmbkz*/ 148216) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1950
  {DBGFIELD(/*VPSHUFHWZmik_VPSHUFHWZmikz_VPSHUFLWZmik_VPSHUFLWZmikz*/ 148402) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1951
  {DBGFIELD(/*VFPCLASSPDZ256mbi_VFPCLASSPSZ256mbi*/ 148456) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1952
  {DBGFIELD(/*VFPCLASSPDZmbi_VFPCLASSPSZmbi*/ 148492) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1953
  {DBGFIELD(/*VFPCLASSPHZ256mbi*/ 148522)  2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1954
  {DBGFIELD(/*VFPCLASSPHZmbi*/ 148540)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1955
  {DBGFIELD(/*VPALIGNRZrmik_VPALIGNRZrmikz_VPUNPCKHBWZrmk_VPUNPCKHBWZrmkz_VPUNPCKHWDZrmk_VPUNPCKHWDZrmkz_VPUNPCKLBWZrmk_VPUNPCKLBWZrmkz_VPUNPCKLWDZrmk_VPUNPCKLWDZrmkz*/ 148555) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1956
  {DBGFIELD(/*VPMULTISHIFTQBZ256rm_VPMULTISHIFTQBZ256rmb*/ 148708) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1957
  {DBGFIELD(/*VPMULTISHIFTQBZrm_VPMULTISHIFTQBZrmb*/ 148751) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1958
  {DBGFIELD(/*VPCLMULQDQZrmi*/ 148788)     2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1959
  {DBGFIELD(/*VPCLMULQDQZ256rmi*/ 148803)  2, false, false, false, 526, 11,  9, 1,  6, 1}, // #1960
  {DBGFIELD(/*VBLENDVPDYrmr_VBLENDVPSYrmr*/ 148821) 4, false, false, false, 843, 6,  9, 1,  8, 2}, // #1961
  {DBGFIELD(/*VPBLENDVBYrmr*/ 148849)      4, false, false, false, 843, 6,  9, 1,  8, 2}, // #1962
  {DBGFIELD(/*VBLENDVPDYrrr_VBLENDVPSYrrr*/ 148863) 3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1963
  {DBGFIELD(/*VPBLENDVBYrrr*/ 148891)      3, false, false, false, 849, 4,  6, 1,  0, 0}, // #1964
  {DBGFIELD(/*VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPSZ256rmk_VMOVUPSZ256rmkz*/ 148905) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1965
  {DBGFIELD(/*VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz*/ 149029) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #1966
  {DBGFIELD(/*VPADDBZ256rm_VPADDDZ256rm_VPADDQZ256rm_VPADDWZ256rm_VPSUBBZ256rm_VPSUBDZ256rm_VPSUBQZ256rm_VPSUBWZ256rm_VPADDDZ256rmb_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rmb_VPADDQZ256rmk_VPADDQZ256rmkz_VPSUBDZ256rmb_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rmb_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmik_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmik_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmikz*/ 149169) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #1967
  {DBGFIELD(/*VCMPPHZ128rmbi_VCMPPHZ128rmik_VCMPPHZ128rmbik_VCMPPHZ128rmi_VFPCLASSPHZ128mbik_VFPCLASSPHZ128mik*/ 149803) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1968
  {DBGFIELD(/*VCMPPHZ256rmbi_VCMPPHZ256rmik_VCMPPHZ256rmbik_VCMPPHZ256rmi_VFPCLASSPHZ256mbik_VFPCLASSPHZ256mik*/ 149900) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #1969
  {DBGFIELD(/*VCMPPHZrmbi_VCMPPHZrmik_VCMPPHZrmbik_VCMPPHZrmi_VFPCLASSPHZmbik_VFPCLASSPHZmik*/ 149997) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1970
  {DBGFIELD(/*VCMPSHZrmi_VCMPSHZrmi_Int_VCMPSHZrmik_Int_VFPCLASSSHZmik*/ 150076) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #1971
  {DBGFIELD(/*VCOMISHZrm_VCOMISHZrm_Int_VUCOMISHZrm_VUCOMISHZrm_Int*/ 150133) 2, false, false, false, 243, 11,  7, 1,  6, 1}, // #1972
  {DBGFIELD(/*VCOMPRESSPDZ128mr_VCOMPRESSPDZ256mr_VCOMPRESSPSZ128mr_VCOMPRESSPSZ256mr_VCOMPRESSPDZmr_VCOMPRESSPSZmr_VPCOMPRESSDZ128mr_VPCOMPRESSDZ256mr_VPCOMPRESSQZ128mr_VPCOMPRESSQZ256mr_VPCOMPRESSDZmr_VPCOMPRESSQZmr*/ 150187) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1973
  {DBGFIELD(/*VPMOVDBZmr_VPMOVQBZmr_VPMOVSQBZmr_VPMOVSWBZmr_VPMOVWBZmr_VPMOVDWZmr_VPMOVQWZmr_VPMOVSDWZmr_VPMOVSQWZmr_VPMOVUSDWZmr_VPMOVUSQWZmr_VPMOVSDBZmr_VPMOVSQDZmr_VPMOVUSDBZmr_VPMOVUSQDZmr_VPMOVUSQBZmr_VPMOVUSWBZmr*/ 150391) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1974
  {DBGFIELD(/*VPMOVDBZmrk_VPMOVQBZmrk_VPMOVSQBZmrk_VPMOVSWBZmrk_VPMOVWBZmrk_VPMOVDWZmrk_VPMOVQWZmrk_VPMOVSDWZmrk_VPMOVSQWZmrk_VPMOVUSDWZmrk_VPMOVUSQWZmrk_VPMOVSDBZmrk_VPMOVSQDZmrk_VPMOVUSDBZmrk_VPMOVUSQDZmrk_VPMOVUSQBZmrk_VPMOVUSWBZmrk*/ 150596) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #1975
  {DBGFIELD(/*VCOMPRESSPDZ128rr_VCOMPRESSPSZ128rr_VPCOMPRESSDZ128rr_VPCOMPRESSQZ128rr*/ 150818) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1976
  {DBGFIELD(/*VCOMPRESSPDZ256rr_VCOMPRESSPSZ256rr_VPCOMPRESSDZ256rr_VPCOMPRESSQZ256rr*/ 150890) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1977
  {DBGFIELD(/*VCOMPRESSPDZrr_VCOMPRESSPSZrr_VPCOMPRESSDZrr_VPCOMPRESSQZrr*/ 150962) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1978
  {DBGFIELD(/*VEXPANDPDZ128rr_VEXPANDPDZ256rr_VEXPANDPSZ128rr_VEXPANDPSZ256rr_VEXPANDPDZrr_VEXPANDPSZrr_VPEXPANDDZ128rr_VPEXPANDDZ256rr_VPEXPANDQZ128rr_VPEXPANDQZ256rr_VPEXPANDDZrr_VPEXPANDQZrr*/ 151022) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1979
  {DBGFIELD(/*VPCOMPRESSBZ128rr_VPCOMPRESSWZ128rr*/ 151202) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1980
  {DBGFIELD(/*VPCOMPRESSBZ256rr_VPCOMPRESSWZ256rr_VPEXPANDBZ256rr_VPEXPANDWZ256rr*/ 151238) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1981
  {DBGFIELD(/*VPCOMPRESSBZrr_VPCOMPRESSWZrr_VPEXPANDBZrr_VPEXPANDWZrr*/ 151306) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1982
  {DBGFIELD(/*VPEXPANDBZ128rr_VPEXPANDWZ128rr*/ 151362) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #1983
  {DBGFIELD(/*VCVTDQ2PDZrrk_VCVTDQ2PDZrrkz_VCVTUDQ2PDZrrk_VCVTUDQ2PDZrrkz*/ 151394) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1984
  {DBGFIELD(/*VCVTPS2QQZrrb_VCVTPS2QQZrrbk_VCVTPS2QQZrrk_VCVTPS2QQZrrkz_VCVTPS2UQQZrrb_VCVTPS2UQQZrrbk_VCVTPS2UQQZrrk_VCVTPS2UQQZrrkz_VCVTTPS2QQZrrb_VCVTTPS2QQZrrbk_VCVTTPS2QQZrrk_VCVTTPS2QQZrrkz_VCVTTPS2UQQZrrb_VCVTTPS2UQQZrrbk_VCVTTPS2UQQZrrk_VCVTTPS2UQQZrrkz_VCVTPS2QQZrrbkz_VCVTPS2UQQZrrbkz_VCVTTPS2QQZrrbkz_VCVTTPS2UQQZrrbkz*/ 151454) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1985
  {DBGFIELD(/*VCVTQQ2PSZrrb_VCVTQQ2PSZrrbk_VCVTQQ2PSZrrk_VCVTQQ2PSZrrkz_VCVTUQQ2PSZrrb_VCVTUQQ2PSZrrbk_VCVTUQQ2PSZrrk_VCVTUQQ2PSZrrkz_VCVTQQ2PSZrrbkz_VCVTUQQ2PSZrrbkz*/ 151770) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1986
  {DBGFIELD(/*VCVTDQ2PHZ128rm_VCVTDQ2PHZ128rmb_VCVTUDQ2PHZ128rm_VCVTUDQ2PHZ128rmb*/ 151923) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1987
  {DBGFIELD(/*VCVTNEPS2BF16Z128rm_VCVTNEPS2BF16Z128rmb*/ 151991) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1988
  {DBGFIELD(/*VCVTDQ2PHZ128rmbk_VCVTDQ2PHZ128rmkz_VCVTUDQ2PHZ128rmbk_VCVTUDQ2PHZ128rmkz_VCVTDQ2PHZ128rmbkz_VCVTDQ2PHZ128rmk_VCVTUDQ2PHZ128rmbkz_VCVTUDQ2PHZ128rmk*/ 152032) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #1989
  {DBGFIELD(/*VCVTDQ2PHZ128rr_VCVTUDQ2PHZ128rr*/ 152180) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1990
  {DBGFIELD(/*VCVTDQ2PHZ128rrk_VCVTDQ2PHZ128rrkz_VCVTUDQ2PHZ128rrk_VCVTUDQ2PHZ128rrkz*/ 152213) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1991
  {DBGFIELD(/*VCVTDQ2PHZ256rm_VCVTDQ2PHZ256rmb_VCVTUDQ2PHZ256rm_VCVTUDQ2PHZ256rmb*/ 152285) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1992
  {DBGFIELD(/*VCVTNEPS2BF16Z128rmbk_VCVTNEPS2BF16Z128rmkz_VCVTNEPS2BF16Z128rmbkz_VCVTNEPS2BF16Z128rmk*/ 152353) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #1993
  {DBGFIELD(/*VCVTDQ2PHZ256rmbk_VCVTDQ2PHZ256rmkz_VCVTUDQ2PHZ256rmbk_VCVTUDQ2PHZ256rmkz_VCVTDQ2PHZ256rmbkz_VCVTDQ2PHZ256rmk_VCVTUDQ2PHZ256rmbkz_VCVTUDQ2PHZ256rmk*/ 152441) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #1994
  {DBGFIELD(/*VCVTDQ2PHZ256rr_VCVTUDQ2PHZ256rr*/ 152589) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1995
  {DBGFIELD(/*VCVTDQ2PHZ256rrk_VCVTDQ2PHZ256rrkz_VCVTUDQ2PHZ256rrk_VCVTUDQ2PHZ256rrkz*/ 152622) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #1996
  {DBGFIELD(/*VCVTDQ2PHZrm_VCVTDQ2PHZrmb_VCVTUDQ2PHZrm_VCVTUDQ2PHZrmb*/ 152694) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1997
  {DBGFIELD(/*VCVTDQ2PHZrmbk_VCVTDQ2PHZrmkz_VCVTUDQ2PHZrmbk_VCVTUDQ2PHZrmkz_VCVTDQ2PHZrmbkz_VCVTDQ2PHZrmk_VCVTUDQ2PHZrmbkz_VCVTUDQ2PHZrmk*/ 152750) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1998
  {DBGFIELD(/*VCVTDQ2PHZrr_VCVTDQ2PHZrrb_VCVTUDQ2PHZrr_VCVTUDQ2PHZrrb*/ 152874) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1999
  {DBGFIELD(/*VCVTDQ2PHZrrbk_VCVTDQ2PHZrrkz_VCVTUDQ2PHZrrbk_VCVTUDQ2PHZrrkz_VCVTDQ2PHZrrbkz_VCVTDQ2PHZrrk_VCVTUDQ2PHZrrbkz_VCVTUDQ2PHZrrk*/ 152930) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2000
  {DBGFIELD(/*VCVTNE2PS2BF16Z128rm_VCVTNE2PS2BF16Z128rmb*/ 153054) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2001
  {DBGFIELD(/*VCVTNE2PS2BF16Z128rmbk_VCVTNE2PS2BF16Z128rmkz_VCVTNE2PS2BF16Z128rmbkz_VCVTNE2PS2BF16Z128rmk*/ 153097) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2002
  {DBGFIELD(/*VCVTNE2PS2BF16Z128rr*/ 153189) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2003
  {DBGFIELD(/*VCVTNE2PS2BF16Z256rr*/ 153210) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2004
  {DBGFIELD(/*VCVTNE2PS2BF16Z128rrk_VCVTNE2PS2BF16Z128rrkz*/ 153231) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2005
  {DBGFIELD(/*VCVTNE2PS2BF16Z256rrk_VCVTNE2PS2BF16Z256rrkz*/ 153276) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2006
  {DBGFIELD(/*VCVTNE2PS2BF16Z256rm_VCVTNE2PS2BF16Z256rmb*/ 153321) 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #2007
  {DBGFIELD(/*VCVTNE2PS2BF16Z256rmbk_VCVTNE2PS2BF16Z256rmkz_VCVTNE2PS2BF16Z256rmbkz_VCVTNE2PS2BF16Z256rmk*/ 153364) 3, false, false, false, 264, 12, 11, 1,  6, 1}, // #2008
  {DBGFIELD(/*VCVTNE2PS2BF16Zrm_VCVTNE2PS2BF16Zrmb*/ 153456) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2009
  {DBGFIELD(/*VDPBF16PSZm_VDPBF16PSZmb_VDPBF16PSZmbk_VDPBF16PSZmk_VDPBF16PSZmkz*/ 153493) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2010
  {DBGFIELD(/*VDPBF16PSZmbkz*/ 153559)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2011
  {DBGFIELD(/*VCVTNE2PS2BF16Zrmbk_VCVTNE2PS2BF16Zrmkz_VCVTNE2PS2BF16Zrmbkz_VCVTNE2PS2BF16Zrmk*/ 153574) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2012
  {DBGFIELD(/*VCVTNE2PS2BF16Zrr*/ 153654)  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2013
  {DBGFIELD(/*VCVTNE2PS2BF16Zrrk_VCVTNE2PS2BF16Zrrkz*/ 153672) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2014
  {DBGFIELD(/*VCVTNEPS2BF16Z128rr*/ 153711) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2015
  {DBGFIELD(/*VCVTNEPS2BF16Z256rr*/ 153731) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2016
  {DBGFIELD(/*VCVTNEPS2BF16Z128rrk_VCVTNEPS2BF16Z128rrkz*/ 153751) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2017
  {DBGFIELD(/*VCVTNEPS2BF16Z256rrk_VCVTNEPS2BF16Z256rrkz*/ 153794) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2018
  {DBGFIELD(/*VCVTNEPS2BF16Z256rm_VCVTNEPS2BF16Z256rmb*/ 153837) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2019
  {DBGFIELD(/*VCVTNEPS2BF16Z256rmbk_VCVTNEPS2BF16Z256rmkz_VCVTNEPS2BF16Z256rmbkz_VCVTNEPS2BF16Z256rmk*/ 153878) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2020
  {DBGFIELD(/*VCVTNEPS2BF16Zrm_VCVTNEPS2BF16Zrmb*/ 153966) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2021
  {DBGFIELD(/*VCVTNEPS2BF16Zrmbk_VCVTNEPS2BF16Zrmkz_VCVTNEPS2BF16Zrmbkz_VCVTNEPS2BF16Zrmk*/ 154001) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2022
  {DBGFIELD(/*VCVTNEPS2BF16Zrr*/ 154077)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2023
  {DBGFIELD(/*VCVTNEPS2BF16Zrrk_VCVTNEPS2BF16Zrrkz*/ 154094) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2024
  {DBGFIELD(/*VCVTPD2DQZ256rm_VCVTPD2DQZ256rmb_VCVTPD2UDQZ256rm_VCVTPD2UDQZ256rmb_VCVTTPD2DQZ256rm_VCVTTPD2DQZ256rmb_VCVTTPD2UDQZ256rm_VCVTTPD2UDQZ256rmb_VCVTPD2DQZ256rmbk_VCVTPD2DQZ256rmkz_VCVTPD2UDQZ256rmbk_VCVTPD2UDQZ256rmkz_VCVTTPD2DQZ256rmbk_VCVTTPD2DQZ256rmkz_VCVTTPD2UDQZ256rmbk_VCVTTPD2UDQZ256rmkz_VCVTPD2DQZ256rmbkz_VCVTPD2DQZ256rmk_VCVTPD2UDQZ256rmbkz_VCVTPD2UDQZ256rmk_VCVTTPD2DQZ256rmbkz_VCVTTPD2DQZ256rmk_VCVTTPD2UDQZ256rmbkz_VCVTTPD2UDQZ256rmk*/ 154131) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2025
  {DBGFIELD(/*VCVTPH2DQZ256rm_VCVTPH2DQZ256rmb_VCVTPH2UDQZ256rm_VCVTPH2UDQZ256rmb_VCVTTPH2DQZ256rm_VCVTTPH2DQZ256rmb_VCVTTPH2UDQZ256rm_VCVTTPH2UDQZ256rmb*/ 154575) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2026
  {DBGFIELD(/*VCVTPH2PSXZ128rmbk_VCVTPH2PSXZ128rmkz_VCVTPH2PSXZ128rmbkz_VCVTPH2PSXZ128rmk*/ 154715) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2027
  {DBGFIELD(/*VCVTPH2PSXZ256rm_VCVTPH2PSXZ256rmb*/ 154791) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2028
  {DBGFIELD(/*VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz_VCVTQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmbkz*/ 154826) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2029
  {DBGFIELD(/*VCVTPH2DQZrm_VCVTPH2DQZrmb_VCVTPH2UDQZrm_VCVTPH2UDQZrmb_VCVTTPH2DQZrm_VCVTTPH2DQZrmb_VCVTTPH2UDQZrm_VCVTTPH2UDQZrmb*/ 155042) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2030
  {DBGFIELD(/*VCVTPH2PSXZrm_VCVTPH2PSXZrmb*/ 155158) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2031
  {DBGFIELD(/*VCVTPD2PHZ128rm_VCVTPD2PHZ128rmb*/ 155187) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2032
  {DBGFIELD(/*VCVTPD2PHZ128rmbk_VCVTPD2PHZ128rmkz_VCVTPD2PHZ128rmbkz_VCVTPD2PHZ128rmk*/ 155220) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2033
  {DBGFIELD(/*VCVTPD2PHZ128rr*/ 155292)    2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2034
  {DBGFIELD(/*VCVTPD2PHZ128rrk_VCVTPD2PHZ128rrkz*/ 155308) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2035
  {DBGFIELD(/*VCVTPD2PHZ256rm_VCVTPD2PHZ256rmb*/ 155343) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2036
  {DBGFIELD(/*VCVTPD2PHZ256rmbk_VCVTPD2PHZ256rmkz_VCVTPD2PHZ256rmbkz_VCVTPD2PHZ256rmk*/ 155376) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2037
  {DBGFIELD(/*VCVTPD2PHZ256rr*/ 155448)    2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2038
  {DBGFIELD(/*VCVTPD2PHZ256rrk_VCVTPD2PHZ256rrkz*/ 155464) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2039
  {DBGFIELD(/*VCVTPD2PHZrm_VCVTPD2PHZrmb*/ 155499) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2040
  {DBGFIELD(/*VCVTPH2PDZrm_VCVTPH2PDZrmb*/ 155526) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2041
  {DBGFIELD(/*VCVTPD2PHZrmbk_VCVTPD2PHZrmkz_VCVTPD2PHZrmbkz_VCVTPD2PHZrmk*/ 155553) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2042
  {DBGFIELD(/*VCVTPH2PDZrmbk_VCVTPH2PDZrmkz_VCVTPH2PDZrmbkz_VCVTPH2PDZrmk*/ 155613) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2043
  {DBGFIELD(/*VCVTPD2PHZrr_VCVTPD2PHZrrb*/ 155673) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2044
  {DBGFIELD(/*VCVTPH2PDZrr_VCVTPH2PDZrrb*/ 155700) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2045
  {DBGFIELD(/*VCVTPD2PHZrrbk_VCVTPD2PHZrrkz_VCVTPD2PHZrrbkz_VCVTPD2PHZrrk*/ 155727) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2046
  {DBGFIELD(/*VCVTPH2PDZrrbk_VCVTPH2PDZrrkz_VCVTPH2PDZrrbkz_VCVTPH2PDZrrk*/ 155787) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2047
  {DBGFIELD(/*VPABSBZ128rmk_VPABSBZ128rmkz_VPABSWZ128rmk_VPABSWZ128rmkz*/ 155847) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2048
  {DBGFIELD(/*VPABSBZ256rmk_VPABSBZ256rmkz_VPABSWZ256rmk_VPABSWZ256rmkz*/ 155905) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2049
  {DBGFIELD(/*VPLZCNTDZ128rm_VPLZCNTDZ128rmb_VPLZCNTDZ128rmbk_VPLZCNTDZ128rmk_VPLZCNTDZ128rmkz_VPLZCNTQZ128rm_VPLZCNTQZ128rmb_VPLZCNTQZ128rmbk_VPLZCNTQZ128rmk_VPLZCNTQZ128rmkz_VPLZCNTDZ128rmbkz_VPLZCNTQZ128rmbkz*/ 155963) 2, false, false, false, 101, 7, 24, 1,  0, 0}, // #2050
  {DBGFIELD(/*VPSLLWZ128mik_VPSLLWZ128mikz_VPSRLWZ128mik_VPSRLWZ128mikz_VPSRAWZ128mik_VPSRAWZ128mikz*/ 156161) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2051
  {DBGFIELD(/*VPSLLWZ256mik_VPSLLWZ256mikz_VPSRLWZ256mik_VPSRLWZ256mikz_VPSRAWZ256mik_VPSRAWZ256mikz*/ 156248) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2052
  {DBGFIELD(/*VFIXUPIMMSDZrmi_VFIXUPIMMSDZrmik_VFIXUPIMMSDZrmikz_VFIXUPIMMSSZrmi_VFIXUPIMMSSZrmik_VFIXUPIMMSSZrmikz_VSCALEFSDZrm_VSCALEFSDZrmk_VSCALEFSDZrmkz_VSCALEFSSZrm_VSCALEFSSZrmk_VSCALEFSSZrmkz*/ 156335) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2053
  {DBGFIELD(/*VPADDSBZ128rmk_VPADDSBZ128rmkz_VPADDSWZ128rmk_VPADDSWZ128rmkz_VPADDUSBZ128rmk_VPADDUSBZ128rmkz_VPADDUSWZ128rmk_VPADDUSWZ128rmkz_VPSUBSBZ128rmk_VPSUBSBZ128rmkz_VPSUBSWZ128rmk_VPSUBSWZ128rmkz_VPSUBUSBZ128rmk_VPSUBUSBZ128rmkz_VPSUBUSWZ128rmk_VPSUBUSWZ128rmkz_VPAVGBZ128rmk_VPAVGBZ128rmkz_VPAVGWZ128rmk_VPAVGWZ128rmkz_VPMAXSBZ128rmk_VPMAXSBZ128rmkz_VPMAXUWZ128rmk_VPMAXUWZ128rmkz_VPMINSBZ128rmk_VPMINSBZ128rmkz_VPMINUWZ128rmk_VPMINUWZ128rmkz_VPMAXSWZ128rmk_VPMAXSWZ128rmkz_VPMAXUBZ128rmk_VPMAXUBZ128rmkz_VPMINSWZ128rmk_VPMINSWZ128rmkz_VPMINUBZ128rmk_VPMINUBZ128rmkz*/ 156521) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2054
  {DBGFIELD(/*VPSHLDVWZ128mk_VPSHLDVWZ128mkz_VPSHRDVWZ128mk_VPSHRDVWZ128mkz*/ 157083) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2055
  {DBGFIELD(/*VPSLLVWZ128rmk_VPSLLVWZ128rmkz_VPSRLVWZ128rmk_VPSRLVWZ128rmkz_VPSRAVWZ128rmk_VPSRAVWZ128rmkz*/ 157145) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2056
  {DBGFIELD(/*VPSLLWZ128rmk_VPSLLWZ128rmkz_VPSRLWZ128rmk_VPSRLWZ128rmkz_VPSRAWZ128rmk_VPSRAWZ128rmkz*/ 157238) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2057
  {DBGFIELD(/*VPADDSBZ256rmk_VPADDSBZ256rmkz_VPADDSWZ256rmk_VPADDSWZ256rmkz_VPADDUSBZ256rmk_VPADDUSBZ256rmkz_VPADDUSWZ256rmk_VPADDUSWZ256rmkz_VPSUBSBZ256rmk_VPSUBSBZ256rmkz_VPSUBSWZ256rmk_VPSUBSWZ256rmkz_VPSUBUSBZ256rmk_VPSUBUSBZ256rmkz_VPSUBUSWZ256rmk_VPSUBUSWZ256rmkz_VPAVGBZ256rmk_VPAVGBZ256rmkz_VPAVGWZ256rmk_VPAVGWZ256rmkz_VPMAXSBZ256rmk_VPMAXSBZ256rmkz_VPMAXUWZ256rmk_VPMAXUWZ256rmkz_VPMINSBZ256rmk_VPMINSBZ256rmkz_VPMINUWZ256rmk_VPMINUWZ256rmkz_VPMAXSWZ256rmk_VPMAXSWZ256rmkz_VPMAXUBZ256rmk_VPMAXUBZ256rmkz_VPMINSWZ256rmk_VPMINSWZ256rmkz_VPMINUBZ256rmk_VPMINUBZ256rmkz*/ 157325) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2058
  {DBGFIELD(/*VPSHLDVWZ256mk_VPSHLDVWZ256mkz_VPSHRDVWZ256mk_VPSHRDVWZ256mkz*/ 157887) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2059
  {DBGFIELD(/*VPSLLVWZ256rmk_VPSLLVWZ256rmkz_VPSRLVWZ256rmk_VPSRLVWZ256rmkz_VPSRAVWZ256rmk_VPSRAVWZ256rmkz*/ 157949) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2060
  {DBGFIELD(/*VPSLLWZ256rmk_VPSLLWZ256rmkz_VPSRLWZ256rmk_VPSRLWZ256rmkz_VPSRAWZ256rmk_VPSRAWZ256rmkz*/ 158042) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2061
  {DBGFIELD(/*VPMADD52HUQZ128m_VPMADD52HUQZ128mb_VPMADD52HUQZ128mbk_VPMADD52HUQZ128mk_VPMADD52HUQZ128mkz_VPMADD52LUQZ128m_VPMADD52LUQZ128mb_VPMADD52LUQZ128mbk_VPMADD52LUQZ128mk_VPMADD52LUQZ128mkz_VPMADD52HUQZ128mbkz_VPMADD52LUQZ128mbkz*/ 158129) 2, false, false, false, 101, 7, 24, 1, 10, 2}, // #2062
  {DBGFIELD(/*VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz*/ 158351) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2063
  {DBGFIELD(/*VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz*/ 158456) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2064
  {DBGFIELD(/*VFIXUPIMMSDZrri_VFIXUPIMMSSZrri_VSCALEFSDZrr_VSCALEFSDZrrk_VSCALEFSDZrrkz_VSCALEFSSZrr_VSCALEFSSZrrk_VSCALEFSSZrrkz_VSCALEFSDZrrbk_Int_VSCALEFSDZrrbkz_Int_VSCALEFSSZrrbk_Int_VSCALEFSSZrrbkz_Int*/ 158561) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2065
  {DBGFIELD(/*VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz*/ 158755) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2066
  {DBGFIELD(/*VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz*/ 158851) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2067
  {DBGFIELD(/*VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz*/ 158947) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2068
  {DBGFIELD(/*VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz*/ 159055) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2069
  {DBGFIELD(/*VFIXUPIMMSDZrrib_VFIXUPIMMSDZrribk_VFIXUPIMMSDZrribkz_VFIXUPIMMSSZrrib_VFIXUPIMMSSZrribk_VFIXUPIMMSSZrribkz*/ 159163) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2070
  {DBGFIELD(/*VCVTPH2DQZ128rm_VCVTPH2DQZ128rmb_VCVTPH2UDQZ128rm_VCVTPH2UDQZ128rmb_VCVTTPH2DQZ128rm_VCVTTPH2DQZ128rmb_VCVTTPH2UDQZ128rm_VCVTTPH2UDQZ128rmb*/ 159271) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2071
  {DBGFIELD(/*VCVTPS2PHXZ128rm_VCVTPS2PHXZ128rmb*/ 159411) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2072
  {DBGFIELD(/*VCVTPH2DQZ128rmbk_VCVTPH2DQZ128rmkz_VCVTPH2UDQZ128rmbk_VCVTPH2UDQZ128rmkz_VCVTTPH2DQZ128rmbk_VCVTTPH2DQZ128rmkz_VCVTTPH2UDQZ128rmbk_VCVTTPH2UDQZ128rmkz_VCVTPH2DQZ128rmbkz_VCVTPH2DQZ128rmk_VCVTPH2UDQZ128rmbkz_VCVTPH2UDQZ128rmk_VCVTTPH2DQZ128rmbkz_VCVTTPH2DQZ128rmk_VCVTTPH2UDQZ128rmbkz_VCVTTPH2UDQZ128rmk*/ 159446) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2073
  {DBGFIELD(/*VCVTPH2DQZ128rrk_VCVTPH2DQZ128rrkz_VCVTPH2UDQZ128rrk_VCVTPH2UDQZ128rrkz_VCVTTPH2DQZ128rrk_VCVTTPH2DQZ128rrkz_VCVTTPH2UDQZ128rrk_VCVTTPH2UDQZ128rrkz*/ 159750) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2074
  {DBGFIELD(/*VCVTPH2DQZ256rrk_VCVTPH2DQZ256rrkz_VCVTPH2UDQZ256rrk_VCVTPH2UDQZ256rrkz_VCVTTPH2DQZ256rrk_VCVTTPH2DQZ256rrkz_VCVTTPH2UDQZ256rrk_VCVTTPH2UDQZ256rrkz*/ 159898) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2075
  {DBGFIELD(/*VCVTPH2PSXZ256rrk_VCVTPH2PSXZ256rrkz*/ 160046) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2076
  {DBGFIELD(/*VCVTPH2PSZ256rrk_VCVTPH2PSZ256rrkz*/ 160083) 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #2077
  {DBGFIELD(/*VCVTPS2PHXZ256rrk_VCVTPS2PHXZ256rrkz*/ 160118) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2078
  {DBGFIELD(/*VCVTPS2PHZ256rrk_VCVTPS2PHZ256rrkz*/ 160155) 2, false, false, false, 254, 10,  7, 1,  0, 0}, // #2079
  {DBGFIELD(/*VCVTPH2DQZ256rmbk_VCVTPH2DQZ256rmkz_VCVTPH2UDQZ256rmbk_VCVTPH2UDQZ256rmkz_VCVTTPH2DQZ256rmbk_VCVTTPH2DQZ256rmkz_VCVTTPH2UDQZ256rmbk_VCVTTPH2UDQZ256rmkz_VCVTPH2DQZ256rmbkz_VCVTPH2DQZ256rmk_VCVTPH2UDQZ256rmbkz_VCVTPH2UDQZ256rmk_VCVTTPH2DQZ256rmbkz_VCVTTPH2DQZ256rmk_VCVTTPH2UDQZ256rmbkz_VCVTTPH2UDQZ256rmk*/ 160190) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2080
  {DBGFIELD(/*VCVTPH2PSXZ256rmbk_VCVTPH2PSXZ256rmkz_VCVTPH2PSXZ256rmbkz_VCVTPH2PSXZ256rmk*/ 160494) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2081
  {DBGFIELD(/*VCVTPS2PHXZ256rmbk_VCVTPS2PHXZ256rmkz_VCVTPS2PHXZ256rmbkz_VCVTPS2PHXZ256rmk*/ 160570) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2082
  {DBGFIELD(/*VCVTPH2DQZrmbk_VCVTPH2DQZrmkz_VCVTPH2UDQZrmbk_VCVTPH2UDQZrmkz_VCVTTPH2DQZrmbk_VCVTTPH2DQZrmkz_VCVTTPH2UDQZrmbk_VCVTTPH2UDQZrmkz_VCVTPH2DQZrmbkz_VCVTPH2DQZrmk_VCVTPH2UDQZrmbkz_VCVTPH2UDQZrmk_VCVTTPH2DQZrmbkz_VCVTTPH2DQZrmk_VCVTTPH2UDQZrmbkz_VCVTTPH2UDQZrmk*/ 160646) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2083
  {DBGFIELD(/*VCVTPH2PSXZrmbk_VCVTPH2PSXZrmkz_VCVTPH2PSXZrmbkz_VCVTPH2PSXZrmk*/ 160902) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2084
  {DBGFIELD(/*VCVTPS2PHXZrmbk_VCVTPS2PHXZrmkz_VCVTPS2PHXZrmbkz_VCVTPS2PHXZrmk*/ 160966) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2085
  {DBGFIELD(/*VCVTPH2DQZrr_VCVTPH2DQZrrb_VCVTPH2UDQZrr_VCVTPH2UDQZrrb_VCVTTPH2DQZrr_VCVTTPH2DQZrrb_VCVTTPH2UDQZrr_VCVTTPH2UDQZrrb*/ 161030) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2086
  {DBGFIELD(/*VCVTPH2PSXZrr_VCVTPH2PSXZrrb*/ 161146) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2087
  {DBGFIELD(/*VCVTPH2PSZrr_VCVTPH2PSZrrb*/ 161175) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2088
  {DBGFIELD(/*VCVTPS2PHXZrr_VCVTPS2PHXZrrb*/ 161202) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2089
  {DBGFIELD(/*VCVTPS2PHZrr_VCVTPS2PHZrrb*/ 161231) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2090
  {DBGFIELD(/*VPSHUFBITQMBZ128rrk*/ 161258) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2091
  {DBGFIELD(/*VPSHUFBITQMBZ256rrk*/ 161278) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2092
  {DBGFIELD(/*VPSHUFBITQMBZrrk*/ 161298)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2093
  {DBGFIELD(/*VCVTPH2DQZrrbk_VCVTPH2DQZrrkz_VCVTPH2UDQZrrbk_VCVTPH2UDQZrrkz_VCVTTPH2DQZrrbk_VCVTTPH2DQZrrkz_VCVTTPH2UDQZrrbk_VCVTTPH2UDQZrrkz_VCVTPH2DQZrrbkz_VCVTPH2DQZrrk_VCVTPH2UDQZrrbkz_VCVTPH2UDQZrrk_VCVTTPH2DQZrrbkz_VCVTTPH2DQZrrk_VCVTTPH2UDQZrrbkz_VCVTTPH2UDQZrrk*/ 161315) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2094
  {DBGFIELD(/*VCVTPH2PSXZrrbk_VCVTPH2PSXZrrkz_VCVTPH2PSXZrrbkz_VCVTPH2PSXZrrk*/ 161571) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2095
  {DBGFIELD(/*VCVTPS2PHXZrrbk_VCVTPS2PHXZrrkz_VCVTPS2PHXZrrbkz_VCVTPS2PHXZrrk*/ 161635) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2096
  {DBGFIELD(/*VCVTPH2PDZ128rm_VCVTPH2PDZ128rmb*/ 161699) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2097
  {DBGFIELD(/*VCVTPH2PDZ128rmbk_VCVTPH2PDZ128rmkz_VCVTPH2PDZ128rmbkz_VCVTPH2PDZ128rmk*/ 161732) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2098
  {DBGFIELD(/*VCVTPH2PDZ128rr*/ 161804)    2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2099
  {DBGFIELD(/*VCVTPH2PDZ128rrk_VCVTPH2PDZ128rrkz*/ 161820) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2100
  {DBGFIELD(/*VCVTPH2PDZ256rm_VCVTPH2PDZ256rmb*/ 161855) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2101
  {DBGFIELD(/*VCVTPH2PDZ256rmbk_VCVTPH2PDZ256rmkz_VCVTPH2PDZ256rmbkz_VCVTPH2PDZ256rmk*/ 161888) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2102
  {DBGFIELD(/*VCVTPH2PDZ256rr*/ 161960)    2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2103
  {DBGFIELD(/*VCVTPH2PDZ256rrk_VCVTPH2PDZ256rrkz*/ 161976) 2, false, false, false, 254, 10,  4, 1,  0, 0}, // #2104
  {DBGFIELD(/*VCVTPH2PSXZ128rrk_VCVTPH2PSXZ128rrkz*/ 162011) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2105
  {DBGFIELD(/*VCVTPH2PSZ128rrk_VCVTPH2PSZ128rrkz*/ 162048) 2, false, false, false, 254, 10,  3, 1,  0, 0}, // #2106
  {DBGFIELD(/*VCVTPS2PHXZ128rrk_VCVTPS2PHXZ128rrkz*/ 162083) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2107
  {DBGFIELD(/*VCVTPS2PHZ128rrk_VCVTPS2PHZ128rrkz*/ 162120) 2, false, false, false, 254, 10,  3, 1,  0, 0}, // #2108
  {DBGFIELD(/*VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz*/ 162155) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2109
  {DBGFIELD(/*VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz*/ 162190) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2110
  {DBGFIELD(/*VCVTSH2SSZrmk_Int_VCVTSH2SSZrmkz_Int*/ 162225) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2111
  {DBGFIELD(/*VPMADDUBSWZ128rmk_VPMADDUBSWZ128rmkz_VPMULHRSWZ128rmk_VPMULHRSWZ128rmkz_VPMULHUWZ128rmk_VPMULHUWZ128rmkz_VPMULHWZ128rmk_VPMULHWZ128rmkz_VPMULLWZ128rmk_VPMULLWZ128rmkz*/ 162262) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2112
  {DBGFIELD(/*VPMADDUBSWZ256rmk_VPMADDUBSWZ256rmkz_VPMULHRSWZ256rmk_VPMULHRSWZ256rmkz_VPMULHUWZ256rmk_VPMULHUWZ256rmkz_VPMULHWZ256rmk_VPMULHWZ256rmkz_VPMULLWZ256rmk_VPMULLWZ256rmkz*/ 162429) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2113
  {DBGFIELD(/*VCVTPH2PSZrm*/ 162596)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2114
  {DBGFIELD(/*VPERMWZrmk_VPERMWZrmkz*/ 162609) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2115
  {DBGFIELD(/*VCVTPH2QQZ128rm_VCVTPH2QQZ128rmb_VCVTPH2QQZ128rmbk_VCVTPH2QQZ128rmk_VCVTPH2QQZ128rmkz_VCVTPH2UQQZ128rm_VCVTPH2UQQZ128rmb_VCVTPH2UQQZ128rmbk_VCVTPH2UQQZ128rmk_VCVTPH2UQQZ128rmkz_VCVTTPH2QQZ128rm_VCVTTPH2QQZ128rmb_VCVTTPH2QQZ128rmbk_VCVTTPH2QQZ128rmk_VCVTTPH2QQZ128rmkz_VCVTTPH2UQQZ128rm_VCVTTPH2UQQZ128rmb_VCVTTPH2UQQZ128rmbk_VCVTTPH2UQQZ128rmk_VCVTTPH2UQQZ128rmkz_VCVTPH2QQZ128rmbkz_VCVTPH2UQQZ128rmbkz_VCVTTPH2QQZ128rmbkz_VCVTTPH2UQQZ128rmbkz*/ 162632) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2116
  {DBGFIELD(/*VCVTPH2QQZ128rr_VCVTPH2QQZ128rrk_VCVTPH2QQZ128rrkz_VCVTPH2UQQZ128rr_VCVTPH2UQQZ128rrk_VCVTPH2UQQZ128rrkz_VCVTTPH2QQZ128rr_VCVTTPH2QQZ128rrk_VCVTTPH2QQZ128rrkz_VCVTTPH2UQQZ128rr_VCVTTPH2UQQZ128rrk_VCVTTPH2UQQZ128rrkz*/ 163076) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2117
  {DBGFIELD(/*VCVTPH2QQZ256rr_VCVTPH2QQZ256rrk_VCVTPH2QQZ256rrkz_VCVTPH2UQQZ256rr_VCVTPH2UQQZ256rrk_VCVTPH2UQQZ256rrkz_VCVTTPH2QQZ256rr_VCVTTPH2QQZ256rrk_VCVTTPH2QQZ256rrkz_VCVTTPH2UQQZ256rr_VCVTTPH2UQQZ256rrk_VCVTTPH2UQQZ256rrkz*/ 163292) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2118
  {DBGFIELD(/*VCVTPH2QQZ256rm_VCVTPH2QQZ256rmb_VCVTPH2QQZ256rmbk_VCVTPH2QQZ256rmk_VCVTPH2QQZ256rmkz_VCVTPH2UQQZ256rm_VCVTPH2UQQZ256rmb_VCVTPH2UQQZ256rmbk_VCVTPH2UQQZ256rmk_VCVTPH2UQQZ256rmkz_VCVTTPH2QQZ256rm_VCVTTPH2QQZ256rmb_VCVTTPH2QQZ256rmbk_VCVTTPH2QQZ256rmk_VCVTTPH2QQZ256rmkz_VCVTTPH2UQQZ256rm_VCVTTPH2UQQZ256rmb_VCVTTPH2UQQZ256rmbk_VCVTTPH2UQQZ256rmk_VCVTTPH2UQQZ256rmkz_VCVTPH2QQZ256rmbkz_VCVTPH2UQQZ256rmbkz_VCVTTPH2QQZ256rmbkz_VCVTTPH2UQQZ256rmbkz*/ 163508) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2119
  {DBGFIELD(/*VCVTPS2PHXZ128rmbk_VCVTPS2PHXZ128rmkz_VCVTPS2PHXZ128rmbkz_VCVTPS2PHXZ128rmk*/ 163952) 3, false, false, false, 264, 12,  2, 1,  0, 0}, // #2120
  {DBGFIELD(/*VCVTPS2PHXZ256rm_VCVTPS2PHXZ256rmb*/ 164028) 3, false, false, false, 264, 12, 11, 1,  0, 0}, // #2121
  {DBGFIELD(/*VCVTPS2PHXZrm_VCVTPS2PHXZrmb*/ 164063) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2122
  {DBGFIELD(/*VCVTPS2PHZ128mrk*/ 164092)   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #2123
  {DBGFIELD(/*VCVTPS2PHZ256mrk*/ 164109)   3, false, false, false, 853, 8,  2, 1,  0, 0}, // #2124
  {DBGFIELD(/*VCVTPS2PHZmrk*/ 164126)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2125
  {DBGFIELD(/*VCVTQQ2PHZ128rm_VCVTQQ2PHZ128rmb_VCVTUQQ2PHZ128rm_VCVTUQQ2PHZ128rmb*/ 164140) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2126
  {DBGFIELD(/*VCVTQQ2PHZ128rmbk_VCVTQQ2PHZ128rmkz_VCVTUQQ2PHZ128rmbk_VCVTUQQ2PHZ128rmkz_VCVTQQ2PHZ128rmbkz_VCVTQQ2PHZ128rmk_VCVTUQQ2PHZ128rmbkz_VCVTUQQ2PHZ128rmk*/ 164208) 2, false, false, false, 101, 7,  8, 1,  0, 0}, // #2127
  {DBGFIELD(/*VCVTQQ2PHZ128rr_VCVTUQQ2PHZ128rr*/ 164356) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2128
  {DBGFIELD(/*VCVTQQ2PHZ128rrk_VCVTQQ2PHZ128rrkz_VCVTUQQ2PHZ128rrk_VCVTUQQ2PHZ128rrkz*/ 164389) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2129
  {DBGFIELD(/*VCVTQQ2PHZ256rr_VCVTUQQ2PHZ256rr*/ 164461) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2130
  {DBGFIELD(/*VCVTQQ2PHZ256rm_VCVTQQ2PHZ256rmb_VCVTUQQ2PHZ256rm_VCVTUQQ2PHZ256rmb*/ 164494) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2131
  {DBGFIELD(/*VCVTQQ2PHZ256rmbk_VCVTQQ2PHZ256rmkz_VCVTUQQ2PHZ256rmbk_VCVTUQQ2PHZ256rmkz_VCVTQQ2PHZ256rmbkz_VCVTQQ2PHZ256rmk_VCVTUQQ2PHZ256rmbkz_VCVTUQQ2PHZ256rmk*/ 164562) 2, false, false, false, 101, 7,  2, 1,  0, 0}, // #2132
  {DBGFIELD(/*VCVTQQ2PHZ256rrk_VCVTQQ2PHZ256rrkz_VCVTUQQ2PHZ256rrk_VCVTUQQ2PHZ256rrkz*/ 164710) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2133
  {DBGFIELD(/*VCVTQQ2PHZrm_VCVTQQ2PHZrmb_VCVTUQQ2PHZrm_VCVTUQQ2PHZrmb*/ 164782) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2134
  {DBGFIELD(/*VCVTQQ2PHZrmbk_VCVTQQ2PHZrmkz_VCVTUQQ2PHZrmbk_VCVTUQQ2PHZrmkz_VCVTQQ2PHZrmbkz_VCVTQQ2PHZrmk_VCVTUQQ2PHZrmbkz_VCVTUQQ2PHZrmk*/ 164838) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2135
  {DBGFIELD(/*VCVTQQ2PHZrr_VCVTQQ2PHZrrb_VCVTUQQ2PHZrr_VCVTUQQ2PHZrrb*/ 164962) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2136
  {DBGFIELD(/*VCVTQQ2PHZrrbk_VCVTQQ2PHZrrkz_VCVTUQQ2PHZrrbk_VCVTUQQ2PHZrrkz_VCVTQQ2PHZrrbkz_VCVTQQ2PHZrrk_VCVTUQQ2PHZrrbkz_VCVTUQQ2PHZrrk*/ 165018) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2137
  {DBGFIELD(/*VCVTSD2SHZrm_VCVTSD2SHZrm_Int*/ 165142) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2138
  {DBGFIELD(/*VCVTSD2SHZrmk_Int_VCVTSD2SHZrmkz_Int*/ 165172) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2139
  {DBGFIELD(/*VCVTSD2SHZrr_Int_VCVTSD2SHZrrb_Int*/ 165209) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2140
  {DBGFIELD(/*VCVTSD2SHZrr*/ 165244)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2141
  {DBGFIELD(/*VCVTSD2SHZrrbk_Int_VCVTSD2SHZrrbkz_Int_VCVTSD2SHZrrk_Int_VCVTSD2SHZrrkz_Int*/ 165257) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2142
  {DBGFIELD(/*VCVTSH2SDZrm_VCVTSH2SDZrm_Int*/ 165333) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2143
  {DBGFIELD(/*VCVTSH2SDZrmk_Int_VCVTSH2SDZrmkz_Int*/ 165363) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2144
  {DBGFIELD(/*VCVTSH2SDZrr_Int_VCVTSH2SDZrrb_Int*/ 165400) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2145
  {DBGFIELD(/*VCVTSH2SDZrr*/ 165435)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2146
  {DBGFIELD(/*VCVTSH2SDZrrbk_Int_VCVTSH2SDZrrbkz_Int_VCVTSH2SDZrrk_Int_VCVTSH2SDZrrkz_Int*/ 165448) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2147
  {DBGFIELD(/*VCVTSH2SI64Zrm_Int_VCVTSH2SIZrm_Int_VCVTSH2USI64Zrm_Int_VCVTSH2USIZrm_Int_VCVTTSH2SI64Zrm_Int_VCVTTSH2SIZrm_Int_VCVTTSH2USI64Zrm_Int_VCVTTSH2USIZrm_Int_VCVTTSH2SI64Zrm_VCVTTSH2SIZrm_VCVTTSH2USI64Zrm_VCVTTSH2USIZrm*/ 165524) 3, false, false, false, 276, 11,  2, 1,  6, 1}, // #2148
  {DBGFIELD(/*VCVTSH2SI64Zrr_Int_VCVTSH2SI64Zrrb_Int_VCVTSH2SIZrr_Int_VCVTSH2SIZrrb_Int_VCVTSH2USI64Zrr_Int_VCVTSH2USI64Zrrb_Int_VCVTSH2USIZrr_Int_VCVTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_Int_VCVTTSH2SI64Zrrb_Int_VCVTTSH2SIZrr_Int_VCVTTSH2SIZrrb_Int_VCVTTSH2USI64Zrr_Int_VCVTTSH2USI64Zrrb_Int_VCVTTSH2USIZrr_Int_VCVTTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_VCVTTSH2SIZrr_VCVTTSH2USI64Zrr_VCVTTSH2USIZrr*/ 165738) 2, false, false, false, 287, 9,  4, 1,  0, 0}, // #2149
  {DBGFIELD(/*VCVTSH2SSZrrbk_Int_VCVTSH2SSZrrbkz_Int_VCVTSH2SSZrrk_Int_VCVTSH2SSZrrkz_Int*/ 166112) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2150
  {DBGFIELD(/*VCVTSI2SHZrm_VCVTSI2SHZrm_Int_VCVTSI642SHZrm_VCVTSI642SHZrm_Int_VCVTUSI2SHZrm_VCVTUSI2SHZrm_Int_VCVTUSI642SHZrm_VCVTUSI642SHZrm_Int*/ 166188) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2151
  {DBGFIELD(/*VCVTSS2SHZrm_VCVTSS2SHZrm_Int*/ 166320) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2152
  {DBGFIELD(/*VCVTSS2SHZrmk_Int_VCVTSS2SHZrmkz_Int*/ 166350) 3, false, false, false, 264, 12,  2, 1,  6, 1}, // #2153
  {DBGFIELD(/*VCVTSS2SHZrr_Int_VCVTSS2SHZrrb_Int*/ 166387) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2154
  {DBGFIELD(/*VCVTSS2SHZrr*/ 166422)       2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2155
  {DBGFIELD(/*VCVTSS2SHZrrbk_Int_VCVTSS2SHZrrbkz_Int_VCVTSS2SHZrrk_Int_VCVTSS2SHZrrkz_Int*/ 166435) 2, false, false, false, 254, 10, 10, 1,  0, 0}, // #2156
  {DBGFIELD(/*VDBPSADBWZ128rrik_VDBPSADBWZ128rrikz*/ 166511) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2157
  {DBGFIELD(/*VDBPSADBWZ256rrik_VDBPSADBWZ256rrikz*/ 166548) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2158
  {DBGFIELD(/*VDBPSADBWZrrik_VDBPSADBWZrrikz*/ 166585) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2159
  {DBGFIELD(/*VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrrk_VPACKUSWBZrrkz*/ 166616) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2160
  {DBGFIELD(/*VPBROADCASTBZ256rrk_VPBROADCASTBZ256rrkz_VPBROADCASTBZrrk_VPBROADCASTBZrrkz_VPBROADCASTDrZ256rrk_VPBROADCASTDrZ256rrkz_VPBROADCASTDrZrrk_VPBROADCASTDrZrrkz_VPBROADCASTQrZ256rrk_VPBROADCASTQrZ256rrkz_VPBROADCASTQrZrrk_VPBROADCASTQrZrrkz_VPBROADCASTWZ256rrk_VPBROADCASTWZ256rrkz_VPBROADCASTWZrrk_VPBROADCASTWZrrkz_VPBROADCASTWrZ256rrk_VPBROADCASTWrZ256rrkz_VPBROADCASTWrZrrk_VPBROADCASTWrZrrkz_VPBROADCASTBrZ256rr_VPBROADCASTDrZ256rr_VPBROADCASTQrZ256rr_VPBROADCASTWrZ256rr_VPBROADCASTBrZ256rrk_VPBROADCASTBrZ256rrkz_VPBROADCASTBrZrr_VPBROADCASTDrZrr_VPBROADCASTQrZrr_VPBROADCASTWrZrr_VPBROADCASTBrZrrk_VPBROADCASTBrZrrkz*/ 166732) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2161
  {DBGFIELD(/*VPBROADCASTBrZ128rr_VPBROADCASTDrZ128rr_VPBROADCASTQrZ128rr_VPBROADCASTWrZ128rr_VPBROADCASTBrZ128rrk_VPBROADCASTBrZ128rrkz_VPBROADCASTDrZ128rrk_VPBROADCASTDrZ128rrkz_VPBROADCASTQrZ128rrk_VPBROADCASTQrZ128rrkz_VPBROADCASTWrZ128rrk_VPBROADCASTWrZ128rrkz*/ 167352) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2162
  {DBGFIELD(/*VPERMBZ128rrk_VPERMBZ128rrkz*/ 167604) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2163
  {DBGFIELD(/*VPERMBZ256rrk_VPERMBZ256rrkz*/ 167633) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2164
  {DBGFIELD(/*VPERMBZrrk_VPERMBZrrkz*/ 167662) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2165
  {DBGFIELD(/*VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz*/ 167685) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2166
  {DBGFIELD(/*VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVZXBWZrrk_VPMOVZXBWZrrkz*/ 167755) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2167
  {DBGFIELD(/*VPMULTISHIFTQBZ128rrk_VPMULTISHIFTQBZ128rrkz*/ 167813) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2168
  {DBGFIELD(/*VPMULTISHIFTQBZ256rrk_VPMULTISHIFTQBZ256rrkz_VPOPCNTBZ256rrk_VPOPCNTBZ256rrkz_VPOPCNTWZ256rrk_VPOPCNTWZ256rrkz*/ 167858) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2169
  {DBGFIELD(/*VPMULTISHIFTQBZrrk_VPMULTISHIFTQBZrrkz_VPOPCNTBZrrk_VPOPCNTBZrrkz_VPOPCNTWZrrk_VPOPCNTWZrrkz*/ 167969) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2170
  {DBGFIELD(/*VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz*/ 168062) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2171
  {DBGFIELD(/*VDIVPHZ128rm_VDIVPHZ128rmb*/ 168128) 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2172
  {DBGFIELD(/*VDIVPHZ128rmbk_VDIVPHZ128rmkz_VDIVPHZ128rmbkz_VDIVPHZ128rmk*/ 168155) 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2173
  {DBGFIELD(/*VDIVPHZ128rr*/ 168215)       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2174
  {DBGFIELD(/*VDIVPHZ256rr*/ 168228)       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2175
  {DBGFIELD(/*VDIVPHZ128rrk*/ 168241)      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2176
  {DBGFIELD(/*VDIVPHZ256rrk*/ 168255)      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2177
  {DBGFIELD(/*VSQRTPHZ128r*/ 168269)       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2178
  {DBGFIELD(/*VSQRTPHZ256r*/ 168282)       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2179
  {DBGFIELD(/*VDIVPHZ128rrkz*/ 168295)     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2180
  {DBGFIELD(/*VDIVPHZ256rm_VDIVPHZ256rmb*/ 168310) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2181
  {DBGFIELD(/*VDIVPHZ256rmbk_VDIVPHZ256rmkz_VDIVPHZ256rmbkz_VDIVPHZ256rmk*/ 168337) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2182
  {DBGFIELD(/*VSQRTPHZ128m_VSQRTPHZ128mb*/ 168397) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2183
  {DBGFIELD(/*VDIVPHZ256rrkz*/ 168424)     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2184
  {DBGFIELD(/*VDIVPHZrm_VDIVPHZrmb*/ 168439) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2185
  {DBGFIELD(/*VDIVPHZrmbk_VDIVPHZrmkz_VDIVPHZrmbkz_VDIVPHZrmk*/ 168460) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2186
  {DBGFIELD(/*VDIVPHZrr_VDIVPHZrrb*/ 168508) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2187
  {DBGFIELD(/*VDIVPHZrrbk_VDIVPHZrrkz_VDIVPHZrrbkz_VDIVPHZrrk*/ 168529) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2188
  {DBGFIELD(/*VDIVPSZrr*/ 168577)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2189
  {DBGFIELD(/*VDIVSHZrm_Int_VDIVSHZrmk_Int_VDIVSHZrmkz_Int*/ 168587) 2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2190
  {DBGFIELD(/*VDIVSHZrm*/ 168632)          2, false, false, false, 243, 11, 13, 1,  6, 1}, // #2191
  {DBGFIELD(/*VDIVSHZrr_Int*/ 168642)      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2192
  {DBGFIELD(/*VSQRTSHZr_Int*/ 168656)      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2193
  {DBGFIELD(/*VDPBF16PSZ128m_VDPBF16PSZ128mb_VDPBF16PSZ128mbk_VDPBF16PSZ128mk_VDPBF16PSZ128mkz*/ 168670) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2194
  {DBGFIELD(/*VDPBF16PSZ128mbkz*/ 168751)  2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2195
  {DBGFIELD(/*VDPBF16PSZ256m_VDPBF16PSZ256mb_VDPBF16PSZ256mbk_VDPBF16PSZ256mk_VDPBF16PSZ256mkz*/ 168769) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2196
  {DBGFIELD(/*VDPBF16PSZ256mbkz*/ 168850)  2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2197
  {DBGFIELD(/*VPEXPANDBZ128rm_VPEXPANDWZ128rm*/ 168868) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2198
  {DBGFIELD(/*VFCMADDCPHZ128m_VFCMADDCPHZ128mb_VFMADDCPHZ128m_VFMADDCPHZ128mb*/ 168900) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2199
  {DBGFIELD(/*VFCMADDCPHZ256m_VFCMADDCPHZ256mb_VFMADDCPHZ256m_VFMADDCPHZ256mb*/ 168964) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2200
  {DBGFIELD(/*VROUNDPDYmi_VROUNDPSYmi*/ 169028) 3, false, false, false, 113, 7, 16, 1,  0, 0}, // #2201
  {DBGFIELD(/*VFCMADDCSHZm_VFMADDCSHZm_VFCMULCPHZ128rm_VFCMULCPHZ128rmb_VFMULCPHZ128rm_VFMULCPHZ128rmb_VFCMULCSHZrm_VFMULCSHZrm*/ 169052) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2202
  {DBGFIELD(/*VRNDSCALEPHZ128rmbi_VRNDSCALEPHZ128rmi_VRNDSCALESHZrmi_VRNDSCALESHZrmi_Int*/ 169166) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2203
  {DBGFIELD(/*VSCALEFPHZ128rm_VSCALEFPHZ128rmb*/ 169241) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2204
  {DBGFIELD(/*VFCMULCPHZ256rm_VFCMULCPHZ256rmb_VFMULCPHZ256rm_VFMULCPHZ256rmb*/ 169274) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2205
  {DBGFIELD(/*VRNDSCALEPDZ256rmbi_VRNDSCALEPDZ256rmi_VRNDSCALEPHZ256rmbi_VRNDSCALEPHZ256rmi_VRNDSCALEPSZ256rmbi_VRNDSCALEPSZ256rmi_VRNDSCALEPDZ256rmbik_VRNDSCALEPDZ256rmbikz_VRNDSCALEPDZ256rmik_VRNDSCALEPDZ256rmikz_VRNDSCALEPSZ256rmbik_VRNDSCALEPSZ256rmbikz_VRNDSCALEPSZ256rmik_VRNDSCALEPSZ256rmikz*/ 169338) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2206
  {DBGFIELD(/*VSCALEFPHZ256rm_VSCALEFPHZ256rmb*/ 169623) 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #2207
  {DBGFIELD(/*VSCALEFSHZrm*/ 169656)       2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2208
  {DBGFIELD(/*VFCMADDCPHZ128mbk_VFCMADDCPHZ128mkz_VFMADDCPHZ128mbk_VFMADDCPHZ128mkz_VFCMADDCPHZ128mbkz_VFCMADDCPHZ128mk_VFMADDCPHZ128mbkz_VFMADDCPHZ128mk*/ 169669) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2209
  {DBGFIELD(/*VFCMADDCPHZ256mbk_VFCMADDCPHZ256mkz_VFMADDCPHZ256mbk_VFMADDCPHZ256mkz_VFCMADDCPHZ256mbkz_VFCMADDCPHZ256mk_VFMADDCPHZ256mbkz_VFMADDCPHZ256mk*/ 169809) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2210
  {DBGFIELD(/*VFCMADDCSHZmk_VFCMADDCSHZmkz_VFMADDCSHZmk_VFMADDCSHZmkz_VFCMULCPHZ128rmbk_VFCMULCPHZ128rmkz_VFMULCPHZ128rmbk_VFMULCPHZ128rmkz_VFCMULCPHZ128rmbkz_VFCMULCPHZ128rmk_VFMULCPHZ128rmbkz_VFMULCPHZ128rmk_VFCMULCSHZrmk_VFCMULCSHZrmkz_VFMULCSHZrmk_VFMULCSHZrmkz*/ 169949) 2, false, false, false, 101, 7,  8, 1,  6, 1}, // #2211
  {DBGFIELD(/*VFCMULCPHZ256rmbk_VFCMULCPHZ256rmkz_VFMULCPHZ256rmbk_VFMULCPHZ256rmkz_VFCMULCPHZ256rmbkz_VFCMULCPHZ256rmk_VFMULCPHZ256rmbkz_VFMULCPHZ256rmk*/ 170201) 2, false, false, false, 101, 7,  2, 1,  6, 1}, // #2212
  {DBGFIELD(/*VFCMADDCPHZ128r_VFMADDCPHZ128r_VFCMADDCSHZr_VFCMADDCSHZrb_VFMADDCSHZr_VFMADDCSHZrb_VFCMULCPHZ128rr_VFMULCPHZ128rr_VFCMULCSHZrr_VFCMULCSHZrrb_VFMULCSHZrr_VFMULCSHZrrb*/ 170341) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2213
  {DBGFIELD(/*VFCMADDCPHZ256r_VFMADDCPHZ256r_VFCMULCPHZ256rr_VFMULCPHZ256rr*/ 170507) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2214
  {DBGFIELD(/*VRNDSCALEPHZ128rri_VRNDSCALESHZrri_Int_VRNDSCALESHZrrib_Int*/ 170569) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2215
  {DBGFIELD(/*VRNDSCALEPHZ256rri*/ 170629) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2216
  {DBGFIELD(/*VSCALEFPHZ128rr*/ 170648)    1, false, false, false, 86, 6,  6, 1,  0, 0}, // #2217
  {DBGFIELD(/*VSCALEFPHZ256rr*/ 170664)    1, false, false, false, 86, 6,  6, 1,  0, 0}, // #2218
  {DBGFIELD(/*VRNDSCALESHZrri*/ 170680)    2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2219
  {DBGFIELD(/*VSCALEFSHZrr_VSCALEFSHZrrb_Int*/ 170696) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2220
  {DBGFIELD(/*VFCMADDCPHZ128rk_VFCMADDCPHZ128rkz_VFMADDCPHZ128rk_VFMADDCPHZ128rkz_VFCMADDCSHZrbk_VFCMADDCSHZrkz_VFMADDCSHZrbk_VFMADDCSHZrkz_VFCMADDCSHZrbkz_VFCMADDCSHZrk_VFMADDCSHZrbkz_VFMADDCSHZrk_VFCMULCPHZ128rrk_VFCMULCPHZ128rrkz_VFMULCPHZ128rrk_VFMULCPHZ128rrkz_VFCMULCSHZrrbk_VFCMULCSHZrrkz_VFMULCSHZrrbk_VFMULCSHZrrkz_VFCMULCSHZrrbkz_VFCMULCSHZrrk_VFMULCSHZrrbkz_VFMULCSHZrrk*/ 170727) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2221
  {DBGFIELD(/*VFCMADDCPHZ256rk_VFCMADDCPHZ256rkz_VFMADDCPHZ256rk_VFMADDCPHZ256rkz_VFCMULCPHZ256rrk_VFCMULCPHZ256rrkz_VFMULCPHZ256rrk_VFMULCPHZ256rrkz*/ 171095) 1, false, false, false, 108, 5, 14, 1,  0, 0}, // #2222
  {DBGFIELD(/*VFCMADDCPHZm_VFCMADDCPHZmb_VFMADDCPHZm_VFMADDCPHZmb*/ 171231) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2223
  {DBGFIELD(/*VFCMULCPHZrm_VFCMULCPHZrmb_VFMULCPHZrm_VFMULCPHZrmb*/ 171283) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2224
  {DBGFIELD(/*VRNDSCALEPDZrmbi_VRNDSCALEPDZrmi_VRNDSCALEPHZrmbi_VRNDSCALEPHZrmi_VRNDSCALEPSZrmbi_VRNDSCALEPSZrmi_VRNDSCALEPDZrmbik_VRNDSCALEPDZrmbikz_VRNDSCALEPDZrmik_VRNDSCALEPDZrmikz_VRNDSCALEPSZrmbik_VRNDSCALEPSZrmbikz_VRNDSCALEPSZrmik_VRNDSCALEPSZrmikz*/ 171335) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2225
  {DBGFIELD(/*VSCALEFPHZrm_VSCALEFPHZrmb*/ 171578) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2226
  {DBGFIELD(/*VFCMADDCPHZmbk_VFCMADDCPHZmkz_VFMADDCPHZmbk_VFMADDCPHZmkz_VFCMADDCPHZmbkz_VFCMADDCPHZmk_VFMADDCPHZmbkz_VFMADDCPHZmk*/ 171605) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2227
  {DBGFIELD(/*VFCMULCPHZrmbk_VFCMULCPHZrmkz_VFMULCPHZrmbk_VFMULCPHZrmkz_VFCMULCPHZrmbkz_VFCMULCPHZrmk_VFMULCPHZrmbkz_VFMULCPHZrmk*/ 171721) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2228
  {DBGFIELD(/*VFCMADDCPHZr_VFCMADDCPHZrb_VFMADDCPHZr_VFMADDCPHZrb_VFCMULCPHZrr_VFCMULCPHZrrb_VFMULCPHZrr_VFMULCPHZrrb*/ 171837) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2229
  {DBGFIELD(/*VRNDSCALEPHZrri_VRNDSCALEPHZrrib*/ 171941) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2230
  {DBGFIELD(/*VSCALEFPHZrr_VSCALEFPHZrrb*/ 171974) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2231
  {DBGFIELD(/*VFCMADDCPHZrbk_VFCMADDCPHZrkz_VFMADDCPHZrbk_VFMADDCPHZrkz_VFCMADDCPHZrbkz_VFCMADDCPHZrk_VFMADDCPHZrbkz_VFMADDCPHZrk_VFCMULCPHZrrbk_VFCMULCPHZrrkz_VFMULCPHZrrbk_VFMULCPHZrrkz_VFCMULCPHZrrbkz_VFCMULCPHZrrk_VFMULCPHZrrbkz_VFMULCPHZrrk*/ 172001) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2232
  {DBGFIELD(/*VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm*/ 172233) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #2233
  {DBGFIELD(/*VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQQZ256rm*/ 172301) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #2234
  {DBGFIELD(/*VGATHERQPSZ256rm_VPGATHERQDZ256rm*/ 172369) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #2235
  {DBGFIELD(/*VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm*/ 172403) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #2236
  {DBGFIELD(/*VGATHERQPSZrm_VPGATHERQDZrm*/ 172459) 1, false, false, false, 39, 3, 42, 2,  0, 0}, // #2237
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ128rmbik_VGF2P8AFFINEINVQBZ128rmbikz_VGF2P8AFFINEINVQBZ128rmik_VGF2P8AFFINEINVQBZ128rmikz_VGF2P8AFFINEQBZ128rmbik_VGF2P8AFFINEQBZ128rmbikz_VGF2P8AFFINEQBZ128rmik_VGF2P8AFFINEQBZ128rmikz*/ 172487) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2238
  {DBGFIELD(/*VGF2P8MULBZ128rmk_VGF2P8MULBZ128rmkz*/ 172691) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2239
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ256rmbik_VGF2P8AFFINEINVQBZ256rmbikz_VGF2P8AFFINEINVQBZ256rmik_VGF2P8AFFINEINVQBZ256rmikz_VGF2P8AFFINEQBZ256rmbik_VGF2P8AFFINEQBZ256rmbikz_VGF2P8AFFINEQBZ256rmik_VGF2P8AFFINEQBZ256rmikz*/ 172728) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2240
  {DBGFIELD(/*VGF2P8MULBZ256rmk_VGF2P8MULBZ256rmkz*/ 172932) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2241
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ128rrik_VGF2P8AFFINEQBZ128rrik*/ 172969) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2242
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ256rrik_VGF2P8AFFINEQBZ256rrik*/ 173018) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2243
  {DBGFIELD(/*VGF2P8MULBZ128rrk*/ 173067)  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2244
  {DBGFIELD(/*VGF2P8MULBZ256rrk*/ 173085)  1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2245
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ128rrikz_VGF2P8AFFINEQBZ128rrikz*/ 173103) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2246
  {DBGFIELD(/*VGF2P8AFFINEINVQBZ256rrikz_VGF2P8AFFINEQBZ256rrikz*/ 173154) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2247
  {DBGFIELD(/*VGF2P8MULBZ128rrkz*/ 173205) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2248
  {DBGFIELD(/*VGF2P8MULBZ256rrkz*/ 173224) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2249
  {DBGFIELD(/*VGF2P8AFFINEINVQBZrmbik_VGF2P8AFFINEINVQBZrmbikz_VGF2P8AFFINEINVQBZrmik_VGF2P8AFFINEINVQBZrmikz_VGF2P8AFFINEQBZrmbik_VGF2P8AFFINEQBZrmbikz_VGF2P8AFFINEQBZrmik_VGF2P8AFFINEQBZrmikz*/ 173243) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2250
  {DBGFIELD(/*VGF2P8MULBZrmk_VGF2P8MULBZrmkz*/ 173423) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2251
  {DBGFIELD(/*VGF2P8AFFINEINVQBZrrik_VGF2P8AFFINEQBZrrik*/ 173454) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2252
  {DBGFIELD(/*VGF2P8MULBZrrk*/ 173497)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2253
  {DBGFIELD(/*VGF2P8AFFINEINVQBZrrikz_VGF2P8AFFINEQBZrrikz*/ 173512) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2254
  {DBGFIELD(/*VGF2P8MULBZrrkz*/ 173557)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2255
  {DBGFIELD(/*VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz*/ 173573) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #2256
  {DBGFIELD(/*VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz*/ 173641) 1, false, false, false, 39, 3,  7, 1,  0, 0}, // #2257
  {DBGFIELD(/*VMOVSHZrmk_VMOVSHZrmkz*/ 173709) 1, false, false, false, 39, 3,  4, 1,  0, 0}, // #2258
  {DBGFIELD(/*VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz*/ 173732) 2, false, false, false, 102, 6,  7, 1,  6, 1}, // #2259
  {DBGFIELD(/*VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz*/ 173802) 4, false, false, false, 843, 6,  9, 1,  6, 1}, // #2260
  {DBGFIELD(/*VMOVDQU16Z128rrk_VMOVDQU16Z128rrk_REV_VMOVDQU16Z128rrkz_VMOVDQU16Z128rrkz_REV_VMOVDQU8Z128rrk_VMOVDQU8Z128rrk_REV_VMOVDQU8Z128rrkz_VMOVDQU8Z128rrkz_REV_VPMOVM2BZ128rk_VPMOVM2WZ128rk*/ 173872) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2261
  {DBGFIELD(/*VMOVDQU16Z256rrk_VMOVDQU16Z256rrk_REV_VMOVDQU16Z256rrkz_VMOVDQU16Z256rrkz_REV_VMOVDQU8Z256rrk_VMOVDQU8Z256rrk_REV_VMOVDQU8Z256rrkz_VMOVDQU8Z256rrkz_REV_VPMOVM2BZ256rk_VPMOVM2WZ256rk*/ 174054) 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2262
  {DBGFIELD(/*VMOVSHZrrk_VMOVSHZrrk_REV_VMOVSHZrrkz_VMOVSHZrrkz_REV*/ 174236) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2263
  {DBGFIELD(/*VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz*/ 174290) 1, false, false, false, 109, 4,  1, 1,  0, 0}, // #2264
  {DBGFIELD(/*VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz*/ 174360) 3, false, false, false, 849, 4,  6, 1,  0, 0}, // #2265
  {DBGFIELD(/*VMOVDQU8Zmrk*/ 174430)       2, false, false, false, 35, 4,  2, 1,  0, 0}, // #2266
  {DBGFIELD(/*VMOVNTDQZ128mr*/ 174443)     2, false, false, false, 35, 4, 25, 1,  0, 0}, // #2267
  {DBGFIELD(/*VMOVNTDQZ256mr*/ 174458)     2, false, false, false, 35, 4, 44, 1,  0, 0}, // #2268
  {DBGFIELD(/*VMOVNTDQZmr*/ 174473)        2, false, false, false, 35, 4, 44, 1,  0, 0}, // #2269
  {DBGFIELD(/*VMOVNTPDZ128mr*/ 174485)     2, false, false, false, 35, 4, 27, 1,  0, 0}, // #2270
  {DBGFIELD(/*VMOVNTPDZ256mr*/ 174500)     2, false, false, false, 35, 4, 45, 1,  0, 0}, // #2271
  {DBGFIELD(/*VMOVNTPDZmr*/ 174515)        2, false, false, false, 35, 4, 45, 1,  0, 0}, // #2272
  {DBGFIELD(/*VMOVNTPSZ128mr*/ 174527)     2, false, false, false, 35, 4, 27, 1,  0, 0}, // #2273
  {DBGFIELD(/*VMOVNTPSZ256mr*/ 174542)     2, false, false, false, 35, 4, 45, 1,  0, 0}, // #2274
  {DBGFIELD(/*VMOVNTPSZmr*/ 174557)        2, false, false, false, 35, 4, 45, 1,  0, 0}, // #2275
  {DBGFIELD(/*VP2INTERSECTDZ128rm_VP2INTERSECTDZ128rmb*/ 174569) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2276
  {DBGFIELD(/*VP2INTERSECTQZ256rm_VP2INTERSECTQZ256rmb*/ 174610) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2277
  {DBGFIELD(/*VP2INTERSECTDZ128rr*/ 174651) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2278
  {DBGFIELD(/*VP2INTERSECTQZ256rr*/ 174671) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2279
  {DBGFIELD(/*VP2INTERSECTDZ256rm_VP2INTERSECTDZ256rmb*/ 174691) 2, false, false, false, 101, 7, 22, 1,  6, 1}, // #2280
  {DBGFIELD(/*VP2INTERSECTDZ256rr*/ 174732) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2281
  {DBGFIELD(/*VP2INTERSECTDZrm_VP2INTERSECTDZrmb*/ 174752) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2282
  {DBGFIELD(/*VP2INTERSECTDZrr*/ 174787)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2283
  {DBGFIELD(/*VP2INTERSECTQZ128rm_VP2INTERSECTQZ128rmb*/ 174804) 2, false, false, false, 101, 7,  7, 1,  6, 1}, // #2284
  {DBGFIELD(/*VP2INTERSECTQZ128rr*/ 174845) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2285
  {DBGFIELD(/*VP2INTERSECTQZrm_VP2INTERSECTQZrmb*/ 174865) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2286
  {DBGFIELD(/*VP2INTERSECTQZrr*/ 174900)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2287
  {DBGFIELD(/*VPABSBZ128rrk_VPABSBZ128rrkz_VPABSWZ128rrk_VPABSWZ128rrkz_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz*/ 174917) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2288
  {DBGFIELD(/*VPABSBZ256rrk_VPABSBZ256rrkz_VPABSWZ256rrk_VPABSWZ256rrkz_VPSUBSBZ256rrk_VPSUBSBZ256rrkz_VPSUBSWZ256rrk_VPSUBSWZ256rrkz_VPADDSBZ256rrk_VPADDSBZ256rrkz_VPADDSWZ256rrk_VPADDSWZ256rrkz_VPADDUSBZ256rrk_VPADDUSBZ256rrkz_VPADDUSWZ256rrk_VPADDUSWZ256rrkz_VPAVGBZ256rrk_VPAVGBZ256rrkz_VPAVGWZ256rrk_VPAVGWZ256rrkz_VPMAXSBZ256rrk_VPMAXSBZ256rrkz_VPMAXUWZ256rrk_VPMAXUWZ256rrkz_VPMINSBZ256rrk_VPMINSBZ256rrkz_VPMINUWZ256rrk_VPMINUWZ256rrkz_VPMAXSWZ256rrk_VPMAXSWZ256rrkz_VPMAXUBZ256rrk_VPMAXUBZ256rrkz_VPMINSWZ256rrk_VPMINSWZ256rrkz_VPMINUBZ256rrk_VPMINUBZ256rrkz_VPSUBUSBZ256rrk_VPSUBUSBZ256rrkz_VPSUBUSWZ256rrk_VPSUBUSWZ256rrkz*/ 175289) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2289
  {DBGFIELD(/*VPMAXSBZ128rrk_VPMAXSBZ128rrkz_VPMAXUWZ128rrk_VPMAXUWZ128rrkz_VPMINSBZ128rrk_VPMINSBZ128rrkz_VPMINUWZ128rrk_VPMINUWZ128rrkz_VPMAXSWZ128rrk_VPMAXSWZ128rrkz_VPMAXUBZ128rrk_VPMAXUBZ128rrkz_VPMINSWZ128rrk_VPMINSWZ128rrkz_VPMINUBZ128rrk_VPMINUBZ128rrkz*/ 175909) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2290
  {DBGFIELD(/*VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz*/ 176157) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2291
  {DBGFIELD(/*VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz*/ 176219) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2292
  {DBGFIELD(/*VPSLLVWZ128rrk_VPSLLVWZ128rrkz_VPSRLVWZ128rrk_VPSRLVWZ128rrkz_VPSRAVWZ128rrk_VPSRAVWZ128rrkz*/ 176281) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2293
  {DBGFIELD(/*VPSLLVWZ256rrk_VPSLLVWZ256rrkz_VPSRLVWZ256rrk_VPSRLVWZ256rrkz_VPSRAVWZ256rrk_VPSRAVWZ256rrkz*/ 176374) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2294
  {DBGFIELD(/*VPSLLWZ128rik_VPSLLWZ128rikz_VPSRLWZ128rik_VPSRLWZ128rikz_VPSRAWZ128rik_VPSRAWZ128rikz*/ 176467) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2295
  {DBGFIELD(/*VPSLLWZ256rik_VPSLLWZ256rikz_VPSRLWZ256rik_VPSRLWZ256rikz_VPSRAWZ256rik_VPSRAWZ256rikz*/ 176554) 1, false, false, false, 108, 5,  1, 1,  0, 0}, // #2296
  {DBGFIELD(/*VSHUFPDZ256rmbi_VSHUFPDZ256rmik_VSHUFPSZ256rmbi_VSHUFPSZ256rmik_VSHUFPDZ256rmbik_VSHUFPDZ256rmbikz_VSHUFPSZ256rmbik_VSHUFPSZ256rmbikz_VSHUFPDZ256rmi_VSHUFPDZ256rmikz_VSHUFPSZ256rmi_VSHUFPSZ256rmikz*/ 176641) 2, false, false, false, 526, 11, 22, 1,  6, 1}, // #2297
  {DBGFIELD(/*VPBROADCASTMB2QZ128rr_VPBROADCASTMB2QZ256rr_VPBROADCASTMW2DZ128rr_VPBROADCASTMW2DZ256rr_VPBROADCASTMB2QZrr_VPBROADCASTMW2DZrr*/ 176839) 1, false, false, false, 92, 9,  1, 1,  0, 0}, // #2298
  {DBGFIELD(/*VPERMWZrrk_VPERMWZrrkz*/ 176965) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2299
  {DBGFIELD(/*VPSRAWZrrk_VPSRAWZrrkz_VPSLLWZrrk_VPSLLWZrrkz_VPSRLWZrrk_VPSRLWZrrkz*/ 176988) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2300
  {DBGFIELD(/*VPSHUFBITQMBZ128rr*/ 177057) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2301
  {DBGFIELD(/*VPSHUFBITQMBZ256rr*/ 177076) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2302
  {DBGFIELD(/*VPSHUFBITQMBZrr*/ 177095)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2303
  {DBGFIELD(/*VPCOMPRESSBZ128mr_VPCOMPRESSBZ256mr_VPCOMPRESSWZ128mr_VPCOMPRESSWZ256mr*/ 177111) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2304
  {DBGFIELD(/*VPCOMPRESSWZmr*/ 177183)     2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2305
  {DBGFIELD(/*VPCOMPRESSBZ128mrk_VPCOMPRESSBZ256mrk_VPCOMPRESSWZ128mrk_VPCOMPRESSWZ256mrk*/ 177198) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2306
  {DBGFIELD(/*VPCOMPRESSWZmrk*/ 177274)    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2307
  {DBGFIELD(/*VPCOMPRESSBZmr*/ 177290)     2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2308
  {DBGFIELD(/*VPCOMPRESSBZmrk*/ 177305)    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2309
  {DBGFIELD(/*VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz*/ 177321) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2310
  {DBGFIELD(/*VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz*/ 177417) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2311
  {DBGFIELD(/*VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmk_VPCONFLICTDZrmkz*/ 177513) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2312
  {DBGFIELD(/*VPCONFLICTDZrr_VPCONFLICTDZrrkz*/ 177594) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2313
  {DBGFIELD(/*VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz*/ 177626) 2, false, false, false, 101, 7,  7, 1,  0, 0}, // #2314
  {DBGFIELD(/*VPERMI2BZ128rm_VPERMT2BZ128rm*/ 177722) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2315
  {DBGFIELD(/*VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz*/ 177752) 2, false, false, false, 101, 7, 22, 1,  0, 0}, // #2316
  {DBGFIELD(/*VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmk_VPCONFLICTQZrmkz*/ 177848) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2317
  {DBGFIELD(/*VPCONFLICTQZrr_VPCONFLICTQZrrkz*/ 177929) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2318
  {DBGFIELD(/*VPERMI2BZ128rmk_VPERMI2BZ128rmkz_VPERMT2BZ128rmk_VPERMT2BZ128rmkz*/ 177961) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2319
  {DBGFIELD(/*VPERMT2WZ128rm*/ 178027)     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2320
  {DBGFIELD(/*VPERMI2BZ128rr_VPERMT2BZ128rr*/ 178042) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2321
  {DBGFIELD(/*VPERMI2BZ256rr_VPERMT2BZ256rr*/ 178072) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2322
  {DBGFIELD(/*VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMT2BZ256rrk_VPERMT2BZ256rrkz*/ 178102) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2323
  {DBGFIELD(/*VPERMI2WZ128rr_VPERMT2WZ128rr*/ 178168) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2324
  {DBGFIELD(/*VPERMI2WZ256rr_VPERMT2WZ256rr*/ 178198) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2325
  {DBGFIELD(/*VPERMI2BZ256rm_VPERMT2BZ256rm*/ 178228) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2326
  {DBGFIELD(/*VPERMI2BZ256rmk_VPERMI2BZ256rmkz_VPERMT2BZ256rmk_VPERMT2BZ256rmkz*/ 178258) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2327
  {DBGFIELD(/*VPERMI2WZ128rm*/ 178324)     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2328
  {DBGFIELD(/*VPERMT2WZ256rm*/ 178339)     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2329
  {DBGFIELD(/*VPERMI2BZrm_VPERMT2BZrm*/ 178354) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2330
  {DBGFIELD(/*VPERMI2BZrmk_VPERMI2BZrmkz_VPERMT2BZrmk_VPERMT2BZrmkz*/ 178378) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2331
  {DBGFIELD(/*VPERMT2WZrm*/ 178432)        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2332
  {DBGFIELD(/*VPERMI2BZrr_VPERMT2BZrr*/ 178444) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2333
  {DBGFIELD(/*VPERMI2BZrrk_VPERMI2BZrrkz_VPERMT2BZrrk_VPERMT2BZrrkz*/ 178468) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2334
  {DBGFIELD(/*VPERMI2WZrr_VPERMT2WZrr*/ 178522) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2335
  {DBGFIELD(/*VPERMI2WZ128rmk_VPERMI2WZ128rmkz*/ 178546) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2336
  {DBGFIELD(/*VPERMT2WZ256rmk_VPERMT2WZ256rmkz*/ 178579) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2337
  {DBGFIELD(/*VPERMI2WZ256rm*/ 178612)     2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2338
  {DBGFIELD(/*VPERMI2WZ256rmk_VPERMI2WZ256rmkz*/ 178627) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2339
  {DBGFIELD(/*VPERMI2WZrm*/ 178660)        2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2340
  {DBGFIELD(/*VPERMI2WZrmk_VPERMI2WZrmkz*/ 178672) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2341
  {DBGFIELD(/*VPERMWZ128rm*/ 178699)       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2342
  {DBGFIELD(/*VPERMWZ256rmk_VPERMWZ256rmkz*/ 178712) 2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2343
  {DBGFIELD(/*VPERMWZ128rr*/ 178741)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2344
  {DBGFIELD(/*VPERMWZ256rr*/ 178754)       1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2345
  {DBGFIELD(/*VPERMWZ256rm*/ 178767)       2, false, false, false, 526, 11,  8, 1,  6, 1}, // #2346
  {DBGFIELD(/*VPEXPANDBZ128rrk_VPEXPANDBZ128rrkz_VPEXPANDWZ128rrk_VPEXPANDWZ128rrkz*/ 178780) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2347
  {DBGFIELD(/*VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz*/ 178850) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2348
  {DBGFIELD(/*VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrrk_VPEXPANDWZrrkz*/ 178920) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2349
  {DBGFIELD(/*VPMADDUBSWZ128rrk_VPMADDUBSWZ128rrkz_VPMULHRSWZ128rrk_VPMULHRSWZ128rrkz_VPMULHUWZ128rrk_VPMULHUWZ128rrkz_VPMULHWZ128rrk_VPMULHWZ128rrkz_VPMULLWZ128rrk_VPMULLWZ128rrkz*/ 178978) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2350
  {DBGFIELD(/*VPMADDUBSWZ256rrk_VPMADDUBSWZ256rrkz_VPMULHRSWZ256rrk_VPMULHRSWZ256rrkz_VPMULHUWZ256rrk_VPMULHUWZ256rrkz_VPMULHWZ256rrk_VPMULHWZ256rrkz_VPMULLWZ256rrk_VPMULLWZ256rrkz*/ 179145) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2351
  {DBGFIELD(/*VPMADDUBSWZrmk_VPMADDUBSWZrmkz_VPMULHRSWZrmk_VPMULHRSWZrmkz_VPMULHUWZrmk_VPMULHUWZrmkz_VPMULHWZrmk_VPMULHWZrmkz_VPMULLWZrmk_VPMULLWZrmkz*/ 179312) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2352
  {DBGFIELD(/*VPMADDUBSWZrrk_VPMADDUBSWZrrkz_VPMULHRSWZrrk_VPMULHRSWZrrkz_VPMULHUWZrrk_VPMULHUWZrrkz_VPMULHWZrrk_VPMULHWZrrkz_VPMULLWZrrk_VPMULLWZrrkz*/ 179449) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2353
  {DBGFIELD(/*VPMOVDBZ128mr_VPMOVDBZ256mr_VPMOVUSDBZ128mr_VPMOVUSDBZ256mr_VPMOVDWZ128mr_VPMOVDWZ256mr_VPMOVQWZ128mr_VPMOVQWZ256mr_VPMOVSDWZ128mr_VPMOVSDWZ256mr_VPMOVSQWZ128mr_VPMOVSQWZ256mr_VPMOVUSDWZ128mr_VPMOVUSDWZ256mr_VPMOVUSQWZ128mr_VPMOVUSQWZ256mr_VPMOVQBZ256mr_VPMOVSDBZ256mr_VPMOVSWBZ256mr_VPMOVWBZ256mr_VPMOVSDBZ128mr_VPMOVWBZ128mr_VPMOVSQBZ256mr_VPMOVUSQBZ256mr_VPMOVSQDZ128mr_VPMOVSQDZ256mr_VPMOVUSQDZ128mr_VPMOVUSQDZ256mr_VPMOVSWBZ128mr_VPMOVUSWBZ128mr*/ 179586) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2354
  {DBGFIELD(/*VPMOVUSWBZ256mr*/ 180037)    2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2355
  {DBGFIELD(/*VPMOVDBZ128mrk_VPMOVQBZ128mrk_VPMOVSQBZ128mrk_VPMOVSWBZ128mrk_VPMOVWBZ128mrk_VPMOVDWZ128mrk_VPMOVQWZ128mrk_VPMOVSDWZ128mrk_VPMOVSQWZ128mrk_VPMOVUSDWZ128mrk_VPMOVUSQWZ128mrk_VPMOVSDBZ128mrk_VPMOVSQDZ128mrk_VPMOVUSDBZ128mrk_VPMOVUSQDZ128mrk_VPMOVUSQBZ128mrk_VPMOVUSWBZ128mrk*/ 180053) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2356
  {DBGFIELD(/*VPMOVDBZ128rr_VPMOVQBZ128rr_VPMOVSQBZ128rr_VPMOVSWBZ128rr_VPMOVWBZ128rr_VPMOVDWZ128rr_VPMOVQWZ128rr_VPMOVSDWZ128rr_VPMOVSQWZ128rr_VPMOVUSDWZ128rr_VPMOVSDBZ128rr_VPMOVSQDZ128rr_VPMOVUSDBZ128rr_VPMOVUSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSWBZ128rr*/ 180326) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2357
  {DBGFIELD(/*VPMOVUSQWZ128rr*/ 180634)    1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2358
  {DBGFIELD(/*VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVDBZ256rr_VPMOVQBZ256rr_VPMOVSQBZ256rr_VPMOVSWBZ256rr_VPMOVWBZ256rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVDWZ256rr_VPMOVQWZ256rr_VPMOVSDWZ256rr_VPMOVSQWZ256rr_VPMOVUSDWZ256rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSQDZ256rr_VPMOVUSDBZ256rr_VPMOVUSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSWBZ256rr*/ 180650) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2359
  {DBGFIELD(/*VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVUSQWZ256rr*/ 181418) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2360
  {DBGFIELD(/*VPMOVDBZ256mrk_VPMOVQBZ256mrk_VPMOVSQBZ256mrk_VPMOVSWBZ256mrk_VPMOVWBZ256mrk_VPMOVDWZ256mrk_VPMOVQWZ256mrk_VPMOVSDWZ256mrk_VPMOVSQWZ256mrk_VPMOVUSDWZ256mrk_VPMOVUSQWZ256mrk_VPMOVSDBZ256mrk_VPMOVSQDZ256mrk_VPMOVUSDBZ256mrk_VPMOVUSQDZ256mrk_VPMOVUSQBZ256mrk_VPMOVUSWBZ256mrk*/ 181469) 2, false, false, false, 526, 11,  8, 1,  0, 0}, // #2361
  {DBGFIELD(/*VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz*/ 181742) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2362
  {DBGFIELD(/*VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmk_VPMULLQZ128rmkz*/ 181777) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2363
  {DBGFIELD(/*VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmk_VPMULLQZ256rmkz*/ 181853) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2364
  {DBGFIELD(/*VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmk_VPMULLQZrmkz*/ 181929) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2365
  {DBGFIELD(/*VPSCATTERQDZ256mr_VSCATTERQPSZ256mr*/ 181990) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #2366
  {DBGFIELD(/*VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr*/ 182026) 2, false, false, false, 35, 4,  2, 1,  0, 0}, // #2367
  {DBGFIELD(/*VPSHLDDZ128rmbi_VPSHLDQZ128rmbi_VPSHRDDZ128rmbi_VPSHRDQZ128rmbi_VPSHLDDZ128rmi_VPSHLDQZ128rmi_VPSHLDWZ128rmi_VPSHRDDZ128rmi_VPSHRDQZ128rmi_VPSHRDWZ128rmi_VPSHLDVDZ128m_VPSHLDVQZ128m_VPSHLDVWZ128m_VPSHRDVDZ128m_VPSHRDVQZ128m_VPSHRDVWZ128m_VPSHLDVDZ128mb_VPSHLDVDZ128mk_VPSHLDVDZ128mkz_VPSHLDVQZ128mb_VPSHLDVQZ128mk_VPSHLDVQZ128mkz_VPSHRDVDZ128mb_VPSHRDVDZ128mk_VPSHRDVDZ128mkz_VPSHRDVQZ128mb_VPSHRDVQZ128mk_VPSHRDVQZ128mkz_VPSHLDVDZ128mbk_VPSHLDVDZ128mbkz_VPSHLDVQZ128mbk_VPSHLDVQZ128mbkz_VPSHRDVDZ128mbk_VPSHRDVDZ128mbkz_VPSHRDVQZ128mbk_VPSHRDVQZ128mbkz*/ 182086) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2368
  {DBGFIELD(/*VPSHLDDZ128rmbik_VPSHLDDZ128rmbikz_VPSHLDDZ128rmik_VPSHLDDZ128rmikz_VPSHLDQZ128rmbik_VPSHLDQZ128rmbikz_VPSHLDQZ128rmik_VPSHLDQZ128rmikz_VPSHRDDZ128rmbik_VPSHRDDZ128rmbikz_VPSHRDDZ128rmik_VPSHRDDZ128rmikz_VPSHRDQZ128rmbik_VPSHRDQZ128rmbikz_VPSHRDQZ128rmik_VPSHRDQZ128rmikz*/ 182640) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2369
  {DBGFIELD(/*VPSHLDDZ128rri_VPSHLDQZ128rri_VPSHLDWZ128rri_VPSHRDDZ128rri_VPSHRDQZ128rri_VPSHRDWZ128rri_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz*/ 182912) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2370
  {DBGFIELD(/*VPSHLDDZ256rri_VPSHLDQZ256rri_VPSHLDWZ256rri_VPSHRDDZ256rri_VPSHRDQZ256rri_VPSHRDWZ256rri_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz*/ 183126) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2371
  {DBGFIELD(/*VPSHLDVDZ128r_VPSHLDVQZ128r_VPSHLDVWZ128r_VPSHRDVDZ128r_VPSHRDVQZ128r_VPSHRDVWZ128r*/ 183340) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2372
  {DBGFIELD(/*VPSHLDVDZ256r_VPSHLDVQZ256r_VPSHLDVWZ256r_VPSHRDVDZ256r_VPSHRDVQZ256r_VPSHRDVWZ256r*/ 183424) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2373
  {DBGFIELD(/*VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rrik_VPSHRDQZ128rrikz*/ 183508) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2374
  {DBGFIELD(/*VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rrik_VPSHRDQZ256rrikz*/ 183640) 1, false, false, false, 108, 5, 10, 1,  0, 0}, // #2375
  {DBGFIELD(/*VPSHLDDZ256rmbi_VPSHLDQZ256rmbi_VPSHRDDZ256rmbi_VPSHRDQZ256rmbi_VPSHLDDZ256rmi_VPSHLDQZ256rmi_VPSHLDWZ256rmi_VPSHRDDZ256rmi_VPSHRDQZ256rmi_VPSHRDWZ256rmi_VPSHLDVDZ256m_VPSHLDVQZ256m_VPSHLDVWZ256m_VPSHRDVDZ256m_VPSHRDVQZ256m_VPSHRDVWZ256m_VPSHLDVDZ256mb_VPSHLDVDZ256mk_VPSHLDVDZ256mkz_VPSHLDVQZ256mb_VPSHLDVQZ256mk_VPSHLDVQZ256mkz_VPSHRDVDZ256mb_VPSHRDVDZ256mk_VPSHRDVDZ256mkz_VPSHRDVQZ256mb_VPSHRDVQZ256mk_VPSHRDVQZ256mkz_VPSHLDVDZ256mbk_VPSHLDVDZ256mbkz_VPSHLDVQZ256mbk_VPSHLDVQZ256mbkz_VPSHRDVDZ256mbk_VPSHRDVDZ256mbkz_VPSHRDVQZ256mbk_VPSHRDVQZ256mbkz*/ 183772) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2376
  {DBGFIELD(/*VPSHLDDZ256rmbik_VPSHLDDZ256rmbikz_VPSHLDDZ256rmik_VPSHLDDZ256rmikz_VPSHLDQZ256rmbik_VPSHLDQZ256rmbikz_VPSHLDQZ256rmik_VPSHLDQZ256rmikz_VPSHRDDZ256rmbik_VPSHRDDZ256rmbikz_VPSHRDDZ256rmik_VPSHRDDZ256rmikz_VPSHRDQZ256rmbik_VPSHRDQZ256rmbikz_VPSHRDQZ256rmik_VPSHRDQZ256rmikz*/ 184326) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2377
  {DBGFIELD(/*VPSHLDDZrmbi_VPSHLDQZrmbi_VPSHRDDZrmbi_VPSHRDQZrmbi_VPSHLDDZrmi_VPSHLDQZrmi_VPSHLDWZrmi_VPSHRDDZrmi_VPSHRDQZrmi_VPSHRDWZrmi_VPSHLDVDZm_VPSHLDVQZm_VPSHLDVWZm_VPSHRDVDZm_VPSHRDVQZm_VPSHRDVWZm_VPSHLDVDZmb_VPSHLDVDZmk_VPSHLDVDZmkz_VPSHLDVQZmb_VPSHLDVQZmk_VPSHLDVQZmkz_VPSHRDVDZmb_VPSHRDVDZmk_VPSHRDVDZmkz_VPSHRDVQZmb_VPSHRDVQZmk_VPSHRDVQZmkz_VPSHLDVDZmbk_VPSHLDVDZmbkz_VPSHLDVQZmbk_VPSHLDVQZmbkz_VPSHRDVDZmbk_VPSHRDVDZmbkz_VPSHRDVQZmbk_VPSHRDVQZmbkz*/ 184598) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2378
  {DBGFIELD(/*VPSHLDDZrmbik_VPSHLDDZrmbikz_VPSHLDDZrmik_VPSHLDDZrmikz_VPSHLDQZrmbik_VPSHLDQZrmbikz_VPSHLDQZrmik_VPSHLDQZrmikz_VPSHRDDZrmbik_VPSHRDDZrmbikz_VPSHRDDZrmik_VPSHRDDZrmikz_VPSHRDQZrmbik_VPSHRDQZrmbikz_VPSHRDQZrmik_VPSHRDQZrmikz*/ 185044) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2379
  {DBGFIELD(/*VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrrik_VPSHRDQZrrikz*/ 185268) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2380
  {DBGFIELD(/*VPSHLDWZ128rmik_VPSHLDWZ128rmikz_VPSHRDWZ128rmik_VPSHRDWZ128rmikz*/ 185376) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2381
  {DBGFIELD(/*VPSHLDWZ256rmik_VPSHLDWZ256rmikz_VPSHRDWZ256rmik_VPSHRDWZ256rmikz*/ 185442) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2382
  {DBGFIELD(/*VPSHLDWZrmik_VPSHLDWZrmikz_VPSHRDWZrmik_VPSHRDWZrmikz*/ 185508) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2383
  {DBGFIELD(/*VPSHUFBITQMBZ128rm*/ 185562) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2384
  {DBGFIELD(/*VPSHUFBITQMBZ256rm*/ 185581) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2385
  {DBGFIELD(/*VPSHUFBITQMBZrm*/ 185600)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2386
  {DBGFIELD(/*VPSHUFBITQMBZ128rmk*/ 185616) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2387
  {DBGFIELD(/*VPSHUFBITQMBZ256rmk*/ 185636) 2, false, false, false, 101, 7, 24, 1,  6, 1}, // #2388
  {DBGFIELD(/*VPSHUFBITQMBZrmk*/ 185656)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2389
  {DBGFIELD(/*VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRAWZ128rrk_VPSRAWZ128rrkz*/ 185673) 2, false, false, false, 718, 7, 12, 1,  0, 0}, // #2390
  {DBGFIELD(/*VRCPPHZmbk_VRCPPHZmkz_VRCPPHZmbkz_VRCPPHZmk*/ 185760) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2391
  {DBGFIELD(/*VRSQRTPHZmbk_VRSQRTPHZmkz_VRSQRTPHZmbkz_VRSQRTPHZmk*/ 185804) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2392
  {DBGFIELD(/*VRCPPHZrk_VRCPPHZrkz*/ 185856) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2393
  {DBGFIELD(/*VREDUCEPHZ128rmbi_VREDUCEPHZ128rmi*/ 185877) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2394
  {DBGFIELD(/*VREDUCESHZrmi*/ 185912)      3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2395
  {DBGFIELD(/*VREDUCEPHZ256rmbi_VREDUCEPHZ256rmi*/ 185926) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2396
  {DBGFIELD(/*VREDUCEPHZ128rmbik_VREDUCEPHZ128rmbikz_VREDUCEPHZ128rmik_VREDUCEPHZ128rmikz_VREDUCESHZrmik_VREDUCESHZrmikz*/ 185961) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2397
  {DBGFIELD(/*VREDUCEPHZ256rmbik_VREDUCEPHZ256rmbikz_VREDUCEPHZ256rmik_VREDUCEPHZ256rmikz*/ 186068) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2398
  {DBGFIELD(/*VREDUCEPHZ128rri_VREDUCESHZrri_VREDUCESHZrrib*/ 186144) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2399
  {DBGFIELD(/*VREDUCEPHZ256rri*/ 186190)   2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2400
  {DBGFIELD(/*VREDUCEPHZ128rrik_VREDUCEPHZ128rrikz_VREDUCESHZrribk_VREDUCESHZrrikz_VREDUCESHZrribkz_VREDUCESHZrrik*/ 186207) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2401
  {DBGFIELD(/*VREDUCEPHZ256rrik_VREDUCEPHZ256rrikz*/ 186308) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2402
  {DBGFIELD(/*VREDUCEPHZrmbi_VREDUCEPHZrmi*/ 186345) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2403
  {DBGFIELD(/*VREDUCEPHZrmbik_VREDUCEPHZrmbikz_VREDUCEPHZrmik_VREDUCEPHZrmikz*/ 186374) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2404
  {DBGFIELD(/*VREDUCEPHZrri_VREDUCEPHZrrib*/ 186438) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2405
  {DBGFIELD(/*VREDUCEPHZrribk_VREDUCEPHZrrikz_VREDUCEPHZrribkz_VREDUCEPHZrrik*/ 186467) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2406
  {DBGFIELD(/*VRNDSCALEPDZrri_VRNDSCALEPDZrrib_VRNDSCALEPDZrribk_VRNDSCALEPDZrrik_VRNDSCALEPDZrrikz_VRNDSCALEPSZrri_VRNDSCALEPSZrrib_VRNDSCALEPSZrribk_VRNDSCALEPSZrrik_VRNDSCALEPSZrrikz_VRNDSCALEPDZrribkz_VRNDSCALEPSZrribkz*/ 186531) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2407
  {DBGFIELD(/*VRNDSCALEPHZ128rmbik_VRNDSCALEPHZ128rmbikz_VRNDSCALEPHZ128rmik_VRNDSCALEPHZ128rmikz_VRNDSCALESHZrmik_Int_VRNDSCALESHZrmikz_Int*/ 186741) 3, false, false, false, 113, 7, 11, 1,  6, 1}, // #2408
  {DBGFIELD(/*VSCALEFPHZ128rmbk_VSCALEFPHZ128rmkz_VSCALEFPHZ128rmbkz_VSCALEFPHZ128rmk*/ 186868) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2409
  {DBGFIELD(/*VRNDSCALEPHZ256rmbik_VRNDSCALEPHZ256rmbikz_VRNDSCALEPHZ256rmik_VRNDSCALEPHZ256rmikz*/ 186940) 3, false, false, false, 113, 7, 16, 1,  6, 1}, // #2410
  {DBGFIELD(/*VSCALEFPHZ256rmbk_VSCALEFPHZ256rmkz_VSCALEFPHZ256rmbkz_VSCALEFPHZ256rmk*/ 187024) 2, false, false, false, 78, 8,  8, 1,  6, 1}, // #2411
  {DBGFIELD(/*VSCALEFSHZrmk_VSCALEFSHZrmkz*/ 187096) 2, false, false, false, 78, 8,  9, 1,  6, 1}, // #2412
  {DBGFIELD(/*VRNDSCALEPHZ128rrik_VRNDSCALEPHZ128rrikz_VRNDSCALESHZrribk_Int_VRNDSCALESHZrribkz_Int_VRNDSCALESHZrrik_Int_VRNDSCALESHZrrikz_Int*/ 187125) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2413
  {DBGFIELD(/*VRNDSCALEPHZ256rrik_VRNDSCALEPHZ256rrikz*/ 187254) 2, false, false, false, 120, 5,  7, 1,  0, 0}, // #2414
  {DBGFIELD(/*VSCALEFPHZ128rrk_VSCALEFPHZ128rrkz*/ 187295) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #2415
  {DBGFIELD(/*VSCALEFPHZ256rrk_VSCALEFPHZ256rrkz*/ 187330) 1, false, false, false, 86, 6,  6, 1,  0, 0}, // #2416
  {DBGFIELD(/*VSCALEFSHZrrbk_Int_VSCALEFSHZrrbkz_Int_VSCALEFSHZrrk_VSCALEFSHZrrkz*/ 187365) 1, false, false, false, 92, 9,  6, 1,  0, 0}, // #2417
  {DBGFIELD(/*VRNDSCALEPHZrmbik_VRNDSCALEPHZrmbikz_VRNDSCALEPHZrmik_VRNDSCALEPHZrmikz*/ 187433) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2418
  {DBGFIELD(/*VSCALEFPHZrmbk_VSCALEFPHZrmkz_VSCALEFPHZrmbkz_VSCALEFPHZrmk*/ 187505) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2419
  {DBGFIELD(/*VRNDSCALEPHZrribk_VRNDSCALEPHZrrikz_VRNDSCALEPHZrribkz_VRNDSCALEPHZrrik*/ 187565) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2420
  {DBGFIELD(/*VSCALEFPHZrrbk_VSCALEFPHZrrkz_VSCALEFPHZrrbkz_VSCALEFPHZrrk*/ 187637) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2421
  {DBGFIELD(/*VRSQRT14PDZr_VRSQRT14PSZr*/ 187697) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2422
  {DBGFIELD(/*VRSQRT14PSZrk*/ 187723)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2423
  {DBGFIELD(/*VRSQRTPHZr*/ 187737)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2424
  {DBGFIELD(/*VSQRTPDYm*/ 187748)          2, false, false, false, 243, 11, 46, 1,  0, 0}, // #2425
  {DBGFIELD(/*VSQRTPDZ256m_VSQRTPDZ256mb*/ 187758) 2, false, false, false, 243, 11, 46, 1,  6, 1}, // #2426
  {DBGFIELD(/*VSQRTPDZ128mbk_VSQRTPDZ128mkz_VSQRTPDZ128mbkz_VSQRTPDZ128mk*/ 187785) 2, false, false, false, 243, 11, 41, 1,  6, 1}, // #2427
  {DBGFIELD(/*VSQRTSDZmk_Int_VSQRTSDZmkz_Int*/ 187845) 2, false, false, false, 243, 11, 18, 1,  6, 1}, // #2428
  {DBGFIELD(/*VSQRTPDZm*/ 187876)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2429
  {DBGFIELD(/*VSQRTPDZmb*/ 187886)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2430
  {DBGFIELD(/*VSQRTPDZr*/ 187897)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2431
  {DBGFIELD(/*VSQRTPHZ128mbk_VSQRTPHZ128mkz_VSQRTPHZ128mbkz_VSQRTPHZ128mk*/ 187907) 2, false, false, false, 243, 11, 17, 1,  6, 1}, // #2432
  {DBGFIELD(/*VSQRTPHZ128rk*/ 187967)      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2433
  {DBGFIELD(/*VSQRTPHZ256rk*/ 187981)      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2434
  {DBGFIELD(/*VSQRTPHZ256rkz*/ 187995)     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2435
  {DBGFIELD(/*VSQRTPHZ128rkz*/ 188010)     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2436
  {DBGFIELD(/*VSQRTPHZ256m_VSQRTPHZ256mb*/ 188025) 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #2437
  {DBGFIELD(/*VSQRTPHZ256mbk_VSQRTPHZ256mkz_VSQRTPHZ256mbkz_VSQRTPHZ256mk*/ 188052) 2, false, false, false, 243, 11, 15, 1,  6, 1}, // #2438
  {DBGFIELD(/*VSQRTPHZm_VSQRTPHZmb*/ 188112) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2439
  {DBGFIELD(/*VSQRTPHZmbk_VSQRTPHZmkz_VSQRTPHZmbkz_VSQRTPHZmk*/ 188133) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2440
  {DBGFIELD(/*VSQRTPHZr_VSQRTPHZrb*/ 188181) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2441
  {DBGFIELD(/*VSQRTPHZrbk_VSQRTPHZrkz_VSQRTPHZrbkz_VSQRTPHZrk*/ 188202) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2442
  {DBGFIELD(/*VSQRTPSZr*/ 188250)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2443
  {DBGFIELD(/*XTEST*/ 188260)              1, false, false, false, 42, 3,  5, 1,  0, 0}, // #2444
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188266) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2445
  {DBGFIELD(/*JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188371) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2446
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188477) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2447
  {DBGFIELD(/*JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188583) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2448
  {DBGFIELD(/*JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188688) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2449
  {DBGFIELD(/*JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188788) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2450
  {DBGFIELD(/*JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188889) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2451
  {DBGFIELD(/*WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 188990) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2452
  {DBGFIELD(/*JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 189090) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2453
  {DBGFIELD(/*WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 189191) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2454
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8B*/ 189288) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2455
  {DBGFIELD(/*JWriteLOCK_CMPXCHG16B*/ 189309) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2456
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8rm*/ 189331) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2457
  {DBGFIELD(/*JWriteLOCK_CMPXCHGrm*/ 189353) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2458
  {DBGFIELD(/*JWriteCMPXCHG8B*/ 189374)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2459
  {DBGFIELD(/*JWriteCMPXCHG16B*/ 189390)   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2460
  {DBGFIELD(/*JWriteCMPXCHG8rm*/ 189407)   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2461
  {DBGFIELD(/*WriteCMPXCHGRMW*/ 60)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2462
  {DBGFIELD(/*JWriteCMPXCHG8rr*/ 189424)   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2463
  {DBGFIELD(/*WriteCMPXCHG*/ 1876)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2464
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 189441) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2465
  {DBGFIELD(/*JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 189570) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2466
  {DBGFIELD(/*JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 189700) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2467
  {DBGFIELD(/*JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 189830) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2468
  {DBGFIELD(/*JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 189959) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2469
  {DBGFIELD(/*JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 190083) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2470
  {DBGFIELD(/*JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 190208) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2471
  {DBGFIELD(/*WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 190333) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2472
  {DBGFIELD(/*JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 190457) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2473
  {DBGFIELD(/*WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd*/ 190582) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2474
  {DBGFIELD(/*JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd*/ 190703) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2475
  {DBGFIELD(/*JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd*/ 190766) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2476
  {DBGFIELD(/*SBWriteZeroLatency*/ 190824) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2477
  {DBGFIELD(/*WriteALU*/ 19)           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2478
  {DBGFIELD(/*HWWriteZeroLatency*/ 190843) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2479
  {DBGFIELD(/*BWWriteZeroLatency*/ 190862) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2480
  {DBGFIELD(/*Zn3WriteZeroLatency*/ 190881) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2481
  {DBGFIELD(/*Zn4WriteZeroLatency*/ 190901) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2482
  {DBGFIELD(/*PdWriteZeroLatency*/ 190921) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2483
  {DBGFIELD(/*JWriteZeroLatency*/ 190940)  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2484
  {DBGFIELD(/*SKLWriteZeroLatency*/ 190958) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2485
  {DBGFIELD(/*SKXWriteZeroLatency*/ 190978) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2486
  {DBGFIELD(/*ICXWriteZeroLatency*/ 190998) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2487
  {DBGFIELD(/*WriteFLogic*/ 985)        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2488
  {DBGFIELD(/*WriteFLogicY*/ 7910)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2489
  {DBGFIELD(/*JWriteZeroIdiomYmm*/ 191018) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2490
  {DBGFIELD(/*WriteVecLogicX*/ 4593)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2491
  {DBGFIELD(/*WriteVecALUX*/ 3281)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2492
  {DBGFIELD(/*SKLWritePSUB*/ 191037)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2493
  {DBGFIELD(/*SKXWritePSUB*/ 191050)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2494
  {DBGFIELD(/*ICXWritePSUB*/ 191063)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2495
  {DBGFIELD(/*SBWritePCMPGTQ*/ 191076)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2496
  {DBGFIELD(/*HWWritePCMPGTQ*/ 191091)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2497
  {DBGFIELD(/*BWWritePCMPGTQ*/ 191106)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2498
  {DBGFIELD(/*SKLWritePCMPGTQ*/ 191121)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2499
  {DBGFIELD(/*SKXWritePCMPGTQ*/ 191137)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2500
  {DBGFIELD(/*ICXWritePCMPGTQ*/ 191153)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2501
  {DBGFIELD(/*SBWriteCMOVA_CMOVBErr*/ 191169) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2502
  {DBGFIELD(/*WriteCMOV*/ 1590)          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2503
  {DBGFIELD(/*HWWriteCMOVA_CMOVBErr*/ 191191) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2504
  {DBGFIELD(/*BWWriteCMOVA_CMOVBErr*/ 191213) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2505
  {DBGFIELD(/*SKLWriteCMOVA_CMOVBErr*/ 191235) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2506
  {DBGFIELD(/*SKXWriteCMOVA_CMOVBErr*/ 191258) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2507
  {DBGFIELD(/*ICXWriteCMOVA_CMOVBErr*/ 191281) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2508
  {DBGFIELD(/*SBWriteCMOVA_CMOVBErm*/ 191304) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2509
  {DBGFIELD(/*WriteCMOVLd*/ 191326)        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2510
  {DBGFIELD(/*HWWriteCMOVA_CMOVBErm*/ 191338) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2511
  {DBGFIELD(/*BWWriteCMOVA_CMOVBErm*/ 191360) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2512
  {DBGFIELD(/*PdWriteCMOVm*/ 191382)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2513
  {DBGFIELD(/*SKLWriteCMOVA_CMOVBErm*/ 191395) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2514
  {DBGFIELD(/*SKXWriteCMOVA_CMOVBErm*/ 191418) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2515
  {DBGFIELD(/*ICXWriteCMOVA_CMOVBErm*/ 191441) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2516
  {DBGFIELD(/*SBWriteSETA_SETBEr*/ 191464) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2517
  {DBGFIELD(/*WriteSETCC*/ 7331)         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2518
  {DBGFIELD(/*HWWriteSETA_SETBEr*/ 191483) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2519
  {DBGFIELD(/*BWWriteSETA_SETBEr*/ 191502) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2520
  {DBGFIELD(/*SKLWriteSETA_SETBEr*/ 191521) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2521
  {DBGFIELD(/*SKXWriteSETA_SETBEr*/ 191541) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2522
  {DBGFIELD(/*ICXWriteSETA_SETBEr*/ 191561) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2523
  {DBGFIELD(/*SBWriteSETA_SETBEm*/ 191581) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2524
  {DBGFIELD(/*WriteSETCCStore*/ 7315)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2525
  {DBGFIELD(/*HWWriteSETA_SETBEm*/ 191600) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2526
  {DBGFIELD(/*BWWriteSETA_SETBEm*/ 191619) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2527
  {DBGFIELD(/*PdWriteSETGEmSETGmSETLEmSETLm*/ 191638) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2528
  {DBGFIELD(/*SKLWriteSETA_SETBEm*/ 191668) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2529
  {DBGFIELD(/*SKXWriteSETA_SETBEm*/ 191688) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2530
  {DBGFIELD(/*ICXWriteSETA_SETBEm*/ 191708) 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2531
  {DBGFIELD(/*WriteVecLogicY*/ 11270)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2532
  {DBGFIELD(/*WriteVecALUY*/ 10475)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2533
  {DBGFIELD(/*HWWriteADC0*/ 191728)        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2534
  {DBGFIELD(/*WriteADC*/ 151)           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2535
  {DBGFIELD(/*WriteFShuffle256*/ 8409)   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2536
  {DBGFIELD(/*Zn3Write3OpsLEA*/ 191740)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2537
  {DBGFIELD(/*WriteLEA*/ 133)           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2538
  {DBGFIELD(/*Zn4Write3OpsLEA*/ 191756)    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2539
  {DBGFIELD(/*PdWrite3OpsLEA*/ 191772)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2540
  {DBGFIELD(/*JWrite3OpsLEA*/ 191787)      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2541
  {DBGFIELD(/*WriteFLogicZ*/ 7954)       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2542
  {DBGFIELD(/*WriteVecLogicZ*/ 11318)     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2543
  {DBGFIELD(/*WriteVecLogic*/ 4944)      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2544
  {DBGFIELD(/*WriteVecALU*/ 38)        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2545
  {DBGFIELD(/*JWriteLOCK_ALURMW*/ 191801)  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2546
  {DBGFIELD(/*WriteALURMW*/ 547)        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2547
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD(1)  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD(/*WriteALU*/ 19)           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD(/*WriteZero*/ 28)          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD(/*WriteVecALU*/ 38)        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD(/*WriteJump*/ 50)          1, false, false, false,  4, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD(/*WriteCMPXCHGRMW*/ 60)    1, false, false, false, 2619, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD(/*WriteJumpLd*/ 76)        1, false, false, false,  4, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD(/*WriteMove*/ 88)          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD(/*WriteFStore*/ 98)        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #8
  {DBGFIELD(/*WriteFLoad*/ 110)         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD(/*WriteSystem*/ 121)        1, false, false, false,  5, 1,  5, 1,  0, 0}, // #10
  {DBGFIELD(/*WriteLEA*/ 133)           1, false, false, false,  4, 2,  1, 1,  0, 0}, // #11
  {DBGFIELD(/*WriteRMW*/ 142)           1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #12
  {DBGFIELD(/*WriteADC*/ 151)           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #13
  {DBGFIELD(/*WriteSHDrri*/ 160)        1, false, false, false, 114, 1, 12, 1,  0, 0}, // #14
  {DBGFIELD(/*WriteFStoreX*/ 172)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #15
  {DBGFIELD(/*WriteFLoadX*/ 185)        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #16
  {DBGFIELD(/*WriteFStoreY*/ 197)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #17
  {DBGFIELD(/*WriteFLoadY*/ 210)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #18
  {DBGFIELD(/*WriteMicrocoded*/ 222)    1, false, false, false,  5, 1,  5, 1,  0, 0}, // #19
  {DBGFIELD(/*WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault*/ 238) 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD(/*WriteFSign*/ 310)         1, false, false, false,  4, 2,  1, 1,  0, 0}, // #21
  {DBGFIELD(/*WriteADCRMW*/ 321)        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #22
  {DBGFIELD(/*WriteADCLd_ReadAfterLd*/ 333) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #23
  {DBGFIELD(/*WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 356) 1, false, false, false, 2621, 2,  1, 1, 15, 2}, // #24
  {DBGFIELD(/*WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 452) 1, false, false, false, 2621, 2,  1, 1, 17, 2}, // #25
  {DBGFIELD(/*WriteALURMW*/ 547)        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #26
  {DBGFIELD(/*WriteALULd_ReadAfterLd*/ 559) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #27
  {DBGFIELD(/*WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 582) 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #28
  {DBGFIELD(/*WriteFAdd64XLd_ReadAfterVecXLd*/ 666) 4, false, false, false, 2623, 3,  4, 1, 14, 1}, // #29
  {DBGFIELD(/*WriteFAdd64X*/ 697)       3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #30
  {DBGFIELD(/*WriteFAddXLd_ReadAfterVecXLd*/ 710) 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #31
  {DBGFIELD(/*WriteFAddX*/ 739)         1, false, false, false,  4, 2, 10, 1,  0, 0}, // #32
  {DBGFIELD(/*WriteNop*/ 750)           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #33
  {DBGFIELD(/*WriteFAdd64Ld_ReadAfterVecLd*/ 759) 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #34
  {DBGFIELD(/*WriteFAdd64*/ 788)        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #35
  {DBGFIELD(/*WriteFAddLd_ReadAfterVecLd*/ 800) 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #36
  {DBGFIELD(/*WriteFAdd*/ 827)          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #37
  {DBGFIELD(/*WriteFAddLd*/ 837)        1, false, false, false, 381, 3, 10, 1,  0, 0}, // #38
  {DBGFIELD(/*WriteAESDecEncLd_ReadAfterVecXLd*/ 849) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD(/*WriteAESDecEnc*/ 882)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD(/*WriteAESIMCLd*/ 897)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD(/*WriteAESIMC*/ 911)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD(/*WriteAESKeyGenLd*/ 923)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #43
  {DBGFIELD(/*WriteAESKeyGen*/ 940)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #44
  {DBGFIELD(/*WriteFLogicLd_ReadAfterVecXLd*/ 955) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #45
  {DBGFIELD(/*WriteFLogic*/ 985)        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #46
  {DBGFIELD(/*WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 997) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD(/*WriteBEXTR*/ 1082)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #48
  {DBGFIELD(/*WriteBEXTRLd*/ 1093)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD(/*WriteALULd*/ 1106)         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #50
  {DBGFIELD(/*WriteFBlendLd_ReadAfterVecXLd*/ 1117) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD(/*WriteFBlend*/ 1147)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD(/*WriteFVarBlendLd_ReadAfterVecXLd*/ 1159) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD(/*WriteFVarBlend*/ 1192)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD(/*WriteBLSLd*/ 1207)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #55
  {DBGFIELD(/*WriteBLS*/ 1218)           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #56
  {DBGFIELD(/*WriteBSFLd*/ 1227)         10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #57
  {DBGFIELD(/*WriteBSF*/ 1238)           10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #58
  {DBGFIELD(/*WriteBSRLd*/ 1247)         10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #59
  {DBGFIELD(/*WriteBSR*/ 1258)           10, false, false, false, 2629, 3, 16, 1,  0, 0}, // #60
  {DBGFIELD(/*WriteBSWAP32*/ 1267)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD(/*WriteBSWAP64*/ 1280)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #62
  {DBGFIELD(/*WriteBitTestImmLd*/ 1293)  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #63
  {DBGFIELD(/*WriteBitTestRegLd*/ 1311)  1, false, false, false, 407, 1, 22, 1,  0, 0}, // #64
  {DBGFIELD(/*WriteBitTest*/ 1329)       1, false, false, false,  4, 2,  1, 1,  0, 0}, // #65
  {DBGFIELD(/*WriteBitTestSetImmRMW*/ 1342) 1, false, false, false, 114, 1, 12, 1,  0, 0}, // #66
  {DBGFIELD(/*WriteBitTestSetRegRMW*/ 1364) 1, false, false, false, 127, 1,  8, 1,  0, 0}, // #67
  {DBGFIELD(/*WriteBitTestSet*/ 1386)    1, false, false, false,  4, 2,  1, 1,  0, 0}, // #68
  {DBGFIELD(/*WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 1402) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #69
  {DBGFIELD(/*WriteBZHI*/ 1486)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #70
  {DBGFIELD(/*WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault*/ 1496) 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #71
  {DBGFIELD(/*WriteCMOVLd_ReadAfterLd*/ 1566) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #72
  {DBGFIELD(/*WriteCMOV*/ 1590)          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #73
  {DBGFIELD(/*WriteLoad*/ 1600)          1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #74
  {DBGFIELD(/*WriteFCMOV*/ 1610)         1, false, false, false, 407, 1, 22, 1,  0, 0}, // #75
  {DBGFIELD(/*WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 1621) 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #76
  {DBGFIELD(/*WriteXCHG*/ 1704)          1, false, false, false, 114, 1, 12, 1,  0, 0}, // #77
  {DBGFIELD(/*WriteFCmp64XLd_ReadAfterVecXLd*/ 1714) 4, false, false, false, 2623, 3,  4, 1, 14, 1}, // #78
  {DBGFIELD(/*WriteFCmp64X*/ 1745)       3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #79
  {DBGFIELD(/*WriteFCmpXLd_ReadAfterVecXLd*/ 1758) 4, false, false, false, 2623, 3,  4, 1, 14, 1}, // #80
  {DBGFIELD(/*WriteFCmpX*/ 1787)         3, false, false, false, 2626, 3,  3, 1,  0, 0}, // #81
  {DBGFIELD(/*WriteFCmp64Ld_ReadAfterVecLd*/ 1798) 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #82
  {DBGFIELD(/*WriteFCmp64*/ 1827)        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #83
  {DBGFIELD(/*WriteFCmpLd_ReadAfterVecLd*/ 1839) 1, false, false, false, 381, 3, 10, 1, 14, 1}, // #84
  {DBGFIELD(/*WriteFCmp*/ 1866)          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #85
  {DBGFIELD(/*WriteCMPXCHG*/ 1876)       1, false, false, false, 2632, 1, 11, 1,  0, 0}, // #86
  {DBGFIELD(/*WriteFComXLd_ReadAfterVecLd*/ 1889) 5, false, false, false, 2633, 3,  9, 1, 14, 1}, // #87
  {DBGFIELD(/*WriteFComX*/ 1917)         4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #88
  {DBGFIELD(/*WriteFCom*/ 1928)          1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #89
  {DBGFIELD(/*WriteCRC32Ld_ReadAfterLd*/ 1938) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #90
  {DBGFIELD(/*WriteCRC32*/ 1963)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #91
  {DBGFIELD(/*WriteCvtI2PDLd*/ 1974)     4, false, false, false, 2641, 3,  7, 1,  0, 0}, // #92
  {DBGFIELD(/*WriteCvtI2PD*/ 1989)       3, false, false, false, 2623, 3,  4, 1,  0, 0}, // #93
  {DBGFIELD(/*WriteCvtI2PSLd*/ 2002)     4, false, false, false, 2641, 3,  4, 1,  0, 0}, // #94
  {DBGFIELD(/*WriteCvtI2PS*/ 2017)       3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #95
  {DBGFIELD(/*WriteCvtPD2ILd*/ 2030)     5, false, false, false, 2644, 3,  7, 1,  0, 0}, // #96
  {DBGFIELD(/*WriteCvtPD2I*/ 2045)       4, false, false, false, 2641, 3,  4, 1,  0, 0}, // #97
  {DBGFIELD(/*WriteCvtPD2PSLd*/ 2058)    5, false, false, false, 2647, 3,  2, 1,  0, 0}, // #98
  {DBGFIELD(/*WriteCvtPD2PS*/ 2074)      4, false, false, false, 2650, 3,  8, 1,  0, 0}, // #99
  {DBGFIELD(/*WriteCvtPS2ILd*/ 2088)     4, false, false, false, 2641, 3,  4, 1,  0, 0}, // #100
  {DBGFIELD(/*WriteCvtPS2I*/ 2103)       3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #101
  {DBGFIELD(/*WriteCvtPS2PDLd*/ 2116)    5, false, false, false, 2641, 3,  7, 1,  0, 0}, // #102
  {DBGFIELD(/*WriteCvtPS2PD*/ 2132)      4, false, false, false, 2623, 3,  4, 1,  0, 0}, // #103
  {DBGFIELD(/*WriteCvtSD2ILd*/ 2146)     4, false, false, false, 2633, 3, 22, 1,  0, 0}, // #104
  {DBGFIELD(/*WriteCvtSD2I_ReadDefault*/ 2161) 3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #105
  {DBGFIELD(/*WriteCvtSD2I*/ 2186)       3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #106
  {DBGFIELD(/*WriteCvtSD2SSLd_ReadAfterVecLd*/ 2199) 4, false, false, false, 2647, 3,  8, 1, 14, 1}, // #107
  {DBGFIELD(/*WriteCvtSD2SS*/ 2230)      3, false, false, false, 2633, 3,  9, 1,  0, 0}, // #108
  {DBGFIELD(/*WriteCvtI2SDLd*/ 2244)     3, false, false, false, 2641, 3,  4, 1,  0, 0}, // #109
  {DBGFIELD(/*WriteCvtI2SDLd_ReadAfterVecLd*/ 2259) 3, false, false, false, 2641, 3,  4, 1, 14, 1}, // #110
  {DBGFIELD(/*WriteCvtI2SD_ReadInt2Fpu*/ 2289) 3, false, false, false, 2623, 3,  3, 1,  0, 1}, // #111
  {DBGFIELD(/*WriteCvtI2SD_ReadDefault_ReadInt2Fpu*/ 2314) 3, false, false, false, 2623, 3,  3, 1,  7, 1}, // #112
  {DBGFIELD(/*WriteCvtI2SSLd*/ 2351)     1, false, false, false, 2623, 3,  4, 1,  0, 0}, // #113
  {DBGFIELD(/*WriteCvtI2SSLd_ReadAfterVecLd*/ 2366) 1, false, false, false, 2623, 3,  4, 1, 14, 1}, // #114
  {DBGFIELD(/*WriteCvtI2SS_ReadInt2Fpu*/ 2396) 3, false, false, false, 2623, 3,  3, 1,  0, 1}, // #115
  {DBGFIELD(/*WriteCvtI2SS_ReadDefault_ReadInt2Fpu*/ 2421) 3, false, false, false, 2623, 3,  3, 1,  7, 1}, // #116
  {DBGFIELD(/*WriteCvtSS2SDLd_ReadAfterVecLd*/ 2458) 4, false, false, false, 2641, 3,  4, 1, 14, 1}, // #117
  {DBGFIELD(/*WriteCvtSS2SD*/ 2489)      3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #118
  {DBGFIELD(/*WriteCvtSS2ILd*/ 2503)     4, false, false, false, 2636, 3, 22, 1,  0, 0}, // #119
  {DBGFIELD(/*WriteCvtSS2I_ReadDefault*/ 2518) 3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #120
  {DBGFIELD(/*WriteCvtSS2I*/ 2543)       3, false, false, false, 2644, 3,  7, 1,  0, 0}, // #121
  {DBGFIELD(/*WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2556) 12, false, false, false, 2653, 3, 96, 1, 15, 2}, // #122
  {DBGFIELD(/*WriteDiv16*/ 2653)         12, false, false, false, 2653, 3, 96, 1,  0, 0}, // #123
  {DBGFIELD(/*WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2664) 12, false, false, false, 2653, 3, 96, 1, 15, 2}, // #124
  {DBGFIELD(/*WriteDiv32*/ 2761)         12, false, false, false, 2653, 3, 96, 1,  0, 0}, // #125
  {DBGFIELD(/*WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2772) 38, false, false, false, 2656, 3, 97, 1, 15, 2}, // #126
  {DBGFIELD(/*WriteDiv64*/ 2869)         38, false, false, false, 2656, 3, 97, 1,  0, 0}, // #127
  {DBGFIELD(/*WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 2880) 9, false, false, false, 2659, 3, 98, 1, 15, 2}, // #128
  {DBGFIELD(/*WriteDiv8*/ 2976)          9, false, false, false, 2653, 3, 96, 1,  0, 0}, // #129
  {DBGFIELD(/*WriteFDiv64XLd_ReadAfterVecXLd*/ 2986) 7, false, false, false, 2662, 3, 99, 1, 14, 1}, // #130
  {DBGFIELD(/*WriteFDiv64X*/ 3017)       6, false, false, false, 2662, 3, 99, 1,  0, 0}, // #131
  {DBGFIELD(/*WriteFDivXLd_ReadAfterVecXLd*/ 3030) 7, false, false, false, 2665, 3, 61, 1, 14, 1}, // #132
  {DBGFIELD(/*WriteFDivX*/ 3059)         6, false, false, false, 2665, 3, 61, 1,  0, 0}, // #133
  {DBGFIELD(/*WriteFDivLd*/ 3070)        4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #134
  {DBGFIELD(/*WriteFDiv*/ 3082)          3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #135
  {DBGFIELD(/*WriteFDiv64Ld_ReadAfterVecLd*/ 3092) 4, false, false, false, 2671, 3, 68, 1, 14, 1}, // #136
  {DBGFIELD(/*WriteFDiv64*/ 3121)        3, false, false, false, 2671, 3, 68, 1,  0, 0}, // #137
  {DBGFIELD(/*WriteFDivLd_ReadAfterVecLd*/ 3133) 4, false, false, false, 2668, 3, 100, 1, 14, 1}, // #138
  {DBGFIELD(/*WriteDPPDLd_ReadAfterVecXLd*/ 3160) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #139
  {DBGFIELD(/*WriteDPPD*/ 3188)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #140
  {DBGFIELD(/*WriteDPPSLd_ReadAfterVecXLd*/ 3198) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #141
  {DBGFIELD(/*WriteDPPS*/ 3226)          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #142
  {DBGFIELD(/*WriteStore*/ 3236)         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #143
  {DBGFIELD(/*WriteVecExtractSt*/ 3247)  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #144
  {DBGFIELD(/*WriteVecExtract*/ 3265)    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #145
  {DBGFIELD(/*WriteVecALUX*/ 3281)       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #146
  {DBGFIELD(/*WriteFComLd*/ 3294)        1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #147
  {DBGFIELD(/*WriteEMMS*/ 3306)          1, false, false, false, 349, 1, 10, 1,  0, 0}, // #148
  {DBGFIELD(/*WriteFLDC*/ 3316)          1, false, false, false, 2280, 1,  9, 1,  0, 0}, // #149
  {DBGFIELD(/*WriteVecIMulXLd_ReadAfterVecXLd*/ 3326) 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #150
  {DBGFIELD(/*WriteVecIMulX*/ 3358)      1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #151
  {DBGFIELD(/*WriteVecALUXLd_ReadAfterVecXLd*/ 3372) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #152
  {DBGFIELD(/*WriteFHAddLd_ReadAfterVecXLd*/ 3403) 6, false, false, false, 2636, 3, 22, 1, 14, 1}, // #153
  {DBGFIELD(/*WriteFHAdd*/ 3432)         5, false, false, false, 2644, 3,  7, 1,  0, 0}, // #154
  {DBGFIELD(/*WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3443) 29, false, false, false, 2671, 3, 68, 1, 15, 2}, // #155
  {DBGFIELD(/*WriteIDiv16*/ 3541)        29, false, false, false, 2671, 3, 68, 1,  0, 0}, // #156
  {DBGFIELD(/*WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3553) 29, false, false, false, 2671, 3, 68, 1, 15, 2}, // #157
  {DBGFIELD(/*WriteIDiv32*/ 3651)        29, false, false, false, 2671, 3, 68, 1,  0, 0}, // #158
  {DBGFIELD(/*WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3663) 60, false, false, false, 2656, 3, 97, 1, 15, 2}, // #159
  {DBGFIELD(/*WriteIDiv64*/ 3761)        60, false, false, false, 2656, 3, 97, 1,  0, 0}, // #160
  {DBGFIELD(/*WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3773) 26, false, false, false, 2671, 3, 68, 1, 15, 2}, // #161
  {DBGFIELD(/*WriteIDiv8*/ 3870)         26, false, false, false, 2671, 3, 68, 1,  0, 0}, // #162
  {DBGFIELD(/*WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 3881) 5, false, false, false, 2644, 3,  7, 1, 15, 2}, // #163
  {DBGFIELD(/*WriteIMul16*/ 3979)        4, false, false, false, 2641, 3,  4, 1,  0, 0}, // #164
  {DBGFIELD(/*WriteIMul16RegLd_ReadAfterLd*/ 3991) 3, false, false, false, 2641, 3,  4, 1, 14, 1}, // #165
  {DBGFIELD(/*WriteIMul16ImmLd*/ 4020)   3, false, false, false, 2641, 3,  4, 1,  0, 0}, // #166
  {DBGFIELD(/*WriteIMul16Reg*/ 4037)     2, false, false, false, 2623, 3,  3, 1,  0, 0}, // #167
  {DBGFIELD(/*WriteIMul16Imm*/ 4052)     2, false, false, false, 2623, 3,  3, 1,  0, 0}, // #168
  {DBGFIELD(/*WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4067) 4, false, false, false, 2641, 3,  4, 1, 15, 2}, // #169
  {DBGFIELD(/*WriteIMul32*/ 4165)        3, false, false, false, 2623, 3,  3, 1,  0, 0}, // #170
  {DBGFIELD(/*WriteIMul32RegLd_ReadAfterLd*/ 4177) 1, false, false, false, 2639, 2, 10, 1, 14, 1}, // #171
  {DBGFIELD(/*WriteIMul32ImmLd*/ 4206)   1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #172
  {DBGFIELD(/*WriteIMul32Reg*/ 4223)     1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #173
  {DBGFIELD(/*WriteIMul32Imm*/ 4238)     1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #174
  {DBGFIELD(/*WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4253) 8, false, false, false, 2647, 3,  2, 1, 15, 2}, // #175
  {DBGFIELD(/*WriteIMul64*/ 4351)        8, false, false, false, 2647, 3,  2, 1,  0, 0}, // #176
  {DBGFIELD(/*WriteIMul64RegLd_ReadAfterLd*/ 4363) 6, false, false, false, 2647, 3,  2, 1, 14, 1}, // #177
  {DBGFIELD(/*WriteIMul64ImmLd*/ 4392)   7, false, false, false, 2676, 3, 21, 1,  0, 0}, // #178
  {DBGFIELD(/*WriteIMul64Reg*/ 4409)     6, false, false, false, 2647, 3,  2, 1,  0, 0}, // #179
  {DBGFIELD(/*WriteIMul64Imm*/ 4424)     7, false, false, false, 2676, 3, 21, 1,  0, 0}, // #180
  {DBGFIELD(/*WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd*/ 4439) 3, false, false, false, 2641, 3,  4, 1, 15, 2}, // #181
  {DBGFIELD(/*WriteIMul8*/ 4536)         3, false, false, false, 2641, 3,  4, 1,  0, 0}, // #182
  {DBGFIELD(/*WriteFShuffleLd_ReadAfterVecXLd*/ 4547) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #183
  {DBGFIELD(/*WriteFShuffle*/ 4579)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD(/*WriteVecLogicX*/ 4593)     1, false, false, false,  5, 1,  1, 1,  0, 0}, // #185
  {DBGFIELD(/*WriteShuffle*/ 4608)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD(/*WriteLAHFSAHF*/ 4621)      1, false, false, false, 114, 1, 12, 1,  0, 0}, // #187
  {DBGFIELD(/*WriteVecLoadX*/ 4635)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #188
  {DBGFIELD(/*WriteLDMXCSR*/ 4649)       4, false, false, false, 2626, 3, 10, 1,  0, 0}, // #189
  {DBGFIELD(/*WriteFLD0*/ 4662)          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #190
  {DBGFIELD(/*WriteFLD1*/ 4672)          1, false, false, false, 630, 1,  3, 1,  0, 0}, // #191
  {DBGFIELD(/*WriteFence*/ 4682)         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #192
  {DBGFIELD(/*WriteLZCNTLd*/ 4693)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #193
  {DBGFIELD(/*WriteLZCNT*/ 4706)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #194
  {DBGFIELD(/*WriteVecStoreX*/ 4717)     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #195
  {DBGFIELD(/*WriteVecStore*/ 4732)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD(/*WriteVecMoveToGpr*/ 4746)  1, false, false, false, 2679, 2,  6, 1,  0, 0}, // #197
  {DBGFIELD(/*WriteVecLoad*/ 4764)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #198
  {DBGFIELD(/*WriteVecMoveFromGpr*/ 4777) 1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #199
  {DBGFIELD(/*WriteVecMoveX*/ 4797)      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #200
  {DBGFIELD(/*WriteVecStoreNT*/ 4811)    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #201
  {DBGFIELD(/*WriteVecMove*/ 4827)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #202
  {DBGFIELD(/*WriteVecALULd*/ 4840)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #203
  {DBGFIELD(/*WriteShuffleLd_ReadAfterVecLd*/ 4854) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #204
  {DBGFIELD(/*WriteVecALULd_ReadAfterVecLd*/ 4884) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #205
  {DBGFIELD(/*WriteVecLogicLd_ReadAfterVecLd*/ 4913) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #206
  {DBGFIELD(/*WriteVecLogic*/ 4944)      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #207
  {DBGFIELD(/*WritePHAddLd_ReadAfterVecLd*/ 4958) 4, false, false, false, 2681, 3, 14, 1, 14, 1}, // #208
  {DBGFIELD(/*WritePHAdd*/ 4986)         3, false, false, false, 2684, 3,  6, 1,  0, 0}, // #209
  {DBGFIELD(/*WriteVecInsertLd_ReadAfterLd*/ 4997) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #210
  {DBGFIELD(/*WriteVecInsert_ReadDefault_ReadInt2Fpu*/ 5026) 1, false, false, false, 2621, 2,  1, 1,  7, 1}, // #211
  {DBGFIELD(/*WriteVecIMulLd_ReadAfterVecLd*/ 5065) 1, false, false, false, 2621, 2, 14, 1, 14, 1}, // #212
  {DBGFIELD(/*WriteVecIMul*/ 5095)       1, false, false, false, 2621, 2, 14, 1,  0, 0}, // #213
  {DBGFIELD(/*WriteMMXMOVMSK*/ 5108)     1, false, false, false, 2679, 2,  6, 1,  0, 0}, // #214
  {DBGFIELD(/*WritePSADBWLd_ReadAfterVecLd*/ 5123) 1, false, false, false, 2621, 2, 14, 1, 14, 1}, // #215
  {DBGFIELD(/*WritePSADBW*/ 5152)        1, false, false, false, 2621, 2, 14, 1,  0, 0}, // #216
  {DBGFIELD(/*WriteVarShuffleLd_ReadAfterVecLd*/ 5164) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #217
  {DBGFIELD(/*WriteVarShuffle*/ 5197)    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD(/*WriteShuffleLd*/ 5213)     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #219
  {DBGFIELD(/*WriteVecShiftImm*/ 5228)   1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #220
  {DBGFIELD(/*WriteVecShiftLd_ReadAfterVecLd*/ 5245) 3, false, false, false, 2687, 3,  6, 1, 14, 1}, // #221
  {DBGFIELD(/*WriteVecShift*/ 5276)      2, false, false, false, 381, 3, 12, 1,  0, 0}, // #222
  {DBGFIELD(/*WriteFMoveX*/ 5290)        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #223
  {DBGFIELD(/*WriteFShuffleLd*/ 5302)    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #224
  {DBGFIELD(/*WriteFMOVMSK*/ 5318)       1, false, false, false, 2679, 2,  6, 1,  0, 0}, // #225
  {DBGFIELD(/*WriteVecLoadNT*/ 5331)     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #226
  {DBGFIELD(/*WriteStoreNT*/ 5346)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #227
  {DBGFIELD(/*WriteFStoreNTX*/ 5359)     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #228
  {DBGFIELD(/*WriteFStoreNT*/ 5374)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #229
  {DBGFIELD(/*WriteMPSADLd_ReadAfterVecXLd*/ 5388) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD(/*WriteMPSAD*/ 5417)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD(/*WriteFMul64XLd_ReadAfterVecXLd*/ 5428) 7, false, false, false, 2633, 3,  9, 1, 14, 1}, // #232
  {DBGFIELD(/*WriteFMul64X*/ 5459)       6, false, false, false, 2636, 3, 22, 1,  0, 0}, // #233
  {DBGFIELD(/*WriteFMulXLd_ReadAfterVecXLd*/ 5472) 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #234
  {DBGFIELD(/*WriteFMulX*/ 5501)         1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #235
  {DBGFIELD(/*WriteFMul64Ld_ReadAfterVecLd*/ 5512) 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #236
  {DBGFIELD(/*WriteFMul64*/ 5541)        1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #237
  {DBGFIELD(/*WriteFMulLd_ReadAfterVecLd*/ 5553) 1, false, false, false, 2674, 2, 14, 1, 14, 1}, // #238
  {DBGFIELD(/*WriteFMul*/ 5580)          1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #239
  {DBGFIELD(/*WriteMULX32Ld*/ 5590)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD(/*WriteMULX32*/ 5604)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD(/*WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 5616) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD(/*WriteIMulH_WriteMULX32*/ 5715) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD(/*WriteMULX64Ld*/ 5738)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD(/*WriteMULX64*/ 5752)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD(/*WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 5764) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD(/*WriteIMulH_WriteMULX64*/ 5863) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #247
  {DBGFIELD(/*WriteFMulLd*/ 5886)        1, false, false, false, 2674, 2, 14, 1,  0, 0}, // #248
  {DBGFIELD(/*WriteVecALUXLd*/ 5898)     1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #249
  {DBGFIELD(/*WriteShuffleXLd_ReadAfterVecXLd*/ 5913) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #250
  {DBGFIELD(/*WriteShuffleX*/ 5945)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #251
  {DBGFIELD(/*WriteVecLogicXLd_ReadAfterVecXLd*/ 5959) 1, false, false, false, 2621, 2,  1, 1, 14, 1}, // #252
  {DBGFIELD(/*WriteVarBlendLd_ReadAfterVecXLd*/ 5992) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD(/*WriteVarBlend*/ 6024)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD(/*WriteBlendLd_ReadAfterVecXLd*/ 6038) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD(/*WriteBlend*/ 6067)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD(/*WriteCLMulLd_ReadAfterVecXLd*/ 6078) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD(/*WriteCLMul*/ 6107)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD(/*WritePCmpEStrILd_ReadAfterVecXLd*/ 6118) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD(/*WritePCmpEStrI*/ 6151)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD(/*WritePCmpEStrMLd_ReadAfterVecXLd*/ 6166) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD(/*WritePCmpEStrM*/ 6199)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD(/*WritePCmpIStrILd_ReadAfterVecXLd*/ 6214) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD(/*WritePCmpIStrI*/ 6247)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #264
  {DBGFIELD(/*WritePCmpIStrMLd_ReadAfterVecXLd*/ 6262) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD(/*WritePCmpIStrM*/ 6295)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD(/*WriteCvtPS2ILd_ReadAfterVecXLd*/ 6310) 4, false, false, false, 2641, 3,  4, 1, 14, 1}, // #267
  {DBGFIELD(/*WritePHAddXLd_ReadAfterVecXLd*/ 6341) 4, false, false, false, 2644, 3,  7, 1, 14, 1}, // #268
  {DBGFIELD(/*WritePHAddX*/ 6371)        3, false, false, false, 2641, 3,  4, 1,  0, 0}, // #269
  {DBGFIELD(/*WritePHMINPOSLd*/ 6383)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #270
  {DBGFIELD(/*WritePHMINPOS*/ 6399)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #271
  {DBGFIELD(/*WriteCvtI2PSLd_ReadAfterVecXLd*/ 6413) 4, false, false, false, 2641, 3,  4, 1, 14, 1}, // #272
  {DBGFIELD(/*WriteVecMOVMSK*/ 6444)     1, false, false, false, 2679, 2,  6, 1,  0, 0}, // #273
  {DBGFIELD(/*WriteShuffleXLd*/ 6459)    1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #274
  {DBGFIELD(/*WritePMULLDLd_ReadAfterVecXLd*/ 6475) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD(/*WritePMULLD*/ 6505)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD(/*WriteCopy*/ 6517)          2, false, false, false, 2674, 2, 12, 1,  0, 0}, // #277
  {DBGFIELD(/*WritePOPCNTLd*/ 6527)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #278
  {DBGFIELD(/*WritePOPCNT*/ 6541)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #279
  {DBGFIELD(/*WritePSADBWXLd_ReadAfterVecXLd*/ 6553) 1, false, false, false, 2674, 2, 10, 1, 14, 1}, // #280
  {DBGFIELD(/*WritePSADBWX*/ 6584)       1, false, false, false, 2674, 2, 10, 1,  0, 0}, // #281
  {DBGFIELD(/*WriteVarShuffleXLd_ReadAfterVecXLd*/ 6597) 5, false, false, false, 2681, 3, 10, 1, 14, 1}, // #282
  {DBGFIELD(/*WriteVarShuffleX*/ 6632)   4, false, false, false, 2684, 3, 14, 1,  0, 0}, // #283
  {DBGFIELD(/*WriteVecShiftImmX*/ 6649)  1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #284
  {DBGFIELD(/*WriteVecShiftXLd_ReadAfterVecXLd*/ 6667) 3, false, false, false, 2687, 3,  6, 1, 14, 1}, // #285
  {DBGFIELD(/*WriteVecShiftX*/ 6700)     2, false, false, false, 381, 3, 12, 1,  0, 0}, // #286
  {DBGFIELD(/*WriteVecTestLd_ReadAfterVecXLd*/ 6715) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #287
  {DBGFIELD(/*WriteVecTest*/ 6746)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #288
  {DBGFIELD(/*WriteRotateLd_WriteRMW*/ 6759) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #289
  {DBGFIELD(/*WriteRotateLd_WriteRotate*/ 6782) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #290
  {DBGFIELD(/*WriteRotateCLLd_WriteRMW*/ 6808) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #291
  {DBGFIELD(/*WriteRotateCLLd_WriteRotateCL*/ 6833) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #292
  {DBGFIELD(/*WriteRotate*/ 6863)        1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #293
  {DBGFIELD(/*WriteRotateCL*/ 6875)      1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #294
  {DBGFIELD(/*WriteFRcpXLd*/ 6889)       6, false, false, false, 2633, 3,  9, 1,  0, 0}, // #295
  {DBGFIELD(/*WriteFRcpX*/ 6902)         5, false, false, false, 2636, 3, 22, 1,  0, 0}, // #296
  {DBGFIELD(/*WriteFRcpLd*/ 6913)        1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #297
  {DBGFIELD(/*WriteFRcpLd_ReadAfterVecLd*/ 6925) 1, false, false, false, 2690, 2, 14, 1, 14, 1}, // #298
  {DBGFIELD(/*WriteFRcp*/ 6952)          1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #299
  {DBGFIELD(/*WriteShiftLd*/ 6962)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #300
  {DBGFIELD(/*WriteShift*/ 6975)         1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD(/*WriteFRndLd*/ 6986)        1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #302
  {DBGFIELD(/*WriteFRnd*/ 6998)          1, false, false, false, 2639, 2, 10, 1,  0, 0}, // #303
  {DBGFIELD(/*WriteFRndLd_ReadAfterVecXLd*/ 7008) 1, false, false, false, 2639, 2, 10, 1, 14, 1}, // #304
  {DBGFIELD(/*WriteFRsqrtXLd*/ 7036)     6, false, false, false, 2633, 3,  9, 1,  0, 0}, // #305
  {DBGFIELD(/*WriteFRsqrtX*/ 7051)       5, false, false, false, 2636, 3, 22, 1,  0, 0}, // #306
  {DBGFIELD(/*WriteFRsqrtLd*/ 7064)      1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #307
  {DBGFIELD(/*WriteFRsqrtLd_ReadAfterVecLd*/ 7078) 1, false, false, false, 2690, 2, 14, 1, 14, 1}, // #308
  {DBGFIELD(/*WriteFRsqrt*/ 7107)        1, false, false, false, 2690, 2, 14, 1,  0, 0}, // #309
  {DBGFIELD(/*WriteShiftLd_WriteRMW*/ 7119) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #310
  {DBGFIELD(/*WriteShiftLd_WriteShift*/ 7141) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #311
  {DBGFIELD(/*WriteShiftCLLd_WriteRMW*/ 7165) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #312
  {DBGFIELD(/*WriteShiftCLLd_WriteShiftCL*/ 7189) 2, false, false, false, 2674, 2, 101, 2,  0, 0}, // #313
  {DBGFIELD(/*WriteShiftCL*/ 7217)       1, false, false, false, 2621, 2,  1, 1,  0, 0}, // #314
  {DBGFIELD(/*WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd*/ 7230) 1, false, false, false, 2621, 2,  1, 1, 15, 1}, // #315
  {DBGFIELD(/*WriteSETCCStore*/ 7315)    1, false, false, false, 114, 1, 12, 1,  0, 0}, // #316
  {DBGFIELD(/*WriteSETCC*/ 7331)         1, false, false, false,  5, 1,  1, 1,  0, 0}, // #317
  {DBGFIELD(/*WriteSHDmrcl*/ 7342)       1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #318
  {DBGFIELD(/*WriteSHDmri*/ 7355)        1, false, false, false, 1461, 1, 14, 1,  0, 0}, // #319
  {DBGFIELD(/*WriteSHDrrcl*/ 7367)       1, false, false, false, 114, 1, 12, 1,  0, 0}, // #320
  {DBGFIELD(/*WriteFSqrt64XLd*/ 7380)    6, false, false, false, 2662, 3, 99, 1,  0, 0}, // #321
  {DBGFIELD(/*WriteFSqrt64X*/ 7396)      5, false, false, false, 2662, 3, 99, 1,  0, 0}, // #322
  {DBGFIELD(/*WriteFSqrtXLd*/ 7410)      6, false, false, false, 2665, 3, 61, 1,  0, 0}, // #323
  {DBGFIELD(/*WriteFSqrtX*/ 7424)        5, false, false, false, 2665, 3, 61, 1,  0, 0}, // #324
  {DBGFIELD(/*WriteFSqrt64Ld*/ 7436)     4, false, false, false, 2671, 3, 68, 1,  0, 0}, // #325
  {DBGFIELD(/*WriteFSqrt64Ld_ReadAfterVecLd*/ 7451) 4, false, false, false, 2671, 3, 68, 1, 14, 1}, // #326
  {DBGFIELD(/*WriteFSqrt64*/ 7481)       3, false, false, false, 2671, 3, 68, 1,  0, 0}, // #327
  {DBGFIELD(/*WriteFSqrtLd*/ 7494)       4, false, false, false, 2668, 3, 100, 1,  0, 0}, // #328
  {DBGFIELD(/*WriteFSqrtLd_ReadAfterVecLd*/ 7507) 4, false, false, false, 2668, 3, 100, 1, 14, 1}, // #329
  {DBGFIELD(/*WriteFSqrt*/ 7535)         3, false, false, false, 2668, 3, 100, 1,  0, 0}, // #330
  {DBGFIELD(/*WriteFSqrt80*/ 7546)       1, false, false, false, 2692, 2, 83, 1,  0, 0}, // #331
  {DBGFIELD(/*WriteSTMXCSR*/ 7559)       4, false, false, false, 2694, 3, 11, 1,  0, 0}, // #332
  {DBGFIELD(/*WriteTZCNTLd*/ 7572)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD(/*WriteTZCNT*/ 7585)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD(/*WriteFMAZLd*/ 7596)        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD(/*WriteFMALd*/ 7608)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD(/*WriteFAddYLd_ReadAfterVecYLd*/ 7619) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD(/*WriteFAddY*/ 7648)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD(/*WriteFAddZLd_ReadAfterVecYLd*/ 7659) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD(/*WriteFAddZ*/ 7688)         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD(/*WriteFAdd64YLd_ReadAfterVecYLd*/ 7699) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD(/*WriteFAdd64Y*/ 7730)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD(/*WriteFAdd64ZLd_ReadAfterVecYLd*/ 7743) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD(/*WriteFAdd64Z*/ 7774)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD(/*WriteShuffleYLd_ReadAfterVecYLd*/ 7787) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD(/*WriteShuffleY*/ 7819)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD(/*WriteShuffleZLd_ReadAfterVecYLd*/ 7833) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD(/*WriteShuffleZ*/ 7865)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD(/*WriteFLogicYLd_ReadAfterVecYLd*/ 7879) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD(/*WriteFLogicY*/ 7910)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD(/*WriteFLogicZLd_ReadAfterVecYLd*/ 7923) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD(/*WriteFLogicZ*/ 7954)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD(/*WriteCvtPH2PSY*/ 7967)     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD(/*WriteCvtPH2PS*/ 7982)      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD(/*WriteFVarBlendYLd_ReadAfterVecYLd*/ 7996) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD(/*WriteFVarBlendY*/ 8030)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD(/*WriteFVarBlendZLd_ReadAfterVecYLd*/ 8046) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD(/*WriteFVarBlendZ*/ 8080)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD(/*WriteFBlendYLd_ReadAfterVecYLd*/ 8096) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD(/*WriteFBlendY*/ 8127)       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD(/*WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd*/ 8140) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD(/*WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd*/ 8250) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD(/*WriteShuffle256Ld*/ 8359)  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD(/*WriteShuffle256*/ 8377)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD(/*WriteShuffleYLd*/ 8393)    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD(/*WriteFShuffle256*/ 8409)   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD(/*WriteFShuffle256Ld*/ 8426) 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #36