#ifdef GET_OPCODE_NAMES
OP_Activate,
#endif
#ifdef GET_INTERP
case OP_Activate: {
  if (!Activate(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Activate:
  Text.Op = PrintName("Activate");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitActivate(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitActivate(SourceInfo L) {
  return emitOp<>(OP_Activate, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitActivate(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Activate(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ActivateThisField,
#endif
#ifdef GET_INTERP
case OP_ActivateThisField: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ActivateThisField(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ActivateThisField:
  Text.Op = PrintName("ActivateThisField");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitActivateThisField( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitActivateThisField( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ActivateThisField, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitActivateThisField( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ActivateThisField(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_AddSint8,
OP_AddUint8,
OP_AddSint16,
OP_AddUint16,
OP_AddSint32,
OP_AddUint32,
OP_AddSint64,
OP_AddUint64,
OP_AddIntAP,
OP_AddIntAPS,
OP_AddBool,
OP_AddFixedPoint,
#endif
#ifdef GET_INTERP
case OP_AddSint8: {
  if (!Add<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_AddUint8: {
  if (!Add<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_AddSint16: {
  if (!Add<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_AddUint16: {
  if (!Add<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_AddSint32: {
  if (!Add<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_AddUint32: {
  if (!Add<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_AddSint64: {
  if (!Add<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_AddUint64: {
  if (!Add<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_AddIntAP: {
  if (!Add<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_AddIntAPS: {
  if (!Add<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_AddBool: {
  if (!Add<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_AddFixedPoint: {
  if (!Add<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_AddSint8:
  Text.Op = PrintName("AddSint8");
  break;
case OP_AddUint8:
  Text.Op = PrintName("AddUint8");
  break;
case OP_AddSint16:
  Text.Op = PrintName("AddSint16");
  break;
case OP_AddUint16:
  Text.Op = PrintName("AddUint16");
  break;
case OP_AddSint32:
  Text.Op = PrintName("AddSint32");
  break;
case OP_AddUint32:
  Text.Op = PrintName("AddUint32");
  break;
case OP_AddSint64:
  Text.Op = PrintName("AddSint64");
  break;
case OP_AddUint64:
  Text.Op = PrintName("AddUint64");
  break;
case OP_AddIntAP:
  Text.Op = PrintName("AddIntAP");
  break;
case OP_AddIntAPS:
  Text.Op = PrintName("AddIntAPS");
  break;
case OP_AddBool:
  Text.Op = PrintName("AddBool");
  break;
case OP_AddFixedPoint:
  Text.Op = PrintName("AddFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAddSint8(SourceInfo);
bool emitAddUint8(SourceInfo);
bool emitAddSint16(SourceInfo);
bool emitAddUint16(SourceInfo);
bool emitAddSint32(SourceInfo);
bool emitAddUint32(SourceInfo);
bool emitAddSint64(SourceInfo);
bool emitAddUint64(SourceInfo);
bool emitAddIntAP(SourceInfo);
bool emitAddIntAPS(SourceInfo);
bool emitAddBool(SourceInfo);
bool emitAddFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitAdd(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitAdd(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitAddSint8(I);
  case PT_Uint8:
    return emitAddUint8(I);
  case PT_Sint16:
    return emitAddSint16(I);
  case PT_Uint16:
    return emitAddUint16(I);
  case PT_Sint32:
    return emitAddSint32(I);
  case PT_Uint32:
    return emitAddUint32(I);
  case PT_Sint64:
    return emitAddSint64(I);
  case PT_Uint64:
    return emitAddUint64(I);
  case PT_IntAP:
    return emitAddIntAP(I);
  case PT_IntAPS:
    return emitAddIntAPS(I);
  case PT_Bool:
    return emitAddBool(I);
  case PT_FixedPoint:
    return emitAddFixedPoint(I);
  default: llvm_unreachable("invalid type: emitAdd");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAddSint8(SourceInfo L) {
  return emitOp<>(OP_AddSint8, L);
}
bool ByteCodeEmitter::emitAddUint8(SourceInfo L) {
  return emitOp<>(OP_AddUint8, L);
}
bool ByteCodeEmitter::emitAddSint16(SourceInfo L) {
  return emitOp<>(OP_AddSint16, L);
}
bool ByteCodeEmitter::emitAddUint16(SourceInfo L) {
  return emitOp<>(OP_AddUint16, L);
}
bool ByteCodeEmitter::emitAddSint32(SourceInfo L) {
  return emitOp<>(OP_AddSint32, L);
}
bool ByteCodeEmitter::emitAddUint32(SourceInfo L) {
  return emitOp<>(OP_AddUint32, L);
}
bool ByteCodeEmitter::emitAddSint64(SourceInfo L) {
  return emitOp<>(OP_AddSint64, L);
}
bool ByteCodeEmitter::emitAddUint64(SourceInfo L) {
  return emitOp<>(OP_AddUint64, L);
}
bool ByteCodeEmitter::emitAddIntAP(SourceInfo L) {
  return emitOp<>(OP_AddIntAP, L);
}
bool ByteCodeEmitter::emitAddIntAPS(SourceInfo L) {
  return emitOp<>(OP_AddIntAPS, L);
}
bool ByteCodeEmitter::emitAddBool(SourceInfo L) {
  return emitOp<>(OP_AddBool, L);
}
bool ByteCodeEmitter::emitAddFixedPoint(SourceInfo L) {
  return emitOp<>(OP_AddFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAddSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitAddUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitAddSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitAddUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitAddSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitAddUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitAddSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitAddUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitAddIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitAddIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitAddBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitAddFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Add<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_AddOffsetSint8,
OP_AddOffsetUint8,
OP_AddOffsetSint16,
OP_AddOffsetUint16,
OP_AddOffsetSint32,
OP_AddOffsetUint32,
OP_AddOffsetSint64,
OP_AddOffsetUint64,
OP_AddOffsetIntAP,
OP_AddOffsetIntAPS,
OP_AddOffsetBool,
OP_AddOffsetFixedPoint,
#endif
#ifdef GET_INTERP
case OP_AddOffsetSint8: {
  if (!AddOffset<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetUint8: {
  if (!AddOffset<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetSint16: {
  if (!AddOffset<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetUint16: {
  if (!AddOffset<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetSint32: {
  if (!AddOffset<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetUint32: {
  if (!AddOffset<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetSint64: {
  if (!AddOffset<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetUint64: {
  if (!AddOffset<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetIntAP: {
  if (!AddOffset<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetIntAPS: {
  if (!AddOffset<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetBool: {
  if (!AddOffset<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_AddOffsetFixedPoint: {
  if (!AddOffset<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_AddOffsetSint8:
  Text.Op = PrintName("AddOffsetSint8");
  break;
case OP_AddOffsetUint8:
  Text.Op = PrintName("AddOffsetUint8");
  break;
case OP_AddOffsetSint16:
  Text.Op = PrintName("AddOffsetSint16");
  break;
case OP_AddOffsetUint16:
  Text.Op = PrintName("AddOffsetUint16");
  break;
case OP_AddOffsetSint32:
  Text.Op = PrintName("AddOffsetSint32");
  break;
case OP_AddOffsetUint32:
  Text.Op = PrintName("AddOffsetUint32");
  break;
case OP_AddOffsetSint64:
  Text.Op = PrintName("AddOffsetSint64");
  break;
case OP_AddOffsetUint64:
  Text.Op = PrintName("AddOffsetUint64");
  break;
case OP_AddOffsetIntAP:
  Text.Op = PrintName("AddOffsetIntAP");
  break;
case OP_AddOffsetIntAPS:
  Text.Op = PrintName("AddOffsetIntAPS");
  break;
case OP_AddOffsetBool:
  Text.Op = PrintName("AddOffsetBool");
  break;
case OP_AddOffsetFixedPoint:
  Text.Op = PrintName("AddOffsetFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAddOffsetSint8(SourceInfo);
bool emitAddOffsetUint8(SourceInfo);
bool emitAddOffsetSint16(SourceInfo);
bool emitAddOffsetUint16(SourceInfo);
bool emitAddOffsetSint32(SourceInfo);
bool emitAddOffsetUint32(SourceInfo);
bool emitAddOffsetSint64(SourceInfo);
bool emitAddOffsetUint64(SourceInfo);
bool emitAddOffsetIntAP(SourceInfo);
bool emitAddOffsetIntAPS(SourceInfo);
bool emitAddOffsetBool(SourceInfo);
bool emitAddOffsetFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitAddOffset(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitAddOffset(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitAddOffsetSint8(I);
  case PT_Uint8:
    return emitAddOffsetUint8(I);
  case PT_Sint16:
    return emitAddOffsetSint16(I);
  case PT_Uint16:
    return emitAddOffsetUint16(I);
  case PT_Sint32:
    return emitAddOffsetSint32(I);
  case PT_Uint32:
    return emitAddOffsetUint32(I);
  case PT_Sint64:
    return emitAddOffsetSint64(I);
  case PT_Uint64:
    return emitAddOffsetUint64(I);
  case PT_IntAP:
    return emitAddOffsetIntAP(I);
  case PT_IntAPS:
    return emitAddOffsetIntAPS(I);
  case PT_Bool:
    return emitAddOffsetBool(I);
  case PT_FixedPoint:
    return emitAddOffsetFixedPoint(I);
  default: llvm_unreachable("invalid type: emitAddOffset");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAddOffsetSint8(SourceInfo L) {
  return emitOp<>(OP_AddOffsetSint8, L);
}
bool ByteCodeEmitter::emitAddOffsetUint8(SourceInfo L) {
  return emitOp<>(OP_AddOffsetUint8, L);
}
bool ByteCodeEmitter::emitAddOffsetSint16(SourceInfo L) {
  return emitOp<>(OP_AddOffsetSint16, L);
}
bool ByteCodeEmitter::emitAddOffsetUint16(SourceInfo L) {
  return emitOp<>(OP_AddOffsetUint16, L);
}
bool ByteCodeEmitter::emitAddOffsetSint32(SourceInfo L) {
  return emitOp<>(OP_AddOffsetSint32, L);
}
bool ByteCodeEmitter::emitAddOffsetUint32(SourceInfo L) {
  return emitOp<>(OP_AddOffsetUint32, L);
}
bool ByteCodeEmitter::emitAddOffsetSint64(SourceInfo L) {
  return emitOp<>(OP_AddOffsetSint64, L);
}
bool ByteCodeEmitter::emitAddOffsetUint64(SourceInfo L) {
  return emitOp<>(OP_AddOffsetUint64, L);
}
bool ByteCodeEmitter::emitAddOffsetIntAP(SourceInfo L) {
  return emitOp<>(OP_AddOffsetIntAP, L);
}
bool ByteCodeEmitter::emitAddOffsetIntAPS(SourceInfo L) {
  return emitOp<>(OP_AddOffsetIntAPS, L);
}
bool ByteCodeEmitter::emitAddOffsetBool(SourceInfo L) {
  return emitOp<>(OP_AddOffsetBool, L);
}
bool ByteCodeEmitter::emitAddOffsetFixedPoint(SourceInfo L) {
  return emitOp<>(OP_AddOffsetFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAddOffsetSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitAddOffsetFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AddOffset<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Addf,
#endif
#ifdef GET_INTERP
case OP_Addf: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Addf(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Addf:
  Text.Op = PrintName("Addf");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAddf( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAddf( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Addf, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAddf( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Addf(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Alloc,
#endif
#ifdef GET_INTERP
case OP_Alloc: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!Alloc(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Alloc:
  Text.Op = PrintName("Alloc");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAlloc( const Descriptor * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAlloc( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_Alloc, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAlloc( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Alloc(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_AllocCNSint8,
OP_AllocCNUint8,
OP_AllocCNSint16,
OP_AllocCNUint16,
OP_AllocCNSint32,
OP_AllocCNUint32,
OP_AllocCNSint64,
OP_AllocCNUint64,
OP_AllocCNIntAP,
OP_AllocCNIntAPS,
#endif
#ifdef GET_INTERP
case OP_AllocCNSint8: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Sint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNUint8: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Uint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNSint16: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Sint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNUint16: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Uint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNSint32: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Sint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNUint32: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Uint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNSint64: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Sint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNUint64: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_Uint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNIntAP: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_IntAP>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_AllocCNIntAPS: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!AllocCN<PT_IntAPS>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_AllocCNSint8:
  Text.Op = PrintName("AllocCNSint8");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNUint8:
  Text.Op = PrintName("AllocCNUint8");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNSint16:
  Text.Op = PrintName("AllocCNSint16");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNUint16:
  Text.Op = PrintName("AllocCNUint16");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNSint32:
  Text.Op = PrintName("AllocCNSint32");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNUint32:
  Text.Op = PrintName("AllocCNUint32");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNSint64:
  Text.Op = PrintName("AllocCNSint64");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNUint64:
  Text.Op = PrintName("AllocCNUint64");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNIntAP:
  Text.Op = PrintName("AllocCNIntAP");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocCNIntAPS:
  Text.Op = PrintName("AllocCNIntAPS");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAllocCNSint8( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNUint8( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNSint16( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNUint16( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNSint32( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNUint32( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNSint64( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNUint64( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNIntAP( const Descriptor * ,  bool , SourceInfo);
bool emitAllocCNIntAPS( const Descriptor * ,  bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitAllocCN(PrimType, const Descriptor *, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitAllocCN(PrimType T0,  const Descriptor * A0,  bool A1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitAllocCNSint8(A0, A1, I);
  case PT_Uint8:
    return emitAllocCNUint8(A0, A1, I);
  case PT_Sint16:
    return emitAllocCNSint16(A0, A1, I);
  case PT_Uint16:
    return emitAllocCNUint16(A0, A1, I);
  case PT_Sint32:
    return emitAllocCNSint32(A0, A1, I);
  case PT_Uint32:
    return emitAllocCNUint32(A0, A1, I);
  case PT_Sint64:
    return emitAllocCNSint64(A0, A1, I);
  case PT_Uint64:
    return emitAllocCNUint64(A0, A1, I);
  case PT_IntAP:
    return emitAllocCNIntAP(A0, A1, I);
  case PT_IntAPS:
    return emitAllocCNIntAPS(A0, A1, I);
  default: llvm_unreachable("invalid type: emitAllocCN");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAllocCNSint8( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNSint8, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNUint8( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNUint8, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNSint16( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNSint16, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNUint16( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNUint16, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNSint32( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNSint32, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNUint32( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNUint32, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNSint64( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNSint64, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNUint64( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNUint64, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNIntAP( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNIntAP, A0, A1, L);
}
bool ByteCodeEmitter::emitAllocCNIntAPS( const Descriptor * A0,  bool A1, SourceInfo L) {
  return emitOp<const Descriptor *, bool>(OP_AllocCNIntAPS, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAllocCNSint8( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Sint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNUint8( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Uint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNSint16( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Sint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNUint16( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Uint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNSint32( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Sint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNUint32( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Uint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNSint64( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Sint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNUint64( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_Uint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNIntAP( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_IntAP>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitAllocCNIntAPS( const Descriptor * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocCN<PT_IntAPS>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_AllocNSint8,
OP_AllocNUint8,
OP_AllocNSint16,
OP_AllocNUint16,
OP_AllocNSint32,
OP_AllocNUint32,
OP_AllocNSint64,
OP_AllocNUint64,
OP_AllocNIntAP,
OP_AllocNIntAPS,
#endif
#ifdef GET_INTERP
case OP_AllocNSint8: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Sint8>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNUint8: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Uint8>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNSint16: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Sint16>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNUint16: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Uint16>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNSint32: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Sint32>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNUint32: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Uint32>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNSint64: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Sint64>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNUint64: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_Uint64>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNIntAP: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_IntAP>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_AllocNIntAPS: {
  const auto V0 = ReadArg<PrimType>(S, PC);
  const auto V1 = ReadArg<const Expr *>(S, PC);
  const auto V2 = ReadArg<bool>(S, PC);
  if (!AllocN<PT_IntAPS>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_AllocNSint8:
  Text.Op = PrintName("AllocNSint8");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNUint8:
  Text.Op = PrintName("AllocNUint8");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNSint16:
  Text.Op = PrintName("AllocNSint16");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNUint16:
  Text.Op = PrintName("AllocNUint16");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNSint32:
  Text.Op = PrintName("AllocNSint32");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNUint32:
  Text.Op = PrintName("AllocNUint32");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNSint64:
  Text.Op = PrintName("AllocNSint64");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNUint64:
  Text.Op = PrintName("AllocNUint64");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNIntAP:
  Text.Op = PrintName("AllocNIntAP");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_AllocNIntAPS:
  Text.Op = PrintName("AllocNIntAPS");
  Text.Args.push_back(printArg<PrimType>(P, PC));
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAllocNSint8( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNUint8( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNSint16( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNUint16( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNSint32( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNUint32( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNSint64( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNUint64( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNIntAP( PrimType ,  const Expr * ,  bool , SourceInfo);
bool emitAllocNIntAPS( PrimType ,  const Expr * ,  bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitAllocN(PrimType, PrimType, const Expr *, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitAllocN(PrimType T0,  PrimType A0,  const Expr * A1,  bool A2, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitAllocNSint8(A0, A1, A2, I);
  case PT_Uint8:
    return emitAllocNUint8(A0, A1, A2, I);
  case PT_Sint16:
    return emitAllocNSint16(A0, A1, A2, I);
  case PT_Uint16:
    return emitAllocNUint16(A0, A1, A2, I);
  case PT_Sint32:
    return emitAllocNSint32(A0, A1, A2, I);
  case PT_Uint32:
    return emitAllocNUint32(A0, A1, A2, I);
  case PT_Sint64:
    return emitAllocNSint64(A0, A1, A2, I);
  case PT_Uint64:
    return emitAllocNUint64(A0, A1, A2, I);
  case PT_IntAP:
    return emitAllocNIntAP(A0, A1, A2, I);
  case PT_IntAPS:
    return emitAllocNIntAPS(A0, A1, A2, I);
  default: llvm_unreachable("invalid type: emitAllocN");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAllocNSint8( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNSint8, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNUint8( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNUint8, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNSint16( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNSint16, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNUint16( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNUint16, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNSint32( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNSint32, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNUint32( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNUint32, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNSint64( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNSint64, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNUint64( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNUint64, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNIntAP( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNIntAP, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitAllocNIntAPS( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  return emitOp<PrimType, const Expr *, bool>(OP_AllocNIntAPS, A0, A1, A2, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAllocNSint8( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Sint8>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNUint8( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Uint8>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNSint16( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Sint16>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNUint16( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Uint16>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNSint32( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Sint32>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNUint32( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Uint32>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNSint64( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Sint64>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNUint64( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_Uint64>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNIntAP( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_IntAP>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitAllocNIntAPS( PrimType A0,  const Expr * A1,  bool A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return AllocN<PT_IntAPS>(S, OpPC, A0, A1, A2);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ArrayDecay,
#endif
#ifdef GET_INTERP
case OP_ArrayDecay: {
  if (!ArrayDecay(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ArrayDecay:
  Text.Op = PrintName("ArrayDecay");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitArrayDecay(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitArrayDecay(SourceInfo L) {
  return emitOp<>(OP_ArrayDecay, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitArrayDecay(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayDecay(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ArrayElemSint8,
OP_ArrayElemUint8,
OP_ArrayElemSint16,
OP_ArrayElemUint16,
OP_ArrayElemSint32,
OP_ArrayElemUint32,
OP_ArrayElemSint64,
OP_ArrayElemUint64,
OP_ArrayElemIntAP,
OP_ArrayElemIntAPS,
OP_ArrayElemBool,
OP_ArrayElemFixedPoint,
OP_ArrayElemPtr,
OP_ArrayElemMemberPtr,
OP_ArrayElemFloat,
#endif
#ifdef GET_INTERP
case OP_ArrayElemSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElem<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ArrayElemSint8:
  Text.Op = PrintName("ArrayElemSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemUint8:
  Text.Op = PrintName("ArrayElemUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemSint16:
  Text.Op = PrintName("ArrayElemSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemUint16:
  Text.Op = PrintName("ArrayElemUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemSint32:
  Text.Op = PrintName("ArrayElemSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemUint32:
  Text.Op = PrintName("ArrayElemUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemSint64:
  Text.Op = PrintName("ArrayElemSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemUint64:
  Text.Op = PrintName("ArrayElemUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemIntAP:
  Text.Op = PrintName("ArrayElemIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemIntAPS:
  Text.Op = PrintName("ArrayElemIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemBool:
  Text.Op = PrintName("ArrayElemBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemFixedPoint:
  Text.Op = PrintName("ArrayElemFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPtr:
  Text.Op = PrintName("ArrayElemPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemMemberPtr:
  Text.Op = PrintName("ArrayElemMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemFloat:
  Text.Op = PrintName("ArrayElemFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitArrayElemSint8( uint32_t , SourceInfo);
bool emitArrayElemUint8( uint32_t , SourceInfo);
bool emitArrayElemSint16( uint32_t , SourceInfo);
bool emitArrayElemUint16( uint32_t , SourceInfo);
bool emitArrayElemSint32( uint32_t , SourceInfo);
bool emitArrayElemUint32( uint32_t , SourceInfo);
bool emitArrayElemSint64( uint32_t , SourceInfo);
bool emitArrayElemUint64( uint32_t , SourceInfo);
bool emitArrayElemIntAP( uint32_t , SourceInfo);
bool emitArrayElemIntAPS( uint32_t , SourceInfo);
bool emitArrayElemBool( uint32_t , SourceInfo);
bool emitArrayElemFixedPoint( uint32_t , SourceInfo);
bool emitArrayElemPtr( uint32_t , SourceInfo);
bool emitArrayElemMemberPtr( uint32_t , SourceInfo);
bool emitArrayElemFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitArrayElem(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitArrayElem(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitArrayElemSint8(A0, I);
  case PT_Uint8:
    return emitArrayElemUint8(A0, I);
  case PT_Sint16:
    return emitArrayElemSint16(A0, I);
  case PT_Uint16:
    return emitArrayElemUint16(A0, I);
  case PT_Sint32:
    return emitArrayElemSint32(A0, I);
  case PT_Uint32:
    return emitArrayElemUint32(A0, I);
  case PT_Sint64:
    return emitArrayElemSint64(A0, I);
  case PT_Uint64:
    return emitArrayElemUint64(A0, I);
  case PT_IntAP:
    return emitArrayElemIntAP(A0, I);
  case PT_IntAPS:
    return emitArrayElemIntAPS(A0, I);
  case PT_Bool:
    return emitArrayElemBool(A0, I);
  case PT_FixedPoint:
    return emitArrayElemFixedPoint(A0, I);
  case PT_Ptr:
    return emitArrayElemPtr(A0, I);
  case PT_MemberPtr:
    return emitArrayElemMemberPtr(A0, I);
  case PT_Float:
    return emitArrayElemFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitArrayElemSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemSint8, A0, L);
}
bool ByteCodeEmitter::emitArrayElemUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemUint8, A0, L);
}
bool ByteCodeEmitter::emitArrayElemSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemSint16, A0, L);
}
bool ByteCodeEmitter::emitArrayElemUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemUint16, A0, L);
}
bool ByteCodeEmitter::emitArrayElemSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemSint32, A0, L);
}
bool ByteCodeEmitter::emitArrayElemUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemUint32, A0, L);
}
bool ByteCodeEmitter::emitArrayElemSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemSint64, A0, L);
}
bool ByteCodeEmitter::emitArrayElemUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemUint64, A0, L);
}
bool ByteCodeEmitter::emitArrayElemIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemIntAP, A0, L);
}
bool ByteCodeEmitter::emitArrayElemIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemIntAPS, A0, L);
}
bool ByteCodeEmitter::emitArrayElemBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemBool, A0, L);
}
bool ByteCodeEmitter::emitArrayElemFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPtr, A0, L);
}
bool ByteCodeEmitter::emitArrayElemMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitArrayElemFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitArrayElemSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElem<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ArrayElemPopSint8,
OP_ArrayElemPopUint8,
OP_ArrayElemPopSint16,
OP_ArrayElemPopUint16,
OP_ArrayElemPopSint32,
OP_ArrayElemPopUint32,
OP_ArrayElemPopSint64,
OP_ArrayElemPopUint64,
OP_ArrayElemPopIntAP,
OP_ArrayElemPopIntAPS,
OP_ArrayElemPopBool,
OP_ArrayElemPopFixedPoint,
OP_ArrayElemPopPtr,
OP_ArrayElemPopMemberPtr,
OP_ArrayElemPopFloat,
#endif
#ifdef GET_INTERP
case OP_ArrayElemPopSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_ArrayElemPopFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!ArrayElemPop<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ArrayElemPopSint8:
  Text.Op = PrintName("ArrayElemPopSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopUint8:
  Text.Op = PrintName("ArrayElemPopUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopSint16:
  Text.Op = PrintName("ArrayElemPopSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopUint16:
  Text.Op = PrintName("ArrayElemPopUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopSint32:
  Text.Op = PrintName("ArrayElemPopSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopUint32:
  Text.Op = PrintName("ArrayElemPopUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopSint64:
  Text.Op = PrintName("ArrayElemPopSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopUint64:
  Text.Op = PrintName("ArrayElemPopUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopIntAP:
  Text.Op = PrintName("ArrayElemPopIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopIntAPS:
  Text.Op = PrintName("ArrayElemPopIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopBool:
  Text.Op = PrintName("ArrayElemPopBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopFixedPoint:
  Text.Op = PrintName("ArrayElemPopFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopPtr:
  Text.Op = PrintName("ArrayElemPopPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopMemberPtr:
  Text.Op = PrintName("ArrayElemPopMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_ArrayElemPopFloat:
  Text.Op = PrintName("ArrayElemPopFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitArrayElemPopSint8( uint32_t , SourceInfo);
bool emitArrayElemPopUint8( uint32_t , SourceInfo);
bool emitArrayElemPopSint16( uint32_t , SourceInfo);
bool emitArrayElemPopUint16( uint32_t , SourceInfo);
bool emitArrayElemPopSint32( uint32_t , SourceInfo);
bool emitArrayElemPopUint32( uint32_t , SourceInfo);
bool emitArrayElemPopSint64( uint32_t , SourceInfo);
bool emitArrayElemPopUint64( uint32_t , SourceInfo);
bool emitArrayElemPopIntAP( uint32_t , SourceInfo);
bool emitArrayElemPopIntAPS( uint32_t , SourceInfo);
bool emitArrayElemPopBool( uint32_t , SourceInfo);
bool emitArrayElemPopFixedPoint( uint32_t , SourceInfo);
bool emitArrayElemPopPtr( uint32_t , SourceInfo);
bool emitArrayElemPopMemberPtr( uint32_t , SourceInfo);
bool emitArrayElemPopFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitArrayElemPop(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitArrayElemPop(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitArrayElemPopSint8(A0, I);
  case PT_Uint8:
    return emitArrayElemPopUint8(A0, I);
  case PT_Sint16:
    return emitArrayElemPopSint16(A0, I);
  case PT_Uint16:
    return emitArrayElemPopUint16(A0, I);
  case PT_Sint32:
    return emitArrayElemPopSint32(A0, I);
  case PT_Uint32:
    return emitArrayElemPopUint32(A0, I);
  case PT_Sint64:
    return emitArrayElemPopSint64(A0, I);
  case PT_Uint64:
    return emitArrayElemPopUint64(A0, I);
  case PT_IntAP:
    return emitArrayElemPopIntAP(A0, I);
  case PT_IntAPS:
    return emitArrayElemPopIntAPS(A0, I);
  case PT_Bool:
    return emitArrayElemPopBool(A0, I);
  case PT_FixedPoint:
    return emitArrayElemPopFixedPoint(A0, I);
  case PT_Ptr:
    return emitArrayElemPopPtr(A0, I);
  case PT_MemberPtr:
    return emitArrayElemPopMemberPtr(A0, I);
  case PT_Float:
    return emitArrayElemPopFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitArrayElemPopSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopSint8, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopUint8, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopSint16, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopUint16, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopSint32, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopUint32, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopSint64, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopUint64, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopIntAP, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopIntAPS, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopBool, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopPtr, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitArrayElemPopFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ArrayElemPopFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitArrayElemPopSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitArrayElemPopFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPop<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ArrayElemPtrSint8,
OP_ArrayElemPtrUint8,
OP_ArrayElemPtrSint16,
OP_ArrayElemPtrUint16,
OP_ArrayElemPtrSint32,
OP_ArrayElemPtrUint32,
OP_ArrayElemPtrSint64,
OP_ArrayElemPtrUint64,
OP_ArrayElemPtrIntAP,
OP_ArrayElemPtrIntAPS,
OP_ArrayElemPtrBool,
OP_ArrayElemPtrFixedPoint,
#endif
#ifdef GET_INTERP
case OP_ArrayElemPtrSint8: {
  if (!ArrayElemPtr<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrUint8: {
  if (!ArrayElemPtr<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrSint16: {
  if (!ArrayElemPtr<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrUint16: {
  if (!ArrayElemPtr<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrSint32: {
  if (!ArrayElemPtr<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrUint32: {
  if (!ArrayElemPtr<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrSint64: {
  if (!ArrayElemPtr<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrUint64: {
  if (!ArrayElemPtr<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrIntAP: {
  if (!ArrayElemPtr<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrIntAPS: {
  if (!ArrayElemPtr<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrBool: {
  if (!ArrayElemPtr<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrFixedPoint: {
  if (!ArrayElemPtr<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ArrayElemPtrSint8:
  Text.Op = PrintName("ArrayElemPtrSint8");
  break;
case OP_ArrayElemPtrUint8:
  Text.Op = PrintName("ArrayElemPtrUint8");
  break;
case OP_ArrayElemPtrSint16:
  Text.Op = PrintName("ArrayElemPtrSint16");
  break;
case OP_ArrayElemPtrUint16:
  Text.Op = PrintName("ArrayElemPtrUint16");
  break;
case OP_ArrayElemPtrSint32:
  Text.Op = PrintName("ArrayElemPtrSint32");
  break;
case OP_ArrayElemPtrUint32:
  Text.Op = PrintName("ArrayElemPtrUint32");
  break;
case OP_ArrayElemPtrSint64:
  Text.Op = PrintName("ArrayElemPtrSint64");
  break;
case OP_ArrayElemPtrUint64:
  Text.Op = PrintName("ArrayElemPtrUint64");
  break;
case OP_ArrayElemPtrIntAP:
  Text.Op = PrintName("ArrayElemPtrIntAP");
  break;
case OP_ArrayElemPtrIntAPS:
  Text.Op = PrintName("ArrayElemPtrIntAPS");
  break;
case OP_ArrayElemPtrBool:
  Text.Op = PrintName("ArrayElemPtrBool");
  break;
case OP_ArrayElemPtrFixedPoint:
  Text.Op = PrintName("ArrayElemPtrFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitArrayElemPtrSint8(SourceInfo);
bool emitArrayElemPtrUint8(SourceInfo);
bool emitArrayElemPtrSint16(SourceInfo);
bool emitArrayElemPtrUint16(SourceInfo);
bool emitArrayElemPtrSint32(SourceInfo);
bool emitArrayElemPtrUint32(SourceInfo);
bool emitArrayElemPtrSint64(SourceInfo);
bool emitArrayElemPtrUint64(SourceInfo);
bool emitArrayElemPtrIntAP(SourceInfo);
bool emitArrayElemPtrIntAPS(SourceInfo);
bool emitArrayElemPtrBool(SourceInfo);
bool emitArrayElemPtrFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitArrayElemPtr(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitArrayElemPtr(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitArrayElemPtrSint8(I);
  case PT_Uint8:
    return emitArrayElemPtrUint8(I);
  case PT_Sint16:
    return emitArrayElemPtrSint16(I);
  case PT_Uint16:
    return emitArrayElemPtrUint16(I);
  case PT_Sint32:
    return emitArrayElemPtrSint32(I);
  case PT_Uint32:
    return emitArrayElemPtrUint32(I);
  case PT_Sint64:
    return emitArrayElemPtrSint64(I);
  case PT_Uint64:
    return emitArrayElemPtrUint64(I);
  case PT_IntAP:
    return emitArrayElemPtrIntAP(I);
  case PT_IntAPS:
    return emitArrayElemPtrIntAPS(I);
  case PT_Bool:
    return emitArrayElemPtrBool(I);
  case PT_FixedPoint:
    return emitArrayElemPtrFixedPoint(I);
  default: llvm_unreachable("invalid type: emitArrayElemPtr");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitArrayElemPtrSint8(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrSint8, L);
}
bool ByteCodeEmitter::emitArrayElemPtrUint8(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrUint8, L);
}
bool ByteCodeEmitter::emitArrayElemPtrSint16(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrSint16, L);
}
bool ByteCodeEmitter::emitArrayElemPtrUint16(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrUint16, L);
}
bool ByteCodeEmitter::emitArrayElemPtrSint32(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrSint32, L);
}
bool ByteCodeEmitter::emitArrayElemPtrUint32(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrUint32, L);
}
bool ByteCodeEmitter::emitArrayElemPtrSint64(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrSint64, L);
}
bool ByteCodeEmitter::emitArrayElemPtrUint64(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrUint64, L);
}
bool ByteCodeEmitter::emitArrayElemPtrIntAP(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrIntAP, L);
}
bool ByteCodeEmitter::emitArrayElemPtrIntAPS(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrIntAPS, L);
}
bool ByteCodeEmitter::emitArrayElemPtrBool(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrBool, L);
}
bool ByteCodeEmitter::emitArrayElemPtrFixedPoint(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitArrayElemPtrSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtr<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ArrayElemPtrPopSint8,
OP_ArrayElemPtrPopUint8,
OP_ArrayElemPtrPopSint16,
OP_ArrayElemPtrPopUint16,
OP_ArrayElemPtrPopSint32,
OP_ArrayElemPtrPopUint32,
OP_ArrayElemPtrPopSint64,
OP_ArrayElemPtrPopUint64,
OP_ArrayElemPtrPopIntAP,
OP_ArrayElemPtrPopIntAPS,
OP_ArrayElemPtrPopBool,
OP_ArrayElemPtrPopFixedPoint,
#endif
#ifdef GET_INTERP
case OP_ArrayElemPtrPopSint8: {
  if (!ArrayElemPtrPop<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopUint8: {
  if (!ArrayElemPtrPop<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopSint16: {
  if (!ArrayElemPtrPop<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopUint16: {
  if (!ArrayElemPtrPop<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopSint32: {
  if (!ArrayElemPtrPop<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopUint32: {
  if (!ArrayElemPtrPop<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopSint64: {
  if (!ArrayElemPtrPop<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopUint64: {
  if (!ArrayElemPtrPop<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopIntAP: {
  if (!ArrayElemPtrPop<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopIntAPS: {
  if (!ArrayElemPtrPop<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopBool: {
  if (!ArrayElemPtrPop<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_ArrayElemPtrPopFixedPoint: {
  if (!ArrayElemPtrPop<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ArrayElemPtrPopSint8:
  Text.Op = PrintName("ArrayElemPtrPopSint8");
  break;
case OP_ArrayElemPtrPopUint8:
  Text.Op = PrintName("ArrayElemPtrPopUint8");
  break;
case OP_ArrayElemPtrPopSint16:
  Text.Op = PrintName("ArrayElemPtrPopSint16");
  break;
case OP_ArrayElemPtrPopUint16:
  Text.Op = PrintName("ArrayElemPtrPopUint16");
  break;
case OP_ArrayElemPtrPopSint32:
  Text.Op = PrintName("ArrayElemPtrPopSint32");
  break;
case OP_ArrayElemPtrPopUint32:
  Text.Op = PrintName("ArrayElemPtrPopUint32");
  break;
case OP_ArrayElemPtrPopSint64:
  Text.Op = PrintName("ArrayElemPtrPopSint64");
  break;
case OP_ArrayElemPtrPopUint64:
  Text.Op = PrintName("ArrayElemPtrPopUint64");
  break;
case OP_ArrayElemPtrPopIntAP:
  Text.Op = PrintName("ArrayElemPtrPopIntAP");
  break;
case OP_ArrayElemPtrPopIntAPS:
  Text.Op = PrintName("ArrayElemPtrPopIntAPS");
  break;
case OP_ArrayElemPtrPopBool:
  Text.Op = PrintName("ArrayElemPtrPopBool");
  break;
case OP_ArrayElemPtrPopFixedPoint:
  Text.Op = PrintName("ArrayElemPtrPopFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitArrayElemPtrPopSint8(SourceInfo);
bool emitArrayElemPtrPopUint8(SourceInfo);
bool emitArrayElemPtrPopSint16(SourceInfo);
bool emitArrayElemPtrPopUint16(SourceInfo);
bool emitArrayElemPtrPopSint32(SourceInfo);
bool emitArrayElemPtrPopUint32(SourceInfo);
bool emitArrayElemPtrPopSint64(SourceInfo);
bool emitArrayElemPtrPopUint64(SourceInfo);
bool emitArrayElemPtrPopIntAP(SourceInfo);
bool emitArrayElemPtrPopIntAPS(SourceInfo);
bool emitArrayElemPtrPopBool(SourceInfo);
bool emitArrayElemPtrPopFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitArrayElemPtrPop(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitArrayElemPtrPop(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitArrayElemPtrPopSint8(I);
  case PT_Uint8:
    return emitArrayElemPtrPopUint8(I);
  case PT_Sint16:
    return emitArrayElemPtrPopSint16(I);
  case PT_Uint16:
    return emitArrayElemPtrPopUint16(I);
  case PT_Sint32:
    return emitArrayElemPtrPopSint32(I);
  case PT_Uint32:
    return emitArrayElemPtrPopUint32(I);
  case PT_Sint64:
    return emitArrayElemPtrPopSint64(I);
  case PT_Uint64:
    return emitArrayElemPtrPopUint64(I);
  case PT_IntAP:
    return emitArrayElemPtrPopIntAP(I);
  case PT_IntAPS:
    return emitArrayElemPtrPopIntAPS(I);
  case PT_Bool:
    return emitArrayElemPtrPopBool(I);
  case PT_FixedPoint:
    return emitArrayElemPtrPopFixedPoint(I);
  default: llvm_unreachable("invalid type: emitArrayElemPtrPop");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitArrayElemPtrPopSint8(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopSint8, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopUint8(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopUint8, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopSint16(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopSint16, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopUint16(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopUint16, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopSint32(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopSint32, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopUint32(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopUint32, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopSint64(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopSint64, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopUint64(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopUint64, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopIntAP(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopIntAP, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopIntAPS(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopIntAPS, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopBool(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopBool, L);
}
bool ByteCodeEmitter::emitArrayElemPtrPopFixedPoint(SourceInfo L) {
  return emitOp<>(OP_ArrayElemPtrPopFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitArrayElemPtrPopSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitArrayElemPtrPopFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ArrayElemPtrPop<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Assume,
#endif
#ifdef GET_INTERP
case OP_Assume: {
  if (!Assume(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Assume:
  Text.Op = PrintName("Assume");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitAssume(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitAssume(SourceInfo L) {
  return emitOp<>(OP_Assume, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitAssume(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Assume(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BCP,
#endif
#ifdef GET_INTERP
case OP_BCP: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  const auto V1 = ReadArg<PrimType>(S, PC);
  if (!BCP(S, PC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BCP:
  Text.Op = PrintName("BCP");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  Text.Args.push_back(printArg<PrimType>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBCP( int32_t ,  PrimType , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBCP( int32_t A0,  PrimType A1, SourceInfo L) {
  return emitOp<int32_t, PrimType>(OP_BCP, A0, A1, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BitAndSint8,
OP_BitAndUint8,
OP_BitAndSint16,
OP_BitAndUint16,
OP_BitAndSint32,
OP_BitAndUint32,
OP_BitAndSint64,
OP_BitAndUint64,
OP_BitAndIntAP,
OP_BitAndIntAPS,
OP_BitAndFixedPoint,
#endif
#ifdef GET_INTERP
case OP_BitAndSint8: {
  if (!BitAnd<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndUint8: {
  if (!BitAnd<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndSint16: {
  if (!BitAnd<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndUint16: {
  if (!BitAnd<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndSint32: {
  if (!BitAnd<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndUint32: {
  if (!BitAnd<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndSint64: {
  if (!BitAnd<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndUint64: {
  if (!BitAnd<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndIntAP: {
  if (!BitAnd<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndIntAPS: {
  if (!BitAnd<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_BitAndFixedPoint: {
  if (!BitAnd<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BitAndSint8:
  Text.Op = PrintName("BitAndSint8");
  break;
case OP_BitAndUint8:
  Text.Op = PrintName("BitAndUint8");
  break;
case OP_BitAndSint16:
  Text.Op = PrintName("BitAndSint16");
  break;
case OP_BitAndUint16:
  Text.Op = PrintName("BitAndUint16");
  break;
case OP_BitAndSint32:
  Text.Op = PrintName("BitAndSint32");
  break;
case OP_BitAndUint32:
  Text.Op = PrintName("BitAndUint32");
  break;
case OP_BitAndSint64:
  Text.Op = PrintName("BitAndSint64");
  break;
case OP_BitAndUint64:
  Text.Op = PrintName("BitAndUint64");
  break;
case OP_BitAndIntAP:
  Text.Op = PrintName("BitAndIntAP");
  break;
case OP_BitAndIntAPS:
  Text.Op = PrintName("BitAndIntAPS");
  break;
case OP_BitAndFixedPoint:
  Text.Op = PrintName("BitAndFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBitAndSint8(SourceInfo);
bool emitBitAndUint8(SourceInfo);
bool emitBitAndSint16(SourceInfo);
bool emitBitAndUint16(SourceInfo);
bool emitBitAndSint32(SourceInfo);
bool emitBitAndUint32(SourceInfo);
bool emitBitAndSint64(SourceInfo);
bool emitBitAndUint64(SourceInfo);
bool emitBitAndIntAP(SourceInfo);
bool emitBitAndIntAPS(SourceInfo);
bool emitBitAndFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitBitAnd(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitBitAnd(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitBitAndSint8(I);
  case PT_Uint8:
    return emitBitAndUint8(I);
  case PT_Sint16:
    return emitBitAndSint16(I);
  case PT_Uint16:
    return emitBitAndUint16(I);
  case PT_Sint32:
    return emitBitAndSint32(I);
  case PT_Uint32:
    return emitBitAndUint32(I);
  case PT_Sint64:
    return emitBitAndSint64(I);
  case PT_Uint64:
    return emitBitAndUint64(I);
  case PT_IntAP:
    return emitBitAndIntAP(I);
  case PT_IntAPS:
    return emitBitAndIntAPS(I);
  case PT_FixedPoint:
    return emitBitAndFixedPoint(I);
  default: llvm_unreachable("invalid type: emitBitAnd");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBitAndSint8(SourceInfo L) {
  return emitOp<>(OP_BitAndSint8, L);
}
bool ByteCodeEmitter::emitBitAndUint8(SourceInfo L) {
  return emitOp<>(OP_BitAndUint8, L);
}
bool ByteCodeEmitter::emitBitAndSint16(SourceInfo L) {
  return emitOp<>(OP_BitAndSint16, L);
}
bool ByteCodeEmitter::emitBitAndUint16(SourceInfo L) {
  return emitOp<>(OP_BitAndUint16, L);
}
bool ByteCodeEmitter::emitBitAndSint32(SourceInfo L) {
  return emitOp<>(OP_BitAndSint32, L);
}
bool ByteCodeEmitter::emitBitAndUint32(SourceInfo L) {
  return emitOp<>(OP_BitAndUint32, L);
}
bool ByteCodeEmitter::emitBitAndSint64(SourceInfo L) {
  return emitOp<>(OP_BitAndSint64, L);
}
bool ByteCodeEmitter::emitBitAndUint64(SourceInfo L) {
  return emitOp<>(OP_BitAndUint64, L);
}
bool ByteCodeEmitter::emitBitAndIntAP(SourceInfo L) {
  return emitOp<>(OP_BitAndIntAP, L);
}
bool ByteCodeEmitter::emitBitAndIntAPS(SourceInfo L) {
  return emitOp<>(OP_BitAndIntAPS, L);
}
bool ByteCodeEmitter::emitBitAndFixedPoint(SourceInfo L) {
  return emitOp<>(OP_BitAndFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitBitAndSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitBitAndUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitBitAndSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitBitAndUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitBitAndSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitBitAndUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitBitAndSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitBitAndUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitBitAndIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitBitAndIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitBitAndFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitAnd<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BitCast,
#endif
#ifdef GET_INTERP
case OP_BitCast: {
  if (!BitCast(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BitCast:
  Text.Op = PrintName("BitCast");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBitCast(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBitCast(SourceInfo L) {
  return emitOp<>(OP_BitCast, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitBitCast(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCast(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BitCastPrimUint8,
OP_BitCastPrimSint8,
OP_BitCastPrimUint16,
OP_BitCastPrimSint16,
OP_BitCastPrimUint32,
OP_BitCastPrimSint32,
OP_BitCastPrimUint64,
OP_BitCastPrimSint64,
OP_BitCastPrimIntAP,
OP_BitCastPrimIntAPS,
OP_BitCastPrimBool,
OP_BitCastPrimFloat,
OP_BitCastPrimPtr,
OP_BitCastPrimMemberPtr,
#endif
#ifdef GET_INTERP
case OP_BitCastPrimUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Uint8>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Sint8>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Uint16>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Sint16>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Uint32>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Sint32>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Uint64>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Sint64>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_IntAP>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_IntAPS>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Bool>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimFloat: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Float>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimPtr: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_Ptr>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
case OP_BitCastPrimMemberPtr: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V3 = ReadArg<const Type *>(S, PC);
  if (!BitCastPrim<PT_MemberPtr>(S, OpPC, V0, V1, V2, V3))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BitCastPrimUint8:
  Text.Op = PrintName("BitCastPrimUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimSint8:
  Text.Op = PrintName("BitCastPrimSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimUint16:
  Text.Op = PrintName("BitCastPrimUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimSint16:
  Text.Op = PrintName("BitCastPrimSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimUint32:
  Text.Op = PrintName("BitCastPrimUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimSint32:
  Text.Op = PrintName("BitCastPrimSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimUint64:
  Text.Op = PrintName("BitCastPrimUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimSint64:
  Text.Op = PrintName("BitCastPrimSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimIntAP:
  Text.Op = PrintName("BitCastPrimIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimIntAPS:
  Text.Op = PrintName("BitCastPrimIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimBool:
  Text.Op = PrintName("BitCastPrimBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimFloat:
  Text.Op = PrintName("BitCastPrimFloat");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimPtr:
  Text.Op = PrintName("BitCastPrimPtr");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
case OP_BitCastPrimMemberPtr:
  Text.Op = PrintName("BitCastPrimMemberPtr");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBitCastPrimUint8( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimSint8( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimUint16( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimSint16( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimUint32( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimSint32( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimUint64( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimSint64( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimIntAP( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimIntAPS( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimBool( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimFloat( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimPtr( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
bool emitBitCastPrimMemberPtr( bool ,  uint32_t ,  const llvm::fltSemantics * ,  const Type * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitBitCastPrim(PrimType, bool, uint32_t, const llvm::fltSemantics *, const Type *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitBitCastPrim(PrimType T0,  bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo I) {
  switch (T0) {
  case PT_Uint8:
    return emitBitCastPrimUint8(A0, A1, A2, A3, I);
  case PT_Sint8:
    return emitBitCastPrimSint8(A0, A1, A2, A3, I);
  case PT_Uint16:
    return emitBitCastPrimUint16(A0, A1, A2, A3, I);
  case PT_Sint16:
    return emitBitCastPrimSint16(A0, A1, A2, A3, I);
  case PT_Uint32:
    return emitBitCastPrimUint32(A0, A1, A2, A3, I);
  case PT_Sint32:
    return emitBitCastPrimSint32(A0, A1, A2, A3, I);
  case PT_Uint64:
    return emitBitCastPrimUint64(A0, A1, A2, A3, I);
  case PT_Sint64:
    return emitBitCastPrimSint64(A0, A1, A2, A3, I);
  case PT_IntAP:
    return emitBitCastPrimIntAP(A0, A1, A2, A3, I);
  case PT_IntAPS:
    return emitBitCastPrimIntAPS(A0, A1, A2, A3, I);
  case PT_Bool:
    return emitBitCastPrimBool(A0, A1, A2, A3, I);
  case PT_Float:
    return emitBitCastPrimFloat(A0, A1, A2, A3, I);
  case PT_Ptr:
    return emitBitCastPrimPtr(A0, A1, A2, A3, I);
  case PT_MemberPtr:
    return emitBitCastPrimMemberPtr(A0, A1, A2, A3, I);
  default: llvm_unreachable("invalid type: emitBitCastPrim");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBitCastPrimUint8( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimUint8, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimSint8( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimSint8, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimUint16( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimUint16, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimSint16( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimSint16, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimUint32( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimUint32, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimSint32( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimSint32, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimUint64( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimUint64, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimSint64( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimSint64, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimIntAP( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimIntAP, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimIntAPS( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimIntAPS, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimBool( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimBool, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimFloat( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimFloat, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimPtr( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimPtr, A0, A1, A2, A3, L);
}
bool ByteCodeEmitter::emitBitCastPrimMemberPtr( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  return emitOp<bool, uint32_t, const llvm::fltSemantics *, const Type *>(OP_BitCastPrimMemberPtr, A0, A1, A2, A3, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitBitCastPrimUint8( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Uint8>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimSint8( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Sint8>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimUint16( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Uint16>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimSint16( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Sint16>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimUint32( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Uint32>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimSint32( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Sint32>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimUint64( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Uint64>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimSint64( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Sint64>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimIntAP( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_IntAP>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimIntAPS( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_IntAPS>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimBool( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Bool>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimFloat( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Float>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimPtr( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_Ptr>(S, OpPC, A0, A1, A2, A3);
}
bool EvalEmitter::emitBitCastPrimMemberPtr( bool A0,  uint32_t A1,  const llvm::fltSemantics * A2,  const Type * A3, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitCastPrim<PT_MemberPtr>(S, OpPC, A0, A1, A2, A3);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BitOrSint8,
OP_BitOrUint8,
OP_BitOrSint16,
OP_BitOrUint16,
OP_BitOrSint32,
OP_BitOrUint32,
OP_BitOrSint64,
OP_BitOrUint64,
OP_BitOrIntAP,
OP_BitOrIntAPS,
OP_BitOrFixedPoint,
#endif
#ifdef GET_INTERP
case OP_BitOrSint8: {
  if (!BitOr<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrUint8: {
  if (!BitOr<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrSint16: {
  if (!BitOr<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrUint16: {
  if (!BitOr<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrSint32: {
  if (!BitOr<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrUint32: {
  if (!BitOr<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrSint64: {
  if (!BitOr<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrUint64: {
  if (!BitOr<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrIntAP: {
  if (!BitOr<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrIntAPS: {
  if (!BitOr<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_BitOrFixedPoint: {
  if (!BitOr<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BitOrSint8:
  Text.Op = PrintName("BitOrSint8");
  break;
case OP_BitOrUint8:
  Text.Op = PrintName("BitOrUint8");
  break;
case OP_BitOrSint16:
  Text.Op = PrintName("BitOrSint16");
  break;
case OP_BitOrUint16:
  Text.Op = PrintName("BitOrUint16");
  break;
case OP_BitOrSint32:
  Text.Op = PrintName("BitOrSint32");
  break;
case OP_BitOrUint32:
  Text.Op = PrintName("BitOrUint32");
  break;
case OP_BitOrSint64:
  Text.Op = PrintName("BitOrSint64");
  break;
case OP_BitOrUint64:
  Text.Op = PrintName("BitOrUint64");
  break;
case OP_BitOrIntAP:
  Text.Op = PrintName("BitOrIntAP");
  break;
case OP_BitOrIntAPS:
  Text.Op = PrintName("BitOrIntAPS");
  break;
case OP_BitOrFixedPoint:
  Text.Op = PrintName("BitOrFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBitOrSint8(SourceInfo);
bool emitBitOrUint8(SourceInfo);
bool emitBitOrSint16(SourceInfo);
bool emitBitOrUint16(SourceInfo);
bool emitBitOrSint32(SourceInfo);
bool emitBitOrUint32(SourceInfo);
bool emitBitOrSint64(SourceInfo);
bool emitBitOrUint64(SourceInfo);
bool emitBitOrIntAP(SourceInfo);
bool emitBitOrIntAPS(SourceInfo);
bool emitBitOrFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitBitOr(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitBitOr(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitBitOrSint8(I);
  case PT_Uint8:
    return emitBitOrUint8(I);
  case PT_Sint16:
    return emitBitOrSint16(I);
  case PT_Uint16:
    return emitBitOrUint16(I);
  case PT_Sint32:
    return emitBitOrSint32(I);
  case PT_Uint32:
    return emitBitOrUint32(I);
  case PT_Sint64:
    return emitBitOrSint64(I);
  case PT_Uint64:
    return emitBitOrUint64(I);
  case PT_IntAP:
    return emitBitOrIntAP(I);
  case PT_IntAPS:
    return emitBitOrIntAPS(I);
  case PT_FixedPoint:
    return emitBitOrFixedPoint(I);
  default: llvm_unreachable("invalid type: emitBitOr");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBitOrSint8(SourceInfo L) {
  return emitOp<>(OP_BitOrSint8, L);
}
bool ByteCodeEmitter::emitBitOrUint8(SourceInfo L) {
  return emitOp<>(OP_BitOrUint8, L);
}
bool ByteCodeEmitter::emitBitOrSint16(SourceInfo L) {
  return emitOp<>(OP_BitOrSint16, L);
}
bool ByteCodeEmitter::emitBitOrUint16(SourceInfo L) {
  return emitOp<>(OP_BitOrUint16, L);
}
bool ByteCodeEmitter::emitBitOrSint32(SourceInfo L) {
  return emitOp<>(OP_BitOrSint32, L);
}
bool ByteCodeEmitter::emitBitOrUint32(SourceInfo L) {
  return emitOp<>(OP_BitOrUint32, L);
}
bool ByteCodeEmitter::emitBitOrSint64(SourceInfo L) {
  return emitOp<>(OP_BitOrSint64, L);
}
bool ByteCodeEmitter::emitBitOrUint64(SourceInfo L) {
  return emitOp<>(OP_BitOrUint64, L);
}
bool ByteCodeEmitter::emitBitOrIntAP(SourceInfo L) {
  return emitOp<>(OP_BitOrIntAP, L);
}
bool ByteCodeEmitter::emitBitOrIntAPS(SourceInfo L) {
  return emitOp<>(OP_BitOrIntAPS, L);
}
bool ByteCodeEmitter::emitBitOrFixedPoint(SourceInfo L) {
  return emitOp<>(OP_BitOrFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitBitOrSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitBitOrUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitBitOrSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitBitOrUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitBitOrSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitBitOrUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitBitOrSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitBitOrUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitBitOrIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitBitOrIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitBitOrFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitOr<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_BitXorSint8,
OP_BitXorUint8,
OP_BitXorSint16,
OP_BitXorUint16,
OP_BitXorSint32,
OP_BitXorUint32,
OP_BitXorSint64,
OP_BitXorUint64,
OP_BitXorIntAP,
OP_BitXorIntAPS,
OP_BitXorFixedPoint,
#endif
#ifdef GET_INTERP
case OP_BitXorSint8: {
  if (!BitXor<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorUint8: {
  if (!BitXor<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorSint16: {
  if (!BitXor<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorUint16: {
  if (!BitXor<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorSint32: {
  if (!BitXor<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorUint32: {
  if (!BitXor<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorSint64: {
  if (!BitXor<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorUint64: {
  if (!BitXor<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorIntAP: {
  if (!BitXor<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorIntAPS: {
  if (!BitXor<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_BitXorFixedPoint: {
  if (!BitXor<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_BitXorSint8:
  Text.Op = PrintName("BitXorSint8");
  break;
case OP_BitXorUint8:
  Text.Op = PrintName("BitXorUint8");
  break;
case OP_BitXorSint16:
  Text.Op = PrintName("BitXorSint16");
  break;
case OP_BitXorUint16:
  Text.Op = PrintName("BitXorUint16");
  break;
case OP_BitXorSint32:
  Text.Op = PrintName("BitXorSint32");
  break;
case OP_BitXorUint32:
  Text.Op = PrintName("BitXorUint32");
  break;
case OP_BitXorSint64:
  Text.Op = PrintName("BitXorSint64");
  break;
case OP_BitXorUint64:
  Text.Op = PrintName("BitXorUint64");
  break;
case OP_BitXorIntAP:
  Text.Op = PrintName("BitXorIntAP");
  break;
case OP_BitXorIntAPS:
  Text.Op = PrintName("BitXorIntAPS");
  break;
case OP_BitXorFixedPoint:
  Text.Op = PrintName("BitXorFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitBitXorSint8(SourceInfo);
bool emitBitXorUint8(SourceInfo);
bool emitBitXorSint16(SourceInfo);
bool emitBitXorUint16(SourceInfo);
bool emitBitXorSint32(SourceInfo);
bool emitBitXorUint32(SourceInfo);
bool emitBitXorSint64(SourceInfo);
bool emitBitXorUint64(SourceInfo);
bool emitBitXorIntAP(SourceInfo);
bool emitBitXorIntAPS(SourceInfo);
bool emitBitXorFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitBitXor(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitBitXor(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitBitXorSint8(I);
  case PT_Uint8:
    return emitBitXorUint8(I);
  case PT_Sint16:
    return emitBitXorSint16(I);
  case PT_Uint16:
    return emitBitXorUint16(I);
  case PT_Sint32:
    return emitBitXorSint32(I);
  case PT_Uint32:
    return emitBitXorUint32(I);
  case PT_Sint64:
    return emitBitXorSint64(I);
  case PT_Uint64:
    return emitBitXorUint64(I);
  case PT_IntAP:
    return emitBitXorIntAP(I);
  case PT_IntAPS:
    return emitBitXorIntAPS(I);
  case PT_FixedPoint:
    return emitBitXorFixedPoint(I);
  default: llvm_unreachable("invalid type: emitBitXor");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitBitXorSint8(SourceInfo L) {
  return emitOp<>(OP_BitXorSint8, L);
}
bool ByteCodeEmitter::emitBitXorUint8(SourceInfo L) {
  return emitOp<>(OP_BitXorUint8, L);
}
bool ByteCodeEmitter::emitBitXorSint16(SourceInfo L) {
  return emitOp<>(OP_BitXorSint16, L);
}
bool ByteCodeEmitter::emitBitXorUint16(SourceInfo L) {
  return emitOp<>(OP_BitXorUint16, L);
}
bool ByteCodeEmitter::emitBitXorSint32(SourceInfo L) {
  return emitOp<>(OP_BitXorSint32, L);
}
bool ByteCodeEmitter::emitBitXorUint32(SourceInfo L) {
  return emitOp<>(OP_BitXorUint32, L);
}
bool ByteCodeEmitter::emitBitXorSint64(SourceInfo L) {
  return emitOp<>(OP_BitXorSint64, L);
}
bool ByteCodeEmitter::emitBitXorUint64(SourceInfo L) {
  return emitOp<>(OP_BitXorUint64, L);
}
bool ByteCodeEmitter::emitBitXorIntAP(SourceInfo L) {
  return emitOp<>(OP_BitXorIntAP, L);
}
bool ByteCodeEmitter::emitBitXorIntAPS(SourceInfo L) {
  return emitOp<>(OP_BitXorIntAPS, L);
}
bool ByteCodeEmitter::emitBitXorFixedPoint(SourceInfo L) {
  return emitOp<>(OP_BitXorFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitBitXorSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitBitXorUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitBitXorSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitBitXorUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitBitXorSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitBitXorUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitBitXorSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitBitXorUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitBitXorIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitBitXorIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitBitXorFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return BitXor<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CMP3Sint8,
OP_CMP3Uint8,
OP_CMP3Sint16,
OP_CMP3Uint16,
OP_CMP3Sint32,
OP_CMP3Uint32,
OP_CMP3Sint64,
OP_CMP3Uint64,
OP_CMP3IntAP,
OP_CMP3IntAPS,
OP_CMP3Bool,
OP_CMP3FixedPoint,
OP_CMP3Ptr,
OP_CMP3Float,
#endif
#ifdef GET_INTERP
case OP_CMP3Sint8: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Uint8: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Sint16: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Uint16: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Sint32: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Uint32: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Sint64: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Uint64: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3IntAP: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3IntAPS: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Bool: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3FixedPoint: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Ptr: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CMP3Float: {
  const auto V0 = ReadArg<const ComparisonCategoryInfo *>(S, PC);
  if (!CMP3<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CMP3Sint8:
  Text.Op = PrintName("CMP3Sint8");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Uint8:
  Text.Op = PrintName("CMP3Uint8");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Sint16:
  Text.Op = PrintName("CMP3Sint16");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Uint16:
  Text.Op = PrintName("CMP3Uint16");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Sint32:
  Text.Op = PrintName("CMP3Sint32");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Uint32:
  Text.Op = PrintName("CMP3Uint32");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Sint64:
  Text.Op = PrintName("CMP3Sint64");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Uint64:
  Text.Op = PrintName("CMP3Uint64");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3IntAP:
  Text.Op = PrintName("CMP3IntAP");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3IntAPS:
  Text.Op = PrintName("CMP3IntAPS");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Bool:
  Text.Op = PrintName("CMP3Bool");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3FixedPoint:
  Text.Op = PrintName("CMP3FixedPoint");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Ptr:
  Text.Op = PrintName("CMP3Ptr");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
case OP_CMP3Float:
  Text.Op = PrintName("CMP3Float");
  Text.Args.push_back(printArg<const ComparisonCategoryInfo *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCMP3Sint8( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Uint8( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Sint16( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Uint16( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Sint32( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Uint32( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Sint64( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Uint64( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3IntAP( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3IntAPS( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Bool( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3FixedPoint( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Ptr( const ComparisonCategoryInfo * , SourceInfo);
bool emitCMP3Float( const ComparisonCategoryInfo * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCMP3(PrimType, const ComparisonCategoryInfo *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCMP3(PrimType T0,  const ComparisonCategoryInfo * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCMP3Sint8(A0, I);
  case PT_Uint8:
    return emitCMP3Uint8(A0, I);
  case PT_Sint16:
    return emitCMP3Sint16(A0, I);
  case PT_Uint16:
    return emitCMP3Uint16(A0, I);
  case PT_Sint32:
    return emitCMP3Sint32(A0, I);
  case PT_Uint32:
    return emitCMP3Uint32(A0, I);
  case PT_Sint64:
    return emitCMP3Sint64(A0, I);
  case PT_Uint64:
    return emitCMP3Uint64(A0, I);
  case PT_IntAP:
    return emitCMP3IntAP(A0, I);
  case PT_IntAPS:
    return emitCMP3IntAPS(A0, I);
  case PT_Bool:
    return emitCMP3Bool(A0, I);
  case PT_FixedPoint:
    return emitCMP3FixedPoint(A0, I);
  case PT_Ptr:
    return emitCMP3Ptr(A0, I);
  case PT_Float:
    return emitCMP3Float(A0, I);
  default: llvm_unreachable("invalid type: emitCMP3");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCMP3Sint8( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Sint8, A0, L);
}
bool ByteCodeEmitter::emitCMP3Uint8( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Uint8, A0, L);
}
bool ByteCodeEmitter::emitCMP3Sint16( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Sint16, A0, L);
}
bool ByteCodeEmitter::emitCMP3Uint16( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Uint16, A0, L);
}
bool ByteCodeEmitter::emitCMP3Sint32( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Sint32, A0, L);
}
bool ByteCodeEmitter::emitCMP3Uint32( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Uint32, A0, L);
}
bool ByteCodeEmitter::emitCMP3Sint64( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Sint64, A0, L);
}
bool ByteCodeEmitter::emitCMP3Uint64( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Uint64, A0, L);
}
bool ByteCodeEmitter::emitCMP3IntAP( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3IntAP, A0, L);
}
bool ByteCodeEmitter::emitCMP3IntAPS( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3IntAPS, A0, L);
}
bool ByteCodeEmitter::emitCMP3Bool( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Bool, A0, L);
}
bool ByteCodeEmitter::emitCMP3FixedPoint( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3FixedPoint, A0, L);
}
bool ByteCodeEmitter::emitCMP3Ptr( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Ptr, A0, L);
}
bool ByteCodeEmitter::emitCMP3Float( const ComparisonCategoryInfo * A0, SourceInfo L) {
  return emitOp<const ComparisonCategoryInfo *>(OP_CMP3Float, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCMP3Sint8( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Uint8( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Sint16( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Uint16( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Sint32( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Uint32( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Sint64( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Uint64( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3IntAP( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3IntAPS( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Bool( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3FixedPoint( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Ptr( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitCMP3Float( const ComparisonCategoryInfo * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CMP3<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Call,
#endif
#ifdef GET_INTERP
case OP_Call: {
  const auto V0 = ReadArg<const Function *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!Call(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Call:
  Text.Op = PrintName("Call");
  Text.Args.push_back(printArg<const Function *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCall( const Function * ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCall( const Function * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Function *, uint32_t>(OP_Call, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCall( const Function * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Call(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CallBI,
#endif
#ifdef GET_INTERP
case OP_CallBI: {
  const auto V0 = ReadArg<const CallExpr *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CallBI(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CallBI:
  Text.Op = PrintName("CallBI");
  Text.Args.push_back(printArg<const CallExpr *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCallBI( const CallExpr * ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCallBI( const CallExpr * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const CallExpr *, uint32_t>(OP_CallBI, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCallBI( const CallExpr * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CallBI(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CallPtr,
#endif
#ifdef GET_INTERP
case OP_CallPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const CallExpr *>(S, PC);
  if (!CallPtr(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CallPtr:
  Text.Op = PrintName("CallPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const CallExpr *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCallPtr( uint32_t ,  const CallExpr * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCallPtr( uint32_t A0,  const CallExpr * A1, SourceInfo L) {
  return emitOp<uint32_t, const CallExpr *>(OP_CallPtr, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCallPtr( uint32_t A0,  const CallExpr * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CallPtr(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CallVar,
#endif
#ifdef GET_INTERP
case OP_CallVar: {
  const auto V0 = ReadArg<const Function *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CallVar(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CallVar:
  Text.Op = PrintName("CallVar");
  Text.Args.push_back(printArg<const Function *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCallVar( const Function * ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCallVar( const Function * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Function *, uint32_t>(OP_CallVar, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCallVar( const Function * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CallVar(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CallVirt,
#endif
#ifdef GET_INTERP
case OP_CallVirt: {
  const auto V0 = ReadArg<const Function *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CallVirt(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CallVirt:
  Text.Op = PrintName("CallVirt");
  Text.Args.push_back(printArg<const Function *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCallVirt( const Function * ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCallVirt( const Function * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Function *, uint32_t>(OP_CallVirt, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCallVirt( const Function * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CallVirt(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastUint8Uint8,
OP_CastUint8Sint8,
OP_CastUint8Uint16,
OP_CastUint8Sint16,
OP_CastUint8Uint32,
OP_CastUint8Sint32,
OP_CastUint8Uint64,
OP_CastUint8Sint64,
OP_CastUint8Bool,
OP_CastSint8Uint8,
OP_CastSint8Sint8,
OP_CastSint8Uint16,
OP_CastSint8Sint16,
OP_CastSint8Uint32,
OP_CastSint8Sint32,
OP_CastSint8Uint64,
OP_CastSint8Sint64,
OP_CastSint8Bool,
OP_CastUint16Uint8,
OP_CastUint16Sint8,
OP_CastUint16Uint16,
OP_CastUint16Sint16,
OP_CastUint16Uint32,
OP_CastUint16Sint32,
OP_CastUint16Uint64,
OP_CastUint16Sint64,
OP_CastUint16Bool,
OP_CastSint16Uint8,
OP_CastSint16Sint8,
OP_CastSint16Uint16,
OP_CastSint16Sint16,
OP_CastSint16Uint32,
OP_CastSint16Sint32,
OP_CastSint16Uint64,
OP_CastSint16Sint64,
OP_CastSint16Bool,
OP_CastUint32Uint8,
OP_CastUint32Sint8,
OP_CastUint32Uint16,
OP_CastUint32Sint16,
OP_CastUint32Uint32,
OP_CastUint32Sint32,
OP_CastUint32Uint64,
OP_CastUint32Sint64,
OP_CastUint32Bool,
OP_CastSint32Uint8,
OP_CastSint32Sint8,
OP_CastSint32Uint16,
OP_CastSint32Sint16,
OP_CastSint32Uint32,
OP_CastSint32Sint32,
OP_CastSint32Uint64,
OP_CastSint32Sint64,
OP_CastSint32Bool,
OP_CastUint64Uint8,
OP_CastUint64Sint8,
OP_CastUint64Uint16,
OP_CastUint64Sint16,
OP_CastUint64Uint32,
OP_CastUint64Sint32,
OP_CastUint64Uint64,
OP_CastUint64Sint64,
OP_CastUint64Bool,
OP_CastSint64Uint8,
OP_CastSint64Sint8,
OP_CastSint64Uint16,
OP_CastSint64Sint16,
OP_CastSint64Uint32,
OP_CastSint64Sint32,
OP_CastSint64Uint64,
OP_CastSint64Sint64,
OP_CastSint64Bool,
OP_CastBoolUint8,
OP_CastBoolSint8,
OP_CastBoolUint16,
OP_CastBoolSint16,
OP_CastBoolUint32,
OP_CastBoolSint32,
OP_CastBoolUint64,
OP_CastBoolSint64,
OP_CastBoolBool,
OP_CastIntAPUint8,
OP_CastIntAPSint8,
OP_CastIntAPUint16,
OP_CastIntAPSint16,
OP_CastIntAPUint32,
OP_CastIntAPSint32,
OP_CastIntAPUint64,
OP_CastIntAPSint64,
OP_CastIntAPBool,
OP_CastIntAPSUint8,
OP_CastIntAPSSint8,
OP_CastIntAPSUint16,
OP_CastIntAPSSint16,
OP_CastIntAPSUint32,
OP_CastIntAPSSint32,
OP_CastIntAPSUint64,
OP_CastIntAPSSint64,
OP_CastIntAPSBool,
OP_CastFixedPointUint8,
OP_CastFixedPointSint8,
OP_CastFixedPointUint16,
OP_CastFixedPointSint16,
OP_CastFixedPointUint32,
OP_CastFixedPointSint32,
OP_CastFixedPointUint64,
OP_CastFixedPointSint64,
OP_CastFixedPointBool,
#endif
#ifdef GET_INTERP
case OP_CastUint8Uint8: {
  if (!Cast<PT_Uint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Sint8: {
  if (!Cast<PT_Uint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Uint16: {
  if (!Cast<PT_Uint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Sint16: {
  if (!Cast<PT_Uint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Uint32: {
  if (!Cast<PT_Uint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Sint32: {
  if (!Cast<PT_Uint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Uint64: {
  if (!Cast<PT_Uint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Sint64: {
  if (!Cast<PT_Uint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint8Bool: {
  if (!Cast<PT_Uint8, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Uint8: {
  if (!Cast<PT_Sint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Sint8: {
  if (!Cast<PT_Sint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Uint16: {
  if (!Cast<PT_Sint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Sint16: {
  if (!Cast<PT_Sint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Uint32: {
  if (!Cast<PT_Sint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Sint32: {
  if (!Cast<PT_Sint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Uint64: {
  if (!Cast<PT_Sint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Sint64: {
  if (!Cast<PT_Sint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint8Bool: {
  if (!Cast<PT_Sint8, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Uint8: {
  if (!Cast<PT_Uint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Sint8: {
  if (!Cast<PT_Uint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Uint16: {
  if (!Cast<PT_Uint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Sint16: {
  if (!Cast<PT_Uint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Uint32: {
  if (!Cast<PT_Uint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Sint32: {
  if (!Cast<PT_Uint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Uint64: {
  if (!Cast<PT_Uint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Sint64: {
  if (!Cast<PT_Uint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint16Bool: {
  if (!Cast<PT_Uint16, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Uint8: {
  if (!Cast<PT_Sint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Sint8: {
  if (!Cast<PT_Sint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Uint16: {
  if (!Cast<PT_Sint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Sint16: {
  if (!Cast<PT_Sint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Uint32: {
  if (!Cast<PT_Sint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Sint32: {
  if (!Cast<PT_Sint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Uint64: {
  if (!Cast<PT_Sint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Sint64: {
  if (!Cast<PT_Sint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint16Bool: {
  if (!Cast<PT_Sint16, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Uint8: {
  if (!Cast<PT_Uint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Sint8: {
  if (!Cast<PT_Uint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Uint16: {
  if (!Cast<PT_Uint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Sint16: {
  if (!Cast<PT_Uint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Uint32: {
  if (!Cast<PT_Uint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Sint32: {
  if (!Cast<PT_Uint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Uint64: {
  if (!Cast<PT_Uint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Sint64: {
  if (!Cast<PT_Uint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint32Bool: {
  if (!Cast<PT_Uint32, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Uint8: {
  if (!Cast<PT_Sint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Sint8: {
  if (!Cast<PT_Sint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Uint16: {
  if (!Cast<PT_Sint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Sint16: {
  if (!Cast<PT_Sint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Uint32: {
  if (!Cast<PT_Sint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Sint32: {
  if (!Cast<PT_Sint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Uint64: {
  if (!Cast<PT_Sint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Sint64: {
  if (!Cast<PT_Sint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint32Bool: {
  if (!Cast<PT_Sint32, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Uint8: {
  if (!Cast<PT_Uint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Sint8: {
  if (!Cast<PT_Uint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Uint16: {
  if (!Cast<PT_Uint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Sint16: {
  if (!Cast<PT_Uint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Uint32: {
  if (!Cast<PT_Uint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Sint32: {
  if (!Cast<PT_Uint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Uint64: {
  if (!Cast<PT_Uint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Sint64: {
  if (!Cast<PT_Uint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastUint64Bool: {
  if (!Cast<PT_Uint64, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Uint8: {
  if (!Cast<PT_Sint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Sint8: {
  if (!Cast<PT_Sint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Uint16: {
  if (!Cast<PT_Sint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Sint16: {
  if (!Cast<PT_Sint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Uint32: {
  if (!Cast<PT_Sint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Sint32: {
  if (!Cast<PT_Sint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Uint64: {
  if (!Cast<PT_Sint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Sint64: {
  if (!Cast<PT_Sint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastSint64Bool: {
  if (!Cast<PT_Sint64, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolUint8: {
  if (!Cast<PT_Bool, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolSint8: {
  if (!Cast<PT_Bool, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolUint16: {
  if (!Cast<PT_Bool, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolSint16: {
  if (!Cast<PT_Bool, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolUint32: {
  if (!Cast<PT_Bool, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolSint32: {
  if (!Cast<PT_Bool, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolUint64: {
  if (!Cast<PT_Bool, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolSint64: {
  if (!Cast<PT_Bool, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastBoolBool: {
  if (!Cast<PT_Bool, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPUint8: {
  if (!Cast<PT_IntAP, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSint8: {
  if (!Cast<PT_IntAP, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPUint16: {
  if (!Cast<PT_IntAP, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSint16: {
  if (!Cast<PT_IntAP, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPUint32: {
  if (!Cast<PT_IntAP, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSint32: {
  if (!Cast<PT_IntAP, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPUint64: {
  if (!Cast<PT_IntAP, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSint64: {
  if (!Cast<PT_IntAP, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPBool: {
  if (!Cast<PT_IntAP, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSUint8: {
  if (!Cast<PT_IntAPS, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSSint8: {
  if (!Cast<PT_IntAPS, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSUint16: {
  if (!Cast<PT_IntAPS, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSSint16: {
  if (!Cast<PT_IntAPS, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSUint32: {
  if (!Cast<PT_IntAPS, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSSint32: {
  if (!Cast<PT_IntAPS, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSUint64: {
  if (!Cast<PT_IntAPS, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSSint64: {
  if (!Cast<PT_IntAPS, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastIntAPSBool: {
  if (!Cast<PT_IntAPS, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointUint8: {
  if (!Cast<PT_FixedPoint, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointSint8: {
  if (!Cast<PT_FixedPoint, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointUint16: {
  if (!Cast<PT_FixedPoint, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointSint16: {
  if (!Cast<PT_FixedPoint, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointUint32: {
  if (!Cast<PT_FixedPoint, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointSint32: {
  if (!Cast<PT_FixedPoint, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointUint64: {
  if (!Cast<PT_FixedPoint, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointSint64: {
  if (!Cast<PT_FixedPoint, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointBool: {
  if (!Cast<PT_FixedPoint, PT_Bool>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastUint8Uint8:
  Text.Op = PrintName("CastUint8Uint8");
  break;
case OP_CastUint8Sint8:
  Text.Op = PrintName("CastUint8Sint8");
  break;
case OP_CastUint8Uint16:
  Text.Op = PrintName("CastUint8Uint16");
  break;
case OP_CastUint8Sint16:
  Text.Op = PrintName("CastUint8Sint16");
  break;
case OP_CastUint8Uint32:
  Text.Op = PrintName("CastUint8Uint32");
  break;
case OP_CastUint8Sint32:
  Text.Op = PrintName("CastUint8Sint32");
  break;
case OP_CastUint8Uint64:
  Text.Op = PrintName("CastUint8Uint64");
  break;
case OP_CastUint8Sint64:
  Text.Op = PrintName("CastUint8Sint64");
  break;
case OP_CastUint8Bool:
  Text.Op = PrintName("CastUint8Bool");
  break;
case OP_CastSint8Uint8:
  Text.Op = PrintName("CastSint8Uint8");
  break;
case OP_CastSint8Sint8:
  Text.Op = PrintName("CastSint8Sint8");
  break;
case OP_CastSint8Uint16:
  Text.Op = PrintName("CastSint8Uint16");
  break;
case OP_CastSint8Sint16:
  Text.Op = PrintName("CastSint8Sint16");
  break;
case OP_CastSint8Uint32:
  Text.Op = PrintName("CastSint8Uint32");
  break;
case OP_CastSint8Sint32:
  Text.Op = PrintName("CastSint8Sint32");
  break;
case OP_CastSint8Uint64:
  Text.Op = PrintName("CastSint8Uint64");
  break;
case OP_CastSint8Sint64:
  Text.Op = PrintName("CastSint8Sint64");
  break;
case OP_CastSint8Bool:
  Text.Op = PrintName("CastSint8Bool");
  break;
case OP_CastUint16Uint8:
  Text.Op = PrintName("CastUint16Uint8");
  break;
case OP_CastUint16Sint8:
  Text.Op = PrintName("CastUint16Sint8");
  break;
case OP_CastUint16Uint16:
  Text.Op = PrintName("CastUint16Uint16");
  break;
case OP_CastUint16Sint16:
  Text.Op = PrintName("CastUint16Sint16");
  break;
case OP_CastUint16Uint32:
  Text.Op = PrintName("CastUint16Uint32");
  break;
case OP_CastUint16Sint32:
  Text.Op = PrintName("CastUint16Sint32");
  break;
case OP_CastUint16Uint64:
  Text.Op = PrintName("CastUint16Uint64");
  break;
case OP_CastUint16Sint64:
  Text.Op = PrintName("CastUint16Sint64");
  break;
case OP_CastUint16Bool:
  Text.Op = PrintName("CastUint16Bool");
  break;
case OP_CastSint16Uint8:
  Text.Op = PrintName("CastSint16Uint8");
  break;
case OP_CastSint16Sint8:
  Text.Op = PrintName("CastSint16Sint8");
  break;
case OP_CastSint16Uint16:
  Text.Op = PrintName("CastSint16Uint16");
  break;
case OP_CastSint16Sint16:
  Text.Op = PrintName("CastSint16Sint16");
  break;
case OP_CastSint16Uint32:
  Text.Op = PrintName("CastSint16Uint32");
  break;
case OP_CastSint16Sint32:
  Text.Op = PrintName("CastSint16Sint32");
  break;
case OP_CastSint16Uint64:
  Text.Op = PrintName("CastSint16Uint64");
  break;
case OP_CastSint16Sint64:
  Text.Op = PrintName("CastSint16Sint64");
  break;
case OP_CastSint16Bool:
  Text.Op = PrintName("CastSint16Bool");
  break;
case OP_CastUint32Uint8:
  Text.Op = PrintName("CastUint32Uint8");
  break;
case OP_CastUint32Sint8:
  Text.Op = PrintName("CastUint32Sint8");
  break;
case OP_CastUint32Uint16:
  Text.Op = PrintName("CastUint32Uint16");
  break;
case OP_CastUint32Sint16:
  Text.Op = PrintName("CastUint32Sint16");
  break;
case OP_CastUint32Uint32:
  Text.Op = PrintName("CastUint32Uint32");
  break;
case OP_CastUint32Sint32:
  Text.Op = PrintName("CastUint32Sint32");
  break;
case OP_CastUint32Uint64:
  Text.Op = PrintName("CastUint32Uint64");
  break;
case OP_CastUint32Sint64:
  Text.Op = PrintName("CastUint32Sint64");
  break;
case OP_CastUint32Bool:
  Text.Op = PrintName("CastUint32Bool");
  break;
case OP_CastSint32Uint8:
  Text.Op = PrintName("CastSint32Uint8");
  break;
case OP_CastSint32Sint8:
  Text.Op = PrintName("CastSint32Sint8");
  break;
case OP_CastSint32Uint16:
  Text.Op = PrintName("CastSint32Uint16");
  break;
case OP_CastSint32Sint16:
  Text.Op = PrintName("CastSint32Sint16");
  break;
case OP_CastSint32Uint32:
  Text.Op = PrintName("CastSint32Uint32");
  break;
case OP_CastSint32Sint32:
  Text.Op = PrintName("CastSint32Sint32");
  break;
case OP_CastSint32Uint64:
  Text.Op = PrintName("CastSint32Uint64");
  break;
case OP_CastSint32Sint64:
  Text.Op = PrintName("CastSint32Sint64");
  break;
case OP_CastSint32Bool:
  Text.Op = PrintName("CastSint32Bool");
  break;
case OP_CastUint64Uint8:
  Text.Op = PrintName("CastUint64Uint8");
  break;
case OP_CastUint64Sint8:
  Text.Op = PrintName("CastUint64Sint8");
  break;
case OP_CastUint64Uint16:
  Text.Op = PrintName("CastUint64Uint16");
  break;
case OP_CastUint64Sint16:
  Text.Op = PrintName("CastUint64Sint16");
  break;
case OP_CastUint64Uint32:
  Text.Op = PrintName("CastUint64Uint32");
  break;
case OP_CastUint64Sint32:
  Text.Op = PrintName("CastUint64Sint32");
  break;
case OP_CastUint64Uint64:
  Text.Op = PrintName("CastUint64Uint64");
  break;
case OP_CastUint64Sint64:
  Text.Op = PrintName("CastUint64Sint64");
  break;
case OP_CastUint64Bool:
  Text.Op = PrintName("CastUint64Bool");
  break;
case OP_CastSint64Uint8:
  Text.Op = PrintName("CastSint64Uint8");
  break;
case OP_CastSint64Sint8:
  Text.Op = PrintName("CastSint64Sint8");
  break;
case OP_CastSint64Uint16:
  Text.Op = PrintName("CastSint64Uint16");
  break;
case OP_CastSint64Sint16:
  Text.Op = PrintName("CastSint64Sint16");
  break;
case OP_CastSint64Uint32:
  Text.Op = PrintName("CastSint64Uint32");
  break;
case OP_CastSint64Sint32:
  Text.Op = PrintName("CastSint64Sint32");
  break;
case OP_CastSint64Uint64:
  Text.Op = PrintName("CastSint64Uint64");
  break;
case OP_CastSint64Sint64:
  Text.Op = PrintName("CastSint64Sint64");
  break;
case OP_CastSint64Bool:
  Text.Op = PrintName("CastSint64Bool");
  break;
case OP_CastBoolUint8:
  Text.Op = PrintName("CastBoolUint8");
  break;
case OP_CastBoolSint8:
  Text.Op = PrintName("CastBoolSint8");
  break;
case OP_CastBoolUint16:
  Text.Op = PrintName("CastBoolUint16");
  break;
case OP_CastBoolSint16:
  Text.Op = PrintName("CastBoolSint16");
  break;
case OP_CastBoolUint32:
  Text.Op = PrintName("CastBoolUint32");
  break;
case OP_CastBoolSint32:
  Text.Op = PrintName("CastBoolSint32");
  break;
case OP_CastBoolUint64:
  Text.Op = PrintName("CastBoolUint64");
  break;
case OP_CastBoolSint64:
  Text.Op = PrintName("CastBoolSint64");
  break;
case OP_CastBoolBool:
  Text.Op = PrintName("CastBoolBool");
  break;
case OP_CastIntAPUint8:
  Text.Op = PrintName("CastIntAPUint8");
  break;
case OP_CastIntAPSint8:
  Text.Op = PrintName("CastIntAPSint8");
  break;
case OP_CastIntAPUint16:
  Text.Op = PrintName("CastIntAPUint16");
  break;
case OP_CastIntAPSint16:
  Text.Op = PrintName("CastIntAPSint16");
  break;
case OP_CastIntAPUint32:
  Text.Op = PrintName("CastIntAPUint32");
  break;
case OP_CastIntAPSint32:
  Text.Op = PrintName("CastIntAPSint32");
  break;
case OP_CastIntAPUint64:
  Text.Op = PrintName("CastIntAPUint64");
  break;
case OP_CastIntAPSint64:
  Text.Op = PrintName("CastIntAPSint64");
  break;
case OP_CastIntAPBool:
  Text.Op = PrintName("CastIntAPBool");
  break;
case OP_CastIntAPSUint8:
  Text.Op = PrintName("CastIntAPSUint8");
  break;
case OP_CastIntAPSSint8:
  Text.Op = PrintName("CastIntAPSSint8");
  break;
case OP_CastIntAPSUint16:
  Text.Op = PrintName("CastIntAPSUint16");
  break;
case OP_CastIntAPSSint16:
  Text.Op = PrintName("CastIntAPSSint16");
  break;
case OP_CastIntAPSUint32:
  Text.Op = PrintName("CastIntAPSUint32");
  break;
case OP_CastIntAPSSint32:
  Text.Op = PrintName("CastIntAPSSint32");
  break;
case OP_CastIntAPSUint64:
  Text.Op = PrintName("CastIntAPSUint64");
  break;
case OP_CastIntAPSSint64:
  Text.Op = PrintName("CastIntAPSSint64");
  break;
case OP_CastIntAPSBool:
  Text.Op = PrintName("CastIntAPSBool");
  break;
case OP_CastFixedPointUint8:
  Text.Op = PrintName("CastFixedPointUint8");
  break;
case OP_CastFixedPointSint8:
  Text.Op = PrintName("CastFixedPointSint8");
  break;
case OP_CastFixedPointUint16:
  Text.Op = PrintName("CastFixedPointUint16");
  break;
case OP_CastFixedPointSint16:
  Text.Op = PrintName("CastFixedPointSint16");
  break;
case OP_CastFixedPointUint32:
  Text.Op = PrintName("CastFixedPointUint32");
  break;
case OP_CastFixedPointSint32:
  Text.Op = PrintName("CastFixedPointSint32");
  break;
case OP_CastFixedPointUint64:
  Text.Op = PrintName("CastFixedPointUint64");
  break;
case OP_CastFixedPointSint64:
  Text.Op = PrintName("CastFixedPointSint64");
  break;
case OP_CastFixedPointBool:
  Text.Op = PrintName("CastFixedPointBool");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastUint8Uint8(SourceInfo);
bool emitCastUint8Sint8(SourceInfo);
bool emitCastUint8Uint16(SourceInfo);
bool emitCastUint8Sint16(SourceInfo);
bool emitCastUint8Uint32(SourceInfo);
bool emitCastUint8Sint32(SourceInfo);
bool emitCastUint8Uint64(SourceInfo);
bool emitCastUint8Sint64(SourceInfo);
bool emitCastUint8Bool(SourceInfo);
bool emitCastSint8Uint8(SourceInfo);
bool emitCastSint8Sint8(SourceInfo);
bool emitCastSint8Uint16(SourceInfo);
bool emitCastSint8Sint16(SourceInfo);
bool emitCastSint8Uint32(SourceInfo);
bool emitCastSint8Sint32(SourceInfo);
bool emitCastSint8Uint64(SourceInfo);
bool emitCastSint8Sint64(SourceInfo);
bool emitCastSint8Bool(SourceInfo);
bool emitCastUint16Uint8(SourceInfo);
bool emitCastUint16Sint8(SourceInfo);
bool emitCastUint16Uint16(SourceInfo);
bool emitCastUint16Sint16(SourceInfo);
bool emitCastUint16Uint32(SourceInfo);
bool emitCastUint16Sint32(SourceInfo);
bool emitCastUint16Uint64(SourceInfo);
bool emitCastUint16Sint64(SourceInfo);
bool emitCastUint16Bool(SourceInfo);
bool emitCastSint16Uint8(SourceInfo);
bool emitCastSint16Sint8(SourceInfo);
bool emitCastSint16Uint16(SourceInfo);
bool emitCastSint16Sint16(SourceInfo);
bool emitCastSint16Uint32(SourceInfo);
bool emitCastSint16Sint32(SourceInfo);
bool emitCastSint16Uint64(SourceInfo);
bool emitCastSint16Sint64(SourceInfo);
bool emitCastSint16Bool(SourceInfo);
bool emitCastUint32Uint8(SourceInfo);
bool emitCastUint32Sint8(SourceInfo);
bool emitCastUint32Uint16(SourceInfo);
bool emitCastUint32Sint16(SourceInfo);
bool emitCastUint32Uint32(SourceInfo);
bool emitCastUint32Sint32(SourceInfo);
bool emitCastUint32Uint64(SourceInfo);
bool emitCastUint32Sint64(SourceInfo);
bool emitCastUint32Bool(SourceInfo);
bool emitCastSint32Uint8(SourceInfo);
bool emitCastSint32Sint8(SourceInfo);
bool emitCastSint32Uint16(SourceInfo);
bool emitCastSint32Sint16(SourceInfo);
bool emitCastSint32Uint32(SourceInfo);
bool emitCastSint32Sint32(SourceInfo);
bool emitCastSint32Uint64(SourceInfo);
bool emitCastSint32Sint64(SourceInfo);
bool emitCastSint32Bool(SourceInfo);
bool emitCastUint64Uint8(SourceInfo);
bool emitCastUint64Sint8(SourceInfo);
bool emitCastUint64Uint16(SourceInfo);
bool emitCastUint64Sint16(SourceInfo);
bool emitCastUint64Uint32(SourceInfo);
bool emitCastUint64Sint32(SourceInfo);
bool emitCastUint64Uint64(SourceInfo);
bool emitCastUint64Sint64(SourceInfo);
bool emitCastUint64Bool(SourceInfo);
bool emitCastSint64Uint8(SourceInfo);
bool emitCastSint64Sint8(SourceInfo);
bool emitCastSint64Uint16(SourceInfo);
bool emitCastSint64Sint16(SourceInfo);
bool emitCastSint64Uint32(SourceInfo);
bool emitCastSint64Sint32(SourceInfo);
bool emitCastSint64Uint64(SourceInfo);
bool emitCastSint64Sint64(SourceInfo);
bool emitCastSint64Bool(SourceInfo);
bool emitCastBoolUint8(SourceInfo);
bool emitCastBoolSint8(SourceInfo);
bool emitCastBoolUint16(SourceInfo);
bool emitCastBoolSint16(SourceInfo);
bool emitCastBoolUint32(SourceInfo);
bool emitCastBoolSint32(SourceInfo);
bool emitCastBoolUint64(SourceInfo);
bool emitCastBoolSint64(SourceInfo);
bool emitCastBoolBool(SourceInfo);
bool emitCastIntAPUint8(SourceInfo);
bool emitCastIntAPSint8(SourceInfo);
bool emitCastIntAPUint16(SourceInfo);
bool emitCastIntAPSint16(SourceInfo);
bool emitCastIntAPUint32(SourceInfo);
bool emitCastIntAPSint32(SourceInfo);
bool emitCastIntAPUint64(SourceInfo);
bool emitCastIntAPSint64(SourceInfo);
bool emitCastIntAPBool(SourceInfo);
bool emitCastIntAPSUint8(SourceInfo);
bool emitCastIntAPSSint8(SourceInfo);
bool emitCastIntAPSUint16(SourceInfo);
bool emitCastIntAPSSint16(SourceInfo);
bool emitCastIntAPSUint32(SourceInfo);
bool emitCastIntAPSSint32(SourceInfo);
bool emitCastIntAPSUint64(SourceInfo);
bool emitCastIntAPSSint64(SourceInfo);
bool emitCastIntAPSBool(SourceInfo);
bool emitCastFixedPointUint8(SourceInfo);
bool emitCastFixedPointSint8(SourceInfo);
bool emitCastFixedPointUint16(SourceInfo);
bool emitCastFixedPointSint16(SourceInfo);
bool emitCastFixedPointUint32(SourceInfo);
bool emitCastFixedPointSint32(SourceInfo);
bool emitCastFixedPointUint64(SourceInfo);
bool emitCastFixedPointSint64(SourceInfo);
bool emitCastFixedPointBool(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCast(PrimType, PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCast(PrimType T0, PrimType T1, SourceInfo I) {
  switch (T0) {
  case PT_Uint8:
  switch (T1) {
  case PT_Uint8:
    return emitCastUint8Uint8(I);
  case PT_Sint8:
    return emitCastUint8Sint8(I);
  case PT_Uint16:
    return emitCastUint8Uint16(I);
  case PT_Sint16:
    return emitCastUint8Sint16(I);
  case PT_Uint32:
    return emitCastUint8Uint32(I);
  case PT_Sint32:
    return emitCastUint8Sint32(I);
  case PT_Uint64:
    return emitCastUint8Uint64(I);
  case PT_Sint64:
    return emitCastUint8Sint64(I);
  case PT_Bool:
    return emitCastUint8Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint8:
  switch (T1) {
  case PT_Uint8:
    return emitCastSint8Uint8(I);
  case PT_Sint8:
    return emitCastSint8Sint8(I);
  case PT_Uint16:
    return emitCastSint8Uint16(I);
  case PT_Sint16:
    return emitCastSint8Sint16(I);
  case PT_Uint32:
    return emitCastSint8Uint32(I);
  case PT_Sint32:
    return emitCastSint8Sint32(I);
  case PT_Uint64:
    return emitCastSint8Uint64(I);
  case PT_Sint64:
    return emitCastSint8Sint64(I);
  case PT_Bool:
    return emitCastSint8Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint16:
  switch (T1) {
  case PT_Uint8:
    return emitCastUint16Uint8(I);
  case PT_Sint8:
    return emitCastUint16Sint8(I);
  case PT_Uint16:
    return emitCastUint16Uint16(I);
  case PT_Sint16:
    return emitCastUint16Sint16(I);
  case PT_Uint32:
    return emitCastUint16Uint32(I);
  case PT_Sint32:
    return emitCastUint16Sint32(I);
  case PT_Uint64:
    return emitCastUint16Uint64(I);
  case PT_Sint64:
    return emitCastUint16Sint64(I);
  case PT_Bool:
    return emitCastUint16Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint16:
  switch (T1) {
  case PT_Uint8:
    return emitCastSint16Uint8(I);
  case PT_Sint8:
    return emitCastSint16Sint8(I);
  case PT_Uint16:
    return emitCastSint16Uint16(I);
  case PT_Sint16:
    return emitCastSint16Sint16(I);
  case PT_Uint32:
    return emitCastSint16Uint32(I);
  case PT_Sint32:
    return emitCastSint16Sint32(I);
  case PT_Uint64:
    return emitCastSint16Uint64(I);
  case PT_Sint64:
    return emitCastSint16Sint64(I);
  case PT_Bool:
    return emitCastSint16Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint32:
  switch (T1) {
  case PT_Uint8:
    return emitCastUint32Uint8(I);
  case PT_Sint8:
    return emitCastUint32Sint8(I);
  case PT_Uint16:
    return emitCastUint32Uint16(I);
  case PT_Sint16:
    return emitCastUint32Sint16(I);
  case PT_Uint32:
    return emitCastUint32Uint32(I);
  case PT_Sint32:
    return emitCastUint32Sint32(I);
  case PT_Uint64:
    return emitCastUint32Uint64(I);
  case PT_Sint64:
    return emitCastUint32Sint64(I);
  case PT_Bool:
    return emitCastUint32Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint32:
  switch (T1) {
  case PT_Uint8:
    return emitCastSint32Uint8(I);
  case PT_Sint8:
    return emitCastSint32Sint8(I);
  case PT_Uint16:
    return emitCastSint32Uint16(I);
  case PT_Sint16:
    return emitCastSint32Sint16(I);
  case PT_Uint32:
    return emitCastSint32Uint32(I);
  case PT_Sint32:
    return emitCastSint32Sint32(I);
  case PT_Uint64:
    return emitCastSint32Uint64(I);
  case PT_Sint64:
    return emitCastSint32Sint64(I);
  case PT_Bool:
    return emitCastSint32Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint64:
  switch (T1) {
  case PT_Uint8:
    return emitCastUint64Uint8(I);
  case PT_Sint8:
    return emitCastUint64Sint8(I);
  case PT_Uint16:
    return emitCastUint64Uint16(I);
  case PT_Sint16:
    return emitCastUint64Sint16(I);
  case PT_Uint32:
    return emitCastUint64Uint32(I);
  case PT_Sint32:
    return emitCastUint64Sint32(I);
  case PT_Uint64:
    return emitCastUint64Uint64(I);
  case PT_Sint64:
    return emitCastUint64Sint64(I);
  case PT_Bool:
    return emitCastUint64Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint64:
  switch (T1) {
  case PT_Uint8:
    return emitCastSint64Uint8(I);
  case PT_Sint8:
    return emitCastSint64Sint8(I);
  case PT_Uint16:
    return emitCastSint64Uint16(I);
  case PT_Sint16:
    return emitCastSint64Sint16(I);
  case PT_Uint32:
    return emitCastSint64Uint32(I);
  case PT_Sint32:
    return emitCastSint64Sint32(I);
  case PT_Uint64:
    return emitCastSint64Uint64(I);
  case PT_Sint64:
    return emitCastSint64Sint64(I);
  case PT_Bool:
    return emitCastSint64Bool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_Bool:
  switch (T1) {
  case PT_Uint8:
    return emitCastBoolUint8(I);
  case PT_Sint8:
    return emitCastBoolSint8(I);
  case PT_Uint16:
    return emitCastBoolUint16(I);
  case PT_Sint16:
    return emitCastBoolSint16(I);
  case PT_Uint32:
    return emitCastBoolUint32(I);
  case PT_Sint32:
    return emitCastBoolSint32(I);
  case PT_Uint64:
    return emitCastBoolUint64(I);
  case PT_Sint64:
    return emitCastBoolSint64(I);
  case PT_Bool:
    return emitCastBoolBool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_IntAP:
  switch (T1) {
  case PT_Uint8:
    return emitCastIntAPUint8(I);
  case PT_Sint8:
    return emitCastIntAPSint8(I);
  case PT_Uint16:
    return emitCastIntAPUint16(I);
  case PT_Sint16:
    return emitCastIntAPSint16(I);
  case PT_Uint32:
    return emitCastIntAPUint32(I);
  case PT_Sint32:
    return emitCastIntAPSint32(I);
  case PT_Uint64:
    return emitCastIntAPUint64(I);
  case PT_Sint64:
    return emitCastIntAPSint64(I);
  case PT_Bool:
    return emitCastIntAPBool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_IntAPS:
  switch (T1) {
  case PT_Uint8:
    return emitCastIntAPSUint8(I);
  case PT_Sint8:
    return emitCastIntAPSSint8(I);
  case PT_Uint16:
    return emitCastIntAPSUint16(I);
  case PT_Sint16:
    return emitCastIntAPSSint16(I);
  case PT_Uint32:
    return emitCastIntAPSUint32(I);
  case PT_Sint32:
    return emitCastIntAPSSint32(I);
  case PT_Uint64:
    return emitCastIntAPSUint64(I);
  case PT_Sint64:
    return emitCastIntAPSSint64(I);
  case PT_Bool:
    return emitCastIntAPSBool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  case PT_FixedPoint:
  switch (T1) {
  case PT_Uint8:
    return emitCastFixedPointUint8(I);
  case PT_Sint8:
    return emitCastFixedPointSint8(I);
  case PT_Uint16:
    return emitCastFixedPointUint16(I);
  case PT_Sint16:
    return emitCastFixedPointSint16(I);
  case PT_Uint32:
    return emitCastFixedPointUint32(I);
  case PT_Sint32:
    return emitCastFixedPointSint32(I);
  case PT_Uint64:
    return emitCastFixedPointUint64(I);
  case PT_Sint64:
    return emitCastFixedPointSint64(I);
  case PT_Bool:
    return emitCastFixedPointBool(I);
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
  default: llvm_unreachable("invalid type: emitCast");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastUint8Uint8(SourceInfo L) {
  return emitOp<>(OP_CastUint8Uint8, L);
}
bool ByteCodeEmitter::emitCastUint8Sint8(SourceInfo L) {
  return emitOp<>(OP_CastUint8Sint8, L);
}
bool ByteCodeEmitter::emitCastUint8Uint16(SourceInfo L) {
  return emitOp<>(OP_CastUint8Uint16, L);
}
bool ByteCodeEmitter::emitCastUint8Sint16(SourceInfo L) {
  return emitOp<>(OP_CastUint8Sint16, L);
}
bool ByteCodeEmitter::emitCastUint8Uint32(SourceInfo L) {
  return emitOp<>(OP_CastUint8Uint32, L);
}
bool ByteCodeEmitter::emitCastUint8Sint32(SourceInfo L) {
  return emitOp<>(OP_CastUint8Sint32, L);
}
bool ByteCodeEmitter::emitCastUint8Uint64(SourceInfo L) {
  return emitOp<>(OP_CastUint8Uint64, L);
}
bool ByteCodeEmitter::emitCastUint8Sint64(SourceInfo L) {
  return emitOp<>(OP_CastUint8Sint64, L);
}
bool ByteCodeEmitter::emitCastUint8Bool(SourceInfo L) {
  return emitOp<>(OP_CastUint8Bool, L);
}
bool ByteCodeEmitter::emitCastSint8Uint8(SourceInfo L) {
  return emitOp<>(OP_CastSint8Uint8, L);
}
bool ByteCodeEmitter::emitCastSint8Sint8(SourceInfo L) {
  return emitOp<>(OP_CastSint8Sint8, L);
}
bool ByteCodeEmitter::emitCastSint8Uint16(SourceInfo L) {
  return emitOp<>(OP_CastSint8Uint16, L);
}
bool ByteCodeEmitter::emitCastSint8Sint16(SourceInfo L) {
  return emitOp<>(OP_CastSint8Sint16, L);
}
bool ByteCodeEmitter::emitCastSint8Uint32(SourceInfo L) {
  return emitOp<>(OP_CastSint8Uint32, L);
}
bool ByteCodeEmitter::emitCastSint8Sint32(SourceInfo L) {
  return emitOp<>(OP_CastSint8Sint32, L);
}
bool ByteCodeEmitter::emitCastSint8Uint64(SourceInfo L) {
  return emitOp<>(OP_CastSint8Uint64, L);
}
bool ByteCodeEmitter::emitCastSint8Sint64(SourceInfo L) {
  return emitOp<>(OP_CastSint8Sint64, L);
}
bool ByteCodeEmitter::emitCastSint8Bool(SourceInfo L) {
  return emitOp<>(OP_CastSint8Bool, L);
}
bool ByteCodeEmitter::emitCastUint16Uint8(SourceInfo L) {
  return emitOp<>(OP_CastUint16Uint8, L);
}
bool ByteCodeEmitter::emitCastUint16Sint8(SourceInfo L) {
  return emitOp<>(OP_CastUint16Sint8, L);
}
bool ByteCodeEmitter::emitCastUint16Uint16(SourceInfo L) {
  return emitOp<>(OP_CastUint16Uint16, L);
}
bool ByteCodeEmitter::emitCastUint16Sint16(SourceInfo L) {
  return emitOp<>(OP_CastUint16Sint16, L);
}
bool ByteCodeEmitter::emitCastUint16Uint32(SourceInfo L) {
  return emitOp<>(OP_CastUint16Uint32, L);
}
bool ByteCodeEmitter::emitCastUint16Sint32(SourceInfo L) {
  return emitOp<>(OP_CastUint16Sint32, L);
}
bool ByteCodeEmitter::emitCastUint16Uint64(SourceInfo L) {
  return emitOp<>(OP_CastUint16Uint64, L);
}
bool ByteCodeEmitter::emitCastUint16Sint64(SourceInfo L) {
  return emitOp<>(OP_CastUint16Sint64, L);
}
bool ByteCodeEmitter::emitCastUint16Bool(SourceInfo L) {
  return emitOp<>(OP_CastUint16Bool, L);
}
bool ByteCodeEmitter::emitCastSint16Uint8(SourceInfo L) {
  return emitOp<>(OP_CastSint16Uint8, L);
}
bool ByteCodeEmitter::emitCastSint16Sint8(SourceInfo L) {
  return emitOp<>(OP_CastSint16Sint8, L);
}
bool ByteCodeEmitter::emitCastSint16Uint16(SourceInfo L) {
  return emitOp<>(OP_CastSint16Uint16, L);
}
bool ByteCodeEmitter::emitCastSint16Sint16(SourceInfo L) {
  return emitOp<>(OP_CastSint16Sint16, L);
}
bool ByteCodeEmitter::emitCastSint16Uint32(SourceInfo L) {
  return emitOp<>(OP_CastSint16Uint32, L);
}
bool ByteCodeEmitter::emitCastSint16Sint32(SourceInfo L) {
  return emitOp<>(OP_CastSint16Sint32, L);
}
bool ByteCodeEmitter::emitCastSint16Uint64(SourceInfo L) {
  return emitOp<>(OP_CastSint16Uint64, L);
}
bool ByteCodeEmitter::emitCastSint16Sint64(SourceInfo L) {
  return emitOp<>(OP_CastSint16Sint64, L);
}
bool ByteCodeEmitter::emitCastSint16Bool(SourceInfo L) {
  return emitOp<>(OP_CastSint16Bool, L);
}
bool ByteCodeEmitter::emitCastUint32Uint8(SourceInfo L) {
  return emitOp<>(OP_CastUint32Uint8, L);
}
bool ByteCodeEmitter::emitCastUint32Sint8(SourceInfo L) {
  return emitOp<>(OP_CastUint32Sint8, L);
}
bool ByteCodeEmitter::emitCastUint32Uint16(SourceInfo L) {
  return emitOp<>(OP_CastUint32Uint16, L);
}
bool ByteCodeEmitter::emitCastUint32Sint16(SourceInfo L) {
  return emitOp<>(OP_CastUint32Sint16, L);
}
bool ByteCodeEmitter::emitCastUint32Uint32(SourceInfo L) {
  return emitOp<>(OP_CastUint32Uint32, L);
}
bool ByteCodeEmitter::emitCastUint32Sint32(SourceInfo L) {
  return emitOp<>(OP_CastUint32Sint32, L);
}
bool ByteCodeEmitter::emitCastUint32Uint64(SourceInfo L) {
  return emitOp<>(OP_CastUint32Uint64, L);
}
bool ByteCodeEmitter::emitCastUint32Sint64(SourceInfo L) {
  return emitOp<>(OP_CastUint32Sint64, L);
}
bool ByteCodeEmitter::emitCastUint32Bool(SourceInfo L) {
  return emitOp<>(OP_CastUint32Bool, L);
}
bool ByteCodeEmitter::emitCastSint32Uint8(SourceInfo L) {
  return emitOp<>(OP_CastSint32Uint8, L);
}
bool ByteCodeEmitter::emitCastSint32Sint8(SourceInfo L) {
  return emitOp<>(OP_CastSint32Sint8, L);
}
bool ByteCodeEmitter::emitCastSint32Uint16(SourceInfo L) {
  return emitOp<>(OP_CastSint32Uint16, L);
}
bool ByteCodeEmitter::emitCastSint32Sint16(SourceInfo L) {
  return emitOp<>(OP_CastSint32Sint16, L);
}
bool ByteCodeEmitter::emitCastSint32Uint32(SourceInfo L) {
  return emitOp<>(OP_CastSint32Uint32, L);
}
bool ByteCodeEmitter::emitCastSint32Sint32(SourceInfo L) {
  return emitOp<>(OP_CastSint32Sint32, L);
}
bool ByteCodeEmitter::emitCastSint32Uint64(SourceInfo L) {
  return emitOp<>(OP_CastSint32Uint64, L);
}
bool ByteCodeEmitter::emitCastSint32Sint64(SourceInfo L) {
  return emitOp<>(OP_CastSint32Sint64, L);
}
bool ByteCodeEmitter::emitCastSint32Bool(SourceInfo L) {
  return emitOp<>(OP_CastSint32Bool, L);
}
bool ByteCodeEmitter::emitCastUint64Uint8(SourceInfo L) {
  return emitOp<>(OP_CastUint64Uint8, L);
}
bool ByteCodeEmitter::emitCastUint64Sint8(SourceInfo L) {
  return emitOp<>(OP_CastUint64Sint8, L);
}
bool ByteCodeEmitter::emitCastUint64Uint16(SourceInfo L) {
  return emitOp<>(OP_CastUint64Uint16, L);
}
bool ByteCodeEmitter::emitCastUint64Sint16(SourceInfo L) {
  return emitOp<>(OP_CastUint64Sint16, L);
}
bool ByteCodeEmitter::emitCastUint64Uint32(SourceInfo L) {
  return emitOp<>(OP_CastUint64Uint32, L);
}
bool ByteCodeEmitter::emitCastUint64Sint32(SourceInfo L) {
  return emitOp<>(OP_CastUint64Sint32, L);
}
bool ByteCodeEmitter::emitCastUint64Uint64(SourceInfo L) {
  return emitOp<>(OP_CastUint64Uint64, L);
}
bool ByteCodeEmitter::emitCastUint64Sint64(SourceInfo L) {
  return emitOp<>(OP_CastUint64Sint64, L);
}
bool ByteCodeEmitter::emitCastUint64Bool(SourceInfo L) {
  return emitOp<>(OP_CastUint64Bool, L);
}
bool ByteCodeEmitter::emitCastSint64Uint8(SourceInfo L) {
  return emitOp<>(OP_CastSint64Uint8, L);
}
bool ByteCodeEmitter::emitCastSint64Sint8(SourceInfo L) {
  return emitOp<>(OP_CastSint64Sint8, L);
}
bool ByteCodeEmitter::emitCastSint64Uint16(SourceInfo L) {
  return emitOp<>(OP_CastSint64Uint16, L);
}
bool ByteCodeEmitter::emitCastSint64Sint16(SourceInfo L) {
  return emitOp<>(OP_CastSint64Sint16, L);
}
bool ByteCodeEmitter::emitCastSint64Uint32(SourceInfo L) {
  return emitOp<>(OP_CastSint64Uint32, L);
}
bool ByteCodeEmitter::emitCastSint64Sint32(SourceInfo L) {
  return emitOp<>(OP_CastSint64Sint32, L);
}
bool ByteCodeEmitter::emitCastSint64Uint64(SourceInfo L) {
  return emitOp<>(OP_CastSint64Uint64, L);
}
bool ByteCodeEmitter::emitCastSint64Sint64(SourceInfo L) {
  return emitOp<>(OP_CastSint64Sint64, L);
}
bool ByteCodeEmitter::emitCastSint64Bool(SourceInfo L) {
  return emitOp<>(OP_CastSint64Bool, L);
}
bool ByteCodeEmitter::emitCastBoolUint8(SourceInfo L) {
  return emitOp<>(OP_CastBoolUint8, L);
}
bool ByteCodeEmitter::emitCastBoolSint8(SourceInfo L) {
  return emitOp<>(OP_CastBoolSint8, L);
}
bool ByteCodeEmitter::emitCastBoolUint16(SourceInfo L) {
  return emitOp<>(OP_CastBoolUint16, L);
}
bool ByteCodeEmitter::emitCastBoolSint16(SourceInfo L) {
  return emitOp<>(OP_CastBoolSint16, L);
}
bool ByteCodeEmitter::emitCastBoolUint32(SourceInfo L) {
  return emitOp<>(OP_CastBoolUint32, L);
}
bool ByteCodeEmitter::emitCastBoolSint32(SourceInfo L) {
  return emitOp<>(OP_CastBoolSint32, L);
}
bool ByteCodeEmitter::emitCastBoolUint64(SourceInfo L) {
  return emitOp<>(OP_CastBoolUint64, L);
}
bool ByteCodeEmitter::emitCastBoolSint64(SourceInfo L) {
  return emitOp<>(OP_CastBoolSint64, L);
}
bool ByteCodeEmitter::emitCastBoolBool(SourceInfo L) {
  return emitOp<>(OP_CastBoolBool, L);
}
bool ByteCodeEmitter::emitCastIntAPUint8(SourceInfo L) {
  return emitOp<>(OP_CastIntAPUint8, L);
}
bool ByteCodeEmitter::emitCastIntAPSint8(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSint8, L);
}
bool ByteCodeEmitter::emitCastIntAPUint16(SourceInfo L) {
  return emitOp<>(OP_CastIntAPUint16, L);
}
bool ByteCodeEmitter::emitCastIntAPSint16(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSint16, L);
}
bool ByteCodeEmitter::emitCastIntAPUint32(SourceInfo L) {
  return emitOp<>(OP_CastIntAPUint32, L);
}
bool ByteCodeEmitter::emitCastIntAPSint32(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSint32, L);
}
bool ByteCodeEmitter::emitCastIntAPUint64(SourceInfo L) {
  return emitOp<>(OP_CastIntAPUint64, L);
}
bool ByteCodeEmitter::emitCastIntAPSint64(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSint64, L);
}
bool ByteCodeEmitter::emitCastIntAPBool(SourceInfo L) {
  return emitOp<>(OP_CastIntAPBool, L);
}
bool ByteCodeEmitter::emitCastIntAPSUint8(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSUint8, L);
}
bool ByteCodeEmitter::emitCastIntAPSSint8(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSSint8, L);
}
bool ByteCodeEmitter::emitCastIntAPSUint16(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSUint16, L);
}
bool ByteCodeEmitter::emitCastIntAPSSint16(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSSint16, L);
}
bool ByteCodeEmitter::emitCastIntAPSUint32(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSUint32, L);
}
bool ByteCodeEmitter::emitCastIntAPSSint32(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSSint32, L);
}
bool ByteCodeEmitter::emitCastIntAPSUint64(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSUint64, L);
}
bool ByteCodeEmitter::emitCastIntAPSSint64(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSSint64, L);
}
bool ByteCodeEmitter::emitCastIntAPSBool(SourceInfo L) {
  return emitOp<>(OP_CastIntAPSBool, L);
}
bool ByteCodeEmitter::emitCastFixedPointUint8(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointUint8, L);
}
bool ByteCodeEmitter::emitCastFixedPointSint8(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointSint8, L);
}
bool ByteCodeEmitter::emitCastFixedPointUint16(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointUint16, L);
}
bool ByteCodeEmitter::emitCastFixedPointSint16(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointSint16, L);
}
bool ByteCodeEmitter::emitCastFixedPointUint32(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointUint32, L);
}
bool ByteCodeEmitter::emitCastFixedPointSint32(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointSint32, L);
}
bool ByteCodeEmitter::emitCastFixedPointUint64(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointUint64, L);
}
bool ByteCodeEmitter::emitCastFixedPointSint64(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointSint64, L);
}
bool ByteCodeEmitter::emitCastFixedPointBool(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointBool, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastUint8Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint8Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint8, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint8Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint8, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint16Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint16, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint16Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint16, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint32Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint32, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint32Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint32, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastUint64Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Uint64, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastSint64Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Sint64, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastBoolUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastBoolSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastBoolUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastBoolSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastBoolUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastBoolSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastBoolUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastBoolSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastBoolBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_Bool, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAP, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastIntAPSBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_IntAPS, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Cast<PT_FixedPoint, PT_Bool>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastAPSint8,
OP_CastAPUint8,
OP_CastAPSint16,
OP_CastAPUint16,
OP_CastAPSint32,
OP_CastAPUint32,
OP_CastAPSint64,
OP_CastAPUint64,
OP_CastAPIntAP,
OP_CastAPIntAPS,
OP_CastAPBool,
OP_CastAPFixedPoint,
#endif
#ifdef GET_INTERP
case OP_CastAPSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAP<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastAPSint8:
  Text.Op = PrintName("CastAPSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPUint8:
  Text.Op = PrintName("CastAPUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSint16:
  Text.Op = PrintName("CastAPSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPUint16:
  Text.Op = PrintName("CastAPUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSint32:
  Text.Op = PrintName("CastAPSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPUint32:
  Text.Op = PrintName("CastAPUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSint64:
  Text.Op = PrintName("CastAPSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPUint64:
  Text.Op = PrintName("CastAPUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPIntAP:
  Text.Op = PrintName("CastAPIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPIntAPS:
  Text.Op = PrintName("CastAPIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPBool:
  Text.Op = PrintName("CastAPBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPFixedPoint:
  Text.Op = PrintName("CastAPFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastAPSint8( uint32_t , SourceInfo);
bool emitCastAPUint8( uint32_t , SourceInfo);
bool emitCastAPSint16( uint32_t , SourceInfo);
bool emitCastAPUint16( uint32_t , SourceInfo);
bool emitCastAPSint32( uint32_t , SourceInfo);
bool emitCastAPUint32( uint32_t , SourceInfo);
bool emitCastAPSint64( uint32_t , SourceInfo);
bool emitCastAPUint64( uint32_t , SourceInfo);
bool emitCastAPIntAP( uint32_t , SourceInfo);
bool emitCastAPIntAPS( uint32_t , SourceInfo);
bool emitCastAPBool( uint32_t , SourceInfo);
bool emitCastAPFixedPoint( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastAP(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastAP(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastAPSint8(A0, I);
  case PT_Uint8:
    return emitCastAPUint8(A0, I);
  case PT_Sint16:
    return emitCastAPSint16(A0, I);
  case PT_Uint16:
    return emitCastAPUint16(A0, I);
  case PT_Sint32:
    return emitCastAPSint32(A0, I);
  case PT_Uint32:
    return emitCastAPUint32(A0, I);
  case PT_Sint64:
    return emitCastAPSint64(A0, I);
  case PT_Uint64:
    return emitCastAPUint64(A0, I);
  case PT_IntAP:
    return emitCastAPIntAP(A0, I);
  case PT_IntAPS:
    return emitCastAPIntAPS(A0, I);
  case PT_Bool:
    return emitCastAPBool(A0, I);
  case PT_FixedPoint:
    return emitCastAPFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitCastAP");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastAPSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSint8, A0, L);
}
bool ByteCodeEmitter::emitCastAPUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPUint8, A0, L);
}
bool ByteCodeEmitter::emitCastAPSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSint16, A0, L);
}
bool ByteCodeEmitter::emitCastAPUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPUint16, A0, L);
}
bool ByteCodeEmitter::emitCastAPSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSint32, A0, L);
}
bool ByteCodeEmitter::emitCastAPUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPUint32, A0, L);
}
bool ByteCodeEmitter::emitCastAPSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSint64, A0, L);
}
bool ByteCodeEmitter::emitCastAPUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPUint64, A0, L);
}
bool ByteCodeEmitter::emitCastAPIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPIntAP, A0, L);
}
bool ByteCodeEmitter::emitCastAPIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPIntAPS, A0, L);
}
bool ByteCodeEmitter::emitCastAPBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPBool, A0, L);
}
bool ByteCodeEmitter::emitCastAPFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastAPSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAP<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastAPSSint8,
OP_CastAPSUint8,
OP_CastAPSSint16,
OP_CastAPSUint16,
OP_CastAPSSint32,
OP_CastAPSUint32,
OP_CastAPSSint64,
OP_CastAPSUint64,
OP_CastAPSIntAP,
OP_CastAPSIntAPS,
OP_CastAPSBool,
OP_CastAPSFixedPoint,
#endif
#ifdef GET_INTERP
case OP_CastAPSSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastAPSFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastAPS<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastAPSSint8:
  Text.Op = PrintName("CastAPSSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSUint8:
  Text.Op = PrintName("CastAPSUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSSint16:
  Text.Op = PrintName("CastAPSSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSUint16:
  Text.Op = PrintName("CastAPSUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSSint32:
  Text.Op = PrintName("CastAPSSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSUint32:
  Text.Op = PrintName("CastAPSUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSSint64:
  Text.Op = PrintName("CastAPSSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSUint64:
  Text.Op = PrintName("CastAPSUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSIntAP:
  Text.Op = PrintName("CastAPSIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSIntAPS:
  Text.Op = PrintName("CastAPSIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSBool:
  Text.Op = PrintName("CastAPSBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastAPSFixedPoint:
  Text.Op = PrintName("CastAPSFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastAPSSint8( uint32_t , SourceInfo);
bool emitCastAPSUint8( uint32_t , SourceInfo);
bool emitCastAPSSint16( uint32_t , SourceInfo);
bool emitCastAPSUint16( uint32_t , SourceInfo);
bool emitCastAPSSint32( uint32_t , SourceInfo);
bool emitCastAPSUint32( uint32_t , SourceInfo);
bool emitCastAPSSint64( uint32_t , SourceInfo);
bool emitCastAPSUint64( uint32_t , SourceInfo);
bool emitCastAPSIntAP( uint32_t , SourceInfo);
bool emitCastAPSIntAPS( uint32_t , SourceInfo);
bool emitCastAPSBool( uint32_t , SourceInfo);
bool emitCastAPSFixedPoint( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastAPS(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastAPS(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastAPSSint8(A0, I);
  case PT_Uint8:
    return emitCastAPSUint8(A0, I);
  case PT_Sint16:
    return emitCastAPSSint16(A0, I);
  case PT_Uint16:
    return emitCastAPSUint16(A0, I);
  case PT_Sint32:
    return emitCastAPSSint32(A0, I);
  case PT_Uint32:
    return emitCastAPSUint32(A0, I);
  case PT_Sint64:
    return emitCastAPSSint64(A0, I);
  case PT_Uint64:
    return emitCastAPSUint64(A0, I);
  case PT_IntAP:
    return emitCastAPSIntAP(A0, I);
  case PT_IntAPS:
    return emitCastAPSIntAPS(A0, I);
  case PT_Bool:
    return emitCastAPSBool(A0, I);
  case PT_FixedPoint:
    return emitCastAPSFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitCastAPS");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastAPSSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSSint8, A0, L);
}
bool ByteCodeEmitter::emitCastAPSUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSUint8, A0, L);
}
bool ByteCodeEmitter::emitCastAPSSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSSint16, A0, L);
}
bool ByteCodeEmitter::emitCastAPSUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSUint16, A0, L);
}
bool ByteCodeEmitter::emitCastAPSSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSSint32, A0, L);
}
bool ByteCodeEmitter::emitCastAPSUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSUint32, A0, L);
}
bool ByteCodeEmitter::emitCastAPSSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSSint64, A0, L);
}
bool ByteCodeEmitter::emitCastAPSUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSUint64, A0, L);
}
bool ByteCodeEmitter::emitCastAPSIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSIntAP, A0, L);
}
bool ByteCodeEmitter::emitCastAPSIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSIntAPS, A0, L);
}
bool ByteCodeEmitter::emitCastAPSBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSBool, A0, L);
}
bool ByteCodeEmitter::emitCastAPSFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastAPSFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastAPSSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitCastAPSFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastAPS<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFP,
#endif
#ifdef GET_INTERP
case OP_CastFP: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<llvm::RoundingMode>(S, PC);
  if (!CastFP(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFP:
  Text.Op = PrintName("CastFP");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<llvm::RoundingMode>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFP( const llvm::fltSemantics * ,  llvm::RoundingMode , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFP( const llvm::fltSemantics * A0,  llvm::RoundingMode A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, llvm::RoundingMode>(OP_CastFP, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFP( const llvm::fltSemantics * A0,  llvm::RoundingMode A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFP(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFixedPoint,
#endif
#ifdef GET_INTERP
case OP_CastFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFixedPoint(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFixedPoint:
  Text.Op = PrintName("CastFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFixedPoint( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPoint(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFixedPointFloating,
#endif
#ifdef GET_INTERP
case OP_CastFixedPointFloating: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  if (!CastFixedPointFloating(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFixedPointFloating:
  Text.Op = PrintName("CastFixedPointFloating");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFixedPointFloating( const llvm::fltSemantics * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFixedPointFloating( const llvm::fltSemantics * A0, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *>(OP_CastFixedPointFloating, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFixedPointFloating( const llvm::fltSemantics * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointFloating(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFixedPointIntegralSint8,
OP_CastFixedPointIntegralUint8,
OP_CastFixedPointIntegralSint16,
OP_CastFixedPointIntegralUint16,
OP_CastFixedPointIntegralSint32,
OP_CastFixedPointIntegralUint32,
OP_CastFixedPointIntegralSint64,
OP_CastFixedPointIntegralUint64,
#endif
#ifdef GET_INTERP
case OP_CastFixedPointIntegralSint8: {
  if (!CastFixedPointIntegral<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralUint8: {
  if (!CastFixedPointIntegral<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralSint16: {
  if (!CastFixedPointIntegral<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralUint16: {
  if (!CastFixedPointIntegral<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralSint32: {
  if (!CastFixedPointIntegral<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralUint32: {
  if (!CastFixedPointIntegral<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralSint64: {
  if (!CastFixedPointIntegral<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastFixedPointIntegralUint64: {
  if (!CastFixedPointIntegral<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFixedPointIntegralSint8:
  Text.Op = PrintName("CastFixedPointIntegralSint8");
  break;
case OP_CastFixedPointIntegralUint8:
  Text.Op = PrintName("CastFixedPointIntegralUint8");
  break;
case OP_CastFixedPointIntegralSint16:
  Text.Op = PrintName("CastFixedPointIntegralSint16");
  break;
case OP_CastFixedPointIntegralUint16:
  Text.Op = PrintName("CastFixedPointIntegralUint16");
  break;
case OP_CastFixedPointIntegralSint32:
  Text.Op = PrintName("CastFixedPointIntegralSint32");
  break;
case OP_CastFixedPointIntegralUint32:
  Text.Op = PrintName("CastFixedPointIntegralUint32");
  break;
case OP_CastFixedPointIntegralSint64:
  Text.Op = PrintName("CastFixedPointIntegralSint64");
  break;
case OP_CastFixedPointIntegralUint64:
  Text.Op = PrintName("CastFixedPointIntegralUint64");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFixedPointIntegralSint8(SourceInfo);
bool emitCastFixedPointIntegralUint8(SourceInfo);
bool emitCastFixedPointIntegralSint16(SourceInfo);
bool emitCastFixedPointIntegralUint16(SourceInfo);
bool emitCastFixedPointIntegralSint32(SourceInfo);
bool emitCastFixedPointIntegralUint32(SourceInfo);
bool emitCastFixedPointIntegralSint64(SourceInfo);
bool emitCastFixedPointIntegralUint64(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastFixedPointIntegral(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastFixedPointIntegral(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastFixedPointIntegralSint8(I);
  case PT_Uint8:
    return emitCastFixedPointIntegralUint8(I);
  case PT_Sint16:
    return emitCastFixedPointIntegralSint16(I);
  case PT_Uint16:
    return emitCastFixedPointIntegralUint16(I);
  case PT_Sint32:
    return emitCastFixedPointIntegralSint32(I);
  case PT_Uint32:
    return emitCastFixedPointIntegralUint32(I);
  case PT_Sint64:
    return emitCastFixedPointIntegralSint64(I);
  case PT_Uint64:
    return emitCastFixedPointIntegralUint64(I);
  default: llvm_unreachable("invalid type: emitCastFixedPointIntegral");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFixedPointIntegralSint8(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralSint8, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralUint8(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralUint8, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralSint16(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralSint16, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralUint16(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralUint16, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralSint32(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralSint32, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralUint32(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralUint32, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralSint64(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralSint64, L);
}
bool ByteCodeEmitter::emitCastFixedPointIntegralUint64(SourceInfo L) {
  return emitOp<>(OP_CastFixedPointIntegralUint64, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFixedPointIntegralSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastFixedPointIntegralUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFixedPointIntegral<PT_Uint64>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFloatingFixedPoint,
#endif
#ifdef GET_INTERP
case OP_CastFloatingFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingFixedPoint(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFloatingFixedPoint:
  Text.Op = PrintName("CastFloatingFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFloatingFixedPoint( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFloatingFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFloatingFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingFixedPoint(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFloatingIntegralSint8,
OP_CastFloatingIntegralUint8,
OP_CastFloatingIntegralSint16,
OP_CastFloatingIntegralUint16,
OP_CastFloatingIntegralSint32,
OP_CastFloatingIntegralUint32,
OP_CastFloatingIntegralSint64,
OP_CastFloatingIntegralUint64,
OP_CastFloatingIntegralBool,
#endif
#ifdef GET_INTERP
case OP_CastFloatingIntegralSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastFloatingIntegralBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegral<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFloatingIntegralSint8:
  Text.Op = PrintName("CastFloatingIntegralSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralUint8:
  Text.Op = PrintName("CastFloatingIntegralUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralSint16:
  Text.Op = PrintName("CastFloatingIntegralSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralUint16:
  Text.Op = PrintName("CastFloatingIntegralUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralSint32:
  Text.Op = PrintName("CastFloatingIntegralSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralUint32:
  Text.Op = PrintName("CastFloatingIntegralUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralSint64:
  Text.Op = PrintName("CastFloatingIntegralSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralUint64:
  Text.Op = PrintName("CastFloatingIntegralUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastFloatingIntegralBool:
  Text.Op = PrintName("CastFloatingIntegralBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFloatingIntegralSint8( uint32_t , SourceInfo);
bool emitCastFloatingIntegralUint8( uint32_t , SourceInfo);
bool emitCastFloatingIntegralSint16( uint32_t , SourceInfo);
bool emitCastFloatingIntegralUint16( uint32_t , SourceInfo);
bool emitCastFloatingIntegralSint32( uint32_t , SourceInfo);
bool emitCastFloatingIntegralUint32( uint32_t , SourceInfo);
bool emitCastFloatingIntegralSint64( uint32_t , SourceInfo);
bool emitCastFloatingIntegralUint64( uint32_t , SourceInfo);
bool emitCastFloatingIntegralBool( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastFloatingIntegral(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastFloatingIntegral(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastFloatingIntegralSint8(A0, I);
  case PT_Uint8:
    return emitCastFloatingIntegralUint8(A0, I);
  case PT_Sint16:
    return emitCastFloatingIntegralSint16(A0, I);
  case PT_Uint16:
    return emitCastFloatingIntegralUint16(A0, I);
  case PT_Sint32:
    return emitCastFloatingIntegralSint32(A0, I);
  case PT_Uint32:
    return emitCastFloatingIntegralUint32(A0, I);
  case PT_Sint64:
    return emitCastFloatingIntegralSint64(A0, I);
  case PT_Uint64:
    return emitCastFloatingIntegralUint64(A0, I);
  case PT_Bool:
    return emitCastFloatingIntegralBool(A0, I);
  default: llvm_unreachable("invalid type: emitCastFloatingIntegral");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFloatingIntegralSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralSint8, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralUint8, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralSint16, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralUint16, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralSint32, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralUint32, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralSint64, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralUint64, A0, L);
}
bool ByteCodeEmitter::emitCastFloatingIntegralBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastFloatingIntegralBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFloatingIntegralSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastFloatingIntegralBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegral<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFloatingIntegralAP,
#endif
#ifdef GET_INTERP
case OP_CastFloatingIntegralAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegralAP(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFloatingIntegralAP:
  Text.Op = PrintName("CastFloatingIntegralAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFloatingIntegralAP( uint32_t ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFloatingIntegralAP( uint32_t A0,  uint32_t A1, SourceInfo L) {
  return emitOp<uint32_t, uint32_t>(OP_CastFloatingIntegralAP, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFloatingIntegralAP( uint32_t A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegralAP(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastFloatingIntegralAPS,
#endif
#ifdef GET_INTERP
case OP_CastFloatingIntegralAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastFloatingIntegralAPS(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastFloatingIntegralAPS:
  Text.Op = PrintName("CastFloatingIntegralAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastFloatingIntegralAPS( uint32_t ,  uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastFloatingIntegralAPS( uint32_t A0,  uint32_t A1, SourceInfo L) {
  return emitOp<uint32_t, uint32_t>(OP_CastFloatingIntegralAPS, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastFloatingIntegralAPS( uint32_t A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastFloatingIntegralAPS(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastIntegralFixedPointSint8,
OP_CastIntegralFixedPointUint8,
OP_CastIntegralFixedPointSint16,
OP_CastIntegralFixedPointUint16,
OP_CastIntegralFixedPointSint32,
OP_CastIntegralFixedPointUint32,
OP_CastIntegralFixedPointSint64,
OP_CastIntegralFixedPointUint64,
OP_CastIntegralFixedPointBool,
#endif
#ifdef GET_INTERP
case OP_CastIntegralFixedPointSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CastIntegralFixedPointBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFixedPoint<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastIntegralFixedPointSint8:
  Text.Op = PrintName("CastIntegralFixedPointSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointUint8:
  Text.Op = PrintName("CastIntegralFixedPointUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointSint16:
  Text.Op = PrintName("CastIntegralFixedPointSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointUint16:
  Text.Op = PrintName("CastIntegralFixedPointUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointSint32:
  Text.Op = PrintName("CastIntegralFixedPointSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointUint32:
  Text.Op = PrintName("CastIntegralFixedPointUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointSint64:
  Text.Op = PrintName("CastIntegralFixedPointSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointUint64:
  Text.Op = PrintName("CastIntegralFixedPointUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFixedPointBool:
  Text.Op = PrintName("CastIntegralFixedPointBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastIntegralFixedPointSint8( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointUint8( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointSint16( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointUint16( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointSint32( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointUint32( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointSint64( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointUint64( uint32_t , SourceInfo);
bool emitCastIntegralFixedPointBool( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastIntegralFixedPoint(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastIntegralFixedPoint(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastIntegralFixedPointSint8(A0, I);
  case PT_Uint8:
    return emitCastIntegralFixedPointUint8(A0, I);
  case PT_Sint16:
    return emitCastIntegralFixedPointSint16(A0, I);
  case PT_Uint16:
    return emitCastIntegralFixedPointUint16(A0, I);
  case PT_Sint32:
    return emitCastIntegralFixedPointSint32(A0, I);
  case PT_Uint32:
    return emitCastIntegralFixedPointUint32(A0, I);
  case PT_Sint64:
    return emitCastIntegralFixedPointSint64(A0, I);
  case PT_Uint64:
    return emitCastIntegralFixedPointUint64(A0, I);
  case PT_Bool:
    return emitCastIntegralFixedPointBool(A0, I);
  default: llvm_unreachable("invalid type: emitCastIntegralFixedPoint");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastIntegralFixedPointSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointSint8, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointUint8, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointSint16, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointUint16, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointSint32, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointUint32, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointSint64, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointUint64, A0, L);
}
bool ByteCodeEmitter::emitCastIntegralFixedPointBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastIntegralFixedPointBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastIntegralFixedPointSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCastIntegralFixedPointBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFixedPoint<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastIntegralFloatingSint8,
OP_CastIntegralFloatingUint8,
OP_CastIntegralFloatingSint16,
OP_CastIntegralFloatingUint16,
OP_CastIntegralFloatingSint32,
OP_CastIntegralFloatingUint32,
OP_CastIntegralFloatingSint64,
OP_CastIntegralFloatingUint64,
OP_CastIntegralFloatingIntAP,
OP_CastIntegralFloatingIntAPS,
OP_CastIntegralFloatingBool,
OP_CastIntegralFloatingFixedPoint,
#endif
#ifdef GET_INTERP
case OP_CastIntegralFloatingSint8: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Sint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingUint8: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Uint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingSint16: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Sint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingUint16: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Uint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingSint32: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Sint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingUint32: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Uint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingSint64: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Sint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingUint64: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Uint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingIntAP: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_IntAP>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingIntAPS: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_IntAPS>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingBool: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_Bool>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_CastIntegralFloatingFixedPoint: {
  const auto V0 = ReadArg<const llvm::fltSemantics *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!CastIntegralFloating<PT_FixedPoint>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastIntegralFloatingSint8:
  Text.Op = PrintName("CastIntegralFloatingSint8");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingUint8:
  Text.Op = PrintName("CastIntegralFloatingUint8");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingSint16:
  Text.Op = PrintName("CastIntegralFloatingSint16");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingUint16:
  Text.Op = PrintName("CastIntegralFloatingUint16");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingSint32:
  Text.Op = PrintName("CastIntegralFloatingSint32");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingUint32:
  Text.Op = PrintName("CastIntegralFloatingUint32");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingSint64:
  Text.Op = PrintName("CastIntegralFloatingSint64");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingUint64:
  Text.Op = PrintName("CastIntegralFloatingUint64");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingIntAP:
  Text.Op = PrintName("CastIntegralFloatingIntAP");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingIntAPS:
  Text.Op = PrintName("CastIntegralFloatingIntAPS");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingBool:
  Text.Op = PrintName("CastIntegralFloatingBool");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CastIntegralFloatingFixedPoint:
  Text.Op = PrintName("CastIntegralFloatingFixedPoint");
  Text.Args.push_back(printArg<const llvm::fltSemantics *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastIntegralFloatingSint8( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingUint8( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingSint16( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingUint16( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingSint32( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingUint32( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingSint64( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingUint64( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingIntAP( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingIntAPS( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingBool( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
bool emitCastIntegralFloatingFixedPoint( const llvm::fltSemantics * ,  uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastIntegralFloating(PrimType, const llvm::fltSemantics *, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastIntegralFloating(PrimType T0,  const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastIntegralFloatingSint8(A0, A1, I);
  case PT_Uint8:
    return emitCastIntegralFloatingUint8(A0, A1, I);
  case PT_Sint16:
    return emitCastIntegralFloatingSint16(A0, A1, I);
  case PT_Uint16:
    return emitCastIntegralFloatingUint16(A0, A1, I);
  case PT_Sint32:
    return emitCastIntegralFloatingSint32(A0, A1, I);
  case PT_Uint32:
    return emitCastIntegralFloatingUint32(A0, A1, I);
  case PT_Sint64:
    return emitCastIntegralFloatingSint64(A0, A1, I);
  case PT_Uint64:
    return emitCastIntegralFloatingUint64(A0, A1, I);
  case PT_IntAP:
    return emitCastIntegralFloatingIntAP(A0, A1, I);
  case PT_IntAPS:
    return emitCastIntegralFloatingIntAPS(A0, A1, I);
  case PT_Bool:
    return emitCastIntegralFloatingBool(A0, A1, I);
  case PT_FixedPoint:
    return emitCastIntegralFloatingFixedPoint(A0, A1, I);
  default: llvm_unreachable("invalid type: emitCastIntegralFloating");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastIntegralFloatingSint8( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingSint8, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingUint8( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingUint8, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingSint16( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingSint16, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingUint16( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingUint16, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingSint32( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingSint32, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingUint32( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingUint32, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingSint64( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingSint64, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingUint64( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingUint64, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingIntAP( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingIntAP, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingIntAPS( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingIntAPS, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingBool( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingBool, A0, A1, L);
}
bool ByteCodeEmitter::emitCastIntegralFloatingFixedPoint( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const llvm::fltSemantics *, uint32_t>(OP_CastIntegralFloatingFixedPoint, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastIntegralFloatingSint8( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Sint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingUint8( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Uint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingSint16( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Sint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingUint16( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Uint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingSint32( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Sint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingUint32( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Uint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingSint64( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Sint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingUint64( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Uint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingIntAP( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_IntAP>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingIntAPS( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_IntAPS>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingBool( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_Bool>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitCastIntegralFloatingFixedPoint( const llvm::fltSemantics * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastIntegralFloating<PT_FixedPoint>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastMemberPtrPtr,
#endif
#ifdef GET_INTERP
case OP_CastMemberPtrPtr: {
  if (!CastMemberPtrPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastMemberPtrPtr:
  Text.Op = PrintName("CastMemberPtrPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastMemberPtrPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastMemberPtrPtr(SourceInfo L) {
  return emitOp<>(OP_CastMemberPtrPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastMemberPtrPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastMemberPtrPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastPointerIntegralSint8,
OP_CastPointerIntegralUint8,
OP_CastPointerIntegralSint16,
OP_CastPointerIntegralUint16,
OP_CastPointerIntegralSint32,
OP_CastPointerIntegralUint32,
OP_CastPointerIntegralSint64,
OP_CastPointerIntegralUint64,
OP_CastPointerIntegralBool,
#endif
#ifdef GET_INTERP
case OP_CastPointerIntegralSint8: {
  if (!CastPointerIntegral<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralUint8: {
  if (!CastPointerIntegral<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralSint16: {
  if (!CastPointerIntegral<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralUint16: {
  if (!CastPointerIntegral<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralSint32: {
  if (!CastPointerIntegral<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralUint32: {
  if (!CastPointerIntegral<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralSint64: {
  if (!CastPointerIntegral<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralUint64: {
  if (!CastPointerIntegral<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CastPointerIntegralBool: {
  if (!CastPointerIntegral<PT_Bool>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastPointerIntegralSint8:
  Text.Op = PrintName("CastPointerIntegralSint8");
  break;
case OP_CastPointerIntegralUint8:
  Text.Op = PrintName("CastPointerIntegralUint8");
  break;
case OP_CastPointerIntegralSint16:
  Text.Op = PrintName("CastPointerIntegralSint16");
  break;
case OP_CastPointerIntegralUint16:
  Text.Op = PrintName("CastPointerIntegralUint16");
  break;
case OP_CastPointerIntegralSint32:
  Text.Op = PrintName("CastPointerIntegralSint32");
  break;
case OP_CastPointerIntegralUint32:
  Text.Op = PrintName("CastPointerIntegralUint32");
  break;
case OP_CastPointerIntegralSint64:
  Text.Op = PrintName("CastPointerIntegralSint64");
  break;
case OP_CastPointerIntegralUint64:
  Text.Op = PrintName("CastPointerIntegralUint64");
  break;
case OP_CastPointerIntegralBool:
  Text.Op = PrintName("CastPointerIntegralBool");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastPointerIntegralSint8(SourceInfo);
bool emitCastPointerIntegralUint8(SourceInfo);
bool emitCastPointerIntegralSint16(SourceInfo);
bool emitCastPointerIntegralUint16(SourceInfo);
bool emitCastPointerIntegralSint32(SourceInfo);
bool emitCastPointerIntegralUint32(SourceInfo);
bool emitCastPointerIntegralSint64(SourceInfo);
bool emitCastPointerIntegralUint64(SourceInfo);
bool emitCastPointerIntegralBool(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCastPointerIntegral(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCastPointerIntegral(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCastPointerIntegralSint8(I);
  case PT_Uint8:
    return emitCastPointerIntegralUint8(I);
  case PT_Sint16:
    return emitCastPointerIntegralSint16(I);
  case PT_Uint16:
    return emitCastPointerIntegralUint16(I);
  case PT_Sint32:
    return emitCastPointerIntegralSint32(I);
  case PT_Uint32:
    return emitCastPointerIntegralUint32(I);
  case PT_Sint64:
    return emitCastPointerIntegralSint64(I);
  case PT_Uint64:
    return emitCastPointerIntegralUint64(I);
  case PT_Bool:
    return emitCastPointerIntegralBool(I);
  default: llvm_unreachable("invalid type: emitCastPointerIntegral");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastPointerIntegralSint8(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralSint8, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralUint8(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralUint8, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralSint16(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralSint16, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralUint16(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralUint16, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralSint32(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralSint32, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralUint32(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralUint32, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralSint64(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralSint64, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralUint64(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralUint64, L);
}
bool ByteCodeEmitter::emitCastPointerIntegralBool(SourceInfo L) {
  return emitOp<>(OP_CastPointerIntegralBool, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastPointerIntegralSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCastPointerIntegralBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegral<PT_Bool>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastPointerIntegralAP,
#endif
#ifdef GET_INTERP
case OP_CastPointerIntegralAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastPointerIntegralAP(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastPointerIntegralAP:
  Text.Op = PrintName("CastPointerIntegralAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastPointerIntegralAP( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastPointerIntegralAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastPointerIntegralAP, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastPointerIntegralAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegralAP(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CastPointerIntegralAPS,
#endif
#ifdef GET_INTERP
case OP_CastPointerIntegralAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!CastPointerIntegralAPS(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CastPointerIntegralAPS:
  Text.Op = PrintName("CastPointerIntegralAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCastPointerIntegralAPS( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCastPointerIntegralAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_CastPointerIntegralAPS, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCastPointerIntegralAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CastPointerIntegralAPS(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckAllocations,
#endif
#ifdef GET_INTERP
case OP_CheckAllocations: {
  if (!CheckAllocations(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckAllocations:
  Text.Op = PrintName("CheckAllocations");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckAllocations(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckAllocations(SourceInfo L) {
  return emitOp<>(OP_CheckAllocations, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckAllocations(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckAllocations(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckArraySize,
#endif
#ifdef GET_INTERP
case OP_CheckArraySize: {
  const auto V0 = ReadArg<uint64_t>(S, PC);
  if (!CheckArraySize(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckArraySize:
  Text.Op = PrintName("CheckArraySize");
  Text.Args.push_back(printArg<uint64_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckArraySize( uint64_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckArraySize( uint64_t A0, SourceInfo L) {
  return emitOp<uint64_t>(OP_CheckArraySize, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckArraySize( uint64_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckArraySize(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckDecl,
#endif
#ifdef GET_INTERP
case OP_CheckDecl: {
  const auto V0 = ReadArg<const VarDecl*>(S, PC);
  if (!CheckDecl(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckDecl:
  Text.Op = PrintName("CheckDecl");
  Text.Args.push_back(printArg<const VarDecl*>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckDecl( const VarDecl* , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckDecl( const VarDecl* A0, SourceInfo L) {
  return emitOp<const VarDecl*>(OP_CheckDecl, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckDecl( const VarDecl* A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckDecl(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckDestruction,
#endif
#ifdef GET_INTERP
case OP_CheckDestruction: {
  if (!CheckDestruction(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckDestruction:
  Text.Op = PrintName("CheckDestruction");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckDestruction(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckDestruction(SourceInfo L) {
  return emitOp<>(OP_CheckDestruction, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckDestruction(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckDestruction(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckEnumValueSint8,
OP_CheckEnumValueUint8,
OP_CheckEnumValueSint16,
OP_CheckEnumValueUint16,
OP_CheckEnumValueSint32,
OP_CheckEnumValueUint32,
OP_CheckEnumValueSint64,
OP_CheckEnumValueUint64,
OP_CheckEnumValueIntAP,
OP_CheckEnumValueIntAPS,
OP_CheckEnumValueBool,
#endif
#ifdef GET_INTERP
case OP_CheckEnumValueSint8: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueUint8: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueSint16: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueUint16: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueSint32: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueUint32: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueSint64: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueUint64: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueIntAP: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueIntAPS: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckEnumValueBool: {
  const auto V0 = ReadArg<const EnumDecl *>(S, PC);
  if (!CheckEnumValue<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckEnumValueSint8:
  Text.Op = PrintName("CheckEnumValueSint8");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueUint8:
  Text.Op = PrintName("CheckEnumValueUint8");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueSint16:
  Text.Op = PrintName("CheckEnumValueSint16");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueUint16:
  Text.Op = PrintName("CheckEnumValueUint16");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueSint32:
  Text.Op = PrintName("CheckEnumValueSint32");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueUint32:
  Text.Op = PrintName("CheckEnumValueUint32");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueSint64:
  Text.Op = PrintName("CheckEnumValueSint64");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueUint64:
  Text.Op = PrintName("CheckEnumValueUint64");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueIntAP:
  Text.Op = PrintName("CheckEnumValueIntAP");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueIntAPS:
  Text.Op = PrintName("CheckEnumValueIntAPS");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
case OP_CheckEnumValueBool:
  Text.Op = PrintName("CheckEnumValueBool");
  Text.Args.push_back(printArg<const EnumDecl *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckEnumValueSint8( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueUint8( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueSint16( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueUint16( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueSint32( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueUint32( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueSint64( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueUint64( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueIntAP( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueIntAPS( const EnumDecl * , SourceInfo);
bool emitCheckEnumValueBool( const EnumDecl * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCheckEnumValue(PrimType, const EnumDecl *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCheckEnumValue(PrimType T0,  const EnumDecl * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCheckEnumValueSint8(A0, I);
  case PT_Uint8:
    return emitCheckEnumValueUint8(A0, I);
  case PT_Sint16:
    return emitCheckEnumValueSint16(A0, I);
  case PT_Uint16:
    return emitCheckEnumValueUint16(A0, I);
  case PT_Sint32:
    return emitCheckEnumValueSint32(A0, I);
  case PT_Uint32:
    return emitCheckEnumValueUint32(A0, I);
  case PT_Sint64:
    return emitCheckEnumValueSint64(A0, I);
  case PT_Uint64:
    return emitCheckEnumValueUint64(A0, I);
  case PT_IntAP:
    return emitCheckEnumValueIntAP(A0, I);
  case PT_IntAPS:
    return emitCheckEnumValueIntAPS(A0, I);
  case PT_Bool:
    return emitCheckEnumValueBool(A0, I);
  default: llvm_unreachable("invalid type: emitCheckEnumValue");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckEnumValueSint8( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueSint8, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueUint8( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueUint8, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueSint16( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueSint16, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueUint16( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueUint16, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueSint32( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueSint32, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueUint32( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueUint32, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueSint64( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueSint64, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueUint64( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueUint64, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueIntAP( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueIntAP, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueIntAPS( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueIntAPS, A0, L);
}
bool ByteCodeEmitter::emitCheckEnumValueBool( const EnumDecl * A0, SourceInfo L) {
  return emitOp<const EnumDecl *>(OP_CheckEnumValueBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckEnumValueSint8( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueUint8( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueSint16( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueUint16( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueSint32( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueUint32( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueSint64( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueUint64( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueIntAP( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueIntAPS( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckEnumValueBool( const EnumDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckEnumValue<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckLiteralType,
#endif
#ifdef GET_INTERP
case OP_CheckLiteralType: {
  const auto V0 = ReadArg<const Type *>(S, PC);
  if (!CheckLiteralType(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckLiteralType:
  Text.Op = PrintName("CheckLiteralType");
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckLiteralType( const Type * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckLiteralType( const Type * A0, SourceInfo L) {
  return emitOp<const Type *>(OP_CheckLiteralType, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckLiteralType( const Type * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckLiteralType(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckNewTypeMismatch,
#endif
#ifdef GET_INTERP
case OP_CheckNewTypeMismatch: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatch(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckNewTypeMismatch:
  Text.Op = PrintName("CheckNewTypeMismatch");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckNewTypeMismatch( const Expr * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckNewTypeMismatch( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatch, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckNewTypeMismatch( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatch(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckNewTypeMismatchArraySint8,
OP_CheckNewTypeMismatchArrayUint8,
OP_CheckNewTypeMismatchArraySint16,
OP_CheckNewTypeMismatchArrayUint16,
OP_CheckNewTypeMismatchArraySint32,
OP_CheckNewTypeMismatchArrayUint32,
OP_CheckNewTypeMismatchArraySint64,
OP_CheckNewTypeMismatchArrayUint64,
OP_CheckNewTypeMismatchArrayIntAP,
OP_CheckNewTypeMismatchArrayIntAPS,
#endif
#ifdef GET_INTERP
case OP_CheckNewTypeMismatchArraySint8: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayUint8: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArraySint16: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayUint16: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArraySint32: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayUint32: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArraySint64: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayUint64: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayIntAP: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_CheckNewTypeMismatchArrayIntAPS: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!CheckNewTypeMismatchArray<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckNewTypeMismatchArraySint8:
  Text.Op = PrintName("CheckNewTypeMismatchArraySint8");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayUint8:
  Text.Op = PrintName("CheckNewTypeMismatchArrayUint8");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArraySint16:
  Text.Op = PrintName("CheckNewTypeMismatchArraySint16");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayUint16:
  Text.Op = PrintName("CheckNewTypeMismatchArrayUint16");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArraySint32:
  Text.Op = PrintName("CheckNewTypeMismatchArraySint32");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayUint32:
  Text.Op = PrintName("CheckNewTypeMismatchArrayUint32");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArraySint64:
  Text.Op = PrintName("CheckNewTypeMismatchArraySint64");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayUint64:
  Text.Op = PrintName("CheckNewTypeMismatchArrayUint64");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayIntAP:
  Text.Op = PrintName("CheckNewTypeMismatchArrayIntAP");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
case OP_CheckNewTypeMismatchArrayIntAPS:
  Text.Op = PrintName("CheckNewTypeMismatchArrayIntAPS");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckNewTypeMismatchArraySint8( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayUint8( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArraySint16( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayUint16( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArraySint32( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayUint32( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArraySint64( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayUint64( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayIntAP( const Expr * , SourceInfo);
bool emitCheckNewTypeMismatchArrayIntAPS( const Expr * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCheckNewTypeMismatchArray(PrimType, const Expr *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCheckNewTypeMismatchArray(PrimType T0,  const Expr * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCheckNewTypeMismatchArraySint8(A0, I);
  case PT_Uint8:
    return emitCheckNewTypeMismatchArrayUint8(A0, I);
  case PT_Sint16:
    return emitCheckNewTypeMismatchArraySint16(A0, I);
  case PT_Uint16:
    return emitCheckNewTypeMismatchArrayUint16(A0, I);
  case PT_Sint32:
    return emitCheckNewTypeMismatchArraySint32(A0, I);
  case PT_Uint32:
    return emitCheckNewTypeMismatchArrayUint32(A0, I);
  case PT_Sint64:
    return emitCheckNewTypeMismatchArraySint64(A0, I);
  case PT_Uint64:
    return emitCheckNewTypeMismatchArrayUint64(A0, I);
  case PT_IntAP:
    return emitCheckNewTypeMismatchArrayIntAP(A0, I);
  case PT_IntAPS:
    return emitCheckNewTypeMismatchArrayIntAPS(A0, I);
  default: llvm_unreachable("invalid type: emitCheckNewTypeMismatchArray");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckNewTypeMismatchArraySint8( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArraySint8, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayUint8( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayUint8, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArraySint16( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArraySint16, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayUint16( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayUint16, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArraySint32( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArraySint32, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayUint32( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayUint32, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArraySint64( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArraySint64, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayUint64( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayUint64, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayIntAP( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayIntAP, A0, L);
}
bool ByteCodeEmitter::emitCheckNewTypeMismatchArrayIntAPS( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_CheckNewTypeMismatchArrayIntAPS, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckNewTypeMismatchArraySint8( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayUint8( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArraySint16( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayUint16( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArraySint32( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayUint32( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArraySint64( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayUint64( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayIntAP( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitCheckNewTypeMismatchArrayIntAPS( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNewTypeMismatchArray<PT_IntAPS>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckNonNullArgPtr,
OP_CheckNonNullArgMemberPtr,
#endif
#ifdef GET_INTERP
case OP_CheckNonNullArgPtr: {
  if (!CheckNonNullArg<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_CheckNonNullArgMemberPtr: {
  if (!CheckNonNullArg<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckNonNullArgPtr:
  Text.Op = PrintName("CheckNonNullArgPtr");
  break;
case OP_CheckNonNullArgMemberPtr:
  Text.Op = PrintName("CheckNonNullArgMemberPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckNonNullArgPtr(SourceInfo);
bool emitCheckNonNullArgMemberPtr(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCheckNonNullArg(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCheckNonNullArg(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Ptr:
    return emitCheckNonNullArgPtr(I);
  case PT_MemberPtr:
    return emitCheckNonNullArgMemberPtr(I);
  default: llvm_unreachable("invalid type: emitCheckNonNullArg");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckNonNullArgPtr(SourceInfo L) {
  return emitOp<>(OP_CheckNonNullArgPtr, L);
}
bool ByteCodeEmitter::emitCheckNonNullArgMemberPtr(SourceInfo L) {
  return emitOp<>(OP_CheckNonNullArgMemberPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckNonNullArgPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNonNullArg<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitCheckNonNullArgMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNonNullArg<PT_MemberPtr>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckNull,
#endif
#ifdef GET_INTERP
case OP_CheckNull: {
  if (!CheckNull(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckNull:
  Text.Op = PrintName("CheckNull");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckNull(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckNull(SourceInfo L) {
  return emitOp<>(OP_CheckNull, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckNull(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckNull(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CheckPseudoDtor,
#endif
#ifdef GET_INTERP
case OP_CheckPseudoDtor: {
  if (!CheckPseudoDtor(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CheckPseudoDtor:
  Text.Op = PrintName("CheckPseudoDtor");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCheckPseudoDtor(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCheckPseudoDtor(SourceInfo L) {
  return emitOp<>(OP_CheckPseudoDtor, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCheckPseudoDtor(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CheckPseudoDtor(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CompSint8,
OP_CompUint8,
OP_CompSint16,
OP_CompUint16,
OP_CompSint32,
OP_CompUint32,
OP_CompSint64,
OP_CompUint64,
OP_CompIntAP,
OP_CompIntAPS,
#endif
#ifdef GET_INTERP
case OP_CompSint8: {
  if (!Comp<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_CompUint8: {
  if (!Comp<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_CompSint16: {
  if (!Comp<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_CompUint16: {
  if (!Comp<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_CompSint32: {
  if (!Comp<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_CompUint32: {
  if (!Comp<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_CompSint64: {
  if (!Comp<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_CompUint64: {
  if (!Comp<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_CompIntAP: {
  if (!Comp<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_CompIntAPS: {
  if (!Comp<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CompSint8:
  Text.Op = PrintName("CompSint8");
  break;
case OP_CompUint8:
  Text.Op = PrintName("CompUint8");
  break;
case OP_CompSint16:
  Text.Op = PrintName("CompSint16");
  break;
case OP_CompUint16:
  Text.Op = PrintName("CompUint16");
  break;
case OP_CompSint32:
  Text.Op = PrintName("CompSint32");
  break;
case OP_CompUint32:
  Text.Op = PrintName("CompUint32");
  break;
case OP_CompSint64:
  Text.Op = PrintName("CompSint64");
  break;
case OP_CompUint64:
  Text.Op = PrintName("CompUint64");
  break;
case OP_CompIntAP:
  Text.Op = PrintName("CompIntAP");
  break;
case OP_CompIntAPS:
  Text.Op = PrintName("CompIntAPS");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCompSint8(SourceInfo);
bool emitCompUint8(SourceInfo);
bool emitCompSint16(SourceInfo);
bool emitCompUint16(SourceInfo);
bool emitCompSint32(SourceInfo);
bool emitCompUint32(SourceInfo);
bool emitCompSint64(SourceInfo);
bool emitCompUint64(SourceInfo);
bool emitCompIntAP(SourceInfo);
bool emitCompIntAPS(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitComp(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitComp(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCompSint8(I);
  case PT_Uint8:
    return emitCompUint8(I);
  case PT_Sint16:
    return emitCompSint16(I);
  case PT_Uint16:
    return emitCompUint16(I);
  case PT_Sint32:
    return emitCompSint32(I);
  case PT_Uint32:
    return emitCompUint32(I);
  case PT_Sint64:
    return emitCompSint64(I);
  case PT_Uint64:
    return emitCompUint64(I);
  case PT_IntAP:
    return emitCompIntAP(I);
  case PT_IntAPS:
    return emitCompIntAPS(I);
  default: llvm_unreachable("invalid type: emitComp");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCompSint8(SourceInfo L) {
  return emitOp<>(OP_CompSint8, L);
}
bool ByteCodeEmitter::emitCompUint8(SourceInfo L) {
  return emitOp<>(OP_CompUint8, L);
}
bool ByteCodeEmitter::emitCompSint16(SourceInfo L) {
  return emitOp<>(OP_CompSint16, L);
}
bool ByteCodeEmitter::emitCompUint16(SourceInfo L) {
  return emitOp<>(OP_CompUint16, L);
}
bool ByteCodeEmitter::emitCompSint32(SourceInfo L) {
  return emitOp<>(OP_CompSint32, L);
}
bool ByteCodeEmitter::emitCompUint32(SourceInfo L) {
  return emitOp<>(OP_CompUint32, L);
}
bool ByteCodeEmitter::emitCompSint64(SourceInfo L) {
  return emitOp<>(OP_CompSint64, L);
}
bool ByteCodeEmitter::emitCompUint64(SourceInfo L) {
  return emitOp<>(OP_CompUint64, L);
}
bool ByteCodeEmitter::emitCompIntAP(SourceInfo L) {
  return emitOp<>(OP_CompIntAP, L);
}
bool ByteCodeEmitter::emitCompIntAPS(SourceInfo L) {
  return emitOp<>(OP_CompIntAPS, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCompSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitCompUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitCompSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitCompUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitCompSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitCompUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitCompSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitCompUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitCompIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitCompIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Comp<PT_IntAPS>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstBool,
#endif
#ifdef GET_INTERP
case OP_ConstBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Const<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstBool:
  Text.Op = PrintName("ConstBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstBool( bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_ConstBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstFixedPoint,
#endif
#ifdef GET_INTERP
case OP_ConstFixedPoint: {
  const auto &V0 = ReadArg<FixedPoint>(S, PC);
  if (!Const<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstFixedPoint:
  Text.Op = PrintName("ConstFixedPoint");
  Text.Args.push_back(printArg<FixedPoint>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstFixedPoint(const FixedPoint &, SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstFixedPoint(const FixedPoint &A0, SourceInfo L) {
  return emitOp<FixedPoint>(OP_ConstFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstFixedPoint(const FixedPoint &A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstFloat,
#endif
#ifdef GET_INTERP
case OP_ConstFloat: {
  const auto &V0 = ReadArg<Floating>(S, PC);
  if (!ConstFloat(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstFloat:
  Text.Op = PrintName("ConstFloat");
  Text.Args.push_back(printArg<Floating>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstFloat(const Floating &, SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstFloat(const Floating &A0, SourceInfo L) {
  return emitOp<Floating>(OP_ConstFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstFloat(const Floating &A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ConstFloat(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstIntAP,
#endif
#ifdef GET_INTERP
case OP_ConstIntAP: {
  const auto &V0 = ReadArg<IntegralAP<false>>(S, PC);
  if (!Const<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstIntAP:
  Text.Op = PrintName("ConstIntAP");
  Text.Args.push_back(printArg<IntegralAP<false>>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstIntAP(const IntegralAP<false> &, SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstIntAP(const IntegralAP<false> &A0, SourceInfo L) {
  return emitOp<IntegralAP<false>>(OP_ConstIntAP, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstIntAP(const IntegralAP<false> &A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_IntAP>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstIntAPS,
#endif
#ifdef GET_INTERP
case OP_ConstIntAPS: {
  const auto &V0 = ReadArg<IntegralAP<true>>(S, PC);
  if (!Const<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstIntAPS:
  Text.Op = PrintName("ConstIntAPS");
  Text.Args.push_back(printArg<IntegralAP<true>>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstIntAPS(const IntegralAP<true> &, SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstIntAPS(const IntegralAP<true> &A0, SourceInfo L) {
  return emitOp<IntegralAP<true>>(OP_ConstIntAPS, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstIntAPS(const IntegralAP<true> &A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_IntAPS>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstSint8,
#endif
#ifdef GET_INTERP
case OP_ConstSint8: {
  const auto V0 = ReadArg<int8_t>(S, PC);
  if (!Const<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstSint8:
  Text.Op = PrintName("ConstSint8");
  Text.Args.push_back(printArg<int8_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstSint8( int8_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstSint8( int8_t A0, SourceInfo L) {
  return emitOp<int8_t>(OP_ConstSint8, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstSint8( int8_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Sint8>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstSint16,
#endif
#ifdef GET_INTERP
case OP_ConstSint16: {
  const auto V0 = ReadArg<int16_t>(S, PC);
  if (!Const<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstSint16:
  Text.Op = PrintName("ConstSint16");
  Text.Args.push_back(printArg<int16_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstSint16( int16_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstSint16( int16_t A0, SourceInfo L) {
  return emitOp<int16_t>(OP_ConstSint16, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstSint16( int16_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Sint16>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstSint32,
#endif
#ifdef GET_INTERP
case OP_ConstSint32: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  if (!Const<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstSint32:
  Text.Op = PrintName("ConstSint32");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstSint32( int32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstSint32( int32_t A0, SourceInfo L) {
  return emitOp<int32_t>(OP_ConstSint32, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstSint32( int32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Sint32>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstSint64,
#endif
#ifdef GET_INTERP
case OP_ConstSint64: {
  const auto V0 = ReadArg<int64_t>(S, PC);
  if (!Const<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstSint64:
  Text.Op = PrintName("ConstSint64");
  Text.Args.push_back(printArg<int64_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstSint64( int64_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstSint64( int64_t A0, SourceInfo L) {
  return emitOp<int64_t>(OP_ConstSint64, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstSint64( int64_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Sint64>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstUint8,
#endif
#ifdef GET_INTERP
case OP_ConstUint8: {
  const auto V0 = ReadArg<uint8_t>(S, PC);
  if (!Const<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstUint8:
  Text.Op = PrintName("ConstUint8");
  Text.Args.push_back(printArg<uint8_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstUint8( uint8_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstUint8( uint8_t A0, SourceInfo L) {
  return emitOp<uint8_t>(OP_ConstUint8, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstUint8( uint8_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Uint8>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstUint16,
#endif
#ifdef GET_INTERP
case OP_ConstUint16: {
  const auto V0 = ReadArg<uint16_t>(S, PC);
  if (!Const<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstUint16:
  Text.Op = PrintName("ConstUint16");
  Text.Args.push_back(printArg<uint16_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstUint16( uint16_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstUint16( uint16_t A0, SourceInfo L) {
  return emitOp<uint16_t>(OP_ConstUint16, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstUint16( uint16_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Uint16>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstUint32,
#endif
#ifdef GET_INTERP
case OP_ConstUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Const<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstUint32:
  Text.Op = PrintName("ConstUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstUint32( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_ConstUint32, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Uint32>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ConstUint64,
#endif
#ifdef GET_INTERP
case OP_ConstUint64: {
  const auto V0 = ReadArg<uint64_t>(S, PC);
  if (!Const<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ConstUint64:
  Text.Op = PrintName("ConstUint64");
  Text.Args.push_back(printArg<uint64_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitConstUint64( uint64_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitConstUint64( uint64_t A0, SourceInfo L) {
  return emitOp<uint64_t>(OP_ConstUint64, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitConstUint64( uint64_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Const<PT_Uint64>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_CopyArraySint8,
OP_CopyArrayUint8,
OP_CopyArraySint16,
OP_CopyArrayUint16,
OP_CopyArraySint32,
OP_CopyArrayUint32,
OP_CopyArraySint64,
OP_CopyArrayUint64,
OP_CopyArrayIntAP,
OP_CopyArrayIntAPS,
OP_CopyArrayBool,
OP_CopyArrayFixedPoint,
OP_CopyArrayPtr,
OP_CopyArrayMemberPtr,
OP_CopyArrayFloat,
#endif
#ifdef GET_INTERP
case OP_CopyArraySint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Sint8>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Uint8>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArraySint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Sint16>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Uint16>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArraySint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Sint32>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Uint32>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArraySint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Sint64>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Uint64>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_IntAP>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_IntAPS>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Bool>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_FixedPoint>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Ptr>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_MemberPtr>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
case OP_CopyArrayFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  const auto V2 = ReadArg<uint32_t>(S, PC);
  if (!CopyArray<PT_Float>(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_CopyArraySint8:
  Text.Op = PrintName("CopyArraySint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayUint8:
  Text.Op = PrintName("CopyArrayUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArraySint16:
  Text.Op = PrintName("CopyArraySint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayUint16:
  Text.Op = PrintName("CopyArrayUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArraySint32:
  Text.Op = PrintName("CopyArraySint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayUint32:
  Text.Op = PrintName("CopyArrayUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArraySint64:
  Text.Op = PrintName("CopyArraySint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayUint64:
  Text.Op = PrintName("CopyArrayUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayIntAP:
  Text.Op = PrintName("CopyArrayIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayIntAPS:
  Text.Op = PrintName("CopyArrayIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayBool:
  Text.Op = PrintName("CopyArrayBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayFixedPoint:
  Text.Op = PrintName("CopyArrayFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayPtr:
  Text.Op = PrintName("CopyArrayPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayMemberPtr:
  Text.Op = PrintName("CopyArrayMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_CopyArrayFloat:
  Text.Op = PrintName("CopyArrayFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitCopyArraySint8( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayUint8( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArraySint16( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayUint16( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArraySint32( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayUint32( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArraySint64( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayUint64( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayIntAP( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayIntAPS( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayBool( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayFixedPoint( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayPtr( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayMemberPtr( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
bool emitCopyArrayFloat( uint32_t ,  uint32_t ,  uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitCopyArray(PrimType, uint32_t, uint32_t, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitCopyArray(PrimType T0,  uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitCopyArraySint8(A0, A1, A2, I);
  case PT_Uint8:
    return emitCopyArrayUint8(A0, A1, A2, I);
  case PT_Sint16:
    return emitCopyArraySint16(A0, A1, A2, I);
  case PT_Uint16:
    return emitCopyArrayUint16(A0, A1, A2, I);
  case PT_Sint32:
    return emitCopyArraySint32(A0, A1, A2, I);
  case PT_Uint32:
    return emitCopyArrayUint32(A0, A1, A2, I);
  case PT_Sint64:
    return emitCopyArraySint64(A0, A1, A2, I);
  case PT_Uint64:
    return emitCopyArrayUint64(A0, A1, A2, I);
  case PT_IntAP:
    return emitCopyArrayIntAP(A0, A1, A2, I);
  case PT_IntAPS:
    return emitCopyArrayIntAPS(A0, A1, A2, I);
  case PT_Bool:
    return emitCopyArrayBool(A0, A1, A2, I);
  case PT_FixedPoint:
    return emitCopyArrayFixedPoint(A0, A1, A2, I);
  case PT_Ptr:
    return emitCopyArrayPtr(A0, A1, A2, I);
  case PT_MemberPtr:
    return emitCopyArrayMemberPtr(A0, A1, A2, I);
  case PT_Float:
    return emitCopyArrayFloat(A0, A1, A2, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitCopyArraySint8( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArraySint8, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayUint8( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayUint8, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArraySint16( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArraySint16, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayUint16( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayUint16, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArraySint32( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArraySint32, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayUint32( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayUint32, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArraySint64( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArraySint64, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayUint64( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayUint64, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayIntAP( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayIntAP, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayIntAPS( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayIntAPS, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayBool( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayBool, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayFixedPoint( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayFixedPoint, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayPtr( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayPtr, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayMemberPtr( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayMemberPtr, A0, A1, A2, L);
}
bool ByteCodeEmitter::emitCopyArrayFloat( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  return emitOp<uint32_t, uint32_t, uint32_t>(OP_CopyArrayFloat, A0, A1, A2, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitCopyArraySint8( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Sint8>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayUint8( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Uint8>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArraySint16( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Sint16>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayUint16( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Uint16>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArraySint32( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Sint32>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayUint32( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Uint32>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArraySint64( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Sint64>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayUint64( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Uint64>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayIntAP( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_IntAP>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayIntAPS( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_IntAPS>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayBool( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Bool>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayFixedPoint( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_FixedPoint>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayPtr( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Ptr>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayMemberPtr( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_MemberPtr>(S, OpPC, A0, A1, A2);
}
bool EvalEmitter::emitCopyArrayFloat( uint32_t A0,  uint32_t A1,  uint32_t A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return CopyArray<PT_Float>(S, OpPC, A0, A1, A2);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DecSint8,
OP_DecUint8,
OP_DecSint16,
OP_DecUint16,
OP_DecSint32,
OP_DecUint32,
OP_DecSint64,
OP_DecUint64,
OP_DecIntAP,
OP_DecIntAPS,
OP_DecBool,
OP_DecFixedPoint,
#endif
#ifdef GET_INTERP
case OP_DecSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Dec<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DecSint8:
  Text.Op = PrintName("DecSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecUint8:
  Text.Op = PrintName("DecUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecSint16:
  Text.Op = PrintName("DecSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecUint16:
  Text.Op = PrintName("DecUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecSint32:
  Text.Op = PrintName("DecSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecUint32:
  Text.Op = PrintName("DecUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecSint64:
  Text.Op = PrintName("DecSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecUint64:
  Text.Op = PrintName("DecUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecIntAP:
  Text.Op = PrintName("DecIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecIntAPS:
  Text.Op = PrintName("DecIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecBool:
  Text.Op = PrintName("DecBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecFixedPoint:
  Text.Op = PrintName("DecFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecSint8( bool , SourceInfo);
bool emitDecUint8( bool , SourceInfo);
bool emitDecSint16( bool , SourceInfo);
bool emitDecUint16( bool , SourceInfo);
bool emitDecSint32( bool , SourceInfo);
bool emitDecUint32( bool , SourceInfo);
bool emitDecSint64( bool , SourceInfo);
bool emitDecUint64( bool , SourceInfo);
bool emitDecIntAP( bool , SourceInfo);
bool emitDecIntAPS( bool , SourceInfo);
bool emitDecBool( bool , SourceInfo);
bool emitDecFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDec(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDec(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitDecSint8(A0, I);
  case PT_Uint8:
    return emitDecUint8(A0, I);
  case PT_Sint16:
    return emitDecSint16(A0, I);
  case PT_Uint16:
    return emitDecUint16(A0, I);
  case PT_Sint32:
    return emitDecSint32(A0, I);
  case PT_Uint32:
    return emitDecUint32(A0, I);
  case PT_Sint64:
    return emitDecSint64(A0, I);
  case PT_Uint64:
    return emitDecUint64(A0, I);
  case PT_IntAP:
    return emitDecIntAP(A0, I);
  case PT_IntAPS:
    return emitDecIntAPS(A0, I);
  case PT_Bool:
    return emitDecBool(A0, I);
  case PT_FixedPoint:
    return emitDecFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitDec");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecSint8, A0, L);
}
bool ByteCodeEmitter::emitDecUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecUint8, A0, L);
}
bool ByteCodeEmitter::emitDecSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecSint16, A0, L);
}
bool ByteCodeEmitter::emitDecUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecUint16, A0, L);
}
bool ByteCodeEmitter::emitDecSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecSint32, A0, L);
}
bool ByteCodeEmitter::emitDecUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecUint32, A0, L);
}
bool ByteCodeEmitter::emitDecSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecSint64, A0, L);
}
bool ByteCodeEmitter::emitDecUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecUint64, A0, L);
}
bool ByteCodeEmitter::emitDecIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecIntAP, A0, L);
}
bool ByteCodeEmitter::emitDecIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecIntAPS, A0, L);
}
bool ByteCodeEmitter::emitDecBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecBool, A0, L);
}
bool ByteCodeEmitter::emitDecFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitDecUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitDecSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitDecUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitDecSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitDecUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitDecSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitDecUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitDecIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitDecIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitDecBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitDecFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dec<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DecPopSint8,
OP_DecPopUint8,
OP_DecPopSint16,
OP_DecPopUint16,
OP_DecPopSint32,
OP_DecPopUint32,
OP_DecPopSint64,
OP_DecPopUint64,
OP_DecPopIntAP,
OP_DecPopIntAPS,
OP_DecPopBool,
OP_DecPopFixedPoint,
#endif
#ifdef GET_INTERP
case OP_DecPopSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_DecPopFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!DecPop<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DecPopSint8:
  Text.Op = PrintName("DecPopSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopUint8:
  Text.Op = PrintName("DecPopUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopSint16:
  Text.Op = PrintName("DecPopSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopUint16:
  Text.Op = PrintName("DecPopUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopSint32:
  Text.Op = PrintName("DecPopSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopUint32:
  Text.Op = PrintName("DecPopUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopSint64:
  Text.Op = PrintName("DecPopSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopUint64:
  Text.Op = PrintName("DecPopUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopIntAP:
  Text.Op = PrintName("DecPopIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopIntAPS:
  Text.Op = PrintName("DecPopIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopBool:
  Text.Op = PrintName("DecPopBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_DecPopFixedPoint:
  Text.Op = PrintName("DecPopFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecPopSint8( bool , SourceInfo);
bool emitDecPopUint8( bool , SourceInfo);
bool emitDecPopSint16( bool , SourceInfo);
bool emitDecPopUint16( bool , SourceInfo);
bool emitDecPopSint32( bool , SourceInfo);
bool emitDecPopUint32( bool , SourceInfo);
bool emitDecPopSint64( bool , SourceInfo);
bool emitDecPopUint64( bool , SourceInfo);
bool emitDecPopIntAP( bool , SourceInfo);
bool emitDecPopIntAPS( bool , SourceInfo);
bool emitDecPopBool( bool , SourceInfo);
bool emitDecPopFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDecPop(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDecPop(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitDecPopSint8(A0, I);
  case PT_Uint8:
    return emitDecPopUint8(A0, I);
  case PT_Sint16:
    return emitDecPopSint16(A0, I);
  case PT_Uint16:
    return emitDecPopUint16(A0, I);
  case PT_Sint32:
    return emitDecPopSint32(A0, I);
  case PT_Uint32:
    return emitDecPopUint32(A0, I);
  case PT_Sint64:
    return emitDecPopSint64(A0, I);
  case PT_Uint64:
    return emitDecPopUint64(A0, I);
  case PT_IntAP:
    return emitDecPopIntAP(A0, I);
  case PT_IntAPS:
    return emitDecPopIntAPS(A0, I);
  case PT_Bool:
    return emitDecPopBool(A0, I);
  case PT_FixedPoint:
    return emitDecPopFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitDecPop");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecPopSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopSint8, A0, L);
}
bool ByteCodeEmitter::emitDecPopUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopUint8, A0, L);
}
bool ByteCodeEmitter::emitDecPopSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopSint16, A0, L);
}
bool ByteCodeEmitter::emitDecPopUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopUint16, A0, L);
}
bool ByteCodeEmitter::emitDecPopSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopSint32, A0, L);
}
bool ByteCodeEmitter::emitDecPopUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopUint32, A0, L);
}
bool ByteCodeEmitter::emitDecPopSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopSint64, A0, L);
}
bool ByteCodeEmitter::emitDecPopUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopUint64, A0, L);
}
bool ByteCodeEmitter::emitDecPopIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopIntAP, A0, L);
}
bool ByteCodeEmitter::emitDecPopIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopIntAPS, A0, L);
}
bool ByteCodeEmitter::emitDecPopBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopBool, A0, L);
}
bool ByteCodeEmitter::emitDecPopFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_DecPopFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecPopSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitDecPopFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPop<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DecPtr,
#endif
#ifdef GET_INTERP
case OP_DecPtr: {
  if (!DecPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DecPtr:
  Text.Op = PrintName("DecPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecPtr(SourceInfo L) {
  return emitOp<>(OP_DecPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DecayPtrPtrPtr,
OP_DecayPtrPtrMemberPtr,
OP_DecayPtrMemberPtrPtr,
OP_DecayPtrMemberPtrMemberPtr,
#endif
#ifdef GET_INTERP
case OP_DecayPtrPtrPtr: {
  if (!DecayPtr<PT_Ptr, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_DecayPtrPtrMemberPtr: {
  if (!DecayPtr<PT_Ptr, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_DecayPtrMemberPtrPtr: {
  if (!DecayPtr<PT_MemberPtr, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_DecayPtrMemberPtrMemberPtr: {
  if (!DecayPtr<PT_MemberPtr, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DecayPtrPtrPtr:
  Text.Op = PrintName("DecayPtrPtrPtr");
  break;
case OP_DecayPtrPtrMemberPtr:
  Text.Op = PrintName("DecayPtrPtrMemberPtr");
  break;
case OP_DecayPtrMemberPtrPtr:
  Text.Op = PrintName("DecayPtrMemberPtrPtr");
  break;
case OP_DecayPtrMemberPtrMemberPtr:
  Text.Op = PrintName("DecayPtrMemberPtrMemberPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecayPtrPtrPtr(SourceInfo);
bool emitDecayPtrPtrMemberPtr(SourceInfo);
bool emitDecayPtrMemberPtrPtr(SourceInfo);
bool emitDecayPtrMemberPtrMemberPtr(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDecayPtr(PrimType, PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDecayPtr(PrimType T0, PrimType T1, SourceInfo I) {
  switch (T0) {
  case PT_Ptr:
  switch (T1) {
  case PT_Ptr:
    return emitDecayPtrPtrPtr(I);
  case PT_MemberPtr:
    return emitDecayPtrPtrMemberPtr(I);
  default: llvm_unreachable("invalid type: emitDecayPtr");
  }
  llvm_unreachable("invalid enum value");
  case PT_MemberPtr:
  switch (T1) {
  case PT_Ptr:
    return emitDecayPtrMemberPtrPtr(I);
  case PT_MemberPtr:
    return emitDecayPtrMemberPtrMemberPtr(I);
  default: llvm_unreachable("invalid type: emitDecayPtr");
  }
  llvm_unreachable("invalid enum value");
  default: llvm_unreachable("invalid type: emitDecayPtr");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecayPtrPtrPtr(SourceInfo L) {
  return emitOp<>(OP_DecayPtrPtrPtr, L);
}
bool ByteCodeEmitter::emitDecayPtrPtrMemberPtr(SourceInfo L) {
  return emitOp<>(OP_DecayPtrPtrMemberPtr, L);
}
bool ByteCodeEmitter::emitDecayPtrMemberPtrPtr(SourceInfo L) {
  return emitOp<>(OP_DecayPtrMemberPtrPtr, L);
}
bool ByteCodeEmitter::emitDecayPtrMemberPtrMemberPtr(SourceInfo L) {
  return emitOp<>(OP_DecayPtrMemberPtrMemberPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecayPtrPtrPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecayPtr<PT_Ptr, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitDecayPtrPtrMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecayPtr<PT_Ptr, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitDecayPtrMemberPtrPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecayPtr<PT_MemberPtr, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitDecayPtrMemberPtrMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecayPtr<PT_MemberPtr, PT_MemberPtr>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Decf,
#endif
#ifdef GET_INTERP
case OP_Decf: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Decf(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Decf:
  Text.Op = PrintName("Decf");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecf( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecf( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Decf, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecf( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Decf(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DecfPop,
#endif
#ifdef GET_INTERP
case OP_DecfPop: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!DecfPop(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DecfPop:
  Text.Op = PrintName("DecfPop");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDecfPop( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDecfPop( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_DecfPop, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDecfPop( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DecfPop(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Destroy,
#endif
#ifdef GET_INTERP
case OP_Destroy: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Destroy(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Destroy:
  Text.Op = PrintName("Destroy");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDestroy( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDestroy( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Destroy, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DiagTypeid,
#endif
#ifdef GET_INTERP
case OP_DiagTypeid: {
  if (!DiagTypeid(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DiagTypeid:
  Text.Op = PrintName("DiagTypeid");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDiagTypeid(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDiagTypeid(SourceInfo L) {
  return emitOp<>(OP_DiagTypeid, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDiagTypeid(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return DiagTypeid(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DivSint8,
OP_DivUint8,
OP_DivSint16,
OP_DivUint16,
OP_DivSint32,
OP_DivUint32,
OP_DivSint64,
OP_DivUint64,
OP_DivIntAP,
OP_DivIntAPS,
OP_DivFixedPoint,
#endif
#ifdef GET_INTERP
case OP_DivSint8: {
  if (!Div<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_DivUint8: {
  if (!Div<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_DivSint16: {
  if (!Div<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_DivUint16: {
  if (!Div<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_DivSint32: {
  if (!Div<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_DivUint32: {
  if (!Div<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_DivSint64: {
  if (!Div<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_DivUint64: {
  if (!Div<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_DivIntAP: {
  if (!Div<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_DivIntAPS: {
  if (!Div<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_DivFixedPoint: {
  if (!Div<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DivSint8:
  Text.Op = PrintName("DivSint8");
  break;
case OP_DivUint8:
  Text.Op = PrintName("DivUint8");
  break;
case OP_DivSint16:
  Text.Op = PrintName("DivSint16");
  break;
case OP_DivUint16:
  Text.Op = PrintName("DivUint16");
  break;
case OP_DivSint32:
  Text.Op = PrintName("DivSint32");
  break;
case OP_DivUint32:
  Text.Op = PrintName("DivUint32");
  break;
case OP_DivSint64:
  Text.Op = PrintName("DivSint64");
  break;
case OP_DivUint64:
  Text.Op = PrintName("DivUint64");
  break;
case OP_DivIntAP:
  Text.Op = PrintName("DivIntAP");
  break;
case OP_DivIntAPS:
  Text.Op = PrintName("DivIntAPS");
  break;
case OP_DivFixedPoint:
  Text.Op = PrintName("DivFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDivSint8(SourceInfo);
bool emitDivUint8(SourceInfo);
bool emitDivSint16(SourceInfo);
bool emitDivUint16(SourceInfo);
bool emitDivSint32(SourceInfo);
bool emitDivUint32(SourceInfo);
bool emitDivSint64(SourceInfo);
bool emitDivUint64(SourceInfo);
bool emitDivIntAP(SourceInfo);
bool emitDivIntAPS(SourceInfo);
bool emitDivFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDiv(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDiv(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitDivSint8(I);
  case PT_Uint8:
    return emitDivUint8(I);
  case PT_Sint16:
    return emitDivSint16(I);
  case PT_Uint16:
    return emitDivUint16(I);
  case PT_Sint32:
    return emitDivSint32(I);
  case PT_Uint32:
    return emitDivUint32(I);
  case PT_Sint64:
    return emitDivSint64(I);
  case PT_Uint64:
    return emitDivUint64(I);
  case PT_IntAP:
    return emitDivIntAP(I);
  case PT_IntAPS:
    return emitDivIntAPS(I);
  case PT_FixedPoint:
    return emitDivFixedPoint(I);
  default: llvm_unreachable("invalid type: emitDiv");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDivSint8(SourceInfo L) {
  return emitOp<>(OP_DivSint8, L);
}
bool ByteCodeEmitter::emitDivUint8(SourceInfo L) {
  return emitOp<>(OP_DivUint8, L);
}
bool ByteCodeEmitter::emitDivSint16(SourceInfo L) {
  return emitOp<>(OP_DivSint16, L);
}
bool ByteCodeEmitter::emitDivUint16(SourceInfo L) {
  return emitOp<>(OP_DivUint16, L);
}
bool ByteCodeEmitter::emitDivSint32(SourceInfo L) {
  return emitOp<>(OP_DivSint32, L);
}
bool ByteCodeEmitter::emitDivUint32(SourceInfo L) {
  return emitOp<>(OP_DivUint32, L);
}
bool ByteCodeEmitter::emitDivSint64(SourceInfo L) {
  return emitOp<>(OP_DivSint64, L);
}
bool ByteCodeEmitter::emitDivUint64(SourceInfo L) {
  return emitOp<>(OP_DivUint64, L);
}
bool ByteCodeEmitter::emitDivIntAP(SourceInfo L) {
  return emitOp<>(OP_DivIntAP, L);
}
bool ByteCodeEmitter::emitDivIntAPS(SourceInfo L) {
  return emitOp<>(OP_DivIntAPS, L);
}
bool ByteCodeEmitter::emitDivFixedPoint(SourceInfo L) {
  return emitOp<>(OP_DivFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDivSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitDivUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitDivSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitDivUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitDivSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitDivUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitDivSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitDivUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitDivIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitDivIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitDivFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Div<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DivcSint8,
OP_DivcUint8,
OP_DivcSint16,
OP_DivcUint16,
OP_DivcSint32,
OP_DivcUint32,
OP_DivcSint64,
OP_DivcUint64,
OP_DivcIntAP,
OP_DivcIntAPS,
OP_DivcFloat,
#endif
#ifdef GET_INTERP
case OP_DivcSint8: {
  if (!Divc<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_DivcUint8: {
  if (!Divc<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_DivcSint16: {
  if (!Divc<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_DivcUint16: {
  if (!Divc<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_DivcSint32: {
  if (!Divc<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_DivcUint32: {
  if (!Divc<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_DivcSint64: {
  if (!Divc<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_DivcUint64: {
  if (!Divc<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_DivcIntAP: {
  if (!Divc<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_DivcIntAPS: {
  if (!Divc<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_DivcFloat: {
  if (!Divc<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DivcSint8:
  Text.Op = PrintName("DivcSint8");
  break;
case OP_DivcUint8:
  Text.Op = PrintName("DivcUint8");
  break;
case OP_DivcSint16:
  Text.Op = PrintName("DivcSint16");
  break;
case OP_DivcUint16:
  Text.Op = PrintName("DivcUint16");
  break;
case OP_DivcSint32:
  Text.Op = PrintName("DivcSint32");
  break;
case OP_DivcUint32:
  Text.Op = PrintName("DivcUint32");
  break;
case OP_DivcSint64:
  Text.Op = PrintName("DivcSint64");
  break;
case OP_DivcUint64:
  Text.Op = PrintName("DivcUint64");
  break;
case OP_DivcIntAP:
  Text.Op = PrintName("DivcIntAP");
  break;
case OP_DivcIntAPS:
  Text.Op = PrintName("DivcIntAPS");
  break;
case OP_DivcFloat:
  Text.Op = PrintName("DivcFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDivcSint8(SourceInfo);
bool emitDivcUint8(SourceInfo);
bool emitDivcSint16(SourceInfo);
bool emitDivcUint16(SourceInfo);
bool emitDivcSint32(SourceInfo);
bool emitDivcUint32(SourceInfo);
bool emitDivcSint64(SourceInfo);
bool emitDivcUint64(SourceInfo);
bool emitDivcIntAP(SourceInfo);
bool emitDivcIntAPS(SourceInfo);
bool emitDivcFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDivc(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDivc(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitDivcSint8(I);
  case PT_Uint8:
    return emitDivcUint8(I);
  case PT_Sint16:
    return emitDivcSint16(I);
  case PT_Uint16:
    return emitDivcUint16(I);
  case PT_Sint32:
    return emitDivcSint32(I);
  case PT_Uint32:
    return emitDivcUint32(I);
  case PT_Sint64:
    return emitDivcSint64(I);
  case PT_Uint64:
    return emitDivcUint64(I);
  case PT_IntAP:
    return emitDivcIntAP(I);
  case PT_IntAPS:
    return emitDivcIntAPS(I);
  case PT_Float:
    return emitDivcFloat(I);
  default: llvm_unreachable("invalid type: emitDivc");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDivcSint8(SourceInfo L) {
  return emitOp<>(OP_DivcSint8, L);
}
bool ByteCodeEmitter::emitDivcUint8(SourceInfo L) {
  return emitOp<>(OP_DivcUint8, L);
}
bool ByteCodeEmitter::emitDivcSint16(SourceInfo L) {
  return emitOp<>(OP_DivcSint16, L);
}
bool ByteCodeEmitter::emitDivcUint16(SourceInfo L) {
  return emitOp<>(OP_DivcUint16, L);
}
bool ByteCodeEmitter::emitDivcSint32(SourceInfo L) {
  return emitOp<>(OP_DivcSint32, L);
}
bool ByteCodeEmitter::emitDivcUint32(SourceInfo L) {
  return emitOp<>(OP_DivcUint32, L);
}
bool ByteCodeEmitter::emitDivcSint64(SourceInfo L) {
  return emitOp<>(OP_DivcSint64, L);
}
bool ByteCodeEmitter::emitDivcUint64(SourceInfo L) {
  return emitOp<>(OP_DivcUint64, L);
}
bool ByteCodeEmitter::emitDivcIntAP(SourceInfo L) {
  return emitOp<>(OP_DivcIntAP, L);
}
bool ByteCodeEmitter::emitDivcIntAPS(SourceInfo L) {
  return emitOp<>(OP_DivcIntAPS, L);
}
bool ByteCodeEmitter::emitDivcFloat(SourceInfo L) {
  return emitOp<>(OP_DivcFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDivcSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitDivcUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitDivcSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitDivcUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitDivcSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitDivcUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitDivcSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitDivcUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitDivcIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitDivcIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitDivcFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divc<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Divf,
#endif
#ifdef GET_INTERP
case OP_Divf: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Divf(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Divf:
  Text.Op = PrintName("Divf");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDivf( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDivf( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Divf, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDivf( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Divf(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Dump,
#endif
#ifdef GET_INTERP
case OP_Dump: {
  if (!Dump(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Dump:
  Text.Op = PrintName("Dump");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDump(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDump(SourceInfo L) {
  return emitOp<>(OP_Dump, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDump(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dump(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_DupSint8,
OP_DupUint8,
OP_DupSint16,
OP_DupUint16,
OP_DupSint32,
OP_DupUint32,
OP_DupSint64,
OP_DupUint64,
OP_DupIntAP,
OP_DupIntAPS,
OP_DupBool,
OP_DupFixedPoint,
OP_DupPtr,
OP_DupMemberPtr,
OP_DupFloat,
#endif
#ifdef GET_INTERP
case OP_DupSint8: {
  if (!Dup<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_DupUint8: {
  if (!Dup<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_DupSint16: {
  if (!Dup<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_DupUint16: {
  if (!Dup<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_DupSint32: {
  if (!Dup<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_DupUint32: {
  if (!Dup<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_DupSint64: {
  if (!Dup<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_DupUint64: {
  if (!Dup<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_DupIntAP: {
  if (!Dup<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_DupIntAPS: {
  if (!Dup<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_DupBool: {
  if (!Dup<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_DupFixedPoint: {
  if (!Dup<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_DupPtr: {
  if (!Dup<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_DupMemberPtr: {
  if (!Dup<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_DupFloat: {
  if (!Dup<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_DupSint8:
  Text.Op = PrintName("DupSint8");
  break;
case OP_DupUint8:
  Text.Op = PrintName("DupUint8");
  break;
case OP_DupSint16:
  Text.Op = PrintName("DupSint16");
  break;
case OP_DupUint16:
  Text.Op = PrintName("DupUint16");
  break;
case OP_DupSint32:
  Text.Op = PrintName("DupSint32");
  break;
case OP_DupUint32:
  Text.Op = PrintName("DupUint32");
  break;
case OP_DupSint64:
  Text.Op = PrintName("DupSint64");
  break;
case OP_DupUint64:
  Text.Op = PrintName("DupUint64");
  break;
case OP_DupIntAP:
  Text.Op = PrintName("DupIntAP");
  break;
case OP_DupIntAPS:
  Text.Op = PrintName("DupIntAPS");
  break;
case OP_DupBool:
  Text.Op = PrintName("DupBool");
  break;
case OP_DupFixedPoint:
  Text.Op = PrintName("DupFixedPoint");
  break;
case OP_DupPtr:
  Text.Op = PrintName("DupPtr");
  break;
case OP_DupMemberPtr:
  Text.Op = PrintName("DupMemberPtr");
  break;
case OP_DupFloat:
  Text.Op = PrintName("DupFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitDupSint8(SourceInfo);
bool emitDupUint8(SourceInfo);
bool emitDupSint16(SourceInfo);
bool emitDupUint16(SourceInfo);
bool emitDupSint32(SourceInfo);
bool emitDupUint32(SourceInfo);
bool emitDupSint64(SourceInfo);
bool emitDupUint64(SourceInfo);
bool emitDupIntAP(SourceInfo);
bool emitDupIntAPS(SourceInfo);
bool emitDupBool(SourceInfo);
bool emitDupFixedPoint(SourceInfo);
bool emitDupPtr(SourceInfo);
bool emitDupMemberPtr(SourceInfo);
bool emitDupFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitDup(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitDup(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitDupSint8(I);
  case PT_Uint8:
    return emitDupUint8(I);
  case PT_Sint16:
    return emitDupSint16(I);
  case PT_Uint16:
    return emitDupUint16(I);
  case PT_Sint32:
    return emitDupSint32(I);
  case PT_Uint32:
    return emitDupUint32(I);
  case PT_Sint64:
    return emitDupSint64(I);
  case PT_Uint64:
    return emitDupUint64(I);
  case PT_IntAP:
    return emitDupIntAP(I);
  case PT_IntAPS:
    return emitDupIntAPS(I);
  case PT_Bool:
    return emitDupBool(I);
  case PT_FixedPoint:
    return emitDupFixedPoint(I);
  case PT_Ptr:
    return emitDupPtr(I);
  case PT_MemberPtr:
    return emitDupMemberPtr(I);
  case PT_Float:
    return emitDupFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitDupSint8(SourceInfo L) {
  return emitOp<>(OP_DupSint8, L);
}
bool ByteCodeEmitter::emitDupUint8(SourceInfo L) {
  return emitOp<>(OP_DupUint8, L);
}
bool ByteCodeEmitter::emitDupSint16(SourceInfo L) {
  return emitOp<>(OP_DupSint16, L);
}
bool ByteCodeEmitter::emitDupUint16(SourceInfo L) {
  return emitOp<>(OP_DupUint16, L);
}
bool ByteCodeEmitter::emitDupSint32(SourceInfo L) {
  return emitOp<>(OP_DupSint32, L);
}
bool ByteCodeEmitter::emitDupUint32(SourceInfo L) {
  return emitOp<>(OP_DupUint32, L);
}
bool ByteCodeEmitter::emitDupSint64(SourceInfo L) {
  return emitOp<>(OP_DupSint64, L);
}
bool ByteCodeEmitter::emitDupUint64(SourceInfo L) {
  return emitOp<>(OP_DupUint64, L);
}
bool ByteCodeEmitter::emitDupIntAP(SourceInfo L) {
  return emitOp<>(OP_DupIntAP, L);
}
bool ByteCodeEmitter::emitDupIntAPS(SourceInfo L) {
  return emitOp<>(OP_DupIntAPS, L);
}
bool ByteCodeEmitter::emitDupBool(SourceInfo L) {
  return emitOp<>(OP_DupBool, L);
}
bool ByteCodeEmitter::emitDupFixedPoint(SourceInfo L) {
  return emitOp<>(OP_DupFixedPoint, L);
}
bool ByteCodeEmitter::emitDupPtr(SourceInfo L) {
  return emitOp<>(OP_DupPtr, L);
}
bool ByteCodeEmitter::emitDupMemberPtr(SourceInfo L) {
  return emitOp<>(OP_DupMemberPtr, L);
}
bool ByteCodeEmitter::emitDupFloat(SourceInfo L) {
  return emitOp<>(OP_DupFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitDupSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitDupUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitDupSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitDupUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitDupSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitDupUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitDupSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitDupUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitDupIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitDupIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitDupBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitDupFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitDupPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitDupMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitDupFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Dup<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_EQSint8,
OP_EQUint8,
OP_EQSint16,
OP_EQUint16,
OP_EQSint32,
OP_EQUint32,
OP_EQSint64,
OP_EQUint64,
OP_EQIntAP,
OP_EQIntAPS,
OP_EQBool,
OP_EQFixedPoint,
OP_EQPtr,
OP_EQMemberPtr,
OP_EQFloat,
#endif
#ifdef GET_INTERP
case OP_EQSint8: {
  if (!EQ<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_EQUint8: {
  if (!EQ<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_EQSint16: {
  if (!EQ<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_EQUint16: {
  if (!EQ<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_EQSint32: {
  if (!EQ<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_EQUint32: {
  if (!EQ<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_EQSint64: {
  if (!EQ<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_EQUint64: {
  if (!EQ<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_EQIntAP: {
  if (!EQ<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_EQIntAPS: {
  if (!EQ<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_EQBool: {
  if (!EQ<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_EQFixedPoint: {
  if (!EQ<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_EQPtr: {
  if (!EQ<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_EQMemberPtr: {
  if (!EQ<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_EQFloat: {
  if (!EQ<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_EQSint8:
  Text.Op = PrintName("EQSint8");
  break;
case OP_EQUint8:
  Text.Op = PrintName("EQUint8");
  break;
case OP_EQSint16:
  Text.Op = PrintName("EQSint16");
  break;
case OP_EQUint16:
  Text.Op = PrintName("EQUint16");
  break;
case OP_EQSint32:
  Text.Op = PrintName("EQSint32");
  break;
case OP_EQUint32:
  Text.Op = PrintName("EQUint32");
  break;
case OP_EQSint64:
  Text.Op = PrintName("EQSint64");
  break;
case OP_EQUint64:
  Text.Op = PrintName("EQUint64");
  break;
case OP_EQIntAP:
  Text.Op = PrintName("EQIntAP");
  break;
case OP_EQIntAPS:
  Text.Op = PrintName("EQIntAPS");
  break;
case OP_EQBool:
  Text.Op = PrintName("EQBool");
  break;
case OP_EQFixedPoint:
  Text.Op = PrintName("EQFixedPoint");
  break;
case OP_EQPtr:
  Text.Op = PrintName("EQPtr");
  break;
case OP_EQMemberPtr:
  Text.Op = PrintName("EQMemberPtr");
  break;
case OP_EQFloat:
  Text.Op = PrintName("EQFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitEQSint8(SourceInfo);
bool emitEQUint8(SourceInfo);
bool emitEQSint16(SourceInfo);
bool emitEQUint16(SourceInfo);
bool emitEQSint32(SourceInfo);
bool emitEQUint32(SourceInfo);
bool emitEQSint64(SourceInfo);
bool emitEQUint64(SourceInfo);
bool emitEQIntAP(SourceInfo);
bool emitEQIntAPS(SourceInfo);
bool emitEQBool(SourceInfo);
bool emitEQFixedPoint(SourceInfo);
bool emitEQPtr(SourceInfo);
bool emitEQMemberPtr(SourceInfo);
bool emitEQFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitEQ(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitEQ(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitEQSint8(I);
  case PT_Uint8:
    return emitEQUint8(I);
  case PT_Sint16:
    return emitEQSint16(I);
  case PT_Uint16:
    return emitEQUint16(I);
  case PT_Sint32:
    return emitEQSint32(I);
  case PT_Uint32:
    return emitEQUint32(I);
  case PT_Sint64:
    return emitEQSint64(I);
  case PT_Uint64:
    return emitEQUint64(I);
  case PT_IntAP:
    return emitEQIntAP(I);
  case PT_IntAPS:
    return emitEQIntAPS(I);
  case PT_Bool:
    return emitEQBool(I);
  case PT_FixedPoint:
    return emitEQFixedPoint(I);
  case PT_Ptr:
    return emitEQPtr(I);
  case PT_MemberPtr:
    return emitEQMemberPtr(I);
  case PT_Float:
    return emitEQFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitEQSint8(SourceInfo L) {
  return emitOp<>(OP_EQSint8, L);
}
bool ByteCodeEmitter::emitEQUint8(SourceInfo L) {
  return emitOp<>(OP_EQUint8, L);
}
bool ByteCodeEmitter::emitEQSint16(SourceInfo L) {
  return emitOp<>(OP_EQSint16, L);
}
bool ByteCodeEmitter::emitEQUint16(SourceInfo L) {
  return emitOp<>(OP_EQUint16, L);
}
bool ByteCodeEmitter::emitEQSint32(SourceInfo L) {
  return emitOp<>(OP_EQSint32, L);
}
bool ByteCodeEmitter::emitEQUint32(SourceInfo L) {
  return emitOp<>(OP_EQUint32, L);
}
bool ByteCodeEmitter::emitEQSint64(SourceInfo L) {
  return emitOp<>(OP_EQSint64, L);
}
bool ByteCodeEmitter::emitEQUint64(SourceInfo L) {
  return emitOp<>(OP_EQUint64, L);
}
bool ByteCodeEmitter::emitEQIntAP(SourceInfo L) {
  return emitOp<>(OP_EQIntAP, L);
}
bool ByteCodeEmitter::emitEQIntAPS(SourceInfo L) {
  return emitOp<>(OP_EQIntAPS, L);
}
bool ByteCodeEmitter::emitEQBool(SourceInfo L) {
  return emitOp<>(OP_EQBool, L);
}
bool ByteCodeEmitter::emitEQFixedPoint(SourceInfo L) {
  return emitOp<>(OP_EQFixedPoint, L);
}
bool ByteCodeEmitter::emitEQPtr(SourceInfo L) {
  return emitOp<>(OP_EQPtr, L);
}
bool ByteCodeEmitter::emitEQMemberPtr(SourceInfo L) {
  return emitOp<>(OP_EQMemberPtr, L);
}
bool ByteCodeEmitter::emitEQFloat(SourceInfo L) {
  return emitOp<>(OP_EQFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitEQSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitEQUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitEQSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitEQUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitEQSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitEQUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitEQSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitEQUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitEQIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitEQIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitEQBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitEQFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitEQPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitEQMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitEQFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EQ<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_EndLifetime,
#endif
#ifdef GET_INTERP
case OP_EndLifetime: {
  if (!EndLifetime(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_EndLifetime:
  Text.Op = PrintName("EndLifetime");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitEndLifetime(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitEndLifetime(SourceInfo L) {
  return emitOp<>(OP_EndLifetime, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitEndLifetime(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EndLifetime(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_EndLifetimePop,
#endif
#ifdef GET_INTERP
case OP_EndLifetimePop: {
  if (!EndLifetimePop(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_EndLifetimePop:
  Text.Op = PrintName("EndLifetimePop");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitEndLifetimePop(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitEndLifetimePop(SourceInfo L) {
  return emitOp<>(OP_EndLifetimePop, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitEndLifetimePop(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EndLifetimePop(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_EndSpeculation,
#endif
#ifdef GET_INTERP
case OP_EndSpeculation: {
  if (!EndSpeculation(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_EndSpeculation:
  Text.Op = PrintName("EndSpeculation");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitEndSpeculation(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitEndSpeculation(SourceInfo L) {
  return emitOp<>(OP_EndSpeculation, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitEndSpeculation(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return EndSpeculation(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Error,
#endif
#ifdef GET_INTERP
case OP_Error: {
  if (!Error(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Error:
  Text.Op = PrintName("Error");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitError(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitError(SourceInfo L) {
  return emitOp<>(OP_Error, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitError(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Error(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ExpandPtr,
#endif
#ifdef GET_INTERP
case OP_ExpandPtr: {
  if (!ExpandPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ExpandPtr:
  Text.Op = PrintName("ExpandPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitExpandPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitExpandPtr(SourceInfo L) {
  return emitOp<>(OP_ExpandPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitExpandPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ExpandPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FinishInit,
#endif
#ifdef GET_INTERP
case OP_FinishInit: {
  if (!FinishInit(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FinishInit:
  Text.Op = PrintName("FinishInit");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFinishInit(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFinishInit(SourceInfo L) {
  return emitOp<>(OP_FinishInit, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFinishInit(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FinishInit(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FinishInitActivate,
#endif
#ifdef GET_INTERP
case OP_FinishInitActivate: {
  if (!FinishInitActivate(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FinishInitActivate:
  Text.Op = PrintName("FinishInitActivate");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFinishInitActivate(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFinishInitActivate(SourceInfo L) {
  return emitOp<>(OP_FinishInitActivate, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFinishInitActivate(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FinishInitActivate(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FinishInitActivatePop,
#endif
#ifdef GET_INTERP
case OP_FinishInitActivatePop: {
  if (!FinishInitActivatePop(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FinishInitActivatePop:
  Text.Op = PrintName("FinishInitActivatePop");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFinishInitActivatePop(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFinishInitActivatePop(SourceInfo L) {
  return emitOp<>(OP_FinishInitActivatePop, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFinishInitActivatePop(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FinishInitActivatePop(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FinishInitGlobal,
#endif
#ifdef GET_INTERP
case OP_FinishInitGlobal: {
  if (!FinishInitGlobal(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FinishInitGlobal:
  Text.Op = PrintName("FinishInitGlobal");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFinishInitGlobal(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFinishInitGlobal(SourceInfo L) {
  return emitOp<>(OP_FinishInitGlobal, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFinishInitGlobal(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FinishInitGlobal(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FinishInitPop,
#endif
#ifdef GET_INTERP
case OP_FinishInitPop: {
  if (!FinishInitPop(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FinishInitPop:
  Text.Op = PrintName("FinishInitPop");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFinishInitPop(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFinishInitPop(SourceInfo L) {
  return emitOp<>(OP_FinishInitPop, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFinishInitPop(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FinishInitPop(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FlipSint8Sint8,
OP_FlipSint8Uint8,
OP_FlipSint8Sint16,
OP_FlipSint8Uint16,
OP_FlipSint8Sint32,
OP_FlipSint8Uint32,
OP_FlipSint8Sint64,
OP_FlipSint8Uint64,
OP_FlipSint8IntAP,
OP_FlipSint8IntAPS,
OP_FlipSint8Bool,
OP_FlipSint8FixedPoint,
OP_FlipSint8Ptr,
OP_FlipSint8MemberPtr,
OP_FlipSint8Float,
OP_FlipUint8Sint8,
OP_FlipUint8Uint8,
OP_FlipUint8Sint16,
OP_FlipUint8Uint16,
OP_FlipUint8Sint32,
OP_FlipUint8Uint32,
OP_FlipUint8Sint64,
OP_FlipUint8Uint64,
OP_FlipUint8IntAP,
OP_FlipUint8IntAPS,
OP_FlipUint8Bool,
OP_FlipUint8FixedPoint,
OP_FlipUint8Ptr,
OP_FlipUint8MemberPtr,
OP_FlipUint8Float,
OP_FlipSint16Sint8,
OP_FlipSint16Uint8,
OP_FlipSint16Sint16,
OP_FlipSint16Uint16,
OP_FlipSint16Sint32,
OP_FlipSint16Uint32,
OP_FlipSint16Sint64,
OP_FlipSint16Uint64,
OP_FlipSint16IntAP,
OP_FlipSint16IntAPS,
OP_FlipSint16Bool,
OP_FlipSint16FixedPoint,
OP_FlipSint16Ptr,
OP_FlipSint16MemberPtr,
OP_FlipSint16Float,
OP_FlipUint16Sint8,
OP_FlipUint16Uint8,
OP_FlipUint16Sint16,
OP_FlipUint16Uint16,
OP_FlipUint16Sint32,
OP_FlipUint16Uint32,
OP_FlipUint16Sint64,
OP_FlipUint16Uint64,
OP_FlipUint16IntAP,
OP_FlipUint16IntAPS,
OP_FlipUint16Bool,
OP_FlipUint16FixedPoint,
OP_FlipUint16Ptr,
OP_FlipUint16MemberPtr,
OP_FlipUint16Float,
OP_FlipSint32Sint8,
OP_FlipSint32Uint8,
OP_FlipSint32Sint16,
OP_FlipSint32Uint16,
OP_FlipSint32Sint32,
OP_FlipSint32Uint32,
OP_FlipSint32Sint64,
OP_FlipSint32Uint64,
OP_FlipSint32IntAP,
OP_FlipSint32IntAPS,
OP_FlipSint32Bool,
OP_FlipSint32FixedPoint,
OP_FlipSint32Ptr,
OP_FlipSint32MemberPtr,
OP_FlipSint32Float,
OP_FlipUint32Sint8,
OP_FlipUint32Uint8,
OP_FlipUint32Sint16,
OP_FlipUint32Uint16,
OP_FlipUint32Sint32,
OP_FlipUint32Uint32,
OP_FlipUint32Sint64,
OP_FlipUint32Uint64,
OP_FlipUint32IntAP,
OP_FlipUint32IntAPS,
OP_FlipUint32Bool,
OP_FlipUint32FixedPoint,
OP_FlipUint32Ptr,
OP_FlipUint32MemberPtr,
OP_FlipUint32Float,
OP_FlipSint64Sint8,
OP_FlipSint64Uint8,
OP_FlipSint64Sint16,
OP_FlipSint64Uint16,
OP_FlipSint64Sint32,
OP_FlipSint64Uint32,
OP_FlipSint64Sint64,
OP_FlipSint64Uint64,
OP_FlipSint64IntAP,
OP_FlipSint64IntAPS,
OP_FlipSint64Bool,
OP_FlipSint64FixedPoint,
OP_FlipSint64Ptr,
OP_FlipSint64MemberPtr,
OP_FlipSint64Float,
OP_FlipUint64Sint8,
OP_FlipUint64Uint8,
OP_FlipUint64Sint16,
OP_FlipUint64Uint16,
OP_FlipUint64Sint32,
OP_FlipUint64Uint32,
OP_FlipUint64Sint64,
OP_FlipUint64Uint64,
OP_FlipUint64IntAP,
OP_FlipUint64IntAPS,
OP_FlipUint64Bool,
OP_FlipUint64FixedPoint,
OP_FlipUint64Ptr,
OP_FlipUint64MemberPtr,
OP_FlipUint64Float,
OP_FlipIntAPSint8,
OP_FlipIntAPUint8,
OP_FlipIntAPSint16,
OP_FlipIntAPUint16,
OP_FlipIntAPSint32,
OP_FlipIntAPUint32,
OP_FlipIntAPSint64,
OP_FlipIntAPUint64,
OP_FlipIntAPIntAP,
OP_FlipIntAPIntAPS,
OP_FlipIntAPBool,
OP_FlipIntAPFixedPoint,
OP_FlipIntAPPtr,
OP_FlipIntAPMemberPtr,
OP_FlipIntAPFloat,
OP_FlipIntAPSSint8,
OP_FlipIntAPSUint8,
OP_FlipIntAPSSint16,
OP_FlipIntAPSUint16,
OP_FlipIntAPSSint32,
OP_FlipIntAPSUint32,
OP_FlipIntAPSSint64,
OP_FlipIntAPSUint64,
OP_FlipIntAPSIntAP,
OP_FlipIntAPSIntAPS,
OP_FlipIntAPSBool,
OP_FlipIntAPSFixedPoint,
OP_FlipIntAPSPtr,
OP_FlipIntAPSMemberPtr,
OP_FlipIntAPSFloat,
OP_FlipBoolSint8,
OP_FlipBoolUint8,
OP_FlipBoolSint16,
OP_FlipBoolUint16,
OP_FlipBoolSint32,
OP_FlipBoolUint32,
OP_FlipBoolSint64,
OP_FlipBoolUint64,
OP_FlipBoolIntAP,
OP_FlipBoolIntAPS,
OP_FlipBoolBool,
OP_FlipBoolFixedPoint,
OP_FlipBoolPtr,
OP_FlipBoolMemberPtr,
OP_FlipBoolFloat,
OP_FlipFixedPointSint8,
OP_FlipFixedPointUint8,
OP_FlipFixedPointSint16,
OP_FlipFixedPointUint16,
OP_FlipFixedPointSint32,
OP_FlipFixedPointUint32,
OP_FlipFixedPointSint64,
OP_FlipFixedPointUint64,
OP_FlipFixedPointIntAP,
OP_FlipFixedPointIntAPS,
OP_FlipFixedPointBool,
OP_FlipFixedPointFixedPoint,
OP_FlipFixedPointPtr,
OP_FlipFixedPointMemberPtr,
OP_FlipFixedPointFloat,
OP_FlipPtrSint8,
OP_FlipPtrUint8,
OP_FlipPtrSint16,
OP_FlipPtrUint16,
OP_FlipPtrSint32,
OP_FlipPtrUint32,
OP_FlipPtrSint64,
OP_FlipPtrUint64,
OP_FlipPtrIntAP,
OP_FlipPtrIntAPS,
OP_FlipPtrBool,
OP_FlipPtrFixedPoint,
OP_FlipPtrPtr,
OP_FlipPtrMemberPtr,
OP_FlipPtrFloat,
OP_FlipMemberPtrSint8,
OP_FlipMemberPtrUint8,
OP_FlipMemberPtrSint16,
OP_FlipMemberPtrUint16,
OP_FlipMemberPtrSint32,
OP_FlipMemberPtrUint32,
OP_FlipMemberPtrSint64,
OP_FlipMemberPtrUint64,
OP_FlipMemberPtrIntAP,
OP_FlipMemberPtrIntAPS,
OP_FlipMemberPtrBool,
OP_FlipMemberPtrFixedPoint,
OP_FlipMemberPtrPtr,
OP_FlipMemberPtrMemberPtr,
OP_FlipMemberPtrFloat,
OP_FlipFloatSint8,
OP_FlipFloatUint8,
OP_FlipFloatSint16,
OP_FlipFloatUint16,
OP_FlipFloatSint32,
OP_FlipFloatUint32,
OP_FlipFloatSint64,
OP_FlipFloatUint64,
OP_FlipFloatIntAP,
OP_FlipFloatIntAPS,
OP_FlipFloatBool,
OP_FlipFloatFixedPoint,
OP_FlipFloatPtr,
OP_FlipFloatMemberPtr,
OP_FlipFloatFloat,
#endif
#ifdef GET_INTERP
case OP_FlipSint8Sint8: {
  if (!Flip<PT_Sint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Uint8: {
  if (!Flip<PT_Sint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Sint16: {
  if (!Flip<PT_Sint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Uint16: {
  if (!Flip<PT_Sint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Sint32: {
  if (!Flip<PT_Sint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Uint32: {
  if (!Flip<PT_Sint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Sint64: {
  if (!Flip<PT_Sint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Uint64: {
  if (!Flip<PT_Sint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8IntAP: {
  if (!Flip<PT_Sint8, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8IntAPS: {
  if (!Flip<PT_Sint8, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Bool: {
  if (!Flip<PT_Sint8, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8FixedPoint: {
  if (!Flip<PT_Sint8, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Ptr: {
  if (!Flip<PT_Sint8, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8MemberPtr: {
  if (!Flip<PT_Sint8, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint8Float: {
  if (!Flip<PT_Sint8, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Sint8: {
  if (!Flip<PT_Uint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Uint8: {
  if (!Flip<PT_Uint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Sint16: {
  if (!Flip<PT_Uint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Uint16: {
  if (!Flip<PT_Uint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Sint32: {
  if (!Flip<PT_Uint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Uint32: {
  if (!Flip<PT_Uint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Sint64: {
  if (!Flip<PT_Uint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Uint64: {
  if (!Flip<PT_Uint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8IntAP: {
  if (!Flip<PT_Uint8, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8IntAPS: {
  if (!Flip<PT_Uint8, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Bool: {
  if (!Flip<PT_Uint8, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8FixedPoint: {
  if (!Flip<PT_Uint8, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Ptr: {
  if (!Flip<PT_Uint8, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8MemberPtr: {
  if (!Flip<PT_Uint8, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint8Float: {
  if (!Flip<PT_Uint8, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Sint8: {
  if (!Flip<PT_Sint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Uint8: {
  if (!Flip<PT_Sint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Sint16: {
  if (!Flip<PT_Sint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Uint16: {
  if (!Flip<PT_Sint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Sint32: {
  if (!Flip<PT_Sint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Uint32: {
  if (!Flip<PT_Sint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Sint64: {
  if (!Flip<PT_Sint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Uint64: {
  if (!Flip<PT_Sint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16IntAP: {
  if (!Flip<PT_Sint16, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16IntAPS: {
  if (!Flip<PT_Sint16, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Bool: {
  if (!Flip<PT_Sint16, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16FixedPoint: {
  if (!Flip<PT_Sint16, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Ptr: {
  if (!Flip<PT_Sint16, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16MemberPtr: {
  if (!Flip<PT_Sint16, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint16Float: {
  if (!Flip<PT_Sint16, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Sint8: {
  if (!Flip<PT_Uint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Uint8: {
  if (!Flip<PT_Uint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Sint16: {
  if (!Flip<PT_Uint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Uint16: {
  if (!Flip<PT_Uint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Sint32: {
  if (!Flip<PT_Uint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Uint32: {
  if (!Flip<PT_Uint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Sint64: {
  if (!Flip<PT_Uint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Uint64: {
  if (!Flip<PT_Uint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16IntAP: {
  if (!Flip<PT_Uint16, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16IntAPS: {
  if (!Flip<PT_Uint16, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Bool: {
  if (!Flip<PT_Uint16, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16FixedPoint: {
  if (!Flip<PT_Uint16, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Ptr: {
  if (!Flip<PT_Uint16, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16MemberPtr: {
  if (!Flip<PT_Uint16, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint16Float: {
  if (!Flip<PT_Uint16, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Sint8: {
  if (!Flip<PT_Sint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Uint8: {
  if (!Flip<PT_Sint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Sint16: {
  if (!Flip<PT_Sint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Uint16: {
  if (!Flip<PT_Sint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Sint32: {
  if (!Flip<PT_Sint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Uint32: {
  if (!Flip<PT_Sint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Sint64: {
  if (!Flip<PT_Sint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Uint64: {
  if (!Flip<PT_Sint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32IntAP: {
  if (!Flip<PT_Sint32, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32IntAPS: {
  if (!Flip<PT_Sint32, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Bool: {
  if (!Flip<PT_Sint32, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32FixedPoint: {
  if (!Flip<PT_Sint32, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Ptr: {
  if (!Flip<PT_Sint32, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32MemberPtr: {
  if (!Flip<PT_Sint32, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint32Float: {
  if (!Flip<PT_Sint32, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Sint8: {
  if (!Flip<PT_Uint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Uint8: {
  if (!Flip<PT_Uint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Sint16: {
  if (!Flip<PT_Uint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Uint16: {
  if (!Flip<PT_Uint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Sint32: {
  if (!Flip<PT_Uint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Uint32: {
  if (!Flip<PT_Uint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Sint64: {
  if (!Flip<PT_Uint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Uint64: {
  if (!Flip<PT_Uint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32IntAP: {
  if (!Flip<PT_Uint32, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32IntAPS: {
  if (!Flip<PT_Uint32, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Bool: {
  if (!Flip<PT_Uint32, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32FixedPoint: {
  if (!Flip<PT_Uint32, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Ptr: {
  if (!Flip<PT_Uint32, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32MemberPtr: {
  if (!Flip<PT_Uint32, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint32Float: {
  if (!Flip<PT_Uint32, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Sint8: {
  if (!Flip<PT_Sint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Uint8: {
  if (!Flip<PT_Sint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Sint16: {
  if (!Flip<PT_Sint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Uint16: {
  if (!Flip<PT_Sint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Sint32: {
  if (!Flip<PT_Sint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Uint32: {
  if (!Flip<PT_Sint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Sint64: {
  if (!Flip<PT_Sint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Uint64: {
  if (!Flip<PT_Sint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64IntAP: {
  if (!Flip<PT_Sint64, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64IntAPS: {
  if (!Flip<PT_Sint64, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Bool: {
  if (!Flip<PT_Sint64, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64FixedPoint: {
  if (!Flip<PT_Sint64, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Ptr: {
  if (!Flip<PT_Sint64, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64MemberPtr: {
  if (!Flip<PT_Sint64, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipSint64Float: {
  if (!Flip<PT_Sint64, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Sint8: {
  if (!Flip<PT_Uint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Uint8: {
  if (!Flip<PT_Uint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Sint16: {
  if (!Flip<PT_Uint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Uint16: {
  if (!Flip<PT_Uint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Sint32: {
  if (!Flip<PT_Uint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Uint32: {
  if (!Flip<PT_Uint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Sint64: {
  if (!Flip<PT_Uint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Uint64: {
  if (!Flip<PT_Uint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64IntAP: {
  if (!Flip<PT_Uint64, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64IntAPS: {
  if (!Flip<PT_Uint64, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Bool: {
  if (!Flip<PT_Uint64, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64FixedPoint: {
  if (!Flip<PT_Uint64, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Ptr: {
  if (!Flip<PT_Uint64, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64MemberPtr: {
  if (!Flip<PT_Uint64, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipUint64Float: {
  if (!Flip<PT_Uint64, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSint8: {
  if (!Flip<PT_IntAP, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPUint8: {
  if (!Flip<PT_IntAP, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSint16: {
  if (!Flip<PT_IntAP, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPUint16: {
  if (!Flip<PT_IntAP, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSint32: {
  if (!Flip<PT_IntAP, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPUint32: {
  if (!Flip<PT_IntAP, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSint64: {
  if (!Flip<PT_IntAP, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPUint64: {
  if (!Flip<PT_IntAP, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPIntAP: {
  if (!Flip<PT_IntAP, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPIntAPS: {
  if (!Flip<PT_IntAP, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPBool: {
  if (!Flip<PT_IntAP, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPFixedPoint: {
  if (!Flip<PT_IntAP, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPPtr: {
  if (!Flip<PT_IntAP, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPMemberPtr: {
  if (!Flip<PT_IntAP, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPFloat: {
  if (!Flip<PT_IntAP, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSSint8: {
  if (!Flip<PT_IntAPS, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSUint8: {
  if (!Flip<PT_IntAPS, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSSint16: {
  if (!Flip<PT_IntAPS, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSUint16: {
  if (!Flip<PT_IntAPS, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSSint32: {
  if (!Flip<PT_IntAPS, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSUint32: {
  if (!Flip<PT_IntAPS, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSSint64: {
  if (!Flip<PT_IntAPS, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSUint64: {
  if (!Flip<PT_IntAPS, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSIntAP: {
  if (!Flip<PT_IntAPS, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSIntAPS: {
  if (!Flip<PT_IntAPS, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSBool: {
  if (!Flip<PT_IntAPS, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSFixedPoint: {
  if (!Flip<PT_IntAPS, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSPtr: {
  if (!Flip<PT_IntAPS, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSMemberPtr: {
  if (!Flip<PT_IntAPS, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipIntAPSFloat: {
  if (!Flip<PT_IntAPS, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolSint8: {
  if (!Flip<PT_Bool, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolUint8: {
  if (!Flip<PT_Bool, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolSint16: {
  if (!Flip<PT_Bool, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolUint16: {
  if (!Flip<PT_Bool, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolSint32: {
  if (!Flip<PT_Bool, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolUint32: {
  if (!Flip<PT_Bool, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolSint64: {
  if (!Flip<PT_Bool, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolUint64: {
  if (!Flip<PT_Bool, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolIntAP: {
  if (!Flip<PT_Bool, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolIntAPS: {
  if (!Flip<PT_Bool, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolBool: {
  if (!Flip<PT_Bool, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolFixedPoint: {
  if (!Flip<PT_Bool, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolPtr: {
  if (!Flip<PT_Bool, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolMemberPtr: {
  if (!Flip<PT_Bool, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipBoolFloat: {
  if (!Flip<PT_Bool, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointSint8: {
  if (!Flip<PT_FixedPoint, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointUint8: {
  if (!Flip<PT_FixedPoint, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointSint16: {
  if (!Flip<PT_FixedPoint, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointUint16: {
  if (!Flip<PT_FixedPoint, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointSint32: {
  if (!Flip<PT_FixedPoint, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointUint32: {
  if (!Flip<PT_FixedPoint, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointSint64: {
  if (!Flip<PT_FixedPoint, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointUint64: {
  if (!Flip<PT_FixedPoint, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointIntAP: {
  if (!Flip<PT_FixedPoint, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointIntAPS: {
  if (!Flip<PT_FixedPoint, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointBool: {
  if (!Flip<PT_FixedPoint, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointFixedPoint: {
  if (!Flip<PT_FixedPoint, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointPtr: {
  if (!Flip<PT_FixedPoint, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointMemberPtr: {
  if (!Flip<PT_FixedPoint, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFixedPointFloat: {
  if (!Flip<PT_FixedPoint, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrSint8: {
  if (!Flip<PT_Ptr, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrUint8: {
  if (!Flip<PT_Ptr, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrSint16: {
  if (!Flip<PT_Ptr, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrUint16: {
  if (!Flip<PT_Ptr, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrSint32: {
  if (!Flip<PT_Ptr, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrUint32: {
  if (!Flip<PT_Ptr, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrSint64: {
  if (!Flip<PT_Ptr, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrUint64: {
  if (!Flip<PT_Ptr, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrIntAP: {
  if (!Flip<PT_Ptr, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrIntAPS: {
  if (!Flip<PT_Ptr, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrBool: {
  if (!Flip<PT_Ptr, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrFixedPoint: {
  if (!Flip<PT_Ptr, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrPtr: {
  if (!Flip<PT_Ptr, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrMemberPtr: {
  if (!Flip<PT_Ptr, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipPtrFloat: {
  if (!Flip<PT_Ptr, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrSint8: {
  if (!Flip<PT_MemberPtr, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrUint8: {
  if (!Flip<PT_MemberPtr, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrSint16: {
  if (!Flip<PT_MemberPtr, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrUint16: {
  if (!Flip<PT_MemberPtr, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrSint32: {
  if (!Flip<PT_MemberPtr, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrUint32: {
  if (!Flip<PT_MemberPtr, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrSint64: {
  if (!Flip<PT_MemberPtr, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrUint64: {
  if (!Flip<PT_MemberPtr, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrIntAP: {
  if (!Flip<PT_MemberPtr, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrIntAPS: {
  if (!Flip<PT_MemberPtr, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrBool: {
  if (!Flip<PT_MemberPtr, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrFixedPoint: {
  if (!Flip<PT_MemberPtr, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrPtr: {
  if (!Flip<PT_MemberPtr, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrMemberPtr: {
  if (!Flip<PT_MemberPtr, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipMemberPtrFloat: {
  if (!Flip<PT_MemberPtr, PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatSint8: {
  if (!Flip<PT_Float, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatUint8: {
  if (!Flip<PT_Float, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatSint16: {
  if (!Flip<PT_Float, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatUint16: {
  if (!Flip<PT_Float, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatSint32: {
  if (!Flip<PT_Float, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatUint32: {
  if (!Flip<PT_Float, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatSint64: {
  if (!Flip<PT_Float, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatUint64: {
  if (!Flip<PT_Float, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatIntAP: {
  if (!Flip<PT_Float, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatIntAPS: {
  if (!Flip<PT_Float, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatBool: {
  if (!Flip<PT_Float, PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatFixedPoint: {
  if (!Flip<PT_Float, PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatPtr: {
  if (!Flip<PT_Float, PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatMemberPtr: {
  if (!Flip<PT_Float, PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_FlipFloatFloat: {
  if (!Flip<PT_Float, PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FlipSint8Sint8:
  Text.Op = PrintName("FlipSint8Sint8");
  break;
case OP_FlipSint8Uint8:
  Text.Op = PrintName("FlipSint8Uint8");
  break;
case OP_FlipSint8Sint16:
  Text.Op = PrintName("FlipSint8Sint16");
  break;
case OP_FlipSint8Uint16:
  Text.Op = PrintName("FlipSint8Uint16");
  break;
case OP_FlipSint8Sint32:
  Text.Op = PrintName("FlipSint8Sint32");
  break;
case OP_FlipSint8Uint32:
  Text.Op = PrintName("FlipSint8Uint32");
  break;
case OP_FlipSint8Sint64:
  Text.Op = PrintName("FlipSint8Sint64");
  break;
case OP_FlipSint8Uint64:
  Text.Op = PrintName("FlipSint8Uint64");
  break;
case OP_FlipSint8IntAP:
  Text.Op = PrintName("FlipSint8IntAP");
  break;
case OP_FlipSint8IntAPS:
  Text.Op = PrintName("FlipSint8IntAPS");
  break;
case OP_FlipSint8Bool:
  Text.Op = PrintName("FlipSint8Bool");
  break;
case OP_FlipSint8FixedPoint:
  Text.Op = PrintName("FlipSint8FixedPoint");
  break;
case OP_FlipSint8Ptr:
  Text.Op = PrintName("FlipSint8Ptr");
  break;
case OP_FlipSint8MemberPtr:
  Text.Op = PrintName("FlipSint8MemberPtr");
  break;
case OP_FlipSint8Float:
  Text.Op = PrintName("FlipSint8Float");
  break;
case OP_FlipUint8Sint8:
  Text.Op = PrintName("FlipUint8Sint8");
  break;
case OP_FlipUint8Uint8:
  Text.Op = PrintName("FlipUint8Uint8");
  break;
case OP_FlipUint8Sint16:
  Text.Op = PrintName("FlipUint8Sint16");
  break;
case OP_FlipUint8Uint16:
  Text.Op = PrintName("FlipUint8Uint16");
  break;
case OP_FlipUint8Sint32:
  Text.Op = PrintName("FlipUint8Sint32");
  break;
case OP_FlipUint8Uint32:
  Text.Op = PrintName("FlipUint8Uint32");
  break;
case OP_FlipUint8Sint64:
  Text.Op = PrintName("FlipUint8Sint64");
  break;
case OP_FlipUint8Uint64:
  Text.Op = PrintName("FlipUint8Uint64");
  break;
case OP_FlipUint8IntAP:
  Text.Op = PrintName("FlipUint8IntAP");
  break;
case OP_FlipUint8IntAPS:
  Text.Op = PrintName("FlipUint8IntAPS");
  break;
case OP_FlipUint8Bool:
  Text.Op = PrintName("FlipUint8Bool");
  break;
case OP_FlipUint8FixedPoint:
  Text.Op = PrintName("FlipUint8FixedPoint");
  break;
case OP_FlipUint8Ptr:
  Text.Op = PrintName("FlipUint8Ptr");
  break;
case OP_FlipUint8MemberPtr:
  Text.Op = PrintName("FlipUint8MemberPtr");
  break;
case OP_FlipUint8Float:
  Text.Op = PrintName("FlipUint8Float");
  break;
case OP_FlipSint16Sint8:
  Text.Op = PrintName("FlipSint16Sint8");
  break;
case OP_FlipSint16Uint8:
  Text.Op = PrintName("FlipSint16Uint8");
  break;
case OP_FlipSint16Sint16:
  Text.Op = PrintName("FlipSint16Sint16");
  break;
case OP_FlipSint16Uint16:
  Text.Op = PrintName("FlipSint16Uint16");
  break;
case OP_FlipSint16Sint32:
  Text.Op = PrintName("FlipSint16Sint32");
  break;
case OP_FlipSint16Uint32:
  Text.Op = PrintName("FlipSint16Uint32");
  break;
case OP_FlipSint16Sint64:
  Text.Op = PrintName("FlipSint16Sint64");
  break;
case OP_FlipSint16Uint64:
  Text.Op = PrintName("FlipSint16Uint64");
  break;
case OP_FlipSint16IntAP:
  Text.Op = PrintName("FlipSint16IntAP");
  break;
case OP_FlipSint16IntAPS:
  Text.Op = PrintName("FlipSint16IntAPS");
  break;
case OP_FlipSint16Bool:
  Text.Op = PrintName("FlipSint16Bool");
  break;
case OP_FlipSint16FixedPoint:
  Text.Op = PrintName("FlipSint16FixedPoint");
  break;
case OP_FlipSint16Ptr:
  Text.Op = PrintName("FlipSint16Ptr");
  break;
case OP_FlipSint16MemberPtr:
  Text.Op = PrintName("FlipSint16MemberPtr");
  break;
case OP_FlipSint16Float:
  Text.Op = PrintName("FlipSint16Float");
  break;
case OP_FlipUint16Sint8:
  Text.Op = PrintName("FlipUint16Sint8");
  break;
case OP_FlipUint16Uint8:
  Text.Op = PrintName("FlipUint16Uint8");
  break;
case OP_FlipUint16Sint16:
  Text.Op = PrintName("FlipUint16Sint16");
  break;
case OP_FlipUint16Uint16:
  Text.Op = PrintName("FlipUint16Uint16");
  break;
case OP_FlipUint16Sint32:
  Text.Op = PrintName("FlipUint16Sint32");
  break;
case OP_FlipUint16Uint32:
  Text.Op = PrintName("FlipUint16Uint32");
  break;
case OP_FlipUint16Sint64:
  Text.Op = PrintName("FlipUint16Sint64");
  break;
case OP_FlipUint16Uint64:
  Text.Op = PrintName("FlipUint16Uint64");
  break;
case OP_FlipUint16IntAP:
  Text.Op = PrintName("FlipUint16IntAP");
  break;
case OP_FlipUint16IntAPS:
  Text.Op = PrintName("FlipUint16IntAPS");
  break;
case OP_FlipUint16Bool:
  Text.Op = PrintName("FlipUint16Bool");
  break;
case OP_FlipUint16FixedPoint:
  Text.Op = PrintName("FlipUint16FixedPoint");
  break;
case OP_FlipUint16Ptr:
  Text.Op = PrintName("FlipUint16Ptr");
  break;
case OP_FlipUint16MemberPtr:
  Text.Op = PrintName("FlipUint16MemberPtr");
  break;
case OP_FlipUint16Float:
  Text.Op = PrintName("FlipUint16Float");
  break;
case OP_FlipSint32Sint8:
  Text.Op = PrintName("FlipSint32Sint8");
  break;
case OP_FlipSint32Uint8:
  Text.Op = PrintName("FlipSint32Uint8");
  break;
case OP_FlipSint32Sint16:
  Text.Op = PrintName("FlipSint32Sint16");
  break;
case OP_FlipSint32Uint16:
  Text.Op = PrintName("FlipSint32Uint16");
  break;
case OP_FlipSint32Sint32:
  Text.Op = PrintName("FlipSint32Sint32");
  break;
case OP_FlipSint32Uint32:
  Text.Op = PrintName("FlipSint32Uint32");
  break;
case OP_FlipSint32Sint64:
  Text.Op = PrintName("FlipSint32Sint64");
  break;
case OP_FlipSint32Uint64:
  Text.Op = PrintName("FlipSint32Uint64");
  break;
case OP_FlipSint32IntAP:
  Text.Op = PrintName("FlipSint32IntAP");
  break;
case OP_FlipSint32IntAPS:
  Text.Op = PrintName("FlipSint32IntAPS");
  break;
case OP_FlipSint32Bool:
  Text.Op = PrintName("FlipSint32Bool");
  break;
case OP_FlipSint32FixedPoint:
  Text.Op = PrintName("FlipSint32FixedPoint");
  break;
case OP_FlipSint32Ptr:
  Text.Op = PrintName("FlipSint32Ptr");
  break;
case OP_FlipSint32MemberPtr:
  Text.Op = PrintName("FlipSint32MemberPtr");
  break;
case OP_FlipSint32Float:
  Text.Op = PrintName("FlipSint32Float");
  break;
case OP_FlipUint32Sint8:
  Text.Op = PrintName("FlipUint32Sint8");
  break;
case OP_FlipUint32Uint8:
  Text.Op = PrintName("FlipUint32Uint8");
  break;
case OP_FlipUint32Sint16:
  Text.Op = PrintName("FlipUint32Sint16");
  break;
case OP_FlipUint32Uint16:
  Text.Op = PrintName("FlipUint32Uint16");
  break;
case OP_FlipUint32Sint32:
  Text.Op = PrintName("FlipUint32Sint32");
  break;
case OP_FlipUint32Uint32:
  Text.Op = PrintName("FlipUint32Uint32");
  break;
case OP_FlipUint32Sint64:
  Text.Op = PrintName("FlipUint32Sint64");
  break;
case OP_FlipUint32Uint64:
  Text.Op = PrintName("FlipUint32Uint64");
  break;
case OP_FlipUint32IntAP:
  Text.Op = PrintName("FlipUint32IntAP");
  break;
case OP_FlipUint32IntAPS:
  Text.Op = PrintName("FlipUint32IntAPS");
  break;
case OP_FlipUint32Bool:
  Text.Op = PrintName("FlipUint32Bool");
  break;
case OP_FlipUint32FixedPoint:
  Text.Op = PrintName("FlipUint32FixedPoint");
  break;
case OP_FlipUint32Ptr:
  Text.Op = PrintName("FlipUint32Ptr");
  break;
case OP_FlipUint32MemberPtr:
  Text.Op = PrintName("FlipUint32MemberPtr");
  break;
case OP_FlipUint32Float:
  Text.Op = PrintName("FlipUint32Float");
  break;
case OP_FlipSint64Sint8:
  Text.Op = PrintName("FlipSint64Sint8");
  break;
case OP_FlipSint64Uint8:
  Text.Op = PrintName("FlipSint64Uint8");
  break;
case OP_FlipSint64Sint16:
  Text.Op = PrintName("FlipSint64Sint16");
  break;
case OP_FlipSint64Uint16:
  Text.Op = PrintName("FlipSint64Uint16");
  break;
case OP_FlipSint64Sint32:
  Text.Op = PrintName("FlipSint64Sint32");
  break;
case OP_FlipSint64Uint32:
  Text.Op = PrintName("FlipSint64Uint32");
  break;
case OP_FlipSint64Sint64:
  Text.Op = PrintName("FlipSint64Sint64");
  break;
case OP_FlipSint64Uint64:
  Text.Op = PrintName("FlipSint64Uint64");
  break;
case OP_FlipSint64IntAP:
  Text.Op = PrintName("FlipSint64IntAP");
  break;
case OP_FlipSint64IntAPS:
  Text.Op = PrintName("FlipSint64IntAPS");
  break;
case OP_FlipSint64Bool:
  Text.Op = PrintName("FlipSint64Bool");
  break;
case OP_FlipSint64FixedPoint:
  Text.Op = PrintName("FlipSint64FixedPoint");
  break;
case OP_FlipSint64Ptr:
  Text.Op = PrintName("FlipSint64Ptr");
  break;
case OP_FlipSint64MemberPtr:
  Text.Op = PrintName("FlipSint64MemberPtr");
  break;
case OP_FlipSint64Float:
  Text.Op = PrintName("FlipSint64Float");
  break;
case OP_FlipUint64Sint8:
  Text.Op = PrintName("FlipUint64Sint8");
  break;
case OP_FlipUint64Uint8:
  Text.Op = PrintName("FlipUint64Uint8");
  break;
case OP_FlipUint64Sint16:
  Text.Op = PrintName("FlipUint64Sint16");
  break;
case OP_FlipUint64Uint16:
  Text.Op = PrintName("FlipUint64Uint16");
  break;
case OP_FlipUint64Sint32:
  Text.Op = PrintName("FlipUint64Sint32");
  break;
case OP_FlipUint64Uint32:
  Text.Op = PrintName("FlipUint64Uint32");
  break;
case OP_FlipUint64Sint64:
  Text.Op = PrintName("FlipUint64Sint64");
  break;
case OP_FlipUint64Uint64:
  Text.Op = PrintName("FlipUint64Uint64");
  break;
case OP_FlipUint64IntAP:
  Text.Op = PrintName("FlipUint64IntAP");
  break;
case OP_FlipUint64IntAPS:
  Text.Op = PrintName("FlipUint64IntAPS");
  break;
case OP_FlipUint64Bool:
  Text.Op = PrintName("FlipUint64Bool");
  break;
case OP_FlipUint64FixedPoint:
  Text.Op = PrintName("FlipUint64FixedPoint");
  break;
case OP_FlipUint64Ptr:
  Text.Op = PrintName("FlipUint64Ptr");
  break;
case OP_FlipUint64MemberPtr:
  Text.Op = PrintName("FlipUint64MemberPtr");
  break;
case OP_FlipUint64Float:
  Text.Op = PrintName("FlipUint64Float");
  break;
case OP_FlipIntAPSint8:
  Text.Op = PrintName("FlipIntAPSint8");
  break;
case OP_FlipIntAPUint8:
  Text.Op = PrintName("FlipIntAPUint8");
  break;
case OP_FlipIntAPSint16:
  Text.Op = PrintName("FlipIntAPSint16");
  break;
case OP_FlipIntAPUint16:
  Text.Op = PrintName("FlipIntAPUint16");
  break;
case OP_FlipIntAPSint32:
  Text.Op = PrintName("FlipIntAPSint32");
  break;
case OP_FlipIntAPUint32:
  Text.Op = PrintName("FlipIntAPUint32");
  break;
case OP_FlipIntAPSint64:
  Text.Op = PrintName("FlipIntAPSint64");
  break;
case OP_FlipIntAPUint64:
  Text.Op = PrintName("FlipIntAPUint64");
  break;
case OP_FlipIntAPIntAP:
  Text.Op = PrintName("FlipIntAPIntAP");
  break;
case OP_FlipIntAPIntAPS:
  Text.Op = PrintName("FlipIntAPIntAPS");
  break;
case OP_FlipIntAPBool:
  Text.Op = PrintName("FlipIntAPBool");
  break;
case OP_FlipIntAPFixedPoint:
  Text.Op = PrintName("FlipIntAPFixedPoint");
  break;
case OP_FlipIntAPPtr:
  Text.Op = PrintName("FlipIntAPPtr");
  break;
case OP_FlipIntAPMemberPtr:
  Text.Op = PrintName("FlipIntAPMemberPtr");
  break;
case OP_FlipIntAPFloat:
  Text.Op = PrintName("FlipIntAPFloat");
  break;
case OP_FlipIntAPSSint8:
  Text.Op = PrintName("FlipIntAPSSint8");
  break;
case OP_FlipIntAPSUint8:
  Text.Op = PrintName("FlipIntAPSUint8");
  break;
case OP_FlipIntAPSSint16:
  Text.Op = PrintName("FlipIntAPSSint16");
  break;
case OP_FlipIntAPSUint16:
  Text.Op = PrintName("FlipIntAPSUint16");
  break;
case OP_FlipIntAPSSint32:
  Text.Op = PrintName("FlipIntAPSSint32");
  break;
case OP_FlipIntAPSUint32:
  Text.Op = PrintName("FlipIntAPSUint32");
  break;
case OP_FlipIntAPSSint64:
  Text.Op = PrintName("FlipIntAPSSint64");
  break;
case OP_FlipIntAPSUint64:
  Text.Op = PrintName("FlipIntAPSUint64");
  break;
case OP_FlipIntAPSIntAP:
  Text.Op = PrintName("FlipIntAPSIntAP");
  break;
case OP_FlipIntAPSIntAPS:
  Text.Op = PrintName("FlipIntAPSIntAPS");
  break;
case OP_FlipIntAPSBool:
  Text.Op = PrintName("FlipIntAPSBool");
  break;
case OP_FlipIntAPSFixedPoint:
  Text.Op = PrintName("FlipIntAPSFixedPoint");
  break;
case OP_FlipIntAPSPtr:
  Text.Op = PrintName("FlipIntAPSPtr");
  break;
case OP_FlipIntAPSMemberPtr:
  Text.Op = PrintName("FlipIntAPSMemberPtr");
  break;
case OP_FlipIntAPSFloat:
  Text.Op = PrintName("FlipIntAPSFloat");
  break;
case OP_FlipBoolSint8:
  Text.Op = PrintName("FlipBoolSint8");
  break;
case OP_FlipBoolUint8:
  Text.Op = PrintName("FlipBoolUint8");
  break;
case OP_FlipBoolSint16:
  Text.Op = PrintName("FlipBoolSint16");
  break;
case OP_FlipBoolUint16:
  Text.Op = PrintName("FlipBoolUint16");
  break;
case OP_FlipBoolSint32:
  Text.Op = PrintName("FlipBoolSint32");
  break;
case OP_FlipBoolUint32:
  Text.Op = PrintName("FlipBoolUint32");
  break;
case OP_FlipBoolSint64:
  Text.Op = PrintName("FlipBoolSint64");
  break;
case OP_FlipBoolUint64:
  Text.Op = PrintName("FlipBoolUint64");
  break;
case OP_FlipBoolIntAP:
  Text.Op = PrintName("FlipBoolIntAP");
  break;
case OP_FlipBoolIntAPS:
  Text.Op = PrintName("FlipBoolIntAPS");
  break;
case OP_FlipBoolBool:
  Text.Op = PrintName("FlipBoolBool");
  break;
case OP_FlipBoolFixedPoint:
  Text.Op = PrintName("FlipBoolFixedPoint");
  break;
case OP_FlipBoolPtr:
  Text.Op = PrintName("FlipBoolPtr");
  break;
case OP_FlipBoolMemberPtr:
  Text.Op = PrintName("FlipBoolMemberPtr");
  break;
case OP_FlipBoolFloat:
  Text.Op = PrintName("FlipBoolFloat");
  break;
case OP_FlipFixedPointSint8:
  Text.Op = PrintName("FlipFixedPointSint8");
  break;
case OP_FlipFixedPointUint8:
  Text.Op = PrintName("FlipFixedPointUint8");
  break;
case OP_FlipFixedPointSint16:
  Text.Op = PrintName("FlipFixedPointSint16");
  break;
case OP_FlipFixedPointUint16:
  Text.Op = PrintName("FlipFixedPointUint16");
  break;
case OP_FlipFixedPointSint32:
  Text.Op = PrintName("FlipFixedPointSint32");
  break;
case OP_FlipFixedPointUint32:
  Text.Op = PrintName("FlipFixedPointUint32");
  break;
case OP_FlipFixedPointSint64:
  Text.Op = PrintName("FlipFixedPointSint64");
  break;
case OP_FlipFixedPointUint64:
  Text.Op = PrintName("FlipFixedPointUint64");
  break;
case OP_FlipFixedPointIntAP:
  Text.Op = PrintName("FlipFixedPointIntAP");
  break;
case OP_FlipFixedPointIntAPS:
  Text.Op = PrintName("FlipFixedPointIntAPS");
  break;
case OP_FlipFixedPointBool:
  Text.Op = PrintName("FlipFixedPointBool");
  break;
case OP_FlipFixedPointFixedPoint:
  Text.Op = PrintName("FlipFixedPointFixedPoint");
  break;
case OP_FlipFixedPointPtr:
  Text.Op = PrintName("FlipFixedPointPtr");
  break;
case OP_FlipFixedPointMemberPtr:
  Text.Op = PrintName("FlipFixedPointMemberPtr");
  break;
case OP_FlipFixedPointFloat:
  Text.Op = PrintName("FlipFixedPointFloat");
  break;
case OP_FlipPtrSint8:
  Text.Op = PrintName("FlipPtrSint8");
  break;
case OP_FlipPtrUint8:
  Text.Op = PrintName("FlipPtrUint8");
  break;
case OP_FlipPtrSint16:
  Text.Op = PrintName("FlipPtrSint16");
  break;
case OP_FlipPtrUint16:
  Text.Op = PrintName("FlipPtrUint16");
  break;
case OP_FlipPtrSint32:
  Text.Op = PrintName("FlipPtrSint32");
  break;
case OP_FlipPtrUint32:
  Text.Op = PrintName("FlipPtrUint32");
  break;
case OP_FlipPtrSint64:
  Text.Op = PrintName("FlipPtrSint64");
  break;
case OP_FlipPtrUint64:
  Text.Op = PrintName("FlipPtrUint64");
  break;
case OP_FlipPtrIntAP:
  Text.Op = PrintName("FlipPtrIntAP");
  break;
case OP_FlipPtrIntAPS:
  Text.Op = PrintName("FlipPtrIntAPS");
  break;
case OP_FlipPtrBool:
  Text.Op = PrintName("FlipPtrBool");
  break;
case OP_FlipPtrFixedPoint:
  Text.Op = PrintName("FlipPtrFixedPoint");
  break;
case OP_FlipPtrPtr:
  Text.Op = PrintName("FlipPtrPtr");
  break;
case OP_FlipPtrMemberPtr:
  Text.Op = PrintName("FlipPtrMemberPtr");
  break;
case OP_FlipPtrFloat:
  Text.Op = PrintName("FlipPtrFloat");
  break;
case OP_FlipMemberPtrSint8:
  Text.Op = PrintName("FlipMemberPtrSint8");
  break;
case OP_FlipMemberPtrUint8:
  Text.Op = PrintName("FlipMemberPtrUint8");
  break;
case OP_FlipMemberPtrSint16:
  Text.Op = PrintName("FlipMemberPtrSint16");
  break;
case OP_FlipMemberPtrUint16:
  Text.Op = PrintName("FlipMemberPtrUint16");
  break;
case OP_FlipMemberPtrSint32:
  Text.Op = PrintName("FlipMemberPtrSint32");
  break;
case OP_FlipMemberPtrUint32:
  Text.Op = PrintName("FlipMemberPtrUint32");
  break;
case OP_FlipMemberPtrSint64:
  Text.Op = PrintName("FlipMemberPtrSint64");
  break;
case OP_FlipMemberPtrUint64:
  Text.Op = PrintName("FlipMemberPtrUint64");
  break;
case OP_FlipMemberPtrIntAP:
  Text.Op = PrintName("FlipMemberPtrIntAP");
  break;
case OP_FlipMemberPtrIntAPS:
  Text.Op = PrintName("FlipMemberPtrIntAPS");
  break;
case OP_FlipMemberPtrBool:
  Text.Op = PrintName("FlipMemberPtrBool");
  break;
case OP_FlipMemberPtrFixedPoint:
  Text.Op = PrintName("FlipMemberPtrFixedPoint");
  break;
case OP_FlipMemberPtrPtr:
  Text.Op = PrintName("FlipMemberPtrPtr");
  break;
case OP_FlipMemberPtrMemberPtr:
  Text.Op = PrintName("FlipMemberPtrMemberPtr");
  break;
case OP_FlipMemberPtrFloat:
  Text.Op = PrintName("FlipMemberPtrFloat");
  break;
case OP_FlipFloatSint8:
  Text.Op = PrintName("FlipFloatSint8");
  break;
case OP_FlipFloatUint8:
  Text.Op = PrintName("FlipFloatUint8");
  break;
case OP_FlipFloatSint16:
  Text.Op = PrintName("FlipFloatSint16");
  break;
case OP_FlipFloatUint16:
  Text.Op = PrintName("FlipFloatUint16");
  break;
case OP_FlipFloatSint32:
  Text.Op = PrintName("FlipFloatSint32");
  break;
case OP_FlipFloatUint32:
  Text.Op = PrintName("FlipFloatUint32");
  break;
case OP_FlipFloatSint64:
  Text.Op = PrintName("FlipFloatSint64");
  break;
case OP_FlipFloatUint64:
  Text.Op = PrintName("FlipFloatUint64");
  break;
case OP_FlipFloatIntAP:
  Text.Op = PrintName("FlipFloatIntAP");
  break;
case OP_FlipFloatIntAPS:
  Text.Op = PrintName("FlipFloatIntAPS");
  break;
case OP_FlipFloatBool:
  Text.Op = PrintName("FlipFloatBool");
  break;
case OP_FlipFloatFixedPoint:
  Text.Op = PrintName("FlipFloatFixedPoint");
  break;
case OP_FlipFloatPtr:
  Text.Op = PrintName("FlipFloatPtr");
  break;
case OP_FlipFloatMemberPtr:
  Text.Op = PrintName("FlipFloatMemberPtr");
  break;
case OP_FlipFloatFloat:
  Text.Op = PrintName("FlipFloatFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFlipSint8Sint8(SourceInfo);
bool emitFlipSint8Uint8(SourceInfo);
bool emitFlipSint8Sint16(SourceInfo);
bool emitFlipSint8Uint16(SourceInfo);
bool emitFlipSint8Sint32(SourceInfo);
bool emitFlipSint8Uint32(SourceInfo);
bool emitFlipSint8Sint64(SourceInfo);
bool emitFlipSint8Uint64(SourceInfo);
bool emitFlipSint8IntAP(SourceInfo);
bool emitFlipSint8IntAPS(SourceInfo);
bool emitFlipSint8Bool(SourceInfo);
bool emitFlipSint8FixedPoint(SourceInfo);
bool emitFlipSint8Ptr(SourceInfo);
bool emitFlipSint8MemberPtr(SourceInfo);
bool emitFlipSint8Float(SourceInfo);
bool emitFlipUint8Sint8(SourceInfo);
bool emitFlipUint8Uint8(SourceInfo);
bool emitFlipUint8Sint16(SourceInfo);
bool emitFlipUint8Uint16(SourceInfo);
bool emitFlipUint8Sint32(SourceInfo);
bool emitFlipUint8Uint32(SourceInfo);
bool emitFlipUint8Sint64(SourceInfo);
bool emitFlipUint8Uint64(SourceInfo);
bool emitFlipUint8IntAP(SourceInfo);
bool emitFlipUint8IntAPS(SourceInfo);
bool emitFlipUint8Bool(SourceInfo);
bool emitFlipUint8FixedPoint(SourceInfo);
bool emitFlipUint8Ptr(SourceInfo);
bool emitFlipUint8MemberPtr(SourceInfo);
bool emitFlipUint8Float(SourceInfo);
bool emitFlipSint16Sint8(SourceInfo);
bool emitFlipSint16Uint8(SourceInfo);
bool emitFlipSint16Sint16(SourceInfo);
bool emitFlipSint16Uint16(SourceInfo);
bool emitFlipSint16Sint32(SourceInfo);
bool emitFlipSint16Uint32(SourceInfo);
bool emitFlipSint16Sint64(SourceInfo);
bool emitFlipSint16Uint64(SourceInfo);
bool emitFlipSint16IntAP(SourceInfo);
bool emitFlipSint16IntAPS(SourceInfo);
bool emitFlipSint16Bool(SourceInfo);
bool emitFlipSint16FixedPoint(SourceInfo);
bool emitFlipSint16Ptr(SourceInfo);
bool emitFlipSint16MemberPtr(SourceInfo);
bool emitFlipSint16Float(SourceInfo);
bool emitFlipUint16Sint8(SourceInfo);
bool emitFlipUint16Uint8(SourceInfo);
bool emitFlipUint16Sint16(SourceInfo);
bool emitFlipUint16Uint16(SourceInfo);
bool emitFlipUint16Sint32(SourceInfo);
bool emitFlipUint16Uint32(SourceInfo);
bool emitFlipUint16Sint64(SourceInfo);
bool emitFlipUint16Uint64(SourceInfo);
bool emitFlipUint16IntAP(SourceInfo);
bool emitFlipUint16IntAPS(SourceInfo);
bool emitFlipUint16Bool(SourceInfo);
bool emitFlipUint16FixedPoint(SourceInfo);
bool emitFlipUint16Ptr(SourceInfo);
bool emitFlipUint16MemberPtr(SourceInfo);
bool emitFlipUint16Float(SourceInfo);
bool emitFlipSint32Sint8(SourceInfo);
bool emitFlipSint32Uint8(SourceInfo);
bool emitFlipSint32Sint16(SourceInfo);
bool emitFlipSint32Uint16(SourceInfo);
bool emitFlipSint32Sint32(SourceInfo);
bool emitFlipSint32Uint32(SourceInfo);
bool emitFlipSint32Sint64(SourceInfo);
bool emitFlipSint32Uint64(SourceInfo);
bool emitFlipSint32IntAP(SourceInfo);
bool emitFlipSint32IntAPS(SourceInfo);
bool emitFlipSint32Bool(SourceInfo);
bool emitFlipSint32FixedPoint(SourceInfo);
bool emitFlipSint32Ptr(SourceInfo);
bool emitFlipSint32MemberPtr(SourceInfo);
bool emitFlipSint32Float(SourceInfo);
bool emitFlipUint32Sint8(SourceInfo);
bool emitFlipUint32Uint8(SourceInfo);
bool emitFlipUint32Sint16(SourceInfo);
bool emitFlipUint32Uint16(SourceInfo);
bool emitFlipUint32Sint32(SourceInfo);
bool emitFlipUint32Uint32(SourceInfo);
bool emitFlipUint32Sint64(SourceInfo);
bool emitFlipUint32Uint64(SourceInfo);
bool emitFlipUint32IntAP(SourceInfo);
bool emitFlipUint32IntAPS(SourceInfo);
bool emitFlipUint32Bool(SourceInfo);
bool emitFlipUint32FixedPoint(SourceInfo);
bool emitFlipUint32Ptr(SourceInfo);
bool emitFlipUint32MemberPtr(SourceInfo);
bool emitFlipUint32Float(SourceInfo);
bool emitFlipSint64Sint8(SourceInfo);
bool emitFlipSint64Uint8(SourceInfo);
bool emitFlipSint64Sint16(SourceInfo);
bool emitFlipSint64Uint16(SourceInfo);
bool emitFlipSint64Sint32(SourceInfo);
bool emitFlipSint64Uint32(SourceInfo);
bool emitFlipSint64Sint64(SourceInfo);
bool emitFlipSint64Uint64(SourceInfo);
bool emitFlipSint64IntAP(SourceInfo);
bool emitFlipSint64IntAPS(SourceInfo);
bool emitFlipSint64Bool(SourceInfo);
bool emitFlipSint64FixedPoint(SourceInfo);
bool emitFlipSint64Ptr(SourceInfo);
bool emitFlipSint64MemberPtr(SourceInfo);
bool emitFlipSint64Float(SourceInfo);
bool emitFlipUint64Sint8(SourceInfo);
bool emitFlipUint64Uint8(SourceInfo);
bool emitFlipUint64Sint16(SourceInfo);
bool emitFlipUint64Uint16(SourceInfo);
bool emitFlipUint64Sint32(SourceInfo);
bool emitFlipUint64Uint32(SourceInfo);
bool emitFlipUint64Sint64(SourceInfo);
bool emitFlipUint64Uint64(SourceInfo);
bool emitFlipUint64IntAP(SourceInfo);
bool emitFlipUint64IntAPS(SourceInfo);
bool emitFlipUint64Bool(SourceInfo);
bool emitFlipUint64FixedPoint(SourceInfo);
bool emitFlipUint64Ptr(SourceInfo);
bool emitFlipUint64MemberPtr(SourceInfo);
bool emitFlipUint64Float(SourceInfo);
bool emitFlipIntAPSint8(SourceInfo);
bool emitFlipIntAPUint8(SourceInfo);
bool emitFlipIntAPSint16(SourceInfo);
bool emitFlipIntAPUint16(SourceInfo);
bool emitFlipIntAPSint32(SourceInfo);
bool emitFlipIntAPUint32(SourceInfo);
bool emitFlipIntAPSint64(SourceInfo);
bool emitFlipIntAPUint64(SourceInfo);
bool emitFlipIntAPIntAP(SourceInfo);
bool emitFlipIntAPIntAPS(SourceInfo);
bool emitFlipIntAPBool(SourceInfo);
bool emitFlipIntAPFixedPoint(SourceInfo);
bool emitFlipIntAPPtr(SourceInfo);
bool emitFlipIntAPMemberPtr(SourceInfo);
bool emitFlipIntAPFloat(SourceInfo);
bool emitFlipIntAPSSint8(SourceInfo);
bool emitFlipIntAPSUint8(SourceInfo);
bool emitFlipIntAPSSint16(SourceInfo);
bool emitFlipIntAPSUint16(SourceInfo);
bool emitFlipIntAPSSint32(SourceInfo);
bool emitFlipIntAPSUint32(SourceInfo);
bool emitFlipIntAPSSint64(SourceInfo);
bool emitFlipIntAPSUint64(SourceInfo);
bool emitFlipIntAPSIntAP(SourceInfo);
bool emitFlipIntAPSIntAPS(SourceInfo);
bool emitFlipIntAPSBool(SourceInfo);
bool emitFlipIntAPSFixedPoint(SourceInfo);
bool emitFlipIntAPSPtr(SourceInfo);
bool emitFlipIntAPSMemberPtr(SourceInfo);
bool emitFlipIntAPSFloat(SourceInfo);
bool emitFlipBoolSint8(SourceInfo);
bool emitFlipBoolUint8(SourceInfo);
bool emitFlipBoolSint16(SourceInfo);
bool emitFlipBoolUint16(SourceInfo);
bool emitFlipBoolSint32(SourceInfo);
bool emitFlipBoolUint32(SourceInfo);
bool emitFlipBoolSint64(SourceInfo);
bool emitFlipBoolUint64(SourceInfo);
bool emitFlipBoolIntAP(SourceInfo);
bool emitFlipBoolIntAPS(SourceInfo);
bool emitFlipBoolBool(SourceInfo);
bool emitFlipBoolFixedPoint(SourceInfo);
bool emitFlipBoolPtr(SourceInfo);
bool emitFlipBoolMemberPtr(SourceInfo);
bool emitFlipBoolFloat(SourceInfo);
bool emitFlipFixedPointSint8(SourceInfo);
bool emitFlipFixedPointUint8(SourceInfo);
bool emitFlipFixedPointSint16(SourceInfo);
bool emitFlipFixedPointUint16(SourceInfo);
bool emitFlipFixedPointSint32(SourceInfo);
bool emitFlipFixedPointUint32(SourceInfo);
bool emitFlipFixedPointSint64(SourceInfo);
bool emitFlipFixedPointUint64(SourceInfo);
bool emitFlipFixedPointIntAP(SourceInfo);
bool emitFlipFixedPointIntAPS(SourceInfo);
bool emitFlipFixedPointBool(SourceInfo);
bool emitFlipFixedPointFixedPoint(SourceInfo);
bool emitFlipFixedPointPtr(SourceInfo);
bool emitFlipFixedPointMemberPtr(SourceInfo);
bool emitFlipFixedPointFloat(SourceInfo);
bool emitFlipPtrSint8(SourceInfo);
bool emitFlipPtrUint8(SourceInfo);
bool emitFlipPtrSint16(SourceInfo);
bool emitFlipPtrUint16(SourceInfo);
bool emitFlipPtrSint32(SourceInfo);
bool emitFlipPtrUint32(SourceInfo);
bool emitFlipPtrSint64(SourceInfo);
bool emitFlipPtrUint64(SourceInfo);
bool emitFlipPtrIntAP(SourceInfo);
bool emitFlipPtrIntAPS(SourceInfo);
bool emitFlipPtrBool(SourceInfo);
bool emitFlipPtrFixedPoint(SourceInfo);
bool emitFlipPtrPtr(SourceInfo);
bool emitFlipPtrMemberPtr(SourceInfo);
bool emitFlipPtrFloat(SourceInfo);
bool emitFlipMemberPtrSint8(SourceInfo);
bool emitFlipMemberPtrUint8(SourceInfo);
bool emitFlipMemberPtrSint16(SourceInfo);
bool emitFlipMemberPtrUint16(SourceInfo);
bool emitFlipMemberPtrSint32(SourceInfo);
bool emitFlipMemberPtrUint32(SourceInfo);
bool emitFlipMemberPtrSint64(SourceInfo);
bool emitFlipMemberPtrUint64(SourceInfo);
bool emitFlipMemberPtrIntAP(SourceInfo);
bool emitFlipMemberPtrIntAPS(SourceInfo);
bool emitFlipMemberPtrBool(SourceInfo);
bool emitFlipMemberPtrFixedPoint(SourceInfo);
bool emitFlipMemberPtrPtr(SourceInfo);
bool emitFlipMemberPtrMemberPtr(SourceInfo);
bool emitFlipMemberPtrFloat(SourceInfo);
bool emitFlipFloatSint8(SourceInfo);
bool emitFlipFloatUint8(SourceInfo);
bool emitFlipFloatSint16(SourceInfo);
bool emitFlipFloatUint16(SourceInfo);
bool emitFlipFloatSint32(SourceInfo);
bool emitFlipFloatUint32(SourceInfo);
bool emitFlipFloatSint64(SourceInfo);
bool emitFlipFloatUint64(SourceInfo);
bool emitFlipFloatIntAP(SourceInfo);
bool emitFlipFloatIntAPS(SourceInfo);
bool emitFlipFloatBool(SourceInfo);
bool emitFlipFloatFixedPoint(SourceInfo);
bool emitFlipFloatPtr(SourceInfo);
bool emitFlipFloatMemberPtr(SourceInfo);
bool emitFlipFloatFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitFlip(PrimType, PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitFlip(PrimType T0, PrimType T1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
  switch (T1) {
  case PT_Sint8:
    return emitFlipSint8Sint8(I);
  case PT_Uint8:
    return emitFlipSint8Uint8(I);
  case PT_Sint16:
    return emitFlipSint8Sint16(I);
  case PT_Uint16:
    return emitFlipSint8Uint16(I);
  case PT_Sint32:
    return emitFlipSint8Sint32(I);
  case PT_Uint32:
    return emitFlipSint8Uint32(I);
  case PT_Sint64:
    return emitFlipSint8Sint64(I);
  case PT_Uint64:
    return emitFlipSint8Uint64(I);
  case PT_IntAP:
    return emitFlipSint8IntAP(I);
  case PT_IntAPS:
    return emitFlipSint8IntAPS(I);
  case PT_Bool:
    return emitFlipSint8Bool(I);
  case PT_FixedPoint:
    return emitFlipSint8FixedPoint(I);
  case PT_Ptr:
    return emitFlipSint8Ptr(I);
  case PT_MemberPtr:
    return emitFlipSint8MemberPtr(I);
  case PT_Float:
    return emitFlipSint8Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint8:
  switch (T1) {
  case PT_Sint8:
    return emitFlipUint8Sint8(I);
  case PT_Uint8:
    return emitFlipUint8Uint8(I);
  case PT_Sint16:
    return emitFlipUint8Sint16(I);
  case PT_Uint16:
    return emitFlipUint8Uint16(I);
  case PT_Sint32:
    return emitFlipUint8Sint32(I);
  case PT_Uint32:
    return emitFlipUint8Uint32(I);
  case PT_Sint64:
    return emitFlipUint8Sint64(I);
  case PT_Uint64:
    return emitFlipUint8Uint64(I);
  case PT_IntAP:
    return emitFlipUint8IntAP(I);
  case PT_IntAPS:
    return emitFlipUint8IntAPS(I);
  case PT_Bool:
    return emitFlipUint8Bool(I);
  case PT_FixedPoint:
    return emitFlipUint8FixedPoint(I);
  case PT_Ptr:
    return emitFlipUint8Ptr(I);
  case PT_MemberPtr:
    return emitFlipUint8MemberPtr(I);
  case PT_Float:
    return emitFlipUint8Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint16:
  switch (T1) {
  case PT_Sint8:
    return emitFlipSint16Sint8(I);
  case PT_Uint8:
    return emitFlipSint16Uint8(I);
  case PT_Sint16:
    return emitFlipSint16Sint16(I);
  case PT_Uint16:
    return emitFlipSint16Uint16(I);
  case PT_Sint32:
    return emitFlipSint16Sint32(I);
  case PT_Uint32:
    return emitFlipSint16Uint32(I);
  case PT_Sint64:
    return emitFlipSint16Sint64(I);
  case PT_Uint64:
    return emitFlipSint16Uint64(I);
  case PT_IntAP:
    return emitFlipSint16IntAP(I);
  case PT_IntAPS:
    return emitFlipSint16IntAPS(I);
  case PT_Bool:
    return emitFlipSint16Bool(I);
  case PT_FixedPoint:
    return emitFlipSint16FixedPoint(I);
  case PT_Ptr:
    return emitFlipSint16Ptr(I);
  case PT_MemberPtr:
    return emitFlipSint16MemberPtr(I);
  case PT_Float:
    return emitFlipSint16Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint16:
  switch (T1) {
  case PT_Sint8:
    return emitFlipUint16Sint8(I);
  case PT_Uint8:
    return emitFlipUint16Uint8(I);
  case PT_Sint16:
    return emitFlipUint16Sint16(I);
  case PT_Uint16:
    return emitFlipUint16Uint16(I);
  case PT_Sint32:
    return emitFlipUint16Sint32(I);
  case PT_Uint32:
    return emitFlipUint16Uint32(I);
  case PT_Sint64:
    return emitFlipUint16Sint64(I);
  case PT_Uint64:
    return emitFlipUint16Uint64(I);
  case PT_IntAP:
    return emitFlipUint16IntAP(I);
  case PT_IntAPS:
    return emitFlipUint16IntAPS(I);
  case PT_Bool:
    return emitFlipUint16Bool(I);
  case PT_FixedPoint:
    return emitFlipUint16FixedPoint(I);
  case PT_Ptr:
    return emitFlipUint16Ptr(I);
  case PT_MemberPtr:
    return emitFlipUint16MemberPtr(I);
  case PT_Float:
    return emitFlipUint16Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint32:
  switch (T1) {
  case PT_Sint8:
    return emitFlipSint32Sint8(I);
  case PT_Uint8:
    return emitFlipSint32Uint8(I);
  case PT_Sint16:
    return emitFlipSint32Sint16(I);
  case PT_Uint16:
    return emitFlipSint32Uint16(I);
  case PT_Sint32:
    return emitFlipSint32Sint32(I);
  case PT_Uint32:
    return emitFlipSint32Uint32(I);
  case PT_Sint64:
    return emitFlipSint32Sint64(I);
  case PT_Uint64:
    return emitFlipSint32Uint64(I);
  case PT_IntAP:
    return emitFlipSint32IntAP(I);
  case PT_IntAPS:
    return emitFlipSint32IntAPS(I);
  case PT_Bool:
    return emitFlipSint32Bool(I);
  case PT_FixedPoint:
    return emitFlipSint32FixedPoint(I);
  case PT_Ptr:
    return emitFlipSint32Ptr(I);
  case PT_MemberPtr:
    return emitFlipSint32MemberPtr(I);
  case PT_Float:
    return emitFlipSint32Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint32:
  switch (T1) {
  case PT_Sint8:
    return emitFlipUint32Sint8(I);
  case PT_Uint8:
    return emitFlipUint32Uint8(I);
  case PT_Sint16:
    return emitFlipUint32Sint16(I);
  case PT_Uint16:
    return emitFlipUint32Uint16(I);
  case PT_Sint32:
    return emitFlipUint32Sint32(I);
  case PT_Uint32:
    return emitFlipUint32Uint32(I);
  case PT_Sint64:
    return emitFlipUint32Sint64(I);
  case PT_Uint64:
    return emitFlipUint32Uint64(I);
  case PT_IntAP:
    return emitFlipUint32IntAP(I);
  case PT_IntAPS:
    return emitFlipUint32IntAPS(I);
  case PT_Bool:
    return emitFlipUint32Bool(I);
  case PT_FixedPoint:
    return emitFlipUint32FixedPoint(I);
  case PT_Ptr:
    return emitFlipUint32Ptr(I);
  case PT_MemberPtr:
    return emitFlipUint32MemberPtr(I);
  case PT_Float:
    return emitFlipUint32Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint64:
  switch (T1) {
  case PT_Sint8:
    return emitFlipSint64Sint8(I);
  case PT_Uint8:
    return emitFlipSint64Uint8(I);
  case PT_Sint16:
    return emitFlipSint64Sint16(I);
  case PT_Uint16:
    return emitFlipSint64Uint16(I);
  case PT_Sint32:
    return emitFlipSint64Sint32(I);
  case PT_Uint32:
    return emitFlipSint64Uint32(I);
  case PT_Sint64:
    return emitFlipSint64Sint64(I);
  case PT_Uint64:
    return emitFlipSint64Uint64(I);
  case PT_IntAP:
    return emitFlipSint64IntAP(I);
  case PT_IntAPS:
    return emitFlipSint64IntAPS(I);
  case PT_Bool:
    return emitFlipSint64Bool(I);
  case PT_FixedPoint:
    return emitFlipSint64FixedPoint(I);
  case PT_Ptr:
    return emitFlipSint64Ptr(I);
  case PT_MemberPtr:
    return emitFlipSint64MemberPtr(I);
  case PT_Float:
    return emitFlipSint64Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint64:
  switch (T1) {
  case PT_Sint8:
    return emitFlipUint64Sint8(I);
  case PT_Uint8:
    return emitFlipUint64Uint8(I);
  case PT_Sint16:
    return emitFlipUint64Sint16(I);
  case PT_Uint16:
    return emitFlipUint64Uint16(I);
  case PT_Sint32:
    return emitFlipUint64Sint32(I);
  case PT_Uint32:
    return emitFlipUint64Uint32(I);
  case PT_Sint64:
    return emitFlipUint64Sint64(I);
  case PT_Uint64:
    return emitFlipUint64Uint64(I);
  case PT_IntAP:
    return emitFlipUint64IntAP(I);
  case PT_IntAPS:
    return emitFlipUint64IntAPS(I);
  case PT_Bool:
    return emitFlipUint64Bool(I);
  case PT_FixedPoint:
    return emitFlipUint64FixedPoint(I);
  case PT_Ptr:
    return emitFlipUint64Ptr(I);
  case PT_MemberPtr:
    return emitFlipUint64MemberPtr(I);
  case PT_Float:
    return emitFlipUint64Float(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_IntAP:
  switch (T1) {
  case PT_Sint8:
    return emitFlipIntAPSint8(I);
  case PT_Uint8:
    return emitFlipIntAPUint8(I);
  case PT_Sint16:
    return emitFlipIntAPSint16(I);
  case PT_Uint16:
    return emitFlipIntAPUint16(I);
  case PT_Sint32:
    return emitFlipIntAPSint32(I);
  case PT_Uint32:
    return emitFlipIntAPUint32(I);
  case PT_Sint64:
    return emitFlipIntAPSint64(I);
  case PT_Uint64:
    return emitFlipIntAPUint64(I);
  case PT_IntAP:
    return emitFlipIntAPIntAP(I);
  case PT_IntAPS:
    return emitFlipIntAPIntAPS(I);
  case PT_Bool:
    return emitFlipIntAPBool(I);
  case PT_FixedPoint:
    return emitFlipIntAPFixedPoint(I);
  case PT_Ptr:
    return emitFlipIntAPPtr(I);
  case PT_MemberPtr:
    return emitFlipIntAPMemberPtr(I);
  case PT_Float:
    return emitFlipIntAPFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_IntAPS:
  switch (T1) {
  case PT_Sint8:
    return emitFlipIntAPSSint8(I);
  case PT_Uint8:
    return emitFlipIntAPSUint8(I);
  case PT_Sint16:
    return emitFlipIntAPSSint16(I);
  case PT_Uint16:
    return emitFlipIntAPSUint16(I);
  case PT_Sint32:
    return emitFlipIntAPSSint32(I);
  case PT_Uint32:
    return emitFlipIntAPSUint32(I);
  case PT_Sint64:
    return emitFlipIntAPSSint64(I);
  case PT_Uint64:
    return emitFlipIntAPSUint64(I);
  case PT_IntAP:
    return emitFlipIntAPSIntAP(I);
  case PT_IntAPS:
    return emitFlipIntAPSIntAPS(I);
  case PT_Bool:
    return emitFlipIntAPSBool(I);
  case PT_FixedPoint:
    return emitFlipIntAPSFixedPoint(I);
  case PT_Ptr:
    return emitFlipIntAPSPtr(I);
  case PT_MemberPtr:
    return emitFlipIntAPSMemberPtr(I);
  case PT_Float:
    return emitFlipIntAPSFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Bool:
  switch (T1) {
  case PT_Sint8:
    return emitFlipBoolSint8(I);
  case PT_Uint8:
    return emitFlipBoolUint8(I);
  case PT_Sint16:
    return emitFlipBoolSint16(I);
  case PT_Uint16:
    return emitFlipBoolUint16(I);
  case PT_Sint32:
    return emitFlipBoolSint32(I);
  case PT_Uint32:
    return emitFlipBoolUint32(I);
  case PT_Sint64:
    return emitFlipBoolSint64(I);
  case PT_Uint64:
    return emitFlipBoolUint64(I);
  case PT_IntAP:
    return emitFlipBoolIntAP(I);
  case PT_IntAPS:
    return emitFlipBoolIntAPS(I);
  case PT_Bool:
    return emitFlipBoolBool(I);
  case PT_FixedPoint:
    return emitFlipBoolFixedPoint(I);
  case PT_Ptr:
    return emitFlipBoolPtr(I);
  case PT_MemberPtr:
    return emitFlipBoolMemberPtr(I);
  case PT_Float:
    return emitFlipBoolFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_FixedPoint:
  switch (T1) {
  case PT_Sint8:
    return emitFlipFixedPointSint8(I);
  case PT_Uint8:
    return emitFlipFixedPointUint8(I);
  case PT_Sint16:
    return emitFlipFixedPointSint16(I);
  case PT_Uint16:
    return emitFlipFixedPointUint16(I);
  case PT_Sint32:
    return emitFlipFixedPointSint32(I);
  case PT_Uint32:
    return emitFlipFixedPointUint32(I);
  case PT_Sint64:
    return emitFlipFixedPointSint64(I);
  case PT_Uint64:
    return emitFlipFixedPointUint64(I);
  case PT_IntAP:
    return emitFlipFixedPointIntAP(I);
  case PT_IntAPS:
    return emitFlipFixedPointIntAPS(I);
  case PT_Bool:
    return emitFlipFixedPointBool(I);
  case PT_FixedPoint:
    return emitFlipFixedPointFixedPoint(I);
  case PT_Ptr:
    return emitFlipFixedPointPtr(I);
  case PT_MemberPtr:
    return emitFlipFixedPointMemberPtr(I);
  case PT_Float:
    return emitFlipFixedPointFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Ptr:
  switch (T1) {
  case PT_Sint8:
    return emitFlipPtrSint8(I);
  case PT_Uint8:
    return emitFlipPtrUint8(I);
  case PT_Sint16:
    return emitFlipPtrSint16(I);
  case PT_Uint16:
    return emitFlipPtrUint16(I);
  case PT_Sint32:
    return emitFlipPtrSint32(I);
  case PT_Uint32:
    return emitFlipPtrUint32(I);
  case PT_Sint64:
    return emitFlipPtrSint64(I);
  case PT_Uint64:
    return emitFlipPtrUint64(I);
  case PT_IntAP:
    return emitFlipPtrIntAP(I);
  case PT_IntAPS:
    return emitFlipPtrIntAPS(I);
  case PT_Bool:
    return emitFlipPtrBool(I);
  case PT_FixedPoint:
    return emitFlipPtrFixedPoint(I);
  case PT_Ptr:
    return emitFlipPtrPtr(I);
  case PT_MemberPtr:
    return emitFlipPtrMemberPtr(I);
  case PT_Float:
    return emitFlipPtrFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_MemberPtr:
  switch (T1) {
  case PT_Sint8:
    return emitFlipMemberPtrSint8(I);
  case PT_Uint8:
    return emitFlipMemberPtrUint8(I);
  case PT_Sint16:
    return emitFlipMemberPtrSint16(I);
  case PT_Uint16:
    return emitFlipMemberPtrUint16(I);
  case PT_Sint32:
    return emitFlipMemberPtrSint32(I);
  case PT_Uint32:
    return emitFlipMemberPtrUint32(I);
  case PT_Sint64:
    return emitFlipMemberPtrSint64(I);
  case PT_Uint64:
    return emitFlipMemberPtrUint64(I);
  case PT_IntAP:
    return emitFlipMemberPtrIntAP(I);
  case PT_IntAPS:
    return emitFlipMemberPtrIntAPS(I);
  case PT_Bool:
    return emitFlipMemberPtrBool(I);
  case PT_FixedPoint:
    return emitFlipMemberPtrFixedPoint(I);
  case PT_Ptr:
    return emitFlipMemberPtrPtr(I);
  case PT_MemberPtr:
    return emitFlipMemberPtrMemberPtr(I);
  case PT_Float:
    return emitFlipMemberPtrFloat(I);
  }
  llvm_unreachable("invalid enum value");
  case PT_Float:
  switch (T1) {
  case PT_Sint8:
    return emitFlipFloatSint8(I);
  case PT_Uint8:
    return emitFlipFloatUint8(I);
  case PT_Sint16:
    return emitFlipFloatSint16(I);
  case PT_Uint16:
    return emitFlipFloatUint16(I);
  case PT_Sint32:
    return emitFlipFloatSint32(I);
  case PT_Uint32:
    return emitFlipFloatUint32(I);
  case PT_Sint64:
    return emitFlipFloatSint64(I);
  case PT_Uint64:
    return emitFlipFloatUint64(I);
  case PT_IntAP:
    return emitFlipFloatIntAP(I);
  case PT_IntAPS:
    return emitFlipFloatIntAPS(I);
  case PT_Bool:
    return emitFlipFloatBool(I);
  case PT_FixedPoint:
    return emitFlipFloatFixedPoint(I);
  case PT_Ptr:
    return emitFlipFloatPtr(I);
  case PT_MemberPtr:
    return emitFlipFloatMemberPtr(I);
  case PT_Float:
    return emitFlipFloatFloat(I);
  }
  llvm_unreachable("invalid enum value");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFlipSint8Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Sint8, L);
}
bool ByteCodeEmitter::emitFlipSint8Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Uint8, L);
}
bool ByteCodeEmitter::emitFlipSint8Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Sint16, L);
}
bool ByteCodeEmitter::emitFlipSint8Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Uint16, L);
}
bool ByteCodeEmitter::emitFlipSint8Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Sint32, L);
}
bool ByteCodeEmitter::emitFlipSint8Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Uint32, L);
}
bool ByteCodeEmitter::emitFlipSint8Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Sint64, L);
}
bool ByteCodeEmitter::emitFlipSint8Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Uint64, L);
}
bool ByteCodeEmitter::emitFlipSint8IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipSint8IntAP, L);
}
bool ByteCodeEmitter::emitFlipSint8IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipSint8IntAPS, L);
}
bool ByteCodeEmitter::emitFlipSint8Bool(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Bool, L);
}
bool ByteCodeEmitter::emitFlipSint8FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipSint8FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipSint8Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Ptr, L);
}
bool ByteCodeEmitter::emitFlipSint8MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipSint8MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipSint8Float(SourceInfo L) {
  return emitOp<>(OP_FlipSint8Float, L);
}
bool ByteCodeEmitter::emitFlipUint8Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Sint8, L);
}
bool ByteCodeEmitter::emitFlipUint8Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Uint8, L);
}
bool ByteCodeEmitter::emitFlipUint8Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Sint16, L);
}
bool ByteCodeEmitter::emitFlipUint8Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Uint16, L);
}
bool ByteCodeEmitter::emitFlipUint8Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Sint32, L);
}
bool ByteCodeEmitter::emitFlipUint8Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Uint32, L);
}
bool ByteCodeEmitter::emitFlipUint8Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Sint64, L);
}
bool ByteCodeEmitter::emitFlipUint8Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Uint64, L);
}
bool ByteCodeEmitter::emitFlipUint8IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipUint8IntAP, L);
}
bool ByteCodeEmitter::emitFlipUint8IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipUint8IntAPS, L);
}
bool ByteCodeEmitter::emitFlipUint8Bool(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Bool, L);
}
bool ByteCodeEmitter::emitFlipUint8FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipUint8FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipUint8Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Ptr, L);
}
bool ByteCodeEmitter::emitFlipUint8MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipUint8MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipUint8Float(SourceInfo L) {
  return emitOp<>(OP_FlipUint8Float, L);
}
bool ByteCodeEmitter::emitFlipSint16Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Sint8, L);
}
bool ByteCodeEmitter::emitFlipSint16Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Uint8, L);
}
bool ByteCodeEmitter::emitFlipSint16Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Sint16, L);
}
bool ByteCodeEmitter::emitFlipSint16Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Uint16, L);
}
bool ByteCodeEmitter::emitFlipSint16Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Sint32, L);
}
bool ByteCodeEmitter::emitFlipSint16Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Uint32, L);
}
bool ByteCodeEmitter::emitFlipSint16Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Sint64, L);
}
bool ByteCodeEmitter::emitFlipSint16Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Uint64, L);
}
bool ByteCodeEmitter::emitFlipSint16IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipSint16IntAP, L);
}
bool ByteCodeEmitter::emitFlipSint16IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipSint16IntAPS, L);
}
bool ByteCodeEmitter::emitFlipSint16Bool(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Bool, L);
}
bool ByteCodeEmitter::emitFlipSint16FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipSint16FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipSint16Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Ptr, L);
}
bool ByteCodeEmitter::emitFlipSint16MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipSint16MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipSint16Float(SourceInfo L) {
  return emitOp<>(OP_FlipSint16Float, L);
}
bool ByteCodeEmitter::emitFlipUint16Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Sint8, L);
}
bool ByteCodeEmitter::emitFlipUint16Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Uint8, L);
}
bool ByteCodeEmitter::emitFlipUint16Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Sint16, L);
}
bool ByteCodeEmitter::emitFlipUint16Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Uint16, L);
}
bool ByteCodeEmitter::emitFlipUint16Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Sint32, L);
}
bool ByteCodeEmitter::emitFlipUint16Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Uint32, L);
}
bool ByteCodeEmitter::emitFlipUint16Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Sint64, L);
}
bool ByteCodeEmitter::emitFlipUint16Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Uint64, L);
}
bool ByteCodeEmitter::emitFlipUint16IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipUint16IntAP, L);
}
bool ByteCodeEmitter::emitFlipUint16IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipUint16IntAPS, L);
}
bool ByteCodeEmitter::emitFlipUint16Bool(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Bool, L);
}
bool ByteCodeEmitter::emitFlipUint16FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipUint16FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipUint16Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Ptr, L);
}
bool ByteCodeEmitter::emitFlipUint16MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipUint16MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipUint16Float(SourceInfo L) {
  return emitOp<>(OP_FlipUint16Float, L);
}
bool ByteCodeEmitter::emitFlipSint32Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Sint8, L);
}
bool ByteCodeEmitter::emitFlipSint32Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Uint8, L);
}
bool ByteCodeEmitter::emitFlipSint32Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Sint16, L);
}
bool ByteCodeEmitter::emitFlipSint32Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Uint16, L);
}
bool ByteCodeEmitter::emitFlipSint32Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Sint32, L);
}
bool ByteCodeEmitter::emitFlipSint32Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Uint32, L);
}
bool ByteCodeEmitter::emitFlipSint32Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Sint64, L);
}
bool ByteCodeEmitter::emitFlipSint32Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Uint64, L);
}
bool ByteCodeEmitter::emitFlipSint32IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipSint32IntAP, L);
}
bool ByteCodeEmitter::emitFlipSint32IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipSint32IntAPS, L);
}
bool ByteCodeEmitter::emitFlipSint32Bool(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Bool, L);
}
bool ByteCodeEmitter::emitFlipSint32FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipSint32FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipSint32Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Ptr, L);
}
bool ByteCodeEmitter::emitFlipSint32MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipSint32MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipSint32Float(SourceInfo L) {
  return emitOp<>(OP_FlipSint32Float, L);
}
bool ByteCodeEmitter::emitFlipUint32Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Sint8, L);
}
bool ByteCodeEmitter::emitFlipUint32Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Uint8, L);
}
bool ByteCodeEmitter::emitFlipUint32Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Sint16, L);
}
bool ByteCodeEmitter::emitFlipUint32Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Uint16, L);
}
bool ByteCodeEmitter::emitFlipUint32Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Sint32, L);
}
bool ByteCodeEmitter::emitFlipUint32Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Uint32, L);
}
bool ByteCodeEmitter::emitFlipUint32Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Sint64, L);
}
bool ByteCodeEmitter::emitFlipUint32Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Uint64, L);
}
bool ByteCodeEmitter::emitFlipUint32IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipUint32IntAP, L);
}
bool ByteCodeEmitter::emitFlipUint32IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipUint32IntAPS, L);
}
bool ByteCodeEmitter::emitFlipUint32Bool(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Bool, L);
}
bool ByteCodeEmitter::emitFlipUint32FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipUint32FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipUint32Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Ptr, L);
}
bool ByteCodeEmitter::emitFlipUint32MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipUint32MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipUint32Float(SourceInfo L) {
  return emitOp<>(OP_FlipUint32Float, L);
}
bool ByteCodeEmitter::emitFlipSint64Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Sint8, L);
}
bool ByteCodeEmitter::emitFlipSint64Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Uint8, L);
}
bool ByteCodeEmitter::emitFlipSint64Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Sint16, L);
}
bool ByteCodeEmitter::emitFlipSint64Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Uint16, L);
}
bool ByteCodeEmitter::emitFlipSint64Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Sint32, L);
}
bool ByteCodeEmitter::emitFlipSint64Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Uint32, L);
}
bool ByteCodeEmitter::emitFlipSint64Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Sint64, L);
}
bool ByteCodeEmitter::emitFlipSint64Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Uint64, L);
}
bool ByteCodeEmitter::emitFlipSint64IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipSint64IntAP, L);
}
bool ByteCodeEmitter::emitFlipSint64IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipSint64IntAPS, L);
}
bool ByteCodeEmitter::emitFlipSint64Bool(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Bool, L);
}
bool ByteCodeEmitter::emitFlipSint64FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipSint64FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipSint64Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Ptr, L);
}
bool ByteCodeEmitter::emitFlipSint64MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipSint64MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipSint64Float(SourceInfo L) {
  return emitOp<>(OP_FlipSint64Float, L);
}
bool ByteCodeEmitter::emitFlipUint64Sint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Sint8, L);
}
bool ByteCodeEmitter::emitFlipUint64Uint8(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Uint8, L);
}
bool ByteCodeEmitter::emitFlipUint64Sint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Sint16, L);
}
bool ByteCodeEmitter::emitFlipUint64Uint16(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Uint16, L);
}
bool ByteCodeEmitter::emitFlipUint64Sint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Sint32, L);
}
bool ByteCodeEmitter::emitFlipUint64Uint32(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Uint32, L);
}
bool ByteCodeEmitter::emitFlipUint64Sint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Sint64, L);
}
bool ByteCodeEmitter::emitFlipUint64Uint64(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Uint64, L);
}
bool ByteCodeEmitter::emitFlipUint64IntAP(SourceInfo L) {
  return emitOp<>(OP_FlipUint64IntAP, L);
}
bool ByteCodeEmitter::emitFlipUint64IntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipUint64IntAPS, L);
}
bool ByteCodeEmitter::emitFlipUint64Bool(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Bool, L);
}
bool ByteCodeEmitter::emitFlipUint64FixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipUint64FixedPoint, L);
}
bool ByteCodeEmitter::emitFlipUint64Ptr(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Ptr, L);
}
bool ByteCodeEmitter::emitFlipUint64MemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipUint64MemberPtr, L);
}
bool ByteCodeEmitter::emitFlipUint64Float(SourceInfo L) {
  return emitOp<>(OP_FlipUint64Float, L);
}
bool ByteCodeEmitter::emitFlipIntAPSint8(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSint8, L);
}
bool ByteCodeEmitter::emitFlipIntAPUint8(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPUint8, L);
}
bool ByteCodeEmitter::emitFlipIntAPSint16(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSint16, L);
}
bool ByteCodeEmitter::emitFlipIntAPUint16(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPUint16, L);
}
bool ByteCodeEmitter::emitFlipIntAPSint32(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSint32, L);
}
bool ByteCodeEmitter::emitFlipIntAPUint32(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPUint32, L);
}
bool ByteCodeEmitter::emitFlipIntAPSint64(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSint64, L);
}
bool ByteCodeEmitter::emitFlipIntAPUint64(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPUint64, L);
}
bool ByteCodeEmitter::emitFlipIntAPIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPIntAP, L);
}
bool ByteCodeEmitter::emitFlipIntAPIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPIntAPS, L);
}
bool ByteCodeEmitter::emitFlipIntAPBool(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPBool, L);
}
bool ByteCodeEmitter::emitFlipIntAPFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipIntAPPtr(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPPtr, L);
}
bool ByteCodeEmitter::emitFlipIntAPMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipIntAPFloat(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPFloat, L);
}
bool ByteCodeEmitter::emitFlipIntAPSSint8(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSSint8, L);
}
bool ByteCodeEmitter::emitFlipIntAPSUint8(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSUint8, L);
}
bool ByteCodeEmitter::emitFlipIntAPSSint16(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSSint16, L);
}
bool ByteCodeEmitter::emitFlipIntAPSUint16(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSUint16, L);
}
bool ByteCodeEmitter::emitFlipIntAPSSint32(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSSint32, L);
}
bool ByteCodeEmitter::emitFlipIntAPSUint32(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSUint32, L);
}
bool ByteCodeEmitter::emitFlipIntAPSSint64(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSSint64, L);
}
bool ByteCodeEmitter::emitFlipIntAPSUint64(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSUint64, L);
}
bool ByteCodeEmitter::emitFlipIntAPSIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSIntAP, L);
}
bool ByteCodeEmitter::emitFlipIntAPSIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSIntAPS, L);
}
bool ByteCodeEmitter::emitFlipIntAPSBool(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSBool, L);
}
bool ByteCodeEmitter::emitFlipIntAPSFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipIntAPSPtr(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSPtr, L);
}
bool ByteCodeEmitter::emitFlipIntAPSMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipIntAPSFloat(SourceInfo L) {
  return emitOp<>(OP_FlipIntAPSFloat, L);
}
bool ByteCodeEmitter::emitFlipBoolSint8(SourceInfo L) {
  return emitOp<>(OP_FlipBoolSint8, L);
}
bool ByteCodeEmitter::emitFlipBoolUint8(SourceInfo L) {
  return emitOp<>(OP_FlipBoolUint8, L);
}
bool ByteCodeEmitter::emitFlipBoolSint16(SourceInfo L) {
  return emitOp<>(OP_FlipBoolSint16, L);
}
bool ByteCodeEmitter::emitFlipBoolUint16(SourceInfo L) {
  return emitOp<>(OP_FlipBoolUint16, L);
}
bool ByteCodeEmitter::emitFlipBoolSint32(SourceInfo L) {
  return emitOp<>(OP_FlipBoolSint32, L);
}
bool ByteCodeEmitter::emitFlipBoolUint32(SourceInfo L) {
  return emitOp<>(OP_FlipBoolUint32, L);
}
bool ByteCodeEmitter::emitFlipBoolSint64(SourceInfo L) {
  return emitOp<>(OP_FlipBoolSint64, L);
}
bool ByteCodeEmitter::emitFlipBoolUint64(SourceInfo L) {
  return emitOp<>(OP_FlipBoolUint64, L);
}
bool ByteCodeEmitter::emitFlipBoolIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipBoolIntAP, L);
}
bool ByteCodeEmitter::emitFlipBoolIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipBoolIntAPS, L);
}
bool ByteCodeEmitter::emitFlipBoolBool(SourceInfo L) {
  return emitOp<>(OP_FlipBoolBool, L);
}
bool ByteCodeEmitter::emitFlipBoolFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipBoolFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipBoolPtr(SourceInfo L) {
  return emitOp<>(OP_FlipBoolPtr, L);
}
bool ByteCodeEmitter::emitFlipBoolMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipBoolMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipBoolFloat(SourceInfo L) {
  return emitOp<>(OP_FlipBoolFloat, L);
}
bool ByteCodeEmitter::emitFlipFixedPointSint8(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointSint8, L);
}
bool ByteCodeEmitter::emitFlipFixedPointUint8(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointUint8, L);
}
bool ByteCodeEmitter::emitFlipFixedPointSint16(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointSint16, L);
}
bool ByteCodeEmitter::emitFlipFixedPointUint16(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointUint16, L);
}
bool ByteCodeEmitter::emitFlipFixedPointSint32(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointSint32, L);
}
bool ByteCodeEmitter::emitFlipFixedPointUint32(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointUint32, L);
}
bool ByteCodeEmitter::emitFlipFixedPointSint64(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointSint64, L);
}
bool ByteCodeEmitter::emitFlipFixedPointUint64(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointUint64, L);
}
bool ByteCodeEmitter::emitFlipFixedPointIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointIntAP, L);
}
bool ByteCodeEmitter::emitFlipFixedPointIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointIntAPS, L);
}
bool ByteCodeEmitter::emitFlipFixedPointBool(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointBool, L);
}
bool ByteCodeEmitter::emitFlipFixedPointFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipFixedPointPtr(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointPtr, L);
}
bool ByteCodeEmitter::emitFlipFixedPointMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipFixedPointFloat(SourceInfo L) {
  return emitOp<>(OP_FlipFixedPointFloat, L);
}
bool ByteCodeEmitter::emitFlipPtrSint8(SourceInfo L) {
  return emitOp<>(OP_FlipPtrSint8, L);
}
bool ByteCodeEmitter::emitFlipPtrUint8(SourceInfo L) {
  return emitOp<>(OP_FlipPtrUint8, L);
}
bool ByteCodeEmitter::emitFlipPtrSint16(SourceInfo L) {
  return emitOp<>(OP_FlipPtrSint16, L);
}
bool ByteCodeEmitter::emitFlipPtrUint16(SourceInfo L) {
  return emitOp<>(OP_FlipPtrUint16, L);
}
bool ByteCodeEmitter::emitFlipPtrSint32(SourceInfo L) {
  return emitOp<>(OP_FlipPtrSint32, L);
}
bool ByteCodeEmitter::emitFlipPtrUint32(SourceInfo L) {
  return emitOp<>(OP_FlipPtrUint32, L);
}
bool ByteCodeEmitter::emitFlipPtrSint64(SourceInfo L) {
  return emitOp<>(OP_FlipPtrSint64, L);
}
bool ByteCodeEmitter::emitFlipPtrUint64(SourceInfo L) {
  return emitOp<>(OP_FlipPtrUint64, L);
}
bool ByteCodeEmitter::emitFlipPtrIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipPtrIntAP, L);
}
bool ByteCodeEmitter::emitFlipPtrIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipPtrIntAPS, L);
}
bool ByteCodeEmitter::emitFlipPtrBool(SourceInfo L) {
  return emitOp<>(OP_FlipPtrBool, L);
}
bool ByteCodeEmitter::emitFlipPtrFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipPtrFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipPtrPtr(SourceInfo L) {
  return emitOp<>(OP_FlipPtrPtr, L);
}
bool ByteCodeEmitter::emitFlipPtrMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipPtrMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipPtrFloat(SourceInfo L) {
  return emitOp<>(OP_FlipPtrFloat, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrSint8(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrSint8, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrUint8(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrUint8, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrSint16(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrSint16, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrUint16(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrUint16, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrSint32(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrSint32, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrUint32(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrUint32, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrSint64(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrSint64, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrUint64(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrUint64, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrIntAP, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrIntAPS, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrBool(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrBool, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrPtr(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrPtr, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipMemberPtrFloat(SourceInfo L) {
  return emitOp<>(OP_FlipMemberPtrFloat, L);
}
bool ByteCodeEmitter::emitFlipFloatSint8(SourceInfo L) {
  return emitOp<>(OP_FlipFloatSint8, L);
}
bool ByteCodeEmitter::emitFlipFloatUint8(SourceInfo L) {
  return emitOp<>(OP_FlipFloatUint8, L);
}
bool ByteCodeEmitter::emitFlipFloatSint16(SourceInfo L) {
  return emitOp<>(OP_FlipFloatSint16, L);
}
bool ByteCodeEmitter::emitFlipFloatUint16(SourceInfo L) {
  return emitOp<>(OP_FlipFloatUint16, L);
}
bool ByteCodeEmitter::emitFlipFloatSint32(SourceInfo L) {
  return emitOp<>(OP_FlipFloatSint32, L);
}
bool ByteCodeEmitter::emitFlipFloatUint32(SourceInfo L) {
  return emitOp<>(OP_FlipFloatUint32, L);
}
bool ByteCodeEmitter::emitFlipFloatSint64(SourceInfo L) {
  return emitOp<>(OP_FlipFloatSint64, L);
}
bool ByteCodeEmitter::emitFlipFloatUint64(SourceInfo L) {
  return emitOp<>(OP_FlipFloatUint64, L);
}
bool ByteCodeEmitter::emitFlipFloatIntAP(SourceInfo L) {
  return emitOp<>(OP_FlipFloatIntAP, L);
}
bool ByteCodeEmitter::emitFlipFloatIntAPS(SourceInfo L) {
  return emitOp<>(OP_FlipFloatIntAPS, L);
}
bool ByteCodeEmitter::emitFlipFloatBool(SourceInfo L) {
  return emitOp<>(OP_FlipFloatBool, L);
}
bool ByteCodeEmitter::emitFlipFloatFixedPoint(SourceInfo L) {
  return emitOp<>(OP_FlipFloatFixedPoint, L);
}
bool ByteCodeEmitter::emitFlipFloatPtr(SourceInfo L) {
  return emitOp<>(OP_FlipFloatPtr, L);
}
bool ByteCodeEmitter::emitFlipFloatMemberPtr(SourceInfo L) {
  return emitOp<>(OP_FlipFloatMemberPtr, L);
}
bool ByteCodeEmitter::emitFlipFloatFloat(SourceInfo L) {
  return emitOp<>(OP_FlipFloatFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFlipSint8Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint8Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint8, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint8Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint8, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint16Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint16, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint16Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint16, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint32Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint32, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint32Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint32, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipSint64Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Sint64, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Sint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Uint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Sint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Uint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Sint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Uint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Sint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Uint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64IntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64IntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Bool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64FixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Ptr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64MemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipUint64Float(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Uint64, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAP, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipIntAPSFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_IntAPS, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipBoolFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Bool, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipFixedPointFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_FixedPoint, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipPtrFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Ptr, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipMemberPtrFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_MemberPtr, PT_Float>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitFlipFloatFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Flip<PT_Float, PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_FnPtrCast,
#endif
#ifdef GET_INTERP
case OP_FnPtrCast: {
  if (!FnPtrCast(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_FnPtrCast:
  Text.Op = PrintName("FnPtrCast");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFnPtrCast(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFnPtrCast(SourceInfo L) {
  return emitOp<>(OP_FnPtrCast, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFnPtrCast(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return FnPtrCast(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Free,
#endif
#ifdef GET_INTERP
case OP_Free: {
  const auto V0 = ReadArg<bool>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!Free(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Free:
  Text.Op = PrintName("Free");
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitFree( bool ,  bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitFree( bool A0,  bool A1, SourceInfo L) {
  return emitOp<bool, bool>(OP_Free, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitFree( bool A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Free(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GESint8,
OP_GEUint8,
OP_GESint16,
OP_GEUint16,
OP_GESint32,
OP_GEUint32,
OP_GESint64,
OP_GEUint64,
OP_GEIntAP,
OP_GEIntAPS,
OP_GEBool,
OP_GEFixedPoint,
OP_GEPtr,
OP_GEFloat,
#endif
#ifdef GET_INTERP
case OP_GESint8: {
  if (!GE<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_GEUint8: {
  if (!GE<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_GESint16: {
  if (!GE<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_GEUint16: {
  if (!GE<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_GESint32: {
  if (!GE<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_GEUint32: {
  if (!GE<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_GESint64: {
  if (!GE<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_GEUint64: {
  if (!GE<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_GEIntAP: {
  if (!GE<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_GEIntAPS: {
  if (!GE<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_GEBool: {
  if (!GE<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_GEFixedPoint: {
  if (!GE<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_GEPtr: {
  if (!GE<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_GEFloat: {
  if (!GE<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GESint8:
  Text.Op = PrintName("GESint8");
  break;
case OP_GEUint8:
  Text.Op = PrintName("GEUint8");
  break;
case OP_GESint16:
  Text.Op = PrintName("GESint16");
  break;
case OP_GEUint16:
  Text.Op = PrintName("GEUint16");
  break;
case OP_GESint32:
  Text.Op = PrintName("GESint32");
  break;
case OP_GEUint32:
  Text.Op = PrintName("GEUint32");
  break;
case OP_GESint64:
  Text.Op = PrintName("GESint64");
  break;
case OP_GEUint64:
  Text.Op = PrintName("GEUint64");
  break;
case OP_GEIntAP:
  Text.Op = PrintName("GEIntAP");
  break;
case OP_GEIntAPS:
  Text.Op = PrintName("GEIntAPS");
  break;
case OP_GEBool:
  Text.Op = PrintName("GEBool");
  break;
case OP_GEFixedPoint:
  Text.Op = PrintName("GEFixedPoint");
  break;
case OP_GEPtr:
  Text.Op = PrintName("GEPtr");
  break;
case OP_GEFloat:
  Text.Op = PrintName("GEFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGESint8(SourceInfo);
bool emitGEUint8(SourceInfo);
bool emitGESint16(SourceInfo);
bool emitGEUint16(SourceInfo);
bool emitGESint32(SourceInfo);
bool emitGEUint32(SourceInfo);
bool emitGESint64(SourceInfo);
bool emitGEUint64(SourceInfo);
bool emitGEIntAP(SourceInfo);
bool emitGEIntAPS(SourceInfo);
bool emitGEBool(SourceInfo);
bool emitGEFixedPoint(SourceInfo);
bool emitGEPtr(SourceInfo);
bool emitGEFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGE(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGE(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGESint8(I);
  case PT_Uint8:
    return emitGEUint8(I);
  case PT_Sint16:
    return emitGESint16(I);
  case PT_Uint16:
    return emitGEUint16(I);
  case PT_Sint32:
    return emitGESint32(I);
  case PT_Uint32:
    return emitGEUint32(I);
  case PT_Sint64:
    return emitGESint64(I);
  case PT_Uint64:
    return emitGEUint64(I);
  case PT_IntAP:
    return emitGEIntAP(I);
  case PT_IntAPS:
    return emitGEIntAPS(I);
  case PT_Bool:
    return emitGEBool(I);
  case PT_FixedPoint:
    return emitGEFixedPoint(I);
  case PT_Ptr:
    return emitGEPtr(I);
  case PT_Float:
    return emitGEFloat(I);
  default: llvm_unreachable("invalid type: emitGE");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGESint8(SourceInfo L) {
  return emitOp<>(OP_GESint8, L);
}
bool ByteCodeEmitter::emitGEUint8(SourceInfo L) {
  return emitOp<>(OP_GEUint8, L);
}
bool ByteCodeEmitter::emitGESint16(SourceInfo L) {
  return emitOp<>(OP_GESint16, L);
}
bool ByteCodeEmitter::emitGEUint16(SourceInfo L) {
  return emitOp<>(OP_GEUint16, L);
}
bool ByteCodeEmitter::emitGESint32(SourceInfo L) {
  return emitOp<>(OP_GESint32, L);
}
bool ByteCodeEmitter::emitGEUint32(SourceInfo L) {
  return emitOp<>(OP_GEUint32, L);
}
bool ByteCodeEmitter::emitGESint64(SourceInfo L) {
  return emitOp<>(OP_GESint64, L);
}
bool ByteCodeEmitter::emitGEUint64(SourceInfo L) {
  return emitOp<>(OP_GEUint64, L);
}
bool ByteCodeEmitter::emitGEIntAP(SourceInfo L) {
  return emitOp<>(OP_GEIntAP, L);
}
bool ByteCodeEmitter::emitGEIntAPS(SourceInfo L) {
  return emitOp<>(OP_GEIntAPS, L);
}
bool ByteCodeEmitter::emitGEBool(SourceInfo L) {
  return emitOp<>(OP_GEBool, L);
}
bool ByteCodeEmitter::emitGEFixedPoint(SourceInfo L) {
  return emitOp<>(OP_GEFixedPoint, L);
}
bool ByteCodeEmitter::emitGEPtr(SourceInfo L) {
  return emitOp<>(OP_GEPtr, L);
}
bool ByteCodeEmitter::emitGEFloat(SourceInfo L) {
  return emitOp<>(OP_GEFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGESint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitGEUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitGESint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitGEUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitGESint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitGEUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitGESint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitGEUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitGEIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitGEIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitGEBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitGEFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitGEPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitGEFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GE<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GTSint8,
OP_GTUint8,
OP_GTSint16,
OP_GTUint16,
OP_GTSint32,
OP_GTUint32,
OP_GTSint64,
OP_GTUint64,
OP_GTIntAP,
OP_GTIntAPS,
OP_GTBool,
OP_GTFixedPoint,
OP_GTPtr,
OP_GTFloat,
#endif
#ifdef GET_INTERP
case OP_GTSint8: {
  if (!GT<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_GTUint8: {
  if (!GT<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_GTSint16: {
  if (!GT<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_GTUint16: {
  if (!GT<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_GTSint32: {
  if (!GT<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_GTUint32: {
  if (!GT<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_GTSint64: {
  if (!GT<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_GTUint64: {
  if (!GT<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_GTIntAP: {
  if (!GT<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_GTIntAPS: {
  if (!GT<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_GTBool: {
  if (!GT<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_GTFixedPoint: {
  if (!GT<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_GTPtr: {
  if (!GT<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_GTFloat: {
  if (!GT<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GTSint8:
  Text.Op = PrintName("GTSint8");
  break;
case OP_GTUint8:
  Text.Op = PrintName("GTUint8");
  break;
case OP_GTSint16:
  Text.Op = PrintName("GTSint16");
  break;
case OP_GTUint16:
  Text.Op = PrintName("GTUint16");
  break;
case OP_GTSint32:
  Text.Op = PrintName("GTSint32");
  break;
case OP_GTUint32:
  Text.Op = PrintName("GTUint32");
  break;
case OP_GTSint64:
  Text.Op = PrintName("GTSint64");
  break;
case OP_GTUint64:
  Text.Op = PrintName("GTUint64");
  break;
case OP_GTIntAP:
  Text.Op = PrintName("GTIntAP");
  break;
case OP_GTIntAPS:
  Text.Op = PrintName("GTIntAPS");
  break;
case OP_GTBool:
  Text.Op = PrintName("GTBool");
  break;
case OP_GTFixedPoint:
  Text.Op = PrintName("GTFixedPoint");
  break;
case OP_GTPtr:
  Text.Op = PrintName("GTPtr");
  break;
case OP_GTFloat:
  Text.Op = PrintName("GTFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGTSint8(SourceInfo);
bool emitGTUint8(SourceInfo);
bool emitGTSint16(SourceInfo);
bool emitGTUint16(SourceInfo);
bool emitGTSint32(SourceInfo);
bool emitGTUint32(SourceInfo);
bool emitGTSint64(SourceInfo);
bool emitGTUint64(SourceInfo);
bool emitGTIntAP(SourceInfo);
bool emitGTIntAPS(SourceInfo);
bool emitGTBool(SourceInfo);
bool emitGTFixedPoint(SourceInfo);
bool emitGTPtr(SourceInfo);
bool emitGTFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGT(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGT(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGTSint8(I);
  case PT_Uint8:
    return emitGTUint8(I);
  case PT_Sint16:
    return emitGTSint16(I);
  case PT_Uint16:
    return emitGTUint16(I);
  case PT_Sint32:
    return emitGTSint32(I);
  case PT_Uint32:
    return emitGTUint32(I);
  case PT_Sint64:
    return emitGTSint64(I);
  case PT_Uint64:
    return emitGTUint64(I);
  case PT_IntAP:
    return emitGTIntAP(I);
  case PT_IntAPS:
    return emitGTIntAPS(I);
  case PT_Bool:
    return emitGTBool(I);
  case PT_FixedPoint:
    return emitGTFixedPoint(I);
  case PT_Ptr:
    return emitGTPtr(I);
  case PT_Float:
    return emitGTFloat(I);
  default: llvm_unreachable("invalid type: emitGT");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGTSint8(SourceInfo L) {
  return emitOp<>(OP_GTSint8, L);
}
bool ByteCodeEmitter::emitGTUint8(SourceInfo L) {
  return emitOp<>(OP_GTUint8, L);
}
bool ByteCodeEmitter::emitGTSint16(SourceInfo L) {
  return emitOp<>(OP_GTSint16, L);
}
bool ByteCodeEmitter::emitGTUint16(SourceInfo L) {
  return emitOp<>(OP_GTUint16, L);
}
bool ByteCodeEmitter::emitGTSint32(SourceInfo L) {
  return emitOp<>(OP_GTSint32, L);
}
bool ByteCodeEmitter::emitGTUint32(SourceInfo L) {
  return emitOp<>(OP_GTUint32, L);
}
bool ByteCodeEmitter::emitGTSint64(SourceInfo L) {
  return emitOp<>(OP_GTSint64, L);
}
bool ByteCodeEmitter::emitGTUint64(SourceInfo L) {
  return emitOp<>(OP_GTUint64, L);
}
bool ByteCodeEmitter::emitGTIntAP(SourceInfo L) {
  return emitOp<>(OP_GTIntAP, L);
}
bool ByteCodeEmitter::emitGTIntAPS(SourceInfo L) {
  return emitOp<>(OP_GTIntAPS, L);
}
bool ByteCodeEmitter::emitGTBool(SourceInfo L) {
  return emitOp<>(OP_GTBool, L);
}
bool ByteCodeEmitter::emitGTFixedPoint(SourceInfo L) {
  return emitOp<>(OP_GTFixedPoint, L);
}
bool ByteCodeEmitter::emitGTPtr(SourceInfo L) {
  return emitOp<>(OP_GTPtr, L);
}
bool ByteCodeEmitter::emitGTFloat(SourceInfo L) {
  return emitOp<>(OP_GTFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGTSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitGTUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitGTSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitGTUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitGTSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitGTUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitGTSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitGTUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitGTIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitGTIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitGTBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitGTFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitGTPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitGTFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GT<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetFieldSint8,
OP_GetFieldUint8,
OP_GetFieldSint16,
OP_GetFieldUint16,
OP_GetFieldSint32,
OP_GetFieldUint32,
OP_GetFieldSint64,
OP_GetFieldUint64,
OP_GetFieldIntAP,
OP_GetFieldIntAPS,
OP_GetFieldBool,
OP_GetFieldFixedPoint,
OP_GetFieldPtr,
OP_GetFieldMemberPtr,
OP_GetFieldFloat,
#endif
#ifdef GET_INTERP
case OP_GetFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetFieldSint8:
  Text.Op = PrintName("GetFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldUint8:
  Text.Op = PrintName("GetFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldSint16:
  Text.Op = PrintName("GetFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldUint16:
  Text.Op = PrintName("GetFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldSint32:
  Text.Op = PrintName("GetFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldUint32:
  Text.Op = PrintName("GetFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldSint64:
  Text.Op = PrintName("GetFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldUint64:
  Text.Op = PrintName("GetFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldIntAP:
  Text.Op = PrintName("GetFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldIntAPS:
  Text.Op = PrintName("GetFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldBool:
  Text.Op = PrintName("GetFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldFixedPoint:
  Text.Op = PrintName("GetFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPtr:
  Text.Op = PrintName("GetFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldMemberPtr:
  Text.Op = PrintName("GetFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldFloat:
  Text.Op = PrintName("GetFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetFieldSint8( uint32_t , SourceInfo);
bool emitGetFieldUint8( uint32_t , SourceInfo);
bool emitGetFieldSint16( uint32_t , SourceInfo);
bool emitGetFieldUint16( uint32_t , SourceInfo);
bool emitGetFieldSint32( uint32_t , SourceInfo);
bool emitGetFieldUint32( uint32_t , SourceInfo);
bool emitGetFieldSint64( uint32_t , SourceInfo);
bool emitGetFieldUint64( uint32_t , SourceInfo);
bool emitGetFieldIntAP( uint32_t , SourceInfo);
bool emitGetFieldIntAPS( uint32_t , SourceInfo);
bool emitGetFieldBool( uint32_t , SourceInfo);
bool emitGetFieldFixedPoint( uint32_t , SourceInfo);
bool emitGetFieldPtr( uint32_t , SourceInfo);
bool emitGetFieldMemberPtr( uint32_t , SourceInfo);
bool emitGetFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetFieldSint8(A0, I);
  case PT_Uint8:
    return emitGetFieldUint8(A0, I);
  case PT_Sint16:
    return emitGetFieldSint16(A0, I);
  case PT_Uint16:
    return emitGetFieldUint16(A0, I);
  case PT_Sint32:
    return emitGetFieldSint32(A0, I);
  case PT_Uint32:
    return emitGetFieldUint32(A0, I);
  case PT_Sint64:
    return emitGetFieldSint64(A0, I);
  case PT_Uint64:
    return emitGetFieldUint64(A0, I);
  case PT_IntAP:
    return emitGetFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitGetFieldIntAPS(A0, I);
  case PT_Bool:
    return emitGetFieldBool(A0, I);
  case PT_FixedPoint:
    return emitGetFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitGetFieldMemberPtr(A0, I);
  case PT_Float:
    return emitGetFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitGetFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitGetFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitGetFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitGetFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitGetFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitGetFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitGetFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitGetFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldBool, A0, L);
}
bool ByteCodeEmitter::emitGetFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitGetFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetFieldPopSint8,
OP_GetFieldPopUint8,
OP_GetFieldPopSint16,
OP_GetFieldPopUint16,
OP_GetFieldPopSint32,
OP_GetFieldPopUint32,
OP_GetFieldPopSint64,
OP_GetFieldPopUint64,
OP_GetFieldPopIntAP,
OP_GetFieldPopIntAPS,
OP_GetFieldPopBool,
OP_GetFieldPopFixedPoint,
OP_GetFieldPopPtr,
OP_GetFieldPopMemberPtr,
OP_GetFieldPopFloat,
#endif
#ifdef GET_INTERP
case OP_GetFieldPopSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetFieldPopFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetFieldPop<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetFieldPopSint8:
  Text.Op = PrintName("GetFieldPopSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopUint8:
  Text.Op = PrintName("GetFieldPopUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopSint16:
  Text.Op = PrintName("GetFieldPopSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopUint16:
  Text.Op = PrintName("GetFieldPopUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopSint32:
  Text.Op = PrintName("GetFieldPopSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopUint32:
  Text.Op = PrintName("GetFieldPopUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopSint64:
  Text.Op = PrintName("GetFieldPopSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopUint64:
  Text.Op = PrintName("GetFieldPopUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopIntAP:
  Text.Op = PrintName("GetFieldPopIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopIntAPS:
  Text.Op = PrintName("GetFieldPopIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopBool:
  Text.Op = PrintName("GetFieldPopBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopFixedPoint:
  Text.Op = PrintName("GetFieldPopFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopPtr:
  Text.Op = PrintName("GetFieldPopPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopMemberPtr:
  Text.Op = PrintName("GetFieldPopMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetFieldPopFloat:
  Text.Op = PrintName("GetFieldPopFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetFieldPopSint8( uint32_t , SourceInfo);
bool emitGetFieldPopUint8( uint32_t , SourceInfo);
bool emitGetFieldPopSint16( uint32_t , SourceInfo);
bool emitGetFieldPopUint16( uint32_t , SourceInfo);
bool emitGetFieldPopSint32( uint32_t , SourceInfo);
bool emitGetFieldPopUint32( uint32_t , SourceInfo);
bool emitGetFieldPopSint64( uint32_t , SourceInfo);
bool emitGetFieldPopUint64( uint32_t , SourceInfo);
bool emitGetFieldPopIntAP( uint32_t , SourceInfo);
bool emitGetFieldPopIntAPS( uint32_t , SourceInfo);
bool emitGetFieldPopBool( uint32_t , SourceInfo);
bool emitGetFieldPopFixedPoint( uint32_t , SourceInfo);
bool emitGetFieldPopPtr( uint32_t , SourceInfo);
bool emitGetFieldPopMemberPtr( uint32_t , SourceInfo);
bool emitGetFieldPopFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetFieldPop(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetFieldPop(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetFieldPopSint8(A0, I);
  case PT_Uint8:
    return emitGetFieldPopUint8(A0, I);
  case PT_Sint16:
    return emitGetFieldPopSint16(A0, I);
  case PT_Uint16:
    return emitGetFieldPopUint16(A0, I);
  case PT_Sint32:
    return emitGetFieldPopSint32(A0, I);
  case PT_Uint32:
    return emitGetFieldPopUint32(A0, I);
  case PT_Sint64:
    return emitGetFieldPopSint64(A0, I);
  case PT_Uint64:
    return emitGetFieldPopUint64(A0, I);
  case PT_IntAP:
    return emitGetFieldPopIntAP(A0, I);
  case PT_IntAPS:
    return emitGetFieldPopIntAPS(A0, I);
  case PT_Bool:
    return emitGetFieldPopBool(A0, I);
  case PT_FixedPoint:
    return emitGetFieldPopFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetFieldPopPtr(A0, I);
  case PT_MemberPtr:
    return emitGetFieldPopMemberPtr(A0, I);
  case PT_Float:
    return emitGetFieldPopFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetFieldPopSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopSint8, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopUint8, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopSint16, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopUint16, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopSint32, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopUint32, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopSint64, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopUint64, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopBool, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopPtr, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetFieldPopFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetFieldPopFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetFieldPopSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetFieldPopFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFieldPop<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetFnPtr,
#endif
#ifdef GET_INTERP
case OP_GetFnPtr: {
  const auto V0 = ReadArg<const Function *>(S, PC);
  if (!GetFnPtr(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetFnPtr:
  Text.Op = PrintName("GetFnPtr");
  Text.Args.push_back(printArg<const Function *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetFnPtr( const Function * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetFnPtr( const Function * A0, SourceInfo L) {
  return emitOp<const Function *>(OP_GetFnPtr, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetFnPtr( const Function * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetFnPtr(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetGlobalSint8,
OP_GetGlobalUint8,
OP_GetGlobalSint16,
OP_GetGlobalUint16,
OP_GetGlobalSint32,
OP_GetGlobalUint32,
OP_GetGlobalSint64,
OP_GetGlobalUint64,
OP_GetGlobalIntAP,
OP_GetGlobalIntAPS,
OP_GetGlobalBool,
OP_GetGlobalFixedPoint,
OP_GetGlobalPtr,
OP_GetGlobalMemberPtr,
OP_GetGlobalFloat,
#endif
#ifdef GET_INTERP
case OP_GetGlobalSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobal<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetGlobalSint8:
  Text.Op = PrintName("GetGlobalSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUint8:
  Text.Op = PrintName("GetGlobalUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalSint16:
  Text.Op = PrintName("GetGlobalSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUint16:
  Text.Op = PrintName("GetGlobalUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalSint32:
  Text.Op = PrintName("GetGlobalSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUint32:
  Text.Op = PrintName("GetGlobalUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalSint64:
  Text.Op = PrintName("GetGlobalSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUint64:
  Text.Op = PrintName("GetGlobalUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalIntAP:
  Text.Op = PrintName("GetGlobalIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalIntAPS:
  Text.Op = PrintName("GetGlobalIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalBool:
  Text.Op = PrintName("GetGlobalBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalFixedPoint:
  Text.Op = PrintName("GetGlobalFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalPtr:
  Text.Op = PrintName("GetGlobalPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalMemberPtr:
  Text.Op = PrintName("GetGlobalMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalFloat:
  Text.Op = PrintName("GetGlobalFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetGlobalSint8( uint32_t , SourceInfo);
bool emitGetGlobalUint8( uint32_t , SourceInfo);
bool emitGetGlobalSint16( uint32_t , SourceInfo);
bool emitGetGlobalUint16( uint32_t , SourceInfo);
bool emitGetGlobalSint32( uint32_t , SourceInfo);
bool emitGetGlobalUint32( uint32_t , SourceInfo);
bool emitGetGlobalSint64( uint32_t , SourceInfo);
bool emitGetGlobalUint64( uint32_t , SourceInfo);
bool emitGetGlobalIntAP( uint32_t , SourceInfo);
bool emitGetGlobalIntAPS( uint32_t , SourceInfo);
bool emitGetGlobalBool( uint32_t , SourceInfo);
bool emitGetGlobalFixedPoint( uint32_t , SourceInfo);
bool emitGetGlobalPtr( uint32_t , SourceInfo);
bool emitGetGlobalMemberPtr( uint32_t , SourceInfo);
bool emitGetGlobalFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetGlobal(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetGlobal(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetGlobalSint8(A0, I);
  case PT_Uint8:
    return emitGetGlobalUint8(A0, I);
  case PT_Sint16:
    return emitGetGlobalSint16(A0, I);
  case PT_Uint16:
    return emitGetGlobalUint16(A0, I);
  case PT_Sint32:
    return emitGetGlobalSint32(A0, I);
  case PT_Uint32:
    return emitGetGlobalUint32(A0, I);
  case PT_Sint64:
    return emitGetGlobalSint64(A0, I);
  case PT_Uint64:
    return emitGetGlobalUint64(A0, I);
  case PT_IntAP:
    return emitGetGlobalIntAP(A0, I);
  case PT_IntAPS:
    return emitGetGlobalIntAPS(A0, I);
  case PT_Bool:
    return emitGetGlobalBool(A0, I);
  case PT_FixedPoint:
    return emitGetGlobalFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetGlobalPtr(A0, I);
  case PT_MemberPtr:
    return emitGetGlobalMemberPtr(A0, I);
  case PT_Float:
    return emitGetGlobalFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetGlobalSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalSint8, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUint8, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalSint16, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUint16, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalSint32, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUint32, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalSint64, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUint64, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalBool, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalPtr, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetGlobalSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobal<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetGlobalUncheckedSint8,
OP_GetGlobalUncheckedUint8,
OP_GetGlobalUncheckedSint16,
OP_GetGlobalUncheckedUint16,
OP_GetGlobalUncheckedSint32,
OP_GetGlobalUncheckedUint32,
OP_GetGlobalUncheckedSint64,
OP_GetGlobalUncheckedUint64,
OP_GetGlobalUncheckedIntAP,
OP_GetGlobalUncheckedIntAPS,
OP_GetGlobalUncheckedBool,
OP_GetGlobalUncheckedFixedPoint,
OP_GetGlobalUncheckedPtr,
OP_GetGlobalUncheckedMemberPtr,
OP_GetGlobalUncheckedFloat,
#endif
#ifdef GET_INTERP
case OP_GetGlobalUncheckedSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetGlobalUncheckedFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetGlobalUnchecked<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetGlobalUncheckedSint8:
  Text.Op = PrintName("GetGlobalUncheckedSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedUint8:
  Text.Op = PrintName("GetGlobalUncheckedUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedSint16:
  Text.Op = PrintName("GetGlobalUncheckedSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedUint16:
  Text.Op = PrintName("GetGlobalUncheckedUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedSint32:
  Text.Op = PrintName("GetGlobalUncheckedSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedUint32:
  Text.Op = PrintName("GetGlobalUncheckedUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedSint64:
  Text.Op = PrintName("GetGlobalUncheckedSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedUint64:
  Text.Op = PrintName("GetGlobalUncheckedUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedIntAP:
  Text.Op = PrintName("GetGlobalUncheckedIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedIntAPS:
  Text.Op = PrintName("GetGlobalUncheckedIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedBool:
  Text.Op = PrintName("GetGlobalUncheckedBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedFixedPoint:
  Text.Op = PrintName("GetGlobalUncheckedFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedPtr:
  Text.Op = PrintName("GetGlobalUncheckedPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedMemberPtr:
  Text.Op = PrintName("GetGlobalUncheckedMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetGlobalUncheckedFloat:
  Text.Op = PrintName("GetGlobalUncheckedFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetGlobalUncheckedSint8( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedUint8( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedSint16( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedUint16( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedSint32( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedUint32( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedSint64( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedUint64( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedIntAP( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedIntAPS( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedBool( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedFixedPoint( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedPtr( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedMemberPtr( uint32_t , SourceInfo);
bool emitGetGlobalUncheckedFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetGlobalUnchecked(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetGlobalUnchecked(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetGlobalUncheckedSint8(A0, I);
  case PT_Uint8:
    return emitGetGlobalUncheckedUint8(A0, I);
  case PT_Sint16:
    return emitGetGlobalUncheckedSint16(A0, I);
  case PT_Uint16:
    return emitGetGlobalUncheckedUint16(A0, I);
  case PT_Sint32:
    return emitGetGlobalUncheckedSint32(A0, I);
  case PT_Uint32:
    return emitGetGlobalUncheckedUint32(A0, I);
  case PT_Sint64:
    return emitGetGlobalUncheckedSint64(A0, I);
  case PT_Uint64:
    return emitGetGlobalUncheckedUint64(A0, I);
  case PT_IntAP:
    return emitGetGlobalUncheckedIntAP(A0, I);
  case PT_IntAPS:
    return emitGetGlobalUncheckedIntAPS(A0, I);
  case PT_Bool:
    return emitGetGlobalUncheckedBool(A0, I);
  case PT_FixedPoint:
    return emitGetGlobalUncheckedFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetGlobalUncheckedPtr(A0, I);
  case PT_MemberPtr:
    return emitGetGlobalUncheckedMemberPtr(A0, I);
  case PT_Float:
    return emitGetGlobalUncheckedFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetGlobalUncheckedSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedSint8, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedUint8, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedSint16, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedUint16, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedSint32, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedUint32, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedSint64, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedUint64, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedBool, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedPtr, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetGlobalUncheckedFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetGlobalUncheckedFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetGlobalUncheckedSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetGlobalUncheckedFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetGlobalUnchecked<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetIntPtrSint8,
OP_GetIntPtrUint8,
OP_GetIntPtrSint16,
OP_GetIntPtrUint16,
OP_GetIntPtrSint32,
OP_GetIntPtrUint32,
OP_GetIntPtrSint64,
OP_GetIntPtrUint64,
OP_GetIntPtrIntAP,
OP_GetIntPtrIntAPS,
OP_GetIntPtrBool,
OP_GetIntPtrFixedPoint,
#endif
#ifdef GET_INTERP
case OP_GetIntPtrSint8: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrUint8: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrSint16: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrUint16: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrSint32: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrUint32: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrSint64: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrUint64: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrIntAP: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrIntAPS: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrBool: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetIntPtrFixedPoint: {
  const auto V0 = ReadArg<const Descriptor *>(S, PC);
  if (!GetIntPtr<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetIntPtrSint8:
  Text.Op = PrintName("GetIntPtrSint8");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrUint8:
  Text.Op = PrintName("GetIntPtrUint8");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrSint16:
  Text.Op = PrintName("GetIntPtrSint16");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrUint16:
  Text.Op = PrintName("GetIntPtrUint16");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrSint32:
  Text.Op = PrintName("GetIntPtrSint32");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrUint32:
  Text.Op = PrintName("GetIntPtrUint32");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrSint64:
  Text.Op = PrintName("GetIntPtrSint64");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrUint64:
  Text.Op = PrintName("GetIntPtrUint64");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrIntAP:
  Text.Op = PrintName("GetIntPtrIntAP");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrIntAPS:
  Text.Op = PrintName("GetIntPtrIntAPS");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrBool:
  Text.Op = PrintName("GetIntPtrBool");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_GetIntPtrFixedPoint:
  Text.Op = PrintName("GetIntPtrFixedPoint");
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetIntPtrSint8( const Descriptor * , SourceInfo);
bool emitGetIntPtrUint8( const Descriptor * , SourceInfo);
bool emitGetIntPtrSint16( const Descriptor * , SourceInfo);
bool emitGetIntPtrUint16( const Descriptor * , SourceInfo);
bool emitGetIntPtrSint32( const Descriptor * , SourceInfo);
bool emitGetIntPtrUint32( const Descriptor * , SourceInfo);
bool emitGetIntPtrSint64( const Descriptor * , SourceInfo);
bool emitGetIntPtrUint64( const Descriptor * , SourceInfo);
bool emitGetIntPtrIntAP( const Descriptor * , SourceInfo);
bool emitGetIntPtrIntAPS( const Descriptor * , SourceInfo);
bool emitGetIntPtrBool( const Descriptor * , SourceInfo);
bool emitGetIntPtrFixedPoint( const Descriptor * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetIntPtr(PrimType, const Descriptor *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetIntPtr(PrimType T0,  const Descriptor * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetIntPtrSint8(A0, I);
  case PT_Uint8:
    return emitGetIntPtrUint8(A0, I);
  case PT_Sint16:
    return emitGetIntPtrSint16(A0, I);
  case PT_Uint16:
    return emitGetIntPtrUint16(A0, I);
  case PT_Sint32:
    return emitGetIntPtrSint32(A0, I);
  case PT_Uint32:
    return emitGetIntPtrUint32(A0, I);
  case PT_Sint64:
    return emitGetIntPtrSint64(A0, I);
  case PT_Uint64:
    return emitGetIntPtrUint64(A0, I);
  case PT_IntAP:
    return emitGetIntPtrIntAP(A0, I);
  case PT_IntAPS:
    return emitGetIntPtrIntAPS(A0, I);
  case PT_Bool:
    return emitGetIntPtrBool(A0, I);
  case PT_FixedPoint:
    return emitGetIntPtrFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitGetIntPtr");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetIntPtrSint8( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrSint8, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrUint8( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrUint8, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrSint16( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrSint16, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrUint16( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrUint16, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrSint32( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrSint32, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrUint32( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrUint32, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrSint64( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrSint64, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrUint64( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrUint64, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrIntAP( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrIntAPS( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrBool( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrBool, A0, L);
}
bool ByteCodeEmitter::emitGetIntPtrFixedPoint( const Descriptor * A0, SourceInfo L) {
  return emitOp<const Descriptor *>(OP_GetIntPtrFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetIntPtrSint8( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrUint8( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrSint16( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrUint16( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrSint32( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrUint32( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrSint64( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrUint64( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrIntAP( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrIntAPS( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrBool( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetIntPtrFixedPoint( const Descriptor * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetIntPtr<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetLocalSint8,
OP_GetLocalUint8,
OP_GetLocalSint16,
OP_GetLocalUint16,
OP_GetLocalSint32,
OP_GetLocalUint32,
OP_GetLocalSint64,
OP_GetLocalUint64,
OP_GetLocalIntAP,
OP_GetLocalIntAPS,
OP_GetLocalBool,
OP_GetLocalFixedPoint,
OP_GetLocalPtr,
OP_GetLocalMemberPtr,
OP_GetLocalFloat,
#endif
#ifdef GET_INTERP
case OP_GetLocalSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetLocalFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetLocal<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetLocalSint8:
  Text.Op = PrintName("GetLocalSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalUint8:
  Text.Op = PrintName("GetLocalUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalSint16:
  Text.Op = PrintName("GetLocalSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalUint16:
  Text.Op = PrintName("GetLocalUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalSint32:
  Text.Op = PrintName("GetLocalSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalUint32:
  Text.Op = PrintName("GetLocalUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalSint64:
  Text.Op = PrintName("GetLocalSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalUint64:
  Text.Op = PrintName("GetLocalUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalIntAP:
  Text.Op = PrintName("GetLocalIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalIntAPS:
  Text.Op = PrintName("GetLocalIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalBool:
  Text.Op = PrintName("GetLocalBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalFixedPoint:
  Text.Op = PrintName("GetLocalFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalPtr:
  Text.Op = PrintName("GetLocalPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalMemberPtr:
  Text.Op = PrintName("GetLocalMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetLocalFloat:
  Text.Op = PrintName("GetLocalFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetLocalSint8( uint32_t , SourceInfo);
bool emitGetLocalUint8( uint32_t , SourceInfo);
bool emitGetLocalSint16( uint32_t , SourceInfo);
bool emitGetLocalUint16( uint32_t , SourceInfo);
bool emitGetLocalSint32( uint32_t , SourceInfo);
bool emitGetLocalUint32( uint32_t , SourceInfo);
bool emitGetLocalSint64( uint32_t , SourceInfo);
bool emitGetLocalUint64( uint32_t , SourceInfo);
bool emitGetLocalIntAP( uint32_t , SourceInfo);
bool emitGetLocalIntAPS( uint32_t , SourceInfo);
bool emitGetLocalBool( uint32_t , SourceInfo);
bool emitGetLocalFixedPoint( uint32_t , SourceInfo);
bool emitGetLocalPtr( uint32_t , SourceInfo);
bool emitGetLocalMemberPtr( uint32_t , SourceInfo);
bool emitGetLocalFloat( uint32_t , SourceInfo);
#if defined(GET_EVAL_PROTO)
template<PrimType>
bool emitGetLocal(uint32_t, SourceInfo);
#endif
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetLocal(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetLocal(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
#ifdef GET_LINK_IMPL
    return emitGetLocalSint8
#else
    return emitGetLocal<PT_Sint8>
#endif
      (A0, I);
  case PT_Uint8:
#ifdef GET_LINK_IMPL
    return emitGetLocalUint8
#else
    return emitGetLocal<PT_Uint8>
#endif
      (A0, I);
  case PT_Sint16:
#ifdef GET_LINK_IMPL
    return emitGetLocalSint16
#else
    return emitGetLocal<PT_Sint16>
#endif
      (A0, I);
  case PT_Uint16:
#ifdef GET_LINK_IMPL
    return emitGetLocalUint16
#else
    return emitGetLocal<PT_Uint16>
#endif
      (A0, I);
  case PT_Sint32:
#ifdef GET_LINK_IMPL
    return emitGetLocalSint32
#else
    return emitGetLocal<PT_Sint32>
#endif
      (A0, I);
  case PT_Uint32:
#ifdef GET_LINK_IMPL
    return emitGetLocalUint32
#else
    return emitGetLocal<PT_Uint32>
#endif
      (A0, I);
  case PT_Sint64:
#ifdef GET_LINK_IMPL
    return emitGetLocalSint64
#else
    return emitGetLocal<PT_Sint64>
#endif
      (A0, I);
  case PT_Uint64:
#ifdef GET_LINK_IMPL
    return emitGetLocalUint64
#else
    return emitGetLocal<PT_Uint64>
#endif
      (A0, I);
  case PT_IntAP:
#ifdef GET_LINK_IMPL
    return emitGetLocalIntAP
#else
    return emitGetLocal<PT_IntAP>
#endif
      (A0, I);
  case PT_IntAPS:
#ifdef GET_LINK_IMPL
    return emitGetLocalIntAPS
#else
    return emitGetLocal<PT_IntAPS>
#endif
      (A0, I);
  case PT_Bool:
#ifdef GET_LINK_IMPL
    return emitGetLocalBool
#else
    return emitGetLocal<PT_Bool>
#endif
      (A0, I);
  case PT_FixedPoint:
#ifdef GET_LINK_IMPL
    return emitGetLocalFixedPoint
#else
    return emitGetLocal<PT_FixedPoint>
#endif
      (A0, I);
  case PT_Ptr:
#ifdef GET_LINK_IMPL
    return emitGetLocalPtr
#else
    return emitGetLocal<PT_Ptr>
#endif
      (A0, I);
  case PT_MemberPtr:
#ifdef GET_LINK_IMPL
    return emitGetLocalMemberPtr
#else
    return emitGetLocal<PT_MemberPtr>
#endif
      (A0, I);
  case PT_Float:
#ifdef GET_LINK_IMPL
    return emitGetLocalFloat
#else
    return emitGetLocal<PT_Float>
#endif
      (A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetLocalSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalSint8, A0, L);
}
bool ByteCodeEmitter::emitGetLocalUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalUint8, A0, L);
}
bool ByteCodeEmitter::emitGetLocalSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalSint16, A0, L);
}
bool ByteCodeEmitter::emitGetLocalUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalUint16, A0, L);
}
bool ByteCodeEmitter::emitGetLocalSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalSint32, A0, L);
}
bool ByteCodeEmitter::emitGetLocalUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalUint32, A0, L);
}
bool ByteCodeEmitter::emitGetLocalSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalSint64, A0, L);
}
bool ByteCodeEmitter::emitGetLocalUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalUint64, A0, L);
}
bool ByteCodeEmitter::emitGetLocalIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetLocalIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetLocalBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalBool, A0, L);
}
bool ByteCodeEmitter::emitGetLocalFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetLocalPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalPtr, A0, L);
}
bool ByteCodeEmitter::emitGetLocalMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetLocalFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetLocalFloat, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetMemberPtr,
#endif
#ifdef GET_INTERP
case OP_GetMemberPtr: {
  const auto V0 = ReadArg<const ValueDecl*>(S, PC);
  if (!GetMemberPtr(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetMemberPtr:
  Text.Op = PrintName("GetMemberPtr");
  Text.Args.push_back(printArg<const ValueDecl*>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetMemberPtr( const ValueDecl* , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetMemberPtr( const ValueDecl* A0, SourceInfo L) {
  return emitOp<const ValueDecl*>(OP_GetMemberPtr, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetMemberPtr( const ValueDecl* A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetMemberPtr(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetMemberPtrBase,
#endif
#ifdef GET_INTERP
case OP_GetMemberPtrBase: {
  if (!GetMemberPtrBase(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetMemberPtrBase:
  Text.Op = PrintName("GetMemberPtrBase");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetMemberPtrBase(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetMemberPtrBase(SourceInfo L) {
  return emitOp<>(OP_GetMemberPtrBase, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetMemberPtrBase(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetMemberPtrBase(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetMemberPtrBasePop,
#endif
#ifdef GET_INTERP
case OP_GetMemberPtrBasePop: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  if (!GetMemberPtrBasePop(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetMemberPtrBasePop:
  Text.Op = PrintName("GetMemberPtrBasePop");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetMemberPtrBasePop( int32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetMemberPtrBasePop( int32_t A0, SourceInfo L) {
  return emitOp<int32_t>(OP_GetMemberPtrBasePop, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetMemberPtrBasePop( int32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetMemberPtrBasePop(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetMemberPtrDecl,
#endif
#ifdef GET_INTERP
case OP_GetMemberPtrDecl: {
  if (!GetMemberPtrDecl(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetMemberPtrDecl:
  Text.Op = PrintName("GetMemberPtrDecl");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetMemberPtrDecl(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetMemberPtrDecl(SourceInfo L) {
  return emitOp<>(OP_GetMemberPtrDecl, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetMemberPtrDecl(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetMemberPtrDecl(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetParamSint8,
OP_GetParamUint8,
OP_GetParamSint16,
OP_GetParamUint16,
OP_GetParamSint32,
OP_GetParamUint32,
OP_GetParamSint64,
OP_GetParamUint64,
OP_GetParamIntAP,
OP_GetParamIntAPS,
OP_GetParamBool,
OP_GetParamFixedPoint,
OP_GetParamPtr,
OP_GetParamMemberPtr,
OP_GetParamFloat,
#endif
#ifdef GET_INTERP
case OP_GetParamSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetParamFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetParam<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetParamSint8:
  Text.Op = PrintName("GetParamSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamUint8:
  Text.Op = PrintName("GetParamUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamSint16:
  Text.Op = PrintName("GetParamSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamUint16:
  Text.Op = PrintName("GetParamUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamSint32:
  Text.Op = PrintName("GetParamSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamUint32:
  Text.Op = PrintName("GetParamUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamSint64:
  Text.Op = PrintName("GetParamSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamUint64:
  Text.Op = PrintName("GetParamUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamIntAP:
  Text.Op = PrintName("GetParamIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamIntAPS:
  Text.Op = PrintName("GetParamIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamBool:
  Text.Op = PrintName("GetParamBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamFixedPoint:
  Text.Op = PrintName("GetParamFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamPtr:
  Text.Op = PrintName("GetParamPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamMemberPtr:
  Text.Op = PrintName("GetParamMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetParamFloat:
  Text.Op = PrintName("GetParamFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetParamSint8( uint32_t , SourceInfo);
bool emitGetParamUint8( uint32_t , SourceInfo);
bool emitGetParamSint16( uint32_t , SourceInfo);
bool emitGetParamUint16( uint32_t , SourceInfo);
bool emitGetParamSint32( uint32_t , SourceInfo);
bool emitGetParamUint32( uint32_t , SourceInfo);
bool emitGetParamSint64( uint32_t , SourceInfo);
bool emitGetParamUint64( uint32_t , SourceInfo);
bool emitGetParamIntAP( uint32_t , SourceInfo);
bool emitGetParamIntAPS( uint32_t , SourceInfo);
bool emitGetParamBool( uint32_t , SourceInfo);
bool emitGetParamFixedPoint( uint32_t , SourceInfo);
bool emitGetParamPtr( uint32_t , SourceInfo);
bool emitGetParamMemberPtr( uint32_t , SourceInfo);
bool emitGetParamFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetParam(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetParam(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetParamSint8(A0, I);
  case PT_Uint8:
    return emitGetParamUint8(A0, I);
  case PT_Sint16:
    return emitGetParamSint16(A0, I);
  case PT_Uint16:
    return emitGetParamUint16(A0, I);
  case PT_Sint32:
    return emitGetParamSint32(A0, I);
  case PT_Uint32:
    return emitGetParamUint32(A0, I);
  case PT_Sint64:
    return emitGetParamSint64(A0, I);
  case PT_Uint64:
    return emitGetParamUint64(A0, I);
  case PT_IntAP:
    return emitGetParamIntAP(A0, I);
  case PT_IntAPS:
    return emitGetParamIntAPS(A0, I);
  case PT_Bool:
    return emitGetParamBool(A0, I);
  case PT_FixedPoint:
    return emitGetParamFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetParamPtr(A0, I);
  case PT_MemberPtr:
    return emitGetParamMemberPtr(A0, I);
  case PT_Float:
    return emitGetParamFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetParamSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamSint8, A0, L);
}
bool ByteCodeEmitter::emitGetParamUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamUint8, A0, L);
}
bool ByteCodeEmitter::emitGetParamSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamSint16, A0, L);
}
bool ByteCodeEmitter::emitGetParamUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamUint16, A0, L);
}
bool ByteCodeEmitter::emitGetParamSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamSint32, A0, L);
}
bool ByteCodeEmitter::emitGetParamUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamUint32, A0, L);
}
bool ByteCodeEmitter::emitGetParamSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamSint64, A0, L);
}
bool ByteCodeEmitter::emitGetParamUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamUint64, A0, L);
}
bool ByteCodeEmitter::emitGetParamIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetParamIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetParamBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamBool, A0, L);
}
bool ByteCodeEmitter::emitGetParamFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetParamPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamPtr, A0, L);
}
bool ByteCodeEmitter::emitGetParamMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetParamFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetParamFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetParamSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetParamFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetParam<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrBase,
#endif
#ifdef GET_INTERP
case OP_GetPtrBase: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrBase(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrBase:
  Text.Op = PrintName("GetPtrBase");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrBase( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrBase( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrBase, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrBase( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrBase(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrBasePop,
#endif
#ifdef GET_INTERP
case OP_GetPtrBasePop: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!GetPtrBasePop(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrBasePop:
  Text.Op = PrintName("GetPtrBasePop");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrBasePop( uint32_t ,  bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrBasePop( uint32_t A0,  bool A1, SourceInfo L) {
  return emitOp<uint32_t, bool>(OP_GetPtrBasePop, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrBasePop( uint32_t A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrBasePop(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrDerivedPop,
#endif
#ifdef GET_INTERP
case OP_GetPtrDerivedPop: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  const auto V2 = ReadArg<const Type *>(S, PC);
  if (!GetPtrDerivedPop(S, OpPC, V0, V1, V2))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrDerivedPop:
  Text.Op = PrintName("GetPtrDerivedPop");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrDerivedPop( uint32_t ,  bool ,  const Type * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrDerivedPop( uint32_t A0,  bool A1,  const Type * A2, SourceInfo L) {
  return emitOp<uint32_t, bool, const Type *>(OP_GetPtrDerivedPop, A0, A1, A2, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrDerivedPop( uint32_t A0,  bool A1,  const Type * A2, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrDerivedPop(S, OpPC, A0, A1, A2);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrField,
#endif
#ifdef GET_INTERP
case OP_GetPtrField: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrField(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrField:
  Text.Op = PrintName("GetPtrField");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrField( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrField( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrField, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrField( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrField(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrFieldPop,
#endif
#ifdef GET_INTERP
case OP_GetPtrFieldPop: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrFieldPop(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrFieldPop:
  Text.Op = PrintName("GetPtrFieldPop");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrFieldPop( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrFieldPop( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrFieldPop, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrFieldPop( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrFieldPop(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrGlobal,
#endif
#ifdef GET_INTERP
case OP_GetPtrGlobal: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrGlobal(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrGlobal:
  Text.Op = PrintName("GetPtrGlobal");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrGlobal( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrGlobal( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrGlobal, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrGlobal( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrGlobal(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrLocal,
#endif
#ifdef GET_INTERP
case OP_GetPtrLocal: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrLocal(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrLocal:
  Text.Op = PrintName("GetPtrLocal");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrLocal( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrLocal( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrLocal, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrParam,
#endif
#ifdef GET_INTERP
case OP_GetPtrParam: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrParam(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrParam:
  Text.Op = PrintName("GetPtrParam");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrParam( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrParam( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrParam, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrParam( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrParam(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrThisBase,
#endif
#ifdef GET_INTERP
case OP_GetPtrThisBase: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrThisBase(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrThisBase:
  Text.Op = PrintName("GetPtrThisBase");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrThisBase( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrThisBase( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrThisBase, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrThisBase( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrThisBase(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrThisField,
#endif
#ifdef GET_INTERP
case OP_GetPtrThisField: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetPtrThisField(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrThisField:
  Text.Op = PrintName("GetPtrThisField");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrThisField( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrThisField( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetPtrThisField, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrThisField( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrThisField(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrThisVirtBase,
#endif
#ifdef GET_INTERP
case OP_GetPtrThisVirtBase: {
  const auto V0 = ReadArg<const RecordDecl *>(S, PC);
  if (!GetPtrThisVirtBase(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrThisVirtBase:
  Text.Op = PrintName("GetPtrThisVirtBase");
  Text.Args.push_back(printArg<const RecordDecl *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrThisVirtBase( const RecordDecl * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrThisVirtBase( const RecordDecl * A0, SourceInfo L) {
  return emitOp<const RecordDecl *>(OP_GetPtrThisVirtBase, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrThisVirtBase( const RecordDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrThisVirtBase(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetPtrVirtBasePop,
#endif
#ifdef GET_INTERP
case OP_GetPtrVirtBasePop: {
  const auto V0 = ReadArg<const RecordDecl *>(S, PC);
  if (!GetPtrVirtBasePop(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetPtrVirtBasePop:
  Text.Op = PrintName("GetPtrVirtBasePop");
  Text.Args.push_back(printArg<const RecordDecl *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetPtrVirtBasePop( const RecordDecl * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetPtrVirtBasePop( const RecordDecl * A0, SourceInfo L) {
  return emitOp<const RecordDecl *>(OP_GetPtrVirtBasePop, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetPtrVirtBasePop( const RecordDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetPtrVirtBasePop(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetThisFieldSint8,
OP_GetThisFieldUint8,
OP_GetThisFieldSint16,
OP_GetThisFieldUint16,
OP_GetThisFieldSint32,
OP_GetThisFieldUint32,
OP_GetThisFieldSint64,
OP_GetThisFieldUint64,
OP_GetThisFieldIntAP,
OP_GetThisFieldIntAPS,
OP_GetThisFieldBool,
OP_GetThisFieldFixedPoint,
OP_GetThisFieldPtr,
OP_GetThisFieldMemberPtr,
OP_GetThisFieldFloat,
#endif
#ifdef GET_INTERP
case OP_GetThisFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_GetThisFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!GetThisField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetThisFieldSint8:
  Text.Op = PrintName("GetThisFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldUint8:
  Text.Op = PrintName("GetThisFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldSint16:
  Text.Op = PrintName("GetThisFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldUint16:
  Text.Op = PrintName("GetThisFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldSint32:
  Text.Op = PrintName("GetThisFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldUint32:
  Text.Op = PrintName("GetThisFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldSint64:
  Text.Op = PrintName("GetThisFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldUint64:
  Text.Op = PrintName("GetThisFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldIntAP:
  Text.Op = PrintName("GetThisFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldIntAPS:
  Text.Op = PrintName("GetThisFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldBool:
  Text.Op = PrintName("GetThisFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldFixedPoint:
  Text.Op = PrintName("GetThisFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldPtr:
  Text.Op = PrintName("GetThisFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldMemberPtr:
  Text.Op = PrintName("GetThisFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_GetThisFieldFloat:
  Text.Op = PrintName("GetThisFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetThisFieldSint8( uint32_t , SourceInfo);
bool emitGetThisFieldUint8( uint32_t , SourceInfo);
bool emitGetThisFieldSint16( uint32_t , SourceInfo);
bool emitGetThisFieldUint16( uint32_t , SourceInfo);
bool emitGetThisFieldSint32( uint32_t , SourceInfo);
bool emitGetThisFieldUint32( uint32_t , SourceInfo);
bool emitGetThisFieldSint64( uint32_t , SourceInfo);
bool emitGetThisFieldUint64( uint32_t , SourceInfo);
bool emitGetThisFieldIntAP( uint32_t , SourceInfo);
bool emitGetThisFieldIntAPS( uint32_t , SourceInfo);
bool emitGetThisFieldBool( uint32_t , SourceInfo);
bool emitGetThisFieldFixedPoint( uint32_t , SourceInfo);
bool emitGetThisFieldPtr( uint32_t , SourceInfo);
bool emitGetThisFieldMemberPtr( uint32_t , SourceInfo);
bool emitGetThisFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitGetThisField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitGetThisField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitGetThisFieldSint8(A0, I);
  case PT_Uint8:
    return emitGetThisFieldUint8(A0, I);
  case PT_Sint16:
    return emitGetThisFieldSint16(A0, I);
  case PT_Uint16:
    return emitGetThisFieldUint16(A0, I);
  case PT_Sint32:
    return emitGetThisFieldSint32(A0, I);
  case PT_Uint32:
    return emitGetThisFieldUint32(A0, I);
  case PT_Sint64:
    return emitGetThisFieldSint64(A0, I);
  case PT_Uint64:
    return emitGetThisFieldUint64(A0, I);
  case PT_IntAP:
    return emitGetThisFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitGetThisFieldIntAPS(A0, I);
  case PT_Bool:
    return emitGetThisFieldBool(A0, I);
  case PT_FixedPoint:
    return emitGetThisFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitGetThisFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitGetThisFieldMemberPtr(A0, I);
  case PT_Float:
    return emitGetThisFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetThisFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldBool, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitGetThisFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_GetThisFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetThisFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitGetThisFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetThisField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetTypeid,
#endif
#ifdef GET_INTERP
case OP_GetTypeid: {
  const auto V0 = ReadArg<const Type *>(S, PC);
  const auto V1 = ReadArg<const Type *>(S, PC);
  if (!GetTypeid(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetTypeid:
  Text.Op = PrintName("GetTypeid");
  Text.Args.push_back(printArg<const Type *>(P, PC));
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetTypeid( const Type * ,  const Type * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetTypeid( const Type * A0,  const Type * A1, SourceInfo L) {
  return emitOp<const Type *, const Type *>(OP_GetTypeid, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetTypeid( const Type * A0,  const Type * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetTypeid(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_GetTypeidPtr,
#endif
#ifdef GET_INTERP
case OP_GetTypeidPtr: {
  const auto V0 = ReadArg<const Type *>(S, PC);
  if (!GetTypeidPtr(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_GetTypeidPtr:
  Text.Op = PrintName("GetTypeidPtr");
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitGetTypeidPtr( const Type * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitGetTypeidPtr( const Type * A0, SourceInfo L) {
  return emitOp<const Type *>(OP_GetTypeidPtr, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitGetTypeidPtr( const Type * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return GetTypeidPtr(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IncSint8,
OP_IncUint8,
OP_IncSint16,
OP_IncUint16,
OP_IncSint32,
OP_IncUint32,
OP_IncSint64,
OP_IncUint64,
OP_IncIntAP,
OP_IncIntAPS,
OP_IncBool,
OP_IncFixedPoint,
#endif
#ifdef GET_INTERP
case OP_IncSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!Inc<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IncSint8:
  Text.Op = PrintName("IncSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncUint8:
  Text.Op = PrintName("IncUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncSint16:
  Text.Op = PrintName("IncSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncUint16:
  Text.Op = PrintName("IncUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncSint32:
  Text.Op = PrintName("IncSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncUint32:
  Text.Op = PrintName("IncUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncSint64:
  Text.Op = PrintName("IncSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncUint64:
  Text.Op = PrintName("IncUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncIntAP:
  Text.Op = PrintName("IncIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncIntAPS:
  Text.Op = PrintName("IncIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncBool:
  Text.Op = PrintName("IncBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncFixedPoint:
  Text.Op = PrintName("IncFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIncSint8( bool , SourceInfo);
bool emitIncUint8( bool , SourceInfo);
bool emitIncSint16( bool , SourceInfo);
bool emitIncUint16( bool , SourceInfo);
bool emitIncSint32( bool , SourceInfo);
bool emitIncUint32( bool , SourceInfo);
bool emitIncSint64( bool , SourceInfo);
bool emitIncUint64( bool , SourceInfo);
bool emitIncIntAP( bool , SourceInfo);
bool emitIncIntAPS( bool , SourceInfo);
bool emitIncBool( bool , SourceInfo);
bool emitIncFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInc(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInc(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitIncSint8(A0, I);
  case PT_Uint8:
    return emitIncUint8(A0, I);
  case PT_Sint16:
    return emitIncSint16(A0, I);
  case PT_Uint16:
    return emitIncUint16(A0, I);
  case PT_Sint32:
    return emitIncSint32(A0, I);
  case PT_Uint32:
    return emitIncUint32(A0, I);
  case PT_Sint64:
    return emitIncSint64(A0, I);
  case PT_Uint64:
    return emitIncUint64(A0, I);
  case PT_IntAP:
    return emitIncIntAP(A0, I);
  case PT_IntAPS:
    return emitIncIntAPS(A0, I);
  case PT_Bool:
    return emitIncBool(A0, I);
  case PT_FixedPoint:
    return emitIncFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitInc");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIncSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncSint8, A0, L);
}
bool ByteCodeEmitter::emitIncUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncUint8, A0, L);
}
bool ByteCodeEmitter::emitIncSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncSint16, A0, L);
}
bool ByteCodeEmitter::emitIncUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncUint16, A0, L);
}
bool ByteCodeEmitter::emitIncSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncSint32, A0, L);
}
bool ByteCodeEmitter::emitIncUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncUint32, A0, L);
}
bool ByteCodeEmitter::emitIncSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncSint64, A0, L);
}
bool ByteCodeEmitter::emitIncUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncUint64, A0, L);
}
bool ByteCodeEmitter::emitIncIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncIntAP, A0, L);
}
bool ByteCodeEmitter::emitIncIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncIntAPS, A0, L);
}
bool ByteCodeEmitter::emitIncBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncBool, A0, L);
}
bool ByteCodeEmitter::emitIncFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIncSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitIncUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitIncSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitIncUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitIncSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitIncUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitIncSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitIncUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitIncIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitIncIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitIncBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitIncFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inc<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IncPopSint8,
OP_IncPopUint8,
OP_IncPopSint16,
OP_IncPopUint16,
OP_IncPopSint32,
OP_IncPopUint32,
OP_IncPopSint64,
OP_IncPopUint64,
OP_IncPopIntAP,
OP_IncPopIntAPS,
OP_IncPopBool,
OP_IncPopFixedPoint,
#endif
#ifdef GET_INTERP
case OP_IncPopSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_IncPopFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!IncPop<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IncPopSint8:
  Text.Op = PrintName("IncPopSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopUint8:
  Text.Op = PrintName("IncPopUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopSint16:
  Text.Op = PrintName("IncPopSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopUint16:
  Text.Op = PrintName("IncPopUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopSint32:
  Text.Op = PrintName("IncPopSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopUint32:
  Text.Op = PrintName("IncPopUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopSint64:
  Text.Op = PrintName("IncPopSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopUint64:
  Text.Op = PrintName("IncPopUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopIntAP:
  Text.Op = PrintName("IncPopIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopIntAPS:
  Text.Op = PrintName("IncPopIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopBool:
  Text.Op = PrintName("IncPopBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_IncPopFixedPoint:
  Text.Op = PrintName("IncPopFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIncPopSint8( bool , SourceInfo);
bool emitIncPopUint8( bool , SourceInfo);
bool emitIncPopSint16( bool , SourceInfo);
bool emitIncPopUint16( bool , SourceInfo);
bool emitIncPopSint32( bool , SourceInfo);
bool emitIncPopUint32( bool , SourceInfo);
bool emitIncPopSint64( bool , SourceInfo);
bool emitIncPopUint64( bool , SourceInfo);
bool emitIncPopIntAP( bool , SourceInfo);
bool emitIncPopIntAPS( bool , SourceInfo);
bool emitIncPopBool( bool , SourceInfo);
bool emitIncPopFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitIncPop(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitIncPop(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitIncPopSint8(A0, I);
  case PT_Uint8:
    return emitIncPopUint8(A0, I);
  case PT_Sint16:
    return emitIncPopSint16(A0, I);
  case PT_Uint16:
    return emitIncPopUint16(A0, I);
  case PT_Sint32:
    return emitIncPopSint32(A0, I);
  case PT_Uint32:
    return emitIncPopUint32(A0, I);
  case PT_Sint64:
    return emitIncPopSint64(A0, I);
  case PT_Uint64:
    return emitIncPopUint64(A0, I);
  case PT_IntAP:
    return emitIncPopIntAP(A0, I);
  case PT_IntAPS:
    return emitIncPopIntAPS(A0, I);
  case PT_Bool:
    return emitIncPopBool(A0, I);
  case PT_FixedPoint:
    return emitIncPopFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitIncPop");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIncPopSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopSint8, A0, L);
}
bool ByteCodeEmitter::emitIncPopUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopUint8, A0, L);
}
bool ByteCodeEmitter::emitIncPopSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopSint16, A0, L);
}
bool ByteCodeEmitter::emitIncPopUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopUint16, A0, L);
}
bool ByteCodeEmitter::emitIncPopSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopSint32, A0, L);
}
bool ByteCodeEmitter::emitIncPopUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopUint32, A0, L);
}
bool ByteCodeEmitter::emitIncPopSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopSint64, A0, L);
}
bool ByteCodeEmitter::emitIncPopUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopUint64, A0, L);
}
bool ByteCodeEmitter::emitIncPopIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopIntAP, A0, L);
}
bool ByteCodeEmitter::emitIncPopIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopIntAPS, A0, L);
}
bool ByteCodeEmitter::emitIncPopBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopBool, A0, L);
}
bool ByteCodeEmitter::emitIncPopFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_IncPopFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIncPopSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitIncPopFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPop<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IncPtr,
#endif
#ifdef GET_INTERP
case OP_IncPtr: {
  if (!IncPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IncPtr:
  Text.Op = PrintName("IncPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIncPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIncPtr(SourceInfo L) {
  return emitOp<>(OP_IncPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIncPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Incf,
#endif
#ifdef GET_INTERP
case OP_Incf: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Incf(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Incf:
  Text.Op = PrintName("Incf");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIncf( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIncf( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Incf, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIncf( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Incf(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IncfPop,
#endif
#ifdef GET_INTERP
case OP_IncfPop: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!IncfPop(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IncfPop:
  Text.Op = PrintName("IncfPop");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIncfPop( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIncfPop( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_IncfPop, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIncfPop( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IncfPop(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitSint8,
OP_InitUint8,
OP_InitSint16,
OP_InitUint16,
OP_InitSint32,
OP_InitUint32,
OP_InitSint64,
OP_InitUint64,
OP_InitIntAP,
OP_InitIntAPS,
OP_InitBool,
OP_InitFixedPoint,
OP_InitPtr,
OP_InitMemberPtr,
OP_InitFloat,
#endif
#ifdef GET_INTERP
case OP_InitSint8: {
  if (!Init<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_InitUint8: {
  if (!Init<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_InitSint16: {
  if (!Init<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_InitUint16: {
  if (!Init<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_InitSint32: {
  if (!Init<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_InitUint32: {
  if (!Init<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_InitSint64: {
  if (!Init<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_InitUint64: {
  if (!Init<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_InitIntAP: {
  if (!Init<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_InitIntAPS: {
  if (!Init<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_InitBool: {
  if (!Init<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_InitFixedPoint: {
  if (!Init<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_InitPtr: {
  if (!Init<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_InitMemberPtr: {
  if (!Init<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_InitFloat: {
  if (!Init<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitSint8:
  Text.Op = PrintName("InitSint8");
  break;
case OP_InitUint8:
  Text.Op = PrintName("InitUint8");
  break;
case OP_InitSint16:
  Text.Op = PrintName("InitSint16");
  break;
case OP_InitUint16:
  Text.Op = PrintName("InitUint16");
  break;
case OP_InitSint32:
  Text.Op = PrintName("InitSint32");
  break;
case OP_InitUint32:
  Text.Op = PrintName("InitUint32");
  break;
case OP_InitSint64:
  Text.Op = PrintName("InitSint64");
  break;
case OP_InitUint64:
  Text.Op = PrintName("InitUint64");
  break;
case OP_InitIntAP:
  Text.Op = PrintName("InitIntAP");
  break;
case OP_InitIntAPS:
  Text.Op = PrintName("InitIntAPS");
  break;
case OP_InitBool:
  Text.Op = PrintName("InitBool");
  break;
case OP_InitFixedPoint:
  Text.Op = PrintName("InitFixedPoint");
  break;
case OP_InitPtr:
  Text.Op = PrintName("InitPtr");
  break;
case OP_InitMemberPtr:
  Text.Op = PrintName("InitMemberPtr");
  break;
case OP_InitFloat:
  Text.Op = PrintName("InitFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitSint8(SourceInfo);
bool emitInitUint8(SourceInfo);
bool emitInitSint16(SourceInfo);
bool emitInitUint16(SourceInfo);
bool emitInitSint32(SourceInfo);
bool emitInitUint32(SourceInfo);
bool emitInitSint64(SourceInfo);
bool emitInitUint64(SourceInfo);
bool emitInitIntAP(SourceInfo);
bool emitInitIntAPS(SourceInfo);
bool emitInitBool(SourceInfo);
bool emitInitFixedPoint(SourceInfo);
bool emitInitPtr(SourceInfo);
bool emitInitMemberPtr(SourceInfo);
bool emitInitFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInit(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInit(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitSint8(I);
  case PT_Uint8:
    return emitInitUint8(I);
  case PT_Sint16:
    return emitInitSint16(I);
  case PT_Uint16:
    return emitInitUint16(I);
  case PT_Sint32:
    return emitInitSint32(I);
  case PT_Uint32:
    return emitInitUint32(I);
  case PT_Sint64:
    return emitInitSint64(I);
  case PT_Uint64:
    return emitInitUint64(I);
  case PT_IntAP:
    return emitInitIntAP(I);
  case PT_IntAPS:
    return emitInitIntAPS(I);
  case PT_Bool:
    return emitInitBool(I);
  case PT_FixedPoint:
    return emitInitFixedPoint(I);
  case PT_Ptr:
    return emitInitPtr(I);
  case PT_MemberPtr:
    return emitInitMemberPtr(I);
  case PT_Float:
    return emitInitFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitSint8(SourceInfo L) {
  return emitOp<>(OP_InitSint8, L);
}
bool ByteCodeEmitter::emitInitUint8(SourceInfo L) {
  return emitOp<>(OP_InitUint8, L);
}
bool ByteCodeEmitter::emitInitSint16(SourceInfo L) {
  return emitOp<>(OP_InitSint16, L);
}
bool ByteCodeEmitter::emitInitUint16(SourceInfo L) {
  return emitOp<>(OP_InitUint16, L);
}
bool ByteCodeEmitter::emitInitSint32(SourceInfo L) {
  return emitOp<>(OP_InitSint32, L);
}
bool ByteCodeEmitter::emitInitUint32(SourceInfo L) {
  return emitOp<>(OP_InitUint32, L);
}
bool ByteCodeEmitter::emitInitSint64(SourceInfo L) {
  return emitOp<>(OP_InitSint64, L);
}
bool ByteCodeEmitter::emitInitUint64(SourceInfo L) {
  return emitOp<>(OP_InitUint64, L);
}
bool ByteCodeEmitter::emitInitIntAP(SourceInfo L) {
  return emitOp<>(OP_InitIntAP, L);
}
bool ByteCodeEmitter::emitInitIntAPS(SourceInfo L) {
  return emitOp<>(OP_InitIntAPS, L);
}
bool ByteCodeEmitter::emitInitBool(SourceInfo L) {
  return emitOp<>(OP_InitBool, L);
}
bool ByteCodeEmitter::emitInitFixedPoint(SourceInfo L) {
  return emitOp<>(OP_InitFixedPoint, L);
}
bool ByteCodeEmitter::emitInitPtr(SourceInfo L) {
  return emitOp<>(OP_InitPtr, L);
}
bool ByteCodeEmitter::emitInitMemberPtr(SourceInfo L) {
  return emitOp<>(OP_InitMemberPtr, L);
}
bool ByteCodeEmitter::emitInitFloat(SourceInfo L) {
  return emitOp<>(OP_InitFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitInitUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitInitSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitInitUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitInitSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitInitUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitInitSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitInitUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitInitIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitInitIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitInitBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitInitFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitInitPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitInitMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitInitFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Init<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitBitFieldSint8,
OP_InitBitFieldUint8,
OP_InitBitFieldSint16,
OP_InitBitFieldUint16,
OP_InitBitFieldSint32,
OP_InitBitFieldUint32,
OP_InitBitFieldSint64,
OP_InitBitFieldUint64,
OP_InitBitFieldIntAP,
OP_InitBitFieldIntAPS,
OP_InitBitFieldBool,
#endif
#ifdef GET_INTERP
case OP_InitBitFieldSint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldUint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldSint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldUint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldSint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldUint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldSint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldUint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldIntAP: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldIntAPS: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldBool: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitBitFieldSint8:
  Text.Op = PrintName("InitBitFieldSint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldUint8:
  Text.Op = PrintName("InitBitFieldUint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldSint16:
  Text.Op = PrintName("InitBitFieldSint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldUint16:
  Text.Op = PrintName("InitBitFieldUint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldSint32:
  Text.Op = PrintName("InitBitFieldSint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldUint32:
  Text.Op = PrintName("InitBitFieldUint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldSint64:
  Text.Op = PrintName("InitBitFieldSint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldUint64:
  Text.Op = PrintName("InitBitFieldUint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldIntAP:
  Text.Op = PrintName("InitBitFieldIntAP");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldIntAPS:
  Text.Op = PrintName("InitBitFieldIntAPS");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldBool:
  Text.Op = PrintName("InitBitFieldBool");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitBitFieldSint8( const Record::Field * , SourceInfo);
bool emitInitBitFieldUint8( const Record::Field * , SourceInfo);
bool emitInitBitFieldSint16( const Record::Field * , SourceInfo);
bool emitInitBitFieldUint16( const Record::Field * , SourceInfo);
bool emitInitBitFieldSint32( const Record::Field * , SourceInfo);
bool emitInitBitFieldUint32( const Record::Field * , SourceInfo);
bool emitInitBitFieldSint64( const Record::Field * , SourceInfo);
bool emitInitBitFieldUint64( const Record::Field * , SourceInfo);
bool emitInitBitFieldIntAP( const Record::Field * , SourceInfo);
bool emitInitBitFieldIntAPS( const Record::Field * , SourceInfo);
bool emitInitBitFieldBool( const Record::Field * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitBitField(PrimType, const Record::Field *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitBitField(PrimType T0,  const Record::Field * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitBitFieldSint8(A0, I);
  case PT_Uint8:
    return emitInitBitFieldUint8(A0, I);
  case PT_Sint16:
    return emitInitBitFieldSint16(A0, I);
  case PT_Uint16:
    return emitInitBitFieldUint16(A0, I);
  case PT_Sint32:
    return emitInitBitFieldSint32(A0, I);
  case PT_Uint32:
    return emitInitBitFieldUint32(A0, I);
  case PT_Sint64:
    return emitInitBitFieldSint64(A0, I);
  case PT_Uint64:
    return emitInitBitFieldUint64(A0, I);
  case PT_IntAP:
    return emitInitBitFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitInitBitFieldIntAPS(A0, I);
  case PT_Bool:
    return emitInitBitFieldBool(A0, I);
  default: llvm_unreachable("invalid type: emitInitBitField");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitBitFieldSint8( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldUint8( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldSint16( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldUint16( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldSint32( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldUint32( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldSint64( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldUint64( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldIntAP( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldIntAPS( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldBool( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitBitFieldSint8( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldUint8( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldSint16( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldUint16( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldSint32( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldUint32( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldSint64( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldUint64( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldIntAP( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldIntAPS( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldBool( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitField<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitBitFieldActivateSint8,
OP_InitBitFieldActivateUint8,
OP_InitBitFieldActivateSint16,
OP_InitBitFieldActivateUint16,
OP_InitBitFieldActivateSint32,
OP_InitBitFieldActivateUint32,
OP_InitBitFieldActivateSint64,
OP_InitBitFieldActivateUint64,
OP_InitBitFieldActivateIntAP,
OP_InitBitFieldActivateIntAPS,
OP_InitBitFieldActivateBool,
#endif
#ifdef GET_INTERP
case OP_InitBitFieldActivateSint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateUint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateSint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateUint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateSint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateUint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateSint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateUint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateIntAP: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateIntAPS: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitBitFieldActivateBool: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  if (!InitBitFieldActivate<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitBitFieldActivateSint8:
  Text.Op = PrintName("InitBitFieldActivateSint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateUint8:
  Text.Op = PrintName("InitBitFieldActivateUint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateSint16:
  Text.Op = PrintName("InitBitFieldActivateSint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateUint16:
  Text.Op = PrintName("InitBitFieldActivateUint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateSint32:
  Text.Op = PrintName("InitBitFieldActivateSint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateUint32:
  Text.Op = PrintName("InitBitFieldActivateUint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateSint64:
  Text.Op = PrintName("InitBitFieldActivateSint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateUint64:
  Text.Op = PrintName("InitBitFieldActivateUint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateIntAP:
  Text.Op = PrintName("InitBitFieldActivateIntAP");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateIntAPS:
  Text.Op = PrintName("InitBitFieldActivateIntAPS");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
case OP_InitBitFieldActivateBool:
  Text.Op = PrintName("InitBitFieldActivateBool");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitBitFieldActivateSint8( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateUint8( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateSint16( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateUint16( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateSint32( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateUint32( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateSint64( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateUint64( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateIntAP( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateIntAPS( const Record::Field * , SourceInfo);
bool emitInitBitFieldActivateBool( const Record::Field * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitBitFieldActivate(PrimType, const Record::Field *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitBitFieldActivate(PrimType T0,  const Record::Field * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitBitFieldActivateSint8(A0, I);
  case PT_Uint8:
    return emitInitBitFieldActivateUint8(A0, I);
  case PT_Sint16:
    return emitInitBitFieldActivateSint16(A0, I);
  case PT_Uint16:
    return emitInitBitFieldActivateUint16(A0, I);
  case PT_Sint32:
    return emitInitBitFieldActivateSint32(A0, I);
  case PT_Uint32:
    return emitInitBitFieldActivateUint32(A0, I);
  case PT_Sint64:
    return emitInitBitFieldActivateSint64(A0, I);
  case PT_Uint64:
    return emitInitBitFieldActivateUint64(A0, I);
  case PT_IntAP:
    return emitInitBitFieldActivateIntAP(A0, I);
  case PT_IntAPS:
    return emitInitBitFieldActivateIntAPS(A0, I);
  case PT_Bool:
    return emitInitBitFieldActivateBool(A0, I);
  default: llvm_unreachable("invalid type: emitInitBitFieldActivate");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitBitFieldActivateSint8( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateSint8, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateUint8( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateUint8, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateSint16( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateSint16, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateUint16( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateUint16, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateSint32( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateSint32, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateUint32( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateUint32, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateSint64( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateSint64, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateUint64( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateUint64, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateIntAP( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateIntAPS( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitBitFieldActivateBool( const Record::Field * A0, SourceInfo L) {
  return emitOp<const Record::Field *>(OP_InitBitFieldActivateBool, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitBitFieldActivateSint8( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateUint8( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateSint16( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateUint16( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateSint32( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateUint32( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateSint64( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateUint64( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateIntAP( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateIntAPS( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitBitFieldActivateBool( const Record::Field * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitBitFieldActivate<PT_Bool>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitElemSint8,
OP_InitElemUint8,
OP_InitElemSint16,
OP_InitElemUint16,
OP_InitElemSint32,
OP_InitElemUint32,
OP_InitElemSint64,
OP_InitElemUint64,
OP_InitElemIntAP,
OP_InitElemIntAPS,
OP_InitElemBool,
OP_InitElemFixedPoint,
OP_InitElemPtr,
OP_InitElemMemberPtr,
OP_InitElemFloat,
#endif
#ifdef GET_INTERP
case OP_InitElemSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElem<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitElemSint8:
  Text.Op = PrintName("InitElemSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemUint8:
  Text.Op = PrintName("InitElemUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemSint16:
  Text.Op = PrintName("InitElemSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemUint16:
  Text.Op = PrintName("InitElemUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemSint32:
  Text.Op = PrintName("InitElemSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemUint32:
  Text.Op = PrintName("InitElemUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemSint64:
  Text.Op = PrintName("InitElemSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemUint64:
  Text.Op = PrintName("InitElemUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemIntAP:
  Text.Op = PrintName("InitElemIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemIntAPS:
  Text.Op = PrintName("InitElemIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemBool:
  Text.Op = PrintName("InitElemBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemFixedPoint:
  Text.Op = PrintName("InitElemFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPtr:
  Text.Op = PrintName("InitElemPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemMemberPtr:
  Text.Op = PrintName("InitElemMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemFloat:
  Text.Op = PrintName("InitElemFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitElemSint8( uint32_t , SourceInfo);
bool emitInitElemUint8( uint32_t , SourceInfo);
bool emitInitElemSint16( uint32_t , SourceInfo);
bool emitInitElemUint16( uint32_t , SourceInfo);
bool emitInitElemSint32( uint32_t , SourceInfo);
bool emitInitElemUint32( uint32_t , SourceInfo);
bool emitInitElemSint64( uint32_t , SourceInfo);
bool emitInitElemUint64( uint32_t , SourceInfo);
bool emitInitElemIntAP( uint32_t , SourceInfo);
bool emitInitElemIntAPS( uint32_t , SourceInfo);
bool emitInitElemBool( uint32_t , SourceInfo);
bool emitInitElemFixedPoint( uint32_t , SourceInfo);
bool emitInitElemPtr( uint32_t , SourceInfo);
bool emitInitElemMemberPtr( uint32_t , SourceInfo);
bool emitInitElemFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitElem(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitElem(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitElemSint8(A0, I);
  case PT_Uint8:
    return emitInitElemUint8(A0, I);
  case PT_Sint16:
    return emitInitElemSint16(A0, I);
  case PT_Uint16:
    return emitInitElemUint16(A0, I);
  case PT_Sint32:
    return emitInitElemSint32(A0, I);
  case PT_Uint32:
    return emitInitElemUint32(A0, I);
  case PT_Sint64:
    return emitInitElemSint64(A0, I);
  case PT_Uint64:
    return emitInitElemUint64(A0, I);
  case PT_IntAP:
    return emitInitElemIntAP(A0, I);
  case PT_IntAPS:
    return emitInitElemIntAPS(A0, I);
  case PT_Bool:
    return emitInitElemBool(A0, I);
  case PT_FixedPoint:
    return emitInitElemFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitElemPtr(A0, I);
  case PT_MemberPtr:
    return emitInitElemMemberPtr(A0, I);
  case PT_Float:
    return emitInitElemFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitElemSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemSint8, A0, L);
}
bool ByteCodeEmitter::emitInitElemUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemUint8, A0, L);
}
bool ByteCodeEmitter::emitInitElemSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemSint16, A0, L);
}
bool ByteCodeEmitter::emitInitElemUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemUint16, A0, L);
}
bool ByteCodeEmitter::emitInitElemSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemSint32, A0, L);
}
bool ByteCodeEmitter::emitInitElemUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemUint32, A0, L);
}
bool ByteCodeEmitter::emitInitElemSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemSint64, A0, L);
}
bool ByteCodeEmitter::emitInitElemUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemUint64, A0, L);
}
bool ByteCodeEmitter::emitInitElemIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitElemIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitElemBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemBool, A0, L);
}
bool ByteCodeEmitter::emitInitElemFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitElemPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPtr, A0, L);
}
bool ByteCodeEmitter::emitInitElemMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitElemFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitElemSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElem<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitElemPopSint8,
OP_InitElemPopUint8,
OP_InitElemPopSint16,
OP_InitElemPopUint16,
OP_InitElemPopSint32,
OP_InitElemPopUint32,
OP_InitElemPopSint64,
OP_InitElemPopUint64,
OP_InitElemPopIntAP,
OP_InitElemPopIntAPS,
OP_InitElemPopBool,
OP_InitElemPopFixedPoint,
OP_InitElemPopPtr,
OP_InitElemPopMemberPtr,
OP_InitElemPopFloat,
#endif
#ifdef GET_INTERP
case OP_InitElemPopSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitElemPopFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitElemPop<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitElemPopSint8:
  Text.Op = PrintName("InitElemPopSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopUint8:
  Text.Op = PrintName("InitElemPopUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopSint16:
  Text.Op = PrintName("InitElemPopSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopUint16:
  Text.Op = PrintName("InitElemPopUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopSint32:
  Text.Op = PrintName("InitElemPopSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopUint32:
  Text.Op = PrintName("InitElemPopUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopSint64:
  Text.Op = PrintName("InitElemPopSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopUint64:
  Text.Op = PrintName("InitElemPopUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopIntAP:
  Text.Op = PrintName("InitElemPopIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopIntAPS:
  Text.Op = PrintName("InitElemPopIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopBool:
  Text.Op = PrintName("InitElemPopBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopFixedPoint:
  Text.Op = PrintName("InitElemPopFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopPtr:
  Text.Op = PrintName("InitElemPopPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopMemberPtr:
  Text.Op = PrintName("InitElemPopMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitElemPopFloat:
  Text.Op = PrintName("InitElemPopFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitElemPopSint8( uint32_t , SourceInfo);
bool emitInitElemPopUint8( uint32_t , SourceInfo);
bool emitInitElemPopSint16( uint32_t , SourceInfo);
bool emitInitElemPopUint16( uint32_t , SourceInfo);
bool emitInitElemPopSint32( uint32_t , SourceInfo);
bool emitInitElemPopUint32( uint32_t , SourceInfo);
bool emitInitElemPopSint64( uint32_t , SourceInfo);
bool emitInitElemPopUint64( uint32_t , SourceInfo);
bool emitInitElemPopIntAP( uint32_t , SourceInfo);
bool emitInitElemPopIntAPS( uint32_t , SourceInfo);
bool emitInitElemPopBool( uint32_t , SourceInfo);
bool emitInitElemPopFixedPoint( uint32_t , SourceInfo);
bool emitInitElemPopPtr( uint32_t , SourceInfo);
bool emitInitElemPopMemberPtr( uint32_t , SourceInfo);
bool emitInitElemPopFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitElemPop(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitElemPop(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitElemPopSint8(A0, I);
  case PT_Uint8:
    return emitInitElemPopUint8(A0, I);
  case PT_Sint16:
    return emitInitElemPopSint16(A0, I);
  case PT_Uint16:
    return emitInitElemPopUint16(A0, I);
  case PT_Sint32:
    return emitInitElemPopSint32(A0, I);
  case PT_Uint32:
    return emitInitElemPopUint32(A0, I);
  case PT_Sint64:
    return emitInitElemPopSint64(A0, I);
  case PT_Uint64:
    return emitInitElemPopUint64(A0, I);
  case PT_IntAP:
    return emitInitElemPopIntAP(A0, I);
  case PT_IntAPS:
    return emitInitElemPopIntAPS(A0, I);
  case PT_Bool:
    return emitInitElemPopBool(A0, I);
  case PT_FixedPoint:
    return emitInitElemPopFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitElemPopPtr(A0, I);
  case PT_MemberPtr:
    return emitInitElemPopMemberPtr(A0, I);
  case PT_Float:
    return emitInitElemPopFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitElemPopSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopSint8, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopUint8, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopSint16, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopUint16, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopSint32, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopUint32, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopSint64, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopUint64, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopBool, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopPtr, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitElemPopFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitElemPopFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitElemPopSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitElemPopFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitElemPop<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitFieldSint8,
OP_InitFieldUint8,
OP_InitFieldSint16,
OP_InitFieldUint16,
OP_InitFieldSint32,
OP_InitFieldUint32,
OP_InitFieldSint64,
OP_InitFieldUint64,
OP_InitFieldIntAP,
OP_InitFieldIntAPS,
OP_InitFieldBool,
OP_InitFieldFixedPoint,
OP_InitFieldPtr,
OP_InitFieldMemberPtr,
OP_InitFieldFloat,
#endif
#ifdef GET_INTERP
case OP_InitFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitFieldSint8:
  Text.Op = PrintName("InitFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldUint8:
  Text.Op = PrintName("InitFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldSint16:
  Text.Op = PrintName("InitFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldUint16:
  Text.Op = PrintName("InitFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldSint32:
  Text.Op = PrintName("InitFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldUint32:
  Text.Op = PrintName("InitFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldSint64:
  Text.Op = PrintName("InitFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldUint64:
  Text.Op = PrintName("InitFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldIntAP:
  Text.Op = PrintName("InitFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldIntAPS:
  Text.Op = PrintName("InitFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldBool:
  Text.Op = PrintName("InitFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldFixedPoint:
  Text.Op = PrintName("InitFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldPtr:
  Text.Op = PrintName("InitFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldMemberPtr:
  Text.Op = PrintName("InitFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldFloat:
  Text.Op = PrintName("InitFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitFieldSint8( uint32_t , SourceInfo);
bool emitInitFieldUint8( uint32_t , SourceInfo);
bool emitInitFieldSint16( uint32_t , SourceInfo);
bool emitInitFieldUint16( uint32_t , SourceInfo);
bool emitInitFieldSint32( uint32_t , SourceInfo);
bool emitInitFieldUint32( uint32_t , SourceInfo);
bool emitInitFieldSint64( uint32_t , SourceInfo);
bool emitInitFieldUint64( uint32_t , SourceInfo);
bool emitInitFieldIntAP( uint32_t , SourceInfo);
bool emitInitFieldIntAPS( uint32_t , SourceInfo);
bool emitInitFieldBool( uint32_t , SourceInfo);
bool emitInitFieldFixedPoint( uint32_t , SourceInfo);
bool emitInitFieldPtr( uint32_t , SourceInfo);
bool emitInitFieldMemberPtr( uint32_t , SourceInfo);
bool emitInitFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitFieldSint8(A0, I);
  case PT_Uint8:
    return emitInitFieldUint8(A0, I);
  case PT_Sint16:
    return emitInitFieldSint16(A0, I);
  case PT_Uint16:
    return emitInitFieldUint16(A0, I);
  case PT_Sint32:
    return emitInitFieldSint32(A0, I);
  case PT_Uint32:
    return emitInitFieldUint32(A0, I);
  case PT_Sint64:
    return emitInitFieldSint64(A0, I);
  case PT_Uint64:
    return emitInitFieldUint64(A0, I);
  case PT_IntAP:
    return emitInitFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitInitFieldIntAPS(A0, I);
  case PT_Bool:
    return emitInitFieldBool(A0, I);
  case PT_FixedPoint:
    return emitInitFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitInitFieldMemberPtr(A0, I);
  case PT_Float:
    return emitInitFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitInitFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitInitFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitInitFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitInitFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitInitFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitInitFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitInitFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitInitFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldBool, A0, L);
}
bool ByteCodeEmitter::emitInitFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitInitFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitFieldActivateSint8,
OP_InitFieldActivateUint8,
OP_InitFieldActivateSint16,
OP_InitFieldActivateUint16,
OP_InitFieldActivateSint32,
OP_InitFieldActivateUint32,
OP_InitFieldActivateSint64,
OP_InitFieldActivateUint64,
OP_InitFieldActivateIntAP,
OP_InitFieldActivateIntAPS,
OP_InitFieldActivateBool,
OP_InitFieldActivateFixedPoint,
OP_InitFieldActivatePtr,
OP_InitFieldActivateMemberPtr,
OP_InitFieldActivateFloat,
#endif
#ifdef GET_INTERP
case OP_InitFieldActivateSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivatePtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitFieldActivateFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitFieldActivate<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitFieldActivateSint8:
  Text.Op = PrintName("InitFieldActivateSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateUint8:
  Text.Op = PrintName("InitFieldActivateUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateSint16:
  Text.Op = PrintName("InitFieldActivateSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateUint16:
  Text.Op = PrintName("InitFieldActivateUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateSint32:
  Text.Op = PrintName("InitFieldActivateSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateUint32:
  Text.Op = PrintName("InitFieldActivateUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateSint64:
  Text.Op = PrintName("InitFieldActivateSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateUint64:
  Text.Op = PrintName("InitFieldActivateUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateIntAP:
  Text.Op = PrintName("InitFieldActivateIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateIntAPS:
  Text.Op = PrintName("InitFieldActivateIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateBool:
  Text.Op = PrintName("InitFieldActivateBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateFixedPoint:
  Text.Op = PrintName("InitFieldActivateFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivatePtr:
  Text.Op = PrintName("InitFieldActivatePtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateMemberPtr:
  Text.Op = PrintName("InitFieldActivateMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitFieldActivateFloat:
  Text.Op = PrintName("InitFieldActivateFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitFieldActivateSint8( uint32_t , SourceInfo);
bool emitInitFieldActivateUint8( uint32_t , SourceInfo);
bool emitInitFieldActivateSint16( uint32_t , SourceInfo);
bool emitInitFieldActivateUint16( uint32_t , SourceInfo);
bool emitInitFieldActivateSint32( uint32_t , SourceInfo);
bool emitInitFieldActivateUint32( uint32_t , SourceInfo);
bool emitInitFieldActivateSint64( uint32_t , SourceInfo);
bool emitInitFieldActivateUint64( uint32_t , SourceInfo);
bool emitInitFieldActivateIntAP( uint32_t , SourceInfo);
bool emitInitFieldActivateIntAPS( uint32_t , SourceInfo);
bool emitInitFieldActivateBool( uint32_t , SourceInfo);
bool emitInitFieldActivateFixedPoint( uint32_t , SourceInfo);
bool emitInitFieldActivatePtr( uint32_t , SourceInfo);
bool emitInitFieldActivateMemberPtr( uint32_t , SourceInfo);
bool emitInitFieldActivateFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitFieldActivate(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitFieldActivate(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitFieldActivateSint8(A0, I);
  case PT_Uint8:
    return emitInitFieldActivateUint8(A0, I);
  case PT_Sint16:
    return emitInitFieldActivateSint16(A0, I);
  case PT_Uint16:
    return emitInitFieldActivateUint16(A0, I);
  case PT_Sint32:
    return emitInitFieldActivateSint32(A0, I);
  case PT_Uint32:
    return emitInitFieldActivateUint32(A0, I);
  case PT_Sint64:
    return emitInitFieldActivateSint64(A0, I);
  case PT_Uint64:
    return emitInitFieldActivateUint64(A0, I);
  case PT_IntAP:
    return emitInitFieldActivateIntAP(A0, I);
  case PT_IntAPS:
    return emitInitFieldActivateIntAPS(A0, I);
  case PT_Bool:
    return emitInitFieldActivateBool(A0, I);
  case PT_FixedPoint:
    return emitInitFieldActivateFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitFieldActivatePtr(A0, I);
  case PT_MemberPtr:
    return emitInitFieldActivateMemberPtr(A0, I);
  case PT_Float:
    return emitInitFieldActivateFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitFieldActivateSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateSint8, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateUint8, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateSint16, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateUint16, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateSint32, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateUint32, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateSint64, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateUint64, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateBool, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivatePtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivatePtr, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitFieldActivateFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitFieldActivateFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitFieldActivateSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivatePtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitFieldActivateFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitFieldActivate<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitGlobalSint8,
OP_InitGlobalUint8,
OP_InitGlobalSint16,
OP_InitGlobalUint16,
OP_InitGlobalSint32,
OP_InitGlobalUint32,
OP_InitGlobalSint64,
OP_InitGlobalUint64,
OP_InitGlobalIntAP,
OP_InitGlobalIntAPS,
OP_InitGlobalBool,
OP_InitGlobalFixedPoint,
OP_InitGlobalPtr,
OP_InitGlobalMemberPtr,
OP_InitGlobalFloat,
#endif
#ifdef GET_INTERP
case OP_InitGlobalSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitGlobalFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitGlobal<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitGlobalSint8:
  Text.Op = PrintName("InitGlobalSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalUint8:
  Text.Op = PrintName("InitGlobalUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalSint16:
  Text.Op = PrintName("InitGlobalSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalUint16:
  Text.Op = PrintName("InitGlobalUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalSint32:
  Text.Op = PrintName("InitGlobalSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalUint32:
  Text.Op = PrintName("InitGlobalUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalSint64:
  Text.Op = PrintName("InitGlobalSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalUint64:
  Text.Op = PrintName("InitGlobalUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalIntAP:
  Text.Op = PrintName("InitGlobalIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalIntAPS:
  Text.Op = PrintName("InitGlobalIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalBool:
  Text.Op = PrintName("InitGlobalBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalFixedPoint:
  Text.Op = PrintName("InitGlobalFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalPtr:
  Text.Op = PrintName("InitGlobalPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalMemberPtr:
  Text.Op = PrintName("InitGlobalMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitGlobalFloat:
  Text.Op = PrintName("InitGlobalFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitGlobalSint8( uint32_t , SourceInfo);
bool emitInitGlobalUint8( uint32_t , SourceInfo);
bool emitInitGlobalSint16( uint32_t , SourceInfo);
bool emitInitGlobalUint16( uint32_t , SourceInfo);
bool emitInitGlobalSint32( uint32_t , SourceInfo);
bool emitInitGlobalUint32( uint32_t , SourceInfo);
bool emitInitGlobalSint64( uint32_t , SourceInfo);
bool emitInitGlobalUint64( uint32_t , SourceInfo);
bool emitInitGlobalIntAP( uint32_t , SourceInfo);
bool emitInitGlobalIntAPS( uint32_t , SourceInfo);
bool emitInitGlobalBool( uint32_t , SourceInfo);
bool emitInitGlobalFixedPoint( uint32_t , SourceInfo);
bool emitInitGlobalPtr( uint32_t , SourceInfo);
bool emitInitGlobalMemberPtr( uint32_t , SourceInfo);
bool emitInitGlobalFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitGlobal(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitGlobal(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitGlobalSint8(A0, I);
  case PT_Uint8:
    return emitInitGlobalUint8(A0, I);
  case PT_Sint16:
    return emitInitGlobalSint16(A0, I);
  case PT_Uint16:
    return emitInitGlobalUint16(A0, I);
  case PT_Sint32:
    return emitInitGlobalSint32(A0, I);
  case PT_Uint32:
    return emitInitGlobalUint32(A0, I);
  case PT_Sint64:
    return emitInitGlobalSint64(A0, I);
  case PT_Uint64:
    return emitInitGlobalUint64(A0, I);
  case PT_IntAP:
    return emitInitGlobalIntAP(A0, I);
  case PT_IntAPS:
    return emitInitGlobalIntAPS(A0, I);
  case PT_Bool:
    return emitInitGlobalBool(A0, I);
  case PT_FixedPoint:
    return emitInitGlobalFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitGlobalPtr(A0, I);
  case PT_MemberPtr:
    return emitInitGlobalMemberPtr(A0, I);
  case PT_Float:
    return emitInitGlobalFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitGlobalSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalSint8, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalUint8, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalSint16, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalUint16, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalSint32, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalUint32, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalSint64, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalUint64, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalBool, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalPtr, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitGlobalFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitGlobalFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitGlobalSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitGlobalFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobal<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitGlobalTempSint8,
OP_InitGlobalTempUint8,
OP_InitGlobalTempSint16,
OP_InitGlobalTempUint16,
OP_InitGlobalTempSint32,
OP_InitGlobalTempUint32,
OP_InitGlobalTempSint64,
OP_InitGlobalTempUint64,
OP_InitGlobalTempIntAP,
OP_InitGlobalTempIntAPS,
OP_InitGlobalTempBool,
OP_InitGlobalTempFixedPoint,
OP_InitGlobalTempPtr,
OP_InitGlobalTempMemberPtr,
OP_InitGlobalTempFloat,
#endif
#ifdef GET_INTERP
case OP_InitGlobalTempSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Sint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Uint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Sint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Uint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Sint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Uint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Sint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Uint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_IntAP>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_IntAPS>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Bool>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_FixedPoint>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Ptr>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_MemberPtr>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitGlobalTempFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  const auto V1 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTemp<PT_Float>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitGlobalTempSint8:
  Text.Op = PrintName("InitGlobalTempSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempUint8:
  Text.Op = PrintName("InitGlobalTempUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempSint16:
  Text.Op = PrintName("InitGlobalTempSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempUint16:
  Text.Op = PrintName("InitGlobalTempUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempSint32:
  Text.Op = PrintName("InitGlobalTempSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempUint32:
  Text.Op = PrintName("InitGlobalTempUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempSint64:
  Text.Op = PrintName("InitGlobalTempSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempUint64:
  Text.Op = PrintName("InitGlobalTempUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempIntAP:
  Text.Op = PrintName("InitGlobalTempIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempIntAPS:
  Text.Op = PrintName("InitGlobalTempIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempBool:
  Text.Op = PrintName("InitGlobalTempBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempFixedPoint:
  Text.Op = PrintName("InitGlobalTempFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempPtr:
  Text.Op = PrintName("InitGlobalTempPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempMemberPtr:
  Text.Op = PrintName("InitGlobalTempMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
case OP_InitGlobalTempFloat:
  Text.Op = PrintName("InitGlobalTempFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitGlobalTempSint8( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempUint8( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempSint16( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempUint16( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempSint32( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempUint32( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempSint64( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempUint64( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempIntAP( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempIntAPS( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempBool( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempFixedPoint( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempPtr( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempMemberPtr( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
bool emitInitGlobalTempFloat( uint32_t ,  const LifetimeExtendedTemporaryDecl * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitGlobalTemp(PrimType, uint32_t, const LifetimeExtendedTemporaryDecl *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitGlobalTemp(PrimType T0,  uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitGlobalTempSint8(A0, A1, I);
  case PT_Uint8:
    return emitInitGlobalTempUint8(A0, A1, I);
  case PT_Sint16:
    return emitInitGlobalTempSint16(A0, A1, I);
  case PT_Uint16:
    return emitInitGlobalTempUint16(A0, A1, I);
  case PT_Sint32:
    return emitInitGlobalTempSint32(A0, A1, I);
  case PT_Uint32:
    return emitInitGlobalTempUint32(A0, A1, I);
  case PT_Sint64:
    return emitInitGlobalTempSint64(A0, A1, I);
  case PT_Uint64:
    return emitInitGlobalTempUint64(A0, A1, I);
  case PT_IntAP:
    return emitInitGlobalTempIntAP(A0, A1, I);
  case PT_IntAPS:
    return emitInitGlobalTempIntAPS(A0, A1, I);
  case PT_Bool:
    return emitInitGlobalTempBool(A0, A1, I);
  case PT_FixedPoint:
    return emitInitGlobalTempFixedPoint(A0, A1, I);
  case PT_Ptr:
    return emitInitGlobalTempPtr(A0, A1, I);
  case PT_MemberPtr:
    return emitInitGlobalTempMemberPtr(A0, A1, I);
  case PT_Float:
    return emitInitGlobalTempFloat(A0, A1, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitGlobalTempSint8( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempSint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempUint8( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempUint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempSint16( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempSint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempUint16( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempUint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempSint32( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempSint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempUint32( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempUint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempSint64( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempSint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempUint64( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempUint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempIntAP( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempIntAP, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempIntAPS( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempIntAPS, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempBool( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempBool, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempFixedPoint( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempFixedPoint, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempPtr( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempPtr, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempMemberPtr( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempMemberPtr, A0, A1, L);
}
bool ByteCodeEmitter::emitInitGlobalTempFloat( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  return emitOp<uint32_t, const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempFloat, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitGlobalTempSint8( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Sint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempUint8( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Uint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempSint16( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Sint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempUint16( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Uint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempSint32( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Sint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempUint32( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Uint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempSint64( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Sint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempUint64( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Uint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempIntAP( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_IntAP>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempIntAPS( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_IntAPS>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempBool( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Bool>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempFixedPoint( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_FixedPoint>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempPtr( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Ptr>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempMemberPtr( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_MemberPtr>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitGlobalTempFloat( uint32_t A0,  const LifetimeExtendedTemporaryDecl * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTemp<PT_Float>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitGlobalTempComp,
#endif
#ifdef GET_INTERP
case OP_InitGlobalTempComp: {
  const auto V0 = ReadArg<const LifetimeExtendedTemporaryDecl *>(S, PC);
  if (!InitGlobalTempComp(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitGlobalTempComp:
  Text.Op = PrintName("InitGlobalTempComp");
  Text.Args.push_back(printArg<const LifetimeExtendedTemporaryDecl *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitGlobalTempComp( const LifetimeExtendedTemporaryDecl * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitGlobalTempComp( const LifetimeExtendedTemporaryDecl * A0, SourceInfo L) {
  return emitOp<const LifetimeExtendedTemporaryDecl *>(OP_InitGlobalTempComp, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitGlobalTempComp( const LifetimeExtendedTemporaryDecl * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitGlobalTempComp(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitPopSint8,
OP_InitPopUint8,
OP_InitPopSint16,
OP_InitPopUint16,
OP_InitPopSint32,
OP_InitPopUint32,
OP_InitPopSint64,
OP_InitPopUint64,
OP_InitPopIntAP,
OP_InitPopIntAPS,
OP_InitPopBool,
OP_InitPopFixedPoint,
OP_InitPopPtr,
OP_InitPopMemberPtr,
OP_InitPopFloat,
#endif
#ifdef GET_INTERP
case OP_InitPopSint8: {
  if (!InitPop<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopUint8: {
  if (!InitPop<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopSint16: {
  if (!InitPop<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopUint16: {
  if (!InitPop<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopSint32: {
  if (!InitPop<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopUint32: {
  if (!InitPop<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopSint64: {
  if (!InitPop<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopUint64: {
  if (!InitPop<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopIntAP: {
  if (!InitPop<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopIntAPS: {
  if (!InitPop<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopBool: {
  if (!InitPop<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopFixedPoint: {
  if (!InitPop<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopPtr: {
  if (!InitPop<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopMemberPtr: {
  if (!InitPop<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_InitPopFloat: {
  if (!InitPop<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitPopSint8:
  Text.Op = PrintName("InitPopSint8");
  break;
case OP_InitPopUint8:
  Text.Op = PrintName("InitPopUint8");
  break;
case OP_InitPopSint16:
  Text.Op = PrintName("InitPopSint16");
  break;
case OP_InitPopUint16:
  Text.Op = PrintName("InitPopUint16");
  break;
case OP_InitPopSint32:
  Text.Op = PrintName("InitPopSint32");
  break;
case OP_InitPopUint32:
  Text.Op = PrintName("InitPopUint32");
  break;
case OP_InitPopSint64:
  Text.Op = PrintName("InitPopSint64");
  break;
case OP_InitPopUint64:
  Text.Op = PrintName("InitPopUint64");
  break;
case OP_InitPopIntAP:
  Text.Op = PrintName("InitPopIntAP");
  break;
case OP_InitPopIntAPS:
  Text.Op = PrintName("InitPopIntAPS");
  break;
case OP_InitPopBool:
  Text.Op = PrintName("InitPopBool");
  break;
case OP_InitPopFixedPoint:
  Text.Op = PrintName("InitPopFixedPoint");
  break;
case OP_InitPopPtr:
  Text.Op = PrintName("InitPopPtr");
  break;
case OP_InitPopMemberPtr:
  Text.Op = PrintName("InitPopMemberPtr");
  break;
case OP_InitPopFloat:
  Text.Op = PrintName("InitPopFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitPopSint8(SourceInfo);
bool emitInitPopUint8(SourceInfo);
bool emitInitPopSint16(SourceInfo);
bool emitInitPopUint16(SourceInfo);
bool emitInitPopSint32(SourceInfo);
bool emitInitPopUint32(SourceInfo);
bool emitInitPopSint64(SourceInfo);
bool emitInitPopUint64(SourceInfo);
bool emitInitPopIntAP(SourceInfo);
bool emitInitPopIntAPS(SourceInfo);
bool emitInitPopBool(SourceInfo);
bool emitInitPopFixedPoint(SourceInfo);
bool emitInitPopPtr(SourceInfo);
bool emitInitPopMemberPtr(SourceInfo);
bool emitInitPopFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitPop(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitPop(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitPopSint8(I);
  case PT_Uint8:
    return emitInitPopUint8(I);
  case PT_Sint16:
    return emitInitPopSint16(I);
  case PT_Uint16:
    return emitInitPopUint16(I);
  case PT_Sint32:
    return emitInitPopSint32(I);
  case PT_Uint32:
    return emitInitPopUint32(I);
  case PT_Sint64:
    return emitInitPopSint64(I);
  case PT_Uint64:
    return emitInitPopUint64(I);
  case PT_IntAP:
    return emitInitPopIntAP(I);
  case PT_IntAPS:
    return emitInitPopIntAPS(I);
  case PT_Bool:
    return emitInitPopBool(I);
  case PT_FixedPoint:
    return emitInitPopFixedPoint(I);
  case PT_Ptr:
    return emitInitPopPtr(I);
  case PT_MemberPtr:
    return emitInitPopMemberPtr(I);
  case PT_Float:
    return emitInitPopFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitPopSint8(SourceInfo L) {
  return emitOp<>(OP_InitPopSint8, L);
}
bool ByteCodeEmitter::emitInitPopUint8(SourceInfo L) {
  return emitOp<>(OP_InitPopUint8, L);
}
bool ByteCodeEmitter::emitInitPopSint16(SourceInfo L) {
  return emitOp<>(OP_InitPopSint16, L);
}
bool ByteCodeEmitter::emitInitPopUint16(SourceInfo L) {
  return emitOp<>(OP_InitPopUint16, L);
}
bool ByteCodeEmitter::emitInitPopSint32(SourceInfo L) {
  return emitOp<>(OP_InitPopSint32, L);
}
bool ByteCodeEmitter::emitInitPopUint32(SourceInfo L) {
  return emitOp<>(OP_InitPopUint32, L);
}
bool ByteCodeEmitter::emitInitPopSint64(SourceInfo L) {
  return emitOp<>(OP_InitPopSint64, L);
}
bool ByteCodeEmitter::emitInitPopUint64(SourceInfo L) {
  return emitOp<>(OP_InitPopUint64, L);
}
bool ByteCodeEmitter::emitInitPopIntAP(SourceInfo L) {
  return emitOp<>(OP_InitPopIntAP, L);
}
bool ByteCodeEmitter::emitInitPopIntAPS(SourceInfo L) {
  return emitOp<>(OP_InitPopIntAPS, L);
}
bool ByteCodeEmitter::emitInitPopBool(SourceInfo L) {
  return emitOp<>(OP_InitPopBool, L);
}
bool ByteCodeEmitter::emitInitPopFixedPoint(SourceInfo L) {
  return emitOp<>(OP_InitPopFixedPoint, L);
}
bool ByteCodeEmitter::emitInitPopPtr(SourceInfo L) {
  return emitOp<>(OP_InitPopPtr, L);
}
bool ByteCodeEmitter::emitInitPopMemberPtr(SourceInfo L) {
  return emitOp<>(OP_InitPopMemberPtr, L);
}
bool ByteCodeEmitter::emitInitPopFloat(SourceInfo L) {
  return emitOp<>(OP_InitPopFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitPopSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitInitPopUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitInitPopSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitInitPopUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitInitPopSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitInitPopUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitInitPopSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitInitPopUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitInitPopIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitInitPopIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitInitPopBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitInitPopFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitInitPopPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitInitPopMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitInitPopFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitPop<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitScope,
#endif
#ifdef GET_INTERP
case OP_InitScope: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitScope(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitScope:
  Text.Op = PrintName("InitScope");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitScope( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitScope( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitScope, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitScope( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitScope(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitThisBitFieldSint8,
OP_InitThisBitFieldUint8,
OP_InitThisBitFieldSint16,
OP_InitThisBitFieldUint16,
OP_InitThisBitFieldSint32,
OP_InitThisBitFieldUint32,
OP_InitThisBitFieldSint64,
OP_InitThisBitFieldUint64,
OP_InitThisBitFieldIntAP,
OP_InitThisBitFieldIntAPS,
OP_InitThisBitFieldBool,
OP_InitThisBitFieldFixedPoint,
#endif
#ifdef GET_INTERP
case OP_InitThisBitFieldSint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Sint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldUint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Uint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldSint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Sint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldUint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Uint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldSint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Sint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldUint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Uint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldSint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Sint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldUint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Uint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldIntAP: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_IntAP>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldIntAPS: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_IntAPS>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldBool: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_Bool>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldFixedPoint: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitField<PT_FixedPoint>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitThisBitFieldSint8:
  Text.Op = PrintName("InitThisBitFieldSint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldUint8:
  Text.Op = PrintName("InitThisBitFieldUint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldSint16:
  Text.Op = PrintName("InitThisBitFieldSint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldUint16:
  Text.Op = PrintName("InitThisBitFieldUint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldSint32:
  Text.Op = PrintName("InitThisBitFieldSint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldUint32:
  Text.Op = PrintName("InitThisBitFieldUint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldSint64:
  Text.Op = PrintName("InitThisBitFieldSint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldUint64:
  Text.Op = PrintName("InitThisBitFieldUint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldIntAP:
  Text.Op = PrintName("InitThisBitFieldIntAP");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldIntAPS:
  Text.Op = PrintName("InitThisBitFieldIntAPS");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldBool:
  Text.Op = PrintName("InitThisBitFieldBool");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldFixedPoint:
  Text.Op = PrintName("InitThisBitFieldFixedPoint");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitThisBitFieldSint8( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldUint8( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldSint16( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldUint16( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldSint32( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldUint32( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldSint64( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldUint64( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldIntAP( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldIntAPS( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldBool( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldFixedPoint( const Record::Field * ,  uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitThisBitField(PrimType, const Record::Field *, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitThisBitField(PrimType T0,  const Record::Field * A0,  uint32_t A1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitThisBitFieldSint8(A0, A1, I);
  case PT_Uint8:
    return emitInitThisBitFieldUint8(A0, A1, I);
  case PT_Sint16:
    return emitInitThisBitFieldSint16(A0, A1, I);
  case PT_Uint16:
    return emitInitThisBitFieldUint16(A0, A1, I);
  case PT_Sint32:
    return emitInitThisBitFieldSint32(A0, A1, I);
  case PT_Uint32:
    return emitInitThisBitFieldUint32(A0, A1, I);
  case PT_Sint64:
    return emitInitThisBitFieldSint64(A0, A1, I);
  case PT_Uint64:
    return emitInitThisBitFieldUint64(A0, A1, I);
  case PT_IntAP:
    return emitInitThisBitFieldIntAP(A0, A1, I);
  case PT_IntAPS:
    return emitInitThisBitFieldIntAPS(A0, A1, I);
  case PT_Bool:
    return emitInitThisBitFieldBool(A0, A1, I);
  case PT_FixedPoint:
    return emitInitThisBitFieldFixedPoint(A0, A1, I);
  default: llvm_unreachable("invalid type: emitInitThisBitField");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitThisBitFieldSint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldSint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldUint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldUint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldSint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldSint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldUint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldUint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldSint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldSint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldUint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldUint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldSint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldSint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldUint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldUint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldIntAP( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldIntAP, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldIntAPS( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldIntAPS, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldBool( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldBool, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldFixedPoint( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldFixedPoint, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitThisBitFieldSint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Sint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldUint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Uint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldSint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Sint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldUint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Uint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldSint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Sint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldUint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Uint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldSint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Sint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldUint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Uint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldIntAP( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_IntAP>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldIntAPS( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_IntAPS>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldBool( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_Bool>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldFixedPoint( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitField<PT_FixedPoint>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitThisBitFieldActivateSint8,
OP_InitThisBitFieldActivateUint8,
OP_InitThisBitFieldActivateSint16,
OP_InitThisBitFieldActivateUint16,
OP_InitThisBitFieldActivateSint32,
OP_InitThisBitFieldActivateUint32,
OP_InitThisBitFieldActivateSint64,
OP_InitThisBitFieldActivateUint64,
OP_InitThisBitFieldActivateIntAP,
OP_InitThisBitFieldActivateIntAPS,
OP_InitThisBitFieldActivateBool,
OP_InitThisBitFieldActivateFixedPoint,
#endif
#ifdef GET_INTERP
case OP_InitThisBitFieldActivateSint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Sint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateUint8: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Uint8>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateSint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Sint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateUint16: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Uint16>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateSint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Sint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateUint32: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Uint32>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateSint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Sint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateUint64: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Uint64>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateIntAP: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_IntAP>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateIntAPS: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_IntAPS>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateBool: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_Bool>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_InitThisBitFieldActivateFixedPoint: {
  const auto V0 = ReadArg<const Record::Field *>(S, PC);
  const auto V1 = ReadArg<uint32_t>(S, PC);
  if (!InitThisBitFieldActivate<PT_FixedPoint>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitThisBitFieldActivateSint8:
  Text.Op = PrintName("InitThisBitFieldActivateSint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateUint8:
  Text.Op = PrintName("InitThisBitFieldActivateUint8");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateSint16:
  Text.Op = PrintName("InitThisBitFieldActivateSint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateUint16:
  Text.Op = PrintName("InitThisBitFieldActivateUint16");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateSint32:
  Text.Op = PrintName("InitThisBitFieldActivateSint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateUint32:
  Text.Op = PrintName("InitThisBitFieldActivateUint32");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateSint64:
  Text.Op = PrintName("InitThisBitFieldActivateSint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateUint64:
  Text.Op = PrintName("InitThisBitFieldActivateUint64");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateIntAP:
  Text.Op = PrintName("InitThisBitFieldActivateIntAP");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateIntAPS:
  Text.Op = PrintName("InitThisBitFieldActivateIntAPS");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateBool:
  Text.Op = PrintName("InitThisBitFieldActivateBool");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisBitFieldActivateFixedPoint:
  Text.Op = PrintName("InitThisBitFieldActivateFixedPoint");
  Text.Args.push_back(printArg<const Record::Field *>(P, PC));
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitThisBitFieldActivateSint8( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateUint8( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateSint16( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateUint16( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateSint32( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateUint32( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateSint64( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateUint64( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateIntAP( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateIntAPS( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateBool( const Record::Field * ,  uint32_t , SourceInfo);
bool emitInitThisBitFieldActivateFixedPoint( const Record::Field * ,  uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitThisBitFieldActivate(PrimType, const Record::Field *, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitThisBitFieldActivate(PrimType T0,  const Record::Field * A0,  uint32_t A1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitThisBitFieldActivateSint8(A0, A1, I);
  case PT_Uint8:
    return emitInitThisBitFieldActivateUint8(A0, A1, I);
  case PT_Sint16:
    return emitInitThisBitFieldActivateSint16(A0, A1, I);
  case PT_Uint16:
    return emitInitThisBitFieldActivateUint16(A0, A1, I);
  case PT_Sint32:
    return emitInitThisBitFieldActivateSint32(A0, A1, I);
  case PT_Uint32:
    return emitInitThisBitFieldActivateUint32(A0, A1, I);
  case PT_Sint64:
    return emitInitThisBitFieldActivateSint64(A0, A1, I);
  case PT_Uint64:
    return emitInitThisBitFieldActivateUint64(A0, A1, I);
  case PT_IntAP:
    return emitInitThisBitFieldActivateIntAP(A0, A1, I);
  case PT_IntAPS:
    return emitInitThisBitFieldActivateIntAPS(A0, A1, I);
  case PT_Bool:
    return emitInitThisBitFieldActivateBool(A0, A1, I);
  case PT_FixedPoint:
    return emitInitThisBitFieldActivateFixedPoint(A0, A1, I);
  default: llvm_unreachable("invalid type: emitInitThisBitFieldActivate");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitThisBitFieldActivateSint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateSint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateUint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateUint8, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateSint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateSint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateUint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateUint16, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateSint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateSint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateUint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateUint32, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateSint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateSint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateUint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateUint64, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateIntAP( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateIntAP, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateIntAPS( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateIntAPS, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateBool( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateBool, A0, A1, L);
}
bool ByteCodeEmitter::emitInitThisBitFieldActivateFixedPoint( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  return emitOp<const Record::Field *, uint32_t>(OP_InitThisBitFieldActivateFixedPoint, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitThisBitFieldActivateSint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Sint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateUint8( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Uint8>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateSint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Sint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateUint16( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Uint16>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateSint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Sint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateUint32( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Uint32>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateSint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Sint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateUint64( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Uint64>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateIntAP( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_IntAP>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateIntAPS( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_IntAPS>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateBool( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_Bool>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitInitThisBitFieldActivateFixedPoint( const Record::Field * A0,  uint32_t A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisBitFieldActivate<PT_FixedPoint>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitThisFieldSint8,
OP_InitThisFieldUint8,
OP_InitThisFieldSint16,
OP_InitThisFieldUint16,
OP_InitThisFieldSint32,
OP_InitThisFieldUint32,
OP_InitThisFieldSint64,
OP_InitThisFieldUint64,
OP_InitThisFieldIntAP,
OP_InitThisFieldIntAPS,
OP_InitThisFieldBool,
OP_InitThisFieldFixedPoint,
OP_InitThisFieldPtr,
OP_InitThisFieldMemberPtr,
OP_InitThisFieldFloat,
#endif
#ifdef GET_INTERP
case OP_InitThisFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitThisFieldSint8:
  Text.Op = PrintName("InitThisFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldUint8:
  Text.Op = PrintName("InitThisFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldSint16:
  Text.Op = PrintName("InitThisFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldUint16:
  Text.Op = PrintName("InitThisFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldSint32:
  Text.Op = PrintName("InitThisFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldUint32:
  Text.Op = PrintName("InitThisFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldSint64:
  Text.Op = PrintName("InitThisFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldUint64:
  Text.Op = PrintName("InitThisFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldIntAP:
  Text.Op = PrintName("InitThisFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldIntAPS:
  Text.Op = PrintName("InitThisFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldBool:
  Text.Op = PrintName("InitThisFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldFixedPoint:
  Text.Op = PrintName("InitThisFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldPtr:
  Text.Op = PrintName("InitThisFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldMemberPtr:
  Text.Op = PrintName("InitThisFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldFloat:
  Text.Op = PrintName("InitThisFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitThisFieldSint8( uint32_t , SourceInfo);
bool emitInitThisFieldUint8( uint32_t , SourceInfo);
bool emitInitThisFieldSint16( uint32_t , SourceInfo);
bool emitInitThisFieldUint16( uint32_t , SourceInfo);
bool emitInitThisFieldSint32( uint32_t , SourceInfo);
bool emitInitThisFieldUint32( uint32_t , SourceInfo);
bool emitInitThisFieldSint64( uint32_t , SourceInfo);
bool emitInitThisFieldUint64( uint32_t , SourceInfo);
bool emitInitThisFieldIntAP( uint32_t , SourceInfo);
bool emitInitThisFieldIntAPS( uint32_t , SourceInfo);
bool emitInitThisFieldBool( uint32_t , SourceInfo);
bool emitInitThisFieldFixedPoint( uint32_t , SourceInfo);
bool emitInitThisFieldPtr( uint32_t , SourceInfo);
bool emitInitThisFieldMemberPtr( uint32_t , SourceInfo);
bool emitInitThisFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitThisField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitThisField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitThisFieldSint8(A0, I);
  case PT_Uint8:
    return emitInitThisFieldUint8(A0, I);
  case PT_Sint16:
    return emitInitThisFieldSint16(A0, I);
  case PT_Uint16:
    return emitInitThisFieldUint16(A0, I);
  case PT_Sint32:
    return emitInitThisFieldSint32(A0, I);
  case PT_Uint32:
    return emitInitThisFieldUint32(A0, I);
  case PT_Sint64:
    return emitInitThisFieldSint64(A0, I);
  case PT_Uint64:
    return emitInitThisFieldUint64(A0, I);
  case PT_IntAP:
    return emitInitThisFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitInitThisFieldIntAPS(A0, I);
  case PT_Bool:
    return emitInitThisFieldBool(A0, I);
  case PT_FixedPoint:
    return emitInitThisFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitThisFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitInitThisFieldMemberPtr(A0, I);
  case PT_Float:
    return emitInitThisFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitThisFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldBool, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitThisFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InitThisFieldActivateSint8,
OP_InitThisFieldActivateUint8,
OP_InitThisFieldActivateSint16,
OP_InitThisFieldActivateUint16,
OP_InitThisFieldActivateSint32,
OP_InitThisFieldActivateUint32,
OP_InitThisFieldActivateSint64,
OP_InitThisFieldActivateUint64,
OP_InitThisFieldActivateIntAP,
OP_InitThisFieldActivateIntAPS,
OP_InitThisFieldActivateBool,
OP_InitThisFieldActivateFixedPoint,
OP_InitThisFieldActivatePtr,
OP_InitThisFieldActivateMemberPtr,
OP_InitThisFieldActivateFloat,
#endif
#ifdef GET_INTERP
case OP_InitThisFieldActivateSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivatePtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_InitThisFieldActivateFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InitThisFieldActivate<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InitThisFieldActivateSint8:
  Text.Op = PrintName("InitThisFieldActivateSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateUint8:
  Text.Op = PrintName("InitThisFieldActivateUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateSint16:
  Text.Op = PrintName("InitThisFieldActivateSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateUint16:
  Text.Op = PrintName("InitThisFieldActivateUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateSint32:
  Text.Op = PrintName("InitThisFieldActivateSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateUint32:
  Text.Op = PrintName("InitThisFieldActivateUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateSint64:
  Text.Op = PrintName("InitThisFieldActivateSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateUint64:
  Text.Op = PrintName("InitThisFieldActivateUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateIntAP:
  Text.Op = PrintName("InitThisFieldActivateIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateIntAPS:
  Text.Op = PrintName("InitThisFieldActivateIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateBool:
  Text.Op = PrintName("InitThisFieldActivateBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateFixedPoint:
  Text.Op = PrintName("InitThisFieldActivateFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivatePtr:
  Text.Op = PrintName("InitThisFieldActivatePtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateMemberPtr:
  Text.Op = PrintName("InitThisFieldActivateMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_InitThisFieldActivateFloat:
  Text.Op = PrintName("InitThisFieldActivateFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInitThisFieldActivateSint8( uint32_t , SourceInfo);
bool emitInitThisFieldActivateUint8( uint32_t , SourceInfo);
bool emitInitThisFieldActivateSint16( uint32_t , SourceInfo);
bool emitInitThisFieldActivateUint16( uint32_t , SourceInfo);
bool emitInitThisFieldActivateSint32( uint32_t , SourceInfo);
bool emitInitThisFieldActivateUint32( uint32_t , SourceInfo);
bool emitInitThisFieldActivateSint64( uint32_t , SourceInfo);
bool emitInitThisFieldActivateUint64( uint32_t , SourceInfo);
bool emitInitThisFieldActivateIntAP( uint32_t , SourceInfo);
bool emitInitThisFieldActivateIntAPS( uint32_t , SourceInfo);
bool emitInitThisFieldActivateBool( uint32_t , SourceInfo);
bool emitInitThisFieldActivateFixedPoint( uint32_t , SourceInfo);
bool emitInitThisFieldActivatePtr( uint32_t , SourceInfo);
bool emitInitThisFieldActivateMemberPtr( uint32_t , SourceInfo);
bool emitInitThisFieldActivateFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitInitThisFieldActivate(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitInitThisFieldActivate(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitInitThisFieldActivateSint8(A0, I);
  case PT_Uint8:
    return emitInitThisFieldActivateUint8(A0, I);
  case PT_Sint16:
    return emitInitThisFieldActivateSint16(A0, I);
  case PT_Uint16:
    return emitInitThisFieldActivateUint16(A0, I);
  case PT_Sint32:
    return emitInitThisFieldActivateSint32(A0, I);
  case PT_Uint32:
    return emitInitThisFieldActivateUint32(A0, I);
  case PT_Sint64:
    return emitInitThisFieldActivateSint64(A0, I);
  case PT_Uint64:
    return emitInitThisFieldActivateUint64(A0, I);
  case PT_IntAP:
    return emitInitThisFieldActivateIntAP(A0, I);
  case PT_IntAPS:
    return emitInitThisFieldActivateIntAPS(A0, I);
  case PT_Bool:
    return emitInitThisFieldActivateBool(A0, I);
  case PT_FixedPoint:
    return emitInitThisFieldActivateFixedPoint(A0, I);
  case PT_Ptr:
    return emitInitThisFieldActivatePtr(A0, I);
  case PT_MemberPtr:
    return emitInitThisFieldActivateMemberPtr(A0, I);
  case PT_Float:
    return emitInitThisFieldActivateFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInitThisFieldActivateSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateSint8, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateUint8, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateSint16, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateUint16, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateSint32, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateUint32, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateSint64, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateUint64, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateIntAP, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateIntAPS, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateBool, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivatePtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivatePtr, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitInitThisFieldActivateFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InitThisFieldActivateFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInitThisFieldActivateSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivatePtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitInitThisFieldActivateFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InitThisFieldActivate<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Inv,
#endif
#ifdef GET_INTERP
case OP_Inv: {
  if (!Inv(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Inv:
  Text.Op = PrintName("Inv");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInv(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInv(SourceInfo L) {
  return emitOp<>(OP_Inv, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInv(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Inv(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Invalid,
#endif
#ifdef GET_INTERP
case OP_Invalid: {
  if (!Invalid(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Invalid:
  Text.Op = PrintName("Invalid");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalid(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalid(SourceInfo L) {
  return emitOp<>(OP_Invalid, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalid(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Invalid(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InvalidCast,
#endif
#ifdef GET_INTERP
case OP_InvalidCast: {
  const auto V0 = ReadArg<interp::CastKind>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!InvalidCast(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InvalidCast:
  Text.Op = PrintName("InvalidCast");
  Text.Args.push_back(printArg<interp::CastKind>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalidCast( interp::CastKind ,  bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalidCast( interp::CastKind A0,  bool A1, SourceInfo L) {
  return emitOp<interp::CastKind, bool>(OP_InvalidCast, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalidCast( interp::CastKind A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InvalidCast(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InvalidDeclRef,
#endif
#ifdef GET_INTERP
case OP_InvalidDeclRef: {
  const auto V0 = ReadArg<const DeclRefExpr *>(S, PC);
  const auto V1 = ReadArg<bool>(S, PC);
  if (!InvalidDeclRef(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InvalidDeclRef:
  Text.Op = PrintName("InvalidDeclRef");
  Text.Args.push_back(printArg<const DeclRefExpr *>(P, PC));
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalidDeclRef( const DeclRefExpr * ,  bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalidDeclRef( const DeclRefExpr * A0,  bool A1, SourceInfo L) {
  return emitOp<const DeclRefExpr *, bool>(OP_InvalidDeclRef, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalidDeclRef( const DeclRefExpr * A0,  bool A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InvalidDeclRef(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InvalidNewDeleteExpr,
#endif
#ifdef GET_INTERP
case OP_InvalidNewDeleteExpr: {
  const auto V0 = ReadArg<const Expr *>(S, PC);
  if (!InvalidNewDeleteExpr(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InvalidNewDeleteExpr:
  Text.Op = PrintName("InvalidNewDeleteExpr");
  Text.Args.push_back(printArg<const Expr *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalidNewDeleteExpr( const Expr * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalidNewDeleteExpr( const Expr * A0, SourceInfo L) {
  return emitOp<const Expr *>(OP_InvalidNewDeleteExpr, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalidNewDeleteExpr( const Expr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InvalidNewDeleteExpr(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InvalidShuffleVectorIndex,
#endif
#ifdef GET_INTERP
case OP_InvalidShuffleVectorIndex: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!InvalidShuffleVectorIndex(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InvalidShuffleVectorIndex:
  Text.Op = PrintName("InvalidShuffleVectorIndex");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalidShuffleVectorIndex( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalidShuffleVectorIndex( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_InvalidShuffleVectorIndex, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalidShuffleVectorIndex( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InvalidShuffleVectorIndex(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_InvalidStore,
#endif
#ifdef GET_INTERP
case OP_InvalidStore: {
  const auto V0 = ReadArg<const Type *>(S, PC);
  if (!InvalidStore(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_InvalidStore:
  Text.Op = PrintName("InvalidStore");
  Text.Args.push_back(printArg<const Type *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitInvalidStore( const Type * , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitInvalidStore( const Type * A0, SourceInfo L) {
  return emitOp<const Type *>(OP_InvalidStore, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitInvalidStore( const Type * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return InvalidStore(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IsConstantContext,
#endif
#ifdef GET_INTERP
case OP_IsConstantContext: {
  if (!IsConstantContext(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IsConstantContext:
  Text.Op = PrintName("IsConstantContext");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIsConstantContext(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIsConstantContext(SourceInfo L) {
  return emitOp<>(OP_IsConstantContext, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIsConstantContext(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IsConstantContext(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_IsNonNullPtr,
OP_IsNonNullMemberPtr,
#endif
#ifdef GET_INTERP
case OP_IsNonNullPtr: {
  if (!IsNonNull<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_IsNonNullMemberPtr: {
  if (!IsNonNull<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_IsNonNullPtr:
  Text.Op = PrintName("IsNonNullPtr");
  break;
case OP_IsNonNullMemberPtr:
  Text.Op = PrintName("IsNonNullMemberPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitIsNonNullPtr(SourceInfo);
bool emitIsNonNullMemberPtr(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitIsNonNull(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitIsNonNull(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Ptr:
    return emitIsNonNullPtr(I);
  case PT_MemberPtr:
    return emitIsNonNullMemberPtr(I);
  default: llvm_unreachable("invalid type: emitIsNonNull");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitIsNonNullPtr(SourceInfo L) {
  return emitOp<>(OP_IsNonNullPtr, L);
}
bool ByteCodeEmitter::emitIsNonNullMemberPtr(SourceInfo L) {
  return emitOp<>(OP_IsNonNullMemberPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitIsNonNullPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IsNonNull<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitIsNonNullMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return IsNonNull<PT_MemberPtr>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Jf,
#endif
#ifdef GET_INTERP
case OP_Jf: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  if (!Jf(S, PC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Jf:
  Text.Op = PrintName("Jf");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitJf( int32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitJf( int32_t A0, SourceInfo L) {
  return emitOp<int32_t>(OP_Jf, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Jmp,
#endif
#ifdef GET_INTERP
case OP_Jmp: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  if (!Jmp(S, PC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Jmp:
  Text.Op = PrintName("Jmp");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitJmp( int32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitJmp( int32_t A0, SourceInfo L) {
  return emitOp<int32_t>(OP_Jmp, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Jt,
#endif
#ifdef GET_INTERP
case OP_Jt: {
  const auto V0 = ReadArg<int32_t>(S, PC);
  if (!Jt(S, PC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Jt:
  Text.Op = PrintName("Jt");
  Text.Args.push_back(printArg<int32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitJt( int32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitJt( int32_t A0, SourceInfo L) {
  return emitOp<int32_t>(OP_Jt, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_LESint8,
OP_LEUint8,
OP_LESint16,
OP_LEUint16,
OP_LESint32,
OP_LEUint32,
OP_LESint64,
OP_LEUint64,
OP_LEIntAP,
OP_LEIntAPS,
OP_LEBool,
OP_LEFixedPoint,
OP_LEPtr,
OP_LEFloat,
#endif
#ifdef GET_INTERP
case OP_LESint8: {
  if (!LE<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_LEUint8: {
  if (!LE<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_LESint16: {
  if (!LE<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_LEUint16: {
  if (!LE<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_LESint32: {
  if (!LE<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_LEUint32: {
  if (!LE<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_LESint64: {
  if (!LE<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_LEUint64: {
  if (!LE<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_LEIntAP: {
  if (!LE<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_LEIntAPS: {
  if (!LE<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_LEBool: {
  if (!LE<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_LEFixedPoint: {
  if (!LE<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_LEPtr: {
  if (!LE<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_LEFloat: {
  if (!LE<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_LESint8:
  Text.Op = PrintName("LESint8");
  break;
case OP_LEUint8:
  Text.Op = PrintName("LEUint8");
  break;
case OP_LESint16:
  Text.Op = PrintName("LESint16");
  break;
case OP_LEUint16:
  Text.Op = PrintName("LEUint16");
  break;
case OP_LESint32:
  Text.Op = PrintName("LESint32");
  break;
case OP_LEUint32:
  Text.Op = PrintName("LEUint32");
  break;
case OP_LESint64:
  Text.Op = PrintName("LESint64");
  break;
case OP_LEUint64:
  Text.Op = PrintName("LEUint64");
  break;
case OP_LEIntAP:
  Text.Op = PrintName("LEIntAP");
  break;
case OP_LEIntAPS:
  Text.Op = PrintName("LEIntAPS");
  break;
case OP_LEBool:
  Text.Op = PrintName("LEBool");
  break;
case OP_LEFixedPoint:
  Text.Op = PrintName("LEFixedPoint");
  break;
case OP_LEPtr:
  Text.Op = PrintName("LEPtr");
  break;
case OP_LEFloat:
  Text.Op = PrintName("LEFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitLESint8(SourceInfo);
bool emitLEUint8(SourceInfo);
bool emitLESint16(SourceInfo);
bool emitLEUint16(SourceInfo);
bool emitLESint32(SourceInfo);
bool emitLEUint32(SourceInfo);
bool emitLESint64(SourceInfo);
bool emitLEUint64(SourceInfo);
bool emitLEIntAP(SourceInfo);
bool emitLEIntAPS(SourceInfo);
bool emitLEBool(SourceInfo);
bool emitLEFixedPoint(SourceInfo);
bool emitLEPtr(SourceInfo);
bool emitLEFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitLE(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitLE(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitLESint8(I);
  case PT_Uint8:
    return emitLEUint8(I);
  case PT_Sint16:
    return emitLESint16(I);
  case PT_Uint16:
    return emitLEUint16(I);
  case PT_Sint32:
    return emitLESint32(I);
  case PT_Uint32:
    return emitLEUint32(I);
  case PT_Sint64:
    return emitLESint64(I);
  case PT_Uint64:
    return emitLEUint64(I);
  case PT_IntAP:
    return emitLEIntAP(I);
  case PT_IntAPS:
    return emitLEIntAPS(I);
  case PT_Bool:
    return emitLEBool(I);
  case PT_FixedPoint:
    return emitLEFixedPoint(I);
  case PT_Ptr:
    return emitLEPtr(I);
  case PT_Float:
    return emitLEFloat(I);
  default: llvm_unreachable("invalid type: emitLE");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitLESint8(SourceInfo L) {
  return emitOp<>(OP_LESint8, L);
}
bool ByteCodeEmitter::emitLEUint8(SourceInfo L) {
  return emitOp<>(OP_LEUint8, L);
}
bool ByteCodeEmitter::emitLESint16(SourceInfo L) {
  return emitOp<>(OP_LESint16, L);
}
bool ByteCodeEmitter::emitLEUint16(SourceInfo L) {
  return emitOp<>(OP_LEUint16, L);
}
bool ByteCodeEmitter::emitLESint32(SourceInfo L) {
  return emitOp<>(OP_LESint32, L);
}
bool ByteCodeEmitter::emitLEUint32(SourceInfo L) {
  return emitOp<>(OP_LEUint32, L);
}
bool ByteCodeEmitter::emitLESint64(SourceInfo L) {
  return emitOp<>(OP_LESint64, L);
}
bool ByteCodeEmitter::emitLEUint64(SourceInfo L) {
  return emitOp<>(OP_LEUint64, L);
}
bool ByteCodeEmitter::emitLEIntAP(SourceInfo L) {
  return emitOp<>(OP_LEIntAP, L);
}
bool ByteCodeEmitter::emitLEIntAPS(SourceInfo L) {
  return emitOp<>(OP_LEIntAPS, L);
}
bool ByteCodeEmitter::emitLEBool(SourceInfo L) {
  return emitOp<>(OP_LEBool, L);
}
bool ByteCodeEmitter::emitLEFixedPoint(SourceInfo L) {
  return emitOp<>(OP_LEFixedPoint, L);
}
bool ByteCodeEmitter::emitLEPtr(SourceInfo L) {
  return emitOp<>(OP_LEPtr, L);
}
bool ByteCodeEmitter::emitLEFloat(SourceInfo L) {
  return emitOp<>(OP_LEFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitLESint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitLEUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitLESint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitLEUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitLESint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitLEUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitLESint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitLEUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitLEIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitLEIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitLEBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitLEFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitLEPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitLEFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LE<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_LTSint8,
OP_LTUint8,
OP_LTSint16,
OP_LTUint16,
OP_LTSint32,
OP_LTUint32,
OP_LTSint64,
OP_LTUint64,
OP_LTIntAP,
OP_LTIntAPS,
OP_LTBool,
OP_LTFixedPoint,
OP_LTPtr,
OP_LTFloat,
#endif
#ifdef GET_INTERP
case OP_LTSint8: {
  if (!LT<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_LTUint8: {
  if (!LT<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_LTSint16: {
  if (!LT<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_LTUint16: {
  if (!LT<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_LTSint32: {
  if (!LT<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_LTUint32: {
  if (!LT<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_LTSint64: {
  if (!LT<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_LTUint64: {
  if (!LT<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_LTIntAP: {
  if (!LT<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_LTIntAPS: {
  if (!LT<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_LTBool: {
  if (!LT<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_LTFixedPoint: {
  if (!LT<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_LTPtr: {
  if (!LT<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_LTFloat: {
  if (!LT<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_LTSint8:
  Text.Op = PrintName("LTSint8");
  break;
case OP_LTUint8:
  Text.Op = PrintName("LTUint8");
  break;
case OP_LTSint16:
  Text.Op = PrintName("LTSint16");
  break;
case OP_LTUint16:
  Text.Op = PrintName("LTUint16");
  break;
case OP_LTSint32:
  Text.Op = PrintName("LTSint32");
  break;
case OP_LTUint32:
  Text.Op = PrintName("LTUint32");
  break;
case OP_LTSint64:
  Text.Op = PrintName("LTSint64");
  break;
case OP_LTUint64:
  Text.Op = PrintName("LTUint64");
  break;
case OP_LTIntAP:
  Text.Op = PrintName("LTIntAP");
  break;
case OP_LTIntAPS:
  Text.Op = PrintName("LTIntAPS");
  break;
case OP_LTBool:
  Text.Op = PrintName("LTBool");
  break;
case OP_LTFixedPoint:
  Text.Op = PrintName("LTFixedPoint");
  break;
case OP_LTPtr:
  Text.Op = PrintName("LTPtr");
  break;
case OP_LTFloat:
  Text.Op = PrintName("LTFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitLTSint8(SourceInfo);
bool emitLTUint8(SourceInfo);
bool emitLTSint16(SourceInfo);
bool emitLTUint16(SourceInfo);
bool emitLTSint32(SourceInfo);
bool emitLTUint32(SourceInfo);
bool emitLTSint64(SourceInfo);
bool emitLTUint64(SourceInfo);
bool emitLTIntAP(SourceInfo);
bool emitLTIntAPS(SourceInfo);
bool emitLTBool(SourceInfo);
bool emitLTFixedPoint(SourceInfo);
bool emitLTPtr(SourceInfo);
bool emitLTFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitLT(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitLT(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitLTSint8(I);
  case PT_Uint8:
    return emitLTUint8(I);
  case PT_Sint16:
    return emitLTSint16(I);
  case PT_Uint16:
    return emitLTUint16(I);
  case PT_Sint32:
    return emitLTSint32(I);
  case PT_Uint32:
    return emitLTUint32(I);
  case PT_Sint64:
    return emitLTSint64(I);
  case PT_Uint64:
    return emitLTUint64(I);
  case PT_IntAP:
    return emitLTIntAP(I);
  case PT_IntAPS:
    return emitLTIntAPS(I);
  case PT_Bool:
    return emitLTBool(I);
  case PT_FixedPoint:
    return emitLTFixedPoint(I);
  case PT_Ptr:
    return emitLTPtr(I);
  case PT_Float:
    return emitLTFloat(I);
  default: llvm_unreachable("invalid type: emitLT");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitLTSint8(SourceInfo L) {
  return emitOp<>(OP_LTSint8, L);
}
bool ByteCodeEmitter::emitLTUint8(SourceInfo L) {
  return emitOp<>(OP_LTUint8, L);
}
bool ByteCodeEmitter::emitLTSint16(SourceInfo L) {
  return emitOp<>(OP_LTSint16, L);
}
bool ByteCodeEmitter::emitLTUint16(SourceInfo L) {
  return emitOp<>(OP_LTUint16, L);
}
bool ByteCodeEmitter::emitLTSint32(SourceInfo L) {
  return emitOp<>(OP_LTSint32, L);
}
bool ByteCodeEmitter::emitLTUint32(SourceInfo L) {
  return emitOp<>(OP_LTUint32, L);
}
bool ByteCodeEmitter::emitLTSint64(SourceInfo L) {
  return emitOp<>(OP_LTSint64, L);
}
bool ByteCodeEmitter::emitLTUint64(SourceInfo L) {
  return emitOp<>(OP_LTUint64, L);
}
bool ByteCodeEmitter::emitLTIntAP(SourceInfo L) {
  return emitOp<>(OP_LTIntAP, L);
}
bool ByteCodeEmitter::emitLTIntAPS(SourceInfo L) {
  return emitOp<>(OP_LTIntAPS, L);
}
bool ByteCodeEmitter::emitLTBool(SourceInfo L) {
  return emitOp<>(OP_LTBool, L);
}
bool ByteCodeEmitter::emitLTFixedPoint(SourceInfo L) {
  return emitOp<>(OP_LTFixedPoint, L);
}
bool ByteCodeEmitter::emitLTPtr(SourceInfo L) {
  return emitOp<>(OP_LTPtr, L);
}
bool ByteCodeEmitter::emitLTFloat(SourceInfo L) {
  return emitOp<>(OP_LTFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitLTSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitLTUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitLTSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitLTUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitLTSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitLTUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitLTSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitLTUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitLTIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitLTIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitLTBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitLTFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitLTPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitLTFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LT<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_LoadSint8,
OP_LoadUint8,
OP_LoadSint16,
OP_LoadUint16,
OP_LoadSint32,
OP_LoadUint32,
OP_LoadSint64,
OP_LoadUint64,
OP_LoadIntAP,
OP_LoadIntAPS,
OP_LoadBool,
OP_LoadFixedPoint,
OP_LoadPtr,
OP_LoadMemberPtr,
OP_LoadFloat,
#endif
#ifdef GET_INTERP
case OP_LoadSint8: {
  if (!Load<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_LoadUint8: {
  if (!Load<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_LoadSint16: {
  if (!Load<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_LoadUint16: {
  if (!Load<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_LoadSint32: {
  if (!Load<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_LoadUint32: {
  if (!Load<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_LoadSint64: {
  if (!Load<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_LoadUint64: {
  if (!Load<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_LoadIntAP: {
  if (!Load<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_LoadIntAPS: {
  if (!Load<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_LoadBool: {
  if (!Load<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_LoadFixedPoint: {
  if (!Load<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPtr: {
  if (!Load<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_LoadMemberPtr: {
  if (!Load<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_LoadFloat: {
  if (!Load<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_LoadSint8:
  Text.Op = PrintName("LoadSint8");
  break;
case OP_LoadUint8:
  Text.Op = PrintName("LoadUint8");
  break;
case OP_LoadSint16:
  Text.Op = PrintName("LoadSint16");
  break;
case OP_LoadUint16:
  Text.Op = PrintName("LoadUint16");
  break;
case OP_LoadSint32:
  Text.Op = PrintName("LoadSint32");
  break;
case OP_LoadUint32:
  Text.Op = PrintName("LoadUint32");
  break;
case OP_LoadSint64:
  Text.Op = PrintName("LoadSint64");
  break;
case OP_LoadUint64:
  Text.Op = PrintName("LoadUint64");
  break;
case OP_LoadIntAP:
  Text.Op = PrintName("LoadIntAP");
  break;
case OP_LoadIntAPS:
  Text.Op = PrintName("LoadIntAPS");
  break;
case OP_LoadBool:
  Text.Op = PrintName("LoadBool");
  break;
case OP_LoadFixedPoint:
  Text.Op = PrintName("LoadFixedPoint");
  break;
case OP_LoadPtr:
  Text.Op = PrintName("LoadPtr");
  break;
case OP_LoadMemberPtr:
  Text.Op = PrintName("LoadMemberPtr");
  break;
case OP_LoadFloat:
  Text.Op = PrintName("LoadFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitLoadSint8(SourceInfo);
bool emitLoadUint8(SourceInfo);
bool emitLoadSint16(SourceInfo);
bool emitLoadUint16(SourceInfo);
bool emitLoadSint32(SourceInfo);
bool emitLoadUint32(SourceInfo);
bool emitLoadSint64(SourceInfo);
bool emitLoadUint64(SourceInfo);
bool emitLoadIntAP(SourceInfo);
bool emitLoadIntAPS(SourceInfo);
bool emitLoadBool(SourceInfo);
bool emitLoadFixedPoint(SourceInfo);
bool emitLoadPtr(SourceInfo);
bool emitLoadMemberPtr(SourceInfo);
bool emitLoadFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitLoad(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitLoad(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitLoadSint8(I);
  case PT_Uint8:
    return emitLoadUint8(I);
  case PT_Sint16:
    return emitLoadSint16(I);
  case PT_Uint16:
    return emitLoadUint16(I);
  case PT_Sint32:
    return emitLoadSint32(I);
  case PT_Uint32:
    return emitLoadUint32(I);
  case PT_Sint64:
    return emitLoadSint64(I);
  case PT_Uint64:
    return emitLoadUint64(I);
  case PT_IntAP:
    return emitLoadIntAP(I);
  case PT_IntAPS:
    return emitLoadIntAPS(I);
  case PT_Bool:
    return emitLoadBool(I);
  case PT_FixedPoint:
    return emitLoadFixedPoint(I);
  case PT_Ptr:
    return emitLoadPtr(I);
  case PT_MemberPtr:
    return emitLoadMemberPtr(I);
  case PT_Float:
    return emitLoadFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitLoadSint8(SourceInfo L) {
  return emitOp<>(OP_LoadSint8, L);
}
bool ByteCodeEmitter::emitLoadUint8(SourceInfo L) {
  return emitOp<>(OP_LoadUint8, L);
}
bool ByteCodeEmitter::emitLoadSint16(SourceInfo L) {
  return emitOp<>(OP_LoadSint16, L);
}
bool ByteCodeEmitter::emitLoadUint16(SourceInfo L) {
  return emitOp<>(OP_LoadUint16, L);
}
bool ByteCodeEmitter::emitLoadSint32(SourceInfo L) {
  return emitOp<>(OP_LoadSint32, L);
}
bool ByteCodeEmitter::emitLoadUint32(SourceInfo L) {
  return emitOp<>(OP_LoadUint32, L);
}
bool ByteCodeEmitter::emitLoadSint64(SourceInfo L) {
  return emitOp<>(OP_LoadSint64, L);
}
bool ByteCodeEmitter::emitLoadUint64(SourceInfo L) {
  return emitOp<>(OP_LoadUint64, L);
}
bool ByteCodeEmitter::emitLoadIntAP(SourceInfo L) {
  return emitOp<>(OP_LoadIntAP, L);
}
bool ByteCodeEmitter::emitLoadIntAPS(SourceInfo L) {
  return emitOp<>(OP_LoadIntAPS, L);
}
bool ByteCodeEmitter::emitLoadBool(SourceInfo L) {
  return emitOp<>(OP_LoadBool, L);
}
bool ByteCodeEmitter::emitLoadFixedPoint(SourceInfo L) {
  return emitOp<>(OP_LoadFixedPoint, L);
}
bool ByteCodeEmitter::emitLoadPtr(SourceInfo L) {
  return emitOp<>(OP_LoadPtr, L);
}
bool ByteCodeEmitter::emitLoadMemberPtr(SourceInfo L) {
  return emitOp<>(OP_LoadMemberPtr, L);
}
bool ByteCodeEmitter::emitLoadFloat(SourceInfo L) {
  return emitOp<>(OP_LoadFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitLoadSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitLoadUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitLoadSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitLoadUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitLoadSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitLoadUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitLoadSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitLoadUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitLoadIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitLoadIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitLoadBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitLoadFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitLoadPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitLoadMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitLoadFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Load<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_LoadPopSint8,
OP_LoadPopUint8,
OP_LoadPopSint16,
OP_LoadPopUint16,
OP_LoadPopSint32,
OP_LoadPopUint32,
OP_LoadPopSint64,
OP_LoadPopUint64,
OP_LoadPopIntAP,
OP_LoadPopIntAPS,
OP_LoadPopBool,
OP_LoadPopFixedPoint,
OP_LoadPopPtr,
OP_LoadPopMemberPtr,
OP_LoadPopFloat,
#endif
#ifdef GET_INTERP
case OP_LoadPopSint8: {
  if (!LoadPop<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopUint8: {
  if (!LoadPop<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopSint16: {
  if (!LoadPop<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopUint16: {
  if (!LoadPop<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopSint32: {
  if (!LoadPop<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopUint32: {
  if (!LoadPop<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopSint64: {
  if (!LoadPop<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopUint64: {
  if (!LoadPop<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopIntAP: {
  if (!LoadPop<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopIntAPS: {
  if (!LoadPop<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopBool: {
  if (!LoadPop<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopFixedPoint: {
  if (!LoadPop<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopPtr: {
  if (!LoadPop<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopMemberPtr: {
  if (!LoadPop<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_LoadPopFloat: {
  if (!LoadPop<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_LoadPopSint8:
  Text.Op = PrintName("LoadPopSint8");
  break;
case OP_LoadPopUint8:
  Text.Op = PrintName("LoadPopUint8");
  break;
case OP_LoadPopSint16:
  Text.Op = PrintName("LoadPopSint16");
  break;
case OP_LoadPopUint16:
  Text.Op = PrintName("LoadPopUint16");
  break;
case OP_LoadPopSint32:
  Text.Op = PrintName("LoadPopSint32");
  break;
case OP_LoadPopUint32:
  Text.Op = PrintName("LoadPopUint32");
  break;
case OP_LoadPopSint64:
  Text.Op = PrintName("LoadPopSint64");
  break;
case OP_LoadPopUint64:
  Text.Op = PrintName("LoadPopUint64");
  break;
case OP_LoadPopIntAP:
  Text.Op = PrintName("LoadPopIntAP");
  break;
case OP_LoadPopIntAPS:
  Text.Op = PrintName("LoadPopIntAPS");
  break;
case OP_LoadPopBool:
  Text.Op = PrintName("LoadPopBool");
  break;
case OP_LoadPopFixedPoint:
  Text.Op = PrintName("LoadPopFixedPoint");
  break;
case OP_LoadPopPtr:
  Text.Op = PrintName("LoadPopPtr");
  break;
case OP_LoadPopMemberPtr:
  Text.Op = PrintName("LoadPopMemberPtr");
  break;
case OP_LoadPopFloat:
  Text.Op = PrintName("LoadPopFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitLoadPopSint8(SourceInfo);
bool emitLoadPopUint8(SourceInfo);
bool emitLoadPopSint16(SourceInfo);
bool emitLoadPopUint16(SourceInfo);
bool emitLoadPopSint32(SourceInfo);
bool emitLoadPopUint32(SourceInfo);
bool emitLoadPopSint64(SourceInfo);
bool emitLoadPopUint64(SourceInfo);
bool emitLoadPopIntAP(SourceInfo);
bool emitLoadPopIntAPS(SourceInfo);
bool emitLoadPopBool(SourceInfo);
bool emitLoadPopFixedPoint(SourceInfo);
bool emitLoadPopPtr(SourceInfo);
bool emitLoadPopMemberPtr(SourceInfo);
bool emitLoadPopFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitLoadPop(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitLoadPop(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitLoadPopSint8(I);
  case PT_Uint8:
    return emitLoadPopUint8(I);
  case PT_Sint16:
    return emitLoadPopSint16(I);
  case PT_Uint16:
    return emitLoadPopUint16(I);
  case PT_Sint32:
    return emitLoadPopSint32(I);
  case PT_Uint32:
    return emitLoadPopUint32(I);
  case PT_Sint64:
    return emitLoadPopSint64(I);
  case PT_Uint64:
    return emitLoadPopUint64(I);
  case PT_IntAP:
    return emitLoadPopIntAP(I);
  case PT_IntAPS:
    return emitLoadPopIntAPS(I);
  case PT_Bool:
    return emitLoadPopBool(I);
  case PT_FixedPoint:
    return emitLoadPopFixedPoint(I);
  case PT_Ptr:
    return emitLoadPopPtr(I);
  case PT_MemberPtr:
    return emitLoadPopMemberPtr(I);
  case PT_Float:
    return emitLoadPopFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitLoadPopSint8(SourceInfo L) {
  return emitOp<>(OP_LoadPopSint8, L);
}
bool ByteCodeEmitter::emitLoadPopUint8(SourceInfo L) {
  return emitOp<>(OP_LoadPopUint8, L);
}
bool ByteCodeEmitter::emitLoadPopSint16(SourceInfo L) {
  return emitOp<>(OP_LoadPopSint16, L);
}
bool ByteCodeEmitter::emitLoadPopUint16(SourceInfo L) {
  return emitOp<>(OP_LoadPopUint16, L);
}
bool ByteCodeEmitter::emitLoadPopSint32(SourceInfo L) {
  return emitOp<>(OP_LoadPopSint32, L);
}
bool ByteCodeEmitter::emitLoadPopUint32(SourceInfo L) {
  return emitOp<>(OP_LoadPopUint32, L);
}
bool ByteCodeEmitter::emitLoadPopSint64(SourceInfo L) {
  return emitOp<>(OP_LoadPopSint64, L);
}
bool ByteCodeEmitter::emitLoadPopUint64(SourceInfo L) {
  return emitOp<>(OP_LoadPopUint64, L);
}
bool ByteCodeEmitter::emitLoadPopIntAP(SourceInfo L) {
  return emitOp<>(OP_LoadPopIntAP, L);
}
bool ByteCodeEmitter::emitLoadPopIntAPS(SourceInfo L) {
  return emitOp<>(OP_LoadPopIntAPS, L);
}
bool ByteCodeEmitter::emitLoadPopBool(SourceInfo L) {
  return emitOp<>(OP_LoadPopBool, L);
}
bool ByteCodeEmitter::emitLoadPopFixedPoint(SourceInfo L) {
  return emitOp<>(OP_LoadPopFixedPoint, L);
}
bool ByteCodeEmitter::emitLoadPopPtr(SourceInfo L) {
  return emitOp<>(OP_LoadPopPtr, L);
}
bool ByteCodeEmitter::emitLoadPopMemberPtr(SourceInfo L) {
  return emitOp<>(OP_LoadPopMemberPtr, L);
}
bool ByteCodeEmitter::emitLoadPopFloat(SourceInfo L) {
  return emitOp<>(OP_LoadPopFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitLoadPopSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitLoadPopUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitLoadPopSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitLoadPopUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitLoadPopSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitLoadPopUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitLoadPopSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitLoadPopUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitLoadPopIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitLoadPopIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitLoadPopBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitLoadPopFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitLoadPopPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitLoadPopMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitLoadPopFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return LoadPop<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Memcpy,
#endif
#ifdef GET_INTERP
case OP_Memcpy: {
  if (!Memcpy(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Memcpy:
  Text.Op = PrintName("Memcpy");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitMemcpy(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitMemcpy(SourceInfo L) {
  return emitOp<>(OP_Memcpy, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitMemcpy(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Memcpy(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_MulSint8,
OP_MulUint8,
OP_MulSint16,
OP_MulUint16,
OP_MulSint32,
OP_MulUint32,
OP_MulSint64,
OP_MulUint64,
OP_MulIntAP,
OP_MulIntAPS,
OP_MulBool,
OP_MulFixedPoint,
#endif
#ifdef GET_INTERP
case OP_MulSint8: {
  if (!Mul<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_MulUint8: {
  if (!Mul<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_MulSint16: {
  if (!Mul<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_MulUint16: {
  if (!Mul<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_MulSint32: {
  if (!Mul<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_MulUint32: {
  if (!Mul<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_MulSint64: {
  if (!Mul<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_MulUint64: {
  if (!Mul<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_MulIntAP: {
  if (!Mul<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_MulIntAPS: {
  if (!Mul<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_MulBool: {
  if (!Mul<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_MulFixedPoint: {
  if (!Mul<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_MulSint8:
  Text.Op = PrintName("MulSint8");
  break;
case OP_MulUint8:
  Text.Op = PrintName("MulUint8");
  break;
case OP_MulSint16:
  Text.Op = PrintName("MulSint16");
  break;
case OP_MulUint16:
  Text.Op = PrintName("MulUint16");
  break;
case OP_MulSint32:
  Text.Op = PrintName("MulSint32");
  break;
case OP_MulUint32:
  Text.Op = PrintName("MulUint32");
  break;
case OP_MulSint64:
  Text.Op = PrintName("MulSint64");
  break;
case OP_MulUint64:
  Text.Op = PrintName("MulUint64");
  break;
case OP_MulIntAP:
  Text.Op = PrintName("MulIntAP");
  break;
case OP_MulIntAPS:
  Text.Op = PrintName("MulIntAPS");
  break;
case OP_MulBool:
  Text.Op = PrintName("MulBool");
  break;
case OP_MulFixedPoint:
  Text.Op = PrintName("MulFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitMulSint8(SourceInfo);
bool emitMulUint8(SourceInfo);
bool emitMulSint16(SourceInfo);
bool emitMulUint16(SourceInfo);
bool emitMulSint32(SourceInfo);
bool emitMulUint32(SourceInfo);
bool emitMulSint64(SourceInfo);
bool emitMulUint64(SourceInfo);
bool emitMulIntAP(SourceInfo);
bool emitMulIntAPS(SourceInfo);
bool emitMulBool(SourceInfo);
bool emitMulFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitMul(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitMul(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitMulSint8(I);
  case PT_Uint8:
    return emitMulUint8(I);
  case PT_Sint16:
    return emitMulSint16(I);
  case PT_Uint16:
    return emitMulUint16(I);
  case PT_Sint32:
    return emitMulSint32(I);
  case PT_Uint32:
    return emitMulUint32(I);
  case PT_Sint64:
    return emitMulSint64(I);
  case PT_Uint64:
    return emitMulUint64(I);
  case PT_IntAP:
    return emitMulIntAP(I);
  case PT_IntAPS:
    return emitMulIntAPS(I);
  case PT_Bool:
    return emitMulBool(I);
  case PT_FixedPoint:
    return emitMulFixedPoint(I);
  default: llvm_unreachable("invalid type: emitMul");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitMulSint8(SourceInfo L) {
  return emitOp<>(OP_MulSint8, L);
}
bool ByteCodeEmitter::emitMulUint8(SourceInfo L) {
  return emitOp<>(OP_MulUint8, L);
}
bool ByteCodeEmitter::emitMulSint16(SourceInfo L) {
  return emitOp<>(OP_MulSint16, L);
}
bool ByteCodeEmitter::emitMulUint16(SourceInfo L) {
  return emitOp<>(OP_MulUint16, L);
}
bool ByteCodeEmitter::emitMulSint32(SourceInfo L) {
  return emitOp<>(OP_MulSint32, L);
}
bool ByteCodeEmitter::emitMulUint32(SourceInfo L) {
  return emitOp<>(OP_MulUint32, L);
}
bool ByteCodeEmitter::emitMulSint64(SourceInfo L) {
  return emitOp<>(OP_MulSint64, L);
}
bool ByteCodeEmitter::emitMulUint64(SourceInfo L) {
  return emitOp<>(OP_MulUint64, L);
}
bool ByteCodeEmitter::emitMulIntAP(SourceInfo L) {
  return emitOp<>(OP_MulIntAP, L);
}
bool ByteCodeEmitter::emitMulIntAPS(SourceInfo L) {
  return emitOp<>(OP_MulIntAPS, L);
}
bool ByteCodeEmitter::emitMulBool(SourceInfo L) {
  return emitOp<>(OP_MulBool, L);
}
bool ByteCodeEmitter::emitMulFixedPoint(SourceInfo L) {
  return emitOp<>(OP_MulFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitMulSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitMulUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitMulSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitMulUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitMulSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitMulUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitMulSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitMulUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitMulIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitMulIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitMulBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitMulFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mul<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_MulcSint8,
OP_MulcUint8,
OP_MulcSint16,
OP_MulcUint16,
OP_MulcSint32,
OP_MulcUint32,
OP_MulcSint64,
OP_MulcUint64,
OP_MulcIntAP,
OP_MulcIntAPS,
OP_MulcFloat,
#endif
#ifdef GET_INTERP
case OP_MulcSint8: {
  if (!Mulc<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_MulcUint8: {
  if (!Mulc<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_MulcSint16: {
  if (!Mulc<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_MulcUint16: {
  if (!Mulc<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_MulcSint32: {
  if (!Mulc<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_MulcUint32: {
  if (!Mulc<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_MulcSint64: {
  if (!Mulc<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_MulcUint64: {
  if (!Mulc<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_MulcIntAP: {
  if (!Mulc<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_MulcIntAPS: {
  if (!Mulc<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_MulcFloat: {
  if (!Mulc<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_MulcSint8:
  Text.Op = PrintName("MulcSint8");
  break;
case OP_MulcUint8:
  Text.Op = PrintName("MulcUint8");
  break;
case OP_MulcSint16:
  Text.Op = PrintName("MulcSint16");
  break;
case OP_MulcUint16:
  Text.Op = PrintName("MulcUint16");
  break;
case OP_MulcSint32:
  Text.Op = PrintName("MulcSint32");
  break;
case OP_MulcUint32:
  Text.Op = PrintName("MulcUint32");
  break;
case OP_MulcSint64:
  Text.Op = PrintName("MulcSint64");
  break;
case OP_MulcUint64:
  Text.Op = PrintName("MulcUint64");
  break;
case OP_MulcIntAP:
  Text.Op = PrintName("MulcIntAP");
  break;
case OP_MulcIntAPS:
  Text.Op = PrintName("MulcIntAPS");
  break;
case OP_MulcFloat:
  Text.Op = PrintName("MulcFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitMulcSint8(SourceInfo);
bool emitMulcUint8(SourceInfo);
bool emitMulcSint16(SourceInfo);
bool emitMulcUint16(SourceInfo);
bool emitMulcSint32(SourceInfo);
bool emitMulcUint32(SourceInfo);
bool emitMulcSint64(SourceInfo);
bool emitMulcUint64(SourceInfo);
bool emitMulcIntAP(SourceInfo);
bool emitMulcIntAPS(SourceInfo);
bool emitMulcFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitMulc(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitMulc(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitMulcSint8(I);
  case PT_Uint8:
    return emitMulcUint8(I);
  case PT_Sint16:
    return emitMulcSint16(I);
  case PT_Uint16:
    return emitMulcUint16(I);
  case PT_Sint32:
    return emitMulcSint32(I);
  case PT_Uint32:
    return emitMulcUint32(I);
  case PT_Sint64:
    return emitMulcSint64(I);
  case PT_Uint64:
    return emitMulcUint64(I);
  case PT_IntAP:
    return emitMulcIntAP(I);
  case PT_IntAPS:
    return emitMulcIntAPS(I);
  case PT_Float:
    return emitMulcFloat(I);
  default: llvm_unreachable("invalid type: emitMulc");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitMulcSint8(SourceInfo L) {
  return emitOp<>(OP_MulcSint8, L);
}
bool ByteCodeEmitter::emitMulcUint8(SourceInfo L) {
  return emitOp<>(OP_MulcUint8, L);
}
bool ByteCodeEmitter::emitMulcSint16(SourceInfo L) {
  return emitOp<>(OP_MulcSint16, L);
}
bool ByteCodeEmitter::emitMulcUint16(SourceInfo L) {
  return emitOp<>(OP_MulcUint16, L);
}
bool ByteCodeEmitter::emitMulcSint32(SourceInfo L) {
  return emitOp<>(OP_MulcSint32, L);
}
bool ByteCodeEmitter::emitMulcUint32(SourceInfo L) {
  return emitOp<>(OP_MulcUint32, L);
}
bool ByteCodeEmitter::emitMulcSint64(SourceInfo L) {
  return emitOp<>(OP_MulcSint64, L);
}
bool ByteCodeEmitter::emitMulcUint64(SourceInfo L) {
  return emitOp<>(OP_MulcUint64, L);
}
bool ByteCodeEmitter::emitMulcIntAP(SourceInfo L) {
  return emitOp<>(OP_MulcIntAP, L);
}
bool ByteCodeEmitter::emitMulcIntAPS(SourceInfo L) {
  return emitOp<>(OP_MulcIntAPS, L);
}
bool ByteCodeEmitter::emitMulcFloat(SourceInfo L) {
  return emitOp<>(OP_MulcFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitMulcSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitMulcUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitMulcSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitMulcUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitMulcSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitMulcUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitMulcSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitMulcUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitMulcIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitMulcIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitMulcFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulc<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_Mulf,
#endif
#ifdef GET_INTERP
case OP_Mulf: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!Mulf(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_Mulf:
  Text.Op = PrintName("Mulf");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitMulf( uint32_t , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitMulf( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_Mulf, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitMulf( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Mulf(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_NESint8,
OP_NEUint8,
OP_NESint16,
OP_NEUint16,
OP_NESint32,
OP_NEUint32,
OP_NESint64,
OP_NEUint64,
OP_NEIntAP,
OP_NEIntAPS,
OP_NEBool,
OP_NEFixedPoint,
OP_NEPtr,
OP_NEMemberPtr,
OP_NEFloat,
#endif
#ifdef GET_INTERP
case OP_NESint8: {
  if (!NE<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_NEUint8: {
  if (!NE<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_NESint16: {
  if (!NE<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_NEUint16: {
  if (!NE<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_NESint32: {
  if (!NE<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_NEUint32: {
  if (!NE<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_NESint64: {
  if (!NE<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_NEUint64: {
  if (!NE<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_NEIntAP: {
  if (!NE<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_NEIntAPS: {
  if (!NE<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_NEBool: {
  if (!NE<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_NEFixedPoint: {
  if (!NE<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_NEPtr: {
  if (!NE<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_NEMemberPtr: {
  if (!NE<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_NEFloat: {
  if (!NE<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_NESint8:
  Text.Op = PrintName("NESint8");
  break;
case OP_NEUint8:
  Text.Op = PrintName("NEUint8");
  break;
case OP_NESint16:
  Text.Op = PrintName("NESint16");
  break;
case OP_NEUint16:
  Text.Op = PrintName("NEUint16");
  break;
case OP_NESint32:
  Text.Op = PrintName("NESint32");
  break;
case OP_NEUint32:
  Text.Op = PrintName("NEUint32");
  break;
case OP_NESint64:
  Text.Op = PrintName("NESint64");
  break;
case OP_NEUint64:
  Text.Op = PrintName("NEUint64");
  break;
case OP_NEIntAP:
  Text.Op = PrintName("NEIntAP");
  break;
case OP_NEIntAPS:
  Text.Op = PrintName("NEIntAPS");
  break;
case OP_NEBool:
  Text.Op = PrintName("NEBool");
  break;
case OP_NEFixedPoint:
  Text.Op = PrintName("NEFixedPoint");
  break;
case OP_NEPtr:
  Text.Op = PrintName("NEPtr");
  break;
case OP_NEMemberPtr:
  Text.Op = PrintName("NEMemberPtr");
  break;
case OP_NEFloat:
  Text.Op = PrintName("NEFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitNESint8(SourceInfo);
bool emitNEUint8(SourceInfo);
bool emitNESint16(SourceInfo);
bool emitNEUint16(SourceInfo);
bool emitNESint32(SourceInfo);
bool emitNEUint32(SourceInfo);
bool emitNESint64(SourceInfo);
bool emitNEUint64(SourceInfo);
bool emitNEIntAP(SourceInfo);
bool emitNEIntAPS(SourceInfo);
bool emitNEBool(SourceInfo);
bool emitNEFixedPoint(SourceInfo);
bool emitNEPtr(SourceInfo);
bool emitNEMemberPtr(SourceInfo);
bool emitNEFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitNE(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitNE(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitNESint8(I);
  case PT_Uint8:
    return emitNEUint8(I);
  case PT_Sint16:
    return emitNESint16(I);
  case PT_Uint16:
    return emitNEUint16(I);
  case PT_Sint32:
    return emitNESint32(I);
  case PT_Uint32:
    return emitNEUint32(I);
  case PT_Sint64:
    return emitNESint64(I);
  case PT_Uint64:
    return emitNEUint64(I);
  case PT_IntAP:
    return emitNEIntAP(I);
  case PT_IntAPS:
    return emitNEIntAPS(I);
  case PT_Bool:
    return emitNEBool(I);
  case PT_FixedPoint:
    return emitNEFixedPoint(I);
  case PT_Ptr:
    return emitNEPtr(I);
  case PT_MemberPtr:
    return emitNEMemberPtr(I);
  case PT_Float:
    return emitNEFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitNESint8(SourceInfo L) {
  return emitOp<>(OP_NESint8, L);
}
bool ByteCodeEmitter::emitNEUint8(SourceInfo L) {
  return emitOp<>(OP_NEUint8, L);
}
bool ByteCodeEmitter::emitNESint16(SourceInfo L) {
  return emitOp<>(OP_NESint16, L);
}
bool ByteCodeEmitter::emitNEUint16(SourceInfo L) {
  return emitOp<>(OP_NEUint16, L);
}
bool ByteCodeEmitter::emitNESint32(SourceInfo L) {
  return emitOp<>(OP_NESint32, L);
}
bool ByteCodeEmitter::emitNEUint32(SourceInfo L) {
  return emitOp<>(OP_NEUint32, L);
}
bool ByteCodeEmitter::emitNESint64(SourceInfo L) {
  return emitOp<>(OP_NESint64, L);
}
bool ByteCodeEmitter::emitNEUint64(SourceInfo L) {
  return emitOp<>(OP_NEUint64, L);
}
bool ByteCodeEmitter::emitNEIntAP(SourceInfo L) {
  return emitOp<>(OP_NEIntAP, L);
}
bool ByteCodeEmitter::emitNEIntAPS(SourceInfo L) {
  return emitOp<>(OP_NEIntAPS, L);
}
bool ByteCodeEmitter::emitNEBool(SourceInfo L) {
  return emitOp<>(OP_NEBool, L);
}
bool ByteCodeEmitter::emitNEFixedPoint(SourceInfo L) {
  return emitOp<>(OP_NEFixedPoint, L);
}
bool ByteCodeEmitter::emitNEPtr(SourceInfo L) {
  return emitOp<>(OP_NEPtr, L);
}
bool ByteCodeEmitter::emitNEMemberPtr(SourceInfo L) {
  return emitOp<>(OP_NEMemberPtr, L);
}
bool ByteCodeEmitter::emitNEFloat(SourceInfo L) {
  return emitOp<>(OP_NEFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitNESint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitNEUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitNESint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitNEUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitNESint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitNEUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitNESint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitNEUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitNEIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitNEIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitNEBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitNEFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitNEPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitNEMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitNEFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NE<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_NarrowPtr,
#endif
#ifdef GET_INTERP
case OP_NarrowPtr: {
  if (!NarrowPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_NarrowPtr:
  Text.Op = PrintName("NarrowPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitNarrowPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitNarrowPtr(SourceInfo L) {
  return emitOp<>(OP_NarrowPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitNarrowPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NarrowPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_NegSint8,
OP_NegUint8,
OP_NegSint16,
OP_NegUint16,
OP_NegSint32,
OP_NegUint32,
OP_NegSint64,
OP_NegUint64,
OP_NegIntAP,
OP_NegIntAPS,
OP_NegBool,
OP_NegFloat,
OP_NegFixedPoint,
#endif
#ifdef GET_INTERP
case OP_NegSint8: {
  if (!Neg<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_NegUint8: {
  if (!Neg<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_NegSint16: {
  if (!Neg<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_NegUint16: {
  if (!Neg<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_NegSint32: {
  if (!Neg<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_NegUint32: {
  if (!Neg<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_NegSint64: {
  if (!Neg<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_NegUint64: {
  if (!Neg<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_NegIntAP: {
  if (!Neg<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_NegIntAPS: {
  if (!Neg<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_NegBool: {
  if (!Neg<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_NegFloat: {
  if (!Neg<PT_Float>(S, OpPC))
    return false;
  continue;
}
case OP_NegFixedPoint: {
  if (!Neg<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_NegSint8:
  Text.Op = PrintName("NegSint8");
  break;
case OP_NegUint8:
  Text.Op = PrintName("NegUint8");
  break;
case OP_NegSint16:
  Text.Op = PrintName("NegSint16");
  break;
case OP_NegUint16:
  Text.Op = PrintName("NegUint16");
  break;
case OP_NegSint32:
  Text.Op = PrintName("NegSint32");
  break;
case OP_NegUint32:
  Text.Op = PrintName("NegUint32");
  break;
case OP_NegSint64:
  Text.Op = PrintName("NegSint64");
  break;
case OP_NegUint64:
  Text.Op = PrintName("NegUint64");
  break;
case OP_NegIntAP:
  Text.Op = PrintName("NegIntAP");
  break;
case OP_NegIntAPS:
  Text.Op = PrintName("NegIntAPS");
  break;
case OP_NegBool:
  Text.Op = PrintName("NegBool");
  break;
case OP_NegFloat:
  Text.Op = PrintName("NegFloat");
  break;
case OP_NegFixedPoint:
  Text.Op = PrintName("NegFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitNegSint8(SourceInfo);
bool emitNegUint8(SourceInfo);
bool emitNegSint16(SourceInfo);
bool emitNegUint16(SourceInfo);
bool emitNegSint32(SourceInfo);
bool emitNegUint32(SourceInfo);
bool emitNegSint64(SourceInfo);
bool emitNegUint64(SourceInfo);
bool emitNegIntAP(SourceInfo);
bool emitNegIntAPS(SourceInfo);
bool emitNegBool(SourceInfo);
bool emitNegFloat(SourceInfo);
bool emitNegFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitNeg(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitNeg(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitNegSint8(I);
  case PT_Uint8:
    return emitNegUint8(I);
  case PT_Sint16:
    return emitNegSint16(I);
  case PT_Uint16:
    return emitNegUint16(I);
  case PT_Sint32:
    return emitNegSint32(I);
  case PT_Uint32:
    return emitNegUint32(I);
  case PT_Sint64:
    return emitNegSint64(I);
  case PT_Uint64:
    return emitNegUint64(I);
  case PT_IntAP:
    return emitNegIntAP(I);
  case PT_IntAPS:
    return emitNegIntAPS(I);
  case PT_Bool:
    return emitNegBool(I);
  case PT_Float:
    return emitNegFloat(I);
  case PT_FixedPoint:
    return emitNegFixedPoint(I);
  default: llvm_unreachable("invalid type: emitNeg");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitNegSint8(SourceInfo L) {
  return emitOp<>(OP_NegSint8, L);
}
bool ByteCodeEmitter::emitNegUint8(SourceInfo L) {
  return emitOp<>(OP_NegUint8, L);
}
bool ByteCodeEmitter::emitNegSint16(SourceInfo L) {
  return emitOp<>(OP_NegSint16, L);
}
bool ByteCodeEmitter::emitNegUint16(SourceInfo L) {
  return emitOp<>(OP_NegUint16, L);
}
bool ByteCodeEmitter::emitNegSint32(SourceInfo L) {
  return emitOp<>(OP_NegSint32, L);
}
bool ByteCodeEmitter::emitNegUint32(SourceInfo L) {
  return emitOp<>(OP_NegUint32, L);
}
bool ByteCodeEmitter::emitNegSint64(SourceInfo L) {
  return emitOp<>(OP_NegSint64, L);
}
bool ByteCodeEmitter::emitNegUint64(SourceInfo L) {
  return emitOp<>(OP_NegUint64, L);
}
bool ByteCodeEmitter::emitNegIntAP(SourceInfo L) {
  return emitOp<>(OP_NegIntAP, L);
}
bool ByteCodeEmitter::emitNegIntAPS(SourceInfo L) {
  return emitOp<>(OP_NegIntAPS, L);
}
bool ByteCodeEmitter::emitNegBool(SourceInfo L) {
  return emitOp<>(OP_NegBool, L);
}
bool ByteCodeEmitter::emitNegFloat(SourceInfo L) {
  return emitOp<>(OP_NegFloat, L);
}
bool ByteCodeEmitter::emitNegFixedPoint(SourceInfo L) {
  return emitOp<>(OP_NegFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitNegSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitNegUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitNegSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitNegUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitNegSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitNegUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitNegSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitNegUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitNegIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitNegIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitNegBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitNegFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_Float>(S, OpPC);
}
bool EvalEmitter::emitNegFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Neg<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_NoRet,
#endif
#ifdef GET_INTERP
case OP_NoRet: {
  if (!NoRet(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_NoRet:
  Text.Op = PrintName("NoRet");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitNoRet(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitNoRet(SourceInfo L) {
  return emitOp<>(OP_NoRet, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitNoRet(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return NoRet(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_NullPtr,
OP_NullMemberPtr,
#endif
#ifdef GET_INTERP
case OP_NullPtr: {
  const auto V0 = ReadArg<uint64_t>(S, PC);
  const auto V1 = ReadArg<const Descriptor *>(S, PC);
  if (!Null<PT_Ptr>(S, OpPC, V0, V1))
    return false;
  continue;
}
case OP_NullMemberPtr: {
  const auto V0 = ReadArg<uint64_t>(S, PC);
  const auto V1 = ReadArg<const Descriptor *>(S, PC);
  if (!Null<PT_MemberPtr>(S, OpPC, V0, V1))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_NullPtr:
  Text.Op = PrintName("NullPtr");
  Text.Args.push_back(printArg<uint64_t>(P, PC));
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
case OP_NullMemberPtr:
  Text.Op = PrintName("NullMemberPtr");
  Text.Args.push_back(printArg<uint64_t>(P, PC));
  Text.Args.push_back(printArg<const Descriptor *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitNullPtr( uint64_t ,  const Descriptor * , SourceInfo);
bool emitNullMemberPtr( uint64_t ,  const Descriptor * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitNull(PrimType, uint64_t, const Descriptor *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitNull(PrimType T0,  uint64_t A0,  const Descriptor * A1, SourceInfo I) {
  switch (T0) {
  case PT_Ptr:
    return emitNullPtr(A0, A1, I);
  case PT_MemberPtr:
    return emitNullMemberPtr(A0, A1, I);
  default: llvm_unreachable("invalid type: emitNull");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitNullPtr( uint64_t A0,  const Descriptor * A1, SourceInfo L) {
  return emitOp<uint64_t, const Descriptor *>(OP_NullPtr, A0, A1, L);
}
bool ByteCodeEmitter::emitNullMemberPtr( uint64_t A0,  const Descriptor * A1, SourceInfo L) {
  return emitOp<uint64_t, const Descriptor *>(OP_NullMemberPtr, A0, A1, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitNullPtr( uint64_t A0,  const Descriptor * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Null<PT_Ptr>(S, OpPC, A0, A1);
}
bool EvalEmitter::emitNullMemberPtr( uint64_t A0,  const Descriptor * A1, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Null<PT_MemberPtr>(S, OpPC, A0, A1);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_OffsetOfSint8,
OP_OffsetOfUint8,
OP_OffsetOfSint16,
OP_OffsetOfUint16,
OP_OffsetOfSint32,
OP_OffsetOfUint32,
OP_OffsetOfSint64,
OP_OffsetOfUint64,
OP_OffsetOfIntAP,
OP_OffsetOfIntAPS,
#endif
#ifdef GET_INTERP
case OP_OffsetOfSint8: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfUint8: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfSint16: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfUint16: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfSint32: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfUint32: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfSint64: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfUint64: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfIntAP: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_OffsetOfIntAPS: {
  const auto V0 = ReadArg<const OffsetOfExpr *>(S, PC);
  if (!OffsetOf<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_OffsetOfSint8:
  Text.Op = PrintName("OffsetOfSint8");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfUint8:
  Text.Op = PrintName("OffsetOfUint8");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfSint16:
  Text.Op = PrintName("OffsetOfSint16");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfUint16:
  Text.Op = PrintName("OffsetOfUint16");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfSint32:
  Text.Op = PrintName("OffsetOfSint32");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfUint32:
  Text.Op = PrintName("OffsetOfUint32");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfSint64:
  Text.Op = PrintName("OffsetOfSint64");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfUint64:
  Text.Op = PrintName("OffsetOfUint64");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfIntAP:
  Text.Op = PrintName("OffsetOfIntAP");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
case OP_OffsetOfIntAPS:
  Text.Op = PrintName("OffsetOfIntAPS");
  Text.Args.push_back(printArg<const OffsetOfExpr *>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitOffsetOfSint8( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfUint8( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfSint16( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfUint16( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfSint32( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfUint32( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfSint64( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfUint64( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfIntAP( const OffsetOfExpr * , SourceInfo);
bool emitOffsetOfIntAPS( const OffsetOfExpr * , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitOffsetOf(PrimType, const OffsetOfExpr *, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitOffsetOf(PrimType T0,  const OffsetOfExpr * A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitOffsetOfSint8(A0, I);
  case PT_Uint8:
    return emitOffsetOfUint8(A0, I);
  case PT_Sint16:
    return emitOffsetOfSint16(A0, I);
  case PT_Uint16:
    return emitOffsetOfUint16(A0, I);
  case PT_Sint32:
    return emitOffsetOfSint32(A0, I);
  case PT_Uint32:
    return emitOffsetOfUint32(A0, I);
  case PT_Sint64:
    return emitOffsetOfSint64(A0, I);
  case PT_Uint64:
    return emitOffsetOfUint64(A0, I);
  case PT_IntAP:
    return emitOffsetOfIntAP(A0, I);
  case PT_IntAPS:
    return emitOffsetOfIntAPS(A0, I);
  default: llvm_unreachable("invalid type: emitOffsetOf");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitOffsetOfSint8( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfSint8, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfUint8( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfUint8, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfSint16( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfSint16, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfUint16( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfUint16, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfSint32( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfSint32, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfUint32( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfUint32, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfSint64( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfSint64, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfUint64( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfUint64, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfIntAP( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfIntAP, A0, L);
}
bool ByteCodeEmitter::emitOffsetOfIntAPS( const OffsetOfExpr * A0, SourceInfo L) {
  return emitOp<const OffsetOfExpr *>(OP_OffsetOfIntAPS, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitOffsetOfSint8( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfUint8( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfSint16( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfUint16( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfSint32( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfUint32( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfSint64( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfUint64( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfIntAP( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitOffsetOfIntAPS( const OffsetOfExpr * A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return OffsetOf<PT_IntAPS>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PopSint8,
OP_PopUint8,
OP_PopSint16,
OP_PopUint16,
OP_PopSint32,
OP_PopUint32,
OP_PopSint64,
OP_PopUint64,
OP_PopIntAP,
OP_PopIntAPS,
OP_PopBool,
OP_PopFixedPoint,
OP_PopPtr,
OP_PopMemberPtr,
OP_PopFloat,
#endif
#ifdef GET_INTERP
case OP_PopSint8: {
  if (!Pop<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_PopUint8: {
  if (!Pop<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_PopSint16: {
  if (!Pop<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_PopUint16: {
  if (!Pop<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_PopSint32: {
  if (!Pop<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_PopUint32: {
  if (!Pop<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_PopSint64: {
  if (!Pop<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_PopUint64: {
  if (!Pop<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_PopIntAP: {
  if (!Pop<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_PopIntAPS: {
  if (!Pop<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_PopBool: {
  if (!Pop<PT_Bool>(S, OpPC))
    return false;
  continue;
}
case OP_PopFixedPoint: {
  if (!Pop<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
case OP_PopPtr: {
  if (!Pop<PT_Ptr>(S, OpPC))
    return false;
  continue;
}
case OP_PopMemberPtr: {
  if (!Pop<PT_MemberPtr>(S, OpPC))
    return false;
  continue;
}
case OP_PopFloat: {
  if (!Pop<PT_Float>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PopSint8:
  Text.Op = PrintName("PopSint8");
  break;
case OP_PopUint8:
  Text.Op = PrintName("PopUint8");
  break;
case OP_PopSint16:
  Text.Op = PrintName("PopSint16");
  break;
case OP_PopUint16:
  Text.Op = PrintName("PopUint16");
  break;
case OP_PopSint32:
  Text.Op = PrintName("PopSint32");
  break;
case OP_PopUint32:
  Text.Op = PrintName("PopUint32");
  break;
case OP_PopSint64:
  Text.Op = PrintName("PopSint64");
  break;
case OP_PopUint64:
  Text.Op = PrintName("PopUint64");
  break;
case OP_PopIntAP:
  Text.Op = PrintName("PopIntAP");
  break;
case OP_PopIntAPS:
  Text.Op = PrintName("PopIntAPS");
  break;
case OP_PopBool:
  Text.Op = PrintName("PopBool");
  break;
case OP_PopFixedPoint:
  Text.Op = PrintName("PopFixedPoint");
  break;
case OP_PopPtr:
  Text.Op = PrintName("PopPtr");
  break;
case OP_PopMemberPtr:
  Text.Op = PrintName("PopMemberPtr");
  break;
case OP_PopFloat:
  Text.Op = PrintName("PopFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPopSint8(SourceInfo);
bool emitPopUint8(SourceInfo);
bool emitPopSint16(SourceInfo);
bool emitPopUint16(SourceInfo);
bool emitPopSint32(SourceInfo);
bool emitPopUint32(SourceInfo);
bool emitPopSint64(SourceInfo);
bool emitPopUint64(SourceInfo);
bool emitPopIntAP(SourceInfo);
bool emitPopIntAPS(SourceInfo);
bool emitPopBool(SourceInfo);
bool emitPopFixedPoint(SourceInfo);
bool emitPopPtr(SourceInfo);
bool emitPopMemberPtr(SourceInfo);
bool emitPopFloat(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitPop(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitPop(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitPopSint8(I);
  case PT_Uint8:
    return emitPopUint8(I);
  case PT_Sint16:
    return emitPopSint16(I);
  case PT_Uint16:
    return emitPopUint16(I);
  case PT_Sint32:
    return emitPopSint32(I);
  case PT_Uint32:
    return emitPopUint32(I);
  case PT_Sint64:
    return emitPopSint64(I);
  case PT_Uint64:
    return emitPopUint64(I);
  case PT_IntAP:
    return emitPopIntAP(I);
  case PT_IntAPS:
    return emitPopIntAPS(I);
  case PT_Bool:
    return emitPopBool(I);
  case PT_FixedPoint:
    return emitPopFixedPoint(I);
  case PT_Ptr:
    return emitPopPtr(I);
  case PT_MemberPtr:
    return emitPopMemberPtr(I);
  case PT_Float:
    return emitPopFloat(I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPopSint8(SourceInfo L) {
  return emitOp<>(OP_PopSint8, L);
}
bool ByteCodeEmitter::emitPopUint8(SourceInfo L) {
  return emitOp<>(OP_PopUint8, L);
}
bool ByteCodeEmitter::emitPopSint16(SourceInfo L) {
  return emitOp<>(OP_PopSint16, L);
}
bool ByteCodeEmitter::emitPopUint16(SourceInfo L) {
  return emitOp<>(OP_PopUint16, L);
}
bool ByteCodeEmitter::emitPopSint32(SourceInfo L) {
  return emitOp<>(OP_PopSint32, L);
}
bool ByteCodeEmitter::emitPopUint32(SourceInfo L) {
  return emitOp<>(OP_PopUint32, L);
}
bool ByteCodeEmitter::emitPopSint64(SourceInfo L) {
  return emitOp<>(OP_PopSint64, L);
}
bool ByteCodeEmitter::emitPopUint64(SourceInfo L) {
  return emitOp<>(OP_PopUint64, L);
}
bool ByteCodeEmitter::emitPopIntAP(SourceInfo L) {
  return emitOp<>(OP_PopIntAP, L);
}
bool ByteCodeEmitter::emitPopIntAPS(SourceInfo L) {
  return emitOp<>(OP_PopIntAPS, L);
}
bool ByteCodeEmitter::emitPopBool(SourceInfo L) {
  return emitOp<>(OP_PopBool, L);
}
bool ByteCodeEmitter::emitPopFixedPoint(SourceInfo L) {
  return emitOp<>(OP_PopFixedPoint, L);
}
bool ByteCodeEmitter::emitPopPtr(SourceInfo L) {
  return emitOp<>(OP_PopPtr, L);
}
bool ByteCodeEmitter::emitPopMemberPtr(SourceInfo L) {
  return emitOp<>(OP_PopMemberPtr, L);
}
bool ByteCodeEmitter::emitPopFloat(SourceInfo L) {
  return emitOp<>(OP_PopFloat, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPopSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitPopUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitPopSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitPopUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitPopSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitPopUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitPopSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitPopUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitPopIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitPopIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitPopBool(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Bool>(S, OpPC);
}
bool EvalEmitter::emitPopFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_FixedPoint>(S, OpPC);
}
bool EvalEmitter::emitPopPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Ptr>(S, OpPC);
}
bool EvalEmitter::emitPopMemberPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_MemberPtr>(S, OpPC);
}
bool EvalEmitter::emitPopFloat(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Pop<PT_Float>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PopCC,
#endif
#ifdef GET_INTERP
case OP_PopCC: {
  if (!PopCC(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PopCC:
  Text.Op = PrintName("PopCC");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPopCC(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPopCC(SourceInfo L) {
  return emitOp<>(OP_PopCC, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPopCC(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PopCC(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PreDecSint8,
OP_PreDecUint8,
OP_PreDecSint16,
OP_PreDecUint16,
OP_PreDecSint32,
OP_PreDecUint32,
OP_PreDecSint64,
OP_PreDecUint64,
OP_PreDecIntAP,
OP_PreDecIntAPS,
OP_PreDecBool,
OP_PreDecFixedPoint,
#endif
#ifdef GET_INTERP
case OP_PreDecSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreDecFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreDec<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PreDecSint8:
  Text.Op = PrintName("PreDecSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecUint8:
  Text.Op = PrintName("PreDecUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecSint16:
  Text.Op = PrintName("PreDecSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecUint16:
  Text.Op = PrintName("PreDecUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecSint32:
  Text.Op = PrintName("PreDecSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecUint32:
  Text.Op = PrintName("PreDecUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecSint64:
  Text.Op = PrintName("PreDecSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecUint64:
  Text.Op = PrintName("PreDecUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecIntAP:
  Text.Op = PrintName("PreDecIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecIntAPS:
  Text.Op = PrintName("PreDecIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecBool:
  Text.Op = PrintName("PreDecBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreDecFixedPoint:
  Text.Op = PrintName("PreDecFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPreDecSint8( bool , SourceInfo);
bool emitPreDecUint8( bool , SourceInfo);
bool emitPreDecSint16( bool , SourceInfo);
bool emitPreDecUint16( bool , SourceInfo);
bool emitPreDecSint32( bool , SourceInfo);
bool emitPreDecUint32( bool , SourceInfo);
bool emitPreDecSint64( bool , SourceInfo);
bool emitPreDecUint64( bool , SourceInfo);
bool emitPreDecIntAP( bool , SourceInfo);
bool emitPreDecIntAPS( bool , SourceInfo);
bool emitPreDecBool( bool , SourceInfo);
bool emitPreDecFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitPreDec(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitPreDec(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitPreDecSint8(A0, I);
  case PT_Uint8:
    return emitPreDecUint8(A0, I);
  case PT_Sint16:
    return emitPreDecSint16(A0, I);
  case PT_Uint16:
    return emitPreDecUint16(A0, I);
  case PT_Sint32:
    return emitPreDecSint32(A0, I);
  case PT_Uint32:
    return emitPreDecUint32(A0, I);
  case PT_Sint64:
    return emitPreDecSint64(A0, I);
  case PT_Uint64:
    return emitPreDecUint64(A0, I);
  case PT_IntAP:
    return emitPreDecIntAP(A0, I);
  case PT_IntAPS:
    return emitPreDecIntAPS(A0, I);
  case PT_Bool:
    return emitPreDecBool(A0, I);
  case PT_FixedPoint:
    return emitPreDecFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitPreDec");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPreDecSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecSint8, A0, L);
}
bool ByteCodeEmitter::emitPreDecUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecUint8, A0, L);
}
bool ByteCodeEmitter::emitPreDecSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecSint16, A0, L);
}
bool ByteCodeEmitter::emitPreDecUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecUint16, A0, L);
}
bool ByteCodeEmitter::emitPreDecSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecSint32, A0, L);
}
bool ByteCodeEmitter::emitPreDecUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecUint32, A0, L);
}
bool ByteCodeEmitter::emitPreDecSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecSint64, A0, L);
}
bool ByteCodeEmitter::emitPreDecUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecUint64, A0, L);
}
bool ByteCodeEmitter::emitPreDecIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecIntAP, A0, L);
}
bool ByteCodeEmitter::emitPreDecIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecIntAPS, A0, L);
}
bool ByteCodeEmitter::emitPreDecBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecBool, A0, L);
}
bool ByteCodeEmitter::emitPreDecFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreDecFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPreDecSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitPreDecFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreDec<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PreIncSint8,
OP_PreIncUint8,
OP_PreIncSint16,
OP_PreIncUint16,
OP_PreIncSint32,
OP_PreIncUint32,
OP_PreIncSint64,
OP_PreIncUint64,
OP_PreIncIntAP,
OP_PreIncIntAPS,
OP_PreIncBool,
OP_PreIncFixedPoint,
#endif
#ifdef GET_INTERP
case OP_PreIncSint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncUint8: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncSint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncUint16: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncSint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncUint32: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncSint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncUint64: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncIntAP: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncIntAPS: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncBool: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_PreIncFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PreInc<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PreIncSint8:
  Text.Op = PrintName("PreIncSint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncUint8:
  Text.Op = PrintName("PreIncUint8");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncSint16:
  Text.Op = PrintName("PreIncSint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncUint16:
  Text.Op = PrintName("PreIncUint16");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncSint32:
  Text.Op = PrintName("PreIncSint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncUint32:
  Text.Op = PrintName("PreIncUint32");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncSint64:
  Text.Op = PrintName("PreIncSint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncUint64:
  Text.Op = PrintName("PreIncUint64");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncIntAP:
  Text.Op = PrintName("PreIncIntAP");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncIntAPS:
  Text.Op = PrintName("PreIncIntAPS");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncBool:
  Text.Op = PrintName("PreIncBool");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
case OP_PreIncFixedPoint:
  Text.Op = PrintName("PreIncFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPreIncSint8( bool , SourceInfo);
bool emitPreIncUint8( bool , SourceInfo);
bool emitPreIncSint16( bool , SourceInfo);
bool emitPreIncUint16( bool , SourceInfo);
bool emitPreIncSint32( bool , SourceInfo);
bool emitPreIncUint32( bool , SourceInfo);
bool emitPreIncSint64( bool , SourceInfo);
bool emitPreIncUint64( bool , SourceInfo);
bool emitPreIncIntAP( bool , SourceInfo);
bool emitPreIncIntAPS( bool , SourceInfo);
bool emitPreIncBool( bool , SourceInfo);
bool emitPreIncFixedPoint( bool , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitPreInc(PrimType, bool, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitPreInc(PrimType T0,  bool A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitPreIncSint8(A0, I);
  case PT_Uint8:
    return emitPreIncUint8(A0, I);
  case PT_Sint16:
    return emitPreIncSint16(A0, I);
  case PT_Uint16:
    return emitPreIncUint16(A0, I);
  case PT_Sint32:
    return emitPreIncSint32(A0, I);
  case PT_Uint32:
    return emitPreIncUint32(A0, I);
  case PT_Sint64:
    return emitPreIncSint64(A0, I);
  case PT_Uint64:
    return emitPreIncUint64(A0, I);
  case PT_IntAP:
    return emitPreIncIntAP(A0, I);
  case PT_IntAPS:
    return emitPreIncIntAPS(A0, I);
  case PT_Bool:
    return emitPreIncBool(A0, I);
  case PT_FixedPoint:
    return emitPreIncFixedPoint(A0, I);
  default: llvm_unreachable("invalid type: emitPreInc");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPreIncSint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncSint8, A0, L);
}
bool ByteCodeEmitter::emitPreIncUint8( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncUint8, A0, L);
}
bool ByteCodeEmitter::emitPreIncSint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncSint16, A0, L);
}
bool ByteCodeEmitter::emitPreIncUint16( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncUint16, A0, L);
}
bool ByteCodeEmitter::emitPreIncSint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncSint32, A0, L);
}
bool ByteCodeEmitter::emitPreIncUint32( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncUint32, A0, L);
}
bool ByteCodeEmitter::emitPreIncSint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncSint64, A0, L);
}
bool ByteCodeEmitter::emitPreIncUint64( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncUint64, A0, L);
}
bool ByteCodeEmitter::emitPreIncIntAP( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncIntAP, A0, L);
}
bool ByteCodeEmitter::emitPreIncIntAPS( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncIntAPS, A0, L);
}
bool ByteCodeEmitter::emitPreIncBool( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncBool, A0, L);
}
bool ByteCodeEmitter::emitPreIncFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PreIncFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPreIncSint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncUint8( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncSint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncUint16( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncSint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncUint32( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncSint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncUint64( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncIntAP( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncIntAPS( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncBool( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitPreIncFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PreInc<PT_FixedPoint>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PtrPtrCast,
#endif
#ifdef GET_INTERP
case OP_PtrPtrCast: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PtrPtrCast(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PtrPtrCast:
  Text.Op = PrintName("PtrPtrCast");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPtrPtrCast( bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPtrPtrCast( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PtrPtrCast, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPtrPtrCast( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PtrPtrCast(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_PushCC,
#endif
#ifdef GET_INTERP
case OP_PushCC: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!PushCC(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_PushCC:
  Text.Op = PrintName("PushCC");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitPushCC( bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitPushCC( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_PushCC, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitPushCC( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return PushCC(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_RVOPtr,
#endif
#ifdef GET_INTERP
case OP_RVOPtr: {
  if (!RVOPtr(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_RVOPtr:
  Text.Op = PrintName("RVOPtr");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitRVOPtr(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitRVOPtr(SourceInfo L) {
  return emitOp<>(OP_RVOPtr, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitRVOPtr(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return RVOPtr(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_RemSint8,
OP_RemUint8,
OP_RemSint16,
OP_RemUint16,
OP_RemSint32,
OP_RemUint32,
OP_RemSint64,
OP_RemUint64,
OP_RemIntAP,
OP_RemIntAPS,
OP_RemFixedPoint,
#endif
#ifdef GET_INTERP
case OP_RemSint8: {
  if (!Rem<PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_RemUint8: {
  if (!Rem<PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_RemSint16: {
  if (!Rem<PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_RemUint16: {
  if (!Rem<PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_RemSint32: {
  if (!Rem<PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_RemUint32: {
  if (!Rem<PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_RemSint64: {
  if (!Rem<PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_RemUint64: {
  if (!Rem<PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_RemIntAP: {
  if (!Rem<PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_RemIntAPS: {
  if (!Rem<PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_RemFixedPoint: {
  if (!Rem<PT_FixedPoint>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_RemSint8:
  Text.Op = PrintName("RemSint8");
  break;
case OP_RemUint8:
  Text.Op = PrintName("RemUint8");
  break;
case OP_RemSint16:
  Text.Op = PrintName("RemSint16");
  break;
case OP_RemUint16:
  Text.Op = PrintName("RemUint16");
  break;
case OP_RemSint32:
  Text.Op = PrintName("RemSint32");
  break;
case OP_RemUint32:
  Text.Op = PrintName("RemUint32");
  break;
case OP_RemSint64:
  Text.Op = PrintName("RemSint64");
  break;
case OP_RemUint64:
  Text.Op = PrintName("RemUint64");
  break;
case OP_RemIntAP:
  Text.Op = PrintName("RemIntAP");
  break;
case OP_RemIntAPS:
  Text.Op = PrintName("RemIntAPS");
  break;
case OP_RemFixedPoint:
  Text.Op = PrintName("RemFixedPoint");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitRemSint8(SourceInfo);
bool emitRemUint8(SourceInfo);
bool emitRemSint16(SourceInfo);
bool emitRemUint16(SourceInfo);
bool emitRemSint32(SourceInfo);
bool emitRemUint32(SourceInfo);
bool emitRemSint64(SourceInfo);
bool emitRemUint64(SourceInfo);
bool emitRemIntAP(SourceInfo);
bool emitRemIntAPS(SourceInfo);
bool emitRemFixedPoint(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitRem(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitRem(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitRemSint8(I);
  case PT_Uint8:
    return emitRemUint8(I);
  case PT_Sint16:
    return emitRemSint16(I);
  case PT_Uint16:
    return emitRemUint16(I);
  case PT_Sint32:
    return emitRemSint32(I);
  case PT_Uint32:
    return emitRemUint32(I);
  case PT_Sint64:
    return emitRemSint64(I);
  case PT_Uint64:
    return emitRemUint64(I);
  case PT_IntAP:
    return emitRemIntAP(I);
  case PT_IntAPS:
    return emitRemIntAPS(I);
  case PT_FixedPoint:
    return emitRemFixedPoint(I);
  default: llvm_unreachable("invalid type: emitRem");
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitRemSint8(SourceInfo L) {
  return emitOp<>(OP_RemSint8, L);
}
bool ByteCodeEmitter::emitRemUint8(SourceInfo L) {
  return emitOp<>(OP_RemUint8, L);
}
bool ByteCodeEmitter::emitRemSint16(SourceInfo L) {
  return emitOp<>(OP_RemSint16, L);
}
bool ByteCodeEmitter::emitRemUint16(SourceInfo L) {
  return emitOp<>(OP_RemUint16, L);
}
bool ByteCodeEmitter::emitRemSint32(SourceInfo L) {
  return emitOp<>(OP_RemSint32, L);
}
bool ByteCodeEmitter::emitRemUint32(SourceInfo L) {
  return emitOp<>(OP_RemUint32, L);
}
bool ByteCodeEmitter::emitRemSint64(SourceInfo L) {
  return emitOp<>(OP_RemSint64, L);
}
bool ByteCodeEmitter::emitRemUint64(SourceInfo L) {
  return emitOp<>(OP_RemUint64, L);
}
bool ByteCodeEmitter::emitRemIntAP(SourceInfo L) {
  return emitOp<>(OP_RemIntAP, L);
}
bool ByteCodeEmitter::emitRemIntAPS(SourceInfo L) {
  return emitOp<>(OP_RemIntAPS, L);
}
bool ByteCodeEmitter::emitRemFixedPoint(SourceInfo L) {
  return emitOp<>(OP_RemFixedPoint, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitRemSint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Sint8>(S, OpPC);
}
bool EvalEmitter::emitRemUint8(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Uint8>(S, OpPC);
}
bool EvalEmitter::emitRemSint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Sint16>(S, OpPC);
}
bool EvalEmitter::emitRemUint16(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Uint16>(S, OpPC);
}
bool EvalEmitter::emitRemSint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Sint32>(S, OpPC);
}
bool EvalEmitter::emitRemUint32(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Uint32>(S, OpPC);
}
bool EvalEmitter::emitRemSint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Sint64>(S, OpPC);
}
bool EvalEmitter::emitRemUint64(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_Uint64>(S, OpPC);
}
bool EvalEmitter::emitRemIntAP(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_IntAP>(S, OpPC);
}
bool EvalEmitter::emitRemIntAPS(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_IntAPS>(S, OpPC);
}
bool EvalEmitter::emitRemFixedPoint(SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return Rem<PT_FixedPoint>(S, OpPC);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_RetSint8,
OP_RetUint8,
OP_RetSint16,
OP_RetUint16,
OP_RetSint32,
OP_RetUint32,
OP_RetSint64,
OP_RetUint64,
OP_RetIntAP,
OP_RetIntAPS,
OP_RetBool,
OP_RetFixedPoint,
OP_RetPtr,
OP_RetMemberPtr,
OP_RetFloat,
#endif
#ifdef GET_INTERP
case OP_RetSint8: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Sint8>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetUint8: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Uint8>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetSint16: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Sint16>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetUint16: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Uint16>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetSint32: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Sint32>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetUint32: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Uint32>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetSint64: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Sint64>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetUint64: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Uint64>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetIntAP: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_IntAP>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetIntAPS: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_IntAPS>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetBool: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Bool>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetFixedPoint: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_FixedPoint>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetPtr: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Ptr>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetMemberPtr: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_MemberPtr>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
case OP_RetFloat: {
  bool DoReturn = (S.Current == StartFrame);
  if (!Ret<PT_Float>(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_RetSint8:
  Text.Op = PrintName("RetSint8");
  break;
case OP_RetUint8:
  Text.Op = PrintName("RetUint8");
  break;
case OP_RetSint16:
  Text.Op = PrintName("RetSint16");
  break;
case OP_RetUint16:
  Text.Op = PrintName("RetUint16");
  break;
case OP_RetSint32:
  Text.Op = PrintName("RetSint32");
  break;
case OP_RetUint32:
  Text.Op = PrintName("RetUint32");
  break;
case OP_RetSint64:
  Text.Op = PrintName("RetSint64");
  break;
case OP_RetUint64:
  Text.Op = PrintName("RetUint64");
  break;
case OP_RetIntAP:
  Text.Op = PrintName("RetIntAP");
  break;
case OP_RetIntAPS:
  Text.Op = PrintName("RetIntAPS");
  break;
case OP_RetBool:
  Text.Op = PrintName("RetBool");
  break;
case OP_RetFixedPoint:
  Text.Op = PrintName("RetFixedPoint");
  break;
case OP_RetPtr:
  Text.Op = PrintName("RetPtr");
  break;
case OP_RetMemberPtr:
  Text.Op = PrintName("RetMemberPtr");
  break;
case OP_RetFloat:
  Text.Op = PrintName("RetFloat");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitRetSint8(SourceInfo);
bool emitRetUint8(SourceInfo);
bool emitRetSint16(SourceInfo);
bool emitRetUint16(SourceInfo);
bool emitRetSint32(SourceInfo);
bool emitRetUint32(SourceInfo);
bool emitRetSint64(SourceInfo);
bool emitRetUint64(SourceInfo);
bool emitRetIntAP(SourceInfo);
bool emitRetIntAPS(SourceInfo);
bool emitRetBool(SourceInfo);
bool emitRetFixedPoint(SourceInfo);
bool emitRetPtr(SourceInfo);
bool emitRetMemberPtr(SourceInfo);
bool emitRetFloat(SourceInfo);
#if defined(GET_EVAL_PROTO)
template<PrimType>
bool emitRet(SourceInfo);
#endif
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitRet(PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitRet(PrimType T0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
#ifdef GET_LINK_IMPL
    return emitRetSint8
#else
    return emitRet<PT_Sint8>
#endif
      (I);
  case PT_Uint8:
#ifdef GET_LINK_IMPL
    return emitRetUint8
#else
    return emitRet<PT_Uint8>
#endif
      (I);
  case PT_Sint16:
#ifdef GET_LINK_IMPL
    return emitRetSint16
#else
    return emitRet<PT_Sint16>
#endif
      (I);
  case PT_Uint16:
#ifdef GET_LINK_IMPL
    return emitRetUint16
#else
    return emitRet<PT_Uint16>
#endif
      (I);
  case PT_Sint32:
#ifdef GET_LINK_IMPL
    return emitRetSint32
#else
    return emitRet<PT_Sint32>
#endif
      (I);
  case PT_Uint32:
#ifdef GET_LINK_IMPL
    return emitRetUint32
#else
    return emitRet<PT_Uint32>
#endif
      (I);
  case PT_Sint64:
#ifdef GET_LINK_IMPL
    return emitRetSint64
#else
    return emitRet<PT_Sint64>
#endif
      (I);
  case PT_Uint64:
#ifdef GET_LINK_IMPL
    return emitRetUint64
#else
    return emitRet<PT_Uint64>
#endif
      (I);
  case PT_IntAP:
#ifdef GET_LINK_IMPL
    return emitRetIntAP
#else
    return emitRet<PT_IntAP>
#endif
      (I);
  case PT_IntAPS:
#ifdef GET_LINK_IMPL
    return emitRetIntAPS
#else
    return emitRet<PT_IntAPS>
#endif
      (I);
  case PT_Bool:
#ifdef GET_LINK_IMPL
    return emitRetBool
#else
    return emitRet<PT_Bool>
#endif
      (I);
  case PT_FixedPoint:
#ifdef GET_LINK_IMPL
    return emitRetFixedPoint
#else
    return emitRet<PT_FixedPoint>
#endif
      (I);
  case PT_Ptr:
#ifdef GET_LINK_IMPL
    return emitRetPtr
#else
    return emitRet<PT_Ptr>
#endif
      (I);
  case PT_MemberPtr:
#ifdef GET_LINK_IMPL
    return emitRetMemberPtr
#else
    return emitRet<PT_MemberPtr>
#endif
      (I);
  case PT_Float:
#ifdef GET_LINK_IMPL
    return emitRetFloat
#else
    return emitRet<PT_Float>
#endif
      (I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitRetSint8(SourceInfo L) {
  return emitOp<>(OP_RetSint8, L);
}
bool ByteCodeEmitter::emitRetUint8(SourceInfo L) {
  return emitOp<>(OP_RetUint8, L);
}
bool ByteCodeEmitter::emitRetSint16(SourceInfo L) {
  return emitOp<>(OP_RetSint16, L);
}
bool ByteCodeEmitter::emitRetUint16(SourceInfo L) {
  return emitOp<>(OP_RetUint16, L);
}
bool ByteCodeEmitter::emitRetSint32(SourceInfo L) {
  return emitOp<>(OP_RetSint32, L);
}
bool ByteCodeEmitter::emitRetUint32(SourceInfo L) {
  return emitOp<>(OP_RetUint32, L);
}
bool ByteCodeEmitter::emitRetSint64(SourceInfo L) {
  return emitOp<>(OP_RetSint64, L);
}
bool ByteCodeEmitter::emitRetUint64(SourceInfo L) {
  return emitOp<>(OP_RetUint64, L);
}
bool ByteCodeEmitter::emitRetIntAP(SourceInfo L) {
  return emitOp<>(OP_RetIntAP, L);
}
bool ByteCodeEmitter::emitRetIntAPS(SourceInfo L) {
  return emitOp<>(OP_RetIntAPS, L);
}
bool ByteCodeEmitter::emitRetBool(SourceInfo L) {
  return emitOp<>(OP_RetBool, L);
}
bool ByteCodeEmitter::emitRetFixedPoint(SourceInfo L) {
  return emitOp<>(OP_RetFixedPoint, L);
}
bool ByteCodeEmitter::emitRetPtr(SourceInfo L) {
  return emitOp<>(OP_RetPtr, L);
}
bool ByteCodeEmitter::emitRetMemberPtr(SourceInfo L) {
  return emitOp<>(OP_RetMemberPtr, L);
}
bool ByteCodeEmitter::emitRetFloat(SourceInfo L) {
  return emitOp<>(OP_RetFloat, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_RetValue,
#endif
#ifdef GET_INTERP
case OP_RetValue: {
  bool DoReturn = (S.Current == StartFrame);
  if (!RetValue(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_RetValue:
  Text.Op = PrintName("RetValue");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitRetValue(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitRetValue(SourceInfo L) {
  return emitOp<>(OP_RetValue, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_RetVoid,
#endif
#ifdef GET_INTERP
case OP_RetVoid: {
  bool DoReturn = (S.Current == StartFrame);
  if (!RetVoid(S, PC))
    return false;
  if (!S.Current || S.Current->isRoot())
    return true;
  if (DoReturn)
    return true;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_RetVoid:
  Text.Op = PrintName("RetVoid");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitRetVoid(SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitRetVoid(SourceInfo L) {
  return emitOp<>(OP_RetVoid, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_SetFieldSint8,
OP_SetFieldUint8,
OP_SetFieldSint16,
OP_SetFieldUint16,
OP_SetFieldSint32,
OP_SetFieldUint32,
OP_SetFieldSint64,
OP_SetFieldUint64,
OP_SetFieldIntAP,
OP_SetFieldIntAPS,
OP_SetFieldBool,
OP_SetFieldFixedPoint,
OP_SetFieldPtr,
OP_SetFieldMemberPtr,
OP_SetFieldFloat,
#endif
#ifdef GET_INTERP
case OP_SetFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_SetFieldSint8:
  Text.Op = PrintName("SetFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldUint8:
  Text.Op = PrintName("SetFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldSint16:
  Text.Op = PrintName("SetFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldUint16:
  Text.Op = PrintName("SetFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldSint32:
  Text.Op = PrintName("SetFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldUint32:
  Text.Op = PrintName("SetFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldSint64:
  Text.Op = PrintName("SetFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldUint64:
  Text.Op = PrintName("SetFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldIntAP:
  Text.Op = PrintName("SetFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldIntAPS:
  Text.Op = PrintName("SetFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldBool:
  Text.Op = PrintName("SetFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldFixedPoint:
  Text.Op = PrintName("SetFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldPtr:
  Text.Op = PrintName("SetFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldMemberPtr:
  Text.Op = PrintName("SetFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetFieldFloat:
  Text.Op = PrintName("SetFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitSetFieldSint8( uint32_t , SourceInfo);
bool emitSetFieldUint8( uint32_t , SourceInfo);
bool emitSetFieldSint16( uint32_t , SourceInfo);
bool emitSetFieldUint16( uint32_t , SourceInfo);
bool emitSetFieldSint32( uint32_t , SourceInfo);
bool emitSetFieldUint32( uint32_t , SourceInfo);
bool emitSetFieldSint64( uint32_t , SourceInfo);
bool emitSetFieldUint64( uint32_t , SourceInfo);
bool emitSetFieldIntAP( uint32_t , SourceInfo);
bool emitSetFieldIntAPS( uint32_t , SourceInfo);
bool emitSetFieldBool( uint32_t , SourceInfo);
bool emitSetFieldFixedPoint( uint32_t , SourceInfo);
bool emitSetFieldPtr( uint32_t , SourceInfo);
bool emitSetFieldMemberPtr( uint32_t , SourceInfo);
bool emitSetFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitSetField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitSetField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitSetFieldSint8(A0, I);
  case PT_Uint8:
    return emitSetFieldUint8(A0, I);
  case PT_Sint16:
    return emitSetFieldSint16(A0, I);
  case PT_Uint16:
    return emitSetFieldUint16(A0, I);
  case PT_Sint32:
    return emitSetFieldSint32(A0, I);
  case PT_Uint32:
    return emitSetFieldUint32(A0, I);
  case PT_Sint64:
    return emitSetFieldSint64(A0, I);
  case PT_Uint64:
    return emitSetFieldUint64(A0, I);
  case PT_IntAP:
    return emitSetFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitSetFieldIntAPS(A0, I);
  case PT_Bool:
    return emitSetFieldBool(A0, I);
  case PT_FixedPoint:
    return emitSetFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitSetFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitSetFieldMemberPtr(A0, I);
  case PT_Float:
    return emitSetFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitSetFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitSetFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitSetFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitSetFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitSetFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitSetFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitSetFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitSetFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitSetFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitSetFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitSetFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldBool, A0, L);
}
bool ByteCodeEmitter::emitSetFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitSetFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitSetFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitSetFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitSetFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_SetGlobalSint8,
OP_SetGlobalUint8,
OP_SetGlobalSint16,
OP_SetGlobalUint16,
OP_SetGlobalSint32,
OP_SetGlobalUint32,
OP_SetGlobalSint64,
OP_SetGlobalUint64,
OP_SetGlobalIntAP,
OP_SetGlobalIntAPS,
OP_SetGlobalBool,
OP_SetGlobalFixedPoint,
OP_SetGlobalPtr,
OP_SetGlobalMemberPtr,
OP_SetGlobalFloat,
#endif
#ifdef GET_INTERP
case OP_SetGlobalSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetGlobalFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetGlobal<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_SetGlobalSint8:
  Text.Op = PrintName("SetGlobalSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalUint8:
  Text.Op = PrintName("SetGlobalUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalSint16:
  Text.Op = PrintName("SetGlobalSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalUint16:
  Text.Op = PrintName("SetGlobalUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalSint32:
  Text.Op = PrintName("SetGlobalSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalUint32:
  Text.Op = PrintName("SetGlobalUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalSint64:
  Text.Op = PrintName("SetGlobalSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalUint64:
  Text.Op = PrintName("SetGlobalUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalIntAP:
  Text.Op = PrintName("SetGlobalIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalIntAPS:
  Text.Op = PrintName("SetGlobalIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalBool:
  Text.Op = PrintName("SetGlobalBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalFixedPoint:
  Text.Op = PrintName("SetGlobalFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalPtr:
  Text.Op = PrintName("SetGlobalPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalMemberPtr:
  Text.Op = PrintName("SetGlobalMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetGlobalFloat:
  Text.Op = PrintName("SetGlobalFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitSetGlobalSint8( uint32_t , SourceInfo);
bool emitSetGlobalUint8( uint32_t , SourceInfo);
bool emitSetGlobalSint16( uint32_t , SourceInfo);
bool emitSetGlobalUint16( uint32_t , SourceInfo);
bool emitSetGlobalSint32( uint32_t , SourceInfo);
bool emitSetGlobalUint32( uint32_t , SourceInfo);
bool emitSetGlobalSint64( uint32_t , SourceInfo);
bool emitSetGlobalUint64( uint32_t , SourceInfo);
bool emitSetGlobalIntAP( uint32_t , SourceInfo);
bool emitSetGlobalIntAPS( uint32_t , SourceInfo);
bool emitSetGlobalBool( uint32_t , SourceInfo);
bool emitSetGlobalFixedPoint( uint32_t , SourceInfo);
bool emitSetGlobalPtr( uint32_t , SourceInfo);
bool emitSetGlobalMemberPtr( uint32_t , SourceInfo);
bool emitSetGlobalFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitSetGlobal(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitSetGlobal(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitSetGlobalSint8(A0, I);
  case PT_Uint8:
    return emitSetGlobalUint8(A0, I);
  case PT_Sint16:
    return emitSetGlobalSint16(A0, I);
  case PT_Uint16:
    return emitSetGlobalUint16(A0, I);
  case PT_Sint32:
    return emitSetGlobalSint32(A0, I);
  case PT_Uint32:
    return emitSetGlobalUint32(A0, I);
  case PT_Sint64:
    return emitSetGlobalSint64(A0, I);
  case PT_Uint64:
    return emitSetGlobalUint64(A0, I);
  case PT_IntAP:
    return emitSetGlobalIntAP(A0, I);
  case PT_IntAPS:
    return emitSetGlobalIntAPS(A0, I);
  case PT_Bool:
    return emitSetGlobalBool(A0, I);
  case PT_FixedPoint:
    return emitSetGlobalFixedPoint(A0, I);
  case PT_Ptr:
    return emitSetGlobalPtr(A0, I);
  case PT_MemberPtr:
    return emitSetGlobalMemberPtr(A0, I);
  case PT_Float:
    return emitSetGlobalFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitSetGlobalSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalSint8, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalUint8, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalSint16, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalUint16, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalSint32, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalUint32, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalSint64, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalUint64, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalIntAP, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalIntAPS, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalBool, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalPtr, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitSetGlobalFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetGlobalFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitSetGlobalSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetGlobalFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetGlobal<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_SetLocalSint8,
OP_SetLocalUint8,
OP_SetLocalSint16,
OP_SetLocalUint16,
OP_SetLocalSint32,
OP_SetLocalUint32,
OP_SetLocalSint64,
OP_SetLocalUint64,
OP_SetLocalIntAP,
OP_SetLocalIntAPS,
OP_SetLocalBool,
OP_SetLocalFixedPoint,
OP_SetLocalPtr,
OP_SetLocalMemberPtr,
OP_SetLocalFloat,
#endif
#ifdef GET_INTERP
case OP_SetLocalSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetLocalFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetLocal<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_SetLocalSint8:
  Text.Op = PrintName("SetLocalSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalUint8:
  Text.Op = PrintName("SetLocalUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalSint16:
  Text.Op = PrintName("SetLocalSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalUint16:
  Text.Op = PrintName("SetLocalUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalSint32:
  Text.Op = PrintName("SetLocalSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalUint32:
  Text.Op = PrintName("SetLocalUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalSint64:
  Text.Op = PrintName("SetLocalSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalUint64:
  Text.Op = PrintName("SetLocalUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalIntAP:
  Text.Op = PrintName("SetLocalIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalIntAPS:
  Text.Op = PrintName("SetLocalIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalBool:
  Text.Op = PrintName("SetLocalBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalFixedPoint:
  Text.Op = PrintName("SetLocalFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalPtr:
  Text.Op = PrintName("SetLocalPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalMemberPtr:
  Text.Op = PrintName("SetLocalMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetLocalFloat:
  Text.Op = PrintName("SetLocalFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitSetLocalSint8( uint32_t , SourceInfo);
bool emitSetLocalUint8( uint32_t , SourceInfo);
bool emitSetLocalSint16( uint32_t , SourceInfo);
bool emitSetLocalUint16( uint32_t , SourceInfo);
bool emitSetLocalSint32( uint32_t , SourceInfo);
bool emitSetLocalUint32( uint32_t , SourceInfo);
bool emitSetLocalSint64( uint32_t , SourceInfo);
bool emitSetLocalUint64( uint32_t , SourceInfo);
bool emitSetLocalIntAP( uint32_t , SourceInfo);
bool emitSetLocalIntAPS( uint32_t , SourceInfo);
bool emitSetLocalBool( uint32_t , SourceInfo);
bool emitSetLocalFixedPoint( uint32_t , SourceInfo);
bool emitSetLocalPtr( uint32_t , SourceInfo);
bool emitSetLocalMemberPtr( uint32_t , SourceInfo);
bool emitSetLocalFloat( uint32_t , SourceInfo);
#if defined(GET_EVAL_PROTO)
template<PrimType>
bool emitSetLocal(uint32_t, SourceInfo);
#endif
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitSetLocal(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitSetLocal(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
#ifdef GET_LINK_IMPL
    return emitSetLocalSint8
#else
    return emitSetLocal<PT_Sint8>
#endif
      (A0, I);
  case PT_Uint8:
#ifdef GET_LINK_IMPL
    return emitSetLocalUint8
#else
    return emitSetLocal<PT_Uint8>
#endif
      (A0, I);
  case PT_Sint16:
#ifdef GET_LINK_IMPL
    return emitSetLocalSint16
#else
    return emitSetLocal<PT_Sint16>
#endif
      (A0, I);
  case PT_Uint16:
#ifdef GET_LINK_IMPL
    return emitSetLocalUint16
#else
    return emitSetLocal<PT_Uint16>
#endif
      (A0, I);
  case PT_Sint32:
#ifdef GET_LINK_IMPL
    return emitSetLocalSint32
#else
    return emitSetLocal<PT_Sint32>
#endif
      (A0, I);
  case PT_Uint32:
#ifdef GET_LINK_IMPL
    return emitSetLocalUint32
#else
    return emitSetLocal<PT_Uint32>
#endif
      (A0, I);
  case PT_Sint64:
#ifdef GET_LINK_IMPL
    return emitSetLocalSint64
#else
    return emitSetLocal<PT_Sint64>
#endif
      (A0, I);
  case PT_Uint64:
#ifdef GET_LINK_IMPL
    return emitSetLocalUint64
#else
    return emitSetLocal<PT_Uint64>
#endif
      (A0, I);
  case PT_IntAP:
#ifdef GET_LINK_IMPL
    return emitSetLocalIntAP
#else
    return emitSetLocal<PT_IntAP>
#endif
      (A0, I);
  case PT_IntAPS:
#ifdef GET_LINK_IMPL
    return emitSetLocalIntAPS
#else
    return emitSetLocal<PT_IntAPS>
#endif
      (A0, I);
  case PT_Bool:
#ifdef GET_LINK_IMPL
    return emitSetLocalBool
#else
    return emitSetLocal<PT_Bool>
#endif
      (A0, I);
  case PT_FixedPoint:
#ifdef GET_LINK_IMPL
    return emitSetLocalFixedPoint
#else
    return emitSetLocal<PT_FixedPoint>
#endif
      (A0, I);
  case PT_Ptr:
#ifdef GET_LINK_IMPL
    return emitSetLocalPtr
#else
    return emitSetLocal<PT_Ptr>
#endif
      (A0, I);
  case PT_MemberPtr:
#ifdef GET_LINK_IMPL
    return emitSetLocalMemberPtr
#else
    return emitSetLocal<PT_MemberPtr>
#endif
      (A0, I);
  case PT_Float:
#ifdef GET_LINK_IMPL
    return emitSetLocalFloat
#else
    return emitSetLocal<PT_Float>
#endif
      (A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitSetLocalSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalSint8, A0, L);
}
bool ByteCodeEmitter::emitSetLocalUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalUint8, A0, L);
}
bool ByteCodeEmitter::emitSetLocalSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalSint16, A0, L);
}
bool ByteCodeEmitter::emitSetLocalUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalUint16, A0, L);
}
bool ByteCodeEmitter::emitSetLocalSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalSint32, A0, L);
}
bool ByteCodeEmitter::emitSetLocalUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalUint32, A0, L);
}
bool ByteCodeEmitter::emitSetLocalSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalSint64, A0, L);
}
bool ByteCodeEmitter::emitSetLocalUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalUint64, A0, L);
}
bool ByteCodeEmitter::emitSetLocalIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalIntAP, A0, L);
}
bool ByteCodeEmitter::emitSetLocalIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalIntAPS, A0, L);
}
bool ByteCodeEmitter::emitSetLocalBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalBool, A0, L);
}
bool ByteCodeEmitter::emitSetLocalFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitSetLocalPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalPtr, A0, L);
}
bool ByteCodeEmitter::emitSetLocalMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitSetLocalFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetLocalFloat, A0, L);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_SetParamSint8,
OP_SetParamUint8,
OP_SetParamSint16,
OP_SetParamUint16,
OP_SetParamSint32,
OP_SetParamUint32,
OP_SetParamSint64,
OP_SetParamUint64,
OP_SetParamIntAP,
OP_SetParamIntAPS,
OP_SetParamBool,
OP_SetParamFixedPoint,
OP_SetParamPtr,
OP_SetParamMemberPtr,
OP_SetParamFloat,
#endif
#ifdef GET_INTERP
case OP_SetParamSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetParamFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetParam<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_SetParamSint8:
  Text.Op = PrintName("SetParamSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamUint8:
  Text.Op = PrintName("SetParamUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamSint16:
  Text.Op = PrintName("SetParamSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamUint16:
  Text.Op = PrintName("SetParamUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamSint32:
  Text.Op = PrintName("SetParamSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamUint32:
  Text.Op = PrintName("SetParamUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamSint64:
  Text.Op = PrintName("SetParamSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamUint64:
  Text.Op = PrintName("SetParamUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamIntAP:
  Text.Op = PrintName("SetParamIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamIntAPS:
  Text.Op = PrintName("SetParamIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamBool:
  Text.Op = PrintName("SetParamBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamFixedPoint:
  Text.Op = PrintName("SetParamFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamPtr:
  Text.Op = PrintName("SetParamPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamMemberPtr:
  Text.Op = PrintName("SetParamMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetParamFloat:
  Text.Op = PrintName("SetParamFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitSetParamSint8( uint32_t , SourceInfo);
bool emitSetParamUint8( uint32_t , SourceInfo);
bool emitSetParamSint16( uint32_t , SourceInfo);
bool emitSetParamUint16( uint32_t , SourceInfo);
bool emitSetParamSint32( uint32_t , SourceInfo);
bool emitSetParamUint32( uint32_t , SourceInfo);
bool emitSetParamSint64( uint32_t , SourceInfo);
bool emitSetParamUint64( uint32_t , SourceInfo);
bool emitSetParamIntAP( uint32_t , SourceInfo);
bool emitSetParamIntAPS( uint32_t , SourceInfo);
bool emitSetParamBool( uint32_t , SourceInfo);
bool emitSetParamFixedPoint( uint32_t , SourceInfo);
bool emitSetParamPtr( uint32_t , SourceInfo);
bool emitSetParamMemberPtr( uint32_t , SourceInfo);
bool emitSetParamFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitSetParam(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitSetParam(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitSetParamSint8(A0, I);
  case PT_Uint8:
    return emitSetParamUint8(A0, I);
  case PT_Sint16:
    return emitSetParamSint16(A0, I);
  case PT_Uint16:
    return emitSetParamUint16(A0, I);
  case PT_Sint32:
    return emitSetParamSint32(A0, I);
  case PT_Uint32:
    return emitSetParamUint32(A0, I);
  case PT_Sint64:
    return emitSetParamSint64(A0, I);
  case PT_Uint64:
    return emitSetParamUint64(A0, I);
  case PT_IntAP:
    return emitSetParamIntAP(A0, I);
  case PT_IntAPS:
    return emitSetParamIntAPS(A0, I);
  case PT_Bool:
    return emitSetParamBool(A0, I);
  case PT_FixedPoint:
    return emitSetParamFixedPoint(A0, I);
  case PT_Ptr:
    return emitSetParamPtr(A0, I);
  case PT_MemberPtr:
    return emitSetParamMemberPtr(A0, I);
  case PT_Float:
    return emitSetParamFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitSetParamSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamSint8, A0, L);
}
bool ByteCodeEmitter::emitSetParamUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamUint8, A0, L);
}
bool ByteCodeEmitter::emitSetParamSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamSint16, A0, L);
}
bool ByteCodeEmitter::emitSetParamUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamUint16, A0, L);
}
bool ByteCodeEmitter::emitSetParamSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamSint32, A0, L);
}
bool ByteCodeEmitter::emitSetParamUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamUint32, A0, L);
}
bool ByteCodeEmitter::emitSetParamSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamSint64, A0, L);
}
bool ByteCodeEmitter::emitSetParamUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamUint64, A0, L);
}
bool ByteCodeEmitter::emitSetParamIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamIntAP, A0, L);
}
bool ByteCodeEmitter::emitSetParamIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamIntAPS, A0, L);
}
bool ByteCodeEmitter::emitSetParamBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamBool, A0, L);
}
bool ByteCodeEmitter::emitSetParamFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitSetParamPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamPtr, A0, L);
}
bool ByteCodeEmitter::emitSetParamMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitSetParamFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetParamFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitSetParamSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetParamFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetParam<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_SetThisFieldSint8,
OP_SetThisFieldUint8,
OP_SetThisFieldSint16,
OP_SetThisFieldUint16,
OP_SetThisFieldSint32,
OP_SetThisFieldUint32,
OP_SetThisFieldSint64,
OP_SetThisFieldUint64,
OP_SetThisFieldIntAP,
OP_SetThisFieldIntAPS,
OP_SetThisFieldBool,
OP_SetThisFieldFixedPoint,
OP_SetThisFieldPtr,
OP_SetThisFieldMemberPtr,
OP_SetThisFieldFloat,
#endif
#ifdef GET_INTERP
case OP_SetThisFieldSint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Sint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldUint8: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Uint8>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldSint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Sint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldUint16: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Uint16>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldSint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Sint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldUint32: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Uint32>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldSint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Sint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldUint64: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Uint64>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldIntAP: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_IntAP>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldIntAPS: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_IntAPS>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldBool: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Bool>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldFixedPoint: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_FixedPoint>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Ptr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldMemberPtr: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_MemberPtr>(S, OpPC, V0))
    return false;
  continue;
}
case OP_SetThisFieldFloat: {
  const auto V0 = ReadArg<uint32_t>(S, PC);
  if (!SetThisField<PT_Float>(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_SetThisFieldSint8:
  Text.Op = PrintName("SetThisFieldSint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldUint8:
  Text.Op = PrintName("SetThisFieldUint8");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldSint16:
  Text.Op = PrintName("SetThisFieldSint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldUint16:
  Text.Op = PrintName("SetThisFieldUint16");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldSint32:
  Text.Op = PrintName("SetThisFieldSint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldUint32:
  Text.Op = PrintName("SetThisFieldUint32");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldSint64:
  Text.Op = PrintName("SetThisFieldSint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldUint64:
  Text.Op = PrintName("SetThisFieldUint64");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldIntAP:
  Text.Op = PrintName("SetThisFieldIntAP");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldIntAPS:
  Text.Op = PrintName("SetThisFieldIntAPS");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldBool:
  Text.Op = PrintName("SetThisFieldBool");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldFixedPoint:
  Text.Op = PrintName("SetThisFieldFixedPoint");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldPtr:
  Text.Op = PrintName("SetThisFieldPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldMemberPtr:
  Text.Op = PrintName("SetThisFieldMemberPtr");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
case OP_SetThisFieldFloat:
  Text.Op = PrintName("SetThisFieldFloat");
  Text.Args.push_back(printArg<uint32_t>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitSetThisFieldSint8( uint32_t , SourceInfo);
bool emitSetThisFieldUint8( uint32_t , SourceInfo);
bool emitSetThisFieldSint16( uint32_t , SourceInfo);
bool emitSetThisFieldUint16( uint32_t , SourceInfo);
bool emitSetThisFieldSint32( uint32_t , SourceInfo);
bool emitSetThisFieldUint32( uint32_t , SourceInfo);
bool emitSetThisFieldSint64( uint32_t , SourceInfo);
bool emitSetThisFieldUint64( uint32_t , SourceInfo);
bool emitSetThisFieldIntAP( uint32_t , SourceInfo);
bool emitSetThisFieldIntAPS( uint32_t , SourceInfo);
bool emitSetThisFieldBool( uint32_t , SourceInfo);
bool emitSetThisFieldFixedPoint( uint32_t , SourceInfo);
bool emitSetThisFieldPtr( uint32_t , SourceInfo);
bool emitSetThisFieldMemberPtr( uint32_t , SourceInfo);
bool emitSetThisFieldFloat( uint32_t , SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitSetThisField(PrimType, uint32_t, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitSetThisField(PrimType T0,  uint32_t A0, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
    return emitSetThisFieldSint8(A0, I);
  case PT_Uint8:
    return emitSetThisFieldUint8(A0, I);
  case PT_Sint16:
    return emitSetThisFieldSint16(A0, I);
  case PT_Uint16:
    return emitSetThisFieldUint16(A0, I);
  case PT_Sint32:
    return emitSetThisFieldSint32(A0, I);
  case PT_Uint32:
    return emitSetThisFieldUint32(A0, I);
  case PT_Sint64:
    return emitSetThisFieldSint64(A0, I);
  case PT_Uint64:
    return emitSetThisFieldUint64(A0, I);
  case PT_IntAP:
    return emitSetThisFieldIntAP(A0, I);
  case PT_IntAPS:
    return emitSetThisFieldIntAPS(A0, I);
  case PT_Bool:
    return emitSetThisFieldBool(A0, I);
  case PT_FixedPoint:
    return emitSetThisFieldFixedPoint(A0, I);
  case PT_Ptr:
    return emitSetThisFieldPtr(A0, I);
  case PT_MemberPtr:
    return emitSetThisFieldMemberPtr(A0, I);
  case PT_Float:
    return emitSetThisFieldFloat(A0, I);
  }
  llvm_unreachable("invalid enum value");
}
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitSetThisFieldSint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldSint8, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldUint8( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldUint8, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldSint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldSint16, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldUint16( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldUint16, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldSint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldSint32, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldUint32( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldUint32, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldSint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldSint64, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldUint64( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldUint64, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldIntAP( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldIntAP, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldIntAPS, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldBool( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldBool, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldFixedPoint, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldPtr, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldMemberPtr, A0, L);
}
bool ByteCodeEmitter::emitSetThisFieldFloat( uint32_t A0, SourceInfo L) {
  return emitOp<uint32_t>(OP_SetThisFieldFloat, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitSetThisFieldSint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Sint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldUint8( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Uint8>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldSint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Sint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldUint16( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Uint16>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldSint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Sint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldUint32( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Uint32>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldSint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Sint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldUint64( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Uint64>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldIntAP( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_IntAP>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldIntAPS( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_IntAPS>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldBool( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Bool>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldFixedPoint( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_FixedPoint>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Ptr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldMemberPtr( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_MemberPtr>(S, OpPC, A0);
}
bool EvalEmitter::emitSetThisFieldFloat( uint32_t A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return SetThisField<PT_Float>(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ShiftFixedPoint,
#endif
#ifdef GET_INTERP
case OP_ShiftFixedPoint: {
  const auto V0 = ReadArg<bool>(S, PC);
  if (!ShiftFixedPoint(S, OpPC, V0))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ShiftFixedPoint:
  Text.Op = PrintName("ShiftFixedPoint");
  Text.Args.push_back(printArg<bool>(P, PC));
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitShiftFixedPoint( bool , SourceInfo);
#endif
#ifdef GET_LINK_IMPL
bool ByteCodeEmitter::emitShiftFixedPoint( bool A0, SourceInfo L) {
  return emitOp<bool>(OP_ShiftFixedPoint, A0, L);
}
#endif
#ifdef GET_EVAL_IMPL
bool EvalEmitter::emitShiftFixedPoint( bool A0, SourceInfo L) {
  if (!isActive()) return true;
  CurrentSource = L;
  return ShiftFixedPoint(S, OpPC, A0);
}
#endif
#ifdef GET_OPCODE_NAMES
OP_ShlSint8Sint8,
OP_ShlSint8Uint8,
OP_ShlSint8Sint16,
OP_ShlSint8Uint16,
OP_ShlSint8Sint32,
OP_ShlSint8Uint32,
OP_ShlSint8Sint64,
OP_ShlSint8Uint64,
OP_ShlSint8IntAP,
OP_ShlSint8IntAPS,
OP_ShlUint8Sint8,
OP_ShlUint8Uint8,
OP_ShlUint8Sint16,
OP_ShlUint8Uint16,
OP_ShlUint8Sint32,
OP_ShlUint8Uint32,
OP_ShlUint8Sint64,
OP_ShlUint8Uint64,
OP_ShlUint8IntAP,
OP_ShlUint8IntAPS,
OP_ShlSint16Sint8,
OP_ShlSint16Uint8,
OP_ShlSint16Sint16,
OP_ShlSint16Uint16,
OP_ShlSint16Sint32,
OP_ShlSint16Uint32,
OP_ShlSint16Sint64,
OP_ShlSint16Uint64,
OP_ShlSint16IntAP,
OP_ShlSint16IntAPS,
OP_ShlUint16Sint8,
OP_ShlUint16Uint8,
OP_ShlUint16Sint16,
OP_ShlUint16Uint16,
OP_ShlUint16Sint32,
OP_ShlUint16Uint32,
OP_ShlUint16Sint64,
OP_ShlUint16Uint64,
OP_ShlUint16IntAP,
OP_ShlUint16IntAPS,
OP_ShlSint32Sint8,
OP_ShlSint32Uint8,
OP_ShlSint32Sint16,
OP_ShlSint32Uint16,
OP_ShlSint32Sint32,
OP_ShlSint32Uint32,
OP_ShlSint32Sint64,
OP_ShlSint32Uint64,
OP_ShlSint32IntAP,
OP_ShlSint32IntAPS,
OP_ShlUint32Sint8,
OP_ShlUint32Uint8,
OP_ShlUint32Sint16,
OP_ShlUint32Uint16,
OP_ShlUint32Sint32,
OP_ShlUint32Uint32,
OP_ShlUint32Sint64,
OP_ShlUint32Uint64,
OP_ShlUint32IntAP,
OP_ShlUint32IntAPS,
OP_ShlSint64Sint8,
OP_ShlSint64Uint8,
OP_ShlSint64Sint16,
OP_ShlSint64Uint16,
OP_ShlSint64Sint32,
OP_ShlSint64Uint32,
OP_ShlSint64Sint64,
OP_ShlSint64Uint64,
OP_ShlSint64IntAP,
OP_ShlSint64IntAPS,
OP_ShlUint64Sint8,
OP_ShlUint64Uint8,
OP_ShlUint64Sint16,
OP_ShlUint64Uint16,
OP_ShlUint64Sint32,
OP_ShlUint64Uint32,
OP_ShlUint64Sint64,
OP_ShlUint64Uint64,
OP_ShlUint64IntAP,
OP_ShlUint64IntAPS,
OP_ShlIntAPSint8,
OP_ShlIntAPUint8,
OP_ShlIntAPSint16,
OP_ShlIntAPUint16,
OP_ShlIntAPSint32,
OP_ShlIntAPUint32,
OP_ShlIntAPSint64,
OP_ShlIntAPUint64,
OP_ShlIntAPIntAP,
OP_ShlIntAPIntAPS,
OP_ShlIntAPSSint8,
OP_ShlIntAPSUint8,
OP_ShlIntAPSSint16,
OP_ShlIntAPSUint16,
OP_ShlIntAPSSint32,
OP_ShlIntAPSUint32,
OP_ShlIntAPSSint64,
OP_ShlIntAPSUint64,
OP_ShlIntAPSIntAP,
OP_ShlIntAPSIntAPS,
#endif
#ifdef GET_INTERP
case OP_ShlSint8Sint8: {
  if (!Shl<PT_Sint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Uint8: {
  if (!Shl<PT_Sint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Sint16: {
  if (!Shl<PT_Sint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Uint16: {
  if (!Shl<PT_Sint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Sint32: {
  if (!Shl<PT_Sint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Uint32: {
  if (!Shl<PT_Sint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Sint64: {
  if (!Shl<PT_Sint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8Uint64: {
  if (!Shl<PT_Sint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8IntAP: {
  if (!Shl<PT_Sint8, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint8IntAPS: {
  if (!Shl<PT_Sint8, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Sint8: {
  if (!Shl<PT_Uint8, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Uint8: {
  if (!Shl<PT_Uint8, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Sint16: {
  if (!Shl<PT_Uint8, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Uint16: {
  if (!Shl<PT_Uint8, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Sint32: {
  if (!Shl<PT_Uint8, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Uint32: {
  if (!Shl<PT_Uint8, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Sint64: {
  if (!Shl<PT_Uint8, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8Uint64: {
  if (!Shl<PT_Uint8, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8IntAP: {
  if (!Shl<PT_Uint8, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint8IntAPS: {
  if (!Shl<PT_Uint8, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Sint8: {
  if (!Shl<PT_Sint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Uint8: {
  if (!Shl<PT_Sint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Sint16: {
  if (!Shl<PT_Sint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Uint16: {
  if (!Shl<PT_Sint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Sint32: {
  if (!Shl<PT_Sint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Uint32: {
  if (!Shl<PT_Sint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Sint64: {
  if (!Shl<PT_Sint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16Uint64: {
  if (!Shl<PT_Sint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16IntAP: {
  if (!Shl<PT_Sint16, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint16IntAPS: {
  if (!Shl<PT_Sint16, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Sint8: {
  if (!Shl<PT_Uint16, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Uint8: {
  if (!Shl<PT_Uint16, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Sint16: {
  if (!Shl<PT_Uint16, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Uint16: {
  if (!Shl<PT_Uint16, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Sint32: {
  if (!Shl<PT_Uint16, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Uint32: {
  if (!Shl<PT_Uint16, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Sint64: {
  if (!Shl<PT_Uint16, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16Uint64: {
  if (!Shl<PT_Uint16, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16IntAP: {
  if (!Shl<PT_Uint16, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint16IntAPS: {
  if (!Shl<PT_Uint16, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Sint8: {
  if (!Shl<PT_Sint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Uint8: {
  if (!Shl<PT_Sint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Sint16: {
  if (!Shl<PT_Sint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Uint16: {
  if (!Shl<PT_Sint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Sint32: {
  if (!Shl<PT_Sint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Uint32: {
  if (!Shl<PT_Sint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Sint64: {
  if (!Shl<PT_Sint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32Uint64: {
  if (!Shl<PT_Sint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32IntAP: {
  if (!Shl<PT_Sint32, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint32IntAPS: {
  if (!Shl<PT_Sint32, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Sint8: {
  if (!Shl<PT_Uint32, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Uint8: {
  if (!Shl<PT_Uint32, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Sint16: {
  if (!Shl<PT_Uint32, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Uint16: {
  if (!Shl<PT_Uint32, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Sint32: {
  if (!Shl<PT_Uint32, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Uint32: {
  if (!Shl<PT_Uint32, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Sint64: {
  if (!Shl<PT_Uint32, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32Uint64: {
  if (!Shl<PT_Uint32, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32IntAP: {
  if (!Shl<PT_Uint32, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint32IntAPS: {
  if (!Shl<PT_Uint32, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Sint8: {
  if (!Shl<PT_Sint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Uint8: {
  if (!Shl<PT_Sint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Sint16: {
  if (!Shl<PT_Sint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Uint16: {
  if (!Shl<PT_Sint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Sint32: {
  if (!Shl<PT_Sint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Uint32: {
  if (!Shl<PT_Sint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Sint64: {
  if (!Shl<PT_Sint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64Uint64: {
  if (!Shl<PT_Sint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64IntAP: {
  if (!Shl<PT_Sint64, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlSint64IntAPS: {
  if (!Shl<PT_Sint64, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Sint8: {
  if (!Shl<PT_Uint64, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Uint8: {
  if (!Shl<PT_Uint64, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Sint16: {
  if (!Shl<PT_Uint64, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Uint16: {
  if (!Shl<PT_Uint64, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Sint32: {
  if (!Shl<PT_Uint64, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Uint32: {
  if (!Shl<PT_Uint64, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Sint64: {
  if (!Shl<PT_Uint64, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64Uint64: {
  if (!Shl<PT_Uint64, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64IntAP: {
  if (!Shl<PT_Uint64, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlUint64IntAPS: {
  if (!Shl<PT_Uint64, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSint8: {
  if (!Shl<PT_IntAP, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPUint8: {
  if (!Shl<PT_IntAP, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSint16: {
  if (!Shl<PT_IntAP, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPUint16: {
  if (!Shl<PT_IntAP, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSint32: {
  if (!Shl<PT_IntAP, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPUint32: {
  if (!Shl<PT_IntAP, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSint64: {
  if (!Shl<PT_IntAP, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPUint64: {
  if (!Shl<PT_IntAP, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPIntAP: {
  if (!Shl<PT_IntAP, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPIntAPS: {
  if (!Shl<PT_IntAP, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSSint8: {
  if (!Shl<PT_IntAPS, PT_Sint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSUint8: {
  if (!Shl<PT_IntAPS, PT_Uint8>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSSint16: {
  if (!Shl<PT_IntAPS, PT_Sint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSUint16: {
  if (!Shl<PT_IntAPS, PT_Uint16>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSSint32: {
  if (!Shl<PT_IntAPS, PT_Sint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSUint32: {
  if (!Shl<PT_IntAPS, PT_Uint32>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSSint64: {
  if (!Shl<PT_IntAPS, PT_Sint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSUint64: {
  if (!Shl<PT_IntAPS, PT_Uint64>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSIntAP: {
  if (!Shl<PT_IntAPS, PT_IntAP>(S, OpPC))
    return false;
  continue;
}
case OP_ShlIntAPSIntAPS: {
  if (!Shl<PT_IntAPS, PT_IntAPS>(S, OpPC))
    return false;
  continue;
}
#endif
#ifdef GET_DISASM
case OP_ShlSint8Sint8:
  Text.Op = PrintName("ShlSint8Sint8");
  break;
case OP_ShlSint8Uint8:
  Text.Op = PrintName("ShlSint8Uint8");
  break;
case OP_ShlSint8Sint16:
  Text.Op = PrintName("ShlSint8Sint16");
  break;
case OP_ShlSint8Uint16:
  Text.Op = PrintName("ShlSint8Uint16");
  break;
case OP_ShlSint8Sint32:
  Text.Op = PrintName("ShlSint8Sint32");
  break;
case OP_ShlSint8Uint32:
  Text.Op = PrintName("ShlSint8Uint32");
  break;
case OP_ShlSint8Sint64:
  Text.Op = PrintName("ShlSint8Sint64");
  break;
case OP_ShlSint8Uint64:
  Text.Op = PrintName("ShlSint8Uint64");
  break;
case OP_ShlSint8IntAP:
  Text.Op = PrintName("ShlSint8IntAP");
  break;
case OP_ShlSint8IntAPS:
  Text.Op = PrintName("ShlSint8IntAPS");
  break;
case OP_ShlUint8Sint8:
  Text.Op = PrintName("ShlUint8Sint8");
  break;
case OP_ShlUint8Uint8:
  Text.Op = PrintName("ShlUint8Uint8");
  break;
case OP_ShlUint8Sint16:
  Text.Op = PrintName("ShlUint8Sint16");
  break;
case OP_ShlUint8Uint16:
  Text.Op = PrintName("ShlUint8Uint16");
  break;
case OP_ShlUint8Sint32:
  Text.Op = PrintName("ShlUint8Sint32");
  break;
case OP_ShlUint8Uint32:
  Text.Op = PrintName("ShlUint8Uint32");
  break;
case OP_ShlUint8Sint64:
  Text.Op = PrintName("ShlUint8Sint64");
  break;
case OP_ShlUint8Uint64:
  Text.Op = PrintName("ShlUint8Uint64");
  break;
case OP_ShlUint8IntAP:
  Text.Op = PrintName("ShlUint8IntAP");
  break;
case OP_ShlUint8IntAPS:
  Text.Op = PrintName("ShlUint8IntAPS");
  break;
case OP_ShlSint16Sint8:
  Text.Op = PrintName("ShlSint16Sint8");
  break;
case OP_ShlSint16Uint8:
  Text.Op = PrintName("ShlSint16Uint8");
  break;
case OP_ShlSint16Sint16:
  Text.Op = PrintName("ShlSint16Sint16");
  break;
case OP_ShlSint16Uint16:
  Text.Op = PrintName("ShlSint16Uint16");
  break;
case OP_ShlSint16Sint32:
  Text.Op = PrintName("ShlSint16Sint32");
  break;
case OP_ShlSint16Uint32:
  Text.Op = PrintName("ShlSint16Uint32");
  break;
case OP_ShlSint16Sint64:
  Text.Op = PrintName("ShlSint16Sint64");
  break;
case OP_ShlSint16Uint64:
  Text.Op = PrintName("ShlSint16Uint64");
  break;
case OP_ShlSint16IntAP:
  Text.Op = PrintName("ShlSint16IntAP");
  break;
case OP_ShlSint16IntAPS:
  Text.Op = PrintName("ShlSint16IntAPS");
  break;
case OP_ShlUint16Sint8:
  Text.Op = PrintName("ShlUint16Sint8");
  break;
case OP_ShlUint16Uint8:
  Text.Op = PrintName("ShlUint16Uint8");
  break;
case OP_ShlUint16Sint16:
  Text.Op = PrintName("ShlUint16Sint16");
  break;
case OP_ShlUint16Uint16:
  Text.Op = PrintName("ShlUint16Uint16");
  break;
case OP_ShlUint16Sint32:
  Text.Op = PrintName("ShlUint16Sint32");
  break;
case OP_ShlUint16Uint32:
  Text.Op = PrintName("ShlUint16Uint32");
  break;
case OP_ShlUint16Sint64:
  Text.Op = PrintName("ShlUint16Sint64");
  break;
case OP_ShlUint16Uint64:
  Text.Op = PrintName("ShlUint16Uint64");
  break;
case OP_ShlUint16IntAP:
  Text.Op = PrintName("ShlUint16IntAP");
  break;
case OP_ShlUint16IntAPS:
  Text.Op = PrintName("ShlUint16IntAPS");
  break;
case OP_ShlSint32Sint8:
  Text.Op = PrintName("ShlSint32Sint8");
  break;
case OP_ShlSint32Uint8:
  Text.Op = PrintName("ShlSint32Uint8");
  break;
case OP_ShlSint32Sint16:
  Text.Op = PrintName("ShlSint32Sint16");
  break;
case OP_ShlSint32Uint16:
  Text.Op = PrintName("ShlSint32Uint16");
  break;
case OP_ShlSint32Sint32:
  Text.Op = PrintName("ShlSint32Sint32");
  break;
case OP_ShlSint32Uint32:
  Text.Op = PrintName("ShlSint32Uint32");
  break;
case OP_ShlSint32Sint64:
  Text.Op = PrintName("ShlSint32Sint64");
  break;
case OP_ShlSint32Uint64:
  Text.Op = PrintName("ShlSint32Uint64");
  break;
case OP_ShlSint32IntAP:
  Text.Op = PrintName("ShlSint32IntAP");
  break;
case OP_ShlSint32IntAPS:
  Text.Op = PrintName("ShlSint32IntAPS");
  break;
case OP_ShlUint32Sint8:
  Text.Op = PrintName("ShlUint32Sint8");
  break;
case OP_ShlUint32Uint8:
  Text.Op = PrintName("ShlUint32Uint8");
  break;
case OP_ShlUint32Sint16:
  Text.Op = PrintName("ShlUint32Sint16");
  break;
case OP_ShlUint32Uint16:
  Text.Op = PrintName("ShlUint32Uint16");
  break;
case OP_ShlUint32Sint32:
  Text.Op = PrintName("ShlUint32Sint32");
  break;
case OP_ShlUint32Uint32:
  Text.Op = PrintName("ShlUint32Uint32");
  break;
case OP_ShlUint32Sint64:
  Text.Op = PrintName("ShlUint32Sint64");
  break;
case OP_ShlUint32Uint64:
  Text.Op = PrintName("ShlUint32Uint64");
  break;
case OP_ShlUint32IntAP:
  Text.Op = PrintName("ShlUint32IntAP");
  break;
case OP_ShlUint32IntAPS:
  Text.Op = PrintName("ShlUint32IntAPS");
  break;
case OP_ShlSint64Sint8:
  Text.Op = PrintName("ShlSint64Sint8");
  break;
case OP_ShlSint64Uint8:
  Text.Op = PrintName("ShlSint64Uint8");
  break;
case OP_ShlSint64Sint16:
  Text.Op = PrintName("ShlSint64Sint16");
  break;
case OP_ShlSint64Uint16:
  Text.Op = PrintName("ShlSint64Uint16");
  break;
case OP_ShlSint64Sint32:
  Text.Op = PrintName("ShlSint64Sint32");
  break;
case OP_ShlSint64Uint32:
  Text.Op = PrintName("ShlSint64Uint32");
  break;
case OP_ShlSint64Sint64:
  Text.Op = PrintName("ShlSint64Sint64");
  break;
case OP_ShlSint64Uint64:
  Text.Op = PrintName("ShlSint64Uint64");
  break;
case OP_ShlSint64IntAP:
  Text.Op = PrintName("ShlSint64IntAP");
  break;
case OP_ShlSint64IntAPS:
  Text.Op = PrintName("ShlSint64IntAPS");
  break;
case OP_ShlUint64Sint8:
  Text.Op = PrintName("ShlUint64Sint8");
  break;
case OP_ShlUint64Uint8:
  Text.Op = PrintName("ShlUint64Uint8");
  break;
case OP_ShlUint64Sint16:
  Text.Op = PrintName("ShlUint64Sint16");
  break;
case OP_ShlUint64Uint16:
  Text.Op = PrintName("ShlUint64Uint16");
  break;
case OP_ShlUint64Sint32:
  Text.Op = PrintName("ShlUint64Sint32");
  break;
case OP_ShlUint64Uint32:
  Text.Op = PrintName("ShlUint64Uint32");
  break;
case OP_ShlUint64Sint64:
  Text.Op = PrintName("ShlUint64Sint64");
  break;
case OP_ShlUint64Uint64:
  Text.Op = PrintName("ShlUint64Uint64");
  break;
case OP_ShlUint64IntAP:
  Text.Op = PrintName("ShlUint64IntAP");
  break;
case OP_ShlUint64IntAPS:
  Text.Op = PrintName("ShlUint64IntAPS");
  break;
case OP_ShlIntAPSint8:
  Text.Op = PrintName("ShlIntAPSint8");
  break;
case OP_ShlIntAPUint8:
  Text.Op = PrintName("ShlIntAPUint8");
  break;
case OP_ShlIntAPSint16:
  Text.Op = PrintName("ShlIntAPSint16");
  break;
case OP_ShlIntAPUint16:
  Text.Op = PrintName("ShlIntAPUint16");
  break;
case OP_ShlIntAPSint32:
  Text.Op = PrintName("ShlIntAPSint32");
  break;
case OP_ShlIntAPUint32:
  Text.Op = PrintName("ShlIntAPUint32");
  break;
case OP_ShlIntAPSint64:
  Text.Op = PrintName("ShlIntAPSint64");
  break;
case OP_ShlIntAPUint64:
  Text.Op = PrintName("ShlIntAPUint64");
  break;
case OP_ShlIntAPIntAP:
  Text.Op = PrintName("ShlIntAPIntAP");
  break;
case OP_ShlIntAPIntAPS:
  Text.Op = PrintName("ShlIntAPIntAPS");
  break;
case OP_ShlIntAPSSint8:
  Text.Op = PrintName("ShlIntAPSSint8");
  break;
case OP_ShlIntAPSUint8:
  Text.Op = PrintName("ShlIntAPSUint8");
  break;
case OP_ShlIntAPSSint16:
  Text.Op = PrintName("ShlIntAPSSint16");
  break;
case OP_ShlIntAPSUint16:
  Text.Op = PrintName("ShlIntAPSUint16");
  break;
case OP_ShlIntAPSSint32:
  Text.Op = PrintName("ShlIntAPSSint32");
  break;
case OP_ShlIntAPSUint32:
  Text.Op = PrintName("ShlIntAPSUint32");
  break;
case OP_ShlIntAPSSint64:
  Text.Op = PrintName("ShlIntAPSSint64");
  break;
case OP_ShlIntAPSUint64:
  Text.Op = PrintName("ShlIntAPSUint64");
  break;
case OP_ShlIntAPSIntAP:
  Text.Op = PrintName("ShlIntAPSIntAP");
  break;
case OP_ShlIntAPSIntAPS:
  Text.Op = PrintName("ShlIntAPSIntAPS");
  break;
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
bool emitShlSint8Sint8(SourceInfo);
bool emitShlSint8Uint8(SourceInfo);
bool emitShlSint8Sint16(SourceInfo);
bool emitShlSint8Uint16(SourceInfo);
bool emitShlSint8Sint32(SourceInfo);
bool emitShlSint8Uint32(SourceInfo);
bool emitShlSint8Sint64(SourceInfo);
bool emitShlSint8Uint64(SourceInfo);
bool emitShlSint8IntAP(SourceInfo);
bool emitShlSint8IntAPS(SourceInfo);
bool emitShlUint8Sint8(SourceInfo);
bool emitShlUint8Uint8(SourceInfo);
bool emitShlUint8Sint16(SourceInfo);
bool emitShlUint8Uint16(SourceInfo);
bool emitShlUint8Sint32(SourceInfo);
bool emitShlUint8Uint32(SourceInfo);
bool emitShlUint8Sint64(SourceInfo);
bool emitShlUint8Uint64(SourceInfo);
bool emitShlUint8IntAP(SourceInfo);
bool emitShlUint8IntAPS(SourceInfo);
bool emitShlSint16Sint8(SourceInfo);
bool emitShlSint16Uint8(SourceInfo);
bool emitShlSint16Sint16(SourceInfo);
bool emitShlSint16Uint16(SourceInfo);
bool emitShlSint16Sint32(SourceInfo);
bool emitShlSint16Uint32(SourceInfo);
bool emitShlSint16Sint64(SourceInfo);
bool emitShlSint16Uint64(SourceInfo);
bool emitShlSint16IntAP(SourceInfo);
bool emitShlSint16IntAPS(SourceInfo);
bool emitShlUint16Sint8(SourceInfo);
bool emitShlUint16Uint8(SourceInfo);
bool emitShlUint16Sint16(SourceInfo);
bool emitShlUint16Uint16(SourceInfo);
bool emitShlUint16Sint32(SourceInfo);
bool emitShlUint16Uint32(SourceInfo);
bool emitShlUint16Sint64(SourceInfo);
bool emitShlUint16Uint64(SourceInfo);
bool emitShlUint16IntAP(SourceInfo);
bool emitShlUint16IntAPS(SourceInfo);
bool emitShlSint32Sint8(SourceInfo);
bool emitShlSint32Uint8(SourceInfo);
bool emitShlSint32Sint16(SourceInfo);
bool emitShlSint32Uint16(SourceInfo);
bool emitShlSint32Sint32(SourceInfo);
bool emitShlSint32Uint32(SourceInfo);
bool emitShlSint32Sint64(SourceInfo);
bool emitShlSint32Uint64(SourceInfo);
bool emitShlSint32IntAP(SourceInfo);
bool emitShlSint32IntAPS(SourceInfo);
bool emitShlUint32Sint8(SourceInfo);
bool emitShlUint32Uint8(SourceInfo);
bool emitShlUint32Sint16(SourceInfo);
bool emitShlUint32Uint16(SourceInfo);
bool emitShlUint32Sint32(SourceInfo);
bool emitShlUint32Uint32(SourceInfo);
bool emitShlUint32Sint64(SourceInfo);
bool emitShlUint32Uint64(SourceInfo);
bool emitShlUint32IntAP(SourceInfo);
bool emitShlUint32IntAPS(SourceInfo);
bool emitShlSint64Sint8(SourceInfo);
bool emitShlSint64Uint8(SourceInfo);
bool emitShlSint64Sint16(SourceInfo);
bool emitShlSint64Uint16(SourceInfo);
bool emitShlSint64Sint32(SourceInfo);
bool emitShlSint64Uint32(SourceInfo);
bool emitShlSint64Sint64(SourceInfo);
bool emitShlSint64Uint64(SourceInfo);
bool emitShlSint64IntAP(SourceInfo);
bool emitShlSint64IntAPS(SourceInfo);
bool emitShlUint64Sint8(SourceInfo);
bool emitShlUint64Uint8(SourceInfo);
bool emitShlUint64Sint16(SourceInfo);
bool emitShlUint64Uint16(SourceInfo);
bool emitShlUint64Sint32(SourceInfo);
bool emitShlUint64Uint32(SourceInfo);
bool emitShlUint64Sint64(SourceInfo);
bool emitShlUint64Uint64(SourceInfo);
bool emitShlUint64IntAP(SourceInfo);
bool emitShlUint64IntAPS(SourceInfo);
bool emitShlIntAPSint8(SourceInfo);
bool emitShlIntAPUint8(SourceInfo);
bool emitShlIntAPSint16(SourceInfo);
bool emitShlIntAPUint16(SourceInfo);
bool emitShlIntAPSint32(SourceInfo);
bool emitShlIntAPUint32(SourceInfo);
bool emitShlIntAPSint64(SourceInfo);
bool emitShlIntAPUint64(SourceInfo);
bool emitShlIntAPIntAP(SourceInfo);
bool emitShlIntAPIntAPS(SourceInfo);
bool emitShlIntAPSSint8(SourceInfo);
bool emitShlIntAPSUint8(SourceInfo);
bool emitShlIntAPSSint16(SourceInfo);
bool emitShlIntAPSUint16(SourceInfo);
bool emitShlIntAPSSint32(SourceInfo);
bool emitShlIntAPSUint32(SourceInfo);
bool emitShlIntAPSSint64(SourceInfo);
bool emitShlIntAPSUint64(SourceInfo);
bool emitShlIntAPSIntAP(SourceInfo);
bool emitShlIntAPSIntAPS(SourceInfo);
#endif
#if defined(GET_EVAL_PROTO) || defined(GET_LINK_PROTO)
[[nodiscard]] bool emitShl(PrimType, PrimType, SourceInfo I);
#endif
#if defined(GET_EVAL_IMPL) || defined(GET_LINK_IMPL)
bool
#if defined(GET_EVAL_IMPL)
EvalEmitter
#else
ByteCodeEmitter
#endif
::emitShl(PrimType T0, PrimType T1, SourceInfo I) {
  switch (T0) {
  case PT_Sint8:
  switch (T1) {
  case PT_Sint8:
    return emitShlSint8Sint8(I);
  case PT_Uint8:
    return emitShlSint8Uint8(I);
  case PT_Sint16:
    return emitShlSint8Sint16(I);
  case PT_Uint16:
    return emitShlSint8Uint16(I);
  case PT_Sint32:
    return emitShlSint8Sint32(I);
  case PT_Uint32:
    return emitShlSint8Uint32(I);
  case PT_Sint64:
    return emitShlSint8Sint64(I);
  case PT_Uint64:
    return emitShlSint8Uint64(I);
  case PT_IntAP:
    return emitShlSint8IntAP(I);
  case PT_IntAPS:
    return emitShlSint8IntAPS(I);
  default: llvm_unreachable("invalid type: emitShl");
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint8:
  switch (T1) {
  case PT_Sint8:
    return emitShlUint8Sint8(I);
  case PT_Uint8:
    return emitShlUint8Uint8(I);
  case PT_Sint16:
    return emitShlUint8Sint16(I);
  case PT_Uint16:
    return emitShlUint8Uint16(I);
  case PT_Sint32:
    return emitShlUint8Sint32(I);
  case PT_Uint32:
    return emitShlUint8Uint32(I);
  case PT_Sint64:
    return emitShlUint8Sint64(I);
  case PT_Uint64:
    return emitShlUint8Uint64(I);
  case PT_IntAP:
    return emitShlUint8IntAP(I);
  case PT_IntAPS:
    return emitShlUint8IntAPS(I);
  default: llvm_unreachable("invalid type: emitShl");
  }
  llvm_unreachable("invalid enum value");
  case PT_Sint16:
  switch (T1) {
  case PT_Sint8:
    return emitShlSint16Sint8(I);
  case PT_Uint8:
    return emitShlSint16Uint8(I);
  case PT_Sint16:
    return emitShlSint16Sint16(I);
  case PT_Uint16:
    return emitShlSint16Uint16(I);
  case PT_Sint32:
    return emitShlSint16Sint32(I);
  case PT_Uint32:
    return emitShlSint16Uint32(I);
  case PT_Sint64:
    return emitShlSint16Sint64(I);
  case PT_Uint64:
    return emitShlSint16Uint64(I);
  case PT_IntAP:
    return emitShlSint16IntAP(I);
  case PT_IntAPS:
    return emitShlSint16IntAPS(I);
  default: llvm_unreachable("invalid type: emitShl");
  }
  llvm_unreachable("invalid enum value");
  case PT_Uint16:
  switch (T1) {
  case PT_Sint8:
    retu