/* rygel-http-get-handler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from rygel-http-get-handler.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Nokia Corporation.
 * Copyright (C) 2010 Andreas Henriksson <andreas@fatal.se>
 * Copyright (C) 2013 Cable Television Laboratories, Inc.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *         Craig Pratt <craig@ecaspia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "rygel-server.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsoup/soup.h>
#include <glib-object.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	RYGEL_HTTP_GET_HANDLER_0_PROPERTY,
	RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY,
	RYGEL_HTTP_GET_HANDLER_NUM_PROPERTIES
};
static GParamSpec* rygel_http_get_handler_properties[RYGEL_HTTP_GET_HANDLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

struct _RygelHTTPGetHandlerPrivate {
	GCancellable* _cancellable;
};

static gint RygelHTTPGetHandler_private_offset;
static gpointer rygel_http_get_handler_parent_class = NULL;

static void rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self,
                                                       RygelHTTPGet* request,
                                                       GError** error);
VALA_EXTERN GType rygel_client_hacks_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void rygel_client_hacks_modify_headers (RygelClientHacks* self,
                                        RygelHTTPRequest* request);
static gchar* rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self,
                                                             const gchar* mode);
static gint64 rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self);
static gint64 rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self);
static gboolean rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self);
static RygelHTTPResponse* rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self,
                                                            RygelHTTPGet* request,
                                                            GError** error);
static void rygel_http_get_handler_finalize (GObject * obj);
static GType rygel_http_get_handler_get_type_once (void);
static void _vala_rygel_http_get_handler_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_rygel_http_get_handler_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
rygel_http_get_handler_get_instance_private (RygelHTTPGetHandler* self)
{
	return G_STRUCT_MEMBER_P (self, RygelHTTPGetHandler_private_offset);
}

/**
     * Invokes the handler to add response headers to/for the given HTTP request
     */
static void
rygel_http_get_handler_real_add_response_headers (RygelHTTPGetHandler* self,
                                                  RygelHTTPGet* request,
                                                  GError** error)
{
	gchar* mode = NULL;
	SoupServerMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	SoupServerMessage* _tmp6_;
	SoupMessageHeaders* _tmp7_;
	const gchar* _tmp8_;
	RygelClientHacks* _tmp9_;
	g_return_if_fail (request != NULL);
	_tmp0_ = ((RygelHTTPRequest*) request)->msg;
	_tmp1_ = soup_server_message_get_request_headers (_tmp0_);
	_tmp2_ = soup_message_headers_get_one (_tmp1_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER);
	_tmp3_ = g_strdup (_tmp2_);
	mode = _tmp3_;
	_tmp4_ = mode;
	if (_tmp4_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = rygel_http_get_handler_get_default_transfer_mode (self);
		_g_free0 (mode);
		mode = _tmp5_;
	}
	_tmp6_ = ((RygelHTTPRequest*) request)->msg;
	_tmp7_ = soup_server_message_get_response_headers (_tmp6_);
	_tmp8_ = mode;
	soup_message_headers_append (_tmp7_, RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_HEADER, _tmp8_);
	_tmp9_ = ((RygelHTTPRequest*) request)->hack;
	if (_tmp9_ != NULL) {
		RygelClientHacks* _tmp10_;
		_tmp10_ = ((RygelHTTPRequest*) request)->hack;
		rygel_client_hacks_modify_headers (_tmp10_, (RygelHTTPRequest*) request);
	}
	_g_free0 (mode);
}

void
rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self,
                                             RygelHTTPGet* request,
                                             GError** error)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->add_response_headers) {
		_klass_->add_response_headers (self, request, error);
	}
}

/**
     * Returns the default transfer mode for the handler.
     * The default is "Interactive"
     */
static gchar*
rygel_http_get_handler_real_get_default_transfer_mode (RygelHTTPGetHandler* self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup (RYGEL_HTTP_GET_HANDLER_TRANSFER_MODE_INTERACTIVE);
	result = _tmp0_;
	return result;
}

gchar*
rygel_http_get_handler_get_default_transfer_mode (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->get_default_transfer_mode) {
		return _klass_->get_default_transfer_mode (self);
	}
	return NULL;
}

/**
     * Returns true if the handler supports the given transfer mode, false
     * otherwise.
     */
static gboolean
rygel_http_get_handler_real_supports_transfer_mode (RygelHTTPGetHandler* self,
                                                    const gchar* mode)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_supports_transfer_mode'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
rygel_http_get_handler_supports_transfer_mode (RygelHTTPGetHandler* self,
                                               const gchar* mode)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->supports_transfer_mode) {
		return _klass_->supports_transfer_mode (self, mode);
	}
	return FALSE;
}

/**
     * Returns the resource size or -1 if not known.
     */
static gint64
rygel_http_get_handler_real_get_resource_size (RygelHTTPGetHandler* self)
{
	gint64 _tmp0_ = 0LL;
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_get_resource_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gint64
rygel_http_get_handler_get_resource_size (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->get_resource_size) {
		return _klass_->get_resource_size (self);
	}
	return -1LL;
}

/**
     * Returns the resource duration (in microseconds) or -1 if not known.
     */
static gint64
rygel_http_get_handler_real_get_resource_duration (RygelHTTPGetHandler* self)
{
	gint64 result;
	result = (gint64) -1;
	return result;
}

gint64
rygel_http_get_handler_get_resource_duration (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->get_resource_duration) {
		return _klass_->get_resource_duration (self);
	}
	return -1LL;
}

/**
     * Returns true if the handler supports full random-access byte seek.
     */
static gboolean
rygel_http_get_handler_real_supports_byte_seek (RygelHTTPGetHandler* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
rygel_http_get_handler_supports_byte_seek (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->supports_byte_seek) {
		return _klass_->supports_byte_seek (self);
	}
	return FALSE;
}

/**
     * Returns true if the handler supports full random-access time seek.
     */
static gboolean
rygel_http_get_handler_real_supports_time_seek (RygelHTTPGetHandler* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
rygel_http_get_handler_supports_time_seek (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->supports_time_seek) {
		return _klass_->supports_time_seek (self);
	}
	return FALSE;
}

/**
     * Returns true if the handler supports any play speed requests.
     */
static gboolean
rygel_http_get_handler_real_supports_playspeed (RygelHTTPGetHandler* self)
{
	gboolean result;
	result = FALSE;
	return result;
}

gboolean
rygel_http_get_handler_supports_playspeed (RygelHTTPGetHandler* self)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->supports_playspeed) {
		return _klass_->supports_playspeed (self);
	}
	return FALSE;
}

/**
     * Create an HTTPResponse object that will render the body.
     */
static RygelHTTPResponse*
rygel_http_get_handler_real_render_body (RygelHTTPGetHandler* self,
                                         RygelHTTPGet* request,
                                         GError** error)
{
	g_critical ("Type `%s' does not implement abstract method `rygel_http_get_handler_render_body'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

RygelHTTPResponse*
rygel_http_get_handler_render_body (RygelHTTPGetHandler* self,
                                    RygelHTTPGet* request,
                                    GError** error)
{
	RygelHTTPGetHandlerClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = RYGEL_HTTP_GET_HANDLER_GET_CLASS (self);
	if (_klass_->render_body) {
		return _klass_->render_body (self, request, error);
	}
	return NULL;
}

RygelHTTPGetHandler*
rygel_http_get_handler_construct (GType object_type)
{
	RygelHTTPGetHandler * self = NULL;
	self = (RygelHTTPGetHandler*) g_object_new (object_type, NULL);
	return self;
}

GCancellable*
rygel_http_get_handler_get_cancellable (RygelHTTPGetHandler* self)
{
	GCancellable* result;
	GCancellable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_cancellable;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self,
                                        GCancellable* value)
{
	GCancellable* old_value;
	g_return_if_fail (self != NULL);
	old_value = rygel_http_get_handler_get_cancellable (self);
	if (old_value != value) {
		GCancellable* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_cancellable);
		self->priv->_cancellable = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, rygel_http_get_handler_properties[RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY]);
	}
}

static void
rygel_http_get_handler_class_init (RygelHTTPGetHandlerClass * klass,
                                   gpointer klass_data)
{
	rygel_http_get_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RygelHTTPGetHandler_private_offset);
	((RygelHTTPGetHandlerClass *) klass)->add_response_headers = (void (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_get_handler_real_add_response_headers;
	((RygelHTTPGetHandlerClass *) klass)->get_default_transfer_mode = (gchar* (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_get_default_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->supports_transfer_mode = (gboolean (*) (RygelHTTPGetHandler*, const gchar*)) rygel_http_get_handler_real_supports_transfer_mode;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_size = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_get_resource_size;
	((RygelHTTPGetHandlerClass *) klass)->get_resource_duration = (gint64 (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_get_resource_duration;
	((RygelHTTPGetHandlerClass *) klass)->supports_byte_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_supports_byte_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_time_seek = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_supports_time_seek;
	((RygelHTTPGetHandlerClass *) klass)->supports_playspeed = (gboolean (*) (RygelHTTPGetHandler*)) rygel_http_get_handler_real_supports_playspeed;
	((RygelHTTPGetHandlerClass *) klass)->render_body = (RygelHTTPResponse* (*) (RygelHTTPGetHandler*, RygelHTTPGet*, GError**)) rygel_http_get_handler_real_render_body;
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_http_get_handler_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_http_get_handler_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_handler_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY, rygel_http_get_handler_properties[RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY] = g_param_spec_object ("cancellable", "cancellable", "cancellable", g_cancellable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
rygel_http_get_handler_instance_init (RygelHTTPGetHandler * self,
                                      gpointer klass)
{
	self->priv = rygel_http_get_handler_get_instance_private (self);
}

static void
rygel_http_get_handler_finalize (GObject * obj)
{
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_get_handler_parent_class)->finalize (obj);
}

/**
 * HTTP GET request handler interface.
 */
 G_GNUC_NO_INLINE static GType
rygel_http_get_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGetHandler), 0, (GInstanceInitFunc) rygel_http_get_handler_instance_init, NULL };
	GType rygel_http_get_handler_type_id;
	rygel_http_get_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGetHandler", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	RygelHTTPGetHandler_private_offset = g_type_add_instance_private (rygel_http_get_handler_type_id, sizeof (RygelHTTPGetHandlerPrivate));
	return rygel_http_get_handler_type_id;
}

GType
rygel_http_get_handler_get_type (void)
{
	static volatile gsize rygel_http_get_handler_type_id__once = 0;
	if (g_once_init_enter (&rygel_http_get_handler_type_id__once)) {
		GType rygel_http_get_handler_type_id;
		rygel_http_get_handler_type_id = rygel_http_get_handler_get_type_once ();
		g_once_init_leave (&rygel_http_get_handler_type_id__once, rygel_http_get_handler_type_id);
	}
	return rygel_http_get_handler_type_id__once;
}

static void
_vala_rygel_http_get_handler_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	switch (property_id) {
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY:
		g_value_set_object (value, rygel_http_get_handler_get_cancellable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_rygel_http_get_handler_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	RygelHTTPGetHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler);
	switch (property_id) {
		case RYGEL_HTTP_GET_HANDLER_CANCELLABLE_PROPERTY:
		rygel_http_get_handler_set_cancellable (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

