
/* Python wrapper functions auto-generated by pidl */
#define PY_SSIZE_T_CLEAN 1 /* We use Py_ssize_t for PyArg_ParseTupleAndKeywords */
#include "lib/replace/system/python.h"
#include "python/py3compat.h"
#include "includes.h"
#include "python/modules.h"
#include <pytalloc.h>
#include "librpc/rpc/pyrpc.h"
#include "librpc/rpc/pyrpc_util.h"
#include "bin/default/librpc/gen_ndr/ndr_dcerpc.h"


/*
 * Suppress compiler warnings if the generated code does not call these
 * functions
 */
#ifndef _MAYBE_UNUSED_
#ifdef __has_attribute
#if __has_attribute(unused)
#define _MAYBE_UNUSED_ __attribute__ ((unused))
#else
#define _MAYBE_UNUSED_
#endif
#endif
#endif
/*
 * These functions are here to ensure they can be optimized out by
 * the compiler based on the constant input values
 */

static inline unsigned long long ndr_sizeof2uintmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return UINT64_MAX;
	case 4:
		return UINT32_MAX;
	case 2:
		return UINT16_MAX;
	case 1:
		return UINT8_MAX;
	}

	return 0;
}

static inline _MAYBE_UNUSED_ long long ndr_sizeof2intmax(size_t var_size)
{
	switch (var_size) {
	case 8:
		return INT64_MAX;
	case 4:
		return INT32_MAX;
	case 2:
		return INT16_MAX;
	case 1:
		return INT8_MAX;
	}

	return 0;
}

#include "librpc/gen_ndr/misc.h"
static PyTypeObject dcerpc_ctx_list_Type;
static PyTypeObject dcerpc_bind_Type;
static PyTypeObject dcerpc_empty_Type;
static PyTypeObject dcerpc_object_Type;
static PyTypeObject dcerpc_request_Type;
static PyTypeObject dcerpc_bind_ack_reason_Type;
static PyTypeObject dcerpc_ack_ctx_Type;
static PyTypeObject dcerpc_bind_ack_Type;
static PyTypeObject dcerpc_bind_nak_version_Type;
static PyTypeObject dcerpc_bind_nak_Type;
static PyTypeObject dcerpc_response_Type;
static PyTypeObject dcerpc_fault_Type;
static PyTypeObject dcerpc_auth_Type;
static PyTypeObject dcerpc_auth3_Type;
static PyTypeObject dcerpc_orphaned_Type;
static PyTypeObject dcerpc_co_cancel_Type;
static PyTypeObject dcerpc_cl_cancel_Type;
static PyTypeObject dcerpc_cancel_ack_Type;
static PyTypeObject dcerpc_fack_Type;
static PyTypeObject dcerpc_ack_Type;
static PyTypeObject dcerpc_ping_Type;
static PyTypeObject dcerpc_shutdown_Type;
static PyTypeObject dcerpc_working_Type;
static PyTypeObject RTSCookie_Type;
static PyTypeObject ClientAddressType_Type;
static PyTypeObject ClientAddress_Type;
static PyTypeObject FlowControlAcknowledgment_Type;
static PyTypeObject dcerpc_rts_cmd_ReceiveWindowSize_Type;
static PyTypeObject dcerpc_rts_cmd_FlowControlAck_Type;
static PyTypeObject dcerpc_rts_cmd_ConnectionTimeout_Type;
static PyTypeObject dcerpc_rts_cmd_Cookie_Type;
static PyTypeObject dcerpc_rts_cmd_ChannelLifetime_Type;
static PyTypeObject dcerpc_rts_cmd_ClientKeepalive_Type;
static PyTypeObject dcerpc_rts_cmd_Version_Type;
static PyTypeObject dcerpc_rts_cmd_Empty_Type;
static PyTypeObject dcerpc_rts_cmd_Padding_Type;
static PyTypeObject dcerpc_rts_cmd_NegativeANCE_Type;
static PyTypeObject dcerpc_rts_cmd_ANCE_Type;
static PyTypeObject dcerpc_rts_cmd_ClientAddress_Type;
static PyTypeObject dcerpc_rts_cmd_AssociationGroupId_Type;
static PyTypeObject dcerpc_rts_cmd_Destination_Type;
static PyTypeObject dcerpc_rts_cmd_PingTrafficSentNotify_Type;
static PyTypeObject dcerpc_rts_cmds_Type;
static PyTypeObject dcerpc_rts_cmd_Type;
static PyTypeObject dcerpc_rts_Type;
static PyTypeObject dcerpc_payload_Type;
static PyTypeObject ncacn_packet_Type;
static PyTypeObject ncadg_packet_Type;
static PyTypeObject dcerpc_sec_vt_pcontext_Type;
static PyTypeObject dcerpc_sec_vt_header2_Type;
static PyTypeObject dcerpc_sec_vt_union_Type;
static PyTypeObject dcerpc_sec_vt_Type;
static PyTypeObject dcerpc_sec_vt_count_Type;
static PyTypeObject dcerpc_sec_verification_trailer_Type;

static PyTypeObject *ndr_syntax_id_Type;
static PyTypeObject *BaseObject_Type;
static PyTypeObject *GUID_Type;

static PyObject *py_dcerpc_ctx_list_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyLong_FromLong((uint16_t)(object->context_id));
	return py_context_id;
}

static int py_dcerpc_ctx_list_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_num_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(obj);
	PyObject *py_num_transfer_syntaxes;
	py_num_transfer_syntaxes = PyLong_FromLong((uint16_t)(object->num_transfer_syntaxes));
	return py_num_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_num_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_transfer_syntaxes");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_transfer_syntaxes));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_transfer_syntaxes = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_abstract_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(obj);
	PyObject *py_abstract_syntax;
	py_abstract_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->abstract_syntax);
	return py_abstract_syntax;
}

static int py_dcerpc_ctx_list_set_abstract_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->abstract_syntax");
		return -1;
	}
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->abstract_syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dcerpc_ctx_list_get_transfer_syntaxes(PyObject *obj, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(obj);
	PyObject *py_transfer_syntaxes;
	py_transfer_syntaxes = PyList_New(object->num_transfer_syntaxes);
	if (py_transfer_syntaxes == NULL) {
		return NULL;
	}
	{
		int transfer_syntaxes_cntr_0;
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < (object->num_transfer_syntaxes); transfer_syntaxes_cntr_0++) {
			PyObject *py_transfer_syntaxes_0;
			py_transfer_syntaxes_0 = pytalloc_reference_ex(ndr_syntax_id_Type, object->transfer_syntaxes, &(object->transfer_syntaxes)[transfer_syntaxes_cntr_0]);
			PyList_SetItem(py_transfer_syntaxes, transfer_syntaxes_cntr_0, py_transfer_syntaxes_0);
		}
	}
	return py_transfer_syntaxes;
}

static int py_dcerpc_ctx_list_set_transfer_syntaxes(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ctx_list *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transfer_syntaxes");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int transfer_syntaxes_cntr_0;
		object->transfer_syntaxes = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->transfer_syntaxes, PyList_GET_SIZE(value));
		if (!object->transfer_syntaxes) { return -1; }
		talloc_set_name_const(object->transfer_syntaxes, "ARRAY: object->transfer_syntaxes");
		for (transfer_syntaxes_cntr_0 = 0; transfer_syntaxes_cntr_0 < PyList_GET_SIZE(value); transfer_syntaxes_cntr_0++) {
			if (PyList_GET_ITEM(value, transfer_syntaxes_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->transfer_syntaxes)[transfer_syntaxes_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(ndr_syntax_id_Type, PyList_GET_ITEM(value, transfer_syntaxes_cntr_0), return -1;);
			if (talloc_reference(object->transfer_syntaxes, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, transfer_syntaxes_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->transfer_syntaxes)[transfer_syntaxes_cntr_0] = *(struct ndr_syntax_id *)pytalloc_get_ptr(PyList_GET_ITEM(value, transfer_syntaxes_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_ctx_list_getsetters[] = {
	{
		.name = discard_const_p(char, "context_id"),
		.get = py_dcerpc_ctx_list_get_context_id,
		.set = py_dcerpc_ctx_list_set_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "num_transfer_syntaxes"),
		.get = py_dcerpc_ctx_list_get_num_transfer_syntaxes,
		.set = py_dcerpc_ctx_list_set_num_transfer_syntaxes,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "abstract_syntax"),
		.get = py_dcerpc_ctx_list_get_abstract_syntax,
		.set = py_dcerpc_ctx_list_set_abstract_syntax,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{
		.name = discard_const_p(char, "transfer_syntaxes"),
		.get = py_dcerpc_ctx_list_get_transfer_syntaxes,
		.set = py_dcerpc_ctx_list_set_transfer_syntaxes,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_ctx_list_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ctx_list, type);
}


static PyTypeObject dcerpc_ctx_list_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ctx_list",
	.tp_getset = py_dcerpc_ctx_list_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ctx_list_new,
};


static PyObject *py_dcerpc_bind_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyLong_FromLong((uint16_t)(object->max_xmit_frag));
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_xmit_frag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_xmit_frag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_xmit_frag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyLong_FromLong((uint16_t)(object->max_recv_frag));
	return py_max_recv_frag;
}

static int py_dcerpc_bind_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_recv_frag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_recv_frag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_recv_frag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyLong_FromUnsignedLongLong((uint32_t)(object->assoc_group_id));
	return py_assoc_group_id;
}

static int py_dcerpc_bind_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->assoc_group_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->assoc_group_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->assoc_group_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_num_contexts(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_num_contexts;
	py_num_contexts = PyLong_FromLong((uint16_t)(object->num_contexts));
	return py_num_contexts;
}

static int py_dcerpc_bind_set_num_contexts(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_contexts");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_contexts));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_contexts = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_contexts);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < (object->num_contexts); ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = pytalloc_reference_ex(&dcerpc_ctx_list_Type, object->ctx_list, &(object->ctx_list)[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctx_list");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ctx_list, PyList_GET_SIZE(value));
		if (!object->ctx_list) { return -1; }
		talloc_set_name_const(object->ctx_list, "ARRAY: object->ctx_list");
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_GET_SIZE(value); ctx_list_cntr_0++) {
			if (PyList_GET_ITEM(value, ctx_list_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ctx_list)[ctx_list_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dcerpc_ctx_list_Type, PyList_GET_ITEM(value, ctx_list_cntr_0), return -1;);
			if (talloc_reference(object->ctx_list, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ctx_list_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->ctx_list)[ctx_list_cntr_0] = *(struct dcerpc_ctx_list *)pytalloc_get_ptr(PyList_GET_ITEM(value, ctx_list_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyBytes_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_info");
		return -1;
	}
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_getsetters[] = {
	{
		.name = discard_const_p(char, "max_xmit_frag"),
		.get = py_dcerpc_bind_get_max_xmit_frag,
		.set = py_dcerpc_bind_set_max_xmit_frag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_recv_frag"),
		.get = py_dcerpc_bind_get_max_recv_frag,
		.set = py_dcerpc_bind_set_max_recv_frag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "assoc_group_id"),
		.get = py_dcerpc_bind_get_assoc_group_id,
		.set = py_dcerpc_bind_set_assoc_group_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "num_contexts"),
		.get = py_dcerpc_bind_get_num_contexts,
		.set = py_dcerpc_bind_set_num_contexts,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ctx_list"),
		.get = py_dcerpc_bind_get_ctx_list,
		.set = py_dcerpc_bind_set_ctx_list,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_ctx_list")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_dcerpc_bind_get_auth_info,
		.set = py_dcerpc_bind_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_bind_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind, type);
}

static PyObject *py_dcerpc_bind_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_bind);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_bind_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_bind_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind, "dcerpc_bind", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind, "dcerpc_bind", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_bind_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_bind_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_bind_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.bind",
	.tp_getset = py_dcerpc_bind_getsetters,
	.tp_methods = py_dcerpc_bind_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_new,
};


static PyObject *py_dcerpc_empty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_empty, type);
}


static PyTypeObject dcerpc_empty_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.empty",
	.tp_getset = NULL,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_empty_new,
};

static PyObject *py_import_dcerpc_object(TALLOC_CTX *mem_ctx, int level, union dcerpc_object *in)
{
	PyObject *ret;

	switch (level) {
		default:
			ret = pytalloc_reference_ex(GUID_Type, mem_ctx, &in->object);
			return ret;

		case false:
			ret = pytalloc_reference_ex(&dcerpc_empty_Type, mem_ctx, &in->empty);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dcerpc_object *py_export_dcerpc_object(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_object *ret = talloc_zero(mem_ctx, union dcerpc_object);
	switch (level) {
		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->object");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(GUID_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->object = *(struct GUID *)pytalloc_get_ptr(in);
			break;

		case false:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->empty");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_empty_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->empty = *(struct dcerpc_empty *)pytalloc_get_ptr(in);
			break;

	}

	return ret;
}

static PyObject *py_dcerpc_object_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dcerpc_object *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dcerpc_object *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dcerpc_object!");
		return NULL;
	}

	return py_import_dcerpc_object(mem_ctx, level, in);
}

static PyObject *py_dcerpc_object_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dcerpc_object *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dcerpc_object(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dcerpc_object_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_object_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_object_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dcerpc_object_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dcerpc_object_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.object",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_object_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_object_new,
};


static PyObject *py_dcerpc_request_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyLong_FromUnsignedLongLong((uint32_t)(object->alloc_hint));
	return py_alloc_hint;
}

static int py_dcerpc_request_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alloc_hint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alloc_hint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alloc_hint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_request_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyLong_FromLong((uint16_t)(object->context_id));
	return py_context_id;
}

static int py_dcerpc_request_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_request_get_opnum(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyLong_FromLong((uint16_t)(object->opnum));
	return py_opnum;
}

static int py_dcerpc_request_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_request_get_object(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pyrpc_import_union(&dcerpc_object_Type, pytalloc_get_mem_ctx(obj), NDR_DCERPC_REQUEST_OBJECT_PRESENT, &object->object, "union dcerpc_object");
	if (py_object == NULL) {
		return NULL;
	}
	return py_object;
}

static int py_dcerpc_request_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	{
		union dcerpc_object *object_switch_0;
		object_switch_0 = (union dcerpc_object *)pyrpc_export_union(&dcerpc_object_Type, pytalloc_get_mem_ctx(py_obj), NDR_DCERPC_REQUEST_OBJECT_PRESENT, value, "union dcerpc_object");
		if (object_switch_0 == NULL) {
			return -1;
		}
		object->object = *object_switch_0;
	}
	return 0;
}

static PyObject *py_dcerpc_request_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyBytes_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_request_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_request *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->stub_and_verifier");
		return -1;
	}
	object->stub_and_verifier = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_request_getsetters[] = {
	{
		.name = discard_const_p(char, "alloc_hint"),
		.get = py_dcerpc_request_get_alloc_hint,
		.set = py_dcerpc_request_set_alloc_hint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "context_id"),
		.get = py_dcerpc_request_get_context_id,
		.set = py_dcerpc_request_set_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "opnum"),
		.get = py_dcerpc_request_get_opnum,
		.set = py_dcerpc_request_set_opnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_dcerpc_request_get_object,
		.set = py_dcerpc_request_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_object")
	},
	{
		.name = discard_const_p(char, "stub_and_verifier"),
		.get = py_dcerpc_request_get_stub_and_verifier,
		.set = py_dcerpc_request_set_stub_and_verifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_request_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_request, type);
}


static PyTypeObject dcerpc_request_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.request",
	.tp_getset = py_dcerpc_request_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_request_new,
};

static PyObject *py_import_dcerpc_bind_ack_reason(TALLOC_CTX *mem_ctx, int level, union dcerpc_bind_ack_reason *in)
{
	PyObject *ret;

	switch (level) {
		case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK:
			ret = PyLong_FromLong((uint16_t)(in->negotiate));
			return ret;

		default:
			ret = PyLong_FromLong((uint16_t)(in->value));
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dcerpc_bind_ack_reason *py_export_dcerpc_bind_ack_reason(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_bind_ack_reason *ret = talloc_zero(mem_ctx, union dcerpc_bind_ack_reason);
	switch (level) {
		case DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->negotiate");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->negotiate));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->negotiate = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->value");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->value));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->value = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

	}

	return ret;
}

static PyObject *py_dcerpc_bind_ack_reason_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dcerpc_bind_ack_reason *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dcerpc_bind_ack_reason *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dcerpc_bind_ack_reason!");
		return NULL;
	}

	return py_import_dcerpc_bind_ack_reason(mem_ctx, level, in);
}

static PyObject *py_dcerpc_bind_ack_reason_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dcerpc_bind_ack_reason *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dcerpc_bind_ack_reason(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dcerpc_bind_ack_reason_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_ack_reason_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_ack_reason_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dcerpc_bind_ack_reason_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dcerpc_bind_ack_reason_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.bind_ack_reason",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_bind_ack_reason_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_ack_reason_new,
};


static PyObject *py_dcerpc_ack_ctx_get_result(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(obj);
	PyObject *py_result;
	py_result = PyLong_FromLong((uint16_t)(object->result));
	return py_result;
}

static int py_dcerpc_ack_ctx_set_result(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->result");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->result));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->result = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_reason(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(obj);
	PyObject *py_reason;
	py_reason = pyrpc_import_union(&dcerpc_bind_ack_reason_Type, pytalloc_get_mem_ctx(obj), object->result, &object->reason, "union dcerpc_bind_ack_reason");
	if (py_reason == NULL) {
		return NULL;
	}
	return py_reason;
}

static int py_dcerpc_ack_ctx_set_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reason");
		return -1;
	}
	{
		union dcerpc_bind_ack_reason *reason_switch_0;
		reason_switch_0 = (union dcerpc_bind_ack_reason *)pyrpc_export_union(&dcerpc_bind_ack_reason_Type, pytalloc_get_mem_ctx(py_obj), object->result, value, "union dcerpc_bind_ack_reason");
		if (reason_switch_0 == NULL) {
			return -1;
		}
		object->reason = *reason_switch_0;
	}
	return 0;
}

static PyObject *py_dcerpc_ack_ctx_get_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(obj);
	PyObject *py_syntax;
	py_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->syntax);
	return py_syntax;
}

static int py_dcerpc_ack_ctx_set_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_ack_ctx *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->syntax");
		return -1;
	}
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_ack_ctx_getsetters[] = {
	{
		.name = discard_const_p(char, "result"),
		.get = py_dcerpc_ack_ctx_get_result,
		.set = py_dcerpc_ack_ctx_set_result,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_bind_ack_result")
	},
	{
		.name = discard_const_p(char, "reason"),
		.get = py_dcerpc_ack_ctx_get_reason,
		.set = py_dcerpc_ack_ctx_set_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_bind_ack_reason")
	},
	{
		.name = discard_const_p(char, "syntax"),
		.get = py_dcerpc_ack_ctx_get_syntax,
		.set = py_dcerpc_ack_ctx_set_syntax,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_ack_ctx_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ack_ctx, type);
}


static PyTypeObject dcerpc_ack_ctx_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ack_ctx",
	.tp_getset = py_dcerpc_ack_ctx_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ack_ctx_new,
};


static PyObject *py_dcerpc_bind_ack_get_max_xmit_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_max_xmit_frag;
	py_max_xmit_frag = PyLong_FromLong((uint16_t)(object->max_xmit_frag));
	return py_max_xmit_frag;
}

static int py_dcerpc_bind_ack_set_max_xmit_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_xmit_frag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_xmit_frag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_xmit_frag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_max_recv_frag(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_max_recv_frag;
	py_max_recv_frag = PyLong_FromLong((uint16_t)(object->max_recv_frag));
	return py_max_recv_frag;
}

static int py_dcerpc_bind_ack_set_max_recv_frag(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_recv_frag");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_recv_frag));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_recv_frag = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_assoc_group_id(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_assoc_group_id;
	py_assoc_group_id = PyLong_FromUnsignedLongLong((uint32_t)(object->assoc_group_id));
	return py_assoc_group_id;
}

static int py_dcerpc_bind_ack_set_assoc_group_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->assoc_group_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->assoc_group_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->assoc_group_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address_size(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_secondary_address_size;
	py_secondary_address_size = PyLong_FromLong((uint16_t)(object->secondary_address_size));
	return py_secondary_address_size;
}

static int py_dcerpc_bind_ack_set_secondary_address_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->secondary_address_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->secondary_address_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->secondary_address_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_secondary_address(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_secondary_address;
	if (object->secondary_address == NULL) {
		py_secondary_address = Py_None;
		Py_INCREF(py_secondary_address);
	} else {
		py_secondary_address = PyUnicode_Decode(object->secondary_address, strlen(object->secondary_address), "utf-8", "ignore");
	}
	return py_secondary_address;
}

static int py_dcerpc_bind_ack_set_secondary_address(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->secondary_address");
		return -1;
	}
	{
		const char *test_str;
		const char *talloc_str;
		PyObject *unicode = NULL;
		if (PyUnicode_Check(value)) {
			unicode = PyUnicode_AsEncodedString(value, "utf-8", "ignore");
			if (unicode == NULL) {
				return -1;
			}
			test_str = PyBytes_AS_STRING(unicode);
		} else if (PyBytes_Check(value)) {
			test_str = PyBytes_AS_STRING(value);
		} else {
			PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(value)->tp_name);
			return -1;
		}
		talloc_str = talloc_strdup(pytalloc_get_mem_ctx(py_obj), test_str);
		if (unicode != NULL) {
			Py_DECREF(unicode);
		}
		if (talloc_str == NULL) {
			PyErr_NoMemory();
			return -1;
		}
		object->secondary_address = talloc_str;
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyBytes_FromStringAndSize((char *)(object->_pad1).data, (object->_pad1).length);
	return py__pad1;
}

static int py_dcerpc_bind_ack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad1");
		return -1;
	}
	object->_pad1 = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_num_results(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_num_results;
	py_num_results = PyLong_FromLong((uint16_t)(object->num_results));
	return py_num_results;
}

static int py_dcerpc_bind_ack_set_num_results(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_results");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_results));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_results = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_ctx_list(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_ctx_list;
	py_ctx_list = PyList_New(object->num_results);
	if (py_ctx_list == NULL) {
		return NULL;
	}
	{
		int ctx_list_cntr_0;
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < (object->num_results); ctx_list_cntr_0++) {
			PyObject *py_ctx_list_0;
			py_ctx_list_0 = pytalloc_reference_ex(&dcerpc_ack_ctx_Type, object->ctx_list, &(object->ctx_list)[ctx_list_cntr_0]);
			PyList_SetItem(py_ctx_list, ctx_list_cntr_0, py_ctx_list_0);
		}
	}
	return py_ctx_list;
}

static int py_dcerpc_bind_ack_set_ctx_list(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ctx_list");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int ctx_list_cntr_0;
		object->ctx_list = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->ctx_list, PyList_GET_SIZE(value));
		if (!object->ctx_list) { return -1; }
		talloc_set_name_const(object->ctx_list, "ARRAY: object->ctx_list");
		for (ctx_list_cntr_0 = 0; ctx_list_cntr_0 < PyList_GET_SIZE(value); ctx_list_cntr_0++) {
			if (PyList_GET_ITEM(value, ctx_list_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->ctx_list)[ctx_list_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dcerpc_ack_ctx_Type, PyList_GET_ITEM(value, ctx_list_cntr_0), return -1;);
			if (talloc_reference(object->ctx_list, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, ctx_list_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->ctx_list)[ctx_list_cntr_0] = *(struct dcerpc_ack_ctx *)pytalloc_get_ptr(PyList_GET_ITEM(value, ctx_list_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_ack_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyBytes_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_bind_ack_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_info");
		return -1;
	}
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_ack_getsetters[] = {
	{
		.name = discard_const_p(char, "max_xmit_frag"),
		.get = py_dcerpc_bind_ack_get_max_xmit_frag,
		.set = py_dcerpc_bind_ack_set_max_xmit_frag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_recv_frag"),
		.get = py_dcerpc_bind_ack_get_max_recv_frag,
		.set = py_dcerpc_bind_ack_set_max_recv_frag,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "assoc_group_id"),
		.get = py_dcerpc_bind_ack_get_assoc_group_id,
		.set = py_dcerpc_bind_ack_set_assoc_group_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "secondary_address_size"),
		.get = py_dcerpc_bind_ack_get_secondary_address_size,
		.set = py_dcerpc_bind_ack_set_secondary_address_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "secondary_address"),
		.get = py_dcerpc_bind_ack_get_secondary_address,
		.set = py_dcerpc_bind_ack_set_secondary_address,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "_pad1"),
		.get = py_dcerpc_bind_ack_get__pad1,
		.set = py_dcerpc_bind_ack_set__pad1,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "num_results"),
		.get = py_dcerpc_bind_ack_get_num_results,
		.set = py_dcerpc_bind_ack_set_num_results,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ctx_list"),
		.get = py_dcerpc_bind_ack_get_ctx_list,
		.set = py_dcerpc_bind_ack_set_ctx_list,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_ack_ctx")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_dcerpc_bind_ack_get_auth_info,
		.set = py_dcerpc_bind_ack_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_bind_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_ack, type);
}


static PyTypeObject dcerpc_bind_ack_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.bind_ack",
	.tp_getset = py_dcerpc_bind_ack_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_ack_new,
};


static PyObject *py_dcerpc_bind_nak_version_get_rpc_vers(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyLong_FromLong((uint16_t)(object->rpc_vers));
	return py_rpc_vers;
}

static int py_dcerpc_bind_nak_version_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rpc_vers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rpc_vers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rpc_vers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_nak_version_get_rpc_vers_minor(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers_minor;
	py_rpc_vers_minor = PyLong_FromLong((uint16_t)(object->rpc_vers_minor));
	return py_rpc_vers_minor;
}

static int py_dcerpc_bind_nak_version_set_rpc_vers_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rpc_vers_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rpc_vers_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rpc_vers_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_version_getsetters[] = {
	{
		.name = discard_const_p(char, "rpc_vers"),
		.get = py_dcerpc_bind_nak_version_get_rpc_vers,
		.set = py_dcerpc_bind_nak_version_set_rpc_vers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "rpc_vers_minor"),
		.get = py_dcerpc_bind_nak_version_get_rpc_vers_minor,
		.set = py_dcerpc_bind_nak_version_set_rpc_vers_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_bind_nak_version_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_nak_version, type);
}

static PyObject *py_dcerpc_bind_nak_version_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_bind_nak_version);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_bind_nak_version_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind_nak_version);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind_nak_version);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_bind_nak_version_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind_nak_version *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind_nak_version, "dcerpc_bind_nak_version", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind_nak_version, "dcerpc_bind_nak_version", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_bind_nak_version_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_bind_nak_version_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_nak_version_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_nak_version_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_bind_nak_version_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.bind_nak_version",
	.tp_getset = py_dcerpc_bind_nak_version_getsetters,
	.tp_methods = py_dcerpc_bind_nak_version_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_nak_version_new,
};


static PyObject *py_dcerpc_bind_nak_get_reject_reason(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(obj);
	PyObject *py_reject_reason;
	py_reject_reason = PyLong_FromLong((uint16_t)(object->reject_reason));
	return py_reject_reason;
}

static int py_dcerpc_bind_nak_set_reject_reason(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reject_reason");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reject_reason));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reject_reason = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_nak_get_num_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(obj);
	PyObject *py_num_versions;
	py_num_versions = PyLong_FromLong((uint16_t)(object->num_versions));
	return py_num_versions;
}

static int py_dcerpc_bind_nak_set_num_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->num_versions");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->num_versions));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->num_versions = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_nak_get_versions(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(obj);
	PyObject *py_versions;
	py_versions = PyList_New(object->num_versions);
	if (py_versions == NULL) {
		return NULL;
	}
	{
		int versions_cntr_0;
		for (versions_cntr_0 = 0; versions_cntr_0 < (object->num_versions); versions_cntr_0++) {
			PyObject *py_versions_0;
			py_versions_0 = pytalloc_reference_ex(&dcerpc_bind_nak_version_Type, object->versions, &(object->versions)[versions_cntr_0]);
			PyList_SetItem(py_versions, versions_cntr_0, py_versions_0);
		}
	}
	return py_versions;
}

static int py_dcerpc_bind_nak_set_versions(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->versions");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int versions_cntr_0;
		object->versions = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->versions, PyList_GET_SIZE(value));
		if (!object->versions) { return -1; }
		talloc_set_name_const(object->versions, "ARRAY: object->versions");
		for (versions_cntr_0 = 0; versions_cntr_0 < PyList_GET_SIZE(value); versions_cntr_0++) {
			if (PyList_GET_ITEM(value, versions_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->versions)[versions_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dcerpc_bind_nak_version_Type, PyList_GET_ITEM(value, versions_cntr_0), return -1;);
			if (talloc_reference(object->versions, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, versions_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->versions)[versions_cntr_0] = *(struct dcerpc_bind_nak_version *)pytalloc_get_ptr(PyList_GET_ITEM(value, versions_cntr_0));
		}
	}
	return 0;
}

static PyObject *py_dcerpc_bind_nak_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_bind_nak_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_bind_nak_getsetters[] = {
	{
		.name = discard_const_p(char, "reject_reason"),
		.get = py_dcerpc_bind_nak_get_reject_reason,
		.set = py_dcerpc_bind_nak_set_reject_reason,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_bind_nak_reason")
	},
	{
		.name = discard_const_p(char, "num_versions"),
		.get = py_dcerpc_bind_nak_get_num_versions,
		.set = py_dcerpc_bind_nak_set_num_versions,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "versions"),
		.get = py_dcerpc_bind_nak_get_versions,
		.set = py_dcerpc_bind_nak_set_versions,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_bind_nak_version")
	},
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_dcerpc_bind_nak_get__pad,
		.set = py_dcerpc_bind_nak_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_bind_nak_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_bind_nak, type);
}

static PyObject *py_dcerpc_bind_nak_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_bind_nak);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_bind_nak_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind_nak);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_bind_nak);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_bind_nak_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_bind_nak *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind_nak, "dcerpc_bind_nak", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_bind_nak, "dcerpc_bind_nak", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_bind_nak_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_bind_nak_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_nak_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_bind_nak_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_bind_nak_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.bind_nak",
	.tp_getset = py_dcerpc_bind_nak_getsetters,
	.tp_methods = py_dcerpc_bind_nak_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_bind_nak_new,
};


static PyObject *py_dcerpc_response_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyLong_FromUnsignedLongLong((uint32_t)(object->alloc_hint));
	return py_alloc_hint;
}

static int py_dcerpc_response_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alloc_hint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alloc_hint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alloc_hint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_response_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyLong_FromLong((uint16_t)(object->context_id));
	return py_context_id;
}

static int py_dcerpc_response_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_response_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyLong_FromLong((uint16_t)(object->cancel_count));
	return py_cancel_count;
}

static int py_dcerpc_response_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cancel_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cancel_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cancel_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_response_get_reserved(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromLong((uint16_t)(object->reserved));
	return py_reserved;
}

static int py_dcerpc_response_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_response_get_stub_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(obj);
	PyObject *py_stub_and_verifier;
	py_stub_and_verifier = PyBytes_FromStringAndSize((char *)(object->stub_and_verifier).data, (object->stub_and_verifier).length);
	return py_stub_and_verifier;
}

static int py_dcerpc_response_set_stub_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_response *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->stub_and_verifier");
		return -1;
	}
	object->stub_and_verifier = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_response_getsetters[] = {
	{
		.name = discard_const_p(char, "alloc_hint"),
		.get = py_dcerpc_response_get_alloc_hint,
		.set = py_dcerpc_response_set_alloc_hint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "context_id"),
		.get = py_dcerpc_response_get_context_id,
		.set = py_dcerpc_response_set_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "cancel_count"),
		.get = py_dcerpc_response_get_cancel_count,
		.set = py_dcerpc_response_set_cancel_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_dcerpc_response_get_reserved,
		.set = py_dcerpc_response_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "stub_and_verifier"),
		.get = py_dcerpc_response_get_stub_and_verifier,
		.set = py_dcerpc_response_set_stub_and_verifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_response_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_response, type);
}


static PyTypeObject dcerpc_response_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.response",
	.tp_getset = py_dcerpc_response_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_response_new,
};


static PyObject *py_dcerpc_fault_get_alloc_hint(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_alloc_hint;
	py_alloc_hint = PyLong_FromUnsignedLongLong((uint32_t)(object->alloc_hint));
	return py_alloc_hint;
}

static int py_dcerpc_fault_set_alloc_hint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->alloc_hint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->alloc_hint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->alloc_hint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyLong_FromLong((uint16_t)(object->context_id));
	return py_context_id;
}

static int py_dcerpc_fault_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_cancel_count(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_cancel_count;
	py_cancel_count = PyLong_FromLong((uint16_t)(object->cancel_count));
	return py_cancel_count;
}

static int py_dcerpc_fault_set_cancel_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->cancel_count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->cancel_count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->cancel_count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_flags(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_flags;
	py_flags = PyLong_FromLong((uint16_t)(object->flags));
	return py_flags;
}

static int py_dcerpc_fault_set_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_status(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_status;
	py_status = PyLong_FromUnsignedLongLong((uint32_t)(object->status));
	return py_status;
}

static int py_dcerpc_fault_set_status(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->status");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->status));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->status = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_reserved(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved;
	py_reserved = PyLong_FromUnsignedLongLong((uint32_t)(object->reserved));
	return py_reserved;
}

static int py_dcerpc_fault_set_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fault_get_error_and_verifier(PyObject *obj, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(obj);
	PyObject *py_error_and_verifier;
	py_error_and_verifier = PyBytes_FromStringAndSize((char *)(object->error_and_verifier).data, (object->error_and_verifier).length);
	return py_error_and_verifier;
}

static int py_dcerpc_fault_set_error_and_verifier(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fault *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->error_and_verifier");
		return -1;
	}
	object->error_and_verifier = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_fault_getsetters[] = {
	{
		.name = discard_const_p(char, "alloc_hint"),
		.get = py_dcerpc_fault_get_alloc_hint,
		.set = py_dcerpc_fault_set_alloc_hint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "context_id"),
		.get = py_dcerpc_fault_get_context_id,
		.set = py_dcerpc_fault_set_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "cancel_count"),
		.get = py_dcerpc_fault_get_cancel_count,
		.set = py_dcerpc_fault_set_cancel_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "flags"),
		.get = py_dcerpc_fault_get_flags,
		.set = py_dcerpc_fault_set_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_fault_flags")
	},
	{
		.name = discard_const_p(char, "status"),
		.get = py_dcerpc_fault_get_status,
		.set = py_dcerpc_fault_set_status,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_nca_status")
	},
	{
		.name = discard_const_p(char, "reserved"),
		.get = py_dcerpc_fault_get_reserved,
		.set = py_dcerpc_fault_set_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "error_and_verifier"),
		.get = py_dcerpc_fault_get_error_and_verifier,
		.set = py_dcerpc_fault_set_error_and_verifier,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_fault_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_fault, type);
}


static PyTypeObject dcerpc_fault_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.fault",
	.tp_getset = py_dcerpc_fault_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_fault_new,
};


static PyObject *py_dcerpc_auth_get_auth_type(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_type;
	py_auth_type = PyLong_FromLong((uint16_t)(object->auth_type));
	return py_auth_type;
}

static int py_dcerpc_auth_set_auth_type(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_type");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_type));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_type = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_level(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_level;
	py_auth_level = PyLong_FromLong((uint16_t)(object->auth_level));
	return py_auth_level;
}

static int py_dcerpc_auth_set_auth_level(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_level");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_level));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_level = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_pad_length(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_pad_length;
	py_auth_pad_length = PyLong_FromLong((uint16_t)(object->auth_pad_length));
	return py_auth_pad_length;
}

static int py_dcerpc_auth_set_auth_pad_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_pad_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_pad_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_pad_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_reserved(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_reserved;
	py_auth_reserved = PyLong_FromLong((uint16_t)(object->auth_reserved));
	return py_auth_reserved;
}

static int py_dcerpc_auth_set_auth_reserved(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_reserved");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_reserved));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_reserved = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_auth_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_context_id;
	py_auth_context_id = PyLong_FromUnsignedLongLong((uint32_t)(object->auth_context_id));
	return py_auth_context_id;
}

static int py_dcerpc_auth_set_auth_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth_get_credentials(PyObject *obj, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(obj);
	PyObject *py_credentials;
	py_credentials = PyBytes_FromStringAndSize((char *)(object->credentials).data, (object->credentials).length);
	return py_credentials;
}

static int py_dcerpc_auth_set_credentials(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->credentials");
		return -1;
	}
	object->credentials = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_type"),
		.get = py_dcerpc_auth_get_auth_type,
		.set = py_dcerpc_auth_set_auth_type,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_AuthType")
	},
	{
		.name = discard_const_p(char, "auth_level"),
		.get = py_dcerpc_auth_get_auth_level,
		.set = py_dcerpc_auth_set_auth_level,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_AuthLevel")
	},
	{
		.name = discard_const_p(char, "auth_pad_length"),
		.get = py_dcerpc_auth_get_auth_pad_length,
		.set = py_dcerpc_auth_set_auth_pad_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "auth_reserved"),
		.get = py_dcerpc_auth_get_auth_reserved,
		.set = py_dcerpc_auth_set_auth_reserved,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "auth_context_id"),
		.get = py_dcerpc_auth_get_auth_context_id,
		.set = py_dcerpc_auth_set_auth_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "credentials"),
		.get = py_dcerpc_auth_get_credentials,
		.set = py_dcerpc_auth_set_credentials,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_auth_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_auth, type);
}

static PyObject *py_dcerpc_auth_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_auth_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_auth_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth, "dcerpc_auth", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth, "dcerpc_auth", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_auth_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_auth_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_auth_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.auth",
	.tp_getset = py_dcerpc_auth_getsetters,
	.tp_methods = py_dcerpc_auth_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_auth_new,
};


static PyObject *py_dcerpc_auth3_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyLong_FromUnsignedLongLong((uint32_t)(object->_pad));
	return py__pad;
}

static int py_dcerpc_auth3_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_pad));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_pad = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_auth3_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyBytes_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_auth3_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_info");
		return -1;
	}
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_auth3_getsetters[] = {
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_dcerpc_auth3_get__pad,
		.set = py_dcerpc_auth3_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_dcerpc_auth3_get_auth_info,
		.set = py_dcerpc_auth3_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_auth3_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_auth3, type);
}

static PyObject *py_dcerpc_auth3_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_auth3);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_auth3_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth3);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_auth3);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_auth3_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_auth3 *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth3, "dcerpc_auth3", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_auth3, "dcerpc_auth3", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_auth3_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_auth3_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_auth3_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_auth3_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_auth3_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.auth3",
	.tp_getset = py_dcerpc_auth3_getsetters,
	.tp_methods = py_dcerpc_auth3_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_auth3_new,
};


static PyObject *py_dcerpc_orphaned_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_orphaned *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyBytes_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_orphaned_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_orphaned *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_info");
		return -1;
	}
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_orphaned_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_dcerpc_orphaned_get_auth_info,
		.set = py_dcerpc_orphaned_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_orphaned_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_orphaned, type);
}

static PyObject *py_dcerpc_orphaned_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_orphaned *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_orphaned);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_orphaned_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_orphaned *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_orphaned);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_orphaned);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_orphaned_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_orphaned *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_orphaned, "dcerpc_orphaned", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_orphaned, "dcerpc_orphaned", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_orphaned_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_orphaned_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_orphaned_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_orphaned_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_orphaned_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.orphaned",
	.tp_getset = py_dcerpc_orphaned_getsetters,
	.tp_methods = py_dcerpc_orphaned_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_orphaned_new,
};


static PyObject *py_dcerpc_co_cancel_get_auth_info(PyObject *obj, void *closure)
{
	struct dcerpc_co_cancel *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_info;
	py_auth_info = PyBytes_FromStringAndSize((char *)(object->auth_info).data, (object->auth_info).length);
	return py_auth_info;
}

static int py_dcerpc_co_cancel_set_auth_info(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_co_cancel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_info");
		return -1;
	}
	object->auth_info = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyGetSetDef py_dcerpc_co_cancel_getsetters[] = {
	{
		.name = discard_const_p(char, "auth_info"),
		.get = py_dcerpc_co_cancel_get_auth_info,
		.set = py_dcerpc_co_cancel_set_auth_info,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_co_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_co_cancel, type);
}

static PyObject *py_dcerpc_co_cancel_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_co_cancel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_co_cancel);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_co_cancel_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_co_cancel *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_co_cancel);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_co_cancel);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_co_cancel_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_co_cancel *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_co_cancel, "dcerpc_co_cancel", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_co_cancel, "dcerpc_co_cancel", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_co_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_co_cancel_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_co_cancel_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_co_cancel_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_co_cancel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.co_cancel",
	.tp_getset = py_dcerpc_co_cancel_getsetters,
	.tp_methods = py_dcerpc_co_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_co_cancel_new,
};


static PyObject *py_dcerpc_cl_cancel_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_dcerpc_cl_cancel_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_cl_cancel_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyLong_FromUnsignedLongLong((uint32_t)(object->id));
	return py_id;
}

static int py_dcerpc_cl_cancel_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_cl_cancel_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_dcerpc_cl_cancel_get_version,
		.set = py_dcerpc_cl_cancel_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "id"),
		.get = py_dcerpc_cl_cancel_get_id,
		.set = py_dcerpc_cl_cancel_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_cl_cancel_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_cl_cancel, type);
}

static PyObject *py_dcerpc_cl_cancel_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cl_cancel);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_cl_cancel_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cl_cancel);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cl_cancel);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_cl_cancel_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cl_cancel *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cl_cancel, "dcerpc_cl_cancel", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cl_cancel, "dcerpc_cl_cancel", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_cl_cancel_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cl_cancel_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_cl_cancel_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_cl_cancel_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cl_cancel_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.cl_cancel",
	.tp_getset = py_dcerpc_cl_cancel_getsetters,
	.tp_methods = py_dcerpc_cl_cancel_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_cl_cancel_new,
};


static PyObject *py_dcerpc_cancel_ack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_dcerpc_cancel_ack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_id(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_id;
	py_id = PyLong_FromUnsignedLongLong((uint32_t)(object->id));
	return py_id;
}

static int py_dcerpc_cancel_ack_set_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_cancel_ack_get_server_is_accepting(PyObject *obj, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(obj);
	PyObject *py_server_is_accepting;
	py_server_is_accepting = PyLong_FromUnsignedLongLong((uint32_t)(object->server_is_accepting));
	return py_server_is_accepting;
}

static int py_dcerpc_cancel_ack_set_server_is_accepting(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_is_accepting");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_is_accepting));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_is_accepting = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_cancel_ack_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_dcerpc_cancel_ack_get_version,
		.set = py_dcerpc_cancel_ack_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "id"),
		.get = py_dcerpc_cancel_ack_get_id,
		.set = py_dcerpc_cancel_ack_set_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "server_is_accepting"),
		.get = py_dcerpc_cancel_ack_get_server_is_accepting,
		.set = py_dcerpc_cancel_ack_set_server_is_accepting,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_cancel_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_cancel_ack, type);
}

static PyObject *py_dcerpc_cancel_ack_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_cancel_ack);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_cancel_ack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cancel_ack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_cancel_ack);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_cancel_ack_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_cancel_ack *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cancel_ack, "dcerpc_cancel_ack", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_cancel_ack, "dcerpc_cancel_ack", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_cancel_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_cancel_ack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_cancel_ack_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_cancel_ack_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_cancel_ack_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.cancel_ack",
	.tp_getset = py_dcerpc_cancel_ack_getsetters,
	.tp_methods = py_dcerpc_cancel_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_cancel_ack_new,
};


static PyObject *py_dcerpc_fack_get_version(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_version;
	py_version = PyLong_FromUnsignedLongLong((uint32_t)(object->version));
	return py_version;
}

static int py_dcerpc_fack_set_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get__pad1(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py__pad1;
	py__pad1 = PyLong_FromLong((uint16_t)(object->_pad1));
	return py__pad1;
}

static int py_dcerpc_fack_set__pad1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->_pad1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->_pad1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_window_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_window_size;
	py_window_size = PyLong_FromLong((uint16_t)(object->window_size));
	return py_window_size;
}

static int py_dcerpc_fack_set_window_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->window_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->window_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->window_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_tdsu(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_max_tdsu;
	py_max_tdsu = PyLong_FromUnsignedLongLong((uint32_t)(object->max_tdsu));
	return py_max_tdsu;
}

static int py_dcerpc_fack_set_max_tdsu(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_tdsu");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_tdsu));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_tdsu = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_max_frag_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_max_frag_size;
	py_max_frag_size = PyLong_FromUnsignedLongLong((uint32_t)(object->max_frag_size));
	return py_max_frag_size;
}

static int py_dcerpc_fack_set_max_frag_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->max_frag_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->max_frag_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->max_frag_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_serial_no(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_no;
	py_serial_no = PyLong_FromLong((uint16_t)(object->serial_no));
	return py_serial_no;
}

static int py_dcerpc_fack_set_serial_no(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_no");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_no));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_no = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack_size(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_selack_size;
	py_selack_size = PyLong_FromLong((uint16_t)(object->selack_size));
	return py_selack_size;
}

static int py_dcerpc_fack_set_selack_size(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->selack_size");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->selack_size));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->selack_size = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_fack_get_selack(PyObject *obj, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(obj);
	PyObject *py_selack;
	py_selack = PyList_New(object->selack_size);
	if (py_selack == NULL) {
		return NULL;
	}
	{
		int selack_cntr_0;
		for (selack_cntr_0 = 0; selack_cntr_0 < (object->selack_size); selack_cntr_0++) {
			PyObject *py_selack_0;
			py_selack_0 = PyLong_FromUnsignedLongLong((uint32_t)((object->selack)[selack_cntr_0]));
			PyList_SetItem(py_selack, selack_cntr_0, py_selack_0);
		}
	}
	return py_selack;
}

static int py_dcerpc_fack_set_selack(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->selack");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int selack_cntr_0;
		object->selack = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->selack, PyList_GET_SIZE(value));
		if (!object->selack) { return -1; }
		talloc_set_name_const(object->selack, "ARRAY: object->selack");
		for (selack_cntr_0 = 0; selack_cntr_0 < PyList_GET_SIZE(value); selack_cntr_0++) {
			if (PyList_GET_ITEM(value, selack_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->selack)[selack_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->selack)[selack_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, selack_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, selack_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->selack)[selack_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_fack_getsetters[] = {
	{
		.name = discard_const_p(char, "version"),
		.get = py_dcerpc_fack_get_version,
		.set = py_dcerpc_fack_set_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "_pad1"),
		.get = py_dcerpc_fack_get__pad1,
		.set = py_dcerpc_fack_set__pad1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "window_size"),
		.get = py_dcerpc_fack_get_window_size,
		.set = py_dcerpc_fack_set_window_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "max_tdsu"),
		.get = py_dcerpc_fack_get_max_tdsu,
		.set = py_dcerpc_fack_set_max_tdsu,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "max_frag_size"),
		.get = py_dcerpc_fack_get_max_frag_size,
		.set = py_dcerpc_fack_set_max_frag_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "serial_no"),
		.get = py_dcerpc_fack_get_serial_no,
		.set = py_dcerpc_fack_set_serial_no,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "selack_size"),
		.get = py_dcerpc_fack_get_selack_size,
		.set = py_dcerpc_fack_set_selack_size,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "selack"),
		.get = py_dcerpc_fack_get_selack,
		.set = py_dcerpc_fack_set_selack,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_fack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_fack, type);
}

static PyObject *py_dcerpc_fack_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_fack);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_fack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_fack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_fack);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_fack_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_fack *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_fack, "dcerpc_fack", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_fack, "dcerpc_fack", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_fack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_fack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_fack_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_fack_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_fack_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.fack",
	.tp_getset = py_dcerpc_fack_getsetters,
	.tp_methods = py_dcerpc_fack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_fack_new,
};


static PyObject *py_dcerpc_ack_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ack, type);
}

static PyObject *py_dcerpc_ack_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_ack *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ack);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_ack_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ack *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ack);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ack);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_ack_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ack *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ack, "dcerpc_ack", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ack, "dcerpc_ack", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_ack_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ack_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_ack_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_ack_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ack_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ack",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_ack_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ack_new,
};


static PyObject *py_dcerpc_ping_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_ping, type);
}

static PyObject *py_dcerpc_ping_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_ping *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_ping);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_ping_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ping *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ping);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_ping);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_ping_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_ping *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ping, "dcerpc_ping", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_ping, "dcerpc_ping", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_ping_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_ping_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_ping_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_ping_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_ping_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ping",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_ping_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_ping_new,
};


static PyObject *py_dcerpc_shutdown_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_shutdown, type);
}

static PyObject *py_dcerpc_shutdown_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_shutdown *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_shutdown);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_shutdown_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_shutdown *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_shutdown);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_shutdown);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_shutdown_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_shutdown *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_shutdown, "dcerpc_shutdown", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_shutdown, "dcerpc_shutdown", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_shutdown_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_shutdown_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_shutdown_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_shutdown_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_shutdown_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.shutdown",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_shutdown_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_shutdown_new,
};


static PyObject *py_dcerpc_working_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_working, type);
}

static PyObject *py_dcerpc_working_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_working *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_working);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_working_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_working *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_working);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_working);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_working_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_working *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_working, "dcerpc_working", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_working, "dcerpc_working", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_working_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_working_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_working_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_working_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_working_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.working",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_working_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_working_new,
};


static PyObject *py_RTSCookie_get_Cookie(PyObject *obj, void *closure)
{
	struct RTSCookie *object = pytalloc_get_ptr(obj);
	PyObject *py_Cookie;
	py_Cookie = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->Cookie);
	return py_Cookie;
}

static int py_RTSCookie_set_Cookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct RTSCookie *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Cookie");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Cookie = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_RTSCookie_getsetters[] = {
	{
		.name = discard_const_p(char, "Cookie"),
		.get = py_RTSCookie_get_Cookie,
		.set = py_RTSCookie_set_Cookie,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{ .name = NULL }
};

static PyObject *py_RTSCookie_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct RTSCookie, type);
}

static PyObject *py_RTSCookie_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct RTSCookie *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_RTSCookie);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_RTSCookie_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct RTSCookie *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_RTSCookie);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_RTSCookie);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_RTSCookie_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct RTSCookie *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_RTSCookie, "RTSCookie", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_RTSCookie, "RTSCookie", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_RTSCookie_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_RTSCookie_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_RTSCookie_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_RTSCookie_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject RTSCookie_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.RTSCookie",
	.tp_getset = py_RTSCookie_getsetters,
	.tp_methods = py_RTSCookie_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_RTSCookie_new,
};

static PyObject *py_import_ClientAddressType(TALLOC_CTX *mem_ctx, int level, union ClientAddressType *in)
{
	PyObject *ret;

	switch (level) {
		case RTS_IPV4:
			ret = PyString_FromStringOrNULL(in->ClientAddressIPV4);
			return ret;

		case RTS_IPV6:
			ret = PyString_FromStringOrNULL(in->ClientAddressIPV6);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union ClientAddressType *py_export_ClientAddressType(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union ClientAddressType *ret = talloc_zero(mem_ctx, union ClientAddressType);
	switch (level) {
		case RTS_IPV4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ClientAddressIPV4");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ClientAddressIPV4 = talloc_str;
			}
			break;

		case RTS_IPV6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ClientAddressIPV6");
				talloc_free(ret); return NULL;
			}
			{
				const char *test_str;
				const char *talloc_str;
				PyObject *unicode = NULL;
				if (PyUnicode_Check(in)) {
					unicode = PyUnicode_AsEncodedString(in, "utf-8", "ignore");
					if (unicode == NULL) {
						talloc_free(ret); return NULL;
					}
					test_str = PyBytes_AS_STRING(unicode);
				} else if (PyBytes_Check(in)) {
					test_str = PyBytes_AS_STRING(in);
				} else {
					PyErr_Format(PyExc_TypeError, "Expected string or unicode object, got %s", Py_TYPE(in)->tp_name);
					talloc_free(ret); return NULL;
				}
				talloc_str = talloc_strdup(mem_ctx, test_str);
				if (unicode != NULL) {
					Py_DECREF(unicode);
				}
				if (talloc_str == NULL) {
					PyErr_NoMemory();
					talloc_free(ret); return NULL;
				}
				ret->ClientAddressIPV6 = talloc_str;
			}
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_ClientAddressType_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union ClientAddressType *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union ClientAddressType *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union ClientAddressType!");
		return NULL;
	}

	return py_import_ClientAddressType(mem_ctx, level, in);
}

static PyObject *py_ClientAddressType_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union ClientAddressType *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_ClientAddressType(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_ClientAddressType_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ClientAddressType_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ClientAddressType_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_ClientAddressType_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject ClientAddressType_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ClientAddressType",
	.tp_getset = NULL,
	.tp_methods = py_ClientAddressType_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ClientAddressType_new,
};


static PyObject *py_ClientAddress_get_AddressType(PyObject *obj, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_AddressType;
	py_AddressType = PyLong_FromUnsignedLongLong((uint32_t)(object->AddressType));
	return py_AddressType;
}

static int py_ClientAddress_set_AddressType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AddressType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AddressType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AddressType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ClientAddress_get_ClientAddress(PyObject *obj, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_ClientAddress;
	py_ClientAddress = pyrpc_import_union(&ClientAddressType_Type, pytalloc_get_mem_ctx(obj), object->AddressType, &object->ClientAddress, "union ClientAddressType");
	if (py_ClientAddress == NULL) {
		return NULL;
	}
	return py_ClientAddress;
}

static int py_ClientAddress_set_ClientAddress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ClientAddress");
		return -1;
	}
	{
		union ClientAddressType *ClientAddress_switch_0;
		ClientAddress_switch_0 = (union ClientAddressType *)pyrpc_export_union(&ClientAddressType_Type, pytalloc_get_mem_ctx(py_obj), object->AddressType, value, "union ClientAddressType");
		if (ClientAddress_switch_0 == NULL) {
			return -1;
		}
		object->ClientAddress = *ClientAddress_switch_0;
	}
	return 0;
}

static PyObject *py_ClientAddress_get_Padding(PyObject *obj, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_Padding;
	py_Padding = PyList_New(12);
	if (py_Padding == NULL) {
		return NULL;
	}
	{
		int Padding_cntr_0;
		for (Padding_cntr_0 = 0; Padding_cntr_0 < (12); Padding_cntr_0++) {
			PyObject *py_Padding_0;
			py_Padding_0 = PyLong_FromLong((uint16_t)((object->Padding)[Padding_cntr_0]));
			PyList_SetItem(py_Padding, Padding_cntr_0, py_Padding_0);
		}
	}
	return py_Padding;
}

static int py_ClientAddress_set_Padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Padding");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Padding_cntr_0;
		if (ARRAY_SIZE(object->Padding) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->Padding),  PyList_GET_SIZE(value));
			return -1;
		}
		for (Padding_cntr_0 = 0; Padding_cntr_0 < PyList_GET_SIZE(value); Padding_cntr_0++) {
			if (PyList_GET_ITEM(value, Padding_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Padding)[Padding_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Padding)[Padding_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Padding_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Padding_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Padding)[Padding_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_ClientAddress_getsetters[] = {
	{
		.name = discard_const_p(char, "AddressType"),
		.get = py_ClientAddress_get_AddressType,
		.set = py_ClientAddress_set_AddressType,
		.doc = discard_const_p(char, "PIDL-generated element of base type AddressType")
	},
	{
		.name = discard_const_p(char, "ClientAddress"),
		.get = py_ClientAddress_get_ClientAddress,
		.set = py_ClientAddress_set_ClientAddress,
		.doc = discard_const_p(char, "PIDL-generated element of base type ClientAddressType")
	},
	{
		.name = discard_const_p(char, "Padding"),
		.get = py_ClientAddress_get_Padding,
		.set = py_ClientAddress_set_Padding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_ClientAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ClientAddress, type);
}

static PyObject *py_ClientAddress_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ClientAddress);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ClientAddress_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ClientAddress);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ClientAddress);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ClientAddress_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ClientAddress *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ClientAddress, "ClientAddress", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ClientAddress, "ClientAddress", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ClientAddress_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ClientAddress_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ClientAddress_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ClientAddress_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ClientAddress_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ClientAddress",
	.tp_getset = py_ClientAddress_getsetters,
	.tp_methods = py_ClientAddress_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ClientAddress_new,
};


static PyObject *py_FlowControlAcknowledgment_get_BytesReceived(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(obj);
	PyObject *py_BytesReceived;
	py_BytesReceived = PyLong_FromUnsignedLongLong((uint32_t)(object->BytesReceived));
	return py_BytesReceived;
}

static int py_FlowControlAcknowledgment_set_BytesReceived(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->BytesReceived");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->BytesReceived));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->BytesReceived = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_FlowControlAcknowledgment_get_AvailableWindow(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(obj);
	PyObject *py_AvailableWindow;
	py_AvailableWindow = PyLong_FromUnsignedLongLong((uint32_t)(object->AvailableWindow));
	return py_AvailableWindow;
}

static int py_FlowControlAcknowledgment_set_AvailableWindow(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AvailableWindow");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->AvailableWindow));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->AvailableWindow = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_FlowControlAcknowledgment_get_ChannelCookie(PyObject *obj, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(obj);
	PyObject *py_ChannelCookie;
	py_ChannelCookie = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->ChannelCookie);
	return py_ChannelCookie;
}

static int py_FlowControlAcknowledgment_set_ChannelCookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChannelCookie");
		return -1;
	}
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ChannelCookie = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_FlowControlAcknowledgment_getsetters[] = {
	{
		.name = discard_const_p(char, "BytesReceived"),
		.get = py_FlowControlAcknowledgment_get_BytesReceived,
		.set = py_FlowControlAcknowledgment_set_BytesReceived,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "AvailableWindow"),
		.get = py_FlowControlAcknowledgment_get_AvailableWindow,
		.set = py_FlowControlAcknowledgment_set_AvailableWindow,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "ChannelCookie"),
		.get = py_FlowControlAcknowledgment_get_ChannelCookie,
		.set = py_FlowControlAcknowledgment_set_ChannelCookie,
		.doc = discard_const_p(char, "PIDL-generated element of base type RTSCookie")
	},
	{ .name = NULL }
};

static PyObject *py_FlowControlAcknowledgment_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct FlowControlAcknowledgment, type);
}

static PyObject *py_FlowControlAcknowledgment_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_FlowControlAcknowledgment);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_FlowControlAcknowledgment_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FlowControlAcknowledgment);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_FlowControlAcknowledgment);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_FlowControlAcknowledgment_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct FlowControlAcknowledgment *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_FlowControlAcknowledgment, "FlowControlAcknowledgment", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_FlowControlAcknowledgment, "FlowControlAcknowledgment", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_FlowControlAcknowledgment_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_FlowControlAcknowledgment_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_FlowControlAcknowledgment_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_FlowControlAcknowledgment_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject FlowControlAcknowledgment_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.FlowControlAcknowledgment",
	.tp_getset = py_FlowControlAcknowledgment_getsetters,
	.tp_methods = py_FlowControlAcknowledgment_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_FlowControlAcknowledgment_new,
};


static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_get_ReceiveWindowSize(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = pytalloc_get_ptr(obj);
	PyObject *py_ReceiveWindowSize;
	py_ReceiveWindowSize = PyLong_FromUnsignedLongLong((uint32_t)(object->ReceiveWindowSize));
	return py_ReceiveWindowSize;
}

static int py_dcerpc_rts_cmd_ReceiveWindowSize_set_ReceiveWindowSize(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ReceiveWindowSize");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ReceiveWindowSize));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ReceiveWindowSize = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ReceiveWindowSize_getsetters[] = {
	{
		.name = discard_const_p(char, "ReceiveWindowSize"),
		.get = py_dcerpc_rts_cmd_ReceiveWindowSize_get_ReceiveWindowSize,
		.set = py_dcerpc_rts_cmd_ReceiveWindowSize_set_ReceiveWindowSize,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ReceiveWindowSize, type);
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ReceiveWindowSize);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ReceiveWindowSize);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ReceiveWindowSize *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ReceiveWindowSize, "dcerpc_rts_cmd_ReceiveWindowSize", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ReceiveWindowSize, "dcerpc_rts_cmd_ReceiveWindowSize", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ReceiveWindowSize_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ReceiveWindowSize_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ReceiveWindowSize_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ReceiveWindowSize",
	.tp_getset = py_dcerpc_rts_cmd_ReceiveWindowSize_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ReceiveWindowSize_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ReceiveWindowSize_new,
};


static PyObject *py_dcerpc_rts_cmd_FlowControlAck_get_Ack(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = pytalloc_get_ptr(obj);
	PyObject *py_Ack;
	py_Ack = pytalloc_reference_ex(&FlowControlAcknowledgment_Type, pytalloc_get_mem_ctx(obj), &object->Ack);
	return py_Ack;
}

static int py_dcerpc_rts_cmd_FlowControlAck_set_Ack(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Ack");
		return -1;
	}
	PY_CHECK_TYPE(&FlowControlAcknowledgment_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Ack = *(struct FlowControlAcknowledgment *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_FlowControlAck_getsetters[] = {
	{
		.name = discard_const_p(char, "Ack"),
		.get = py_dcerpc_rts_cmd_FlowControlAck_get_Ack,
		.set = py_dcerpc_rts_cmd_FlowControlAck_set_Ack,
		.doc = discard_const_p(char, "PIDL-generated element of base type FlowControlAcknowledgment")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_FlowControlAck, type);
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_FlowControlAck *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_FlowControlAck);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_FlowControlAck);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_FlowControlAck);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_FlowControlAck_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_FlowControlAck *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_FlowControlAck, "dcerpc_rts_cmd_FlowControlAck", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_FlowControlAck, "dcerpc_rts_cmd_FlowControlAck", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_FlowControlAck_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_FlowControlAck_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_FlowControlAck_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_FlowControlAck_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_FlowControlAck_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_FlowControlAck",
	.tp_getset = py_dcerpc_rts_cmd_FlowControlAck_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_FlowControlAck_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_FlowControlAck_new,
};


static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_get_ConnectionTimeout(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = pytalloc_get_ptr(obj);
	PyObject *py_ConnectionTimeout;
	py_ConnectionTimeout = PyLong_FromUnsignedLongLong((uint32_t)(object->ConnectionTimeout));
	return py_ConnectionTimeout;
}

static int py_dcerpc_rts_cmd_ConnectionTimeout_set_ConnectionTimeout(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ConnectionTimeout");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ConnectionTimeout));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ConnectionTimeout = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ConnectionTimeout_getsetters[] = {
	{
		.name = discard_const_p(char, "ConnectionTimeout"),
		.get = py_dcerpc_rts_cmd_ConnectionTimeout_get_ConnectionTimeout,
		.set = py_dcerpc_rts_cmd_ConnectionTimeout_set_ConnectionTimeout,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ConnectionTimeout, type);
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ConnectionTimeout);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ConnectionTimeout);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ConnectionTimeout);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ConnectionTimeout_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ConnectionTimeout *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ConnectionTimeout, "dcerpc_rts_cmd_ConnectionTimeout", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ConnectionTimeout, "dcerpc_rts_cmd_ConnectionTimeout", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ConnectionTimeout_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ConnectionTimeout_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ConnectionTimeout_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ConnectionTimeout_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ConnectionTimeout_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ConnectionTimeout",
	.tp_getset = py_dcerpc_rts_cmd_ConnectionTimeout_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ConnectionTimeout_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ConnectionTimeout_new,
};


static PyObject *py_dcerpc_rts_cmd_Cookie_get_Cookie(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Cookie *object = pytalloc_get_ptr(obj);
	PyObject *py_Cookie;
	py_Cookie = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->Cookie);
	return py_Cookie;
}

static int py_dcerpc_rts_cmd_Cookie_set_Cookie(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Cookie *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Cookie");
		return -1;
	}
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->Cookie = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Cookie_getsetters[] = {
	{
		.name = discard_const_p(char, "Cookie"),
		.get = py_dcerpc_rts_cmd_Cookie_get_Cookie,
		.set = py_dcerpc_rts_cmd_Cookie_set_Cookie,
		.doc = discard_const_p(char, "PIDL-generated element of base type RTSCookie")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_Cookie_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Cookie, type);
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_Cookie *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Cookie);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Cookie *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Cookie);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Cookie);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Cookie_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Cookie *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Cookie, "dcerpc_rts_cmd_Cookie", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Cookie, "dcerpc_rts_cmd_Cookie", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Cookie_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Cookie_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Cookie_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Cookie_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Cookie_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_Cookie",
	.tp_getset = py_dcerpc_rts_cmd_Cookie_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Cookie_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_Cookie_new,
};


static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_get_ChannelLifetime(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = pytalloc_get_ptr(obj);
	PyObject *py_ChannelLifetime;
	py_ChannelLifetime = PyLong_FromUnsignedLongLong((uint32_t)(object->ChannelLifetime));
	return py_ChannelLifetime;
}

static int py_dcerpc_rts_cmd_ChannelLifetime_set_ChannelLifetime(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ChannelLifetime");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ChannelLifetime));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ChannelLifetime = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ChannelLifetime_getsetters[] = {
	{
		.name = discard_const_p(char, "ChannelLifetime"),
		.get = py_dcerpc_rts_cmd_ChannelLifetime_get_ChannelLifetime,
		.set = py_dcerpc_rts_cmd_ChannelLifetime_set_ChannelLifetime,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ChannelLifetime, type);
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ChannelLifetime);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ChannelLifetime);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ChannelLifetime);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ChannelLifetime_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ChannelLifetime *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ChannelLifetime, "dcerpc_rts_cmd_ChannelLifetime", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ChannelLifetime, "dcerpc_rts_cmd_ChannelLifetime", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ChannelLifetime_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ChannelLifetime_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ChannelLifetime_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ChannelLifetime_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ChannelLifetime_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ChannelLifetime",
	.tp_getset = py_dcerpc_rts_cmd_ChannelLifetime_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ChannelLifetime_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ChannelLifetime_new,
};


static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_get_ClientKeepalive(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = pytalloc_get_ptr(obj);
	PyObject *py_ClientKeepalive;
	py_ClientKeepalive = PyLong_FromUnsignedLongLong((uint32_t)(object->ClientKeepalive));
	return py_ClientKeepalive;
}

static int py_dcerpc_rts_cmd_ClientKeepalive_set_ClientKeepalive(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ClientKeepalive");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ClientKeepalive));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ClientKeepalive = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ClientKeepalive_getsetters[] = {
	{
		.name = discard_const_p(char, "ClientKeepalive"),
		.get = py_dcerpc_rts_cmd_ClientKeepalive_get_ClientKeepalive,
		.set = py_dcerpc_rts_cmd_ClientKeepalive_set_ClientKeepalive,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ClientKeepalive, type);
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ClientKeepalive);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientKeepalive);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientKeepalive);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ClientKeepalive_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientKeepalive *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientKeepalive, "dcerpc_rts_cmd_ClientKeepalive", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientKeepalive, "dcerpc_rts_cmd_ClientKeepalive", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ClientKeepalive_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ClientKeepalive_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ClientKeepalive_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ClientKeepalive_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ClientKeepalive_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ClientKeepalive",
	.tp_getset = py_dcerpc_rts_cmd_ClientKeepalive_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ClientKeepalive_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ClientKeepalive_new,
};


static PyObject *py_dcerpc_rts_cmd_Version_get_Version(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Version *object = pytalloc_get_ptr(obj);
	PyObject *py_Version;
	py_Version = PyLong_FromUnsignedLongLong((uint32_t)(object->Version));
	return py_Version;
}

static int py_dcerpc_rts_cmd_Version_set_Version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Version *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Version_getsetters[] = {
	{
		.name = discard_const_p(char, "Version"),
		.get = py_dcerpc_rts_cmd_Version_get_Version,
		.set = py_dcerpc_rts_cmd_Version_set_Version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_Version_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Version, type);
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_Version *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Version);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Version *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Version);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Version);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Version_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Version *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Version, "dcerpc_rts_cmd_Version", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Version, "dcerpc_rts_cmd_Version", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Version_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Version_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Version_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Version_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Version_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_Version",
	.tp_getset = py_dcerpc_rts_cmd_Version_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Version_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_Version_new,
};


static PyObject *py_dcerpc_rts_cmd_Empty_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Empty, type);
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_Empty *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Empty);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Empty *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Empty);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Empty);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Empty_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Empty *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Empty, "dcerpc_rts_cmd_Empty", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Empty, "dcerpc_rts_cmd_Empty", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Empty_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Empty_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Empty_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Empty_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Empty_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_Empty",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_Empty_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_Empty_new,
};


static PyObject *py_dcerpc_rts_cmd_Padding_get_ConformanceCount(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(obj);
	PyObject *py_ConformanceCount;
	py_ConformanceCount = PyLong_FromUnsignedLongLong((uint32_t)(object->ConformanceCount));
	return py_ConformanceCount;
}

static int py_dcerpc_rts_cmd_Padding_set_ConformanceCount(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ConformanceCount");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ConformanceCount));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ConformanceCount = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_rts_cmd_Padding_get_Padding(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(obj);
	PyObject *py_Padding;
	py_Padding = PyList_New(object->ConformanceCount);
	if (py_Padding == NULL) {
		return NULL;
	}
	{
		int Padding_cntr_0;
		for (Padding_cntr_0 = 0; Padding_cntr_0 < (object->ConformanceCount); Padding_cntr_0++) {
			PyObject *py_Padding_0;
			py_Padding_0 = PyLong_FromLong((uint16_t)((object->Padding)[Padding_cntr_0]));
			PyList_SetItem(py_Padding, Padding_cntr_0, py_Padding_0);
		}
	}
	return py_Padding;
}

static int py_dcerpc_rts_cmd_Padding_set_Padding(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Padding");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Padding_cntr_0;
		object->Padding = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Padding, PyList_GET_SIZE(value));
		if (!object->Padding) { return -1; }
		talloc_set_name_const(object->Padding, "ARRAY: object->Padding");
		for (Padding_cntr_0 = 0; Padding_cntr_0 < PyList_GET_SIZE(value); Padding_cntr_0++) {
			if (PyList_GET_ITEM(value, Padding_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Padding)[Padding_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->Padding)[Padding_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, Padding_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, Padding_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->Padding)[Padding_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Padding_getsetters[] = {
	{
		.name = discard_const_p(char, "ConformanceCount"),
		.get = py_dcerpc_rts_cmd_Padding_get_ConformanceCount,
		.set = py_dcerpc_rts_cmd_Padding_set_ConformanceCount,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Padding"),
		.get = py_dcerpc_rts_cmd_Padding_get_Padding,
		.set = py_dcerpc_rts_cmd_Padding_set_Padding,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_Padding_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Padding, type);
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Padding);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Padding);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Padding);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Padding_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Padding *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Padding, "dcerpc_rts_cmd_Padding", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Padding, "dcerpc_rts_cmd_Padding", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Padding_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Padding_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Padding_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Padding_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Padding_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_Padding",
	.tp_getset = py_dcerpc_rts_cmd_Padding_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Padding_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_Padding_new,
};


static PyObject *py_dcerpc_rts_cmd_NegativeANCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_NegativeANCE, type);
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_NegativeANCE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_NegativeANCE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_NegativeANCE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_NegativeANCE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_NegativeANCE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_NegativeANCE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_NegativeANCE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_NegativeANCE, "dcerpc_rts_cmd_NegativeANCE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_NegativeANCE, "dcerpc_rts_cmd_NegativeANCE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_NegativeANCE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_NegativeANCE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_NegativeANCE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_NegativeANCE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_NegativeANCE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_NegativeANCE",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_NegativeANCE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_NegativeANCE_new,
};


static PyObject *py_dcerpc_rts_cmd_ANCE_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ANCE, type);
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ANCE *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ANCE);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ANCE *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ANCE);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ANCE);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ANCE_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ANCE *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ANCE, "dcerpc_rts_cmd_ANCE", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ANCE, "dcerpc_rts_cmd_ANCE", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ANCE_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ANCE_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ANCE_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ANCE_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ANCE_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ANCE",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmd_ANCE_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ANCE_new,
};


static PyObject *py_dcerpc_rts_cmd_ClientAddress_get_ClientAddress(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_ClientAddress *object = pytalloc_get_ptr(obj);
	PyObject *py_ClientAddress;
	py_ClientAddress = pytalloc_reference_ex(&ClientAddress_Type, pytalloc_get_mem_ctx(obj), &object->ClientAddress);
	return py_ClientAddress;
}

static int py_dcerpc_rts_cmd_ClientAddress_set_ClientAddress(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_ClientAddress *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ClientAddress");
		return -1;
	}
	PY_CHECK_TYPE(&ClientAddress_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->ClientAddress = *(struct ClientAddress *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_ClientAddress_getsetters[] = {
	{
		.name = discard_const_p(char, "ClientAddress"),
		.get = py_dcerpc_rts_cmd_ClientAddress_get_ClientAddress,
		.set = py_dcerpc_rts_cmd_ClientAddress_set_ClientAddress,
		.doc = discard_const_p(char, "PIDL-generated element of base type ClientAddress")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_ClientAddress_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_ClientAddress, type);
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_ClientAddress *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_ClientAddress);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientAddress *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientAddress);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_ClientAddress);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ClientAddress_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_ClientAddress *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientAddress, "dcerpc_rts_cmd_ClientAddress", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_ClientAddress, "dcerpc_rts_cmd_ClientAddress", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_ClientAddress_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ClientAddress_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ClientAddress_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ClientAddress_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_ClientAddress_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_ClientAddress",
	.tp_getset = py_dcerpc_rts_cmd_ClientAddress_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_ClientAddress_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_ClientAddress_new,
};


static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_get_AssociationGroupId(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = pytalloc_get_ptr(obj);
	PyObject *py_AssociationGroupId;
	py_AssociationGroupId = pytalloc_reference_ex(&RTSCookie_Type, pytalloc_get_mem_ctx(obj), &object->AssociationGroupId);
	return py_AssociationGroupId;
}

static int py_dcerpc_rts_cmd_AssociationGroupId_set_AssociationGroupId(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->AssociationGroupId");
		return -1;
	}
	PY_CHECK_TYPE(&RTSCookie_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->AssociationGroupId = *(struct RTSCookie *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_AssociationGroupId_getsetters[] = {
	{
		.name = discard_const_p(char, "AssociationGroupId"),
		.get = py_dcerpc_rts_cmd_AssociationGroupId_get_AssociationGroupId,
		.set = py_dcerpc_rts_cmd_AssociationGroupId_set_AssociationGroupId,
		.doc = discard_const_p(char, "PIDL-generated element of base type RTSCookie")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_AssociationGroupId, type);
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_AssociationGroupId);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_AssociationGroupId);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_AssociationGroupId);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_AssociationGroupId_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_AssociationGroupId *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_AssociationGroupId, "dcerpc_rts_cmd_AssociationGroupId", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_AssociationGroupId, "dcerpc_rts_cmd_AssociationGroupId", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_AssociationGroupId_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_AssociationGroupId_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_AssociationGroupId_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_AssociationGroupId_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_AssociationGroupId_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_AssociationGroupId",
	.tp_getset = py_dcerpc_rts_cmd_AssociationGroupId_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_AssociationGroupId_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_AssociationGroupId_new,
};


static PyObject *py_dcerpc_rts_cmd_Destination_get_ForwardDestination(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_Destination *object = pytalloc_get_ptr(obj);
	PyObject *py_ForwardDestination;
	py_ForwardDestination = PyLong_FromUnsignedLongLong((uint32_t)(object->ForwardDestination));
	return py_ForwardDestination;
}

static int py_dcerpc_rts_cmd_Destination_set_ForwardDestination(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_Destination *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ForwardDestination");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ForwardDestination));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ForwardDestination = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_Destination_getsetters[] = {
	{
		.name = discard_const_p(char, "ForwardDestination"),
		.get = py_dcerpc_rts_cmd_Destination_get_ForwardDestination,
		.set = py_dcerpc_rts_cmd_Destination_set_ForwardDestination,
		.doc = discard_const_p(char, "PIDL-generated element of base type ForwardDestination")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_Destination_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_Destination, type);
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_Destination *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_Destination);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Destination *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Destination);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_Destination);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_Destination_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_Destination *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Destination, "dcerpc_rts_cmd_Destination", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_Destination, "dcerpc_rts_cmd_Destination", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_Destination_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_Destination_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Destination_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_Destination_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Destination_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_Destination",
	.tp_getset = py_dcerpc_rts_cmd_Destination_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_Destination_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_Destination_new,
};


static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_get_PingTrafficSent(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = pytalloc_get_ptr(obj);
	PyObject *py_PingTrafficSent;
	py_PingTrafficSent = PyLong_FromUnsignedLongLong((uint32_t)(object->PingTrafficSent));
	return py_PingTrafficSent;
}

static int py_dcerpc_rts_cmd_PingTrafficSentNotify_set_PingTrafficSent(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->PingTrafficSent");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->PingTrafficSent));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->PingTrafficSent = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_PingTrafficSentNotify_getsetters[] = {
	{
		.name = discard_const_p(char, "PingTrafficSent"),
		.get = py_dcerpc_rts_cmd_PingTrafficSentNotify_get_PingTrafficSent,
		.set = py_dcerpc_rts_cmd_PingTrafficSentNotify_set_PingTrafficSent,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd_PingTrafficSentNotify, type);
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd_PingTrafficSentNotify);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd_PingTrafficSentNotify);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd_PingTrafficSentNotify *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify, "dcerpc_rts_cmd_PingTrafficSentNotify", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd_PingTrafficSentNotify, "dcerpc_rts_cmd_PingTrafficSentNotify", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_PingTrafficSentNotify_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_PingTrafficSentNotify_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_PingTrafficSentNotify_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd_PingTrafficSentNotify",
	.tp_getset = py_dcerpc_rts_cmd_PingTrafficSentNotify_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_PingTrafficSentNotify_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_PingTrafficSentNotify_new,
};

static PyObject *py_import_dcerpc_rts_cmds(TALLOC_CTX *mem_ctx, int level, union dcerpc_rts_cmds *in)
{
	PyObject *ret;

	switch (level) {
		case 0x0:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ReceiveWindowSize_Type, mem_ctx, &in->ReceiveWindowSize);
			return ret;

		case 0x1:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_FlowControlAck_Type, mem_ctx, &in->FlowControlAck);
			return ret;

		case 0x2:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ConnectionTimeout_Type, mem_ctx, &in->ConnectionTimeout);
			return ret;

		case 0x3:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Cookie_Type, mem_ctx, &in->Cookie);
			return ret;

		case 0x4:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ChannelLifetime_Type, mem_ctx, &in->ChannelLifetime);
			return ret;

		case 0x5:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ClientKeepalive_Type, mem_ctx, &in->ClientKeepalive);
			return ret;

		case 0x6:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Version_Type, mem_ctx, &in->Version);
			return ret;

		case 0x7:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Empty_Type, mem_ctx, &in->Empty);
			return ret;

		case 0x8:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Padding_Type, mem_ctx, &in->Padding);
			return ret;

		case 0x9:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_NegativeANCE_Type, mem_ctx, &in->NegativeANCE);
			return ret;

		case 0xA:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ANCE_Type, mem_ctx, &in->ANCE);
			return ret;

		case 0xB:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_ClientAddress_Type, mem_ctx, &in->ClientAddress);
			return ret;

		case 0xC:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_AssociationGroupId_Type, mem_ctx, &in->AssociationGroupId);
			return ret;

		case 0xD:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_Destination_Type, mem_ctx, &in->Destination);
			return ret;

		case 0xE:
			ret = pytalloc_reference_ex(&dcerpc_rts_cmd_PingTrafficSentNotify_Type, mem_ctx, &in->PingTrafficSentNotify);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dcerpc_rts_cmds *py_export_dcerpc_rts_cmds(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_rts_cmds *ret = talloc_zero(mem_ctx, union dcerpc_rts_cmds);
	switch (level) {
		case 0x0:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ReceiveWindowSize");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ReceiveWindowSize_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ReceiveWindowSize = *(struct dcerpc_rts_cmd_ReceiveWindowSize *)pytalloc_get_ptr(in);
			break;

		case 0x1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->FlowControlAck");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_FlowControlAck_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->FlowControlAck = *(struct dcerpc_rts_cmd_FlowControlAck *)pytalloc_get_ptr(in);
			break;

		case 0x2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ConnectionTimeout");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ConnectionTimeout_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ConnectionTimeout = *(struct dcerpc_rts_cmd_ConnectionTimeout *)pytalloc_get_ptr(in);
			break;

		case 0x3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Cookie");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Cookie_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Cookie = *(struct dcerpc_rts_cmd_Cookie *)pytalloc_get_ptr(in);
			break;

		case 0x4:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ChannelLifetime");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ChannelLifetime_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ChannelLifetime = *(struct dcerpc_rts_cmd_ChannelLifetime *)pytalloc_get_ptr(in);
			break;

		case 0x5:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ClientKeepalive");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ClientKeepalive_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ClientKeepalive = *(struct dcerpc_rts_cmd_ClientKeepalive *)pytalloc_get_ptr(in);
			break;

		case 0x6:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Version");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Version_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Version = *(struct dcerpc_rts_cmd_Version *)pytalloc_get_ptr(in);
			break;

		case 0x7:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Empty");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Empty_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Empty = *(struct dcerpc_rts_cmd_Empty *)pytalloc_get_ptr(in);
			break;

		case 0x8:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Padding");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Padding_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Padding = *(struct dcerpc_rts_cmd_Padding *)pytalloc_get_ptr(in);
			break;

		case 0x9:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->NegativeANCE");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_NegativeANCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->NegativeANCE = *(struct dcerpc_rts_cmd_NegativeANCE *)pytalloc_get_ptr(in);
			break;

		case 0xA:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ANCE");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ANCE_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ANCE = *(struct dcerpc_rts_cmd_ANCE *)pytalloc_get_ptr(in);
			break;

		case 0xB:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ClientAddress");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_ClientAddress_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ClientAddress = *(struct dcerpc_rts_cmd_ClientAddress *)pytalloc_get_ptr(in);
			break;

		case 0xC:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->AssociationGroupId");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_AssociationGroupId_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->AssociationGroupId = *(struct dcerpc_rts_cmd_AssociationGroupId *)pytalloc_get_ptr(in);
			break;

		case 0xD:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->Destination");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Destination_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->Destination = *(struct dcerpc_rts_cmd_Destination *)pytalloc_get_ptr(in);
			break;

		case 0xE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->PingTrafficSentNotify");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_PingTrafficSentNotify_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->PingTrafficSentNotify = *(struct dcerpc_rts_cmd_PingTrafficSentNotify *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_dcerpc_rts_cmds_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dcerpc_rts_cmds *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dcerpc_rts_cmds *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dcerpc_rts_cmds!");
		return NULL;
	}

	return py_import_dcerpc_rts_cmds(mem_ctx, level, in);
}

static PyObject *py_dcerpc_rts_cmds_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dcerpc_rts_cmds *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dcerpc_rts_cmds(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dcerpc_rts_cmds_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmds_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmds_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dcerpc_rts_cmds_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dcerpc_rts_cmds_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmds",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_rts_cmds_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmds_new,
};


static PyObject *py_dcerpc_rts_cmd_get_CommandType(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_CommandType;
	py_CommandType = PyLong_FromUnsignedLongLong((uint32_t)(object->CommandType));
	return py_CommandType;
}

static int py_dcerpc_rts_cmd_set_CommandType(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->CommandType");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->CommandType));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->CommandType = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_rts_cmd_get_Command(PyObject *obj, void *closure)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(obj);
	PyObject *py_Command;
	py_Command = pyrpc_import_union(&dcerpc_rts_cmds_Type, pytalloc_get_mem_ctx(obj), object->CommandType, &object->Command, "union dcerpc_rts_cmds");
	if (py_Command == NULL) {
		return NULL;
	}
	return py_Command;
}

static int py_dcerpc_rts_cmd_set_Command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Command");
		return -1;
	}
	{
		union dcerpc_rts_cmds *Command_switch_0;
		Command_switch_0 = (union dcerpc_rts_cmds *)pyrpc_export_union(&dcerpc_rts_cmds_Type, pytalloc_get_mem_ctx(py_obj), object->CommandType, value, "union dcerpc_rts_cmds");
		if (Command_switch_0 == NULL) {
			return -1;
		}
		object->Command = *Command_switch_0;
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_cmd_getsetters[] = {
	{
		.name = discard_const_p(char, "CommandType"),
		.get = py_dcerpc_rts_cmd_get_CommandType,
		.set = py_dcerpc_rts_cmd_set_CommandType,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "Command"),
		.get = py_dcerpc_rts_cmd_get_Command,
		.set = py_dcerpc_rts_cmd_set_Command,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_rts_cmds")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_cmd_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts_cmd, type);
}

static PyObject *py_dcerpc_rts_cmd_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts_cmd);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_cmd_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts_cmd);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_cmd_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts_cmd *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd, "dcerpc_rts_cmd", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts_cmd, "dcerpc_rts_cmd", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_cmd_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_cmd_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_cmd_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_cmd_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts_cmd",
	.tp_getset = py_dcerpc_rts_cmd_getsetters,
	.tp_methods = py_dcerpc_rts_cmd_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_cmd_new,
};


static PyObject *py_dcerpc_rts_get_Flags(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(obj);
	PyObject *py_Flags;
	py_Flags = PyLong_FromLong((uint16_t)(object->Flags));
	return py_Flags;
}

static int py_dcerpc_rts_set_Flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->Flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->Flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_rts_get_NumberOfCommands(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(obj);
	PyObject *py_NumberOfCommands;
	py_NumberOfCommands = PyLong_FromLong((uint16_t)(object->NumberOfCommands));
	return py_NumberOfCommands;
}

static int py_dcerpc_rts_set_NumberOfCommands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->NumberOfCommands");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->NumberOfCommands));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->NumberOfCommands = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_rts_get_Commands(PyObject *obj, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(obj);
	PyObject *py_Commands;
	py_Commands = PyList_New(object->NumberOfCommands);
	if (py_Commands == NULL) {
		return NULL;
	}
	{
		int Commands_cntr_0;
		for (Commands_cntr_0 = 0; Commands_cntr_0 < (object->NumberOfCommands); Commands_cntr_0++) {
			PyObject *py_Commands_0;
			py_Commands_0 = pytalloc_reference_ex(&dcerpc_rts_cmd_Type, object->Commands, &(object->Commands)[Commands_cntr_0]);
			PyList_SetItem(py_Commands, Commands_cntr_0, py_Commands_0);
		}
	}
	return py_Commands;
}

static int py_dcerpc_rts_set_Commands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->Commands");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int Commands_cntr_0;
		object->Commands = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->Commands, PyList_GET_SIZE(value));
		if (!object->Commands) { return -1; }
		talloc_set_name_const(object->Commands, "ARRAY: object->Commands");
		for (Commands_cntr_0 = 0; Commands_cntr_0 < PyList_GET_SIZE(value); Commands_cntr_0++) {
			if (PyList_GET_ITEM(value, Commands_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->Commands)[Commands_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dcerpc_rts_cmd_Type, PyList_GET_ITEM(value, Commands_cntr_0), return -1;);
			if (talloc_reference(object->Commands, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, Commands_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->Commands)[Commands_cntr_0] = *(struct dcerpc_rts_cmd *)pytalloc_get_ptr(PyList_GET_ITEM(value, Commands_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_rts_getsetters[] = {
	{
		.name = discard_const_p(char, "Flags"),
		.get = py_dcerpc_rts_get_Flags,
		.set = py_dcerpc_rts_set_Flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_rts_flags")
	},
	{
		.name = discard_const_p(char, "NumberOfCommands"),
		.get = py_dcerpc_rts_get_NumberOfCommands,
		.set = py_dcerpc_rts_set_NumberOfCommands,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "Commands"),
		.get = py_dcerpc_rts_get_Commands,
		.set = py_dcerpc_rts_set_Commands,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_rts_cmd")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_rts_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_rts, type);
}

static PyObject *py_dcerpc_rts_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_rts);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_rts_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_rts);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_rts_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_rts *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts, "dcerpc_rts", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_rts, "dcerpc_rts", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_rts_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_rts_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_rts_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_rts_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.rts",
	.tp_getset = py_dcerpc_rts_getsetters,
	.tp_methods = py_dcerpc_rts_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_rts_new,
};

static PyObject *py_import_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, union dcerpc_payload *in)
{
	PyObject *ret;

	switch (level) {
		case DCERPC_PKT_REQUEST:
			ret = pytalloc_reference_ex(&dcerpc_request_Type, mem_ctx, &in->request);
			return ret;

		case DCERPC_PKT_PING:
			ret = pytalloc_reference_ex(&dcerpc_ping_Type, mem_ctx, &in->ping);
			return ret;

		case DCERPC_PKT_RESPONSE:
			ret = pytalloc_reference_ex(&dcerpc_response_Type, mem_ctx, &in->response);
			return ret;

		case DCERPC_PKT_FAULT:
			ret = pytalloc_reference_ex(&dcerpc_fault_Type, mem_ctx, &in->fault);
			return ret;

		case DCERPC_PKT_WORKING:
			ret = pytalloc_reference_ex(&dcerpc_working_Type, mem_ctx, &in->working);
			return ret;

		case DCERPC_PKT_NOCALL:
			ret = pytalloc_reference_ex(&dcerpc_fack_Type, mem_ctx, &in->nocall);
			return ret;

		case DCERPC_PKT_REJECT:
			ret = pytalloc_reference_ex(&dcerpc_fault_Type, mem_ctx, &in->reject);
			return ret;

		case DCERPC_PKT_ACK:
			ret = pytalloc_reference_ex(&dcerpc_ack_Type, mem_ctx, &in->ack);
			return ret;

		case DCERPC_PKT_CL_CANCEL:
			ret = pytalloc_reference_ex(&dcerpc_cl_cancel_Type, mem_ctx, &in->cl_cancel);
			return ret;

		case DCERPC_PKT_FACK:
			ret = pytalloc_reference_ex(&dcerpc_fack_Type, mem_ctx, &in->fack);
			return ret;

		case DCERPC_PKT_CANCEL_ACK:
			ret = pytalloc_reference_ex(&dcerpc_cancel_ack_Type, mem_ctx, &in->cancel_ack);
			return ret;

		case DCERPC_PKT_BIND:
			ret = pytalloc_reference_ex(&dcerpc_bind_Type, mem_ctx, &in->bind);
			return ret;

		case DCERPC_PKT_BIND_ACK:
			ret = pytalloc_reference_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->bind_ack);
			return ret;

		case DCERPC_PKT_BIND_NAK:
			ret = pytalloc_reference_ex(&dcerpc_bind_nak_Type, mem_ctx, &in->bind_nak);
			return ret;

		case DCERPC_PKT_ALTER:
			ret = pytalloc_reference_ex(&dcerpc_bind_Type, mem_ctx, &in->alter);
			return ret;

		case DCERPC_PKT_ALTER_RESP:
			ret = pytalloc_reference_ex(&dcerpc_bind_ack_Type, mem_ctx, &in->alter_resp);
			return ret;

		case DCERPC_PKT_SHUTDOWN:
			ret = pytalloc_reference_ex(&dcerpc_shutdown_Type, mem_ctx, &in->shutdown);
			return ret;

		case DCERPC_PKT_CO_CANCEL:
			ret = pytalloc_reference_ex(&dcerpc_co_cancel_Type, mem_ctx, &in->co_cancel);
			return ret;

		case DCERPC_PKT_ORPHANED:
			ret = pytalloc_reference_ex(&dcerpc_orphaned_Type, mem_ctx, &in->orphaned);
			return ret;

		case DCERPC_PKT_AUTH3:
			ret = pytalloc_reference_ex(&dcerpc_auth3_Type, mem_ctx, &in->auth3);
			return ret;

		case DCERPC_PKT_RTS:
			ret = pytalloc_reference_ex(&dcerpc_rts_Type, mem_ctx, &in->rts);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dcerpc_payload *py_export_dcerpc_payload(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_payload *ret = talloc_zero(mem_ctx, union dcerpc_payload);
	switch (level) {
		case DCERPC_PKT_REQUEST:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->request");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_request_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->request = *(struct dcerpc_request *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_PING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ping");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_ping_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ping = *(struct dcerpc_ping *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_RESPONSE:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->response");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_response_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->response = *(struct dcerpc_response *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_FAULT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->fault");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->fault = *(struct dcerpc_fault *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_WORKING:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->working");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_working_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->working = *(struct dcerpc_working *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_NOCALL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->nocall");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->nocall = *(struct dcerpc_fack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_REJECT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->reject");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_fault_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->reject = *(struct dcerpc_fault *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->ack");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->ack = *(struct dcerpc_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CL_CANCEL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->cl_cancel");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_cl_cancel_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->cl_cancel = *(struct dcerpc_cl_cancel *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_FACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->fack");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_fack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->fack = *(struct dcerpc_fack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CANCEL_ACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->cancel_ack");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_cancel_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->cancel_ack = *(struct dcerpc_cancel_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->bind");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind = *(struct dcerpc_bind *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND_ACK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->bind_ack");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind_ack = *(struct dcerpc_bind_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_BIND_NAK:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->bind_nak");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_bind_nak_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->bind_nak = *(struct dcerpc_bind_nak *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ALTER:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->alter");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_bind_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->alter = *(struct dcerpc_bind *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ALTER_RESP:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->alter_resp");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_bind_ack_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->alter_resp = *(struct dcerpc_bind_ack *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_SHUTDOWN:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->shutdown");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_shutdown_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->shutdown = *(struct dcerpc_shutdown *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_CO_CANCEL:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->co_cancel");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_co_cancel_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->co_cancel = *(struct dcerpc_co_cancel *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_ORPHANED:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->orphaned");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_orphaned_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->orphaned = *(struct dcerpc_orphaned *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_AUTH3:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->auth3");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_auth3_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->auth3 = *(struct dcerpc_auth3 *)pytalloc_get_ptr(in);
			break;

		case DCERPC_PKT_RTS:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->rts");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_rts_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->rts = *(struct dcerpc_rts *)pytalloc_get_ptr(in);
			break;

		default:
			PyErr_SetString(PyExc_TypeError, "invalid union level value");
			talloc_free(ret);
			ret = NULL;
	}

	return ret;
}

static PyObject *py_dcerpc_payload_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dcerpc_payload *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dcerpc_payload *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dcerpc_payload!");
		return NULL;
	}

	return py_import_dcerpc_payload(mem_ctx, level, in);
}

static PyObject *py_dcerpc_payload_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dcerpc_payload *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dcerpc_payload(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dcerpc_payload_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_payload_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_payload_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dcerpc_payload_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dcerpc_payload_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.payload",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_payload_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_payload_new,
};


static PyObject *py_ncacn_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyLong_FromLong((uint16_t)(object->rpc_vers));
	return py_rpc_vers;
}

static int py_ncacn_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rpc_vers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rpc_vers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rpc_vers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_rpc_vers_minor(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers_minor;
	py_rpc_vers_minor = PyLong_FromLong((uint16_t)(object->rpc_vers_minor));
	return py_rpc_vers_minor;
}

static int py_ncacn_packet_set_rpc_vers_minor(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rpc_vers_minor");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rpc_vers_minor));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rpc_vers_minor = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyLong_FromLong((uint16_t)(object->ptype));
	return py_ptype;
}

static int py_ncacn_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ptype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ptype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ptype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyLong_FromLong((uint16_t)(object->pfc_flags));
	return py_pfc_flags;
}

static int py_ncacn_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pfc_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pfc_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pfc_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(4);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < (4); drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyLong_FromLong((uint16_t)((object->drep)[drep_cntr_0]));
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncacn_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->drep");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		if (ARRAY_SIZE(object->drep) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->drep),  PyList_GET_SIZE(value));
			return -1;
		}
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_GET_SIZE(value); drep_cntr_0++) {
			if (PyList_GET_ITEM(value, drep_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->drep)[drep_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->drep)[drep_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, drep_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, drep_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->drep)[drep_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_frag_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_frag_length;
	py_frag_length = PyLong_FromLong((uint16_t)(object->frag_length));
	return py_frag_length;
}

static int py_ncacn_packet_set_frag_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->frag_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->frag_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->frag_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_auth_length(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_length;
	py_auth_length = PyLong_FromLong((uint16_t)(object->auth_length));
	return py_auth_length;
}

static int py_ncacn_packet_set_auth_length(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_length");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_length));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_length = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_call_id(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_call_id;
	py_call_id = PyLong_FromUnsignedLongLong((uint32_t)(object->call_id));
	return py_call_id;
}

static int py_ncacn_packet_set_call_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->call_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->call_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->call_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncacn_packet_get_u(PyObject *obj, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = pyrpc_import_union(&dcerpc_payload_Type, pytalloc_get_mem_ctx(obj), object->ptype, &object->u, "union dcerpc_payload");
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncacn_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->u");
		return -1;
	}
	{
		union dcerpc_payload *u_switch_0;
		u_switch_0 = (union dcerpc_payload *)pyrpc_export_union(&dcerpc_payload_Type, pytalloc_get_mem_ctx(py_obj), object->ptype, value, "union dcerpc_payload");
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ncacn_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "rpc_vers"),
		.get = py_ncacn_packet_get_rpc_vers,
		.set = py_ncacn_packet_set_rpc_vers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "rpc_vers_minor"),
		.get = py_ncacn_packet_get_rpc_vers_minor,
		.set = py_ncacn_packet_set_rpc_vers_minor,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ptype"),
		.get = py_ncacn_packet_get_ptype,
		.set = py_ncacn_packet_set_ptype,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_pkt_type")
	},
	{
		.name = discard_const_p(char, "pfc_flags"),
		.get = py_ncacn_packet_get_pfc_flags,
		.set = py_ncacn_packet_set_pfc_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_pfc_flags")
	},
	{
		.name = discard_const_p(char, "drep"),
		.get = py_ncacn_packet_get_drep,
		.set = py_ncacn_packet_set_drep,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "frag_length"),
		.get = py_ncacn_packet_get_frag_length,
		.set = py_ncacn_packet_set_frag_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "auth_length"),
		.get = py_ncacn_packet_get_auth_length,
		.set = py_ncacn_packet_set_auth_length,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "call_id"),
		.get = py_ncacn_packet_get_call_id,
		.set = py_ncacn_packet_set_call_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "u"),
		.get = py_ncacn_packet_get_u,
		.set = py_ncacn_packet_set_u,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_payload")
	},
	{ .name = NULL }
};

static PyObject *py_ncacn_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ncacn_packet, type);
}

static PyObject *py_ncacn_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ncacn_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ncacn_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncacn_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncacn_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ncacn_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncacn_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncacn_packet, "ncacn_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncacn_packet, "ncacn_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ncacn_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncacn_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ncacn_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ncacn_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncacn_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ncacn_packet",
	.tp_getset = py_ncacn_packet_getsetters,
	.tp_methods = py_ncacn_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ncacn_packet_new,
};


static PyObject *py_ncadg_packet_get_rpc_vers(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_rpc_vers;
	py_rpc_vers = PyLong_FromLong((uint16_t)(object->rpc_vers));
	return py_rpc_vers;
}

static int py_ncadg_packet_set_rpc_vers(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->rpc_vers");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->rpc_vers));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->rpc_vers = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_ptype(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyLong_FromLong((uint16_t)(object->ptype));
	return py_ptype;
}

static int py_ncadg_packet_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ptype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ptype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ptype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_pfc_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_pfc_flags;
	py_pfc_flags = PyLong_FromLong((uint16_t)(object->pfc_flags));
	return py_pfc_flags;
}

static int py_ncadg_packet_set_pfc_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->pfc_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->pfc_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->pfc_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_ncadg_flags(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ncadg_flags;
	py_ncadg_flags = PyLong_FromLong((uint16_t)(object->ncadg_flags));
	return py_ncadg_flags;
}

static int py_ncadg_packet_set_ncadg_flags(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ncadg_flags");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ncadg_flags));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ncadg_flags = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_drep(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(3);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < (3); drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyLong_FromLong((uint16_t)((object->drep)[drep_cntr_0]));
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_ncadg_packet_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->drep");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		if (ARRAY_SIZE(object->drep) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->drep),  PyList_GET_SIZE(value));
			return -1;
		}
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_GET_SIZE(value); drep_cntr_0++) {
			if (PyList_GET_ITEM(value, drep_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->drep)[drep_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->drep)[drep_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, drep_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, drep_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->drep)[drep_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_high(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_high;
	py_serial_high = PyLong_FromLong((uint16_t)(object->serial_high));
	return py_serial_high;
}

static int py_ncadg_packet_set_serial_high(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_high");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_high));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_high = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_object(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_object;
	py_object = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->object);
	return py_object;
}

static int py_ncadg_packet_set_object(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->object");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->object = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_iface(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_iface;
	py_iface = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->iface);
	return py_iface;
}

static int py_ncadg_packet_set_iface(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->iface");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->iface = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_activity(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_activity;
	py_activity = pytalloc_reference_ex(GUID_Type, pytalloc_get_mem_ctx(obj), &object->activity);
	return py_activity;
}

static int py_ncadg_packet_set_activity(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->activity");
		return -1;
	}
	PY_CHECK_TYPE(GUID_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->activity = *(struct GUID *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_ncadg_packet_get_server_boot(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_server_boot;
	py_server_boot = PyLong_FromUnsignedLongLong((uint32_t)(object->server_boot));
	return py_server_boot;
}

static int py_ncadg_packet_set_server_boot(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->server_boot");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->server_boot));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->server_boot = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_iface_version(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_iface_version;
	py_iface_version = PyLong_FromUnsignedLongLong((uint32_t)(object->iface_version));
	return py_iface_version;
}

static int py_ncadg_packet_set_iface_version(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->iface_version");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->iface_version));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->iface_version = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_seq_num(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_seq_num;
	py_seq_num = PyLong_FromUnsignedLongLong((uint32_t)(object->seq_num));
	return py_seq_num;
}

static int py_ncadg_packet_set_seq_num(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->seq_num");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->seq_num));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->seq_num = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_opnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyLong_FromLong((uint16_t)(object->opnum));
	return py_opnum;
}

static int py_ncadg_packet_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_ihint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ihint;
	py_ihint = PyLong_FromLong((uint16_t)(object->ihint));
	return py_ihint;
}

static int py_ncadg_packet_set_ihint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ihint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ihint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ihint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_ahint(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_ahint;
	py_ahint = PyLong_FromLong((uint16_t)(object->ahint));
	return py_ahint;
}

static int py_ncadg_packet_set_ahint(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ahint");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ahint));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ahint = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_len(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_len;
	py_len = PyLong_FromLong((uint16_t)(object->len));
	return py_len;
}

static int py_ncadg_packet_set_len(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->len");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->len));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->len = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_fragnum(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_fragnum;
	py_fragnum = PyLong_FromLong((uint16_t)(object->fragnum));
	return py_fragnum;
}

static int py_ncadg_packet_set_fragnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->fragnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->fragnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->fragnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_auth_proto(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_auth_proto;
	py_auth_proto = PyLong_FromLong((uint16_t)(object->auth_proto));
	return py_auth_proto;
}

static int py_ncadg_packet_set_auth_proto(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->auth_proto");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->auth_proto));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->auth_proto = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_serial_low(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_serial_low;
	py_serial_low = PyLong_FromLong((uint16_t)(object->serial_low));
	return py_serial_low;
}

static int py_ncadg_packet_set_serial_low(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->serial_low");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->serial_low));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->serial_low = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_ncadg_packet_get_u(PyObject *obj, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = pyrpc_import_union(&dcerpc_payload_Type, pytalloc_get_mem_ctx(obj), object->ptype, &object->u, "union dcerpc_payload");
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_ncadg_packet_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->u");
		return -1;
	}
	{
		union dcerpc_payload *u_switch_0;
		u_switch_0 = (union dcerpc_payload *)pyrpc_export_union(&dcerpc_payload_Type, pytalloc_get_mem_ctx(py_obj), object->ptype, value, "union dcerpc_payload");
		if (u_switch_0 == NULL) {
			return -1;
		}
		object->u = *u_switch_0;
	}
	return 0;
}

static PyGetSetDef py_ncadg_packet_getsetters[] = {
	{
		.name = discard_const_p(char, "rpc_vers"),
		.get = py_ncadg_packet_get_rpc_vers,
		.set = py_ncadg_packet_set_rpc_vers,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ptype"),
		.get = py_ncadg_packet_get_ptype,
		.set = py_ncadg_packet_set_ptype,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "pfc_flags"),
		.get = py_ncadg_packet_get_pfc_flags,
		.set = py_ncadg_packet_set_pfc_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "ncadg_flags"),
		.get = py_ncadg_packet_get_ncadg_flags,
		.set = py_ncadg_packet_set_ncadg_flags,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "drep"),
		.get = py_ncadg_packet_get_drep,
		.set = py_ncadg_packet_set_drep,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "serial_high"),
		.get = py_ncadg_packet_get_serial_high,
		.set = py_ncadg_packet_set_serial_high,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "object"),
		.get = py_ncadg_packet_get_object,
		.set = py_ncadg_packet_set_object,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "iface"),
		.get = py_ncadg_packet_get_iface,
		.set = py_ncadg_packet_set_iface,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "activity"),
		.get = py_ncadg_packet_get_activity,
		.set = py_ncadg_packet_set_activity,
		.doc = discard_const_p(char, "PIDL-generated element of base type GUID")
	},
	{
		.name = discard_const_p(char, "server_boot"),
		.get = py_ncadg_packet_get_server_boot,
		.set = py_ncadg_packet_set_server_boot,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "iface_version"),
		.get = py_ncadg_packet_get_iface_version,
		.set = py_ncadg_packet_set_iface_version,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "seq_num"),
		.get = py_ncadg_packet_get_seq_num,
		.set = py_ncadg_packet_set_seq_num,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "opnum"),
		.get = py_ncadg_packet_get_opnum,
		.set = py_ncadg_packet_set_opnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ihint"),
		.get = py_ncadg_packet_get_ihint,
		.set = py_ncadg_packet_set_ihint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "ahint"),
		.get = py_ncadg_packet_get_ahint,
		.set = py_ncadg_packet_set_ahint,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "len"),
		.get = py_ncadg_packet_get_len,
		.set = py_ncadg_packet_set_len,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "fragnum"),
		.get = py_ncadg_packet_get_fragnum,
		.set = py_ncadg_packet_set_fragnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "auth_proto"),
		.get = py_ncadg_packet_get_auth_proto,
		.set = py_ncadg_packet_set_auth_proto,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "serial_low"),
		.get = py_ncadg_packet_get_serial_low,
		.set = py_ncadg_packet_set_serial_low,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "u"),
		.get = py_ncadg_packet_get_u,
		.set = py_ncadg_packet_set_u,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_payload")
	},
	{ .name = NULL }
};

static PyObject *py_ncadg_packet_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct ncadg_packet, type);
}

static PyObject *py_ncadg_packet_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_ncadg_packet);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_ncadg_packet_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncadg_packet);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_ncadg_packet);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_ncadg_packet_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct ncadg_packet *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncadg_packet, "ncadg_packet", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_ncadg_packet, "ncadg_packet", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_ncadg_packet_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_ncadg_packet_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ncadg_packet_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_ncadg_packet_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject ncadg_packet_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.ncadg_packet",
	.tp_getset = py_ncadg_packet_getsetters,
	.tp_methods = py_ncadg_packet_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_ncadg_packet_new,
};


static PyObject *py_dcerpc_sec_vt_pcontext_get_abstract_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_pcontext *object = pytalloc_get_ptr(obj);
	PyObject *py_abstract_syntax;
	py_abstract_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->abstract_syntax);
	return py_abstract_syntax;
}

static int py_dcerpc_sec_vt_pcontext_set_abstract_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_pcontext *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->abstract_syntax");
		return -1;
	}
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->abstract_syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dcerpc_sec_vt_pcontext_get_transfer_syntax(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_pcontext *object = pytalloc_get_ptr(obj);
	PyObject *py_transfer_syntax;
	py_transfer_syntax = pytalloc_reference_ex(ndr_syntax_id_Type, pytalloc_get_mem_ctx(obj), &object->transfer_syntax);
	return py_transfer_syntax;
}

static int py_dcerpc_sec_vt_pcontext_set_transfer_syntax(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_pcontext *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->transfer_syntax");
		return -1;
	}
	PY_CHECK_TYPE(ndr_syntax_id_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->transfer_syntax = *(struct ndr_syntax_id *)pytalloc_get_ptr(value);
	return 0;
}

static PyGetSetDef py_dcerpc_sec_vt_pcontext_getsetters[] = {
	{
		.name = discard_const_p(char, "abstract_syntax"),
		.get = py_dcerpc_sec_vt_pcontext_get_abstract_syntax,
		.set = py_dcerpc_sec_vt_pcontext_set_abstract_syntax,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{
		.name = discard_const_p(char, "transfer_syntax"),
		.get = py_dcerpc_sec_vt_pcontext_get_transfer_syntax,
		.set = py_dcerpc_sec_vt_pcontext_set_transfer_syntax,
		.doc = discard_const_p(char, "PIDL-generated element of base type ndr_syntax_id")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_sec_vt_pcontext_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_sec_vt_pcontext, type);
}


static PyTypeObject dcerpc_sec_vt_pcontext_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_vt_pcontext",
	.tp_getset = py_dcerpc_sec_vt_pcontext_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_vt_pcontext_new,
};


static PyObject *py_dcerpc_sec_vt_header2_get_ptype(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_ptype;
	py_ptype = PyLong_FromLong((uint16_t)(object->ptype));
	return py_ptype;
}

static int py_dcerpc_sec_vt_header2_set_ptype(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->ptype");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->ptype));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->ptype = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_reserved1(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved1;
	py_reserved1 = PyLong_FromLong((uint16_t)(object->reserved1));
	return py_reserved1;
}

static int py_dcerpc_sec_vt_header2_set_reserved1(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved1");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved1));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved1 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_reserved2(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_reserved2;
	py_reserved2 = PyLong_FromLong((uint16_t)(object->reserved2));
	return py_reserved2;
}

static int py_dcerpc_sec_vt_header2_set_reserved2(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->reserved2");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->reserved2));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->reserved2 = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_drep(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_drep;
	py_drep = PyList_New(4);
	if (py_drep == NULL) {
		return NULL;
	}
	{
		int drep_cntr_0;
		for (drep_cntr_0 = 0; drep_cntr_0 < (4); drep_cntr_0++) {
			PyObject *py_drep_0;
			py_drep_0 = PyLong_FromLong((uint16_t)((object->drep)[drep_cntr_0]));
			PyList_SetItem(py_drep, drep_cntr_0, py_drep_0);
		}
	}
	return py_drep;
}

static int py_dcerpc_sec_vt_header2_set_drep(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->drep");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int drep_cntr_0;
		if (ARRAY_SIZE(object->drep) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->drep),  PyList_GET_SIZE(value));
			return -1;
		}
		for (drep_cntr_0 = 0; drep_cntr_0 < PyList_GET_SIZE(value); drep_cntr_0++) {
			if (PyList_GET_ITEM(value, drep_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->drep)[drep_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->drep)[drep_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, drep_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, drep_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->drep)[drep_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_call_id(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_call_id;
	py_call_id = PyLong_FromUnsignedLongLong((uint32_t)(object->call_id));
	return py_call_id;
}

static int py_dcerpc_sec_vt_header2_set_call_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->call_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->call_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->call_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_context_id(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_context_id;
	py_context_id = PyLong_FromLong((uint16_t)(object->context_id));
	return py_context_id;
}

static int py_dcerpc_sec_vt_header2_set_context_id(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->context_id");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->context_id));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->context_id = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_header2_get_opnum(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(obj);
	PyObject *py_opnum;
	py_opnum = PyLong_FromLong((uint16_t)(object->opnum));
	return py_opnum;
}

static int py_dcerpc_sec_vt_header2_set_opnum(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_header2 *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->opnum");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->opnum));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->opnum = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_sec_vt_header2_getsetters[] = {
	{
		.name = discard_const_p(char, "ptype"),
		.get = py_dcerpc_sec_vt_header2_get_ptype,
		.set = py_dcerpc_sec_vt_header2_set_ptype,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_pkt_type")
	},
	{
		.name = discard_const_p(char, "reserved1"),
		.get = py_dcerpc_sec_vt_header2_get_reserved1,
		.set = py_dcerpc_sec_vt_header2_set_reserved1,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "reserved2"),
		.get = py_dcerpc_sec_vt_header2_get_reserved2,
		.set = py_dcerpc_sec_vt_header2_set_reserved2,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "drep"),
		.get = py_dcerpc_sec_vt_header2_get_drep,
		.set = py_dcerpc_sec_vt_header2_set_drep,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "call_id"),
		.get = py_dcerpc_sec_vt_header2_get_call_id,
		.set = py_dcerpc_sec_vt_header2_set_call_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint32")
	},
	{
		.name = discard_const_p(char, "context_id"),
		.get = py_dcerpc_sec_vt_header2_get_context_id,
		.set = py_dcerpc_sec_vt_header2_set_context_id,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{
		.name = discard_const_p(char, "opnum"),
		.get = py_dcerpc_sec_vt_header2_get_opnum,
		.set = py_dcerpc_sec_vt_header2_set_opnum,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_sec_vt_header2_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_sec_vt_header2, type);
}


static PyTypeObject dcerpc_sec_vt_header2_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_vt_header2",
	.tp_getset = py_dcerpc_sec_vt_header2_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_vt_header2_new,
};

static PyObject *py_import_dcerpc_sec_vt_union(TALLOC_CTX *mem_ctx, int level, union dcerpc_sec_vt_union *in)
{
	PyObject *ret;

	switch (level) {
		case DCERPC_SEC_VT_COMMAND_BITMASK1:
			ret = PyLong_FromUnsignedLongLong((uint32_t)(in->bitmask1));
			return ret;

		case DCERPC_SEC_VT_COMMAND_PCONTEXT:
			ret = pytalloc_reference_ex(&dcerpc_sec_vt_pcontext_Type, mem_ctx, &in->pcontext);
			return ret;

		case DCERPC_SEC_VT_COMMAND_HEADER2:
			ret = pytalloc_reference_ex(&dcerpc_sec_vt_header2_Type, mem_ctx, &in->header2);
			return ret;

		default:
			ret = PyBytes_FromStringAndSize((char *)(in->_unknown).data, (in->_unknown).length);
			return ret;

	}
	PyErr_SetString(PyExc_TypeError, "unknown union level");
	return NULL;
}

static union dcerpc_sec_vt_union *py_export_dcerpc_sec_vt_union(TALLOC_CTX *mem_ctx, int level, PyObject *in)
{
	union dcerpc_sec_vt_union *ret = talloc_zero(mem_ctx, union dcerpc_sec_vt_union);
	switch (level) {
		case DCERPC_SEC_VT_COMMAND_BITMASK1:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->bitmask1");
				talloc_free(ret); return NULL;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(ret->bitmask1));
				if (PyLong_Check(in)) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(in);
					if (PyErr_Occurred() != NULL) {
						talloc_free(ret); return NULL;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						talloc_free(ret); return NULL;
					}
					ret->bitmask1 = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					talloc_free(ret); return NULL;
				}
			}
			break;

		case DCERPC_SEC_VT_COMMAND_PCONTEXT:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->pcontext");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_sec_vt_pcontext_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->pcontext = *(struct dcerpc_sec_vt_pcontext *)pytalloc_get_ptr(in);
			break;

		case DCERPC_SEC_VT_COMMAND_HEADER2:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->header2");
				talloc_free(ret); return NULL;
			}
			PY_CHECK_TYPE(&dcerpc_sec_vt_header2_Type, in, talloc_free(ret); return NULL;);
			if (talloc_reference(mem_ctx, pytalloc_get_mem_ctx(in)) == NULL) {
				PyErr_NoMemory();
				talloc_free(ret); return NULL;
			}
			ret->header2 = *(struct dcerpc_sec_vt_header2 *)pytalloc_get_ptr(in);
			break;

		default:
			if (in == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: ret->_unknown");
				talloc_free(ret); return NULL;
			}
			ret->_unknown = data_blob_talloc(mem_ctx, PyBytes_AS_STRING(in), PyBytes_GET_SIZE(in));
			break;

	}

	return ret;
}

static PyObject *py_dcerpc_sec_vt_union_import(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in_obj = NULL;
	union dcerpc_sec_vt_union *in = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:import",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in_obj)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}
	in = (union dcerpc_sec_vt_union *)pytalloc_get_ptr(in_obj);
	if (in == NULL) {
		PyErr_Format(PyExc_TypeError, "in needs to be a pointer to union dcerpc_sec_vt_union!");
		return NULL;
	}

	return py_import_dcerpc_sec_vt_union(mem_ctx, level, in);
}

static PyObject *py_dcerpc_sec_vt_union_export(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	const char * const kwnames[] = { "mem_ctx", "level", "in", NULL };
	PyObject *mem_ctx_obj = NULL;
	TALLOC_CTX *mem_ctx = NULL;
	int level = 0;
	PyObject *in = NULL;
	union dcerpc_sec_vt_union *out = NULL;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, "OiO:export",
		discard_const_p(char *, kwnames),
		&mem_ctx_obj,
		&level,
		&in)) {
		return NULL;
	}
	mem_ctx = pytalloc_get_ptr(mem_ctx_obj);
	if (mem_ctx == NULL) {
		PyErr_SetString(PyExc_TypeError, "mem_ctx is NULL)!");
		return NULL;
	}

	out = py_export_dcerpc_sec_vt_union(mem_ctx, level, in);
	if (out == NULL) {
		return NULL;
	}

	return pytalloc_GenericObject_reference(out);
}

static PyMethodDef py_dcerpc_sec_vt_union_methods[] = {
	{ "__import__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_vt_union_import),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__import__(mem_ctx, level, in) => ret." },
	{ "__export__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_vt_union_export),
		METH_VARARGS|METH_KEYWORDS|METH_CLASS,
		"T.__export__(mem_ctx, level, in) => ret." },
	{ NULL, NULL, 0, NULL }
};

static PyObject *py_dcerpc_sec_vt_union_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	PyErr_Format(PyExc_TypeError, "New %s Objects are not supported", type->tp_name);
	return NULL;
}


static PyTypeObject dcerpc_sec_vt_union_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_vt_union",
	.tp_getset = NULL,
	.tp_methods = py_dcerpc_sec_vt_union_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_vt_union_new,
};


static PyObject *py_dcerpc_sec_vt_get_command(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt *object = pytalloc_get_ptr(obj);
	PyObject *py_command;
	py_command = PyLong_FromLong((uint16_t)(object->command));
	return py_command;
}

static int py_dcerpc_sec_vt_set_command(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->command");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->command));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->command = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_vt_get_u(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt *object = pytalloc_get_ptr(obj);
	PyObject *py_u;
	py_u = pyrpc_import_union(&dcerpc_sec_vt_union_Type, pytalloc_get_mem_ctx(obj), object->command & DCERPC_SEC_VT_COMMAND_ENUM, &object->u, "union dcerpc_sec_vt_union");
	if (py_u == NULL) {
		return NULL;
	}
	return py_u;
}

static int py_dcerpc_sec_vt_set_u(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->u");
		return -1;
	}
	{
		union dcerpc_sec_vt_union *u_switch_1;
		u_switch_1 = (union dcerpc_sec_vt_union *)pyrpc_export_union(&dcerpc_sec_vt_union_Type, pytalloc_get_mem_ctx(py_obj), object->command & DCERPC_SEC_VT_COMMAND_ENUM, value, "union dcerpc_sec_vt_union");
		if (u_switch_1 == NULL) {
			return -1;
		}
		object->u = *u_switch_1;
	}
	return 0;
}

static PyGetSetDef py_dcerpc_sec_vt_getsetters[] = {
	{
		.name = discard_const_p(char, "command"),
		.get = py_dcerpc_sec_vt_get_command,
		.set = py_dcerpc_sec_vt_set_command,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_sec_vt_command")
	},
	{
		.name = discard_const_p(char, "u"),
		.get = py_dcerpc_sec_vt_get_u,
		.set = py_dcerpc_sec_vt_set_u,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_sec_vt_union")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_sec_vt_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_sec_vt, type);
}


static PyTypeObject dcerpc_sec_vt_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_vt",
	.tp_getset = py_dcerpc_sec_vt_getsetters,
	.tp_methods = NULL,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_vt_new,
};


static PyObject *py_dcerpc_sec_vt_count_get_count(PyObject *obj, void *closure)
{
	struct dcerpc_sec_vt_count *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = PyLong_FromLong((uint16_t)(object->count));
	return py_count;
}

static int py_dcerpc_sec_vt_count_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_vt_count *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	{
		const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof(object->count));
		if (PyLong_Check(value)) {
			unsigned long long test_var;
			test_var = PyLong_AsUnsignedLongLong(value);
			if (PyErr_Occurred() != NULL) {
				return -1;
			}
			if (test_var > uint_max) {
				PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
				  PyLong_Type.tp_name, uint_max, test_var);
				return -1;
			}
			object->count = test_var;
		} else {
			PyErr_Format(PyExc_TypeError, "Expected type %s",
			  PyLong_Type.tp_name);
			return -1;
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_sec_vt_count_getsetters[] = {
	{
		.name = discard_const_p(char, "count"),
		.get = py_dcerpc_sec_vt_count_get_count,
		.set = py_dcerpc_sec_vt_count_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint16")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_sec_vt_count_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_sec_vt_count, type);
}

static PyObject *py_dcerpc_sec_vt_count_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_sec_vt_count *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_sec_vt_count);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_sec_vt_count_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_sec_vt_count *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_sec_vt_count);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_sec_vt_count);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_sec_vt_count_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_sec_vt_count *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_sec_vt_count, "dcerpc_sec_vt_count", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_sec_vt_count, "dcerpc_sec_vt_count", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_sec_vt_count_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_sec_vt_count_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_vt_count_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_vt_count_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_sec_vt_count_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_vt_count",
	.tp_getset = py_dcerpc_sec_vt_count_getsetters,
	.tp_methods = py_dcerpc_sec_vt_count_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_vt_count_new,
};


static PyObject *py_dcerpc_sec_verification_trailer_get__pad(PyObject *obj, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(obj);
	PyObject *py__pad;
	py__pad = PyBytes_FromStringAndSize((char *)(object->_pad).data, (object->_pad).length);
	return py__pad;
}

static int py_dcerpc_sec_verification_trailer_set__pad(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->_pad");
		return -1;
	}
	object->_pad = data_blob_talloc(pytalloc_get_mem_ctx(py_obj), PyBytes_AS_STRING(value), PyBytes_GET_SIZE(value));
	return 0;
}

static PyObject *py_dcerpc_sec_verification_trailer_get_magic(PyObject *obj, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(obj);
	PyObject *py_magic;
	py_magic = PyList_New(8);
	if (py_magic == NULL) {
		return NULL;
	}
	{
		int magic_cntr_0;
		for (magic_cntr_0 = 0; magic_cntr_0 < (8); magic_cntr_0++) {
			PyObject *py_magic_0;
			py_magic_0 = PyLong_FromLong((uint16_t)((object->magic)[magic_cntr_0]));
			PyList_SetItem(py_magic, magic_cntr_0, py_magic_0);
		}
	}
	return py_magic;
}

static int py_dcerpc_sec_verification_trailer_set_magic(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->magic");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int magic_cntr_0;
		if (ARRAY_SIZE(object->magic) != PyList_GET_SIZE(value)) {
			PyErr_Format(PyExc_TypeError, "Expected list of type %s, length %zu, got %zd", Py_TYPE(value)->tp_name, ARRAY_SIZE(object->magic),  PyList_GET_SIZE(value));
			return -1;
		}
		for (magic_cntr_0 = 0; magic_cntr_0 < PyList_GET_SIZE(value); magic_cntr_0++) {
			if (PyList_GET_ITEM(value, magic_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->magic)[magic_cntr_0]");
				return -1;
			}
			{
				const unsigned long long uint_max = ndr_sizeof2uintmax(sizeof((object->magic)[magic_cntr_0]));
				if (PyLong_Check(PyList_GET_ITEM(value, magic_cntr_0))) {
					unsigned long long test_var;
					test_var = PyLong_AsUnsignedLongLong(PyList_GET_ITEM(value, magic_cntr_0));
					if (PyErr_Occurred() != NULL) {
						return -1;
					}
					if (test_var > uint_max) {
						PyErr_Format(PyExc_OverflowError, "Expected type %s within range 0 - %llu, got %llu",
						  PyLong_Type.tp_name, uint_max, test_var);
						return -1;
					}
					(object->magic)[magic_cntr_0] = test_var;
				} else {
					PyErr_Format(PyExc_TypeError, "Expected type %s",
					  PyLong_Type.tp_name);
					return -1;
				}
			}
		}
	}
	return 0;
}

static PyObject *py_dcerpc_sec_verification_trailer_get_count(PyObject *obj, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(obj);
	PyObject *py_count;
	py_count = pytalloc_reference_ex(&dcerpc_sec_vt_count_Type, pytalloc_get_mem_ctx(obj), &object->count);
	return py_count;
}

static int py_dcerpc_sec_verification_trailer_set_count(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->count");
		return -1;
	}
	PY_CHECK_TYPE(&dcerpc_sec_vt_count_Type, value, return -1;);
	if (talloc_reference(pytalloc_get_mem_ctx(py_obj), pytalloc_get_mem_ctx(value)) == NULL) {
		PyErr_NoMemory();
		return -1;
	}
	object->count = *(struct dcerpc_sec_vt_count *)pytalloc_get_ptr(value);
	return 0;
}

static PyObject *py_dcerpc_sec_verification_trailer_get_commands(PyObject *obj, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(obj);
	PyObject *py_commands;
	py_commands = PyList_New(object->count.count);
	if (py_commands == NULL) {
		return NULL;
	}
	{
		int commands_cntr_0;
		for (commands_cntr_0 = 0; commands_cntr_0 < (object->count.count); commands_cntr_0++) {
			PyObject *py_commands_0;
			py_commands_0 = pytalloc_reference_ex(&dcerpc_sec_vt_Type, object->commands, &(object->commands)[commands_cntr_0]);
			PyList_SetItem(py_commands, commands_cntr_0, py_commands_0);
		}
	}
	return py_commands;
}

static int py_dcerpc_sec_verification_trailer_set_commands(PyObject *py_obj, PyObject *value, void *closure)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	if (value == NULL) {
		PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: object->commands");
		return -1;
	}
	PY_CHECK_TYPE(&PyList_Type, value, return -1;);
	{
		int commands_cntr_0;
		object->commands = talloc_array_ptrtype(pytalloc_get_mem_ctx(py_obj), object->commands, PyList_GET_SIZE(value));
		if (!object->commands) { return -1; }
		talloc_set_name_const(object->commands, "ARRAY: object->commands");
		for (commands_cntr_0 = 0; commands_cntr_0 < PyList_GET_SIZE(value); commands_cntr_0++) {
			if (PyList_GET_ITEM(value, commands_cntr_0) == NULL) {
				PyErr_Format(PyExc_AttributeError, "Cannot delete NDR object: (object->commands)[commands_cntr_0]");
				return -1;
			}
			PY_CHECK_TYPE(&dcerpc_sec_vt_Type, PyList_GET_ITEM(value, commands_cntr_0), return -1;);
			if (talloc_reference(object->commands, pytalloc_get_mem_ctx(PyList_GET_ITEM(value, commands_cntr_0))) == NULL) {
				PyErr_NoMemory();
				return -1;
			}
			(object->commands)[commands_cntr_0] = *(struct dcerpc_sec_vt *)pytalloc_get_ptr(PyList_GET_ITEM(value, commands_cntr_0));
		}
	}
	return 0;
}

static PyGetSetDef py_dcerpc_sec_verification_trailer_getsetters[] = {
	{
		.name = discard_const_p(char, "_pad"),
		.get = py_dcerpc_sec_verification_trailer_get__pad,
		.set = py_dcerpc_sec_verification_trailer_set__pad,
		.doc = discard_const_p(char, "PIDL-generated element of base type DATA_BLOB")
	},
	{
		.name = discard_const_p(char, "magic"),
		.get = py_dcerpc_sec_verification_trailer_get_magic,
		.set = py_dcerpc_sec_verification_trailer_set_magic,
		.doc = discard_const_p(char, "PIDL-generated element of base type uint8")
	},
	{
		.name = discard_const_p(char, "count"),
		.get = py_dcerpc_sec_verification_trailer_get_count,
		.set = py_dcerpc_sec_verification_trailer_set_count,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_sec_vt_count")
	},
	{
		.name = discard_const_p(char, "commands"),
		.get = py_dcerpc_sec_verification_trailer_get_commands,
		.set = py_dcerpc_sec_verification_trailer_set_commands,
		.doc = discard_const_p(char, "PIDL-generated element of base type dcerpc_sec_vt")
	},
	{ .name = NULL }
};

static PyObject *py_dcerpc_sec_verification_trailer_new(PyTypeObject *type, PyObject *args, PyObject *kwargs)
{
	return pytalloc_new(struct dcerpc_sec_verification_trailer, type);
}

static PyObject *py_dcerpc_sec_verification_trailer_ndr_pack(PyObject *py_obj,  PyObject *Py_UNUSED(ignored))
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	PyObject *ret = NULL;
	DATA_BLOB blob;
	enum ndr_err_code err;
	TALLOC_CTX *tmp_ctx = talloc_new(pytalloc_get_mem_ctx(py_obj));
	if (tmp_ctx == NULL) {
		PyErr_SetNdrError(NDR_ERR_ALLOC);
		return NULL;
	}
	err = ndr_push_struct_blob(&blob, tmp_ctx, object, (ndr_push_flags_fn_t)ndr_push_dcerpc_sec_verification_trailer);
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		TALLOC_FREE(tmp_ctx);
		PyErr_SetNdrError(err);
		return NULL;
	}

	ret = PyBytes_FromStringAndSize((char *)blob.data, blob.length);
	TALLOC_FREE(tmp_ctx);
	return ret;
}

static PyObject *py_dcerpc_sec_verification_trailer_ndr_unpack(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	DATA_BLOB blob = {.data = NULL, .length = 0};
	Py_ssize_t blob_length = 0;
	enum ndr_err_code err;
	const char * const kwnames[] = { "data_blob", "allow_remaining", NULL };
	PyObject *allow_remaining_obj = NULL;
	bool allow_remaining = false;

	if (!PyArg_ParseTupleAndKeywords(args, kwargs, PYARG_BYTES_LEN "|O:__ndr_unpack__",
		discard_const_p(char *, kwnames),
		&blob.data, &blob_length,
		&allow_remaining_obj)) {
		return NULL;
	}
	blob.length = blob_length;

	if (allow_remaining_obj && PyObject_IsTrue(allow_remaining_obj)) {
		allow_remaining = true;
	}

	if (allow_remaining) {
		err = ndr_pull_struct_blob(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_sec_verification_trailer);
	} else {
		err = ndr_pull_struct_blob_all(&blob, pytalloc_get_mem_ctx(py_obj), object, (ndr_pull_flags_fn_t)ndr_pull_dcerpc_sec_verification_trailer);
	}
	if (!NDR_ERR_CODE_IS_SUCCESS(err)) {
		PyErr_SetNdrError(err);
		return NULL;
	}

	Py_RETURN_NONE;
}

static PyObject *py_dcerpc_sec_verification_trailer_ndr_print(PyObject *py_obj, PyObject *args, PyObject *kwargs)
{
	struct dcerpc_sec_verification_trailer *object = pytalloc_get_ptr(py_obj);
	const char * const kwnames[] = { "print_secrets", NULL };
	PyObject *py_print_secrets = NULL;
	PyObject *ret;
	char *retstr;
	bool ok;

	ok = PyArg_ParseTupleAndKeywords(args, kwargs, "|O:__ndr_print__",
		discard_const_p(char *, kwnames),
		&py_print_secrets);
	if (!ok) {
		return NULL;
	}

	if (py_print_secrets != NULL && PyObject_IsTrue(py_print_secrets)) {
		retstr = ndr_print_struct_secret_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_sec_verification_trailer, "dcerpc_sec_verification_trailer", object);
	} else {
		retstr = ndr_print_struct_string(pytalloc_get_mem_ctx(py_obj), (ndr_print_fn_t)ndr_print_dcerpc_sec_verification_trailer, "dcerpc_sec_verification_trailer", object);
		}
	ret = PyUnicode_FromString(retstr);
	talloc_free(retstr);

	return ret;
}

static PyMethodDef py_dcerpc_sec_verification_trailer_methods[] = {
	{ "__ndr_pack__", (PyCFunction)py_dcerpc_sec_verification_trailer_ndr_pack, METH_NOARGS, "S.ndr_pack(object) -> blob\nNDR pack" },
	{ "__ndr_unpack__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_verification_trailer_ndr_unpack), METH_VARARGS|METH_KEYWORDS, "S.ndr_unpack(class, blob, allow_remaining=False) -> None\nNDR unpack" },
	{ "__ndr_print__", PY_DISCARD_FUNC_SIG(PyCFunction,py_dcerpc_sec_verification_trailer_ndr_print), METH_VARARGS|METH_KEYWORDS, "S.ndr_print(object, print_secrets=False) -> String\nNDR print" },
	{ NULL, NULL, 0, NULL }
};


static PyTypeObject dcerpc_sec_verification_trailer_Type = {
	PyVarObject_HEAD_INIT(NULL, 0)
	.tp_name = "dcerpc.sec_verification_trailer",
	.tp_getset = py_dcerpc_sec_verification_trailer_getsetters,
	.tp_methods = py_dcerpc_sec_verification_trailer_methods,
	.tp_flags = Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,
	.tp_new = py_dcerpc_sec_verification_trailer_new,
};

static PyMethodDef dcerpc_methods[] = {
	{ NULL, NULL, 0, NULL }
};

static struct PyModuleDef moduledef = {
	PyModuleDef_HEAD_INIT,
	.m_name = "dcerpc",
	.m_doc = "dcerpc DCE/RPC",
	.m_size = -1,
	.m_methods = dcerpc_methods,
};
MODULE_INIT_FUNC(dcerpc)
{
	PyObject *m = NULL;
	PyObject *dep_samba_dcerpc_misc = NULL;
	PyObject *dep_talloc = NULL;

	dep_samba_dcerpc_misc = PyImport_ImportModule("samba.dcerpc.misc");
	if (dep_samba_dcerpc_misc == NULL)
		goto out;

	dep_talloc = PyImport_ImportModule("talloc");
	if (dep_talloc == NULL)
		goto out;

	ndr_syntax_id_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "ndr_syntax_id");
	if (ndr_syntax_id_Type == NULL)
		goto out;

	BaseObject_Type = (PyTypeObject *)PyObject_GetAttrString(dep_talloc, "BaseObject");
	if (BaseObject_Type == NULL)
		goto out;

	GUID_Type = (PyTypeObject *)PyObject_GetAttrString(dep_samba_dcerpc_misc, "GUID");
	if (GUID_Type == NULL)
		goto out;

	dcerpc_ctx_list_Type.tp_base = BaseObject_Type;
	dcerpc_ctx_list_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_bind_Type.tp_base = BaseObject_Type;
	dcerpc_bind_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_empty_Type.tp_base = BaseObject_Type;
	dcerpc_empty_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_object_Type.tp_base = BaseObject_Type;
	dcerpc_object_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_request_Type.tp_base = BaseObject_Type;
	dcerpc_request_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_bind_ack_reason_Type.tp_base = BaseObject_Type;
	dcerpc_bind_ack_reason_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_ack_ctx_Type.tp_base = BaseObject_Type;
	dcerpc_ack_ctx_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_bind_ack_Type.tp_base = BaseObject_Type;
	dcerpc_bind_ack_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_bind_nak_version_Type.tp_base = BaseObject_Type;
	dcerpc_bind_nak_version_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_bind_nak_Type.tp_base = BaseObject_Type;
	dcerpc_bind_nak_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_response_Type.tp_base = BaseObject_Type;
	dcerpc_response_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_fault_Type.tp_base = BaseObject_Type;
	dcerpc_fault_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_auth_Type.tp_base = BaseObject_Type;
	dcerpc_auth_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_auth3_Type.tp_base = BaseObject_Type;
	dcerpc_auth3_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_orphaned_Type.tp_base = BaseObject_Type;
	dcerpc_orphaned_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_co_cancel_Type.tp_base = BaseObject_Type;
	dcerpc_co_cancel_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_cl_cancel_Type.tp_base = BaseObject_Type;
	dcerpc_cl_cancel_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_cancel_ack_Type.tp_base = BaseObject_Type;
	dcerpc_cancel_ack_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_fack_Type.tp_base = BaseObject_Type;
	dcerpc_fack_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_ack_Type.tp_base = BaseObject_Type;
	dcerpc_ack_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_ping_Type.tp_base = BaseObject_Type;
	dcerpc_ping_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_shutdown_Type.tp_base = BaseObject_Type;
	dcerpc_shutdown_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_working_Type.tp_base = BaseObject_Type;
	dcerpc_working_Type.tp_basicsize = pytalloc_BaseObject_size();

	RTSCookie_Type.tp_base = BaseObject_Type;
	RTSCookie_Type.tp_basicsize = pytalloc_BaseObject_size();

	ClientAddressType_Type.tp_base = BaseObject_Type;
	ClientAddressType_Type.tp_basicsize = pytalloc_BaseObject_size();

	ClientAddress_Type.tp_base = BaseObject_Type;
	ClientAddress_Type.tp_basicsize = pytalloc_BaseObject_size();

	FlowControlAcknowledgment_Type.tp_base = BaseObject_Type;
	FlowControlAcknowledgment_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ReceiveWindowSize_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ReceiveWindowSize_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_FlowControlAck_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_FlowControlAck_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ConnectionTimeout_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ConnectionTimeout_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Cookie_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Cookie_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ChannelLifetime_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ChannelLifetime_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ClientKeepalive_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ClientKeepalive_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Version_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Version_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Empty_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Empty_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Padding_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Padding_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_NegativeANCE_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_NegativeANCE_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ANCE_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ANCE_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_ClientAddress_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_ClientAddress_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_AssociationGroupId_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_AssociationGroupId_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Destination_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Destination_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_PingTrafficSentNotify_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_PingTrafficSentNotify_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmds_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmds_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_cmd_Type.tp_base = BaseObject_Type;
	dcerpc_rts_cmd_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_rts_Type.tp_base = BaseObject_Type;
	dcerpc_rts_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_payload_Type.tp_base = BaseObject_Type;
	dcerpc_payload_Type.tp_basicsize = pytalloc_BaseObject_size();

	ncacn_packet_Type.tp_base = BaseObject_Type;
	ncacn_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	ncadg_packet_Type.tp_base = BaseObject_Type;
	ncadg_packet_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_vt_pcontext_Type.tp_base = BaseObject_Type;
	dcerpc_sec_vt_pcontext_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_vt_header2_Type.tp_base = BaseObject_Type;
	dcerpc_sec_vt_header2_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_vt_union_Type.tp_base = BaseObject_Type;
	dcerpc_sec_vt_union_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_vt_Type.tp_base = BaseObject_Type;
	dcerpc_sec_vt_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_vt_count_Type.tp_base = BaseObject_Type;
	dcerpc_sec_vt_count_Type.tp_basicsize = pytalloc_BaseObject_size();

	dcerpc_sec_verification_trailer_Type.tp_base = BaseObject_Type;
	dcerpc_sec_verification_trailer_Type.tp_basicsize = pytalloc_BaseObject_size();

	if (PyType_Ready(&dcerpc_ctx_list_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_bind_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_empty_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_object_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_request_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_bind_ack_reason_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_ack_ctx_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_bind_ack_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_bind_nak_version_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_bind_nak_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_response_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_fault_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_auth_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_auth3_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_orphaned_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_co_cancel_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_cl_cancel_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_cancel_ack_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_fack_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_ack_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_ping_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_shutdown_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_working_Type) < 0)
		goto out;
	if (PyType_Ready(&RTSCookie_Type) < 0)
		goto out;
	if (PyType_Ready(&ClientAddressType_Type) < 0)
		goto out;
	if (PyType_Ready(&ClientAddress_Type) < 0)
		goto out;
	if (PyType_Ready(&FlowControlAcknowledgment_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ReceiveWindowSize_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_FlowControlAck_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ConnectionTimeout_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Cookie_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ChannelLifetime_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ClientKeepalive_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Version_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Empty_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Padding_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_NegativeANCE_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ANCE_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_ClientAddress_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_AssociationGroupId_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Destination_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_PingTrafficSentNotify_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmds_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_cmd_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_rts_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_payload_Type) < 0)
		goto out;
	if (PyType_Ready(&ncacn_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&ncadg_packet_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_vt_pcontext_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_vt_header2_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_vt_union_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_vt_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_vt_count_Type) < 0)
		goto out;
	if (PyType_Ready(&dcerpc_sec_verification_trailer_Type) < 0)
		goto out;
#ifdef PY_CTX_LIST_PATCH
	PY_CTX_LIST_PATCH(&dcerpc_ctx_list_Type);
#endif
#ifdef PY_BIND_PATCH
	PY_BIND_PATCH(&dcerpc_bind_Type);
#endif
#ifdef PY_EMPTY_PATCH
	PY_EMPTY_PATCH(&dcerpc_empty_Type);
#endif
#ifdef PY_OBJECT_PATCH
	PY_OBJECT_PATCH(&dcerpc_object_Type);
#endif
#ifdef PY_REQUEST_PATCH
	PY_REQUEST_PATCH(&dcerpc_request_Type);
#endif
#ifdef PY_BIND_ACK_REASON_PATCH
	PY_BIND_ACK_REASON_PATCH(&dcerpc_bind_ack_reason_Type);
#endif
#ifdef PY_ACK_CTX_PATCH
	PY_ACK_CTX_PATCH(&dcerpc_ack_ctx_Type);
#endif
#ifdef PY_BIND_ACK_PATCH
	PY_BIND_ACK_PATCH(&dcerpc_bind_ack_Type);
#endif
#ifdef PY_BIND_NAK_VERSION_PATCH
	PY_BIND_NAK_VERSION_PATCH(&dcerpc_bind_nak_version_Type);
#endif
#ifdef PY_BIND_NAK_PATCH
	PY_BIND_NAK_PATCH(&dcerpc_bind_nak_Type);
#endif
#ifdef PY_RESPONSE_PATCH
	PY_RESPONSE_PATCH(&dcerpc_response_Type);
#endif
#ifdef PY_FAULT_PATCH
	PY_FAULT_PATCH(&dcerpc_fault_Type);
#endif
#ifdef PY_AUTH_PATCH
	PY_AUTH_PATCH(&dcerpc_auth_Type);
#endif
#ifdef PY_AUTH3_PATCH
	PY_AUTH3_PATCH(&dcerpc_auth3_Type);
#endif
#ifdef PY_ORPHANED_PATCH
	PY_ORPHANED_PATCH(&dcerpc_orphaned_Type);
#endif
#ifdef PY_CO_CANCEL_PATCH
	PY_CO_CANCEL_PATCH(&dcerpc_co_cancel_Type);
#endif
#ifdef PY_CL_CANCEL_PATCH
	PY_CL_CANCEL_PATCH(&dcerpc_cl_cancel_Type);
#endif
#ifdef PY_CANCEL_ACK_PATCH
	PY_CANCEL_ACK_PATCH(&dcerpc_cancel_ack_Type);
#endif
#ifdef PY_FACK_PATCH
	PY_FACK_PATCH(&dcerpc_fack_Type);
#endif
#ifdef PY_ACK_PATCH
	PY_ACK_PATCH(&dcerpc_ack_Type);
#endif
#ifdef PY_PING_PATCH
	PY_PING_PATCH(&dcerpc_ping_Type);
#endif
#ifdef PY_SHUTDOWN_PATCH
	PY_SHUTDOWN_PATCH(&dcerpc_shutdown_Type);
#endif
#ifdef PY_WORKING_PATCH
	PY_WORKING_PATCH(&dcerpc_working_Type);
#endif
#ifdef PY_RTSCOOKIE_PATCH
	PY_RTSCOOKIE_PATCH(&RTSCookie_Type);
#endif
#ifdef PY_CLIENTADDRESSTYPE_PATCH
	PY_CLIENTADDRESSTYPE_PATCH(&ClientAddressType_Type);
#endif
#ifdef PY_CLIENTADDRESS_PATCH
	PY_CLIENTADDRESS_PATCH(&ClientAddress_Type);
#endif
#ifdef PY_FLOWCONTROLACKNOWLEDGMENT_PATCH
	PY_FLOWCONTROLACKNOWLEDGMENT_PATCH(&FlowControlAcknowledgment_Type);
#endif
#ifdef PY_RTS_CMD_RECEIVEWINDOWSIZE_PATCH
	PY_RTS_CMD_RECEIVEWINDOWSIZE_PATCH(&dcerpc_rts_cmd_ReceiveWindowSize_Type);
#endif
#ifdef PY_RTS_CMD_FLOWCONTROLACK_PATCH
	PY_RTS_CMD_FLOWCONTROLACK_PATCH(&dcerpc_rts_cmd_FlowControlAck_Type);
#endif
#ifdef PY_RTS_CMD_CONNECTIONTIMEOUT_PATCH
	PY_RTS_CMD_CONNECTIONTIMEOUT_PATCH(&dcerpc_rts_cmd_ConnectionTimeout_Type);
#endif
#ifdef PY_RTS_CMD_COOKIE_PATCH
	PY_RTS_CMD_COOKIE_PATCH(&dcerpc_rts_cmd_Cookie_Type);
#endif
#ifdef PY_RTS_CMD_CHANNELLIFETIME_PATCH
	PY_RTS_CMD_CHANNELLIFETIME_PATCH(&dcerpc_rts_cmd_ChannelLifetime_Type);
#endif
#ifdef PY_RTS_CMD_CLIENTKEEPALIVE_PATCH
	PY_RTS_CMD_CLIENTKEEPALIVE_PATCH(&dcerpc_rts_cmd_ClientKeepalive_Type);
#endif
#ifdef PY_RTS_CMD_VERSION_PATCH
	PY_RTS_CMD_VERSION_PATCH(&dcerpc_rts_cmd_Version_Type);
#endif
#ifdef PY_RTS_CMD_EMPTY_PATCH
	PY_RTS_CMD_EMPTY_PATCH(&dcerpc_rts_cmd_Empty_Type);
#endif
#ifdef PY_RTS_CMD_PADDING_PATCH
	PY_RTS_CMD_PADDING_PATCH(&dcerpc_rts_cmd_Padding_Type);
#endif
#ifdef PY_RTS_CMD_NEGATIVEANCE_PATCH
	PY_RTS_CMD_NEGATIVEANCE_PATCH(&dcerpc_rts_cmd_NegativeANCE_Type);
#endif
#ifdef PY_RTS_CMD_ANCE_PATCH
	PY_RTS_CMD_ANCE_PATCH(&dcerpc_rts_cmd_ANCE_Type);
#endif
#ifdef PY_RTS_CMD_CLIENTADDRESS_PATCH
	PY_RTS_CMD_CLIENTADDRESS_PATCH(&dcerpc_rts_cmd_ClientAddress_Type);
#endif
#ifdef PY_RTS_CMD_ASSOCIATIONGROUPID_PATCH
	PY_RTS_CMD_ASSOCIATIONGROUPID_PATCH(&dcerpc_rts_cmd_AssociationGroupId_Type);
#endif
#ifdef PY_RTS_CMD_DESTINATION_PATCH
	PY_RTS_CMD_DESTINATION_PATCH(&dcerpc_rts_cmd_Destination_Type);
#endif
#ifdef PY_RTS_CMD_PINGTRAFFICSENTNOTIFY_PATCH
	PY_RTS_CMD_PINGTRAFFICSENTNOTIFY_PATCH(&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
#endif
#ifdef PY_RTS_CMDS_PATCH
	PY_RTS_CMDS_PATCH(&dcerpc_rts_cmds_Type);
#endif
#ifdef PY_RTS_CMD_PATCH
	PY_RTS_CMD_PATCH(&dcerpc_rts_cmd_Type);
#endif
#ifdef PY_RTS_PATCH
	PY_RTS_PATCH(&dcerpc_rts_Type);
#endif
#ifdef PY_PAYLOAD_PATCH
	PY_PAYLOAD_PATCH(&dcerpc_payload_Type);
#endif
#ifdef PY_NCACN_PACKET_PATCH
	PY_NCACN_PACKET_PATCH(&ncacn_packet_Type);
#endif
#ifdef PY_NCADG_PACKET_PATCH
	PY_NCADG_PACKET_PATCH(&ncadg_packet_Type);
#endif
#ifdef PY_SEC_VT_PCONTEXT_PATCH
	PY_SEC_VT_PCONTEXT_PATCH(&dcerpc_sec_vt_pcontext_Type);
#endif
#ifdef PY_SEC_VT_HEADER2_PATCH
	PY_SEC_VT_HEADER2_PATCH(&dcerpc_sec_vt_header2_Type);
#endif
#ifdef PY_SEC_VT_UNION_PATCH
	PY_SEC_VT_UNION_PATCH(&dcerpc_sec_vt_union_Type);
#endif
#ifdef PY_SEC_VT_PATCH
	PY_SEC_VT_PATCH(&dcerpc_sec_vt_Type);
#endif
#ifdef PY_SEC_VT_COUNT_PATCH
	PY_SEC_VT_COUNT_PATCH(&dcerpc_sec_vt_count_Type);
#endif
#ifdef PY_SEC_VERIFICATION_TRAILER_PATCH
	PY_SEC_VERIFICATION_TRAILER_PATCH(&dcerpc_sec_verification_trailer_Type);
#endif

	m = PyModule_Create(&moduledef);
	if (m == NULL)
		goto out;

	PyModule_AddObject(m, "DCERPC_REQUEST_LENGTH", PyLong_FromUnsignedLongLong(24));
	PyModule_AddObject(m, "DCERPC_BIND_PROVIDER_REJECT", PyLong_FromLong(DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_ASYNTAX", PyLong_FromLong(DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED));
	PyModule_AddObject(m, "DECRPC_BIND_PROTOCOL_VERSION_NOT_SUPPORTED", PyLong_FromLong(DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED));
	PyModule_AddObject(m, "DCERPC_BIND_REASON_INVALID_AUTH_TYPE", PyLong_FromLong(DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE));
	PyModule_AddObject(m, "DCERPC_RESPONSE_LENGTH", PyLong_FromUnsignedLongLong(24));
	PyModule_AddObject(m, "DCERPC_FAULT_OP_RNG_ERROR", PyLong_FromLong(DCERPC_NCA_S_OP_RNG_ERROR));
	PyModule_AddObject(m, "DCERPC_FAULT_NDR", PyLong_FromLong(DCERPC_FAULT_BAD_STUB_DATA));
	PyModule_AddObject(m, "DCERPC_FAULT_INVALID_TAG", PyLong_FromLong(DCERPC_NCA_S_FAULT_INVALID_TAG));
	PyModule_AddObject(m, "DCERPC_FAULT_CONTEXT_MISMATCH", PyLong_FromLong(DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH));
	PyModule_AddObject(m, "DCERPC_FAULT_OTHER", PyLong_FromUnsignedLongLong(0x00000001));
	PyModule_AddObject(m, "DCERPC_FAULT_TODO", PyLong_FromUnsignedLongLong(0x00000042));
	PyModule_AddObject(m, "DCERPC_FAULT_LENGTH", PyLong_FromUnsignedLongLong(32));
	PyModule_AddObject(m, "AS_SYSTEM_MAGIC_PATH_TOKEN", PyUnicode_FromString("/root/ncalrpc_as_system"));
	PyModule_AddObject(m, "DCERPC_AUTH_TRAILER_LENGTH", PyLong_FromUnsignedLongLong(8));
	PyModule_AddObject(m, "DCERPC_AUTH_PAD_ALIGNMENT", PyLong_FromUnsignedLongLong(16));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_PENDING_CANCEL", PyLong_FromLong(DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_SUPPORT_HEADER_SIGN", PyLong_FromLong(DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING));
	PyModule_AddObject(m, "DCERPC_PFC_OFFSET", PyLong_FromUnsignedLongLong(3));
	PyModule_AddObject(m, "DCERPC_DREP_OFFSET", PyLong_FromUnsignedLongLong(4));
	PyModule_AddObject(m, "DCERPC_FRAG_LEN_OFFSET", PyLong_FromUnsignedLongLong(8));
	PyModule_AddObject(m, "DCERPC_FRAG_MAX_SIZE", PyLong_FromUnsignedLongLong(5840));
	PyModule_AddObject(m, "DCERPC_AUTH_LEN_OFFSET", PyLong_FromUnsignedLongLong(10));
	PyModule_AddObject(m, "DCERPC_NCACN_PAYLOAD_OFFSET", PyLong_FromUnsignedLongLong(16));
	PyModule_AddObject(m, "DCERPC_NCACN_REQUEST_DEFAULT_MAX_SIZE", PyLong_FromUnsignedLongLong(0x400000));
	PyModule_AddObject(m, "DCERPC_NCACN_RESPONSE_DEFAULT_MAX_SIZE", PyLong_FromUnsignedLongLong(0xf000000));
	PyModule_AddObject(m, "DCERPC_DREP_LE", PyLong_FromUnsignedLongLong(0x10));
	PyModule_AddObject(m, "DCERPC_SEC_VT_MAX_SIZE", PyLong_FromUnsignedLongLong(1024));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_RESULT_ACCEPTANCE", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_RESULT_ACCEPTANCE)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_RESULT_USER_REJECTION", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_RESULT_USER_REJECTION)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_RESULT_PROVIDER_REJECTION)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_RESULT_NEGOTIATE_ACK)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_REASON_NOT_SPECIFIED", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_REASON_NOT_SPECIFIED)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_REASON_ABSTRACT_SYNTAX_NOT_SUPPORTED)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_REASON_TRANSFER_SYNTAXES_NOT_SUPPORTED)));
	PyModule_AddObject(m, "DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED", PyLong_FromLong((uint16_t)(DCERPC_BIND_ACK_REASON_LOCAL_LIMIT_EXCEEDED)));
	PyModule_AddObject(m, "DCERPC_BIND_TIME_SECURITY_CONTEXT_MULTIPLEXING", PyLong_FromLong((uint16_t)(DCERPC_BIND_TIME_SECURITY_CONTEXT_MULTIPLEXING)));
	PyModule_AddObject(m, "DCERPC_BIND_TIME_KEEP_CONNECTION_ON_ORPHAN", PyLong_FromLong((uint16_t)(DCERPC_BIND_TIME_KEEP_CONNECTION_ON_ORPHAN)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_NOT_SPECIFIED", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_NOT_SPECIFIED)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_TEMPORARY_CONGESTION)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_LOCAL_LIMIT_EXCEEDED)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_PROTOCOL_VERSION_NOT_SUPPORTED)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_INVALID_AUTH_TYPE)));
	PyModule_AddObject(m, "DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM", PyLong_FromLong((uint16_t)(DCERPC_BIND_NAK_REASON_INVALID_CHECKSUM)));
	PyModule_AddObject(m, "DCERPC_NCA_S_COMM_FAILURE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_COMM_FAILURE)));
	PyModule_AddObject(m, "DCERPC_NCA_S_OP_RNG_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_OP_RNG_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNKNOWN_IF", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_UNKNOWN_IF)));
	PyModule_AddObject(m, "DCERPC_NCA_S_WRONG_BOOT_TIME", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_WRONG_BOOT_TIME)));
	PyModule_AddObject(m, "DCERPC_NCA_S_YOU_CRASHED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_YOU_CRASHED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_PROTO_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_PROTO_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_OUT_ARGS_TOO_BIG", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_OUT_ARGS_TOO_BIG)));
	PyModule_AddObject(m, "DCERPC_NCA_S_SERVER_TOO_BUSY", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_SERVER_TOO_BUSY)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_STRING_TOO_LARGE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_STRING_TOO_LARGE)));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNSUPPORTED_TYPE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_UNSUPPORTED_TYPE)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_INT_DIV_BY_ZERO)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_ADDR_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_ADDR_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_FP_DIV_BY_ZERO)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_UNDERFLOW", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_FP_UNDERFLOW)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_OVERRFLOW", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_FP_OVERRFLOW)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INVALID_TAG", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_INVALID_TAG)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INVALID_BOUND", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_INVALID_BOUND)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_RPC_VERSION_MISMATCH)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_UNSPEC_REJECT", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_UNSPEC_REJECT)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_BAD_ACTID", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_BAD_ACTID)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_WHO_ARE_YOU_FAILED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_MANAGER_NOT_ENTERED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CANCEL", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_CANCEL)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_ILL_INST", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_ILL_INST)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_FP_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_FP_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_INT_OVERFLOW", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_INT_OVERFLOW)));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNUSED_1C000011", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_UNUSED_1C000011)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_UNSPEC", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_UNSPEC)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_REMOTE_COMM_FAILURE)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_EMPTY", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_EMPTY)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_CLOSED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_CLOSED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_ORDER", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_ORDER)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_DISCIPLINE)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_COMM_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_PIPE_MEMORY", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_PIPE_MEMORY)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_CONTEXT_MISMATCH)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_REMOTE_NO_MEMORY)));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_INVALID_PRES_CONTEXT_ID)));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_UNSUPPORTED_AUTHN_LEVEL)));
	PyModule_AddObject(m, "DCERPC_NCA_S_UNUSED_1C00001E", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_UNUSED_1C00001E)));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_CHECKSUM", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_INVALID_CHECKSUM)));
	PyModule_AddObject(m, "DCERPC_NCA_S_INVALID_CRC", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_INVALID_CRC)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_USER_DEFINED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_USER_DEFINED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_TX_OPEN_FAILED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_TX_OPEN_FAILED)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_CODESET_CONV_ERROR)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_OBJECT_NOT_FOUND)));
	PyModule_AddObject(m, "DCERPC_NCA_S_FAULT_NO_CLIENT_STUB", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_NCA_S_FAULT_NO_CLIENT_STUB)));
	PyModule_AddObject(m, "DCERPC_FAULT_ACCESS_DENIED", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_ACCESS_DENIED)));
	PyModule_AddObject(m, "DCERPC_FAULT_SERVER_UNAVAILABLE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_SERVER_UNAVAILABLE)));
	PyModule_AddObject(m, "DCERPC_FAULT_NO_CALL_ACTIVE", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_NO_CALL_ACTIVE)));
	PyModule_AddObject(m, "DCERPC_FAULT_CANT_PERFORM", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_CANT_PERFORM)));
	PyModule_AddObject(m, "DCERPC_FAULT_OUT_OF_RESOURCES", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_OUT_OF_RESOURCES)));
	PyModule_AddObject(m, "DCERPC_FAULT_BAD_STUB_DATA", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_BAD_STUB_DATA)));
	PyModule_AddObject(m, "DCERPC_FAULT_SEC_PKG_ERROR", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_FAULT_SEC_PKG_ERROR)));
	PyModule_AddObject(m, "DCERPC_FAULT_FLAG_EXTENDED_ERROR_INFORMATION", PyLong_FromLong((uint16_t)(DCERPC_FAULT_FLAG_EXTENDED_ERROR_INFORMATION)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NONE", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_NONE)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5_1", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_KRB5_1)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SPNEGO", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_SPNEGO)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NTLMSSP", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_NTLMSSP)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_KRB5", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_KRB5)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DPA", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_DPA)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSN", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_MSN)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_DIGEST", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_DIGEST)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_SCHANNEL", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_SCHANNEL)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_MSMQ", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_MSMQ)));
	PyModule_AddObject(m, "DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM", PyLong_FromLong((uint16_t)(DCERPC_AUTH_TYPE_NCALRPC_AS_SYSTEM)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_NONE", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_NONE)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CONNECT", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_CONNECT)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_CALL", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_CALL)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PACKET", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_PACKET)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_INTEGRITY", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_INTEGRITY)));
	PyModule_AddObject(m, "DCERPC_AUTH_LEVEL_PRIVACY", PyLong_FromLong((uint16_t)(DCERPC_AUTH_LEVEL_PRIVACY)));
	PyModule_AddObject(m, "RTS_IPV4", PyLong_FromUnsignedLongLong((uint32_t)(RTS_IPV4)));
	PyModule_AddObject(m, "RTS_IPV6", PyLong_FromUnsignedLongLong((uint32_t)(RTS_IPV6)));
	PyModule_AddObject(m, "FDClient", PyLong_FromUnsignedLongLong((uint32_t)(FDClient)));
	PyModule_AddObject(m, "FDInProxy", PyLong_FromUnsignedLongLong((uint32_t)(FDInProxy)));
	PyModule_AddObject(m, "FDServer", PyLong_FromUnsignedLongLong((uint32_t)(FDServer)));
	PyModule_AddObject(m, "FDOutProxy", PyLong_FromUnsignedLongLong((uint32_t)(FDOutProxy)));
	PyModule_AddObject(m, "RTS_FLAG_NONE", PyLong_FromLong((uint16_t)(RTS_FLAG_NONE)));
	PyModule_AddObject(m, "RTS_FLAG_PING", PyLong_FromLong((uint16_t)(RTS_FLAG_PING)));
	PyModule_AddObject(m, "RTS_FLAG_OTHER_CMD", PyLong_FromLong((uint16_t)(RTS_FLAG_OTHER_CMD)));
	PyModule_AddObject(m, "RTS_FLAG_RECYCLE_CHANNEL", PyLong_FromLong((uint16_t)(RTS_FLAG_RECYCLE_CHANNEL)));
	PyModule_AddObject(m, "RTS_FLAG_IN_CHANNEL", PyLong_FromLong((uint16_t)(RTS_FLAG_IN_CHANNEL)));
	PyModule_AddObject(m, "RTS_FLAG_OUT_CHANNEL", PyLong_FromLong((uint16_t)(RTS_FLAG_OUT_CHANNEL)));
	PyModule_AddObject(m, "RTS_FLAG_EOF", PyLong_FromLong((uint16_t)(RTS_FLAG_EOF)));
	PyModule_AddObject(m, "RTS_FLAG_ECHO", PyLong_FromLong((uint16_t)(RTS_FLAG_ECHO)));
	PyModule_AddObject(m, "DCERPC_PKT_REQUEST", PyLong_FromLong((uint16_t)(DCERPC_PKT_REQUEST)));
	PyModule_AddObject(m, "DCERPC_PKT_PING", PyLong_FromLong((uint16_t)(DCERPC_PKT_PING)));
	PyModule_AddObject(m, "DCERPC_PKT_RESPONSE", PyLong_FromLong((uint16_t)(DCERPC_PKT_RESPONSE)));
	PyModule_AddObject(m, "DCERPC_PKT_FAULT", PyLong_FromLong((uint16_t)(DCERPC_PKT_FAULT)));
	PyModule_AddObject(m, "DCERPC_PKT_WORKING", PyLong_FromLong((uint16_t)(DCERPC_PKT_WORKING)));
	PyModule_AddObject(m, "DCERPC_PKT_NOCALL", PyLong_FromLong((uint16_t)(DCERPC_PKT_NOCALL)));
	PyModule_AddObject(m, "DCERPC_PKT_REJECT", PyLong_FromLong((uint16_t)(DCERPC_PKT_REJECT)));
	PyModule_AddObject(m, "DCERPC_PKT_ACK", PyLong_FromLong((uint16_t)(DCERPC_PKT_ACK)));
	PyModule_AddObject(m, "DCERPC_PKT_CL_CANCEL", PyLong_FromLong((uint16_t)(DCERPC_PKT_CL_CANCEL)));
	PyModule_AddObject(m, "DCERPC_PKT_FACK", PyLong_FromLong((uint16_t)(DCERPC_PKT_FACK)));
	PyModule_AddObject(m, "DCERPC_PKT_CANCEL_ACK", PyLong_FromLong((uint16_t)(DCERPC_PKT_CANCEL_ACK)));
	PyModule_AddObject(m, "DCERPC_PKT_BIND", PyLong_FromLong((uint16_t)(DCERPC_PKT_BIND)));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_ACK", PyLong_FromLong((uint16_t)(DCERPC_PKT_BIND_ACK)));
	PyModule_AddObject(m, "DCERPC_PKT_BIND_NAK", PyLong_FromLong((uint16_t)(DCERPC_PKT_BIND_NAK)));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER", PyLong_FromLong((uint16_t)(DCERPC_PKT_ALTER)));
	PyModule_AddObject(m, "DCERPC_PKT_ALTER_RESP", PyLong_FromLong((uint16_t)(DCERPC_PKT_ALTER_RESP)));
	PyModule_AddObject(m, "DCERPC_PKT_AUTH3", PyLong_FromLong((uint16_t)(DCERPC_PKT_AUTH3)));
	PyModule_AddObject(m, "DCERPC_PKT_SHUTDOWN", PyLong_FromLong((uint16_t)(DCERPC_PKT_SHUTDOWN)));
	PyModule_AddObject(m, "DCERPC_PKT_CO_CANCEL", PyLong_FromLong((uint16_t)(DCERPC_PKT_CO_CANCEL)));
	PyModule_AddObject(m, "DCERPC_PKT_ORPHANED", PyLong_FromLong((uint16_t)(DCERPC_PKT_ORPHANED)));
	PyModule_AddObject(m, "DCERPC_PKT_RTS", PyLong_FromLong((uint16_t)(DCERPC_PKT_RTS)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_FIRST", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_FIRST)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_LAST", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_LAST)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_PENDING_CANCEL_OR_HDR_SIGNING)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_CONC_MPX", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_CONC_MPX)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_DID_NOT_EXECUTE", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_DID_NOT_EXECUTE)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_MAYBE", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_MAYBE)));
	PyModule_AddObject(m, "DCERPC_PFC_FLAG_OBJECT_UUID", PyLong_FromLong((uint16_t)(DCERPC_PFC_FLAG_OBJECT_UUID)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_COMMAND_ENUM", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_COMMAND_ENUM)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_COMMAND_END", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_COMMAND_END)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_MUST_PROCESS", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_MUST_PROCESS)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_COMMAND_BITMASK1", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_COMMAND_BITMASK1)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_COMMAND_PCONTEXT", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_COMMAND_PCONTEXT)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_COMMAND_HEADER2", PyLong_FromLong((uint16_t)(DCERPC_SEC_VT_COMMAND_HEADER2)));
	PyModule_AddObject(m, "DCERPC_SEC_VT_CLIENT_SUPPORTS_HEADER_SIGNING", PyLong_FromUnsignedLongLong((uint32_t)(DCERPC_SEC_VT_CLIENT_SUPPORTS_HEADER_SIGNING)));
	Py_INCREF((PyObject *)(void *)&dcerpc_ctx_list_Type);
	PyModule_AddObject(m, "ctx_list", (PyObject *)(void *)&dcerpc_ctx_list_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_Type);
	PyModule_AddObject(m, "bind", (PyObject *)(void *)&dcerpc_bind_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_empty_Type);
	PyModule_AddObject(m, "empty", (PyObject *)(void *)&dcerpc_empty_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_object_Type);
	PyModule_AddObject(m, "object", (PyObject *)(void *)&dcerpc_object_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_request_Type);
	PyModule_AddObject(m, "request", (PyObject *)(void *)&dcerpc_request_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_ack_reason_Type);
	PyModule_AddObject(m, "bind_ack_reason", (PyObject *)(void *)&dcerpc_bind_ack_reason_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ack_ctx_Type);
	PyModule_AddObject(m, "ack_ctx", (PyObject *)(void *)&dcerpc_ack_ctx_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_ack_Type);
	PyModule_AddObject(m, "bind_ack", (PyObject *)(void *)&dcerpc_bind_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_nak_version_Type);
	PyModule_AddObject(m, "bind_nak_version", (PyObject *)(void *)&dcerpc_bind_nak_version_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_bind_nak_Type);
	PyModule_AddObject(m, "bind_nak", (PyObject *)(void *)&dcerpc_bind_nak_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_response_Type);
	PyModule_AddObject(m, "response", (PyObject *)(void *)&dcerpc_response_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_fault_Type);
	PyModule_AddObject(m, "fault", (PyObject *)(void *)&dcerpc_fault_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_auth_Type);
	PyModule_AddObject(m, "auth", (PyObject *)(void *)&dcerpc_auth_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_auth3_Type);
	PyModule_AddObject(m, "auth3", (PyObject *)(void *)&dcerpc_auth3_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_orphaned_Type);
	PyModule_AddObject(m, "orphaned", (PyObject *)(void *)&dcerpc_orphaned_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_co_cancel_Type);
	PyModule_AddObject(m, "co_cancel", (PyObject *)(void *)&dcerpc_co_cancel_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_cl_cancel_Type);
	PyModule_AddObject(m, "cl_cancel", (PyObject *)(void *)&dcerpc_cl_cancel_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_cancel_ack_Type);
	PyModule_AddObject(m, "cancel_ack", (PyObject *)(void *)&dcerpc_cancel_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_fack_Type);
	PyModule_AddObject(m, "fack", (PyObject *)(void *)&dcerpc_fack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ack_Type);
	PyModule_AddObject(m, "ack", (PyObject *)(void *)&dcerpc_ack_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_ping_Type);
	PyModule_AddObject(m, "ping", (PyObject *)(void *)&dcerpc_ping_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_shutdown_Type);
	PyModule_AddObject(m, "shutdown", (PyObject *)(void *)&dcerpc_shutdown_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_working_Type);
	PyModule_AddObject(m, "working", (PyObject *)(void *)&dcerpc_working_Type);
	Py_INCREF((PyObject *)(void *)&RTSCookie_Type);
	PyModule_AddObject(m, "RTSCookie", (PyObject *)(void *)&RTSCookie_Type);
	Py_INCREF((PyObject *)(void *)&ClientAddressType_Type);
	PyModule_AddObject(m, "ClientAddressType", (PyObject *)(void *)&ClientAddressType_Type);
	Py_INCREF((PyObject *)(void *)&ClientAddress_Type);
	PyModule_AddObject(m, "ClientAddress", (PyObject *)(void *)&ClientAddress_Type);
	Py_INCREF((PyObject *)(void *)&FlowControlAcknowledgment_Type);
	PyModule_AddObject(m, "FlowControlAcknowledgment", (PyObject *)(void *)&FlowControlAcknowledgment_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ReceiveWindowSize_Type);
	PyModule_AddObject(m, "rts_cmd_ReceiveWindowSize", (PyObject *)(void *)&dcerpc_rts_cmd_ReceiveWindowSize_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_FlowControlAck_Type);
	PyModule_AddObject(m, "rts_cmd_FlowControlAck", (PyObject *)(void *)&dcerpc_rts_cmd_FlowControlAck_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ConnectionTimeout_Type);
	PyModule_AddObject(m, "rts_cmd_ConnectionTimeout", (PyObject *)(void *)&dcerpc_rts_cmd_ConnectionTimeout_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Cookie_Type);
	PyModule_AddObject(m, "rts_cmd_Cookie", (PyObject *)(void *)&dcerpc_rts_cmd_Cookie_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ChannelLifetime_Type);
	PyModule_AddObject(m, "rts_cmd_ChannelLifetime", (PyObject *)(void *)&dcerpc_rts_cmd_ChannelLifetime_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ClientKeepalive_Type);
	PyModule_AddObject(m, "rts_cmd_ClientKeepalive", (PyObject *)(void *)&dcerpc_rts_cmd_ClientKeepalive_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Version_Type);
	PyModule_AddObject(m, "rts_cmd_Version", (PyObject *)(void *)&dcerpc_rts_cmd_Version_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Empty_Type);
	PyModule_AddObject(m, "rts_cmd_Empty", (PyObject *)(void *)&dcerpc_rts_cmd_Empty_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Padding_Type);
	PyModule_AddObject(m, "rts_cmd_Padding", (PyObject *)(void *)&dcerpc_rts_cmd_Padding_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_NegativeANCE_Type);
	PyModule_AddObject(m, "rts_cmd_NegativeANCE", (PyObject *)(void *)&dcerpc_rts_cmd_NegativeANCE_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ANCE_Type);
	PyModule_AddObject(m, "rts_cmd_ANCE", (PyObject *)(void *)&dcerpc_rts_cmd_ANCE_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_ClientAddress_Type);
	PyModule_AddObject(m, "rts_cmd_ClientAddress", (PyObject *)(void *)&dcerpc_rts_cmd_ClientAddress_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_AssociationGroupId_Type);
	PyModule_AddObject(m, "rts_cmd_AssociationGroupId", (PyObject *)(void *)&dcerpc_rts_cmd_AssociationGroupId_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Destination_Type);
	PyModule_AddObject(m, "rts_cmd_Destination", (PyObject *)(void *)&dcerpc_rts_cmd_Destination_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
	PyModule_AddObject(m, "rts_cmd_PingTrafficSentNotify", (PyObject *)(void *)&dcerpc_rts_cmd_PingTrafficSentNotify_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmds_Type);
	PyModule_AddObject(m, "rts_cmds", (PyObject *)(void *)&dcerpc_rts_cmds_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_cmd_Type);
	PyModule_AddObject(m, "rts_cmd", (PyObject *)(void *)&dcerpc_rts_cmd_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_rts_Type);
	PyModule_AddObject(m, "rts", (PyObject *)(void *)&dcerpc_rts_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_payload_Type);
	PyModule_AddObject(m, "payload", (PyObject *)(void *)&dcerpc_payload_Type);
	Py_INCREF((PyObject *)(void *)&ncacn_packet_Type);
	PyModule_AddObject(m, "ncacn_packet", (PyObject *)(void *)&ncacn_packet_Type);
	Py_INCREF((PyObject *)(void *)&ncadg_packet_Type);
	PyModule_AddObject(m, "ncadg_packet", (PyObject *)(void *)&ncadg_packet_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_vt_pcontext_Type);
	PyModule_AddObject(m, "sec_vt_pcontext", (PyObject *)(void *)&dcerpc_sec_vt_pcontext_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_vt_header2_Type);
	PyModule_AddObject(m, "sec_vt_header2", (PyObject *)(void *)&dcerpc_sec_vt_header2_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_vt_union_Type);
	PyModule_AddObject(m, "sec_vt_union", (PyObject *)(void *)&dcerpc_sec_vt_union_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_vt_Type);
	PyModule_AddObject(m, "sec_vt", (PyObject *)(void *)&dcerpc_sec_vt_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_vt_count_Type);
	PyModule_AddObject(m, "sec_vt_count", (PyObject *)(void *)&dcerpc_sec_vt_count_Type);
	Py_INCREF((PyObject *)(void *)&dcerpc_sec_verification_trailer_Type);
	PyModule_AddObject(m, "sec_verification_trailer", (PyObject *)(void *)&dcerpc_sec_verification_trailer_Type);
#ifdef PY_MOD_DCERPC_PATCH
	PY_MOD_DCERPC_PATCH(m);
#endif
	out:
	Py_XDECREF(dep_samba_dcerpc_misc);
	Py_XDECREF(dep_talloc);
	return m;

}
