/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*
* Copyright 2020 elementary, Inc. (https://elementary.io)
*           2015 Ivo Nunes, Akshay Shekher
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 3 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "system.h"
#include <adwaita.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <gmodule.h>

#define ABOUT_PLUG_OPERATING_SYSTEM "operating-system"
#define ABOUT_PLUG_HARDWARE "hardware"
#define ABOUT_PLUG_FIRMWARE "firmware"
#define ABOUT_PLUG_DRIVERS "drivers"
#define ABOUT_GETTEXT_PACKAGE "io.elementary.settings.system"
#define ABOUT_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	ABOUT_PLUG_0_PROPERTY,
	ABOUT_PLUG_NUM_PROPERTIES
};
static GParamSpec* about_plug_properties[ABOUT_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _AboutPlugSearchData AboutPlugSearchData;

struct _AboutPlugPrivate {
	AboutOperatingSystemView* operating_system_view;
	AdwToolbarView* toolbarview;
	GtkStack* stack;
	GCancellable* sponsors_goal_cancellable;
};

struct _AboutPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	AboutPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	const gchar* _tmp51_;
	const gchar* _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	const gchar* _tmp55_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	const gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	const gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
};

static gint AboutPlug_private_offset;
static gpointer about_plug_parent_class = NULL;

static GtkWidget* about_plug_real_get_widget (SwitchboardPlug* base);
static void about_plug_real_shown (SwitchboardPlug* base);
static void about_plug_real_hidden (SwitchboardPlug* base);
static void about_plug_real_search_callback (SwitchboardPlug* base,
                                      const gchar* location);
static void about_plug_real_search_data_free (gpointer _data);
static void about_plug_real_search (SwitchboardPlug* base,
                             const gchar* search,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
static gboolean about_plug_real_search_co (AboutPlugSearchData* _data_);
static void about_plug_finalize (GObject * obj);
static GType about_plug_get_type_once (void);

static inline gpointer
about_plug_get_instance_private (AboutPlug* self)
{
	return G_STRUCT_MEMBER_P (self, AboutPlug_private_offset);
}

AboutPlug*
about_plug_construct (GType object_type)
{
	AboutPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (ABOUT_GETTEXT_PACKAGE, ABOUT_LOCALEDIR);
	bind_textdomain_codeset (ABOUT_GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about", NULL);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/os", ABOUT_PLUG_OPERATING_SYSTEM);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/hardware", ABOUT_PLUG_HARDWARE);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/firmware", ABOUT_PLUG_FIRMWARE);
	gee_abstract_map_set ((GeeAbstractMap*) settings, "about/drivers", ABOUT_PLUG_DRIVERS);
	self = (AboutPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_SYSTEM, "code-name", "io.elementary.settings.system", "display-name", _ ("System"), "description", _ ("View operating system and hardware information"), "icon", "application-x-firmware", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

AboutPlug*
about_plug_new (void)
{
	return about_plug_construct (ABOUT_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
about_plug_real_get_widget (SwitchboardPlug* base)
{
	AboutPlug * self;
	AdwToolbarView* _tmp0_;
	AdwToolbarView* _tmp36_;
	GtkWidget* _tmp37_;
	GtkWidget* result;
	self = (AboutPlug*) base;
	_tmp0_ = self->priv->toolbarview;
	if (_tmp0_ == NULL) {
		AboutOperatingSystemView* _tmp1_;
		AboutHardwareView* hardware_view = NULL;
		AboutHardwareView* _tmp2_;
		AboutFirmwareView* firmware_view = NULL;
		AboutFirmwareView* _tmp3_;
		GtkStack* _tmp4_ = NULL;
		GtkStack* _tmp5_;
		AboutOperatingSystemView* _tmp6_;
		GtkStack* _tmp7_;
		AboutHardwareView* _tmp8_;
		GtkStack* _tmp9_;
		AboutFirmwareView* _tmp10_;
		GtkStack* _tmp11_;
		AboutDriversView* _tmp12_;
		AboutDriversView* _tmp13_;
		GtkStackSwitcher* stack_switcher = NULL;
		GtkStack* _tmp14_;
		GtkStack* _tmp15_;
		GtkStackSwitcher* _tmp16_ = NULL;
		GtkSizeGroup* size_group = NULL;
		GtkSizeGroup* _tmp17_;
		GtkWidget* child = NULL;
		GtkStackSwitcher* _tmp18_;
		GtkWidget* _tmp19_;
		GtkWidget* _tmp20_;
		AdwHeaderBar* headerbar = NULL;
		GtkStackSwitcher* _tmp27_;
		GtkWidget* _tmp28_;
		AdwHeaderBar* _tmp29_ = NULL;
		AdwHeaderBar* _tmp30_;
		GtkStack* _tmp31_;
		GtkWidget* _tmp32_;
		AdwToolbarView* _tmp33_ = NULL;
		AdwToolbarView* _tmp34_;
		AdwHeaderBar* _tmp35_;
		_tmp1_ = about_operating_system_view_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->operating_system_view);
		self->priv->operating_system_view = _tmp1_;
		_tmp2_ = about_hardware_view_new ();
		g_object_ref_sink (_tmp2_);
		hardware_view = _tmp2_;
		_tmp3_ = about_firmware_view_new ();
		g_object_ref_sink (_tmp3_);
		firmware_view = _tmp3_;
		_tmp4_ = (GtkStack*) gtk_stack_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp4_, TRUE);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->stack);
		self->priv->stack = _tmp4_;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->operating_system_view;
		gtk_stack_add_titled (_tmp5_, (GtkWidget*) _tmp6_, ABOUT_PLUG_OPERATING_SYSTEM, _ ("Operating System"));
		_tmp7_ = self->priv->stack;
		_tmp8_ = hardware_view;
		gtk_stack_add_titled (_tmp7_, (GtkWidget*) _tmp8_, ABOUT_PLUG_HARDWARE, _ ("Hardware"));
		_tmp9_ = self->priv->stack;
		_tmp10_ = firmware_view;
		gtk_stack_add_titled (_tmp9_, (GtkWidget*) _tmp10_, ABOUT_PLUG_FIRMWARE, _ ("Firmware"));
		_tmp11_ = self->priv->stack;
		_tmp12_ = about_drivers_view_new ();
		g_object_ref_sink (_tmp12_);
		_tmp13_ = _tmp12_;
		gtk_stack_add_titled (_tmp11_, (GtkWidget*) _tmp13_, ABOUT_PLUG_DRIVERS, _ ("Drivers"));
		_g_object_unref0 (_tmp13_);
		_tmp14_ = self->priv->stack;
		_tmp15_ = _g_object_ref0 (_tmp14_);
		_tmp16_ = (GtkStackSwitcher*) gtk_stack_switcher_new ();
		gtk_stack_switcher_set_stack (_tmp16_, _tmp15_);
		_g_object_unref0 (_tmp15_);
		g_object_ref_sink (_tmp16_);
		stack_switcher = _tmp16_;
		_tmp17_ = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
		size_group = _tmp17_;
		_tmp18_ = stack_switcher;
		_tmp19_ = gtk_widget_get_first_child ((GtkWidget*) _tmp18_);
		_tmp20_ = _g_object_ref0 (_tmp19_);
		child = _tmp20_;
		while (TRUE) {
			GtkWidget* _tmp21_;
			GtkSizeGroup* _tmp22_;
			GtkWidget* _tmp23_;
			GtkWidget* _tmp24_;
			GtkWidget* _tmp25_;
			GtkWidget* _tmp26_;
			_tmp21_ = child;
			if (!(_tmp21_ != NULL)) {
				break;
			}
			_tmp22_ = size_group;
			_tmp23_ = child;
			gtk_size_group_add_widget (_tmp22_, _tmp23_);
			_tmp24_ = child;
			_tmp25_ = gtk_widget_get_next_sibling (_tmp24_);
			_tmp26_ = _g_object_ref0 (_tmp25_);
			_g_object_unref0 (child);
			child = _tmp26_;
		}
		_tmp27_ = stack_switcher;
		_tmp28_ = _g_object_ref0 ((GtkWidget*) _tmp27_);
		_tmp29_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_title_widget (_tmp29_, _tmp28_);
		_g_object_unref0 (_tmp28_);
		g_object_ref_sink (_tmp29_);
		headerbar = _tmp29_;
		_tmp30_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp30_, GRANITE_STYLE_CLASS_FLAT);
		_tmp31_ = self->priv->stack;
		_tmp32_ = _g_object_ref0 ((GtkWidget*) _tmp31_);
		_tmp33_ = (AdwToolbarView*) adw_toolbar_view_new ();
		adw_toolbar_view_set_content (_tmp33_, _tmp32_);
		_g_object_unref0 (_tmp32_);
		g_object_ref_sink (_tmp33_);
		_g_object_unref0 (self->priv->toolbarview);
		self->priv->toolbarview = _tmp33_;
		_tmp34_ = self->priv->toolbarview;
		_tmp35_ = headerbar;
		adw_toolbar_view_add_top_bar (_tmp34_, (GtkWidget*) _tmp35_);
		_g_object_unref0 (headerbar);
		_g_object_unref0 (child);
		_g_object_unref0 (size_group);
		_g_object_unref0 (stack_switcher);
		_g_object_unref0 (firmware_view);
		_g_object_unref0 (hardware_view);
	}
	_tmp36_ = self->priv->toolbarview;
	_tmp37_ = _g_object_ref0 ((GtkWidget*) _tmp36_);
	result = _tmp37_;
	return result;
}

static void
about_plug_real_shown (SwitchboardPlug* base)
{
	AboutPlug * self;
	AboutOperatingSystemView* _tmp0_;
	GCancellable* _tmp1_;
	AboutOperatingSystemView* _tmp2_;
	GCancellable* _tmp3_;
	self = (AboutPlug*) base;
	_tmp0_ = self->priv->operating_system_view;
	about_operating_system_view_load_logo (_tmp0_, NULL, NULL);
	_tmp1_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->sponsors_goal_cancellable);
	self->priv->sponsors_goal_cancellable = _tmp1_;
	_tmp2_ = self->priv->operating_system_view;
	_tmp3_ = self->priv->sponsors_goal_cancellable;
	about_operating_system_view_load_sponsors_goal (_tmp2_, _tmp3_);
}

static void
about_plug_real_hidden (SwitchboardPlug* base)
{
	AboutPlug * self;
	GCancellable* _tmp0_;
	self = (AboutPlug*) base;
	_tmp0_ = self->priv->sponsors_goal_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->sponsors_goal_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
}

static void
about_plug_real_search_callback (SwitchboardPlug* base,
                                 const gchar* location)
{
	AboutPlug * self;
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
	static GQuark _tmp1_label0 = 0;
	static GQuark _tmp1_label1 = 0;
	static GQuark _tmp1_label2 = 0;
	static GQuark _tmp1_label3 = 0;
	self = (AboutPlug*) base;
	g_return_if_fail (location != NULL);
	_tmp0_ = location;
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if ((((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (ABOUT_PLUG_OPERATING_SYSTEM)))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (ABOUT_PLUG_HARDWARE))))) || (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (ABOUT_PLUG_FIRMWARE))))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (ABOUT_PLUG_DRIVERS))))) {
		switch (0) {
			default:
			{
				GtkStack* _tmp3_;
				_tmp3_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp3_, location);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkStack* _tmp4_;
				_tmp4_ = self->priv->stack;
				gtk_stack_set_visible_child_name (_tmp4_, ABOUT_PLUG_OPERATING_SYSTEM);
				break;
			}
		}
	}
}

static void
about_plug_real_search_data_free (gpointer _data)
{
	AboutPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (AboutPlugSearchData, _data_);
}

static void
about_plug_real_search (SwitchboardPlug* base,
                        const gchar* search,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	AboutPlug * self;
	AboutPlugSearchData* _data_;
	AboutPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (AboutPlug*) base;
	_data_ = g_slice_new0 (AboutPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, about_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	about_plug_real_search_co (_data_);
}

static GeeTreeMap*
about_plug_search_finish (SwitchboardPlug* base,
                          GAsyncResult* _res_)
{
	GeeTreeMap* result;
	AboutPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
about_plug_real_search_co (AboutPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Operating System"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp8_, _ ("Operating System"), _ ("Automatic Updates"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp12_, _ ("Operating System"), _ ("Basics Guide"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp16_, _ ("Operating System"), _ ("Get Help"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp20_, _ ("Operating System"), _ ("Get Involved or Sponsor Us"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp24_, _ ("Operating System"), _ ("Get Support"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp28_, _ ("Operating System"), _ ("Our Website"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp32_, _ ("Operating System"), _ ("Report a Problem"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp36_, _ ("Operating System"), _ ("Restore Default Settings"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp40_, _ ("Operating System"), _ ("Send Feedback"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp42_, ABOUT_PLUG_OPERATING_SYSTEM);
	_g_free0 (_data_->_tmp42_);
	_data_->_tmp43_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp44_ = _data_->_tmp43_;
	_data_->_tmp45_ = g_strdup_printf ("%s → %s", _data_->_tmp44_, _ ("Hardware"));
	_data_->_tmp46_ = _data_->_tmp45_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp46_, ABOUT_PLUG_HARDWARE);
	_g_free0 (_data_->_tmp46_);
	_data_->_tmp47_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp48_ = _data_->_tmp47_;
	_data_->_tmp49_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp48_, _ ("Hardware"), _ ("Device name"));
	_data_->_tmp50_ = _data_->_tmp49_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp50_, ABOUT_PLUG_HARDWARE);
	_g_free0 (_data_->_tmp50_);
	_data_->_tmp51_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp52_ = _data_->_tmp51_;
	_data_->_tmp53_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp52_, _ ("Hardware"), _ ("Host name"));
	_data_->_tmp54_ = _data_->_tmp53_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp54_, ABOUT_PLUG_HARDWARE);
	_g_free0 (_data_->_tmp54_);
	_data_->_tmp55_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp56_ = _data_->_tmp55_;
	_data_->_tmp57_ = g_strdup_printf ("%s → %s", _data_->_tmp56_, _ ("About This Device"));
	_data_->_tmp58_ = _data_->_tmp57_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp58_, ABOUT_PLUG_HARDWARE);
	_g_free0 (_data_->_tmp58_);
	_data_->_tmp59_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp60_ = _data_->_tmp59_;
	_data_->_tmp61_ = g_strdup_printf ("%s → %s", _data_->_tmp60_, _ ("Firmware"));
	_data_->_tmp62_ = _data_->_tmp61_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp62_, ABOUT_PLUG_FIRMWARE);
	_g_free0 (_data_->_tmp62_);
	_data_->_tmp63_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp64_ = _data_->_tmp63_;
	_data_->_tmp65_ = g_strdup_printf ("%s → %s → %s", _data_->_tmp64_, _ ("Firmware"), _ ("Restart to Firmware Setup…"));
	_data_->_tmp66_ = _data_->_tmp65_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp66_, ABOUT_PLUG_FIRMWARE);
	_g_free0 (_data_->_tmp66_);
	_data_->_tmp67_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp68_ = _data_->_tmp67_;
	_data_->_tmp69_ = g_strdup_printf ("%s → %s", _data_->_tmp68_, _ ("Drivers"));
	_data_->_tmp70_ = _data_->_tmp69_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp70_, ABOUT_PLUG_DRIVERS);
	_g_free0 (_data_->_tmp70_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
about_plug_class_init (AboutPlugClass * klass,
                       gpointer klass_data)
{
	about_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &AboutPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) about_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) about_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) about_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) about_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) about_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) about_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = about_plug_finalize;
}

static void
about_plug_instance_init (AboutPlug * self,
                          gpointer klass)
{
	self->priv = about_plug_get_instance_private (self);
}

static void
about_plug_finalize (GObject * obj)
{
	AboutPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ABOUT_TYPE_PLUG, AboutPlug);
	_g_object_unref0 (self->priv->operating_system_view);
	_g_object_unref0 (self->priv->toolbarview);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->sponsors_goal_cancellable);
	G_OBJECT_CLASS (about_plug_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
about_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AboutPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) about_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AboutPlug), 0, (GInstanceInitFunc) about_plug_instance_init, NULL };
	GType about_plug_type_id;
	about_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "AboutPlug", &g_define_type_info, 0);
	AboutPlug_private_offset = g_type_add_instance_private (about_plug_type_id, sizeof (AboutPlugPrivate));
	return about_plug_type_id;
}

GType
about_plug_get_type (void)
{
	static volatile gsize about_plug_type_id__once = 0;
	if (g_once_init_enter (&about_plug_type_id__once)) {
		GType about_plug_type_id;
		about_plug_type_id = about_plug_get_type_once ();
		g_once_init_leave (&about_plug_type_id__once, about_plug_type_id);
	}
	return about_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	AboutPlug* plug = NULL;
	AboutPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:154: Activating System plug");
	_tmp0_ = about_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

