/* SecretAccountStore.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SecretAccountStore.vala, do not modify */

#include <glib-object.h>
#include <glib.h>
#include <libsecret/secret.h>
#include <stdlib.h>
#include <string.h>
#include <adwaita.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <libsoup/soup.h>
#include <json-glib/json-glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>

#define TUBA_SECRET_ACCOUNT_STORE_VERSION "1"
#define BUILD_DOMAIN "dev.geopjr.Tuba"
#define BUILD_NAME "Tuba"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_TYPE_ACCOUNT_STORE (tuba_account_store_get_type ())
#define TUBA_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore))
#define TUBA_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))
#define TUBA_IS_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_IS_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ACCOUNT_STORE))
#define TUBA_ACCOUNT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ACCOUNT_STORE, TubaAccountStoreClass))

typedef struct _TubaAccountStore TubaAccountStore;
typedef struct _TubaAccountStoreClass TubaAccountStoreClass;
typedef struct _TubaAccountStorePrivate TubaAccountStorePrivate;

#define TUBA_TYPE_ENTITY (tuba_entity_get_type ())
#define TUBA_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_ENTITY, TubaEntity))
#define TUBA_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_ENTITY, TubaEntityClass))
#define TUBA_IS_ENTITY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_ENTITY))
#define TUBA_IS_ENTITY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_ENTITY))
#define TUBA_ENTITY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_ENTITY, TubaEntityClass))

typedef struct _TubaEntity TubaEntity;
typedef struct _TubaEntityClass TubaEntityClass;

#define TUBA_API_TYPE_ACCOUNT (tuba_api_account_get_type ())
#define TUBA_API_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccount))
#define TUBA_API_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))
#define TUBA_API_IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_ACCOUNT))
#define TUBA_API_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_ACCOUNT, TubaAPIAccountClass))

typedef struct _TubaAPIAccount TubaAPIAccount;
typedef struct _TubaAPIAccountClass TubaAPIAccountClass;

#define TUBA_TYPE_INSTANCE_ACCOUNT (tuba_instance_account_get_type ())
#define TUBA_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccount))
#define TUBA_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))
#define TUBA_IS_INSTANCE_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_IS_INSTANCE_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_INSTANCE_ACCOUNT))
#define TUBA_INSTANCE_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_INSTANCE_ACCOUNT, TubaInstanceAccountClass))

typedef struct _TubaInstanceAccount TubaInstanceAccount;
typedef struct _TubaInstanceAccountClass TubaInstanceAccountClass;

#define TUBA_TYPE_SECRET_ACCOUNT_STORE (tuba_secret_account_store_get_type ())
#define TUBA_SECRET_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStore))
#define TUBA_SECRET_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStoreClass))
#define TUBA_IS_SECRET_ACCOUNT_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE))
#define TUBA_IS_SECRET_ACCOUNT_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_SECRET_ACCOUNT_STORE))
#define TUBA_SECRET_ACCOUNT_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStoreClass))

typedef struct _TubaSecretAccountStore TubaSecretAccountStore;
typedef struct _TubaSecretAccountStoreClass TubaSecretAccountStoreClass;
typedef struct _TubaSecretAccountStorePrivate TubaSecretAccountStorePrivate;
enum  {
	TUBA_SECRET_ACCOUNT_STORE_0_PROPERTY,
	TUBA_SECRET_ACCOUNT_STORE_NUM_PROPERTIES
};
static GParamSpec* tuba_secret_account_store_properties[TUBA_SECRET_ACCOUNT_STORE_NUM_PROPERTIES];
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block54Data Block54Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TUBA_DIALOGS_TYPE_NEW_ACCOUNT (tuba_dialogs_new_account_get_type ())
#define TUBA_DIALOGS_NEW_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccount))
#define TUBA_DIALOGS_NEW_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccountClass))
#define TUBA_DIALOGS_IS_NEW_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT))
#define TUBA_DIALOGS_IS_NEW_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_NEW_ACCOUNT))
#define TUBA_DIALOGS_NEW_ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_NEW_ACCOUNT, TubaDialogsNewAccountClass))

typedef struct _TubaDialogsNewAccount TubaDialogsNewAccount;
typedef struct _TubaDialogsNewAccountClass TubaDialogsNewAccountClass;

#define TUBA_TYPE_APPLICATION (tuba_application_get_type ())
#define TUBA_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_APPLICATION, TubaApplication))
#define TUBA_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_APPLICATION, TubaApplicationClass))
#define TUBA_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_APPLICATION))
#define TUBA_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_APPLICATION))
#define TUBA_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_APPLICATION, TubaApplicationClass))

typedef struct _TubaApplication TubaApplication;
typedef struct _TubaApplicationClass TubaApplicationClass;

#define TUBA_APPLICATION_TYPE_QUESTION_TEXT (tuba_application_question_text_get_type ())
typedef struct _TubaApplicationQuestionText TubaApplicationQuestionText;

#define TUBA_APPLICATION_TYPE_QUESTION_BUTTONS (tuba_application_question_buttons_get_type ())
typedef struct _TubaApplicationQuestionButtons TubaApplicationQuestionButtons;

#define TUBA_APPLICATION_TYPE_QUESTION_BUTTON (tuba_application_question_button_get_type ())
typedef struct _TubaApplicationQuestionButton TubaApplicationQuestionButton;
typedef enum  {
	TUBA_APPLICATION_QUESTION_ANSWER_YES,
	TUBA_APPLICATION_QUESTION_ANSWER_NO,
	TUBA_APPLICATION_QUESTION_ANSWER_CLOSE
} TubaApplicationQuestionAnswer;

#define TUBA_APPLICATION_TYPE_QUESTION_ANSWER (tuba_application_question_answer_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block55Data Block55Data;

#define TUBA_TYPE_REQUEST (tuba_request_get_type ())
#define TUBA_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_REQUEST, TubaRequest))
#define TUBA_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_REQUEST, TubaRequestClass))
#define TUBA_IS_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_REQUEST))
#define TUBA_IS_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_REQUEST))
#define TUBA_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_REQUEST, TubaRequestClass))

typedef struct _TubaRequest TubaRequest;
typedef struct _TubaRequestClass TubaRequestClass;
typedef void (*TubaNetworkSuccessCallback) (GInputStream* in_stream, SoupMessageHeaders* response_headers, gpointer user_data, GError** error);

#define TUBA_TYPE_NETWORK (tuba_network_get_type ())
#define TUBA_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_TYPE_NETWORK, TubaNetwork))
#define TUBA_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_TYPE_NETWORK, TubaNetworkClass))
#define TUBA_IS_NETWORK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_TYPE_NETWORK))
#define TUBA_IS_NETWORK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_TYPE_NETWORK))
#define TUBA_NETWORK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_TYPE_NETWORK, TubaNetworkClass))

typedef struct _TubaNetwork TubaNetwork;
typedef struct _TubaNetworkClass TubaNetworkClass;
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define TUBA_DIALOGS_TYPE_MAIN_WINDOW (tuba_dialogs_main_window_get_type ())
#define TUBA_DIALOGS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindow))
#define TUBA_DIALOGS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))
#define TUBA_DIALOGS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_DIALOGS_TYPE_MAIN_WINDOW))
#define TUBA_DIALOGS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_DIALOGS_TYPE_MAIN_WINDOW, TubaDialogsMainWindowClass))

typedef struct _TubaDialogsMainWindow TubaDialogsMainWindow;
typedef struct _TubaDialogsMainWindowClass TubaDialogsMainWindowClass;
typedef struct _Block56Data Block56Data;

#define TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS (tuba_api_instance_v2_api_versions_get_type ())
#define TUBA_API_INSTANCE_V2_API_VERSIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS, TubaAPIInstanceV2APIVersions))
#define TUBA_API_INSTANCE_V2_API_VERSIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS, TubaAPIInstanceV2APIVersionsClass))
#define TUBA_API_INSTANCE_V2_IS_API_VERSIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS))
#define TUBA_API_INSTANCE_V2_IS_API_VERSIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS))
#define TUBA_API_INSTANCE_V2_API_VERSIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_INSTANCE_V2_TYPE_API_VERSIONS, TubaAPIInstanceV2APIVersionsClass))

typedef struct _TubaAPIInstanceV2APIVersions TubaAPIInstanceV2APIVersions;
typedef struct _TubaAPIInstanceV2APIVersionsClass TubaAPIInstanceV2APIVersionsClass;
typedef enum  {
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_NONE = 1 << 0,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_QUOTE = 1 << 1,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_EMOJI_REACTIONS = 1 << 2,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_BUBBLE = 1 << 3,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_GROUP_NOTIFICATIONS = 1 << 4,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_FEATURE_TAGS = 1 << 5,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_ENDORSE_USERS = 1 << 6,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_MUTUALS = 1 << 7,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_TRANSLATION = 1 << 8,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_ICESHRIMP = 1 << 9,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_GLITCH = 1 << 10,
	TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_LOCAL_ONLY = 1 << 11
} TubaInstanceAccountInstanceFeatures;

#define TUBA_INSTANCE_ACCOUNT_TYPE_INSTANCE_FEATURES (tuba_instance_account_instance_features_get_type ())

#define TUBA_API_TYPE_EMOJI (tuba_api_emoji_get_type ())
#define TUBA_API_EMOJI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_API_TYPE_EMOJI, TubaAPIEmoji))
#define TUBA_API_EMOJI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_API_TYPE_EMOJI, TubaAPIEmojiClass))
#define TUBA_API_IS_EMOJI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_API_TYPE_EMOJI))
#define TUBA_API_IS_EMOJI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_API_TYPE_EMOJI))
#define TUBA_API_EMOJI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_API_TYPE_EMOJI, TubaAPIEmojiClass))

typedef struct _TubaAPIEmoji TubaAPIEmoji;
typedef struct _TubaAPIEmojiClass TubaAPIEmojiClass;
#define _secret_value_unref0(var) ((var == NULL) ? NULL : (var = (secret_value_unref (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _TubaAccountStore {
	GObject parent_instance;
	TubaAccountStorePrivate * priv;
};

struct _TubaAccountStoreClass {
	GObjectClass parent_class;
	void (*init) (TubaAccountStore* self, GError** error);
	void (*update_account) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
	void (*load) (TubaAccountStore* self, GError** error);
	void (*save) (TubaAccountStore* self, GError** error);
	void (*add) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
	void (*remove) (TubaAccountStore* self, TubaInstanceAccount* account, GError** error);
};

struct _TubaSecretAccountStore {
	TubaAccountStore parent_instance;
	TubaSecretAccountStorePrivate * priv;
};

struct _TubaSecretAccountStoreClass {
	TubaAccountStoreClass parent_class;
};

struct _TubaSecretAccountStorePrivate {
	SecretSchema* schema;
	GHashTable* schema_attributes;
};

struct _Block54Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	gchar* wiki_page;
};

struct _TubaApplicationQuestionText {
	gchar* text;
	gboolean use_markup;
};

struct _TubaApplicationQuestionButton {
	gchar* label;
	AdwResponseAppearance appearance;
};

struct _TubaApplicationQuestionButtons {
	TubaApplicationQuestionButton yes;
	TubaApplicationQuestionButton no;
};

struct _Block55Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	TubaInstanceAccount* account;
};

struct _Block56Data {
	int _ref_count_;
	TubaSecretAccountStore* self;
	TubaInstanceAccount* account;
};

static gint TubaSecretAccountStore_private_offset;
static gpointer tuba_secret_account_store_parent_class = NULL;
VALA_EXTERN TubaApplication* tuba_app;
VALA_EXTERN TubaNetwork* tuba_network;
VALA_EXTERN TubaAccountStore* tuba_accounts;

VALA_EXTERN GType tuba_account_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAccountStore, g_object_unref)
VALA_EXTERN GType tuba_entity_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaEntity, g_object_unref)
VALA_EXTERN GType tuba_api_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIAccount, g_object_unref)
VALA_EXTERN GType tuba_instance_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaInstanceAccount, g_object_unref)
VALA_EXTERN GType tuba_secret_account_store_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaSecretAccountStore, g_object_unref)
VALA_EXTERN void tuba_account_store_init (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_load (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_save (TubaAccountStore* self,
                              GError** error);
VALA_EXTERN void tuba_account_store_update_account (TubaAccountStore* self,
                                        TubaInstanceAccount* account,
                                        GError** error);
VALA_EXTERN void tuba_account_store_remove (TubaAccountStore* self,
                                TubaInstanceAccount* account,
                                GError** error);
static void tuba_secret_account_store_real_init (TubaAccountStore* base,
                                          GError** error);
static void _g_free0_ (gpointer var);
static void tuba_secret_account_store_real_load (TubaAccountStore* base,
                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static Block54Data* block54_data_ref (Block54Data* _data54_);
static void block54_data_unref (void * _userdata_);
VALA_EXTERN TubaDialogsNewAccount* tuba_dialogs_new_account_new (gboolean can_access_settings);
VALA_EXTERN TubaDialogsNewAccount* tuba_dialogs_new_account_construct (GType object_type,
                                                           gboolean can_access_settings);
VALA_EXTERN GType tuba_dialogs_new_account_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsNewAccount, g_object_unref)
VALA_EXTERN GType tuba_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaApplication, g_object_unref)
VALA_EXTERN GType tuba_application_question_text_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionText* tuba_application_question_text_dup (const TubaApplicationQuestionText* self);
VALA_EXTERN void tuba_application_question_text_free (TubaApplicationQuestionText* self);
VALA_EXTERN void tuba_application_question_text_copy (const TubaApplicationQuestionText* self,
                                          TubaApplicationQuestionText* dest);
VALA_EXTERN void tuba_application_question_text_destroy (TubaApplicationQuestionText* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionText, tuba_application_question_text_destroy)
VALA_EXTERN GType tuba_application_question_buttons_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tuba_application_question_button_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionButton* tuba_application_question_button_dup (const TubaApplicationQuestionButton* self);
VALA_EXTERN void tuba_application_question_button_free (TubaApplicationQuestionButton* self);
VALA_EXTERN void tuba_application_question_button_copy (const TubaApplicationQuestionButton* self,
                                            TubaApplicationQuestionButton* dest);
VALA_EXTERN void tuba_application_question_button_destroy (TubaApplicationQuestionButton* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionButton, tuba_application_question_button_destroy)
VALA_EXTERN TubaApplicationQuestionButtons* tuba_application_question_buttons_dup (const TubaApplicationQuestionButtons* self);
VALA_EXTERN void tuba_application_question_buttons_free (TubaApplicationQuestionButtons* self);
VALA_EXTERN void tuba_application_question_buttons_copy (const TubaApplicationQuestionButtons* self,
                                             TubaApplicationQuestionButtons* dest);
VALA_EXTERN void tuba_application_question_buttons_destroy (TubaApplicationQuestionButtons* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (TubaApplicationQuestionButtons, tuba_application_question_buttons_destroy)
VALA_EXTERN void tuba_application_question (TubaApplication* self,
                                TubaApplicationQuestionText* title,
                                TubaApplicationQuestionText* msg,
                                GtkWidget* win,
                                TubaApplicationQuestionButtons* buttons,
                                GtkWidget* child,
                                gboolean skip,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
VALA_EXTERN GType tuba_application_question_answer_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaApplicationQuestionAnswer tuba_application_question_finish (TubaApplication* self,
                                                                GAsyncResult* _res_);
VALA_EXTERN TubaDialogsNewAccount* tuba_application_get_add_account_window (TubaApplication* self);
static void ___lambda357_ (Block54Data* _data54_,
                    GObject* obj,
                    GAsyncResult* res);
VALA_EXTERN gboolean tuba_application_question_answer_truthy (TubaApplicationQuestionAnswer self);
VALA_EXTERN void tuba_utils_host_open_url (const gchar* _uri,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
VALA_EXTERN gboolean tuba_utils_host_open_url_finish (GAsyncResult* _res_);
static void ___lambda358_ (TubaSecretAccountStore* self,
                    GObject* obj,
                    GAsyncResult* res);
static void ____lambda358__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void ____lambda357__gasync_ready_callback (GObject* source_object,
                                           GAsyncResult* res,
                                           gpointer self);
static void __lambda359_ (TubaSecretAccountStore* self,
                   SecretRetrievable* item);
static Block55Data* block55_data_ref (Block55Data* _data55_);
static void block55_data_unref (void * _userdata_);
static TubaInstanceAccount* tuba_secret_account_store_secret_to_account (TubaSecretAccountStore* self,
                                                                  SecretRetrievable* item);
VALA_EXTERN const gchar* tuba_api_account_get_id (TubaAPIAccount* self);
VALA_EXTERN TubaRequest* tuba_request_new_GET (const gchar* url);
VALA_EXTERN TubaRequest* tuba_request_construct_GET (GType object_type,
                                         const gchar* url);
VALA_EXTERN GType tuba_request_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaRequest, g_object_unref)
VALA_EXTERN TubaRequest* tuba_request_with_account (TubaRequest* self,
                                        TubaInstanceAccount* account);
VALA_EXTERN TubaRequest* tuba_request_then (TubaRequest* self,
                                TubaNetworkSuccessCallback cb,
                                gpointer cb_target,
                                GDestroyNotify cb_target_destroy_notify);
static void ___lambda360_ (Block55Data* _data55_,
                    GInputStream* in_stream,
                    GError** error);
VALA_EXTERN JsonParser* tuba_network_get_parser_from_inputstream (GInputStream* in_stream,
                                                      GError** error);
VALA_EXTERN GType tuba_network_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaNetwork, g_object_unref)
VALA_EXTERN JsonNode* tuba_network_parse_node (TubaNetwork* self,
                                   JsonParser* parser);
VALA_EXTERN TubaAPIAccount* tuba_api_account_from (JsonNode* node,
                                       GError** error);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN const gchar* tuba_api_account_get_display_name (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_avatar (TubaAPIAccount* self);
VALA_EXTERN void tuba_api_account_set_display_name (TubaAPIAccount* self,
                                        const gchar* value);
VALA_EXTERN void tuba_api_account_set_avatar (TubaAPIAccount* self,
                                  const gchar* value);
static void tuba_secret_account_store_account_to_secret (TubaSecretAccountStore* self,
                                                  TubaInstanceAccount* account);
static void ____lambda360__tuba_network_success_callback (GInputStream* in_stream,
                                                   SoupMessageHeaders* response_headers,
                                                   gpointer self,
                                                   GError** error);
VALA_EXTERN TubaRequest* tuba_request_exec (TubaRequest* self);
VALA_EXTERN GeeArrayList* tuba_account_store_get_saved (TubaAccountStore* self);
static void ___lambda359__gfunc (gconstpointer data,
                          gpointer self);
static void tuba_secret_account_store_real_save (TubaAccountStore* base,
                                          GError** error);
static gboolean __lambda362_ (TubaSecretAccountStore* self,
                       TubaInstanceAccount* account);
static gboolean ___lambda362__gee_forall_func (gpointer g,
                                        gpointer self);
static void tuba_secret_account_store_real_update_account (TubaAccountStore* base,
                                                    TubaInstanceAccount* account,
                                                    GError** error);
VALA_EXTERN gchar* tuba_api_account_get_full_handle (TubaAPIAccount* self);
static void tuba_secret_account_store_real_remove (TubaAccountStore* base,
                                            TubaInstanceAccount* account,
                                            GError** error);
VALA_EXTERN gchar* tuba_instance_account_get_handle (TubaInstanceAccount* self);
static void __lambda363_ (TubaSecretAccountStore* self,
                   GObject* obj,
                   GAsyncResult* async_res);
VALA_EXTERN AdwAlertDialog* tuba_application_inform (TubaApplication* self,
                                         const gchar* text,
                                         const gchar* msg);
VALA_EXTERN GType tuba_dialogs_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaDialogsMainWindow, g_object_unref)
VALA_EXTERN TubaDialogsMainWindow* tuba_application_get_main_window (TubaApplication* self);
static void ___lambda363__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static Block56Data* block56_data_ref (Block56Data* _data56_);
static void block56_data_unref (void * _userdata_);
VALA_EXTERN const gchar* tuba_api_account_get_username (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_acct (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_header (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_account_get_url (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_instance (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_client_id (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_client_secret (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_access_token (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_backend (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_uuid (TubaInstanceAccount* self);
VALA_EXTERN gboolean tuba_instance_account_get_admin_mode (TubaInstanceAccount* self);
VALA_EXTERN GType tuba_api_instance_v2_api_versions_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIInstanceV2APIVersions, g_object_unref)
VALA_EXTERN TubaAPIInstanceV2APIVersions* tuba_instance_account_get_tuba_api_versions (TubaInstanceAccount* self);
VALA_EXTERN gint8 tuba_api_instance_v2_api_versions_get_mastodon (TubaAPIInstanceV2APIVersions* self);
VALA_EXTERN gint8 tuba_api_instance_v2_api_versions_get_chuckya (TubaAPIInstanceV2APIVersions* self);
VALA_EXTERN GType tuba_instance_account_instance_features_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TubaInstanceAccountInstanceFeatures tuba_instance_account_get_tuba_instance_features (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_tuba_iceshrimp_api_key (TubaInstanceAccount* self);
VALA_EXTERN const gchar* tuba_instance_account_get_tuba_streaming_url (TubaInstanceAccount* self);
VALA_EXTERN GType tuba_api_emoji_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaAPIEmoji, g_object_unref)
VALA_EXTERN GeeArrayList* tuba_api_account_get_emojis (TubaAPIAccount* self);
VALA_EXTERN const gchar* tuba_api_emoji_get_shortcode (TubaAPIEmoji* self);
VALA_EXTERN const gchar* tuba_api_emoji_get_url (TubaAPIEmoji* self);
static void __lambda361_ (Block56Data* _data56_,
                   GObject* obj,
                   GAsyncResult* async_res);
static void ___lambda361__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN TubaInstanceAccount* tuba_account_store_create_account (TubaAccountStore* self,
                                                        JsonNode* node,
                                                        GError** error);
VALA_EXTERN TubaSecretAccountStore* tuba_secret_account_store_new (void);
VALA_EXTERN TubaSecretAccountStore* tuba_secret_account_store_construct (GType object_type);
VALA_EXTERN TubaAccountStore* tuba_account_store_construct (GType object_type);
static void tuba_secret_account_store_finalize (GObject * obj);
static GType tuba_secret_account_store_get_type_once (void);

static inline gpointer
tuba_secret_account_store_get_instance_private (TubaSecretAccountStore* self)
{
	return G_STRUCT_MEMBER_P (self, TubaSecretAccountStore_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
tuba_secret_account_store_real_init (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashFunc _tmp8_;
	GEqualFunc _tmp9_;
	GHashTable* _tmp10_;
	GHashTable* _tmp11_;
	gchar* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GHashTable* _tmp15_;
	SecretSchema* _tmp16_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = g_strdup_printf ("%i", SECRET_MAJOR_VERSION);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%i", SECRET_MINOR_VERSION);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", SECRET_MICRO_VERSION);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("Using libsecret v", _tmp1_, ".", _tmp3_, ".", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	g_debug ("SecretAccountStore.vala:9: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp8_ = g_str_hash;
	_tmp9_ = g_str_equal;
	_tmp10_ = g_hash_table_new_full (_tmp8_, _tmp9_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->schema_attributes);
	self->priv->schema_attributes = _tmp10_;
	_tmp11_ = self->priv->schema_attributes;
	_tmp12_ = g_strdup ("login");
	g_hash_table_insert (_tmp11_, _tmp12_, (gpointer) ((gintptr) SECRET_SCHEMA_ATTRIBUTE_STRING));
	_tmp13_ = self->priv->schema_attributes;
	_tmp14_ = g_strdup ("version");
	g_hash_table_insert (_tmp13_, _tmp14_, (gpointer) ((gintptr) SECRET_SCHEMA_ATTRIBUTE_STRING));
	_tmp15_ = self->priv->schema_attributes;
	_tmp16_ = secret_schema_newv (BUILD_DOMAIN, SECRET_SCHEMA_DONT_MATCH_NAME, _tmp15_);
	_secret_schema_unref0 (self->priv->schema);
	self->priv->schema = _tmp16_;
	TUBA_ACCOUNT_STORE_CLASS (tuba_secret_account_store_parent_class)->init (G_TYPE_CHECK_INSTANCE_CAST (self, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore), &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static Block54Data*
block54_data_ref (Block54Data* _data54_)
{
	g_atomic_int_inc (&_data54_->_ref_count_);
	return _data54_;
}

static void
block54_data_unref (void * _userdata_)
{
	Block54Data* _data54_;
	_data54_ = (Block54Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data54_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data54_->self;
		_g_free0 (_data54_->wiki_page);
		_g_object_unref0 (self);
		g_slice_free (Block54Data, _data54_);
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
___lambda358_ (TubaSecretAccountStore* self,
               GObject* obj,
               GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	tuba_utils_host_open_url_finish (res);
	exit (1);
}

static void
____lambda358__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda358_ ((TubaSecretAccountStore*) self, source_object, res);
	g_object_unref (self);
}

static void
___lambda357_ (Block54Data* _data54_,
               GObject* obj,
               GAsyncResult* res)
{
	TubaSecretAccountStore* self;
	TubaApplication* _tmp0_;
	self = _data54_->self;
	g_return_if_fail (res != NULL);
	_tmp0_ = tuba_app;
	if (tuba_application_question_answer_truthy (tuba_application_question_finish (_tmp0_, res))) {
		const gchar* _tmp1_;
		_tmp1_ = _data54_->wiki_page;
		tuba_utils_host_open_url (_tmp1_, ____lambda358__gasync_ready_callback, g_object_ref (self));
	} else {
		exit (1);
	}
}

static void
____lambda357__gasync_ready_callback (GObject* source_object,
                                      GAsyncResult* res,
                                      gpointer self)
{
	___lambda357_ (self, source_object, res);
	block54_data_unref (self);
}

static Block55Data*
block55_data_ref (Block55Data* _data55_)
{
	g_atomic_int_inc (&_data55_->_ref_count_);
	return _data55_;
}

static void
block55_data_unref (void * _userdata_)
{
	Block55Data* _data55_;
	_data55_ = (Block55Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data55_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data55_->self;
		_g_object_unref0 (_data55_->account);
		_g_object_unref0 (self);
		g_slice_free (Block55Data, _data55_);
	}
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

static void
___lambda360_ (Block55Data* _data55_,
               GInputStream* in_stream,
               GError** error)
{
	TubaSecretAccountStore* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp0_;
	JsonNode* node = NULL;
	TubaNetwork* _tmp1_;
	JsonParser* _tmp2_;
	JsonNode* _tmp3_;
	TubaAPIAccount* acc = NULL;
	JsonNode* _tmp4_;
	TubaAPIAccount* _tmp5_;
	gboolean _tmp6_ = FALSE;
	TubaInstanceAccount* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	TubaAPIAccount* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = _data55_->self;
	g_return_if_fail (in_stream != NULL);
	_tmp0_ = tuba_network_get_parser_from_inputstream (in_stream, &_inner_error0_);
	parser = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp1_ = tuba_network;
	_tmp2_ = parser;
	_tmp3_ = tuba_network_parse_node (_tmp1_, _tmp2_);
	node = _tmp3_;
	_tmp4_ = node;
	_tmp5_ = tuba_api_account_from (_tmp4_, &_inner_error0_);
	acc = _tmp5_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (parser);
		return;
	}
	_tmp7_ = _data55_->account;
	_tmp8_ = tuba_api_account_get_display_name ((TubaAPIAccount*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = acc;
	_tmp11_ = tuba_api_account_get_display_name (_tmp10_);
	_tmp12_ = _tmp11_;
	if (g_strcmp0 (_tmp9_, _tmp12_) != 0) {
		_tmp6_ = TRUE;
	} else {
		TubaInstanceAccount* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		TubaAPIAccount* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		_tmp13_ = _data55_->account;
		_tmp14_ = tuba_api_account_get_avatar ((TubaAPIAccount*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = acc;
		_tmp17_ = tuba_api_account_get_avatar (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp6_ = g_strcmp0 (_tmp15_, _tmp18_) != 0;
	}
	if (_tmp6_) {
		TubaInstanceAccount* _tmp19_;
		TubaAPIAccount* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		TubaInstanceAccount* _tmp23_;
		TubaAPIAccount* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		TubaInstanceAccount* _tmp27_;
		_tmp19_ = _data55_->account;
		_tmp20_ = acc;
		_tmp21_ = tuba_api_account_get_display_name (_tmp20_);
		_tmp22_ = _tmp21_;
		tuba_api_account_set_display_name ((TubaAPIAccount*) _tmp19_, _tmp22_);
		_tmp23_ = _data55_->account;
		_tmp24_ = acc;
		_tmp25_ = tuba_api_account_get_avatar (_tmp24_);
		_tmp26_ = _tmp25_;
		tuba_api_account_set_avatar ((TubaAPIAccount*) _tmp23_, _tmp26_);
		_tmp27_ = _data55_->account;
		tuba_secret_account_store_account_to_secret (self, _tmp27_);
	}
	_g_object_unref0 (acc);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (parser);
}

static void
____lambda360__tuba_network_success_callback (GInputStream* in_stream,
                                              SoupMessageHeaders* response_headers,
                                              gpointer self,
                                              GError** error)
{
	___lambda360_ (self, in_stream, error);
}

static void
__lambda359_ (TubaSecretAccountStore* self,
              SecretRetrievable* item)
{
	Block55Data* _data55_;
	TubaInstanceAccount* _tmp0_;
	gboolean _tmp1_ = FALSE;
	TubaInstanceAccount* _tmp2_;
	g_return_if_fail (item != NULL);
	_data55_ = g_slice_new0 (Block55Data);
	_data55_->_ref_count_ = 1;
	_data55_->self = g_object_ref (self);
	_tmp0_ = tuba_secret_account_store_secret_to_account (self, item);
	_data55_->account = _tmp0_;
	_tmp2_ = _data55_->account;
	if (_tmp2_ != NULL) {
		TubaInstanceAccount* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp3_ = _data55_->account;
		_tmp4_ = tuba_api_account_get_id ((TubaAPIAccount*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = g_strcmp0 (_tmp5_, "") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		TubaInstanceAccount* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		TubaRequest* _tmp12_;
		TubaRequest* _tmp13_;
		TubaInstanceAccount* _tmp14_;
		TubaRequest* _tmp15_;
		TubaRequest* _tmp16_;
		TubaRequest* _tmp17_;
		TubaRequest* _tmp18_;
		TubaRequest* _tmp19_;
		TubaRequest* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _tmp22_;
		TubaInstanceAccount* _tmp23_;
		TubaInstanceAccount* _tmp24_;
		_tmp6_ = _data55_->account;
		_tmp7_ = tuba_api_account_get_id ((TubaAPIAccount*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("/api/v1/accounts/", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = tuba_request_new_GET (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _data55_->account;
		_tmp15_ = tuba_request_with_account (_tmp13_, _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = tuba_request_then (_tmp16_, ____lambda360__tuba_network_success_callback, block55_data_ref (_data55_), block55_data_unref);
		_tmp18_ = _tmp17_;
		_tmp19_ = tuba_request_exec (_tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp20_);
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (_tmp16_);
		_g_object_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_tmp21_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _data55_->account;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
		_tmp24_ = _data55_->account;
		g_signal_emit_by_name (_tmp24_, "added");
	}
	block55_data_unref (_data55_);
	_data55_ = NULL;
}

static void
___lambda359__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda359_ ((TubaSecretAccountStore*) self, (SecretRetrievable*) data);
}

static void
tuba_secret_account_store_real_load (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	GHashTable* attrs = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GList* secrets = NULL;
	GList* _tmp43_;
	GeeArrayList* _tmp44_;
	GeeArrayList* _tmp45_;
	GeeArrayList* _tmp46_;
	GeeArrayList* _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attrs = _tmp2_;
	_tmp3_ = g_strdup ("version");
	_tmp4_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (attrs, _tmp3_, _tmp4_);
	secrets = NULL;
	{
		GList* _tmp5_ = NULL;
		SecretSchema* _tmp6_;
		GList* _tmp7_;
		GList* _tmp8_;
		_tmp6_ = self->priv->schema;
		_tmp7_ = secret_password_searchv_sync (_tmp6_, attrs, SECRET_SEARCH_ALL | SECRET_SEARCH_UNLOCK, NULL, &_inner_error0_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
		secrets = _tmp8_;
		(_tmp5_ == NULL) ? NULL : (_tmp5_ = (_g_list_free__g_object_unref0_ (_tmp5_), NULL));
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block54Data* _data54_;
		gchar* _tmp9_;
		gchar* help_msg = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		TubaDialogsNewAccount* _tmp30_;
		TubaDialogsNewAccount* _tmp31_;
		TubaApplication* _tmp32_;
		TubaApplicationQuestionText _tmp33_ = {0};
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		TubaApplicationQuestionText _tmp38_ = {0};
		TubaApplication* _tmp39_;
		TubaDialogsNewAccount* _tmp40_;
		TubaDialogsNewAccount* _tmp41_;
		TubaApplicationQuestionButtons _tmp42_ = {0};
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data54_ = g_slice_new0 (Block54Data);
		_data54_->_ref_count_ = 1;
		_data54_->self = g_object_ref (self);
		_tmp9_ = g_strdup ("https://github.com/GeopJr/Tuba/wiki/keyring-issues");
		_data54_->wiki_page = _tmp9_;
		_tmp10_ = g_strdup ("If you didn’t manually cancel it, try creating a password keyring name" \
"d \"login\" using Passwords and Keys (seahorse) or KWalletManager");
		help_msg = _tmp10_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		if (g_strcmp0 (_tmp12_, "org.freedesktop.DBus.Error.ServiceUnknown") == 0) {
			gchar* _tmp13_;
			GError* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = g_strdup ("https://github.com/GeopJr/Tuba/wiki/libsecret-issues");
			_g_free0 (_data54_->wiki_page);
			_data54_->wiki_page = _tmp13_;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = string_to_string (BUILD_NAME);
			_tmp18_ = g_strconcat (_tmp16_, ", ", _tmp17_, " might be missing some permissions", NULL);
			_g_free0 (help_msg);
			help_msg = _tmp18_;
		}
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		_tmp21_ = string_to_string (_tmp20_);
		_tmp22_ = g_strconcat ("Error while searching for items in the secret service: ", _tmp21_, NULL);
		_tmp23_ = _tmp22_;
		g_critical ("SecretAccountStore.vala:50: %s", _tmp23_);
		_g_free0 (_tmp23_);
		_tmp24_ = help_msg;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = _data54_->wiki_page;
		_tmp27_ = string_to_string (_tmp26_);
		_tmp28_ = g_strconcat (_tmp25_, "\nread more: ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		g_warning ("SecretAccountStore.vala:51: %s", _tmp29_);
		_g_free0 (_tmp29_);
		_tmp30_ = tuba_dialogs_new_account_new (FALSE);
		g_object_ref_sink (_tmp30_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp31_);
		_tmp32_ = tuba_app;
		_g_free0 (_tmp33_.text);
		_tmp33_.text = "Error while searching for user accounts";
		_tmp33_.use_markup = FALSE;
		_tmp34_ = help_msg;
		_tmp35_ = string_to_string (_tmp34_);
		_tmp36_ = g_strconcat (_tmp35_, ".", NULL);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp38_.text);
		_tmp38_.text = _tmp37_;
		_tmp38_.use_markup = FALSE;
		_tmp39_ = tuba_app;
		_tmp40_ = tuba_application_get_add_account_window (_tmp39_);
		_tmp41_ = _tmp40_;
		tuba_application_question_button_destroy (&_tmp42_.yes);
		_tmp42_.yes = (TubaApplicationQuestionButton) {"Read More", ADW_RESPONSE_SUGGESTED};
		tuba_application_question_button_destroy (&_tmp42_.no);
		_tmp42_.no = (TubaApplicationQuestionButton) {"Close", ADW_RESPONSE_DEFAULT};
		tuba_application_question (_tmp32_, &_tmp33_, &_tmp38_, (GtkWidget*) _tmp41_, &_tmp42_, NULL, FALSE, ____lambda357__gasync_ready_callback, block54_data_ref (_data54_));
		_g_free0 (_tmp37_);
		_g_free0 (help_msg);
		_g_error_free0 (e);
		block54_data_unref (_data54_);
		_data54_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
		_g_hash_table_unref0 (attrs);
		return;
	}
	_tmp43_ = secrets;
	g_list_foreach (_tmp43_, ___lambda359__gfunc, self);
	_tmp44_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp45_ = _tmp44_;
	g_signal_emit_by_name ((TubaAccountStore*) self, "changed", _tmp45_);
	_tmp46_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp47_);
	_tmp49_ = _tmp48_;
	_tmp50_ = g_strdup_printf ("%i", _tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = g_strconcat ("Loaded ", _tmp51_, " accounts", NULL);
	_tmp53_ = _tmp52_;
	g_debug ("SecretAccountStore.vala:98: %s", _tmp53_);
	_g_free0 (_tmp53_);
	_g_free0 (_tmp51_);
	(secrets == NULL) ? NULL : (secrets = (_g_list_free__g_object_unref0_ (secrets), NULL));
	_g_hash_table_unref0 (attrs);
}

static gboolean
__lambda362_ (TubaSecretAccountStore* self,
              TubaInstanceAccount* account)
{
	gboolean result;
	g_return_val_if_fail (account != NULL, FALSE);
	tuba_secret_account_store_account_to_secret (self, account);
	result = TRUE;
	_g_object_unref0 (account);
	return result;
}

static gboolean
___lambda362__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda362_ ((TubaSecretAccountStore*) self, (TubaInstanceAccount*) g);
	return result;
}

static void
tuba_secret_account_store_real_save (TubaAccountStore* base,
                                     GError** error)
{
	TubaSecretAccountStore * self;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (TubaSecretAccountStore*) base;
	_tmp0_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp1_ = _tmp0_;
	gee_abstract_collection_foreach ((GeeAbstractCollection*) _tmp1_, ___lambda362__gee_forall_func, self);
	_tmp2_ = tuba_account_store_get_saved ((TubaAccountStore*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%i", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("Saved ", _tmp7_, " accounts", NULL);
	_tmp9_ = _tmp8_;
	g_debug ("SecretAccountStore.vala:106: %s", _tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
}

static void
tuba_secret_account_store_real_update_account (TubaAccountStore* base,
                                               TubaInstanceAccount* account,
                                               GError** error)
{
	TubaSecretAccountStore * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (TubaSecretAccountStore*) base;
	g_return_if_fail (account != NULL);
	tuba_secret_account_store_account_to_secret (self, account);
	_tmp0_ = tuba_api_account_get_full_handle ((TubaAPIAccount*) account);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("Updated ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("SecretAccountStore.vala:111: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
__lambda363_ (TubaSecretAccountStore* self,
              GObject* obj,
              GAsyncResult* async_res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (async_res != NULL);
	{
		secret_password_clear_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		AdwAlertDialog* dlg = NULL;
		TubaApplication* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		AdwAlertDialog* _tmp5_;
		AdwAlertDialog* _tmp6_;
		TubaApplication* _tmp7_;
		TubaDialogsMainWindow* _tmp8_;
		TubaDialogsMainWindow* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("SecretAccountStore.vala:131: %s", _tmp1_);
		_tmp2_ = tuba_app;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = tuba_application_inform (_tmp2_, _ ("Error"), _tmp4_);
		dlg = _tmp5_;
		_tmp6_ = dlg;
		_tmp7_ = tuba_app;
		_tmp8_ = tuba_application_get_main_window (_tmp7_);
		_tmp9_ = _tmp8_;
		adw_dialog_present ((AdwDialog*) _tmp6_, (GtkWidget*) _tmp9_);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda363__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda363_ ((TubaSecretAccountStore*) self, source_object, res);
	g_object_unref (self);
}

static void
tuba_secret_account_store_real_remove (TubaAccountStore* base,
                                       TubaInstanceAccount* account,
                                       GError** error)
{
	TubaSecretAccountStore * self;
	GHashTable* attrs = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GHashTable* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	SecretSchema* _tmp10_;
	GHashTable* _tmp11_;
	GHashTable* _tmp12_;
	GError* _inner_error0_ = NULL;
	self = (TubaSecretAccountStore*) base;
	g_return_if_fail (account != NULL);
	TUBA_ACCOUNT_STORE_CLASS (tuba_secret_account_store_parent_class)->remove (G_TYPE_CHECK_INSTANCE_CAST (self, TUBA_TYPE_ACCOUNT_STORE, TubaAccountStore), account, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	attrs = _tmp2_;
	_tmp3_ = attrs;
	_tmp4_ = g_strdup ("version");
	_tmp5_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp5_);
	_tmp6_ = attrs;
	_tmp7_ = g_strdup ("login");
	_tmp8_ = tuba_instance_account_get_handle (account);
	_tmp9_ = _tmp8_;
	g_hash_table_insert (_tmp6_, _tmp7_, _tmp9_);
	_tmp10_ = self->priv->schema;
	_tmp11_ = attrs;
	_tmp12_ = _g_hash_table_ref0 (_tmp11_);
	secret_password_clearv (_tmp10_, _tmp12_, NULL, ___lambda363__gasync_ready_callback, g_object_ref (self));
	_g_hash_table_unref0 (attrs);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block56Data*
block56_data_ref (Block56Data* _data56_)
{
	g_atomic_int_inc (&_data56_->_ref_count_);
	return _data56_;
}

static void
block56_data_unref (void * _userdata_)
{
	Block56Data* _data56_;
	_data56_ = (Block56Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data56_->_ref_count_)) {
		TubaSecretAccountStore* self;
		self = _data56_->self;
		_g_object_unref0 (_data56_->account);
		_g_object_unref0 (self);
		g_slice_free (Block56Data, _data56_);
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
__lambda361_ (Block56Data* _data56_,
              GObject* obj,
              GAsyncResult* async_res)
{
	TubaSecretAccountStore* self;
	GError* _inner_error0_ = NULL;
	self = _data56_->self;
	g_return_if_fail (async_res != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		secret_password_store_finish (async_res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp0_ = tuba_instance_account_get_handle (_data56_->account);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Saved secret for ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		g_debug ("SecretAccountStore.vala:264: %s", _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		AdwAlertDialog* dlg = NULL;
		TubaApplication* _tmp8_;
		GError* _tmp9_;
		const gchar* _tmp10_;
		AdwAlertDialog* _tmp11_;
		AdwAlertDialog* _tmp12_;
		TubaApplication* _tmp13_;
		TubaDialogsMainWindow* _tmp14_;
		TubaDialogsMainWindow* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("SecretAccountStore.vala:267: %s", _tmp7_);
		_tmp8_ = tuba_app;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		_tmp11_ = tuba_application_inform (_tmp8_, _ ("Error"), _tmp10_);
		dlg = _tmp11_;
		_tmp12_ = dlg;
		_tmp13_ = tuba_app;
		_tmp14_ = tuba_application_get_main_window (_tmp13_);
		_tmp15_ = _tmp14_;
		adw_dialog_present ((AdwDialog*) _tmp12_, (GtkWidget*) _tmp15_);
		_g_object_unref0 (dlg);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda361__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda361_ (self, source_object, res);
	block56_data_unref (self);
}

static void
tuba_secret_account_store_account_to_secret (TubaSecretAccountStore* self,
                                             TubaInstanceAccount* account)
{
	Block56Data* _data56_;
	TubaInstanceAccount* _tmp0_;
	GHashTable* attrs = NULL;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp11_;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp12_;
	JsonBuilder* _tmp13_;
	JsonBuilder* _tmp14_;
	JsonBuilder* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	JsonBuilder* _tmp18_;
	JsonBuilder* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	JsonBuilder* _tmp22_;
	JsonBuilder* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	JsonBuilder* _tmp26_;
	JsonBuilder* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	JsonBuilder* _tmp30_;
	JsonBuilder* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_;
	JsonBuilder* _tmp34_;
	JsonBuilder* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	JsonBuilder* _tmp38_;
	JsonBuilder* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	JsonBuilder* _tmp42_;
	JsonBuilder* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	JsonBuilder* _tmp46_;
	JsonBuilder* _tmp47_;
	const gchar* _tmp48_;
	const gchar* _tmp49_;
	JsonBuilder* _tmp50_;
	JsonBuilder* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	JsonBuilder* _tmp54_;
	JsonBuilder* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	JsonBuilder* _tmp58_;
	JsonBuilder* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	JsonBuilder* _tmp63_;
	JsonBuilder* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	JsonBuilder* _tmp67_;
	JsonBuilder* _tmp68_;
	const gchar* _tmp69_;
	const gchar* _tmp70_;
	JsonBuilder* _tmp71_;
	JsonBuilder* _tmp72_;
	gboolean _tmp73_;
	gboolean _tmp74_;
	JsonBuilder* _tmp75_;
	JsonBuilder* _tmp76_;
	TubaAPIInstanceV2APIVersions* _tmp77_;
	TubaAPIInstanceV2APIVersions* _tmp78_;
	gint8 _tmp79_;
	gint8 _tmp80_;
	TubaAPIInstanceV2APIVersions* _tmp87_;
	TubaAPIInstanceV2APIVersions* _tmp88_;
	gint8 _tmp89_;
	gint8 _tmp90_;
	JsonBuilder* _tmp97_;
	JsonBuilder* _tmp98_;
	JsonBuilder* _tmp99_;
	TubaInstanceAccountInstanceFeatures _tmp100_;
	TubaInstanceAccountInstanceFeatures _tmp101_;
	gboolean _tmp102_ = FALSE;
	TubaInstanceAccountInstanceFeatures _tmp103_;
	TubaInstanceAccountInstanceFeatures _tmp104_;
	gboolean _tmp111_ = FALSE;
	const gchar* _tmp112_;
	const gchar* _tmp113_;
	JsonBuilder* _tmp122_;
	JsonBuilder* _tmp123_;
	gboolean _tmp124_ = FALSE;
	GeeArrayList* _tmp125_;
	GeeArrayList* _tmp126_;
	JsonBuilder* _tmp152_;
	JsonBuilder* _tmp153_;
	JsonGenerator* _tmp154_;
	JsonBuilder* _tmp155_;
	JsonNode* _tmp156_;
	JsonNode* _tmp157_;
	gchar* secret = NULL;
	JsonGenerator* _tmp158_;
	gchar* _tmp159_;
	gchar* _tmp160_ = NULL;
	gboolean _tmp161_ = FALSE;
	const gchar* _tmp162_;
	const gchar* _tmp163_;
	gchar* label = NULL;
	gchar* _tmp180_;
	SecretSchema* _tmp181_;
	GHashTable* _tmp182_;
	GHashTable* _tmp183_;
	const gchar* _tmp184_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	_data56_ = g_slice_new0 (Block56Data);
	_data56_->_ref_count_ = 1;
	_data56_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (account);
	_g_object_unref0 (_data56_->account);
	_data56_->account = _tmp0_;
	_tmp1_ = g_str_hash;
	_tmp2_ = g_str_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_free0_, _g_free0_);
	attrs = _tmp3_;
	_tmp4_ = attrs;
	_tmp5_ = g_strdup ("login");
	_tmp6_ = tuba_instance_account_get_handle (_data56_->account);
	_tmp7_ = _tmp6_;
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp7_);
	_tmp8_ = attrs;
	_tmp9_ = g_strdup ("version");
	_tmp10_ = g_strdup (TUBA_SECRET_ACCOUNT_STORE_VERSION);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = json_generator_new ();
	generator = _tmp11_;
	_tmp12_ = json_builder_new ();
	builder = _tmp12_;
	_tmp13_ = builder;
	json_builder_begin_object (_tmp13_);
	_tmp14_ = builder;
	json_builder_set_member_name (_tmp14_, "id");
	_tmp15_ = builder;
	_tmp16_ = tuba_api_account_get_id ((TubaAPIAccount*) _data56_->account);
	_tmp17_ = _tmp16_;
	json_builder_add_string_value (_tmp15_, _tmp17_);
	_tmp18_ = builder;
	json_builder_set_member_name (_tmp18_, "username");
	_tmp19_ = builder;
	_tmp20_ = tuba_api_account_get_username ((TubaAPIAccount*) _data56_->account);
	_tmp21_ = _tmp20_;
	json_builder_add_string_value (_tmp19_, _tmp21_);
	_tmp22_ = builder;
	json_builder_set_member_name (_tmp22_, "display-name");
	_tmp23_ = builder;
	_tmp24_ = tuba_api_account_get_display_name ((TubaAPIAccount*) _data56_->account);
	_tmp25_ = _tmp24_;
	json_builder_add_string_value (_tmp23_, _tmp25_);
	_tmp26_ = builder;
	json_builder_set_member_name (_tmp26_, "acct");
	_tmp27_ = builder;
	_tmp28_ = tuba_api_account_get_acct ((TubaAPIAccount*) _data56_->account);
	_tmp29_ = _tmp28_;
	json_builder_add_string_value (_tmp27_, _tmp29_);
	_tmp30_ = builder;
	json_builder_set_member_name (_tmp30_, "header");
	_tmp31_ = builder;
	_tmp32_ = tuba_api_account_get_header ((TubaAPIAccount*) _data56_->account);
	_tmp33_ = _tmp32_;
	json_builder_add_string_value (_tmp31_, _tmp33_);
	_tmp34_ = builder;
	json_builder_set_member_name (_tmp34_, "avatar");
	_tmp35_ = builder;
	_tmp36_ = tuba_api_account_get_avatar ((TubaAPIAccount*) _data56_->account);
	_tmp37_ = _tmp36_;
	json_builder_add_string_value (_tmp35_, _tmp37_);
	_tmp38_ = builder;
	json_builder_set_member_name (_tmp38_, "url");
	_tmp39_ = builder;
	_tmp40_ = tuba_api_account_get_url ((TubaAPIAccount*) _data56_->account);
	_tmp41_ = _tmp40_;
	json_builder_add_string_value (_tmp39_, _tmp41_);
	_tmp42_ = builder;
	json_builder_set_member_name (_tmp42_, "instance");
	_tmp43_ = builder;
	_tmp44_ = tuba_instance_account_get_instance (_data56_->account);
	_tmp45_ = _tmp44_;
	json_builder_add_string_value (_tmp43_, _tmp45_);
	_tmp46_ = builder;
	json_builder_set_member_name (_tmp46_, "client-id");
	_tmp47_ = builder;
	_tmp48_ = tuba_instance_account_get_client_id (_data56_->account);
	_tmp49_ = _tmp48_;
	json_builder_add_string_value (_tmp47_, _tmp49_);
	_tmp50_ = builder;
	json_builder_set_member_name (_tmp50_, "client-secret");
	_tmp51_ = builder;
	_tmp52_ = tuba_instance_account_get_client_secret (_data56_->account);
	_tmp53_ = _tmp52_;
	json_builder_add_string_value (_tmp51_, _tmp53_);
	_tmp54_ = builder;
	json_builder_set_member_name (_tmp54_, "access-token");
	_tmp55_ = builder;
	_tmp56_ = tuba_instance_account_get_access_token (_data56_->account);
	_tmp57_ = _tmp56_;
	json_builder_add_string_value (_tmp55_, _tmp57_);
	_tmp58_ = builder;
	json_builder_set_member_name (_tmp58_, "handle");
	_tmp59_ = builder;
	_tmp60_ = tuba_instance_account_get_handle (_data56_->account);
	_tmp61_ = _tmp60_;
	_tmp62_ = _tmp61_;
	json_builder_add_string_value (_tmp59_, _tmp62_);
	_g_free0 (_tmp62_);
	_tmp63_ = builder;
	json_builder_set_member_name (_tmp63_, "backend");
	_tmp64_ = builder;
	_tmp65_ = tuba_instance_account_get_backend (_data56_->account);
	_tmp66_ = _tmp65_;
	json_builder_add_string_value (_tmp64_, _tmp66_);
	_tmp67_ = builder;
	json_builder_set_member_name (_tmp67_, "uuid");
	_tmp68_ = builder;
	_tmp69_ = tuba_instance_account_get_uuid (_data56_->account);
	_tmp70_ = _tmp69_;
	json_builder_add_string_value (_tmp68_, _tmp70_);
	_tmp71_ = builder;
	json_builder_set_member_name (_tmp71_, "admin-mode");
	_tmp72_ = builder;
	_tmp73_ = tuba_instance_account_get_admin_mode (_data56_->account);
	_tmp74_ = _tmp73_;
	json_builder_add_boolean_value (_tmp72_, _tmp74_);
	_tmp75_ = builder;
	json_builder_set_member_name (_tmp75_, "api-versions");
	_tmp76_ = builder;
	json_builder_begin_object (_tmp76_);
	_tmp77_ = tuba_instance_account_get_tuba_api_versions (_data56_->account);
	_tmp78_ = _tmp77_;
	_tmp79_ = tuba_api_instance_v2_api_versions_get_mastodon (_tmp78_);
	_tmp80_ = _tmp79_;
	if (((gint) _tmp80_) > 0) {
		JsonBuilder* _tmp81_;
		JsonBuilder* _tmp82_;
		TubaAPIInstanceV2APIVersions* _tmp83_;
		TubaAPIInstanceV2APIVersions* _tmp84_;
		gint8 _tmp85_;
		gint8 _tmp86_;
		_tmp81_ = builder;
		json_builder_set_member_name (_tmp81_, "mastodon");
		_tmp82_ = builder;
		_tmp83_ = tuba_instance_account_get_tuba_api_versions (_data56_->account);
		_tmp84_ = _tmp83_;
		_tmp85_ = tuba_api_instance_v2_api_versions_get_mastodon (_tmp84_);
		_tmp86_ = _tmp85_;
		json_builder_add_int_value (_tmp82_, (gint64) _tmp86_);
	}
	_tmp87_ = tuba_instance_account_get_tuba_api_versions (_data56_->account);
	_tmp88_ = _tmp87_;
	_tmp89_ = tuba_api_instance_v2_api_versions_get_chuckya (_tmp88_);
	_tmp90_ = _tmp89_;
	if (((gint) _tmp90_) > 0) {
		JsonBuilder* _tmp91_;
		JsonBuilder* _tmp92_;
		TubaAPIInstanceV2APIVersions* _tmp93_;
		TubaAPIInstanceV2APIVersions* _tmp94_;
		gint8 _tmp95_;
		gint8 _tmp96_;
		_tmp91_ = builder;
		json_builder_set_member_name (_tmp91_, "chuckya");
		_tmp92_ = builder;
		_tmp93_ = tuba_instance_account_get_tuba_api_versions (_data56_->account);
		_tmp94_ = _tmp93_;
		_tmp95_ = tuba_api_instance_v2_api_versions_get_chuckya (_tmp94_);
		_tmp96_ = _tmp95_;
		json_builder_add_int_value (_tmp92_, (gint64) _tmp96_);
	}
	_tmp97_ = builder;
	json_builder_end_object (_tmp97_);
	_tmp98_ = builder;
	json_builder_set_member_name (_tmp98_, "instance-features");
	_tmp99_ = builder;
	_tmp100_ = tuba_instance_account_get_tuba_instance_features (_data56_->account);
	_tmp101_ = _tmp100_;
	json_builder_add_int_value (_tmp99_, (gint64) ((gint) _tmp101_));
	_tmp103_ = tuba_instance_account_get_tuba_instance_features (_data56_->account);
	_tmp104_ = _tmp103_;
	if ((_tmp104_ & TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_ICESHRIMP) == TUBA_INSTANCE_ACCOUNT_INSTANCE_FEATURES_ICESHRIMP) {
		const gchar* _tmp105_;
		const gchar* _tmp106_;
		_tmp105_ = tuba_instance_account_get_tuba_iceshrimp_api_key (_data56_->account);
		_tmp106_ = _tmp105_;
		_tmp102_ = _tmp106_ != NULL;
	} else {
		_tmp102_ = FALSE;
	}
	if (_tmp102_) {
		JsonBuilder* _tmp107_;
		JsonBuilder* _tmp108_;
		const gchar* _tmp109_;
		const gchar* _tmp110_;
		_tmp107_ = builder;
		json_builder_set_member_name (_tmp107_, "iceshrimp-api-key");
		_tmp108_ = builder;
		_tmp109_ = tuba_instance_account_get_tuba_iceshrimp_api_key (_data56_->account);
		_tmp110_ = _tmp109_;
		json_builder_add_string_value (_tmp108_, _tmp110_);
	}
	_tmp112_ = tuba_instance_account_get_tuba_streaming_url (_data56_->account);
	_tmp113_ = _tmp112_;
	if (g_strcmp0 (_tmp113_, "") != 0) {
		const gchar* _tmp114_;
		const gchar* _tmp115_;
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		_tmp114_ = tuba_instance_account_get_tuba_streaming_url (_data56_->account);
		_tmp115_ = _tmp114_;
		_tmp116_ = tuba_instance_account_get_instance (_data56_->account);
		_tmp117_ = _tmp116_;
		_tmp111_ = g_strcmp0 (_tmp115_, _tmp117_) != 0;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		JsonBuilder* _tmp118_;
		JsonBuilder* _tmp119_;
		const gchar* _tmp120_;
		const gchar* _tmp121_;
		_tmp118_ = builder;
		json_builder_set_member_name (_tmp118_, "streaming");
		_tmp119_ = builder;
		_tmp120_ = tuba_instance_account_get_tuba_streaming_url (_data56_->account);
		_tmp121_ = _tmp120_;
		json_builder_add_string_value (_tmp119_, _tmp121_);
	}
	_tmp122_ = builder;
	json_builder_set_member_name (_tmp122_, "emojis");
	_tmp123_ = builder;
	json_builder_begin_array (_tmp123_);
	_tmp125_ = tuba_api_account_get_emojis ((TubaAPIAccount*) _data56_->account);
	_tmp126_ = _tmp125_;
	if (_tmp126_ != NULL) {
		GeeArrayList* _tmp127_;
		GeeArrayList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		_tmp127_ = tuba_api_account_get_emojis ((TubaAPIAccount*) _data56_->account);
		_tmp128_ = _tmp127_;
		_tmp129_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		_tmp124_ = _tmp130_ > 0;
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		{
			GeeArrayList* _emoji_list = NULL;
			GeeArrayList* _tmp131_;
			GeeArrayList* _tmp132_;
			gint _emoji_size = 0;
			GeeArrayList* _tmp133_;
			gint _tmp134_;
			gint _tmp135_;
			gint _emoji_index = 0;
			_tmp131_ = tuba_api_account_get_emojis ((TubaAPIAccount*) _data56_->account);
			_tmp132_ = _tmp131_;
			_emoji_list = _tmp132_;
			_tmp133_ = _emoji_list;
			_tmp134_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp133_);
			_tmp135_ = _tmp134_;
			_emoji_size = _tmp135_;
			_emoji_index = -1;
			while (TRUE) {
				gint _tmp136_;
				gint _tmp137_;
				TubaAPIEmoji* emoji = NULL;
				GeeArrayList* _tmp138_;
				gpointer _tmp139_;
				JsonBuilder* _tmp140_;
				JsonBuilder* _tmp141_;
				JsonBuilder* _tmp142_;
				TubaAPIEmoji* _tmp143_;
				const gchar* _tmp144_;
				const gchar* _tmp145_;
				JsonBuilder* _tmp146_;
				JsonBuilder* _tmp147_;
				TubaAPIEmoji* _tmp148_;
				const gchar* _tmp149_;
				const gchar* _tmp150_;
				JsonBuilder* _tmp151_;
				_emoji_index = _emoji_index + 1;
				_tmp136_ = _emoji_index;
				_tmp137_ = _emoji_size;
				if (!(_tmp136_ < _tmp137_)) {
					break;
				}
				_tmp138_ = _emoji_list;
				_tmp139_ = gee_abstract_list_get ((GeeAbstractList*) _tmp138_, _emoji_index);
				emoji = (TubaAPIEmoji*) _tmp139_;
				_tmp140_ = builder;
				json_builder_begin_object (_tmp140_);
				_tmp141_ = builder;
				json_builder_set_member_name (_tmp141_, "shortcode");
				_tmp142_ = builder;
				_tmp143_ = emoji;
				_tmp144_ = tuba_api_emoji_get_shortcode (_tmp143_);
				_tmp145_ = _tmp144_;
				json_builder_add_string_value (_tmp142_, _tmp145_);
				_tmp146_ = builder;
				json_builder_set_member_name (_tmp146_, "url");
				_tmp147_ = builder;
				_tmp148_ = emoji;
				_tmp149_ = tuba_api_emoji_get_url (_tmp148_);
				_tmp150_ = _tmp149_;
				json_builder_add_string_value (_tmp147_, _tmp150_);
				_tmp151_ = builder;
				json_builder_end_object (_tmp151_);
				_g_object_unref0 (emoji);
			}
		}
	}
	_tmp152_ = builder;
	json_builder_end_array (_tmp152_);
	_tmp153_ = builder;
	json_builder_end_object (_tmp153_);
	_tmp154_ = generator;
	_tmp155_ = builder;
	_tmp156_ = json_builder_get_root (_tmp155_);
	_tmp157_ = _tmp156_;
	json_generator_set_root (_tmp154_, _tmp157_);
	__vala_JsonNode_free0 (_tmp157_);
	_tmp158_ = generator;
	_tmp159_ = json_generator_to_data (_tmp158_, NULL);
	secret = _tmp159_;
	_tmp162_ = tuba_instance_account_get_backend (_data56_->account);
	_tmp163_ = _tmp162_;
	if (_tmp163_ == NULL) {
		_tmp161_ = TRUE;
	} else {
		const gchar* _tmp164_;
		const gchar* _tmp165_;
		_tmp164_ = tuba_instance_account_get_backend (_data56_->account);
		_tmp165_ = _tmp164_;
		_tmp161_ = g_strcmp0 (_tmp165_, "") == 0;
	}
	if (_tmp161_) {
		gchar* _tmp166_;
		_tmp166_ = g_strdup ("Fediverse");
		_g_free0 (_tmp160_);
		_tmp160_ = _tmp166_;
	} else {
		const gchar* _tmp167_;
		const gchar* _tmp168_;
		gchar* _tmp169_;
		gchar* _tmp170_;
		gchar* _tmp171_;
		gchar* _tmp172_;
		const gchar* _tmp173_;
		const gchar* _tmp174_;
		const gchar* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		const gchar* _tmp178_;
		gchar* _tmp179_;
		_tmp167_ = tuba_instance_account_get_backend (_data56_->account);
		_tmp168_ = _tmp167_;
		_tmp169_ = g_strdup_printf ("%c", string_get (_tmp168_, (glong) 0));
		_tmp170_ = _tmp169_;
		_tmp171_ = g_utf8_strup (_tmp170_, (gssize) -1);
		_tmp172_ = _tmp171_;
		_tmp173_ = string_to_string (_tmp172_);
		_tmp174_ = tuba_instance_account_get_backend (_data56_->account);
		_tmp175_ = _tmp174_;
		_tmp176_ = string_substring (_tmp175_, (glong) 1, (glong) -1);
		_tmp177_ = _tmp176_;
		_tmp178_ = string_to_string (_tmp177_);
		_tmp179_ = g_strconcat (_tmp173_, _tmp178_, NULL);
		_g_free0 (_tmp160_);
		_tmp160_ = _tmp179_;
		_g_free0 (_tmp177_);
		_g_free0 (_tmp172_);
		_g_free0 (_tmp170_);
	}
	_tmp180_ = g_strdup_printf (_ ("%s Account"), _tmp160_);
	label = _tmp180_;
	_tmp181_ = self->priv->schema;
	_tmp182_ = attrs;
	_tmp183_ = _g_hash_table_ref0 (_tmp182_);
	_tmp184_ = secret;
	secret_password_storev (_tmp181_, _tmp183_, SECRET_COLLECTION_DEFAULT, label, _tmp184_, NULL, ___lambda361__gasync_ready_callback, block56_data_ref (_data56_));
	_g_free0 (label);
	_g_free0 (_tmp160_);
	_g_free0 (secret);
	_g_object_unref0 (builder);
	_g_object_unref0 (generator);
	_g_hash_table_unref0 (attrs);
	block56_data_unref (_data56_);
	_data56_ = NULL;
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

static TubaInstanceAccount*
tuba_secret_account_store_secret_to_account (TubaSecretAccountStore* self,
                                             SecretRetrievable* item)
{
	TubaInstanceAccount* account = NULL;
	GError* _inner_error0_ = NULL;
	TubaInstanceAccount* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	account = NULL;
	{
		SecretValue* secret = NULL;
		SecretValue* _tmp0_;
		gchar* contents = NULL;
		SecretValue* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		JsonParser* parser = NULL;
		JsonParser* _tmp4_;
		gboolean _tmp5_ = FALSE;
		JsonParser* _tmp6_;
		const gchar* _tmp7_;
		JsonNode* root = NULL;
		JsonParser* _tmp8_;
		JsonNode* _tmp9_;
		JsonNode* _tmp10_;
		gboolean _tmp11_ = FALSE;
		JsonNode* _tmp12_;
		JsonObject* root_obj = NULL;
		JsonNode* _tmp14_;
		JsonObject* _tmp15_;
		JsonObject* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		gboolean _tmp22_ = FALSE;
		JsonObject* _tmp23_;
		TubaInstanceAccount* _tmp30_ = NULL;
		TubaAccountStore* _tmp31_;
		JsonNode* _tmp32_;
		TubaInstanceAccount* _tmp33_;
		TubaInstanceAccount* _tmp34_;
		_tmp0_ = secret_retrievable_retrieve_secret_sync (item, NULL, &_inner_error0_);
		secret = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = secret;
		_tmp2_ = secret_value_get_text (_tmp1_);
		_tmp3_ = g_strdup (_tmp2_);
		contents = _tmp3_;
		_tmp4_ = json_parser_new ();
		parser = _tmp4_;
		_tmp6_ = parser;
		_tmp7_ = contents;
		_tmp5_ = json_parser_load_from_data (_tmp6_, _tmp7_, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			goto __catch0_g_error;
		}
		if (!_tmp5_) {
			result = NULL;
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			_g_object_unref0 (account);
			return result;
		}
		_tmp8_ = parser;
		_tmp9_ = json_parser_get_root (_tmp8_);
		_tmp10_ = __vala_JsonNode_copy0 (_tmp9_);
		root = _tmp10_;
		_tmp12_ = root;
		if (_tmp12_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			JsonNode* _tmp13_;
			_tmp13_ = root;
			_tmp11_ = json_node_get_node_type (_tmp13_) != JSON_NODE_OBJECT;
		}
		if (_tmp11_) {
			result = NULL;
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			_g_object_unref0 (account);
			return result;
		}
		_tmp14_ = root;
		_tmp15_ = json_node_get_object (_tmp14_);
		_tmp16_ = _json_object_ref0 (_tmp15_);
		root_obj = _tmp16_;
		_tmp23_ = root_obj;
		if (!json_object_has_member (_tmp23_, "backend")) {
			_tmp22_ = TRUE;
		} else {
			JsonObject* _tmp24_;
			_tmp24_ = root_obj;
			_tmp22_ = !json_object_has_member (_tmp24_, "acct");
		}
		if (_tmp22_) {
			_tmp21_ = TRUE;
		} else {
			JsonObject* _tmp25_;
			_tmp25_ = root_obj;
			_tmp21_ = !json_object_has_member (_tmp25_, "id");
		}
		if (_tmp21_) {
			_tmp20_ = TRUE;
		} else {
			JsonObject* _tmp26_;
			_tmp26_ = root_obj;
			_tmp20_ = !json_object_has_member (_tmp26_, "client-secret");
		}
		if (_tmp20_) {
			_tmp19_ = TRUE;
		} else {
			JsonObject* _tmp27_;
			_tmp27_ = root_obj;
			_tmp19_ = !json_object_has_member (_tmp27_, "client-id");
		}
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			JsonObject* _tmp28_;
			_tmp28_ = root_obj;
			_tmp18_ = !json_object_has_member (_tmp28_, "access-token");
		}
		if (_tmp18_) {
			_tmp17_ = TRUE;
		} else {
			JsonObject* _tmp29_;
			_tmp29_ = root_obj;
			_tmp17_ = !json_object_has_member (_tmp29_, "uuid");
		}
		if (_tmp17_) {
			result = NULL;
			_json_object_unref0 (root_obj);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			_g_object_unref0 (account);
			return result;
		}
		_tmp31_ = tuba_accounts;
		_tmp32_ = root;
		_tmp33_ = tuba_account_store_create_account (_tmp31_, _tmp32_, &_inner_error0_);
		_tmp30_ = _tmp33_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_json_object_unref0 (root_obj);
			__vala_JsonNode_free0 (root);
			_g_object_unref0 (parser);
			_g_free0 (contents);
			_secret_value_unref0 (secret);
			goto __catch0_g_error;
		}
		_tmp34_ = _tmp30_;
		_tmp30_ = NULL;
		_g_object_unref0 (account);
		account = _tmp34_;
		_g_object_unref0 (_tmp30_);
		_json_object_unref0 (root_obj);
		__vala_JsonNode_free0 (root);
		_g_object_unref0 (parser);
		_g_free0 (contents);
		_secret_value_unref0 (secret);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp35_;
		const gchar* _tmp36_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		g_warning ("SecretAccountStore.vala:302: %s", _tmp36_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (account);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = account;
	return result;
}

TubaSecretAccountStore*
tuba_secret_account_store_construct (GType object_type)
{
	TubaSecretAccountStore * self = NULL;
	self = (TubaSecretAccountStore*) tuba_account_store_construct (object_type);
	return self;
}

TubaSecretAccountStore*
tuba_secret_account_store_new (void)
{
	return tuba_secret_account_store_construct (TUBA_TYPE_SECRET_ACCOUNT_STORE);
}

static void
tuba_secret_account_store_class_init (TubaSecretAccountStoreClass * klass,
                                      gpointer klass_data)
{
	tuba_secret_account_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaSecretAccountStore_private_offset);
	((TubaAccountStoreClass *) klass)->init = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_init;
	((TubaAccountStoreClass *) klass)->load = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_load;
	((TubaAccountStoreClass *) klass)->save = (void (*) (TubaAccountStore*, GError**)) tuba_secret_account_store_real_save;
	((TubaAccountStoreClass *) klass)->update_account = (void (*) (TubaAccountStore*, TubaInstanceAccount*, GError**)) tuba_secret_account_store_real_update_account;
	((TubaAccountStoreClass *) klass)->remove = (void (*) (TubaAccountStore*, TubaInstanceAccount*, GError**)) tuba_secret_account_store_real_remove;
	G_OBJECT_CLASS (klass)->finalize = tuba_secret_account_store_finalize;
}

static void
tuba_secret_account_store_instance_init (TubaSecretAccountStore * self,
                                         gpointer klass)
{
	self->priv = tuba_secret_account_store_get_instance_private (self);
}

static void
tuba_secret_account_store_finalize (GObject * obj)
{
	TubaSecretAccountStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_TYPE_SECRET_ACCOUNT_STORE, TubaSecretAccountStore);
	_secret_schema_unref0 (self->priv->schema);
	_g_hash_table_unref0 (self->priv->schema_attributes);
	G_OBJECT_CLASS (tuba_secret_account_store_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_secret_account_store_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaSecretAccountStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_secret_account_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaSecretAccountStore), 0, (GInstanceInitFunc) tuba_secret_account_store_instance_init, NULL };
	GType tuba_secret_account_store_type_id;
	tuba_secret_account_store_type_id = g_type_register_static (TUBA_TYPE_ACCOUNT_STORE, "TubaSecretAccountStore", &g_define_type_info, 0);
	TubaSecretAccountStore_private_offset = g_type_add_instance_private (tuba_secret_account_store_type_id, sizeof (TubaSecretAccountStorePrivate));
	return tuba_secret_account_store_type_id;
}

GType
tuba_secret_account_store_get_type (void)
{
	static gsize tuba_secret_account_store_type_id__once = 0;
	if (g_once_init_enter (&tuba_secret_account_store_type_id__once)) {
		GType tuba_secret_account_store_type_id;
		tuba_secret_account_store_type_id = tuba_secret_account_store_get_type_once ();
		g_once_init_leave (&tuba_secret_account_store_type_id__once, tuba_secret_account_store_type_id);
	}
	return tuba_secret_account_store_type_id__once;
}

